// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon API Gateway
///
/// Client for invoking operations on Amazon API Gateway. Each operation on Amazon API Gateway is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_apigateway::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_apigateway::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_apigateway::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateApiKey`](crate::client::fluent_builders::CreateApiKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApiKey::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApiKey::set_name): <p>The name of the <code>ApiKey</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApiKey::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApiKey::set_description): <p>The description of the <code>ApiKey</code>.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::CreateApiKey::enabled) / [`set_enabled(bool)`](crate::client::fluent_builders::CreateApiKey::set_enabled): <p>Specifies whether the <code>ApiKey</code> can be used by callers.</p>
    ///   - [`generate_distinct_id(bool)`](crate::client::fluent_builders::CreateApiKey::generate_distinct_id) / [`set_generate_distinct_id(bool)`](crate::client::fluent_builders::CreateApiKey::set_generate_distinct_id): <p>Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.</p>
    ///   - [`value(impl Into<String>)`](crate::client::fluent_builders::CreateApiKey::value) / [`set_value(Option<String>)`](crate::client::fluent_builders::CreateApiKey::set_value): <p>Specifies a value of the API key.</p> <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
    ///   - [`stage_keys(Vec<StageKey>)`](crate::client::fluent_builders::CreateApiKey::stage_keys) / [`set_stage_keys(Option<Vec<StageKey>>)`](crate::client::fluent_builders::CreateApiKey::set_stage_keys): <p>DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.</p>
    ///   - [`customer_id(impl Into<String>)`](crate::client::fluent_builders::CreateApiKey::customer_id) / [`set_customer_id(Option<String>)`](crate::client::fluent_builders::CreateApiKey::set_customer_id): <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateApiKey::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateApiKey::set_tags): <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    /// - On success, responds with [`CreateApiKeyOutput`](crate::output::CreateApiKeyOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateApiKeyOutput::id): <p>The identifier of the API Key.</p>
    ///   - [`value(Option<String>)`](crate::output::CreateApiKeyOutput::value): <p>The value of the API Key.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateApiKeyOutput::name): <p>The name of the API Key.</p>
    ///   - [`customer_id(Option<String>)`](crate::output::CreateApiKeyOutput::customer_id): <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateApiKeyOutput::description): <p>The description of the API Key.</p>
    ///   - [`enabled(bool)`](crate::output::CreateApiKeyOutput::enabled): <p>Specifies whether the API Key can be used by callers.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateApiKeyOutput::created_date): <p>The timestamp when the API Key was created.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::CreateApiKeyOutput::last_updated_date): <p>The timestamp when the API Key was last updated.</p>
    ///   - [`stage_keys(Option<Vec<String>>)`](crate::output::CreateApiKeyOutput::stage_keys): <p>A list of <code>Stage</code> resources that are associated with the <code>ApiKey</code> resource.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateApiKeyOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<CreateApiKeyError>`](crate::error::CreateApiKeyError)
    pub fn create_api_key(&self) -> fluent_builders::CreateApiKey<C, M, R> {
        fluent_builders::CreateApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAuthorizer`](crate::client::fluent_builders::CreateAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_name): <p>[Required] The name of the authorizer.</p>
    ///   - [`r#type(AuthorizerType)`](crate::client::fluent_builders::CreateAuthorizer::r#type) / [`set_type(Option<AuthorizerType>)`](crate::client::fluent_builders::CreateAuthorizer::set_type): <p>[Required] The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
    ///   - [`provider_ar_ns(Vec<String>)`](crate::client::fluent_builders::CreateAuthorizer::provider_ar_ns) / [`set_provider_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateAuthorizer::set_provider_ar_ns): <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
    ///   - [`auth_type(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::auth_type) / [`set_auth_type(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_auth_type): <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
    ///   - [`authorizer_uri(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_uri) / [`set_authorizer_uri(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_uri): <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
    ///   - [`authorizer_credentials(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_credentials) / [`set_authorizer_credentials(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_credentials): <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
    ///   - [`identity_source(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::identity_source) / [`set_identity_source(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_identity_source): <p>The identity source for which authorization is requested. </p> <ul>  <li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li>  <li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li> </ul> <p></p>
    ///   - [`identity_validation_expression(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::identity_validation_expression) / [`set_identity_validation_expression(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_identity_validation_expression): <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
    ///   - [`authorizer_result_ttl_in_seconds(i32)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_result_ttl_in_seconds) / [`set_authorizer_result_ttl_in_seconds(Option<i32>)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_result_ttl_in_seconds): <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
    /// - On success, responds with [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateAuthorizerOutput::id): <p>The identifier for the authorizer resource.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateAuthorizerOutput::name): <p>[Required] The name of the authorizer.</p>
    ///   - [`r#type(Option<AuthorizerType>)`](crate::output::CreateAuthorizerOutput::type): <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
    ///   - [`provider_ar_ns(Option<Vec<String>>)`](crate::output::CreateAuthorizerOutput::provider_ar_ns): <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
    ///   - [`auth_type(Option<String>)`](crate::output::CreateAuthorizerOutput::auth_type): <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
    ///   - [`authorizer_uri(Option<String>)`](crate::output::CreateAuthorizerOutput::authorizer_uri): <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
    ///   - [`authorizer_credentials(Option<String>)`](crate::output::CreateAuthorizerOutput::authorizer_credentials): <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
    ///   - [`identity_source(Option<String>)`](crate::output::CreateAuthorizerOutput::identity_source): <p>The identity source for which authorization is requested. </p> <ul>  <li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li>  <li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li> </ul> <p></p>
    ///   - [`identity_validation_expression(Option<String>)`](crate::output::CreateAuthorizerOutput::identity_validation_expression): <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
    ///   - [`authorizer_result_ttl_in_seconds(Option<i32>)`](crate::output::CreateAuthorizerOutput::authorizer_result_ttl_in_seconds): <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
    /// - On failure, responds with [`SdkError<CreateAuthorizerError>`](crate::error::CreateAuthorizerError)
    pub fn create_authorizer(&self) -> fluent_builders::CreateAuthorizer<C, M, R> {
        fluent_builders::CreateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBasePathMapping`](crate::client::fluent_builders::CreateBasePathMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateBasePathMapping::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateBasePathMapping::set_domain_name): <p>[Required] The domain name of the <code>BasePathMapping</code> resource to create.</p>
    ///   - [`base_path(impl Into<String>)`](crate::client::fluent_builders::CreateBasePathMapping::base_path) / [`set_base_path(Option<String>)`](crate::client::fluent_builders::CreateBasePathMapping::set_base_path): <p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.</p>
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::CreateBasePathMapping::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::CreateBasePathMapping::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage(impl Into<String>)`](crate::client::fluent_builders::CreateBasePathMapping::stage) / [`set_stage(Option<String>)`](crate::client::fluent_builders::CreateBasePathMapping::set_stage): <p>The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.</p>
    /// - On success, responds with [`CreateBasePathMappingOutput`](crate::output::CreateBasePathMappingOutput) with field(s):
    ///   - [`base_path(Option<String>)`](crate::output::CreateBasePathMappingOutput::base_path): <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
    ///   - [`rest_api_id(Option<String>)`](crate::output::CreateBasePathMappingOutput::rest_api_id): <p>The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage(Option<String>)`](crate::output::CreateBasePathMappingOutput::stage): <p>The name of the associated stage.</p>
    /// - On failure, responds with [`SdkError<CreateBasePathMappingError>`](crate::error::CreateBasePathMappingError)
    pub fn create_base_path_mapping(&self) -> fluent_builders::CreateBasePathMapping<C, M, R> {
        fluent_builders::CreateBasePathMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_stage_name): <p>The name of the <code>Stage</code> resource for the <code>Deployment</code> resource to create.</p>
    ///   - [`stage_description(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::stage_description) / [`set_stage_description(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_stage_description): <p>The description of the <code>Stage</code> resource for the <code>Deployment</code> resource to create.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_description): <p>The description for the <code>Deployment</code> resource to create.</p>
    ///   - [`cache_cluster_enabled(bool)`](crate::client::fluent_builders::CreateDeployment::cache_cluster_enabled) / [`set_cache_cluster_enabled(Option<bool>)`](crate::client::fluent_builders::CreateDeployment::set_cache_cluster_enabled): <p>Enables a cache cluster for the <code>Stage</code> resource specified in the input.</p>
    ///   - [`cache_cluster_size(CacheClusterSize)`](crate::client::fluent_builders::CreateDeployment::cache_cluster_size) / [`set_cache_cluster_size(Option<CacheClusterSize>)`](crate::client::fluent_builders::CreateDeployment::set_cache_cluster_size): <p>Specifies the cache cluster size for the <code>Stage</code> resource specified in the input, if a cache cluster is enabled.</p>
    ///   - [`variables(HashMap<String, String>)`](crate::client::fluent_builders::CreateDeployment::variables) / [`set_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDeployment::set_variables): <p>A map that defines the stage variables for the <code>Stage</code> resource that is associated with the new deployment. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>
    ///   - [`canary_settings(DeploymentCanarySettings)`](crate::client::fluent_builders::CreateDeployment::canary_settings) / [`set_canary_settings(Option<DeploymentCanarySettings>)`](crate::client::fluent_builders::CreateDeployment::set_canary_settings): <p>The input configuration for the canary deployment when the deployment is a canary release deployment. </p>
    ///   - [`tracing_enabled(bool)`](crate::client::fluent_builders::CreateDeployment::tracing_enabled) / [`set_tracing_enabled(Option<bool>)`](crate::client::fluent_builders::CreateDeployment::set_tracing_enabled): <p>Specifies whether active tracing with X-ray is enabled for the <code>Stage</code>.</p>
    /// - On success, responds with [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateDeploymentOutput::id): <p>The identifier for the deployment resource.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateDeploymentOutput::description): <p>The description for the deployment resource.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateDeploymentOutput::created_date): <p>The date and time that the deployment resource was created.</p>
    ///   - [`api_summary(Option<HashMap<String, HashMap<String, MethodSnapshot>>>)`](crate::output::CreateDeploymentOutput::api_summary): <p>A summary of the <code>RestApi</code> at the date and time that the deployment resource was created.</p>
    /// - On failure, responds with [`SdkError<CreateDeploymentError>`](crate::error::CreateDeploymentError)
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment<C, M, R> {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDocumentationPart`](crate::client::fluent_builders::CreateDocumentationPart) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentationPart::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::CreateDocumentationPart::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`location(DocumentationPartLocation)`](crate::client::fluent_builders::CreateDocumentationPart::location) / [`set_location(Option<DocumentationPartLocation>)`](crate::client::fluent_builders::CreateDocumentationPart::set_location): <p>[Required] The location of the targeted API entity of the to-be-created documentation part.</p>
    ///   - [`properties(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentationPart::properties) / [`set_properties(Option<String>)`](crate::client::fluent_builders::CreateDocumentationPart::set_properties): <p>[Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.</p>
    /// - On success, responds with [`CreateDocumentationPartOutput`](crate::output::CreateDocumentationPartOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateDocumentationPartOutput::id): <p>The <code>DocumentationPart</code> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
    ///   - [`location(Option<DocumentationPartLocation>)`](crate::output::CreateDocumentationPartOutput::location): <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
    ///   - [`properties(Option<String>)`](crate::output::CreateDocumentationPartOutput::properties): <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant documentation-related fields from the <literal>   properties  </literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
    /// - On failure, responds with [`SdkError<CreateDocumentationPartError>`](crate::error::CreateDocumentationPartError)
    pub fn create_documentation_part(&self) -> fluent_builders::CreateDocumentationPart<C, M, R> {
        fluent_builders::CreateDocumentationPart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDocumentationVersion`](crate::client::fluent_builders::CreateDocumentationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentationVersion::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::CreateDocumentationVersion::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`documentation_version(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentationVersion::documentation_version) / [`set_documentation_version(Option<String>)`](crate::client::fluent_builders::CreateDocumentationVersion::set_documentation_version): <p>[Required] The version identifier of the new snapshot.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentationVersion::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::CreateDocumentationVersion::set_stage_name): <p>The stage name to be associated with the new documentation snapshot.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentationVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDocumentationVersion::set_description): <p>A description about the new documentation snapshot.</p>
    /// - On success, responds with [`CreateDocumentationVersionOutput`](crate::output::CreateDocumentationVersionOutput) with field(s):
    ///   - [`version(Option<String>)`](crate::output::CreateDocumentationVersionOutput::version): <p>The version identifier of the API documentation snapshot.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateDocumentationVersionOutput::created_date): <p>The date when the API documentation snapshot is created.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateDocumentationVersionOutput::description): <p>The description of the API documentation snapshot.</p>
    /// - On failure, responds with [`SdkError<CreateDocumentationVersionError>`](crate::error::CreateDocumentationVersionError)
    pub fn create_documentation_version(
        &self,
    ) -> fluent_builders::CreateDocumentationVersion<C, M, R> {
        fluent_builders::CreateDocumentationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDomainName`](crate::client::fluent_builders::CreateDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_domain_name): <p>[Required] The name of the <code>DomainName</code> resource.</p>
    ///   - [`certificate_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::certificate_name) / [`set_certificate_name(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_certificate_name): <p>The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    ///   - [`certificate_body(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::certificate_body) / [`set_certificate_body(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_certificate_body): <p>[Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.</p>
    ///   - [`certificate_private_key(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::certificate_private_key) / [`set_certificate_private_key(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_certificate_private_key): <p>[Deprecated] Your edge-optimized endpoint's domain name certificate's private key.</p>
    ///   - [`certificate_chain(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::certificate_chain) / [`set_certificate_chain(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_certificate_chain): <p>[Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.</p>
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_certificate_arn): <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    ///   - [`regional_certificate_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::regional_certificate_name) / [`set_regional_certificate_name(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_regional_certificate_name): <p>The user-friendly name of the certificate that will be used by regional endpoint for this domain name.</p>
    ///   - [`regional_certificate_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::regional_certificate_arn) / [`set_regional_certificate_arn(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_regional_certificate_arn): <p>The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    ///   - [`endpoint_configuration(EndpointConfiguration)`](crate::client::fluent_builders::CreateDomainName::endpoint_configuration) / [`set_endpoint_configuration(Option<EndpointConfiguration>)`](crate::client::fluent_builders::CreateDomainName::set_endpoint_configuration): <p>The endpoint configuration of this <code>DomainName</code> showing the endpoint types of the domain name.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDomainName::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDomainName::set_tags): <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    ///   - [`security_policy(SecurityPolicy)`](crate::client::fluent_builders::CreateDomainName::security_policy) / [`set_security_policy(Option<SecurityPolicy>)`](crate::client::fluent_builders::CreateDomainName::set_security_policy): <p>The Transport Layer Security (TLS) version + cipher suite for this <code>DomainName</code>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    ///   - [`mutual_tls_authentication(MutualTlsAuthenticationInput)`](crate::client::fluent_builders::CreateDomainName::mutual_tls_authentication) / [`set_mutual_tls_authentication(Option<MutualTlsAuthenticationInput>)`](crate::client::fluent_builders::CreateDomainName::set_mutual_tls_authentication): <p>If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.</p>
    ///   - [`ownership_verification_certificate_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::ownership_verification_certificate_arn) / [`set_ownership_verification_certificate_arn(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_ownership_verification_certificate_arn): <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    /// - On success, responds with [`CreateDomainNameOutput`](crate::output::CreateDomainNameOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::CreateDomainNameOutput::domain_name): <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
    ///   - [`certificate_name(Option<String>)`](crate::output::CreateDomainNameOutput::certificate_name): <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    ///   - [`certificate_arn(Option<String>)`](crate::output::CreateDomainNameOutput::certificate_arn): <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    ///   - [`certificate_upload_date(Option<DateTime>)`](crate::output::CreateDomainNameOutput::certificate_upload_date): <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    ///   - [`regional_domain_name(Option<String>)`](crate::output::CreateDomainNameOutput::regional_domain_name): <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
    ///   - [`regional_hosted_zone_id(Option<String>)`](crate::output::CreateDomainNameOutput::regional_hosted_zone_id): <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    ///   - [`regional_certificate_name(Option<String>)`](crate::output::CreateDomainNameOutput::regional_certificate_name): <p>The name of the certificate that will be used for validating the regional domain name.</p>
    ///   - [`regional_certificate_arn(Option<String>)`](crate::output::CreateDomainNameOutput::regional_certificate_arn): <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
    ///   - [`distribution_domain_name(Option<String>)`](crate::output::CreateDomainNameOutput::distribution_domain_name): <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
    ///   - [`distribution_hosted_zone_id(Option<String>)`](crate::output::CreateDomainNameOutput::distribution_hosted_zone_id): <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    ///   - [`endpoint_configuration(Option<EndpointConfiguration>)`](crate::output::CreateDomainNameOutput::endpoint_configuration): <p>The endpoint configuration of this <code>DomainName</code> showing the endpoint types of the domain name.</p>
    ///   - [`domain_name_status(Option<DomainNameStatus>)`](crate::output::CreateDomainNameOutput::domain_name_status): <p>The status of the <code>DomainName</code> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
    ///   - [`domain_name_status_message(Option<String>)`](crate::output::CreateDomainNameOutput::domain_name_status_message): <p>An optional text message containing detailed information about status of the <code>DomainName</code> migration.</p>
    ///   - [`security_policy(Option<SecurityPolicy>)`](crate::output::CreateDomainNameOutput::security_policy): <p>The Transport Layer Security (TLS) version + cipher suite for this <code>DomainName</code>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateDomainNameOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`mutual_tls_authentication(Option<MutualTlsAuthentication>)`](crate::output::CreateDomainNameOutput::mutual_tls_authentication): <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
    ///   - [`ownership_verification_certificate_arn(Option<String>)`](crate::output::CreateDomainNameOutput::ownership_verification_certificate_arn): <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    /// - On failure, responds with [`SdkError<CreateDomainNameError>`](crate::error::CreateDomainNameError)
    pub fn create_domain_name(&self) -> fluent_builders::CreateDomainName<C, M, R> {
        fluent_builders::CreateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateModel`](crate::client::fluent_builders::CreateModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::CreateModel::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::CreateModel::set_rest_api_id): <p>[Required] The <code>RestApi</code> identifier under which the <code>Model</code> will be created.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateModel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateModel::set_name): <p>[Required] The name of the model. Must be alphanumeric.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateModel::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateModel::set_description): <p>The description of the model.</p>
    ///   - [`schema(impl Into<String>)`](crate::client::fluent_builders::CreateModel::schema) / [`set_schema(Option<String>)`](crate::client::fluent_builders::CreateModel::set_schema): <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::CreateModel::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::CreateModel::set_content_type): <p>[Required] The content-type for the model.</p>
    /// - On success, responds with [`CreateModelOutput`](crate::output::CreateModelOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateModelOutput::id): <p>The identifier for the model resource.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateModelOutput::name): <p>The name of the model. Must be an alphanumeric string.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateModelOutput::description): <p>The description of the model.</p>
    ///   - [`schema(Option<String>)`](crate::output::CreateModelOutput::schema): <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
    ///   - [`content_type(Option<String>)`](crate::output::CreateModelOutput::content_type): <p>The content-type for the model.</p>
    /// - On failure, responds with [`SdkError<CreateModelError>`](crate::error::CreateModelError)
    pub fn create_model(&self) -> fluent_builders::CreateModel<C, M, R> {
        fluent_builders::CreateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRequestValidator`](crate::client::fluent_builders::CreateRequestValidator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::CreateRequestValidator::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::CreateRequestValidator::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRequestValidator::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRequestValidator::set_name): <p>The name of the to-be-created <code>RequestValidator</code>.</p>
    ///   - [`validate_request_body(bool)`](crate::client::fluent_builders::CreateRequestValidator::validate_request_body) / [`set_validate_request_body(bool)`](crate::client::fluent_builders::CreateRequestValidator::set_validate_request_body): <p>A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).</p>
    ///   - [`validate_request_parameters(bool)`](crate::client::fluent_builders::CreateRequestValidator::validate_request_parameters) / [`set_validate_request_parameters(bool)`](crate::client::fluent_builders::CreateRequestValidator::set_validate_request_parameters): <p>A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.</p>
    /// - On success, responds with [`CreateRequestValidatorOutput`](crate::output::CreateRequestValidatorOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateRequestValidatorOutput::id): <p>The identifier of this <code>RequestValidator</code>.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateRequestValidatorOutput::name): <p>The name of this <code>RequestValidator</code></p>
    ///   - [`validate_request_body(bool)`](crate::output::CreateRequestValidatorOutput::validate_request_body): <p>A Boolean flag to indicate whether to validate a request body according to the configured <code>Model</code> schema.</p>
    ///   - [`validate_request_parameters(bool)`](crate::output::CreateRequestValidatorOutput::validate_request_parameters): <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
    /// - On failure, responds with [`SdkError<CreateRequestValidatorError>`](crate::error::CreateRequestValidatorError)
    pub fn create_request_validator(&self) -> fluent_builders::CreateRequestValidator<C, M, R> {
        fluent_builders::CreateRequestValidator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResource`](crate::client::fluent_builders::CreateResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::CreateResource::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::CreateResource::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`parent_id(impl Into<String>)`](crate::client::fluent_builders::CreateResource::parent_id) / [`set_parent_id(Option<String>)`](crate::client::fluent_builders::CreateResource::set_parent_id): <p>[Required] The parent resource's identifier.</p>
    ///   - [`path_part(impl Into<String>)`](crate::client::fluent_builders::CreateResource::path_part) / [`set_path_part(Option<String>)`](crate::client::fluent_builders::CreateResource::set_path_part): <p>The last path segment for this resource.</p>
    /// - On success, responds with [`CreateResourceOutput`](crate::output::CreateResourceOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateResourceOutput::id): <p>The resource's identifier.</p>
    ///   - [`parent_id(Option<String>)`](crate::output::CreateResourceOutput::parent_id): <p>The parent resource's identifier.</p>
    ///   - [`path_part(Option<String>)`](crate::output::CreateResourceOutput::path_part): <p>The last path segment for this resource.</p>
    ///   - [`path(Option<String>)`](crate::output::CreateResourceOutput::path): <p>The full path for this resource.</p>
    ///   - [`resource_methods(Option<HashMap<String, Method>>)`](crate::output::CreateResourceOutput::resource_methods): <p>Gets an API resource's method of a given HTTP verb.</p>  <div class="remarks">   <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>   <h4>Example: Get the GET method of an API resource</h4>   <h5>Request</h5>   <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20170223T031827Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>   <h5>Response</h5>   <pre><code>{   "_links": {     "curies": [       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",         "name": "integration",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",         "name": "integrationresponse",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",         "name": "method",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",         "name": "methodresponse",         "templated": true       }     ],     "self": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",       "name": "GET",       "title": "GET"     },     "integration:put": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"     },     "method:delete": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"     },     "method:integration": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"     },     "method:responses": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",       "name": "200",       "title": "200"     },     "method:update": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"     },     "methodresponse:put": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",       "templated": true     }   },   "apiKeyRequired": false,   "authorizationType": "NONE",   "httpMethod": "GET",   "_embedded": {     "method:integration": {       "_links": {         "self": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"         },         "integration:delete": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"         },         "integration:responses": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",           "name": "200",           "title": "200"         },         "integration:update": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"         },         "integrationresponse:put": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",           "templated": true         }       },       "cacheKeyParameters": [],       "cacheNamespace": "3kzxbg5sa2",       "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",       "httpMethod": "POST",       "passthroughBehavior": "WHEN_NO_MATCH",       "requestParameters": {         "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"       },       "requestTemplates": {         "application/json": "{\n}"       },       "type": "AWS",       "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",       "_embedded": {         "integration:responses": {           "_links": {             "self": {               "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",               "name": "200",               "title": "200"             },             "integrationresponse:delete": {               "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"             },             "integrationresponse:update": {               "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"             }           },           "responseParameters": {             "method.response.header.Content-Type": "'application/xml'"           },           "responseTemplates": {             "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"           },           "statusCode": "200"         }       }     },     "method:responses": {       "_links": {         "self": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",           "name": "200",           "title": "200"         },         "methodresponse:delete": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"         },         "methodresponse:update": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"         }       },       "responseModels": {         "application/json": "Empty"       },       "responseParameters": {         "method.response.header.Content-Type": false       },       "statusCode": "200"     }   } }</code></pre>   <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>  </div>  <div class="seeAlso">  </div>
    /// - On failure, responds with [`SdkError<CreateResourceError>`](crate::error::CreateResourceError)
    pub fn create_resource(&self) -> fluent_builders::CreateResource<C, M, R> {
        fluent_builders::CreateResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRestApi`](crate::client::fluent_builders::CreateRestApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRestApi::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRestApi::set_name): <p>[Required] The name of the <code>RestApi</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRestApi::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRestApi::set_description): <p>The description of the <code>RestApi</code>.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::CreateRestApi::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::CreateRestApi::set_version): <p>A version identifier for the API.</p>
    ///   - [`clone_from(impl Into<String>)`](crate::client::fluent_builders::CreateRestApi::clone_from) / [`set_clone_from(Option<String>)`](crate::client::fluent_builders::CreateRestApi::set_clone_from): <p>The ID of the <code>RestApi</code> that you want to clone from.</p>
    ///   - [`binary_media_types(Vec<String>)`](crate::client::fluent_builders::CreateRestApi::binary_media_types) / [`set_binary_media_types(Option<Vec<String>>)`](crate::client::fluent_builders::CreateRestApi::set_binary_media_types): <p>The list of binary media types supported by the <code>RestApi</code>. By default, the <code>RestApi</code> supports only UTF-8-encoded text payloads.</p>
    ///   - [`minimum_compression_size(i32)`](crate::client::fluent_builders::CreateRestApi::minimum_compression_size) / [`set_minimum_compression_size(Option<i32>)`](crate::client::fluent_builders::CreateRestApi::set_minimum_compression_size): <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    ///   - [`api_key_source(ApiKeySourceType)`](crate::client::fluent_builders::CreateRestApi::api_key_source) / [`set_api_key_source(Option<ApiKeySourceType>)`](crate::client::fluent_builders::CreateRestApi::set_api_key_source): <p>The source of the API key for metering requests according to a usage plan. Valid values are: </p> <ul>  <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li>  <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li> </ul> <p></p>
    ///   - [`endpoint_configuration(EndpointConfiguration)`](crate::client::fluent_builders::CreateRestApi::endpoint_configuration) / [`set_endpoint_configuration(Option<EndpointConfiguration>)`](crate::client::fluent_builders::CreateRestApi::set_endpoint_configuration): <p>The endpoint configuration of this <code>RestApi</code> showing the endpoint types of the API.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::CreateRestApi::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::CreateRestApi::set_policy): A stringified JSON policy document that applies to this RestApi regardless of the caller and <code>Method</code> configuration.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRestApi::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRestApi::set_tags): <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::client::fluent_builders::CreateRestApi::disable_execute_api_endpoint) / [`set_disable_execute_api_endpoint(bool)`](crate::client::fluent_builders::CreateRestApi::set_disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    /// - On success, responds with [`CreateRestApiOutput`](crate::output::CreateRestApiOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateRestApiOutput::id): <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateRestApiOutput::name): <p>The API's name.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateRestApiOutput::description): <p>The API's description.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateRestApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateRestApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::CreateRestApiOutput::warnings): <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    ///   - [`binary_media_types(Option<Vec<String>>)`](crate::output::CreateRestApiOutput::binary_media_types): <p>The list of binary media types supported by the <code>RestApi</code>. By default, the <code>RestApi</code> supports only UTF-8-encoded text payloads.</p>
    ///   - [`minimum_compression_size(Option<i32>)`](crate::output::CreateRestApiOutput::minimum_compression_size): <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    ///   - [`api_key_source(Option<ApiKeySourceType>)`](crate::output::CreateRestApiOutput::api_key_source): <p>The source of the API key for metering requests according to a usage plan. Valid values are: </p> <ul>  <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li>  <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li> </ul> <p></p>
    ///   - [`endpoint_configuration(Option<EndpointConfiguration>)`](crate::output::CreateRestApiOutput::endpoint_configuration): <p>The endpoint configuration of this <code>RestApi</code> showing the endpoint types of the API.</p>
    ///   - [`policy(Option<String>)`](crate::output::CreateRestApiOutput::policy): <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <code>Method</code> configuration.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateRestApiOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::CreateRestApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    /// - On failure, responds with [`SdkError<CreateRestApiError>`](crate::error::CreateRestApiError)
    pub fn create_rest_api(&self) -> fluent_builders::CreateRestApi<C, M, R> {
        fluent_builders::CreateRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStage`](crate::client::fluent_builders::CreateStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::CreateStage::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::CreateStage::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::CreateStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::CreateStage::set_stage_name): <p>[Required] The name for the <code>Stage</code> resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::CreateStage::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::CreateStage::set_deployment_id): <p>[Required] The identifier of the <code>Deployment</code> resource for the <code>Stage</code> resource.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateStage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateStage::set_description): <p>The description of the <code>Stage</code> resource.</p>
    ///   - [`cache_cluster_enabled(bool)`](crate::client::fluent_builders::CreateStage::cache_cluster_enabled) / [`set_cache_cluster_enabled(bool)`](crate::client::fluent_builders::CreateStage::set_cache_cluster_enabled): <p>Whether cache clustering is enabled for the stage.</p>
    ///   - [`cache_cluster_size(CacheClusterSize)`](crate::client::fluent_builders::CreateStage::cache_cluster_size) / [`set_cache_cluster_size(Option<CacheClusterSize>)`](crate::client::fluent_builders::CreateStage::set_cache_cluster_size): <p>The stage's cache cluster size.</p>
    ///   - [`variables(HashMap<String, String>)`](crate::client::fluent_builders::CreateStage::variables) / [`set_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStage::set_variables): <p>A map that defines the stage variables for the new <code>Stage</code> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>
    ///   - [`documentation_version(impl Into<String>)`](crate::client::fluent_builders::CreateStage::documentation_version) / [`set_documentation_version(Option<String>)`](crate::client::fluent_builders::CreateStage::set_documentation_version): <p>The version of the associated API documentation.</p>
    ///   - [`canary_settings(CanarySettings)`](crate::client::fluent_builders::CreateStage::canary_settings) / [`set_canary_settings(Option<CanarySettings>)`](crate::client::fluent_builders::CreateStage::set_canary_settings): <p>The canary deployment settings of this stage.</p>
    ///   - [`tracing_enabled(bool)`](crate::client::fluent_builders::CreateStage::tracing_enabled) / [`set_tracing_enabled(bool)`](crate::client::fluent_builders::CreateStage::set_tracing_enabled): <p>Specifies whether active tracing with X-ray is enabled for the <code>Stage</code>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStage::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStage::set_tags): <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    /// - On success, responds with [`CreateStageOutput`](crate::output::CreateStageOutput) with field(s):
    ///   - [`deployment_id(Option<String>)`](crate::output::CreateStageOutput::deployment_id): <p>The identifier of the <code>Deployment</code> that the stage points to.</p>
    ///   - [`client_certificate_id(Option<String>)`](crate::output::CreateStageOutput::client_certificate_id): <p>The identifier of a client certificate for an API stage.</p>
    ///   - [`stage_name(Option<String>)`](crate::output::CreateStageOutput::stage_name): <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateStageOutput::description): <p>The stage's description.</p>
    ///   - [`cache_cluster_enabled(bool)`](crate::output::CreateStageOutput::cache_cluster_enabled): <p>Specifies whether a cache cluster is enabled for the stage.</p>
    ///   - [`cache_cluster_size(Option<CacheClusterSize>)`](crate::output::CreateStageOutput::cache_cluster_size): <p>The size of the cache cluster for the stage, if enabled.</p>
    ///   - [`cache_cluster_status(Option<CacheClusterStatus>)`](crate::output::CreateStageOutput::cache_cluster_status): <p>The status of the cache cluster for the stage, if enabled.</p>
    ///   - [`method_settings(Option<HashMap<String, MethodSetting>>)`](crate::output::CreateStageOutput::method_settings): <p>A map that defines the method settings for a <code>Stage</code> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage. <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
    ///   - [`variables(Option<HashMap<String, String>>)`](crate::output::CreateStageOutput::variables): <p>A map that defines the stage variables for a <code>Stage</code> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>
    ///   - [`documentation_version(Option<String>)`](crate::output::CreateStageOutput::documentation_version): <p>The version of the associated API documentation.</p>
    ///   - [`access_log_settings(Option<AccessLogSettings>)`](crate::output::CreateStageOutput::access_log_settings): <p>Settings for logging access in this stage.</p>
    ///   - [`canary_settings(Option<CanarySettings>)`](crate::output::CreateStageOutput::canary_settings): <p>Settings for the canary deployment in this stage.</p>
    ///   - [`tracing_enabled(bool)`](crate::output::CreateStageOutput::tracing_enabled): <p>Specifies whether active tracing with X-ray is enabled for the <code>Stage</code>.</p>
    ///   - [`web_acl_arn(Option<String>)`](crate::output::CreateStageOutput::web_acl_arn): <p>The ARN of the WebAcl associated with the <code>Stage</code>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateStageOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateStageOutput::created_date): <p>The timestamp when the stage was created.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::CreateStageOutput::last_updated_date): <p>The timestamp when the stage last updated.</p>
    /// - On failure, responds with [`SdkError<CreateStageError>`](crate::error::CreateStageError)
    pub fn create_stage(&self) -> fluent_builders::CreateStage<C, M, R> {
        fluent_builders::CreateStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUsagePlan`](crate::client::fluent_builders::CreateUsagePlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateUsagePlan::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateUsagePlan::set_name): <p>[Required] The name of the usage plan.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateUsagePlan::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateUsagePlan::set_description): <p>The description of the usage plan.</p>
    ///   - [`api_stages(Vec<ApiStage>)`](crate::client::fluent_builders::CreateUsagePlan::api_stages) / [`set_api_stages(Option<Vec<ApiStage>>)`](crate::client::fluent_builders::CreateUsagePlan::set_api_stages): <p>The associated API stages of the usage plan.</p>
    ///   - [`throttle(ThrottleSettings)`](crate::client::fluent_builders::CreateUsagePlan::throttle) / [`set_throttle(Option<ThrottleSettings>)`](crate::client::fluent_builders::CreateUsagePlan::set_throttle): <p>The throttling limits of the usage plan.</p>
    ///   - [`quota(QuotaSettings)`](crate::client::fluent_builders::CreateUsagePlan::quota) / [`set_quota(Option<QuotaSettings>)`](crate::client::fluent_builders::CreateUsagePlan::set_quota): <p>The quota of the usage plan.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateUsagePlan::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateUsagePlan::set_tags): <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    /// - On success, responds with [`CreateUsagePlanOutput`](crate::output::CreateUsagePlanOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateUsagePlanOutput::id): <p>The identifier of a <code>UsagePlan</code> resource.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateUsagePlanOutput::name): <p>The name of a usage plan.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateUsagePlanOutput::description): <p>The description of a usage plan.</p>
    ///   - [`api_stages(Option<Vec<ApiStage>>)`](crate::output::CreateUsagePlanOutput::api_stages): <p>The associated API stages of a usage plan.</p>
    ///   - [`throttle(Option<ThrottleSettings>)`](crate::output::CreateUsagePlanOutput::throttle): <p>Map containing method level throttling information for API stage in a usage plan.</p>
    ///   - [`quota(Option<QuotaSettings>)`](crate::output::CreateUsagePlanOutput::quota): <p>The target maximum number of permitted requests per a given unit time interval.</p>
    ///   - [`product_code(Option<String>)`](crate::output::CreateUsagePlanOutput::product_code): <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateUsagePlanOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<CreateUsagePlanError>`](crate::error::CreateUsagePlanError)
    pub fn create_usage_plan(&self) -> fluent_builders::CreateUsagePlan<C, M, R> {
        fluent_builders::CreateUsagePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUsagePlanKey`](crate::client::fluent_builders::CreateUsagePlanKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_plan_id(impl Into<String>)`](crate::client::fluent_builders::CreateUsagePlanKey::usage_plan_id) / [`set_usage_plan_id(Option<String>)`](crate::client::fluent_builders::CreateUsagePlanKey::set_usage_plan_id): <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-created <code>UsagePlanKey</code> resource representing a plan customer.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::CreateUsagePlanKey::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::CreateUsagePlanKey::set_key_id): <p>[Required] The identifier of a <code>UsagePlanKey</code> resource for a plan customer.</p>
    ///   - [`key_type(impl Into<String>)`](crate::client::fluent_builders::CreateUsagePlanKey::key_type) / [`set_key_type(Option<String>)`](crate::client::fluent_builders::CreateUsagePlanKey::set_key_type): <p>[Required] The type of a <code>UsagePlanKey</code> resource for a plan customer.</p>
    /// - On success, responds with [`CreateUsagePlanKeyOutput`](crate::output::CreateUsagePlanKeyOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateUsagePlanKeyOutput::id): <p>The Id of a usage plan key.</p>
    ///   - [`r#type(Option<String>)`](crate::output::CreateUsagePlanKeyOutput::type): <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
    ///   - [`value(Option<String>)`](crate::output::CreateUsagePlanKeyOutput::value): <p>The value of a usage plan key.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateUsagePlanKeyOutput::name): <p>The name of a usage plan key.</p>
    /// - On failure, responds with [`SdkError<CreateUsagePlanKeyError>`](crate::error::CreateUsagePlanKeyError)
    pub fn create_usage_plan_key(&self) -> fluent_builders::CreateUsagePlanKey<C, M, R> {
        fluent_builders::CreateUsagePlanKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpcLink`](crate::client::fluent_builders::CreateVpcLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateVpcLink::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateVpcLink::set_name): <p>[Required] The name used to label and identify the VPC link.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateVpcLink::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateVpcLink::set_description): <p>The description of the VPC link.</p>
    ///   - [`target_arns(Vec<String>)`](crate::client::fluent_builders::CreateVpcLink::target_arns) / [`set_target_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcLink::set_target_arns): <p>[Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateVpcLink::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateVpcLink::set_tags): <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    /// - On success, responds with [`CreateVpcLinkOutput`](crate::output::CreateVpcLinkOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateVpcLinkOutput::id): <p>The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateVpcLinkOutput::name): <p>The name used to label and identify the VPC link.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateVpcLinkOutput::description): <p>The description of the VPC link.</p>
    ///   - [`target_arns(Option<Vec<String>>)`](crate::output::CreateVpcLinkOutput::target_arns): <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    ///   - [`status(Option<VpcLinkStatus>)`](crate::output::CreateVpcLinkOutput::status): <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
    ///   - [`status_message(Option<String>)`](crate::output::CreateVpcLinkOutput::status_message): <p>A description about the VPC link status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateVpcLinkOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<CreateVpcLinkError>`](crate::error::CreateVpcLinkError)
    pub fn create_vpc_link(&self) -> fluent_builders::CreateVpcLink<C, M, R> {
        fluent_builders::CreateVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApiKey`](crate::client::fluent_builders::DeleteApiKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_key(impl Into<String>)`](crate::client::fluent_builders::DeleteApiKey::api_key) / [`set_api_key(Option<String>)`](crate::client::fluent_builders::DeleteApiKey::set_api_key): <p>[Required] The identifier of the <code>ApiKey</code> resource to be deleted.</p>
    /// - On success, responds with [`DeleteApiKeyOutput`](crate::output::DeleteApiKeyOutput)

    /// - On failure, responds with [`SdkError<DeleteApiKeyError>`](crate::error::DeleteApiKeyError)
    pub fn delete_api_key(&self) -> fluent_builders::DeleteApiKey<C, M, R> {
        fluent_builders::DeleteApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAuthorizer`](crate::client::fluent_builders::DeleteAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAuthorizer::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteAuthorizer::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAuthorizer::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::DeleteAuthorizer::set_authorizer_id): <p>[Required] The identifier of the <code>Authorizer</code> resource.</p>
    /// - On success, responds with [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)

    /// - On failure, responds with [`SdkError<DeleteAuthorizerError>`](crate::error::DeleteAuthorizerError)
    pub fn delete_authorizer(&self) -> fluent_builders::DeleteAuthorizer<C, M, R> {
        fluent_builders::DeleteAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBasePathMapping`](crate::client::fluent_builders::DeleteBasePathMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBasePathMapping::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteBasePathMapping::set_domain_name): <p>[Required] The domain name of the <code>BasePathMapping</code> resource to delete.</p>
    ///   - [`base_path(impl Into<String>)`](crate::client::fluent_builders::DeleteBasePathMapping::base_path) / [`set_base_path(Option<String>)`](crate::client::fluent_builders::DeleteBasePathMapping::set_base_path): <p>[Required] The base path name of the <code>BasePathMapping</code> resource to delete.</p>  <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
    /// - On success, responds with [`DeleteBasePathMappingOutput`](crate::output::DeleteBasePathMappingOutput)

    /// - On failure, responds with [`SdkError<DeleteBasePathMappingError>`](crate::error::DeleteBasePathMappingError)
    pub fn delete_base_path_mapping(&self) -> fluent_builders::DeleteBasePathMapping<C, M, R> {
        fluent_builders::DeleteBasePathMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteClientCertificate`](crate::client::fluent_builders::DeleteClientCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_certificate_id(impl Into<String>)`](crate::client::fluent_builders::DeleteClientCertificate::client_certificate_id) / [`set_client_certificate_id(Option<String>)`](crate::client::fluent_builders::DeleteClientCertificate::set_client_certificate_id): <p>[Required] The identifier of the <code>ClientCertificate</code> resource to be deleted.</p>
    /// - On success, responds with [`DeleteClientCertificateOutput`](crate::output::DeleteClientCertificateOutput)

    /// - On failure, responds with [`SdkError<DeleteClientCertificateError>`](crate::error::DeleteClientCertificateError)
    pub fn delete_client_certificate(&self) -> fluent_builders::DeleteClientCertificate<C, M, R> {
        fluent_builders::DeleteClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDeployment`](crate::client::fluent_builders::DeleteDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDeployment::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteDeployment::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::DeleteDeployment::set_deployment_id): <p>[Required] The identifier of the <code>Deployment</code> resource to delete.</p>
    /// - On success, responds with [`DeleteDeploymentOutput`](crate::output::DeleteDeploymentOutput)

    /// - On failure, responds with [`SdkError<DeleteDeploymentError>`](crate::error::DeleteDeploymentError)
    pub fn delete_deployment(&self) -> fluent_builders::DeleteDeployment<C, M, R> {
        fluent_builders::DeleteDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDocumentationPart`](crate::client::fluent_builders::DeleteDocumentationPart) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDocumentationPart::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteDocumentationPart::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`documentation_part_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDocumentationPart::documentation_part_id) / [`set_documentation_part_id(Option<String>)`](crate::client::fluent_builders::DeleteDocumentationPart::set_documentation_part_id): <p>[Required] The identifier of the to-be-deleted documentation part.</p>
    /// - On success, responds with [`DeleteDocumentationPartOutput`](crate::output::DeleteDocumentationPartOutput)

    /// - On failure, responds with [`SdkError<DeleteDocumentationPartError>`](crate::error::DeleteDocumentationPartError)
    pub fn delete_documentation_part(&self) -> fluent_builders::DeleteDocumentationPart<C, M, R> {
        fluent_builders::DeleteDocumentationPart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDocumentationVersion`](crate::client::fluent_builders::DeleteDocumentationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDocumentationVersion::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteDocumentationVersion::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`documentation_version(impl Into<String>)`](crate::client::fluent_builders::DeleteDocumentationVersion::documentation_version) / [`set_documentation_version(Option<String>)`](crate::client::fluent_builders::DeleteDocumentationVersion::set_documentation_version): <p>[Required] The version identifier of a to-be-deleted documentation snapshot.</p>
    /// - On success, responds with [`DeleteDocumentationVersionOutput`](crate::output::DeleteDocumentationVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteDocumentationVersionError>`](crate::error::DeleteDocumentationVersionError)
    pub fn delete_documentation_version(
        &self,
    ) -> fluent_builders::DeleteDocumentationVersion<C, M, R> {
        fluent_builders::DeleteDocumentationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomainName`](crate::client::fluent_builders::DeleteDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteDomainName::set_domain_name): <p>[Required] The name of the <code>DomainName</code> resource to be deleted.</p>
    /// - On success, responds with [`DeleteDomainNameOutput`](crate::output::DeleteDomainNameOutput)

    /// - On failure, responds with [`SdkError<DeleteDomainNameError>`](crate::error::DeleteDomainNameError)
    pub fn delete_domain_name(&self) -> fluent_builders::DeleteDomainName<C, M, R> {
        fluent_builders::DeleteDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGatewayResponse`](crate::client::fluent_builders::DeleteGatewayResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGatewayResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteGatewayResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`response_type(GatewayResponseType)`](crate::client::fluent_builders::DeleteGatewayResponse::response_type) / [`set_response_type(Option<GatewayResponseType>)`](crate::client::fluent_builders::DeleteGatewayResponse::set_response_type): <p>[Required] </p> <p>The response type of the associated <code>GatewayResponse</code>.</p> <p></p>
    /// - On success, responds with [`DeleteGatewayResponseOutput`](crate::output::DeleteGatewayResponseOutput)

    /// - On failure, responds with [`SdkError<DeleteGatewayResponseError>`](crate::error::DeleteGatewayResponseError)
    pub fn delete_gateway_response(&self) -> fluent_builders::DeleteGatewayResponse<C, M, R> {
        fluent_builders::DeleteGatewayResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIntegration`](crate::client::fluent_builders::DeleteIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegration::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegration::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegration::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegration::set_resource_id): <p>[Required] Specifies a delete integration request's resource identifier.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegration::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::DeleteIntegration::set_http_method): <p>[Required] Specifies a delete integration request's HTTP method.</p>
    /// - On success, responds with [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)

    /// - On failure, responds with [`SdkError<DeleteIntegrationError>`](crate::error::DeleteIntegrationError)
    pub fn delete_integration(&self) -> fluent_builders::DeleteIntegration<C, M, R> {
        fluent_builders::DeleteIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIntegrationResponse`](crate::client::fluent_builders::DeleteIntegrationResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::set_resource_id): <p>[Required] Specifies a delete integration response request's resource identifier.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::set_http_method): <p>[Required] Specifies a delete integration response request's HTTP method.</p>
    ///   - [`status_code(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::status_code) / [`set_status_code(Option<String>)`](crate::client::fluent_builders::DeleteIntegrationResponse::set_status_code): <p>[Required] Specifies a delete integration response request's status code.</p>
    /// - On success, responds with [`DeleteIntegrationResponseOutput`](crate::output::DeleteIntegrationResponseOutput)

    /// - On failure, responds with [`SdkError<DeleteIntegrationResponseError>`](crate::error::DeleteIntegrationResponseError)
    pub fn delete_integration_response(
        &self,
    ) -> fluent_builders::DeleteIntegrationResponse<C, M, R> {
        fluent_builders::DeleteIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMethod`](crate::client::fluent_builders::DeleteMethod) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMethod::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteMethod::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMethod::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteMethod::set_resource_id): <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::DeleteMethod::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::DeleteMethod::set_http_method): <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
    /// - On success, responds with [`DeleteMethodOutput`](crate::output::DeleteMethodOutput)

    /// - On failure, responds with [`SdkError<DeleteMethodError>`](crate::error::DeleteMethodError)
    pub fn delete_method(&self) -> fluent_builders::DeleteMethod<C, M, R> {
        fluent_builders::DeleteMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMethodResponse`](crate::client::fluent_builders::DeleteMethodResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMethodResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteMethodResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMethodResponse::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteMethodResponse::set_resource_id): <p>[Required] The <code>Resource</code> identifier for the <code>MethodResponse</code> resource.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::DeleteMethodResponse::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::DeleteMethodResponse::set_http_method): <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
    ///   - [`status_code(impl Into<String>)`](crate::client::fluent_builders::DeleteMethodResponse::status_code) / [`set_status_code(Option<String>)`](crate::client::fluent_builders::DeleteMethodResponse::set_status_code): <p>[Required] The status code identifier for the <code>MethodResponse</code> resource.</p>
    /// - On success, responds with [`DeleteMethodResponseOutput`](crate::output::DeleteMethodResponseOutput)

    /// - On failure, responds with [`SdkError<DeleteMethodResponseError>`](crate::error::DeleteMethodResponseError)
    pub fn delete_method_response(&self) -> fluent_builders::DeleteMethodResponse<C, M, R> {
        fluent_builders::DeleteMethodResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteModel`](crate::client::fluent_builders::DeleteModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteModel::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteModel::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`model_name(impl Into<String>)`](crate::client::fluent_builders::DeleteModel::model_name) / [`set_model_name(Option<String>)`](crate::client::fluent_builders::DeleteModel::set_model_name): <p>[Required] The name of the model to delete.</p>
    /// - On success, responds with [`DeleteModelOutput`](crate::output::DeleteModelOutput)

    /// - On failure, responds with [`SdkError<DeleteModelError>`](crate::error::DeleteModelError)
    pub fn delete_model(&self) -> fluent_builders::DeleteModel<C, M, R> {
        fluent_builders::DeleteModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRequestValidator`](crate::client::fluent_builders::DeleteRequestValidator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRequestValidator::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteRequestValidator::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`request_validator_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRequestValidator::request_validator_id) / [`set_request_validator_id(Option<String>)`](crate::client::fluent_builders::DeleteRequestValidator::set_request_validator_id): <p>[Required] The identifier of the <code>RequestValidator</code> to be deleted.</p>
    /// - On success, responds with [`DeleteRequestValidatorOutput`](crate::output::DeleteRequestValidatorOutput)

    /// - On failure, responds with [`SdkError<DeleteRequestValidatorError>`](crate::error::DeleteRequestValidatorError)
    pub fn delete_request_validator(&self) -> fluent_builders::DeleteRequestValidator<C, M, R> {
        fluent_builders::DeleteRequestValidator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResource`](crate::client::fluent_builders::DeleteResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResource::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteResource::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteResource::set_resource_id): <p>[Required] The identifier of the <code>Resource</code> resource.</p>
    /// - On success, responds with [`DeleteResourceOutput`](crate::output::DeleteResourceOutput)

    /// - On failure, responds with [`SdkError<DeleteResourceError>`](crate::error::DeleteResourceError)
    pub fn delete_resource(&self) -> fluent_builders::DeleteResource<C, M, R> {
        fluent_builders::DeleteResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRestApi`](crate::client::fluent_builders::DeleteRestApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRestApi::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteRestApi::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    /// - On success, responds with [`DeleteRestApiOutput`](crate::output::DeleteRestApiOutput)

    /// - On failure, responds with [`SdkError<DeleteRestApiError>`](crate::error::DeleteRestApiError)
    pub fn delete_rest_api(&self) -> fluent_builders::DeleteRestApi<C, M, R> {
        fluent_builders::DeleteRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStage`](crate::client::fluent_builders::DeleteStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStage::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::DeleteStage::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::DeleteStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::DeleteStage::set_stage_name): <p>[Required] The name of the <code>Stage</code> resource to delete.</p>
    /// - On success, responds with [`DeleteStageOutput`](crate::output::DeleteStageOutput)

    /// - On failure, responds with [`SdkError<DeleteStageError>`](crate::error::DeleteStageError)
    pub fn delete_stage(&self) -> fluent_builders::DeleteStage<C, M, R> {
        fluent_builders::DeleteStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUsagePlan`](crate::client::fluent_builders::DeleteUsagePlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_plan_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUsagePlan::usage_plan_id) / [`set_usage_plan_id(Option<String>)`](crate::client::fluent_builders::DeleteUsagePlan::set_usage_plan_id): <p>[Required] The Id of the to-be-deleted usage plan.</p>
    /// - On success, responds with [`DeleteUsagePlanOutput`](crate::output::DeleteUsagePlanOutput)

    /// - On failure, responds with [`SdkError<DeleteUsagePlanError>`](crate::error::DeleteUsagePlanError)
    pub fn delete_usage_plan(&self) -> fluent_builders::DeleteUsagePlan<C, M, R> {
        fluent_builders::DeleteUsagePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUsagePlanKey`](crate::client::fluent_builders::DeleteUsagePlanKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_plan_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUsagePlanKey::usage_plan_id) / [`set_usage_plan_id(Option<String>)`](crate::client::fluent_builders::DeleteUsagePlanKey::set_usage_plan_id): <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-deleted <code>UsagePlanKey</code> resource representing a plan customer.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUsagePlanKey::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::DeleteUsagePlanKey::set_key_id): <p>[Required] The Id of the <code>UsagePlanKey</code> resource to be deleted.</p>
    /// - On success, responds with [`DeleteUsagePlanKeyOutput`](crate::output::DeleteUsagePlanKeyOutput)

    /// - On failure, responds with [`SdkError<DeleteUsagePlanKeyError>`](crate::error::DeleteUsagePlanKeyError)
    pub fn delete_usage_plan_key(&self) -> fluent_builders::DeleteUsagePlanKey<C, M, R> {
        fluent_builders::DeleteUsagePlanKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpcLink`](crate::client::fluent_builders::DeleteVpcLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_link_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVpcLink::vpc_link_id) / [`set_vpc_link_id(Option<String>)`](crate::client::fluent_builders::DeleteVpcLink::set_vpc_link_id): <p>[Required] The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
    /// - On success, responds with [`DeleteVpcLinkOutput`](crate::output::DeleteVpcLinkOutput)

    /// - On failure, responds with [`SdkError<DeleteVpcLinkError>`](crate::error::DeleteVpcLinkError)
    pub fn delete_vpc_link(&self) -> fluent_builders::DeleteVpcLink<C, M, R> {
        fluent_builders::DeleteVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FlushStageAuthorizersCache`](crate::client::fluent_builders::FlushStageAuthorizersCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::FlushStageAuthorizersCache::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::FlushStageAuthorizersCache::set_rest_api_id): <p>The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::FlushStageAuthorizersCache::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::FlushStageAuthorizersCache::set_stage_name): <p>The name of the stage to flush.</p>
    /// - On success, responds with [`FlushStageAuthorizersCacheOutput`](crate::output::FlushStageAuthorizersCacheOutput)

    /// - On failure, responds with [`SdkError<FlushStageAuthorizersCacheError>`](crate::error::FlushStageAuthorizersCacheError)
    pub fn flush_stage_authorizers_cache(
        &self,
    ) -> fluent_builders::FlushStageAuthorizersCache<C, M, R> {
        fluent_builders::FlushStageAuthorizersCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FlushStageCache`](crate::client::fluent_builders::FlushStageCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::FlushStageCache::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::FlushStageCache::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::FlushStageCache::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::FlushStageCache::set_stage_name): <p>[Required] The name of the stage to flush its cache.</p>
    /// - On success, responds with [`FlushStageCacheOutput`](crate::output::FlushStageCacheOutput)

    /// - On failure, responds with [`SdkError<FlushStageCacheError>`](crate::error::FlushStageCacheError)
    pub fn flush_stage_cache(&self) -> fluent_builders::FlushStageCache<C, M, R> {
        fluent_builders::FlushStageCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateClientCertificate`](crate::client::fluent_builders::GenerateClientCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::GenerateClientCertificate::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::GenerateClientCertificate::set_description): <p>The description of the <code>ClientCertificate</code>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::GenerateClientCertificate::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GenerateClientCertificate::set_tags): <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    /// - On success, responds with [`GenerateClientCertificateOutput`](crate::output::GenerateClientCertificateOutput) with field(s):
    ///   - [`client_certificate_id(Option<String>)`](crate::output::GenerateClientCertificateOutput::client_certificate_id): <p>The identifier of the client certificate.</p>
    ///   - [`description(Option<String>)`](crate::output::GenerateClientCertificateOutput::description): <p>The description of the client certificate.</p>
    ///   - [`pem_encoded_certificate(Option<String>)`](crate::output::GenerateClientCertificateOutput::pem_encoded_certificate): <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GenerateClientCertificateOutput::created_date): <p>The timestamp when the client certificate was created.</p>
    ///   - [`expiration_date(Option<DateTime>)`](crate::output::GenerateClientCertificateOutput::expiration_date): <p>The timestamp when the client certificate will expire.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GenerateClientCertificateOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<GenerateClientCertificateError>`](crate::error::GenerateClientCertificateError)
    pub fn generate_client_certificate(
        &self,
    ) -> fluent_builders::GenerateClientCertificate<C, M, R> {
        fluent_builders::GenerateClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccount`](crate::client::fluent_builders::GetAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAccount::send) it.

    /// - On success, responds with [`GetAccountOutput`](crate::output::GetAccountOutput) with field(s):
    ///   - [`cloudwatch_role_arn(Option<String>)`](crate::output::GetAccountOutput::cloudwatch_role_arn): <p>The ARN of an Amazon CloudWatch role for the current <code>Account</code>.</p>
    ///   - [`throttle_settings(Option<ThrottleSettings>)`](crate::output::GetAccountOutput::throttle_settings): <p>Specifies the API request limits configured for the current <code>Account</code>.</p>
    ///   - [`features(Option<Vec<String>>)`](crate::output::GetAccountOutput::features): <p>A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.</p>
    ///   - [`api_key_version(Option<String>)`](crate::output::GetAccountOutput::api_key_version): <p>The version of the API keys used for the account.</p>
    /// - On failure, responds with [`SdkError<GetAccountError>`](crate::error::GetAccountError)
    pub fn get_account(&self) -> fluent_builders::GetAccount<C, M, R> {
        fluent_builders::GetAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApiKey`](crate::client::fluent_builders::GetApiKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_key(impl Into<String>)`](crate::client::fluent_builders::GetApiKey::api_key) / [`set_api_key(Option<String>)`](crate::client::fluent_builders::GetApiKey::set_api_key): <p>[Required] The identifier of the <code>ApiKey</code> resource.</p>
    ///   - [`include_value(bool)`](crate::client::fluent_builders::GetApiKey::include_value) / [`set_include_value(Option<bool>)`](crate::client::fluent_builders::GetApiKey::set_include_value): <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.</p>
    /// - On success, responds with [`GetApiKeyOutput`](crate::output::GetApiKeyOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetApiKeyOutput::id): <p>The identifier of the API Key.</p>
    ///   - [`value(Option<String>)`](crate::output::GetApiKeyOutput::value): <p>The value of the API Key.</p>
    ///   - [`name(Option<String>)`](crate::output::GetApiKeyOutput::name): <p>The name of the API Key.</p>
    ///   - [`customer_id(Option<String>)`](crate::output::GetApiKeyOutput::customer_id): <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
    ///   - [`description(Option<String>)`](crate::output::GetApiKeyOutput::description): <p>The description of the API Key.</p>
    ///   - [`enabled(bool)`](crate::output::GetApiKeyOutput::enabled): <p>Specifies whether the API Key can be used by callers.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetApiKeyOutput::created_date): <p>The timestamp when the API Key was created.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::GetApiKeyOutput::last_updated_date): <p>The timestamp when the API Key was last updated.</p>
    ///   - [`stage_keys(Option<Vec<String>>)`](crate::output::GetApiKeyOutput::stage_keys): <p>A list of <code>Stage</code> resources that are associated with the <code>ApiKey</code> resource.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetApiKeyOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<GetApiKeyError>`](crate::error::GetApiKeyError)
    pub fn get_api_key(&self) -> fluent_builders::GetApiKey<C, M, R> {
        fluent_builders::GetApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApiKeys`](crate::client::fluent_builders::GetApiKeys) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetApiKeys::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetApiKeys::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetApiKeys::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetApiKeys::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetApiKeys::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    ///   - [`name_query(impl Into<String>)`](crate::client::fluent_builders::GetApiKeys::name_query) / [`set_name_query(Option<String>)`](crate::client::fluent_builders::GetApiKeys::set_name_query): <p>The name of queried API keys.</p>
    ///   - [`customer_id(impl Into<String>)`](crate::client::fluent_builders::GetApiKeys::customer_id) / [`set_customer_id(Option<String>)`](crate::client::fluent_builders::GetApiKeys::set_customer_id): <p>The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.</p>
    ///   - [`include_values(bool)`](crate::client::fluent_builders::GetApiKeys::include_values) / [`set_include_values(Option<bool>)`](crate::client::fluent_builders::GetApiKeys::set_include_values): <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.</p>
    /// - On success, responds with [`GetApiKeysOutput`](crate::output::GetApiKeysOutput) with field(s):
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::GetApiKeysOutput::warnings): <p>A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code> option is set to true.</p>
    ///   - [`items(Option<Vec<ApiKey>>)`](crate::output::GetApiKeysOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetApiKeysOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetApiKeysError>`](crate::error::GetApiKeysError)
    pub fn get_api_keys(&self) -> fluent_builders::GetApiKeys<C, M, R> {
        fluent_builders::GetApiKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAuthorizer`](crate::client::fluent_builders::GetAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizer::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetAuthorizer::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizer::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::GetAuthorizer::set_authorizer_id): <p>[Required] The identifier of the <code>Authorizer</code> resource.</p>
    /// - On success, responds with [`GetAuthorizerOutput`](crate::output::GetAuthorizerOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetAuthorizerOutput::id): <p>The identifier for the authorizer resource.</p>
    ///   - [`name(Option<String>)`](crate::output::GetAuthorizerOutput::name): <p>[Required] The name of the authorizer.</p>
    ///   - [`r#type(Option<AuthorizerType>)`](crate::output::GetAuthorizerOutput::type): <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
    ///   - [`provider_ar_ns(Option<Vec<String>>)`](crate::output::GetAuthorizerOutput::provider_ar_ns): <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
    ///   - [`auth_type(Option<String>)`](crate::output::GetAuthorizerOutput::auth_type): <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
    ///   - [`authorizer_uri(Option<String>)`](crate::output::GetAuthorizerOutput::authorizer_uri): <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
    ///   - [`authorizer_credentials(Option<String>)`](crate::output::GetAuthorizerOutput::authorizer_credentials): <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
    ///   - [`identity_source(Option<String>)`](crate::output::GetAuthorizerOutput::identity_source): <p>The identity source for which authorization is requested. </p> <ul>  <li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li>  <li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li> </ul> <p></p>
    ///   - [`identity_validation_expression(Option<String>)`](crate::output::GetAuthorizerOutput::identity_validation_expression): <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
    ///   - [`authorizer_result_ttl_in_seconds(Option<i32>)`](crate::output::GetAuthorizerOutput::authorizer_result_ttl_in_seconds): <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
    /// - On failure, responds with [`SdkError<GetAuthorizerError>`](crate::error::GetAuthorizerError)
    pub fn get_authorizer(&self) -> fluent_builders::GetAuthorizer<C, M, R> {
        fluent_builders::GetAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAuthorizers`](crate::client::fluent_builders::GetAuthorizers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizers::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetAuthorizers::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizers::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetAuthorizers::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetAuthorizers::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetAuthorizers::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetAuthorizersOutput`](crate::output::GetAuthorizersOutput) with field(s):
    ///   - [`items(Option<Vec<Authorizer>>)`](crate::output::GetAuthorizersOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetAuthorizersOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetAuthorizersError>`](crate::error::GetAuthorizersError)
    pub fn get_authorizers(&self) -> fluent_builders::GetAuthorizers<C, M, R> {
        fluent_builders::GetAuthorizers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBasePathMapping`](crate::client::fluent_builders::GetBasePathMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetBasePathMapping::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetBasePathMapping::set_domain_name): <p>[Required] The domain name of the <code>BasePathMapping</code> resource to be described.</p>
    ///   - [`base_path(impl Into<String>)`](crate::client::fluent_builders::GetBasePathMapping::base_path) / [`set_base_path(Option<String>)`](crate::client::fluent_builders::GetBasePathMapping::set_base_path): <p>[Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.</p>
    /// - On success, responds with [`GetBasePathMappingOutput`](crate::output::GetBasePathMappingOutput) with field(s):
    ///   - [`base_path(Option<String>)`](crate::output::GetBasePathMappingOutput::base_path): <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
    ///   - [`rest_api_id(Option<String>)`](crate::output::GetBasePathMappingOutput::rest_api_id): <p>The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage(Option<String>)`](crate::output::GetBasePathMappingOutput::stage): <p>The name of the associated stage.</p>
    /// - On failure, responds with [`SdkError<GetBasePathMappingError>`](crate::error::GetBasePathMappingError)
    pub fn get_base_path_mapping(&self) -> fluent_builders::GetBasePathMapping<C, M, R> {
        fluent_builders::GetBasePathMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBasePathMappings`](crate::client::fluent_builders::GetBasePathMappings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBasePathMappings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetBasePathMappings::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetBasePathMappings::set_domain_name): <p>[Required] The domain name of a <code>BasePathMapping</code> resource.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetBasePathMappings::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetBasePathMappings::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetBasePathMappings::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetBasePathMappings::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetBasePathMappingsOutput`](crate::output::GetBasePathMappingsOutput) with field(s):
    ///   - [`items(Option<Vec<BasePathMapping>>)`](crate::output::GetBasePathMappingsOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetBasePathMappingsOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetBasePathMappingsError>`](crate::error::GetBasePathMappingsError)
    pub fn get_base_path_mappings(&self) -> fluent_builders::GetBasePathMappings<C, M, R> {
        fluent_builders::GetBasePathMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetClientCertificate`](crate::client::fluent_builders::GetClientCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_certificate_id(impl Into<String>)`](crate::client::fluent_builders::GetClientCertificate::client_certificate_id) / [`set_client_certificate_id(Option<String>)`](crate::client::fluent_builders::GetClientCertificate::set_client_certificate_id): <p>[Required] The identifier of the <code>ClientCertificate</code> resource to be described.</p>
    /// - On success, responds with [`GetClientCertificateOutput`](crate::output::GetClientCertificateOutput) with field(s):
    ///   - [`client_certificate_id(Option<String>)`](crate::output::GetClientCertificateOutput::client_certificate_id): <p>The identifier of the client certificate.</p>
    ///   - [`description(Option<String>)`](crate::output::GetClientCertificateOutput::description): <p>The description of the client certificate.</p>
    ///   - [`pem_encoded_certificate(Option<String>)`](crate::output::GetClientCertificateOutput::pem_encoded_certificate): <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetClientCertificateOutput::created_date): <p>The timestamp when the client certificate was created.</p>
    ///   - [`expiration_date(Option<DateTime>)`](crate::output::GetClientCertificateOutput::expiration_date): <p>The timestamp when the client certificate will expire.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetClientCertificateOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<GetClientCertificateError>`](crate::error::GetClientCertificateError)
    pub fn get_client_certificate(&self) -> fluent_builders::GetClientCertificate<C, M, R> {
        fluent_builders::GetClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetClientCertificates`](crate::client::fluent_builders::GetClientCertificates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetClientCertificates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetClientCertificates::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetClientCertificates::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetClientCertificates::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetClientCertificates::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetClientCertificatesOutput`](crate::output::GetClientCertificatesOutput) with field(s):
    ///   - [`items(Option<Vec<ClientCertificate>>)`](crate::output::GetClientCertificatesOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetClientCertificatesOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetClientCertificatesError>`](crate::error::GetClientCertificatesError)
    pub fn get_client_certificates(&self) -> fluent_builders::GetClientCertificates<C, M, R> {
        fluent_builders::GetClientCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeployment`](crate::client::fluent_builders::GetDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployment::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetDeployment::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::GetDeployment::set_deployment_id): <p>[Required] The identifier of the <code>Deployment</code> resource to get information about.</p>
    ///   - [`embed(Vec<String>)`](crate::client::fluent_builders::GetDeployment::embed) / [`set_embed(Option<Vec<String>>)`](crate::client::fluent_builders::GetDeployment::set_embed): <p>A query parameter to retrieve the specified embedded resources of the returned <code>Deployment</code> resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string. For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.</p>
    /// - On success, responds with [`GetDeploymentOutput`](crate::output::GetDeploymentOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetDeploymentOutput::id): <p>The identifier for the deployment resource.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDeploymentOutput::description): <p>The description for the deployment resource.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetDeploymentOutput::created_date): <p>The date and time that the deployment resource was created.</p>
    ///   - [`api_summary(Option<HashMap<String, HashMap<String, MethodSnapshot>>>)`](crate::output::GetDeploymentOutput::api_summary): <p>A summary of the <code>RestApi</code> at the date and time that the deployment resource was created.</p>
    /// - On failure, responds with [`SdkError<GetDeploymentError>`](crate::error::GetDeploymentError)
    pub fn get_deployment(&self) -> fluent_builders::GetDeployment<C, M, R> {
        fluent_builders::GetDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeployments`](crate::client::fluent_builders::GetDeployments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetDeployments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployments::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetDeployments::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetDeployments::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetDeployments::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetDeployments::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetDeployments::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetDeploymentsOutput`](crate::output::GetDeploymentsOutput) with field(s):
    ///   - [`items(Option<Vec<Deployment>>)`](crate::output::GetDeploymentsOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetDeploymentsOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetDeploymentsError>`](crate::error::GetDeploymentsError)
    pub fn get_deployments(&self) -> fluent_builders::GetDeployments<C, M, R> {
        fluent_builders::GetDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocumentationPart`](crate::client::fluent_builders::GetDocumentationPart) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationPart::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetDocumentationPart::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`documentation_part_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationPart::documentation_part_id) / [`set_documentation_part_id(Option<String>)`](crate::client::fluent_builders::GetDocumentationPart::set_documentation_part_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    /// - On success, responds with [`GetDocumentationPartOutput`](crate::output::GetDocumentationPartOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetDocumentationPartOutput::id): <p>The <code>DocumentationPart</code> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
    ///   - [`location(Option<DocumentationPartLocation>)`](crate::output::GetDocumentationPartOutput::location): <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
    ///   - [`properties(Option<String>)`](crate::output::GetDocumentationPartOutput::properties): <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant documentation-related fields from the <literal>   properties  </literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
    /// - On failure, responds with [`SdkError<GetDocumentationPartError>`](crate::error::GetDocumentationPartError)
    pub fn get_documentation_part(&self) -> fluent_builders::GetDocumentationPart<C, M, R> {
        fluent_builders::GetDocumentationPart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocumentationParts`](crate::client::fluent_builders::GetDocumentationParts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationParts::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetDocumentationParts::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`r#type(DocumentationPartType)`](crate::client::fluent_builders::GetDocumentationParts::r#type) / [`set_type(Option<DocumentationPartType>)`](crate::client::fluent_builders::GetDocumentationParts::set_type): <p>The type of API entities of the to-be-retrieved documentation parts. </p>
    ///   - [`name_query(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationParts::name_query) / [`set_name_query(Option<String>)`](crate::client::fluent_builders::GetDocumentationParts::set_name_query): <p>The name of API entities of the to-be-retrieved documentation parts.</p>
    ///   - [`path(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationParts::path) / [`set_path(Option<String>)`](crate::client::fluent_builders::GetDocumentationParts::set_path): <p>The path of API entities of the to-be-retrieved documentation parts.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationParts::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetDocumentationParts::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetDocumentationParts::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetDocumentationParts::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    ///   - [`location_status(LocationStatusType)`](crate::client::fluent_builders::GetDocumentationParts::location_status) / [`set_location_status(Option<LocationStatusType>)`](crate::client::fluent_builders::GetDocumentationParts::set_location_status): <p>The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving <code>DocumentationPart</code> resources with content and <code>UNDOCUMENTED</code> for <code>DocumentationPart</code> resources without content.</p>
    /// - On success, responds with [`GetDocumentationPartsOutput`](crate::output::GetDocumentationPartsOutput) with field(s):
    ///   - [`items(Option<Vec<DocumentationPart>>)`](crate::output::GetDocumentationPartsOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetDocumentationPartsOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetDocumentationPartsError>`](crate::error::GetDocumentationPartsError)
    pub fn get_documentation_parts(&self) -> fluent_builders::GetDocumentationParts<C, M, R> {
        fluent_builders::GetDocumentationParts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocumentationVersion`](crate::client::fluent_builders::GetDocumentationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationVersion::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetDocumentationVersion::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`documentation_version(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationVersion::documentation_version) / [`set_documentation_version(Option<String>)`](crate::client::fluent_builders::GetDocumentationVersion::set_documentation_version): <p>[Required] The version identifier of the to-be-retrieved documentation snapshot.</p>
    /// - On success, responds with [`GetDocumentationVersionOutput`](crate::output::GetDocumentationVersionOutput) with field(s):
    ///   - [`version(Option<String>)`](crate::output::GetDocumentationVersionOutput::version): <p>The version identifier of the API documentation snapshot.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetDocumentationVersionOutput::created_date): <p>The date when the API documentation snapshot is created.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDocumentationVersionOutput::description): <p>The description of the API documentation snapshot.</p>
    /// - On failure, responds with [`SdkError<GetDocumentationVersionError>`](crate::error::GetDocumentationVersionError)
    pub fn get_documentation_version(&self) -> fluent_builders::GetDocumentationVersion<C, M, R> {
        fluent_builders::GetDocumentationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocumentationVersions`](crate::client::fluent_builders::GetDocumentationVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationVersions::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetDocumentationVersions::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetDocumentationVersions::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetDocumentationVersions::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetDocumentationVersions::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetDocumentationVersions::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetDocumentationVersionsOutput`](crate::output::GetDocumentationVersionsOutput) with field(s):
    ///   - [`items(Option<Vec<DocumentationVersion>>)`](crate::output::GetDocumentationVersionsOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetDocumentationVersionsOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetDocumentationVersionsError>`](crate::error::GetDocumentationVersionsError)
    pub fn get_documentation_versions(&self) -> fluent_builders::GetDocumentationVersions<C, M, R> {
        fluent_builders::GetDocumentationVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainName`](crate::client::fluent_builders::GetDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetDomainName::set_domain_name): <p>[Required] The name of the <code>DomainName</code> resource.</p>
    /// - On success, responds with [`GetDomainNameOutput`](crate::output::GetDomainNameOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::GetDomainNameOutput::domain_name): <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
    ///   - [`certificate_name(Option<String>)`](crate::output::GetDomainNameOutput::certificate_name): <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    ///   - [`certificate_arn(Option<String>)`](crate::output::GetDomainNameOutput::certificate_arn): <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    ///   - [`certificate_upload_date(Option<DateTime>)`](crate::output::GetDomainNameOutput::certificate_upload_date): <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    ///   - [`regional_domain_name(Option<String>)`](crate::output::GetDomainNameOutput::regional_domain_name): <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
    ///   - [`regional_hosted_zone_id(Option<String>)`](crate::output::GetDomainNameOutput::regional_hosted_zone_id): <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    ///   - [`regional_certificate_name(Option<String>)`](crate::output::GetDomainNameOutput::regional_certificate_name): <p>The name of the certificate that will be used for validating the regional domain name.</p>
    ///   - [`regional_certificate_arn(Option<String>)`](crate::output::GetDomainNameOutput::regional_certificate_arn): <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
    ///   - [`distribution_domain_name(Option<String>)`](crate::output::GetDomainNameOutput::distribution_domain_name): <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
    ///   - [`distribution_hosted_zone_id(Option<String>)`](crate::output::GetDomainNameOutput::distribution_hosted_zone_id): <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    ///   - [`endpoint_configuration(Option<EndpointConfiguration>)`](crate::output::GetDomainNameOutput::endpoint_configuration): <p>The endpoint configuration of this <code>DomainName</code> showing the endpoint types of the domain name.</p>
    ///   - [`domain_name_status(Option<DomainNameStatus>)`](crate::output::GetDomainNameOutput::domain_name_status): <p>The status of the <code>DomainName</code> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
    ///   - [`domain_name_status_message(Option<String>)`](crate::output::GetDomainNameOutput::domain_name_status_message): <p>An optional text message containing detailed information about status of the <code>DomainName</code> migration.</p>
    ///   - [`security_policy(Option<SecurityPolicy>)`](crate::output::GetDomainNameOutput::security_policy): <p>The Transport Layer Security (TLS) version + cipher suite for this <code>DomainName</code>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetDomainNameOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`mutual_tls_authentication(Option<MutualTlsAuthentication>)`](crate::output::GetDomainNameOutput::mutual_tls_authentication): <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
    ///   - [`ownership_verification_certificate_arn(Option<String>)`](crate::output::GetDomainNameOutput::ownership_verification_certificate_arn): <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    /// - On failure, responds with [`SdkError<GetDomainNameError>`](crate::error::GetDomainNameError)
    pub fn get_domain_name(&self) -> fluent_builders::GetDomainName<C, M, R> {
        fluent_builders::GetDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainNames`](crate::client::fluent_builders::GetDomainNames) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetDomainNames::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetDomainNames::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetDomainNames::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetDomainNames::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetDomainNames::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput) with field(s):
    ///   - [`items(Option<Vec<DomainName>>)`](crate::output::GetDomainNamesOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetDomainNamesOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetDomainNamesError>`](crate::error::GetDomainNamesError)
    pub fn get_domain_names(&self) -> fluent_builders::GetDomainNames<C, M, R> {
        fluent_builders::GetDomainNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExport`](crate::client::fluent_builders::GetExport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetExport::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetExport::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::GetExport::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::GetExport::set_stage_name): <p>[Required] The name of the <code>Stage</code> that will be exported.</p>
    ///   - [`export_type(impl Into<String>)`](crate::client::fluent_builders::GetExport::export_type) / [`set_export_type(Option<String>)`](crate::client::fluent_builders::GetExport::set_export_type): <p>[Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.</p>
    ///   - [`parameters(HashMap<String, String>)`](crate::client::fluent_builders::GetExport::parameters) / [`set_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetExport::set_parameters): <p>A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool</p>
    ///   - [`accepts(impl Into<String>)`](crate::client::fluent_builders::GetExport::accepts) / [`set_accepts(Option<String>)`](crate::client::fluent_builders::GetExport::set_accepts): <p>The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.</p>
    /// - On success, responds with [`GetExportOutput`](crate::output::GetExportOutput) with field(s):
    ///   - [`content_type(Option<String>)`](crate::output::GetExportOutput::content_type): <p>The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in the request.</p>
    ///   - [`content_disposition(Option<String>)`](crate::output::GetExportOutput::content_disposition): <p>The content-disposition header value in the HTTP response.</p>
    ///   - [`body(Option<Blob>)`](crate::output::GetExportOutput::body): <p>The binary blob response to <code>GetExport</code>, which contains the export.</p>
    /// - On failure, responds with [`SdkError<GetExportError>`](crate::error::GetExportError)
    pub fn get_export(&self) -> fluent_builders::GetExport<C, M, R> {
        fluent_builders::GetExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGatewayResponse`](crate::client::fluent_builders::GetGatewayResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetGatewayResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetGatewayResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`response_type(GatewayResponseType)`](crate::client::fluent_builders::GetGatewayResponse::response_type) / [`set_response_type(Option<GatewayResponseType>)`](crate::client::fluent_builders::GetGatewayResponse::set_response_type): <p>[Required] </p> <p>The response type of the associated <code>GatewayResponse</code>.</p> <p></p>
    /// - On success, responds with [`GetGatewayResponseOutput`](crate::output::GetGatewayResponseOutput) with field(s):
    ///   - [`response_type(Option<GatewayResponseType>)`](crate::output::GetGatewayResponseOutput::response_type): <p>The response type of the associated <code>GatewayResponse</code>.</p>
    ///   - [`status_code(Option<String>)`](crate::output::GetGatewayResponseOutput::status_code): <p>The HTTP status code for this <code>GatewayResponse</code>.</p>
    ///   - [`response_parameters(Option<HashMap<String, String>>)`](crate::output::GetGatewayResponseOutput::response_parameters): <p>Response parameters (paths, query strings and headers) of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
    ///   - [`response_templates(Option<HashMap<String, String>>)`](crate::output::GetGatewayResponseOutput::response_templates): <p>Response templates of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
    ///   - [`default_response(bool)`](crate::output::GetGatewayResponseOutput::default_response): <p>A Boolean flag to indicate whether this <code>GatewayResponse</code> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    /// - On failure, responds with [`SdkError<GetGatewayResponseError>`](crate::error::GetGatewayResponseError)
    pub fn get_gateway_response(&self) -> fluent_builders::GetGatewayResponse<C, M, R> {
        fluent_builders::GetGatewayResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGatewayResponses`](crate::client::fluent_builders::GetGatewayResponses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetGatewayResponses::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetGatewayResponses::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetGatewayResponses::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetGatewayResponses::set_position): <p>The current pagination position in the paged result set. The <code>GatewayResponse</code> collection does not support pagination and the position does not apply here.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetGatewayResponses::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetGatewayResponses::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The <code>GatewayResponses</code> collection does not support pagination and the limit does not apply here.</p>
    /// - On success, responds with [`GetGatewayResponsesOutput`](crate::output::GetGatewayResponsesOutput) with field(s):
    ///   - [`items(Option<Vec<GatewayResponse>>)`](crate::output::GetGatewayResponsesOutput::items): <p>Returns the entire collection, because of no pagination support.</p>
    ///   - [`position(Option<String>)`](crate::output::GetGatewayResponsesOutput::position): <p>The current pagination position in the paged result set. The <code>GatewayResponse</code> collection does not support pagination and the position does not apply here.</p>
    /// - On failure, responds with [`SdkError<GetGatewayResponsesError>`](crate::error::GetGatewayResponsesError)
    pub fn get_gateway_responses(&self) -> fluent_builders::GetGatewayResponses<C, M, R> {
        fluent_builders::GetGatewayResponses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntegration`](crate::client::fluent_builders::GetIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegration::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetIntegration::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegration::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetIntegration::set_resource_id): <p>[Required] Specifies a get integration request's resource identifier</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::GetIntegration::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::GetIntegration::set_http_method): <p>[Required] Specifies a get integration request's HTTP method.</p>
    /// - On success, responds with [`GetIntegrationOutput`](crate::output::GetIntegrationOutput) with field(s):
    ///   - [`r#type(Option<IntegrationType>)`](crate::output::GetIntegrationOutput::type): <p>Specifies an API method integration type. The valid value is one of the following:</p>  <ul>   <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>   <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>   <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>   <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>   <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>  </ul>  <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <code>VpcLink</code> to connect API Gateway to a network load balancer of a VPC.</p>
    ///   - [`http_method(Option<String>)`](crate::output::GetIntegrationOutput::http_method): <p>Specifies the integration's HTTP method type.</p>
    ///   - [`uri(Option<String>)`](crate::output::GetIntegrationOutput::uri): <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>  <ul>   <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p> </li>   <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p> </li> </ul>
    ///   - [`connection_type(Option<ConnectionType>)`](crate::output::GetIntegrationOutput::connection_type): <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::GetIntegrationOutput::connection_id): <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <code>VpcLink</code> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    ///   - [`credentials(Option<String>)`](crate::output::GetIntegrationOutput::credentials): <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    ///   - [`request_parameters(Option<HashMap<String, String>>)`](crate::output::GetIntegrationOutput::request_parameters): <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    ///   - [`request_templates(Option<HashMap<String, String>>)`](crate::output::GetIntegrationOutput::request_templates): <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    ///   - [`passthrough_behavior(Option<String>)`](crate::output::GetIntegrationOutput::passthrough_behavior): <div>   <p> Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following: </p>   <ul>    <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li>    <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li>    <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li>   </ul>  </div>
    ///   - [`content_handling(Option<ContentHandlingStrategy>)`](crate::output::GetIntegrationOutput::content_handling): <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>  <ul>   <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>   <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>  </ul>  <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    ///   - [`timeout_in_millis(i32)`](crate::output::GetIntegrationOutput::timeout_in_millis): <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    ///   - [`cache_namespace(Option<String>)`](crate::output::GetIntegrationOutput::cache_namespace): <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    ///   - [`cache_key_parameters(Option<Vec<String>>)`](crate::output::GetIntegrationOutput::cache_key_parameters): <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <code>Method</code> <code>requestParameters</code>.</p>
    ///   - [`integration_responses(Option<HashMap<String, IntegrationResponse>>)`](crate::output::GetIntegrationOutput::integration_responses): <p>Specifies the integration's responses.</p>  <div class="remarks">   <p></p>   <h4>Example: Get integration responses of a method</h4>   <h5>Request</h5>   <p></p>   <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre>   <h5>Response</h5>   <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>   <pre><code>{   "_links": {     "curies": {       "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",       "name": "integrationresponse",       "templated": true     },     "self": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",       "title": "200"     },     "integrationresponse:delete": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"     },     "integrationresponse:update": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"     }   },   "responseParameters": {     "method.response.header.Content-Type": "'application/xml'"   },   "responseTemplates": {     "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"   },   "statusCode": "200" }</code></pre>   <p></p>  </div>  <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>  </div>
    ///   - [`tls_config(Option<TlsConfig>)`](crate::output::GetIntegrationOutput::tls_config): <p>Specifies the TLS configuration for an integration.</p>
    /// - On failure, responds with [`SdkError<GetIntegrationError>`](crate::error::GetIntegrationError)
    pub fn get_integration(&self) -> fluent_builders::GetIntegration<C, M, R> {
        fluent_builders::GetIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntegrationResponse`](crate::client::fluent_builders::GetIntegrationResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponse::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponse::set_resource_id): <p>[Required] Specifies a get integration response request's resource identifier.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponse::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponse::set_http_method): <p>[Required] Specifies a get integration response request's HTTP method.</p>
    ///   - [`status_code(impl Into<String>)`](crate::client::fluent_builders::GetIntegrationResponse::status_code) / [`set_status_code(Option<String>)`](crate::client::fluent_builders::GetIntegrationResponse::set_status_code): <p>[Required] Specifies a get integration response request's status code.</p>
    /// - On success, responds with [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput) with field(s):
    ///   - [`status_code(Option<String>)`](crate::output::GetIntegrationResponseOutput::status_code): <p>Specifies the status code that is used to map the integration response to an existing <code>MethodResponse</code>.</p>
    ///   - [`selection_pattern(Option<String>)`](crate::output::GetIntegrationResponseOutput::selection_pattern): <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    ///   - [`response_parameters(Option<HashMap<String, String>>)`](crate::output::GetIntegrationResponseOutput::response_parameters): <p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    ///   - [`response_templates(Option<HashMap<String, String>>)`](crate::output::GetIntegrationResponseOutput::response_templates): <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    ///   - [`content_handling(Option<ContentHandlingStrategy>)`](crate::output::GetIntegrationResponseOutput::content_handling): <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>  <ul>   <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>   <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>  </ul>  <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    /// - On failure, responds with [`SdkError<GetIntegrationResponseError>`](crate::error::GetIntegrationResponseError)
    pub fn get_integration_response(&self) -> fluent_builders::GetIntegrationResponse<C, M, R> {
        fluent_builders::GetIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMethod`](crate::client::fluent_builders::GetMethod) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetMethod::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetMethod::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetMethod::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetMethod::set_resource_id): <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::GetMethod::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::GetMethod::set_http_method): <p>[Required] Specifies the method request's HTTP method type.</p>
    /// - On success, responds with [`GetMethodOutput`](crate::output::GetMethodOutput) with field(s):
    ///   - [`http_method(Option<String>)`](crate::output::GetMethodOutput::http_method): <p>The method's HTTP verb.</p>
    ///   - [`authorization_type(Option<String>)`](crate::output::GetMethodOutput::authorization_type): <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    ///   - [`authorizer_id(Option<String>)`](crate::output::GetMethodOutput::authorizer_id): <p>The identifier of an <code>Authorizer</code> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    ///   - [`api_key_required(Option<bool>)`](crate::output::GetMethodOutput::api_key_required): <p>A boolean flag specifying whether a valid <code>ApiKey</code> is required to invoke this method.</p>
    ///   - [`request_validator_id(Option<String>)`](crate::output::GetMethodOutput::request_validator_id): <p>The identifier of a <code>RequestValidator</code> for request validation.</p>
    ///   - [`operation_name(Option<String>)`](crate::output::GetMethodOutput::operation_name): <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    ///   - [`request_parameters(Option<HashMap<String, bool>>)`](crate::output::GetMethodOutput::request_parameters): <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <code>Integration</code> to be mapped to integration request parameters or templates.</p>
    ///   - [`request_models(Option<HashMap<String, String>>)`](crate::output::GetMethodOutput::request_models): <p>A key-value map specifying data schemas, represented by <code>Model</code> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    ///   - [`method_responses(Option<HashMap<String, MethodResponse>>)`](crate::output::GetMethodOutput::method_responses): <p>Gets a method response associated with a given HTTP status code. </p>  <div class="remarks">   <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <code>MethodResponse</code> resource that specifies the response returned to the caller from the back end through the integration response.</p>   <h4>Example: Get a 200 OK response of a GET method</h4>   <h5>Request</h5>   <p></p>   <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T215008Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>   <h5>Response</h5>   <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>   <pre><code>{   "_links": {     "curies": {       "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",       "name": "methodresponse",       "templated": true     },     "self": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",       "title": "200"     },     "methodresponse:delete": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"     },     "methodresponse:update": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"     }   },   "responseModels": {     "application/json": "Empty"   },   "responseParameters": {     "method.response.header.operator": false,     "method.response.header.operand_2": false,     "method.response.header.operand_1": false   },   "statusCode": "200" }</code></pre>   <p></p>  </div>  <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>  </div>
    ///   - [`method_integration(Option<Integration>)`](crate::output::GetMethodOutput::method_integration): <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>  <div class="remarks">   <p></p>   <h4>Example: </h4>   <h5>Request</h5>   <p></p>   <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T213210Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>   <h5>Response</h5>   <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>   <pre><code>{   "_links": {     "curies": [       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",         "name": "integration",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",         "name": "integrationresponse",         "templated": true       }     ],     "self": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"     },     "integration:delete": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"     },     "integration:responses": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",       "name": "200",       "title": "200"     },     "integration:update": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"     },     "integrationresponse:put": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",       "templated": true     }   },   "cacheKeyParameters": [],   "cacheNamespace": "0cjtch",   "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",   "httpMethod": "POST",   "passthroughBehavior": "WHEN_NO_MATCH",   "requestTemplates": {     "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"   },   "type": "AWS",   "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",   "_embedded": {     "integration:responses": {       "_links": {         "self": {           "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",           "name": "200",           "title": "200"         },         "integrationresponse:delete": {           "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"         },         "integrationresponse:update": {           "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"         }       },       "responseParameters": {         "method.response.header.operator": "integration.response.body.op",         "method.response.header.operand_2": "integration.response.body.b",         "method.response.header.operand_1": "integration.response.body.a"       },       "responseTemplates": {         "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op =&gt; $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"       },       "selectionPattern": "",       "statusCode": "200"     }   } }</code></pre>   <p></p>  </div>  <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>  </div>
    ///   - [`authorization_scopes(Option<Vec<String>>)`](crate::output::GetMethodOutput::authorization_scopes): <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    /// - On failure, responds with [`SdkError<GetMethodError>`](crate::error::GetMethodError)
    pub fn get_method(&self) -> fluent_builders::GetMethod<C, M, R> {
        fluent_builders::GetMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMethodResponse`](crate::client::fluent_builders::GetMethodResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetMethodResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetMethodResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetMethodResponse::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetMethodResponse::set_resource_id): <p>[Required] The <code>Resource</code> identifier for the <code>MethodResponse</code> resource.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::GetMethodResponse::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::GetMethodResponse::set_http_method): <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
    ///   - [`status_code(impl Into<String>)`](crate::client::fluent_builders::GetMethodResponse::status_code) / [`set_status_code(Option<String>)`](crate::client::fluent_builders::GetMethodResponse::set_status_code): <p>[Required] The status code for the <code>MethodResponse</code> resource.</p>
    /// - On success, responds with [`GetMethodResponseOutput`](crate::output::GetMethodResponseOutput) with field(s):
    ///   - [`status_code(Option<String>)`](crate::output::GetMethodResponseOutput::status_code): <p>The method response's status code.</p>
    ///   - [`response_parameters(Option<HashMap<String, bool>>)`](crate::output::GetMethodResponseOutput::response_parameters): <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <code>IntegrationResponse</code>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    ///   - [`response_models(Option<HashMap<String, String>>)`](crate::output::GetMethodResponseOutput::response_models): <p>Specifies the <code>Model</code> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <code>Model</code> name as the value.</p>
    /// - On failure, responds with [`SdkError<GetMethodResponseError>`](crate::error::GetMethodResponseError)
    pub fn get_method_response(&self) -> fluent_builders::GetMethodResponse<C, M, R> {
        fluent_builders::GetMethodResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetModel`](crate::client::fluent_builders::GetModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetModel::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetModel::set_rest_api_id): <p>[Required] The <code>RestApi</code> identifier under which the <code>Model</code> exists.</p>
    ///   - [`model_name(impl Into<String>)`](crate::client::fluent_builders::GetModel::model_name) / [`set_model_name(Option<String>)`](crate::client::fluent_builders::GetModel::set_model_name): <p>[Required] The name of the model as an identifier.</p>
    ///   - [`flatten(bool)`](crate::client::fluent_builders::GetModel::flatten) / [`set_flatten(bool)`](crate::client::fluent_builders::GetModel::set_flatten): <p>A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.</p>
    /// - On success, responds with [`GetModelOutput`](crate::output::GetModelOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetModelOutput::id): <p>The identifier for the model resource.</p>
    ///   - [`name(Option<String>)`](crate::output::GetModelOutput::name): <p>The name of the model. Must be an alphanumeric string.</p>
    ///   - [`description(Option<String>)`](crate::output::GetModelOutput::description): <p>The description of the model.</p>
    ///   - [`schema(Option<String>)`](crate::output::GetModelOutput::schema): <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
    ///   - [`content_type(Option<String>)`](crate::output::GetModelOutput::content_type): <p>The content-type for the model.</p>
    /// - On failure, responds with [`SdkError<GetModelError>`](crate::error::GetModelError)
    pub fn get_model(&self) -> fluent_builders::GetModel<C, M, R> {
        fluent_builders::GetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetModels`](crate::client::fluent_builders::GetModels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetModels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetModels::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetModels::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetModels::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetModels::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetModels::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetModels::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetModelsOutput`](crate::output::GetModelsOutput) with field(s):
    ///   - [`items(Option<Vec<Model>>)`](crate::output::GetModelsOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetModelsOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetModelsError>`](crate::error::GetModelsError)
    pub fn get_models(&self) -> fluent_builders::GetModels<C, M, R> {
        fluent_builders::GetModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetModelTemplate`](crate::client::fluent_builders::GetModelTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetModelTemplate::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetModelTemplate::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`model_name(impl Into<String>)`](crate::client::fluent_builders::GetModelTemplate::model_name) / [`set_model_name(Option<String>)`](crate::client::fluent_builders::GetModelTemplate::set_model_name): <p>[Required] The name of the model for which to generate a template.</p>
    /// - On success, responds with [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput) with field(s):
    ///   - [`value(Option<String>)`](crate::output::GetModelTemplateOutput::value): <p>The Apache <a target="_blank" href="https://velocity.apache.org/engine/devel/vtl-reference.html">Velocity Template Language (VTL)</a> template content used for the template resource.</p>
    /// - On failure, responds with [`SdkError<GetModelTemplateError>`](crate::error::GetModelTemplateError)
    pub fn get_model_template(&self) -> fluent_builders::GetModelTemplate<C, M, R> {
        fluent_builders::GetModelTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRequestValidator`](crate::client::fluent_builders::GetRequestValidator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetRequestValidator::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetRequestValidator::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`request_validator_id(impl Into<String>)`](crate::client::fluent_builders::GetRequestValidator::request_validator_id) / [`set_request_validator_id(Option<String>)`](crate::client::fluent_builders::GetRequestValidator::set_request_validator_id): <p>[Required] The identifier of the <code>RequestValidator</code> to be retrieved.</p>
    /// - On success, responds with [`GetRequestValidatorOutput`](crate::output::GetRequestValidatorOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetRequestValidatorOutput::id): <p>The identifier of this <code>RequestValidator</code>.</p>
    ///   - [`name(Option<String>)`](crate::output::GetRequestValidatorOutput::name): <p>The name of this <code>RequestValidator</code></p>
    ///   - [`validate_request_body(bool)`](crate::output::GetRequestValidatorOutput::validate_request_body): <p>A Boolean flag to indicate whether to validate a request body according to the configured <code>Model</code> schema.</p>
    ///   - [`validate_request_parameters(bool)`](crate::output::GetRequestValidatorOutput::validate_request_parameters): <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
    /// - On failure, responds with [`SdkError<GetRequestValidatorError>`](crate::error::GetRequestValidatorError)
    pub fn get_request_validator(&self) -> fluent_builders::GetRequestValidator<C, M, R> {
        fluent_builders::GetRequestValidator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRequestValidators`](crate::client::fluent_builders::GetRequestValidators) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetRequestValidators::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetRequestValidators::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetRequestValidators::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetRequestValidators::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetRequestValidators::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetRequestValidators::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetRequestValidatorsOutput`](crate::output::GetRequestValidatorsOutput) with field(s):
    ///   - [`items(Option<Vec<RequestValidator>>)`](crate::output::GetRequestValidatorsOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetRequestValidatorsOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetRequestValidatorsError>`](crate::error::GetRequestValidatorsError)
    pub fn get_request_validators(&self) -> fluent_builders::GetRequestValidators<C, M, R> {
        fluent_builders::GetRequestValidators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResource`](crate::client::fluent_builders::GetResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetResource::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetResource::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetResource::set_resource_id): <p>[Required] The identifier for the <code>Resource</code> resource.</p>
    ///   - [`embed(Vec<String>)`](crate::client::fluent_builders::GetResource::embed) / [`set_embed(Option<Vec<String>>)`](crate::client::fluent_builders::GetResource::set_embed): <p>A query parameter to retrieve the specified resources embedded in the returned <code>Resource</code> representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <code>Method</code> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.</p>
    /// - On success, responds with [`GetResourceOutput`](crate::output::GetResourceOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetResourceOutput::id): <p>The resource's identifier.</p>
    ///   - [`parent_id(Option<String>)`](crate::output::GetResourceOutput::parent_id): <p>The parent resource's identifier.</p>
    ///   - [`path_part(Option<String>)`](crate::output::GetResourceOutput::path_part): <p>The last path segment for this resource.</p>
    ///   - [`path(Option<String>)`](crate::output::GetResourceOutput::path): <p>The full path for this resource.</p>
    ///   - [`resource_methods(Option<HashMap<String, Method>>)`](crate::output::GetResourceOutput::resource_methods): <p>Gets an API resource's method of a given HTTP verb.</p>  <div class="remarks">   <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>   <h4>Example: Get the GET method of an API resource</h4>   <h5>Request</h5>   <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20170223T031827Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>   <h5>Response</h5>   <pre><code>{   "_links": {     "curies": [       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",         "name": "integration",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",         "name": "integrationresponse",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",         "name": "method",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",         "name": "methodresponse",         "templated": true       }     ],     "self": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",       "name": "GET",       "title": "GET"     },     "integration:put": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"     },     "method:delete": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"     },     "method:integration": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"     },     "method:responses": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",       "name": "200",       "title": "200"     },     "method:update": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"     },     "methodresponse:put": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",       "templated": true     }   },   "apiKeyRequired": false,   "authorizationType": "NONE",   "httpMethod": "GET",   "_embedded": {     "method:integration": {       "_links": {         "self": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"         },         "integration:delete": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"         },         "integration:responses": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",           "name": "200",           "title": "200"         },         "integration:update": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"         },         "integrationresponse:put": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",           "templated": true         }       },       "cacheKeyParameters": [],       "cacheNamespace": "3kzxbg5sa2",       "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",       "httpMethod": "POST",       "passthroughBehavior": "WHEN_NO_MATCH",       "requestParameters": {         "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"       },       "requestTemplates": {         "application/json": "{\n}"       },       "type": "AWS",       "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",       "_embedded": {         "integration:responses": {           "_links": {             "self": {               "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",               "name": "200",               "title": "200"             },             "integrationresponse:delete": {               "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"             },             "integrationresponse:update": {               "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"             }           },           "responseParameters": {             "method.response.header.Content-Type": "'application/xml'"           },           "responseTemplates": {             "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"           },           "statusCode": "200"         }       }     },     "method:responses": {       "_links": {         "self": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",           "name": "200",           "title": "200"         },         "methodresponse:delete": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"         },         "methodresponse:update": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"         }       },       "responseModels": {         "application/json": "Empty"       },       "responseParameters": {         "method.response.header.Content-Type": false       },       "statusCode": "200"     }   } }</code></pre>   <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>  </div>  <div class="seeAlso">  </div>
    /// - On failure, responds with [`SdkError<GetResourceError>`](crate::error::GetResourceError)
    pub fn get_resource(&self) -> fluent_builders::GetResource<C, M, R> {
        fluent_builders::GetResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResources`](crate::client::fluent_builders::GetResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetResources::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetResources::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetResources::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetResources::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetResources::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetResources::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    ///   - [`embed(Vec<String>)`](crate::client::fluent_builders::GetResources::embed) / [`set_embed(Option<Vec<String>>)`](crate::client::fluent_builders::GetResources::set_embed): <p>A query parameter used to retrieve the specified resources embedded in the returned <code>Resources</code> resource in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <code>Method</code> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.</p>
    /// - On success, responds with [`GetResourcesOutput`](crate::output::GetResourcesOutput) with field(s):
    ///   - [`items(Option<Vec<Resource>>)`](crate::output::GetResourcesOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetResourcesOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetResourcesError>`](crate::error::GetResourcesError)
    pub fn get_resources(&self) -> fluent_builders::GetResources<C, M, R> {
        fluent_builders::GetResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRestApi`](crate::client::fluent_builders::GetRestApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetRestApi::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetRestApi::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    /// - On success, responds with [`GetRestApiOutput`](crate::output::GetRestApiOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetRestApiOutput::id): <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    ///   - [`name(Option<String>)`](crate::output::GetRestApiOutput::name): <p>The API's name.</p>
    ///   - [`description(Option<String>)`](crate::output::GetRestApiOutput::description): <p>The API's description.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetRestApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`version(Option<String>)`](crate::output::GetRestApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::GetRestApiOutput::warnings): <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    ///   - [`binary_media_types(Option<Vec<String>>)`](crate::output::GetRestApiOutput::binary_media_types): <p>The list of binary media types supported by the <code>RestApi</code>. By default, the <code>RestApi</code> supports only UTF-8-encoded text payloads.</p>
    ///   - [`minimum_compression_size(Option<i32>)`](crate::output::GetRestApiOutput::minimum_compression_size): <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    ///   - [`api_key_source(Option<ApiKeySourceType>)`](crate::output::GetRestApiOutput::api_key_source): <p>The source of the API key for metering requests according to a usage plan. Valid values are: </p> <ul>  <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li>  <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li> </ul> <p></p>
    ///   - [`endpoint_configuration(Option<EndpointConfiguration>)`](crate::output::GetRestApiOutput::endpoint_configuration): <p>The endpoint configuration of this <code>RestApi</code> showing the endpoint types of the API.</p>
    ///   - [`policy(Option<String>)`](crate::output::GetRestApiOutput::policy): <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <code>Method</code> configuration.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetRestApiOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::GetRestApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    /// - On failure, responds with [`SdkError<GetRestApiError>`](crate::error::GetRestApiError)
    pub fn get_rest_api(&self) -> fluent_builders::GetRestApi<C, M, R> {
        fluent_builders::GetRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRestApis`](crate::client::fluent_builders::GetRestApis) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetRestApis::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetRestApis::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetRestApis::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetRestApis::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetRestApis::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetRestApisOutput`](crate::output::GetRestApisOutput) with field(s):
    ///   - [`items(Option<Vec<RestApi>>)`](crate::output::GetRestApisOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetRestApisOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetRestApisError>`](crate::error::GetRestApisError)
    pub fn get_rest_apis(&self) -> fluent_builders::GetRestApis<C, M, R> {
        fluent_builders::GetRestApis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSdk`](crate::client::fluent_builders::GetSdk) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetSdk::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetSdk::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::GetSdk::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::GetSdk::set_stage_name): <p>[Required] The name of the <code>Stage</code> that the SDK will use.</p>
    ///   - [`sdk_type(impl Into<String>)`](crate::client::fluent_builders::GetSdk::sdk_type) / [`set_sdk_type(Option<String>)`](crate::client::fluent_builders::GetSdk::set_sdk_type): <p>[Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code> are supported.</p>
    ///   - [`parameters(HashMap<String, String>)`](crate::client::fluent_builders::GetSdk::parameters) / [`set_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetSdk::set_parameters): <p>A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. </p>
    /// - On success, responds with [`GetSdkOutput`](crate::output::GetSdkOutput) with field(s):
    ///   - [`content_type(Option<String>)`](crate::output::GetSdkOutput::content_type): <p>The content-type header value in the HTTP response.</p>
    ///   - [`content_disposition(Option<String>)`](crate::output::GetSdkOutput::content_disposition): <p>The content-disposition header value in the HTTP response.</p>
    ///   - [`body(Option<Blob>)`](crate::output::GetSdkOutput::body): <p>The binary blob response to <code>GetSdk</code>, which contains the generated SDK.</p>
    /// - On failure, responds with [`SdkError<GetSdkError>`](crate::error::GetSdkError)
    pub fn get_sdk(&self) -> fluent_builders::GetSdk<C, M, R> {
        fluent_builders::GetSdk::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSdkType`](crate::client::fluent_builders::GetSdkType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetSdkType::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetSdkType::set_id): <p>[Required] The identifier of the queried <code>SdkType</code> instance.</p>
    /// - On success, responds with [`GetSdkTypeOutput`](crate::output::GetSdkTypeOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetSdkTypeOutput::id): <p>The identifier of an <code>SdkType</code> instance.</p>
    ///   - [`friendly_name(Option<String>)`](crate::output::GetSdkTypeOutput::friendly_name): <p>The user-friendly name of an <code>SdkType</code> instance.</p>
    ///   - [`description(Option<String>)`](crate::output::GetSdkTypeOutput::description): <p>The description of an <code>SdkType</code>.</p>
    ///   - [`configuration_properties(Option<Vec<SdkConfigurationProperty>>)`](crate::output::GetSdkTypeOutput::configuration_properties): <p>A list of configuration properties of an <code>SdkType</code>.</p>
    /// - On failure, responds with [`SdkError<GetSdkTypeError>`](crate::error::GetSdkTypeError)
    pub fn get_sdk_type(&self) -> fluent_builders::GetSdkType<C, M, R> {
        fluent_builders::GetSdkType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSdkTypes`](crate::client::fluent_builders::GetSdkTypes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetSdkTypes::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetSdkTypes::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetSdkTypes::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetSdkTypes::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetSdkTypesOutput`](crate::output::GetSdkTypesOutput) with field(s):
    ///   - [`items(Option<Vec<SdkType>>)`](crate::output::GetSdkTypesOutput::items): <p>The current page of elements from this collection.</p>
    /// - On failure, responds with [`SdkError<GetSdkTypesError>`](crate::error::GetSdkTypesError)
    pub fn get_sdk_types(&self) -> fluent_builders::GetSdkTypes<C, M, R> {
        fluent_builders::GetSdkTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStage`](crate::client::fluent_builders::GetStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetStage::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetStage::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::GetStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::GetStage::set_stage_name): <p>[Required] The name of the <code>Stage</code> resource to get information about.</p>
    /// - On success, responds with [`GetStageOutput`](crate::output::GetStageOutput) with field(s):
    ///   - [`deployment_id(Option<String>)`](crate::output::GetStageOutput::deployment_id): <p>The identifier of the <code>Deployment</code> that the stage points to.</p>
    ///   - [`client_certificate_id(Option<String>)`](crate::output::GetStageOutput::client_certificate_id): <p>The identifier of a client certificate for an API stage.</p>
    ///   - [`stage_name(Option<String>)`](crate::output::GetStageOutput::stage_name): <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    ///   - [`description(Option<String>)`](crate::output::GetStageOutput::description): <p>The stage's description.</p>
    ///   - [`cache_cluster_enabled(bool)`](crate::output::GetStageOutput::cache_cluster_enabled): <p>Specifies whether a cache cluster is enabled for the stage.</p>
    ///   - [`cache_cluster_size(Option<CacheClusterSize>)`](crate::output::GetStageOutput::cache_cluster_size): <p>The size of the cache cluster for the stage, if enabled.</p>
    ///   - [`cache_cluster_status(Option<CacheClusterStatus>)`](crate::output::GetStageOutput::cache_cluster_status): <p>The status of the cache cluster for the stage, if enabled.</p>
    ///   - [`method_settings(Option<HashMap<String, MethodSetting>>)`](crate::output::GetStageOutput::method_settings): <p>A map that defines the method settings for a <code>Stage</code> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage. <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
    ///   - [`variables(Option<HashMap<String, String>>)`](crate::output::GetStageOutput::variables): <p>A map that defines the stage variables for a <code>Stage</code> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>
    ///   - [`documentation_version(Option<String>)`](crate::output::GetStageOutput::documentation_version): <p>The version of the associated API documentation.</p>
    ///   - [`access_log_settings(Option<AccessLogSettings>)`](crate::output::GetStageOutput::access_log_settings): <p>Settings for logging access in this stage.</p>
    ///   - [`canary_settings(Option<CanarySettings>)`](crate::output::GetStageOutput::canary_settings): <p>Settings for the canary deployment in this stage.</p>
    ///   - [`tracing_enabled(bool)`](crate::output::GetStageOutput::tracing_enabled): <p>Specifies whether active tracing with X-ray is enabled for the <code>Stage</code>.</p>
    ///   - [`web_acl_arn(Option<String>)`](crate::output::GetStageOutput::web_acl_arn): <p>The ARN of the WebAcl associated with the <code>Stage</code>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetStageOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetStageOutput::created_date): <p>The timestamp when the stage was created.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::GetStageOutput::last_updated_date): <p>The timestamp when the stage last updated.</p>
    /// - On failure, responds with [`SdkError<GetStageError>`](crate::error::GetStageError)
    pub fn get_stage(&self) -> fluent_builders::GetStage<C, M, R> {
        fluent_builders::GetStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStages`](crate::client::fluent_builders::GetStages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::GetStages::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::GetStages::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::GetStages::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::GetStages::set_deployment_id): <p>The stages' deployment identifiers.</p>
    /// - On success, responds with [`GetStagesOutput`](crate::output::GetStagesOutput) with field(s):
    ///   - [`item(Option<Vec<Stage>>)`](crate::output::GetStagesOutput::item): <p>The current page of elements from this collection.</p>
    /// - On failure, responds with [`SdkError<GetStagesError>`](crate::error::GetStagesError)
    pub fn get_stages(&self) -> fluent_builders::GetStages<C, M, R> {
        fluent_builders::GetStages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTags`](crate::client::fluent_builders::GetTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetTags::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetTags::set_resource_arn): <p>[Required] The ARN of a resource that can be tagged.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetTags::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetTags::set_position): <p>(Not currently supported) The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetTags::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetTags::set_limit): <p>(Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetTagsOutput`](crate::output::GetTagsOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetTagsOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<GetTagsError>`](crate::error::GetTagsError)
    pub fn get_tags(&self) -> fluent_builders::GetTags<C, M, R> {
        fluent_builders::GetTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUsage`](crate::client::fluent_builders::GetUsage) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetUsage::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_plan_id(impl Into<String>)`](crate::client::fluent_builders::GetUsage::usage_plan_id) / [`set_usage_plan_id(Option<String>)`](crate::client::fluent_builders::GetUsage::set_usage_plan_id): <p>[Required] The Id of the usage plan associated with the usage data.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GetUsage::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GetUsage::set_key_id): <p>The Id of the API key associated with the resultant usage data.</p>
    ///   - [`start_date(impl Into<String>)`](crate::client::fluent_builders::GetUsage::start_date) / [`set_start_date(Option<String>)`](crate::client::fluent_builders::GetUsage::set_start_date): <p>[Required] The starting date (e.g., 2016-01-01) of the usage data.</p>
    ///   - [`end_date(impl Into<String>)`](crate::client::fluent_builders::GetUsage::end_date) / [`set_end_date(Option<String>)`](crate::client::fluent_builders::GetUsage::set_end_date): <p>[Required] The ending date (e.g., 2016-12-31) of the usage data.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetUsage::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetUsage::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetUsage::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetUsage::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetUsageOutput`](crate::output::GetUsageOutput) with field(s):
    ///   - [`usage_plan_id(Option<String>)`](crate::output::GetUsageOutput::usage_plan_id): <p>The plan Id associated with this usage data.</p>
    ///   - [`start_date(Option<String>)`](crate::output::GetUsageOutput::start_date): <p>The starting date of the usage data.</p>
    ///   - [`end_date(Option<String>)`](crate::output::GetUsageOutput::end_date): <p>The ending date of the usage data.</p>
    ///   - [`items(Option<HashMap<String, Vec<Vec<i64>>>>)`](crate::output::GetUsageOutput::items): <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
    ///   - [`position(Option<String>)`](crate::output::GetUsageOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetUsageError>`](crate::error::GetUsageError)
    pub fn get_usage(&self) -> fluent_builders::GetUsage<C, M, R> {
        fluent_builders::GetUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUsagePlan`](crate::client::fluent_builders::GetUsagePlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_plan_id(impl Into<String>)`](crate::client::fluent_builders::GetUsagePlan::usage_plan_id) / [`set_usage_plan_id(Option<String>)`](crate::client::fluent_builders::GetUsagePlan::set_usage_plan_id): <p>[Required] The identifier of the <code>UsagePlan</code> resource to be retrieved.</p>
    /// - On success, responds with [`GetUsagePlanOutput`](crate::output::GetUsagePlanOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetUsagePlanOutput::id): <p>The identifier of a <code>UsagePlan</code> resource.</p>
    ///   - [`name(Option<String>)`](crate::output::GetUsagePlanOutput::name): <p>The name of a usage plan.</p>
    ///   - [`description(Option<String>)`](crate::output::GetUsagePlanOutput::description): <p>The description of a usage plan.</p>
    ///   - [`api_stages(Option<Vec<ApiStage>>)`](crate::output::GetUsagePlanOutput::api_stages): <p>The associated API stages of a usage plan.</p>
    ///   - [`throttle(Option<ThrottleSettings>)`](crate::output::GetUsagePlanOutput::throttle): <p>Map containing method level throttling information for API stage in a usage plan.</p>
    ///   - [`quota(Option<QuotaSettings>)`](crate::output::GetUsagePlanOutput::quota): <p>The target maximum number of permitted requests per a given unit time interval.</p>
    ///   - [`product_code(Option<String>)`](crate::output::GetUsagePlanOutput::product_code): <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetUsagePlanOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<GetUsagePlanError>`](crate::error::GetUsagePlanError)
    pub fn get_usage_plan(&self) -> fluent_builders::GetUsagePlan<C, M, R> {
        fluent_builders::GetUsagePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUsagePlanKey`](crate::client::fluent_builders::GetUsagePlanKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_plan_id(impl Into<String>)`](crate::client::fluent_builders::GetUsagePlanKey::usage_plan_id) / [`set_usage_plan_id(Option<String>)`](crate::client::fluent_builders::GetUsagePlanKey::set_usage_plan_id): <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-retrieved <code>UsagePlanKey</code> resource representing a plan customer.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GetUsagePlanKey::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GetUsagePlanKey::set_key_id): <p>[Required] The key Id of the to-be-retrieved <code>UsagePlanKey</code> resource representing a plan customer.</p>
    /// - On success, responds with [`GetUsagePlanKeyOutput`](crate::output::GetUsagePlanKeyOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetUsagePlanKeyOutput::id): <p>The Id of a usage plan key.</p>
    ///   - [`r#type(Option<String>)`](crate::output::GetUsagePlanKeyOutput::type): <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
    ///   - [`value(Option<String>)`](crate::output::GetUsagePlanKeyOutput::value): <p>The value of a usage plan key.</p>
    ///   - [`name(Option<String>)`](crate::output::GetUsagePlanKeyOutput::name): <p>The name of a usage plan key.</p>
    /// - On failure, responds with [`SdkError<GetUsagePlanKeyError>`](crate::error::GetUsagePlanKeyError)
    pub fn get_usage_plan_key(&self) -> fluent_builders::GetUsagePlanKey<C, M, R> {
        fluent_builders::GetUsagePlanKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUsagePlanKeys`](crate::client::fluent_builders::GetUsagePlanKeys) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetUsagePlanKeys::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_plan_id(impl Into<String>)`](crate::client::fluent_builders::GetUsagePlanKeys::usage_plan_id) / [`set_usage_plan_id(Option<String>)`](crate::client::fluent_builders::GetUsagePlanKeys::set_usage_plan_id): <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-retrieved <code>UsagePlanKey</code> resource representing a plan customer.</p>
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetUsagePlanKeys::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetUsagePlanKeys::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetUsagePlanKeys::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetUsagePlanKeys::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    ///   - [`name_query(impl Into<String>)`](crate::client::fluent_builders::GetUsagePlanKeys::name_query) / [`set_name_query(Option<String>)`](crate::client::fluent_builders::GetUsagePlanKeys::set_name_query): <p>A query parameter specifying the name of the to-be-returned usage plan keys.</p>
    /// - On success, responds with [`GetUsagePlanKeysOutput`](crate::output::GetUsagePlanKeysOutput) with field(s):
    ///   - [`items(Option<Vec<UsagePlanKey>>)`](crate::output::GetUsagePlanKeysOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetUsagePlanKeysOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetUsagePlanKeysError>`](crate::error::GetUsagePlanKeysError)
    pub fn get_usage_plan_keys(&self) -> fluent_builders::GetUsagePlanKeys<C, M, R> {
        fluent_builders::GetUsagePlanKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUsagePlans`](crate::client::fluent_builders::GetUsagePlans) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetUsagePlans::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetUsagePlans::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetUsagePlans::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GetUsagePlans::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GetUsagePlans::set_key_id): <p>The identifier of the API key associated with the usage plans.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetUsagePlans::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetUsagePlans::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetUsagePlansOutput`](crate::output::GetUsagePlansOutput) with field(s):
    ///   - [`items(Option<Vec<UsagePlan>>)`](crate::output::GetUsagePlansOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetUsagePlansOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetUsagePlansError>`](crate::error::GetUsagePlansError)
    pub fn get_usage_plans(&self) -> fluent_builders::GetUsagePlans<C, M, R> {
        fluent_builders::GetUsagePlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVpcLink`](crate::client::fluent_builders::GetVpcLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_link_id(impl Into<String>)`](crate::client::fluent_builders::GetVpcLink::vpc_link_id) / [`set_vpc_link_id(Option<String>)`](crate::client::fluent_builders::GetVpcLink::set_vpc_link_id): <p>[Required] The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
    /// - On success, responds with [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetVpcLinkOutput::id): <p>The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
    ///   - [`name(Option<String>)`](crate::output::GetVpcLinkOutput::name): <p>The name used to label and identify the VPC link.</p>
    ///   - [`description(Option<String>)`](crate::output::GetVpcLinkOutput::description): <p>The description of the VPC link.</p>
    ///   - [`target_arns(Option<Vec<String>>)`](crate::output::GetVpcLinkOutput::target_arns): <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    ///   - [`status(Option<VpcLinkStatus>)`](crate::output::GetVpcLinkOutput::status): <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetVpcLinkOutput::status_message): <p>A description about the VPC link status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetVpcLinkOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<GetVpcLinkError>`](crate::error::GetVpcLinkError)
    pub fn get_vpc_link(&self) -> fluent_builders::GetVpcLink<C, M, R> {
        fluent_builders::GetVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVpcLinks`](crate::client::fluent_builders::GetVpcLinks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetVpcLinks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`position(impl Into<String>)`](crate::client::fluent_builders::GetVpcLinks::position) / [`set_position(Option<String>)`](crate::client::fluent_builders::GetVpcLinks::set_position): <p>The current pagination position in the paged result set.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetVpcLinks::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetVpcLinks::set_limit): <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
    /// - On success, responds with [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput) with field(s):
    ///   - [`items(Option<Vec<VpcLink>>)`](crate::output::GetVpcLinksOutput::items): <p>The current page of elements from this collection.</p>
    ///   - [`position(Option<String>)`](crate::output::GetVpcLinksOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<GetVpcLinksError>`](crate::error::GetVpcLinksError)
    pub fn get_vpc_links(&self) -> fluent_builders::GetVpcLinks<C, M, R> {
        fluent_builders::GetVpcLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportApiKeys`](crate::client::fluent_builders::ImportApiKeys) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`body(Blob)`](crate::client::fluent_builders::ImportApiKeys::body) / [`set_body(Option<Blob>)`](crate::client::fluent_builders::ImportApiKeys::set_body): <p>The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format</a>.</p>
    ///   - [`format(ApiKeysFormat)`](crate::client::fluent_builders::ImportApiKeys::format) / [`set_format(Option<ApiKeysFormat>)`](crate::client::fluent_builders::ImportApiKeys::set_format): <p>A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.</p>
    ///   - [`fail_on_warnings(bool)`](crate::client::fluent_builders::ImportApiKeys::fail_on_warnings) / [`set_fail_on_warnings(bool)`](crate::client::fluent_builders::ImportApiKeys::set_fail_on_warnings): <p>A query parameter to indicate whether to rollback <code>ApiKey</code> importation (<code>true</code>) or not (<code>false</code>) when error is encountered.</p>
    /// - On success, responds with [`ImportApiKeysOutput`](crate::output::ImportApiKeysOutput) with field(s):
    ///   - [`ids(Option<Vec<String>>)`](crate::output::ImportApiKeysOutput::ids): <p>A list of all the <code>ApiKey</code> identifiers.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::ImportApiKeysOutput::warnings): <p>A list of warning messages.</p>
    /// - On failure, responds with [`SdkError<ImportApiKeysError>`](crate::error::ImportApiKeysError)
    pub fn import_api_keys(&self) -> fluent_builders::ImportApiKeys<C, M, R> {
        fluent_builders::ImportApiKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportDocumentationParts`](crate::client::fluent_builders::ImportDocumentationParts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::ImportDocumentationParts::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::ImportDocumentationParts::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`mode(PutMode)`](crate::client::fluent_builders::ImportDocumentationParts::mode) / [`set_mode(Option<PutMode>)`](crate::client::fluent_builders::ImportDocumentationParts::set_mode): <p>A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing <code>DocumentationParts</code> definition or to merge (<code>MERGE</code>) the new definition into the existing one. The default value is <code>MERGE</code>.</p>
    ///   - [`fail_on_warnings(bool)`](crate::client::fluent_builders::ImportDocumentationParts::fail_on_warnings) / [`set_fail_on_warnings(bool)`](crate::client::fluent_builders::ImportDocumentationParts::set_fail_on_warnings): <p>A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
    ///   - [`body(Blob)`](crate::client::fluent_builders::ImportDocumentationParts::body) / [`set_body(Option<Blob>)`](crate::client::fluent_builders::ImportDocumentationParts::set_body): <p>[Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.</p>
    /// - On success, responds with [`ImportDocumentationPartsOutput`](crate::output::ImportDocumentationPartsOutput) with field(s):
    ///   - [`ids(Option<Vec<String>>)`](crate::output::ImportDocumentationPartsOutput::ids): <p>A list of the returned documentation part identifiers.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::ImportDocumentationPartsOutput::warnings): <p>A list of warning messages reported during import of documentation parts.</p>
    /// - On failure, responds with [`SdkError<ImportDocumentationPartsError>`](crate::error::ImportDocumentationPartsError)
    pub fn import_documentation_parts(&self) -> fluent_builders::ImportDocumentationParts<C, M, R> {
        fluent_builders::ImportDocumentationParts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportRestApi`](crate::client::fluent_builders::ImportRestApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fail_on_warnings(bool)`](crate::client::fluent_builders::ImportRestApi::fail_on_warnings) / [`set_fail_on_warnings(bool)`](crate::client::fluent_builders::ImportRestApi::set_fail_on_warnings): <p>A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
    ///   - [`parameters(HashMap<String, String>)`](crate::client::fluent_builders::ImportRestApi::parameters) / [`set_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ImportRestApi::set_parameters): <p>A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.</p>  <p> To exclude <code>DocumentationParts</code> from the import, set <code>parameters</code> as <code>ignore=documentation</code>.</p>  <p> To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.</p>  <p> To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>.</p>  <p>For example, the AWS CLI command to exclude documentation from the imported API is:</p>  <pre><code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code></pre>  <p>The AWS CLI command to set the regional endpoint on the imported API is:</p>  <pre><code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code></pre>
    ///   - [`body(Blob)`](crate::client::fluent_builders::ImportRestApi::body) / [`set_body(Option<Blob>)`](crate::client::fluent_builders::ImportRestApi::set_body): <p>[Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
    /// - On success, responds with [`ImportRestApiOutput`](crate::output::ImportRestApiOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::ImportRestApiOutput::id): <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    ///   - [`name(Option<String>)`](crate::output::ImportRestApiOutput::name): <p>The API's name.</p>
    ///   - [`description(Option<String>)`](crate::output::ImportRestApiOutput::description): <p>The API's description.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::ImportRestApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`version(Option<String>)`](crate::output::ImportRestApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::ImportRestApiOutput::warnings): <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    ///   - [`binary_media_types(Option<Vec<String>>)`](crate::output::ImportRestApiOutput::binary_media_types): <p>The list of binary media types supported by the <code>RestApi</code>. By default, the <code>RestApi</code> supports only UTF-8-encoded text payloads.</p>
    ///   - [`minimum_compression_size(Option<i32>)`](crate::output::ImportRestApiOutput::minimum_compression_size): <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    ///   - [`api_key_source(Option<ApiKeySourceType>)`](crate::output::ImportRestApiOutput::api_key_source): <p>The source of the API key for metering requests according to a usage plan. Valid values are: </p> <ul>  <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li>  <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li> </ul> <p></p>
    ///   - [`endpoint_configuration(Option<EndpointConfiguration>)`](crate::output::ImportRestApiOutput::endpoint_configuration): <p>The endpoint configuration of this <code>RestApi</code> showing the endpoint types of the API.</p>
    ///   - [`policy(Option<String>)`](crate::output::ImportRestApiOutput::policy): <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <code>Method</code> configuration.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ImportRestApiOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::ImportRestApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    /// - On failure, responds with [`SdkError<ImportRestApiError>`](crate::error::ImportRestApiError)
    pub fn import_rest_api(&self) -> fluent_builders::ImportRestApi<C, M, R> {
        fluent_builders::ImportRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutGatewayResponse`](crate::client::fluent_builders::PutGatewayResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::PutGatewayResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::PutGatewayResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`response_type(GatewayResponseType)`](crate::client::fluent_builders::PutGatewayResponse::response_type) / [`set_response_type(Option<GatewayResponseType>)`](crate::client::fluent_builders::PutGatewayResponse::set_response_type): <p>[Required] </p> <p>The response type of the associated <code>GatewayResponse</code>.</p> <p></p>
    ///   - [`status_code(impl Into<String>)`](crate::client::fluent_builders::PutGatewayResponse::status_code) / [`set_status_code(Option<String>)`](crate::client::fluent_builders::PutGatewayResponse::set_status_code): The HTTP status code of the <code>GatewayResponse</code>.
    ///   - [`response_parameters(HashMap<String, String>)`](crate::client::fluent_builders::PutGatewayResponse::response_parameters) / [`set_response_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutGatewayResponse::set_response_parameters): <p></p> <p>Response parameters (paths, query strings and headers) of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p> <p></p>
    ///   - [`response_templates(HashMap<String, String>)`](crate::client::fluent_builders::PutGatewayResponse::response_templates) / [`set_response_templates(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutGatewayResponse::set_response_templates): <p></p> <p>Response templates of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p> <p></p>
    /// - On success, responds with [`PutGatewayResponseOutput`](crate::output::PutGatewayResponseOutput) with field(s):
    ///   - [`response_type(Option<GatewayResponseType>)`](crate::output::PutGatewayResponseOutput::response_type): <p>The response type of the associated <code>GatewayResponse</code>.</p>
    ///   - [`status_code(Option<String>)`](crate::output::PutGatewayResponseOutput::status_code): <p>The HTTP status code for this <code>GatewayResponse</code>.</p>
    ///   - [`response_parameters(Option<HashMap<String, String>>)`](crate::output::PutGatewayResponseOutput::response_parameters): <p>Response parameters (paths, query strings and headers) of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
    ///   - [`response_templates(Option<HashMap<String, String>>)`](crate::output::PutGatewayResponseOutput::response_templates): <p>Response templates of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
    ///   - [`default_response(bool)`](crate::output::PutGatewayResponseOutput::default_response): <p>A Boolean flag to indicate whether this <code>GatewayResponse</code> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    /// - On failure, responds with [`SdkError<PutGatewayResponseError>`](crate::error::PutGatewayResponseError)
    pub fn put_gateway_response(&self) -> fluent_builders::PutGatewayResponse<C, M, R> {
        fluent_builders::PutGatewayResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutIntegration`](crate::client::fluent_builders::PutIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_resource_id): <p>[Required] Specifies a put integration request's resource ID.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_http_method): <p>[Required] Specifies a put integration request's HTTP method.</p>
    ///   - [`r#type(IntegrationType)`](crate::client::fluent_builders::PutIntegration::r#type) / [`set_type(Option<IntegrationType>)`](crate::client::fluent_builders::PutIntegration::set_type): <p>[Required] Specifies a put integration input's type.</p>
    ///   - [`integration_http_method(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::integration_http_method) / [`set_integration_http_method(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_integration_http_method): <p>Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.</p>
    ///   - [`uri(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::uri) / [`set_uri(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_uri): <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>  <ul>   <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p> </li>   <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p> </li> </ul>
    ///   - [`connection_type(ConnectionType)`](crate::client::fluent_builders::PutIntegration::connection_type) / [`set_connection_type(Option<ConnectionType>)`](crate::client::fluent_builders::PutIntegration::set_connection_type): <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_connection_id): <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <code>VpcLink</code> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    ///   - [`credentials(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::credentials) / [`set_credentials(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_credentials): <p>Specifies whether credentials are required for a put integration.</p>
    ///   - [`request_parameters(HashMap<String, String>)`](crate::client::fluent_builders::PutIntegration::request_parameters) / [`set_request_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutIntegration::set_request_parameters): <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    ///   - [`request_templates(HashMap<String, String>)`](crate::client::fluent_builders::PutIntegration::request_templates) / [`set_request_templates(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutIntegration::set_request_templates): <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    ///   - [`passthrough_behavior(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::passthrough_behavior) / [`set_passthrough_behavior(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_passthrough_behavior): <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values: <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>. </p>  <ul>   <li><p><code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration back end without transformation.</p></li>   <li><p><code>NEVER</code> rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.</p></li>   <li><p><code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.</p></li>  </ul>
    ///   - [`cache_namespace(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::cache_namespace) / [`set_cache_namespace(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_cache_namespace): <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    ///   - [`cache_key_parameters(Vec<String>)`](crate::client::fluent_builders::PutIntegration::cache_key_parameters) / [`set_cache_key_parameters(Option<Vec<String>>)`](crate::client::fluent_builders::PutIntegration::set_cache_key_parameters): <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <code>Method</code> <code>requestParameters</code>.</p>
    ///   - [`content_handling(ContentHandlingStrategy)`](crate::client::fluent_builders::PutIntegration::content_handling) / [`set_content_handling(Option<ContentHandlingStrategy>)`](crate::client::fluent_builders::PutIntegration::set_content_handling): <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>  <ul>   <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>   <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>  </ul>  <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    ///   - [`timeout_in_millis(i32)`](crate::client::fluent_builders::PutIntegration::timeout_in_millis) / [`set_timeout_in_millis(Option<i32>)`](crate::client::fluent_builders::PutIntegration::set_timeout_in_millis): <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    ///   - [`tls_config(TlsConfig)`](crate::client::fluent_builders::PutIntegration::tls_config) / [`set_tls_config(Option<TlsConfig>)`](crate::client::fluent_builders::PutIntegration::set_tls_config): (undocumented)
    /// - On success, responds with [`PutIntegrationOutput`](crate::output::PutIntegrationOutput) with field(s):
    ///   - [`r#type(Option<IntegrationType>)`](crate::output::PutIntegrationOutput::type): <p>Specifies an API method integration type. The valid value is one of the following:</p>  <ul>   <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>   <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>   <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>   <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>   <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>  </ul>  <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <code>VpcLink</code> to connect API Gateway to a network load balancer of a VPC.</p>
    ///   - [`http_method(Option<String>)`](crate::output::PutIntegrationOutput::http_method): <p>Specifies the integration's HTTP method type.</p>
    ///   - [`uri(Option<String>)`](crate::output::PutIntegrationOutput::uri): <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>  <ul>   <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p> </li>   <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p> </li> </ul>
    ///   - [`connection_type(Option<ConnectionType>)`](crate::output::PutIntegrationOutput::connection_type): <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::PutIntegrationOutput::connection_id): <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <code>VpcLink</code> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    ///   - [`credentials(Option<String>)`](crate::output::PutIntegrationOutput::credentials): <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    ///   - [`request_parameters(Option<HashMap<String, String>>)`](crate::output::PutIntegrationOutput::request_parameters): <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    ///   - [`request_templates(Option<HashMap<String, String>>)`](crate::output::PutIntegrationOutput::request_templates): <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    ///   - [`passthrough_behavior(Option<String>)`](crate::output::PutIntegrationOutput::passthrough_behavior): <div>   <p> Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following: </p>   <ul>    <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li>    <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li>    <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li>   </ul>  </div>
    ///   - [`content_handling(Option<ContentHandlingStrategy>)`](crate::output::PutIntegrationOutput::content_handling): <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>  <ul>   <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>   <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>  </ul>  <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    ///   - [`timeout_in_millis(i32)`](crate::output::PutIntegrationOutput::timeout_in_millis): <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    ///   - [`cache_namespace(Option<String>)`](crate::output::PutIntegrationOutput::cache_namespace): <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    ///   - [`cache_key_parameters(Option<Vec<String>>)`](crate::output::PutIntegrationOutput::cache_key_parameters): <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <code>Method</code> <code>requestParameters</code>.</p>
    ///   - [`integration_responses(Option<HashMap<String, IntegrationResponse>>)`](crate::output::PutIntegrationOutput::integration_responses): <p>Specifies the integration's responses.</p>  <div class="remarks">   <p></p>   <h4>Example: Get integration responses of a method</h4>   <h5>Request</h5>   <p></p>   <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre>   <h5>Response</h5>   <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>   <pre><code>{   "_links": {     "curies": {       "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",       "name": "integrationresponse",       "templated": true     },     "self": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",       "title": "200"     },     "integrationresponse:delete": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"     },     "integrationresponse:update": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"     }   },   "responseParameters": {     "method.response.header.Content-Type": "'application/xml'"   },   "responseTemplates": {     "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"   },   "statusCode": "200" }</code></pre>   <p></p>  </div>  <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>  </div>
    ///   - [`tls_config(Option<TlsConfig>)`](crate::output::PutIntegrationOutput::tls_config): <p>Specifies the TLS configuration for an integration.</p>
    /// - On failure, responds with [`SdkError<PutIntegrationError>`](crate::error::PutIntegrationError)
    pub fn put_integration(&self) -> fluent_builders::PutIntegration<C, M, R> {
        fluent_builders::PutIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutIntegrationResponse`](crate::client::fluent_builders::PutIntegrationResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::PutIntegrationResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::PutIntegrationResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::PutIntegrationResponse::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::PutIntegrationResponse::set_resource_id): <p>[Required] Specifies a put integration response request's resource identifier.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::PutIntegrationResponse::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::PutIntegrationResponse::set_http_method): <p>[Required] Specifies a put integration response request's HTTP method.</p>
    ///   - [`status_code(impl Into<String>)`](crate::client::fluent_builders::PutIntegrationResponse::status_code) / [`set_status_code(Option<String>)`](crate::client::fluent_builders::PutIntegrationResponse::set_status_code): <p>[Required] Specifies the status code that is used to map the integration response to an existing <code>MethodResponse</code>.</p>
    ///   - [`selection_pattern(impl Into<String>)`](crate::client::fluent_builders::PutIntegrationResponse::selection_pattern) / [`set_selection_pattern(Option<String>)`](crate::client::fluent_builders::PutIntegrationResponse::set_selection_pattern): <p>Specifies the selection pattern of a put integration response.</p>
    ///   - [`response_parameters(HashMap<String, String>)`](crate::client::fluent_builders::PutIntegrationResponse::response_parameters) / [`set_response_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutIntegrationResponse::set_response_parameters): <p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.</p>
    ///   - [`response_templates(HashMap<String, String>)`](crate::client::fluent_builders::PutIntegrationResponse::response_templates) / [`set_response_templates(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutIntegrationResponse::set_response_templates): <p>Specifies a put integration response's templates.</p>
    ///   - [`content_handling(ContentHandlingStrategy)`](crate::client::fluent_builders::PutIntegrationResponse::content_handling) / [`set_content_handling(Option<ContentHandlingStrategy>)`](crate::client::fluent_builders::PutIntegrationResponse::set_content_handling): <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>  <ul>   <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>   <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>  </ul>  <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    /// - On success, responds with [`PutIntegrationResponseOutput`](crate::output::PutIntegrationResponseOutput) with field(s):
    ///   - [`status_code(Option<String>)`](crate::output::PutIntegrationResponseOutput::status_code): <p>Specifies the status code that is used to map the integration response to an existing <code>MethodResponse</code>.</p>
    ///   - [`selection_pattern(Option<String>)`](crate::output::PutIntegrationResponseOutput::selection_pattern): <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    ///   - [`response_parameters(Option<HashMap<String, String>>)`](crate::output::PutIntegrationResponseOutput::response_parameters): <p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    ///   - [`response_templates(Option<HashMap<String, String>>)`](crate::output::PutIntegrationResponseOutput::response_templates): <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    ///   - [`content_handling(Option<ContentHandlingStrategy>)`](crate::output::PutIntegrationResponseOutput::content_handling): <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>  <ul>   <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>   <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>  </ul>  <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    /// - On failure, responds with [`SdkError<PutIntegrationResponseError>`](crate::error::PutIntegrationResponseError)
    pub fn put_integration_response(&self) -> fluent_builders::PutIntegrationResponse<C, M, R> {
        fluent_builders::PutIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutMethod`](crate::client::fluent_builders::PutMethod) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::PutMethod::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::PutMethod::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::PutMethod::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::PutMethod::set_resource_id): <p>[Required] The <code>Resource</code> identifier for the new <code>Method</code> resource.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::PutMethod::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::PutMethod::set_http_method): <p>[Required] Specifies the method request's HTTP method type.</p>
    ///   - [`authorization_type(impl Into<String>)`](crate::client::fluent_builders::PutMethod::authorization_type) / [`set_authorization_type(Option<String>)`](crate::client::fluent_builders::PutMethod::set_authorization_type): <p>[Required] The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::PutMethod::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::PutMethod::set_authorizer_id): <p>Specifies the identifier of an <code>Authorizer</code> to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
    ///   - [`api_key_required(bool)`](crate::client::fluent_builders::PutMethod::api_key_required) / [`set_api_key_required(bool)`](crate::client::fluent_builders::PutMethod::set_api_key_required): <p>Specifies whether the method required a valid <code>ApiKey</code>.</p>
    ///   - [`operation_name(impl Into<String>)`](crate::client::fluent_builders::PutMethod::operation_name) / [`set_operation_name(Option<String>)`](crate::client::fluent_builders::PutMethod::set_operation_name): <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    ///   - [`request_parameters(HashMap<String, bool>)`](crate::client::fluent_builders::PutMethod::request_parameters) / [`set_request_parameters(Option<HashMap<String, bool>>)`](crate::client::fluent_builders::PutMethod::set_request_parameters): <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <code>Integration</code> to be mapped to integration request parameters or body-mapping templates.</p>
    ///   - [`request_models(HashMap<String, String>)`](crate::client::fluent_builders::PutMethod::request_models) / [`set_request_models(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutMethod::set_request_models): <p>Specifies the <code>Model</code> resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a <code>Model</code> name as the value.</p>
    ///   - [`request_validator_id(impl Into<String>)`](crate::client::fluent_builders::PutMethod::request_validator_id) / [`set_request_validator_id(Option<String>)`](crate::client::fluent_builders::PutMethod::set_request_validator_id): <p>The identifier of a <code>RequestValidator</code> for validating the method request.</p>
    ///   - [`authorization_scopes(Vec<String>)`](crate::client::fluent_builders::PutMethod::authorization_scopes) / [`set_authorization_scopes(Option<Vec<String>>)`](crate::client::fluent_builders::PutMethod::set_authorization_scopes): <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    /// - On success, responds with [`PutMethodOutput`](crate::output::PutMethodOutput) with field(s):
    ///   - [`http_method(Option<String>)`](crate::output::PutMethodOutput::http_method): <p>The method's HTTP verb.</p>
    ///   - [`authorization_type(Option<String>)`](crate::output::PutMethodOutput::authorization_type): <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    ///   - [`authorizer_id(Option<String>)`](crate::output::PutMethodOutput::authorizer_id): <p>The identifier of an <code>Authorizer</code> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    ///   - [`api_key_required(Option<bool>)`](crate::output::PutMethodOutput::api_key_required): <p>A boolean flag specifying whether a valid <code>ApiKey</code> is required to invoke this method.</p>
    ///   - [`request_validator_id(Option<String>)`](crate::output::PutMethodOutput::request_validator_id): <p>The identifier of a <code>RequestValidator</code> for request validation.</p>
    ///   - [`operation_name(Option<String>)`](crate::output::PutMethodOutput::operation_name): <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    ///   - [`request_parameters(Option<HashMap<String, bool>>)`](crate::output::PutMethodOutput::request_parameters): <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <code>Integration</code> to be mapped to integration request parameters or templates.</p>
    ///   - [`request_models(Option<HashMap<String, String>>)`](crate::output::PutMethodOutput::request_models): <p>A key-value map specifying data schemas, represented by <code>Model</code> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    ///   - [`method_responses(Option<HashMap<String, MethodResponse>>)`](crate::output::PutMethodOutput::method_responses): <p>Gets a method response associated with a given HTTP status code. </p>  <div class="remarks">   <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <code>MethodResponse</code> resource that specifies the response returned to the caller from the back end through the integration response.</p>   <h4>Example: Get a 200 OK response of a GET method</h4>   <h5>Request</h5>   <p></p>   <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T215008Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>   <h5>Response</h5>   <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>   <pre><code>{   "_links": {     "curies": {       "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",       "name": "methodresponse",       "templated": true     },     "self": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",       "title": "200"     },     "methodresponse:delete": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"     },     "methodresponse:update": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"     }   },   "responseModels": {     "application/json": "Empty"   },   "responseParameters": {     "method.response.header.operator": false,     "method.response.header.operand_2": false,     "method.response.header.operand_1": false   },   "statusCode": "200" }</code></pre>   <p></p>  </div>  <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>  </div>
    ///   - [`method_integration(Option<Integration>)`](crate::output::PutMethodOutput::method_integration): <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>  <div class="remarks">   <p></p>   <h4>Example: </h4>   <h5>Request</h5>   <p></p>   <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T213210Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>   <h5>Response</h5>   <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>   <pre><code>{   "_links": {     "curies": [       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",         "name": "integration",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",         "name": "integrationresponse",         "templated": true       }     ],     "self": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"     },     "integration:delete": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"     },     "integration:responses": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",       "name": "200",       "title": "200"     },     "integration:update": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"     },     "integrationresponse:put": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",       "templated": true     }   },   "cacheKeyParameters": [],   "cacheNamespace": "0cjtch",   "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",   "httpMethod": "POST",   "passthroughBehavior": "WHEN_NO_MATCH",   "requestTemplates": {     "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"   },   "type": "AWS",   "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",   "_embedded": {     "integration:responses": {       "_links": {         "self": {           "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",           "name": "200",           "title": "200"         },         "integrationresponse:delete": {           "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"         },         "integrationresponse:update": {           "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"         }       },       "responseParameters": {         "method.response.header.operator": "integration.response.body.op",         "method.response.header.operand_2": "integration.response.body.b",         "method.response.header.operand_1": "integration.response.body.a"       },       "responseTemplates": {         "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op =&gt; $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"       },       "selectionPattern": "",       "statusCode": "200"     }   } }</code></pre>   <p></p>  </div>  <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>  </div>
    ///   - [`authorization_scopes(Option<Vec<String>>)`](crate::output::PutMethodOutput::authorization_scopes): <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    /// - On failure, responds with [`SdkError<PutMethodError>`](crate::error::PutMethodError)
    pub fn put_method(&self) -> fluent_builders::PutMethod<C, M, R> {
        fluent_builders::PutMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutMethodResponse`](crate::client::fluent_builders::PutMethodResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::PutMethodResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::PutMethodResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::PutMethodResponse::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::PutMethodResponse::set_resource_id): <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::PutMethodResponse::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::PutMethodResponse::set_http_method): <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
    ///   - [`status_code(impl Into<String>)`](crate::client::fluent_builders::PutMethodResponse::status_code) / [`set_status_code(Option<String>)`](crate::client::fluent_builders::PutMethodResponse::set_status_code): <p>[Required] The method response's status code.</p>
    ///   - [`response_parameters(HashMap<String, bool>)`](crate::client::fluent_builders::PutMethodResponse::response_parameters) / [`set_response_parameters(Option<HashMap<String, bool>>)`](crate::client::fluent_builders::PutMethodResponse::set_response_parameters): <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    ///   - [`response_models(HashMap<String, String>)`](crate::client::fluent_builders::PutMethodResponse::response_models) / [`set_response_models(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutMethodResponse::set_response_models): <p>Specifies the <code>Model</code> resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a <code>Model</code> name as the value.</p>
    /// - On success, responds with [`PutMethodResponseOutput`](crate::output::PutMethodResponseOutput) with field(s):
    ///   - [`status_code(Option<String>)`](crate::output::PutMethodResponseOutput::status_code): <p>The method response's status code.</p>
    ///   - [`response_parameters(Option<HashMap<String, bool>>)`](crate::output::PutMethodResponseOutput::response_parameters): <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <code>IntegrationResponse</code>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    ///   - [`response_models(Option<HashMap<String, String>>)`](crate::output::PutMethodResponseOutput::response_models): <p>Specifies the <code>Model</code> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <code>Model</code> name as the value.</p>
    /// - On failure, responds with [`SdkError<PutMethodResponseError>`](crate::error::PutMethodResponseError)
    pub fn put_method_response(&self) -> fluent_builders::PutMethodResponse<C, M, R> {
        fluent_builders::PutMethodResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRestApi`](crate::client::fluent_builders::PutRestApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::PutRestApi::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::PutRestApi::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`mode(PutMode)`](crate::client::fluent_builders::PutRestApi::mode) / [`set_mode(Option<PutMode>)`](crate::client::fluent_builders::PutRestApi::set_mode): <p>The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default, the update mode is "merge".</p>
    ///   - [`fail_on_warnings(bool)`](crate::client::fluent_builders::PutRestApi::fail_on_warnings) / [`set_fail_on_warnings(bool)`](crate::client::fluent_builders::PutRestApi::set_fail_on_warnings): <p>A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
    ///   - [`parameters(HashMap<String, String>)`](crate::client::fluent_builders::PutRestApi::parameters) / [`set_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutRestApi::set_parameters): <p>Custom header parameters as part of the request. For example, to exclude <code>DocumentationParts</code> from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>.</p>
    ///   - [`body(Blob)`](crate::client::fluent_builders::PutRestApi::body) / [`set_body(Option<Blob>)`](crate::client::fluent_builders::PutRestApi::set_body): <p>[Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
    /// - On success, responds with [`PutRestApiOutput`](crate::output::PutRestApiOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::PutRestApiOutput::id): <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    ///   - [`name(Option<String>)`](crate::output::PutRestApiOutput::name): <p>The API's name.</p>
    ///   - [`description(Option<String>)`](crate::output::PutRestApiOutput::description): <p>The API's description.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::PutRestApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`version(Option<String>)`](crate::output::PutRestApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::PutRestApiOutput::warnings): <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    ///   - [`binary_media_types(Option<Vec<String>>)`](crate::output::PutRestApiOutput::binary_media_types): <p>The list of binary media types supported by the <code>RestApi</code>. By default, the <code>RestApi</code> supports only UTF-8-encoded text payloads.</p>
    ///   - [`minimum_compression_size(Option<i32>)`](crate::output::PutRestApiOutput::minimum_compression_size): <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    ///   - [`api_key_source(Option<ApiKeySourceType>)`](crate::output::PutRestApiOutput::api_key_source): <p>The source of the API key for metering requests according to a usage plan. Valid values are: </p> <ul>  <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li>  <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li> </ul> <p></p>
    ///   - [`endpoint_configuration(Option<EndpointConfiguration>)`](crate::output::PutRestApiOutput::endpoint_configuration): <p>The endpoint configuration of this <code>RestApi</code> showing the endpoint types of the API.</p>
    ///   - [`policy(Option<String>)`](crate::output::PutRestApiOutput::policy): <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <code>Method</code> configuration.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::PutRestApiOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::PutRestApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    /// - On failure, responds with [`SdkError<PutRestApiError>`](crate::error::PutRestApiError)
    pub fn put_rest_api(&self) -> fluent_builders::PutRestApi<C, M, R> {
        fluent_builders::PutRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>[Required] The ARN of a resource that can be tagged.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>[Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestInvokeAuthorizer`](crate::client::fluent_builders::TestInvokeAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_authorizer_id): <p>[Required] Specifies a test invoke authorizer request's <code>Authorizer</code> ID.</p>
    ///   - [`headers(HashMap<String, String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::headers) / [`set_headers(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_headers): <p>[Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.</p>
    ///   - [`multi_value_headers(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::TestInvokeAuthorizer::multi_value_headers) / [`set_multi_value_headers(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_multi_value_headers): <p>[Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.</p>
    ///   - [`path_with_query_string(impl Into<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::path_with_query_string) / [`set_path_with_query_string(Option<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_path_with_query_string): <p>[Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
    ///   - [`body(impl Into<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::body) / [`set_body(Option<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_body): <p>[Optional] The simulated request body of an incoming invocation request.</p>
    ///   - [`stage_variables(HashMap<String, String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::stage_variables) / [`set_stage_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_stage_variables): <p>A key-value map of stage variables to simulate an invocation on a deployed <code>Stage</code>.</p>
    ///   - [`additional_context(HashMap<String, String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::additional_context) / [`set_additional_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_additional_context): <p>[Optional] A key-value map of additional context variables.</p>
    /// - On success, responds with [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput) with field(s):
    ///   - [`client_status(i32)`](crate::output::TestInvokeAuthorizerOutput::client_status): <p>The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.</p>
    ///   - [`log(Option<String>)`](crate::output::TestInvokeAuthorizerOutput::log): <p>The API Gateway execution log for the test authorizer request.</p>
    ///   - [`latency(i64)`](crate::output::TestInvokeAuthorizerOutput::latency): <p>The execution latency of the test authorizer request.</p>
    ///   - [`principal_id(Option<String>)`](crate::output::TestInvokeAuthorizerOutput::principal_id): <p>The principal identity returned by the <code>Authorizer</code></p>
    ///   - [`policy(Option<String>)`](crate::output::TestInvokeAuthorizerOutput::policy): <p>The JSON policy document returned by the <code>Authorizer</code></p>
    ///   - [`authorization(Option<HashMap<String, Vec<String>>>)`](crate::output::TestInvokeAuthorizerOutput::authorization): (undocumented)
    ///   - [`claims(Option<HashMap<String, String>>)`](crate::output::TestInvokeAuthorizerOutput::claims): <p>The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.</p>
    /// - On failure, responds with [`SdkError<TestInvokeAuthorizerError>`](crate::error::TestInvokeAuthorizerError)
    pub fn test_invoke_authorizer(&self) -> fluent_builders::TestInvokeAuthorizer<C, M, R> {
        fluent_builders::TestInvokeAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestInvokeMethod`](crate::client::fluent_builders::TestInvokeMethod) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::TestInvokeMethod::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::TestInvokeMethod::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::TestInvokeMethod::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::TestInvokeMethod::set_resource_id): <p>[Required] Specifies a test invoke method request's resource ID.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::TestInvokeMethod::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::TestInvokeMethod::set_http_method): <p>[Required] Specifies a test invoke method request's HTTP method.</p>
    ///   - [`path_with_query_string(impl Into<String>)`](crate::client::fluent_builders::TestInvokeMethod::path_with_query_string) / [`set_path_with_query_string(Option<String>)`](crate::client::fluent_builders::TestInvokeMethod::set_path_with_query_string): <p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
    ///   - [`body(impl Into<String>)`](crate::client::fluent_builders::TestInvokeMethod::body) / [`set_body(Option<String>)`](crate::client::fluent_builders::TestInvokeMethod::set_body): <p>The simulated request body of an incoming invocation request.</p>
    ///   - [`headers(HashMap<String, String>)`](crate::client::fluent_builders::TestInvokeMethod::headers) / [`set_headers(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TestInvokeMethod::set_headers): <p>A key-value map of headers to simulate an incoming invocation request.</p>
    ///   - [`multi_value_headers(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::TestInvokeMethod::multi_value_headers) / [`set_multi_value_headers(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::TestInvokeMethod::set_multi_value_headers): <p>The headers as a map from string to list of values to simulate an incoming invocation request.</p>
    ///   - [`client_certificate_id(impl Into<String>)`](crate::client::fluent_builders::TestInvokeMethod::client_certificate_id) / [`set_client_certificate_id(Option<String>)`](crate::client::fluent_builders::TestInvokeMethod::set_client_certificate_id): <p>A <code>ClientCertificate</code> identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.</p>
    ///   - [`stage_variables(HashMap<String, String>)`](crate::client::fluent_builders::TestInvokeMethod::stage_variables) / [`set_stage_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TestInvokeMethod::set_stage_variables): <p>A key-value map of stage variables to simulate an invocation on a deployed <code>Stage</code>.</p>
    /// - On success, responds with [`TestInvokeMethodOutput`](crate::output::TestInvokeMethodOutput) with field(s):
    ///   - [`status(i32)`](crate::output::TestInvokeMethodOutput::status): <p>The HTTP status code.</p>
    ///   - [`body(Option<String>)`](crate::output::TestInvokeMethodOutput::body): <p>The body of the HTTP response.</p>
    ///   - [`headers(Option<HashMap<String, String>>)`](crate::output::TestInvokeMethodOutput::headers): <p>The headers of the HTTP response.</p>
    ///   - [`multi_value_headers(Option<HashMap<String, Vec<String>>>)`](crate::output::TestInvokeMethodOutput::multi_value_headers): <p>The headers of the HTTP response as a map from string to list of values.</p>
    ///   - [`log(Option<String>)`](crate::output::TestInvokeMethodOutput::log): <p>The API Gateway execution log for the test invoke request.</p>
    ///   - [`latency(i64)`](crate::output::TestInvokeMethodOutput::latency): <p>The execution latency of the test invoke request.</p>
    /// - On failure, responds with [`SdkError<TestInvokeMethodError>`](crate::error::TestInvokeMethodError)
    pub fn test_invoke_method(&self) -> fluent_builders::TestInvokeMethod<C, M, R> {
        fluent_builders::TestInvokeMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>[Required] The ARN of a resource that can be tagged.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>[Required] The Tag keys to delete.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccount`](crate::client::fluent_builders::UpdateAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateAccount::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateAccount::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateAccountOutput`](crate::output::UpdateAccountOutput) with field(s):
    ///   - [`cloudwatch_role_arn(Option<String>)`](crate::output::UpdateAccountOutput::cloudwatch_role_arn): <p>The ARN of an Amazon CloudWatch role for the current <code>Account</code>.</p>
    ///   - [`throttle_settings(Option<ThrottleSettings>)`](crate::output::UpdateAccountOutput::throttle_settings): <p>Specifies the API request limits configured for the current <code>Account</code>.</p>
    ///   - [`features(Option<Vec<String>>)`](crate::output::UpdateAccountOutput::features): <p>A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.</p>
    ///   - [`api_key_version(Option<String>)`](crate::output::UpdateAccountOutput::api_key_version): <p>The version of the API keys used for the account.</p>
    /// - On failure, responds with [`SdkError<UpdateAccountError>`](crate::error::UpdateAccountError)
    pub fn update_account(&self) -> fluent_builders::UpdateAccount<C, M, R> {
        fluent_builders::UpdateAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApiKey`](crate::client::fluent_builders::UpdateApiKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_key(impl Into<String>)`](crate::client::fluent_builders::UpdateApiKey::api_key) / [`set_api_key(Option<String>)`](crate::client::fluent_builders::UpdateApiKey::set_api_key): <p>[Required] The identifier of the <code>ApiKey</code> resource to be updated.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateApiKey::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateApiKey::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateApiKeyOutput`](crate::output::UpdateApiKeyOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateApiKeyOutput::id): <p>The identifier of the API Key.</p>
    ///   - [`value(Option<String>)`](crate::output::UpdateApiKeyOutput::value): <p>The value of the API Key.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateApiKeyOutput::name): <p>The name of the API Key.</p>
    ///   - [`customer_id(Option<String>)`](crate::output::UpdateApiKeyOutput::customer_id): <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateApiKeyOutput::description): <p>The description of the API Key.</p>
    ///   - [`enabled(bool)`](crate::output::UpdateApiKeyOutput::enabled): <p>Specifies whether the API Key can be used by callers.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateApiKeyOutput::created_date): <p>The timestamp when the API Key was created.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::UpdateApiKeyOutput::last_updated_date): <p>The timestamp when the API Key was last updated.</p>
    ///   - [`stage_keys(Option<Vec<String>>)`](crate::output::UpdateApiKeyOutput::stage_keys): <p>A list of <code>Stage</code> resources that are associated with the <code>ApiKey</code> resource.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateApiKeyOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<UpdateApiKeyError>`](crate::error::UpdateApiKeyError)
    pub fn update_api_key(&self) -> fluent_builders::UpdateApiKey<C, M, R> {
        fluent_builders::UpdateApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAuthorizer`](crate::client::fluent_builders::UpdateAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`authorizer_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::authorizer_id) / [`set_authorizer_id(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_authorizer_id): <p>[Required] The identifier of the <code>Authorizer</code> resource.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateAuthorizer::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateAuthorizer::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateAuthorizerOutput::id): <p>The identifier for the authorizer resource.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateAuthorizerOutput::name): <p>[Required] The name of the authorizer.</p>
    ///   - [`r#type(Option<AuthorizerType>)`](crate::output::UpdateAuthorizerOutput::type): <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
    ///   - [`provider_ar_ns(Option<Vec<String>>)`](crate::output::UpdateAuthorizerOutput::provider_ar_ns): <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
    ///   - [`auth_type(Option<String>)`](crate::output::UpdateAuthorizerOutput::auth_type): <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
    ///   - [`authorizer_uri(Option<String>)`](crate::output::UpdateAuthorizerOutput::authorizer_uri): <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
    ///   - [`authorizer_credentials(Option<String>)`](crate::output::UpdateAuthorizerOutput::authorizer_credentials): <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
    ///   - [`identity_source(Option<String>)`](crate::output::UpdateAuthorizerOutput::identity_source): <p>The identity source for which authorization is requested. </p> <ul>  <li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li>  <li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li> </ul> <p></p>
    ///   - [`identity_validation_expression(Option<String>)`](crate::output::UpdateAuthorizerOutput::identity_validation_expression): <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
    ///   - [`authorizer_result_ttl_in_seconds(Option<i32>)`](crate::output::UpdateAuthorizerOutput::authorizer_result_ttl_in_seconds): <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
    /// - On failure, responds with [`SdkError<UpdateAuthorizerError>`](crate::error::UpdateAuthorizerError)
    pub fn update_authorizer(&self) -> fluent_builders::UpdateAuthorizer<C, M, R> {
        fluent_builders::UpdateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBasePathMapping`](crate::client::fluent_builders::UpdateBasePathMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateBasePathMapping::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateBasePathMapping::set_domain_name): <p>[Required] The domain name of the <code>BasePathMapping</code> resource to change.</p>
    ///   - [`base_path(impl Into<String>)`](crate::client::fluent_builders::UpdateBasePathMapping::base_path) / [`set_base_path(Option<String>)`](crate::client::fluent_builders::UpdateBasePathMapping::set_base_path): <p>[Required] The base path of the <code>BasePathMapping</code> resource to change.</p>  <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateBasePathMapping::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateBasePathMapping::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateBasePathMappingOutput`](crate::output::UpdateBasePathMappingOutput) with field(s):
    ///   - [`base_path(Option<String>)`](crate::output::UpdateBasePathMappingOutput::base_path): <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
    ///   - [`rest_api_id(Option<String>)`](crate::output::UpdateBasePathMappingOutput::rest_api_id): <p>The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage(Option<String>)`](crate::output::UpdateBasePathMappingOutput::stage): <p>The name of the associated stage.</p>
    /// - On failure, responds with [`SdkError<UpdateBasePathMappingError>`](crate::error::UpdateBasePathMappingError)
    pub fn update_base_path_mapping(&self) -> fluent_builders::UpdateBasePathMapping<C, M, R> {
        fluent_builders::UpdateBasePathMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateClientCertificate`](crate::client::fluent_builders::UpdateClientCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_certificate_id(impl Into<String>)`](crate::client::fluent_builders::UpdateClientCertificate::client_certificate_id) / [`set_client_certificate_id(Option<String>)`](crate::client::fluent_builders::UpdateClientCertificate::set_client_certificate_id): <p>[Required] The identifier of the <code>ClientCertificate</code> resource to be updated.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateClientCertificate::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateClientCertificate::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateClientCertificateOutput`](crate::output::UpdateClientCertificateOutput) with field(s):
    ///   - [`client_certificate_id(Option<String>)`](crate::output::UpdateClientCertificateOutput::client_certificate_id): <p>The identifier of the client certificate.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateClientCertificateOutput::description): <p>The description of the client certificate.</p>
    ///   - [`pem_encoded_certificate(Option<String>)`](crate::output::UpdateClientCertificateOutput::pem_encoded_certificate): <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateClientCertificateOutput::created_date): <p>The timestamp when the client certificate was created.</p>
    ///   - [`expiration_date(Option<DateTime>)`](crate::output::UpdateClientCertificateOutput::expiration_date): <p>The timestamp when the client certificate will expire.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateClientCertificateOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<UpdateClientCertificateError>`](crate::error::UpdateClientCertificateError)
    pub fn update_client_certificate(&self) -> fluent_builders::UpdateClientCertificate<C, M, R> {
        fluent_builders::UpdateClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDeployment`](crate::client::fluent_builders::UpdateDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDeployment::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateDeployment::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::UpdateDeployment::set_deployment_id): <p>The replacement identifier for the <code>Deployment</code> resource to change information about.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateDeployment::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateDeployment::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateDeploymentOutput::id): <p>The identifier for the deployment resource.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateDeploymentOutput::description): <p>The description for the deployment resource.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateDeploymentOutput::created_date): <p>The date and time that the deployment resource was created.</p>
    ///   - [`api_summary(Option<HashMap<String, HashMap<String, MethodSnapshot>>>)`](crate::output::UpdateDeploymentOutput::api_summary): <p>A summary of the <code>RestApi</code> at the date and time that the deployment resource was created.</p>
    /// - On failure, responds with [`SdkError<UpdateDeploymentError>`](crate::error::UpdateDeploymentError)
    pub fn update_deployment(&self) -> fluent_builders::UpdateDeployment<C, M, R> {
        fluent_builders::UpdateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDocumentationPart`](crate::client::fluent_builders::UpdateDocumentationPart) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentationPart::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateDocumentationPart::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`documentation_part_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentationPart::documentation_part_id) / [`set_documentation_part_id(Option<String>)`](crate::client::fluent_builders::UpdateDocumentationPart::set_documentation_part_id): <p>[Required] The identifier of the to-be-updated documentation part.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateDocumentationPart::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateDocumentationPart::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateDocumentationPartOutput`](crate::output::UpdateDocumentationPartOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateDocumentationPartOutput::id): <p>The <code>DocumentationPart</code> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
    ///   - [`location(Option<DocumentationPartLocation>)`](crate::output::UpdateDocumentationPartOutput::location): <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
    ///   - [`properties(Option<String>)`](crate::output::UpdateDocumentationPartOutput::properties): <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant documentation-related fields from the <literal>   properties  </literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateDocumentationPartError>`](crate::error::UpdateDocumentationPartError)
    pub fn update_documentation_part(&self) -> fluent_builders::UpdateDocumentationPart<C, M, R> {
        fluent_builders::UpdateDocumentationPart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDocumentationVersion`](crate::client::fluent_builders::UpdateDocumentationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentationVersion::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateDocumentationVersion::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>..</p>
    ///   - [`documentation_version(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentationVersion::documentation_version) / [`set_documentation_version(Option<String>)`](crate::client::fluent_builders::UpdateDocumentationVersion::set_documentation_version): <p>[Required] The version identifier of the to-be-updated documentation version.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateDocumentationVersion::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateDocumentationVersion::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateDocumentationVersionOutput`](crate::output::UpdateDocumentationVersionOutput) with field(s):
    ///   - [`version(Option<String>)`](crate::output::UpdateDocumentationVersionOutput::version): <p>The version identifier of the API documentation snapshot.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateDocumentationVersionOutput::created_date): <p>The date when the API documentation snapshot is created.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateDocumentationVersionOutput::description): <p>The description of the API documentation snapshot.</p>
    /// - On failure, responds with [`SdkError<UpdateDocumentationVersionError>`](crate::error::UpdateDocumentationVersionError)
    pub fn update_documentation_version(
        &self,
    ) -> fluent_builders::UpdateDocumentationVersion<C, M, R> {
        fluent_builders::UpdateDocumentationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainName`](crate::client::fluent_builders::UpdateDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainName::set_domain_name): <p>[Required] The name of the <code>DomainName</code> resource to be changed.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateDomainName::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateDomainName::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::UpdateDomainNameOutput::domain_name): <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
    ///   - [`certificate_name(Option<String>)`](crate::output::UpdateDomainNameOutput::certificate_name): <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    ///   - [`certificate_arn(Option<String>)`](crate::output::UpdateDomainNameOutput::certificate_arn): <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    ///   - [`certificate_upload_date(Option<DateTime>)`](crate::output::UpdateDomainNameOutput::certificate_upload_date): <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    ///   - [`regional_domain_name(Option<String>)`](crate::output::UpdateDomainNameOutput::regional_domain_name): <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
    ///   - [`regional_hosted_zone_id(Option<String>)`](crate::output::UpdateDomainNameOutput::regional_hosted_zone_id): <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    ///   - [`regional_certificate_name(Option<String>)`](crate::output::UpdateDomainNameOutput::regional_certificate_name): <p>The name of the certificate that will be used for validating the regional domain name.</p>
    ///   - [`regional_certificate_arn(Option<String>)`](crate::output::UpdateDomainNameOutput::regional_certificate_arn): <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
    ///   - [`distribution_domain_name(Option<String>)`](crate::output::UpdateDomainNameOutput::distribution_domain_name): <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
    ///   - [`distribution_hosted_zone_id(Option<String>)`](crate::output::UpdateDomainNameOutput::distribution_hosted_zone_id): <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    ///   - [`endpoint_configuration(Option<EndpointConfiguration>)`](crate::output::UpdateDomainNameOutput::endpoint_configuration): <p>The endpoint configuration of this <code>DomainName</code> showing the endpoint types of the domain name.</p>
    ///   - [`domain_name_status(Option<DomainNameStatus>)`](crate::output::UpdateDomainNameOutput::domain_name_status): <p>The status of the <code>DomainName</code> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
    ///   - [`domain_name_status_message(Option<String>)`](crate::output::UpdateDomainNameOutput::domain_name_status_message): <p>An optional text message containing detailed information about status of the <code>DomainName</code> migration.</p>
    ///   - [`security_policy(Option<SecurityPolicy>)`](crate::output::UpdateDomainNameOutput::security_policy): <p>The Transport Layer Security (TLS) version + cipher suite for this <code>DomainName</code>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateDomainNameOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`mutual_tls_authentication(Option<MutualTlsAuthentication>)`](crate::output::UpdateDomainNameOutput::mutual_tls_authentication): <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
    ///   - [`ownership_verification_certificate_arn(Option<String>)`](crate::output::UpdateDomainNameOutput::ownership_verification_certificate_arn): <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    /// - On failure, responds with [`SdkError<UpdateDomainNameError>`](crate::error::UpdateDomainNameError)
    pub fn update_domain_name(&self) -> fluent_builders::UpdateDomainName<C, M, R> {
        fluent_builders::UpdateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGatewayResponse`](crate::client::fluent_builders::UpdateGatewayResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateGatewayResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`response_type(GatewayResponseType)`](crate::client::fluent_builders::UpdateGatewayResponse::response_type) / [`set_response_type(Option<GatewayResponseType>)`](crate::client::fluent_builders::UpdateGatewayResponse::set_response_type): <p>[Required] </p> <p>The response type of the associated <code>GatewayResponse</code>.</p> <p></p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateGatewayResponse::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateGatewayResponse::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateGatewayResponseOutput`](crate::output::UpdateGatewayResponseOutput) with field(s):
    ///   - [`response_type(Option<GatewayResponseType>)`](crate::output::UpdateGatewayResponseOutput::response_type): <p>The response type of the associated <code>GatewayResponse</code>.</p>
    ///   - [`status_code(Option<String>)`](crate::output::UpdateGatewayResponseOutput::status_code): <p>The HTTP status code for this <code>GatewayResponse</code>.</p>
    ///   - [`response_parameters(Option<HashMap<String, String>>)`](crate::output::UpdateGatewayResponseOutput::response_parameters): <p>Response parameters (paths, query strings and headers) of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
    ///   - [`response_templates(Option<HashMap<String, String>>)`](crate::output::UpdateGatewayResponseOutput::response_templates): <p>Response templates of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
    ///   - [`default_response(bool)`](crate::output::UpdateGatewayResponseOutput::default_response): <p>A Boolean flag to indicate whether this <code>GatewayResponse</code> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    /// - On failure, responds with [`SdkError<UpdateGatewayResponseError>`](crate::error::UpdateGatewayResponseError)
    pub fn update_gateway_response(&self) -> fluent_builders::UpdateGatewayResponse<C, M, R> {
        fluent_builders::UpdateGatewayResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIntegration`](crate::client::fluent_builders::UpdateIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_resource_id): <p>[Required] Represents an update integration request's resource identifier.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegration::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::UpdateIntegration::set_http_method): <p>[Required] Represents an update integration request's HTTP method.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateIntegration::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateIntegration::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput) with field(s):
    ///   - [`r#type(Option<IntegrationType>)`](crate::output::UpdateIntegrationOutput::type): <p>Specifies an API method integration type. The valid value is one of the following:</p>  <ul>   <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>   <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>   <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>   <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>   <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>  </ul>  <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <code>VpcLink</code> to connect API Gateway to a network load balancer of a VPC.</p>
    ///   - [`http_method(Option<String>)`](crate::output::UpdateIntegrationOutput::http_method): <p>Specifies the integration's HTTP method type.</p>
    ///   - [`uri(Option<String>)`](crate::output::UpdateIntegrationOutput::uri): <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>  <ul>   <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p> </li>   <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p> </li> </ul>
    ///   - [`connection_type(Option<ConnectionType>)`](crate::output::UpdateIntegrationOutput::connection_type): <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::UpdateIntegrationOutput::connection_id): <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <code>VpcLink</code> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    ///   - [`credentials(Option<String>)`](crate::output::UpdateIntegrationOutput::credentials): <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    ///   - [`request_parameters(Option<HashMap<String, String>>)`](crate::output::UpdateIntegrationOutput::request_parameters): <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    ///   - [`request_templates(Option<HashMap<String, String>>)`](crate::output::UpdateIntegrationOutput::request_templates): <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    ///   - [`passthrough_behavior(Option<String>)`](crate::output::UpdateIntegrationOutput::passthrough_behavior): <div>   <p> Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following: </p>   <ul>    <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li>    <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li>    <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li>   </ul>  </div>
    ///   - [`content_handling(Option<ContentHandlingStrategy>)`](crate::output::UpdateIntegrationOutput::content_handling): <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>  <ul>   <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>   <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>  </ul>  <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    ///   - [`timeout_in_millis(i32)`](crate::output::UpdateIntegrationOutput::timeout_in_millis): <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    ///   - [`cache_namespace(Option<String>)`](crate::output::UpdateIntegrationOutput::cache_namespace): <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    ///   - [`cache_key_parameters(Option<Vec<String>>)`](crate::output::UpdateIntegrationOutput::cache_key_parameters): <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <code>Method</code> <code>requestParameters</code>.</p>
    ///   - [`integration_responses(Option<HashMap<String, IntegrationResponse>>)`](crate::output::UpdateIntegrationOutput::integration_responses): <p>Specifies the integration's responses.</p>  <div class="remarks">   <p></p>   <h4>Example: Get integration responses of a method</h4>   <h5>Request</h5>   <p></p>   <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre>   <h5>Response</h5>   <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>   <pre><code>{   "_links": {     "curies": {       "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",       "name": "integrationresponse",       "templated": true     },     "self": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",       "title": "200"     },     "integrationresponse:delete": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"     },     "integrationresponse:update": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"     }   },   "responseParameters": {     "method.response.header.Content-Type": "'application/xml'"   },   "responseTemplates": {     "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"   },   "statusCode": "200" }</code></pre>   <p></p>  </div>  <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>  </div>
    ///   - [`tls_config(Option<TlsConfig>)`](crate::output::UpdateIntegrationOutput::tls_config): <p>Specifies the TLS configuration for an integration.</p>
    /// - On failure, responds with [`SdkError<UpdateIntegrationError>`](crate::error::UpdateIntegrationError)
    pub fn update_integration(&self) -> fluent_builders::UpdateIntegration<C, M, R> {
        fluent_builders::UpdateIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIntegrationResponse`](crate::client::fluent_builders::UpdateIntegrationResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_resource_id): <p>[Required] Specifies an update integration response request's resource identifier.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_http_method): <p>[Required] Specifies an update integration response request's HTTP method.</p>
    ///   - [`status_code(impl Into<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::status_code) / [`set_status_code(Option<String>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_status_code): <p>[Required] Specifies an update integration response request's status code.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateIntegrationResponse::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateIntegrationResponse::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput) with field(s):
    ///   - [`status_code(Option<String>)`](crate::output::UpdateIntegrationResponseOutput::status_code): <p>Specifies the status code that is used to map the integration response to an existing <code>MethodResponse</code>.</p>
    ///   - [`selection_pattern(Option<String>)`](crate::output::UpdateIntegrationResponseOutput::selection_pattern): <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    ///   - [`response_parameters(Option<HashMap<String, String>>)`](crate::output::UpdateIntegrationResponseOutput::response_parameters): <p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    ///   - [`response_templates(Option<HashMap<String, String>>)`](crate::output::UpdateIntegrationResponseOutput::response_templates): <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    ///   - [`content_handling(Option<ContentHandlingStrategy>)`](crate::output::UpdateIntegrationResponseOutput::content_handling): <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>  <ul>   <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>   <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>  </ul>  <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    /// - On failure, responds with [`SdkError<UpdateIntegrationResponseError>`](crate::error::UpdateIntegrationResponseError)
    pub fn update_integration_response(
        &self,
    ) -> fluent_builders::UpdateIntegrationResponse<C, M, R> {
        fluent_builders::UpdateIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMethod`](crate::client::fluent_builders::UpdateMethod) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMethod::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateMethod::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMethod::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateMethod::set_resource_id): <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::UpdateMethod::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::UpdateMethod::set_http_method): <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateMethod::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateMethod::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateMethodOutput`](crate::output::UpdateMethodOutput) with field(s):
    ///   - [`http_method(Option<String>)`](crate::output::UpdateMethodOutput::http_method): <p>The method's HTTP verb.</p>
    ///   - [`authorization_type(Option<String>)`](crate::output::UpdateMethodOutput::authorization_type): <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    ///   - [`authorizer_id(Option<String>)`](crate::output::UpdateMethodOutput::authorizer_id): <p>The identifier of an <code>Authorizer</code> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    ///   - [`api_key_required(Option<bool>)`](crate::output::UpdateMethodOutput::api_key_required): <p>A boolean flag specifying whether a valid <code>ApiKey</code> is required to invoke this method.</p>
    ///   - [`request_validator_id(Option<String>)`](crate::output::UpdateMethodOutput::request_validator_id): <p>The identifier of a <code>RequestValidator</code> for request validation.</p>
    ///   - [`operation_name(Option<String>)`](crate::output::UpdateMethodOutput::operation_name): <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    ///   - [`request_parameters(Option<HashMap<String, bool>>)`](crate::output::UpdateMethodOutput::request_parameters): <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <code>Integration</code> to be mapped to integration request parameters or templates.</p>
    ///   - [`request_models(Option<HashMap<String, String>>)`](crate::output::UpdateMethodOutput::request_models): <p>A key-value map specifying data schemas, represented by <code>Model</code> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    ///   - [`method_responses(Option<HashMap<String, MethodResponse>>)`](crate::output::UpdateMethodOutput::method_responses): <p>Gets a method response associated with a given HTTP status code. </p>  <div class="remarks">   <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <code>MethodResponse</code> resource that specifies the response returned to the caller from the back end through the integration response.</p>   <h4>Example: Get a 200 OK response of a GET method</h4>   <h5>Request</h5>   <p></p>   <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T215008Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>   <h5>Response</h5>   <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>   <pre><code>{   "_links": {     "curies": {       "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",       "name": "methodresponse",       "templated": true     },     "self": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",       "title": "200"     },     "methodresponse:delete": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"     },     "methodresponse:update": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"     }   },   "responseModels": {     "application/json": "Empty"   },   "responseParameters": {     "method.response.header.operator": false,     "method.response.header.operand_2": false,     "method.response.header.operand_1": false   },   "statusCode": "200" }</code></pre>   <p></p>  </div>  <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>  </div>
    ///   - [`method_integration(Option<Integration>)`](crate::output::UpdateMethodOutput::method_integration): <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>  <div class="remarks">   <p></p>   <h4>Example: </h4>   <h5>Request</h5>   <p></p>   <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T213210Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>   <h5>Response</h5>   <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>   <pre><code>{   "_links": {     "curies": [       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",         "name": "integration",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",         "name": "integrationresponse",         "templated": true       }     ],     "self": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"     },     "integration:delete": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"     },     "integration:responses": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",       "name": "200",       "title": "200"     },     "integration:update": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"     },     "integrationresponse:put": {       "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",       "templated": true     }   },   "cacheKeyParameters": [],   "cacheNamespace": "0cjtch",   "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",   "httpMethod": "POST",   "passthroughBehavior": "WHEN_NO_MATCH",   "requestTemplates": {     "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"   },   "type": "AWS",   "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",   "_embedded": {     "integration:responses": {       "_links": {         "self": {           "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",           "name": "200",           "title": "200"         },         "integrationresponse:delete": {           "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"         },         "integrationresponse:update": {           "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"         }       },       "responseParameters": {         "method.response.header.operator": "integration.response.body.op",         "method.response.header.operand_2": "integration.response.body.b",         "method.response.header.operand_1": "integration.response.body.a"       },       "responseTemplates": {         "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op =&gt; $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"       },       "selectionPattern": "",       "statusCode": "200"     }   } }</code></pre>   <p></p>  </div>  <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>  </div>
    ///   - [`authorization_scopes(Option<Vec<String>>)`](crate::output::UpdateMethodOutput::authorization_scopes): <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    /// - On failure, responds with [`SdkError<UpdateMethodError>`](crate::error::UpdateMethodError)
    pub fn update_method(&self) -> fluent_builders::UpdateMethod<C, M, R> {
        fluent_builders::UpdateMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMethodResponse`](crate::client::fluent_builders::UpdateMethodResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMethodResponse::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateMethodResponse::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMethodResponse::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateMethodResponse::set_resource_id): <p>[Required] The <code>Resource</code> identifier for the <code>MethodResponse</code> resource.</p>
    ///   - [`http_method(impl Into<String>)`](crate::client::fluent_builders::UpdateMethodResponse::http_method) / [`set_http_method(Option<String>)`](crate::client::fluent_builders::UpdateMethodResponse::set_http_method): <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
    ///   - [`status_code(impl Into<String>)`](crate::client::fluent_builders::UpdateMethodResponse::status_code) / [`set_status_code(Option<String>)`](crate::client::fluent_builders::UpdateMethodResponse::set_status_code): <p>[Required] The status code for the <code>MethodResponse</code> resource.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateMethodResponse::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateMethodResponse::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateMethodResponseOutput`](crate::output::UpdateMethodResponseOutput) with field(s):
    ///   - [`status_code(Option<String>)`](crate::output::UpdateMethodResponseOutput::status_code): <p>The method response's status code.</p>
    ///   - [`response_parameters(Option<HashMap<String, bool>>)`](crate::output::UpdateMethodResponseOutput::response_parameters): <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <code>IntegrationResponse</code>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    ///   - [`response_models(Option<HashMap<String, String>>)`](crate::output::UpdateMethodResponseOutput::response_models): <p>Specifies the <code>Model</code> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <code>Model</code> name as the value.</p>
    /// - On failure, responds with [`SdkError<UpdateMethodResponseError>`](crate::error::UpdateMethodResponseError)
    pub fn update_method_response(&self) -> fluent_builders::UpdateMethodResponse<C, M, R> {
        fluent_builders::UpdateMethodResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateModel`](crate::client::fluent_builders::UpdateModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`model_name(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::model_name) / [`set_model_name(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_model_name): <p>[Required] The name of the model to update.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateModel::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateModel::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateModelOutput`](crate::output::UpdateModelOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateModelOutput::id): <p>The identifier for the model resource.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateModelOutput::name): <p>The name of the model. Must be an alphanumeric string.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateModelOutput::description): <p>The description of the model.</p>
    ///   - [`schema(Option<String>)`](crate::output::UpdateModelOutput::schema): <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
    ///   - [`content_type(Option<String>)`](crate::output::UpdateModelOutput::content_type): <p>The content-type for the model.</p>
    /// - On failure, responds with [`SdkError<UpdateModelError>`](crate::error::UpdateModelError)
    pub fn update_model(&self) -> fluent_builders::UpdateModel<C, M, R> {
        fluent_builders::UpdateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRequestValidator`](crate::client::fluent_builders::UpdateRequestValidator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRequestValidator::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateRequestValidator::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`request_validator_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRequestValidator::request_validator_id) / [`set_request_validator_id(Option<String>)`](crate::client::fluent_builders::UpdateRequestValidator::set_request_validator_id): <p>[Required] The identifier of <code>RequestValidator</code> to be updated.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateRequestValidator::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateRequestValidator::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateRequestValidatorOutput`](crate::output::UpdateRequestValidatorOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateRequestValidatorOutput::id): <p>The identifier of this <code>RequestValidator</code>.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateRequestValidatorOutput::name): <p>The name of this <code>RequestValidator</code></p>
    ///   - [`validate_request_body(bool)`](crate::output::UpdateRequestValidatorOutput::validate_request_body): <p>A Boolean flag to indicate whether to validate a request body according to the configured <code>Model</code> schema.</p>
    ///   - [`validate_request_parameters(bool)`](crate::output::UpdateRequestValidatorOutput::validate_request_parameters): <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
    /// - On failure, responds with [`SdkError<UpdateRequestValidatorError>`](crate::error::UpdateRequestValidatorError)
    pub fn update_request_validator(&self) -> fluent_builders::UpdateRequestValidator<C, M, R> {
        fluent_builders::UpdateRequestValidator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResource`](crate::client::fluent_builders::UpdateResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResource::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateResource::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateResource::set_resource_id): <p>[Required] The identifier of the <code>Resource</code> resource.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateResource::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateResource::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateResourceOutput`](crate::output::UpdateResourceOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateResourceOutput::id): <p>The resource's identifier.</p>
    ///   - [`parent_id(Option<String>)`](crate::output::UpdateResourceOutput::parent_id): <p>The parent resource's identifier.</p>
    ///   - [`path_part(Option<String>)`](crate::output::UpdateResourceOutput::path_part): <p>The last path segment for this resource.</p>
    ///   - [`path(Option<String>)`](crate::output::UpdateResourceOutput::path): <p>The full path for this resource.</p>
    ///   - [`resource_methods(Option<HashMap<String, Method>>)`](crate::output::UpdateResourceOutput::resource_methods): <p>Gets an API resource's method of a given HTTP verb.</p>  <div class="remarks">   <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>   <h4>Example: Get the GET method of an API resource</h4>   <h5>Request</h5>   <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20170223T031827Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>   <h5>Response</h5>   <pre><code>{   "_links": {     "curies": [       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",         "name": "integration",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",         "name": "integrationresponse",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",         "name": "method",         "templated": true       },       {         "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",         "name": "methodresponse",         "templated": true       }     ],     "self": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",       "name": "GET",       "title": "GET"     },     "integration:put": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"     },     "method:delete": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"     },     "method:integration": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"     },     "method:responses": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",       "name": "200",       "title": "200"     },     "method:update": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"     },     "methodresponse:put": {       "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",       "templated": true     }   },   "apiKeyRequired": false,   "authorizationType": "NONE",   "httpMethod": "GET",   "_embedded": {     "method:integration": {       "_links": {         "self": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"         },         "integration:delete": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"         },         "integration:responses": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",           "name": "200",           "title": "200"         },         "integration:update": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"         },         "integrationresponse:put": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",           "templated": true         }       },       "cacheKeyParameters": [],       "cacheNamespace": "3kzxbg5sa2",       "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",       "httpMethod": "POST",       "passthroughBehavior": "WHEN_NO_MATCH",       "requestParameters": {         "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"       },       "requestTemplates": {         "application/json": "{\n}"       },       "type": "AWS",       "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",       "_embedded": {         "integration:responses": {           "_links": {             "self": {               "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",               "name": "200",               "title": "200"             },             "integrationresponse:delete": {               "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"             },             "integrationresponse:update": {               "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"             }           },           "responseParameters": {             "method.response.header.Content-Type": "'application/xml'"           },           "responseTemplates": {             "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"           },           "statusCode": "200"         }       }     },     "method:responses": {       "_links": {         "self": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",           "name": "200",           "title": "200"         },         "methodresponse:delete": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"         },         "methodresponse:update": {           "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"         }       },       "responseModels": {         "application/json": "Empty"       },       "responseParameters": {         "method.response.header.Content-Type": false       },       "statusCode": "200"     }   } }</code></pre>   <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>  </div>  <div class="seeAlso">  </div>
    /// - On failure, responds with [`SdkError<UpdateResourceError>`](crate::error::UpdateResourceError)
    pub fn update_resource(&self) -> fluent_builders::UpdateResource<C, M, R> {
        fluent_builders::UpdateResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRestApi`](crate::client::fluent_builders::UpdateRestApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRestApi::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateRestApi::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateRestApi::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateRestApi::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateRestApiOutput`](crate::output::UpdateRestApiOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateRestApiOutput::id): <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateRestApiOutput::name): <p>The API's name.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateRestApiOutput::description): <p>The API's description.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateRestApiOutput::created_date): <p>The timestamp when the API was created.</p>
    ///   - [`version(Option<String>)`](crate::output::UpdateRestApiOutput::version): <p>A version identifier for the API.</p>
    ///   - [`warnings(Option<Vec<String>>)`](crate::output::UpdateRestApiOutput::warnings): <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    ///   - [`binary_media_types(Option<Vec<String>>)`](crate::output::UpdateRestApiOutput::binary_media_types): <p>The list of binary media types supported by the <code>RestApi</code>. By default, the <code>RestApi</code> supports only UTF-8-encoded text payloads.</p>
    ///   - [`minimum_compression_size(Option<i32>)`](crate::output::UpdateRestApiOutput::minimum_compression_size): <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    ///   - [`api_key_source(Option<ApiKeySourceType>)`](crate::output::UpdateRestApiOutput::api_key_source): <p>The source of the API key for metering requests according to a usage plan. Valid values are: </p> <ul>  <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li>  <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li> </ul> <p></p>
    ///   - [`endpoint_configuration(Option<EndpointConfiguration>)`](crate::output::UpdateRestApiOutput::endpoint_configuration): <p>The endpoint configuration of this <code>RestApi</code> showing the endpoint types of the API.</p>
    ///   - [`policy(Option<String>)`](crate::output::UpdateRestApiOutput::policy): <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <code>Method</code> configuration.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateRestApiOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`disable_execute_api_endpoint(bool)`](crate::output::UpdateRestApiOutput::disable_execute_api_endpoint): <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    /// - On failure, responds with [`SdkError<UpdateRestApiError>`](crate::error::UpdateRestApiError)
    pub fn update_rest_api(&self) -> fluent_builders::UpdateRestApi<C, M, R> {
        fluent_builders::UpdateRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStage`](crate::client::fluent_builders::UpdateStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rest_api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::rest_api_id) / [`set_rest_api_id(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_rest_api_id): <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_stage_name): <p>[Required] The name of the <code>Stage</code> resource to change information about.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateStage::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateStage::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateStageOutput`](crate::output::UpdateStageOutput) with field(s):
    ///   - [`deployment_id(Option<String>)`](crate::output::UpdateStageOutput::deployment_id): <p>The identifier of the <code>Deployment</code> that the stage points to.</p>
    ///   - [`client_certificate_id(Option<String>)`](crate::output::UpdateStageOutput::client_certificate_id): <p>The identifier of a client certificate for an API stage.</p>
    ///   - [`stage_name(Option<String>)`](crate::output::UpdateStageOutput::stage_name): <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateStageOutput::description): <p>The stage's description.</p>
    ///   - [`cache_cluster_enabled(bool)`](crate::output::UpdateStageOutput::cache_cluster_enabled): <p>Specifies whether a cache cluster is enabled for the stage.</p>
    ///   - [`cache_cluster_size(Option<CacheClusterSize>)`](crate::output::UpdateStageOutput::cache_cluster_size): <p>The size of the cache cluster for the stage, if enabled.</p>
    ///   - [`cache_cluster_status(Option<CacheClusterStatus>)`](crate::output::UpdateStageOutput::cache_cluster_status): <p>The status of the cache cluster for the stage, if enabled.</p>
    ///   - [`method_settings(Option<HashMap<String, MethodSetting>>)`](crate::output::UpdateStageOutput::method_settings): <p>A map that defines the method settings for a <code>Stage</code> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage. <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
    ///   - [`variables(Option<HashMap<String, String>>)`](crate::output::UpdateStageOutput::variables): <p>A map that defines the stage variables for a <code>Stage</code> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>
    ///   - [`documentation_version(Option<String>)`](crate::output::UpdateStageOutput::documentation_version): <p>The version of the associated API documentation.</p>
    ///   - [`access_log_settings(Option<AccessLogSettings>)`](crate::output::UpdateStageOutput::access_log_settings): <p>Settings for logging access in this stage.</p>
    ///   - [`canary_settings(Option<CanarySettings>)`](crate::output::UpdateStageOutput::canary_settings): <p>Settings for the canary deployment in this stage.</p>
    ///   - [`tracing_enabled(bool)`](crate::output::UpdateStageOutput::tracing_enabled): <p>Specifies whether active tracing with X-ray is enabled for the <code>Stage</code>.</p>
    ///   - [`web_acl_arn(Option<String>)`](crate::output::UpdateStageOutput::web_acl_arn): <p>The ARN of the WebAcl associated with the <code>Stage</code>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateStageOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdateStageOutput::created_date): <p>The timestamp when the stage was created.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::UpdateStageOutput::last_updated_date): <p>The timestamp when the stage last updated.</p>
    /// - On failure, responds with [`SdkError<UpdateStageError>`](crate::error::UpdateStageError)
    pub fn update_stage(&self) -> fluent_builders::UpdateStage<C, M, R> {
        fluent_builders::UpdateStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUsage`](crate::client::fluent_builders::UpdateUsage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_plan_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUsage::usage_plan_id) / [`set_usage_plan_id(Option<String>)`](crate::client::fluent_builders::UpdateUsage::set_usage_plan_id): <p>[Required] The Id of the usage plan associated with the usage data.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUsage::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::UpdateUsage::set_key_id): <p>[Required] The identifier of the API key associated with the usage plan in which a temporary extension is granted to the remaining quota.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateUsage::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateUsage::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateUsageOutput`](crate::output::UpdateUsageOutput) with field(s):
    ///   - [`usage_plan_id(Option<String>)`](crate::output::UpdateUsageOutput::usage_plan_id): <p>The plan Id associated with this usage data.</p>
    ///   - [`start_date(Option<String>)`](crate::output::UpdateUsageOutput::start_date): <p>The starting date of the usage data.</p>
    ///   - [`end_date(Option<String>)`](crate::output::UpdateUsageOutput::end_date): <p>The ending date of the usage data.</p>
    ///   - [`items(Option<HashMap<String, Vec<Vec<i64>>>>)`](crate::output::UpdateUsageOutput::items): <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
    ///   - [`position(Option<String>)`](crate::output::UpdateUsageOutput::position): <p>The current pagination position in the paged result set.</p>
    /// - On failure, responds with [`SdkError<UpdateUsageError>`](crate::error::UpdateUsageError)
    pub fn update_usage(&self) -> fluent_builders::UpdateUsage<C, M, R> {
        fluent_builders::UpdateUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUsagePlan`](crate::client::fluent_builders::UpdateUsagePlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_plan_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUsagePlan::usage_plan_id) / [`set_usage_plan_id(Option<String>)`](crate::client::fluent_builders::UpdateUsagePlan::set_usage_plan_id): <p>[Required] The Id of the to-be-updated usage plan.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateUsagePlan::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateUsagePlan::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateUsagePlanOutput`](crate::output::UpdateUsagePlanOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateUsagePlanOutput::id): <p>The identifier of a <code>UsagePlan</code> resource.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateUsagePlanOutput::name): <p>The name of a usage plan.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateUsagePlanOutput::description): <p>The description of a usage plan.</p>
    ///   - [`api_stages(Option<Vec<ApiStage>>)`](crate::output::UpdateUsagePlanOutput::api_stages): <p>The associated API stages of a usage plan.</p>
    ///   - [`throttle(Option<ThrottleSettings>)`](crate::output::UpdateUsagePlanOutput::throttle): <p>Map containing method level throttling information for API stage in a usage plan.</p>
    ///   - [`quota(Option<QuotaSettings>)`](crate::output::UpdateUsagePlanOutput::quota): <p>The target maximum number of permitted requests per a given unit time interval.</p>
    ///   - [`product_code(Option<String>)`](crate::output::UpdateUsagePlanOutput::product_code): <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateUsagePlanOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<UpdateUsagePlanError>`](crate::error::UpdateUsagePlanError)
    pub fn update_usage_plan(&self) -> fluent_builders::UpdateUsagePlan<C, M, R> {
        fluent_builders::UpdateUsagePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVpcLink`](crate::client::fluent_builders::UpdateVpcLink) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_link_id(impl Into<String>)`](crate::client::fluent_builders::UpdateVpcLink::vpc_link_id) / [`set_vpc_link_id(Option<String>)`](crate::client::fluent_builders::UpdateVpcLink::set_vpc_link_id): <p>[Required] The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
    ///   - [`patch_operations(Vec<PatchOperation>)`](crate::client::fluent_builders::UpdateVpcLink::patch_operations) / [`set_patch_operations(Option<Vec<PatchOperation>>)`](crate::client::fluent_builders::UpdateVpcLink::set_patch_operations): <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
    /// - On success, responds with [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateVpcLinkOutput::id): <p>The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateVpcLinkOutput::name): <p>The name used to label and identify the VPC link.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateVpcLinkOutput::description): <p>The description of the VPC link.</p>
    ///   - [`target_arns(Option<Vec<String>>)`](crate::output::UpdateVpcLinkOutput::target_arns): <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    ///   - [`status(Option<VpcLinkStatus>)`](crate::output::UpdateVpcLinkOutput::status): <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
    ///   - [`status_message(Option<String>)`](crate::output::UpdateVpcLinkOutput::status_message): <p>A description about the VPC link status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateVpcLinkOutput::tags): <p>The collection of tags. Each tag element is associated with a given resource.</p>
    /// - On failure, responds with [`SdkError<UpdateVpcLinkError>`](crate::error::UpdateVpcLinkError)
    pub fn update_vpc_link(&self) -> fluent_builders::UpdateVpcLink<C, M, R> {
        fluent_builders::UpdateVpcLink::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApiKey`.
    ///
    /// <p>Create an <code>ApiKey</code> resource. </p>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</a>
    /// </div>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_api_key_input::Builder,
    }
    impl<C, M, R> CreateApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApiKeyInputOperationOutputAlias,
                crate::output::CreateApiKeyOutput,
                crate::error::CreateApiKeyError,
                crate::input::CreateApiKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>ApiKey</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the <code>ApiKey</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the <code>ApiKey</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the <code>ApiKey</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies whether the <code>ApiKey</code> can be used by callers.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>Specifies whether the <code>ApiKey</code> can be used by callers.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.</p>
        pub fn generate_distinct_id(mut self, input: bool) -> Self {
            self.inner = self.inner.generate_distinct_id(input);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.</p>
        pub fn set_generate_distinct_id(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_generate_distinct_id(input);
            self
        }
        /// <p>Specifies a value of the API key.</p> <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(input.into());
            self
        }
        /// <p>Specifies a value of the API key.</p> <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
        /// Appends an item to `stageKeys`.
        ///
        /// To override the contents of this collection use [`set_stage_keys`](Self::set_stage_keys).
        ///
        /// <p>DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.</p>
        pub fn stage_keys(mut self, input: crate::model::StageKey) -> Self {
            self.inner = self.inner.stage_keys(input);
            self
        }
        /// <p>DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.</p>
        pub fn set_stage_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StageKey>>,
        ) -> Self {
            self.inner = self.inner.set_stage_keys(input);
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn customer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_id(input.into());
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn set_customer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_customer_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuthorizer`.
    ///
    /// <p>Adds a new <code>Authorizer</code> resource to an existing <code>RestApi</code> resource.</p>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</a>
    /// </div>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_authorizer_input::Builder,
    }
    impl<C, M, R> CreateAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAuthorizerInputOperationOutputAlias,
                crate::output::CreateAuthorizerOutput,
                crate::error::CreateAuthorizerError,
                crate::input::CreateAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>[Required] The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn r#type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>[Required] The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `providerARNs`.
        ///
        /// To override the contents of this collection use [`set_provider_ar_ns`](Self::set_provider_ar_ns).
        ///
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_ar_ns(input.into());
            self
        }
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn set_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_provider_ar_ns(input);
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn auth_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_type(input.into());
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn set_auth_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_type(input);
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_uri(input.into());
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_uri(input);
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn authorizer_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_credentials(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn set_authorizer_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_credentials(input);
            self
        }
        /// <p>The identity source for which authorization is requested. </p>
        /// <ul>
        /// <li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li>
        /// <li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li>
        /// </ul>
        /// <p></p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_source(input.into());
            self
        }
        /// <p>The identity source for which authorization is requested. </p>
        /// <ul>
        /// <li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li>
        /// <li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li>
        /// </ul>
        /// <p></p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_source(input);
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_validation_expression(input.into());
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_validation_expression(input);
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.authorizer_result_ttl_in_seconds(input);
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_result_ttl_in_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBasePathMapping`.
    ///
    /// <p>Creates a new <code>BasePathMapping</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBasePathMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_base_path_mapping_input::Builder,
    }
    impl<C, M, R> CreateBasePathMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBasePathMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBasePathMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBasePathMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBasePathMappingInputOperationOutputAlias,
                crate::output::CreateBasePathMappingOutput,
                crate::error::CreateBasePathMappingError,
                crate::input::CreateBasePathMappingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The domain name of the <code>BasePathMapping</code> resource to create.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>[Required] The domain name of the <code>BasePathMapping</code> resource to create.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_path(input.into());
            self
        }
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_base_path(input);
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage(input.into());
            self
        }
        /// <p>The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// <p>Creates a <code>Deployment</code> resource, which makes a specified <code>RestApi</code> callable over the internet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl<C, M, R> CreateDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeploymentInputOperationOutputAlias,
                crate::output::CreateDeploymentOutput,
                crate::error::CreateDeploymentError,
                crate::input::CreateDeploymentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The name of the <code>Stage</code> resource for the <code>Deployment</code> resource to create.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the <code>Stage</code> resource for the <code>Deployment</code> resource to create.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>The description of the <code>Stage</code> resource for the <code>Deployment</code> resource to create.</p>
        pub fn stage_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_description(input.into());
            self
        }
        /// <p>The description of the <code>Stage</code> resource for the <code>Deployment</code> resource to create.</p>
        pub fn set_stage_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stage_description(input);
            self
        }
        /// <p>The description for the <code>Deployment</code> resource to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the <code>Deployment</code> resource to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Enables a cache cluster for the <code>Stage</code> resource specified in the input.</p>
        pub fn cache_cluster_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.cache_cluster_enabled(input);
            self
        }
        /// <p>Enables a cache cluster for the <code>Stage</code> resource specified in the input.</p>
        pub fn set_cache_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cache_cluster_enabled(input);
            self
        }
        /// <p>Specifies the cache cluster size for the <code>Stage</code> resource specified in the input, if a cache cluster is enabled.</p>
        pub fn cache_cluster_size(mut self, input: crate::model::CacheClusterSize) -> Self {
            self.inner = self.inner.cache_cluster_size(input);
            self
        }
        /// <p>Specifies the cache cluster size for the <code>Stage</code> resource specified in the input, if a cache cluster is enabled.</p>
        pub fn set_cache_cluster_size(
            mut self,
            input: std::option::Option<crate::model::CacheClusterSize>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_size(input);
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>A map that defines the stage variables for the <code>Stage</code> resource that is associated with the new deployment. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.variables(k.into(), v.into());
            self
        }
        /// <p>A map that defines the stage variables for the <code>Stage</code> resource that is associated with the new deployment. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_variables(input);
            self
        }
        /// <p>The input configuration for the canary deployment when the deployment is a canary release deployment. </p>
        pub fn canary_settings(mut self, input: crate::model::DeploymentCanarySettings) -> Self {
            self.inner = self.inner.canary_settings(input);
            self
        }
        /// <p>The input configuration for the canary deployment when the deployment is a canary release deployment. </p>
        pub fn set_canary_settings(
            mut self,
            input: std::option::Option<crate::model::DeploymentCanarySettings>,
        ) -> Self {
            self.inner = self.inner.set_canary_settings(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <code>Stage</code>.</p>
        pub fn tracing_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.tracing_enabled(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <code>Stage</code>.</p>
        pub fn set_tracing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_tracing_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDocumentationPart`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDocumentationPart<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_documentation_part_input::Builder,
    }
    impl<C, M, R> CreateDocumentationPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDocumentationPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDocumentationPartOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDocumentationPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDocumentationPartInputOperationOutputAlias,
                crate::output::CreateDocumentationPartOutput,
                crate::error::CreateDocumentationPartError,
                crate::input::CreateDocumentationPartInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The location of the targeted API entity of the to-be-created documentation part.</p>
        pub fn location(mut self, input: crate::model::DocumentationPartLocation) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>[Required] The location of the targeted API entity of the to-be-created documentation part.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::DocumentationPartLocation>,
        ) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>[Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.</p>
        pub fn properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.properties(input.into());
            self
        }
        /// <p>[Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.</p>
        pub fn set_properties(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDocumentationVersion`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDocumentationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_documentation_version_input::Builder,
    }
    impl<C, M, R> CreateDocumentationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDocumentationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDocumentationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDocumentationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDocumentationVersionInputOperationOutputAlias,
                crate::output::CreateDocumentationVersionOutput,
                crate::error::CreateDocumentationVersionError,
                crate::input::CreateDocumentationVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The version identifier of the new snapshot.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(input.into());
            self
        }
        /// <p>[Required] The version identifier of the new snapshot.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
        /// <p>The stage name to be associated with the new documentation snapshot.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The stage name to be associated with the new documentation snapshot.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>A description about the new documentation snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description about the new documentation snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainName`.
    ///
    /// <p>Creates a new domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_name_input::Builder,
    }
    impl<C, M, R> CreateDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainNameInputOperationOutputAlias,
                crate::output::CreateDomainNameOutput,
                crate::error::CreateDomainNameError,
                crate::input::CreateDomainNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <code>DomainName</code> resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>[Required] The name of the <code>DomainName</code> resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(input.into());
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
        /// <p>[Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.</p>
        pub fn certificate_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_body(input.into());
            self
        }
        /// <p>[Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.</p>
        pub fn set_certificate_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_body(input);
            self
        }
        /// <p>[Deprecated] Your edge-optimized endpoint's domain name certificate's private key.</p>
        pub fn certificate_private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_private_key(input.into());
            self
        }
        /// <p>[Deprecated] Your edge-optimized endpoint's domain name certificate's private key.</p>
        pub fn set_certificate_private_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_private_key(input);
            self
        }
        /// <p>[Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.</p>
        pub fn certificate_chain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_chain(input.into());
            self
        }
        /// <p>[Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_chain(input);
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by regional endpoint for this domain name.</p>
        pub fn regional_certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regional_certificate_name(input.into());
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by regional endpoint for this domain name.</p>
        pub fn set_regional_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regional_certificate_name(input);
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn regional_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regional_certificate_arn(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_regional_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regional_certificate_arn(input);
            self
        }
        /// <p>The endpoint configuration of this <code>DomainName</code> showing the endpoint types of the domain name.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.inner = self.inner.endpoint_configuration(input);
            self
        }
        /// <p>The endpoint configuration of this <code>DomainName</code> showing the endpoint types of the domain name.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configuration(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <code>DomainName</code>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn security_policy(mut self, input: crate::model::SecurityPolicy) -> Self {
            self.inner = self.inner.security_policy(input);
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <code>DomainName</code>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn set_security_policy(
            mut self,
            input: std::option::Option<crate::model::SecurityPolicy>,
        ) -> Self {
            self.inner = self.inner.set_security_policy(input);
            self
        }
        /// <p>If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthenticationInput,
        ) -> Self {
            self.inner = self.inner.mutual_tls_authentication(input);
            self
        }
        /// <p>If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        ) -> Self {
            self.inner = self.inner.set_mutual_tls_authentication(input);
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn ownership_verification_certificate_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .ownership_verification_certificate_arn(input.into());
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn set_ownership_verification_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ownership_verification_certificate_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModel`.
    ///
    /// <p>Adds a new <code>Model</code> resource to an existing <code>RestApi</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_input::Builder,
    }
    impl<C, M, R> CreateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelInputOperationOutputAlias,
                crate::output::CreateModelOutput,
                crate::error::CreateModelError,
                crate::input::CreateModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The <code>RestApi</code> identifier under which the <code>Model</code> will be created.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The <code>RestApi</code> identifier under which the <code>Model</code> will be created.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>[Required] The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// <p>[Required] The content-type for the model.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>[Required] The content-type for the model.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRequestValidator`.
    ///
    /// <p>Creates a <code>ReqeustValidator</code> of a given <code>RestApi</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRequestValidator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_request_validator_input::Builder,
    }
    impl<C, M, R> CreateRequestValidator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRequestValidator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRequestValidatorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRequestValidatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRequestValidatorInputOperationOutputAlias,
                crate::output::CreateRequestValidatorOutput,
                crate::error::CreateRequestValidatorError,
                crate::input::CreateRequestValidatorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The name of the to-be-created <code>RequestValidator</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the to-be-created <code>RequestValidator</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).</p>
        pub fn validate_request_body(mut self, input: bool) -> Self {
            self.inner = self.inner.validate_request_body(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).</p>
        pub fn set_validate_request_body(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_validate_request_body(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.</p>
        pub fn validate_request_parameters(mut self, input: bool) -> Self {
            self.inner = self.inner.validate_request_parameters(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.</p>
        pub fn set_validate_request_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_validate_request_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResource`.
    ///
    /// <p>Creates a <code>Resource</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_input::Builder,
    }
    impl<C, M, R> CreateResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceInputOperationOutputAlias,
                crate::output::CreateResourceOutput,
                crate::error::CreateResourceError,
                crate::input::CreateResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The parent resource's identifier.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(input.into());
            self
        }
        /// <p>[Required] The parent resource's identifier.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn path_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_part(input.into());
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn set_path_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_part(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRestApi`.
    ///
    /// <p>Creates a new <code>RestApi</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rest_api_input::Builder,
    }
    impl<C, M, R> CreateRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRestApiInputOperationOutputAlias,
                crate::output::CreateRestApiOutput,
                crate::error::CreateRestApiError,
                crate::input::CreateRestApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <code>RestApi</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>[Required] The name of the <code>RestApi</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the <code>RestApi</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the <code>RestApi</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The ID of the <code>RestApi</code> that you want to clone from.</p>
        pub fn clone_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.clone_from(input.into());
            self
        }
        /// <p>The ID of the <code>RestApi</code> that you want to clone from.</p>
        pub fn set_clone_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_clone_from(input);
            self
        }
        /// Appends an item to `binaryMediaTypes`.
        ///
        /// To override the contents of this collection use [`set_binary_media_types`](Self::set_binary_media_types).
        ///
        /// <p>The list of binary media types supported by the <code>RestApi</code>. By default, the <code>RestApi</code> supports only UTF-8-encoded text payloads.</p>
        pub fn binary_media_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.binary_media_types(input.into());
            self
        }
        /// <p>The list of binary media types supported by the <code>RestApi</code>. By default, the <code>RestApi</code> supports only UTF-8-encoded text payloads.</p>
        pub fn set_binary_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_binary_media_types(input);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn minimum_compression_size(mut self, input: i32) -> Self {
            self.inner = self.inner.minimum_compression_size(input);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn set_minimum_compression_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_minimum_compression_size(input);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: </p>
        /// <ul>
        /// <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li>
        /// <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li>
        /// </ul>
        /// <p></p>
        pub fn api_key_source(mut self, input: crate::model::ApiKeySourceType) -> Self {
            self.inner = self.inner.api_key_source(input);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: </p>
        /// <ul>
        /// <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li>
        /// <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li>
        /// </ul>
        /// <p></p>
        pub fn set_api_key_source(
            mut self,
            input: std::option::Option<crate::model::ApiKeySourceType>,
        ) -> Self {
            self.inner = self.inner.set_api_key_source(input);
            self
        }
        /// <p>The endpoint configuration of this <code>RestApi</code> showing the endpoint types of the API.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.inner = self.inner.endpoint_configuration(input);
            self
        }
        /// <p>The endpoint configuration of this <code>RestApi</code> showing the endpoint types of the API.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configuration(input);
            self
        }
        /// A stringified JSON policy document that applies to this RestApi regardless of the caller and <code>Method</code> configuration.
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// A stringified JSON policy document that applies to this RestApi regardless of the caller and <code>Method</code> configuration.
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_execute_api_endpoint(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_disable_execute_api_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStage`.
    ///
    /// <p>Creates a new <code>Stage</code> resource that references a pre-existing <code>Deployment</code> for the API. </p> <!--   <p>Creates a <a>Stage</a> resource.</p>  -->
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stage_input::Builder,
    }
    impl<C, M, R> CreateStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStageInputOperationOutputAlias,
                crate::output::CreateStageOutput,
                crate::error::CreateStageError,
                crate::input::CreateStageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name for the <code>Stage</code> resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>[Required] The name for the <code>Stage</code> resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>[Required] The identifier of the <code>Deployment</code> resource for the <code>Stage</code> resource.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>Deployment</code> resource for the <code>Stage</code> resource.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>The description of the <code>Stage</code> resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the <code>Stage</code> resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Whether cache clustering is enabled for the stage.</p>
        pub fn cache_cluster_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.cache_cluster_enabled(input);
            self
        }
        /// <p>Whether cache clustering is enabled for the stage.</p>
        pub fn set_cache_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cache_cluster_enabled(input);
            self
        }
        /// <p>The stage's cache cluster size.</p>
        pub fn cache_cluster_size(mut self, input: crate::model::CacheClusterSize) -> Self {
            self.inner = self.inner.cache_cluster_size(input);
            self
        }
        /// <p>The stage's cache cluster size.</p>
        pub fn set_cache_cluster_size(
            mut self,
            input: std::option::Option<crate::model::CacheClusterSize>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_size(input);
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>A map that defines the stage variables for the new <code>Stage</code> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.variables(k.into(), v.into());
            self
        }
        /// <p>A map that defines the stage variables for the new <code>Stage</code> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_variables(input);
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(input.into());
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
        /// <p>The canary deployment settings of this stage.</p>
        pub fn canary_settings(mut self, input: crate::model::CanarySettings) -> Self {
            self.inner = self.inner.canary_settings(input);
            self
        }
        /// <p>The canary deployment settings of this stage.</p>
        pub fn set_canary_settings(
            mut self,
            input: std::option::Option<crate::model::CanarySettings>,
        ) -> Self {
            self.inner = self.inner.set_canary_settings(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <code>Stage</code>.</p>
        pub fn tracing_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.tracing_enabled(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <code>Stage</code>.</p>
        pub fn set_tracing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_tracing_enabled(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUsagePlan`.
    ///
    /// <p>Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUsagePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_usage_plan_input::Builder,
    }
    impl<C, M, R> CreateUsagePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUsagePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUsagePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUsagePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUsagePlanInputOperationOutputAlias,
                crate::output::CreateUsagePlanOutput,
                crate::error::CreateUsagePlanError,
                crate::input::CreateUsagePlanInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the usage plan.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>[Required] The name of the usage plan.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the usage plan.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the usage plan.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `apiStages`.
        ///
        /// To override the contents of this collection use [`set_api_stages`](Self::set_api_stages).
        ///
        /// <p>The associated API stages of the usage plan.</p>
        pub fn api_stages(mut self, input: crate::model::ApiStage) -> Self {
            self.inner = self.inner.api_stages(input);
            self
        }
        /// <p>The associated API stages of the usage plan.</p>
        pub fn set_api_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        ) -> Self {
            self.inner = self.inner.set_api_stages(input);
            self
        }
        /// <p>The throttling limits of the usage plan.</p>
        pub fn throttle(mut self, input: crate::model::ThrottleSettings) -> Self {
            self.inner = self.inner.throttle(input);
            self
        }
        /// <p>The throttling limits of the usage plan.</p>
        pub fn set_throttle(
            mut self,
            input: std::option::Option<crate::model::ThrottleSettings>,
        ) -> Self {
            self.inner = self.inner.set_throttle(input);
            self
        }
        /// <p>The quota of the usage plan.</p>
        pub fn quota(mut self, input: crate::model::QuotaSettings) -> Self {
            self.inner = self.inner.quota(input);
            self
        }
        /// <p>The quota of the usage plan.</p>
        pub fn set_quota(
            mut self,
            input: std::option::Option<crate::model::QuotaSettings>,
        ) -> Self {
            self.inner = self.inner.set_quota(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUsagePlanKey`.
    ///
    /// <p>Creates a usage plan key for adding an existing API key to a usage plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUsagePlanKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_usage_plan_key_input::Builder,
    }
    impl<C, M, R> CreateUsagePlanKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUsagePlanKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUsagePlanKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUsagePlanKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUsagePlanKeyInputOperationOutputAlias,
                crate::output::CreateUsagePlanKeyOutput,
                crate::error::CreateUsagePlanKeyError,
                crate::input::CreateUsagePlanKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-created <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(input.into());
            self
        }
        /// <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-created <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>[Required] The identifier of a <code>UsagePlanKey</code> resource for a plan customer.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>[Required] The identifier of a <code>UsagePlanKey</code> resource for a plan customer.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>[Required] The type of a <code>UsagePlanKey</code> resource for a plan customer.</p>
        pub fn key_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_type(input.into());
            self
        }
        /// <p>[Required] The type of a <code>UsagePlanKey</code> resource for a plan customer.</p>
        pub fn set_key_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVpcLink`.
    ///
    /// <p>Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_vpc_link_input::Builder,
    }
    impl<C, M, R> CreateVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVpcLinkInputOperationOutputAlias,
                crate::output::CreateVpcLinkOutput,
                crate::error::CreateVpcLinkError,
                crate::input::CreateVpcLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name used to label and identify the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>[Required] The name used to label and identify the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `targetArns`.
        ///
        /// To override the contents of this collection use [`set_target_arns`](Self::set_target_arns).
        ///
        /// <p>[Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arns(input.into());
            self
        }
        /// <p>[Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn set_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_arns(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiKey`.
    ///
    /// <p>Deletes the <code>ApiKey</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_api_key_input::Builder,
    }
    impl<C, M, R> DeleteApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApiKeyInputOperationOutputAlias,
                crate::output::DeleteApiKeyOutput,
                crate::error::DeleteApiKeyError,
                crate::input::DeleteApiKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <code>ApiKey</code> resource to be deleted.</p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_key(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>ApiKey</code> resource to be deleted.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuthorizer`.
    ///
    /// <p>Deletes an existing <code>Authorizer</code> resource.</p>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</a>
    /// </div>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_authorizer_input::Builder,
    }
    impl<C, M, R> DeleteAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAuthorizerInputOperationOutputAlias,
                crate::output::DeleteAuthorizerOutput,
                crate::error::DeleteAuthorizerError,
                crate::input::DeleteAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <code>Authorizer</code> resource.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>Authorizer</code> resource.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBasePathMapping`.
    ///
    /// <p>Deletes the <code>BasePathMapping</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBasePathMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_base_path_mapping_input::Builder,
    }
    impl<C, M, R> DeleteBasePathMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBasePathMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBasePathMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBasePathMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBasePathMappingInputOperationOutputAlias,
                crate::output::DeleteBasePathMappingOutput,
                crate::error::DeleteBasePathMappingError,
                crate::input::DeleteBasePathMappingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The domain name of the <code>BasePathMapping</code> resource to delete.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>[Required] The domain name of the <code>BasePathMapping</code> resource to delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>[Required] The base path name of the <code>BasePathMapping</code> resource to delete.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_path(input.into());
            self
        }
        /// <p>[Required] The base path name of the <code>BasePathMapping</code> resource to delete.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_base_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClientCertificate`.
    ///
    /// <p>Deletes the <code>ClientCertificate</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_client_certificate_input::Builder,
    }
    impl<C, M, R> DeleteClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClientCertificateInputOperationOutputAlias,
                crate::output::DeleteClientCertificateOutput,
                crate::error::DeleteClientCertificateError,
                crate::input::DeleteClientCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <code>ClientCertificate</code> resource to be deleted.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>ClientCertificate</code> resource to be deleted.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeployment`.
    ///
    /// <p>Deletes a <code>Deployment</code> resource. Deleting a deployment will only succeed if there are no <code>Stage</code> resources associated with it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_deployment_input::Builder,
    }
    impl<C, M, R> DeleteDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeploymentInputOperationOutputAlias,
                crate::output::DeleteDeploymentOutput,
                crate::error::DeleteDeploymentError,
                crate::input::DeleteDeploymentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <code>Deployment</code> resource to delete.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>Deployment</code> resource to delete.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDocumentationPart`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDocumentationPart<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_documentation_part_input::Builder,
    }
    impl<C, M, R> DeleteDocumentationPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDocumentationPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDocumentationPartOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDocumentationPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDocumentationPartInputOperationOutputAlias,
                crate::output::DeleteDocumentationPartOutput,
                crate::error::DeleteDocumentationPartError,
                crate::input::DeleteDocumentationPartInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the to-be-deleted documentation part.</p>
        pub fn documentation_part_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_part_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the to-be-deleted documentation part.</p>
        pub fn set_documentation_part_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_part_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDocumentationVersion`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDocumentationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_documentation_version_input::Builder,
    }
    impl<C, M, R> DeleteDocumentationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDocumentationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDocumentationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDocumentationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDocumentationVersionInputOperationOutputAlias,
                crate::output::DeleteDocumentationVersionOutput,
                crate::error::DeleteDocumentationVersionError,
                crate::input::DeleteDocumentationVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The version identifier of a to-be-deleted documentation snapshot.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(input.into());
            self
        }
        /// <p>[Required] The version identifier of a to-be-deleted documentation snapshot.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainName`.
    ///
    /// <p>Deletes the <code>DomainName</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_name_input::Builder,
    }
    impl<C, M, R> DeleteDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainNameInputOperationOutputAlias,
                crate::output::DeleteDomainNameOutput,
                crate::error::DeleteDomainNameError,
                crate::input::DeleteDomainNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <code>DomainName</code> resource to be deleted.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>[Required] The name of the <code>DomainName</code> resource to be deleted.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGatewayResponse`.
    ///
    /// <p>Clears any customization of a <code>GatewayResponse</code> of a specified response type on the given <code>RestApi</code> and resets it with the default settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGatewayResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_gateway_response_input::Builder,
    }
    impl<C, M, R> DeleteGatewayResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGatewayResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGatewayResponseInputOperationOutputAlias,
                crate::output::DeleteGatewayResponseOutput,
                crate::error::DeleteGatewayResponseError,
                crate::input::DeleteGatewayResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] </p>
        /// <p>The response type of the associated <code>GatewayResponse</code>.</p>
        /// <p></p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.inner = self.inner.response_type(input);
            self
        }
        /// <p>[Required] </p>
        /// <p>The response type of the associated <code>GatewayResponse</code>.</p>
        /// <p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.inner = self.inner.set_response_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegration`.
    ///
    /// <p>Represents a delete integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_integration_input::Builder,
    }
    impl<C, M, R> DeleteIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntegrationInputOperationOutputAlias,
                crate::output::DeleteIntegrationOutput,
                crate::error::DeleteIntegrationError,
                crate::input::DeleteIntegrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a delete integration request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a delete integration request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegrationResponse`.
    ///
    /// <p>Represents a delete integration response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_integration_response_input::Builder,
    }
    impl<C, M, R> DeleteIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntegrationResponseInputOperationOutputAlias,
                crate::output::DeleteIntegrationResponseOutput,
                crate::error::DeleteIntegrationResponseError,
                crate::input::DeleteIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a delete integration response request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a delete integration response request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies a delete integration response request's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration response request's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMethod`.
    ///
    /// <p>Deletes an existing <code>Method</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_method_input::Builder,
    }
    impl<C, M, R> DeleteMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMethodInputOperationOutputAlias,
                crate::output::DeleteMethodOutput,
                crate::error::DeleteMethodError,
                crate::input::DeleteMethodInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMethodResponse`.
    ///
    /// <p>Deletes an existing <code>MethodResponse</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMethodResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_method_response_input::Builder,
    }
    impl<C, M, R> DeleteMethodResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMethodResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMethodResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMethodResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMethodResponseInputOperationOutputAlias,
                crate::output::DeleteMethodResponseOutput,
                crate::error::DeleteMethodResponseError,
                crate::input::DeleteMethodResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>MethodResponse</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>MethodResponse</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The status code identifier for the <code>MethodResponse</code> resource.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(input.into());
            self
        }
        /// <p>[Required] The status code identifier for the <code>MethodResponse</code> resource.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModel`.
    ///
    /// <p>Deletes a model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_input::Builder,
    }
    impl<C, M, R> DeleteModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelInputOperationOutputAlias,
                crate::output::DeleteModelOutput,
                crate::error::DeleteModelError,
                crate::input::DeleteModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model to delete.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>[Required] The name of the model to delete.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRequestValidator`.
    ///
    /// <p>Deletes a <code>RequestValidator</code> of a given <code>RestApi</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRequestValidator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_request_validator_input::Builder,
    }
    impl<C, M, R> DeleteRequestValidator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRequestValidator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRequestValidatorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRequestValidatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRequestValidatorInputOperationOutputAlias,
                crate::output::DeleteRequestValidatorOutput,
                crate::error::DeleteRequestValidatorError,
                crate::input::DeleteRequestValidatorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <code>RequestValidator</code> to be deleted.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_validator_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>RequestValidator</code> to be deleted.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_validator_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResource`.
    ///
    /// <p>Deletes a <code>Resource</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_input::Builder,
    }
    impl<C, M, R> DeleteResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceInputOperationOutputAlias,
                crate::output::DeleteResourceOutput,
                crate::error::DeleteResourceError,
                crate::input::DeleteResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <code>Resource</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>Resource</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRestApi`.
    ///
    /// <p>Deletes the specified API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rest_api_input::Builder,
    }
    impl<C, M, R> DeleteRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRestApiInputOperationOutputAlias,
                crate::output::DeleteRestApiOutput,
                crate::error::DeleteRestApiError,
                crate::input::DeleteRestApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStage`.
    ///
    /// <p>Deletes a <code>Stage</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stage_input::Builder,
    }
    impl<C, M, R> DeleteStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStageInputOperationOutputAlias,
                crate::output::DeleteStageOutput,
                crate::error::DeleteStageError,
                crate::input::DeleteStageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the <code>Stage</code> resource to delete.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>[Required] The name of the <code>Stage</code> resource to delete.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUsagePlan`.
    ///
    /// <p>Deletes a usage plan of a given plan Id.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUsagePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_usage_plan_input::Builder,
    }
    impl<C, M, R> DeleteUsagePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUsagePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUsagePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUsagePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUsagePlanInputOperationOutputAlias,
                crate::output::DeleteUsagePlanOutput,
                crate::error::DeleteUsagePlanError,
                crate::input::DeleteUsagePlanInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the to-be-deleted usage plan.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(input.into());
            self
        }
        /// <p>[Required] The Id of the to-be-deleted usage plan.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUsagePlanKey`.
    ///
    /// <p>Deletes a usage plan key and remove the underlying API key from the associated usage plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUsagePlanKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_usage_plan_key_input::Builder,
    }
    impl<C, M, R> DeleteUsagePlanKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUsagePlanKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUsagePlanKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUsagePlanKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUsagePlanKeyInputOperationOutputAlias,
                crate::output::DeleteUsagePlanKeyOutput,
                crate::error::DeleteUsagePlanKeyError,
                crate::input::DeleteUsagePlanKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-deleted <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(input.into());
            self
        }
        /// <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-deleted <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>[Required] The Id of the <code>UsagePlanKey</code> resource to be deleted.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>[Required] The Id of the <code>UsagePlanKey</code> resource to be deleted.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVpcLink`.
    ///
    /// <p>Deletes an existing <code>VpcLink</code> of a specified identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_vpc_link_input::Builder,
    }
    impl<C, M, R> DeleteVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVpcLinkInputOperationOutputAlias,
                crate::output::DeleteVpcLinkOutput,
                crate::error::DeleteVpcLinkError,
                crate::input::DeleteVpcLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FlushStageAuthorizersCache`.
    ///
    /// <p>Flushes all authorizer cache entries on a stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct FlushStageAuthorizersCache<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::flush_stage_authorizers_cache_input::Builder,
    }
    impl<C, M, R> FlushStageAuthorizersCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FlushStageAuthorizersCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FlushStageAuthorizersCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::FlushStageAuthorizersCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FlushStageAuthorizersCacheInputOperationOutputAlias,
                crate::output::FlushStageAuthorizersCacheOutput,
                crate::error::FlushStageAuthorizersCacheError,
                crate::input::FlushStageAuthorizersCacheInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The name of the stage to flush.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage to flush.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FlushStageCache`.
    ///
    /// <p>Flushes a stage's cache.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct FlushStageCache<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::flush_stage_cache_input::Builder,
    }
    impl<C, M, R> FlushStageCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FlushStageCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FlushStageCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::FlushStageCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FlushStageCacheInputOperationOutputAlias,
                crate::output::FlushStageCacheOutput,
                crate::error::FlushStageCacheError,
                crate::input::FlushStageCacheInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the stage to flush its cache.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>[Required] The name of the stage to flush its cache.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateClientCertificate`.
    ///
    /// <p>Generates a <code>ClientCertificate</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_client_certificate_input::Builder,
    }
    impl<C, M, R> GenerateClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateClientCertificateInputOperationOutputAlias,
                crate::output::GenerateClientCertificateOutput,
                crate::error::GenerateClientCertificateError,
                crate::input::GenerateClientCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The description of the <code>ClientCertificate</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the <code>ClientCertificate</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccount`.
    ///
    /// <p>Gets information about the current <code>Account</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_input::Builder,
    }
    impl<C, M, R> GetAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountInputOperationOutputAlias,
                crate::output::GetAccountOutput,
                crate::error::GetAccountError,
                crate::input::GetAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetApiKey`.
    ///
    /// <p>Gets information about the current <code>ApiKey</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_api_key_input::Builder,
    }
    impl<C, M, R> GetApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApiKeyInputOperationOutputAlias,
                crate::output::GetApiKeyOutput,
                crate::error::GetApiKeyError,
                crate::input::GetApiKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <code>ApiKey</code> resource.</p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_key(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>ApiKey</code> resource.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_key(input);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.</p>
        pub fn include_value(mut self, input: bool) -> Self {
            self.inner = self.inner.include_value(input);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.</p>
        pub fn set_include_value(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApiKeys`.
    ///
    /// <p>Gets information about the current <code>ApiKeys</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApiKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_api_keys_input::Builder,
    }
    impl<C, M, R> GetApiKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApiKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApiKeysInputOperationOutputAlias,
                crate::output::GetApiKeysOutput,
                crate::error::GetApiKeysError,
                crate::input::GetApiKeysInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetApiKeysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetApiKeysPaginator<C, M, R> {
            crate::paginator::GetApiKeysPaginator::new(self.handle, self.inner)
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The name of queried API keys.</p>
        pub fn name_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_query(input.into());
            self
        }
        /// <p>The name of queried API keys.</p>
        pub fn set_name_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_query(input);
            self
        }
        /// <p>The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.</p>
        pub fn customer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_id(input.into());
            self
        }
        /// <p>The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.</p>
        pub fn set_customer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_customer_id(input);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.</p>
        pub fn include_values(mut self, input: bool) -> Self {
            self.inner = self.inner.include_values(input);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.</p>
        pub fn set_include_values(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizer`.
    ///
    /// <p>Describe an existing <code>Authorizer</code> resource.</p>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</a>
    /// </div>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorizer_input::Builder,
    }
    impl<C, M, R> GetAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizerInputOperationOutputAlias,
                crate::output::GetAuthorizerOutput,
                crate::error::GetAuthorizerError,
                crate::input::GetAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <code>Authorizer</code> resource.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>Authorizer</code> resource.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizers`.
    ///
    /// <p>Describe an existing <code>Authorizers</code> resource.</p>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</a>
    /// </div>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAuthorizers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorizers_input::Builder,
    }
    impl<C, M, R> GetAuthorizers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizersInputOperationOutputAlias,
                crate::output::GetAuthorizersOutput,
                crate::error::GetAuthorizersError,
                crate::input::GetAuthorizersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBasePathMapping`.
    ///
    /// <p>Describe a <code>BasePathMapping</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBasePathMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_base_path_mapping_input::Builder,
    }
    impl<C, M, R> GetBasePathMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBasePathMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBasePathMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBasePathMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBasePathMappingInputOperationOutputAlias,
                crate::output::GetBasePathMappingOutput,
                crate::error::GetBasePathMappingError,
                crate::input::GetBasePathMappingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The domain name of the <code>BasePathMapping</code> resource to be described.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>[Required] The domain name of the <code>BasePathMapping</code> resource to be described.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>[Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_path(input.into());
            self
        }
        /// <p>[Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_base_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBasePathMappings`.
    ///
    /// <p>Represents a collection of <code>BasePathMapping</code> resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBasePathMappings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_base_path_mappings_input::Builder,
    }
    impl<C, M, R> GetBasePathMappings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBasePathMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBasePathMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBasePathMappingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBasePathMappingsInputOperationOutputAlias,
                crate::output::GetBasePathMappingsOutput,
                crate::error::GetBasePathMappingsError,
                crate::input::GetBasePathMappingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBasePathMappingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetBasePathMappingsPaginator<C, M, R> {
            crate::paginator::GetBasePathMappingsPaginator::new(self.handle, self.inner)
        }
        /// <p>[Required] The domain name of a <code>BasePathMapping</code> resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>[Required] The domain name of a <code>BasePathMapping</code> resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClientCertificate`.
    ///
    /// <p>Gets information about the current <code>ClientCertificate</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_client_certificate_input::Builder,
    }
    impl<C, M, R> GetClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetClientCertificateInputOperationOutputAlias,
                crate::output::GetClientCertificateOutput,
                crate::error::GetClientCertificateError,
                crate::input::GetClientCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <code>ClientCertificate</code> resource to be described.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>ClientCertificate</code> resource to be described.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClientCertificates`.
    ///
    /// <p>Gets a collection of <code>ClientCertificate</code> resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetClientCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_client_certificates_input::Builder,
    }
    impl<C, M, R> GetClientCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetClientCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClientCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetClientCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetClientCertificatesInputOperationOutputAlias,
                crate::output::GetClientCertificatesOutput,
                crate::error::GetClientCertificatesError,
                crate::input::GetClientCertificatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetClientCertificatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetClientCertificatesPaginator<C, M, R> {
            crate::paginator::GetClientCertificatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployment`.
    ///
    /// <p>Gets information about a <code>Deployment</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployment_input::Builder,
    }
    impl<C, M, R> GetDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentInputOperationOutputAlias,
                crate::output::GetDeploymentOutput,
                crate::error::GetDeploymentError,
                crate::input::GetDeploymentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <code>Deployment</code> resource to get information about.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>Deployment</code> resource to get information about.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// Appends an item to `embed`.
        ///
        /// To override the contents of this collection use [`set_embed`](Self::set_embed).
        ///
        /// <p>A query parameter to retrieve the specified embedded resources of the returned <code>Deployment</code> resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string. For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.</p>
        pub fn embed(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed(input.into());
            self
        }
        /// <p>A query parameter to retrieve the specified embedded resources of the returned <code>Deployment</code> resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string. For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.</p>
        pub fn set_embed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployments`.
    ///
    /// <p>Gets information about a <code>Deployments</code> collection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployments_input::Builder,
    }
    impl<C, M, R> GetDeployments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentsInputOperationOutputAlias,
                crate::output::GetDeploymentsOutput,
                crate::error::GetDeploymentsError,
                crate::input::GetDeploymentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDeploymentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDeploymentsPaginator<C, M, R> {
            crate::paginator::GetDeploymentsPaginator::new(self.handle, self.inner)
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentationPart`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocumentationPart<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_documentation_part_input::Builder,
    }
    impl<C, M, R> GetDocumentationPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentationPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentationPartOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentationPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentationPartInputOperationOutputAlias,
                crate::output::GetDocumentationPartOutput,
                crate::error::GetDocumentationPartError,
                crate::input::GetDocumentationPartInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn documentation_part_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_part_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_documentation_part_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_part_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentationParts`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocumentationParts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_documentation_parts_input::Builder,
    }
    impl<C, M, R> GetDocumentationParts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentationParts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentationPartsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentationPartsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentationPartsInputOperationOutputAlias,
                crate::output::GetDocumentationPartsOutput,
                crate::error::GetDocumentationPartsError,
                crate::input::GetDocumentationPartsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The type of API entities of the to-be-retrieved documentation parts. </p>
        pub fn r#type(mut self, input: crate::model::DocumentationPartType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of API entities of the to-be-retrieved documentation parts. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DocumentationPartType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of API entities of the to-be-retrieved documentation parts.</p>
        pub fn name_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_query(input.into());
            self
        }
        /// <p>The name of API entities of the to-be-retrieved documentation parts.</p>
        pub fn set_name_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_query(input);
            self
        }
        /// <p>The path of API entities of the to-be-retrieved documentation parts.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(input.into());
            self
        }
        /// <p>The path of API entities of the to-be-retrieved documentation parts.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving <code>DocumentationPart</code> resources with content and <code>UNDOCUMENTED</code> for <code>DocumentationPart</code> resources without content.</p>
        pub fn location_status(mut self, input: crate::model::LocationStatusType) -> Self {
            self.inner = self.inner.location_status(input);
            self
        }
        /// <p>The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving <code>DocumentationPart</code> resources with content and <code>UNDOCUMENTED</code> for <code>DocumentationPart</code> resources without content.</p>
        pub fn set_location_status(
            mut self,
            input: std::option::Option<crate::model::LocationStatusType>,
        ) -> Self {
            self.inner = self.inner.set_location_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentationVersion`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocumentationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_documentation_version_input::Builder,
    }
    impl<C, M, R> GetDocumentationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentationVersionInputOperationOutputAlias,
                crate::output::GetDocumentationVersionOutput,
                crate::error::GetDocumentationVersionError,
                crate::input::GetDocumentationVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The version identifier of the to-be-retrieved documentation snapshot.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(input.into());
            self
        }
        /// <p>[Required] The version identifier of the to-be-retrieved documentation snapshot.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentationVersions`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocumentationVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_documentation_versions_input::Builder,
    }
    impl<C, M, R> GetDocumentationVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentationVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentationVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentationVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentationVersionsInputOperationOutputAlias,
                crate::output::GetDocumentationVersionsOutput,
                crate::error::GetDocumentationVersionsError,
                crate::input::GetDocumentationVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainName`.
    ///
    /// <p>Represents a domain name that is contained in a simpler, more intuitive URL that can be called.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_name_input::Builder,
    }
    impl<C, M, R> GetDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainNameInputOperationOutputAlias,
                crate::output::GetDomainNameOutput,
                crate::error::GetDomainNameError,
                crate::input::GetDomainNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <code>DomainName</code> resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>[Required] The name of the <code>DomainName</code> resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainNames`.
    ///
    /// <p>Represents a collection of <code>DomainName</code> resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainNames<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_names_input::Builder,
    }
    impl<C, M, R> GetDomainNames<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainNamesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainNamesInputOperationOutputAlias,
                crate::output::GetDomainNamesOutput,
                crate::error::GetDomainNamesError,
                crate::input::GetDomainNamesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDomainNamesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDomainNamesPaginator<C, M, R> {
            crate::paginator::GetDomainNamesPaginator::new(self.handle, self.inner)
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExport`.
    ///
    /// <p>Exports a deployed version of a <code>RestApi</code> in a specified format.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_export_input::Builder,
    }
    impl<C, M, R> GetExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExportInputOperationOutputAlias,
                crate::output::GetExportOutput,
                crate::error::GetExportError,
                crate::input::GetExportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the <code>Stage</code> that will be exported.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>[Required] The name of the <code>Stage</code> that will be exported.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>[Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.</p>
        pub fn export_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_type(input.into());
            self
        }
        /// <p>[Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.</p>
        pub fn set_export_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_type(input);
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k.into(), v.into());
            self
        }
        /// <p>A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.</p>
        pub fn accepts(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accepts(input.into());
            self
        }
        /// <p>The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.</p>
        pub fn set_accepts(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_accepts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGatewayResponse`.
    ///
    /// <p>Gets a <code>GatewayResponse</code> of a specified response type on the given <code>RestApi</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGatewayResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_gateway_response_input::Builder,
    }
    impl<C, M, R> GetGatewayResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGatewayResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGatewayResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGatewayResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGatewayResponseInputOperationOutputAlias,
                crate::output::GetGatewayResponseOutput,
                crate::error::GetGatewayResponseError,
                crate::input::GetGatewayResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] </p>
        /// <p>The response type of the associated <code>GatewayResponse</code>.</p>
        /// <p></p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.inner = self.inner.response_type(input);
            self
        }
        /// <p>[Required] </p>
        /// <p>The response type of the associated <code>GatewayResponse</code>.</p>
        /// <p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.inner = self.inner.set_response_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGatewayResponses`.
    ///
    /// <p>Gets the <code>GatewayResponses</code> collection on the given <code>RestApi</code>. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default <code>GatewayResponses</code> collection for the supported response types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGatewayResponses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_gateway_responses_input::Builder,
    }
    impl<C, M, R> GetGatewayResponses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGatewayResponses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGatewayResponsesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGatewayResponsesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGatewayResponsesInputOperationOutputAlias,
                crate::output::GetGatewayResponsesOutput,
                crate::error::GetGatewayResponsesError,
                crate::input::GetGatewayResponsesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set. The <code>GatewayResponse</code> collection does not support pagination and the position does not apply here.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set. The <code>GatewayResponse</code> collection does not support pagination and the position does not apply here.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The <code>GatewayResponses</code> collection does not support pagination and the limit does not apply here.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The <code>GatewayResponses</code> collection does not support pagination and the limit does not apply here.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegration`.
    ///
    /// <p>Get the integration settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_integration_input::Builder,
    }
    impl<C, M, R> GetIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntegrationInputOperationOutputAlias,
                crate::output::GetIntegrationOutput,
                crate::error::GetIntegrationError,
                crate::input::GetIntegrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a get integration request's resource identifier</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration request's resource identifier</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a get integration request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegrationResponse`.
    ///
    /// <p>Represents a get integration response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_integration_response_input::Builder,
    }
    impl<C, M, R> GetIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntegrationResponseInputOperationOutputAlias,
                crate::output::GetIntegrationResponseOutput,
                crate::error::GetIntegrationResponseError,
                crate::input::GetIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a get integration response request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a get integration response request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies a get integration response request's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration response request's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMethod`.
    ///
    /// <p>Describe an existing <code>Method</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_method_input::Builder,
    }
    impl<C, M, R> GetMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMethodInputOperationOutputAlias,
                crate::output::GetMethodOutput,
                crate::error::GetMethodError,
                crate::input::GetMethodInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMethodResponse`.
    ///
    /// <p>Describes a <code>MethodResponse</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMethodResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_method_response_input::Builder,
    }
    impl<C, M, R> GetMethodResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMethodResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMethodResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMethodResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMethodResponseInputOperationOutputAlias,
                crate::output::GetMethodResponseOutput,
                crate::error::GetMethodResponseError,
                crate::input::GetMethodResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>MethodResponse</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>MethodResponse</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The status code for the <code>MethodResponse</code> resource.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(input.into());
            self
        }
        /// <p>[Required] The status code for the <code>MethodResponse</code> resource.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModel`.
    ///
    /// <p>Describes an existing model defined for a <code>RestApi</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_model_input::Builder,
    }
    impl<C, M, R> GetModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelInputOperationOutputAlias,
                crate::output::GetModelOutput,
                crate::error::GetModelError,
                crate::input::GetModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The <code>RestApi</code> identifier under which the <code>Model</code> exists.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The <code>RestApi</code> identifier under which the <code>Model</code> exists.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model as an identifier.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>[Required] The name of the model as an identifier.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
        /// <p>A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.</p>
        pub fn flatten(mut self, input: bool) -> Self {
            self.inner = self.inner.flatten(input);
            self
        }
        /// <p>A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.</p>
        pub fn set_flatten(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_flatten(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModels`.
    ///
    /// <p>Describes existing <code>Models</code> defined for a <code>RestApi</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_models_input::Builder,
    }
    impl<C, M, R> GetModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelsInputOperationOutputAlias,
                crate::output::GetModelsOutput,
                crate::error::GetModelsError,
                crate::input::GetModelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetModelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetModelsPaginator<C, M, R> {
            crate::paginator::GetModelsPaginator::new(self.handle, self.inner)
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModelTemplate`.
    ///
    /// <p>Generates a sample mapping template that can be used to transform a payload into the structure of a model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModelTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_model_template_input::Builder,
    }
    impl<C, M, R> GetModelTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModelTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelTemplateInputOperationOutputAlias,
                crate::output::GetModelTemplateOutput,
                crate::error::GetModelTemplateError,
                crate::input::GetModelTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model for which to generate a template.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>[Required] The name of the model for which to generate a template.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRequestValidator`.
    ///
    /// <p>Gets a <code>RequestValidator</code> of a given <code>RestApi</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRequestValidator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_request_validator_input::Builder,
    }
    impl<C, M, R> GetRequestValidator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRequestValidator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRequestValidatorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRequestValidatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRequestValidatorInputOperationOutputAlias,
                crate::output::GetRequestValidatorOutput,
                crate::error::GetRequestValidatorError,
                crate::input::GetRequestValidatorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <code>RequestValidator</code> to be retrieved.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_validator_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>RequestValidator</code> to be retrieved.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_validator_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRequestValidators`.
    ///
    /// <p>Gets the <code>RequestValidators</code> collection of a given <code>RestApi</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRequestValidators<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_request_validators_input::Builder,
    }
    impl<C, M, R> GetRequestValidators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRequestValidators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRequestValidatorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRequestValidatorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRequestValidatorsInputOperationOutputAlias,
                crate::output::GetRequestValidatorsOutput,
                crate::error::GetRequestValidatorsError,
                crate::input::GetRequestValidatorsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResource`.
    ///
    /// <p>Lists information about a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_input::Builder,
    }
    impl<C, M, R> GetResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceInputOperationOutputAlias,
                crate::output::GetResourceOutput,
                crate::error::GetResourceError,
                crate::input::GetResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier for the <code>Resource</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The identifier for the <code>Resource</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `embed`.
        ///
        /// To override the contents of this collection use [`set_embed`](Self::set_embed).
        ///
        /// <p>A query parameter to retrieve the specified resources embedded in the returned <code>Resource</code> representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <code>Method</code> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.</p>
        pub fn embed(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed(input.into());
            self
        }
        /// <p>A query parameter to retrieve the specified resources embedded in the returned <code>Resource</code> representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <code>Method</code> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.</p>
        pub fn set_embed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResources`.
    ///
    /// <p>Lists information about a collection of <code>Resource</code> resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resources_input::Builder,
    }
    impl<C, M, R> GetResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcesInputOperationOutputAlias,
                crate::output::GetResourcesOutput,
                crate::error::GetResourcesError,
                crate::input::GetResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetResourcesPaginator<C, M, R> {
            crate::paginator::GetResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// Appends an item to `embed`.
        ///
        /// To override the contents of this collection use [`set_embed`](Self::set_embed).
        ///
        /// <p>A query parameter used to retrieve the specified resources embedded in the returned <code>Resources</code> resource in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <code>Method</code> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.</p>
        pub fn embed(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed(input.into());
            self
        }
        /// <p>A query parameter used to retrieve the specified resources embedded in the returned <code>Resources</code> resource in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <code>Method</code> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.</p>
        pub fn set_embed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRestApi`.
    ///
    /// <p>Lists the <code>RestApi</code> resource in the collection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rest_api_input::Builder,
    }
    impl<C, M, R> GetRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRestApiInputOperationOutputAlias,
                crate::output::GetRestApiOutput,
                crate::error::GetRestApiError,
                crate::input::GetRestApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRestApis`.
    ///
    /// <p>Lists the <code>RestApis</code> resources for your collection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRestApis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rest_apis_input::Builder,
    }
    impl<C, M, R> GetRestApis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRestApis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRestApisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRestApisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRestApisInputOperationOutputAlias,
                crate::output::GetRestApisOutput,
                crate::error::GetRestApisError,
                crate::input::GetRestApisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetRestApisPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetRestApisPaginator<C, M, R> {
            crate::paginator::GetRestApisPaginator::new(self.handle, self.inner)
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSdk`.
    ///
    /// <p>Generates a client SDK for a <code>RestApi</code> and <code>Stage</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSdk<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sdk_input::Builder,
    }
    impl<C, M, R> GetSdk<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSdk`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSdkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSdkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSdkInputOperationOutputAlias,
                crate::output::GetSdkOutput,
                crate::error::GetSdkError,
                crate::input::GetSdkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the <code>Stage</code> that the SDK will use.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>[Required] The name of the <code>Stage</code> that the SDK will use.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>[Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code> are supported.</p>
        pub fn sdk_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sdk_type(input.into());
            self
        }
        /// <p>[Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code> are supported.</p>
        pub fn set_sdk_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sdk_type(input);
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. </p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k.into(), v.into());
            self
        }
        /// <p>A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSdkType`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSdkType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sdk_type_input::Builder,
    }
    impl<C, M, R> GetSdkType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSdkType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSdkTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSdkTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSdkTypeInputOperationOutputAlias,
                crate::output::GetSdkTypeOutput,
                crate::error::GetSdkTypeError,
                crate::input::GetSdkTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the queried <code>SdkType</code> instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>[Required] The identifier of the queried <code>SdkType</code> instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSdkTypes`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSdkTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sdk_types_input::Builder,
    }
    impl<C, M, R> GetSdkTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSdkTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSdkTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSdkTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSdkTypesInputOperationOutputAlias,
                crate::output::GetSdkTypesOutput,
                crate::error::GetSdkTypesError,
                crate::input::GetSdkTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStage`.
    ///
    /// <p>Gets information about a <code>Stage</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stage_input::Builder,
    }
    impl<C, M, R> GetStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStageInputOperationOutputAlias,
                crate::output::GetStageOutput,
                crate::error::GetStageError,
                crate::input::GetStageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the <code>Stage</code> resource to get information about.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>[Required] The name of the <code>Stage</code> resource to get information about.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStages`.
    ///
    /// <p>Gets information about one or more <code>Stage</code> resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stages_input::Builder,
    }
    impl<C, M, R> GetStages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStagesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStagesInputOperationOutputAlias,
                crate::output::GetStagesOutput,
                crate::error::GetStagesError,
                crate::input::GetStagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The stages' deployment identifiers.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The stages' deployment identifiers.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTags`.
    ///
    /// <p>Gets the <code>Tags</code> collection for a given resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_tags_input::Builder,
    }
    impl<C, M, R> GetTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTagsInputOperationOutputAlias,
                crate::output::GetTagsOutput,
                crate::error::GetTagsError,
                crate::input::GetTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>(Not currently supported) The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>(Not currently supported) The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>(Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>(Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsage`.
    ///
    /// <p>Gets the usage data of a usage plan in a specified time interval.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_input::Builder,
    }
    impl<C, M, R> GetUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsageInputOperationOutputAlias,
                crate::output::GetUsageOutput,
                crate::error::GetUsageError,
                crate::input::GetUsageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetUsagePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetUsagePaginator<C, M, R> {
            crate::paginator::GetUsagePaginator::new(self.handle, self.inner)
        }
        /// <p>[Required] The Id of the usage plan associated with the usage data.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(input.into());
            self
        }
        /// <p>[Required] The Id of the usage plan associated with the usage data.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>The Id of the API key associated with the resultant usage data.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>The Id of the API key associated with the resultant usage data.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>[Required] The starting date (e.g., 2016-01-01) of the usage data.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_date(input.into());
            self
        }
        /// <p>[Required] The starting date (e.g., 2016-01-01) of the usage data.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>[Required] The ending date (e.g., 2016-12-31) of the usage data.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.end_date(input.into());
            self
        }
        /// <p>[Required] The ending date (e.g., 2016-12-31) of the usage data.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsagePlan`.
    ///
    /// <p>Gets a usage plan of a given plan identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUsagePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_plan_input::Builder,
    }
    impl<C, M, R> GetUsagePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsagePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsagePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsagePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsagePlanInputOperationOutputAlias,
                crate::output::GetUsagePlanOutput,
                crate::error::GetUsagePlanError,
                crate::input::GetUsagePlanInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <code>UsagePlan</code> resource to be retrieved.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>UsagePlan</code> resource to be retrieved.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsagePlanKey`.
    ///
    /// <p>Gets a usage plan key of a given key identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUsagePlanKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_plan_key_input::Builder,
    }
    impl<C, M, R> GetUsagePlanKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsagePlanKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsagePlanKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsagePlanKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsagePlanKeyInputOperationOutputAlias,
                crate::output::GetUsagePlanKeyOutput,
                crate::error::GetUsagePlanKeyError,
                crate::input::GetUsagePlanKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-retrieved <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(input.into());
            self
        }
        /// <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-retrieved <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>[Required] The key Id of the to-be-retrieved <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>[Required] The key Id of the to-be-retrieved <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsagePlanKeys`.
    ///
    /// <p>Gets all the usage plan keys representing the API keys added to a specified usage plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUsagePlanKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_plan_keys_input::Builder,
    }
    impl<C, M, R> GetUsagePlanKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsagePlanKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsagePlanKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsagePlanKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsagePlanKeysInputOperationOutputAlias,
                crate::output::GetUsagePlanKeysOutput,
                crate::error::GetUsagePlanKeysError,
                crate::input::GetUsagePlanKeysInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetUsagePlanKeysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetUsagePlanKeysPaginator<C, M, R> {
            crate::paginator::GetUsagePlanKeysPaginator::new(self.handle, self.inner)
        }
        /// <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-retrieved <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(input.into());
            self
        }
        /// <p>[Required] The Id of the <code>UsagePlan</code> resource representing the usage plan containing the to-be-retrieved <code>UsagePlanKey</code> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>A query parameter specifying the name of the to-be-returned usage plan keys.</p>
        pub fn name_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_query(input.into());
            self
        }
        /// <p>A query parameter specifying the name of the to-be-returned usage plan keys.</p>
        pub fn set_name_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_query(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsagePlans`.
    ///
    /// <p>Gets all the usage plans of the caller's account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUsagePlans<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_plans_input::Builder,
    }
    impl<C, M, R> GetUsagePlans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsagePlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsagePlansOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsagePlansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsagePlansInputOperationOutputAlias,
                crate::output::GetUsagePlansOutput,
                crate::error::GetUsagePlansError,
                crate::input::GetUsagePlansInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetUsagePlansPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetUsagePlansPaginator<C, M, R> {
            crate::paginator::GetUsagePlansPaginator::new(self.handle, self.inner)
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The identifier of the API key associated with the usage plans.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>The identifier of the API key associated with the usage plans.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcLink`.
    ///
    /// <p>Gets a specified VPC link under the caller's account in a region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_vpc_link_input::Builder,
    }
    impl<C, M, R> GetVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVpcLinkInputOperationOutputAlias,
                crate::output::GetVpcLinkOutput,
                crate::error::GetVpcLinkError,
                crate::input::GetVpcLinkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>VpcLink</code>. It is used in an <code>Integration</code> to reference this <code>VpcLink</code>.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcLinks`.
    ///
    /// <p>Gets the <code>VpcLinks</code> collection under the caller's account in a selected region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVpcLinks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_vpc_links_input::Builder,
    }
    impl<C, M, R> GetVpcLinks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVpcLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcLinksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVpcLinksInputOperationOutputAlias,
                crate::output::GetVpcLinksOutput,
                crate::error::GetVpcLinksError,
                crate::input::GetVpcLinksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetVpcLinksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetVpcLinksPaginator<C, M, R> {
            crate::paginator::GetVpcLinksPaginator::new(self.handle, self.inner)
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportApiKeys`.
    ///
    /// <p>Import API keys from an external source, such as a CSV-formatted file.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportApiKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_api_keys_input::Builder,
    }
    impl<C, M, R> ImportApiKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportApiKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportApiKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportApiKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportApiKeysInputOperationOutputAlias,
                crate::output::ImportApiKeysOutput,
                crate::error::ImportApiKeysError,
                crate::input::ImportApiKeysInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format</a>.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.body(input);
            self
        }
        /// <p>The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format</a>.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// <p>A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.</p>
        pub fn format(mut self, input: crate::model::ApiKeysFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ApiKeysFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback <code>ApiKey</code> importation (<code>true</code>) or not (<code>false</code>) when error is encountered.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback <code>ApiKey</code> importation (<code>true</code>) or not (<code>false</code>) when error is encountered.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportDocumentationParts`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportDocumentationParts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_documentation_parts_input::Builder,
    }
    impl<C, M, R> ImportDocumentationParts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportDocumentationParts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportDocumentationPartsOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportDocumentationPartsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportDocumentationPartsInputOperationOutputAlias,
                crate::output::ImportDocumentationPartsOutput,
                crate::error::ImportDocumentationPartsError,
                crate::input::ImportDocumentationPartsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing <code>DocumentationParts</code> definition or to merge (<code>MERGE</code>) the new definition into the existing one. The default value is <code>MERGE</code>.</p>
        pub fn mode(mut self, input: crate::model::PutMode) -> Self {
            self.inner = self.inner.mode(input);
            self
        }
        /// <p>A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing <code>DocumentationParts</code> definition or to merge (<code>MERGE</code>) the new definition into the existing one. The default value is <code>MERGE</code>.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::PutMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(input);
            self
        }
        /// <p>A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
        /// <p>[Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.body(input);
            self
        }
        /// <p>[Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportRestApi`.
    ///
    /// <p>A feature of the API Gateway control service for creating a new API from an external API definition file.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_rest_api_input::Builder,
    }
    impl<C, M, R> ImportRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportRestApiInputOperationOutputAlias,
                crate::output::ImportRestApiOutput,
                crate::error::ImportRestApiError,
                crate::input::ImportRestApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.</p>
        /// <p> To exclude <code>DocumentationParts</code> from the import, set <code>parameters</code> as <code>ignore=documentation</code>.</p>
        /// <p> To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.</p>
        /// <p> To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>.</p>
        /// <p>For example, the AWS CLI command to exclude documentation from the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code></pre>
        /// <p>The AWS CLI command to set the regional endpoint on the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code></pre>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k.into(), v.into());
            self
        }
        /// <p>A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.</p>
        /// <p> To exclude <code>DocumentationParts</code> from the import, set <code>parameters</code> as <code>ignore=documentation</code>.</p>
        /// <p> To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.</p>
        /// <p> To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>.</p>
        /// <p>For example, the AWS CLI command to exclude documentation from the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code></pre>
        /// <p>The AWS CLI command to set the regional endpoint on the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code></pre>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>[Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.body(input);
            self
        }
        /// <p>[Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutGatewayResponse`.
    ///
    /// <p>Creates a customization of a <code>GatewayResponse</code> of a specified response type and status code on the given <code>RestApi</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutGatewayResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_gateway_response_input::Builder,
    }
    impl<C, M, R> PutGatewayResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutGatewayResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutGatewayResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::PutGatewayResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutGatewayResponseInputOperationOutputAlias,
                crate::output::PutGatewayResponseOutput,
                crate::error::PutGatewayResponseError,
                crate::input::PutGatewayResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] </p>
        /// <p>The response type of the associated <code>GatewayResponse</code>.</p>
        /// <p></p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.inner = self.inner.response_type(input);
            self
        }
        /// <p>[Required] </p>
        /// <p>The response type of the associated <code>GatewayResponse</code>.</p>
        /// <p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.inner = self.inner.set_response_type(input);
            self
        }
        /// The HTTP status code of the <code>GatewayResponse</code>.
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(input.into());
            self
        }
        /// The HTTP status code of the <code>GatewayResponse</code>.
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// Adds a key-value pair to `responseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p></p>
        /// <p>Response parameters (paths, query strings and headers) of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
        /// <p></p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v.into());
            self
        }
        /// <p></p>
        /// <p>Response parameters (paths, query strings and headers) of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
        /// <p></p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `responseTemplates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p></p>
        /// <p>Response templates of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
        /// <p></p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_templates(k.into(), v.into());
            self
        }
        /// <p></p>
        /// <p>Response templates of the <code>GatewayResponse</code> as a string-to-string map of key-value pairs.</p>
        /// <p></p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_templates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutIntegration`.
    ///
    /// <p>Sets up a method's integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_integration_input::Builder,
    }
    impl<C, M, R> PutIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutIntegrationInputOperationOutputAlias,
                crate::output::PutIntegrationOutput,
                crate::error::PutIntegrationError,
                crate::input::PutIntegrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a put integration request's resource ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] Specifies a put integration request's resource ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a put integration request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies a put integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies a put integration input's type.</p>
        pub fn r#type(mut self, input: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>[Required] Specifies a put integration input's type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.</p>
        pub fn integration_http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_http_method(input.into());
            self
        }
        /// <p>Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.</p>
        pub fn set_integration_http_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_http_method(input);
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p> </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p> </li>
        /// </ul>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(input.into());
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p> </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p> </li>
        /// </ul>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.inner = self.inner.connection_type(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.inner = self.inner.set_connection_type(input);
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <code>VpcLink</code> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <code>VpcLink</code> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>Specifies whether credentials are required for a put integration.</p>
        pub fn credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials(input.into());
            self
        }
        /// <p>Specifies whether credentials are required for a put integration.</p>
        pub fn set_credentials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_credentials(input);
            self
        }
        /// Adds a key-value pair to `requestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v.into());
            self
        }
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// Adds a key-value pair to `requestTemplates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_templates(k.into(), v.into());
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_templates(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values: <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>. </p>
        /// <ul>
        /// <li><p><code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration back end without transformation.</p></li>
        /// <li><p><code>NEVER</code> rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.</p></li>
        /// <li><p><code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.</p></li>
        /// </ul>
        pub fn passthrough_behavior(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.passthrough_behavior(input.into());
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values: <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>. </p>
        /// <ul>
        /// <li><p><code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration back end without transformation.</p></li>
        /// <li><p><code>NEVER</code> rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.</p></li>
        /// <li><p><code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.</p></li>
        /// </ul>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_passthrough_behavior(input);
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn cache_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_namespace(input.into());
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn set_cache_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_namespace(input);
            self
        }
        /// Appends an item to `cacheKeyParameters`.
        ///
        /// To override the contents of this collection use [`set_cache_key_parameters`](Self::set_cache_key_parameters).
        ///
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <code>Method</code> <code>requestParameters</code>.</p>
        pub fn cache_key_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_key_parameters(input.into());
            self
        }
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <code>Method</code> <code>requestParameters</code>.</p>
        pub fn set_cache_key_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_key_parameters(input);
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.inner = self.inner.content_handling(input);
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout_in_millis(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_millis(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.inner = self.inner.tls_config(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.inner = self.inner.set_tls_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutIntegrationResponse`.
    ///
    /// <p>Represents a put integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_integration_response_input::Builder,
    }
    impl<C, M, R> PutIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::PutIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutIntegrationResponseInputOperationOutputAlias,
                crate::output::PutIntegrationResponseOutput,
                crate::error::PutIntegrationResponseError,
                crate::input::PutIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a put integration response request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] Specifies a put integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a put integration response request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies a put integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies the status code that is used to map the integration response to an existing <code>MethodResponse</code>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(input.into());
            self
        }
        /// <p>[Required] Specifies the status code that is used to map the integration response to an existing <code>MethodResponse</code>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// <p>Specifies the selection pattern of a put integration response.</p>
        pub fn selection_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selection_pattern(input.into());
            self
        }
        /// <p>Specifies the selection pattern of a put integration response.</p>
        pub fn set_selection_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_selection_pattern(input);
            self
        }
        /// Adds a key-value pair to `responseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v.into());
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `responseTemplates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Specifies a put integration response's templates.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_templates(k.into(), v.into());
            self
        }
        /// <p>Specifies a put integration response's templates.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_templates(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.inner = self.inner.content_handling(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMethod`.
    ///
    /// <p>Add a method to an existing <code>Resource</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_method_input::Builder,
    }
    impl<C, M, R> PutMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMethodInputOperationOutputAlias,
                crate::output::PutMethodOutput,
                crate::error::PutMethodError,
                crate::input::PutMethodInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the new <code>Method</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the new <code>Method</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn authorization_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_type(input.into());
            self
        }
        /// <p>[Required] The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>Specifies the identifier of an <code>Authorizer</code> to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>Specifies the identifier of an <code>Authorizer</code> to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// <p>Specifies whether the method required a valid <code>ApiKey</code>.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.inner = self.inner.api_key_required(input);
            self
        }
        /// <p>Specifies whether the method required a valid <code>ApiKey</code>.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_api_key_required(input);
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_name(input.into());
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operation_name(input);
            self
        }
        /// Adds a key-value pair to `requestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <code>Integration</code> to be mapped to integration request parameters or body-mapping templates.</p>
        pub fn request_parameters(mut self, k: impl Into<std::string::String>, v: bool) -> Self {
            self.inner = self.inner.request_parameters(k.into(), v);
            self
        }
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <code>Integration</code> to be mapped to integration request parameters or body-mapping templates.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// Adds a key-value pair to `requestModels`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>Specifies the <code>Model</code> resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a <code>Model</code> name as the value.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_models(k.into(), v.into());
            self
        }
        /// <p>Specifies the <code>Model</code> resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a <code>Model</code> name as the value.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_models(input);
            self
        }
        /// <p>The identifier of a <code>RequestValidator</code> for validating the method request.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_validator_id(input.into());
            self
        }
        /// <p>The identifier of a <code>RequestValidator</code> for validating the method request.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_validator_id(input);
            self
        }
        /// Appends an item to `authorizationScopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_scopes(input.into());
            self
        }
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_authorization_scopes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMethodResponse`.
    ///
    /// <p>Adds a <code>MethodResponse</code> to an existing <code>Method</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutMethodResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_method_response_input::Builder,
    }
    impl<C, M, R> PutMethodResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMethodResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMethodResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMethodResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMethodResponseInputOperationOutputAlias,
                crate::output::PutMethodResponseOutput,
                crate::error::PutMethodResponseError,
                crate::input::PutMethodResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The method response's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(input.into());
            self
        }
        /// <p>[Required] The method response's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// Adds a key-value pair to `responseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn response_parameters(mut self, k: impl Into<std::string::String>, v: bool) -> Self {
            self.inner = self.inner.response_parameters(k.into(), v);
            self
        }
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `responseModels`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Specifies the <code>Model</code> resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a <code>Model</code> name as the value.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_models(k.into(), v.into());
            self
        }
        /// <p>Specifies the <code>Model</code> resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a <code>Model</code> name as the value.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_models(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRestApi`.
    ///
    /// <p>A feature of the API Gateway control service for updating an existing API with an input of external API definitions. The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_rest_api_input::Builder,
    }
    impl<C, M, R> PutRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRestApiInputOperationOutputAlias,
                crate::output::PutRestApiOutput,
                crate::error::PutRestApiError,
                crate::input::PutRestApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default, the update mode is "merge".</p>
        pub fn mode(mut self, input: crate::model::PutMode) -> Self {
            self.inner = self.inner.mode(input);
            self
        }
        /// <p>The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default, the update mode is "merge".</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::PutMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Custom header parameters as part of the request. For example, to exclude <code>DocumentationParts</code> from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k.into(), v.into());
            self
        }
        /// <p>Custom header parameters as part of the request. For example, to exclude <code>DocumentationParts</code> from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>[Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.body(input);
            self
        }
        /// <p>[Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates a tag on a given resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>[Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>[Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestInvokeAuthorizer`.
    ///
    /// <p>Simulate the execution of an <code>Authorizer</code> in your <code>RestApi</code> with headers, parameters, and an incoming request body.</p>
    /// <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer</a> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer</a>
    /// </div>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestInvokeAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_invoke_authorizer_input::Builder,
    }
    impl<C, M, R> TestInvokeAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestInvokeAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestInvokeAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::TestInvokeAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestInvokeAuthorizerInputOperationOutputAlias,
                crate::output::TestInvokeAuthorizerOutput,
                crate::error::TestInvokeAuthorizerError,
                crate::input::TestInvokeAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a test invoke authorizer request's <code>Authorizer</code> ID.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>[Required] Specifies a test invoke authorizer request's <code>Authorizer</code> ID.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// Adds a key-value pair to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>[Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.</p>
        pub fn headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.headers(k.into(), v.into());
            self
        }
        /// <p>[Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_headers(input);
            self
        }
        /// Adds a key-value pair to `multiValueHeaders`.
        ///
        /// To override the contents of this collection use [`set_multi_value_headers`](Self::set_multi_value_headers).
        ///
        /// <p>[Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.</p>
        pub fn multi_value_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.multi_value_headers(k.into(), v);
            self
        }
        /// <p>[Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.</p>
        pub fn set_multi_value_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_multi_value_headers(input);
            self
        }
        /// <p>[Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn path_with_query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_with_query_string(input.into());
            self
        }
        /// <p>[Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn set_path_with_query_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_path_with_query_string(input);
            self
        }
        /// <p>[Optional] The simulated request body of an incoming invocation request.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(input.into());
            self
        }
        /// <p>[Optional] The simulated request body of an incoming invocation request.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// Adds a key-value pair to `stageVariables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <code>Stage</code>.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stage_variables(k.into(), v.into());
            self
        }
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <code>Stage</code>.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stage_variables(input);
            self
        }
        /// Adds a key-value pair to `additionalContext`.
        ///
        /// To override the contents of this collection use [`set_additional_context`](Self::set_additional_context).
        ///
        /// <p>[Optional] A key-value map of additional context variables.</p>
        pub fn additional_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_context(k.into(), v.into());
            self
        }
        /// <p>[Optional] A key-value map of additional context variables.</p>
        pub fn set_additional_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestInvokeMethod`.
    ///
    /// <p>Simulate the execution of a <code>Method</code> in your <code>RestApi</code> with headers, parameters, and an incoming request body.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestInvokeMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_invoke_method_input::Builder,
    }
    impl<C, M, R> TestInvokeMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestInvokeMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestInvokeMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::TestInvokeMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestInvokeMethodInputOperationOutputAlias,
                crate::output::TestInvokeMethodOutput,
                crate::error::TestInvokeMethodError,
                crate::input::TestInvokeMethodInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a test invoke method request's resource ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] Specifies a test invoke method request's resource ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a test invoke method request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies a test invoke method request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn path_with_query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_with_query_string(input.into());
            self
        }
        /// <p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn set_path_with_query_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_path_with_query_string(input);
            self
        }
        /// <p>The simulated request body of an incoming invocation request.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(input.into());
            self
        }
        /// <p>The simulated request body of an incoming invocation request.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// Adds a key-value pair to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>A key-value map of headers to simulate an incoming invocation request.</p>
        pub fn headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.headers(k.into(), v.into());
            self
        }
        /// <p>A key-value map of headers to simulate an incoming invocation request.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_headers(input);
            self
        }
        /// Adds a key-value pair to `multiValueHeaders`.
        ///
        /// To override the contents of this collection use [`set_multi_value_headers`](Self::set_multi_value_headers).
        ///
        /// <p>The headers as a map from string to list of values to simulate an incoming invocation request.</p>
        pub fn multi_value_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.multi_value_headers(k.into(), v);
            self
        }
        /// <p>The headers as a map from string to list of values to simulate an incoming invocation request.</p>
        pub fn set_multi_value_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_multi_value_headers(input);
            self
        }
        /// <p>A <code>ClientCertificate</code> identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(input.into());
            self
        }
        /// <p>A <code>ClientCertificate</code> identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
        /// Adds a key-value pair to `stageVariables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <code>Stage</code>.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stage_variables(k.into(), v.into());
            self
        }
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <code>Stage</code>.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stage_variables(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from a given resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>[Required] The Tag keys to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>[Required] The Tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccount`.
    ///
    /// <p>Changes information about the current <code>Account</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_input::Builder,
    }
    impl<C, M, R> UpdateAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountInputOperationOutputAlias,
                crate::output::UpdateAccountOutput,
                crate::error::UpdateAccountError,
                crate::input::UpdateAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiKey`.
    ///
    /// <p>Changes information about an <code>ApiKey</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_api_key_input::Builder,
    }
    impl<C, M, R> UpdateApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApiKeyInputOperationOutputAlias,
                crate::output::UpdateApiKeyOutput,
                crate::error::UpdateApiKeyError,
                crate::input::UpdateApiKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <code>ApiKey</code> resource to be updated.</p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_key(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>ApiKey</code> resource to be updated.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_key(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAuthorizer`.
    ///
    /// <p>Updates an existing <code>Authorizer</code> resource.</p>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</a>
    /// </div>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_authorizer_input::Builder,
    }
    impl<C, M, R> UpdateAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAuthorizerInputOperationOutputAlias,
                crate::output::UpdateAuthorizerOutput,
                crate::error::UpdateAuthorizerError,
                crate::input::UpdateAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <code>Authorizer</code> resource.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>Authorizer</code> resource.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBasePathMapping`.
    ///
    /// <p>Changes information about the <code>BasePathMapping</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBasePathMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_base_path_mapping_input::Builder,
    }
    impl<C, M, R> UpdateBasePathMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBasePathMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBasePathMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBasePathMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBasePathMappingInputOperationOutputAlias,
                crate::output::UpdateBasePathMappingOutput,
                crate::error::UpdateBasePathMappingError,
                crate::input::UpdateBasePathMappingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The domain name of the <code>BasePathMapping</code> resource to change.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>[Required] The domain name of the <code>BasePathMapping</code> resource to change.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>[Required] The base path of the <code>BasePathMapping</code> resource to change.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_path(input.into());
            self
        }
        /// <p>[Required] The base path of the <code>BasePathMapping</code> resource to change.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_base_path(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateClientCertificate`.
    ///
    /// <p>Changes information about an <code>ClientCertificate</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_client_certificate_input::Builder,
    }
    impl<C, M, R> UpdateClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateClientCertificateInputOperationOutputAlias,
                crate::output::UpdateClientCertificateOutput,
                crate::error::UpdateClientCertificateError,
                crate::input::UpdateClientCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <code>ClientCertificate</code> resource to be updated.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the <code>ClientCertificate</code> resource to be updated.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeployment`.
    ///
    /// <p>Changes information about a <code>Deployment</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_deployment_input::Builder,
    }
    impl<C, M, R> UpdateDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeploymentInputOperationOutputAlias,
                crate::output::UpdateDeploymentOutput,
                crate::error::UpdateDeploymentError,
                crate::input::UpdateDeploymentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The replacement identifier for the <code>Deployment</code> resource to change information about.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The replacement identifier for the <code>Deployment</code> resource to change information about.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDocumentationPart`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDocumentationPart<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_documentation_part_input::Builder,
    }
    impl<C, M, R> UpdateDocumentationPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDocumentationPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDocumentationPartOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDocumentationPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDocumentationPartInputOperationOutputAlias,
                crate::output::UpdateDocumentationPartOutput,
                crate::error::UpdateDocumentationPartError,
                crate::input::UpdateDocumentationPartInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the to-be-updated documentation part.</p>
        pub fn documentation_part_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_part_id(input.into());
            self
        }
        /// <p>[Required] The identifier of the to-be-updated documentation part.</p>
        pub fn set_documentation_part_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_part_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDocumentationVersion`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDocumentationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_documentation_version_input::Builder,
    }
    impl<C, M, R> UpdateDocumentationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDocumentationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDocumentationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDocumentationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDocumentationVersionInputOperationOutputAlias,
                crate::output::UpdateDocumentationVersionOutput,
                crate::error::UpdateDocumentationVersionError,
                crate::input::UpdateDocumentationVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>..</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>..</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The version identifier of the to-be-updated documentation version.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(input.into());
            self
        }
        /// <p>[Required] The version identifier of the to-be-updated documentation version.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainName`.
    ///
    /// <p>Changes information about the <code>DomainName</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_name_input::Builder,
    }
    impl<C, M, R> UpdateDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainNameInputOperationOutputAlias,
                crate::output::UpdateDomainNameOutput,
                crate::error::UpdateDomainNameError,
                crate::input::UpdateDomainNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <code>DomainName</code> resource to be changed.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>[Required] The name of the <code>DomainName</code> resource to be changed.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayResponse`.
    ///
    /// <p>Updates a <code>GatewayResponse</code> of a specified response type on the given <code>RestApi</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGatewayResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gateway_response_input::Builder,
    }
    impl<C, M, R> UpdateGatewayResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGatewayResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGatewayResponseInputOperationOutputAlias,
                crate::output::UpdateGatewayResponseOutput,
                crate::error::UpdateGatewayResponseError,
                crate::input::UpdateGatewayResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] </p>
        /// <p>The response type of the associated <code>GatewayResponse</code>.</p>
        /// <p></p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.inner = self.inner.response_type(input);
            self
        }
        /// <p>[Required] </p>
        /// <p>The response type of the associated <code>GatewayResponse</code>.</p>
        /// <p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.inner = self.inner.set_response_type(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntegration`.
    ///
    /// <p>Represents an update integration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_integration_input::Builder,
    }
    impl<C, M, R> UpdateIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIntegrationInputOperationOutputAlias,
                crate::output::UpdateIntegrationOutput,
                crate::error::UpdateIntegrationError,
                crate::input::UpdateIntegrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Represents an update integration request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] Represents an update integration request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Represents an update integration request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Represents an update integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntegrationResponse`.
    ///
    /// <p>Represents an update integration response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_integration_response_input::Builder,
    }
    impl<C, M, R> UpdateIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIntegrationResponseInputOperationOutputAlias,
                crate::output::UpdateIntegrationResponseOutput,
                crate::error::UpdateIntegrationResponseError,
                crate::input::UpdateIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies an update integration response request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] Specifies an update integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies an update integration response request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] Specifies an update integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies an update integration response request's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(input.into());
            self
        }
        /// <p>[Required] Specifies an update integration response request's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMethod`.
    ///
    /// <p>Updates an existing <code>Method</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_method_input::Builder,
    }
    impl<C, M, R> UpdateMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMethodInputOperationOutputAlias,
                crate::output::UpdateMethodOutput,
                crate::error::UpdateMethodError,
                crate::input::UpdateMethodInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>Method</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMethodResponse`.
    ///
    /// <p>Updates an existing <code>MethodResponse</code> resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMethodResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_method_response_input::Builder,
    }
    impl<C, M, R> UpdateMethodResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMethodResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMethodResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMethodResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMethodResponseInputOperationOutputAlias,
                crate::output::UpdateMethodResponseOutput,
                crate::error::UpdateMethodResponseError,
                crate::input::UpdateMethodResponseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>MethodResponse</code> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>[Required] The <code>Resource</code> identifier for the <code>MethodResponse</code> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <code>Method</code> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The status code for the <code>MethodResponse</code> resource.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(input.into());
            self
        }
        /// <p>[Required] The status code for the <code>MethodResponse</code> resource.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModel`.
    ///
    /// <p>Changes information about a model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_model_input::Builder,
    }
    impl<C, M, R> UpdateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateModelInputOperationOutputAlias,
                crate::output::UpdateModelOutput,
                crate::error::UpdateModelError,
                crate::input::UpdateModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <code>RestApi</code>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model to update.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>[Required] The name of the model to update.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: crate::model::PatchOperation) -> Self {
            self.inner = self.inner.patch_operations(input);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRequestValidator`.
    ///
    /// <p>Updates a <code>RequestValidator</code> of a given <code>RestApi</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRequestValidator<
        C = aws_smithy_client::erase::D