// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateApiKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_api_key`](crate::client::Client::create_api_key).
///
/// See [`crate::client::fluent_builders::CreateApiKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApiKey {
    _private: (),
}
impl CreateApiKey {
    /// Creates a new builder-style object to manufacture [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
    pub fn builder() -> crate::input::create_api_key_input::Builder {
        crate::input::create_api_key_input::Builder::default()
    }
    /// Creates a new `CreateApiKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApiKey {
    type Output =
        std::result::Result<crate::output::CreateApiKeyOutput, crate::error::CreateApiKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_api_key_error(response)
        } else {
            crate::operation_deser::parse_create_api_key_response(response)
        }
    }
}

/// Operation shape for `CreateAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_authorizer`](crate::client::Client::create_authorizer).
///
/// See [`crate::client::fluent_builders::CreateAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAuthorizer {
    _private: (),
}
impl CreateAuthorizer {
    /// Creates a new builder-style object to manufacture [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
    pub fn builder() -> crate::input::create_authorizer_input::Builder {
        crate::input::create_authorizer_input::Builder::default()
    }
    /// Creates a new `CreateAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAuthorizer {
    type Output = std::result::Result<
        crate::output::CreateAuthorizerOutput,
        crate::error::CreateAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_authorizer_error(response)
        } else {
            crate::operation_deser::parse_create_authorizer_response(response)
        }
    }
}

/// Operation shape for `CreateBasePathMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_base_path_mapping`](crate::client::Client::create_base_path_mapping).
///
/// See [`crate::client::fluent_builders::CreateBasePathMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBasePathMapping {
    _private: (),
}
impl CreateBasePathMapping {
    /// Creates a new builder-style object to manufacture [`CreateBasePathMappingInput`](crate::input::CreateBasePathMappingInput)
    pub fn builder() -> crate::input::create_base_path_mapping_input::Builder {
        crate::input::create_base_path_mapping_input::Builder::default()
    }
    /// Creates a new `CreateBasePathMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBasePathMapping {
    type Output = std::result::Result<
        crate::output::CreateBasePathMappingOutput,
        crate::error::CreateBasePathMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_base_path_mapping_error(response)
        } else {
            crate::operation_deser::parse_create_base_path_mapping_response(response)
        }
    }
}

/// Operation shape for `CreateDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_deployment`](crate::client::Client::create_deployment).
///
/// See [`crate::client::fluent_builders::CreateDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeployment {
    _private: (),
}
impl CreateDeployment {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
    /// Creates a new `CreateDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeployment {
    type Output = std::result::Result<
        crate::output::CreateDeploymentOutput,
        crate::error::CreateDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_deployment_error(response)
        } else {
            crate::operation_deser::parse_create_deployment_response(response)
        }
    }
}

/// Operation shape for `CreateDocumentationPart`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_documentation_part`](crate::client::Client::create_documentation_part).
///
/// See [`crate::client::fluent_builders::CreateDocumentationPart`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDocumentationPart {
    _private: (),
}
impl CreateDocumentationPart {
    /// Creates a new builder-style object to manufacture [`CreateDocumentationPartInput`](crate::input::CreateDocumentationPartInput)
    pub fn builder() -> crate::input::create_documentation_part_input::Builder {
        crate::input::create_documentation_part_input::Builder::default()
    }
    /// Creates a new `CreateDocumentationPart` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDocumentationPart {
    type Output = std::result::Result<
        crate::output::CreateDocumentationPartOutput,
        crate::error::CreateDocumentationPartError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_documentation_part_error(response)
        } else {
            crate::operation_deser::parse_create_documentation_part_response(response)
        }
    }
}

/// Operation shape for `CreateDocumentationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_documentation_version`](crate::client::Client::create_documentation_version).
///
/// See [`crate::client::fluent_builders::CreateDocumentationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDocumentationVersion {
    _private: (),
}
impl CreateDocumentationVersion {
    /// Creates a new builder-style object to manufacture [`CreateDocumentationVersionInput`](crate::input::CreateDocumentationVersionInput)
    pub fn builder() -> crate::input::create_documentation_version_input::Builder {
        crate::input::create_documentation_version_input::Builder::default()
    }
    /// Creates a new `CreateDocumentationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDocumentationVersion {
    type Output = std::result::Result<
        crate::output::CreateDocumentationVersionOutput,
        crate::error::CreateDocumentationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_documentation_version_error(response)
        } else {
            crate::operation_deser::parse_create_documentation_version_response(response)
        }
    }
}

/// Operation shape for `CreateDomainName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain_name`](crate::client::Client::create_domain_name).
///
/// See [`crate::client::fluent_builders::CreateDomainName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomainName {
    _private: (),
}
impl CreateDomainName {
    /// Creates a new builder-style object to manufacture [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
    pub fn builder() -> crate::input::create_domain_name_input::Builder {
        crate::input::create_domain_name_input::Builder::default()
    }
    /// Creates a new `CreateDomainName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomainName {
    type Output = std::result::Result<
        crate::output::CreateDomainNameOutput,
        crate::error::CreateDomainNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_domain_name_error(response)
        } else {
            crate::operation_deser::parse_create_domain_name_response(response)
        }
    }
}

/// Operation shape for `CreateModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model`](crate::client::Client::create_model).
///
/// See [`crate::client::fluent_builders::CreateModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModel {
    _private: (),
}
impl CreateModel {
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
    /// Creates a new `CreateModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModel {
    type Output =
        std::result::Result<crate::output::CreateModelOutput, crate::error::CreateModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_model_error(response)
        } else {
            crate::operation_deser::parse_create_model_response(response)
        }
    }
}

/// Operation shape for `CreateRequestValidator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_request_validator`](crate::client::Client::create_request_validator).
///
/// See [`crate::client::fluent_builders::CreateRequestValidator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRequestValidator {
    _private: (),
}
impl CreateRequestValidator {
    /// Creates a new builder-style object to manufacture [`CreateRequestValidatorInput`](crate::input::CreateRequestValidatorInput)
    pub fn builder() -> crate::input::create_request_validator_input::Builder {
        crate::input::create_request_validator_input::Builder::default()
    }
    /// Creates a new `CreateRequestValidator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRequestValidator {
    type Output = std::result::Result<
        crate::output::CreateRequestValidatorOutput,
        crate::error::CreateRequestValidatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_request_validator_error(response)
        } else {
            crate::operation_deser::parse_create_request_validator_response(response)
        }
    }
}

/// Operation shape for `CreateResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource`](crate::client::Client::create_resource).
///
/// See [`crate::client::fluent_builders::CreateResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResource {
    _private: (),
}
impl CreateResource {
    /// Creates a new builder-style object to manufacture [`CreateResourceInput`](crate::input::CreateResourceInput)
    pub fn builder() -> crate::input::create_resource_input::Builder {
        crate::input::create_resource_input::Builder::default()
    }
    /// Creates a new `CreateResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResource {
    type Output =
        std::result::Result<crate::output::CreateResourceOutput, crate::error::CreateResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_resource_error(response)
        } else {
            crate::operation_deser::parse_create_resource_response(response)
        }
    }
}

/// Operation shape for `CreateRestApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_rest_api`](crate::client::Client::create_rest_api).
///
/// See [`crate::client::fluent_builders::CreateRestApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRestApi {
    _private: (),
}
impl CreateRestApi {
    /// Creates a new builder-style object to manufacture [`CreateRestApiInput`](crate::input::CreateRestApiInput)
    pub fn builder() -> crate::input::create_rest_api_input::Builder {
        crate::input::create_rest_api_input::Builder::default()
    }
    /// Creates a new `CreateRestApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRestApi {
    type Output =
        std::result::Result<crate::output::CreateRestApiOutput, crate::error::CreateRestApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_rest_api_error(response)
        } else {
            crate::operation_deser::parse_create_rest_api_response(response)
        }
    }
}

/// Operation shape for `CreateStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stage`](crate::client::Client::create_stage).
///
/// See [`crate::client::fluent_builders::CreateStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStage {
    _private: (),
}
impl CreateStage {
    /// Creates a new builder-style object to manufacture [`CreateStageInput`](crate::input::CreateStageInput)
    pub fn builder() -> crate::input::create_stage_input::Builder {
        crate::input::create_stage_input::Builder::default()
    }
    /// Creates a new `CreateStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStage {
    type Output =
        std::result::Result<crate::output::CreateStageOutput, crate::error::CreateStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_stage_error(response)
        } else {
            crate::operation_deser::parse_create_stage_response(response)
        }
    }
}

/// Operation shape for `CreateUsagePlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_usage_plan`](crate::client::Client::create_usage_plan).
///
/// See [`crate::client::fluent_builders::CreateUsagePlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUsagePlan {
    _private: (),
}
impl CreateUsagePlan {
    /// Creates a new builder-style object to manufacture [`CreateUsagePlanInput`](crate::input::CreateUsagePlanInput)
    pub fn builder() -> crate::input::create_usage_plan_input::Builder {
        crate::input::create_usage_plan_input::Builder::default()
    }
    /// Creates a new `CreateUsagePlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUsagePlan {
    type Output = std::result::Result<
        crate::output::CreateUsagePlanOutput,
        crate::error::CreateUsagePlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_usage_plan_error(response)
        } else {
            crate::operation_deser::parse_create_usage_plan_response(response)
        }
    }
}

/// Operation shape for `CreateUsagePlanKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_usage_plan_key`](crate::client::Client::create_usage_plan_key).
///
/// See [`crate::client::fluent_builders::CreateUsagePlanKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUsagePlanKey {
    _private: (),
}
impl CreateUsagePlanKey {
    /// Creates a new builder-style object to manufacture [`CreateUsagePlanKeyInput`](crate::input::CreateUsagePlanKeyInput)
    pub fn builder() -> crate::input::create_usage_plan_key_input::Builder {
        crate::input::create_usage_plan_key_input::Builder::default()
    }
    /// Creates a new `CreateUsagePlanKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUsagePlanKey {
    type Output = std::result::Result<
        crate::output::CreateUsagePlanKeyOutput,
        crate::error::CreateUsagePlanKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_usage_plan_key_error(response)
        } else {
            crate::operation_deser::parse_create_usage_plan_key_response(response)
        }
    }
}

/// Operation shape for `CreateVpcLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_link`](crate::client::Client::create_vpc_link).
///
/// See [`crate::client::fluent_builders::CreateVpcLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcLink {
    _private: (),
}
impl CreateVpcLink {
    /// Creates a new builder-style object to manufacture [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
    pub fn builder() -> crate::input::create_vpc_link_input::Builder {
        crate::input::create_vpc_link_input::Builder::default()
    }
    /// Creates a new `CreateVpcLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcLink {
    type Output =
        std::result::Result<crate::output::CreateVpcLinkOutput, crate::error::CreateVpcLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_vpc_link_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_link_response(response)
        }
    }
}

/// Operation shape for `DeleteApiKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_api_key`](crate::client::Client::delete_api_key).
///
/// See [`crate::client::fluent_builders::DeleteApiKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApiKey {
    _private: (),
}
impl DeleteApiKey {
    /// Creates a new builder-style object to manufacture [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
    pub fn builder() -> crate::input::delete_api_key_input::Builder {
        crate::input::delete_api_key_input::Builder::default()
    }
    /// Creates a new `DeleteApiKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApiKey {
    type Output =
        std::result::Result<crate::output::DeleteApiKeyOutput, crate::error::DeleteApiKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_api_key_error(response)
        } else {
            crate::operation_deser::parse_delete_api_key_response(response)
        }
    }
}

/// Operation shape for `DeleteAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_authorizer`](crate::client::Client::delete_authorizer).
///
/// See [`crate::client::fluent_builders::DeleteAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAuthorizer {
    _private: (),
}
impl DeleteAuthorizer {
    /// Creates a new builder-style object to manufacture [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
    pub fn builder() -> crate::input::delete_authorizer_input::Builder {
        crate::input::delete_authorizer_input::Builder::default()
    }
    /// Creates a new `DeleteAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAuthorizer {
    type Output = std::result::Result<
        crate::output::DeleteAuthorizerOutput,
        crate::error::DeleteAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_authorizer_error(response)
        } else {
            crate::operation_deser::parse_delete_authorizer_response(response)
        }
    }
}

/// Operation shape for `DeleteBasePathMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_base_path_mapping`](crate::client::Client::delete_base_path_mapping).
///
/// See [`crate::client::fluent_builders::DeleteBasePathMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBasePathMapping {
    _private: (),
}
impl DeleteBasePathMapping {
    /// Creates a new builder-style object to manufacture [`DeleteBasePathMappingInput`](crate::input::DeleteBasePathMappingInput)
    pub fn builder() -> crate::input::delete_base_path_mapping_input::Builder {
        crate::input::delete_base_path_mapping_input::Builder::default()
    }
    /// Creates a new `DeleteBasePathMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBasePathMapping {
    type Output = std::result::Result<
        crate::output::DeleteBasePathMappingOutput,
        crate::error::DeleteBasePathMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_base_path_mapping_error(response)
        } else {
            crate::operation_deser::parse_delete_base_path_mapping_response(response)
        }
    }
}

/// Operation shape for `DeleteClientCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_client_certificate`](crate::client::Client::delete_client_certificate).
///
/// See [`crate::client::fluent_builders::DeleteClientCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteClientCertificate {
    _private: (),
}
impl DeleteClientCertificate {
    /// Creates a new builder-style object to manufacture [`DeleteClientCertificateInput`](crate::input::DeleteClientCertificateInput)
    pub fn builder() -> crate::input::delete_client_certificate_input::Builder {
        crate::input::delete_client_certificate_input::Builder::default()
    }
    /// Creates a new `DeleteClientCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteClientCertificate {
    type Output = std::result::Result<
        crate::output::DeleteClientCertificateOutput,
        crate::error::DeleteClientCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_client_certificate_error(response)
        } else {
            crate::operation_deser::parse_delete_client_certificate_response(response)
        }
    }
}

/// Operation shape for `DeleteDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_deployment`](crate::client::Client::delete_deployment).
///
/// See [`crate::client::fluent_builders::DeleteDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDeployment {
    _private: (),
}
impl DeleteDeployment {
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
    pub fn builder() -> crate::input::delete_deployment_input::Builder {
        crate::input::delete_deployment_input::Builder::default()
    }
    /// Creates a new `DeleteDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDeployment {
    type Output = std::result::Result<
        crate::output::DeleteDeploymentOutput,
        crate::error::DeleteDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_deployment_error(response)
        } else {
            crate::operation_deser::parse_delete_deployment_response(response)
        }
    }
}

/// Operation shape for `DeleteDocumentationPart`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_documentation_part`](crate::client::Client::delete_documentation_part).
///
/// See [`crate::client::fluent_builders::DeleteDocumentationPart`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDocumentationPart {
    _private: (),
}
impl DeleteDocumentationPart {
    /// Creates a new builder-style object to manufacture [`DeleteDocumentationPartInput`](crate::input::DeleteDocumentationPartInput)
    pub fn builder() -> crate::input::delete_documentation_part_input::Builder {
        crate::input::delete_documentation_part_input::Builder::default()
    }
    /// Creates a new `DeleteDocumentationPart` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDocumentationPart {
    type Output = std::result::Result<
        crate::output::DeleteDocumentationPartOutput,
        crate::error::DeleteDocumentationPartError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_documentation_part_error(response)
        } else {
            crate::operation_deser::parse_delete_documentation_part_response(response)
        }
    }
}

/// Operation shape for `DeleteDocumentationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_documentation_version`](crate::client::Client::delete_documentation_version).
///
/// See [`crate::client::fluent_builders::DeleteDocumentationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDocumentationVersion {
    _private: (),
}
impl DeleteDocumentationVersion {
    /// Creates a new builder-style object to manufacture [`DeleteDocumentationVersionInput`](crate::input::DeleteDocumentationVersionInput)
    pub fn builder() -> crate::input::delete_documentation_version_input::Builder {
        crate::input::delete_documentation_version_input::Builder::default()
    }
    /// Creates a new `DeleteDocumentationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDocumentationVersion {
    type Output = std::result::Result<
        crate::output::DeleteDocumentationVersionOutput,
        crate::error::DeleteDocumentationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_documentation_version_error(response)
        } else {
            crate::operation_deser::parse_delete_documentation_version_response(response)
        }
    }
}

/// Operation shape for `DeleteDomainName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain_name`](crate::client::Client::delete_domain_name).
///
/// See [`crate::client::fluent_builders::DeleteDomainName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomainName {
    _private: (),
}
impl DeleteDomainName {
    /// Creates a new builder-style object to manufacture [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
    pub fn builder() -> crate::input::delete_domain_name_input::Builder {
        crate::input::delete_domain_name_input::Builder::default()
    }
    /// Creates a new `DeleteDomainName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomainName {
    type Output = std::result::Result<
        crate::output::DeleteDomainNameOutput,
        crate::error::DeleteDomainNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_domain_name_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_name_response(response)
        }
    }
}

/// Operation shape for `DeleteGatewayResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_gateway_response`](crate::client::Client::delete_gateway_response).
///
/// See [`crate::client::fluent_builders::DeleteGatewayResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGatewayResponse {
    _private: (),
}
impl DeleteGatewayResponse {
    /// Creates a new builder-style object to manufacture [`DeleteGatewayResponseInput`](crate::input::DeleteGatewayResponseInput)
    pub fn builder() -> crate::input::delete_gateway_response_input::Builder {
        crate::input::delete_gateway_response_input::Builder::default()
    }
    /// Creates a new `DeleteGatewayResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGatewayResponse {
    type Output = std::result::Result<
        crate::output::DeleteGatewayResponseOutput,
        crate::error::DeleteGatewayResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_gateway_response_error(response)
        } else {
            crate::operation_deser::parse_delete_gateway_response_response(response)
        }
    }
}

/// Operation shape for `DeleteIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_integration`](crate::client::Client::delete_integration).
///
/// See [`crate::client::fluent_builders::DeleteIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIntegration {
    _private: (),
}
impl DeleteIntegration {
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
    pub fn builder() -> crate::input::delete_integration_input::Builder {
        crate::input::delete_integration_input::Builder::default()
    }
    /// Creates a new `DeleteIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIntegration {
    type Output = std::result::Result<
        crate::output::DeleteIntegrationOutput,
        crate::error::DeleteIntegrationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_integration_error(response)
        } else {
            crate::operation_deser::parse_delete_integration_response(response)
        }
    }
}

/// Operation shape for `DeleteIntegrationResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_integration_response`](crate::client::Client::delete_integration_response).
///
/// See [`crate::client::fluent_builders::DeleteIntegrationResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIntegrationResponse {
    _private: (),
}
impl DeleteIntegrationResponse {
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
    pub fn builder() -> crate::input::delete_integration_response_input::Builder {
        crate::input::delete_integration_response_input::Builder::default()
    }
    /// Creates a new `DeleteIntegrationResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIntegrationResponse {
    type Output = std::result::Result<
        crate::output::DeleteIntegrationResponseOutput,
        crate::error::DeleteIntegrationResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_integration_response_error(response)
        } else {
            crate::operation_deser::parse_delete_integration_response_response(response)
        }
    }
}

/// Operation shape for `DeleteMethod`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_method`](crate::client::Client::delete_method).
///
/// See [`crate::client::fluent_builders::DeleteMethod`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMethod {
    _private: (),
}
impl DeleteMethod {
    /// Creates a new builder-style object to manufacture [`DeleteMethodInput`](crate::input::DeleteMethodInput)
    pub fn builder() -> crate::input::delete_method_input::Builder {
        crate::input::delete_method_input::Builder::default()
    }
    /// Creates a new `DeleteMethod` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMethod {
    type Output =
        std::result::Result<crate::output::DeleteMethodOutput, crate::error::DeleteMethodError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_method_error(response)
        } else {
            crate::operation_deser::parse_delete_method_response(response)
        }
    }
}

/// Operation shape for `DeleteMethodResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_method_response`](crate::client::Client::delete_method_response).
///
/// See [`crate::client::fluent_builders::DeleteMethodResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMethodResponse {
    _private: (),
}
impl DeleteMethodResponse {
    /// Creates a new builder-style object to manufacture [`DeleteMethodResponseInput`](crate::input::DeleteMethodResponseInput)
    pub fn builder() -> crate::input::delete_method_response_input::Builder {
        crate::input::delete_method_response_input::Builder::default()
    }
    /// Creates a new `DeleteMethodResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMethodResponse {
    type Output = std::result::Result<
        crate::output::DeleteMethodResponseOutput,
        crate::error::DeleteMethodResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_method_response_error(response)
        } else {
            crate::operation_deser::parse_delete_method_response_response(response)
        }
    }
}

/// Operation shape for `DeleteModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model`](crate::client::Client::delete_model).
///
/// See [`crate::client::fluent_builders::DeleteModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModel {
    _private: (),
}
impl DeleteModel {
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
    /// Creates a new `DeleteModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModel {
    type Output =
        std::result::Result<crate::output::DeleteModelOutput, crate::error::DeleteModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_model_error(response)
        } else {
            crate::operation_deser::parse_delete_model_response(response)
        }
    }
}

/// Operation shape for `DeleteRequestValidator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_request_validator`](crate::client::Client::delete_request_validator).
///
/// See [`crate::client::fluent_builders::DeleteRequestValidator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRequestValidator {
    _private: (),
}
impl DeleteRequestValidator {
    /// Creates a new builder-style object to manufacture [`DeleteRequestValidatorInput`](crate::input::DeleteRequestValidatorInput)
    pub fn builder() -> crate::input::delete_request_validator_input::Builder {
        crate::input::delete_request_validator_input::Builder::default()
    }
    /// Creates a new `DeleteRequestValidator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRequestValidator {
    type Output = std::result::Result<
        crate::output::DeleteRequestValidatorOutput,
        crate::error::DeleteRequestValidatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_request_validator_error(response)
        } else {
            crate::operation_deser::parse_delete_request_validator_response(response)
        }
    }
}

/// Operation shape for `DeleteResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource`](crate::client::Client::delete_resource).
///
/// See [`crate::client::fluent_builders::DeleteResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResource {
    _private: (),
}
impl DeleteResource {
    /// Creates a new builder-style object to manufacture [`DeleteResourceInput`](crate::input::DeleteResourceInput)
    pub fn builder() -> crate::input::delete_resource_input::Builder {
        crate::input::delete_resource_input::Builder::default()
    }
    /// Creates a new `DeleteResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResource {
    type Output =
        std::result::Result<crate::output::DeleteResourceOutput, crate::error::DeleteResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_resource_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_response(response)
        }
    }
}

/// Operation shape for `DeleteRestApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_rest_api`](crate::client::Client::delete_rest_api).
///
/// See [`crate::client::fluent_builders::DeleteRestApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRestApi {
    _private: (),
}
impl DeleteRestApi {
    /// Creates a new builder-style object to manufacture [`DeleteRestApiInput`](crate::input::DeleteRestApiInput)
    pub fn builder() -> crate::input::delete_rest_api_input::Builder {
        crate::input::delete_rest_api_input::Builder::default()
    }
    /// Creates a new `DeleteRestApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRestApi {
    type Output =
        std::result::Result<crate::output::DeleteRestApiOutput, crate::error::DeleteRestApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_rest_api_error(response)
        } else {
            crate::operation_deser::parse_delete_rest_api_response(response)
        }
    }
}

/// Operation shape for `DeleteStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stage`](crate::client::Client::delete_stage).
///
/// See [`crate::client::fluent_builders::DeleteStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStage {
    _private: (),
}
impl DeleteStage {
    /// Creates a new builder-style object to manufacture [`DeleteStageInput`](crate::input::DeleteStageInput)
    pub fn builder() -> crate::input::delete_stage_input::Builder {
        crate::input::delete_stage_input::Builder::default()
    }
    /// Creates a new `DeleteStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStage {
    type Output =
        std::result::Result<crate::output::DeleteStageOutput, crate::error::DeleteStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_stage_error(response)
        } else {
            crate::operation_deser::parse_delete_stage_response(response)
        }
    }
}

/// Operation shape for `DeleteUsagePlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_usage_plan`](crate::client::Client::delete_usage_plan).
///
/// See [`crate::client::fluent_builders::DeleteUsagePlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUsagePlan {
    _private: (),
}
impl DeleteUsagePlan {
    /// Creates a new builder-style object to manufacture [`DeleteUsagePlanInput`](crate::input::DeleteUsagePlanInput)
    pub fn builder() -> crate::input::delete_usage_plan_input::Builder {
        crate::input::delete_usage_plan_input::Builder::default()
    }
    /// Creates a new `DeleteUsagePlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUsagePlan {
    type Output = std::result::Result<
        crate::output::DeleteUsagePlanOutput,
        crate::error::DeleteUsagePlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_usage_plan_error(response)
        } else {
            crate::operation_deser::parse_delete_usage_plan_response(response)
        }
    }
}

/// Operation shape for `DeleteUsagePlanKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_usage_plan_key`](crate::client::Client::delete_usage_plan_key).
///
/// See [`crate::client::fluent_builders::DeleteUsagePlanKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUsagePlanKey {
    _private: (),
}
impl DeleteUsagePlanKey {
    /// Creates a new builder-style object to manufacture [`DeleteUsagePlanKeyInput`](crate::input::DeleteUsagePlanKeyInput)
    pub fn builder() -> crate::input::delete_usage_plan_key_input::Builder {
        crate::input::delete_usage_plan_key_input::Builder::default()
    }
    /// Creates a new `DeleteUsagePlanKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUsagePlanKey {
    type Output = std::result::Result<
        crate::output::DeleteUsagePlanKeyOutput,
        crate::error::DeleteUsagePlanKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_usage_plan_key_error(response)
        } else {
            crate::operation_deser::parse_delete_usage_plan_key_response(response)
        }
    }
}

/// Operation shape for `DeleteVpcLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_link`](crate::client::Client::delete_vpc_link).
///
/// See [`crate::client::fluent_builders::DeleteVpcLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpcLink {
    _private: (),
}
impl DeleteVpcLink {
    /// Creates a new builder-style object to manufacture [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
    pub fn builder() -> crate::input::delete_vpc_link_input::Builder {
        crate::input::delete_vpc_link_input::Builder::default()
    }
    /// Creates a new `DeleteVpcLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpcLink {
    type Output =
        std::result::Result<crate::output::DeleteVpcLinkOutput, crate::error::DeleteVpcLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_vpc_link_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_link_response(response)
        }
    }
}

/// Operation shape for `FlushStageAuthorizersCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`flush_stage_authorizers_cache`](crate::client::Client::flush_stage_authorizers_cache).
///
/// See [`crate::client::fluent_builders::FlushStageAuthorizersCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FlushStageAuthorizersCache {
    _private: (),
}
impl FlushStageAuthorizersCache {
    /// Creates a new builder-style object to manufacture [`FlushStageAuthorizersCacheInput`](crate::input::FlushStageAuthorizersCacheInput)
    pub fn builder() -> crate::input::flush_stage_authorizers_cache_input::Builder {
        crate::input::flush_stage_authorizers_cache_input::Builder::default()
    }
    /// Creates a new `FlushStageAuthorizersCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FlushStageAuthorizersCache {
    type Output = std::result::Result<
        crate::output::FlushStageAuthorizersCacheOutput,
        crate::error::FlushStageAuthorizersCacheError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_flush_stage_authorizers_cache_error(response)
        } else {
            crate::operation_deser::parse_flush_stage_authorizers_cache_response(response)
        }
    }
}

/// Operation shape for `FlushStageCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`flush_stage_cache`](crate::client::Client::flush_stage_cache).
///
/// See [`crate::client::fluent_builders::FlushStageCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FlushStageCache {
    _private: (),
}
impl FlushStageCache {
    /// Creates a new builder-style object to manufacture [`FlushStageCacheInput`](crate::input::FlushStageCacheInput)
    pub fn builder() -> crate::input::flush_stage_cache_input::Builder {
        crate::input::flush_stage_cache_input::Builder::default()
    }
    /// Creates a new `FlushStageCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FlushStageCache {
    type Output = std::result::Result<
        crate::output::FlushStageCacheOutput,
        crate::error::FlushStageCacheError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_flush_stage_cache_error(response)
        } else {
            crate::operation_deser::parse_flush_stage_cache_response(response)
        }
    }
}

/// Operation shape for `GenerateClientCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_client_certificate`](crate::client::Client::generate_client_certificate).
///
/// See [`crate::client::fluent_builders::GenerateClientCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateClientCertificate {
    _private: (),
}
impl GenerateClientCertificate {
    /// Creates a new builder-style object to manufacture [`GenerateClientCertificateInput`](crate::input::GenerateClientCertificateInput)
    pub fn builder() -> crate::input::generate_client_certificate_input::Builder {
        crate::input::generate_client_certificate_input::Builder::default()
    }
    /// Creates a new `GenerateClientCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateClientCertificate {
    type Output = std::result::Result<
        crate::output::GenerateClientCertificateOutput,
        crate::error::GenerateClientCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_generate_client_certificate_error(response)
        } else {
            crate::operation_deser::parse_generate_client_certificate_response(response)
        }
    }
}

/// Operation shape for `GetAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account`](crate::client::Client::get_account).
///
/// See [`crate::client::fluent_builders::GetAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccount {
    _private: (),
}
impl GetAccount {
    /// Creates a new builder-style object to manufacture [`GetAccountInput`](crate::input::GetAccountInput)
    pub fn builder() -> crate::input::get_account_input::Builder {
        crate::input::get_account_input::Builder::default()
    }
    /// Creates a new `GetAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccount {
    type Output =
        std::result::Result<crate::output::GetAccountOutput, crate::error::GetAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_error(response)
        } else {
            crate::operation_deser::parse_get_account_response(response)
        }
    }
}

/// Operation shape for `GetApiKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_api_key`](crate::client::Client::get_api_key).
///
/// See [`crate::client::fluent_builders::GetApiKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApiKey {
    _private: (),
}
impl GetApiKey {
    /// Creates a new builder-style object to manufacture [`GetApiKeyInput`](crate::input::GetApiKeyInput)
    pub fn builder() -> crate::input::get_api_key_input::Builder {
        crate::input::get_api_key_input::Builder::default()
    }
    /// Creates a new `GetApiKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApiKey {
    type Output = std::result::Result<crate::output::GetApiKeyOutput, crate::error::GetApiKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_api_key_error(response)
        } else {
            crate::operation_deser::parse_get_api_key_response(response)
        }
    }
}

/// Operation shape for `GetApiKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_api_keys`](crate::client::Client::get_api_keys).
///
/// See [`crate::client::fluent_builders::GetApiKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApiKeys {
    _private: (),
}
impl GetApiKeys {
    /// Creates a new builder-style object to manufacture [`GetApiKeysInput`](crate::input::GetApiKeysInput)
    pub fn builder() -> crate::input::get_api_keys_input::Builder {
        crate::input::get_api_keys_input::Builder::default()
    }
    /// Creates a new `GetApiKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApiKeys {
    type Output =
        std::result::Result<crate::output::GetApiKeysOutput, crate::error::GetApiKeysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_api_keys_error(response)
        } else {
            crate::operation_deser::parse_get_api_keys_response(response)
        }
    }
}

/// Operation shape for `GetAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_authorizer`](crate::client::Client::get_authorizer).
///
/// See [`crate::client::fluent_builders::GetAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAuthorizer {
    _private: (),
}
impl GetAuthorizer {
    /// Creates a new builder-style object to manufacture [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
    pub fn builder() -> crate::input::get_authorizer_input::Builder {
        crate::input::get_authorizer_input::Builder::default()
    }
    /// Creates a new `GetAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAuthorizer {
    type Output =
        std::result::Result<crate::output::GetAuthorizerOutput, crate::error::GetAuthorizerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_authorizer_error(response)
        } else {
            crate::operation_deser::parse_get_authorizer_response(response)
        }
    }
}

/// Operation shape for `GetAuthorizers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_authorizers`](crate::client::Client::get_authorizers).
///
/// See [`crate::client::fluent_builders::GetAuthorizers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAuthorizers {
    _private: (),
}
impl GetAuthorizers {
    /// Creates a new builder-style object to manufacture [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
    pub fn builder() -> crate::input::get_authorizers_input::Builder {
        crate::input::get_authorizers_input::Builder::default()
    }
    /// Creates a new `GetAuthorizers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAuthorizers {
    type Output =
        std::result::Result<crate::output::GetAuthorizersOutput, crate::error::GetAuthorizersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_authorizers_error(response)
        } else {
            crate::operation_deser::parse_get_authorizers_response(response)
        }
    }
}

/// Operation shape for `GetBasePathMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_base_path_mapping`](crate::client::Client::get_base_path_mapping).
///
/// See [`crate::client::fluent_builders::GetBasePathMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBasePathMapping {
    _private: (),
}
impl GetBasePathMapping {
    /// Creates a new builder-style object to manufacture [`GetBasePathMappingInput`](crate::input::GetBasePathMappingInput)
    pub fn builder() -> crate::input::get_base_path_mapping_input::Builder {
        crate::input::get_base_path_mapping_input::Builder::default()
    }
    /// Creates a new `GetBasePathMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBasePathMapping {
    type Output = std::result::Result<
        crate::output::GetBasePathMappingOutput,
        crate::error::GetBasePathMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_base_path_mapping_error(response)
        } else {
            crate::operation_deser::parse_get_base_path_mapping_response(response)
        }
    }
}

/// Operation shape for `GetBasePathMappings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_base_path_mappings`](crate::client::Client::get_base_path_mappings).
///
/// See [`crate::client::fluent_builders::GetBasePathMappings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBasePathMappings {
    _private: (),
}
impl GetBasePathMappings {
    /// Creates a new builder-style object to manufacture [`GetBasePathMappingsInput`](crate::input::GetBasePathMappingsInput)
    pub fn builder() -> crate::input::get_base_path_mappings_input::Builder {
        crate::input::get_base_path_mappings_input::Builder::default()
    }
    /// Creates a new `GetBasePathMappings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBasePathMappings {
    type Output = std::result::Result<
        crate::output::GetBasePathMappingsOutput,
        crate::error::GetBasePathMappingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_base_path_mappings_error(response)
        } else {
            crate::operation_deser::parse_get_base_path_mappings_response(response)
        }
    }
}

/// Operation shape for `GetClientCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_client_certificate`](crate::client::Client::get_client_certificate).
///
/// See [`crate::client::fluent_builders::GetClientCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetClientCertificate {
    _private: (),
}
impl GetClientCertificate {
    /// Creates a new builder-style object to manufacture [`GetClientCertificateInput`](crate::input::GetClientCertificateInput)
    pub fn builder() -> crate::input::get_client_certificate_input::Builder {
        crate::input::get_client_certificate_input::Builder::default()
    }
    /// Creates a new `GetClientCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetClientCertificate {
    type Output = std::result::Result<
        crate::output::GetClientCertificateOutput,
        crate::error::GetClientCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_client_certificate_error(response)
        } else {
            crate::operation_deser::parse_get_client_certificate_response(response)
        }
    }
}

/// Operation shape for `GetClientCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_client_certificates`](crate::client::Client::get_client_certificates).
///
/// See [`crate::client::fluent_builders::GetClientCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetClientCertificates {
    _private: (),
}
impl GetClientCertificates {
    /// Creates a new builder-style object to manufacture [`GetClientCertificatesInput`](crate::input::GetClientCertificatesInput)
    pub fn builder() -> crate::input::get_client_certificates_input::Builder {
        crate::input::get_client_certificates_input::Builder::default()
    }
    /// Creates a new `GetClientCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetClientCertificates {
    type Output = std::result::Result<
        crate::output::GetClientCertificatesOutput,
        crate::error::GetClientCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_client_certificates_error(response)
        } else {
            crate::operation_deser::parse_get_client_certificates_response(response)
        }
    }
}

/// Operation shape for `GetDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deployment`](crate::client::Client::get_deployment).
///
/// See [`crate::client::fluent_builders::GetDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeployment {
    _private: (),
}
impl GetDeployment {
    /// Creates a new builder-style object to manufacture [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    pub fn builder() -> crate::input::get_deployment_input::Builder {
        crate::input::get_deployment_input::Builder::default()
    }
    /// Creates a new `GetDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeployment {
    type Output =
        std::result::Result<crate::output::GetDeploymentOutput, crate::error::GetDeploymentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deployment_error(response)
        } else {
            crate::operation_deser::parse_get_deployment_response(response)
        }
    }
}

/// Operation shape for `GetDeployments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deployments`](crate::client::Client::get_deployments).
///
/// See [`crate::client::fluent_builders::GetDeployments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeployments {
    _private: (),
}
impl GetDeployments {
    /// Creates a new builder-style object to manufacture [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
    pub fn builder() -> crate::input::get_deployments_input::Builder {
        crate::input::get_deployments_input::Builder::default()
    }
    /// Creates a new `GetDeployments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeployments {
    type Output =
        std::result::Result<crate::output::GetDeploymentsOutput, crate::error::GetDeploymentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deployments_error(response)
        } else {
            crate::operation_deser::parse_get_deployments_response(response)
        }
    }
}

/// Operation shape for `GetDocumentationPart`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_documentation_part`](crate::client::Client::get_documentation_part).
///
/// See [`crate::client::fluent_builders::GetDocumentationPart`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDocumentationPart {
    _private: (),
}
impl GetDocumentationPart {
    /// Creates a new builder-style object to manufacture [`GetDocumentationPartInput`](crate::input::GetDocumentationPartInput)
    pub fn builder() -> crate::input::get_documentation_part_input::Builder {
        crate::input::get_documentation_part_input::Builder::default()
    }
    /// Creates a new `GetDocumentationPart` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDocumentationPart {
    type Output = std::result::Result<
        crate::output::GetDocumentationPartOutput,
        crate::error::GetDocumentationPartError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_documentation_part_error(response)
        } else {
            crate::operation_deser::parse_get_documentation_part_response(response)
        }
    }
}

/// Operation shape for `GetDocumentationParts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_documentation_parts`](crate::client::Client::get_documentation_parts).
///
/// See [`crate::client::fluent_builders::GetDocumentationParts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDocumentationParts {
    _private: (),
}
impl GetDocumentationParts {
    /// Creates a new builder-style object to manufacture [`GetDocumentationPartsInput`](crate::input::GetDocumentationPartsInput)
    pub fn builder() -> crate::input::get_documentation_parts_input::Builder {
        crate::input::get_documentation_parts_input::Builder::default()
    }
    /// Creates a new `GetDocumentationParts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDocumentationParts {
    type Output = std::result::Result<
        crate::output::GetDocumentationPartsOutput,
        crate::error::GetDocumentationPartsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_documentation_parts_error(response)
        } else {
            crate::operation_deser::parse_get_documentation_parts_response(response)
        }
    }
}

/// Operation shape for `GetDocumentationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_documentation_version`](crate::client::Client::get_documentation_version).
///
/// See [`crate::client::fluent_builders::GetDocumentationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDocumentationVersion {
    _private: (),
}
impl GetDocumentationVersion {
    /// Creates a new builder-style object to manufacture [`GetDocumentationVersionInput`](crate::input::GetDocumentationVersionInput)
    pub fn builder() -> crate::input::get_documentation_version_input::Builder {
        crate::input::get_documentation_version_input::Builder::default()
    }
    /// Creates a new `GetDocumentationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDocumentationVersion {
    type Output = std::result::Result<
        crate::output::GetDocumentationVersionOutput,
        crate::error::GetDocumentationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_documentation_version_error(response)
        } else {
            crate::operation_deser::parse_get_documentation_version_response(response)
        }
    }
}

/// Operation shape for `GetDocumentationVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_documentation_versions`](crate::client::Client::get_documentation_versions).
///
/// See [`crate::client::fluent_builders::GetDocumentationVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDocumentationVersions {
    _private: (),
}
impl GetDocumentationVersions {
    /// Creates a new builder-style object to manufacture [`GetDocumentationVersionsInput`](crate::input::GetDocumentationVersionsInput)
    pub fn builder() -> crate::input::get_documentation_versions_input::Builder {
        crate::input::get_documentation_versions_input::Builder::default()
    }
    /// Creates a new `GetDocumentationVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDocumentationVersions {
    type Output = std::result::Result<
        crate::output::GetDocumentationVersionsOutput,
        crate::error::GetDocumentationVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_documentation_versions_error(response)
        } else {
            crate::operation_deser::parse_get_documentation_versions_response(response)
        }
    }
}

/// Operation shape for `GetDomainName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain_name`](crate::client::Client::get_domain_name).
///
/// See [`crate::client::fluent_builders::GetDomainName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomainName {
    _private: (),
}
impl GetDomainName {
    /// Creates a new builder-style object to manufacture [`GetDomainNameInput`](crate::input::GetDomainNameInput)
    pub fn builder() -> crate::input::get_domain_name_input::Builder {
        crate::input::get_domain_name_input::Builder::default()
    }
    /// Creates a new `GetDomainName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomainName {
    type Output =
        std::result::Result<crate::output::GetDomainNameOutput, crate::error::GetDomainNameError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_name_error(response)
        } else {
            crate::operation_deser::parse_get_domain_name_response(response)
        }
    }
}

/// Operation shape for `GetDomainNames`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain_names`](crate::client::Client::get_domain_names).
///
/// See [`crate::client::fluent_builders::GetDomainNames`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomainNames {
    _private: (),
}
impl GetDomainNames {
    /// Creates a new builder-style object to manufacture [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
    pub fn builder() -> crate::input::get_domain_names_input::Builder {
        crate::input::get_domain_names_input::Builder::default()
    }
    /// Creates a new `GetDomainNames` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomainNames {
    type Output =
        std::result::Result<crate::output::GetDomainNamesOutput, crate::error::GetDomainNamesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_names_error(response)
        } else {
            crate::operation_deser::parse_get_domain_names_response(response)
        }
    }
}

/// Operation shape for `GetExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_export`](crate::client::Client::get_export).
///
/// See [`crate::client::fluent_builders::GetExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExport {
    _private: (),
}
impl GetExport {
    /// Creates a new builder-style object to manufacture [`GetExportInput`](crate::input::GetExportInput)
    pub fn builder() -> crate::input::get_export_input::Builder {
        crate::input::get_export_input::Builder::default()
    }
    /// Creates a new `GetExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExport {
    type Output = std::result::Result<crate::output::GetExportOutput, crate::error::GetExportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_export_error(response)
        } else {
            crate::operation_deser::parse_get_export_response(response)
        }
    }
}

/// Operation shape for `GetGatewayResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_gateway_response`](crate::client::Client::get_gateway_response).
///
/// See [`crate::client::fluent_builders::GetGatewayResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGatewayResponse {
    _private: (),
}
impl GetGatewayResponse {
    /// Creates a new builder-style object to manufacture [`GetGatewayResponseInput`](crate::input::GetGatewayResponseInput)
    pub fn builder() -> crate::input::get_gateway_response_input::Builder {
        crate::input::get_gateway_response_input::Builder::default()
    }
    /// Creates a new `GetGatewayResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGatewayResponse {
    type Output = std::result::Result<
        crate::output::GetGatewayResponseOutput,
        crate::error::GetGatewayResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_gateway_response_error(response)
        } else {
            crate::operation_deser::parse_get_gateway_response_response(response)
        }
    }
}

/// Operation shape for `GetGatewayResponses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_gateway_responses`](crate::client::Client::get_gateway_responses).
///
/// See [`crate::client::fluent_builders::GetGatewayResponses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGatewayResponses {
    _private: (),
}
impl GetGatewayResponses {
    /// Creates a new builder-style object to manufacture [`GetGatewayResponsesInput`](crate::input::GetGatewayResponsesInput)
    pub fn builder() -> crate::input::get_gateway_responses_input::Builder {
        crate::input::get_gateway_responses_input::Builder::default()
    }
    /// Creates a new `GetGatewayResponses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGatewayResponses {
    type Output = std::result::Result<
        crate::output::GetGatewayResponsesOutput,
        crate::error::GetGatewayResponsesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_gateway_responses_error(response)
        } else {
            crate::operation_deser::parse_get_gateway_responses_response(response)
        }
    }
}

/// Operation shape for `GetIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_integration`](crate::client::Client::get_integration).
///
/// See [`crate::client::fluent_builders::GetIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntegration {
    _private: (),
}
impl GetIntegration {
    /// Creates a new builder-style object to manufacture [`GetIntegrationInput`](crate::input::GetIntegrationInput)
    pub fn builder() -> crate::input::get_integration_input::Builder {
        crate::input::get_integration_input::Builder::default()
    }
    /// Creates a new `GetIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntegration {
    type Output =
        std::result::Result<crate::output::GetIntegrationOutput, crate::error::GetIntegrationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_integration_error(response)
        } else {
            crate::operation_deser::parse_get_integration_response(response)
        }
    }
}

/// Operation shape for `GetIntegrationResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_integration_response`](crate::client::Client::get_integration_response).
///
/// See [`crate::client::fluent_builders::GetIntegrationResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntegrationResponse {
    _private: (),
}
impl GetIntegrationResponse {
    /// Creates a new builder-style object to manufacture [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
    pub fn builder() -> crate::input::get_integration_response_input::Builder {
        crate::input::get_integration_response_input::Builder::default()
    }
    /// Creates a new `GetIntegrationResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntegrationResponse {
    type Output = std::result::Result<
        crate::output::GetIntegrationResponseOutput,
        crate::error::GetIntegrationResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_integration_response_error(response)
        } else {
            crate::operation_deser::parse_get_integration_response_response(response)
        }
    }
}

/// Operation shape for `GetMethod`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_method`](crate::client::Client::get_method).
///
/// See [`crate::client::fluent_builders::GetMethod`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMethod {
    _private: (),
}
impl GetMethod {
    /// Creates a new builder-style object to manufacture [`GetMethodInput`](crate::input::GetMethodInput)
    pub fn builder() -> crate::input::get_method_input::Builder {
        crate::input::get_method_input::Builder::default()
    }
    /// Creates a new `GetMethod` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMethod {
    type Output = std::result::Result<crate::output::GetMethodOutput, crate::error::GetMethodError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_method_error(response)
        } else {
            crate::operation_deser::parse_get_method_response(response)
        }
    }
}

/// Operation shape for `GetMethodResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_method_response`](crate::client::Client::get_method_response).
///
/// See [`crate::client::fluent_builders::GetMethodResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMethodResponse {
    _private: (),
}
impl GetMethodResponse {
    /// Creates a new builder-style object to manufacture [`GetMethodResponseInput`](crate::input::GetMethodResponseInput)
    pub fn builder() -> crate::input::get_method_response_input::Builder {
        crate::input::get_method_response_input::Builder::default()
    }
    /// Creates a new `GetMethodResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMethodResponse {
    type Output = std::result::Result<
        crate::output::GetMethodResponseOutput,
        crate::error::GetMethodResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_method_response_error(response)
        } else {
            crate::operation_deser::parse_get_method_response_response(response)
        }
    }
}

/// Operation shape for `GetModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_model`](crate::client::Client::get_model).
///
/// See [`crate::client::fluent_builders::GetModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetModel {
    _private: (),
}
impl GetModel {
    /// Creates a new builder-style object to manufacture [`GetModelInput`](crate::input::GetModelInput)
    pub fn builder() -> crate::input::get_model_input::Builder {
        crate::input::get_model_input::Builder::default()
    }
    /// Creates a new `GetModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetModel {
    type Output = std::result::Result<crate::output::GetModelOutput, crate::error::GetModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_model_error(response)
        } else {
            crate::operation_deser::parse_get_model_response(response)
        }
    }
}

/// Operation shape for `GetModels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_models`](crate::client::Client::get_models).
///
/// See [`crate::client::fluent_builders::GetModels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetModels {
    _private: (),
}
impl GetModels {
    /// Creates a new builder-style object to manufacture [`GetModelsInput`](crate::input::GetModelsInput)
    pub fn builder() -> crate::input::get_models_input::Builder {
        crate::input::get_models_input::Builder::default()
    }
    /// Creates a new `GetModels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetModels {
    type Output = std::result::Result<crate::output::GetModelsOutput, crate::error::GetModelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_models_error(response)
        } else {
            crate::operation_deser::parse_get_models_response(response)
        }
    }
}

/// Operation shape for `GetModelTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_model_template`](crate::client::Client::get_model_template).
///
/// See [`crate::client::fluent_builders::GetModelTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetModelTemplate {
    _private: (),
}
impl GetModelTemplate {
    /// Creates a new builder-style object to manufacture [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
    pub fn builder() -> crate::input::get_model_template_input::Builder {
        crate::input::get_model_template_input::Builder::default()
    }
    /// Creates a new `GetModelTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetModelTemplate {
    type Output = std::result::Result<
        crate::output::GetModelTemplateOutput,
        crate::error::GetModelTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_model_template_error(response)
        } else {
            crate::operation_deser::parse_get_model_template_response(response)
        }
    }
}

/// Operation shape for `GetRequestValidator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_request_validator`](crate::client::Client::get_request_validator).
///
/// See [`crate::client::fluent_builders::GetRequestValidator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRequestValidator {
    _private: (),
}
impl GetRequestValidator {
    /// Creates a new builder-style object to manufacture [`GetRequestValidatorInput`](crate::input::GetRequestValidatorInput)
    pub fn builder() -> crate::input::get_request_validator_input::Builder {
        crate::input::get_request_validator_input::Builder::default()
    }
    /// Creates a new `GetRequestValidator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRequestValidator {
    type Output = std::result::Result<
        crate::output::GetRequestValidatorOutput,
        crate::error::GetRequestValidatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_request_validator_error(response)
        } else {
            crate::operation_deser::parse_get_request_validator_response(response)
        }
    }
}

/// Operation shape for `GetRequestValidators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_request_validators`](crate::client::Client::get_request_validators).
///
/// See [`crate::client::fluent_builders::GetRequestValidators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRequestValidators {
    _private: (),
}
impl GetRequestValidators {
    /// Creates a new builder-style object to manufacture [`GetRequestValidatorsInput`](crate::input::GetRequestValidatorsInput)
    pub fn builder() -> crate::input::get_request_validators_input::Builder {
        crate::input::get_request_validators_input::Builder::default()
    }
    /// Creates a new `GetRequestValidators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRequestValidators {
    type Output = std::result::Result<
        crate::output::GetRequestValidatorsOutput,
        crate::error::GetRequestValidatorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_request_validators_error(response)
        } else {
            crate::operation_deser::parse_get_request_validators_response(response)
        }
    }
}

/// Operation shape for `GetResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource`](crate::client::Client::get_resource).
///
/// See [`crate::client::fluent_builders::GetResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResource {
    _private: (),
}
impl GetResource {
    /// Creates a new builder-style object to manufacture [`GetResourceInput`](crate::input::GetResourceInput)
    pub fn builder() -> crate::input::get_resource_input::Builder {
        crate::input::get_resource_input::Builder::default()
    }
    /// Creates a new `GetResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResource {
    type Output =
        std::result::Result<crate::output::GetResourceOutput, crate::error::GetResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_error(response)
        } else {
            crate::operation_deser::parse_get_resource_response(response)
        }
    }
}

/// Operation shape for `GetResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resources`](crate::client::Client::get_resources).
///
/// See [`crate::client::fluent_builders::GetResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResources {
    _private: (),
}
impl GetResources {
    /// Creates a new builder-style object to manufacture [`GetResourcesInput`](crate::input::GetResourcesInput)
    pub fn builder() -> crate::input::get_resources_input::Builder {
        crate::input::get_resources_input::Builder::default()
    }
    /// Creates a new `GetResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResources {
    type Output =
        std::result::Result<crate::output::GetResourcesOutput, crate::error::GetResourcesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resources_error(response)
        } else {
            crate::operation_deser::parse_get_resources_response(response)
        }
    }
}

/// Operation shape for `GetRestApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rest_api`](crate::client::Client::get_rest_api).
///
/// See [`crate::client::fluent_builders::GetRestApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRestApi {
    _private: (),
}
impl GetRestApi {
    /// Creates a new builder-style object to manufacture [`GetRestApiInput`](crate::input::GetRestApiInput)
    pub fn builder() -> crate::input::get_rest_api_input::Builder {
        crate::input::get_rest_api_input::Builder::default()
    }
    /// Creates a new `GetRestApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRestApi {
    type Output =
        std::result::Result<crate::output::GetRestApiOutput, crate::error::GetRestApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rest_api_error(response)
        } else {
            crate::operation_deser::parse_get_rest_api_response(response)
        }
    }
}

/// Operation shape for `GetRestApis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rest_apis`](crate::client::Client::get_rest_apis).
///
/// See [`crate::client::fluent_builders::GetRestApis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRestApis {
    _private: (),
}
impl GetRestApis {
    /// Creates a new builder-style object to manufacture [`GetRestApisInput`](crate::input::GetRestApisInput)
    pub fn builder() -> crate::input::get_rest_apis_input::Builder {
        crate::input::get_rest_apis_input::Builder::default()
    }
    /// Creates a new `GetRestApis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRestApis {
    type Output =
        std::result::Result<crate::output::GetRestApisOutput, crate::error::GetRestApisError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rest_apis_error(response)
        } else {
            crate::operation_deser::parse_get_rest_apis_response(response)
        }
    }
}

/// Operation shape for `GetSdk`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sdk`](crate::client::Client::get_sdk).
///
/// See [`crate::client::fluent_builders::GetSdk`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSdk {
    _private: (),
}
impl GetSdk {
    /// Creates a new builder-style object to manufacture [`GetSdkInput`](crate::input::GetSdkInput)
    pub fn builder() -> crate::input::get_sdk_input::Builder {
        crate::input::get_sdk_input::Builder::default()
    }
    /// Creates a new `GetSdk` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSdk {
    type Output = std::result::Result<crate::output::GetSdkOutput, crate::error::GetSdkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sdk_error(response)
        } else {
            crate::operation_deser::parse_get_sdk_response(response)
        }
    }
}

/// Operation shape for `GetSdkType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sdk_type`](crate::client::Client::get_sdk_type).
///
/// See [`crate::client::fluent_builders::GetSdkType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSdkType {
    _private: (),
}
impl GetSdkType {
    /// Creates a new builder-style object to manufacture [`GetSdkTypeInput`](crate::input::GetSdkTypeInput)
    pub fn builder() -> crate::input::get_sdk_type_input::Builder {
        crate::input::get_sdk_type_input::Builder::default()
    }
    /// Creates a new `GetSdkType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSdkType {
    type Output =
        std::result::Result<crate::output::GetSdkTypeOutput, crate::error::GetSdkTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sdk_type_error(response)
        } else {
            crate::operation_deser::parse_get_sdk_type_response(response)
        }
    }
}

/// Operation shape for `GetSdkTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sdk_types`](crate::client::Client::get_sdk_types).
///
/// See [`crate::client::fluent_builders::GetSdkTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSdkTypes {
    _private: (),
}
impl GetSdkTypes {
    /// Creates a new builder-style object to manufacture [`GetSdkTypesInput`](crate::input::GetSdkTypesInput)
    pub fn builder() -> crate::input::get_sdk_types_input::Builder {
        crate::input::get_sdk_types_input::Builder::default()
    }
    /// Creates a new `GetSdkTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSdkTypes {
    type Output =
        std::result::Result<crate::output::GetSdkTypesOutput, crate::error::GetSdkTypesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sdk_types_error(response)
        } else {
            crate::operation_deser::parse_get_sdk_types_response(response)
        }
    }
}

/// Operation shape for `GetStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_stage`](crate::client::Client::get_stage).
///
/// See [`crate::client::fluent_builders::GetStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStage {
    _private: (),
}
impl GetStage {
    /// Creates a new builder-style object to manufacture [`GetStageInput`](crate::input::GetStageInput)
    pub fn builder() -> crate::input::get_stage_input::Builder {
        crate::input::get_stage_input::Builder::default()
    }
    /// Creates a new `GetStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStage {
    type Output = std::result::Result<crate::output::GetStageOutput, crate::error::GetStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_stage_error(response)
        } else {
            crate::operation_deser::parse_get_stage_response(response)
        }
    }
}

/// Operation shape for `GetStages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_stages`](crate::client::Client::get_stages).
///
/// See [`crate::client::fluent_builders::GetStages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStages {
    _private: (),
}
impl GetStages {
    /// Creates a new builder-style object to manufacture [`GetStagesInput`](crate::input::GetStagesInput)
    pub fn builder() -> crate::input::get_stages_input::Builder {
        crate::input::get_stages_input::Builder::default()
    }
    /// Creates a new `GetStages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStages {
    type Output = std::result::Result<crate::output::GetStagesOutput, crate::error::GetStagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_stages_error(response)
        } else {
            crate::operation_deser::parse_get_stages_response(response)
        }
    }
}

/// Operation shape for `GetTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_tags`](crate::client::Client::get_tags).
///
/// See [`crate::client::fluent_builders::GetTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTags {
    _private: (),
}
impl GetTags {
    /// Creates a new builder-style object to manufacture [`GetTagsInput`](crate::input::GetTagsInput)
    pub fn builder() -> crate::input::get_tags_input::Builder {
        crate::input::get_tags_input::Builder::default()
    }
    /// Creates a new `GetTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTags {
    type Output = std::result::Result<crate::output::GetTagsOutput, crate::error::GetTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_tags_error(response)
        } else {
            crate::operation_deser::parse_get_tags_response(response)
        }
    }
}

/// Operation shape for `GetUsage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_usage`](crate::client::Client::get_usage).
///
/// See [`crate::client::fluent_builders::GetUsage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUsage {
    _private: (),
}
impl GetUsage {
    /// Creates a new builder-style object to manufacture [`GetUsageInput`](crate::input::GetUsageInput)
    pub fn builder() -> crate::input::get_usage_input::Builder {
        crate::input::get_usage_input::Builder::default()
    }
    /// Creates a new `GetUsage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUsage {
    type Output = std::result::Result<crate::output::GetUsageOutput, crate::error::GetUsageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_usage_error(response)
        } else {
            crate::operation_deser::parse_get_usage_response(response)
        }
    }
}

/// Operation shape for `GetUsagePlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_usage_plan`](crate::client::Client::get_usage_plan).
///
/// See [`crate::client::fluent_builders::GetUsagePlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUsagePlan {
    _private: (),
}
impl GetUsagePlan {
    /// Creates a new builder-style object to manufacture [`GetUsagePlanInput`](crate::input::GetUsagePlanInput)
    pub fn builder() -> crate::input::get_usage_plan_input::Builder {
        crate::input::get_usage_plan_input::Builder::default()
    }
    /// Creates a new `GetUsagePlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUsagePlan {
    type Output =
        std::result::Result<crate::output::GetUsagePlanOutput, crate::error::GetUsagePlanError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_usage_plan_error(response)
        } else {
            crate::operation_deser::parse_get_usage_plan_response(response)
        }
    }
}

/// Operation shape for `GetUsagePlanKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_usage_plan_key`](crate::client::Client::get_usage_plan_key).
///
/// See [`crate::client::fluent_builders::GetUsagePlanKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUsagePlanKey {
    _private: (),
}
impl GetUsagePlanKey {
    /// Creates a new builder-style object to manufacture [`GetUsagePlanKeyInput`](crate::input::GetUsagePlanKeyInput)
    pub fn builder() -> crate::input::get_usage_plan_key_input::Builder {
        crate::input::get_usage_plan_key_input::Builder::default()
    }
    /// Creates a new `GetUsagePlanKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUsagePlanKey {
    type Output = std::result::Result<
        crate::output::GetUsagePlanKeyOutput,
        crate::error::GetUsagePlanKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_usage_plan_key_error(response)
        } else {
            crate::operation_deser::parse_get_usage_plan_key_response(response)
        }
    }
}

/// Operation shape for `GetUsagePlanKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_usage_plan_keys`](crate::client::Client::get_usage_plan_keys).
///
/// See [`crate::client::fluent_builders::GetUsagePlanKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUsagePlanKeys {
    _private: (),
}
impl GetUsagePlanKeys {
    /// Creates a new builder-style object to manufacture [`GetUsagePlanKeysInput`](crate::input::GetUsagePlanKeysInput)
    pub fn builder() -> crate::input::get_usage_plan_keys_input::Builder {
        crate::input::get_usage_plan_keys_input::Builder::default()
    }
    /// Creates a new `GetUsagePlanKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUsagePlanKeys {
    type Output = std::result::Result<
        crate::output::GetUsagePlanKeysOutput,
        crate::error::GetUsagePlanKeysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_usage_plan_keys_error(response)
        } else {
            crate::operation_deser::parse_get_usage_plan_keys_response(response)
        }
    }
}

/// Operation shape for `GetUsagePlans`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_usage_plans`](crate::client::Client::get_usage_plans).
///
/// See [`crate::client::fluent_builders::GetUsagePlans`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUsagePlans {
    _private: (),
}
impl GetUsagePlans {
    /// Creates a new builder-style object to manufacture [`GetUsagePlansInput`](crate::input::GetUsagePlansInput)
    pub fn builder() -> crate::input::get_usage_plans_input::Builder {
        crate::input::get_usage_plans_input::Builder::default()
    }
    /// Creates a new `GetUsagePlans` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUsagePlans {
    type Output =
        std::result::Result<crate::output::GetUsagePlansOutput, crate::error::GetUsagePlansError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_usage_plans_error(response)
        } else {
            crate::operation_deser::parse_get_usage_plans_response(response)
        }
    }
}

/// Operation shape for `GetVpcLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vpc_link`](crate::client::Client::get_vpc_link).
///
/// See [`crate::client::fluent_builders::GetVpcLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVpcLink {
    _private: (),
}
impl GetVpcLink {
    /// Creates a new builder-style object to manufacture [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
    pub fn builder() -> crate::input::get_vpc_link_input::Builder {
        crate::input::get_vpc_link_input::Builder::default()
    }
    /// Creates a new `GetVpcLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVpcLink {
    type Output =
        std::result::Result<crate::output::GetVpcLinkOutput, crate::error::GetVpcLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vpc_link_error(response)
        } else {
            crate::operation_deser::parse_get_vpc_link_response(response)
        }
    }
}

/// Operation shape for `GetVpcLinks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vpc_links`](crate::client::Client::get_vpc_links).
///
/// See [`crate::client::fluent_builders::GetVpcLinks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVpcLinks {
    _private: (),
}
impl GetVpcLinks {
    /// Creates a new builder-style object to manufacture [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
    pub fn builder() -> crate::input::get_vpc_links_input::Builder {
        crate::input::get_vpc_links_input::Builder::default()
    }
    /// Creates a new `GetVpcLinks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVpcLinks {
    type Output =
        std::result::Result<crate::output::GetVpcLinksOutput, crate::error::GetVpcLinksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vpc_links_error(response)
        } else {
            crate::operation_deser::parse_get_vpc_links_response(response)
        }
    }
}

/// Operation shape for `ImportApiKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_api_keys`](crate::client::Client::import_api_keys).
///
/// See [`crate::client::fluent_builders::ImportApiKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportApiKeys {
    _private: (),
}
impl ImportApiKeys {
    /// Creates a new builder-style object to manufacture [`ImportApiKeysInput`](crate::input::ImportApiKeysInput)
    pub fn builder() -> crate::input::import_api_keys_input::Builder {
        crate::input::import_api_keys_input::Builder::default()
    }
    /// Creates a new `ImportApiKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportApiKeys {
    type Output =
        std::result::Result<crate::output::ImportApiKeysOutput, crate::error::ImportApiKeysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_import_api_keys_error(response)
        } else {
            crate::operation_deser::parse_import_api_keys_response(response)
        }
    }
}

/// Operation shape for `ImportDocumentationParts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_documentation_parts`](crate::client::Client::import_documentation_parts).
///
/// See [`crate::client::fluent_builders::ImportDocumentationParts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportDocumentationParts {
    _private: (),
}
impl ImportDocumentationParts {
    /// Creates a new builder-style object to manufacture [`ImportDocumentationPartsInput`](crate::input::ImportDocumentationPartsInput)
    pub fn builder() -> crate::input::import_documentation_parts_input::Builder {
        crate::input::import_documentation_parts_input::Builder::default()
    }
    /// Creates a new `ImportDocumentationParts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportDocumentationParts {
    type Output = std::result::Result<
        crate::output::ImportDocumentationPartsOutput,
        crate::error::ImportDocumentationPartsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_documentation_parts_error(response)
        } else {
            crate::operation_deser::parse_import_documentation_parts_response(response)
        }
    }
}

/// Operation shape for `ImportRestApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_rest_api`](crate::client::Client::import_rest_api).
///
/// See [`crate::client::fluent_builders::ImportRestApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportRestApi {
    _private: (),
}
impl ImportRestApi {
    /// Creates a new builder-style object to manufacture [`ImportRestApiInput`](crate::input::ImportRestApiInput)
    pub fn builder() -> crate::input::import_rest_api_input::Builder {
        crate::input::import_rest_api_input::Builder::default()
    }
    /// Creates a new `ImportRestApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportRestApi {
    type Output =
        std::result::Result<crate::output::ImportRestApiOutput, crate::error::ImportRestApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_import_rest_api_error(response)
        } else {
            crate::operation_deser::parse_import_rest_api_response(response)
        }
    }
}

/// Operation shape for `PutGatewayResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_gateway_response`](crate::client::Client::put_gateway_response).
///
/// See [`crate::client::fluent_builders::PutGatewayResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutGatewayResponse {
    _private: (),
}
impl PutGatewayResponse {
    /// Creates a new builder-style object to manufacture [`PutGatewayResponseInput`](crate::input::PutGatewayResponseInput)
    pub fn builder() -> crate::input::put_gateway_response_input::Builder {
        crate::input::put_gateway_response_input::Builder::default()
    }
    /// Creates a new `PutGatewayResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutGatewayResponse {
    type Output = std::result::Result<
        crate::output::PutGatewayResponseOutput,
        crate::error::PutGatewayResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_put_gateway_response_error(response)
        } else {
            crate::operation_deser::parse_put_gateway_response_response(response)
        }
    }
}

/// Operation shape for `PutIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_integration`](crate::client::Client::put_integration).
///
/// See [`crate::client::fluent_builders::PutIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutIntegration {
    _private: (),
}
impl PutIntegration {
    /// Creates a new builder-style object to manufacture [`PutIntegrationInput`](crate::input::PutIntegrationInput)
    pub fn builder() -> crate::input::put_integration_input::Builder {
        crate::input::put_integration_input::Builder::default()
    }
    /// Creates a new `PutIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutIntegration {
    type Output =
        std::result::Result<crate::output::PutIntegrationOutput, crate::error::PutIntegrationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_put_integration_error(response)
        } else {
            crate::operation_deser::parse_put_integration_response(response)
        }
    }
}

/// Operation shape for `PutIntegrationResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_integration_response`](crate::client::Client::put_integration_response).
///
/// See [`crate::client::fluent_builders::PutIntegrationResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutIntegrationResponse {
    _private: (),
}
impl PutIntegrationResponse {
    /// Creates a new builder-style object to manufacture [`PutIntegrationResponseInput`](crate::input::PutIntegrationResponseInput)
    pub fn builder() -> crate::input::put_integration_response_input::Builder {
        crate::input::put_integration_response_input::Builder::default()
    }
    /// Creates a new `PutIntegrationResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutIntegrationResponse {
    type Output = std::result::Result<
        crate::output::PutIntegrationResponseOutput,
        crate::error::PutIntegrationResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_put_integration_response_error(response)
        } else {
            crate::operation_deser::parse_put_integration_response_response(response)
        }
    }
}

/// Operation shape for `PutMethod`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_method`](crate::client::Client::put_method).
///
/// See [`crate::client::fluent_builders::PutMethod`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutMethod {
    _private: (),
}
impl PutMethod {
    /// Creates a new builder-style object to manufacture [`PutMethodInput`](crate::input::PutMethodInput)
    pub fn builder() -> crate::input::put_method_input::Builder {
        crate::input::put_method_input::Builder::default()
    }
    /// Creates a new `PutMethod` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutMethod {
    type Output = std::result::Result<crate::output::PutMethodOutput, crate::error::PutMethodError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_put_method_error(response)
        } else {
            crate::operation_deser::parse_put_method_response(response)
        }
    }
}

/// Operation shape for `PutMethodResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_method_response`](crate::client::Client::put_method_response).
///
/// See [`crate::client::fluent_builders::PutMethodResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutMethodResponse {
    _private: (),
}
impl PutMethodResponse {
    /// Creates a new builder-style object to manufacture [`PutMethodResponseInput`](crate::input::PutMethodResponseInput)
    pub fn builder() -> crate::input::put_method_response_input::Builder {
        crate::input::put_method_response_input::Builder::default()
    }
    /// Creates a new `PutMethodResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutMethodResponse {
    type Output = std::result::Result<
        crate::output::PutMethodResponseOutput,
        crate::error::PutMethodResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_put_method_response_error(response)
        } else {
            crate::operation_deser::parse_put_method_response_response(response)
        }
    }
}

/// Operation shape for `PutRestApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_rest_api`](crate::client::Client::put_rest_api).
///
/// See [`crate::client::fluent_builders::PutRestApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRestApi {
    _private: (),
}
impl PutRestApi {
    /// Creates a new builder-style object to manufacture [`PutRestApiInput`](crate::input::PutRestApiInput)
    pub fn builder() -> crate::input::put_rest_api_input::Builder {
        crate::input::put_rest_api_input::Builder::default()
    }
    /// Creates a new `PutRestApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRestApi {
    type Output =
        std::result::Result<crate::output::PutRestApiOutput, crate::error::PutRestApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_rest_api_error(response)
        } else {
            crate::operation_deser::parse_put_rest_api_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TestInvokeAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_invoke_authorizer`](crate::client::Client::test_invoke_authorizer).
///
/// See [`crate::client::fluent_builders::TestInvokeAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestInvokeAuthorizer {
    _private: (),
}
impl TestInvokeAuthorizer {
    /// Creates a new builder-style object to manufacture [`TestInvokeAuthorizerInput`](crate::input::TestInvokeAuthorizerInput)
    pub fn builder() -> crate::input::test_invoke_authorizer_input::Builder {
        crate::input::test_invoke_authorizer_input::Builder::default()
    }
    /// Creates a new `TestInvokeAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestInvokeAuthorizer {
    type Output = std::result::Result<
        crate::output::TestInvokeAuthorizerOutput,
        crate::error::TestInvokeAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_invoke_authorizer_error(response)
        } else {
            crate::operation_deser::parse_test_invoke_authorizer_response(response)
        }
    }
}

/// Operation shape for `TestInvokeMethod`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_invoke_method`](crate::client::Client::test_invoke_method).
///
/// See [`crate::client::fluent_builders::TestInvokeMethod`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestInvokeMethod {
    _private: (),
}
impl TestInvokeMethod {
    /// Creates a new builder-style object to manufacture [`TestInvokeMethodInput`](crate::input::TestInvokeMethodInput)
    pub fn builder() -> crate::input::test_invoke_method_input::Builder {
        crate::input::test_invoke_method_input::Builder::default()
    }
    /// Creates a new `TestInvokeMethod` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestInvokeMethod {
    type Output = std::result::Result<
        crate::output::TestInvokeMethodOutput,
        crate::error::TestInvokeMethodError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_invoke_method_error(response)
        } else {
            crate::operation_deser::parse_test_invoke_method_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_account`](crate::client::Client::update_account).
///
/// See [`crate::client::fluent_builders::UpdateAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccount {
    _private: (),
}
impl UpdateAccount {
    /// Creates a new builder-style object to manufacture [`UpdateAccountInput`](crate::input::UpdateAccountInput)
    pub fn builder() -> crate::input::update_account_input::Builder {
        crate::input::update_account_input::Builder::default()
    }
    /// Creates a new `UpdateAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccount {
    type Output =
        std::result::Result<crate::output::UpdateAccountOutput, crate::error::UpdateAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_account_error(response)
        } else {
            crate::operation_deser::parse_update_account_response(response)
        }
    }
}

/// Operation shape for `UpdateApiKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_api_key`](crate::client::Client::update_api_key).
///
/// See [`crate::client::fluent_builders::UpdateApiKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApiKey {
    _private: (),
}
impl UpdateApiKey {
    /// Creates a new builder-style object to manufacture [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
    pub fn builder() -> crate::input::update_api_key_input::Builder {
        crate::input::update_api_key_input::Builder::default()
    }
    /// Creates a new `UpdateApiKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApiKey {
    type Output =
        std::result::Result<crate::output::UpdateApiKeyOutput, crate::error::UpdateApiKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_api_key_error(response)
        } else {
            crate::operation_deser::parse_update_api_key_response(response)
        }
    }
}

/// Operation shape for `UpdateAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_authorizer`](crate::client::Client::update_authorizer).
///
/// See [`crate::client::fluent_builders::UpdateAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAuthorizer {
    _private: (),
}
impl UpdateAuthorizer {
    /// Creates a new builder-style object to manufacture [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
    pub fn builder() -> crate::input::update_authorizer_input::Builder {
        crate::input::update_authorizer_input::Builder::default()
    }
    /// Creates a new `UpdateAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAuthorizer {
    type Output = std::result::Result<
        crate::output::UpdateAuthorizerOutput,
        crate::error::UpdateAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_authorizer_error(response)
        } else {
            crate::operation_deser::parse_update_authorizer_response(response)
        }
    }
}

/// Operation shape for `UpdateBasePathMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_base_path_mapping`](crate::client::Client::update_base_path_mapping).
///
/// See [`crate::client::fluent_builders::UpdateBasePathMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBasePathMapping {
    _private: (),
}
impl UpdateBasePathMapping {
    /// Creates a new builder-style object to manufacture [`UpdateBasePathMappingInput`](crate::input::UpdateBasePathMappingInput)
    pub fn builder() -> crate::input::update_base_path_mapping_input::Builder {
        crate::input::update_base_path_mapping_input::Builder::default()
    }
    /// Creates a new `UpdateBasePathMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBasePathMapping {
    type Output = std::result::Result<
        crate::output::UpdateBasePathMappingOutput,
        crate::error::UpdateBasePathMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_base_path_mapping_error(response)
        } else {
            crate::operation_deser::parse_update_base_path_mapping_response(response)
        }
    }
}

/// Operation shape for `UpdateClientCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_client_certificate`](crate::client::Client::update_client_certificate).
///
/// See [`crate::client::fluent_builders::UpdateClientCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateClientCertificate {
    _private: (),
}
impl UpdateClientCertificate {
    /// Creates a new builder-style object to manufacture [`UpdateClientCertificateInput`](crate::input::UpdateClientCertificateInput)
    pub fn builder() -> crate::input::update_client_certificate_input::Builder {
        crate::input::update_client_certificate_input::Builder::default()
    }
    /// Creates a new `UpdateClientCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateClientCertificate {
    type Output = std::result::Result<
        crate::output::UpdateClientCertificateOutput,
        crate::error::UpdateClientCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_client_certificate_error(response)
        } else {
            crate::operation_deser::parse_update_client_certificate_response(response)
        }
    }
}

/// Operation shape for `UpdateDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_deployment`](crate::client::Client::update_deployment).
///
/// See [`crate::client::fluent_builders::UpdateDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeployment {
    _private: (),
}
impl UpdateDeployment {
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentInput`](crate::input::UpdateDeploymentInput)
    pub fn builder() -> crate::input::update_deployment_input::Builder {
        crate::input::update_deployment_input::Builder::default()
    }
    /// Creates a new `UpdateDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeployment {
    type Output = std::result::Result<
        crate::output::UpdateDeploymentOutput,
        crate::error::UpdateDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_deployment_error(response)
        } else {
            crate::operation_deser::parse_update_deployment_response(response)
        }
    }
}

/// Operation shape for `UpdateDocumentationPart`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_documentation_part`](crate::client::Client::update_documentation_part).
///
/// See [`crate::client::fluent_builders::UpdateDocumentationPart`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDocumentationPart {
    _private: (),
}
impl UpdateDocumentationPart {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentationPartInput`](crate::input::UpdateDocumentationPartInput)
    pub fn builder() -> crate::input::update_documentation_part_input::Builder {
        crate::input::update_documentation_part_input::Builder::default()
    }
    /// Creates a new `UpdateDocumentationPart` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDocumentationPart {
    type Output = std::result::Result<
        crate::output::UpdateDocumentationPartOutput,
        crate::error::UpdateDocumentationPartError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_documentation_part_error(response)
        } else {
            crate::operation_deser::parse_update_documentation_part_response(response)
        }
    }
}

/// Operation shape for `UpdateDocumentationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_documentation_version`](crate::client::Client::update_documentation_version).
///
/// See [`crate::client::fluent_builders::UpdateDocumentationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDocumentationVersion {
    _private: (),
}
impl UpdateDocumentationVersion {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentationVersionInput`](crate::input::UpdateDocumentationVersionInput)
    pub fn builder() -> crate::input::update_documentation_version_input::Builder {
        crate::input::update_documentation_version_input::Builder::default()
    }
    /// Creates a new `UpdateDocumentationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDocumentationVersion {
    type Output = std::result::Result<
        crate::output::UpdateDocumentationVersionOutput,
        crate::error::UpdateDocumentationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_documentation_version_error(response)
        } else {
            crate::operation_deser::parse_update_documentation_version_response(response)
        }
    }
}

/// Operation shape for `UpdateDomainName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_domain_name`](crate::client::Client::update_domain_name).
///
/// See [`crate::client::fluent_builders::UpdateDomainName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDomainName {
    _private: (),
}
impl UpdateDomainName {
    /// Creates a new builder-style object to manufacture [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
    pub fn builder() -> crate::input::update_domain_name_input::Builder {
        crate::input::update_domain_name_input::Builder::default()
    }
    /// Creates a new `UpdateDomainName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDomainName {
    type Output = std::result::Result<
        crate::output::UpdateDomainNameOutput,
        crate::error::UpdateDomainNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_domain_name_error(response)
        } else {
            crate::operation_deser::parse_update_domain_name_response(response)
        }
    }
}

/// Operation shape for `UpdateGatewayResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_gateway_response`](crate::client::Client::update_gateway_response).
///
/// See [`crate::client::fluent_builders::UpdateGatewayResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGatewayResponse {
    _private: (),
}
impl UpdateGatewayResponse {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayResponseInput`](crate::input::UpdateGatewayResponseInput)
    pub fn builder() -> crate::input::update_gateway_response_input::Builder {
        crate::input::update_gateway_response_input::Builder::default()
    }
    /// Creates a new `UpdateGatewayResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGatewayResponse {
    type Output = std::result::Result<
        crate::output::UpdateGatewayResponseOutput,
        crate::error::UpdateGatewayResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_gateway_response_error(response)
        } else {
            crate::operation_deser::parse_update_gateway_response_response(response)
        }
    }
}

/// Operation shape for `UpdateIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_integration`](crate::client::Client::update_integration).
///
/// See [`crate::client::fluent_builders::UpdateIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIntegration {
    _private: (),
}
impl UpdateIntegration {
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationInput`](crate::input::UpdateIntegrationInput)
    pub fn builder() -> crate::input::update_integration_input::Builder {
        crate::input::update_integration_input::Builder::default()
    }
    /// Creates a new `UpdateIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIntegration {
    type Output = std::result::Result<
        crate::output::UpdateIntegrationOutput,
        crate::error::UpdateIntegrationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_integration_error(response)
        } else {
            crate::operation_deser::parse_update_integration_response(response)
        }
    }
}

/// Operation shape for `UpdateIntegrationResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_integration_response`](crate::client::Client::update_integration_response).
///
/// See [`crate::client::fluent_builders::UpdateIntegrationResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIntegrationResponse {
    _private: (),
}
impl UpdateIntegrationResponse {
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationResponseInput`](crate::input::UpdateIntegrationResponseInput)
    pub fn builder() -> crate::input::update_integration_response_input::Builder {
        crate::input::update_integration_response_input::Builder::default()
    }
    /// Creates a new `UpdateIntegrationResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIntegrationResponse {
    type Output = std::result::Result<
        crate::output::UpdateIntegrationResponseOutput,
        crate::error::UpdateIntegrationResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_integration_response_error(response)
        } else {
            crate::operation_deser::parse_update_integration_response_response(response)
        }
    }
}

/// Operation shape for `UpdateMethod`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_method`](crate::client::Client::update_method).
///
/// See [`crate::client::fluent_builders::UpdateMethod`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMethod {
    _private: (),
}
impl UpdateMethod {
    /// Creates a new builder-style object to manufacture [`UpdateMethodInput`](crate::input::UpdateMethodInput)
    pub fn builder() -> crate::input::update_method_input::Builder {
        crate::input::update_method_input::Builder::default()
    }
    /// Creates a new `UpdateMethod` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMethod {
    type Output =
        std::result::Result<crate::output::UpdateMethodOutput, crate::error::UpdateMethodError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_method_error(response)
        } else {
            crate::operation_deser::parse_update_method_response(response)
        }
    }
}

/// Operation shape for `UpdateMethodResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_method_response`](crate::client::Client::update_method_response).
///
/// See [`crate::client::fluent_builders::UpdateMethodResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMethodResponse {
    _private: (),
}
impl UpdateMethodResponse {
    /// Creates a new builder-style object to manufacture [`UpdateMethodResponseInput`](crate::input::UpdateMethodResponseInput)
    pub fn builder() -> crate::input::update_method_response_input::Builder {
        crate::input::update_method_response_input::Builder::default()
    }
    /// Creates a new `UpdateMethodResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMethodResponse {
    type Output = std::result::Result<
        crate::output::UpdateMethodResponseOutput,
        crate::error::UpdateMethodResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_update_method_response_error(response)
        } else {
            crate::operation_deser::parse_update_method_response_response(response)
        }
    }
}

/// Operation shape for `UpdateModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_model`](crate::client::Client::update_model).
///
/// See [`crate::client::fluent_builders::UpdateModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateModel {
    _private: (),
}
impl UpdateModel {
    /// Creates a new builder-style object to manufacture [`UpdateModelInput`](crate::input::UpdateModelInput)
    pub fn builder() -> crate::input::update_model_input::Builder {
        crate::input::update_model_input::Builder::default()
    }
    /// Creates a new `UpdateModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateModel {
    type Output =
        std::result::Result<crate::output::UpdateModelOutput, crate::error::UpdateModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_model_error(response)
        } else {
            crate::operation_deser::parse_update_model_response(response)
        }
    }
}

/// Operation shape for `UpdateRequestValidator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_request_validator`](crate::client::Client::update_request_validator).
///
/// See [`crate::client::fluent_builders::UpdateRequestValidator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRequestValidator {
    _private: (),
}
impl UpdateRequestValidator {
    /// Creates a new builder-style object to manufacture [`UpdateRequestValidatorInput`](crate::input::UpdateRequestValidatorInput)
    pub fn builder() -> crate::input::update_request_validator_input::Builder {
        crate::input::update_request_validator_input::Builder::default()
    }
    /// Creates a new `UpdateRequestValidator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRequestValidator {
    type Output = std::result::Result<
        crate::output::UpdateRequestValidatorOutput,
        crate::error::UpdateRequestValidatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_request_validator_error(response)
        } else {
            crate::operation_deser::parse_update_request_validator_response(response)
        }
    }
}

/// Operation shape for `UpdateResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resource`](crate::client::Client::update_resource).
///
/// See [`crate::client::fluent_builders::UpdateResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResource {
    _private: (),
}
impl UpdateResource {
    /// Creates a new builder-style object to manufacture [`UpdateResourceInput`](crate::input::UpdateResourceInput)
    pub fn builder() -> crate::input::update_resource_input::Builder {
        crate::input::update_resource_input::Builder::default()
    }
    /// Creates a new `UpdateResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResource {
    type Output =
        std::result::Result<crate::output::UpdateResourceOutput, crate::error::UpdateResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resource_error(response)
        } else {
            crate::operation_deser::parse_update_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateRestApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rest_api`](crate::client::Client::update_rest_api).
///
/// See [`crate::client::fluent_builders::UpdateRestApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRestApi {
    _private: (),
}
impl UpdateRestApi {
    /// Creates a new builder-style object to manufacture [`UpdateRestApiInput`](crate::input::UpdateRestApiInput)
    pub fn builder() -> crate::input::update_rest_api_input::Builder {
        crate::input::update_rest_api_input::Builder::default()
    }
    /// Creates a new `UpdateRestApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRestApi {
    type Output =
        std::result::Result<crate::output::UpdateRestApiOutput, crate::error::UpdateRestApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rest_api_error(response)
        } else {
            crate::operation_deser::parse_update_rest_api_response(response)
        }
    }
}

/// Operation shape for `UpdateStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stage`](crate::client::Client::update_stage).
///
/// See [`crate::client::fluent_builders::UpdateStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStage {
    _private: (),
}
impl UpdateStage {
    /// Creates a new builder-style object to manufacture [`UpdateStageInput`](crate::input::UpdateStageInput)
    pub fn builder() -> crate::input::update_stage_input::Builder {
        crate::input::update_stage_input::Builder::default()
    }
    /// Creates a new `UpdateStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStage {
    type Output =
        std::result::Result<crate::output::UpdateStageOutput, crate::error::UpdateStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stage_error(response)
        } else {
            crate::operation_deser::parse_update_stage_response(response)
        }
    }
}

/// Operation shape for `UpdateUsage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_usage`](crate::client::Client::update_usage).
///
/// See [`crate::client::fluent_builders::UpdateUsage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUsage {
    _private: (),
}
impl UpdateUsage {
    /// Creates a new builder-style object to manufacture [`UpdateUsageInput`](crate::input::UpdateUsageInput)
    pub fn builder() -> crate::input::update_usage_input::Builder {
        crate::input::update_usage_input::Builder::default()
    }
    /// Creates a new `UpdateUsage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUsage {
    type Output =
        std::result::Result<crate::output::UpdateUsageOutput, crate::error::UpdateUsageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_usage_error(response)
        } else {
            crate::operation_deser::parse_update_usage_response(response)
        }
    }
}

/// Operation shape for `UpdateUsagePlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_usage_plan`](crate::client::Client::update_usage_plan).
///
/// See [`crate::client::fluent_builders::UpdateUsagePlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUsagePlan {
    _private: (),
}
impl UpdateUsagePlan {
    /// Creates a new builder-style object to manufacture [`UpdateUsagePlanInput`](crate::input::UpdateUsagePlanInput)
    pub fn builder() -> crate::input::update_usage_plan_input::Builder {
        crate::input::update_usage_plan_input::Builder::default()
    }
    /// Creates a new `UpdateUsagePlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUsagePlan {
    type Output = std::result::Result<
        crate::output::UpdateUsagePlanOutput,
        crate::error::UpdateUsagePlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_usage_plan_error(response)
        } else {
            crate::operation_deser::parse_update_usage_plan_response(response)
        }
    }
}

/// Operation shape for `UpdateVpcLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_vpc_link`](crate::client::Client::update_vpc_link).
///
/// See [`crate::client::fluent_builders::UpdateVpcLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVpcLink {
    _private: (),
}
impl UpdateVpcLink {
    /// Creates a new builder-style object to manufacture [`UpdateVpcLinkInput`](crate::input::UpdateVpcLinkInput)
    pub fn builder() -> crate::input::update_vpc_link_input::Builder {
        crate::input::update_vpc_link_input::Builder::default()
    }
    /// Creates a new `UpdateVpcLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVpcLink {
    type Output =
        std::result::Result<crate::output::UpdateVpcLinkOutput, crate::error::UpdateVpcLinkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_vpc_link_error(response)
        } else {
            crate::operation_deser::parse_update_vpc_link_response(response)
        }
    }
}
