// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VpcLinkStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VpcLinkStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => VpcLinkStatus::Available,
            "DELETING" => VpcLinkStatus::Deleting,
            "FAILED" => VpcLinkStatus::Failed,
            "PENDING" => VpcLinkStatus::Pending,
            other => VpcLinkStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VpcLinkStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VpcLinkStatus::from(s))
    }
}
impl VpcLinkStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VpcLinkStatus::Available => "AVAILABLE",
            VpcLinkStatus::Deleting => "DELETING",
            VpcLinkStatus::Failed => "FAILED",
            VpcLinkStatus::Pending => "PENDING",
            VpcLinkStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "FAILED", "PENDING"]
    }
}
impl AsRef<str> for VpcLinkStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A single patch operation to apply to the specified resource. Please refer to
/// http://tools.ietf.org/html/rfc6902#section-4 for an explanation of how each operation is used.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchOperation {
    /// <p> An update operation to be performed with this PATCH request. The valid value can be <code>add</code>, <code>remove</code>,  <code>replace</code> or <code>copy</code>. Not all valid operations are supported for a given resource. Support of the operations depends on specific operational contexts. Attempts to apply an unsupported operation on a resource will return an error message.</p>
    pub op: std::option::Option<crate::model::Op>,
    /// <p>The <code>op</code> operation's target, as identified by a <a href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer</a> value that references a location within the targeted resource. For example, if the target resource has an updateable property of <code>{"name":"value"}</code>, the path for this property is <code>/name</code>. If the <code>name</code> property value is a JSON object (e.g., <code>{"name": {"child/name": "child-value"}}</code>), the path for the <code>child/name</code> property will be <code>/name/child~1name</code>. Any slash ("/") character appearing in path names must be escaped with "~1", as shown in the example above. Each <code>op</code> operation can have only one <code>path</code> associated with it.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The new target value of the update operation. It is applicable for the <code>add</code> or <code>replace</code> operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The <code>copy</code> update operation's source as identified by a <code>JSON-Pointer</code> value referencing the location within the targeted resource to copy the value from. For example, to promote a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a <a>Stage</a> resource with <code>"op":"copy"</code>, <code>"from":"/canarySettings/deploymentId"</code> and <code>"path":"/deploymentId"</code>.</p>
    pub from: std::option::Option<std::string::String>,
}
impl PatchOperation {
    /// <p> An update operation to be performed with this PATCH request. The valid value can be <code>add</code>, <code>remove</code>,  <code>replace</code> or <code>copy</code>. Not all valid operations are supported for a given resource. Support of the operations depends on specific operational contexts. Attempts to apply an unsupported operation on a resource will return an error message.</p>
    pub fn op(&self) -> std::option::Option<&crate::model::Op> {
        self.op.as_ref()
    }
    /// <p>The <code>op</code> operation's target, as identified by a <a href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer</a> value that references a location within the targeted resource. For example, if the target resource has an updateable property of <code>{"name":"value"}</code>, the path for this property is <code>/name</code>. If the <code>name</code> property value is a JSON object (e.g., <code>{"name": {"child/name": "child-value"}}</code>), the path for the <code>child/name</code> property will be <code>/name/child~1name</code>. Any slash ("/") character appearing in path names must be escaped with "~1", as shown in the example above. Each <code>op</code> operation can have only one <code>path</code> associated with it.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The new target value of the update operation. It is applicable for the <code>add</code> or <code>replace</code> operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The <code>copy</code> update operation's source as identified by a <code>JSON-Pointer</code> value referencing the location within the targeted resource to copy the value from. For example, to promote a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a <a>Stage</a> resource with <code>"op":"copy"</code>, <code>"from":"/canarySettings/deploymentId"</code> and <code>"path":"/deploymentId"</code>.</p>
    pub fn from(&self) -> std::option::Option<&str> {
        self.from.as_deref()
    }
}
impl std::fmt::Debug for PatchOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchOperation");
        formatter.field("op", &self.op);
        formatter.field("path", &self.path);
        formatter.field("value", &self.value);
        formatter.field("from", &self.from);
        formatter.finish()
    }
}
/// See [`PatchOperation`](crate::model::PatchOperation)
pub mod patch_operation {
    /// A builder for [`PatchOperation`](crate::model::PatchOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) op: std::option::Option<crate::model::Op>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) from: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> An update operation to be performed with this PATCH request. The valid value can be <code>add</code>, <code>remove</code>,  <code>replace</code> or <code>copy</code>. Not all valid operations are supported for a given resource. Support of the operations depends on specific operational contexts. Attempts to apply an unsupported operation on a resource will return an error message.</p>
        pub fn op(mut self, input: crate::model::Op) -> Self {
            self.op = Some(input);
            self
        }
        /// <p> An update operation to be performed with this PATCH request. The valid value can be <code>add</code>, <code>remove</code>,  <code>replace</code> or <code>copy</code>. Not all valid operations are supported for a given resource. Support of the operations depends on specific operational contexts. Attempts to apply an unsupported operation on a resource will return an error message.</p>
        pub fn set_op(mut self, input: std::option::Option<crate::model::Op>) -> Self {
            self.op = input;
            self
        }
        /// <p>The <code>op</code> operation's target, as identified by a <a href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer</a> value that references a location within the targeted resource. For example, if the target resource has an updateable property of <code>{"name":"value"}</code>, the path for this property is <code>/name</code>. If the <code>name</code> property value is a JSON object (e.g., <code>{"name": {"child/name": "child-value"}}</code>), the path for the <code>child/name</code> property will be <code>/name/child~1name</code>. Any slash ("/") character appearing in path names must be escaped with "~1", as shown in the example above. Each <code>op</code> operation can have only one <code>path</code> associated with it.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The <code>op</code> operation's target, as identified by a <a href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer</a> value that references a location within the targeted resource. For example, if the target resource has an updateable property of <code>{"name":"value"}</code>, the path for this property is <code>/name</code>. If the <code>name</code> property value is a JSON object (e.g., <code>{"name": {"child/name": "child-value"}}</code>), the path for the <code>child/name</code> property will be <code>/name/child~1name</code>. Any slash ("/") character appearing in path names must be escaped with "~1", as shown in the example above. Each <code>op</code> operation can have only one <code>path</code> associated with it.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The new target value of the update operation. It is applicable for the <code>add</code> or <code>replace</code> operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The new target value of the update operation. It is applicable for the <code>add</code> or <code>replace</code> operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The <code>copy</code> update operation's source as identified by a <code>JSON-Pointer</code> value referencing the location within the targeted resource to copy the value from. For example, to promote a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a <a>Stage</a> resource with <code>"op":"copy"</code>, <code>"from":"/canarySettings/deploymentId"</code> and <code>"path":"/deploymentId"</code>.</p>
        pub fn from(mut self, input: impl Into<std::string::String>) -> Self {
            self.from = Some(input.into());
            self
        }
        /// <p>The <code>copy</code> update operation's source as identified by a <code>JSON-Pointer</code> value referencing the location within the targeted resource to copy the value from. For example, to promote a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a <a>Stage</a> resource with <code>"op":"copy"</code>, <code>"from":"/canarySettings/deploymentId"</code> and <code>"path":"/deploymentId"</code>.</p>
        pub fn set_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchOperation`](crate::model::PatchOperation)
        pub fn build(self) -> crate::model::PatchOperation {
            crate::model::PatchOperation {
                op: self.op,
                path: self.path,
                value: self.value,
                from: self.from,
            }
        }
    }
}
impl PatchOperation {
    /// Creates a new builder-style object to manufacture [`PatchOperation`](crate::model::PatchOperation)
    pub fn builder() -> crate::model::patch_operation::Builder {
        crate::model::patch_operation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Op {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    Copy,
    #[allow(missing_docs)] // documentation missing in model
    Move,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    #[allow(missing_docs)] // documentation missing in model
    Test,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Op {
    fn from(s: &str) -> Self {
        match s {
            "add" => Op::Add,
            "copy" => Op::Copy,
            "move" => Op::Move,
            "remove" => Op::Remove,
            "replace" => Op::Replace,
            "test" => Op::Test,
            other => Op::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Op {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Op::from(s))
    }
}
impl Op {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Op::Add => "add",
            Op::Copy => "copy",
            Op::Move => "move",
            Op::Remove => "remove",
            Op::Replace => "replace",
            Op::Test => "test",
            Op::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["add", "copy", "move", "remove", "replace", "test"]
    }
}
impl AsRef<str> for Op {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Quotas configured for a usage plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuotaSettings {
    /// <p>The maximum number of requests that can be made in a given time period.</p>
    pub limit: i32,
    /// <p>The day that a time period starts. For example, with a time period of <code>WEEK</code>, an offset of <code>0</code> starts on Sunday, and an offset of <code>1</code> starts on Monday.</p>
    pub offset: i32,
    /// <p>The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".</p>
    pub period: std::option::Option<crate::model::QuotaPeriodType>,
}
impl QuotaSettings {
    /// <p>The maximum number of requests that can be made in a given time period.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The day that a time period starts. For example, with a time period of <code>WEEK</code>, an offset of <code>0</code> starts on Sunday, and an offset of <code>1</code> starts on Monday.</p>
    pub fn offset(&self) -> i32 {
        self.offset
    }
    /// <p>The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".</p>
    pub fn period(&self) -> std::option::Option<&crate::model::QuotaPeriodType> {
        self.period.as_ref()
    }
}
impl std::fmt::Debug for QuotaSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuotaSettings");
        formatter.field("limit", &self.limit);
        formatter.field("offset", &self.offset);
        formatter.field("period", &self.period);
        formatter.finish()
    }
}
/// See [`QuotaSettings`](crate::model::QuotaSettings)
pub mod quota_settings {
    /// A builder for [`QuotaSettings`](crate::model::QuotaSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) offset: std::option::Option<i32>,
        pub(crate) period: std::option::Option<crate::model::QuotaPeriodType>,
    }
    impl Builder {
        /// <p>The maximum number of requests that can be made in a given time period.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of requests that can be made in a given time period.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The day that a time period starts. For example, with a time period of <code>WEEK</code>, an offset of <code>0</code> starts on Sunday, and an offset of <code>1</code> starts on Monday.</p>
        pub fn offset(mut self, input: i32) -> Self {
            self.offset = Some(input);
            self
        }
        /// <p>The day that a time period starts. For example, with a time period of <code>WEEK</code>, an offset of <code>0</code> starts on Sunday, and an offset of <code>1</code> starts on Monday.</p>
        pub fn set_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.offset = input;
            self
        }
        /// <p>The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".</p>
        pub fn period(mut self, input: crate::model::QuotaPeriodType) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".</p>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::QuotaPeriodType>,
        ) -> Self {
            self.period = input;
            self
        }
        /// Consumes the builder and constructs a [`QuotaSettings`](crate::model::QuotaSettings)
        pub fn build(self) -> crate::model::QuotaSettings {
            crate::model::QuotaSettings {
                limit: self.limit.unwrap_or_default(),
                offset: self.offset.unwrap_or_default(),
                period: self.period,
            }
        }
    }
}
impl QuotaSettings {
    /// Creates a new builder-style object to manufacture [`QuotaSettings`](crate::model::QuotaSettings)
    pub fn builder() -> crate::model::quota_settings::Builder {
        crate::model::quota_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QuotaPeriodType {
    #[allow(missing_docs)] // documentation missing in model
    Day,
    #[allow(missing_docs)] // documentation missing in model
    Month,
    #[allow(missing_docs)] // documentation missing in model
    Week,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QuotaPeriodType {
    fn from(s: &str) -> Self {
        match s {
            "DAY" => QuotaPeriodType::Day,
            "MONTH" => QuotaPeriodType::Month,
            "WEEK" => QuotaPeriodType::Week,
            other => QuotaPeriodType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QuotaPeriodType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QuotaPeriodType::from(s))
    }
}
impl QuotaPeriodType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QuotaPeriodType::Day => "DAY",
            QuotaPeriodType::Month => "MONTH",
            QuotaPeriodType::Week => "WEEK",
            QuotaPeriodType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAY", "MONTH", "WEEK"]
    }
}
impl AsRef<str> for QuotaPeriodType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The API request rate limits.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottleSettings {
    /// <p>The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.</p>
    pub burst_limit: i32,
    /// <p>The API request steady-state rate limit.</p>
    pub rate_limit: f64,
}
impl ThrottleSettings {
    /// <p>The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.</p>
    pub fn burst_limit(&self) -> i32 {
        self.burst_limit
    }
    /// <p>The API request steady-state rate limit.</p>
    pub fn rate_limit(&self) -> f64 {
        self.rate_limit
    }
}
impl std::fmt::Debug for ThrottleSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottleSettings");
        formatter.field("burst_limit", &self.burst_limit);
        formatter.field("rate_limit", &self.rate_limit);
        formatter.finish()
    }
}
/// See [`ThrottleSettings`](crate::model::ThrottleSettings)
pub mod throttle_settings {
    /// A builder for [`ThrottleSettings`](crate::model::ThrottleSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) burst_limit: std::option::Option<i32>,
        pub(crate) rate_limit: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.</p>
        pub fn burst_limit(mut self, input: i32) -> Self {
            self.burst_limit = Some(input);
            self
        }
        /// <p>The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.</p>
        pub fn set_burst_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.burst_limit = input;
            self
        }
        /// <p>The API request steady-state rate limit.</p>
        pub fn rate_limit(mut self, input: f64) -> Self {
            self.rate_limit = Some(input);
            self
        }
        /// <p>The API request steady-state rate limit.</p>
        pub fn set_rate_limit(mut self, input: std::option::Option<f64>) -> Self {
            self.rate_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottleSettings`](crate::model::ThrottleSettings)
        pub fn build(self) -> crate::model::ThrottleSettings {
            crate::model::ThrottleSettings {
                burst_limit: self.burst_limit.unwrap_or_default(),
                rate_limit: self.rate_limit.unwrap_or_default(),
            }
        }
    }
}
impl ThrottleSettings {
    /// Creates a new builder-style object to manufacture [`ThrottleSettings`](crate::model::ThrottleSettings)
    pub fn builder() -> crate::model::throttle_settings::Builder {
        crate::model::throttle_settings::Builder::default()
    }
}

/// <p>API stage name of the associated API stage in a usage plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiStage {
    /// <p>API Id of the associated API stage in a usage plan.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>API stage name of the associated API stage in a usage plan.</p>
    pub stage: std::option::Option<std::string::String>,
    /// <p>Map containing method level throttling information for API stage in a usage plan.</p>
    pub throttle: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ThrottleSettings>,
    >,
}
impl ApiStage {
    /// <p>API Id of the associated API stage in a usage plan.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>API stage name of the associated API stage in a usage plan.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
    /// <p>Map containing method level throttling information for API stage in a usage plan.</p>
    pub fn throttle(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ThrottleSettings>,
    > {
        self.throttle.as_ref()
    }
}
impl std::fmt::Debug for ApiStage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiStage");
        formatter.field("api_id", &self.api_id);
        formatter.field("stage", &self.stage);
        formatter.field("throttle", &self.throttle);
        formatter.finish()
    }
}
/// See [`ApiStage`](crate::model::ApiStage)
pub mod api_stage {
    /// A builder for [`ApiStage`](crate::model::ApiStage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
        pub(crate) throttle: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ThrottleSettings>,
        >,
    }
    impl Builder {
        /// <p>API Id of the associated API stage in a usage plan.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>API Id of the associated API stage in a usage plan.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>API stage name of the associated API stage in a usage plan.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>API stage name of the associated API stage in a usage plan.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Adds a key-value pair to `throttle`.
        ///
        /// To override the contents of this collection use [`set_throttle`](Self::set_throttle).
        ///
        /// <p>Map containing method level throttling information for API stage in a usage plan.</p>
        pub fn throttle(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ThrottleSettings>,
        ) -> Self {
            let mut hash_map = self.throttle.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.throttle = Some(hash_map);
            self
        }
        /// <p>Map containing method level throttling information for API stage in a usage plan.</p>
        pub fn set_throttle(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ThrottleSettings>,
            >,
        ) -> Self {
            self.throttle = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiStage`](crate::model::ApiStage)
        pub fn build(self) -> crate::model::ApiStage {
            crate::model::ApiStage {
                api_id: self.api_id,
                stage: self.stage,
                throttle: self.throttle,
            }
        }
    }
}
impl ApiStage {
    /// Creates a new builder-style object to manufacture [`ApiStage`](crate::model::ApiStage)
    pub fn builder() -> crate::model::api_stage::Builder {
        crate::model::api_stage::Builder::default()
    }
}

/// <p>Configuration settings of a canary deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CanarySettings {
    /// <p>The percent (0-100) of traffic diverted to a canary deployment.</p>
    pub percent_traffic: f64,
    /// <p>The ID of the canary deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>
    pub stage_variable_overrides:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A Boolean flag to indicate whether the canary deployment uses the stage cache or not.</p>
    pub use_stage_cache: bool,
}
impl CanarySettings {
    /// <p>The percent (0-100) of traffic diverted to a canary deployment.</p>
    pub fn percent_traffic(&self) -> f64 {
        self.percent_traffic
    }
    /// <p>The ID of the canary deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>
    pub fn stage_variable_overrides(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.stage_variable_overrides.as_ref()
    }
    /// <p>A Boolean flag to indicate whether the canary deployment uses the stage cache or not.</p>
    pub fn use_stage_cache(&self) -> bool {
        self.use_stage_cache
    }
}
impl std::fmt::Debug for CanarySettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CanarySettings");
        formatter.field("percent_traffic", &self.percent_traffic);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("stage_variable_overrides", &self.stage_variable_overrides);
        formatter.field("use_stage_cache", &self.use_stage_cache);
        formatter.finish()
    }
}
/// See [`CanarySettings`](crate::model::CanarySettings)
pub mod canary_settings {
    /// A builder for [`CanarySettings`](crate::model::CanarySettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percent_traffic: std::option::Option<f64>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) stage_variable_overrides: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) use_stage_cache: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The percent (0-100) of traffic diverted to a canary deployment.</p>
        pub fn percent_traffic(mut self, input: f64) -> Self {
            self.percent_traffic = Some(input);
            self
        }
        /// <p>The percent (0-100) of traffic diverted to a canary deployment.</p>
        pub fn set_percent_traffic(mut self, input: std::option::Option<f64>) -> Self {
            self.percent_traffic = input;
            self
        }
        /// <p>The ID of the canary deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The ID of the canary deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Adds a key-value pair to `stage_variable_overrides`.
        ///
        /// To override the contents of this collection use [`set_stage_variable_overrides`](Self::set_stage_variable_overrides).
        ///
        /// <p>Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>
        pub fn stage_variable_overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variable_overrides.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variable_overrides = Some(hash_map);
            self
        }
        /// <p>Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>
        pub fn set_stage_variable_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variable_overrides = input;
            self
        }
        /// <p>A Boolean flag to indicate whether the canary deployment uses the stage cache or not.</p>
        pub fn use_stage_cache(mut self, input: bool) -> Self {
            self.use_stage_cache = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether the canary deployment uses the stage cache or not.</p>
        pub fn set_use_stage_cache(mut self, input: std::option::Option<bool>) -> Self {
            self.use_stage_cache = input;
            self
        }
        /// Consumes the builder and constructs a [`CanarySettings`](crate::model::CanarySettings)
        pub fn build(self) -> crate::model::CanarySettings {
            crate::model::CanarySettings {
                percent_traffic: self.percent_traffic.unwrap_or_default(),
                deployment_id: self.deployment_id,
                stage_variable_overrides: self.stage_variable_overrides,
                use_stage_cache: self.use_stage_cache.unwrap_or_default(),
            }
        }
    }
}
impl CanarySettings {
    /// Creates a new builder-style object to manufacture [`CanarySettings`](crate::model::CanarySettings)
    pub fn builder() -> crate::model::canary_settings::Builder {
        crate::model::canary_settings::Builder::default()
    }
}

/// <p>Access log settings, including the access log format and access log destination ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessLogSettings {
    /// <p>A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables</a>. The format must include at least <code>$context.requestId</code>.</p>
    pub format: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code>.</p>
    pub destination_arn: std::option::Option<std::string::String>,
}
impl AccessLogSettings {
    /// <p>A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables</a>. The format must include at least <code>$context.requestId</code>.</p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code>.</p>
    pub fn destination_arn(&self) -> std::option::Option<&str> {
        self.destination_arn.as_deref()
    }
}
impl std::fmt::Debug for AccessLogSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessLogSettings");
        formatter.field("format", &self.format);
        formatter.field("destination_arn", &self.destination_arn);
        formatter.finish()
    }
}
/// See [`AccessLogSettings`](crate::model::AccessLogSettings)
pub mod access_log_settings {
    /// A builder for [`AccessLogSettings`](crate::model::AccessLogSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) destination_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables</a>. The format must include at least <code>$context.requestId</code>.</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables</a>. The format must include at least <code>$context.requestId</code>.</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code>.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code>.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessLogSettings`](crate::model::AccessLogSettings)
        pub fn build(self) -> crate::model::AccessLogSettings {
            crate::model::AccessLogSettings {
                format: self.format,
                destination_arn: self.destination_arn,
            }
        }
    }
}
impl AccessLogSettings {
    /// Creates a new builder-style object to manufacture [`AccessLogSettings`](crate::model::AccessLogSettings)
    pub fn builder() -> crate::model::access_log_settings::Builder {
        crate::model::access_log_settings::Builder::default()
    }
}

/// <p>Specifies the method setting properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MethodSetting {
    /// <p>Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is <code>/{method_setting_key}/metrics/enabled</code>, and the value is a Boolean.</p>
    pub metrics_enabled: bool,
    /// <p>Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is <code>/{method_setting_key}/logging/loglevel</code>, and the available levels are <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code> events as well as extra informational events.</p>
    pub logging_level: std::option::Option<std::string::String>,
    /// <p>Specifies whether full requests and responses are logged for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs. The PATCH path for this setting is <code>/{method_setting_key}/logging/dataTrace</code>, and the value is a Boolean.</p>
    pub data_trace_enabled: bool,
    /// <p>Specifies the throttling burst limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/burstLimit</code>, and the value is an integer.</p>
    pub throttling_burst_limit: i32,
    /// <p>Specifies the throttling rate limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/rateLimit</code>, and the value is a double.</p>
    pub throttling_rate_limit: f64,
    /// <p>Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/enabled</code>, and the value is a Boolean.</p>
    pub caching_enabled: bool,
    /// <p>Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/ttlInSeconds</code>, and the value is an integer.</p>
    pub cache_ttl_in_seconds: i32,
    /// <p>Specifies whether the cached responses are encrypted. The PATCH path for this setting is <code>/{method_setting_key}/caching/dataEncrypted</code>, and the value is a Boolean.</p>
    pub cache_data_encrypted: bool,
    /// <p>Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting is <code>/{method_setting_key}/caching/requireAuthorizationForCacheControl</code>, and the value is a Boolean.</p>
    pub require_authorization_for_cache_control: bool,
    /// <p>Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available values are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>, <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.</p>
    pub unauthorized_cache_control_header_strategy:
        std::option::Option<crate::model::UnauthorizedCacheControlHeaderStrategy>,
}
impl MethodSetting {
    /// <p>Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is <code>/{method_setting_key}/metrics/enabled</code>, and the value is a Boolean.</p>
    pub fn metrics_enabled(&self) -> bool {
        self.metrics_enabled
    }
    /// <p>Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is <code>/{method_setting_key}/logging/loglevel</code>, and the available levels are <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code> events as well as extra informational events.</p>
    pub fn logging_level(&self) -> std::option::Option<&str> {
        self.logging_level.as_deref()
    }
    /// <p>Specifies whether full requests and responses are logged for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs. The PATCH path for this setting is <code>/{method_setting_key}/logging/dataTrace</code>, and the value is a Boolean.</p>
    pub fn data_trace_enabled(&self) -> bool {
        self.data_trace_enabled
    }
    /// <p>Specifies the throttling burst limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/burstLimit</code>, and the value is an integer.</p>
    pub fn throttling_burst_limit(&self) -> i32 {
        self.throttling_burst_limit
    }
    /// <p>Specifies the throttling rate limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/rateLimit</code>, and the value is a double.</p>
    pub fn throttling_rate_limit(&self) -> f64 {
        self.throttling_rate_limit
    }
    /// <p>Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/enabled</code>, and the value is a Boolean.</p>
    pub fn caching_enabled(&self) -> bool {
        self.caching_enabled
    }
    /// <p>Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/ttlInSeconds</code>, and the value is an integer.</p>
    pub fn cache_ttl_in_seconds(&self) -> i32 {
        self.cache_ttl_in_seconds
    }
    /// <p>Specifies whether the cached responses are encrypted. The PATCH path for this setting is <code>/{method_setting_key}/caching/dataEncrypted</code>, and the value is a Boolean.</p>
    pub fn cache_data_encrypted(&self) -> bool {
        self.cache_data_encrypted
    }
    /// <p>Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting is <code>/{method_setting_key}/caching/requireAuthorizationForCacheControl</code>, and the value is a Boolean.</p>
    pub fn require_authorization_for_cache_control(&self) -> bool {
        self.require_authorization_for_cache_control
    }
    /// <p>Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available values are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>, <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.</p>
    pub fn unauthorized_cache_control_header_strategy(
        &self,
    ) -> std::option::Option<&crate::model::UnauthorizedCacheControlHeaderStrategy> {
        self.unauthorized_cache_control_header_strategy.as_ref()
    }
}
impl std::fmt::Debug for MethodSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MethodSetting");
        formatter.field("metrics_enabled", &self.metrics_enabled);
        formatter.field("logging_level", &self.logging_level);
        formatter.field("data_trace_enabled", &self.data_trace_enabled);
        formatter.field("throttling_burst_limit", &self.throttling_burst_limit);
        formatter.field("throttling_rate_limit", &self.throttling_rate_limit);
        formatter.field("caching_enabled", &self.caching_enabled);
        formatter.field("cache_ttl_in_seconds", &self.cache_ttl_in_seconds);
        formatter.field("cache_data_encrypted", &self.cache_data_encrypted);
        formatter.field(
            "require_authorization_for_cache_control",
            &self.require_authorization_for_cache_control,
        );
        formatter.field(
            "unauthorized_cache_control_header_strategy",
            &self.unauthorized_cache_control_header_strategy,
        );
        formatter.finish()
    }
}
/// See [`MethodSetting`](crate::model::MethodSetting)
pub mod method_setting {
    /// A builder for [`MethodSetting`](crate::model::MethodSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metrics_enabled: std::option::Option<bool>,
        pub(crate) logging_level: std::option::Option<std::string::String>,
        pub(crate) data_trace_enabled: std::option::Option<bool>,
        pub(crate) throttling_burst_limit: std::option::Option<i32>,
        pub(crate) throttling_rate_limit: std::option::Option<f64>,
        pub(crate) caching_enabled: std::option::Option<bool>,
        pub(crate) cache_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) cache_data_encrypted: std::option::Option<bool>,
        pub(crate) require_authorization_for_cache_control: std::option::Option<bool>,
        pub(crate) unauthorized_cache_control_header_strategy:
            std::option::Option<crate::model::UnauthorizedCacheControlHeaderStrategy>,
    }
    impl Builder {
        /// <p>Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is <code>/{method_setting_key}/metrics/enabled</code>, and the value is a Boolean.</p>
        pub fn metrics_enabled(mut self, input: bool) -> Self {
            self.metrics_enabled = Some(input);
            self
        }
        /// <p>Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is <code>/{method_setting_key}/metrics/enabled</code>, and the value is a Boolean.</p>
        pub fn set_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.metrics_enabled = input;
            self
        }
        /// <p>Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is <code>/{method_setting_key}/logging/loglevel</code>, and the available levels are <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code> events as well as extra informational events.</p>
        pub fn logging_level(mut self, input: impl Into<std::string::String>) -> Self {
            self.logging_level = Some(input.into());
            self
        }
        /// <p>Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is <code>/{method_setting_key}/logging/loglevel</code>, and the available levels are <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code> events as well as extra informational events.</p>
        pub fn set_logging_level(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logging_level = input;
            self
        }
        /// <p>Specifies whether full requests and responses are logged for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs. The PATCH path for this setting is <code>/{method_setting_key}/logging/dataTrace</code>, and the value is a Boolean.</p>
        pub fn data_trace_enabled(mut self, input: bool) -> Self {
            self.data_trace_enabled = Some(input);
            self
        }
        /// <p>Specifies whether full requests and responses are logged for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs. The PATCH path for this setting is <code>/{method_setting_key}/logging/dataTrace</code>, and the value is a Boolean.</p>
        pub fn set_data_trace_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.data_trace_enabled = input;
            self
        }
        /// <p>Specifies the throttling burst limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/burstLimit</code>, and the value is an integer.</p>
        pub fn throttling_burst_limit(mut self, input: i32) -> Self {
            self.throttling_burst_limit = Some(input);
            self
        }
        /// <p>Specifies the throttling burst limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/burstLimit</code>, and the value is an integer.</p>
        pub fn set_throttling_burst_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.throttling_burst_limit = input;
            self
        }
        /// <p>Specifies the throttling rate limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/rateLimit</code>, and the value is a double.</p>
        pub fn throttling_rate_limit(mut self, input: f64) -> Self {
            self.throttling_rate_limit = Some(input);
            self
        }
        /// <p>Specifies the throttling rate limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/rateLimit</code>, and the value is a double.</p>
        pub fn set_throttling_rate_limit(mut self, input: std::option::Option<f64>) -> Self {
            self.throttling_rate_limit = input;
            self
        }
        /// <p>Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/enabled</code>, and the value is a Boolean.</p>
        pub fn caching_enabled(mut self, input: bool) -> Self {
            self.caching_enabled = Some(input);
            self
        }
        /// <p>Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/enabled</code>, and the value is a Boolean.</p>
        pub fn set_caching_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.caching_enabled = input;
            self
        }
        /// <p>Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/ttlInSeconds</code>, and the value is an integer.</p>
        pub fn cache_ttl_in_seconds(mut self, input: i32) -> Self {
            self.cache_ttl_in_seconds = Some(input);
            self
        }
        /// <p>Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/ttlInSeconds</code>, and the value is an integer.</p>
        pub fn set_cache_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.cache_ttl_in_seconds = input;
            self
        }
        /// <p>Specifies whether the cached responses are encrypted. The PATCH path for this setting is <code>/{method_setting_key}/caching/dataEncrypted</code>, and the value is a Boolean.</p>
        pub fn cache_data_encrypted(mut self, input: bool) -> Self {
            self.cache_data_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the cached responses are encrypted. The PATCH path for this setting is <code>/{method_setting_key}/caching/dataEncrypted</code>, and the value is a Boolean.</p>
        pub fn set_cache_data_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.cache_data_encrypted = input;
            self
        }
        /// <p>Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting is <code>/{method_setting_key}/caching/requireAuthorizationForCacheControl</code>, and the value is a Boolean.</p>
        pub fn require_authorization_for_cache_control(mut self, input: bool) -> Self {
            self.require_authorization_for_cache_control = Some(input);
            self
        }
        /// <p>Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting is <code>/{method_setting_key}/caching/requireAuthorizationForCacheControl</code>, and the value is a Boolean.</p>
        pub fn set_require_authorization_for_cache_control(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.require_authorization_for_cache_control = input;
            self
        }
        /// <p>Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available values are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>, <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.</p>
        pub fn unauthorized_cache_control_header_strategy(
            mut self,
            input: crate::model::UnauthorizedCacheControlHeaderStrategy,
        ) -> Self {
            self.unauthorized_cache_control_header_strategy = Some(input);
            self
        }
        /// <p>Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available values are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>, <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.</p>
        pub fn set_unauthorized_cache_control_header_strategy(
            mut self,
            input: std::option::Option<crate::model::UnauthorizedCacheControlHeaderStrategy>,
        ) -> Self {
            self.unauthorized_cache_control_header_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`MethodSetting`](crate::model::MethodSetting)
        pub fn build(self) -> crate::model::MethodSetting {
            crate::model::MethodSetting {
                metrics_enabled: self.metrics_enabled.unwrap_or_default(),
                logging_level: self.logging_level,
                data_trace_enabled: self.data_trace_enabled.unwrap_or_default(),
                throttling_burst_limit: self.throttling_burst_limit.unwrap_or_default(),
                throttling_rate_limit: self.throttling_rate_limit.unwrap_or_default(),
                caching_enabled: self.caching_enabled.unwrap_or_default(),
                cache_ttl_in_seconds: self.cache_ttl_in_seconds.unwrap_or_default(),
                cache_data_encrypted: self.cache_data_encrypted.unwrap_or_default(),
                require_authorization_for_cache_control: self
                    .require_authorization_for_cache_control
                    .unwrap_or_default(),
                unauthorized_cache_control_header_strategy: self
                    .unauthorized_cache_control_header_strategy,
            }
        }
    }
}
impl MethodSetting {
    /// Creates a new builder-style object to manufacture [`MethodSetting`](crate::model::MethodSetting)
    pub fn builder() -> crate::model::method_setting::Builder {
        crate::model::method_setting::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UnauthorizedCacheControlHeaderStrategy {
    #[allow(missing_docs)] // documentation missing in model
    FailWith403,
    #[allow(missing_docs)] // documentation missing in model
    SucceedWithoutResponseHeader,
    #[allow(missing_docs)] // documentation missing in model
    SucceedWithResponseHeader,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UnauthorizedCacheControlHeaderStrategy {
    fn from(s: &str) -> Self {
        match s {
            "FAIL_WITH_403" => UnauthorizedCacheControlHeaderStrategy::FailWith403,
            "SUCCEED_WITHOUT_RESPONSE_HEADER" => {
                UnauthorizedCacheControlHeaderStrategy::SucceedWithoutResponseHeader
            }
            "SUCCEED_WITH_RESPONSE_HEADER" => {
                UnauthorizedCacheControlHeaderStrategy::SucceedWithResponseHeader
            }
            other => UnauthorizedCacheControlHeaderStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UnauthorizedCacheControlHeaderStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UnauthorizedCacheControlHeaderStrategy::from(s))
    }
}
impl UnauthorizedCacheControlHeaderStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UnauthorizedCacheControlHeaderStrategy::FailWith403 => "FAIL_WITH_403",
            UnauthorizedCacheControlHeaderStrategy::SucceedWithoutResponseHeader => {
                "SUCCEED_WITHOUT_RESPONSE_HEADER"
            }
            UnauthorizedCacheControlHeaderStrategy::SucceedWithResponseHeader => {
                "SUCCEED_WITH_RESPONSE_HEADER"
            }
            UnauthorizedCacheControlHeaderStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAIL_WITH_403",
            "SUCCEED_WITHOUT_RESPONSE_HEADER",
            "SUCCEED_WITH_RESPONSE_HEADER",
        ]
    }
}
impl AsRef<str> for UnauthorizedCacheControlHeaderStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns the status of the <b>CacheCluster</b>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CacheClusterStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    FlushInProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotAvailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CacheClusterStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => CacheClusterStatus::Available,
            "CREATE_IN_PROGRESS" => CacheClusterStatus::CreateInProgress,
            "DELETE_IN_PROGRESS" => CacheClusterStatus::DeleteInProgress,
            "FLUSH_IN_PROGRESS" => CacheClusterStatus::FlushInProgress,
            "NOT_AVAILABLE" => CacheClusterStatus::NotAvailable,
            other => CacheClusterStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CacheClusterStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CacheClusterStatus::from(s))
    }
}
impl CacheClusterStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CacheClusterStatus::Available => "AVAILABLE",
            CacheClusterStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            CacheClusterStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            CacheClusterStatus::FlushInProgress => "FLUSH_IN_PROGRESS",
            CacheClusterStatus::NotAvailable => "NOT_AVAILABLE",
            CacheClusterStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATE_IN_PROGRESS",
            "DELETE_IN_PROGRESS",
            "FLUSH_IN_PROGRESS",
            "NOT_AVAILABLE",
        ]
    }
}
impl AsRef<str> for CacheClusterStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns the size of the <b>CacheCluster</b>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CacheClusterSize {
    #[allow(missing_docs)] // documentation missing in model
    Size0Point5Gb,
    #[allow(missing_docs)] // documentation missing in model
    Size1Point6Gb,
    #[allow(missing_docs)] // documentation missing in model
    Size118Gb,
    #[allow(missing_docs)] // documentation missing in model
    Size13Point5Gb,
    #[allow(missing_docs)] // documentation missing in model
    Size237Gb,
    #[allow(missing_docs)] // documentation missing in model
    Size28Point4Gb,
    #[allow(missing_docs)] // documentation missing in model
    Size58Point2Gb,
    #[allow(missing_docs)] // documentation missing in model
    Size6Point1Gb,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CacheClusterSize {
    fn from(s: &str) -> Self {
        match s {
            "0.5" => CacheClusterSize::Size0Point5Gb,
            "1.6" => CacheClusterSize::Size1Point6Gb,
            "118" => CacheClusterSize::Size118Gb,
            "13.5" => CacheClusterSize::Size13Point5Gb,
            "237" => CacheClusterSize::Size237Gb,
            "28.4" => CacheClusterSize::Size28Point4Gb,
            "58.2" => CacheClusterSize::Size58Point2Gb,
            "6.1" => CacheClusterSize::Size6Point1Gb,
            other => CacheClusterSize::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CacheClusterSize {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CacheClusterSize::from(s))
    }
}
impl CacheClusterSize {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CacheClusterSize::Size0Point5Gb => "0.5",
            CacheClusterSize::Size1Point6Gb => "1.6",
            CacheClusterSize::Size118Gb => "118",
            CacheClusterSize::Size13Point5Gb => "13.5",
            CacheClusterSize::Size237Gb => "237",
            CacheClusterSize::Size28Point4Gb => "28.4",
            CacheClusterSize::Size58Point2Gb => "58.2",
            CacheClusterSize::Size6Point1Gb => "6.1",
            CacheClusterSize::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["0.5", "1.6", "118", "13.5", "237", "28.4", "58.2", "6.1"]
    }
}
impl AsRef<str> for CacheClusterSize {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The endpoint configuration to indicate the types of endpoints an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>) has. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointConfiguration {
    /// <p>A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.</p>
    pub types: std::option::Option<std::vec::Vec<crate::model::EndpointType>>,
    /// <p>A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.</p>
    pub vpc_endpoint_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EndpointConfiguration {
    /// <p>A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.</p>
    pub fn types(&self) -> std::option::Option<&[crate::model::EndpointType]> {
        self.types.as_deref()
    }
    /// <p>A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.</p>
    pub fn vpc_endpoint_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_endpoint_ids.as_deref()
    }
}
impl std::fmt::Debug for EndpointConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointConfiguration");
        formatter.field("types", &self.types);
        formatter.field("vpc_endpoint_ids", &self.vpc_endpoint_ids);
        formatter.finish()
    }
}
/// See [`EndpointConfiguration`](crate::model::EndpointConfiguration)
pub mod endpoint_configuration {
    /// A builder for [`EndpointConfiguration`](crate::model::EndpointConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) types: std::option::Option<std::vec::Vec<crate::model::EndpointType>>,
        pub(crate) vpc_endpoint_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.</p>
        pub fn types(mut self, input: impl Into<crate::model::EndpointType>) -> Self {
            let mut v = self.types.unwrap_or_default();
            v.push(input.into());
            self.types = Some(v);
            self
        }
        /// <p>A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointType>>,
        ) -> Self {
            self.types = input;
            self
        }
        /// Appends an item to `vpc_endpoint_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_endpoint_ids`](Self::set_vpc_endpoint_ids).
        ///
        /// <p>A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.</p>
        pub fn vpc_endpoint_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_endpoint_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_endpoint_ids = Some(v);
            self
        }
        /// <p>A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.</p>
        pub fn set_vpc_endpoint_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_endpoint_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointConfiguration`](crate::model::EndpointConfiguration)
        pub fn build(self) -> crate::model::EndpointConfiguration {
            crate::model::EndpointConfiguration {
                types: self.types,
                vpc_endpoint_ids: self.vpc_endpoint_ids,
            }
        }
    }
}
impl EndpointConfiguration {
    /// Creates a new builder-style object to manufacture [`EndpointConfiguration`](crate::model::EndpointConfiguration)
    pub fn builder() -> crate::model::endpoint_configuration::Builder {
        crate::model::endpoint_configuration::Builder::default()
    }
}

/// <p>The endpoint type. The valid values are <code>EDGE</code> for edge-optimized API setup, most suitable for mobile applications; <code>REGIONAL</code> for regional API endpoint setup, most suitable for calling from AWS Region; and <code>PRIVATE</code> for private APIs.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Edge,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Regional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointType {
    fn from(s: &str) -> Self {
        match s {
            "EDGE" => EndpointType::Edge,
            "PRIVATE" => EndpointType::Private,
            "REGIONAL" => EndpointType::Regional,
            other => EndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointType::from(s))
    }
}
impl EndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointType::Edge => "EDGE",
            EndpointType::Private => "PRIVATE",
            EndpointType::Regional => "REGIONAL",
            EndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EDGE", "PRIVATE", "REGIONAL"]
    }
}
impl AsRef<str> for EndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApiKeySourceType {
    #[allow(missing_docs)] // documentation missing in model
    Authorizer,
    #[allow(missing_docs)] // documentation missing in model
    Header,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApiKeySourceType {
    fn from(s: &str) -> Self {
        match s {
            "AUTHORIZER" => ApiKeySourceType::Authorizer,
            "HEADER" => ApiKeySourceType::Header,
            other => ApiKeySourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApiKeySourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApiKeySourceType::from(s))
    }
}
impl ApiKeySourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiKeySourceType::Authorizer => "AUTHORIZER",
            ApiKeySourceType::Header => "HEADER",
            ApiKeySourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTHORIZER", "HEADER"]
    }
}
impl AsRef<str> for ApiKeySourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Represents a client-facing interface by which the client calls the API to access back-end resources. A <b>Method</b> resource is
/// integrated with an <a>Integration</a> resource. Both consist of a request and one or more responses. The method request takes
/// the client input that is passed to the back end through the integration request. A method response returns the output from
/// the back end to the client through an integration response. A method request is embodied in a <b>Method</b> resource, whereas
/// an integration request is embodied in an <a>Integration</a> resource.  On the other hand, a method response is represented
/// by a <a>MethodResponse</a> resource, whereas an integration response is represented by an <a>IntegrationResponse</a> resource.
/// </p>
/// <div class="remarks">
/// <p></p>
/// <h4>Example: Retrive the GET method on a specified resource</h4>
/// <h5>Request</h5>
/// <p>The following example request retrieves the information about the GET method on an API resource (<code>3kzxbg5sa2</code>) of an API (<code>fugvjdxtri</code>). </p>
/// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
/// Content-Type: application/json
/// Host: apigateway.us-east-1.amazonaws.com
/// X-Amz-Date: 20160603T210259Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
/// <h5>Response</h5>
/// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": [
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
/// "name": "integration",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
/// "name": "integrationresponse",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
/// "name": "method",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
/// "name": "methodresponse",
/// "templated": true
/// }
/// ],
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
/// "name": "GET",
/// "title": "GET"
/// },
/// "integration:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "method:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
/// },
/// "method:integration": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "method:responses": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "method:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
/// },
/// "methodresponse:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
/// "templated": true
/// }
/// },
/// "apiKeyRequired": true,
/// "authorizationType": "NONE",
/// "httpMethod": "GET",
/// "_embedded": {
/// "method:integration": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integration:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integration:responses": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "integration:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integrationresponse:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
/// "templated": true
/// }
/// },
/// "cacheKeyParameters": [],
/// "cacheNamespace": "3kzxbg5sa2",
/// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
/// "httpMethod": "POST",
/// "passthroughBehavior": "WHEN_NO_MATCH",
/// "requestParameters": {
/// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
/// },
/// "requestTemplates": {
/// "application/json": "{\n}"
/// },
/// "type": "AWS",
/// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
/// "_embedded": {
/// "integration:responses": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "integrationresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
/// },
/// "integrationresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
/// }
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": "'application/xml'"
/// },
/// "responseTemplates": {
/// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E\")"
/// },
/// "statusCode": "200"
/// }
/// }
/// },
/// "method:responses": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "methodresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// },
/// "methodresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// }
/// },
/// "responseModels": {
/// "application/json": "Empty"
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": false
/// },
/// "statusCode": "200"
/// }
/// }
/// }</code></pre>
/// <p>In the example above, the response template for the <code>200 OK</code> response maps the JSON output from the <code>ListStreams</code> action in the back end to an XML output. The mapping template is URL-encoded as <code>%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E</code> and the output is decoded using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#util-templat-reference">$util.urlDecode()</a> helper function.</p>
/// </div>
/// <div class="seeAlso">
/// <a>MethodResponse</a>, <a>Integration</a>, <a>IntegrationResponse</a>, <a>Resource</a>,
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-method-settings.html">Set up an API's method</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Method {
    /// <p>The method's HTTP verb.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub authorization_type: std::option::Option<std::string::String>,
    /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
    pub api_key_required: std::option::Option<bool>,
    /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
    pub request_validator_id: std::option::Option<std::string::String>,
    /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Gets a method response associated with a given HTTP status code. </p>
    /// <div class="remarks">
    /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
    /// <h4>Example: Get a 200 OK response of a GET method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T215008Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": false,
    /// "method.response.header.operand_2": false,
    /// "method.response.header.operand_1": false
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
    /// </div>
    pub method_responses: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
    >,
    /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: </h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T213210Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "0cjtch",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestTemplates": {
    /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": "integration.response.body.op",
    /// "method.response.header.operand_2": "integration.response.body.b",
    /// "method.response.header.operand_1": "integration.response.body.a"
    /// },
    /// "responseTemplates": {
    /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
    /// },
    /// "selectionPattern": "",
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
    /// </div>
    pub method_integration: std::option::Option<crate::model::Integration>,
    /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Method {
    /// <p>The method's HTTP verb.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub fn authorization_type(&self) -> std::option::Option<&str> {
        self.authorization_type.as_deref()
    }
    /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
    pub fn api_key_required(&self) -> std::option::Option<bool> {
        self.api_key_required
    }
    /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
    pub fn request_validator_id(&self) -> std::option::Option<&str> {
        self.request_validator_id.as_deref()
    }
    /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.request_parameters.as_ref()
    }
    /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>Gets a method response associated with a given HTTP status code. </p>
    /// <div class="remarks">
    /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
    /// <h4>Example: Get a 200 OK response of a GET method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T215008Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": false,
    /// "method.response.header.operand_2": false,
    /// "method.response.header.operand_1": false
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
    /// </div>
    pub fn method_responses(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
    > {
        self.method_responses.as_ref()
    }
    /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: </h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T213210Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "0cjtch",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestTemplates": {
    /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": "integration.response.body.op",
    /// "method.response.header.operand_2": "integration.response.body.b",
    /// "method.response.header.operand_1": "integration.response.body.a"
    /// },
    /// "responseTemplates": {
    /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
    /// },
    /// "selectionPattern": "",
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
    /// </div>
    pub fn method_integration(&self) -> std::option::Option<&crate::model::Integration> {
        self.method_integration.as_ref()
    }
    /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
}
impl std::fmt::Debug for Method {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Method");
        formatter.field("http_method", &self.http_method);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("request_validator_id", &self.request_validator_id);
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_models", &self.request_models);
        formatter.field("method_responses", &self.method_responses);
        formatter.field("method_integration", &self.method_integration);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.finish()
    }
}
/// See [`Method`](crate::model::Method)
pub mod method {
    /// A builder for [`Method`](crate::model::Method)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) authorization_type: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) request_validator_id: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) method_responses: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
        >,
        pub(crate) method_integration: std::option::Option<crate::model::Integration>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The method's HTTP verb.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>The method's HTTP verb.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn authorization_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_type = Some(input.into());
            self
        }
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_validator_id = Some(input.into());
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_validator_id = input;
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `method_responses`.
        ///
        /// To override the contents of this collection use [`set_method_responses`](Self::set_method_responses).
        ///
        /// <p>Gets a method response associated with a given HTTP status code. </p>
        /// <div class="remarks">
        /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
        /// <h4>Example: Get a 200 OK response of a GET method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T215008Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": false,
        /// "method.response.header.operand_2": false,
        /// "method.response.header.operand_1": false
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
        /// </div>
        pub fn method_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MethodResponse>,
        ) -> Self {
            let mut hash_map = self.method_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.method_responses = Some(hash_map);
            self
        }
        /// <p>Gets a method response associated with a given HTTP status code. </p>
        /// <div class="remarks">
        /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
        /// <h4>Example: Get a 200 OK response of a GET method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T215008Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": false,
        /// "method.response.header.operand_2": false,
        /// "method.response.header.operand_1": false
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
        /// </div>
        pub fn set_method_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
            >,
        ) -> Self {
            self.method_responses = input;
            self
        }
        /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: </h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T213210Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "0cjtch",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestTemplates": {
        /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": "integration.response.body.op",
        /// "method.response.header.operand_2": "integration.response.body.b",
        /// "method.response.header.operand_1": "integration.response.body.a"
        /// },
        /// "responseTemplates": {
        /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
        /// },
        /// "selectionPattern": "",
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
        /// </div>
        pub fn method_integration(mut self, input: crate::model::Integration) -> Self {
            self.method_integration = Some(input);
            self
        }
        /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: </h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T213210Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "0cjtch",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestTemplates": {
        /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": "integration.response.body.op",
        /// "method.response.header.operand_2": "integration.response.body.b",
        /// "method.response.header.operand_1": "integration.response.body.a"
        /// },
        /// "responseTemplates": {
        /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
        /// },
        /// "selectionPattern": "",
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
        /// </div>
        pub fn set_method_integration(
            mut self,
            input: std::option::Option<crate::model::Integration>,
        ) -> Self {
            self.method_integration = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`Method`](crate::model::Method)
        pub fn build(self) -> crate::model::Method {
            crate::model::Method {
                http_method: self.http_method,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                api_key_required: self.api_key_required,
                request_validator_id: self.request_validator_id,
                operation_name: self.operation_name,
                request_parameters: self.request_parameters,
                request_models: self.request_models,
                method_responses: self.method_responses,
                method_integration: self.method_integration,
                authorization_scopes: self.authorization_scopes,
            }
        }
    }
}
impl Method {
    /// Creates a new builder-style object to manufacture [`Method`](crate::model::Method)
    pub fn builder() -> crate::model::method::Builder {
        crate::model::method::Builder::default()
    }
}

/// <p>Represents an HTTP, HTTP_PROXY, AWS, AWS_PROXY, or Mock integration.</p>
/// <div class="remarks">In the API Gateway console, the built-in Lambda integration is an AWS integration.</div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Integration {
    /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
    /// <ul>
    /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
    /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
    /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
    /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
    /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
    /// </ul>
    /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
    pub r#type: std::option::Option<crate::model::IntegrationType>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
    /// <ul>
    /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
    /// </li>
    /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
    /// </li></ul>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <div>
    /// <p>
    /// Specifies how the method request body of an unmapped content type will be passed through the integration request
    /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
    /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
    /// The valid value is one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
    /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
    /// </li>
    /// <li>
    /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
    /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
    /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
    /// </li>
    /// <li>
    /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
    /// request content type does not match any content type associated with the mapping templates defined in the integration request or
    /// no mapping template is defined in the integration request.
    /// </li>
    /// </ul>
    /// </div>
    pub passthrough_behavior: std::option::Option<std::string::String>,
    /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    pub content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    pub timeout_in_millis: i32,
    /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    pub cache_namespace: std::option::Option<std::string::String>,
    /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
    pub cache_key_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the integration's responses.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: Get integration responses of a method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20160607T191449Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
    /// </code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
    /// </div>
    pub integration_responses: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
    >,
    /// <p>Specifies the TLS configuration for an integration.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfig>,
}
impl Integration {
    /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
    /// <ul>
    /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
    /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
    /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
    /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
    /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
    /// </ul>
    /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.r#type.as_ref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
    /// <ul>
    /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
    /// </li>
    /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
    /// </li></ul>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials(&self) -> std::option::Option<&str> {
        self.credentials.as_deref()
    }
    /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <div>
    /// <p>
    /// Specifies how the method request body of an unmapped content type will be passed through the integration request
    /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
    /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
    /// The valid value is one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
    /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
    /// </li>
    /// <li>
    /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
    /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
    /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
    /// </li>
    /// <li>
    /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
    /// request content type does not match any content type associated with the mapping templates defined in the integration request or
    /// no mapping template is defined in the integration request.
    /// </li>
    /// </ul>
    /// </div>
    pub fn passthrough_behavior(&self) -> std::option::Option<&str> {
        self.passthrough_behavior.as_deref()
    }
    /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    pub fn content_handling(&self) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling.as_ref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    pub fn cache_namespace(&self) -> std::option::Option<&str> {
        self.cache_namespace.as_deref()
    }
    /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
    pub fn cache_key_parameters(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_key_parameters.as_deref()
    }
    /// <p>Specifies the integration's responses.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: Get integration responses of a method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20160607T191449Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
    /// </code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
    /// </div>
    pub fn integration_responses(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
    > {
        self.integration_responses.as_ref()
    }
    /// <p>Specifies the TLS configuration for an integration.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfig> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for Integration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Integration");
        formatter.field("r#type", &self.r#type);
        formatter.field("http_method", &self.http_method);
        formatter.field("uri", &self.uri);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("credentials", &self.credentials);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("content_handling", &self.content_handling);
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("cache_namespace", &self.cache_namespace);
        formatter.field("cache_key_parameters", &self.cache_key_parameters);
        formatter.field("integration_responses", &self.integration_responses);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}
/// See [`Integration`](crate::model::Integration)
pub mod integration {
    /// A builder for [`Integration`](crate::model::Integration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) credentials: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) passthrough_behavior: std::option::Option<std::string::String>,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) cache_namespace: std::option::Option<std::string::String>,
        pub(crate) cache_key_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) integration_responses: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
        >,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfig>,
    }
    impl Builder {
        /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
        /// <ul>
        /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
        /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
        /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
        /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
        /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
        /// </ul>
        /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
        pub fn r#type(mut self, input: crate::model::IntegrationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
        /// <ul>
        /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
        /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
        /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
        /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
        /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
        /// </ul>
        /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credentials = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// <div>
        /// <p>
        /// Specifies how the method request body of an unmapped content type will be passed through the integration request
        /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
        /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
        /// The valid value is one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
        /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
        /// </li>
        /// <li>
        /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
        /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
        /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
        /// </li>
        /// <li>
        /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
        /// request content type does not match any content type associated with the mapping templates defined in the integration request or
        /// no mapping template is defined in the integration request.
        /// </li>
        /// </ul>
        /// </div>
        pub fn passthrough_behavior(mut self, input: impl Into<std::string::String>) -> Self {
            self.passthrough_behavior = Some(input.into());
            self
        }
        /// <div>
        /// <p>
        /// Specifies how the method request body of an unmapped content type will be passed through the integration request
        /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
        /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
        /// The valid value is one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
        /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
        /// </li>
        /// <li>
        /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
        /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
        /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
        /// </li>
        /// <li>
        /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
        /// request content type does not match any content type associated with the mapping templates defined in the integration request or
        /// no mapping template is defined in the integration request.
        /// </li>
        /// </ul>
        /// </div>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn cache_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_namespace = Some(input.into());
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn set_cache_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_namespace = input;
            self
        }
        /// Appends an item to `cache_key_parameters`.
        ///
        /// To override the contents of this collection use [`set_cache_key_parameters`](Self::set_cache_key_parameters).
        ///
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn cache_key_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_key_parameters.unwrap_or_default();
            v.push(input.into());
            self.cache_key_parameters = Some(v);
            self
        }
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn set_cache_key_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_key_parameters = input;
            self
        }
        /// Adds a key-value pair to `integration_responses`.
        ///
        /// To override the contents of this collection use [`set_integration_responses`](Self::set_integration_responses).
        ///
        /// <p>Specifies the integration's responses.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: Get integration responses of a method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20160607T191449Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
        /// </code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
        /// </div>
        pub fn integration_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::IntegrationResponse>,
        ) -> Self {
            let mut hash_map = self.integration_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.integration_responses = Some(hash_map);
            self
        }
        /// <p>Specifies the integration's responses.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: Get integration responses of a method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20160607T191449Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
        /// </code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
        /// </div>
        pub fn set_integration_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
            >,
        ) -> Self {
            self.integration_responses = input;
            self
        }
        /// <p>Specifies the TLS configuration for an integration.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>Specifies the TLS configuration for an integration.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Integration`](crate::model::Integration)
        pub fn build(self) -> crate::model::Integration {
            crate::model::Integration {
                r#type: self.r#type,
                http_method: self.http_method,
                uri: self.uri,
                connection_type: self.connection_type,
                connection_id: self.connection_id,
                credentials: self.credentials,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                passthrough_behavior: self.passthrough_behavior,
                content_handling: self.content_handling,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                cache_namespace: self.cache_namespace,
                cache_key_parameters: self.cache_key_parameters,
                integration_responses: self.integration_responses,
                tls_config: self.tls_config,
            }
        }
    }
}
impl Integration {
    /// Creates a new builder-style object to manufacture [`Integration`](crate::model::Integration)
    pub fn builder() -> crate::model::integration::Builder {
        crate::model::integration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TlsConfig {
    /// <p>Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is
    /// issued by a <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html">supported certificate authority</a>. This isn’t recommended, but it enables you to
    /// use certificates that are signed by private certificate authorities, or certificates
    /// that are self-signed. If enabled, API Gateway still performs basic certificate
    /// validation, which includes checking the certificate's expiration date, hostname, and
    /// presence of a root certificate authority. Supported only for <code>HTTP</code> and
    /// <code>HTTP_PROXY</code> integrations.</p>
    pub insecure_skip_verification: bool,
}
impl TlsConfig {
    /// <p>Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is
    /// issued by a <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html">supported certificate authority</a>. This isn’t recommended, but it enables you to
    /// use certificates that are signed by private certificate authorities, or certificates
    /// that are self-signed. If enabled, API Gateway still performs basic certificate
    /// validation, which includes checking the certificate's expiration date, hostname, and
    /// presence of a root certificate authority. Supported only for <code>HTTP</code> and
    /// <code>HTTP_PROXY</code> integrations.</p>
    pub fn insecure_skip_verification(&self) -> bool {
        self.insecure_skip_verification
    }
}
impl std::fmt::Debug for TlsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TlsConfig");
        formatter.field(
            "insecure_skip_verification",
            &self.insecure_skip_verification,
        );
        formatter.finish()
    }
}
/// See [`TlsConfig`](crate::model::TlsConfig)
pub mod tls_config {
    /// A builder for [`TlsConfig`](crate::model::TlsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insecure_skip_verification: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is
        /// issued by a <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html">supported certificate authority</a>. This isn’t recommended, but it enables you to
        /// use certificates that are signed by private certificate authorities, or certificates
        /// that are self-signed. If enabled, API Gateway still performs basic certificate
        /// validation, which includes checking the certificate's expiration date, hostname, and
        /// presence of a root certificate authority. Supported only for <code>HTTP</code> and
        /// <code>HTTP_PROXY</code> integrations.</p>
        pub fn insecure_skip_verification(mut self, input: bool) -> Self {
            self.insecure_skip_verification = Some(input);
            self
        }
        /// <p>Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is
        /// issued by a <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html">supported certificate authority</a>. This isn’t recommended, but it enables you to
        /// use certificates that are signed by private certificate authorities, or certificates
        /// that are self-signed. If enabled, API Gateway still performs basic certificate
        /// validation, which includes checking the certificate's expiration date, hostname, and
        /// presence of a root certificate authority. Supported only for <code>HTTP</code> and
        /// <code>HTTP_PROXY</code> integrations.</p>
        pub fn set_insecure_skip_verification(mut self, input: std::option::Option<bool>) -> Self {
            self.insecure_skip_verification = input;
            self
        }
        /// Consumes the builder and constructs a [`TlsConfig`](crate::model::TlsConfig)
        pub fn build(self) -> crate::model::TlsConfig {
            crate::model::TlsConfig {
                insecure_skip_verification: self.insecure_skip_verification.unwrap_or_default(),
            }
        }
    }
}
impl TlsConfig {
    /// Creates a new builder-style object to manufacture [`TlsConfig`](crate::model::TlsConfig)
    pub fn builder() -> crate::model::tls_config::Builder {
        crate::model::tls_config::Builder::default()
    }
}

/// <p>Represents an integration response. The status code must map to an existing <a>MethodResponse</a>, and parameters and templates can be used to transform the back-end response.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntegrationResponse {
    /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    pub selection_pattern: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
    /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    pub content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
}
impl IntegrationResponse {
    /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    pub fn selection_pattern(&self) -> std::option::Option<&str> {
        self.selection_pattern.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
    /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    pub fn content_handling(&self) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling.as_ref()
    }
}
impl std::fmt::Debug for IntegrationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntegrationResponse");
        formatter.field("status_code", &self.status_code);
        formatter.field("selection_pattern", &self.selection_pattern);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field("content_handling", &self.content_handling);
        formatter.finish()
    }
}
/// See [`IntegrationResponse`](crate::model::IntegrationResponse)
pub mod integration_response {
    /// A builder for [`IntegrationResponse`](crate::model::IntegrationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) selection_pattern: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
    }
    impl Builder {
        /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
        pub fn selection_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_pattern = Some(input.into());
            self
        }
        /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
        pub fn set_selection_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_pattern = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// Consumes the builder and constructs a [`IntegrationResponse`](crate::model::IntegrationResponse)
        pub fn build(self) -> crate::model::IntegrationResponse {
            crate::model::IntegrationResponse {
                status_code: self.status_code,
                selection_pattern: self.selection_pattern,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                content_handling: self.content_handling,
            }
        }
    }
}
impl IntegrationResponse {
    /// Creates a new builder-style object to manufacture [`IntegrationResponse`](crate::model::IntegrationResponse)
    pub fn builder() -> crate::model::integration_response::Builder {
        crate::model::integration_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentHandlingStrategy {
    #[allow(missing_docs)] // documentation missing in model
    ConvertToBinary,
    #[allow(missing_docs)] // documentation missing in model
    ConvertToText,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentHandlingStrategy {
    fn from(s: &str) -> Self {
        match s {
            "CONVERT_TO_BINARY" => ContentHandlingStrategy::ConvertToBinary,
            "CONVERT_TO_TEXT" => ContentHandlingStrategy::ConvertToText,
            other => ContentHandlingStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentHandlingStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentHandlingStrategy::from(s))
    }
}
impl ContentHandlingStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentHandlingStrategy::ConvertToBinary => "CONVERT_TO_BINARY",
            ContentHandlingStrategy::ConvertToText => "CONVERT_TO_TEXT",
            ContentHandlingStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONVERT_TO_BINARY", "CONVERT_TO_TEXT"]
    }
}
impl AsRef<str> for ContentHandlingStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionType {
    #[allow(missing_docs)] // documentation missing in model
    Internet,
    #[allow(missing_docs)] // documentation missing in model
    VpcLink,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionType {
    fn from(s: &str) -> Self {
        match s {
            "INTERNET" => ConnectionType::Internet,
            "VPC_LINK" => ConnectionType::VpcLink,
            other => ConnectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionType::from(s))
    }
}
impl ConnectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionType::Internet => "INTERNET",
            ConnectionType::VpcLink => "VPC_LINK",
            ConnectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNET", "VPC_LINK"]
    }
}
impl AsRef<str> for ConnectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The integration type. The valid value is <code>HTTP</code> for integrating an API method with an HTTP backend; <code>AWS</code> with any AWS service endpoints; <code>MOCK</code> for testing without actually invoking the backend; <code>HTTP_PROXY</code> for integrating with the HTTP proxy integration; <code>AWS_PROXY</code> for integrating with the Lambda proxy integration. </p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntegrationType {
    #[allow(missing_docs)] // documentation missing in model
    Aws,
    #[allow(missing_docs)] // documentation missing in model
    AwsProxy,
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    HttpProxy,
    #[allow(missing_docs)] // documentation missing in model
    Mock,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntegrationType {
    fn from(s: &str) -> Self {
        match s {
            "AWS" => IntegrationType::Aws,
            "AWS_PROXY" => IntegrationType::AwsProxy,
            "HTTP" => IntegrationType::Http,
            "HTTP_PROXY" => IntegrationType::HttpProxy,
            "MOCK" => IntegrationType::Mock,
            other => IntegrationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntegrationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntegrationType::from(s))
    }
}
impl IntegrationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntegrationType::Aws => "AWS",
            IntegrationType::AwsProxy => "AWS_PROXY",
            IntegrationType::Http => "HTTP",
            IntegrationType::HttpProxy => "HTTP_PROXY",
            IntegrationType::Mock => "MOCK",
            IntegrationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS", "AWS_PROXY", "HTTP", "HTTP_PROXY", "MOCK"]
    }
}
impl AsRef<str> for IntegrationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a method response of a given HTTP status code returned to the client. The method response is passed from the back end through the associated integration response that can be transformed using a mapping template. <!-- API Gateway sends back the status code to the caller as the HTTP status code. Parameters and models can be used to transform the response from the method's integration.--></p>
/// <div class="remarks">
/// <p></p>
/// <h4>Example: A <b>MethodResponse</b> instance of an API</h4>
/// <h5>Request</h5>
/// <p>The example request retrieves a <b>MethodResponse</b> of the 200 status code.</p>
/// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200 HTTP/1.1
/// Content-Type: application/json
/// Host: apigateway.us-east-1.amazonaws.com
/// X-Amz-Date: 20160603T222952Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
/// <h5>Response</h5>
/// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
/// "name": "methodresponse",
/// "templated": true
/// },
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "title": "200"
/// },
/// "methodresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// },
/// "methodresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// }
/// },
/// "responseModels": {
/// "application/json": "Empty"
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": false
/// },
/// "statusCode": "200"
/// }</code></pre>
/// <p></p>
/// </div>
/// <div class="seeAlso">
/// <a>Method</a>, <a>IntegrationResponse</a>, <a>Integration</a>
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MethodResponse {
    /// <p>The method response's status code.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl MethodResponse {
    /// <p>The method response's status code.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.response_parameters.as_ref()
    }
    /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
}
impl std::fmt::Debug for MethodResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MethodResponse");
        formatter.field("status_code", &self.status_code);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_models", &self.response_models);
        formatter.finish()
    }
}
/// See [`MethodResponse`](crate::model::MethodResponse)
pub mod method_response {
    /// A builder for [`MethodResponse`](crate::model::MethodResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The method response's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The method response's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Consumes the builder and constructs a [`MethodResponse`](crate::model::MethodResponse)
        pub fn build(self) -> crate::model::MethodResponse {
            crate::model::MethodResponse {
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_models: self.response_models,
            }
        }
    }
}
impl MethodResponse {
    /// Creates a new builder-style object to manufacture [`MethodResponse`](crate::model::MethodResponse)
    pub fn builder() -> crate::model::method_response::Builder {
        crate::model::method_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GatewayResponseType {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    ApiConfigurationError,
    #[allow(missing_docs)] // documentation missing in model
    AuthorizerConfigurationError,
    #[allow(missing_docs)] // documentation missing in model
    AuthorizerFailure,
    #[allow(missing_docs)] // documentation missing in model
    BadRequestBody,
    #[allow(missing_docs)] // documentation missing in model
    BadRequestParameters,
    #[allow(missing_docs)] // documentation missing in model
    Default4Xx,
    #[allow(missing_docs)] // documentation missing in model
    Default5Xx,
    #[allow(missing_docs)] // documentation missing in model
    ExpiredToken,
    #[allow(missing_docs)] // documentation missing in model
    IntegrationFailure,
    #[allow(missing_docs)] // documentation missing in model
    IntegrationTimeout,
    #[allow(missing_docs)] // documentation missing in model
    InvalidApiKey,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSignature,
    #[allow(missing_docs)] // documentation missing in model
    MissingAuthenticationToken,
    #[allow(missing_docs)] // documentation missing in model
    QuotaExceeded,
    #[allow(missing_docs)] // documentation missing in model
    RequestTooLarge,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    Throttled,
    #[allow(missing_docs)] // documentation missing in model
    Unauthorized,
    #[allow(missing_docs)] // documentation missing in model
    UnsupportedMediaType,
    #[allow(missing_docs)] // documentation missing in model
    WafFiltered,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GatewayResponseType {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => GatewayResponseType::AccessDenied,
            "API_CONFIGURATION_ERROR" => GatewayResponseType::ApiConfigurationError,
            "AUTHORIZER_CONFIGURATION_ERROR" => GatewayResponseType::AuthorizerConfigurationError,
            "AUTHORIZER_FAILURE" => GatewayResponseType::AuthorizerFailure,
            "BAD_REQUEST_BODY" => GatewayResponseType::BadRequestBody,
            "BAD_REQUEST_PARAMETERS" => GatewayResponseType::BadRequestParameters,
            "DEFAULT_4XX" => GatewayResponseType::Default4Xx,
            "DEFAULT_5XX" => GatewayResponseType::Default5Xx,
            "EXPIRED_TOKEN" => GatewayResponseType::ExpiredToken,
            "INTEGRATION_FAILURE" => GatewayResponseType::IntegrationFailure,
            "INTEGRATION_TIMEOUT" => GatewayResponseType::IntegrationTimeout,
            "INVALID_API_KEY" => GatewayResponseType::InvalidApiKey,
            "INVALID_SIGNATURE" => GatewayResponseType::InvalidSignature,
            "MISSING_AUTHENTICATION_TOKEN" => GatewayResponseType::MissingAuthenticationToken,
            "QUOTA_EXCEEDED" => GatewayResponseType::QuotaExceeded,
            "REQUEST_TOO_LARGE" => GatewayResponseType::RequestTooLarge,
            "RESOURCE_NOT_FOUND" => GatewayResponseType::ResourceNotFound,
            "THROTTLED" => GatewayResponseType::Throttled,
            "UNAUTHORIZED" => GatewayResponseType::Unauthorized,
            "UNSUPPORTED_MEDIA_TYPE" => GatewayResponseType::UnsupportedMediaType,
            "WAF_FILTERED" => GatewayResponseType::WafFiltered,
            other => GatewayResponseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GatewayResponseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GatewayResponseType::from(s))
    }
}
impl GatewayResponseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GatewayResponseType::AccessDenied => "ACCESS_DENIED",
            GatewayResponseType::ApiConfigurationError => "API_CONFIGURATION_ERROR",
            GatewayResponseType::AuthorizerConfigurationError => "AUTHORIZER_CONFIGURATION_ERROR",
            GatewayResponseType::AuthorizerFailure => "AUTHORIZER_FAILURE",
            GatewayResponseType::BadRequestBody => "BAD_REQUEST_BODY",
            GatewayResponseType::BadRequestParameters => "BAD_REQUEST_PARAMETERS",
            GatewayResponseType::Default4Xx => "DEFAULT_4XX",
            GatewayResponseType::Default5Xx => "DEFAULT_5XX",
            GatewayResponseType::ExpiredToken => "EXPIRED_TOKEN",
            GatewayResponseType::IntegrationFailure => "INTEGRATION_FAILURE",
            GatewayResponseType::IntegrationTimeout => "INTEGRATION_TIMEOUT",
            GatewayResponseType::InvalidApiKey => "INVALID_API_KEY",
            GatewayResponseType::InvalidSignature => "INVALID_SIGNATURE",
            GatewayResponseType::MissingAuthenticationToken => "MISSING_AUTHENTICATION_TOKEN",
            GatewayResponseType::QuotaExceeded => "QUOTA_EXCEEDED",
            GatewayResponseType::RequestTooLarge => "REQUEST_TOO_LARGE",
            GatewayResponseType::ResourceNotFound => "RESOURCE_NOT_FOUND",
            GatewayResponseType::Throttled => "THROTTLED",
            GatewayResponseType::Unauthorized => "UNAUTHORIZED",
            GatewayResponseType::UnsupportedMediaType => "UNSUPPORTED_MEDIA_TYPE",
            GatewayResponseType::WafFiltered => "WAF_FILTERED",
            GatewayResponseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "API_CONFIGURATION_ERROR",
            "AUTHORIZER_CONFIGURATION_ERROR",
            "AUTHORIZER_FAILURE",
            "BAD_REQUEST_BODY",
            "BAD_REQUEST_PARAMETERS",
            "DEFAULT_4XX",
            "DEFAULT_5XX",
            "EXPIRED_TOKEN",
            "INTEGRATION_FAILURE",
            "INTEGRATION_TIMEOUT",
            "INVALID_API_KEY",
            "INVALID_SIGNATURE",
            "MISSING_AUTHENTICATION_TOKEN",
            "QUOTA_EXCEEDED",
            "REQUEST_TOO_LARGE",
            "RESOURCE_NOT_FOUND",
            "THROTTLED",
            "UNAUTHORIZED",
            "UNSUPPORTED_MEDIA_TYPE",
            "WAF_FILTERED",
        ]
    }
}
impl AsRef<str> for GatewayResponseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MutualTlsAuthentication {
    /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
    /// for example <code>s3://bucket-name/key-name</code>.
    /// The truststore can contain certificates from public or private certificate authorities.
    /// To update the truststore, upload a new version to S3, and then update your custom domain
    /// name to use the new version. To update the truststore, you must have permissions to
    /// access the S3 object.</p>
    pub truststore_uri: std::option::Option<std::string::String>,
    /// <p>The version of the S3 object that contains your truststore. To
    /// specify a version, you must have versioning enabled for the S3 bucket.</p>
    pub truststore_version: std::option::Option<std::string::String>,
    /// <p>A list of warnings that API Gateway returns while processing your truststore. Invalid
    /// certificates produce warnings. Mutual TLS is still enabled, but some clients might not
    /// be able to access your API. To resolve warnings, upload a new truststore to S3, and then
    /// update you domain name to use the new version.</p>
    pub truststore_warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl MutualTlsAuthentication {
    /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
    /// for example <code>s3://bucket-name/key-name</code>.
    /// The truststore can contain certificates from public or private certificate authorities.
    /// To update the truststore, upload a new version to S3, and then update your custom domain
    /// name to use the new version. To update the truststore, you must have permissions to
    /// access the S3 object.</p>
    pub fn truststore_uri(&self) -> std::option::Option<&str> {
        self.truststore_uri.as_deref()
    }
    /// <p>The version of the S3 object that contains your truststore. To
    /// specify a version, you must have versioning enabled for the S3 bucket.</p>
    pub fn truststore_version(&self) -> std::option::Option<&str> {
        self.truststore_version.as_deref()
    }
    /// <p>A list of warnings that API Gateway returns while processing your truststore. Invalid
    /// certificates produce warnings. Mutual TLS is still enabled, but some clients might not
    /// be able to access your API. To resolve warnings, upload a new truststore to S3, and then
    /// update you domain name to use the new version.</p>
    pub fn truststore_warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.truststore_warnings.as_deref()
    }
}
impl std::fmt::Debug for MutualTlsAuthentication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MutualTlsAuthentication");
        formatter.field("truststore_uri", &self.truststore_uri);
        formatter.field("truststore_version", &self.truststore_version);
        formatter.field("truststore_warnings", &self.truststore_warnings);
        formatter.finish()
    }
}
/// See [`MutualTlsAuthentication`](crate::model::MutualTlsAuthentication)
pub mod mutual_tls_authentication {
    /// A builder for [`MutualTlsAuthentication`](crate::model::MutualTlsAuthentication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) truststore_uri: std::option::Option<std::string::String>,
        pub(crate) truststore_version: std::option::Option<std::string::String>,
        pub(crate) truststore_warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
        /// for example <code>s3://bucket-name/key-name</code>.
        /// The truststore can contain certificates from public or private certificate authorities.
        /// To update the truststore, upload a new version to S3, and then update your custom domain
        /// name to use the new version. To update the truststore, you must have permissions to
        /// access the S3 object.</p>
        pub fn truststore_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.truststore_uri = Some(input.into());
            self
        }
        /// <p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
        /// for example <code>s3://bucket-name/key-name</code>.
        /// The truststore can contain certificates from public or private certificate authorities.
        /// To update the truststore, upload a new version to S3, and then update your custom domain
        /// name to use the new version. To update the truststore, you must have permissions to
        /// access the S3 object.</p>
        pub fn set_truststore_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.truststore_uri = input;
            self
        }
        /// <p>The version of the S3 object that contains your truststore. To
        /// specify a version, you must have versioning enabled for the S3 bucket.</p>
        pub fn truststore_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.truststore_version = Some(input.into());
            self
        }
        /// <p>The version of the S3 object that contains your truststore. To
        /// specify a version, you must have versioning enabled for the S3 bucket.</p>
        pub fn set_truststore_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.truststore_version = input;
            self
        }
        /// Appends an item to `truststore_warnings`.
        ///
        /// To override the contents of this collection use [`set_truststore_warnings`](Self::set_truststore_warnings).
        ///
        /// <p>A list of warnings that API Gateway returns while processing your truststore. Invalid
        /// certificates produce warnings. Mutual TLS is still enabled, but some clients might not
        /// be able to access your API. To resolve warnings, upload a new truststore to S3, and then
        /// update you domain name to use the new version.</p>
        pub fn truststore_warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.truststore_warnings.unwrap_or_default();
            v.push(input.into());
            self.truststore_warnings = Some(v);
            self
        }
        /// <p>A list of warnings that API Gateway returns while processing your truststore. Invalid
        /// certificates produce warnings. Mutual TLS is still enabled, but some clients might not
        /// be able to access your API. To resolve warnings, upload a new truststore to S3, and then
        /// update you domain name to use the new version.</p>
        pub fn set_truststore_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.truststore_warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`MutualTlsAuthentication`](crate::model::MutualTlsAuthentication)
        pub fn build(self) -> crate::model::MutualTlsAuthentication {
            crate::model::MutualTlsAuthentication {
                truststore_uri: self.truststore_uri,
                truststore_version: self.truststore_version,
                truststore_warnings: self.truststore_warnings,
            }
        }
    }
}
impl MutualTlsAuthentication {
    /// Creates a new builder-style object to manufacture [`MutualTlsAuthentication`](crate::model::MutualTlsAuthentication)
    pub fn builder() -> crate::model::mutual_tls_authentication::Builder {
        crate::model::mutual_tls_authentication::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SecurityPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Tls10,
    #[allow(missing_docs)] // documentation missing in model
    Tls12,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SecurityPolicy {
    fn from(s: &str) -> Self {
        match s {
            "TLS_1_0" => SecurityPolicy::Tls10,
            "TLS_1_2" => SecurityPolicy::Tls12,
            other => SecurityPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SecurityPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SecurityPolicy::from(s))
    }
}
impl SecurityPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SecurityPolicy::Tls10 => "TLS_1_0",
            SecurityPolicy::Tls12 => "TLS_1_2",
            SecurityPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TLS_1_0", "TLS_1_2"]
    }
}
impl AsRef<str> for SecurityPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainNameStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    PendingCertificateReimport,
    #[allow(missing_docs)] // documentation missing in model
    PendingOwnershipVerification,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainNameStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DomainNameStatus::Available,
            "PENDING" => DomainNameStatus::Pending,
            "PENDING_CERTIFICATE_REIMPORT" => DomainNameStatus::PendingCertificateReimport,
            "PENDING_OWNERSHIP_VERIFICATION" => DomainNameStatus::PendingOwnershipVerification,
            "UPDATING" => DomainNameStatus::Updating,
            other => DomainNameStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainNameStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainNameStatus::from(s))
    }
}
impl DomainNameStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainNameStatus::Available => "AVAILABLE",
            DomainNameStatus::Pending => "PENDING",
            DomainNameStatus::PendingCertificateReimport => "PENDING_CERTIFICATE_REIMPORT",
            DomainNameStatus::PendingOwnershipVerification => "PENDING_OWNERSHIP_VERIFICATION",
            DomainNameStatus::Updating => "UPDATING",
            DomainNameStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "PENDING",
            "PENDING_CERTIFICATE_REIMPORT",
            "PENDING_OWNERSHIP_VERIFICATION",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for DomainNameStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the target API entity to which the documentation applies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentationPartLocation {
    /// <p>[Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,  <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>,  <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.</p>
    pub r#type: std::option::Option<crate::model::DocumentationPartType>,
    /// <p>The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes,  the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The HTTP verb of a method. It is a valid field for the API entity types of  <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,  <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method.  When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes,  the child entity's <code>method</code> attribute must match that of the parent entity exactly.</p>
    pub method: std::option::Option<std::string::String>,
    /// <p>The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child  entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DocumentationPartLocation {
    /// <p>[Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,  <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>,  <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DocumentationPartType> {
        self.r#type.as_ref()
    }
    /// <p>The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes,  the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The HTTP verb of a method. It is a valid field for the API entity types of  <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,  <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method.  When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes,  the child entity's <code>method</code> attribute must match that of the parent entity exactly.</p>
    pub fn method(&self) -> std::option::Option<&str> {
        self.method.as_deref()
    }
    /// <p>The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child  entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DocumentationPartLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentationPartLocation");
        formatter.field("r#type", &self.r#type);
        formatter.field("path", &self.path);
        formatter.field("method", &self.method);
        formatter.field("status_code", &self.status_code);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DocumentationPartLocation`](crate::model::DocumentationPartLocation)
pub mod documentation_part_location {
    /// A builder for [`DocumentationPartLocation`](crate::model::DocumentationPartLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DocumentationPartType>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) method: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,  <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>,  <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.</p>
        pub fn r#type(mut self, input: crate::model::DocumentationPartType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>[Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,  <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>,  <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DocumentationPartType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes,  the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes,  the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The HTTP verb of a method. It is a valid field for the API entity types of  <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,  <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method.  When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes,  the child entity's <code>method</code> attribute must match that of the parent entity exactly.</p>
        pub fn method(mut self, input: impl Into<std::string::String>) -> Self {
            self.method = Some(input.into());
            self
        }
        /// <p>The HTTP verb of a method. It is a valid field for the API entity types of  <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,  <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method.  When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes,  the child entity's <code>method</code> attribute must match that of the parent entity exactly.</p>
        pub fn set_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.method = input;
            self
        }
        /// <p>The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child  entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child  entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentationPartLocation`](crate::model::DocumentationPartLocation)
        pub fn build(self) -> crate::model::DocumentationPartLocation {
            crate::model::DocumentationPartLocation {
                r#type: self.r#type,
                path: self.path,
                method: self.method,
                status_code: self.status_code,
                name: self.name,
            }
        }
    }
}
impl DocumentationPartLocation {
    /// Creates a new builder-style object to manufacture [`DocumentationPartLocation`](crate::model::DocumentationPartLocation)
    pub fn builder() -> crate::model::documentation_part_location::Builder {
        crate::model::documentation_part_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentationPartType {
    #[allow(missing_docs)] // documentation missing in model
    Api,
    #[allow(missing_docs)] // documentation missing in model
    Authorizer,
    #[allow(missing_docs)] // documentation missing in model
    Method,
    #[allow(missing_docs)] // documentation missing in model
    Model,
    #[allow(missing_docs)] // documentation missing in model
    PathParameter,
    #[allow(missing_docs)] // documentation missing in model
    QueryParameter,
    #[allow(missing_docs)] // documentation missing in model
    RequestBody,
    #[allow(missing_docs)] // documentation missing in model
    RequestHeader,
    #[allow(missing_docs)] // documentation missing in model
    Resource,
    #[allow(missing_docs)] // documentation missing in model
    Response,
    #[allow(missing_docs)] // documentation missing in model
    ResponseBody,
    #[allow(missing_docs)] // documentation missing in model
    ResponseHeader,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentationPartType {
    fn from(s: &str) -> Self {
        match s {
            "API" => DocumentationPartType::Api,
            "AUTHORIZER" => DocumentationPartType::Authorizer,
            "METHOD" => DocumentationPartType::Method,
            "MODEL" => DocumentationPartType::Model,
            "PATH_PARAMETER" => DocumentationPartType::PathParameter,
            "QUERY_PARAMETER" => DocumentationPartType::QueryParameter,
            "REQUEST_BODY" => DocumentationPartType::RequestBody,
            "REQUEST_HEADER" => DocumentationPartType::RequestHeader,
            "RESOURCE" => DocumentationPartType::Resource,
            "RESPONSE" => DocumentationPartType::Response,
            "RESPONSE_BODY" => DocumentationPartType::ResponseBody,
            "RESPONSE_HEADER" => DocumentationPartType::ResponseHeader,
            other => DocumentationPartType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentationPartType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentationPartType::from(s))
    }
}
impl DocumentationPartType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentationPartType::Api => "API",
            DocumentationPartType::Authorizer => "AUTHORIZER",
            DocumentationPartType::Method => "METHOD",
            DocumentationPartType::Model => "MODEL",
            DocumentationPartType::PathParameter => "PATH_PARAMETER",
            DocumentationPartType::QueryParameter => "QUERY_PARAMETER",
            DocumentationPartType::RequestBody => "REQUEST_BODY",
            DocumentationPartType::RequestHeader => "REQUEST_HEADER",
            DocumentationPartType::Resource => "RESOURCE",
            DocumentationPartType::Response => "RESPONSE",
            DocumentationPartType::ResponseBody => "RESPONSE_BODY",
            DocumentationPartType::ResponseHeader => "RESPONSE_HEADER",
            DocumentationPartType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "API",
            "AUTHORIZER",
            "METHOD",
            "MODEL",
            "PATH_PARAMETER",
            "QUERY_PARAMETER",
            "REQUEST_BODY",
            "REQUEST_HEADER",
            "RESOURCE",
            "RESPONSE",
            "RESPONSE_BODY",
            "RESPONSE_HEADER",
        ]
    }
}
impl AsRef<str> for DocumentationPartType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a summary of a <a>Method</a> resource, given a particular date and time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MethodSnapshot {
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub authorization_type: std::option::Option<std::string::String>,
    /// <p>Specifies whether the method requires a valid <a>ApiKey</a>.</p>
    pub api_key_required: bool,
}
impl MethodSnapshot {
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub fn authorization_type(&self) -> std::option::Option<&str> {
        self.authorization_type.as_deref()
    }
    /// <p>Specifies whether the method requires a valid <a>ApiKey</a>.</p>
    pub fn api_key_required(&self) -> bool {
        self.api_key_required
    }
}
impl std::fmt::Debug for MethodSnapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MethodSnapshot");
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.finish()
    }
}
/// See [`MethodSnapshot`](crate::model::MethodSnapshot)
pub mod method_snapshot {
    /// A builder for [`MethodSnapshot`](crate::model::MethodSnapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization_type: std::option::Option<std::string::String>,
        pub(crate) api_key_required: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn authorization_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_type = Some(input.into());
            self
        }
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>Specifies whether the method requires a valid <a>ApiKey</a>.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>Specifies whether the method requires a valid <a>ApiKey</a>.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// Consumes the builder and constructs a [`MethodSnapshot`](crate::model::MethodSnapshot)
        pub fn build(self) -> crate::model::MethodSnapshot {
            crate::model::MethodSnapshot {
                authorization_type: self.authorization_type,
                api_key_required: self.api_key_required.unwrap_or_default(),
            }
        }
    }
}
impl MethodSnapshot {
    /// Creates a new builder-style object to manufacture [`MethodSnapshot`](crate::model::MethodSnapshot)
    pub fn builder() -> crate::model::method_snapshot::Builder {
        crate::model::method_snapshot::Builder::default()
    }
}

/// <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthorizerType {
    #[allow(missing_docs)] // documentation missing in model
    CognitoUserPools,
    #[allow(missing_docs)] // documentation missing in model
    Request,
    #[allow(missing_docs)] // documentation missing in model
    Token,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthorizerType {
    fn from(s: &str) -> Self {
        match s {
            "COGNITO_USER_POOLS" => AuthorizerType::CognitoUserPools,
            "REQUEST" => AuthorizerType::Request,
            "TOKEN" => AuthorizerType::Token,
            other => AuthorizerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthorizerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthorizerType::from(s))
    }
}
impl AuthorizerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthorizerType::CognitoUserPools => "COGNITO_USER_POOLS",
            AuthorizerType::Request => "REQUEST",
            AuthorizerType::Token => "TOKEN",
            AuthorizerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COGNITO_USER_POOLS", "REQUEST", "TOKEN"]
    }
}
impl AsRef<str> for AuthorizerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PutMode {
    #[allow(missing_docs)] // documentation missing in model
    Merge,
    #[allow(missing_docs)] // documentation missing in model
    Overwrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PutMode {
    fn from(s: &str) -> Self {
        match s {
            "merge" => PutMode::Merge,
            "overwrite" => PutMode::Overwrite,
            other => PutMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PutMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PutMode::from(s))
    }
}
impl PutMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PutMode::Merge => "merge",
            PutMode::Overwrite => "overwrite",
            PutMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["merge", "overwrite"]
    }
}
impl AsRef<str> for PutMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApiKeysFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApiKeysFormat {
    fn from(s: &str) -> Self {
        match s {
            "csv" => ApiKeysFormat::Csv,
            other => ApiKeysFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApiKeysFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApiKeysFormat::from(s))
    }
}
impl ApiKeysFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiKeysFormat::Csv => "csv",
            ApiKeysFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["csv"]
    }
}
impl AsRef<str> for ApiKeysFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An API Gateway VPC link for a <a>RestApi</a> to access resources in an Amazon Virtual Private Cloud (VPC).</p>
/// <div class="remarks">
/// <p><p>To enable access to a resource in an Amazon Virtual Private Cloud through Amazon API Gateway, you, as an API developer, create a <a>VpcLink</a> resource targeted for one or more network load balancers of the VPC and then integrate an API method with a private integration that uses the <a>VpcLink</a>. The private integration has an integration type of <code>HTTP</code> or <code>HTTP_PROXY</code> and has a connection type of <code>VPC_LINK</code>. The integration uses the <code>connectionId</code> property to identify the <a>VpcLink</a> used.</p></p>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcLink {
    /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name used to label and identify the VPC link.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the VPC link.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    pub target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
    pub status: std::option::Option<crate::model::VpcLinkStatus>,
    /// <p>A description about the VPC link status.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl VpcLink {
    /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name used to label and identify the VPC link.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the VPC link.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    pub fn target_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.target_arns.as_deref()
    }
    /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VpcLinkStatus> {
        self.status.as_ref()
    }
    /// <p>A description about the VPC link status.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for VpcLink {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcLink");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("target_arns", &self.target_arns);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`VpcLink`](crate::model::VpcLink)
pub mod vpc_link {
    /// A builder for [`VpcLink`](crate::model::VpcLink)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::VpcLinkStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name used to label and identify the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name used to label and identify the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `target_arns`.
        ///
        /// To override the contents of this collection use [`set_target_arns`](Self::set_target_arns).
        ///
        /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_arns.unwrap_or_default();
            v.push(input.into());
            self.target_arns = Some(v);
            self
        }
        /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn set_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_arns = input;
            self
        }
        /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
        pub fn status(mut self, input: crate::model::VpcLinkStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VpcLinkStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A description about the VPC link status.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A description about the VPC link status.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcLink`](crate::model::VpcLink)
        pub fn build(self) -> crate::model::VpcLink {
            crate::model::VpcLink {
                id: self.id,
                name: self.name,
                description: self.description,
                target_arns: self.target_arns,
                status: self.status,
                status_message: self.status_message,
                tags: self.tags,
            }
        }
    }
}
impl VpcLink {
    /// Creates a new builder-style object to manufacture [`VpcLink`](crate::model::VpcLink)
    pub fn builder() -> crate::model::vpc_link::Builder {
        crate::model::vpc_link::Builder::default()
    }
}

/// <p>Represents a usage plan than can specify who can assess associated API stages with specified request limits and quotas.</p>
/// <div class="remarks">
/// <p>In a usage plan, you associate an API by specifying the API's Id and a stage name of the specified API. You add plan customers by adding API keys to the plan. </p>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsagePlan {
    /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of a usage plan.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of a usage plan.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The associated API stages of a usage plan.</p>
    pub api_stages: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
    /// <p>The request throttle limits of a usage plan.</p>
    pub throttle: std::option::Option<crate::model::ThrottleSettings>,
    /// <p>The maximum number of permitted requests per a given unit time interval.</p>
    pub quota: std::option::Option<crate::model::QuotaSettings>,
    /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
    pub product_code: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UsagePlan {
    /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of a usage plan.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of a usage plan.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The associated API stages of a usage plan.</p>
    pub fn api_stages(&self) -> std::option::Option<&[crate::model::ApiStage]> {
        self.api_stages.as_deref()
    }
    /// <p>The request throttle limits of a usage plan.</p>
    pub fn throttle(&self) -> std::option::Option<&crate::model::ThrottleSettings> {
        self.throttle.as_ref()
    }
    /// <p>The maximum number of permitted requests per a given unit time interval.</p>
    pub fn quota(&self) -> std::option::Option<&crate::model::QuotaSettings> {
        self.quota.as_ref()
    }
    /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
    pub fn product_code(&self) -> std::option::Option<&str> {
        self.product_code.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UsagePlan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsagePlan");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("api_stages", &self.api_stages);
        formatter.field("throttle", &self.throttle);
        formatter.field("quota", &self.quota);
        formatter.field("product_code", &self.product_code);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UsagePlan`](crate::model::UsagePlan)
pub mod usage_plan {
    /// A builder for [`UsagePlan`](crate::model::UsagePlan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) api_stages: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        pub(crate) throttle: std::option::Option<crate::model::ThrottleSettings>,
        pub(crate) quota: std::option::Option<crate::model::QuotaSettings>,
        pub(crate) product_code: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of a usage plan.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a usage plan.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of a usage plan.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a usage plan.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `api_stages`.
        ///
        /// To override the contents of this collection use [`set_api_stages`](Self::set_api_stages).
        ///
        /// <p>The associated API stages of a usage plan.</p>
        pub fn api_stages(mut self, input: impl Into<crate::model::ApiStage>) -> Self {
            let mut v = self.api_stages.unwrap_or_default();
            v.push(input.into());
            self.api_stages = Some(v);
            self
        }
        /// <p>The associated API stages of a usage plan.</p>
        pub fn set_api_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        ) -> Self {
            self.api_stages = input;
            self
        }
        /// <p>The request throttle limits of a usage plan.</p>
        pub fn throttle(mut self, input: crate::model::ThrottleSettings) -> Self {
            self.throttle = Some(input);
            self
        }
        /// <p>The request throttle limits of a usage plan.</p>
        pub fn set_throttle(
            mut self,
            input: std::option::Option<crate::model::ThrottleSettings>,
        ) -> Self {
            self.throttle = input;
            self
        }
        /// <p>The maximum number of permitted requests per a given unit time interval.</p>
        pub fn quota(mut self, input: crate::model::QuotaSettings) -> Self {
            self.quota = Some(input);
            self
        }
        /// <p>The maximum number of permitted requests per a given unit time interval.</p>
        pub fn set_quota(
            mut self,
            input: std::option::Option<crate::model::QuotaSettings>,
        ) -> Self {
            self.quota = input;
            self
        }
        /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code = Some(input.into());
            self
        }
        /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_code = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UsagePlan`](crate::model::UsagePlan)
        pub fn build(self) -> crate::model::UsagePlan {
            crate::model::UsagePlan {
                id: self.id,
                name: self.name,
                description: self.description,
                api_stages: self.api_stages,
                throttle: self.throttle,
                quota: self.quota,
                product_code: self.product_code,
                tags: self.tags,
            }
        }
    }
}
impl UsagePlan {
    /// Creates a new builder-style object to manufacture [`UsagePlan`](crate::model::UsagePlan)
    pub fn builder() -> crate::model::usage_plan::Builder {
        crate::model::usage_plan::Builder::default()
    }
}

/// <p>Represents a usage plan key to identify a plan customer.</p>
/// <div class="remarks">
/// <p>To associate an API stage with a selected API key in a usage plan, you must create a UsagePlanKey resource to represent the selected <a>ApiKey</a>.</p>
/// </div>"
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsagePlanKey {
    /// <p>The Id of a usage plan key.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The value of a usage plan key.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The name of a usage plan key.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UsagePlanKey {
    /// <p>The Id of a usage plan key.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The value of a usage plan key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The name of a usage plan key.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UsagePlanKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsagePlanKey");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UsagePlanKey`](crate::model::UsagePlanKey)
pub mod usage_plan_key {
    /// A builder for [`UsagePlanKey`](crate::model::UsagePlanKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Id of a usage plan key.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The Id of a usage plan key.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value of a usage plan key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a usage plan key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The name of a usage plan key.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a usage plan key.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UsagePlanKey`](crate::model::UsagePlanKey)
        pub fn build(self) -> crate::model::UsagePlanKey {
            crate::model::UsagePlanKey {
                id: self.id,
                r#type: self.r#type,
                value: self.value,
                name: self.name,
            }
        }
    }
}
impl UsagePlanKey {
    /// Creates a new builder-style object to manufacture [`UsagePlanKey`](crate::model::UsagePlanKey)
    pub fn builder() -> crate::model::usage_plan_key::Builder {
        crate::model::usage_plan_key::Builder::default()
    }
}

/// <p>Represents a unique identifier for a version of a deployed <a>RestApi</a> that is callable by users.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html">Deploy an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Stage {
    /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The identifier of a client certificate for an API stage.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The stage's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
    pub cache_cluster_enabled: bool,
    /// <p>The size of the cache cluster for the stage, if enabled.</p>
    pub cache_cluster_size: std::option::Option<crate::model::CacheClusterSize>,
    /// <p>The status of the cache cluster for the stage, if enabled.</p>
    pub cache_cluster_status: std::option::Option<crate::model::CacheClusterStatus>,
    /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
    pub method_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
    >,
    /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
    /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
    pub variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The version of the associated API documentation.</p>
    pub documentation_version: std::option::Option<std::string::String>,
    /// <p>Settings for logging access in this stage.</p>
    pub access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
    /// <p>Settings for the canary deployment in this stage.</p>
    pub canary_settings: std::option::Option<crate::model::CanarySettings>,
    /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
    pub tracing_enabled: bool,
    /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
    pub web_acl_arn: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The timestamp when the stage was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the stage last updated.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Stage {
    /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The identifier of a client certificate for an API stage.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The stage's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
    pub fn cache_cluster_enabled(&self) -> bool {
        self.cache_cluster_enabled
    }
    /// <p>The size of the cache cluster for the stage, if enabled.</p>
    pub fn cache_cluster_size(&self) -> std::option::Option<&crate::model::CacheClusterSize> {
        self.cache_cluster_size.as_ref()
    }
    /// <p>The status of the cache cluster for the stage, if enabled.</p>
    pub fn cache_cluster_status(&self) -> std::option::Option<&crate::model::CacheClusterStatus> {
        self.cache_cluster_status.as_ref()
    }
    /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
    pub fn method_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
    > {
        self.method_settings.as_ref()
    }
    /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
    /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
    pub fn variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.variables.as_ref()
    }
    /// <p>The version of the associated API documentation.</p>
    pub fn documentation_version(&self) -> std::option::Option<&str> {
        self.documentation_version.as_deref()
    }
    /// <p>Settings for logging access in this stage.</p>
    pub fn access_log_settings(&self) -> std::option::Option<&crate::model::AccessLogSettings> {
        self.access_log_settings.as_ref()
    }
    /// <p>Settings for the canary deployment in this stage.</p>
    pub fn canary_settings(&self) -> std::option::Option<&crate::model::CanarySettings> {
        self.canary_settings.as_ref()
    }
    /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
    pub fn tracing_enabled(&self) -> bool {
        self.tracing_enabled
    }
    /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
    pub fn web_acl_arn(&self) -> std::option::Option<&str> {
        self.web_acl_arn.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The timestamp when the stage was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The timestamp when the stage last updated.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
}
impl std::fmt::Debug for Stage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Stage");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("description", &self.description);
        formatter.field("cache_cluster_enabled", &self.cache_cluster_enabled);
        formatter.field("cache_cluster_size", &self.cache_cluster_size);
        formatter.field("cache_cluster_status", &self.cache_cluster_status);
        formatter.field("method_settings", &self.method_settings);
        formatter.field("variables", &self.variables);
        formatter.field("documentation_version", &self.documentation_version);
        formatter.field("access_log_settings", &self.access_log_settings);
        formatter.field("canary_settings", &self.canary_settings);
        formatter.field("tracing_enabled", &self.tracing_enabled);
        formatter.field("web_acl_arn", &self.web_acl_arn);
        formatter.field("tags", &self.tags);
        formatter.field("created_date", &self.created_date);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.finish()
    }
}
/// See [`Stage`](crate::model::Stage)
pub mod stage {
    /// A builder for [`Stage`](crate::model::Stage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_enabled: std::option::Option<bool>,
        pub(crate) cache_cluster_size: std::option::Option<crate::model::CacheClusterSize>,
        pub(crate) cache_cluster_status: std::option::Option<crate::model::CacheClusterStatus>,
        pub(crate) method_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
        >,
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) documentation_version: std::option::Option<std::string::String>,
        pub(crate) access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
        pub(crate) canary_settings: std::option::Option<crate::model::CanarySettings>,
        pub(crate) tracing_enabled: std::option::Option<bool>,
        pub(crate) web_acl_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The identifier of a client certificate for an API stage.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of a client certificate for an API stage.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The stage's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The stage's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
        pub fn cache_cluster_enabled(mut self, input: bool) -> Self {
            self.cache_cluster_enabled = Some(input);
            self
        }
        /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
        pub fn set_cache_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cache_cluster_enabled = input;
            self
        }
        /// <p>The size of the cache cluster for the stage, if enabled.</p>
        pub fn cache_cluster_size(mut self, input: crate::model::CacheClusterSize) -> Self {
            self.cache_cluster_size = Some(input);
            self
        }
        /// <p>The size of the cache cluster for the stage, if enabled.</p>
        pub fn set_cache_cluster_size(
            mut self,
            input: std::option::Option<crate::model::CacheClusterSize>,
        ) -> Self {
            self.cache_cluster_size = input;
            self
        }
        /// <p>The status of the cache cluster for the stage, if enabled.</p>
        pub fn cache_cluster_status(mut self, input: crate::model::CacheClusterStatus) -> Self {
            self.cache_cluster_status = Some(input);
            self
        }
        /// <p>The status of the cache cluster for the stage, if enabled.</p>
        pub fn set_cache_cluster_status(
            mut self,
            input: std::option::Option<crate::model::CacheClusterStatus>,
        ) -> Self {
            self.cache_cluster_status = input;
            self
        }
        /// Adds a key-value pair to `method_settings`.
        ///
        /// To override the contents of this collection use [`set_method_settings`](Self::set_method_settings).
        ///
        /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
        pub fn method_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MethodSetting>,
        ) -> Self {
            let mut hash_map = self.method_settings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.method_settings = Some(hash_map);
            self
        }
        /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
        pub fn set_method_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
            >,
        ) -> Self {
            self.method_settings = input;
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
        /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
        /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.documentation_version = Some(input.into());
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documentation_version = input;
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.access_log_settings = Some(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.access_log_settings = input;
            self
        }
        /// <p>Settings for the canary deployment in this stage.</p>
        pub fn canary_settings(mut self, input: crate::model::CanarySettings) -> Self {
            self.canary_settings = Some(input);
            self
        }
        /// <p>Settings for the canary deployment in this stage.</p>
        pub fn set_canary_settings(
            mut self,
            input: std::option::Option<crate::model::CanarySettings>,
        ) -> Self {
            self.canary_settings = input;
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn tracing_enabled(mut self, input: bool) -> Self {
            self.tracing_enabled = Some(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn set_tracing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.tracing_enabled = input;
            self
        }
        /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_acl_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_acl_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The timestamp when the stage last updated.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage last updated.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Stage`](crate::model::Stage)
        pub fn build(self) -> crate::model::Stage {
            crate::model::Stage {
                deployment_id: self.deployment_id,
                client_certificate_id: self.client_certificate_id,
                stage_name: self.stage_name,
                description: self.description,
                cache_cluster_enabled: self.cache_cluster_enabled.unwrap_or_default(),
                cache_cluster_size: self.cache_cluster_size,
                cache_cluster_status: self.cache_cluster_status,
                method_settings: self.method_settings,
                variables: self.variables,
                documentation_version: self.documentation_version,
                access_log_settings: self.access_log_settings,
                canary_settings: self.canary_settings,
                tracing_enabled: self.tracing_enabled.unwrap_or_default(),
                web_acl_arn: self.web_acl_arn,
                tags: self.tags,
                created_date: self.created_date,
                last_updated_date: self.last_updated_date,
            }
        }
    }
}
impl Stage {
    /// Creates a new builder-style object to manufacture [`Stage`](crate::model::Stage)
    pub fn builder() -> crate::model::stage::Builder {
        crate::model::stage::Builder::default()
    }
}

/// <p>A type of SDK that API Gateway can generate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SdkType {
    /// <p>The identifier of an <a>SdkType</a> instance.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The user-friendly name of an <a>SdkType</a> instance.</p>
    pub friendly_name: std::option::Option<std::string::String>,
    /// <p>The description of an <a>SdkType</a>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of configuration properties of an <a>SdkType</a>.</p>
    pub configuration_properties:
        std::option::Option<std::vec::Vec<crate::model::SdkConfigurationProperty>>,
}
impl SdkType {
    /// <p>The identifier of an <a>SdkType</a> instance.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The user-friendly name of an <a>SdkType</a> instance.</p>
    pub fn friendly_name(&self) -> std::option::Option<&str> {
        self.friendly_name.as_deref()
    }
    /// <p>The description of an <a>SdkType</a>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of configuration properties of an <a>SdkType</a>.</p>
    pub fn configuration_properties(
        &self,
    ) -> std::option::Option<&[crate::model::SdkConfigurationProperty]> {
        self.configuration_properties.as_deref()
    }
}
impl std::fmt::Debug for SdkType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SdkType");
        formatter.field("id", &self.id);
        formatter.field("friendly_name", &self.friendly_name);
        formatter.field("description", &self.description);
        formatter.field("configuration_properties", &self.configuration_properties);
        formatter.finish()
    }
}
/// See [`SdkType`](crate::model::SdkType)
pub mod sdk_type {
    /// A builder for [`SdkType`](crate::model::SdkType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) friendly_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) configuration_properties:
            std::option::Option<std::vec::Vec<crate::model::SdkConfigurationProperty>>,
    }
    impl Builder {
        /// <p>The identifier of an <a>SdkType</a> instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of an <a>SdkType</a> instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The user-friendly name of an <a>SdkType</a> instance.</p>
        pub fn friendly_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.friendly_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of an <a>SdkType</a> instance.</p>
        pub fn set_friendly_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.friendly_name = input;
            self
        }
        /// <p>The description of an <a>SdkType</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of an <a>SdkType</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `configuration_properties`.
        ///
        /// To override the contents of this collection use [`set_configuration_properties`](Self::set_configuration_properties).
        ///
        /// <p>A list of configuration properties of an <a>SdkType</a>.</p>
        pub fn configuration_properties(
            mut self,
            input: impl Into<crate::model::SdkConfigurationProperty>,
        ) -> Self {
            let mut v = self.configuration_properties.unwrap_or_default();
            v.push(input.into());
            self.configuration_properties = Some(v);
            self
        }
        /// <p>A list of configuration properties of an <a>SdkType</a>.</p>
        pub fn set_configuration_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SdkConfigurationProperty>>,
        ) -> Self {
            self.configuration_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`SdkType`](crate::model::SdkType)
        pub fn build(self) -> crate::model::SdkType {
            crate::model::SdkType {
                id: self.id,
                friendly_name: self.friendly_name,
                description: self.description,
                configuration_properties: self.configuration_properties,
            }
        }
    }
}
impl SdkType {
    /// Creates a new builder-style object to manufacture [`SdkType`](crate::model::SdkType)
    pub fn builder() -> crate::model::sdk_type::Builder {
        crate::model::sdk_type::Builder::default()
    }
}

/// <p>A configuration property of an SDK type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SdkConfigurationProperty {
    /// <p>The name of a an <a>SdkType</a> configuration property.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The user-friendly name of an <a>SdkType</a> configuration property.</p>
    pub friendly_name: std::option::Option<std::string::String>,
    /// <p>The description of an <a>SdkType</a> configuration property.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A boolean flag of an <a>SdkType</a> configuration property to indicate if the associated SDK configuration property is required (<code>true</code>) or not (<code>false</code>).</p>
    pub required: bool,
    /// <p>The default value of an <a>SdkType</a> configuration property.</p>
    pub default_value: std::option::Option<std::string::String>,
}
impl SdkConfigurationProperty {
    /// <p>The name of a an <a>SdkType</a> configuration property.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The user-friendly name of an <a>SdkType</a> configuration property.</p>
    pub fn friendly_name(&self) -> std::option::Option<&str> {
        self.friendly_name.as_deref()
    }
    /// <p>The description of an <a>SdkType</a> configuration property.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A boolean flag of an <a>SdkType</a> configuration property to indicate if the associated SDK configuration property is required (<code>true</code>) or not (<code>false</code>).</p>
    pub fn required(&self) -> bool {
        self.required
    }
    /// <p>The default value of an <a>SdkType</a> configuration property.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
}
impl std::fmt::Debug for SdkConfigurationProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SdkConfigurationProperty");
        formatter.field("name", &self.name);
        formatter.field("friendly_name", &self.friendly_name);
        formatter.field("description", &self.description);
        formatter.field("required", &self.required);
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`SdkConfigurationProperty`](crate::model::SdkConfigurationProperty)
pub mod sdk_configuration_property {
    /// A builder for [`SdkConfigurationProperty`](crate::model::SdkConfigurationProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) friendly_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) required: std::option::Option<bool>,
        pub(crate) default_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a an <a>SdkType</a> configuration property.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a an <a>SdkType</a> configuration property.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The user-friendly name of an <a>SdkType</a> configuration property.</p>
        pub fn friendly_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.friendly_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of an <a>SdkType</a> configuration property.</p>
        pub fn set_friendly_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.friendly_name = input;
            self
        }
        /// <p>The description of an <a>SdkType</a> configuration property.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of an <a>SdkType</a> configuration property.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A boolean flag of an <a>SdkType</a> configuration property to indicate if the associated SDK configuration property is required (<code>true</code>) or not (<code>false</code>).</p>
        pub fn required(mut self, input: bool) -> Self {
            self.required = Some(input);
            self
        }
        /// <p>A boolean flag of an <a>SdkType</a> configuration property to indicate if the associated SDK configuration property is required (<code>true</code>) or not (<code>false</code>).</p>
        pub fn set_required(mut self, input: std::option::Option<bool>) -> Self {
            self.required = input;
            self
        }
        /// <p>The default value of an <a>SdkType</a> configuration property.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value of an <a>SdkType</a> configuration property.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`SdkConfigurationProperty`](crate::model::SdkConfigurationProperty)
        pub fn build(self) -> crate::model::SdkConfigurationProperty {
            crate::model::SdkConfigurationProperty {
                name: self.name,
                friendly_name: self.friendly_name,
                description: self.description,
                required: self.required.unwrap_or_default(),
                default_value: self.default_value,
            }
        }
    }
}
impl SdkConfigurationProperty {
    /// Creates a new builder-style object to manufacture [`SdkConfigurationProperty`](crate::model::SdkConfigurationProperty)
    pub fn builder() -> crate::model::sdk_configuration_property::Builder {
        crate::model::sdk_configuration_property::Builder::default()
    }
}

/// <p>Represents a REST API.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestApi {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The API's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub minimum_compression_size: std::option::Option<i32>,
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
}
impl RestApi {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The API's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub fn binary_media_types(&self) -> std::option::Option<&[std::string::String]> {
        self.binary_media_types.as_deref()
    }
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub fn minimum_compression_size(&self) -> std::option::Option<i32> {
        self.minimum_compression_size
    }
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub fn api_key_source(&self) -> std::option::Option<&crate::model::ApiKeySourceType> {
        self.api_key_source.as_ref()
    }
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
}
impl std::fmt::Debug for RestApi {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestApi");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.field("binary_media_types", &self.binary_media_types);
        formatter.field("minimum_compression_size", &self.minimum_compression_size);
        formatter.field("api_key_source", &self.api_key_source);
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("policy", &self.policy);
        formatter.field("tags", &self.tags);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.finish()
    }
}
/// See [`RestApi`](crate::model::RestApi)
pub mod rest_api {
    /// A builder for [`RestApi`](crate::model::RestApi)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_compression_size: std::option::Option<i32>,
        pub(crate) api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The API's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The API's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The API's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Appends an item to `binary_media_types`.
        ///
        /// To override the contents of this collection use [`set_binary_media_types`](Self::set_binary_media_types).
        ///
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn binary_media_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.binary_media_types.unwrap_or_default();
            v.push(input.into());
            self.binary_media_types = Some(v);
            self
        }
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn set_binary_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.binary_media_types = input;
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn minimum_compression_size(mut self, input: i32) -> Self {
            self.minimum_compression_size = Some(input);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn set_minimum_compression_size(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_compression_size = input;
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn api_key_source(mut self, input: crate::model::ApiKeySourceType) -> Self {
            self.api_key_source = Some(input);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn set_api_key_source(
            mut self,
            input: std::option::Option<crate::model::ApiKeySourceType>,
        ) -> Self {
            self.api_key_source = input;
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`RestApi`](crate::model::RestApi)
        pub fn build(self) -> crate::model::RestApi {
            crate::model::RestApi {
                id: self.id,
                name: self.name,
                description: self.description,
                created_date: self.created_date,
                version: self.version,
                warnings: self.warnings,
                binary_media_types: self.binary_media_types,
                minimum_compression_size: self.minimum_compression_size,
                api_key_source: self.api_key_source,
                endpoint_configuration: self.endpoint_configuration,
                policy: self.policy,
                tags: self.tags,
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
            }
        }
    }
}
impl RestApi {
    /// Creates a new builder-style object to manufacture [`RestApi`](crate::model::RestApi)
    pub fn builder() -> crate::model::rest_api::Builder {
        crate::model::rest_api::Builder::default()
    }
}

/// <p>Represents an API resource.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The resource's identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The parent resource's identifier.</p>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>The last path segment for this resource.</p>
    pub path_part: std::option::Option<std::string::String>,
    /// <p>The full path for this resource.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Gets an API resource's method of a given HTTP verb.</p>
    /// <div class="remarks">
    /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
    /// <h4>Example: Get the GET method of an API resource</h4>
    /// <h5>Request</h5>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20170223T031827Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
    /// "name": "method",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
    /// "name": "GET",
    /// "title": "GET"
    /// },
    /// "integration:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "method:integration": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "method:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "methodresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "apiKeyRequired": false,
    /// "authorizationType": "NONE",
    /// "httpMethod": "GET",
    /// "_embedded": {
    /// "method:integration": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "3kzxbg5sa2",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestParameters": {
    /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
    /// },
    /// "requestTemplates": {
    /// "application/json": "{\n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// },
    /// "method:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": false
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
    /// </div>
    /// <div class="seeAlso">
    /// </div>
    pub resource_methods:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Method>>,
}
impl Resource {
    /// <p>The resource's identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The parent resource's identifier.</p>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>The last path segment for this resource.</p>
    pub fn path_part(&self) -> std::option::Option<&str> {
        self.path_part.as_deref()
    }
    /// <p>The full path for this resource.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>Gets an API resource's method of a given HTTP verb.</p>
    /// <div class="remarks">
    /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
    /// <h4>Example: Get the GET method of an API resource</h4>
    /// <h5>Request</h5>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20170223T031827Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
    /// "name": "method",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
    /// "name": "GET",
    /// "title": "GET"
    /// },
    /// "integration:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "method:integration": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "method:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "methodresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "apiKeyRequired": false,
    /// "authorizationType": "NONE",
    /// "httpMethod": "GET",
    /// "_embedded": {
    /// "method:integration": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "3kzxbg5sa2",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestParameters": {
    /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
    /// },
    /// "requestTemplates": {
    /// "application/json": "{\n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// },
    /// "method:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": false
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
    /// </div>
    /// <div class="seeAlso">
    /// </div>
    pub fn resource_methods(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Method>>
    {
        self.resource_methods.as_ref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("id", &self.id);
        formatter.field("parent_id", &self.parent_id);
        formatter.field("path_part", &self.path_part);
        formatter.field("path", &self.path);
        formatter.field("resource_methods", &self.resource_methods);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) path_part: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) resource_methods: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Method>,
        >,
    }
    impl Builder {
        /// <p>The resource's identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The resource's identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The parent resource's identifier.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The parent resource's identifier.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn path_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_part = Some(input.into());
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn set_path_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_part = input;
            self
        }
        /// <p>The full path for this resource.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The full path for this resource.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Adds a key-value pair to `resource_methods`.
        ///
        /// To override the contents of this collection use [`set_resource_methods`](Self::set_resource_methods).
        ///
        /// <p>Gets an API resource's method of a given HTTP verb.</p>
        /// <div class="remarks">
        /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
        /// <h4>Example: Get the GET method of an API resource</h4>
        /// <h5>Request</h5>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20170223T031827Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
        /// "name": "method",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
        /// "name": "GET",
        /// "title": "GET"
        /// },
        /// "integration:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "method:integration": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "method:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "methodresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "apiKeyRequired": false,
        /// "authorizationType": "NONE",
        /// "httpMethod": "GET",
        /// "_embedded": {
        /// "method:integration": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "3kzxbg5sa2",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestParameters": {
        /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
        /// },
        /// "requestTemplates": {
        /// "application/json": "{\n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// },
        /// "method:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": false
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
        /// </div>
        /// <div class="seeAlso">
        /// </div>
        pub fn resource_methods(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Method>,
        ) -> Self {
            let mut hash_map = self.resource_methods.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_methods = Some(hash_map);
            self
        }
        /// <p>Gets an API resource's method of a given HTTP verb.</p>
        /// <div class="remarks">
        /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
        /// <h4>Example: Get the GET method of an API resource</h4>
        /// <h5>Request</h5>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20170223T031827Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
        /// "name": "method",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
        /// "name": "GET",
        /// "title": "GET"
        /// },
        /// "integration:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "method:integration": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "method:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "methodresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "apiKeyRequired": false,
        /// "authorizationType": "NONE",
        /// "httpMethod": "GET",
        /// "_embedded": {
        /// "method:integration": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "3kzxbg5sa2",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestParameters": {
        /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
        /// },
        /// "requestTemplates": {
        /// "application/json": "{\n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// },
        /// "method:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": false
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
        /// </div>
        /// <div class="seeAlso">
        /// </div>
        pub fn set_resource_methods(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Method>,
            >,
        ) -> Self {
            self.resource_methods = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                id: self.id,
                parent_id: self.parent_id,
                path_part: self.path_part,
                path: self.path,
                resource_methods: self.resource_methods,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>A set of validation rules for incoming <a>Method</a> requests.</p>
/// <div class="remarks">
/// <p>In OpenAPI, a <a>RequestValidator</a> of an API is defined by the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.requestValidator.html">x-amazon-apigateway-request-validators.requestValidator</a> object. It the referenced using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validator">x-amazon-apigateway-request-validator</a> property.</p>
/// </div>
/// <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html">Enable Basic Request Validation in API Gateway</a></div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestValidator {
    /// <p>The identifier of this <a>RequestValidator</a>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of this <a>RequestValidator</a></p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
    pub validate_request_body: bool,
    /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
    pub validate_request_parameters: bool,
}
impl RequestValidator {
    /// <p>The identifier of this <a>RequestValidator</a>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of this <a>RequestValidator</a></p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
    pub fn validate_request_body(&self) -> bool {
        self.validate_request_body
    }
    /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
    pub fn validate_request_parameters(&self) -> bool {
        self.validate_request_parameters
    }
}
impl std::fmt::Debug for RequestValidator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestValidator");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("validate_request_body", &self.validate_request_body);
        formatter.field(
            "validate_request_parameters",
            &self.validate_request_parameters,
        );
        formatter.finish()
    }
}
/// See [`RequestValidator`](crate::model::RequestValidator)
pub mod request_validator {
    /// A builder for [`RequestValidator`](crate::model::RequestValidator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) validate_request_body: std::option::Option<bool>,
        pub(crate) validate_request_parameters: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of this <a>RequestValidator</a>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of this <a>RequestValidator</a>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of this <a>RequestValidator</a></p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this <a>RequestValidator</a></p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
        pub fn validate_request_body(mut self, input: bool) -> Self {
            self.validate_request_body = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
        pub fn set_validate_request_body(mut self, input: std::option::Option<bool>) -> Self {
            self.validate_request_body = input;
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
        pub fn validate_request_parameters(mut self, input: bool) -> Self {
            self.validate_request_parameters = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
        pub fn set_validate_request_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.validate_request_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestValidator`](crate::model::RequestValidator)
        pub fn build(self) -> crate::model::RequestValidator {
            crate::model::RequestValidator {
                id: self.id,
                name: self.name,
                validate_request_body: self.validate_request_body.unwrap_or_default(),
                validate_request_parameters: self.validate_request_parameters.unwrap_or_default(),
            }
        }
    }
}
impl RequestValidator {
    /// Creates a new builder-style object to manufacture [`RequestValidator`](crate::model::RequestValidator)
    pub fn builder() -> crate::model::request_validator::Builder {
        crate::model::request_validator::Builder::default()
    }
}

/// <p>Represents the data structure of a method's request or response payload.</p>
/// <div class="remarks">
/// <p>A request model defines the data structure of the client-supplied request payload. A response model defines the data structure of the response payload returned by the back end. Although not required, models are useful for mapping payloads between the front end and back end.</p>
/// <p>A model is used for generating an API's SDK, validating the input request body, and creating a skeletal mapping template.</p>
/// </div>
/// <div class="seeAlso">
/// <a>Method</a>, <a>MethodResponse</a>, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html">Models and Mappings</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Model {
    /// <p>The identifier for the model resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the model. Must be an alphanumeric string.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The content-type for the model.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl Model {
    /// <p>The identifier for the model resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the model. Must be an alphanumeric string.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The content-type for the model.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for Model {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Model");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("schema", &self.schema);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`Model`](crate::model::Model)
pub mod model {
    /// A builder for [`Model`](crate::model::Model)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the model resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the model resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the model. Must be an alphanumeric string.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model. Must be an alphanumeric string.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>The content-type for the model.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type for the model.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Model`](crate::model::Model)
        pub fn build(self) -> crate::model::Model {
            crate::model::Model {
                id: self.id,
                name: self.name,
                description: self.description,
                schema: self.schema,
                content_type: self.content_type,
            }
        }
    }
}
impl Model {
    /// Creates a new builder-style object to manufacture [`Model`](crate::model::Model)
    pub fn builder() -> crate::model::model::Builder {
        crate::model::model::Builder::default()
    }
}

/// <p>A gateway response of a given response type and status code, with optional response parameters and mapping templates.</p>
/// <div class="remarks">
/// For more information about valid gateway response types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">Gateway Response Types Supported by API Gateway</a>
/// <div class="example">
/// <h4>Example: Get a Gateway Response of a given response type</h4>
/// <h5>Request</h5>
/// <p>This example shows how to get a gateway response of the <code>MISSING_AUTHENTICATION_TOKEN</code> type.</p>
/// <pre><code>GET /restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN HTTP/1.1
/// Host: beta-apigateway.us-east-1.amazonaws.com
/// Content-Type: application/json
/// X-Amz-Date: 20170503T202516Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=1b52460e3159c1a26cff29093855d50ea141c1c5b937528fecaf60f51129697a
/// Cache-Control: no-cache
/// Postman-Token: 3b2a1ce9-c848-2e26-2e2f-9c2caefbed45
/// </code></pre>
/// <p>The response type is specified as a URL path.</p>
/// <h5>Response</h5>
/// <p>The successful operation returns the <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html",
/// "name": "gatewayresponse",
/// "templated": true
/// },
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// "gatewayresponse:delete": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// }
/// },
/// "defaultResponse": false,
/// "responseParameters": {
/// "gatewayresponse.header.x-request-path": "method.request.path.petId",
/// "gatewayresponse.header.Access-Control-Allow-Origin": "'a.b.c'",
/// "gatewayresponse.header.x-request-query": "method.request.querystring.q",
/// "gatewayresponse.header.x-request-header": "method.request.header.Accept"
/// },
/// "responseTemplates": {
/// "application/json": "{\n     \"message\": $context.error.messageString,\n     \"type\":  \"$context.error.responseType\",\n     \"stage\":  \"$context.stage\",\n     \"resourcePath\":  \"$context.resourcePath\",\n     \"stageVariables.a\":  \"$stageVariables.a\",\n     \"statusCode\": \"'404'\"\n}"
/// },
/// "responseType": "MISSING_AUTHENTICATION_TOKEN",
/// "statusCode": "404"
/// }</code></pre>
/// <p></p>
/// </div>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html">Customize Gateway Responses</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayResponse {
    /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
    pub response_type: std::option::Option<crate::model::GatewayResponseType>,
    /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    pub default_response: bool,
}
impl GatewayResponse {
    /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
    pub fn response_type(&self) -> std::option::Option<&crate::model::GatewayResponseType> {
        self.response_type.as_ref()
    }
    /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    pub fn default_response(&self) -> bool {
        self.default_response
    }
}
impl std::fmt::Debug for GatewayResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayResponse");
        formatter.field("response_type", &self.response_type);
        formatter.field("status_code", &self.status_code);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field("default_response", &self.default_response);
        formatter.finish()
    }
}
/// See [`GatewayResponse`](crate::model::GatewayResponse)
pub mod gateway_response {
    /// A builder for [`GatewayResponse`](crate::model::GatewayResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_type: std::option::Option<crate::model::GatewayResponseType>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) default_response: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.response_type = Some(input);
            self
        }
        /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.response_type = input;
            self
        }
        /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
        pub fn default_response(mut self, input: bool) -> Self {
            self.default_response = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
        pub fn set_default_response(mut self, input: std::option::Option<bool>) -> Self {
            self.default_response = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayResponse`](crate::model::GatewayResponse)
        pub fn build(self) -> crate::model::GatewayResponse {
            crate::model::GatewayResponse {
                response_type: self.response_type,
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                default_response: self.default_response.unwrap_or_default(),
            }
        }
    }
}
impl GatewayResponse {
    /// Creates a new builder-style object to manufacture [`GatewayResponse`](crate::model::GatewayResponse)
    pub fn builder() -> crate::model::gateway_response::Builder {
        crate::model::gateway_response::Builder::default()
    }
}

/// <p>Represents a custom domain name as a user-friendly host name of an API (<a>RestApi</a>).</p>
/// <div class="Remarks">
/// <p>When you deploy an API, API Gateway creates a default host name for the API. This default API host name is of the <code>{restapi-id}.execute-api.{region}.amazonaws.com</code> format. With the default host name, you can access the API's root resource with the URL of <code>https://{restapi-id}.execute-api.{region}.amazonaws.com/{stage}/</code>. When you set up a custom domain name of <code>apis.example.com</code> for this API, you can then access the same resource using the URL of the <code>https://apis.examples.com/myApi</code>, where <code>myApi</code> is the base path mapping (<a>BasePathMapping</a>) of your API under the custom domain name.
/// </p>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Set a Custom Host Name for an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainName {
    /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    pub certificate_name: std::option::Option<std::string::String>,
    /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    pub certificate_upload_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
    pub regional_domain_name: std::option::Option<std::string::String>,
    /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub regional_hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
    pub regional_certificate_name: std::option::Option<std::string::String>,
    /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
    pub regional_certificate_arn: std::option::Option<std::string::String>,
    /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
    pub distribution_domain_name: std::option::Option<std::string::String>,
    /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub distribution_hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
    pub endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
    /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
    pub domain_name_status: std::option::Option<crate::model::DomainNameStatus>,
    /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
    pub domain_name_status_message: std::option::Option<std::string::String>,
    /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    pub security_policy: std::option::Option<crate::model::SecurityPolicy>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
    pub mutual_tls_authentication: std::option::Option<crate::model::MutualTlsAuthentication>,
    /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    pub ownership_verification_certificate_arn: std::option::Option<std::string::String>,
}
impl DomainName {
    /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    pub fn certificate_name(&self) -> std::option::Option<&str> {
        self.certificate_name.as_deref()
    }
    /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    pub fn certificate_upload_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.certificate_upload_date.as_ref()
    }
    /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
    pub fn regional_domain_name(&self) -> std::option::Option<&str> {
        self.regional_domain_name.as_deref()
    }
    /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub fn regional_hosted_zone_id(&self) -> std::option::Option<&str> {
        self.regional_hosted_zone_id.as_deref()
    }
    /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
    pub fn regional_certificate_name(&self) -> std::option::Option<&str> {
        self.regional_certificate_name.as_deref()
    }
    /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
    pub fn regional_certificate_arn(&self) -> std::option::Option<&str> {
        self.regional_certificate_arn.as_deref()
    }
    /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
    pub fn distribution_domain_name(&self) -> std::option::Option<&str> {
        self.distribution_domain_name.as_deref()
    }
    /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub fn distribution_hosted_zone_id(&self) -> std::option::Option<&str> {
        self.distribution_hosted_zone_id.as_deref()
    }
    /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
    pub fn domain_name_status(&self) -> std::option::Option<&crate::model::DomainNameStatus> {
        self.domain_name_status.as_ref()
    }
    /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
    pub fn domain_name_status_message(&self) -> std::option::Option<&str> {
        self.domain_name_status_message.as_deref()
    }
    /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    pub fn security_policy(&self) -> std::option::Option<&crate::model::SecurityPolicy> {
        self.security_policy.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
    pub fn mutual_tls_authentication(
        &self,
    ) -> std::option::Option<&crate::model::MutualTlsAuthentication> {
        self.mutual_tls_authentication.as_ref()
    }
    /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    pub fn ownership_verification_certificate_arn(&self) -> std::option::Option<&str> {
        self.ownership_verification_certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for DomainName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainName");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("certificate_name", &self.certificate_name);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_upload_date", &self.certificate_upload_date);
        formatter.field("regional_domain_name", &self.regional_domain_name);
        formatter.field("regional_hosted_zone_id", &self.regional_hosted_zone_id);
        formatter.field("regional_certificate_name", &self.regional_certificate_name);
        formatter.field("regional_certificate_arn", &self.regional_certificate_arn);
        formatter.field("distribution_domain_name", &self.distribution_domain_name);
        formatter.field(
            "distribution_hosted_zone_id",
            &self.distribution_hosted_zone_id,
        );
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("domain_name_status", &self.domain_name_status);
        formatter.field(
            "domain_name_status_message",
            &self.domain_name_status_message,
        );
        formatter.field("security_policy", &self.security_policy);
        formatter.field("tags", &self.tags);
        formatter.field("mutual_tls_authentication", &self.mutual_tls_authentication);
        formatter.field(
            "ownership_verification_certificate_arn",
            &self.ownership_verification_certificate_arn,
        );
        formatter.finish()
    }
}
/// See [`DomainName`](crate::model::DomainName)
pub mod domain_name {
    /// A builder for [`DomainName`](crate::model::DomainName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_upload_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) regional_domain_name: std::option::Option<std::string::String>,
        pub(crate) regional_hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) regional_certificate_name: std::option::Option<std::string::String>,
        pub(crate) regional_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) distribution_domain_name: std::option::Option<std::string::String>,
        pub(crate) distribution_hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) domain_name_status: std::option::Option<crate::model::DomainNameStatus>,
        pub(crate) domain_name_status_message: std::option::Option<std::string::String>,
        pub(crate) security_policy: std::option::Option<crate::model::SecurityPolicy>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthentication>,
        pub(crate) ownership_verification_certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
        pub fn certificate_upload_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.certificate_upload_date = Some(input);
            self
        }
        /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
        pub fn set_certificate_upload_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.certificate_upload_date = input;
            self
        }
        /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
        pub fn regional_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_domain_name = Some(input.into());
            self
        }
        /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
        pub fn set_regional_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_domain_name = input;
            self
        }
        /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn regional_hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn set_regional_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_hosted_zone_id = input;
            self
        }
        /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
        pub fn regional_certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
        pub fn set_regional_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_certificate_name = input;
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn regional_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_certificate_arn = Some(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_regional_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_certificate_arn = input;
            self
        }
        /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
        pub fn distribution_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_domain_name = Some(input.into());
            self
        }
        /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
        pub fn set_distribution_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_domain_name = input;
            self
        }
        /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn distribution_hosted_zone_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn set_distribution_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_hosted_zone_id = input;
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
        pub fn domain_name_status(mut self, input: crate::model::DomainNameStatus) -> Self {
            self.domain_name_status = Some(input);
            self
        }
        /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
        pub fn set_domain_name_status(
            mut self,
            input: std::option::Option<crate::model::DomainNameStatus>,
        ) -> Self {
            self.domain_name_status = input;
            self
        }
        /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
        pub fn domain_name_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name_status_message = Some(input.into());
            self
        }
        /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
        pub fn set_domain_name_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_name_status_message = input;
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn security_policy(mut self, input: crate::model::SecurityPolicy) -> Self {
            self.security_policy = Some(input);
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn set_security_policy(
            mut self,
            input: std::option::Option<crate::model::SecurityPolicy>,
        ) -> Self {
            self.security_policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthentication,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthentication>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn ownership_verification_certificate_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn set_ownership_verification_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainName`](crate::model::DomainName)
        pub fn build(self) -> crate::model::DomainName {
            crate::model::DomainName {
                domain_name: self.domain_name,
                certificate_name: self.certificate_name,
                certificate_arn: self.certificate_arn,
                certificate_upload_date: self.certificate_upload_date,
                regional_domain_name: self.regional_domain_name,
                regional_hosted_zone_id: self.regional_hosted_zone_id,
                regional_certificate_name: self.regional_certificate_name,
                regional_certificate_arn: self.regional_certificate_arn,
                distribution_domain_name: self.distribution_domain_name,
                distribution_hosted_zone_id: self.distribution_hosted_zone_id,
                endpoint_configuration: self.endpoint_configuration,
                domain_name_status: self.domain_name_status,
                domain_name_status_message: self.domain_name_status_message,
                security_policy: self.security_policy,
                tags: self.tags,
                mutual_tls_authentication: self.mutual_tls_authentication,
                ownership_verification_certificate_arn: self.ownership_verification_certificate_arn,
            }
        }
    }
}
impl DomainName {
    /// Creates a new builder-style object to manufacture [`DomainName`](crate::model::DomainName)
    pub fn builder() -> crate::model::domain_name::Builder {
        crate::model::domain_name::Builder::default()
    }
}

/// <p>A snapshot of the documentation of an API.</p>
/// <div class="remarks"><p>Publishing API documentation involves creating a documentation version associated with an API stage and exporting the versioned documentation to an external (e.g., OpenAPI) file.</p></div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a>DocumentationPart</a>, <a>DocumentationVersions</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentationVersion {
    /// <p>The version identifier of the API documentation snapshot.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The date when the API documentation snapshot is created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the API documentation snapshot.</p>
    pub description: std::option::Option<std::string::String>,
}
impl DocumentationVersion {
    /// <p>The version identifier of the API documentation snapshot.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The date when the API documentation snapshot is created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The description of the API documentation snapshot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for DocumentationVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentationVersion");
        formatter.field("version", &self.version);
        formatter.field("created_date", &self.created_date);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`DocumentationVersion`](crate::model::DocumentationVersion)
pub mod documentation_version {
    /// A builder for [`DocumentationVersion`](crate::model::DocumentationVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version identifier of the API documentation snapshot.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version identifier of the API documentation snapshot.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The date when the API documentation snapshot is created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date when the API documentation snapshot is created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The description of the API documentation snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API documentation snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentationVersion`](crate::model::DocumentationVersion)
        pub fn build(self) -> crate::model::DocumentationVersion {
            crate::model::DocumentationVersion {
                version: self.version,
                created_date: self.created_date,
                description: self.description,
            }
        }
    }
}
impl DocumentationVersion {
    /// Creates a new builder-style object to manufacture [`DocumentationVersion`](crate::model::DocumentationVersion)
    pub fn builder() -> crate::model::documentation_version::Builder {
        crate::model::documentation_version::Builder::default()
    }
}

/// <p>A documentation part for a targeted API entity.</p>
/// <div class="remarks">
/// <p>A documentation part consists of a content map (<code>properties</code>) and a target (<code>location</code>). The target specifies an API entity to which the documentation content applies. The supported API entity types are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Valid <code>location</code> fields depend on the API entity type. All valid fields are not required.</p>
/// <p>The content map is a JSON string of API-specific key-value pairs. Although an API can use any shape for the content map, only the OpenAPI-compliant documentation fields will be injected into the associated API entity definition in the exported OpenAPI definition file.</p></div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a>DocumentationParts</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentationPart {
    /// <p>The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
    pub location: std::option::Option<crate::model::DocumentationPartLocation>,
    /// <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>.  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
    pub properties: std::option::Option<std::string::String>,
}
impl DocumentationPart {
    /// <p>The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::DocumentationPartLocation> {
        self.location.as_ref()
    }
    /// <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>.  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
    pub fn properties(&self) -> std::option::Option<&str> {
        self.properties.as_deref()
    }
}
impl std::fmt::Debug for DocumentationPart {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentationPart");
        formatter.field("id", &self.id);
        formatter.field("location", &self.location);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`DocumentationPart`](crate::model::DocumentationPart)
pub mod documentation_part {
    /// A builder for [`DocumentationPart`](crate::model::DocumentationPart)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::DocumentationPartLocation>,
        pub(crate) properties: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
        pub fn location(mut self, input: crate::model::DocumentationPartLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::DocumentationPartLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>.  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
        pub fn properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.properties = Some(input.into());
            self
        }
        /// <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>.  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
        pub fn set_properties(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentationPart`](crate::model::DocumentationPart)
        pub fn build(self) -> crate::model::DocumentationPart {
            crate::model::DocumentationPart {
                id: self.id,
                location: self.location,
                properties: self.properties,
            }
        }
    }
}
impl DocumentationPart {
    /// Creates a new builder-style object to manufacture [`DocumentationPart`](crate::model::DocumentationPart)
    pub fn builder() -> crate::model::documentation_part::Builder {
        crate::model::documentation_part::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocationStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Documented,
    #[allow(missing_docs)] // documentation missing in model
    Undocumented,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocationStatusType {
    fn from(s: &str) -> Self {
        match s {
            "DOCUMENTED" => LocationStatusType::Documented,
            "UNDOCUMENTED" => LocationStatusType::Undocumented,
            other => LocationStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocationStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocationStatusType::from(s))
    }
}
impl LocationStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocationStatusType::Documented => "DOCUMENTED",
            LocationStatusType::Undocumented => "UNDOCUMENTED",
            LocationStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOCUMENTED", "UNDOCUMENTED"]
    }
}
impl AsRef<str> for LocationStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An immutable representation of a <a>RestApi</a> resource that can be called by users using <a>Stages</a>. A deployment must be associated with a <a>Stage</a> for it to be callable over the Internet.</p>
/// <div class="remarks">To create a deployment, call <code>POST</code> on the <a>Deployments</a> resource of a <a>RestApi</a>.
/// To view, update, or delete a deployment, call <code>GET</code>, <code>PATCH</code>, or <code>DELETE</code> on the specified deployment resource (<code>/restapis/{restapi_id}/deployments/{deployment_id}</code>).</div>
/// <div class="seeAlso"><a>RestApi</a>, <a>Deployments</a>, <a>Stage</a>,
/// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html">AWS CLI</a>,
/// <a href="https://aws.amazon.com/tools/">AWS SDKs</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Deployment {
    /// <p>The identifier for the deployment resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The description for the deployment resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the deployment resource was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.</p>
    pub api_summary: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>,
        >,
    >,
}
impl Deployment {
    /// <p>The identifier for the deployment resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The description for the deployment resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that the deployment resource was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.</p>
    pub fn api_summary(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>,
        >,
    > {
        self.api_summary.as_ref()
    }
}
impl std::fmt::Debug for Deployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Deployment");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("api_summary", &self.api_summary);
        formatter.finish()
    }
}
/// See [`Deployment`](crate::model::Deployment)
pub mod deployment {
    /// A builder for [`Deployment`](crate::model::Deployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) api_summary: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>,
            >,
        >,
    }
    impl Builder {
        /// <p>The identifier for the deployment resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the deployment resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the deployment resource was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time that the deployment resource was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Adds a key-value pair to `api_summary`.
        ///
        /// To override the contents of this collection use [`set_api_summary`](Self::set_api_summary).
        ///
        /// <p>A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.</p>
        pub fn api_summary(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>>,
        ) -> Self {
            let mut hash_map = self.api_summary.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.api_summary = Some(hash_map);
            self
        }
        /// <p>A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.</p>
        pub fn set_api_summary(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>,
                >,
            >,
        ) -> Self {
            self.api_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`Deployment`](crate::model::Deployment)
        pub fn build(self) -> crate::model::Deployment {
            crate::model::Deployment {
                id: self.id,
                description: self.description,
                created_date: self.created_date,
                api_summary: self.api_summary,
            }
        }
    }
}
impl Deployment {
    /// Creates a new builder-style object to manufacture [`Deployment`](crate::model::Deployment)
    pub fn builder() -> crate::model::deployment::Builder {
        crate::model::deployment::Builder::default()
    }
}

/// <p>Represents a client certificate used to configure client-side SSL authentication while sending requests to the integration endpoint.</p>
/// <div class="remarks">Client certificates are used to authenticate an API by the backend server. To authenticate an API client (or user), use IAM roles and policies, a custom <a>Authorizer</a> or an Amazon Cognito user pool.</div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html">Use Client-Side Certificate</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientCertificate {
    /// <p>The identifier of the client certificate.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The description of the client certificate.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
    pub pem_encoded_certificate: std::option::Option<std::string::String>,
    /// <p>The timestamp when the client certificate was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the client certificate will expire.</p>
    pub expiration_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ClientCertificate {
    /// <p>The identifier of the client certificate.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The description of the client certificate.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
    pub fn pem_encoded_certificate(&self) -> std::option::Option<&str> {
        self.pem_encoded_certificate.as_deref()
    }
    /// <p>The timestamp when the client certificate was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The timestamp when the client certificate will expire.</p>
    pub fn expiration_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration_date.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ClientCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientCertificate");
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("description", &self.description);
        formatter.field("pem_encoded_certificate", &self.pem_encoded_certificate);
        formatter.field("created_date", &self.created_date);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ClientCertificate`](crate::model::ClientCertificate)
pub mod client_certificate {
    /// A builder for [`ClientCertificate`](crate::model::ClientCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) pem_encoded_certificate: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the client certificate.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of the client certificate.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The description of the client certificate.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the client certificate.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
        pub fn pem_encoded_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.pem_encoded_certificate = Some(input.into());
            self
        }
        /// <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
        pub fn set_pem_encoded_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pem_encoded_certificate = input;
            self
        }
        /// <p>The timestamp when the client certificate was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the client certificate was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The timestamp when the client certificate will expire.</p>
        pub fn expiration_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p>The timestamp when the client certificate will expire.</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientCertificate`](crate::model::ClientCertificate)
        pub fn build(self) -> crate::model::ClientCertificate {
            crate::model::ClientCertificate {
                client_certificate_id: self.client_certificate_id,
                description: self.description,
                pem_encoded_certificate: self.pem_encoded_certificate,
                created_date: self.created_date,
                expiration_date: self.expiration_date,
                tags: self.tags,
            }
        }
    }
}
impl ClientCertificate {
    /// Creates a new builder-style object to manufacture [`ClientCertificate`](crate::model::ClientCertificate)
    pub fn builder() -> crate::model::client_certificate::Builder {
        crate::model::client_certificate::Builder::default()
    }
}

/// <p>Represents the base path that callers of the API must provide as part of the URL after the domain name.</p>
/// <div class="remarks">A custom domain name plus a <code>BasePathMapping</code> specification identifies a deployed <a>RestApi</a> in a given stage of the owner <a>Account</a>.</div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Use Custom Domain Names</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BasePathMapping {
    /// <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
    pub base_path: std::option::Option<std::string::String>,
    /// <p>The string identifier of the associated <a>RestApi</a>.</p>
    pub rest_api_id: std::option::Option<std::string::String>,
    /// <p>The name of the associated stage.</p>
    pub stage: std::option::Option<std::string::String>,
}
impl BasePathMapping {
    /// <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
    pub fn base_path(&self) -> std::option::Option<&str> {
        self.base_path.as_deref()
    }
    /// <p>The string identifier of the associated <a>RestApi</a>.</p>
    pub fn rest_api_id(&self) -> std::option::Option<&str> {
        self.rest_api_id.as_deref()
    }
    /// <p>The name of the associated stage.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
}
impl std::fmt::Debug for BasePathMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BasePathMapping");
        formatter.field("base_path", &self.base_path);
        formatter.field("rest_api_id", &self.rest_api_id);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}
/// See [`BasePathMapping`](crate::model::BasePathMapping)
pub mod base_path_mapping {
    /// A builder for [`BasePathMapping`](crate::model::BasePathMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_path: std::option::Option<std::string::String>,
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_path = Some(input.into());
            self
        }
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.base_path = input;
            self
        }
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The name of the associated stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The name of the associated stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`BasePathMapping`](crate::model::BasePathMapping)
        pub fn build(self) -> crate::model::BasePathMapping {
            crate::model::BasePathMapping {
                base_path: self.base_path,
                rest_api_id: self.rest_api_id,
                stage: self.stage,
            }
        }
    }
}
impl BasePathMapping {
    /// Creates a new builder-style object to manufacture [`BasePathMapping`](crate::model::BasePathMapping)
    pub fn builder() -> crate::model::base_path_mapping::Builder {
        crate::model::base_path_mapping::Builder::default()
    }
}

/// <p>Represents an authorization layer for methods. If enabled on a method, API Gateway will activate the authorizer when a client calls the method.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer</a>
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Authorizer {
    /// <p>The identifier for the authorizer resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>[Required] The name of the authorizer.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
    pub r#type: std::option::Option<crate::model::AuthorizerType>,
    /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
    pub provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
    pub auth_type: std::option::Option<std::string::String>,
    /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
    pub authorizer_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
    pub authorizer_credentials: std::option::Option<std::string::String>,
    /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
    pub identity_source: std::option::Option<std::string::String>,
    /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
    pub identity_validation_expression: std::option::Option<std::string::String>,
    /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
    pub authorizer_result_ttl_in_seconds: std::option::Option<i32>,
}
impl Authorizer {
    /// <p>The identifier for the authorizer resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>[Required] The name of the authorizer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AuthorizerType> {
        self.r#type.as_ref()
    }
    /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
    pub fn provider_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.provider_ar_ns.as_deref()
    }
    /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
    pub fn auth_type(&self) -> std::option::Option<&str> {
        self.auth_type.as_deref()
    }
    /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
    pub fn authorizer_uri(&self) -> std::option::Option<&str> {
        self.authorizer_uri.as_deref()
    }
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
    pub fn authorizer_credentials(&self) -> std::option::Option<&str> {
        self.authorizer_credentials.as_deref()
    }
    /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
    pub fn identity_source(&self) -> std::option::Option<&str> {
        self.identity_source.as_deref()
    }
    /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
    pub fn identity_validation_expression(&self) -> std::option::Option<&str> {
        self.identity_validation_expression.as_deref()
    }
    /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
    pub fn authorizer_result_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.authorizer_result_ttl_in_seconds
    }
}
impl std::fmt::Debug for Authorizer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Authorizer");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("provider_ar_ns", &self.provider_ar_ns);
        formatter.field("auth_type", &self.auth_type);
        formatter.field("authorizer_uri", &self.authorizer_uri);
        formatter.field("authorizer_credentials", &self.authorizer_credentials);
        formatter.field("identity_source", &self.identity_source);
        formatter.field(
            "identity_validation_expression",
            &self.identity_validation_expression,
        );
        formatter.field(
            "authorizer_result_ttl_in_seconds",
            &self.authorizer_result_ttl_in_seconds,
        );
        formatter.finish()
    }
}
/// See [`Authorizer`](crate::model::Authorizer)
pub mod authorizer {
    /// A builder for [`Authorizer`](crate::model::Authorizer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AuthorizerType>,
        pub(crate) provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auth_type: std::option::Option<std::string::String>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) authorizer_credentials: std::option::Option<std::string::String>,
        pub(crate) identity_source: std::option::Option<std::string::String>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the authorizer resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the authorizer resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn r#type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_provider_ar_ns`](Self::set_provider_ar_ns).
        ///
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.provider_ar_ns = Some(v);
            self
        }
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn set_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.provider_ar_ns = input;
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn auth_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_type = Some(input.into());
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn set_auth_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_type = input;
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn authorizer_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_credentials = Some(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn set_authorizer_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_credentials = input;
            self
        }
        /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_source = Some(input.into());
            self
        }
        /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_source = input;
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`Authorizer`](crate::model::Authorizer)
        pub fn build(self) -> crate::model::Authorizer {
            crate::model::Authorizer {
                id: self.id,
                name: self.name,
                r#type: self.r#type,
                provider_ar_ns: self.provider_ar_ns,
                auth_type: self.auth_type,
                authorizer_uri: self.authorizer_uri,
                authorizer_credentials: self.authorizer_credentials,
                identity_source: self.identity_source,
                identity_validation_expression: self.identity_validation_expression,
                authorizer_result_ttl_in_seconds: self.authorizer_result_ttl_in_seconds,
            }
        }
    }
}
impl Authorizer {
    /// Creates a new builder-style object to manufacture [`Authorizer`](crate::model::Authorizer)
    pub fn builder() -> crate::model::authorizer::Builder {
        crate::model::authorizer::Builder::default()
    }
}

/// <p>A resource that can be distributed to callers for executing <a>Method</a> resources that require an API key. API keys can be mapped to any <a>Stage</a> on any <a>RestApi</a>, which indicates that the callers with the API key can make requests to that stage.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html">Use API Keys</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiKey {
    /// <p>The identifier of the API Key.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the API Key.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The name of the API Key.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
    pub customer_id: std::option::Option<std::string::String>,
    /// <p>The description of the API Key.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether the API Key can be used by callers.</p>
    pub enabled: bool,
    /// <p>The timestamp when the API Key was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the API Key was last updated.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>
    pub stage_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ApiKey {
    /// <p>The identifier of the API Key.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the API Key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The name of the API Key.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
    pub fn customer_id(&self) -> std::option::Option<&str> {
        self.customer_id.as_deref()
    }
    /// <p>The description of the API Key.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies whether the API Key can be used by callers.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The timestamp when the API Key was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The timestamp when the API Key was last updated.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
    /// <p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>
    pub fn stage_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.stage_keys.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ApiKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiKey");
        formatter.field("id", &self.id);
        formatter.field("value", &self.value);
        formatter.field("name", &self.name);
        formatter.field("customer_id", &self.customer_id);
        formatter.field("description", &self.description);
        formatter.field("enabled", &self.enabled);
        formatter.field("created_date", &self.created_date);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("stage_keys", &self.stage_keys);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ApiKey`](crate::model::ApiKey)
pub mod api_key {
    /// A builder for [`ApiKey`](crate::model::ApiKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) customer_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) stage_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the API Key.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the API Key.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the API Key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the API Key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The name of the API Key.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API Key.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn customer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_id = Some(input.into());
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn set_customer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.customer_id = input;
            self
        }
        /// <p>The description of the API Key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API Key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether the API Key can be used by callers.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the API Key can be used by callers.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The timestamp when the API Key was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API Key was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The timestamp when the API Key was last updated.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The timestamp when the API Key was last updated.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Appends an item to `stage_keys`.
        ///
        /// To override the contents of this collection use [`set_stage_keys`](Self::set_stage_keys).
        ///
        /// <p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>
        pub fn stage_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stage_keys.unwrap_or_default();
            v.push(input.into());
            self.stage_keys = Some(v);
            self
        }
        /// <p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>
        pub fn set_stage_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stage_keys = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiKey`](crate::model::ApiKey)
        pub fn build(self) -> crate::model::ApiKey {
            crate::model::ApiKey {
                id: self.id,
                value: self.value,
                name: self.name,
                customer_id: self.customer_id,
                description: self.description,
                enabled: self.enabled.unwrap_or_default(),
                created_date: self.created_date,
                last_updated_date: self.last_updated_date,
                stage_keys: self.stage_keys,
                tags: self.tags,
            }
        }
    }
}
impl ApiKey {
    /// Creates a new builder-style object to manufacture [`ApiKey`](crate::model::ApiKey)
    pub fn builder() -> crate::model::api_key::Builder {
        crate::model::api_key::Builder::default()
    }
}

/// <p>If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MutualTlsAuthenticationInput {
    /// <p>An Amazon S3 resource ARN that specifies the truststore for mutual TLS authentication,
    /// for example,
    /// <code>s3://bucket-name/key-name</code>.
    /// The truststore can contain certificates from public or private certificate authorities.
    /// To update the truststore, upload a new version to S3, and then update your custom domain
    /// name to use the new version. To update the truststore, you must have permissions to
    /// access the S3 object.</p>
    pub truststore_uri: std::option::Option<std::string::String>,
    /// <p>The version of the S3 object that contains your truststore. To
    /// specify a version, you must have versioning enabled for the S3 bucket.</p>
    pub truststore_version: std::option::Option<std::string::String>,
}
impl MutualTlsAuthenticationInput {
    /// <p>An Amazon S3 resource ARN that specifies the truststore for mutual TLS authentication,
    /// for example,
    /// <code>s3://bucket-name/key-name</code>.
    /// The truststore can contain certificates from public or private certificate authorities.
    /// To update the truststore, upload a new version to S3, and then update your custom domain
    /// name to use the new version. To update the truststore, you must have permissions to
    /// access the S3 object.</p>
    pub fn truststore_uri(&self) -> std::option::Option<&str> {
        self.truststore_uri.as_deref()
    }
    /// <p>The version of the S3 object that contains your truststore. To
    /// specify a version, you must have versioning enabled for the S3 bucket.</p>
    pub fn truststore_version(&self) -> std::option::Option<&str> {
        self.truststore_version.as_deref()
    }
}
impl std::fmt::Debug for MutualTlsAuthenticationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MutualTlsAuthenticationInput");
        formatter.field("truststore_uri", &self.truststore_uri);
        formatter.field("truststore_version", &self.truststore_version);
        formatter.finish()
    }
}
/// See [`MutualTlsAuthenticationInput`](crate::model::MutualTlsAuthenticationInput)
pub mod mutual_tls_authentication_input {
    /// A builder for [`MutualTlsAuthenticationInput`](crate::model::MutualTlsAuthenticationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) truststore_uri: std::option::Option<std::string::String>,
        pub(crate) truststore_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon S3 resource ARN that specifies the truststore for mutual TLS authentication,
        /// for example,
        /// <code>s3://bucket-name/key-name</code>.
        /// The truststore can contain certificates from public or private certificate authorities.
        /// To update the truststore, upload a new version to S3, and then update your custom domain
        /// name to use the new version. To update the truststore, you must have permissions to
        /// access the S3 object.</p>
        pub fn truststore_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.truststore_uri = Some(input.into());
            self
        }
        /// <p>An Amazon S3 resource ARN that specifies the truststore for mutual TLS authentication,
        /// for example,
        /// <code>s3://bucket-name/key-name</code>.
        /// The truststore can contain certificates from public or private certificate authorities.
        /// To update the truststore, upload a new version to S3, and then update your custom domain
        /// name to use the new version. To update the truststore, you must have permissions to
        /// access the S3 object.</p>
        pub fn set_truststore_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.truststore_uri = input;
            self
        }
        /// <p>The version of the S3 object that contains your truststore. To
        /// specify a version, you must have versioning enabled for the S3 bucket.</p>
        pub fn truststore_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.truststore_version = Some(input.into());
            self
        }
        /// <p>The version of the S3 object that contains your truststore. To
        /// specify a version, you must have versioning enabled for the S3 bucket.</p>
        pub fn set_truststore_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.truststore_version = input;
            self
        }
        /// Consumes the builder and constructs a [`MutualTlsAuthenticationInput`](crate::model::MutualTlsAuthenticationInput)
        pub fn build(self) -> crate::model::MutualTlsAuthenticationInput {
            crate::model::MutualTlsAuthenticationInput {
                truststore_uri: self.truststore_uri,
                truststore_version: self.truststore_version,
            }
        }
    }
}
impl MutualTlsAuthenticationInput {
    /// Creates a new builder-style object to manufacture [`MutualTlsAuthenticationInput`](crate::model::MutualTlsAuthenticationInput)
    pub fn builder() -> crate::model::mutual_tls_authentication_input::Builder {
        crate::model::mutual_tls_authentication_input::Builder::default()
    }
}

/// <p>The input configuration for a canary deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentCanarySettings {
    /// <p>The percentage (0.0-100.0) of traffic routed to the canary deployment.</p>
    pub percent_traffic: f64,
    /// <p>A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>
    pub stage_variable_overrides:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.</p>
    pub use_stage_cache: bool,
}
impl DeploymentCanarySettings {
    /// <p>The percentage (0.0-100.0) of traffic routed to the canary deployment.</p>
    pub fn percent_traffic(&self) -> f64 {
        self.percent_traffic
    }
    /// <p>A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>
    pub fn stage_variable_overrides(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.stage_variable_overrides.as_ref()
    }
    /// <p>A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.</p>
    pub fn use_stage_cache(&self) -> bool {
        self.use_stage_cache
    }
}
impl std::fmt::Debug for DeploymentCanarySettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentCanarySettings");
        formatter.field("percent_traffic", &self.percent_traffic);
        formatter.field("stage_variable_overrides", &self.stage_variable_overrides);
        formatter.field("use_stage_cache", &self.use_stage_cache);
        formatter.finish()
    }
}
/// See [`DeploymentCanarySettings`](crate::model::DeploymentCanarySettings)
pub mod deployment_canary_settings {
    /// A builder for [`DeploymentCanarySettings`](crate::model::DeploymentCanarySettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percent_traffic: std::option::Option<f64>,
        pub(crate) stage_variable_overrides: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) use_stage_cache: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The percentage (0.0-100.0) of traffic routed to the canary deployment.</p>
        pub fn percent_traffic(mut self, input: f64) -> Self {
            self.percent_traffic = Some(input);
            self
        }
        /// <p>The percentage (0.0-100.0) of traffic routed to the canary deployment.</p>
        pub fn set_percent_traffic(mut self, input: std::option::Option<f64>) -> Self {
            self.percent_traffic = input;
            self
        }
        /// Adds a key-value pair to `stage_variable_overrides`.
        ///
        /// To override the contents of this collection use [`set_stage_variable_overrides`](Self::set_stage_variable_overrides).
        ///
        /// <p>A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>
        pub fn stage_variable_overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variable_overrides.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variable_overrides = Some(hash_map);
            self
        }
        /// <p>A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>
        pub fn set_stage_variable_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variable_overrides = input;
            self
        }
        /// <p>A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.</p>
        pub fn use_stage_cache(mut self, input: bool) -> Self {
            self.use_stage_cache = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.</p>
        pub fn set_use_stage_cache(mut self, input: std::option::Option<bool>) -> Self {
            self.use_stage_cache = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentCanarySettings`](crate::model::DeploymentCanarySettings)
        pub fn build(self) -> crate::model::DeploymentCanarySettings {
            crate::model::DeploymentCanarySettings {
                percent_traffic: self.percent_traffic.unwrap_or_default(),
                stage_variable_overrides: self.stage_variable_overrides,
                use_stage_cache: self.use_stage_cache.unwrap_or_default(),
            }
        }
    }
}
impl DeploymentCanarySettings {
    /// Creates a new builder-style object to manufacture [`DeploymentCanarySettings`](crate::model::DeploymentCanarySettings)
    pub fn builder() -> crate::model::deployment_canary_settings::Builder {
        crate::model::deployment_canary_settings::Builder::default()
    }
}

/// <p>A reference to a unique stage identified in the format <code>{restApiId}/{stage}</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageKey {
    /// <p>The string identifier of the associated <a>RestApi</a>.</p>
    pub rest_api_id: std::option::Option<std::string::String>,
    /// <p>The stage name associated with the stage key.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl StageKey {
    /// <p>The string identifier of the associated <a>RestApi</a>.</p>
    pub fn rest_api_id(&self) -> std::option::Option<&str> {
        self.rest_api_id.as_deref()
    }
    /// <p>The stage name associated with the stage key.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for StageKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageKey");
        formatter.field("rest_api_id", &self.rest_api_id);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}
/// See [`StageKey`](crate::model::StageKey)
pub mod stage_key {
    /// A builder for [`StageKey`](crate::model::StageKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The stage name associated with the stage key.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The stage name associated with the stage key.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StageKey`](crate::model::StageKey)
        pub fn build(self) -> crate::model::StageKey {
            crate::model::StageKey {
                rest_api_id: self.rest_api_id,
                stage_name: self.stage_name,
            }
        }
    }
}
impl StageKey {
    /// Creates a new builder-style object to manufacture [`StageKey`](crate::model::StageKey)
    pub fn builder() -> crate::model::stage_key::Builder {
        crate::model::stage_key::Builder::default()
    }
}
