// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An API Gateway VPC link for a <a>RestApi</a> to access resources in an Amazon Virtual Private Cloud (VPC).</p>
/// <div class="remarks">
/// <p><p>To enable access to a resource in an Amazon Virtual Private Cloud through Amazon API Gateway, you, as an API developer, create a <a>VpcLink</a> resource targeted for one or more network load balancers of the VPC and then integrate an API method with a private integration that uses the <a>VpcLink</a>. The private integration has an integration type of <code>HTTP</code> or <code>HTTP_PROXY</code> and has a connection type of <code>VPC_LINK</code>. The integration uses the <code>connectionId</code> property to identify the <a>VpcLink</a> used.</p></p>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVpcLinkOutput {
    /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name used to label and identify the VPC link.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the VPC link.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    pub target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
    pub status: std::option::Option<crate::model::VpcLinkStatus>,
    /// <p>A description about the VPC link status.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateVpcLinkOutput {
    /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name used to label and identify the VPC link.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the VPC link.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    pub fn target_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.target_arns.as_deref()
    }
    /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VpcLinkStatus> {
        self.status.as_ref()
    }
    /// <p>A description about the VPC link status.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateVpcLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVpcLinkOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("target_arns", &self.target_arns);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput)
pub mod update_vpc_link_output {
    /// A builder for [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::VpcLinkStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name used to label and identify the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name used to label and identify the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `target_arns`.
        ///
        /// To override the contents of this collection use [`set_target_arns`](Self::set_target_arns).
        ///
        /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_arns.unwrap_or_default();
            v.push(input.into());
            self.target_arns = Some(v);
            self
        }
        /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn set_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_arns = input;
            self
        }
        /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
        pub fn status(mut self, input: crate::model::VpcLinkStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VpcLinkStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A description about the VPC link status.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A description about the VPC link status.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput)
        pub fn build(self) -> crate::output::UpdateVpcLinkOutput {
            crate::output::UpdateVpcLinkOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                target_arns: self.target_arns,
                status: self.status,
                status_message: self.status_message,
                tags: self.tags,
            }
        }
    }
}
impl UpdateVpcLinkOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVpcLinkOutput`](crate::output::UpdateVpcLinkOutput)
    pub fn builder() -> crate::output::update_vpc_link_output::Builder {
        crate::output::update_vpc_link_output::Builder::default()
    }
}

/// <p>Represents a usage plan than can specify who can assess associated API stages with specified request limits and quotas.</p>
/// <div class="remarks">
/// <p>In a usage plan, you associate an API by specifying the API's Id and a stage name of the specified API. You add plan customers by adding API keys to the plan. </p>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUsagePlanOutput {
    /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of a usage plan.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of a usage plan.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The associated API stages of a usage plan.</p>
    pub api_stages: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
    /// <p>The request throttle limits of a usage plan.</p>
    pub throttle: std::option::Option<crate::model::ThrottleSettings>,
    /// <p>The maximum number of permitted requests per a given unit time interval.</p>
    pub quota: std::option::Option<crate::model::QuotaSettings>,
    /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
    pub product_code: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateUsagePlanOutput {
    /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of a usage plan.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of a usage plan.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The associated API stages of a usage plan.</p>
    pub fn api_stages(&self) -> std::option::Option<&[crate::model::ApiStage]> {
        self.api_stages.as_deref()
    }
    /// <p>The request throttle limits of a usage plan.</p>
    pub fn throttle(&self) -> std::option::Option<&crate::model::ThrottleSettings> {
        self.throttle.as_ref()
    }
    /// <p>The maximum number of permitted requests per a given unit time interval.</p>
    pub fn quota(&self) -> std::option::Option<&crate::model::QuotaSettings> {
        self.quota.as_ref()
    }
    /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
    pub fn product_code(&self) -> std::option::Option<&str> {
        self.product_code.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateUsagePlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUsagePlanOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("api_stages", &self.api_stages);
        formatter.field("throttle", &self.throttle);
        formatter.field("quota", &self.quota);
        formatter.field("product_code", &self.product_code);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateUsagePlanOutput`](crate::output::UpdateUsagePlanOutput)
pub mod update_usage_plan_output {
    /// A builder for [`UpdateUsagePlanOutput`](crate::output::UpdateUsagePlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) api_stages: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        pub(crate) throttle: std::option::Option<crate::model::ThrottleSettings>,
        pub(crate) quota: std::option::Option<crate::model::QuotaSettings>,
        pub(crate) product_code: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of a usage plan.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a usage plan.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of a usage plan.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a usage plan.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `api_stages`.
        ///
        /// To override the contents of this collection use [`set_api_stages`](Self::set_api_stages).
        ///
        /// <p>The associated API stages of a usage plan.</p>
        pub fn api_stages(mut self, input: impl Into<crate::model::ApiStage>) -> Self {
            let mut v = self.api_stages.unwrap_or_default();
            v.push(input.into());
            self.api_stages = Some(v);
            self
        }
        /// <p>The associated API stages of a usage plan.</p>
        pub fn set_api_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        ) -> Self {
            self.api_stages = input;
            self
        }
        /// <p>The request throttle limits of a usage plan.</p>
        pub fn throttle(mut self, input: crate::model::ThrottleSettings) -> Self {
            self.throttle = Some(input);
            self
        }
        /// <p>The request throttle limits of a usage plan.</p>
        pub fn set_throttle(
            mut self,
            input: std::option::Option<crate::model::ThrottleSettings>,
        ) -> Self {
            self.throttle = input;
            self
        }
        /// <p>The maximum number of permitted requests per a given unit time interval.</p>
        pub fn quota(mut self, input: crate::model::QuotaSettings) -> Self {
            self.quota = Some(input);
            self
        }
        /// <p>The maximum number of permitted requests per a given unit time interval.</p>
        pub fn set_quota(
            mut self,
            input: std::option::Option<crate::model::QuotaSettings>,
        ) -> Self {
            self.quota = input;
            self
        }
        /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code = Some(input.into());
            self
        }
        /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_code = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUsagePlanOutput`](crate::output::UpdateUsagePlanOutput)
        pub fn build(self) -> crate::output::UpdateUsagePlanOutput {
            crate::output::UpdateUsagePlanOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                api_stages: self.api_stages,
                throttle: self.throttle,
                quota: self.quota,
                product_code: self.product_code,
                tags: self.tags,
            }
        }
    }
}
impl UpdateUsagePlanOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUsagePlanOutput`](crate::output::UpdateUsagePlanOutput)
    pub fn builder() -> crate::output::update_usage_plan_output::Builder {
        crate::output::update_usage_plan_output::Builder::default()
    }
}

/// <p>Represents the usage data of a usage plan.</p>
/// <div class="remarks"></div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>,
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-usage-plans-with-console.html#api-gateway-usage-plan-manage-usage">Manage Usage in a Usage Plan</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUsageOutput {
    /// <p>The plan Id associated with this usage data.</p>
    pub usage_plan_id: std::option::Option<std::string::String>,
    /// <p>The starting date of the usage data.</p>
    pub start_date: std::option::Option<std::string::String>,
    /// <p>The ending date of the usage data.</p>
    pub end_date: std::option::Option<std::string::String>,
    /// <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
    pub items: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::vec::Vec<i64>>>,
    >,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl UpdateUsageOutput {
    /// <p>The plan Id associated with this usage data.</p>
    pub fn usage_plan_id(&self) -> std::option::Option<&str> {
        self.usage_plan_id.as_deref()
    }
    /// <p>The starting date of the usage data.</p>
    pub fn start_date(&self) -> std::option::Option<&str> {
        self.start_date.as_deref()
    }
    /// <p>The ending date of the usage data.</p>
    pub fn end_date(&self) -> std::option::Option<&str> {
        self.end_date.as_deref()
    }
    /// <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
    pub fn items(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::vec::Vec<i64>>>,
    > {
        self.items.as_ref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for UpdateUsageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUsageOutput");
        formatter.field("usage_plan_id", &self.usage_plan_id);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`UpdateUsageOutput`](crate::output::UpdateUsageOutput)
pub mod update_usage_output {
    /// A builder for [`UpdateUsageOutput`](crate::output::UpdateUsageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_plan_id: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) end_date: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::vec::Vec<i64>>>,
        >,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The plan Id associated with this usage data.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_plan_id = Some(input.into());
            self
        }
        /// <p>The plan Id associated with this usage data.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_plan_id = input;
            self
        }
        /// <p>The starting date of the usage data.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The starting date of the usage data.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The ending date of the usage data.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date = Some(input.into());
            self
        }
        /// <p>The ending date of the usage data.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_date = input;
            self
        }
        /// Adds a key-value pair to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
        pub fn items(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::vec::Vec<i64>>>,
        ) -> Self {
            let mut hash_map = self.items.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.items = Some(hash_map);
            self
        }
        /// <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::vec::Vec<i64>>>,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUsageOutput`](crate::output::UpdateUsageOutput)
        pub fn build(self) -> crate::output::UpdateUsageOutput {
            crate::output::UpdateUsageOutput {
                usage_plan_id: self.usage_plan_id,
                start_date: self.start_date,
                end_date: self.end_date,
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl UpdateUsageOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUsageOutput`](crate::output::UpdateUsageOutput)
    pub fn builder() -> crate::output::update_usage_output::Builder {
        crate::output::update_usage_output::Builder::default()
    }
}

/// <p>Represents a unique identifier for a version of a deployed <a>RestApi</a> that is callable by users.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html">Deploy an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStageOutput {
    /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The identifier of a client certificate for an API stage.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The stage's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
    pub cache_cluster_enabled: bool,
    /// <p>The size of the cache cluster for the stage, if enabled.</p>
    pub cache_cluster_size: std::option::Option<crate::model::CacheClusterSize>,
    /// <p>The status of the cache cluster for the stage, if enabled.</p>
    pub cache_cluster_status: std::option::Option<crate::model::CacheClusterStatus>,
    /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
    pub method_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
    >,
    /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
    /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
    pub variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The version of the associated API documentation.</p>
    pub documentation_version: std::option::Option<std::string::String>,
    /// <p>Settings for logging access in this stage.</p>
    pub access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
    /// <p>Settings for the canary deployment in this stage.</p>
    pub canary_settings: std::option::Option<crate::model::CanarySettings>,
    /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
    pub tracing_enabled: bool,
    /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
    pub web_acl_arn: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The timestamp when the stage was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when the stage last updated.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
}
impl UpdateStageOutput {
    /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The identifier of a client certificate for an API stage.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The stage's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
    pub fn cache_cluster_enabled(&self) -> bool {
        self.cache_cluster_enabled
    }
    /// <p>The size of the cache cluster for the stage, if enabled.</p>
    pub fn cache_cluster_size(&self) -> std::option::Option<&crate::model::CacheClusterSize> {
        self.cache_cluster_size.as_ref()
    }
    /// <p>The status of the cache cluster for the stage, if enabled.</p>
    pub fn cache_cluster_status(&self) -> std::option::Option<&crate::model::CacheClusterStatus> {
        self.cache_cluster_status.as_ref()
    }
    /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
    pub fn method_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
    > {
        self.method_settings.as_ref()
    }
    /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
    /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
    pub fn variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.variables.as_ref()
    }
    /// <p>The version of the associated API documentation.</p>
    pub fn documentation_version(&self) -> std::option::Option<&str> {
        self.documentation_version.as_deref()
    }
    /// <p>Settings for logging access in this stage.</p>
    pub fn access_log_settings(&self) -> std::option::Option<&crate::model::AccessLogSettings> {
        self.access_log_settings.as_ref()
    }
    /// <p>Settings for the canary deployment in this stage.</p>
    pub fn canary_settings(&self) -> std::option::Option<&crate::model::CanarySettings> {
        self.canary_settings.as_ref()
    }
    /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
    pub fn tracing_enabled(&self) -> bool {
        self.tracing_enabled
    }
    /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
    pub fn web_acl_arn(&self) -> std::option::Option<&str> {
        self.web_acl_arn.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The timestamp when the stage was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The timestamp when the stage last updated.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
}
impl std::fmt::Debug for UpdateStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStageOutput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("description", &self.description);
        formatter.field("cache_cluster_enabled", &self.cache_cluster_enabled);
        formatter.field("cache_cluster_size", &self.cache_cluster_size);
        formatter.field("cache_cluster_status", &self.cache_cluster_status);
        formatter.field("method_settings", &self.method_settings);
        formatter.field("variables", &self.variables);
        formatter.field("documentation_version", &self.documentation_version);
        formatter.field("access_log_settings", &self.access_log_settings);
        formatter.field("canary_settings", &self.canary_settings);
        formatter.field("tracing_enabled", &self.tracing_enabled);
        formatter.field("web_acl_arn", &self.web_acl_arn);
        formatter.field("tags", &self.tags);
        formatter.field("created_date", &self.created_date);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.finish()
    }
}
/// See [`UpdateStageOutput`](crate::output::UpdateStageOutput)
pub mod update_stage_output {
    /// A builder for [`UpdateStageOutput`](crate::output::UpdateStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_enabled: std::option::Option<bool>,
        pub(crate) cache_cluster_size: std::option::Option<crate::model::CacheClusterSize>,
        pub(crate) cache_cluster_status: std::option::Option<crate::model::CacheClusterStatus>,
        pub(crate) method_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
        >,
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) documentation_version: std::option::Option<std::string::String>,
        pub(crate) access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
        pub(crate) canary_settings: std::option::Option<crate::model::CanarySettings>,
        pub(crate) tracing_enabled: std::option::Option<bool>,
        pub(crate) web_acl_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The identifier of a client certificate for an API stage.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of a client certificate for an API stage.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The stage's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The stage's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
        pub fn cache_cluster_enabled(mut self, input: bool) -> Self {
            self.cache_cluster_enabled = Some(input);
            self
        }
        /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
        pub fn set_cache_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cache_cluster_enabled = input;
            self
        }
        /// <p>The size of the cache cluster for the stage, if enabled.</p>
        pub fn cache_cluster_size(mut self, input: crate::model::CacheClusterSize) -> Self {
            self.cache_cluster_size = Some(input);
            self
        }
        /// <p>The size of the cache cluster for the stage, if enabled.</p>
        pub fn set_cache_cluster_size(
            mut self,
            input: std::option::Option<crate::model::CacheClusterSize>,
        ) -> Self {
            self.cache_cluster_size = input;
            self
        }
        /// <p>The status of the cache cluster for the stage, if enabled.</p>
        pub fn cache_cluster_status(mut self, input: crate::model::CacheClusterStatus) -> Self {
            self.cache_cluster_status = Some(input);
            self
        }
        /// <p>The status of the cache cluster for the stage, if enabled.</p>
        pub fn set_cache_cluster_status(
            mut self,
            input: std::option::Option<crate::model::CacheClusterStatus>,
        ) -> Self {
            self.cache_cluster_status = input;
            self
        }
        /// Adds a key-value pair to `method_settings`.
        ///
        /// To override the contents of this collection use [`set_method_settings`](Self::set_method_settings).
        ///
        /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
        pub fn method_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MethodSetting>,
        ) -> Self {
            let mut hash_map = self.method_settings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.method_settings = Some(hash_map);
            self
        }
        /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
        pub fn set_method_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
            >,
        ) -> Self {
            self.method_settings = input;
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
        /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
        /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.documentation_version = Some(input.into());
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documentation_version = input;
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.access_log_settings = Some(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.access_log_settings = input;
            self
        }
        /// <p>Settings for the canary deployment in this stage.</p>
        pub fn canary_settings(mut self, input: crate::model::CanarySettings) -> Self {
            self.canary_settings = Some(input);
            self
        }
        /// <p>Settings for the canary deployment in this stage.</p>
        pub fn set_canary_settings(
            mut self,
            input: std::option::Option<crate::model::CanarySettings>,
        ) -> Self {
            self.canary_settings = input;
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn tracing_enabled(mut self, input: bool) -> Self {
            self.tracing_enabled = Some(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn set_tracing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.tracing_enabled = input;
            self
        }
        /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_acl_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_acl_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The timestamp when the stage last updated.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage last updated.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStageOutput`](crate::output::UpdateStageOutput)
        pub fn build(self) -> crate::output::UpdateStageOutput {
            crate::output::UpdateStageOutput {
                deployment_id: self.deployment_id,
                client_certificate_id: self.client_certificate_id,
                stage_name: self.stage_name,
                description: self.description,
                cache_cluster_enabled: self.cache_cluster_enabled.unwrap_or_default(),
                cache_cluster_size: self.cache_cluster_size,
                cache_cluster_status: self.cache_cluster_status,
                method_settings: self.method_settings,
                variables: self.variables,
                documentation_version: self.documentation_version,
                access_log_settings: self.access_log_settings,
                canary_settings: self.canary_settings,
                tracing_enabled: self.tracing_enabled.unwrap_or_default(),
                web_acl_arn: self.web_acl_arn,
                tags: self.tags,
                created_date: self.created_date,
                last_updated_date: self.last_updated_date,
            }
        }
    }
}
impl UpdateStageOutput {
    /// Creates a new builder-style object to manufacture [`UpdateStageOutput`](crate::output::UpdateStageOutput)
    pub fn builder() -> crate::output::update_stage_output::Builder {
        crate::output::update_stage_output::Builder::default()
    }
}

/// <p>Represents a REST API.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRestApiOutput {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The API's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub minimum_compression_size: std::option::Option<i32>,
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
}
impl UpdateRestApiOutput {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The API's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub fn binary_media_types(&self) -> std::option::Option<&[std::string::String]> {
        self.binary_media_types.as_deref()
    }
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub fn minimum_compression_size(&self) -> std::option::Option<i32> {
        self.minimum_compression_size
    }
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub fn api_key_source(&self) -> std::option::Option<&crate::model::ApiKeySourceType> {
        self.api_key_source.as_ref()
    }
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
}
impl std::fmt::Debug for UpdateRestApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRestApiOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.field("binary_media_types", &self.binary_media_types);
        formatter.field("minimum_compression_size", &self.minimum_compression_size);
        formatter.field("api_key_source", &self.api_key_source);
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("policy", &self.policy);
        formatter.field("tags", &self.tags);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.finish()
    }
}
/// See [`UpdateRestApiOutput`](crate::output::UpdateRestApiOutput)
pub mod update_rest_api_output {
    /// A builder for [`UpdateRestApiOutput`](crate::output::UpdateRestApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_compression_size: std::option::Option<i32>,
        pub(crate) api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The API's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The API's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The API's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Appends an item to `binary_media_types`.
        ///
        /// To override the contents of this collection use [`set_binary_media_types`](Self::set_binary_media_types).
        ///
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn binary_media_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.binary_media_types.unwrap_or_default();
            v.push(input.into());
            self.binary_media_types = Some(v);
            self
        }
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn set_binary_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.binary_media_types = input;
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn minimum_compression_size(mut self, input: i32) -> Self {
            self.minimum_compression_size = Some(input);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn set_minimum_compression_size(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_compression_size = input;
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn api_key_source(mut self, input: crate::model::ApiKeySourceType) -> Self {
            self.api_key_source = Some(input);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn set_api_key_source(
            mut self,
            input: std::option::Option<crate::model::ApiKeySourceType>,
        ) -> Self {
            self.api_key_source = input;
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRestApiOutput`](crate::output::UpdateRestApiOutput)
        pub fn build(self) -> crate::output::UpdateRestApiOutput {
            crate::output::UpdateRestApiOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                created_date: self.created_date,
                version: self.version,
                warnings: self.warnings,
                binary_media_types: self.binary_media_types,
                minimum_compression_size: self.minimum_compression_size,
                api_key_source: self.api_key_source,
                endpoint_configuration: self.endpoint_configuration,
                policy: self.policy,
                tags: self.tags,
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
            }
        }
    }
}
impl UpdateRestApiOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRestApiOutput`](crate::output::UpdateRestApiOutput)
    pub fn builder() -> crate::output::update_rest_api_output::Builder {
        crate::output::update_rest_api_output::Builder::default()
    }
}

/// <p>Represents an API resource.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceOutput {
    /// <p>The resource's identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The parent resource's identifier.</p>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>The last path segment for this resource.</p>
    pub path_part: std::option::Option<std::string::String>,
    /// <p>The full path for this resource.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Gets an API resource's method of a given HTTP verb.</p>
    /// <div class="remarks">
    /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
    /// <h4>Example: Get the GET method of an API resource</h4>
    /// <h5>Request</h5>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20170223T031827Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
    /// "name": "method",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
    /// "name": "GET",
    /// "title": "GET"
    /// },
    /// "integration:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "method:integration": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "method:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "methodresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "apiKeyRequired": false,
    /// "authorizationType": "NONE",
    /// "httpMethod": "GET",
    /// "_embedded": {
    /// "method:integration": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "3kzxbg5sa2",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestParameters": {
    /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
    /// },
    /// "requestTemplates": {
    /// "application/json": "{\n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// },
    /// "method:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": false
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
    /// </div>
    /// <div class="seeAlso">
    /// </div>
    pub resource_methods:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Method>>,
}
impl UpdateResourceOutput {
    /// <p>The resource's identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The parent resource's identifier.</p>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>The last path segment for this resource.</p>
    pub fn path_part(&self) -> std::option::Option<&str> {
        self.path_part.as_deref()
    }
    /// <p>The full path for this resource.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>Gets an API resource's method of a given HTTP verb.</p>
    /// <div class="remarks">
    /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
    /// <h4>Example: Get the GET method of an API resource</h4>
    /// <h5>Request</h5>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20170223T031827Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
    /// "name": "method",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
    /// "name": "GET",
    /// "title": "GET"
    /// },
    /// "integration:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "method:integration": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "method:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "methodresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "apiKeyRequired": false,
    /// "authorizationType": "NONE",
    /// "httpMethod": "GET",
    /// "_embedded": {
    /// "method:integration": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "3kzxbg5sa2",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestParameters": {
    /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
    /// },
    /// "requestTemplates": {
    /// "application/json": "{\n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// },
    /// "method:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": false
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
    /// </div>
    /// <div class="seeAlso">
    /// </div>
    pub fn resource_methods(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Method>>
    {
        self.resource_methods.as_ref()
    }
}
impl std::fmt::Debug for UpdateResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceOutput");
        formatter.field("id", &self.id);
        formatter.field("parent_id", &self.parent_id);
        formatter.field("path_part", &self.path_part);
        formatter.field("path", &self.path);
        formatter.field("resource_methods", &self.resource_methods);
        formatter.finish()
    }
}
/// See [`UpdateResourceOutput`](crate::output::UpdateResourceOutput)
pub mod update_resource_output {
    /// A builder for [`UpdateResourceOutput`](crate::output::UpdateResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) path_part: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) resource_methods: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Method>,
        >,
    }
    impl Builder {
        /// <p>The resource's identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The resource's identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The parent resource's identifier.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The parent resource's identifier.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn path_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_part = Some(input.into());
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn set_path_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_part = input;
            self
        }
        /// <p>The full path for this resource.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The full path for this resource.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Adds a key-value pair to `resource_methods`.
        ///
        /// To override the contents of this collection use [`set_resource_methods`](Self::set_resource_methods).
        ///
        /// <p>Gets an API resource's method of a given HTTP verb.</p>
        /// <div class="remarks">
        /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
        /// <h4>Example: Get the GET method of an API resource</h4>
        /// <h5>Request</h5>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20170223T031827Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
        /// "name": "method",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
        /// "name": "GET",
        /// "title": "GET"
        /// },
        /// "integration:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "method:integration": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "method:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "methodresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "apiKeyRequired": false,
        /// "authorizationType": "NONE",
        /// "httpMethod": "GET",
        /// "_embedded": {
        /// "method:integration": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "3kzxbg5sa2",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestParameters": {
        /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
        /// },
        /// "requestTemplates": {
        /// "application/json": "{\n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// },
        /// "method:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": false
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
        /// </div>
        /// <div class="seeAlso">
        /// </div>
        pub fn resource_methods(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Method>,
        ) -> Self {
            let mut hash_map = self.resource_methods.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_methods = Some(hash_map);
            self
        }
        /// <p>Gets an API resource's method of a given HTTP verb.</p>
        /// <div class="remarks">
        /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
        /// <h4>Example: Get the GET method of an API resource</h4>
        /// <h5>Request</h5>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20170223T031827Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
        /// "name": "method",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
        /// "name": "GET",
        /// "title": "GET"
        /// },
        /// "integration:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "method:integration": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "method:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "methodresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "apiKeyRequired": false,
        /// "authorizationType": "NONE",
        /// "httpMethod": "GET",
        /// "_embedded": {
        /// "method:integration": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "3kzxbg5sa2",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestParameters": {
        /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
        /// },
        /// "requestTemplates": {
        /// "application/json": "{\n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// },
        /// "method:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": false
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
        /// </div>
        /// <div class="seeAlso">
        /// </div>
        pub fn set_resource_methods(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Method>,
            >,
        ) -> Self {
            self.resource_methods = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceOutput`](crate::output::UpdateResourceOutput)
        pub fn build(self) -> crate::output::UpdateResourceOutput {
            crate::output::UpdateResourceOutput {
                id: self.id,
                parent_id: self.parent_id,
                path_part: self.path_part,
                path: self.path,
                resource_methods: self.resource_methods,
            }
        }
    }
}
impl UpdateResourceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResourceOutput`](crate::output::UpdateResourceOutput)
    pub fn builder() -> crate::output::update_resource_output::Builder {
        crate::output::update_resource_output::Builder::default()
    }
}

/// <p>A set of validation rules for incoming <a>Method</a> requests.</p>
/// <div class="remarks">
/// <p>In OpenAPI, a <a>RequestValidator</a> of an API is defined by the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.requestValidator.html">x-amazon-apigateway-request-validators.requestValidator</a> object. It the referenced using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validator">x-amazon-apigateway-request-validator</a> property.</p>
/// </div>
/// <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html">Enable Basic Request Validation in API Gateway</a></div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRequestValidatorOutput {
    /// <p>The identifier of this <a>RequestValidator</a>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of this <a>RequestValidator</a></p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
    pub validate_request_body: bool,
    /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
    pub validate_request_parameters: bool,
}
impl UpdateRequestValidatorOutput {
    /// <p>The identifier of this <a>RequestValidator</a>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of this <a>RequestValidator</a></p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
    pub fn validate_request_body(&self) -> bool {
        self.validate_request_body
    }
    /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
    pub fn validate_request_parameters(&self) -> bool {
        self.validate_request_parameters
    }
}
impl std::fmt::Debug for UpdateRequestValidatorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRequestValidatorOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("validate_request_body", &self.validate_request_body);
        formatter.field(
            "validate_request_parameters",
            &self.validate_request_parameters,
        );
        formatter.finish()
    }
}
/// See [`UpdateRequestValidatorOutput`](crate::output::UpdateRequestValidatorOutput)
pub mod update_request_validator_output {
    /// A builder for [`UpdateRequestValidatorOutput`](crate::output::UpdateRequestValidatorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) validate_request_body: std::option::Option<bool>,
        pub(crate) validate_request_parameters: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of this <a>RequestValidator</a>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of this <a>RequestValidator</a>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of this <a>RequestValidator</a></p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this <a>RequestValidator</a></p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
        pub fn validate_request_body(mut self, input: bool) -> Self {
            self.validate_request_body = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
        pub fn set_validate_request_body(mut self, input: std::option::Option<bool>) -> Self {
            self.validate_request_body = input;
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
        pub fn validate_request_parameters(mut self, input: bool) -> Self {
            self.validate_request_parameters = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
        pub fn set_validate_request_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.validate_request_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRequestValidatorOutput`](crate::output::UpdateRequestValidatorOutput)
        pub fn build(self) -> crate::output::UpdateRequestValidatorOutput {
            crate::output::UpdateRequestValidatorOutput {
                id: self.id,
                name: self.name,
                validate_request_body: self.validate_request_body.unwrap_or_default(),
                validate_request_parameters: self.validate_request_parameters.unwrap_or_default(),
            }
        }
    }
}
impl UpdateRequestValidatorOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRequestValidatorOutput`](crate::output::UpdateRequestValidatorOutput)
    pub fn builder() -> crate::output::update_request_validator_output::Builder {
        crate::output::update_request_validator_output::Builder::default()
    }
}

/// <p>Represents the data structure of a method's request or response payload.</p>
/// <div class="remarks">
/// <p>A request model defines the data structure of the client-supplied request payload. A response model defines the data structure of the response payload returned by the back end. Although not required, models are useful for mapping payloads between the front end and back end.</p>
/// <p>A model is used for generating an API's SDK, validating the input request body, and creating a skeletal mapping template.</p>
/// </div>
/// <div class="seeAlso">
/// <a>Method</a>, <a>MethodResponse</a>, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html">Models and Mappings</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelOutput {
    /// <p>The identifier for the model resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the model. Must be an alphanumeric string.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The content-type for the model.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl UpdateModelOutput {
    /// <p>The identifier for the model resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the model. Must be an alphanumeric string.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The content-type for the model.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for UpdateModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("schema", &self.schema);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`UpdateModelOutput`](crate::output::UpdateModelOutput)
pub mod update_model_output {
    /// A builder for [`UpdateModelOutput`](crate::output::UpdateModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the model resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the model resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the model. Must be an alphanumeric string.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model. Must be an alphanumeric string.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>The content-type for the model.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type for the model.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateModelOutput`](crate::output::UpdateModelOutput)
        pub fn build(self) -> crate::output::UpdateModelOutput {
            crate::output::UpdateModelOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                schema: self.schema,
                content_type: self.content_type,
            }
        }
    }
}
impl UpdateModelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateModelOutput`](crate::output::UpdateModelOutput)
    pub fn builder() -> crate::output::update_model_output::Builder {
        crate::output::update_model_output::Builder::default()
    }
}

/// <p>Represents a method response of a given HTTP status code returned to the client. The method response is passed from the back end through the associated integration response that can be transformed using a mapping template. <!-- API Gateway sends back the status code to the caller as the HTTP status code. Parameters and models can be used to transform the response from the method's integration.--></p>
/// <div class="remarks">
/// <p></p>
/// <h4>Example: A <b>MethodResponse</b> instance of an API</h4>
/// <h5>Request</h5>
/// <p>The example request retrieves a <b>MethodResponse</b> of the 200 status code.</p>
/// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200 HTTP/1.1
/// Content-Type: application/json
/// Host: apigateway.us-east-1.amazonaws.com
/// X-Amz-Date: 20160603T222952Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
/// <h5>Response</h5>
/// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
/// "name": "methodresponse",
/// "templated": true
/// },
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "title": "200"
/// },
/// "methodresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// },
/// "methodresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// }
/// },
/// "responseModels": {
/// "application/json": "Empty"
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": false
/// },
/// "statusCode": "200"
/// }</code></pre>
/// <p></p>
/// </div>
/// <div class="seeAlso">
/// <a>Method</a>, <a>IntegrationResponse</a>, <a>Integration</a>
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMethodResponseOutput {
    /// <p>The method response's status code.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateMethodResponseOutput {
    /// <p>The method response's status code.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.response_parameters.as_ref()
    }
    /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
}
impl std::fmt::Debug for UpdateMethodResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMethodResponseOutput");
        formatter.field("status_code", &self.status_code);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_models", &self.response_models);
        formatter.finish()
    }
}
/// See [`UpdateMethodResponseOutput`](crate::output::UpdateMethodResponseOutput)
pub mod update_method_response_output {
    /// A builder for [`UpdateMethodResponseOutput`](crate::output::UpdateMethodResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The method response's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The method response's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMethodResponseOutput`](crate::output::UpdateMethodResponseOutput)
        pub fn build(self) -> crate::output::UpdateMethodResponseOutput {
            crate::output::UpdateMethodResponseOutput {
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_models: self.response_models,
            }
        }
    }
}
impl UpdateMethodResponseOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMethodResponseOutput`](crate::output::UpdateMethodResponseOutput)
    pub fn builder() -> crate::output::update_method_response_output::Builder {
        crate::output::update_method_response_output::Builder::default()
    }
}

/// <p>
/// Represents a client-facing interface by which the client calls the API to access back-end resources. A <b>Method</b> resource is
/// integrated with an <a>Integration</a> resource. Both consist of a request and one or more responses. The method request takes
/// the client input that is passed to the back end through the integration request. A method response returns the output from
/// the back end to the client through an integration response. A method request is embodied in a <b>Method</b> resource, whereas
/// an integration request is embodied in an <a>Integration</a> resource.  On the other hand, a method response is represented
/// by a <a>MethodResponse</a> resource, whereas an integration response is represented by an <a>IntegrationResponse</a> resource.
/// </p>
/// <div class="remarks">
/// <p></p>
/// <h4>Example: Retrive the GET method on a specified resource</h4>
/// <h5>Request</h5>
/// <p>The following example request retrieves the information about the GET method on an API resource (<code>3kzxbg5sa2</code>) of an API (<code>fugvjdxtri</code>). </p>
/// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
/// Content-Type: application/json
/// Host: apigateway.us-east-1.amazonaws.com
/// X-Amz-Date: 20160603T210259Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
/// <h5>Response</h5>
/// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": [
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
/// "name": "integration",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
/// "name": "integrationresponse",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
/// "name": "method",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
/// "name": "methodresponse",
/// "templated": true
/// }
/// ],
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
/// "name": "GET",
/// "title": "GET"
/// },
/// "integration:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "method:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
/// },
/// "method:integration": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "method:responses": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "method:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
/// },
/// "methodresponse:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
/// "templated": true
/// }
/// },
/// "apiKeyRequired": true,
/// "authorizationType": "NONE",
/// "httpMethod": "GET",
/// "_embedded": {
/// "method:integration": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integration:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integration:responses": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "integration:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integrationresponse:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
/// "templated": true
/// }
/// },
/// "cacheKeyParameters": [],
/// "cacheNamespace": "3kzxbg5sa2",
/// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
/// "httpMethod": "POST",
/// "passthroughBehavior": "WHEN_NO_MATCH",
/// "requestParameters": {
/// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
/// },
/// "requestTemplates": {
/// "application/json": "{\n}"
/// },
/// "type": "AWS",
/// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
/// "_embedded": {
/// "integration:responses": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "integrationresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
/// },
/// "integrationresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
/// }
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": "'application/xml'"
/// },
/// "responseTemplates": {
/// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E\")"
/// },
/// "statusCode": "200"
/// }
/// }
/// },
/// "method:responses": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "methodresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// },
/// "methodresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// }
/// },
/// "responseModels": {
/// "application/json": "Empty"
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": false
/// },
/// "statusCode": "200"
/// }
/// }
/// }</code></pre>
/// <p>In the example above, the response template for the <code>200 OK</code> response maps the JSON output from the <code>ListStreams</code> action in the back end to an XML output. The mapping template is URL-encoded as <code>%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E</code> and the output is decoded using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#util-templat-reference">$util.urlDecode()</a> helper function.</p>
/// </div>
/// <div class="seeAlso">
/// <a>MethodResponse</a>, <a>Integration</a>, <a>IntegrationResponse</a>, <a>Resource</a>,
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-method-settings.html">Set up an API's method</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMethodOutput {
    /// <p>The method's HTTP verb.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub authorization_type: std::option::Option<std::string::String>,
    /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
    pub api_key_required: std::option::Option<bool>,
    /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
    pub request_validator_id: std::option::Option<std::string::String>,
    /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Gets a method response associated with a given HTTP status code. </p>
    /// <div class="remarks">
    /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
    /// <h4>Example: Get a 200 OK response of a GET method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T215008Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": false,
    /// "method.response.header.operand_2": false,
    /// "method.response.header.operand_1": false
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
    /// </div>
    pub method_responses: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
    >,
    /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: </h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T213210Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "0cjtch",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestTemplates": {
    /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": "integration.response.body.op",
    /// "method.response.header.operand_2": "integration.response.body.b",
    /// "method.response.header.operand_1": "integration.response.body.a"
    /// },
    /// "responseTemplates": {
    /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
    /// },
    /// "selectionPattern": "",
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
    /// </div>
    pub method_integration: std::option::Option<crate::model::Integration>,
    /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateMethodOutput {
    /// <p>The method's HTTP verb.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub fn authorization_type(&self) -> std::option::Option<&str> {
        self.authorization_type.as_deref()
    }
    /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
    pub fn api_key_required(&self) -> std::option::Option<bool> {
        self.api_key_required
    }
    /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
    pub fn request_validator_id(&self) -> std::option::Option<&str> {
        self.request_validator_id.as_deref()
    }
    /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.request_parameters.as_ref()
    }
    /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>Gets a method response associated with a given HTTP status code. </p>
    /// <div class="remarks">
    /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
    /// <h4>Example: Get a 200 OK response of a GET method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T215008Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": false,
    /// "method.response.header.operand_2": false,
    /// "method.response.header.operand_1": false
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
    /// </div>
    pub fn method_responses(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
    > {
        self.method_responses.as_ref()
    }
    /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: </h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T213210Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "0cjtch",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestTemplates": {
    /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": "integration.response.body.op",
    /// "method.response.header.operand_2": "integration.response.body.b",
    /// "method.response.header.operand_1": "integration.response.body.a"
    /// },
    /// "responseTemplates": {
    /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
    /// },
    /// "selectionPattern": "",
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
    /// </div>
    pub fn method_integration(&self) -> std::option::Option<&crate::model::Integration> {
        self.method_integration.as_ref()
    }
    /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
}
impl std::fmt::Debug for UpdateMethodOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMethodOutput");
        formatter.field("http_method", &self.http_method);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("request_validator_id", &self.request_validator_id);
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_models", &self.request_models);
        formatter.field("method_responses", &self.method_responses);
        formatter.field("method_integration", &self.method_integration);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.finish()
    }
}
/// See [`UpdateMethodOutput`](crate::output::UpdateMethodOutput)
pub mod update_method_output {
    /// A builder for [`UpdateMethodOutput`](crate::output::UpdateMethodOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) authorization_type: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) request_validator_id: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) method_responses: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
        >,
        pub(crate) method_integration: std::option::Option<crate::model::Integration>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The method's HTTP verb.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>The method's HTTP verb.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn authorization_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_type = Some(input.into());
            self
        }
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_validator_id = Some(input.into());
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_validator_id = input;
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `method_responses`.
        ///
        /// To override the contents of this collection use [`set_method_responses`](Self::set_method_responses).
        ///
        /// <p>Gets a method response associated with a given HTTP status code. </p>
        /// <div class="remarks">
        /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
        /// <h4>Example: Get a 200 OK response of a GET method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T215008Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": false,
        /// "method.response.header.operand_2": false,
        /// "method.response.header.operand_1": false
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
        /// </div>
        pub fn method_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MethodResponse>,
        ) -> Self {
            let mut hash_map = self.method_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.method_responses = Some(hash_map);
            self
        }
        /// <p>Gets a method response associated with a given HTTP status code. </p>
        /// <div class="remarks">
        /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
        /// <h4>Example: Get a 200 OK response of a GET method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T215008Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": false,
        /// "method.response.header.operand_2": false,
        /// "method.response.header.operand_1": false
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
        /// </div>
        pub fn set_method_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
            >,
        ) -> Self {
            self.method_responses = input;
            self
        }
        /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: </h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T213210Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "0cjtch",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestTemplates": {
        /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": "integration.response.body.op",
        /// "method.response.header.operand_2": "integration.response.body.b",
        /// "method.response.header.operand_1": "integration.response.body.a"
        /// },
        /// "responseTemplates": {
        /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
        /// },
        /// "selectionPattern": "",
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
        /// </div>
        pub fn method_integration(mut self, input: crate::model::Integration) -> Self {
            self.method_integration = Some(input);
            self
        }
        /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: </h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T213210Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "0cjtch",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestTemplates": {
        /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": "integration.response.body.op",
        /// "method.response.header.operand_2": "integration.response.body.b",
        /// "method.response.header.operand_1": "integration.response.body.a"
        /// },
        /// "responseTemplates": {
        /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
        /// },
        /// "selectionPattern": "",
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
        /// </div>
        pub fn set_method_integration(
            mut self,
            input: std::option::Option<crate::model::Integration>,
        ) -> Self {
            self.method_integration = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMethodOutput`](crate::output::UpdateMethodOutput)
        pub fn build(self) -> crate::output::UpdateMethodOutput {
            crate::output::UpdateMethodOutput {
                http_method: self.http_method,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                api_key_required: self.api_key_required,
                request_validator_id: self.request_validator_id,
                operation_name: self.operation_name,
                request_parameters: self.request_parameters,
                request_models: self.request_models,
                method_responses: self.method_responses,
                method_integration: self.method_integration,
                authorization_scopes: self.authorization_scopes,
            }
        }
    }
}
impl UpdateMethodOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMethodOutput`](crate::output::UpdateMethodOutput)
    pub fn builder() -> crate::output::update_method_output::Builder {
        crate::output::update_method_output::Builder::default()
    }
}

/// <p>Represents an integration response. The status code must map to an existing <a>MethodResponse</a>, and parameters and templates can be used to transform the back-end response.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIntegrationResponseOutput {
    /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    pub selection_pattern: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
    /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    pub content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
}
impl UpdateIntegrationResponseOutput {
    /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    pub fn selection_pattern(&self) -> std::option::Option<&str> {
        self.selection_pattern.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
    /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    pub fn content_handling(&self) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling.as_ref()
    }
}
impl std::fmt::Debug for UpdateIntegrationResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIntegrationResponseOutput");
        formatter.field("status_code", &self.status_code);
        formatter.field("selection_pattern", &self.selection_pattern);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field("content_handling", &self.content_handling);
        formatter.finish()
    }
}
/// See [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput)
pub mod update_integration_response_output {
    /// A builder for [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) selection_pattern: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
    }
    impl Builder {
        /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
        pub fn selection_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_pattern = Some(input.into());
            self
        }
        /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
        pub fn set_selection_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_pattern = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput)
        pub fn build(self) -> crate::output::UpdateIntegrationResponseOutput {
            crate::output::UpdateIntegrationResponseOutput {
                status_code: self.status_code,
                selection_pattern: self.selection_pattern,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                content_handling: self.content_handling,
            }
        }
    }
}
impl UpdateIntegrationResponseOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationResponseOutput`](crate::output::UpdateIntegrationResponseOutput)
    pub fn builder() -> crate::output::update_integration_response_output::Builder {
        crate::output::update_integration_response_output::Builder::default()
    }
}

/// <p>Represents an HTTP, HTTP_PROXY, AWS, AWS_PROXY, or Mock integration.</p>
/// <div class="remarks">In the API Gateway console, the built-in Lambda integration is an AWS integration.</div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIntegrationOutput {
    /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
    /// <ul>
    /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
    /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
    /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
    /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
    /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
    /// </ul>
    /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
    pub r#type: std::option::Option<crate::model::IntegrationType>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
    /// <ul>
    /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
    /// </li>
    /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
    /// </li></ul>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <div>
    /// <p>
    /// Specifies how the method request body of an unmapped content type will be passed through the integration request
    /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
    /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
    /// The valid value is one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
    /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
    /// </li>
    /// <li>
    /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
    /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
    /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
    /// </li>
    /// <li>
    /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
    /// request content type does not match any content type associated with the mapping templates defined in the integration request or
    /// no mapping template is defined in the integration request.
    /// </li>
    /// </ul>
    /// </div>
    pub passthrough_behavior: std::option::Option<std::string::String>,
    /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    pub content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    pub timeout_in_millis: i32,
    /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    pub cache_namespace: std::option::Option<std::string::String>,
    /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
    pub cache_key_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the integration's responses.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: Get integration responses of a method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20160607T191449Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
    /// </code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
    /// </div>
    pub integration_responses: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
    >,
    /// <p>Specifies the TLS configuration for an integration.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfig>,
}
impl UpdateIntegrationOutput {
    /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
    /// <ul>
    /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
    /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
    /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
    /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
    /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
    /// </ul>
    /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.r#type.as_ref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
    /// <ul>
    /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
    /// </li>
    /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
    /// </li></ul>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials(&self) -> std::option::Option<&str> {
        self.credentials.as_deref()
    }
    /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <div>
    /// <p>
    /// Specifies how the method request body of an unmapped content type will be passed through the integration request
    /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
    /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
    /// The valid value is one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
    /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
    /// </li>
    /// <li>
    /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
    /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
    /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
    /// </li>
    /// <li>
    /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
    /// request content type does not match any content type associated with the mapping templates defined in the integration request or
    /// no mapping template is defined in the integration request.
    /// </li>
    /// </ul>
    /// </div>
    pub fn passthrough_behavior(&self) -> std::option::Option<&str> {
        self.passthrough_behavior.as_deref()
    }
    /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    pub fn content_handling(&self) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling.as_ref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    pub fn cache_namespace(&self) -> std::option::Option<&str> {
        self.cache_namespace.as_deref()
    }
    /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
    pub fn cache_key_parameters(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_key_parameters.as_deref()
    }
    /// <p>Specifies the integration's responses.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: Get integration responses of a method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20160607T191449Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
    /// </code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
    /// </div>
    pub fn integration_responses(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
    > {
        self.integration_responses.as_ref()
    }
    /// <p>Specifies the TLS configuration for an integration.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfig> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIntegrationOutput");
        formatter.field("r#type", &self.r#type);
        formatter.field("http_method", &self.http_method);
        formatter.field("uri", &self.uri);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("credentials", &self.credentials);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("content_handling", &self.content_handling);
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("cache_namespace", &self.cache_namespace);
        formatter.field("cache_key_parameters", &self.cache_key_parameters);
        formatter.field("integration_responses", &self.integration_responses);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}
/// See [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput)
pub mod update_integration_output {
    /// A builder for [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) credentials: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) passthrough_behavior: std::option::Option<std::string::String>,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) cache_namespace: std::option::Option<std::string::String>,
        pub(crate) cache_key_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) integration_responses: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
        >,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfig>,
    }
    impl Builder {
        /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
        /// <ul>
        /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
        /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
        /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
        /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
        /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
        /// </ul>
        /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
        pub fn r#type(mut self, input: crate::model::IntegrationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
        /// <ul>
        /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
        /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
        /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
        /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
        /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
        /// </ul>
        /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credentials = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// <div>
        /// <p>
        /// Specifies how the method request body of an unmapped content type will be passed through the integration request
        /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
        /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
        /// The valid value is one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
        /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
        /// </li>
        /// <li>
        /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
        /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
        /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
        /// </li>
        /// <li>
        /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
        /// request content type does not match any content type associated with the mapping templates defined in the integration request or
        /// no mapping template is defined in the integration request.
        /// </li>
        /// </ul>
        /// </div>
        pub fn passthrough_behavior(mut self, input: impl Into<std::string::String>) -> Self {
            self.passthrough_behavior = Some(input.into());
            self
        }
        /// <div>
        /// <p>
        /// Specifies how the method request body of an unmapped content type will be passed through the integration request
        /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
        /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
        /// The valid value is one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
        /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
        /// </li>
        /// <li>
        /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
        /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
        /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
        /// </li>
        /// <li>
        /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
        /// request content type does not match any content type associated with the mapping templates defined in the integration request or
        /// no mapping template is defined in the integration request.
        /// </li>
        /// </ul>
        /// </div>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn cache_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_namespace = Some(input.into());
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn set_cache_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_namespace = input;
            self
        }
        /// Appends an item to `cache_key_parameters`.
        ///
        /// To override the contents of this collection use [`set_cache_key_parameters`](Self::set_cache_key_parameters).
        ///
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn cache_key_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_key_parameters.unwrap_or_default();
            v.push(input.into());
            self.cache_key_parameters = Some(v);
            self
        }
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn set_cache_key_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_key_parameters = input;
            self
        }
        /// Adds a key-value pair to `integration_responses`.
        ///
        /// To override the contents of this collection use [`set_integration_responses`](Self::set_integration_responses).
        ///
        /// <p>Specifies the integration's responses.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: Get integration responses of a method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20160607T191449Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
        /// </code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
        /// </div>
        pub fn integration_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::IntegrationResponse>,
        ) -> Self {
            let mut hash_map = self.integration_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.integration_responses = Some(hash_map);
            self
        }
        /// <p>Specifies the integration's responses.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: Get integration responses of a method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20160607T191449Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
        /// </code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
        /// </div>
        pub fn set_integration_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
            >,
        ) -> Self {
            self.integration_responses = input;
            self
        }
        /// <p>Specifies the TLS configuration for an integration.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>Specifies the TLS configuration for an integration.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput)
        pub fn build(self) -> crate::output::UpdateIntegrationOutput {
            crate::output::UpdateIntegrationOutput {
                r#type: self.r#type,
                http_method: self.http_method,
                uri: self.uri,
                connection_type: self.connection_type,
                connection_id: self.connection_id,
                credentials: self.credentials,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                passthrough_behavior: self.passthrough_behavior,
                content_handling: self.content_handling,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                cache_namespace: self.cache_namespace,
                cache_key_parameters: self.cache_key_parameters,
                integration_responses: self.integration_responses,
                tls_config: self.tls_config,
            }
        }
    }
}
impl UpdateIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIntegrationOutput`](crate::output::UpdateIntegrationOutput)
    pub fn builder() -> crate::output::update_integration_output::Builder {
        crate::output::update_integration_output::Builder::default()
    }
}

/// <p>A gateway response of a given response type and status code, with optional response parameters and mapping templates.</p>
/// <div class="remarks">
/// For more information about valid gateway response types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">Gateway Response Types Supported by API Gateway</a>
/// <div class="example">
/// <h4>Example: Get a Gateway Response of a given response type</h4>
/// <h5>Request</h5>
/// <p>This example shows how to get a gateway response of the <code>MISSING_AUTHENTICATION_TOKEN</code> type.</p>
/// <pre><code>GET /restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN HTTP/1.1
/// Host: beta-apigateway.us-east-1.amazonaws.com
/// Content-Type: application/json
/// X-Amz-Date: 20170503T202516Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=1b52460e3159c1a26cff29093855d50ea141c1c5b937528fecaf60f51129697a
/// Cache-Control: no-cache
/// Postman-Token: 3b2a1ce9-c848-2e26-2e2f-9c2caefbed45
/// </code></pre>
/// <p>The response type is specified as a URL path.</p>
/// <h5>Response</h5>
/// <p>The successful operation returns the <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html",
/// "name": "gatewayresponse",
/// "templated": true
/// },
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// "gatewayresponse:delete": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// }
/// },
/// "defaultResponse": false,
/// "responseParameters": {
/// "gatewayresponse.header.x-request-path": "method.request.path.petId",
/// "gatewayresponse.header.Access-Control-Allow-Origin": "'a.b.c'",
/// "gatewayresponse.header.x-request-query": "method.request.querystring.q",
/// "gatewayresponse.header.x-request-header": "method.request.header.Accept"
/// },
/// "responseTemplates": {
/// "application/json": "{\n     \"message\": $context.error.messageString,\n     \"type\":  \"$context.error.responseType\",\n     \"stage\":  \"$context.stage\",\n     \"resourcePath\":  \"$context.resourcePath\",\n     \"stageVariables.a\":  \"$stageVariables.a\",\n     \"statusCode\": \"'404'\"\n}"
/// },
/// "responseType": "MISSING_AUTHENTICATION_TOKEN",
/// "statusCode": "404"
/// }</code></pre>
/// <p></p>
/// </div>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html">Customize Gateway Responses</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayResponseOutput {
    /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
    pub response_type: std::option::Option<crate::model::GatewayResponseType>,
    /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    pub default_response: bool,
}
impl UpdateGatewayResponseOutput {
    /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
    pub fn response_type(&self) -> std::option::Option<&crate::model::GatewayResponseType> {
        self.response_type.as_ref()
    }
    /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    pub fn default_response(&self) -> bool {
        self.default_response
    }
}
impl std::fmt::Debug for UpdateGatewayResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayResponseOutput");
        formatter.field("response_type", &self.response_type);
        formatter.field("status_code", &self.status_code);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field("default_response", &self.default_response);
        formatter.finish()
    }
}
/// See [`UpdateGatewayResponseOutput`](crate::output::UpdateGatewayResponseOutput)
pub mod update_gateway_response_output {
    /// A builder for [`UpdateGatewayResponseOutput`](crate::output::UpdateGatewayResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_type: std::option::Option<crate::model::GatewayResponseType>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) default_response: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.response_type = Some(input);
            self
        }
        /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.response_type = input;
            self
        }
        /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
        pub fn default_response(mut self, input: bool) -> Self {
            self.default_response = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
        pub fn set_default_response(mut self, input: std::option::Option<bool>) -> Self {
            self.default_response = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayResponseOutput`](crate::output::UpdateGatewayResponseOutput)
        pub fn build(self) -> crate::output::UpdateGatewayResponseOutput {
            crate::output::UpdateGatewayResponseOutput {
                response_type: self.response_type,
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                default_response: self.default_response.unwrap_or_default(),
            }
        }
    }
}
impl UpdateGatewayResponseOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayResponseOutput`](crate::output::UpdateGatewayResponseOutput)
    pub fn builder() -> crate::output::update_gateway_response_output::Builder {
        crate::output::update_gateway_response_output::Builder::default()
    }
}

/// <p>Represents a custom domain name as a user-friendly host name of an API (<a>RestApi</a>).</p>
/// <div class="Remarks">
/// <p>When you deploy an API, API Gateway creates a default host name for the API. This default API host name is of the <code>{restapi-id}.execute-api.{region}.amazonaws.com</code> format. With the default host name, you can access the API's root resource with the URL of <code>https://{restapi-id}.execute-api.{region}.amazonaws.com/{stage}/</code>. When you set up a custom domain name of <code>apis.example.com</code> for this API, you can then access the same resource using the URL of the <code>https://apis.examples.com/myApi</code>, where <code>myApi</code> is the base path mapping (<a>BasePathMapping</a>) of your API under the custom domain name.
/// </p>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Set a Custom Host Name for an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainNameOutput {
    /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    pub certificate_name: std::option::Option<std::string::String>,
    /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    pub certificate_upload_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
    pub regional_domain_name: std::option::Option<std::string::String>,
    /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub regional_hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
    pub regional_certificate_name: std::option::Option<std::string::String>,
    /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
    pub regional_certificate_arn: std::option::Option<std::string::String>,
    /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
    pub distribution_domain_name: std::option::Option<std::string::String>,
    /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub distribution_hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
    pub endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
    /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
    pub domain_name_status: std::option::Option<crate::model::DomainNameStatus>,
    /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
    pub domain_name_status_message: std::option::Option<std::string::String>,
    /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    pub security_policy: std::option::Option<crate::model::SecurityPolicy>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
    pub mutual_tls_authentication: std::option::Option<crate::model::MutualTlsAuthentication>,
    /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    pub ownership_verification_certificate_arn: std::option::Option<std::string::String>,
}
impl UpdateDomainNameOutput {
    /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    pub fn certificate_name(&self) -> std::option::Option<&str> {
        self.certificate_name.as_deref()
    }
    /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    pub fn certificate_upload_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.certificate_upload_date.as_ref()
    }
    /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
    pub fn regional_domain_name(&self) -> std::option::Option<&str> {
        self.regional_domain_name.as_deref()
    }
    /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub fn regional_hosted_zone_id(&self) -> std::option::Option<&str> {
        self.regional_hosted_zone_id.as_deref()
    }
    /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
    pub fn regional_certificate_name(&self) -> std::option::Option<&str> {
        self.regional_certificate_name.as_deref()
    }
    /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
    pub fn regional_certificate_arn(&self) -> std::option::Option<&str> {
        self.regional_certificate_arn.as_deref()
    }
    /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
    pub fn distribution_domain_name(&self) -> std::option::Option<&str> {
        self.distribution_domain_name.as_deref()
    }
    /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub fn distribution_hosted_zone_id(&self) -> std::option::Option<&str> {
        self.distribution_hosted_zone_id.as_deref()
    }
    /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
    pub fn domain_name_status(&self) -> std::option::Option<&crate::model::DomainNameStatus> {
        self.domain_name_status.as_ref()
    }
    /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
    pub fn domain_name_status_message(&self) -> std::option::Option<&str> {
        self.domain_name_status_message.as_deref()
    }
    /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    pub fn security_policy(&self) -> std::option::Option<&crate::model::SecurityPolicy> {
        self.security_policy.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
    pub fn mutual_tls_authentication(
        &self,
    ) -> std::option::Option<&crate::model::MutualTlsAuthentication> {
        self.mutual_tls_authentication.as_ref()
    }
    /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    pub fn ownership_verification_certificate_arn(&self) -> std::option::Option<&str> {
        self.ownership_verification_certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateDomainNameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainNameOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("certificate_name", &self.certificate_name);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_upload_date", &self.certificate_upload_date);
        formatter.field("regional_domain_name", &self.regional_domain_name);
        formatter.field("regional_hosted_zone_id", &self.regional_hosted_zone_id);
        formatter.field("regional_certificate_name", &self.regional_certificate_name);
        formatter.field("regional_certificate_arn", &self.regional_certificate_arn);
        formatter.field("distribution_domain_name", &self.distribution_domain_name);
        formatter.field(
            "distribution_hosted_zone_id",
            &self.distribution_hosted_zone_id,
        );
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("domain_name_status", &self.domain_name_status);
        formatter.field(
            "domain_name_status_message",
            &self.domain_name_status_message,
        );
        formatter.field("security_policy", &self.security_policy);
        formatter.field("tags", &self.tags);
        formatter.field("mutual_tls_authentication", &self.mutual_tls_authentication);
        formatter.field(
            "ownership_verification_certificate_arn",
            &self.ownership_verification_certificate_arn,
        );
        formatter.finish()
    }
}
/// See [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput)
pub mod update_domain_name_output {
    /// A builder for [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_upload_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) regional_domain_name: std::option::Option<std::string::String>,
        pub(crate) regional_hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) regional_certificate_name: std::option::Option<std::string::String>,
        pub(crate) regional_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) distribution_domain_name: std::option::Option<std::string::String>,
        pub(crate) distribution_hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) domain_name_status: std::option::Option<crate::model::DomainNameStatus>,
        pub(crate) domain_name_status_message: std::option::Option<std::string::String>,
        pub(crate) security_policy: std::option::Option<crate::model::SecurityPolicy>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthentication>,
        pub(crate) ownership_verification_certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
        pub fn certificate_upload_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.certificate_upload_date = Some(input);
            self
        }
        /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
        pub fn set_certificate_upload_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.certificate_upload_date = input;
            self
        }
        /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
        pub fn regional_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_domain_name = Some(input.into());
            self
        }
        /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
        pub fn set_regional_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_domain_name = input;
            self
        }
        /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn regional_hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn set_regional_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_hosted_zone_id = input;
            self
        }
        /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
        pub fn regional_certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
        pub fn set_regional_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_certificate_name = input;
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn regional_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_certificate_arn = Some(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_regional_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_certificate_arn = input;
            self
        }
        /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
        pub fn distribution_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_domain_name = Some(input.into());
            self
        }
        /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
        pub fn set_distribution_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_domain_name = input;
            self
        }
        /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn distribution_hosted_zone_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn set_distribution_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_hosted_zone_id = input;
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
        pub fn domain_name_status(mut self, input: crate::model::DomainNameStatus) -> Self {
            self.domain_name_status = Some(input);
            self
        }
        /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
        pub fn set_domain_name_status(
            mut self,
            input: std::option::Option<crate::model::DomainNameStatus>,
        ) -> Self {
            self.domain_name_status = input;
            self
        }
        /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
        pub fn domain_name_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name_status_message = Some(input.into());
            self
        }
        /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
        pub fn set_domain_name_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_name_status_message = input;
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn security_policy(mut self, input: crate::model::SecurityPolicy) -> Self {
            self.security_policy = Some(input);
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn set_security_policy(
            mut self,
            input: std::option::Option<crate::model::SecurityPolicy>,
        ) -> Self {
            self.security_policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthentication,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthentication>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn ownership_verification_certificate_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn set_ownership_verification_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput)
        pub fn build(self) -> crate::output::UpdateDomainNameOutput {
            crate::output::UpdateDomainNameOutput {
                domain_name: self.domain_name,
                certificate_name: self.certificate_name,
                certificate_arn: self.certificate_arn,
                certificate_upload_date: self.certificate_upload_date,
                regional_domain_name: self.regional_domain_name,
                regional_hosted_zone_id: self.regional_hosted_zone_id,
                regional_certificate_name: self.regional_certificate_name,
                regional_certificate_arn: self.regional_certificate_arn,
                distribution_domain_name: self.distribution_domain_name,
                distribution_hosted_zone_id: self.distribution_hosted_zone_id,
                endpoint_configuration: self.endpoint_configuration,
                domain_name_status: self.domain_name_status,
                domain_name_status_message: self.domain_name_status_message,
                security_policy: self.security_policy,
                tags: self.tags,
                mutual_tls_authentication: self.mutual_tls_authentication,
                ownership_verification_certificate_arn: self.ownership_verification_certificate_arn,
            }
        }
    }
}
impl UpdateDomainNameOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput)
    pub fn builder() -> crate::output::update_domain_name_output::Builder {
        crate::output::update_domain_name_output::Builder::default()
    }
}

/// <p>A snapshot of the documentation of an API.</p>
/// <div class="remarks"><p>Publishing API documentation involves creating a documentation version associated with an API stage and exporting the versioned documentation to an external (e.g., OpenAPI) file.</p></div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a>DocumentationPart</a>, <a>DocumentationVersions</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentationVersionOutput {
    /// <p>The version identifier of the API documentation snapshot.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The date when the API documentation snapshot is created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the API documentation snapshot.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateDocumentationVersionOutput {
    /// <p>The version identifier of the API documentation snapshot.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The date when the API documentation snapshot is created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The description of the API documentation snapshot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateDocumentationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentationVersionOutput");
        formatter.field("version", &self.version);
        formatter.field("created_date", &self.created_date);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`UpdateDocumentationVersionOutput`](crate::output::UpdateDocumentationVersionOutput)
pub mod update_documentation_version_output {
    /// A builder for [`UpdateDocumentationVersionOutput`](crate::output::UpdateDocumentationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version identifier of the API documentation snapshot.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version identifier of the API documentation snapshot.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The date when the API documentation snapshot is created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date when the API documentation snapshot is created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The description of the API documentation snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API documentation snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDocumentationVersionOutput`](crate::output::UpdateDocumentationVersionOutput)
        pub fn build(self) -> crate::output::UpdateDocumentationVersionOutput {
            crate::output::UpdateDocumentationVersionOutput {
                version: self.version,
                created_date: self.created_date,
                description: self.description,
            }
        }
    }
}
impl UpdateDocumentationVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentationVersionOutput`](crate::output::UpdateDocumentationVersionOutput)
    pub fn builder() -> crate::output::update_documentation_version_output::Builder {
        crate::output::update_documentation_version_output::Builder::default()
    }
}

/// <p>A documentation part for a targeted API entity.</p>
/// <div class="remarks">
/// <p>A documentation part consists of a content map (<code>properties</code>) and a target (<code>location</code>). The target specifies an API entity to which the documentation content applies. The supported API entity types are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Valid <code>location</code> fields depend on the API entity type. All valid fields are not required.</p>
/// <p>The content map is a JSON string of API-specific key-value pairs. Although an API can use any shape for the content map, only the OpenAPI-compliant documentation fields will be injected into the associated API entity definition in the exported OpenAPI definition file.</p></div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a>DocumentationParts</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentationPartOutput {
    /// <p>The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
    pub location: std::option::Option<crate::model::DocumentationPartLocation>,
    /// <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>.  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
    pub properties: std::option::Option<std::string::String>,
}
impl UpdateDocumentationPartOutput {
    /// <p>The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::DocumentationPartLocation> {
        self.location.as_ref()
    }
    /// <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>.  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
    pub fn properties(&self) -> std::option::Option<&str> {
        self.properties.as_deref()
    }
}
impl std::fmt::Debug for UpdateDocumentationPartOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentationPartOutput");
        formatter.field("id", &self.id);
        formatter.field("location", &self.location);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`UpdateDocumentationPartOutput`](crate::output::UpdateDocumentationPartOutput)
pub mod update_documentation_part_output {
    /// A builder for [`UpdateDocumentationPartOutput`](crate::output::UpdateDocumentationPartOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::DocumentationPartLocation>,
        pub(crate) properties: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
        pub fn location(mut self, input: crate::model::DocumentationPartLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::DocumentationPartLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>.  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
        pub fn properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.properties = Some(input.into());
            self
        }
        /// <p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>.  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>
        pub fn set_properties(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDocumentationPartOutput`](crate::output::UpdateDocumentationPartOutput)
        pub fn build(self) -> crate::output::UpdateDocumentationPartOutput {
            crate::output::UpdateDocumentationPartOutput {
                id: self.id,
                location: self.location,
                properties: self.properties,
            }
        }
    }
}
impl UpdateDocumentationPartOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentationPartOutput`](crate::output::UpdateDocumentationPartOutput)
    pub fn builder() -> crate::output::update_documentation_part_output::Builder {
        crate::output::update_documentation_part_output::Builder::default()
    }
}

/// <p>An immutable representation of a <a>RestApi</a> resource that can be called by users using <a>Stages</a>. A deployment must be associated with a <a>Stage</a> for it to be callable over the Internet.</p>
/// <div class="remarks">To create a deployment, call <code>POST</code> on the <a>Deployments</a> resource of a <a>RestApi</a>.
/// To view, update, or delete a deployment, call <code>GET</code>, <code>PATCH</code>, or <code>DELETE</code> on the specified deployment resource (<code>/restapis/{restapi_id}/deployments/{deployment_id}</code>).</div>
/// <div class="seeAlso"><a>RestApi</a>, <a>Deployments</a>, <a>Stage</a>,
/// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html">AWS CLI</a>,
/// <a href="https://aws.amazon.com/tools/">AWS SDKs</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeploymentOutput {
    /// <p>The identifier for the deployment resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The description for the deployment resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that the deployment resource was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.</p>
    pub api_summary: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>,
        >,
    >,
}
impl UpdateDeploymentOutput {
    /// <p>The identifier for the deployment resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The description for the deployment resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that the deployment resource was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.</p>
    pub fn api_summary(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>,
        >,
    > {
        self.api_summary.as_ref()
    }
}
impl std::fmt::Debug for UpdateDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeploymentOutput");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("api_summary", &self.api_summary);
        formatter.finish()
    }
}
/// See [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput)
pub mod update_deployment_output {
    /// A builder for [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) api_summary: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>,
            >,
        >,
    }
    impl Builder {
        /// <p>The identifier for the deployment resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the deployment resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the deployment resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that the deployment resource was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time that the deployment resource was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Adds a key-value pair to `api_summary`.
        ///
        /// To override the contents of this collection use [`set_api_summary`](Self::set_api_summary).
        ///
        /// <p>A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.</p>
        pub fn api_summary(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>>,
        ) -> Self {
            let mut hash_map = self.api_summary.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.api_summary = Some(hash_map);
            self
        }
        /// <p>A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.</p>
        pub fn set_api_summary(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, crate::model::MethodSnapshot>,
                >,
            >,
        ) -> Self {
            self.api_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput)
        pub fn build(self) -> crate::output::UpdateDeploymentOutput {
            crate::output::UpdateDeploymentOutput {
                id: self.id,
                description: self.description,
                created_date: self.created_date,
                api_summary: self.api_summary,
            }
        }
    }
}
impl UpdateDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentOutput`](crate::output::UpdateDeploymentOutput)
    pub fn builder() -> crate::output::update_deployment_output::Builder {
        crate::output::update_deployment_output::Builder::default()
    }
}

/// <p>Represents a client certificate used to configure client-side SSL authentication while sending requests to the integration endpoint.</p>
/// <div class="remarks">Client certificates are used to authenticate an API by the backend server. To authenticate an API client (or user), use IAM roles and policies, a custom <a>Authorizer</a> or an Amazon Cognito user pool.</div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html">Use Client-Side Certificate</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClientCertificateOutput {
    /// <p>The identifier of the client certificate.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The description of the client certificate.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
    pub pem_encoded_certificate: std::option::Option<std::string::String>,
    /// <p>The timestamp when the client certificate was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when the client certificate will expire.</p>
    pub expiration_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateClientCertificateOutput {
    /// <p>The identifier of the client certificate.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The description of the client certificate.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
    pub fn pem_encoded_certificate(&self) -> std::option::Option<&str> {
        self.pem_encoded_certificate.as_deref()
    }
    /// <p>The timestamp when the client certificate was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The timestamp when the client certificate will expire.</p>
    pub fn expiration_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expiration_date.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateClientCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClientCertificateOutput");
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("description", &self.description);
        formatter.field("pem_encoded_certificate", &self.pem_encoded_certificate);
        formatter.field("created_date", &self.created_date);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateClientCertificateOutput`](crate::output::UpdateClientCertificateOutput)
pub mod update_client_certificate_output {
    /// A builder for [`UpdateClientCertificateOutput`](crate::output::UpdateClientCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) pem_encoded_certificate: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the client certificate.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of the client certificate.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The description of the client certificate.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the client certificate.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
        pub fn pem_encoded_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.pem_encoded_certificate = Some(input.into());
            self
        }
        /// <p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>
        pub fn set_pem_encoded_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pem_encoded_certificate = input;
            self
        }
        /// <p>The timestamp when the client certificate was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the client certificate was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The timestamp when the client certificate will expire.</p>
        pub fn expiration_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p>The timestamp when the client certificate will expire.</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClientCertificateOutput`](crate::output::UpdateClientCertificateOutput)
        pub fn build(self) -> crate::output::UpdateClientCertificateOutput {
            crate::output::UpdateClientCertificateOutput {
                client_certificate_id: self.client_certificate_id,
                description: self.description,
                pem_encoded_certificate: self.pem_encoded_certificate,
                created_date: self.created_date,
                expiration_date: self.expiration_date,
                tags: self.tags,
            }
        }
    }
}
impl UpdateClientCertificateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateClientCertificateOutput`](crate::output::UpdateClientCertificateOutput)
    pub fn builder() -> crate::output::update_client_certificate_output::Builder {
        crate::output::update_client_certificate_output::Builder::default()
    }
}

/// <p>Represents the base path that callers of the API must provide as part of the URL after the domain name.</p>
/// <div class="remarks">A custom domain name plus a <code>BasePathMapping</code> specification identifies a deployed <a>RestApi</a> in a given stage of the owner <a>Account</a>.</div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Use Custom Domain Names</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBasePathMappingOutput {
    /// <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
    pub base_path: std::option::Option<std::string::String>,
    /// <p>The string identifier of the associated <a>RestApi</a>.</p>
    pub rest_api_id: std::option::Option<std::string::String>,
    /// <p>The name of the associated stage.</p>
    pub stage: std::option::Option<std::string::String>,
}
impl UpdateBasePathMappingOutput {
    /// <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
    pub fn base_path(&self) -> std::option::Option<&str> {
        self.base_path.as_deref()
    }
    /// <p>The string identifier of the associated <a>RestApi</a>.</p>
    pub fn rest_api_id(&self) -> std::option::Option<&str> {
        self.rest_api_id.as_deref()
    }
    /// <p>The name of the associated stage.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
}
impl std::fmt::Debug for UpdateBasePathMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBasePathMappingOutput");
        formatter.field("base_path", &self.base_path);
        formatter.field("rest_api_id", &self.rest_api_id);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}
/// See [`UpdateBasePathMappingOutput`](crate::output::UpdateBasePathMappingOutput)
pub mod update_base_path_mapping_output {
    /// A builder for [`UpdateBasePathMappingOutput`](crate::output::UpdateBasePathMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_path: std::option::Option<std::string::String>,
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_path = Some(input.into());
            self
        }
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.base_path = input;
            self
        }
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The name of the associated stage.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The name of the associated stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBasePathMappingOutput`](crate::output::UpdateBasePathMappingOutput)
        pub fn build(self) -> crate::output::UpdateBasePathMappingOutput {
            crate::output::UpdateBasePathMappingOutput {
                base_path: self.base_path,
                rest_api_id: self.rest_api_id,
                stage: self.stage,
            }
        }
    }
}
impl UpdateBasePathMappingOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBasePathMappingOutput`](crate::output::UpdateBasePathMappingOutput)
    pub fn builder() -> crate::output::update_base_path_mapping_output::Builder {
        crate::output::update_base_path_mapping_output::Builder::default()
    }
}

/// <p>Represents an authorization layer for methods. If enabled on a method, API Gateway will activate the authorizer when a client calls the method.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer</a>
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAuthorizerOutput {
    /// <p>The identifier for the authorizer resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>[Required] The name of the authorizer.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
    pub r#type: std::option::Option<crate::model::AuthorizerType>,
    /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
    pub provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
    pub auth_type: std::option::Option<std::string::String>,
    /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
    pub authorizer_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
    pub authorizer_credentials: std::option::Option<std::string::String>,
    /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
    pub identity_source: std::option::Option<std::string::String>,
    /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
    pub identity_validation_expression: std::option::Option<std::string::String>,
    /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
    pub authorizer_result_ttl_in_seconds: std::option::Option<i32>,
}
impl UpdateAuthorizerOutput {
    /// <p>The identifier for the authorizer resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>[Required] The name of the authorizer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AuthorizerType> {
        self.r#type.as_ref()
    }
    /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
    pub fn provider_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.provider_ar_ns.as_deref()
    }
    /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
    pub fn auth_type(&self) -> std::option::Option<&str> {
        self.auth_type.as_deref()
    }
    /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
    pub fn authorizer_uri(&self) -> std::option::Option<&str> {
        self.authorizer_uri.as_deref()
    }
    /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
    pub fn authorizer_credentials(&self) -> std::option::Option<&str> {
        self.authorizer_credentials.as_deref()
    }
    /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
    pub fn identity_source(&self) -> std::option::Option<&str> {
        self.identity_source.as_deref()
    }
    /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
    pub fn identity_validation_expression(&self) -> std::option::Option<&str> {
        self.identity_validation_expression.as_deref()
    }
    /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
    pub fn authorizer_result_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.authorizer_result_ttl_in_seconds
    }
}
impl std::fmt::Debug for UpdateAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAuthorizerOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("provider_ar_ns", &self.provider_ar_ns);
        formatter.field("auth_type", &self.auth_type);
        formatter.field("authorizer_uri", &self.authorizer_uri);
        formatter.field("authorizer_credentials", &self.authorizer_credentials);
        formatter.field("identity_source", &self.identity_source);
        formatter.field(
            "identity_validation_expression",
            &self.identity_validation_expression,
        );
        formatter.field(
            "authorizer_result_ttl_in_seconds",
            &self.authorizer_result_ttl_in_seconds,
        );
        formatter.finish()
    }
}
/// See [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
pub mod update_authorizer_output {
    /// A builder for [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AuthorizerType>,
        pub(crate) provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auth_type: std::option::Option<std::string::String>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) authorizer_credentials: std::option::Option<std::string::String>,
        pub(crate) identity_source: std::option::Option<std::string::String>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the authorizer resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the authorizer resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn r#type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_provider_ar_ns`](Self::set_provider_ar_ns).
        ///
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.provider_ar_ns = Some(v);
            self
        }
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn set_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.provider_ar_ns = input;
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn auth_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_type = Some(input.into());
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn set_auth_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_type = input;
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn authorizer_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_credentials = Some(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn set_authorizer_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_credentials = input;
            self
        }
        /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_source = Some(input.into());
            self
        }
        /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_source = input;
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
        pub fn build(self) -> crate::output::UpdateAuthorizerOutput {
            crate::output::UpdateAuthorizerOutput {
                id: self.id,
                name: self.name,
                r#type: self.r#type,
                provider_ar_ns: self.provider_ar_ns,
                auth_type: self.auth_type,
                authorizer_uri: self.authorizer_uri,
                authorizer_credentials: self.authorizer_credentials,
                identity_source: self.identity_source,
                identity_validation_expression: self.identity_validation_expression,
                authorizer_result_ttl_in_seconds: self.authorizer_result_ttl_in_seconds,
            }
        }
    }
}
impl UpdateAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
    pub fn builder() -> crate::output::update_authorizer_output::Builder {
        crate::output::update_authorizer_output::Builder::default()
    }
}

/// <p>A resource that can be distributed to callers for executing <a>Method</a> resources that require an API key. API keys can be mapped to any <a>Stage</a> on any <a>RestApi</a>, which indicates that the callers with the API key can make requests to that stage.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html">Use API Keys</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApiKeyOutput {
    /// <p>The identifier of the API Key.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the API Key.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The name of the API Key.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
    pub customer_id: std::option::Option<std::string::String>,
    /// <p>The description of the API Key.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether the API Key can be used by callers.</p>
    pub enabled: bool,
    /// <p>The timestamp when the API Key was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when the API Key was last updated.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>
    pub stage_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateApiKeyOutput {
    /// <p>The identifier of the API Key.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the API Key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The name of the API Key.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
    pub fn customer_id(&self) -> std::option::Option<&str> {
        self.customer_id.as_deref()
    }
    /// <p>The description of the API Key.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies whether the API Key can be used by callers.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The timestamp when the API Key was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The timestamp when the API Key was last updated.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>
    pub fn stage_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.stage_keys.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateApiKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApiKeyOutput");
        formatter.field("id", &self.id);
        formatter.field("value", &self.value);
        formatter.field("name", &self.name);
        formatter.field("customer_id", &self.customer_id);
        formatter.field("description", &self.description);
        formatter.field("enabled", &self.enabled);
        formatter.field("created_date", &self.created_date);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("stage_keys", &self.stage_keys);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateApiKeyOutput`](crate::output::UpdateApiKeyOutput)
pub mod update_api_key_output {
    /// A builder for [`UpdateApiKeyOutput`](crate::output::UpdateApiKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) customer_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stage_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the API Key.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the API Key.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the API Key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the API Key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The name of the API Key.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API Key.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn customer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_id = Some(input.into());
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn set_customer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.customer_id = input;
            self
        }
        /// <p>The description of the API Key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the API Key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether the API Key can be used by callers.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the API Key can be used by callers.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The timestamp when the API Key was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API Key was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The timestamp when the API Key was last updated.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The timestamp when the API Key was last updated.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Appends an item to `stage_keys`.
        ///
        /// To override the contents of this collection use [`set_stage_keys`](Self::set_stage_keys).
        ///
        /// <p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>
        pub fn stage_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stage_keys.unwrap_or_default();
            v.push(input.into());
            self.stage_keys = Some(v);
            self
        }
        /// <p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>
        pub fn set_stage_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stage_keys = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiKeyOutput`](crate::output::UpdateApiKeyOutput)
        pub fn build(self) -> crate::output::UpdateApiKeyOutput {
            crate::output::UpdateApiKeyOutput {
                id: self.id,
                value: self.value,
                name: self.name,
                customer_id: self.customer_id,
                description: self.description,
                enabled: self.enabled.unwrap_or_default(),
                created_date: self.created_date,
                last_updated_date: self.last_updated_date,
                stage_keys: self.stage_keys,
                tags: self.tags,
            }
        }
    }
}
impl UpdateApiKeyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApiKeyOutput`](crate::output::UpdateApiKeyOutput)
    pub fn builder() -> crate::output::update_api_key_output::Builder {
        crate::output::update_api_key_output::Builder::default()
    }
}

/// <p>Represents an AWS account that is associated with API Gateway.</p>
/// <div class="remarks">
/// <p>To view the account info, call <code>GET</code> on this resource.</p>
/// <h4>Error Codes</h4>
/// <p>The following exception may be thrown when the request fails.</p>
/// <ul>
/// <li>UnauthorizedException</li>
/// <li>NotFoundException</li>
/// <li>TooManyRequestsException</li>
/// </ul>
/// <p>For detailed error code information, including the corresponding HTTP Status Codes, see <a href="https://docs.aws.amazon.com/apigateway/api-reference/handling-errors/#api-error-codes">API Gateway Error Codes</a></p>
/// <h4>Example: Get the information about an account.</h4>
/// <h5>Request</h5>
/// <pre><code>GET /account HTTP/1.1
/// Content-Type: application/json
/// Host: apigateway.us-east-1.amazonaws.com
/// X-Amz-Date: 20160531T184618Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
/// </code></pre>
/// <h5>Response</h5>
/// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/account-apigateway-{rel}.html",
/// "name": "account",
/// "templated": true
/// },
/// "self": {
/// "href": "/account"
/// },
/// "account:update": {
/// "href": "/account"
/// }
/// },
/// "cloudwatchRoleArn": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
/// "throttleSettings": {
/// "rateLimit": 500,
/// "burstLimit": 1000
/// }
/// }
/// </code></pre>
/// <p>In addition to making the REST API call directly, you can use the AWS CLI and an AWS SDK to access this resource.</p>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-limits.html">API Gateway Limits</a>
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/welcome.html">Developer Guide</a>,
/// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-account.html">AWS CLI</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccountOutput {
    /// <p>The ARN of an Amazon CloudWatch role for the current <a>Account</a>.</p>
    pub cloudwatch_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the API request limits configured for the current <a>Account</a>.</p>
    pub throttle_settings: std::option::Option<crate::model::ThrottleSettings>,
    /// <p>A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.</p>
    pub features: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The version of the API keys used for the account.</p>
    pub api_key_version: std::option::Option<std::string::String>,
}
impl UpdateAccountOutput {
    /// <p>The ARN of an Amazon CloudWatch role for the current <a>Account</a>.</p>
    pub fn cloudwatch_role_arn(&self) -> std::option::Option<&str> {
        self.cloudwatch_role_arn.as_deref()
    }
    /// <p>Specifies the API request limits configured for the current <a>Account</a>.</p>
    pub fn throttle_settings(&self) -> std::option::Option<&crate::model::ThrottleSettings> {
        self.throttle_settings.as_ref()
    }
    /// <p>A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.</p>
    pub fn features(&self) -> std::option::Option<&[std::string::String]> {
        self.features.as_deref()
    }
    /// <p>The version of the API keys used for the account.</p>
    pub fn api_key_version(&self) -> std::option::Option<&str> {
        self.api_key_version.as_deref()
    }
}
impl std::fmt::Debug for UpdateAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccountOutput");
        formatter.field("cloudwatch_role_arn", &self.cloudwatch_role_arn);
        formatter.field("throttle_settings", &self.throttle_settings);
        formatter.field("features", &self.features);
        formatter.field("api_key_version", &self.api_key_version);
        formatter.finish()
    }
}
/// See [`UpdateAccountOutput`](crate::output::UpdateAccountOutput)
pub mod update_account_output {
    /// A builder for [`UpdateAccountOutput`](crate::output::UpdateAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloudwatch_role_arn: std::option::Option<std::string::String>,
        pub(crate) throttle_settings: std::option::Option<crate::model::ThrottleSettings>,
        pub(crate) features: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) api_key_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of an Amazon CloudWatch role for the current <a>Account</a>.</p>
        pub fn cloudwatch_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloudwatch_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an Amazon CloudWatch role for the current <a>Account</a>.</p>
        pub fn set_cloudwatch_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloudwatch_role_arn = input;
            self
        }
        /// <p>Specifies the API request limits configured for the current <a>Account</a>.</p>
        pub fn throttle_settings(mut self, input: crate::model::ThrottleSettings) -> Self {
            self.throttle_settings = Some(input);
            self
        }
        /// <p>Specifies the API request limits configured for the current <a>Account</a>.</p>
        pub fn set_throttle_settings(
            mut self,
            input: std::option::Option<crate::model::ThrottleSettings>,
        ) -> Self {
            self.throttle_settings = input;
            self
        }
        /// Appends an item to `features`.
        ///
        /// To override the contents of this collection use [`set_features`](Self::set_features).
        ///
        /// <p>A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.</p>
        pub fn features(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.features.unwrap_or_default();
            v.push(input.into());
            self.features = Some(v);
            self
        }
        /// <p>A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.</p>
        pub fn set_features(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.features = input;
            self
        }
        /// <p>The version of the API keys used for the account.</p>
        pub fn api_key_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key_version = Some(input.into());
            self
        }
        /// <p>The version of the API keys used for the account.</p>
        pub fn set_api_key_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccountOutput`](crate::output::UpdateAccountOutput)
        pub fn build(self) -> crate::output::UpdateAccountOutput {
            crate::output::UpdateAccountOutput {
                cloudwatch_role_arn: self.cloudwatch_role_arn,
                throttle_settings: self.throttle_settings,
                features: self.features,
                api_key_version: self.api_key_version,
            }
        }
    }
}
impl UpdateAccountOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccountOutput`](crate::output::UpdateAccountOutput)
    pub fn builder() -> crate::output::update_account_output::Builder {
        crate::output::update_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

/// <p>Represents the response of the test invoke request in the HTTP method.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-test-method.html#how-to-test-method-console">Test API using the API Gateway console</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestInvokeMethodOutput {
    /// <p>The HTTP status code.</p>
    pub status: i32,
    /// <p>The body of the HTTP response.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The headers of the HTTP response.</p>
    pub headers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The headers of the HTTP response as a map from string to list of values.</p>
    pub multi_value_headers: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The API Gateway execution log for the test invoke request.</p>
    pub log: std::option::Option<std::string::String>,
    /// <p>The execution latency of the test invoke request.</p>
    pub latency: i64,
}
impl TestInvokeMethodOutput {
    /// <p>The HTTP status code.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The body of the HTTP response.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The headers of the HTTP response.</p>
    pub fn headers(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.headers.as_ref()
    }
    /// <p>The headers of the HTTP response as a map from string to list of values.</p>
    pub fn multi_value_headers(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.multi_value_headers.as_ref()
    }
    /// <p>The API Gateway execution log for the test invoke request.</p>
    pub fn log(&self) -> std::option::Option<&str> {
        self.log.as_deref()
    }
    /// <p>The execution latency of the test invoke request.</p>
    pub fn latency(&self) -> i64 {
        self.latency
    }
}
impl std::fmt::Debug for TestInvokeMethodOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestInvokeMethodOutput");
        formatter.field("status", &self.status);
        formatter.field("body", &self.body);
        formatter.field("headers", &self.headers);
        formatter.field("multi_value_headers", &self.multi_value_headers);
        formatter.field("log", &self.log);
        formatter.field("latency", &self.latency);
        formatter.finish()
    }
}
/// See [`TestInvokeMethodOutput`](crate::output::TestInvokeMethodOutput)
pub mod test_invoke_method_output {
    /// A builder for [`TestInvokeMethodOutput`](crate::output::TestInvokeMethodOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) multi_value_headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) log: std::option::Option<std::string::String>,
        pub(crate) latency: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The HTTP status code.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status code.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The body of the HTTP response.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The body of the HTTP response.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// Adds a key-value pair to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>The headers of the HTTP response.</p>
        pub fn headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.headers = Some(hash_map);
            self
        }
        /// <p>The headers of the HTTP response.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.headers = input;
            self
        }
        /// Adds a key-value pair to `multi_value_headers`.
        ///
        /// To override the contents of this collection use [`set_multi_value_headers`](Self::set_multi_value_headers).
        ///
        /// <p>The headers of the HTTP response as a map from string to list of values.</p>
        pub fn multi_value_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.multi_value_headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.multi_value_headers = Some(hash_map);
            self
        }
        /// <p>The headers of the HTTP response as a map from string to list of values.</p>
        pub fn set_multi_value_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.multi_value_headers = input;
            self
        }
        /// <p>The API Gateway execution log for the test invoke request.</p>
        pub fn log(mut self, input: impl Into<std::string::String>) -> Self {
            self.log = Some(input.into());
            self
        }
        /// <p>The API Gateway execution log for the test invoke request.</p>
        pub fn set_log(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log = input;
            self
        }
        /// <p>The execution latency of the test invoke request.</p>
        pub fn latency(mut self, input: i64) -> Self {
            self.latency = Some(input);
            self
        }
        /// <p>The execution latency of the test invoke request.</p>
        pub fn set_latency(mut self, input: std::option::Option<i64>) -> Self {
            self.latency = input;
            self
        }
        /// Consumes the builder and constructs a [`TestInvokeMethodOutput`](crate::output::TestInvokeMethodOutput)
        pub fn build(self) -> crate::output::TestInvokeMethodOutput {
            crate::output::TestInvokeMethodOutput {
                status: self.status.unwrap_or_default(),
                body: self.body,
                headers: self.headers,
                multi_value_headers: self.multi_value_headers,
                log: self.log,
                latency: self.latency.unwrap_or_default(),
            }
        }
    }
}
impl TestInvokeMethodOutput {
    /// Creates a new builder-style object to manufacture [`TestInvokeMethodOutput`](crate::output::TestInvokeMethodOutput)
    pub fn builder() -> crate::output::test_invoke_method_output::Builder {
        crate::output::test_invoke_method_output::Builder::default()
    }
}

/// <p>Represents the response of the test invoke request for a custom <a>Authorizer</a></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestInvokeAuthorizerOutput {
    /// <p>The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.</p>
    pub client_status: i32,
    /// <p>The API Gateway execution log for the test authorizer request.</p>
    pub log: std::option::Option<std::string::String>,
    /// <p>The execution latency of the test authorizer request.</p>
    pub latency: i64,
    /// <p>The principal identity returned by the <a>Authorizer</a></p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The JSON policy document returned by the <a>Authorizer</a></p>
    pub policy: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub authorization: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.</p>
    pub claims:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TestInvokeAuthorizerOutput {
    /// <p>The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.</p>
    pub fn client_status(&self) -> i32 {
        self.client_status
    }
    /// <p>The API Gateway execution log for the test authorizer request.</p>
    pub fn log(&self) -> std::option::Option<&str> {
        self.log.as_deref()
    }
    /// <p>The execution latency of the test authorizer request.</p>
    pub fn latency(&self) -> i64 {
        self.latency
    }
    /// <p>The principal identity returned by the <a>Authorizer</a></p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The JSON policy document returned by the <a>Authorizer</a></p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn authorization(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.authorization.as_ref()
    }
    /// <p>The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.</p>
    pub fn claims(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.claims.as_ref()
    }
}
impl std::fmt::Debug for TestInvokeAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestInvokeAuthorizerOutput");
        formatter.field("client_status", &self.client_status);
        formatter.field("log", &self.log);
        formatter.field("latency", &self.latency);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("policy", &self.policy);
        formatter.field("authorization", &self.authorization);
        formatter.field("claims", &self.claims);
        formatter.finish()
    }
}
/// See [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput)
pub mod test_invoke_authorizer_output {
    /// A builder for [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_status: std::option::Option<i32>,
        pub(crate) log: std::option::Option<std::string::String>,
        pub(crate) latency: std::option::Option<i64>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) claims: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.</p>
        pub fn client_status(mut self, input: i32) -> Self {
            self.client_status = Some(input);
            self
        }
        /// <p>The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.</p>
        pub fn set_client_status(mut self, input: std::option::Option<i32>) -> Self {
            self.client_status = input;
            self
        }
        /// <p>The API Gateway execution log for the test authorizer request.</p>
        pub fn log(mut self, input: impl Into<std::string::String>) -> Self {
            self.log = Some(input.into());
            self
        }
        /// <p>The API Gateway execution log for the test authorizer request.</p>
        pub fn set_log(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log = input;
            self
        }
        /// <p>The execution latency of the test authorizer request.</p>
        pub fn latency(mut self, input: i64) -> Self {
            self.latency = Some(input);
            self
        }
        /// <p>The execution latency of the test authorizer request.</p>
        pub fn set_latency(mut self, input: std::option::Option<i64>) -> Self {
            self.latency = input;
            self
        }
        /// <p>The principal identity returned by the <a>Authorizer</a></p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal identity returned by the <a>Authorizer</a></p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The JSON policy document returned by the <a>Authorizer</a></p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The JSON policy document returned by the <a>Authorizer</a></p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Adds a key-value pair to `authorization`.
        ///
        /// To override the contents of this collection use [`set_authorization`](Self::set_authorization).
        ///
        pub fn authorization(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.authorization.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.authorization = Some(hash_map);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_authorization(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// Adds a key-value pair to `claims`.
        ///
        /// To override the contents of this collection use [`set_claims`](Self::set_claims).
        ///
        /// <p>The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.</p>
        pub fn claims(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.claims.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.claims = Some(hash_map);
            self
        }
        /// <p>The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.</p>
        pub fn set_claims(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.claims = input;
            self
        }
        /// Consumes the builder and constructs a [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput)
        pub fn build(self) -> crate::output::TestInvokeAuthorizerOutput {
            crate::output::TestInvokeAuthorizerOutput {
                client_status: self.client_status.unwrap_or_default(),
                log: self.log,
                latency: self.latency.unwrap_or_default(),
                principal_id: self.principal_id,
                policy: self.policy,
                authorization: self.authorization,
                claims: self.claims,
            }
        }
    }
}
impl TestInvokeAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput)
    pub fn builder() -> crate::output::test_invoke_authorizer_output::Builder {
        crate::output::test_invoke_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p>Represents a REST API.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRestApiOutput {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The API's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub minimum_compression_size: std::option::Option<i32>,
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
}
impl PutRestApiOutput {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The API's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub fn binary_media_types(&self) -> std::option::Option<&[std::string::String]> {
        self.binary_media_types.as_deref()
    }
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub fn minimum_compression_size(&self) -> std::option::Option<i32> {
        self.minimum_compression_size
    }
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub fn api_key_source(&self) -> std::option::Option<&crate::model::ApiKeySourceType> {
        self.api_key_source.as_ref()
    }
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
}
impl std::fmt::Debug for PutRestApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRestApiOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.field("binary_media_types", &self.binary_media_types);
        formatter.field("minimum_compression_size", &self.minimum_compression_size);
        formatter.field("api_key_source", &self.api_key_source);
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("policy", &self.policy);
        formatter.field("tags", &self.tags);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.finish()
    }
}
/// See [`PutRestApiOutput`](crate::output::PutRestApiOutput)
pub mod put_rest_api_output {
    /// A builder for [`PutRestApiOutput`](crate::output::PutRestApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_compression_size: std::option::Option<i32>,
        pub(crate) api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The API's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The API's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The API's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Appends an item to `binary_media_types`.
        ///
        /// To override the contents of this collection use [`set_binary_media_types`](Self::set_binary_media_types).
        ///
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn binary_media_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.binary_media_types.unwrap_or_default();
            v.push(input.into());
            self.binary_media_types = Some(v);
            self
        }
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn set_binary_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.binary_media_types = input;
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn minimum_compression_size(mut self, input: i32) -> Self {
            self.minimum_compression_size = Some(input);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn set_minimum_compression_size(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_compression_size = input;
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn api_key_source(mut self, input: crate::model::ApiKeySourceType) -> Self {
            self.api_key_source = Some(input);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn set_api_key_source(
            mut self,
            input: std::option::Option<crate::model::ApiKeySourceType>,
        ) -> Self {
            self.api_key_source = input;
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRestApiOutput`](crate::output::PutRestApiOutput)
        pub fn build(self) -> crate::output::PutRestApiOutput {
            crate::output::PutRestApiOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                created_date: self.created_date,
                version: self.version,
                warnings: self.warnings,
                binary_media_types: self.binary_media_types,
                minimum_compression_size: self.minimum_compression_size,
                api_key_source: self.api_key_source,
                endpoint_configuration: self.endpoint_configuration,
                policy: self.policy,
                tags: self.tags,
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
            }
        }
    }
}
impl PutRestApiOutput {
    /// Creates a new builder-style object to manufacture [`PutRestApiOutput`](crate::output::PutRestApiOutput)
    pub fn builder() -> crate::output::put_rest_api_output::Builder {
        crate::output::put_rest_api_output::Builder::default()
    }
}

/// <p>Represents a method response of a given HTTP status code returned to the client. The method response is passed from the back end through the associated integration response that can be transformed using a mapping template. <!-- API Gateway sends back the status code to the caller as the HTTP status code. Parameters and models can be used to transform the response from the method's integration.--></p>
/// <div class="remarks">
/// <p></p>
/// <h4>Example: A <b>MethodResponse</b> instance of an API</h4>
/// <h5>Request</h5>
/// <p>The example request retrieves a <b>MethodResponse</b> of the 200 status code.</p>
/// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200 HTTP/1.1
/// Content-Type: application/json
/// Host: apigateway.us-east-1.amazonaws.com
/// X-Amz-Date: 20160603T222952Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
/// <h5>Response</h5>
/// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
/// "name": "methodresponse",
/// "templated": true
/// },
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "title": "200"
/// },
/// "methodresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// },
/// "methodresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// }
/// },
/// "responseModels": {
/// "application/json": "Empty"
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": false
/// },
/// "statusCode": "200"
/// }</code></pre>
/// <p></p>
/// </div>
/// <div class="seeAlso">
/// <a>Method</a>, <a>IntegrationResponse</a>, <a>Integration</a>
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutMethodResponseOutput {
    /// <p>The method response's status code.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PutMethodResponseOutput {
    /// <p>The method response's status code.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.response_parameters.as_ref()
    }
    /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
}
impl std::fmt::Debug for PutMethodResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutMethodResponseOutput");
        formatter.field("status_code", &self.status_code);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_models", &self.response_models);
        formatter.finish()
    }
}
/// See [`PutMethodResponseOutput`](crate::output::PutMethodResponseOutput)
pub mod put_method_response_output {
    /// A builder for [`PutMethodResponseOutput`](crate::output::PutMethodResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The method response's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The method response's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMethodResponseOutput`](crate::output::PutMethodResponseOutput)
        pub fn build(self) -> crate::output::PutMethodResponseOutput {
            crate::output::PutMethodResponseOutput {
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_models: self.response_models,
            }
        }
    }
}
impl PutMethodResponseOutput {
    /// Creates a new builder-style object to manufacture [`PutMethodResponseOutput`](crate::output::PutMethodResponseOutput)
    pub fn builder() -> crate::output::put_method_response_output::Builder {
        crate::output::put_method_response_output::Builder::default()
    }
}

/// <p>
/// Represents a client-facing interface by which the client calls the API to access back-end resources. A <b>Method</b> resource is
/// integrated with an <a>Integration</a> resource. Both consist of a request and one or more responses. The method request takes
/// the client input that is passed to the back end through the integration request. A method response returns the output from
/// the back end to the client through an integration response. A method request is embodied in a <b>Method</b> resource, whereas
/// an integration request is embodied in an <a>Integration</a> resource.  On the other hand, a method response is represented
/// by a <a>MethodResponse</a> resource, whereas an integration response is represented by an <a>IntegrationResponse</a> resource.
/// </p>
/// <div class="remarks">
/// <p></p>
/// <h4>Example: Retrive the GET method on a specified resource</h4>
/// <h5>Request</h5>
/// <p>The following example request retrieves the information about the GET method on an API resource (<code>3kzxbg5sa2</code>) of an API (<code>fugvjdxtri</code>). </p>
/// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
/// Content-Type: application/json
/// Host: apigateway.us-east-1.amazonaws.com
/// X-Amz-Date: 20160603T210259Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
/// <h5>Response</h5>
/// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": [
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
/// "name": "integration",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
/// "name": "integrationresponse",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
/// "name": "method",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
/// "name": "methodresponse",
/// "templated": true
/// }
/// ],
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
/// "name": "GET",
/// "title": "GET"
/// },
/// "integration:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "method:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
/// },
/// "method:integration": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "method:responses": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "method:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
/// },
/// "methodresponse:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
/// "templated": true
/// }
/// },
/// "apiKeyRequired": true,
/// "authorizationType": "NONE",
/// "httpMethod": "GET",
/// "_embedded": {
/// "method:integration": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integration:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integration:responses": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "integration:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integrationresponse:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
/// "templated": true
/// }
/// },
/// "cacheKeyParameters": [],
/// "cacheNamespace": "3kzxbg5sa2",
/// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
/// "httpMethod": "POST",
/// "passthroughBehavior": "WHEN_NO_MATCH",
/// "requestParameters": {
/// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
/// },
/// "requestTemplates": {
/// "application/json": "{\n}"
/// },
/// "type": "AWS",
/// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
/// "_embedded": {
/// "integration:responses": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "integrationresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
/// },
/// "integrationresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
/// }
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": "'application/xml'"
/// },
/// "responseTemplates": {
/// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E\")"
/// },
/// "statusCode": "200"
/// }
/// }
/// },
/// "method:responses": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "methodresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// },
/// "methodresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// }
/// },
/// "responseModels": {
/// "application/json": "Empty"
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": false
/// },
/// "statusCode": "200"
/// }
/// }
/// }</code></pre>
/// <p>In the example above, the response template for the <code>200 OK</code> response maps the JSON output from the <code>ListStreams</code> action in the back end to an XML output. The mapping template is URL-encoded as <code>%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E</code> and the output is decoded using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#util-templat-reference">$util.urlDecode()</a> helper function.</p>
/// </div>
/// <div class="seeAlso">
/// <a>MethodResponse</a>, <a>Integration</a>, <a>IntegrationResponse</a>, <a>Resource</a>,
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-method-settings.html">Set up an API's method</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutMethodOutput {
    /// <p>The method's HTTP verb.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub authorization_type: std::option::Option<std::string::String>,
    /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
    pub api_key_required: std::option::Option<bool>,
    /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
    pub request_validator_id: std::option::Option<std::string::String>,
    /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Gets a method response associated with a given HTTP status code. </p>
    /// <div class="remarks">
    /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
    /// <h4>Example: Get a 200 OK response of a GET method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T215008Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": false,
    /// "method.response.header.operand_2": false,
    /// "method.response.header.operand_1": false
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
    /// </div>
    pub method_responses: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
    >,
    /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: </h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T213210Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "0cjtch",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestTemplates": {
    /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": "integration.response.body.op",
    /// "method.response.header.operand_2": "integration.response.body.b",
    /// "method.response.header.operand_1": "integration.response.body.a"
    /// },
    /// "responseTemplates": {
    /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
    /// },
    /// "selectionPattern": "",
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
    /// </div>
    pub method_integration: std::option::Option<crate::model::Integration>,
    /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PutMethodOutput {
    /// <p>The method's HTTP verb.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub fn authorization_type(&self) -> std::option::Option<&str> {
        self.authorization_type.as_deref()
    }
    /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
    pub fn api_key_required(&self) -> std::option::Option<bool> {
        self.api_key_required
    }
    /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
    pub fn request_validator_id(&self) -> std::option::Option<&str> {
        self.request_validator_id.as_deref()
    }
    /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.request_parameters.as_ref()
    }
    /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>Gets a method response associated with a given HTTP status code. </p>
    /// <div class="remarks">
    /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
    /// <h4>Example: Get a 200 OK response of a GET method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T215008Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": false,
    /// "method.response.header.operand_2": false,
    /// "method.response.header.operand_1": false
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
    /// </div>
    pub fn method_responses(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
    > {
        self.method_responses.as_ref()
    }
    /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: </h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T213210Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "0cjtch",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestTemplates": {
    /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": "integration.response.body.op",
    /// "method.response.header.operand_2": "integration.response.body.b",
    /// "method.response.header.operand_1": "integration.response.body.a"
    /// },
    /// "responseTemplates": {
    /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
    /// },
    /// "selectionPattern": "",
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
    /// </div>
    pub fn method_integration(&self) -> std::option::Option<&crate::model::Integration> {
        self.method_integration.as_ref()
    }
    /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
}
impl std::fmt::Debug for PutMethodOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutMethodOutput");
        formatter.field("http_method", &self.http_method);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("request_validator_id", &self.request_validator_id);
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_models", &self.request_models);
        formatter.field("method_responses", &self.method_responses);
        formatter.field("method_integration", &self.method_integration);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.finish()
    }
}
/// See [`PutMethodOutput`](crate::output::PutMethodOutput)
pub mod put_method_output {
    /// A builder for [`PutMethodOutput`](crate::output::PutMethodOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) authorization_type: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) request_validator_id: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) method_responses: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
        >,
        pub(crate) method_integration: std::option::Option<crate::model::Integration>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The method's HTTP verb.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>The method's HTTP verb.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn authorization_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_type = Some(input.into());
            self
        }
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_validator_id = Some(input.into());
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_validator_id = input;
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `method_responses`.
        ///
        /// To override the contents of this collection use [`set_method_responses`](Self::set_method_responses).
        ///
        /// <p>Gets a method response associated with a given HTTP status code. </p>
        /// <div class="remarks">
        /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
        /// <h4>Example: Get a 200 OK response of a GET method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T215008Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": false,
        /// "method.response.header.operand_2": false,
        /// "method.response.header.operand_1": false
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
        /// </div>
        pub fn method_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MethodResponse>,
        ) -> Self {
            let mut hash_map = self.method_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.method_responses = Some(hash_map);
            self
        }
        /// <p>Gets a method response associated with a given HTTP status code. </p>
        /// <div class="remarks">
        /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
        /// <h4>Example: Get a 200 OK response of a GET method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T215008Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": false,
        /// "method.response.header.operand_2": false,
        /// "method.response.header.operand_1": false
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
        /// </div>
        pub fn set_method_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
            >,
        ) -> Self {
            self.method_responses = input;
            self
        }
        /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: </h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T213210Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "0cjtch",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestTemplates": {
        /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": "integration.response.body.op",
        /// "method.response.header.operand_2": "integration.response.body.b",
        /// "method.response.header.operand_1": "integration.response.body.a"
        /// },
        /// "responseTemplates": {
        /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
        /// },
        /// "selectionPattern": "",
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
        /// </div>
        pub fn method_integration(mut self, input: crate::model::Integration) -> Self {
            self.method_integration = Some(input);
            self
        }
        /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: </h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T213210Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "0cjtch",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestTemplates": {
        /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": "integration.response.body.op",
        /// "method.response.header.operand_2": "integration.response.body.b",
        /// "method.response.header.operand_1": "integration.response.body.a"
        /// },
        /// "responseTemplates": {
        /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
        /// },
        /// "selectionPattern": "",
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
        /// </div>
        pub fn set_method_integration(
            mut self,
            input: std::option::Option<crate::model::Integration>,
        ) -> Self {
            self.method_integration = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMethodOutput`](crate::output::PutMethodOutput)
        pub fn build(self) -> crate::output::PutMethodOutput {
            crate::output::PutMethodOutput {
                http_method: self.http_method,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                api_key_required: self.api_key_required,
                request_validator_id: self.request_validator_id,
                operation_name: self.operation_name,
                request_parameters: self.request_parameters,
                request_models: self.request_models,
                method_responses: self.method_responses,
                method_integration: self.method_integration,
                authorization_scopes: self.authorization_scopes,
            }
        }
    }
}
impl PutMethodOutput {
    /// Creates a new builder-style object to manufacture [`PutMethodOutput`](crate::output::PutMethodOutput)
    pub fn builder() -> crate::output::put_method_output::Builder {
        crate::output::put_method_output::Builder::default()
    }
}

/// <p>Represents an integration response. The status code must map to an existing <a>MethodResponse</a>, and parameters and templates can be used to transform the back-end response.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutIntegrationResponseOutput {
    /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    pub selection_pattern: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
    /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    pub content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
}
impl PutIntegrationResponseOutput {
    /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    pub fn selection_pattern(&self) -> std::option::Option<&str> {
        self.selection_pattern.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
    /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    pub fn content_handling(&self) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling.as_ref()
    }
}
impl std::fmt::Debug for PutIntegrationResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutIntegrationResponseOutput");
        formatter.field("status_code", &self.status_code);
        formatter.field("selection_pattern", &self.selection_pattern);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field("content_handling", &self.content_handling);
        formatter.finish()
    }
}
/// See [`PutIntegrationResponseOutput`](crate::output::PutIntegrationResponseOutput)
pub mod put_integration_response_output {
    /// A builder for [`PutIntegrationResponseOutput`](crate::output::PutIntegrationResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) selection_pattern: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
    }
    impl Builder {
        /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
        pub fn selection_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_pattern = Some(input.into());
            self
        }
        /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
        pub fn set_selection_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_pattern = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// Consumes the builder and constructs a [`PutIntegrationResponseOutput`](crate::output::PutIntegrationResponseOutput)
        pub fn build(self) -> crate::output::PutIntegrationResponseOutput {
            crate::output::PutIntegrationResponseOutput {
                status_code: self.status_code,
                selection_pattern: self.selection_pattern,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                content_handling: self.content_handling,
            }
        }
    }
}
impl PutIntegrationResponseOutput {
    /// Creates a new builder-style object to manufacture [`PutIntegrationResponseOutput`](crate::output::PutIntegrationResponseOutput)
    pub fn builder() -> crate::output::put_integration_response_output::Builder {
        crate::output::put_integration_response_output::Builder::default()
    }
}

/// <p>Represents an HTTP, HTTP_PROXY, AWS, AWS_PROXY, or Mock integration.</p>
/// <div class="remarks">In the API Gateway console, the built-in Lambda integration is an AWS integration.</div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutIntegrationOutput {
    /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
    /// <ul>
    /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
    /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
    /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
    /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
    /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
    /// </ul>
    /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
    pub r#type: std::option::Option<crate::model::IntegrationType>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
    /// <ul>
    /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
    /// </li>
    /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
    /// </li></ul>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <div>
    /// <p>
    /// Specifies how the method request body of an unmapped content type will be passed through the integration request
    /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
    /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
    /// The valid value is one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
    /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
    /// </li>
    /// <li>
    /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
    /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
    /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
    /// </li>
    /// <li>
    /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
    /// request content type does not match any content type associated with the mapping templates defined in the integration request or
    /// no mapping template is defined in the integration request.
    /// </li>
    /// </ul>
    /// </div>
    pub passthrough_behavior: std::option::Option<std::string::String>,
    /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    pub content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    pub timeout_in_millis: i32,
    /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    pub cache_namespace: std::option::Option<std::string::String>,
    /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
    pub cache_key_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the integration's responses.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: Get integration responses of a method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20160607T191449Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
    /// </code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
    /// </div>
    pub integration_responses: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
    >,
    /// <p>Specifies the TLS configuration for an integration.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfig>,
}
impl PutIntegrationOutput {
    /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
    /// <ul>
    /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
    /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
    /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
    /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
    /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
    /// </ul>
    /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.r#type.as_ref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
    /// <ul>
    /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
    /// </li>
    /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
    /// </li></ul>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials(&self) -> std::option::Option<&str> {
        self.credentials.as_deref()
    }
    /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <div>
    /// <p>
    /// Specifies how the method request body of an unmapped content type will be passed through the integration request
    /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
    /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
    /// The valid value is one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
    /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
    /// </li>
    /// <li>
    /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
    /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
    /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
    /// </li>
    /// <li>
    /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
    /// request content type does not match any content type associated with the mapping templates defined in the integration request or
    /// no mapping template is defined in the integration request.
    /// </li>
    /// </ul>
    /// </div>
    pub fn passthrough_behavior(&self) -> std::option::Option<&str> {
        self.passthrough_behavior.as_deref()
    }
    /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    pub fn content_handling(&self) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling.as_ref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    pub fn cache_namespace(&self) -> std::option::Option<&str> {
        self.cache_namespace.as_deref()
    }
    /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
    pub fn cache_key_parameters(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_key_parameters.as_deref()
    }
    /// <p>Specifies the integration's responses.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: Get integration responses of a method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20160607T191449Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
    /// </code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
    /// </div>
    pub fn integration_responses(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
    > {
        self.integration_responses.as_ref()
    }
    /// <p>Specifies the TLS configuration for an integration.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfig> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for PutIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutIntegrationOutput");
        formatter.field("r#type", &self.r#type);
        formatter.field("http_method", &self.http_method);
        formatter.field("uri", &self.uri);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("credentials", &self.credentials);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("content_handling", &self.content_handling);
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("cache_namespace", &self.cache_namespace);
        formatter.field("cache_key_parameters", &self.cache_key_parameters);
        formatter.field("integration_responses", &self.integration_responses);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}
/// See [`PutIntegrationOutput`](crate::output::PutIntegrationOutput)
pub mod put_integration_output {
    /// A builder for [`PutIntegrationOutput`](crate::output::PutIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) credentials: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) passthrough_behavior: std::option::Option<std::string::String>,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) cache_namespace: std::option::Option<std::string::String>,
        pub(crate) cache_key_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) integration_responses: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
        >,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfig>,
    }
    impl Builder {
        /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
        /// <ul>
        /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
        /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
        /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
        /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
        /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
        /// </ul>
        /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
        pub fn r#type(mut self, input: crate::model::IntegrationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
        /// <ul>
        /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
        /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
        /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
        /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
        /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
        /// </ul>
        /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credentials = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// <div>
        /// <p>
        /// Specifies how the method request body of an unmapped content type will be passed through the integration request
        /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
        /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
        /// The valid value is one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
        /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
        /// </li>
        /// <li>
        /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
        /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
        /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
        /// </li>
        /// <li>
        /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
        /// request content type does not match any content type associated with the mapping templates defined in the integration request or
        /// no mapping template is defined in the integration request.
        /// </li>
        /// </ul>
        /// </div>
        pub fn passthrough_behavior(mut self, input: impl Into<std::string::String>) -> Self {
            self.passthrough_behavior = Some(input.into());
            self
        }
        /// <div>
        /// <p>
        /// Specifies how the method request body of an unmapped content type will be passed through the integration request
        /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
        /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
        /// The valid value is one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
        /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
        /// </li>
        /// <li>
        /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
        /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
        /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
        /// </li>
        /// <li>
        /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
        /// request content type does not match any content type associated with the mapping templates defined in the integration request or
        /// no mapping template is defined in the integration request.
        /// </li>
        /// </ul>
        /// </div>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn cache_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_namespace = Some(input.into());
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn set_cache_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_namespace = input;
            self
        }
        /// Appends an item to `cache_key_parameters`.
        ///
        /// To override the contents of this collection use [`set_cache_key_parameters`](Self::set_cache_key_parameters).
        ///
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn cache_key_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_key_parameters.unwrap_or_default();
            v.push(input.into());
            self.cache_key_parameters = Some(v);
            self
        }
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn set_cache_key_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_key_parameters = input;
            self
        }
        /// Adds a key-value pair to `integration_responses`.
        ///
        /// To override the contents of this collection use [`set_integration_responses`](Self::set_integration_responses).
        ///
        /// <p>Specifies the integration's responses.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: Get integration responses of a method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20160607T191449Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
        /// </code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
        /// </div>
        pub fn integration_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::IntegrationResponse>,
        ) -> Self {
            let mut hash_map = self.integration_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.integration_responses = Some(hash_map);
            self
        }
        /// <p>Specifies the integration's responses.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: Get integration responses of a method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20160607T191449Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
        /// </code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
        /// </div>
        pub fn set_integration_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
            >,
        ) -> Self {
            self.integration_responses = input;
            self
        }
        /// <p>Specifies the TLS configuration for an integration.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>Specifies the TLS configuration for an integration.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`PutIntegrationOutput`](crate::output::PutIntegrationOutput)
        pub fn build(self) -> crate::output::PutIntegrationOutput {
            crate::output::PutIntegrationOutput {
                r#type: self.r#type,
                http_method: self.http_method,
                uri: self.uri,
                connection_type: self.connection_type,
                connection_id: self.connection_id,
                credentials: self.credentials,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                passthrough_behavior: self.passthrough_behavior,
                content_handling: self.content_handling,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                cache_namespace: self.cache_namespace,
                cache_key_parameters: self.cache_key_parameters,
                integration_responses: self.integration_responses,
                tls_config: self.tls_config,
            }
        }
    }
}
impl PutIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`PutIntegrationOutput`](crate::output::PutIntegrationOutput)
    pub fn builder() -> crate::output::put_integration_output::Builder {
        crate::output::put_integration_output::Builder::default()
    }
}

/// <p>A gateway response of a given response type and status code, with optional response parameters and mapping templates.</p>
/// <div class="remarks">
/// For more information about valid gateway response types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">Gateway Response Types Supported by API Gateway</a>
/// <div class="example">
/// <h4>Example: Get a Gateway Response of a given response type</h4>
/// <h5>Request</h5>
/// <p>This example shows how to get a gateway response of the <code>MISSING_AUTHENTICATION_TOKEN</code> type.</p>
/// <pre><code>GET /restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN HTTP/1.1
/// Host: beta-apigateway.us-east-1.amazonaws.com
/// Content-Type: application/json
/// X-Amz-Date: 20170503T202516Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=1b52460e3159c1a26cff29093855d50ea141c1c5b937528fecaf60f51129697a
/// Cache-Control: no-cache
/// Postman-Token: 3b2a1ce9-c848-2e26-2e2f-9c2caefbed45
/// </code></pre>
/// <p>The response type is specified as a URL path.</p>
/// <h5>Response</h5>
/// <p>The successful operation returns the <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html",
/// "name": "gatewayresponse",
/// "templated": true
/// },
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// "gatewayresponse:delete": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// }
/// },
/// "defaultResponse": false,
/// "responseParameters": {
/// "gatewayresponse.header.x-request-path": "method.request.path.petId",
/// "gatewayresponse.header.Access-Control-Allow-Origin": "'a.b.c'",
/// "gatewayresponse.header.x-request-query": "method.request.querystring.q",
/// "gatewayresponse.header.x-request-header": "method.request.header.Accept"
/// },
/// "responseTemplates": {
/// "application/json": "{\n     \"message\": $context.error.messageString,\n     \"type\":  \"$context.error.responseType\",\n     \"stage\":  \"$context.stage\",\n     \"resourcePath\":  \"$context.resourcePath\",\n     \"stageVariables.a\":  \"$stageVariables.a\",\n     \"statusCode\": \"'404'\"\n}"
/// },
/// "responseType": "MISSING_AUTHENTICATION_TOKEN",
/// "statusCode": "404"
/// }</code></pre>
/// <p></p>
/// </div>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html">Customize Gateway Responses</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutGatewayResponseOutput {
    /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
    pub response_type: std::option::Option<crate::model::GatewayResponseType>,
    /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    pub default_response: bool,
}
impl PutGatewayResponseOutput {
    /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
    pub fn response_type(&self) -> std::option::Option<&crate::model::GatewayResponseType> {
        self.response_type.as_ref()
    }
    /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    pub fn default_response(&self) -> bool {
        self.default_response
    }
}
impl std::fmt::Debug for PutGatewayResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutGatewayResponseOutput");
        formatter.field("response_type", &self.response_type);
        formatter.field("status_code", &self.status_code);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field("default_response", &self.default_response);
        formatter.finish()
    }
}
/// See [`PutGatewayResponseOutput`](crate::output::PutGatewayResponseOutput)
pub mod put_gateway_response_output {
    /// A builder for [`PutGatewayResponseOutput`](crate::output::PutGatewayResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_type: std::option::Option<crate::model::GatewayResponseType>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) default_response: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.response_type = Some(input);
            self
        }
        /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.response_type = input;
            self
        }
        /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
        pub fn default_response(mut self, input: bool) -> Self {
            self.default_response = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
        pub fn set_default_response(mut self, input: std::option::Option<bool>) -> Self {
            self.default_response = input;
            self
        }
        /// Consumes the builder and constructs a [`PutGatewayResponseOutput`](crate::output::PutGatewayResponseOutput)
        pub fn build(self) -> crate::output::PutGatewayResponseOutput {
            crate::output::PutGatewayResponseOutput {
                response_type: self.response_type,
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                default_response: self.default_response.unwrap_or_default(),
            }
        }
    }
}
impl PutGatewayResponseOutput {
    /// Creates a new builder-style object to manufacture [`PutGatewayResponseOutput`](crate::output::PutGatewayResponseOutput)
    pub fn builder() -> crate::output::put_gateway_response_output::Builder {
        crate::output::put_gateway_response_output::Builder::default()
    }
}

/// <p>Represents a REST API.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportRestApiOutput {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The API's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub minimum_compression_size: std::option::Option<i32>,
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
}
impl ImportRestApiOutput {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The API's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub fn binary_media_types(&self) -> std::option::Option<&[std::string::String]> {
        self.binary_media_types.as_deref()
    }
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub fn minimum_compression_size(&self) -> std::option::Option<i32> {
        self.minimum_compression_size
    }
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub fn api_key_source(&self) -> std::option::Option<&crate::model::ApiKeySourceType> {
        self.api_key_source.as_ref()
    }
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
}
impl std::fmt::Debug for ImportRestApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportRestApiOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.field("binary_media_types", &self.binary_media_types);
        formatter.field("minimum_compression_size", &self.minimum_compression_size);
        formatter.field("api_key_source", &self.api_key_source);
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("policy", &self.policy);
        formatter.field("tags", &self.tags);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.finish()
    }
}
/// See [`ImportRestApiOutput`](crate::output::ImportRestApiOutput)
pub mod import_rest_api_output {
    /// A builder for [`ImportRestApiOutput`](crate::output::ImportRestApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_compression_size: std::option::Option<i32>,
        pub(crate) api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The API's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The API's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The API's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Appends an item to `binary_media_types`.
        ///
        /// To override the contents of this collection use [`set_binary_media_types`](Self::set_binary_media_types).
        ///
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn binary_media_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.binary_media_types.unwrap_or_default();
            v.push(input.into());
            self.binary_media_types = Some(v);
            self
        }
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn set_binary_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.binary_media_types = input;
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn minimum_compression_size(mut self, input: i32) -> Self {
            self.minimum_compression_size = Some(input);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn set_minimum_compression_size(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_compression_size = input;
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn api_key_source(mut self, input: crate::model::ApiKeySourceType) -> Self {
            self.api_key_source = Some(input);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn set_api_key_source(
            mut self,
            input: std::option::Option<crate::model::ApiKeySourceType>,
        ) -> Self {
            self.api_key_source = input;
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportRestApiOutput`](crate::output::ImportRestApiOutput)
        pub fn build(self) -> crate::output::ImportRestApiOutput {
            crate::output::ImportRestApiOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                created_date: self.created_date,
                version: self.version,
                warnings: self.warnings,
                binary_media_types: self.binary_media_types,
                minimum_compression_size: self.minimum_compression_size,
                api_key_source: self.api_key_source,
                endpoint_configuration: self.endpoint_configuration,
                policy: self.policy,
                tags: self.tags,
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
            }
        }
    }
}
impl ImportRestApiOutput {
    /// Creates a new builder-style object to manufacture [`ImportRestApiOutput`](crate::output::ImportRestApiOutput)
    pub fn builder() -> crate::output::import_rest_api_output::Builder {
        crate::output::import_rest_api_output::Builder::default()
    }
}

/// <p>A collection of the imported  <a>DocumentationPart</a> identifiers.</p>
/// <div class="remarks">This is used to return the result when documentation parts in an external (e.g., OpenAPI) file are imported into API Gateway</div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a href="https://docs.aws.amazon.com/apigateway/api-reference/link-relation/documentationpart-import/">documentationpart:import</a>, <a>DocumentationPart</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportDocumentationPartsOutput {
    /// <p>A list of the returned documentation part identifiers.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of warning messages reported during import of documentation parts.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ImportDocumentationPartsOutput {
    /// <p>A list of the returned documentation part identifiers.</p>
    pub fn ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ids.as_deref()
    }
    /// <p>A list of warning messages reported during import of documentation parts.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for ImportDocumentationPartsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportDocumentationPartsOutput");
        formatter.field("ids", &self.ids);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`ImportDocumentationPartsOutput`](crate::output::ImportDocumentationPartsOutput)
pub mod import_documentation_parts_output {
    /// A builder for [`ImportDocumentationPartsOutput`](crate::output::ImportDocumentationPartsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>A list of the returned documentation part identifiers.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>A list of the returned documentation part identifiers.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>A list of warning messages reported during import of documentation parts.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>A list of warning messages reported during import of documentation parts.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportDocumentationPartsOutput`](crate::output::ImportDocumentationPartsOutput)
        pub fn build(self) -> crate::output::ImportDocumentationPartsOutput {
            crate::output::ImportDocumentationPartsOutput {
                ids: self.ids,
                warnings: self.warnings,
            }
        }
    }
}
impl ImportDocumentationPartsOutput {
    /// Creates a new builder-style object to manufacture [`ImportDocumentationPartsOutput`](crate::output::ImportDocumentationPartsOutput)
    pub fn builder() -> crate::output::import_documentation_parts_output::Builder {
        crate::output::import_documentation_parts_output::Builder::default()
    }
}

/// <p>The identifier of an <a>ApiKey</a> used in a <a>UsagePlan</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportApiKeysOutput {
    /// <p>A list of all the <a>ApiKey</a> identifiers.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of warning messages.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ImportApiKeysOutput {
    /// <p>A list of all the <a>ApiKey</a> identifiers.</p>
    pub fn ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ids.as_deref()
    }
    /// <p>A list of warning messages.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for ImportApiKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportApiKeysOutput");
        formatter.field("ids", &self.ids);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`ImportApiKeysOutput`](crate::output::ImportApiKeysOutput)
pub mod import_api_keys_output {
    /// A builder for [`ImportApiKeysOutput`](crate::output::ImportApiKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>A list of all the <a>ApiKey</a> identifiers.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>A list of all the <a>ApiKey</a> identifiers.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>A list of warning messages.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>A list of warning messages.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportApiKeysOutput`](crate::output::ImportApiKeysOutput)
        pub fn build(self) -> crate::output::ImportApiKeysOutput {
            crate::output::ImportApiKeysOutput {
                ids: self.ids,
                warnings: self.warnings,
            }
        }
    }
}
impl ImportApiKeysOutput {
    /// Creates a new builder-style object to manufacture [`ImportApiKeysOutput`](crate::output::ImportApiKeysOutput)
    pub fn builder() -> crate::output::import_api_keys_output::Builder {
        crate::output::import_api_keys_output::Builder::default()
    }
}

/// <p>The collection of VPC links under the caller's account in a region.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-with-private-integration.html">Getting Started with Private Integrations</a>,
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-private-integration.html">Set up Private Integrations</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVpcLinksOutput {
    /// <p>The current page of elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::VpcLink>>,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetVpcLinksOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::VpcLink]> {
        self.items.as_deref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetVpcLinksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVpcLinksOutput");
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput)
pub mod get_vpc_links_output {
    /// A builder for [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::VpcLink>>,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::VpcLink>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcLink>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput)
        pub fn build(self) -> crate::output::GetVpcLinksOutput {
            crate::output::GetVpcLinksOutput {
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetVpcLinksOutput {
    /// Creates a new builder-style object to manufacture [`GetVpcLinksOutput`](crate::output::GetVpcLinksOutput)
    pub fn builder() -> crate::output::get_vpc_links_output::Builder {
        crate::output::get_vpc_links_output::Builder::default()
    }
}

/// <p>An API Gateway VPC link for a <a>RestApi</a> to access resources in an Amazon Virtual Private Cloud (VPC).</p>
/// <div class="remarks">
/// <p><p>To enable access to a resource in an Amazon Virtual Private Cloud through Amazon API Gateway, you, as an API developer, create a <a>VpcLink</a> resource targeted for one or more network load balancers of the VPC and then integrate an API method with a private integration that uses the <a>VpcLink</a>. The private integration has an integration type of <code>HTTP</code> or <code>HTTP_PROXY</code> and has a connection type of <code>VPC_LINK</code>. The integration uses the <code>connectionId</code> property to identify the <a>VpcLink</a> used.</p></p>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVpcLinkOutput {
    /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name used to label and identify the VPC link.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the VPC link.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    pub target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
    pub status: std::option::Option<crate::model::VpcLinkStatus>,
    /// <p>A description about the VPC link status.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetVpcLinkOutput {
    /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name used to label and identify the VPC link.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the VPC link.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
    pub fn target_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.target_arns.as_deref()
    }
    /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VpcLinkStatus> {
        self.status.as_ref()
    }
    /// <p>A description about the VPC link status.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetVpcLinkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVpcLinkOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("target_arns", &self.target_arns);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput)
pub mod get_vpc_link_output {
    /// A builder for [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::VpcLinkStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name used to label and identify the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name used to label and identify the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `target_arns`.
        ///
        /// To override the contents of this collection use [`set_target_arns`](Self::set_target_arns).
        ///
        /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_arns.unwrap_or_default();
            v.push(input.into());
            self.target_arns = Some(v);
            self
        }
        /// <p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn set_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_arns = input;
            self
        }
        /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
        pub fn status(mut self, input: crate::model::VpcLinkStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VpcLinkStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A description about the VPC link status.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A description about the VPC link status.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput)
        pub fn build(self) -> crate::output::GetVpcLinkOutput {
            crate::output::GetVpcLinkOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                target_arns: self.target_arns,
                status: self.status,
                status_message: self.status_message,
                tags: self.tags,
            }
        }
    }
}
impl GetVpcLinkOutput {
    /// Creates a new builder-style object to manufacture [`GetVpcLinkOutput`](crate::output::GetVpcLinkOutput)
    pub fn builder() -> crate::output::get_vpc_link_output::Builder {
        crate::output::get_vpc_link_output::Builder::default()
    }
}

/// <p>Represents a collection of usage plans for an AWS account.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsagePlansOutput {
    /// <p>The current page of elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::UsagePlan>>,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetUsagePlansOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::UsagePlan]> {
        self.items.as_deref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetUsagePlansOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsagePlansOutput");
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetUsagePlansOutput`](crate::output::GetUsagePlansOutput)
pub mod get_usage_plans_output {
    /// A builder for [`GetUsagePlansOutput`](crate::output::GetUsagePlansOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::UsagePlan>>,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::UsagePlan>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsagePlan>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsagePlansOutput`](crate::output::GetUsagePlansOutput)
        pub fn build(self) -> crate::output::GetUsagePlansOutput {
            crate::output::GetUsagePlansOutput {
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetUsagePlansOutput {
    /// Creates a new builder-style object to manufacture [`GetUsagePlansOutput`](crate::output::GetUsagePlansOutput)
    pub fn builder() -> crate::output::get_usage_plans_output::Builder {
        crate::output::get_usage_plans_output::Builder::default()
    }
}

/// <p>Represents the collection of usage plan keys added to usage plans for the associated API keys and, possibly, other types of keys.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsagePlanKeysOutput {
    /// <p>The current page of elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::UsagePlanKey>>,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetUsagePlanKeysOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::UsagePlanKey]> {
        self.items.as_deref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetUsagePlanKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsagePlanKeysOutput");
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetUsagePlanKeysOutput`](crate::output::GetUsagePlanKeysOutput)
pub mod get_usage_plan_keys_output {
    /// A builder for [`GetUsagePlanKeysOutput`](crate::output::GetUsagePlanKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::UsagePlanKey>>,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::UsagePlanKey>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsagePlanKey>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsagePlanKeysOutput`](crate::output::GetUsagePlanKeysOutput)
        pub fn build(self) -> crate::output::GetUsagePlanKeysOutput {
            crate::output::GetUsagePlanKeysOutput {
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetUsagePlanKeysOutput {
    /// Creates a new builder-style object to manufacture [`GetUsagePlanKeysOutput`](crate::output::GetUsagePlanKeysOutput)
    pub fn builder() -> crate::output::get_usage_plan_keys_output::Builder {
        crate::output::get_usage_plan_keys_output::Builder::default()
    }
}

/// <p>Represents a usage plan key to identify a plan customer.</p>
/// <div class="remarks">
/// <p>To associate an API stage with a selected API key in a usage plan, you must create a UsagePlanKey resource to represent the selected <a>ApiKey</a>.</p>
/// </div>"
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsagePlanKeyOutput {
    /// <p>The Id of a usage plan key.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The value of a usage plan key.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The name of a usage plan key.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetUsagePlanKeyOutput {
    /// <p>The Id of a usage plan key.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The value of a usage plan key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The name of a usage plan key.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetUsagePlanKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsagePlanKeyOutput");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`GetUsagePlanKeyOutput`](crate::output::GetUsagePlanKeyOutput)
pub mod get_usage_plan_key_output {
    /// A builder for [`GetUsagePlanKeyOutput`](crate::output::GetUsagePlanKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Id of a usage plan key.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The Id of a usage plan key.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value of a usage plan key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a usage plan key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The name of a usage plan key.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a usage plan key.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsagePlanKeyOutput`](crate::output::GetUsagePlanKeyOutput)
        pub fn build(self) -> crate::output::GetUsagePlanKeyOutput {
            crate::output::GetUsagePlanKeyOutput {
                id: self.id,
                r#type: self.r#type,
                value: self.value,
                name: self.name,
            }
        }
    }
}
impl GetUsagePlanKeyOutput {
    /// Creates a new builder-style object to manufacture [`GetUsagePlanKeyOutput`](crate::output::GetUsagePlanKeyOutput)
    pub fn builder() -> crate::output::get_usage_plan_key_output::Builder {
        crate::output::get_usage_plan_key_output::Builder::default()
    }
}

/// <p>Represents a usage plan than can specify who can assess associated API stages with specified request limits and quotas.</p>
/// <div class="remarks">
/// <p>In a usage plan, you associate an API by specifying the API's Id and a stage name of the specified API. You add plan customers by adding API keys to the plan. </p>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsagePlanOutput {
    /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of a usage plan.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of a usage plan.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The associated API stages of a usage plan.</p>
    pub api_stages: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
    /// <p>The request throttle limits of a usage plan.</p>
    pub throttle: std::option::Option<crate::model::ThrottleSettings>,
    /// <p>The maximum number of permitted requests per a given unit time interval.</p>
    pub quota: std::option::Option<crate::model::QuotaSettings>,
    /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
    pub product_code: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetUsagePlanOutput {
    /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of a usage plan.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of a usage plan.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The associated API stages of a usage plan.</p>
    pub fn api_stages(&self) -> std::option::Option<&[crate::model::ApiStage]> {
        self.api_stages.as_deref()
    }
    /// <p>The request throttle limits of a usage plan.</p>
    pub fn throttle(&self) -> std::option::Option<&crate::model::ThrottleSettings> {
        self.throttle.as_ref()
    }
    /// <p>The maximum number of permitted requests per a given unit time interval.</p>
    pub fn quota(&self) -> std::option::Option<&crate::model::QuotaSettings> {
        self.quota.as_ref()
    }
    /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
    pub fn product_code(&self) -> std::option::Option<&str> {
        self.product_code.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetUsagePlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsagePlanOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("api_stages", &self.api_stages);
        formatter.field("throttle", &self.throttle);
        formatter.field("quota", &self.quota);
        formatter.field("product_code", &self.product_code);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetUsagePlanOutput`](crate::output::GetUsagePlanOutput)
pub mod get_usage_plan_output {
    /// A builder for [`GetUsagePlanOutput`](crate::output::GetUsagePlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) api_stages: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        pub(crate) throttle: std::option::Option<crate::model::ThrottleSettings>,
        pub(crate) quota: std::option::Option<crate::model::QuotaSettings>,
        pub(crate) product_code: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of a <a>UsagePlan</a> resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of a usage plan.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a usage plan.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of a usage plan.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a usage plan.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `api_stages`.
        ///
        /// To override the contents of this collection use [`set_api_stages`](Self::set_api_stages).
        ///
        /// <p>The associated API stages of a usage plan.</p>
        pub fn api_stages(mut self, input: impl Into<crate::model::ApiStage>) -> Self {
            let mut v = self.api_stages.unwrap_or_default();
            v.push(input.into());
            self.api_stages = Some(v);
            self
        }
        /// <p>The associated API stages of a usage plan.</p>
        pub fn set_api_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        ) -> Self {
            self.api_stages = input;
            self
        }
        /// <p>The request throttle limits of a usage plan.</p>
        pub fn throttle(mut self, input: crate::model::ThrottleSettings) -> Self {
            self.throttle = Some(input);
            self
        }
        /// <p>The request throttle limits of a usage plan.</p>
        pub fn set_throttle(
            mut self,
            input: std::option::Option<crate::model::ThrottleSettings>,
        ) -> Self {
            self.throttle = input;
            self
        }
        /// <p>The maximum number of permitted requests per a given unit time interval.</p>
        pub fn quota(mut self, input: crate::model::QuotaSettings) -> Self {
            self.quota = Some(input);
            self
        }
        /// <p>The maximum number of permitted requests per a given unit time interval.</p>
        pub fn set_quota(
            mut self,
            input: std::option::Option<crate::model::QuotaSettings>,
        ) -> Self {
            self.quota = input;
            self
        }
        /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code = Some(input.into());
            self
        }
        /// <p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_code = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsagePlanOutput`](crate::output::GetUsagePlanOutput)
        pub fn build(self) -> crate::output::GetUsagePlanOutput {
            crate::output::GetUsagePlanOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                api_stages: self.api_stages,
                throttle: self.throttle,
                quota: self.quota,
                product_code: self.product_code,
                tags: self.tags,
            }
        }
    }
}
impl GetUsagePlanOutput {
    /// Creates a new builder-style object to manufacture [`GetUsagePlanOutput`](crate::output::GetUsagePlanOutput)
    pub fn builder() -> crate::output::get_usage_plan_output::Builder {
        crate::output::get_usage_plan_output::Builder::default()
    }
}

/// <p>Represents the usage data of a usage plan.</p>
/// <div class="remarks"></div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>,
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-usage-plans-with-console.html#api-gateway-usage-plan-manage-usage">Manage Usage in a Usage Plan</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsageOutput {
    /// <p>The plan Id associated with this usage data.</p>
    pub usage_plan_id: std::option::Option<std::string::String>,
    /// <p>The starting date of the usage data.</p>
    pub start_date: std::option::Option<std::string::String>,
    /// <p>The ending date of the usage data.</p>
    pub end_date: std::option::Option<std::string::String>,
    /// <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
    pub items: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::vec::Vec<i64>>>,
    >,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetUsageOutput {
    /// <p>The plan Id associated with this usage data.</p>
    pub fn usage_plan_id(&self) -> std::option::Option<&str> {
        self.usage_plan_id.as_deref()
    }
    /// <p>The starting date of the usage data.</p>
    pub fn start_date(&self) -> std::option::Option<&str> {
        self.start_date.as_deref()
    }
    /// <p>The ending date of the usage data.</p>
    pub fn end_date(&self) -> std::option::Option<&str> {
        self.end_date.as_deref()
    }
    /// <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
    pub fn items(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::vec::Vec<i64>>>,
    > {
        self.items.as_ref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetUsageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsageOutput");
        formatter.field("usage_plan_id", &self.usage_plan_id);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetUsageOutput`](crate::output::GetUsageOutput)
pub mod get_usage_output {
    /// A builder for [`GetUsageOutput`](crate::output::GetUsageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_plan_id: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) end_date: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::vec::Vec<i64>>>,
        >,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The plan Id associated with this usage data.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_plan_id = Some(input.into());
            self
        }
        /// <p>The plan Id associated with this usage data.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_plan_id = input;
            self
        }
        /// <p>The starting date of the usage data.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The starting date of the usage data.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The ending date of the usage data.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date = Some(input.into());
            self
        }
        /// <p>The ending date of the usage data.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_date = input;
            self
        }
        /// Adds a key-value pair to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
        pub fn items(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::vec::Vec<i64>>>,
        ) -> Self {
            let mut hash_map = self.items.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.items = Some(hash_map);
            self
        }
        /// <p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::vec::Vec<i64>>>,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsageOutput`](crate::output::GetUsageOutput)
        pub fn build(self) -> crate::output::GetUsageOutput {
            crate::output::GetUsageOutput {
                usage_plan_id: self.usage_plan_id,
                start_date: self.start_date,
                end_date: self.end_date,
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetUsageOutput {
    /// Creates a new builder-style object to manufacture [`GetUsageOutput`](crate::output::GetUsageOutput)
    pub fn builder() -> crate::output::get_usage_output::Builder {
        crate::output::get_usage_output::Builder::default()
    }
}

/// <p>The collection of tags. Each tag element is associated with a given resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTagsOutput {
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetTagsOutput {
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetTagsOutput`](crate::output::GetTagsOutput)
pub mod get_tags_output {
    /// A builder for [`GetTagsOutput`](crate::output::GetTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTagsOutput`](crate::output::GetTagsOutput)
        pub fn build(self) -> crate::output::GetTagsOutput {
            crate::output::GetTagsOutput { tags: self.tags }
        }
    }
}
impl GetTagsOutput {
    /// Creates a new builder-style object to manufacture [`GetTagsOutput`](crate::output::GetTagsOutput)
    pub fn builder() -> crate::output::get_tags_output::Builder {
        crate::output::get_tags_output::Builder::default()
    }
}

/// <p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>
/// <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/stages.html">Deploying API in Stages</a></div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStagesOutput {
    /// <p>The current page of elements from this collection.</p>
    pub item: std::option::Option<std::vec::Vec<crate::model::Stage>>,
}
impl GetStagesOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn item(&self) -> std::option::Option<&[crate::model::Stage]> {
        self.item.as_deref()
    }
}
impl std::fmt::Debug for GetStagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStagesOutput");
        formatter.field("item", &self.item);
        formatter.finish()
    }
}
/// See [`GetStagesOutput`](crate::output::GetStagesOutput)
pub mod get_stages_output {
    /// A builder for [`GetStagesOutput`](crate::output::GetStagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item: std::option::Option<std::vec::Vec<crate::model::Stage>>,
    }
    impl Builder {
        /// Appends an item to `item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn item(mut self, input: impl Into<crate::model::Stage>) -> Self {
            let mut v = self.item.unwrap_or_default();
            v.push(input.into());
            self.item = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_item(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Stage>>,
        ) -> Self {
            self.item = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStagesOutput`](crate::output::GetStagesOutput)
        pub fn build(self) -> crate::output::GetStagesOutput {
            crate::output::GetStagesOutput { item: self.item }
        }
    }
}
impl GetStagesOutput {
    /// Creates a new builder-style object to manufacture [`GetStagesOutput`](crate::output::GetStagesOutput)
    pub fn builder() -> crate::output::get_stages_output::Builder {
        crate::output::get_stages_output::Builder::default()
    }
}

/// <p>Represents a unique identifier for a version of a deployed <a>RestApi</a> that is callable by users.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html">Deploy an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStageOutput {
    /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The identifier of a client certificate for an API stage.</p>
    pub client_certificate_id: std::option::Option<std::string::String>,
    /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The stage's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
    pub cache_cluster_enabled: bool,
    /// <p>The size of the cache cluster for the stage, if enabled.</p>
    pub cache_cluster_size: std::option::Option<crate::model::CacheClusterSize>,
    /// <p>The status of the cache cluster for the stage, if enabled.</p>
    pub cache_cluster_status: std::option::Option<crate::model::CacheClusterStatus>,
    /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
    pub method_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
    >,
    /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
    /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
    pub variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The version of the associated API documentation.</p>
    pub documentation_version: std::option::Option<std::string::String>,
    /// <p>Settings for logging access in this stage.</p>
    pub access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
    /// <p>Settings for the canary deployment in this stage.</p>
    pub canary_settings: std::option::Option<crate::model::CanarySettings>,
    /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
    pub tracing_enabled: bool,
    /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
    pub web_acl_arn: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The timestamp when the stage was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when the stage last updated.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
}
impl GetStageOutput {
    /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The identifier of a client certificate for an API stage.</p>
    pub fn client_certificate_id(&self) -> std::option::Option<&str> {
        self.client_certificate_id.as_deref()
    }
    /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The stage's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
    pub fn cache_cluster_enabled(&self) -> bool {
        self.cache_cluster_enabled
    }
    /// <p>The size of the cache cluster for the stage, if enabled.</p>
    pub fn cache_cluster_size(&self) -> std::option::Option<&crate::model::CacheClusterSize> {
        self.cache_cluster_size.as_ref()
    }
    /// <p>The status of the cache cluster for the stage, if enabled.</p>
    pub fn cache_cluster_status(&self) -> std::option::Option<&crate::model::CacheClusterStatus> {
        self.cache_cluster_status.as_ref()
    }
    /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
    pub fn method_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
    > {
        self.method_settings.as_ref()
    }
    /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
    /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
    pub fn variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.variables.as_ref()
    }
    /// <p>The version of the associated API documentation.</p>
    pub fn documentation_version(&self) -> std::option::Option<&str> {
        self.documentation_version.as_deref()
    }
    /// <p>Settings for logging access in this stage.</p>
    pub fn access_log_settings(&self) -> std::option::Option<&crate::model::AccessLogSettings> {
        self.access_log_settings.as_ref()
    }
    /// <p>Settings for the canary deployment in this stage.</p>
    pub fn canary_settings(&self) -> std::option::Option<&crate::model::CanarySettings> {
        self.canary_settings.as_ref()
    }
    /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
    pub fn tracing_enabled(&self) -> bool {
        self.tracing_enabled
    }
    /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
    pub fn web_acl_arn(&self) -> std::option::Option<&str> {
        self.web_acl_arn.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The timestamp when the stage was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The timestamp when the stage last updated.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
}
impl std::fmt::Debug for GetStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStageOutput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("client_certificate_id", &self.client_certificate_id);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("description", &self.description);
        formatter.field("cache_cluster_enabled", &self.cache_cluster_enabled);
        formatter.field("cache_cluster_size", &self.cache_cluster_size);
        formatter.field("cache_cluster_status", &self.cache_cluster_status);
        formatter.field("method_settings", &self.method_settings);
        formatter.field("variables", &self.variables);
        formatter.field("documentation_version", &self.documentation_version);
        formatter.field("access_log_settings", &self.access_log_settings);
        formatter.field("canary_settings", &self.canary_settings);
        formatter.field("tracing_enabled", &self.tracing_enabled);
        formatter.field("web_acl_arn", &self.web_acl_arn);
        formatter.field("tags", &self.tags);
        formatter.field("created_date", &self.created_date);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.finish()
    }
}
/// See [`GetStageOutput`](crate::output::GetStageOutput)
pub mod get_stage_output {
    /// A builder for [`GetStageOutput`](crate::output::GetStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_enabled: std::option::Option<bool>,
        pub(crate) cache_cluster_size: std::option::Option<crate::model::CacheClusterSize>,
        pub(crate) cache_cluster_status: std::option::Option<crate::model::CacheClusterStatus>,
        pub(crate) method_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
        >,
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) documentation_version: std::option::Option<std::string::String>,
        pub(crate) access_log_settings: std::option::Option<crate::model::AccessLogSettings>,
        pub(crate) canary_settings: std::option::Option<crate::model::CanarySettings>,
        pub(crate) tracing_enabled: std::option::Option<bool>,
        pub(crate) web_acl_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier of the <a>Deployment</a> that the stage points to.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The identifier of a client certificate for an API stage.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of a client certificate for an API stage.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The stage's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The stage's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
        pub fn cache_cluster_enabled(mut self, input: bool) -> Self {
            self.cache_cluster_enabled = Some(input);
            self
        }
        /// <p>Specifies whether a cache cluster is enabled for the stage.</p>
        pub fn set_cache_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cache_cluster_enabled = input;
            self
        }
        /// <p>The size of the cache cluster for the stage, if enabled.</p>
        pub fn cache_cluster_size(mut self, input: crate::model::CacheClusterSize) -> Self {
            self.cache_cluster_size = Some(input);
            self
        }
        /// <p>The size of the cache cluster for the stage, if enabled.</p>
        pub fn set_cache_cluster_size(
            mut self,
            input: std::option::Option<crate::model::CacheClusterSize>,
        ) -> Self {
            self.cache_cluster_size = input;
            self
        }
        /// <p>The status of the cache cluster for the stage, if enabled.</p>
        pub fn cache_cluster_status(mut self, input: crate::model::CacheClusterStatus) -> Self {
            self.cache_cluster_status = Some(input);
            self
        }
        /// <p>The status of the cache cluster for the stage, if enabled.</p>
        pub fn set_cache_cluster_status(
            mut self,
            input: std::option::Option<crate::model::CacheClusterStatus>,
        ) -> Self {
            self.cache_cluster_status = input;
            self
        }
        /// Adds a key-value pair to `method_settings`.
        ///
        /// To override the contents of this collection use [`set_method_settings`](Self::set_method_settings).
        ///
        /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
        pub fn method_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MethodSetting>,
        ) -> Self {
            let mut hash_map = self.method_settings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.method_settings = Some(hash_map);
            self
        }
        /// <p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the <code>resource_path</code> part must be encoded as "~1" as in, for example, <code>~1resource~1sub-resource/GET</code>.--></p>
        pub fn set_method_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MethodSetting>,
            >,
        ) -> Self {
            self.method_settings = input;
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
        /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can
        /// have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.documentation_version = Some(input.into());
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documentation_version = input;
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn access_log_settings(mut self, input: crate::model::AccessLogSettings) -> Self {
            self.access_log_settings = Some(input);
            self
        }
        /// <p>Settings for logging access in this stage.</p>
        pub fn set_access_log_settings(
            mut self,
            input: std::option::Option<crate::model::AccessLogSettings>,
        ) -> Self {
            self.access_log_settings = input;
            self
        }
        /// <p>Settings for the canary deployment in this stage.</p>
        pub fn canary_settings(mut self, input: crate::model::CanarySettings) -> Self {
            self.canary_settings = Some(input);
            self
        }
        /// <p>Settings for the canary deployment in this stage.</p>
        pub fn set_canary_settings(
            mut self,
            input: std::option::Option<crate::model::CanarySettings>,
        ) -> Self {
            self.canary_settings = input;
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn tracing_enabled(mut self, input: bool) -> Self {
            self.tracing_enabled = Some(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn set_tracing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.tracing_enabled = input;
            self
        }
        /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_acl_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_acl_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The timestamp when the stage last updated.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The timestamp when the stage last updated.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStageOutput`](crate::output::GetStageOutput)
        pub fn build(self) -> crate::output::GetStageOutput {
            crate::output::GetStageOutput {
                deployment_id: self.deployment_id,
                client_certificate_id: self.client_certificate_id,
                stage_name: self.stage_name,
                description: self.description,
                cache_cluster_enabled: self.cache_cluster_enabled.unwrap_or_default(),
                cache_cluster_size: self.cache_cluster_size,
                cache_cluster_status: self.cache_cluster_status,
                method_settings: self.method_settings,
                variables: self.variables,
                documentation_version: self.documentation_version,
                access_log_settings: self.access_log_settings,
                canary_settings: self.canary_settings,
                tracing_enabled: self.tracing_enabled.unwrap_or_default(),
                web_acl_arn: self.web_acl_arn,
                tags: self.tags,
                created_date: self.created_date,
                last_updated_date: self.last_updated_date,
            }
        }
    }
}
impl GetStageOutput {
    /// Creates a new builder-style object to manufacture [`GetStageOutput`](crate::output::GetStageOutput)
    pub fn builder() -> crate::output::get_stage_output::Builder {
        crate::output::get_stage_output::Builder::default()
    }
}

/// <p>The collection of <a>SdkType</a> instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSdkTypesOutput {
    /// <p>The current page of elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::SdkType>>,
}
impl GetSdkTypesOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::SdkType]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for GetSdkTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSdkTypesOutput");
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`GetSdkTypesOutput`](crate::output::GetSdkTypesOutput)
pub mod get_sdk_types_output {
    /// A builder for [`GetSdkTypesOutput`](crate::output::GetSdkTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::SdkType>>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::SdkType>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SdkType>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSdkTypesOutput`](crate::output::GetSdkTypesOutput)
        pub fn build(self) -> crate::output::GetSdkTypesOutput {
            crate::output::GetSdkTypesOutput { items: self.items }
        }
    }
}
impl GetSdkTypesOutput {
    /// Creates a new builder-style object to manufacture [`GetSdkTypesOutput`](crate::output::GetSdkTypesOutput)
    pub fn builder() -> crate::output::get_sdk_types_output::Builder {
        crate::output::get_sdk_types_output::Builder::default()
    }
}

/// <p>A type of SDK that API Gateway can generate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSdkTypeOutput {
    /// <p>The identifier of an <a>SdkType</a> instance.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The user-friendly name of an <a>SdkType</a> instance.</p>
    pub friendly_name: std::option::Option<std::string::String>,
    /// <p>The description of an <a>SdkType</a>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of configuration properties of an <a>SdkType</a>.</p>
    pub configuration_properties:
        std::option::Option<std::vec::Vec<crate::model::SdkConfigurationProperty>>,
}
impl GetSdkTypeOutput {
    /// <p>The identifier of an <a>SdkType</a> instance.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The user-friendly name of an <a>SdkType</a> instance.</p>
    pub fn friendly_name(&self) -> std::option::Option<&str> {
        self.friendly_name.as_deref()
    }
    /// <p>The description of an <a>SdkType</a>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of configuration properties of an <a>SdkType</a>.</p>
    pub fn configuration_properties(
        &self,
    ) -> std::option::Option<&[crate::model::SdkConfigurationProperty]> {
        self.configuration_properties.as_deref()
    }
}
impl std::fmt::Debug for GetSdkTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSdkTypeOutput");
        formatter.field("id", &self.id);
        formatter.field("friendly_name", &self.friendly_name);
        formatter.field("description", &self.description);
        formatter.field("configuration_properties", &self.configuration_properties);
        formatter.finish()
    }
}
/// See [`GetSdkTypeOutput`](crate::output::GetSdkTypeOutput)
pub mod get_sdk_type_output {
    /// A builder for [`GetSdkTypeOutput`](crate::output::GetSdkTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) friendly_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) configuration_properties:
            std::option::Option<std::vec::Vec<crate::model::SdkConfigurationProperty>>,
    }
    impl Builder {
        /// <p>The identifier of an <a>SdkType</a> instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of an <a>SdkType</a> instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The user-friendly name of an <a>SdkType</a> instance.</p>
        pub fn friendly_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.friendly_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of an <a>SdkType</a> instance.</p>
        pub fn set_friendly_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.friendly_name = input;
            self
        }
        /// <p>The description of an <a>SdkType</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of an <a>SdkType</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `configuration_properties`.
        ///
        /// To override the contents of this collection use [`set_configuration_properties`](Self::set_configuration_properties).
        ///
        /// <p>A list of configuration properties of an <a>SdkType</a>.</p>
        pub fn configuration_properties(
            mut self,
            input: impl Into<crate::model::SdkConfigurationProperty>,
        ) -> Self {
            let mut v = self.configuration_properties.unwrap_or_default();
            v.push(input.into());
            self.configuration_properties = Some(v);
            self
        }
        /// <p>A list of configuration properties of an <a>SdkType</a>.</p>
        pub fn set_configuration_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SdkConfigurationProperty>>,
        ) -> Self {
            self.configuration_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSdkTypeOutput`](crate::output::GetSdkTypeOutput)
        pub fn build(self) -> crate::output::GetSdkTypeOutput {
            crate::output::GetSdkTypeOutput {
                id: self.id,
                friendly_name: self.friendly_name,
                description: self.description,
                configuration_properties: self.configuration_properties,
            }
        }
    }
}
impl GetSdkTypeOutput {
    /// Creates a new builder-style object to manufacture [`GetSdkTypeOutput`](crate::output::GetSdkTypeOutput)
    pub fn builder() -> crate::output::get_sdk_type_output::Builder {
        crate::output::get_sdk_type_output::Builder::default()
    }
}

/// <p>The binary blob response to <a>GetSdk</a>, which contains the generated SDK.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSdkOutput {
    /// <p>The content-type header value in the HTTP response.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The content-disposition header value in the HTTP response.</p>
    pub content_disposition: std::option::Option<std::string::String>,
    /// <p>The binary blob response to <a>GetSdk</a>, which contains the generated SDK.</p>
    pub body: std::option::Option<aws_smithy_types::Blob>,
}
impl GetSdkOutput {
    /// <p>The content-type header value in the HTTP response.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The content-disposition header value in the HTTP response.</p>
    pub fn content_disposition(&self) -> std::option::Option<&str> {
        self.content_disposition.as_deref()
    }
    /// <p>The binary blob response to <a>GetSdk</a>, which contains the generated SDK.</p>
    pub fn body(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.body.as_ref()
    }
}
impl std::fmt::Debug for GetSdkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSdkOutput");
        formatter.field("content_type", &self.content_type);
        formatter.field("content_disposition", &self.content_disposition);
        formatter.field("body", &self.body);
        formatter.finish()
    }
}
/// See [`GetSdkOutput`](crate::output::GetSdkOutput)
pub mod get_sdk_output {
    /// A builder for [`GetSdkOutput`](crate::output::GetSdkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The content-type header value in the HTTP response.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type header value in the HTTP response.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The content-disposition header value in the HTTP response.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p>The content-disposition header value in the HTTP response.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p>The binary blob response to <a>GetSdk</a>, which contains the generated SDK.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The binary blob response to <a>GetSdk</a>, which contains the generated SDK.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSdkOutput`](crate::output::GetSdkOutput)
        pub fn build(self) -> crate::output::GetSdkOutput {
            crate::output::GetSdkOutput {
                content_type: self.content_type,
                content_disposition: self.content_disposition,
                body: self.body,
            }
        }
    }
}
impl GetSdkOutput {
    /// Creates a new builder-style object to manufacture [`GetSdkOutput`](crate::output::GetSdkOutput)
    pub fn builder() -> crate::output::get_sdk_output::Builder {
        crate::output::get_sdk_output::Builder::default()
    }
}

/// <p>Contains references to your APIs and links that guide you in how to interact with your collection. A collection offers a paginated view of your APIs.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRestApisOutput {
    /// <p>The current page of elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::RestApi>>,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetRestApisOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::RestApi]> {
        self.items.as_deref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetRestApisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRestApisOutput");
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetRestApisOutput`](crate::output::GetRestApisOutput)
pub mod get_rest_apis_output {
    /// A builder for [`GetRestApisOutput`](crate::output::GetRestApisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::RestApi>>,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::RestApi>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RestApi>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRestApisOutput`](crate::output::GetRestApisOutput)
        pub fn build(self) -> crate::output::GetRestApisOutput {
            crate::output::GetRestApisOutput {
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetRestApisOutput {
    /// Creates a new builder-style object to manufacture [`GetRestApisOutput`](crate::output::GetRestApisOutput)
    pub fn builder() -> crate::output::get_rest_apis_output::Builder {
        crate::output::get_rest_apis_output::Builder::default()
    }
}

/// <p>Represents a REST API.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRestApiOutput {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The API's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when the API was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A version identifier for the API.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub minimum_compression_size: std::option::Option<i32>,
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub disable_execute_api_endpoint: bool,
}
impl GetRestApiOutput {
    /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The API's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when the API was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>A version identifier for the API.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
    /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
    pub fn binary_media_types(&self) -> std::option::Option<&[std::string::String]> {
        self.binary_media_types.as_deref()
    }
    /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
    pub fn minimum_compression_size(&self) -> std::option::Option<i32> {
        self.minimum_compression_size
    }
    /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
    pub fn api_key_source(&self) -> std::option::Option<&crate::model::ApiKeySourceType> {
        self.api_key_source.as_ref()
    }
    /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
    pub fn disable_execute_api_endpoint(&self) -> bool {
        self.disable_execute_api_endpoint
    }
}
impl std::fmt::Debug for GetRestApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRestApiOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("warnings", &self.warnings);
        formatter.field("binary_media_types", &self.binary_media_types);
        formatter.field("minimum_compression_size", &self.minimum_compression_size);
        formatter.field("api_key_source", &self.api_key_source);
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("policy", &self.policy);
        formatter.field("tags", &self.tags);
        formatter.field(
            "disable_execute_api_endpoint",
            &self.disable_execute_api_endpoint,
        );
        formatter.finish()
    }
}
/// See [`GetRestApiOutput`](crate::output::GetRestApiOutput)
pub mod get_rest_api_output {
    /// A builder for [`GetRestApiOutput`](crate::output::GetRestApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_compression_size: std::option::Option<i32>,
        pub(crate) api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The API's identifier. This identifier is unique across all of your APIs in API Gateway.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The API's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The API's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The API's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The timestamp when the API was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Appends an item to `binary_media_types`.
        ///
        /// To override the contents of this collection use [`set_binary_media_types`](Self::set_binary_media_types).
        ///
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn binary_media_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.binary_media_types.unwrap_or_default();
            v.push(input.into());
            self.binary_media_types = Some(v);
            self
        }
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn set_binary_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.binary_media_types = input;
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn minimum_compression_size(mut self, input: i32) -> Self {
            self.minimum_compression_size = Some(input);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn set_minimum_compression_size(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_compression_size = input;
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn api_key_source(mut self, input: crate::model::ApiKeySourceType) -> Self {
            self.api_key_source = Some(input);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn set_api_key_source(
            mut self,
            input: std::option::Option<crate::model::ApiKeySourceType>,
        ) -> Self {
            self.api_key_source = input;
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRestApiOutput`](crate::output::GetRestApiOutput)
        pub fn build(self) -> crate::output::GetRestApiOutput {
            crate::output::GetRestApiOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                created_date: self.created_date,
                version: self.version,
                warnings: self.warnings,
                binary_media_types: self.binary_media_types,
                minimum_compression_size: self.minimum_compression_size,
                api_key_source: self.api_key_source,
                endpoint_configuration: self.endpoint_configuration,
                policy: self.policy,
                tags: self.tags,
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
            }
        }
    }
}
impl GetRestApiOutput {
    /// Creates a new builder-style object to manufacture [`GetRestApiOutput`](crate::output::GetRestApiOutput)
    pub fn builder() -> crate::output::get_rest_api_output::Builder {
        crate::output::get_rest_api_output::Builder::default()
    }
}

/// <p>Represents a collection of <a>Resource</a> resources.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcesOutput {
    /// <p>The current page of elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetResourcesOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.items.as_deref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcesOutput");
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetResourcesOutput`](crate::output::GetResourcesOutput)
pub mod get_resources_output {
    /// A builder for [`GetResourcesOutput`](crate::output::GetResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcesOutput`](crate::output::GetResourcesOutput)
        pub fn build(self) -> crate::output::GetResourcesOutput {
            crate::output::GetResourcesOutput {
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetResourcesOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcesOutput`](crate::output::GetResourcesOutput)
    pub fn builder() -> crate::output::get_resources_output::Builder {
        crate::output::get_resources_output::Builder::default()
    }
}

/// <p>Represents an API resource.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceOutput {
    /// <p>The resource's identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The parent resource's identifier.</p>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>The last path segment for this resource.</p>
    pub path_part: std::option::Option<std::string::String>,
    /// <p>The full path for this resource.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Gets an API resource's method of a given HTTP verb.</p>
    /// <div class="remarks">
    /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
    /// <h4>Example: Get the GET method of an API resource</h4>
    /// <h5>Request</h5>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20170223T031827Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
    /// "name": "method",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
    /// "name": "GET",
    /// "title": "GET"
    /// },
    /// "integration:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "method:integration": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "method:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "methodresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "apiKeyRequired": false,
    /// "authorizationType": "NONE",
    /// "httpMethod": "GET",
    /// "_embedded": {
    /// "method:integration": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "3kzxbg5sa2",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestParameters": {
    /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
    /// },
    /// "requestTemplates": {
    /// "application/json": "{\n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// },
    /// "method:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": false
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
    /// </div>
    /// <div class="seeAlso">
    /// </div>
    pub resource_methods:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Method>>,
}
impl GetResourceOutput {
    /// <p>The resource's identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The parent resource's identifier.</p>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>The last path segment for this resource.</p>
    pub fn path_part(&self) -> std::option::Option<&str> {
        self.path_part.as_deref()
    }
    /// <p>The full path for this resource.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>Gets an API resource's method of a given HTTP verb.</p>
    /// <div class="remarks">
    /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
    /// <h4>Example: Get the GET method of an API resource</h4>
    /// <h5>Request</h5>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20170223T031827Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
    /// "name": "method",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
    /// "name": "GET",
    /// "title": "GET"
    /// },
    /// "integration:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "method:integration": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "method:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "method:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
    /// },
    /// "methodresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "apiKeyRequired": false,
    /// "authorizationType": "NONE",
    /// "httpMethod": "GET",
    /// "_embedded": {
    /// "method:integration": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "3kzxbg5sa2",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestParameters": {
    /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
    /// },
    /// "requestTemplates": {
    /// "application/json": "{\n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// },
    /// "method:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": false
    /// },
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
    /// </div>
    /// <div class="seeAlso">
    /// </div>
    pub fn resource_methods(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Method>>
    {
        self.resource_methods.as_ref()
    }
}
impl std::fmt::Debug for GetResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceOutput");
        formatter.field("id", &self.id);
        formatter.field("parent_id", &self.parent_id);
        formatter.field("path_part", &self.path_part);
        formatter.field("path", &self.path);
        formatter.field("resource_methods", &self.resource_methods);
        formatter.finish()
    }
}
/// See [`GetResourceOutput`](crate::output::GetResourceOutput)
pub mod get_resource_output {
    /// A builder for [`GetResourceOutput`](crate::output::GetResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) path_part: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) resource_methods: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Method>,
        >,
    }
    impl Builder {
        /// <p>The resource's identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The resource's identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The parent resource's identifier.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The parent resource's identifier.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn path_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_part = Some(input.into());
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn set_path_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_part = input;
            self
        }
        /// <p>The full path for this resource.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The full path for this resource.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Adds a key-value pair to `resource_methods`.
        ///
        /// To override the contents of this collection use [`set_resource_methods`](Self::set_resource_methods).
        ///
        /// <p>Gets an API resource's method of a given HTTP verb.</p>
        /// <div class="remarks">
        /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
        /// <h4>Example: Get the GET method of an API resource</h4>
        /// <h5>Request</h5>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20170223T031827Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
        /// "name": "method",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
        /// "name": "GET",
        /// "title": "GET"
        /// },
        /// "integration:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "method:integration": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "method:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "methodresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "apiKeyRequired": false,
        /// "authorizationType": "NONE",
        /// "httpMethod": "GET",
        /// "_embedded": {
        /// "method:integration": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "3kzxbg5sa2",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestParameters": {
        /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
        /// },
        /// "requestTemplates": {
        /// "application/json": "{\n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// },
        /// "method:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": false
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
        /// </div>
        /// <div class="seeAlso">
        /// </div>
        pub fn resource_methods(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Method>,
        ) -> Self {
            let mut hash_map = self.resource_methods.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_methods = Some(hash_map);
            self
        }
        /// <p>Gets an API resource's method of a given HTTP verb.</p>
        /// <div class="remarks">
        /// <p>The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p>
        /// <h4>Example: Get the GET method of an API resource</h4>
        /// <h5>Request</h5>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20170223T031827Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
        /// "name": "method",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
        /// "name": "GET",
        /// "title": "GET"
        /// },
        /// "integration:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "method:integration": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "method:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "method:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
        /// },
        /// "methodresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "apiKeyRequired": false,
        /// "authorizationType": "NONE",
        /// "httpMethod": "GET",
        /// "_embedded": {
        /// "method:integration": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "3kzxbg5sa2",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestParameters": {
        /// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
        /// },
        /// "requestTemplates": {
        /// "application/json": "{\n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// },
        /// "method:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": false
        /// },
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p>
        /// </div>
        /// <div class="seeAlso">
        /// </div>
        pub fn set_resource_methods(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Method>,
            >,
        ) -> Self {
            self.resource_methods = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceOutput`](crate::output::GetResourceOutput)
        pub fn build(self) -> crate::output::GetResourceOutput {
            crate::output::GetResourceOutput {
                id: self.id,
                parent_id: self.parent_id,
                path_part: self.path_part,
                path: self.path,
                resource_methods: self.resource_methods,
            }
        }
    }
}
impl GetResourceOutput {
    /// Creates a new builder-style object to manufacture [`GetResourceOutput`](crate::output::GetResourceOutput)
    pub fn builder() -> crate::output::get_resource_output::Builder {
        crate::output::get_resource_output::Builder::default()
    }
}

/// <p>A collection of <a>RequestValidator</a> resources of a given <a>RestApi</a>.</p>
/// <div class="remarks">
/// <p>In OpenAPI, the <a>RequestValidators</a> of an API is defined by the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.html">x-amazon-apigateway-request-validators</a> extension.</p>
/// </div>
/// <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html">Enable Basic Request Validation in API Gateway</a></div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRequestValidatorsOutput {
    /// <p>The current page of elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::RequestValidator>>,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetRequestValidatorsOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::RequestValidator]> {
        self.items.as_deref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetRequestValidatorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRequestValidatorsOutput");
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetRequestValidatorsOutput`](crate::output::GetRequestValidatorsOutput)
pub mod get_request_validators_output {
    /// A builder for [`GetRequestValidatorsOutput`](crate::output::GetRequestValidatorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::RequestValidator>>,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::RequestValidator>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RequestValidator>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRequestValidatorsOutput`](crate::output::GetRequestValidatorsOutput)
        pub fn build(self) -> crate::output::GetRequestValidatorsOutput {
            crate::output::GetRequestValidatorsOutput {
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetRequestValidatorsOutput {
    /// Creates a new builder-style object to manufacture [`GetRequestValidatorsOutput`](crate::output::GetRequestValidatorsOutput)
    pub fn builder() -> crate::output::get_request_validators_output::Builder {
        crate::output::get_request_validators_output::Builder::default()
    }
}

/// <p>A set of validation rules for incoming <a>Method</a> requests.</p>
/// <div class="remarks">
/// <p>In OpenAPI, a <a>RequestValidator</a> of an API is defined by the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.requestValidator.html">x-amazon-apigateway-request-validators.requestValidator</a> object. It the referenced using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validator">x-amazon-apigateway-request-validator</a> property.</p>
/// </div>
/// <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html">Enable Basic Request Validation in API Gateway</a></div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRequestValidatorOutput {
    /// <p>The identifier of this <a>RequestValidator</a>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of this <a>RequestValidator</a></p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
    pub validate_request_body: bool,
    /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
    pub validate_request_parameters: bool,
}
impl GetRequestValidatorOutput {
    /// <p>The identifier of this <a>RequestValidator</a>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of this <a>RequestValidator</a></p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
    pub fn validate_request_body(&self) -> bool {
        self.validate_request_body
    }
    /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
    pub fn validate_request_parameters(&self) -> bool {
        self.validate_request_parameters
    }
}
impl std::fmt::Debug for GetRequestValidatorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRequestValidatorOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("validate_request_body", &self.validate_request_body);
        formatter.field(
            "validate_request_parameters",
            &self.validate_request_parameters,
        );
        formatter.finish()
    }
}
/// See [`GetRequestValidatorOutput`](crate::output::GetRequestValidatorOutput)
pub mod get_request_validator_output {
    /// A builder for [`GetRequestValidatorOutput`](crate::output::GetRequestValidatorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) validate_request_body: std::option::Option<bool>,
        pub(crate) validate_request_parameters: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of this <a>RequestValidator</a>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of this <a>RequestValidator</a>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of this <a>RequestValidator</a></p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this <a>RequestValidator</a></p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
        pub fn validate_request_body(mut self, input: bool) -> Self {
            self.validate_request_body = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>
        pub fn set_validate_request_body(mut self, input: std::option::Option<bool>) -> Self {
            self.validate_request_body = input;
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
        pub fn validate_request_parameters(mut self, input: bool) -> Self {
            self.validate_request_parameters = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>
        pub fn set_validate_request_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.validate_request_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRequestValidatorOutput`](crate::output::GetRequestValidatorOutput)
        pub fn build(self) -> crate::output::GetRequestValidatorOutput {
            crate::output::GetRequestValidatorOutput {
                id: self.id,
                name: self.name,
                validate_request_body: self.validate_request_body.unwrap_or_default(),
                validate_request_parameters: self.validate_request_parameters.unwrap_or_default(),
            }
        }
    }
}
impl GetRequestValidatorOutput {
    /// Creates a new builder-style object to manufacture [`GetRequestValidatorOutput`](crate::output::GetRequestValidatorOutput)
    pub fn builder() -> crate::output::get_request_validator_output::Builder {
        crate::output::get_request_validator_output::Builder::default()
    }
}

/// <p>Represents a mapping template used to transform a payload.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html#models-mappings-mappings">Mapping Templates</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelTemplateOutput {
    /// <p>The Apache <a target="_blank" href="https://velocity.apache.org/engine/devel/vtl-reference.html">Velocity Template Language (VTL)</a> template content used for the template resource.</p>
    pub value: std::option::Option<std::string::String>,
}
impl GetModelTemplateOutput {
    /// <p>The Apache <a target="_blank" href="https://velocity.apache.org/engine/devel/vtl-reference.html">Velocity Template Language (VTL)</a> template content used for the template resource.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for GetModelTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelTemplateOutput");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput)
pub mod get_model_template_output {
    /// A builder for [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Apache <a target="_blank" href="https://velocity.apache.org/engine/devel/vtl-reference.html">Velocity Template Language (VTL)</a> template content used for the template resource.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The Apache <a target="_blank" href="https://velocity.apache.org/engine/devel/vtl-reference.html">Velocity Template Language (VTL)</a> template content used for the template resource.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput)
        pub fn build(self) -> crate::output::GetModelTemplateOutput {
            crate::output::GetModelTemplateOutput { value: self.value }
        }
    }
}
impl GetModelTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetModelTemplateOutput`](crate::output::GetModelTemplateOutput)
    pub fn builder() -> crate::output::get_model_template_output::Builder {
        crate::output::get_model_template_output::Builder::default()
    }
}

/// <p>Represents a collection of <a>Model</a> resources.</p>
/// <div class="seeAlso">
/// <a>Method</a>, <a>MethodResponse</a>, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html">Models and Mappings</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelsOutput {
    /// <p>The current page of elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Model>>,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetModelsOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Model]> {
        self.items.as_deref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelsOutput");
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetModelsOutput`](crate::output::GetModelsOutput)
pub mod get_models_output {
    /// A builder for [`GetModelsOutput`](crate::output::GetModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Model>>,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::Model>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Model>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelsOutput`](crate::output::GetModelsOutput)
        pub fn build(self) -> crate::output::GetModelsOutput {
            crate::output::GetModelsOutput {
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetModelsOutput {
    /// Creates a new builder-style object to manufacture [`GetModelsOutput`](crate::output::GetModelsOutput)
    pub fn builder() -> crate::output::get_models_output::Builder {
        crate::output::get_models_output::Builder::default()
    }
}

/// <p>Represents the data structure of a method's request or response payload.</p>
/// <div class="remarks">
/// <p>A request model defines the data structure of the client-supplied request payload. A response model defines the data structure of the response payload returned by the back end. Although not required, models are useful for mapping payloads between the front end and back end.</p>
/// <p>A model is used for generating an API's SDK, validating the input request body, and creating a skeletal mapping template.</p>
/// </div>
/// <div class="seeAlso">
/// <a>Method</a>, <a>MethodResponse</a>, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html">Models and Mappings</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelOutput {
    /// <p>The identifier for the model resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the model. Must be an alphanumeric string.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The content-type for the model.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl GetModelOutput {
    /// <p>The identifier for the model resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the model. Must be an alphanumeric string.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The content-type for the model.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for GetModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("schema", &self.schema);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`GetModelOutput`](crate::output::GetModelOutput)
pub mod get_model_output {
    /// A builder for [`GetModelOutput`](crate::output::GetModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the model resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the model resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the model. Must be an alphanumeric string.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model. Must be an alphanumeric string.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>The content-type for the model.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type for the model.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelOutput`](crate::output::GetModelOutput)
        pub fn build(self) -> crate::output::GetModelOutput {
            crate::output::GetModelOutput {
                id: self.id,
                name: self.name,
                description: self.description,
                schema: self.schema,
                content_type: self.content_type,
            }
        }
    }
}
impl GetModelOutput {
    /// Creates a new builder-style object to manufacture [`GetModelOutput`](crate::output::GetModelOutput)
    pub fn builder() -> crate::output::get_model_output::Builder {
        crate::output::get_model_output::Builder::default()
    }
}

/// <p>Represents a method response of a given HTTP status code returned to the client. The method response is passed from the back end through the associated integration response that can be transformed using a mapping template. <!-- API Gateway sends back the status code to the caller as the HTTP status code. Parameters and models can be used to transform the response from the method's integration.--></p>
/// <div class="remarks">
/// <p></p>
/// <h4>Example: A <b>MethodResponse</b> instance of an API</h4>
/// <h5>Request</h5>
/// <p>The example request retrieves a <b>MethodResponse</b> of the 200 status code.</p>
/// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200 HTTP/1.1
/// Content-Type: application/json
/// Host: apigateway.us-east-1.amazonaws.com
/// X-Amz-Date: 20160603T222952Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
/// <h5>Response</h5>
/// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
/// "name": "methodresponse",
/// "templated": true
/// },
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "title": "200"
/// },
/// "methodresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// },
/// "methodresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// }
/// },
/// "responseModels": {
/// "application/json": "Empty"
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": false
/// },
/// "statusCode": "200"
/// }</code></pre>
/// <p></p>
/// </div>
/// <div class="seeAlso">
/// <a>Method</a>, <a>IntegrationResponse</a>, <a>Integration</a>
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMethodResponseOutput {
    /// <p>The method response's status code.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
    pub response_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetMethodResponseOutput {
    /// <p>The method response's status code.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.response_parameters.as_ref()
    }
    /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
    pub fn response_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_models.as_ref()
    }
}
impl std::fmt::Debug for GetMethodResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMethodResponseOutput");
        formatter.field("status_code", &self.status_code);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_models", &self.response_models);
        formatter.finish()
    }
}
/// See [`GetMethodResponseOutput`](crate::output::GetMethodResponseOutput)
pub mod get_method_response_output {
    /// A builder for [`GetMethodResponseOutput`](crate::output::GetMethodResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The method response's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The method response's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMethodResponseOutput`](crate::output::GetMethodResponseOutput)
        pub fn build(self) -> crate::output::GetMethodResponseOutput {
            crate::output::GetMethodResponseOutput {
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_models: self.response_models,
            }
        }
    }
}
impl GetMethodResponseOutput {
    /// Creates a new builder-style object to manufacture [`GetMethodResponseOutput`](crate::output::GetMethodResponseOutput)
    pub fn builder() -> crate::output::get_method_response_output::Builder {
        crate::output::get_method_response_output::Builder::default()
    }
}

/// <p>
/// Represents a client-facing interface by which the client calls the API to access back-end resources. A <b>Method</b> resource is
/// integrated with an <a>Integration</a> resource. Both consist of a request and one or more responses. The method request takes
/// the client input that is passed to the back end through the integration request. A method response returns the output from
/// the back end to the client through an integration response. A method request is embodied in a <b>Method</b> resource, whereas
/// an integration request is embodied in an <a>Integration</a> resource.  On the other hand, a method response is represented
/// by a <a>MethodResponse</a> resource, whereas an integration response is represented by an <a>IntegrationResponse</a> resource.
/// </p>
/// <div class="remarks">
/// <p></p>
/// <h4>Example: Retrive the GET method on a specified resource</h4>
/// <h5>Request</h5>
/// <p>The following example request retrieves the information about the GET method on an API resource (<code>3kzxbg5sa2</code>) of an API (<code>fugvjdxtri</code>). </p>
/// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
/// Content-Type: application/json
/// Host: apigateway.us-east-1.amazonaws.com
/// X-Amz-Date: 20160603T210259Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
/// <h5>Response</h5>
/// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": [
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
/// "name": "integration",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
/// "name": "integrationresponse",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
/// "name": "method",
/// "templated": true
/// },
/// {
/// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
/// "name": "methodresponse",
/// "templated": true
/// }
/// ],
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
/// "name": "GET",
/// "title": "GET"
/// },
/// "integration:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "method:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
/// },
/// "method:integration": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "method:responses": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "method:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
/// },
/// "methodresponse:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
/// "templated": true
/// }
/// },
/// "apiKeyRequired": true,
/// "authorizationType": "NONE",
/// "httpMethod": "GET",
/// "_embedded": {
/// "method:integration": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integration:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integration:responses": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "integration:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
/// },
/// "integrationresponse:put": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
/// "templated": true
/// }
/// },
/// "cacheKeyParameters": [],
/// "cacheNamespace": "3kzxbg5sa2",
/// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
/// "httpMethod": "POST",
/// "passthroughBehavior": "WHEN_NO_MATCH",
/// "requestParameters": {
/// "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
/// },
/// "requestTemplates": {
/// "application/json": "{\n}"
/// },
/// "type": "AWS",
/// "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
/// "_embedded": {
/// "integration:responses": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "integrationresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
/// },
/// "integrationresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
/// }
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": "'application/xml'"
/// },
/// "responseTemplates": {
/// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E\")"
/// },
/// "statusCode": "200"
/// }
/// }
/// },
/// "method:responses": {
/// "_links": {
/// "self": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
/// "name": "200",
/// "title": "200"
/// },
/// "methodresponse:delete": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// },
/// "methodresponse:update": {
/// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
/// }
/// },
/// "responseModels": {
/// "application/json": "Empty"
/// },
/// "responseParameters": {
/// "method.response.header.Content-Type": false
/// },
/// "statusCode": "200"
/// }
/// }
/// }</code></pre>
/// <p>In the example above, the response template for the <code>200 OK</code> response maps the JSON output from the <code>ListStreams</code> action in the back end to an XML output. The mapping template is URL-encoded as <code>%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E</code> and the output is decoded using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#util-templat-reference">$util.urlDecode()</a> helper function.</p>
/// </div>
/// <div class="seeAlso">
/// <a>MethodResponse</a>, <a>Integration</a>, <a>IntegrationResponse</a>, <a>Resource</a>,
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-method-settings.html">Set up an API's method</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMethodOutput {
    /// <p>The method's HTTP verb.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub authorization_type: std::option::Option<std::string::String>,
    /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    pub authorizer_id: std::option::Option<std::string::String>,
    /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
    pub api_key_required: std::option::Option<bool>,
    /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
    pub request_validator_id: std::option::Option<std::string::String>,
    /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    pub request_models:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Gets a method response associated with a given HTTP status code. </p>
    /// <div class="remarks">
    /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
    /// <h4>Example: Get a 200 OK response of a GET method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T215008Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": false,
    /// "method.response.header.operand_2": false,
    /// "method.response.header.operand_1": false
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
    /// </div>
    pub method_responses: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
    >,
    /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: </h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T213210Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "0cjtch",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestTemplates": {
    /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": "integration.response.body.op",
    /// "method.response.header.operand_2": "integration.response.body.b",
    /// "method.response.header.operand_1": "integration.response.body.a"
    /// },
    /// "responseTemplates": {
    /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
    /// },
    /// "selectionPattern": "",
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
    /// </div>
    pub method_integration: std::option::Option<crate::model::Integration>,
    /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetMethodOutput {
    /// <p>The method's HTTP verb.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
    pub fn authorization_type(&self) -> std::option::Option<&str> {
        self.authorization_type.as_deref()
    }
    /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
    pub fn authorizer_id(&self) -> std::option::Option<&str> {
        self.authorizer_id.as_deref()
    }
    /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
    pub fn api_key_required(&self) -> std::option::Option<bool> {
        self.api_key_required
    }
    /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
    pub fn request_validator_id(&self) -> std::option::Option<&str> {
        self.request_validator_id.as_deref()
    }
    /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.request_parameters.as_ref()
    }
    /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
    pub fn request_models(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_models.as_ref()
    }
    /// <p>Gets a method response associated with a given HTTP status code. </p>
    /// <div class="remarks">
    /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
    /// <h4>Example: Get a 200 OK response of a GET method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T215008Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
    /// "name": "methodresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
    /// "title": "200"
    /// },
    /// "methodresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// },
    /// "methodresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
    /// }
    /// },
    /// "responseModels": {
    /// "application/json": "Empty"
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": false,
    /// "method.response.header.operand_2": false,
    /// "method.response.header.operand_1": false
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
    /// </div>
    pub fn method_responses(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
    > {
        self.method_responses.as_ref()
    }
    /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: </h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// Content-Length: 117
    /// X-Amz-Date: 20160613T213210Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": [
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
    /// "name": "integration",
    /// "templated": true
    /// },
    /// {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// }
    /// ],
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integration:responses": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integration:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
    /// },
    /// "integrationresponse:put": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
    /// "templated": true
    /// }
    /// },
    /// "cacheKeyParameters": [],
    /// "cacheNamespace": "0cjtch",
    /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
    /// "httpMethod": "POST",
    /// "passthroughBehavior": "WHEN_NO_MATCH",
    /// "requestTemplates": {
    /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
    /// },
    /// "type": "AWS",
    /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
    /// "_embedded": {
    /// "integration:responses": {
    /// "_links": {
    /// "self": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
    /// "name": "200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.operator": "integration.response.body.op",
    /// "method.response.header.operand_2": "integration.response.body.b",
    /// "method.response.header.operand_1": "integration.response.body.a"
    /// },
    /// "responseTemplates": {
    /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
    /// },
    /// "selectionPattern": "",
    /// "statusCode": "200"
    /// }
    /// }
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
    /// </div>
    pub fn method_integration(&self) -> std::option::Option<&crate::model::Integration> {
        self.method_integration.as_ref()
    }
    /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
    pub fn authorization_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.authorization_scopes.as_deref()
    }
}
impl std::fmt::Debug for GetMethodOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMethodOutput");
        formatter.field("http_method", &self.http_method);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("authorizer_id", &self.authorizer_id);
        formatter.field("api_key_required", &self.api_key_required);
        formatter.field("request_validator_id", &self.request_validator_id);
        formatter.field("operation_name", &self.operation_name);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_models", &self.request_models);
        formatter.field("method_responses", &self.method_responses);
        formatter.field("method_integration", &self.method_integration);
        formatter.field("authorization_scopes", &self.authorization_scopes);
        formatter.finish()
    }
}
/// See [`GetMethodOutput`](crate::output::GetMethodOutput)
pub mod get_method_output {
    /// A builder for [`GetMethodOutput`](crate::output::GetMethodOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) authorization_type: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) request_validator_id: std::option::Option<std::string::String>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) method_responses: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
        >,
        pub(crate) method_integration: std::option::Option<crate::model::Integration>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The method's HTTP verb.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>The method's HTTP verb.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn authorization_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_type = Some(input.into());
            self
        }
        /// <p>The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_validator_id = Some(input.into());
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for request validation.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_validator_id = input;
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// Adds a key-value pair to `method_responses`.
        ///
        /// To override the contents of this collection use [`set_method_responses`](Self::set_method_responses).
        ///
        /// <p>Gets a method response associated with a given HTTP status code. </p>
        /// <div class="remarks">
        /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
        /// <h4>Example: Get a 200 OK response of a GET method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T215008Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": false,
        /// "method.response.header.operand_2": false,
        /// "method.response.header.operand_1": false
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
        /// </div>
        pub fn method_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MethodResponse>,
        ) -> Self {
            let mut hash_map = self.method_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.method_responses = Some(hash_map);
            self
        }
        /// <p>Gets a method response associated with a given HTTP status code. </p>
        /// <div class="remarks">
        /// <p>The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p>
        /// <h4>Example: Get a 200 OK response of a GET method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T215008Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
        /// "name": "methodresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
        /// "title": "200"
        /// },
        /// "methodresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// },
        /// "methodresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
        /// }
        /// },
        /// "responseModels": {
        /// "application/json": "Empty"
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": false,
        /// "method.response.header.operand_2": false,
        /// "method.response.header.operand_1": false
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a>
        /// </div>
        pub fn set_method_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MethodResponse>,
            >,
        ) -> Self {
            self.method_responses = input;
            self
        }
        /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: </h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T213210Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "0cjtch",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestTemplates": {
        /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": "integration.response.body.op",
        /// "method.response.header.operand_2": "integration.response.body.b",
        /// "method.response.header.operand_1": "integration.response.body.a"
        /// },
        /// "responseTemplates": {
        /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
        /// },
        /// "selectionPattern": "",
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
        /// </div>
        pub fn method_integration(mut self, input: crate::model::Integration) -> Self {
            self.method_integration = Some(input);
            self
        }
        /// <p>Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: </h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// Content-Length: 117
        /// X-Amz-Date: 20160613T213210Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": [
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
        /// "name": "integration",
        /// "templated": true
        /// },
        /// {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// }
        /// ],
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integration:responses": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integration:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
        /// },
        /// "integrationresponse:put": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
        /// "templated": true
        /// }
        /// },
        /// "cacheKeyParameters": [],
        /// "cacheNamespace": "0cjtch",
        /// "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
        /// "httpMethod": "POST",
        /// "passthroughBehavior": "WHEN_NO_MATCH",
        /// "requestTemplates": {
        /// "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
        /// },
        /// "type": "AWS",
        /// "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
        /// "_embedded": {
        /// "integration:responses": {
        /// "_links": {
        /// "self": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
        /// "name": "200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.operator": "integration.response.body.op",
        /// "method.response.header.operand_2": "integration.response.body.b",
        /// "method.response.header.operand_1": "integration.response.body.a"
        /// },
        /// "responseTemplates": {
        /// "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
        /// },
        /// "selectionPattern": "",
        /// "statusCode": "200"
        /// }
        /// }
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a>
        /// </div>
        pub fn set_method_integration(
            mut self,
            input: std::option::Option<crate::model::Integration>,
        ) -> Self {
            self.method_integration = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMethodOutput`](crate::output::GetMethodOutput)
        pub fn build(self) -> crate::output::GetMethodOutput {
            crate::output::GetMethodOutput {
                http_method: self.http_method,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                api_key_required: self.api_key_required,
                request_validator_id: self.request_validator_id,
                operation_name: self.operation_name,
                request_parameters: self.request_parameters,
                request_models: self.request_models,
                method_responses: self.method_responses,
                method_integration: self.method_integration,
                authorization_scopes: self.authorization_scopes,
            }
        }
    }
}
impl GetMethodOutput {
    /// Creates a new builder-style object to manufacture [`GetMethodOutput`](crate::output::GetMethodOutput)
    pub fn builder() -> crate::output::get_method_output::Builder {
        crate::output::get_method_output::Builder::default()
    }
}

/// <p>Represents an integration response. The status code must map to an existing <a>MethodResponse</a>, and parameters and templates can be used to transform the back-end response.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationResponseOutput {
    /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    pub selection_pattern: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
    /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    pub content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
}
impl GetIntegrationResponseOutput {
    /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
    pub fn selection_pattern(&self) -> std::option::Option<&str> {
        self.selection_pattern.as_deref()
    }
    /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
    /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
    pub fn content_handling(&self) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling.as_ref()
    }
}
impl std::fmt::Debug for GetIntegrationResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationResponseOutput");
        formatter.field("status_code", &self.status_code);
        formatter.field("selection_pattern", &self.selection_pattern);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field("content_handling", &self.content_handling);
        formatter.finish()
    }
}
/// See [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput)
pub mod get_integration_response_output {
    /// A builder for [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) selection_pattern: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
    }
    impl Builder {
        /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
        pub fn selection_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_pattern = Some(input.into());
            self
        }
        /// <p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>
        pub fn set_selection_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_pattern = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput)
        pub fn build(self) -> crate::output::GetIntegrationResponseOutput {
            crate::output::GetIntegrationResponseOutput {
                status_code: self.status_code,
                selection_pattern: self.selection_pattern,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                content_handling: self.content_handling,
            }
        }
    }
}
impl GetIntegrationResponseOutput {
    /// Creates a new builder-style object to manufacture [`GetIntegrationResponseOutput`](crate::output::GetIntegrationResponseOutput)
    pub fn builder() -> crate::output::get_integration_response_output::Builder {
        crate::output::get_integration_response_output::Builder::default()
    }
}

/// <p>Represents an HTTP, HTTP_PROXY, AWS, AWS_PROXY, or Mock integration.</p>
/// <div class="remarks">In the API Gateway console, the built-in Lambda integration is an AWS integration.</div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationOutput {
    /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
    /// <ul>
    /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
    /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
    /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
    /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
    /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
    /// </ul>
    /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
    pub r#type: std::option::Option<crate::model::IntegrationType>,
    /// <p>Specifies the integration's HTTP method type.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
    /// <ul>
    /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
    /// </li>
    /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
    /// </li></ul>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    pub credentials: std::option::Option<std::string::String>,
    /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    pub request_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    pub request_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <div>
    /// <p>
    /// Specifies how the method request body of an unmapped content type will be passed through the integration request
    /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
    /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
    /// The valid value is one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
    /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
    /// </li>
    /// <li>
    /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
    /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
    /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
    /// </li>
    /// <li>
    /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
    /// request content type does not match any content type associated with the mapping templates defined in the integration request or
    /// no mapping template is defined in the integration request.
    /// </li>
    /// </ul>
    /// </div>
    pub passthrough_behavior: std::option::Option<std::string::String>,
    /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    pub content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
    /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    pub timeout_in_millis: i32,
    /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    pub cache_namespace: std::option::Option<std::string::String>,
    /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
    pub cache_key_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the integration's responses.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: Get integration responses of a method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20160607T191449Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
    /// </code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
    /// </div>
    pub integration_responses: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
    >,
    /// <p>Specifies the TLS configuration for an integration.</p>
    pub tls_config: std::option::Option<crate::model::TlsConfig>,
}
impl GetIntegrationOutput {
    /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
    /// <ul>
    /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
    /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
    /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
    /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
    /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
    /// </ul>
    /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::IntegrationType> {
        self.r#type.as_ref()
    }
    /// <p>Specifies the integration's HTTP method type.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
    /// <ul>
    /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
    /// </li>
    /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
    /// </li></ul>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
    pub fn credentials(&self) -> std::option::Option<&str> {
        self.credentials.as_deref()
    }
    /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
    pub fn request_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_parameters.as_ref()
    }
    /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
    pub fn request_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_templates.as_ref()
    }
    /// <div>
    /// <p>
    /// Specifies how the method request body of an unmapped content type will be passed through the integration request
    /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
    /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
    /// The valid value is one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
    /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
    /// </li>
    /// <li>
    /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
    /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
    /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
    /// </li>
    /// <li>
    /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
    /// request content type does not match any content type associated with the mapping templates defined in the integration request or
    /// no mapping template is defined in the integration request.
    /// </li>
    /// </ul>
    /// </div>
    pub fn passthrough_behavior(&self) -> std::option::Option<&str> {
        self.passthrough_behavior.as_deref()
    }
    /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
    /// <ul>
    /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
    /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
    /// </ul>
    /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
    pub fn content_handling(&self) -> std::option::Option<&crate::model::ContentHandlingStrategy> {
        self.content_handling.as_ref()
    }
    /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
    pub fn timeout_in_millis(&self) -> i32 {
        self.timeout_in_millis
    }
    /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
    pub fn cache_namespace(&self) -> std::option::Option<&str> {
        self.cache_namespace.as_deref()
    }
    /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
    pub fn cache_key_parameters(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_key_parameters.as_deref()
    }
    /// <p>Specifies the integration's responses.</p>
    /// <div class="remarks">
    /// <p></p>
    /// <h4>Example: Get integration responses of a method</h4>
    /// <h5>Request</h5>
    /// <p></p>
    /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
    /// Content-Type: application/json
    /// Host: apigateway.us-east-1.amazonaws.com
    /// X-Amz-Date: 20160607T191449Z
    /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
    /// </code></pre>
    /// <h5>Response</h5>
    /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
    /// <pre><code>{
    /// "_links": {
    /// "curies": {
    /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
    /// "name": "integrationresponse",
    /// "templated": true
    /// },
    /// "self": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
    /// "title": "200"
    /// },
    /// "integrationresponse:delete": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// },
    /// "integrationresponse:update": {
    /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
    /// }
    /// },
    /// "responseParameters": {
    /// "method.response.header.Content-Type": "'application/xml'"
    /// },
    /// "responseTemplates": {
    /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
    /// },
    /// "statusCode": "200"
    /// }</code></pre>
    /// <p></p>
    /// </div>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
    /// </div>
    pub fn integration_responses(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
    > {
        self.integration_responses.as_ref()
    }
    /// <p>Specifies the TLS configuration for an integration.</p>
    pub fn tls_config(&self) -> std::option::Option<&crate::model::TlsConfig> {
        self.tls_config.as_ref()
    }
}
impl std::fmt::Debug for GetIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationOutput");
        formatter.field("r#type", &self.r#type);
        formatter.field("http_method", &self.http_method);
        formatter.field("uri", &self.uri);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("credentials", &self.credentials);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_templates", &self.request_templates);
        formatter.field("passthrough_behavior", &self.passthrough_behavior);
        formatter.field("content_handling", &self.content_handling);
        formatter.field("timeout_in_millis", &self.timeout_in_millis);
        formatter.field("cache_namespace", &self.cache_namespace);
        formatter.field("cache_key_parameters", &self.cache_key_parameters);
        formatter.field("integration_responses", &self.integration_responses);
        formatter.field("tls_config", &self.tls_config);
        formatter.finish()
    }
}
/// See [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
pub mod get_integration_output {
    /// A builder for [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) credentials: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) passthrough_behavior: std::option::Option<std::string::String>,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) cache_namespace: std::option::Option<std::string::String>,
        pub(crate) cache_key_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) integration_responses: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
        >,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfig>,
    }
    impl Builder {
        /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
        /// <ul>
        /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
        /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
        /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
        /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
        /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
        /// </ul>
        /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
        pub fn r#type(mut self, input: crate::model::IntegrationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies an API method integration type. The valid value is one of the following:</p>
        /// <ul>
        /// <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li>
        /// <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li>
        /// <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li>
        /// <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li>
        /// <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li>
        /// </ul>
        /// <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>Specifies the integration's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials = Some(input.into());
            self
        }
        /// <p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>
        pub fn set_credentials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credentials = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// <div>
        /// <p>
        /// Specifies how the method request body of an unmapped content type will be passed through the integration request
        /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
        /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
        /// The valid value is one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
        /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
        /// </li>
        /// <li>
        /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
        /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
        /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
        /// </li>
        /// <li>
        /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
        /// request content type does not match any content type associated with the mapping templates defined in the integration request or
        /// no mapping template is defined in the integration request.
        /// </li>
        /// </ul>
        /// </div>
        pub fn passthrough_behavior(mut self, input: impl Into<std::string::String>) -> Self {
            self.passthrough_behavior = Some(input.into());
            self
        }
        /// <div>
        /// <p>
        /// Specifies how the method request body of an unmapped content type will be passed through the integration request
        /// to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
        /// or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>.
        /// The valid value is one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation
        /// when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
        /// </li>
        /// <li>
        /// <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation
        /// when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
        /// of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response.
        /// </li>
        /// <li>
        /// <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method
        /// request content type does not match any content type associated with the mapping templates defined in the integration request or
        /// no mapping template is defined in the integration request.
        /// </li>
        /// </ul>
        /// </div>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn cache_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_namespace = Some(input.into());
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn set_cache_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_namespace = input;
            self
        }
        /// Appends an item to `cache_key_parameters`.
        ///
        /// To override the contents of this collection use [`set_cache_key_parameters`](Self::set_cache_key_parameters).
        ///
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn cache_key_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_key_parameters.unwrap_or_default();
            v.push(input.into());
            self.cache_key_parameters = Some(v);
            self
        }
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn set_cache_key_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_key_parameters = input;
            self
        }
        /// Adds a key-value pair to `integration_responses`.
        ///
        /// To override the contents of this collection use [`set_integration_responses`](Self::set_integration_responses).
        ///
        /// <p>Specifies the integration's responses.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: Get integration responses of a method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20160607T191449Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
        /// </code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
        /// </div>
        pub fn integration_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::IntegrationResponse>,
        ) -> Self {
            let mut hash_map = self.integration_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.integration_responses = Some(hash_map);
            self
        }
        /// <p>Specifies the integration's responses.</p>
        /// <div class="remarks">
        /// <p></p>
        /// <h4>Example: Get integration responses of a method</h4>
        /// <h5>Request</h5>
        /// <p></p>
        /// <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
        /// Content-Type: application/json
        /// Host: apigateway.us-east-1.amazonaws.com
        /// X-Amz-Date: 20160607T191449Z
        /// Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
        /// </code></pre>
        /// <h5>Response</h5>
        /// <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p>
        /// <pre><code>{
        /// "_links": {
        /// "curies": {
        /// "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
        /// "name": "integrationresponse",
        /// "templated": true
        /// },
        /// "self": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
        /// "title": "200"
        /// },
        /// "integrationresponse:delete": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// },
        /// "integrationresponse:update": {
        /// "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
        /// }
        /// },
        /// "responseParameters": {
        /// "method.response.header.Content-Type": "'application/xml'"
        /// },
        /// "responseTemplates": {
        /// "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
        /// },
        /// "statusCode": "200"
        /// }</code></pre>
        /// <p></p>
        /// </div>
        /// <div class="seeAlso">
        /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a>
        /// </div>
        pub fn set_integration_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::IntegrationResponse>,
            >,
        ) -> Self {
            self.integration_responses = input;
            self
        }
        /// <p>Specifies the TLS configuration for an integration.</p>
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.tls_config = Some(input);
            self
        }
        /// <p>Specifies the TLS configuration for an integration.</p>
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
        pub fn build(self) -> crate::output::GetIntegrationOutput {
            crate::output::GetIntegrationOutput {
                r#type: self.r#type,
                http_method: self.http_method,
                uri: self.uri,
                connection_type: self.connection_type,
                connection_id: self.connection_id,
                credentials: self.credentials,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                passthrough_behavior: self.passthrough_behavior,
                content_handling: self.content_handling,
                timeout_in_millis: self.timeout_in_millis.unwrap_or_default(),
                cache_namespace: self.cache_namespace,
                cache_key_parameters: self.cache_key_parameters,
                integration_responses: self.integration_responses,
                tls_config: self.tls_config,
            }
        }
    }
}
impl GetIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
    pub fn builder() -> crate::output::get_integration_output::Builder {
        crate::output::get_integration_output::Builder::default()
    }
}

/// <p>The collection of the <a>GatewayResponse</a> instances of a <a>RestApi</a> as a <code>responseType</code>-to-<a>GatewayResponse</a> object map of key-value pairs. As such, pagination is not supported for querying this collection.</p>
/// <div class="remarks">
/// For more information about valid gateway response types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">Gateway Response Types Supported by API Gateway</a>
/// <div class="example">
/// <h4>Example: Get the collection of gateway responses of an API</h4>
/// <h5>Request</h5>
/// <p>This example request shows how to retrieve the <a>GatewayResponses</a> collection from an API.</p>
/// <pre><code>GET /restapis/o81lxisefl/gatewayresponses HTTP/1.1
/// Host: beta-apigateway.us-east-1.amazonaws.com
/// Content-Type: application/json
/// X-Amz-Date: 20170503T220604Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=59b42fe54a76a5de8adf2c67baa6d39206f8e9ad49a1d77ccc6a5da3103a398a
/// Cache-Control: no-cache
/// Postman-Token: 5637af27-dc29-fc5c-9dfe-0645d52cb515
/// </code></pre>
/// <p></p>
/// <h5>Response</h5>
/// <p>The successful operation returns the <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html",
/// "name": "gatewayresponse",
/// "templated": true
/// },
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses"
/// },
/// "first": {
/// "href": "/restapis/o81lxisefl/gatewayresponses"
/// },
/// "gatewayresponse:by-type": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "item": [
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_FAILURE"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/RESOURCE_NOT_FOUND"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/REQUEST_TOO_LARGE"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/THROTTLED"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/UNSUPPORTED_MEDIA_TYPE"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_CONFIGURATION_ERROR"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_5XX"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_4XX"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_PARAMETERS"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_BODY"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/EXPIRED_TOKEN"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/ACCESS_DENIED"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_API_KEY"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/UNAUTHORIZED"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/API_CONFIGURATION_ERROR"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/QUOTA_EXCEEDED"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_TIMEOUT"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_SIGNATURE"
/// },
/// {
/// "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_FAILURE"
/// }
/// ]
/// },
/// "_embedded": {
/// "item": [
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_FAILURE"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_FAILURE"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "INTEGRATION_FAILURE",
/// "statusCode": "504"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/RESOURCE_NOT_FOUND"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/RESOURCE_NOT_FOUND"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "RESOURCE_NOT_FOUND",
/// "statusCode": "404"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/REQUEST_TOO_LARGE"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/REQUEST_TOO_LARGE"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "REQUEST_TOO_LARGE",
/// "statusCode": "413"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/THROTTLED"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/THROTTLED"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "THROTTLED",
/// "statusCode": "429"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/UNSUPPORTED_MEDIA_TYPE"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/UNSUPPORTED_MEDIA_TYPE"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "UNSUPPORTED_MEDIA_TYPE",
/// "statusCode": "415"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_CONFIGURATION_ERROR"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_CONFIGURATION_ERROR"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "AUTHORIZER_CONFIGURATION_ERROR",
/// "statusCode": "500"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_5XX"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_5XX"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "DEFAULT_5XX"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_4XX"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_4XX"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "DEFAULT_4XX"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_PARAMETERS"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_PARAMETERS"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "BAD_REQUEST_PARAMETERS",
/// "statusCode": "400"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_BODY"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_BODY"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "BAD_REQUEST_BODY",
/// "statusCode": "400"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/EXPIRED_TOKEN"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/EXPIRED_TOKEN"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "EXPIRED_TOKEN",
/// "statusCode": "403"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/ACCESS_DENIED"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/ACCESS_DENIED"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "ACCESS_DENIED",
/// "statusCode": "403"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_API_KEY"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_API_KEY"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "INVALID_API_KEY",
/// "statusCode": "403"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/UNAUTHORIZED"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/UNAUTHORIZED"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "UNAUTHORIZED",
/// "statusCode": "401"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/API_CONFIGURATION_ERROR"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/API_CONFIGURATION_ERROR"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "API_CONFIGURATION_ERROR",
/// "statusCode": "500"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/QUOTA_EXCEEDED"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/QUOTA_EXCEEDED"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "QUOTA_EXCEEDED",
/// "statusCode": "429"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_TIMEOUT"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_TIMEOUT"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "INTEGRATION_TIMEOUT",
/// "statusCode": "504"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "MISSING_AUTHENTICATION_TOKEN",
/// "statusCode": "403"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_SIGNATURE"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_SIGNATURE"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "INVALID_SIGNATURE",
/// "statusCode": "403"
/// },
/// {
/// "_links": {
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_FAILURE"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_FAILURE"
/// }
/// },
/// "defaultResponse": true,
/// "responseParameters": {},
/// "responseTemplates": {
/// "application/json": "{\"message\":$context.error.messageString}"
/// },
/// "responseType": "AUTHORIZER_FAILURE",
/// "statusCode": "500"
/// }
/// ]
/// }
/// }</code></pre>
/// <p></p>
/// </div>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html">Customize Gateway Responses</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGatewayResponsesOutput {
    /// <p>Returns the entire collection, because of no pagination support.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::GatewayResponse>>,
    /// <p>The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetGatewayResponsesOutput {
    /// <p>Returns the entire collection, because of no pagination support.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::GatewayResponse]> {
        self.items.as_deref()
    }
    /// <p>The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetGatewayResponsesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGatewayResponsesOutput");
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetGatewayResponsesOutput`](crate::output::GetGatewayResponsesOutput)
pub mod get_gateway_responses_output {
    /// A builder for [`GetGatewayResponsesOutput`](crate::output::GetGatewayResponsesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::GatewayResponse>>,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Returns the entire collection, because of no pagination support.</p>
        pub fn items(mut self, input: impl Into<crate::model::GatewayResponse>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>Returns the entire collection, because of no pagination support.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GatewayResponse>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGatewayResponsesOutput`](crate::output::GetGatewayResponsesOutput)
        pub fn build(self) -> crate::output::GetGatewayResponsesOutput {
            crate::output::GetGatewayResponsesOutput {
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetGatewayResponsesOutput {
    /// Creates a new builder-style object to manufacture [`GetGatewayResponsesOutput`](crate::output::GetGatewayResponsesOutput)
    pub fn builder() -> crate::output::get_gateway_responses_output::Builder {
        crate::output::get_gateway_responses_output::Builder::default()
    }
}

/// <p>A gateway response of a given response type and status code, with optional response parameters and mapping templates.</p>
/// <div class="remarks">
/// For more information about valid gateway response types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">Gateway Response Types Supported by API Gateway</a>
/// <div class="example">
/// <h4>Example: Get a Gateway Response of a given response type</h4>
/// <h5>Request</h5>
/// <p>This example shows how to get a gateway response of the <code>MISSING_AUTHENTICATION_TOKEN</code> type.</p>
/// <pre><code>GET /restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN HTTP/1.1
/// Host: beta-apigateway.us-east-1.amazonaws.com
/// Content-Type: application/json
/// X-Amz-Date: 20170503T202516Z
/// Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=1b52460e3159c1a26cff29093855d50ea141c1c5b937528fecaf60f51129697a
/// Cache-Control: no-cache
/// Postman-Token: 3b2a1ce9-c848-2e26-2e2f-9c2caefbed45
/// </code></pre>
/// <p>The response type is specified as a URL path.</p>
/// <h5>Response</h5>
/// <p>The successful operation returns the <code>200 OK</code> status code and a payload similar to the following:</p>
/// <pre><code>{
/// "_links": {
/// "curies": {
/// "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html",
/// "name": "gatewayresponse",
/// "templated": true
/// },
/// "self": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// "gatewayresponse:delete": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// },
/// "gatewayresponse:put": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
/// "templated": true
/// },
/// "gatewayresponse:update": {
/// "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
/// }
/// },
/// "defaultResponse": false,
/// "responseParameters": {
/// "gatewayresponse.header.x-request-path": "method.request.path.petId",
/// "gatewayresponse.header.Access-Control-Allow-Origin": "'a.b.c'",
/// "gatewayresponse.header.x-request-query": "method.request.querystring.q",
/// "gatewayresponse.header.x-request-header": "method.request.header.Accept"
/// },
/// "responseTemplates": {
/// "application/json": "{\n     \"message\": $context.error.messageString,\n     \"type\":  \"$context.error.responseType\",\n     \"stage\":  \"$context.stage\",\n     \"resourcePath\":  \"$context.resourcePath\",\n     \"stageVariables.a\":  \"$stageVariables.a\",\n     \"statusCode\": \"'404'\"\n}"
/// },
/// "responseType": "MISSING_AUTHENTICATION_TOKEN",
/// "statusCode": "404"
/// }</code></pre>
/// <p></p>
/// </div>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html">Customize Gateway Responses</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGatewayResponseOutput {
    /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
    pub response_type: std::option::Option<crate::model::GatewayResponseType>,
    /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
    pub response_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
    pub response_templates:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    pub default_response: bool,
}
impl GetGatewayResponseOutput {
    /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
    pub fn response_type(&self) -> std::option::Option<&crate::model::GatewayResponseType> {
        self.response_type.as_ref()
    }
    /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
    pub fn response_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_parameters.as_ref()
    }
    /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
    pub fn response_templates(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_templates.as_ref()
    }
    /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
    pub fn default_response(&self) -> bool {
        self.default_response
    }
}
impl std::fmt::Debug for GetGatewayResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGatewayResponseOutput");
        formatter.field("response_type", &self.response_type);
        formatter.field("status_code", &self.status_code);
        formatter.field("response_parameters", &self.response_parameters);
        formatter.field("response_templates", &self.response_templates);
        formatter.field("default_response", &self.default_response);
        formatter.finish()
    }
}
/// See [`GetGatewayResponseOutput`](crate::output::GetGatewayResponseOutput)
pub mod get_gateway_response_output {
    /// A builder for [`GetGatewayResponseOutput`](crate::output::GetGatewayResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_type: std::option::Option<crate::model::GatewayResponseType>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) default_response: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.response_type = Some(input);
            self
        }
        /// <p>The response type of the associated <a>GatewayResponse</a>.</p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.response_type = input;
            self
        }
        /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The HTTP status code for this <a>GatewayResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
        pub fn default_response(mut self, input: bool) -> Self {
            self.default_response = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>
        pub fn set_default_response(mut self, input: std::option::Option<bool>) -> Self {
            self.default_response = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGatewayResponseOutput`](crate::output::GetGatewayResponseOutput)
        pub fn build(self) -> crate::output::GetGatewayResponseOutput {
            crate::output::GetGatewayResponseOutput {
                response_type: self.response_type,
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                default_response: self.default_response.unwrap_or_default(),
            }
        }
    }
}
impl GetGatewayResponseOutput {
    /// Creates a new builder-style object to manufacture [`GetGatewayResponseOutput`](crate::output::GetGatewayResponseOutput)
    pub fn builder() -> crate::output::get_gateway_response_output::Builder {
        crate::output::get_gateway_response_output::Builder::default()
    }
}

/// <p>The binary blob response to <a>GetExport</a>, which contains the generated SDK.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExportOutput {
    /// <p>The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in the request.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The content-disposition header value in the HTTP response.</p>
    pub content_disposition: std::option::Option<std::string::String>,
    /// <p>The binary blob response to <a>GetExport</a>, which contains the export.</p>
    pub body: std::option::Option<aws_smithy_types::Blob>,
}
impl GetExportOutput {
    /// <p>The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in the request.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The content-disposition header value in the HTTP response.</p>
    pub fn content_disposition(&self) -> std::option::Option<&str> {
        self.content_disposition.as_deref()
    }
    /// <p>The binary blob response to <a>GetExport</a>, which contains the export.</p>
    pub fn body(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.body.as_ref()
    }
}
impl std::fmt::Debug for GetExportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExportOutput");
        formatter.field("content_type", &self.content_type);
        formatter.field("content_disposition", &self.content_disposition);
        formatter.field("body", &self.body);
        formatter.finish()
    }
}
/// See [`GetExportOutput`](crate::output::GetExportOutput)
pub mod get_export_output {
    /// A builder for [`GetExportOutput`](crate::output::GetExportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in the request.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in the request.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The content-disposition header value in the HTTP response.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p>The content-disposition header value in the HTTP response.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p>The binary blob response to <a>GetExport</a>, which contains the export.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The binary blob response to <a>GetExport</a>, which contains the export.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExportOutput`](crate::output::GetExportOutput)
        pub fn build(self) -> crate::output::GetExportOutput {
            crate::output::GetExportOutput {
                content_type: self.content_type,
                content_disposition: self.content_disposition,
                body: self.body,
            }
        }
    }
}
impl GetExportOutput {
    /// Creates a new builder-style object to manufacture [`GetExportOutput`](crate::output::GetExportOutput)
    pub fn builder() -> crate::output::get_export_output::Builder {
        crate::output::get_export_output::Builder::default()
    }
}

/// <p>Represents a collection of <a>DomainName</a> resources.</p>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Use Client-Side Certificate</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainNamesOutput {
    /// <p>The current page of elements from this collection.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::DomainName>>,
    /// <p>The current pagination position in the paged result set.</p>
    pub position: std::option::Option<std::string::String>,
}
impl GetDomainNamesOutput {
    /// <p>The current page of elements from this collection.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::DomainName]> {
        self.items.as_deref()
    }
    /// <p>The current pagination position in the paged result set.</p>
    pub fn position(&self) -> std::option::Option<&str> {
        self.position.as_deref()
    }
}
impl std::fmt::Debug for GetDomainNamesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainNamesOutput");
        formatter.field("items", &self.items);
        formatter.field("position", &self.position);
        formatter.finish()
    }
}
/// See [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput)
pub mod get_domain_names_output {
    /// A builder for [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::DomainName>>,
        pub(crate) position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The current page of elements from this collection.</p>
        pub fn items(mut self, input: impl Into<crate::model::DomainName>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The current page of elements from this collection.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainName>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput)
        pub fn build(self) -> crate::output::GetDomainNamesOutput {
            crate::output::GetDomainNamesOutput {
                items: self.items,
                position: self.position,
            }
        }
    }
}
impl GetDomainNamesOutput {
    /// Creates a new builder-style object to manufacture [`GetDomainNamesOutput`](crate::output::GetDomainNamesOutput)
    pub fn builder() -> crate::output::get_domain_names_output::Builder {
        crate::output::get_domain_names_output::Builder::default()
    }
}

/// <p>Represents a custom domain name as a user-friendly host name of an API (<a>RestApi</a>).</p>
/// <div class="Remarks">
/// <p>When you deploy an API, API Gateway creates a default host name for the API. This default API host name is of the <code>{restapi-id}.execute-api.{region}.amazonaws.com</code> format. With the default host name, you can access the API's root resource with the URL of <code>https://{restapi-id}.execute-api.{region}.amazonaws.com/{stage}/</code>. When you set up a custom domain name of <code>apis.example.com</code> for this API, you can then access the same resource using the URL of the <code>https://apis.examples.com/myApi</code>, where <code>myApi</code> is the base path mapping (<a>BasePathMapping</a>) of your API under the custom domain name.
/// </p>
/// </div>
/// <div class="seeAlso">
/// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Set a Custom Host Name for an API</a>
/// </div>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainNameOutput {
    /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    pub certificate_name: std::option::Option<std::string::String>,
    /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    pub certificate_upload_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
    pub regional_domain_name: std::option::Option<std::string::String>,
    /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub regional_hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
    pub regional_certificate_name: std::option::Option<std::string::String>,
    /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
    pub regional_certificate_arn: std::option::Option<std::string::String>,
    /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
    pub distribution_domain_name: std::option::Option<std::string::String>,
    /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub distribution_hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
    pub endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
    /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
    pub domain_name_status: std::option::Option<crate::model::DomainNameStatus>,
    /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
    pub domain_name_status_message: std::option::Option<std::string::String>,
    /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    pub security_policy: std::option::Option<crate::model::SecurityPolicy>,
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
    pub mutual_tls_authentication: std::option::Option<crate::model::MutualTlsAuthentication>,
    /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    pub ownership_verification_certificate_arn: std::option::Option<std::string::String>,
}
impl GetDomainNameOutput {
    /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
    pub fn certificate_name(&self) -> std::option::Option<&str> {
        self.certificate_name.as_deref()
    }
    /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
    pub fn certificate_upload_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.certificate_upload_date.as_ref()
    }
    /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
    pub fn regional_domain_name(&self) -> std::option::Option<&str> {
        self.regional_domain_name.as_deref()
    }
    /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub fn regional_hosted_zone_id(&self) -> std::option::Option<&str> {
        self.regional_hosted_zone_id.as_deref()
    }
    /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
    pub fn regional_certificate_name(&self) -> std::option::Option<&str> {
        self.regional_certificate_name.as_deref()
    }
    /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
    pub fn regional_certificate_arn(&self) -> std::option::Option<&str> {
        self.regional_certificate_arn.as_deref()
    }
    /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
    pub fn distribution_domain_name(&self) -> std::option::Option<&str> {
        self.distribution_domain_name.as_deref()
    }
    /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
    pub fn distribution_hosted_zone_id(&self) -> std::option::Option<&str> {
        self.distribution_hosted_zone_id.as_deref()
    }
    /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
    pub fn endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EndpointConfiguration> {
        self.endpoint_configuration.as_ref()
    }
    /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
    pub fn domain_name_status(&self) -> std::option::Option<&crate::model::DomainNameStatus> {
        self.domain_name_status.as_ref()
    }
    /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
    pub fn domain_name_status_message(&self) -> std::option::Option<&str> {
        self.domain_name_status_message.as_deref()
    }
    /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
    pub fn security_policy(&self) -> std::option::Option<&crate::model::SecurityPolicy> {
        self.security_policy.as_ref()
    }
    /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
    pub fn mutual_tls_authentication(
        &self,
    ) -> std::option::Option<&crate::model::MutualTlsAuthentication> {
        self.mutual_tls_authentication.as_ref()
    }
    /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
    pub fn ownership_verification_certificate_arn(&self) -> std::option::Option<&str> {
        self.ownership_verification_certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for GetDomainNameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainNameOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("certificate_name", &self.certificate_name);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_upload_date", &self.certificate_upload_date);
        formatter.field("regional_domain_name", &self.regional_domain_name);
        formatter.field("regional_hosted_zone_id", &self.regional_hosted_zone_id);
        formatter.field("regional_certificate_name", &self.regional_certificate_name);
        formatter.field("regional_certificate_arn", &self.regional_certificate_arn);
        formatter.field("distribution_domain_name", &self.distribution_domain_name);
        formatter.field(
            "distribution_hosted_zone_id",
            &self.distribution_hosted_zone_id,
        );
        formatter.field("endpoint_configuration", &self.endpoint_configuration);
        formatter.field("domain_name_status", &self.domain_name_status);
        formatter.field(
            "domain_name_status_message",
            &self.domain_name_status_message,
        );
        formatter.field("security_policy", &self.security_policy);
        formatter.field("tags", &self.tags);
        formatter.field("mutual_tls_authentication", &self.mutual_tls_authentication);
        formatter.field(
            "ownership_verification_certificate_arn",
            &self.ownership_verification_certificate_arn,
        );
        formatter.finish()
    }
}
/// See [`GetDomainNameOutput`](crate::output::GetDomainNameOutput)
pub mod get_domain_name_output {
    /// A builder for [`GetDomainNameOutput`](crate::output::GetDomainNameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_upload_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) regional_domain_name: std::option::Option<std::string::String>,
        pub(crate) regional_hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) regional_certificate_name: std::option::Option<std::string::String>,
        pub(crate) regional_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) distribution_domain_name: std::option::Option<std::string::String>,
        pub(crate) distribution_hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) domain_name_status: std::option::Option<crate::model::DomainNameStatus>,
        pub(crate) domain_name_status_message: std::option::Option<std::string::String>,
        pub(crate) security_policy: std::option::Option<crate::model::SecurityPolicy>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthentication>,
        pub(crate) ownership_verification_certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
        pub fn certificate_upload_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.certificate_upload_date = Some(input);
            self
        }
        /// <p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>
        pub fn set_certificate_upload_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.certificate_upload_date = input;
            self
        }
        /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
        pub fn regional_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_domain_name = Some(input.into());
            self
        }
        /// <p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>
        pub fn set_regional_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_domain_name = input;
            self
        }
        /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn regional_hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn set_regional_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_hosted_zone_id = input;
            self
        }
        /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
        pub fn regional_certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate that will be used for validating the regional domain name.</p>
        pub fn set_regional_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_certificate_name = input;
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn regional_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_certificate_arn = Some(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_regional_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_certificate_arn = input;
            self
        }
        /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
        pub fn distribution_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_domain_name = Some(input.into());
            self
        }
        /// <p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation</a>.</p>
        pub fn set_distribution_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_domain_name = input;
            self
        }
        /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn distribution_hosted_zone_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>.</p>
        pub fn set_distribution_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_hosted_zone_id = input;
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
        pub fn domain_name_status(mut self, input: crate::model::DomainNameStatus) -> Self {
            self.domain_name_status = Some(input);
            self
        }
        /// <p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code>, <code>UPDATING</code>, <code>PENDING_CERTIFICATE_REIMPORT</code>, and <code>PENDING_OWNERSHIP_VERIFICATION</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>
        pub fn set_domain_name_status(
            mut self,
            input: std::option::Option<crate::model::DomainNameStatus>,
        ) -> Self {
            self.domain_name_status = input;
            self
        }
        /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
        pub fn domain_name_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name_status_message = Some(input.into());
            self
        }
        /// <p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>
        pub fn set_domain_name_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_name_status_message = input;
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn security_policy(mut self, input: crate::model::SecurityPolicy) -> Self {
            self.security_policy = Some(input);
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn set_security_policy(
            mut self,
            input: std::option::Option<crate::model::SecurityPolicy>,
        ) -> Self {
            self.security_policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The collection of tags. Each tag element is associated with a given resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthentication,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthentication>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn ownership_verification_certificate_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn set_ownership_verification_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainNameOutput`](crate::output::GetDomainNameOutput)
        pub fn build(self) -> crate::output::GetDomainNameOutput {
            crate::output::GetDomainNameOutput {
                domain_name: self.domain_name,
                certificate_name: self.certificate_name,
                certificate_arn: self.certificate_arn,
                certificate_upload_date: self.certificate_upload_date,
                regional_domain_name: self.regional_domain_name,
                regional_hosted_zone_id: self.regional_hosted_zone_id,
                regional_certificate_name: self.regional_certificate_name,
                regional_certificate_arn: self.regional_certificate_arn,
                distribution_domain_name: self.distribution_domain_name,
                distribution_hosted_zone_id: self.distribution_hosted_zone_id,
                endpoint_configuration: self.endpoint_configuration,
                domain_name_status: self.domain_name_status,
             