// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
pub mod create_api_key_input {
    /// A builder for [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) generate_distinct_id: std::option::Option<bool>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) stage_keys: std::option::Option<std::vec::Vec<crate::model::StageKey>>,
        pub(crate) customer_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the <a>ApiKey</a>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <a>ApiKey</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the <a>ApiKey</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the <a>ApiKey</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether the <a>ApiKey</a> can be used by callers.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the <a>ApiKey</a> can be used by callers.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.</p>
        pub fn generate_distinct_id(mut self, input: bool) -> Self {
            self.generate_distinct_id = Some(input);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.</p>
        pub fn set_generate_distinct_id(mut self, input: std::option::Option<bool>) -> Self {
            self.generate_distinct_id = input;
            self
        }
        /// <p>Specifies a value of the API key.</p> <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Specifies a value of the API key.</p> <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Appends an item to `stage_keys`.
        ///
        /// To override the contents of this collection use [`set_stage_keys`](Self::set_stage_keys).
        ///
        /// <p>DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.</p>
        pub fn stage_keys(mut self, input: impl Into<crate::model::StageKey>) -> Self {
            let mut v = self.stage_keys.unwrap_or_default();
            v.push(input.into());
            self.stage_keys = Some(v);
            self
        }
        /// <p>DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.</p>
        pub fn set_stage_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StageKey>>,
        ) -> Self {
            self.stage_keys = input;
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn customer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_id = Some(input.into());
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn set_customer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.customer_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApiKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApiKeyInput {
                name: self.name,
                description: self.description,
                enabled: self.enabled.unwrap_or_default(),
                generate_distinct_id: self.generate_distinct_id.unwrap_or_default(),
                value: self.value,
                stage_keys: self.stage_keys,
                customer_id: self.customer_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApiKeyInputOperationOutputAlias = crate::operation::CreateApiKey;
#[doc(hidden)]
pub type CreateApiKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateApiKeyInput {
    /// Consumes the builder and constructs an Operation<[`CreateApiKey`](crate::operation::CreateApiKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApiKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateApiKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/apikeys").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateApiKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateApiKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_api_key(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApiKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApiKey",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
    pub fn builder() -> crate::input::create_api_key_input::Builder {
        crate::input::create_api_key_input::Builder::default()
    }
}

/// See [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
pub mod create_authorizer_input {
    /// A builder for [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AuthorizerType>,
        pub(crate) provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auth_type: std::option::Option<std::string::String>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) authorizer_credentials: std::option::Option<std::string::String>,
        pub(crate) identity_source: std::option::Option<std::string::String>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>[Required] The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn r#type(mut self, input: crate::model::AuthorizerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>[Required] The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_provider_ar_ns`](Self::set_provider_ar_ns).
        ///
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.provider_ar_ns = Some(v);
            self
        }
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn set_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.provider_ar_ns = input;
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn auth_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_type = Some(input.into());
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn set_auth_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_type = input;
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn authorizer_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_credentials = Some(input.into());
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn set_authorizer_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_credentials = input;
            self
        }
        /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
        pub fn identity_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_source = Some(input.into());
            self
        }
        /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_source = input;
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAuthorizerInput {
                rest_api_id: self.rest_api_id,
                name: self.name,
                r#type: self.r#type,
                provider_ar_ns: self.provider_ar_ns,
                auth_type: self.auth_type,
                authorizer_uri: self.authorizer_uri,
                authorizer_credentials: self.authorizer_credentials,
                identity_source: self.identity_source,
                identity_validation_expression: self.identity_validation_expression,
                authorizer_result_ttl_in_seconds: self.authorizer_result_ttl_in_seconds,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAuthorizerInputOperationOutputAlias = crate::operation::CreateAuthorizer;
#[doc(hidden)]
pub type CreateAuthorizerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`CreateAuthorizer`](crate::operation::CreateAuthorizer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAuthorizer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAuthorizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.rest_api_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_1, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/authorizers",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAuthorizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAuthorizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_authorizer(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAuthorizer",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
    pub fn builder() -> crate::input::create_authorizer_input::Builder {
        crate::input::create_authorizer_input::Builder::default()
    }
}

/// See [`CreateBasePathMappingInput`](crate::input::CreateBasePathMappingInput)
pub mod create_base_path_mapping_input {
    /// A builder for [`CreateBasePathMappingInput`](crate::input::CreateBasePathMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) base_path: std::option::Option<std::string::String>,
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to create.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to create.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_path = Some(input.into());
            self
        }
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.base_path = input;
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBasePathMappingInput`](crate::input::CreateBasePathMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBasePathMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBasePathMappingInput {
                domain_name: self.domain_name,
                base_path: self.base_path,
                rest_api_id: self.rest_api_id,
                stage: self.stage,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBasePathMappingInputOperationOutputAlias = crate::operation::CreateBasePathMapping;
#[doc(hidden)]
pub type CreateBasePathMappingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBasePathMappingInput {
    /// Consumes the builder and constructs an Operation<[`CreateBasePathMapping`](crate::operation::CreateBasePathMapping)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBasePathMapping,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBasePathMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.domain_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    })?;
            let domain_name = aws_smithy_http::label::fmt_string(input_2, false);
            if domain_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "domain_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/domainnames/{domainName}/basepathmappings",
                domainName = domain_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBasePathMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBasePathMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_base_path_mapping(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBasePathMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBasePathMapping",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBasePathMappingInput`](crate::input::CreateBasePathMappingInput)
    pub fn builder() -> crate::input::create_base_path_mapping_input::Builder {
        crate::input::create_base_path_mapping_input::Builder::default()
    }
}

/// See [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
pub mod create_deployment_input {
    /// A builder for [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) stage_description: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_enabled: std::option::Option<bool>,
        pub(crate) cache_cluster_size: std::option::Option<crate::model::CacheClusterSize>,
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) canary_settings: std::option::Option<crate::model::DeploymentCanarySettings>,
        pub(crate) tracing_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>
        pub fn stage_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_description = Some(input.into());
            self
        }
        /// <p>The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>
        pub fn set_stage_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stage_description = input;
            self
        }
        /// <p>The description for the <a>Deployment</a> resource to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the <a>Deployment</a> resource to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Enables a cache cluster for the <a>Stage</a> resource specified in the input.</p>
        pub fn cache_cluster_enabled(mut self, input: bool) -> Self {
            self.cache_cluster_enabled = Some(input);
            self
        }
        /// <p>Enables a cache cluster for the <a>Stage</a> resource specified in the input.</p>
        pub fn set_cache_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cache_cluster_enabled = input;
            self
        }
        /// <p>Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache cluster is enabled.</p>
        pub fn cache_cluster_size(mut self, input: crate::model::CacheClusterSize) -> Self {
            self.cache_cluster_size = Some(input);
            self
        }
        /// <p>Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache cluster is enabled.</p>
        pub fn set_cache_cluster_size(
            mut self,
            input: std::option::Option<crate::model::CacheClusterSize>,
        ) -> Self {
            self.cache_cluster_size = input;
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>A map that defines the stage variables for the <a>Stage</a> resource that is associated
        /// with the new deployment. Variable names can have alphanumeric and underscore characters, and the values
        /// must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for the <a>Stage</a> resource that is associated
        /// with the new deployment. Variable names can have alphanumeric and underscore characters, and the values
        /// must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p>The input configuration for the canary deployment when the deployment is a canary release deployment. </p>
        pub fn canary_settings(mut self, input: crate::model::DeploymentCanarySettings) -> Self {
            self.canary_settings = Some(input);
            self
        }
        /// <p>The input configuration for the canary deployment when the deployment is a canary release deployment. </p>
        pub fn set_canary_settings(
            mut self,
            input: std::option::Option<crate::model::DeploymentCanarySettings>,
        ) -> Self {
            self.canary_settings = input;
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn tracing_enabled(mut self, input: bool) -> Self {
            self.tracing_enabled = Some(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn set_tracing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.tracing_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentInput {
                rest_api_id: self.rest_api_id,
                stage_name: self.stage_name,
                stage_description: self.stage_description,
                description: self.description,
                cache_cluster_enabled: self.cache_cluster_enabled,
                cache_cluster_size: self.cache_cluster_size,
                variables: self.variables,
                canary_settings: self.canary_settings,
                tracing_enabled: self.tracing_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentInputOperationOutputAlias = crate::operation::CreateDeployment;
#[doc(hidden)]
pub type CreateDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeployment`](crate::operation::CreateDeployment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.rest_api_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_3, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/deployments",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_deployment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeployment",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
}

/// See [`CreateDocumentationPartInput`](crate::input::CreateDocumentationPartInput)
pub mod create_documentation_part_input {
    /// A builder for [`CreateDocumentationPartInput`](crate::input::CreateDocumentationPartInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::DocumentationPartLocation>,
        pub(crate) properties: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The location of the targeted API entity of the to-be-created documentation part.</p>
        pub fn location(mut self, input: crate::model::DocumentationPartLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>[Required] The location of the targeted API entity of the to-be-created documentation part.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::DocumentationPartLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>[Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.</p>
        pub fn properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.properties = Some(input.into());
            self
        }
        /// <p>[Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.</p>
        pub fn set_properties(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDocumentationPartInput`](crate::input::CreateDocumentationPartInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDocumentationPartInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDocumentationPartInput {
                rest_api_id: self.rest_api_id,
                location: self.location,
                properties: self.properties,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDocumentationPartInputOperationOutputAlias =
    crate::operation::CreateDocumentationPart;
#[doc(hidden)]
pub type CreateDocumentationPartInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDocumentationPartInput {
    /// Consumes the builder and constructs an Operation<[`CreateDocumentationPart`](crate::operation::CreateDocumentationPart)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDocumentationPart,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDocumentationPartInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.rest_api_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_4, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/documentation/parts",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDocumentationPartInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDocumentationPartInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_documentation_part(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDocumentationPart::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDocumentationPart",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDocumentationPartInput`](crate::input::CreateDocumentationPartInput)
    pub fn builder() -> crate::input::create_documentation_part_input::Builder {
        crate::input::create_documentation_part_input::Builder::default()
    }
}

/// See [`CreateDocumentationVersionInput`](crate::input::CreateDocumentationVersionInput)
pub mod create_documentation_version_input {
    /// A builder for [`CreateDocumentationVersionInput`](crate::input::CreateDocumentationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) documentation_version: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The version identifier of the new snapshot.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.documentation_version = Some(input.into());
            self
        }
        /// <p>[Required] The version identifier of the new snapshot.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documentation_version = input;
            self
        }
        /// <p>The stage name to be associated with the new documentation snapshot.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The stage name to be associated with the new documentation snapshot.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>A description about the new documentation snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description about the new documentation snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDocumentationVersionInput`](crate::input::CreateDocumentationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDocumentationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDocumentationVersionInput {
                rest_api_id: self.rest_api_id,
                documentation_version: self.documentation_version,
                stage_name: self.stage_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDocumentationVersionInputOperationOutputAlias =
    crate::operation::CreateDocumentationVersion;
#[doc(hidden)]
pub type CreateDocumentationVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDocumentationVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateDocumentationVersion`](crate::operation::CreateDocumentationVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDocumentationVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDocumentationVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.rest_api_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_5, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/documentation/versions",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDocumentationVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDocumentationVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_documentation_version(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDocumentationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDocumentationVersion",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDocumentationVersionInput`](crate::input::CreateDocumentationVersionInput)
    pub fn builder() -> crate::input::create_documentation_version_input::Builder {
        crate::input::create_documentation_version_input::Builder::default()
    }
}

/// See [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
pub mod create_domain_name_input {
    /// A builder for [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) certificate_body: std::option::Option<std::string::String>,
        pub(crate) certificate_private_key: std::option::Option<std::string::String>,
        pub(crate) certificate_chain: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) regional_certificate_name: std::option::Option<std::string::String>,
        pub(crate) regional_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) security_policy: std::option::Option<crate::model::SecurityPolicy>,
        pub(crate) mutual_tls_authentication:
            std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        pub(crate) ownership_verification_certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The name of the <a>DomainName</a> resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>[Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.</p>
        pub fn certificate_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_body = Some(input.into());
            self
        }
        /// <p>[Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.</p>
        pub fn set_certificate_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_body = input;
            self
        }
        /// <p>[Deprecated] Your edge-optimized endpoint's domain name certificate's private key.</p>
        pub fn certificate_private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_private_key = Some(input.into());
            self
        }
        /// <p>[Deprecated] Your edge-optimized endpoint's domain name certificate's private key.</p>
        pub fn set_certificate_private_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_private_key = input;
            self
        }
        /// <p>[Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.</p>
        pub fn certificate_chain(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_chain = Some(input.into());
            self
        }
        /// <p>[Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_chain = input;
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by regional endpoint for this domain name.</p>
        pub fn regional_certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_certificate_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by regional endpoint for this domain name.</p>
        pub fn set_regional_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_certificate_name = input;
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn regional_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.regional_certificate_arn = Some(input.into());
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_regional_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regional_certificate_arn = input;
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn security_policy(mut self, input: crate::model::SecurityPolicy) -> Self {
            self.security_policy = Some(input);
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn set_security_policy(
            mut self,
            input: std::option::Option<crate::model::SecurityPolicy>,
        ) -> Self {
            self.security_policy = input;
            self
        }
        /// <p>If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            input: crate::model::MutualTlsAuthenticationInput,
        ) -> Self {
            self.mutual_tls_authentication = Some(input);
            self
        }
        /// <p>If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        ) -> Self {
            self.mutual_tls_authentication = input;
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn ownership_verification_certificate_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn set_ownership_verification_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ownership_verification_certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainNameInput {
                domain_name: self.domain_name,
                certificate_name: self.certificate_name,
                certificate_body: self.certificate_body,
                certificate_private_key: self.certificate_private_key,
                certificate_chain: self.certificate_chain,
                certificate_arn: self.certificate_arn,
                regional_certificate_name: self.regional_certificate_name,
                regional_certificate_arn: self.regional_certificate_arn,
                endpoint_configuration: self.endpoint_configuration,
                tags: self.tags,
                security_policy: self.security_policy,
                mutual_tls_authentication: self.mutual_tls_authentication,
                ownership_verification_certificate_arn: self.ownership_verification_certificate_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainNameInputOperationOutputAlias = crate::operation::CreateDomainName;
#[doc(hidden)]
pub type CreateDomainNameInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomainName`](crate::operation::CreateDomainName)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomainName,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDomainNameInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/domainnames").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDomainNameInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDomainNameInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_domain_name(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomainName",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
    pub fn builder() -> crate::input::create_domain_name_input::Builder {
        crate::input::create_domain_name_input::Builder::default()
    }
}

/// See [`CreateModelInput`](crate::input::CreateModelInput)
pub mod create_model_input {
    /// A builder for [`CreateModelInput`](crate::input::CreateModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> will be created.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> will be created.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>[Required] The content-type for the model.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>[Required] The content-type for the model.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelInput`](crate::input::CreateModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelInput {
                rest_api_id: self.rest_api_id,
                name: self.name,
                description: self.description,
                schema: self.schema,
                content_type: self.content_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelInputOperationOutputAlias = crate::operation::CreateModel;
#[doc(hidden)]
pub type CreateModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateModelInput {
    /// Consumes the builder and constructs an Operation<[`CreateModel`](crate::operation::CreateModel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.rest_api_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_6, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/models",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_model(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModel",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
}

/// See [`CreateRequestValidatorInput`](crate::input::CreateRequestValidatorInput)
pub mod create_request_validator_input {
    /// A builder for [`CreateRequestValidatorInput`](crate::input::CreateRequestValidatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) validate_request_body: std::option::Option<bool>,
        pub(crate) validate_request_parameters: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The name of the to-be-created <a>RequestValidator</a>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the to-be-created <a>RequestValidator</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).</p>
        pub fn validate_request_body(mut self, input: bool) -> Self {
            self.validate_request_body = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).</p>
        pub fn set_validate_request_body(mut self, input: std::option::Option<bool>) -> Self {
            self.validate_request_body = input;
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.</p>
        pub fn validate_request_parameters(mut self, input: bool) -> Self {
            self.validate_request_parameters = Some(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.</p>
        pub fn set_validate_request_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.validate_request_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRequestValidatorInput`](crate::input::CreateRequestValidatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRequestValidatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRequestValidatorInput {
                rest_api_id: self.rest_api_id,
                name: self.name,
                validate_request_body: self.validate_request_body.unwrap_or_default(),
                validate_request_parameters: self.validate_request_parameters.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRequestValidatorInputOperationOutputAlias = crate::operation::CreateRequestValidator;
#[doc(hidden)]
pub type CreateRequestValidatorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRequestValidatorInput {
    /// Consumes the builder and constructs an Operation<[`CreateRequestValidator`](crate::operation::CreateRequestValidator)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRequestValidator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRequestValidatorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.rest_api_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_7, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/requestvalidators",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRequestValidatorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRequestValidatorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_request_validator(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRequestValidator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRequestValidator",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRequestValidatorInput`](crate::input::CreateRequestValidatorInput)
    pub fn builder() -> crate::input::create_request_validator_input::Builder {
        crate::input::create_request_validator_input::Builder::default()
    }
}

/// See [`CreateResourceInput`](crate::input::CreateResourceInput)
pub mod create_resource_input {
    /// A builder for [`CreateResourceInput`](crate::input::CreateResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) path_part: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The parent resource's identifier.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>[Required] The parent resource's identifier.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn path_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_part = Some(input.into());
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn set_path_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_part = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceInput`](crate::input::CreateResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourceInput {
                rest_api_id: self.rest_api_id,
                parent_id: self.parent_id,
                path_part: self.path_part,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourceInputOperationOutputAlias = crate::operation::CreateResource;
#[doc(hidden)]
pub type CreateResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResourceInput {
    /// Consumes the builder and constructs an Operation<[`CreateResource`](crate::operation::CreateResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.rest_api_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_8, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.parent_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "parent_id",
                        details: "cannot be empty or unset",
                    })?;
            let parent_id = aws_smithy_http::label::fmt_string(input_9, false);
            if parent_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "parent_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{parentId}",
                restApiId = rest_api_id,
                parentId = parent_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResource",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourceInput`](crate::input::CreateResourceInput)
    pub fn builder() -> crate::input::create_resource_input::Builder {
        crate::input::create_resource_input::Builder::default()
    }
}

/// See [`CreateRestApiInput`](crate::input::CreateRestApiInput)
pub mod create_rest_api_input {
    /// A builder for [`CreateRestApiInput`](crate::input::CreateRestApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) clone_from: std::option::Option<std::string::String>,
        pub(crate) binary_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_compression_size: std::option::Option<i32>,
        pub(crate) api_key_source: std::option::Option<crate::model::ApiKeySourceType>,
        pub(crate) endpoint_configuration: std::option::Option<crate::model::EndpointConfiguration>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) disable_execute_api_endpoint: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>[Required] The name of the <a>RestApi</a>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the <a>RestApi</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the <a>RestApi</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the <a>RestApi</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The ID of the <a>RestApi</a> that you want to clone from.</p>
        pub fn clone_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.clone_from = Some(input.into());
            self
        }
        /// <p>The ID of the <a>RestApi</a> that you want to clone from.</p>
        pub fn set_clone_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.clone_from = input;
            self
        }
        /// Appends an item to `binary_media_types`.
        ///
        /// To override the contents of this collection use [`set_binary_media_types`](Self::set_binary_media_types).
        ///
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn binary_media_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.binary_media_types.unwrap_or_default();
            v.push(input.into());
            self.binary_media_types = Some(v);
            self
        }
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn set_binary_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.binary_media_types = input;
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn minimum_compression_size(mut self, input: i32) -> Self {
            self.minimum_compression_size = Some(input);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn set_minimum_compression_size(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_compression_size = input;
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn api_key_source(mut self, input: crate::model::ApiKeySourceType) -> Self {
            self.api_key_source = Some(input);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn set_api_key_source(
            mut self,
            input: std::option::Option<crate::model::ApiKeySourceType>,
        ) -> Self {
            self.api_key_source = input;
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn endpoint_configuration(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.endpoint_configuration = Some(input);
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.endpoint_configuration = input;
            self
        }
        /// A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, input: bool) -> Self {
            self.disable_execute_api_endpoint = Some(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_execute_api_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRestApiInput`](crate::input::CreateRestApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRestApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRestApiInput {
                name: self.name,
                description: self.description,
                version: self.version,
                clone_from: self.clone_from,
                binary_media_types: self.binary_media_types,
                minimum_compression_size: self.minimum_compression_size,
                api_key_source: self.api_key_source,
                endpoint_configuration: self.endpoint_configuration,
                policy: self.policy,
                tags: self.tags,
                disable_execute_api_endpoint: self.disable_execute_api_endpoint.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRestApiInputOperationOutputAlias = crate::operation::CreateRestApi;
#[doc(hidden)]
pub type CreateRestApiInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRestApiInput {
    /// Consumes the builder and constructs an Operation<[`CreateRestApi`](crate::operation::CreateRestApi)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRestApi,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRestApiInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/restapis").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRestApiInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRestApiInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_rest_api(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRestApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRestApi",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRestApiInput`](crate::input::CreateRestApiInput)
    pub fn builder() -> crate::input::create_rest_api_input::Builder {
        crate::input::create_rest_api_input::Builder::default()
    }
}

/// See [`CreateStageInput`](crate::input::CreateStageInput)
pub mod create_stage_input {
    /// A builder for [`CreateStageInput`](crate::input::CreateStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_enabled: std::option::Option<bool>,
        pub(crate) cache_cluster_size: std::option::Option<crate::model::CacheClusterSize>,
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) documentation_version: std::option::Option<std::string::String>,
        pub(crate) canary_settings: std::option::Option<crate::model::CanarySettings>,
        pub(crate) tracing_enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>[Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The description of the <a>Stage</a> resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the <a>Stage</a> resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Whether cache clustering is enabled for the stage.</p>
        pub fn cache_cluster_enabled(mut self, input: bool) -> Self {
            self.cache_cluster_enabled = Some(input);
            self
        }
        /// <p>Whether cache clustering is enabled for the stage.</p>
        pub fn set_cache_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cache_cluster_enabled = input;
            self
        }
        /// <p>The stage's cache cluster size.</p>
        pub fn cache_cluster_size(mut self, input: crate::model::CacheClusterSize) -> Self {
            self.cache_cluster_size = Some(input);
            self
        }
        /// <p>The stage's cache cluster size.</p>
        pub fn set_cache_cluster_size(
            mut self,
            input: std::option::Option<crate::model::CacheClusterSize>,
        ) -> Self {
            self.cache_cluster_size = input;
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>A map that defines the stage variables for the new <a>Stage</a> resource. Variable names
        /// can have alphanumeric and underscore characters, and the values must match
        /// <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.variables = Some(hash_map);
            self
        }
        /// <p>A map that defines the stage variables for the new <a>Stage</a> resource. Variable names
        /// can have alphanumeric and underscore characters, and the values must match
        /// <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.documentation_version = Some(input.into());
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documentation_version = input;
            self
        }
        /// <p>The canary deployment settings of this stage.</p>
        pub fn canary_settings(mut self, input: crate::model::CanarySettings) -> Self {
            self.canary_settings = Some(input);
            self
        }
        /// <p>The canary deployment settings of this stage.</p>
        pub fn set_canary_settings(
            mut self,
            input: std::option::Option<crate::model::CanarySettings>,
        ) -> Self {
            self.canary_settings = input;
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn tracing_enabled(mut self, input: bool) -> Self {
            self.tracing_enabled = Some(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn set_tracing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.tracing_enabled = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStageInput`](crate::input::CreateStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStageInput {
                rest_api_id: self.rest_api_id,
                stage_name: self.stage_name,
                deployment_id: self.deployment_id,
                description: self.description,
                cache_cluster_enabled: self.cache_cluster_enabled.unwrap_or_default(),
                cache_cluster_size: self.cache_cluster_size,
                variables: self.variables,
                documentation_version: self.documentation_version,
                canary_settings: self.canary_settings,
                tracing_enabled: self.tracing_enabled.unwrap_or_default(),
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStageInputOperationOutputAlias = crate::operation::CreateStage;
#[doc(hidden)]
pub type CreateStageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStageInput {
    /// Consumes the builder and constructs an Operation<[`CreateStage`](crate::operation::CreateStage)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.rest_api_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_10, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/stages",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_stage(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStage",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStageInput`](crate::input::CreateStageInput)
    pub fn builder() -> crate::input::create_stage_input::Builder {
        crate::input::create_stage_input::Builder::default()
    }
}

/// See [`CreateUsagePlanInput`](crate::input::CreateUsagePlanInput)
pub mod create_usage_plan_input {
    /// A builder for [`CreateUsagePlanInput`](crate::input::CreateUsagePlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) api_stages: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        pub(crate) throttle: std::option::Option<crate::model::ThrottleSettings>,
        pub(crate) quota: std::option::Option<crate::model::QuotaSettings>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>[Required] The name of the usage plan.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the usage plan.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the usage plan.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the usage plan.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `api_stages`.
        ///
        /// To override the contents of this collection use [`set_api_stages`](Self::set_api_stages).
        ///
        /// <p>The associated API stages of the usage plan.</p>
        pub fn api_stages(mut self, input: impl Into<crate::model::ApiStage>) -> Self {
            let mut v = self.api_stages.unwrap_or_default();
            v.push(input.into());
            self.api_stages = Some(v);
            self
        }
        /// <p>The associated API stages of the usage plan.</p>
        pub fn set_api_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        ) -> Self {
            self.api_stages = input;
            self
        }
        /// <p>The throttling limits of the usage plan.</p>
        pub fn throttle(mut self, input: crate::model::ThrottleSettings) -> Self {
            self.throttle = Some(input);
            self
        }
        /// <p>The throttling limits of the usage plan.</p>
        pub fn set_throttle(
            mut self,
            input: std::option::Option<crate::model::ThrottleSettings>,
        ) -> Self {
            self.throttle = input;
            self
        }
        /// <p>The quota of the usage plan.</p>
        pub fn quota(mut self, input: crate::model::QuotaSettings) -> Self {
            self.quota = Some(input);
            self
        }
        /// <p>The quota of the usage plan.</p>
        pub fn set_quota(
            mut self,
            input: std::option::Option<crate::model::QuotaSettings>,
        ) -> Self {
            self.quota = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUsagePlanInput`](crate::input::CreateUsagePlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUsagePlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUsagePlanInput {
                name: self.name,
                description: self.description,
                api_stages: self.api_stages,
                throttle: self.throttle,
                quota: self.quota,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUsagePlanInputOperationOutputAlias = crate::operation::CreateUsagePlan;
#[doc(hidden)]
pub type CreateUsagePlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUsagePlanInput {
    /// Consumes the builder and constructs an Operation<[`CreateUsagePlan`](crate::operation::CreateUsagePlan)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUsagePlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUsagePlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/usageplans").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUsagePlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUsagePlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_usage_plan(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUsagePlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUsagePlan",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUsagePlanInput`](crate::input::CreateUsagePlanInput)
    pub fn builder() -> crate::input::create_usage_plan_input::Builder {
        crate::input::create_usage_plan_input::Builder::default()
    }
}

/// See [`CreateUsagePlanKeyInput`](crate::input::CreateUsagePlanKeyInput)
pub mod create_usage_plan_key_input {
    /// A builder for [`CreateUsagePlanKeyInput`](crate::input::CreateUsagePlanKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_plan_id: std::option::Option<std::string::String>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) key_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-created <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_plan_id = Some(input.into());
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-created <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_plan_id = input;
            self
        }
        /// <p>[Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>[Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.</p>
        pub fn key_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_type = Some(input.into());
            self
        }
        /// <p>[Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.</p>
        pub fn set_key_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUsagePlanKeyInput`](crate::input::CreateUsagePlanKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUsagePlanKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUsagePlanKeyInput {
                usage_plan_id: self.usage_plan_id,
                key_id: self.key_id,
                key_type: self.key_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUsagePlanKeyInputOperationOutputAlias = crate::operation::CreateUsagePlanKey;
#[doc(hidden)]
pub type CreateUsagePlanKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUsagePlanKeyInput {
    /// Consumes the builder and constructs an Operation<[`CreateUsagePlanKey`](crate::operation::CreateUsagePlanKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUsagePlanKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUsagePlanKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.usage_plan_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "usage_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let usage_plan_id = aws_smithy_http::label::fmt_string(input_11, false);
            if usage_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "usage_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/usageplans/{usagePlanId}/keys",
                usagePlanId = usage_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUsagePlanKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUsagePlanKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_usage_plan_key(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUsagePlanKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUsagePlanKey",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUsagePlanKeyInput`](crate::input::CreateUsagePlanKeyInput)
    pub fn builder() -> crate::input::create_usage_plan_key_input::Builder {
        crate::input::create_usage_plan_key_input::Builder::default()
    }
}

/// See [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
pub mod create_vpc_link_input {
    /// A builder for [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>[Required] The name used to label and identify the VPC link.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>[Required] The name used to label and identify the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `target_arns`.
        ///
        /// To override the contents of this collection use [`set_target_arns`](Self::set_target_arns).
        ///
        /// <p>[Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_arns.unwrap_or_default();
            v.push(input.into());
            self.target_arns = Some(v);
            self
        }
        /// <p>[Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn set_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_arns = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVpcLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVpcLinkInput {
                name: self.name,
                description: self.description,
                target_arns: self.target_arns,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVpcLinkInputOperationOutputAlias = crate::operation::CreateVpcLink;
#[doc(hidden)]
pub type CreateVpcLinkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateVpcLinkInput {
    /// Consumes the builder and constructs an Operation<[`CreateVpcLink`](crate::operation::CreateVpcLink)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVpcLink,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVpcLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/vpclinks").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVpcLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVpcLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_vpc_link(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVpcLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVpcLink",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVpcLinkInput`](crate::input::CreateVpcLinkInput)
    pub fn builder() -> crate::input::create_vpc_link_input::Builder {
        crate::input::create_vpc_link_input::Builder::default()
    }
}

/// See [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
pub mod delete_api_key_input {
    /// A builder for [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource to be deleted.</p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource to be deleted.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApiKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApiKeyInput {
                api_key: self.api_key,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApiKeyInputOperationOutputAlias = crate::operation::DeleteApiKey;
#[doc(hidden)]
pub type DeleteApiKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteApiKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApiKey`](crate::operation::DeleteApiKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApiKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApiKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.api_key;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_key",
                        details: "cannot be empty or unset",
                    })?;
            let api_key = aws_smithy_http::label::fmt_string(input_12, false);
            if api_key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "api_key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/apikeys/{apiKey}", apiKey = api_key)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApiKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApiKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApiKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApiKey",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
    pub fn builder() -> crate::input::delete_api_key_input::Builder {
        crate::input::delete_api_key_input::Builder::default()
    }
}

/// See [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
pub mod delete_authorizer_input {
    /// A builder for [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAuthorizerInput {
                rest_api_id: self.rest_api_id,
                authorizer_id: self.authorizer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAuthorizerInputOperationOutputAlias = crate::operation::DeleteAuthorizer;
#[doc(hidden)]
pub type DeleteAuthorizerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAuthorizer`](crate::operation::DeleteAuthorizer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAuthorizer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAuthorizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.rest_api_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_13, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.authorizer_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    })?;
            let authorizer_id = aws_smithy_http::label::fmt_string(input_14, false);
            if authorizer_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "authorizer_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/authorizers/{authorizerId}",
                restApiId = rest_api_id,
                authorizerId = authorizer_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAuthorizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAuthorizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAuthorizer",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
    pub fn builder() -> crate::input::delete_authorizer_input::Builder {
        crate::input::delete_authorizer_input::Builder::default()
    }
}

/// See [`DeleteBasePathMappingInput`](crate::input::DeleteBasePathMappingInput)
pub mod delete_base_path_mapping_input {
    /// A builder for [`DeleteBasePathMappingInput`](crate::input::DeleteBasePathMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) base_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to delete.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>[Required] The base path name of the <a>BasePathMapping</a> resource to delete.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_path = Some(input.into());
            self
        }
        /// <p>[Required] The base path name of the <a>BasePathMapping</a> resource to delete.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.base_path = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBasePathMappingInput`](crate::input::DeleteBasePathMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBasePathMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBasePathMappingInput {
                domain_name: self.domain_name,
                base_path: self.base_path,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBasePathMappingInputOperationOutputAlias = crate::operation::DeleteBasePathMapping;
#[doc(hidden)]
pub type DeleteBasePathMappingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBasePathMappingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBasePathMapping`](crate::operation::DeleteBasePathMapping)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBasePathMapping,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBasePathMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.domain_name;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    })?;
            let domain_name = aws_smithy_http::label::fmt_string(input_15, false);
            if domain_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "domain_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.base_path;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "base_path",
                        details: "cannot be empty or unset",
                    })?;
            let base_path = aws_smithy_http::label::fmt_string(input_16, false);
            if base_path.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "base_path",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/domainnames/{domainName}/basepathmappings/{basePath}",
                domainName = domain_name,
                basePath = base_path
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBasePathMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBasePathMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBasePathMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBasePathMapping",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBasePathMappingInput`](crate::input::DeleteBasePathMappingInput)
    pub fn builder() -> crate::input::delete_base_path_mapping_input::Builder {
        crate::input::delete_base_path_mapping_input::Builder::default()
    }
}

/// See [`DeleteClientCertificateInput`](crate::input::DeleteClientCertificateInput)
pub mod delete_client_certificate_input {
    /// A builder for [`DeleteClientCertificateInput`](crate::input::DeleteClientCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClientCertificateInput`](crate::input::DeleteClientCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClientCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClientCertificateInput {
                client_certificate_id: self.client_certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClientCertificateInputOperationOutputAlias =
    crate::operation::DeleteClientCertificate;
#[doc(hidden)]
pub type DeleteClientCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteClientCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteClientCertificate`](crate::operation::DeleteClientCertificate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteClientCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteClientCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.client_certificate_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "client_certificate_id",
                        details: "cannot be empty or unset",
                    })?;
            let client_certificate_id = aws_smithy_http::label::fmt_string(input_17, false);
            if client_certificate_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "client_certificate_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/clientcertificates/{clientCertificateId}",
                clientCertificateId = client_certificate_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteClientCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteClientCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteClientCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteClientCertificate",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteClientCertificateInput`](crate::input::DeleteClientCertificateInput)
    pub fn builder() -> crate::input::delete_client_certificate_input::Builder {
        crate::input::delete_client_certificate_input::Builder::default()
    }
}

/// See [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
pub mod delete_deployment_input {
    /// A builder for [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource to delete.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource to delete.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeploymentInput {
                rest_api_id: self.rest_api_id,
                deployment_id: self.deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeploymentInputOperationOutputAlias = crate::operation::DeleteDeployment;
#[doc(hidden)]
pub type DeleteDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeployment`](crate::operation::DeleteDeployment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.rest_api_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_18, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.deployment_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    })?;
            let deployment_id = aws_smithy_http::label::fmt_string(input_19, false);
            if deployment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/deployments/{deploymentId}",
                restApiId = rest_api_id,
                deploymentId = deployment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeployment",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentInput`](crate::input::DeleteDeploymentInput)
    pub fn builder() -> crate::input::delete_deployment_input::Builder {
        crate::input::delete_deployment_input::Builder::default()
    }
}

/// See [`DeleteDocumentationPartInput`](crate::input::DeleteDocumentationPartInput)
pub mod delete_documentation_part_input {
    /// A builder for [`DeleteDocumentationPartInput`](crate::input::DeleteDocumentationPartInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) documentation_part_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier of the to-be-deleted documentation part.</p>
        pub fn documentation_part_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.documentation_part_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the to-be-deleted documentation part.</p>
        pub fn set_documentation_part_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documentation_part_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDocumentationPartInput`](crate::input::DeleteDocumentationPartInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDocumentationPartInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDocumentationPartInput {
                rest_api_id: self.rest_api_id,
                documentation_part_id: self.documentation_part_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDocumentationPartInputOperationOutputAlias =
    crate::operation::DeleteDocumentationPart;
#[doc(hidden)]
pub type DeleteDocumentationPartInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDocumentationPartInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDocumentationPart`](crate::operation::DeleteDocumentationPart)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDocumentationPart,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDocumentationPartInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.rest_api_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_20, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.documentation_part_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "documentation_part_id",
                        details: "cannot be empty or unset",
                    })?;
            let documentation_part_id = aws_smithy_http::label::fmt_string(input_21, false);
            if documentation_part_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "documentation_part_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/documentation/parts/{documentationPartId}",
                restApiId = rest_api_id,
                documentationPartId = documentation_part_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDocumentationPartInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDocumentationPartInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDocumentationPart::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDocumentationPart",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDocumentationPartInput`](crate::input::DeleteDocumentationPartInput)
    pub fn builder() -> crate::input::delete_documentation_part_input::Builder {
        crate::input::delete_documentation_part_input::Builder::default()
    }
}

/// See [`DeleteDocumentationVersionInput`](crate::input::DeleteDocumentationVersionInput)
pub mod delete_documentation_version_input {
    /// A builder for [`DeleteDocumentationVersionInput`](crate::input::DeleteDocumentationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) documentation_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The version identifier of a to-be-deleted documentation snapshot.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.documentation_version = Some(input.into());
            self
        }
        /// <p>[Required] The version identifier of a to-be-deleted documentation snapshot.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documentation_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDocumentationVersionInput`](crate::input::DeleteDocumentationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDocumentationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDocumentationVersionInput {
                rest_api_id: self.rest_api_id,
                documentation_version: self.documentation_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDocumentationVersionInputOperationOutputAlias =
    crate::operation::DeleteDocumentationVersion;
#[doc(hidden)]
pub type DeleteDocumentationVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDocumentationVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDocumentationVersion`](crate::operation::DeleteDocumentationVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDocumentationVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDocumentationVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.rest_api_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_22, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.documentation_version;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "documentation_version",
                        details: "cannot be empty or unset",
                    })?;
            let documentation_version = aws_smithy_http::label::fmt_string(input_23, false);
            if documentation_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "documentation_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/documentation/versions/{documentationVersion}",
                restApiId = rest_api_id,
                documentationVersion = documentation_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDocumentationVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDocumentationVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDocumentationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDocumentationVersion",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDocumentationVersionInput`](crate::input::DeleteDocumentationVersionInput)
    pub fn builder() -> crate::input::delete_documentation_version_input::Builder {
        crate::input::delete_documentation_version_input::Builder::default()
    }
}

/// See [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
pub mod delete_domain_name_input {
    /// A builder for [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The name of the <a>DomainName</a> resource to be deleted.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource to be deleted.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainNameInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainNameInputOperationOutputAlias = crate::operation::DeleteDomainName;
#[doc(hidden)]
pub type DeleteDomainNameInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomainName`](crate::operation::DeleteDomainName)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomainName,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDomainNameInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.domain_name;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    })?;
            let domain_name = aws_smithy_http::label::fmt_string(input_24, false);
            if domain_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "domain_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/domainnames/{domainName}",
                domainName = domain_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDomainNameInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDomainNameInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomainName",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
    pub fn builder() -> crate::input::delete_domain_name_input::Builder {
        crate::input::delete_domain_name_input::Builder::default()
    }
}

/// See [`DeleteGatewayResponseInput`](crate::input::DeleteGatewayResponseInput)
pub mod delete_gateway_response_input {
    /// A builder for [`DeleteGatewayResponseInput`](crate::input::DeleteGatewayResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) response_type: std::option::Option<crate::model::GatewayResponseType>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.response_type = Some(input);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.response_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGatewayResponseInput`](crate::input::DeleteGatewayResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGatewayResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGatewayResponseInput {
                rest_api_id: self.rest_api_id,
                response_type: self.response_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGatewayResponseInputOperationOutputAlias = crate::operation::DeleteGatewayResponse;
#[doc(hidden)]
pub type DeleteGatewayResponseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGatewayResponseInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGatewayResponse`](crate::operation::DeleteGatewayResponse)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGatewayResponse,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGatewayResponseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.rest_api_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_25, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_26 = &_input.response_type;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "response_type",
                        details: "cannot be empty or unset",
                    })?;
            let response_type = aws_smithy_http::label::fmt_string(input_26, false);
            if response_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "response_type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/gatewayresponses/{responseType}",
                restApiId = rest_api_id,
                responseType = response_type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGatewayResponseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGatewayResponseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGatewayResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGatewayResponse",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGatewayResponseInput`](crate::input::DeleteGatewayResponseInput)
    pub fn builder() -> crate::input::delete_gateway_response_input::Builder {
        crate::input::delete_gateway_response_input::Builder::default()
    }
}

/// See [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
pub mod delete_integration_input {
    /// A builder for [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] Specifies a delete integration request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] Specifies a delete integration request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIntegrationInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIntegrationInputOperationOutputAlias = crate::operation::DeleteIntegration;
#[doc(hidden)]
pub type DeleteIntegrationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIntegration`](crate::operation::DeleteIntegration)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIntegration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIntegrationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.rest_api_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_27, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.resource_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_28, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_29 = &_input.http_method;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_29, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}/integration",
                restApiId = rest_api_id,
                resourceId = resource_id,
                httpMethod = http_method
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIntegrationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIntegrationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIntegration",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
    pub fn builder() -> crate::input::delete_integration_input::Builder {
        crate::input::delete_integration_input::Builder::default()
    }
}

/// See [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
pub mod delete_integration_response_input {
    /// A builder for [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] Specifies a delete integration response request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] Specifies a delete integration response request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>[Required] Specifies a delete integration response request's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a delete integration response request's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIntegrationResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIntegrationResponseInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
                status_code: self.status_code,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIntegrationResponseInputOperationOutputAlias =
    crate::operation::DeleteIntegrationResponse;
#[doc(hidden)]
pub type DeleteIntegrationResponseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIntegrationResponseInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIntegrationResponse`](crate::operation::DeleteIntegrationResponse)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIntegrationResponse,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIntegrationResponseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.rest_api_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_30, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.resource_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_31, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_32 = &_input.http_method;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_32, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            let input_33 = &_input.status_code;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "status_code",
                        details: "cannot be empty or unset",
                    })?;
            let status_code = aws_smithy_http::label::fmt_string(input_33, false);
            if status_code.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "status_code",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}/integration/responses/{statusCode}", restApiId = rest_api_id, resourceId = resource_id, httpMethod = http_method, statusCode = status_code).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIntegrationResponseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIntegrationResponseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIntegrationResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIntegrationResponse",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationResponseInput`](crate::input::DeleteIntegrationResponseInput)
    pub fn builder() -> crate::input::delete_integration_response_input::Builder {
        crate::input::delete_integration_response_input::Builder::default()
    }
}

/// See [`DeleteMethodInput`](crate::input::DeleteMethodInput)
pub mod delete_method_input {
    /// A builder for [`DeleteMethodInput`](crate::input::DeleteMethodInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMethodInput`](crate::input::DeleteMethodInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMethodInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMethodInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMethodInputOperationOutputAlias = crate::operation::DeleteMethod;
#[doc(hidden)]
pub type DeleteMethodInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteMethodInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMethod`](crate::operation::DeleteMethod)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMethod,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMethodInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.rest_api_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_34, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.resource_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_35, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_36 = &_input.http_method;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_36, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}",
                restApiId = rest_api_id,
                resourceId = resource_id,
                httpMethod = http_method
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMethodInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMethodInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMethod::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMethod",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMethodInput`](crate::input::DeleteMethodInput)
    pub fn builder() -> crate::input::delete_method_input::Builder {
        crate::input::delete_method_input::Builder::default()
    }
}

/// See [`DeleteMethodResponseInput`](crate::input::DeleteMethodResponseInput)
pub mod delete_method_response_input {
    /// A builder for [`DeleteMethodResponseInput`](crate::input::DeleteMethodResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>[Required] The status code identifier for the <a>MethodResponse</a> resource.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>[Required] The status code identifier for the <a>MethodResponse</a> resource.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMethodResponseInput`](crate::input::DeleteMethodResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMethodResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMethodResponseInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
                status_code: self.status_code,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMethodResponseInputOperationOutputAlias = crate::operation::DeleteMethodResponse;
#[doc(hidden)]
pub type DeleteMethodResponseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteMethodResponseInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMethodResponse`](crate::operation::DeleteMethodResponse)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMethodResponse,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMethodResponseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.rest_api_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_37, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_38 = &_input.resource_id;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_38, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_39 = &_input.http_method;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_39, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            let input_40 = &_input.status_code;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "status_code",
                        details: "cannot be empty or unset",
                    })?;
            let status_code = aws_smithy_http::label::fmt_string(input_40, false);
            if status_code.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "status_code",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}/responses/{statusCode}", restApiId = rest_api_id, resourceId = resource_id, httpMethod = http_method, statusCode = status_code).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMethodResponseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMethodResponseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMethodResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMethodResponse",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMethodResponseInput`](crate::input::DeleteMethodResponseInput)
    pub fn builder() -> crate::input::delete_method_response_input::Builder {
        crate::input::delete_method_response_input::Builder::default()
    }
}

/// See [`DeleteModelInput`](crate::input::DeleteModelInput)
pub mod delete_model_input {
    /// A builder for [`DeleteModelInput`](crate::input::DeleteModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the model to delete.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the model to delete.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelInput`](crate::input::DeleteModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelInput {
                rest_api_id: self.rest_api_id,
                model_name: self.model_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelInputOperationOutputAlias = crate::operation::DeleteModel;
#[doc(hidden)]
pub type DeleteModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModel`](crate::operation::DeleteModel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_41 = &_input.rest_api_id;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_41, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_42 = &_input.model_name;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_name",
                        details: "cannot be empty or unset",
                    })?;
            let model_name = aws_smithy_http::label::fmt_string(input_42, false);
            if model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/models/{modelName}",
                restApiId = rest_api_id,
                modelName = model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModel",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
}

/// See [`DeleteRequestValidatorInput`](crate::input::DeleteRequestValidatorInput)
pub mod delete_request_validator_input {
    /// A builder for [`DeleteRequestValidatorInput`](crate::input::DeleteRequestValidatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) request_validator_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier of the <a>RequestValidator</a> to be deleted.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_validator_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>RequestValidator</a> to be deleted.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_validator_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRequestValidatorInput`](crate::input::DeleteRequestValidatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRequestValidatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRequestValidatorInput {
                rest_api_id: self.rest_api_id,
                request_validator_id: self.request_validator_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRequestValidatorInputOperationOutputAlias = crate::operation::DeleteRequestValidator;
#[doc(hidden)]
pub type DeleteRequestValidatorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRequestValidatorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRequestValidator`](crate::operation::DeleteRequestValidator)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRequestValidator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRequestValidatorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.rest_api_id;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_43, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_44 = &_input.request_validator_id;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "request_validator_id",
                        details: "cannot be empty or unset",
                    })?;
            let request_validator_id = aws_smithy_http::label::fmt_string(input_44, false);
            if request_validator_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "request_validator_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/requestvalidators/{requestValidatorId}",
                restApiId = rest_api_id,
                requestValidatorId = request_validator_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRequestValidatorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRequestValidatorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRequestValidator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRequestValidator",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRequestValidatorInput`](crate::input::DeleteRequestValidatorInput)
    pub fn builder() -> crate::input::delete_request_validator_input::Builder {
        crate::input::delete_request_validator_input::Builder::default()
    }
}

/// See [`DeleteResourceInput`](crate::input::DeleteResourceInput)
pub mod delete_resource_input {
    /// A builder for [`DeleteResourceInput`](crate::input::DeleteResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier of the <a>Resource</a> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>Resource</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourceInput`](crate::input::DeleteResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourceInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourceInputOperationOutputAlias = crate::operation::DeleteResource;
#[doc(hidden)]
pub type DeleteResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResourceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResource`](crate::operation::DeleteResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.rest_api_id;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_45, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_46 = &_input.resource_id;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_46, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{resourceId}",
                restApiId = rest_api_id,
                resourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResource",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourceInput`](crate::input::DeleteResourceInput)
    pub fn builder() -> crate::input::delete_resource_input::Builder {
        crate::input::delete_resource_input::Builder::default()
    }
}

/// See [`DeleteRestApiInput`](crate::input::DeleteRestApiInput)
pub mod delete_rest_api_input {
    /// A builder for [`DeleteRestApiInput`](crate::input::DeleteRestApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRestApiInput`](crate::input::DeleteRestApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRestApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRestApiInput {
                rest_api_id: self.rest_api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRestApiInputOperationOutputAlias = crate::operation::DeleteRestApi;
#[doc(hidden)]
pub type DeleteRestApiInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRestApiInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRestApi`](crate::operation::DeleteRestApi)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRestApi,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRestApiInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.rest_api_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_47, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/restapis/{restApiId}", restApiId = rest_api_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRestApiInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRestApiInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRestApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRestApi",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRestApiInput`](crate::input::DeleteRestApiInput)
    pub fn builder() -> crate::input::delete_rest_api_input::Builder {
        crate::input::delete_rest_api_input::Builder::default()
    }
}

/// See [`DeleteStageInput`](crate::input::DeleteStageInput)
pub mod delete_stage_input {
    /// A builder for [`DeleteStageInput`](crate::input::DeleteStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to delete.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to delete.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStageInput`](crate::input::DeleteStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStageInput {
                rest_api_id: self.rest_api_id,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStageInputOperationOutputAlias = crate::operation::DeleteStage;
#[doc(hidden)]
pub type DeleteStageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStage`](crate::operation::DeleteStage)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_48 = &_input.rest_api_id;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_48, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_49 = &_input.stage_name;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    })?;
            let stage_name = aws_smithy_http::label::fmt_string(input_49, false);
            if stage_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "stage_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/stages/{stageName}",
                restApiId = rest_api_id,
                stageName = stage_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStage",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStageInput`](crate::input::DeleteStageInput)
    pub fn builder() -> crate::input::delete_stage_input::Builder {
        crate::input::delete_stage_input::Builder::default()
    }
}

/// See [`DeleteUsagePlanInput`](crate::input::DeleteUsagePlanInput)
pub mod delete_usage_plan_input {
    /// A builder for [`DeleteUsagePlanInput`](crate::input::DeleteUsagePlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_plan_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The Id of the to-be-deleted usage plan.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_plan_id = Some(input.into());
            self
        }
        /// <p>[Required] The Id of the to-be-deleted usage plan.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_plan_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUsagePlanInput`](crate::input::DeleteUsagePlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUsagePlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUsagePlanInput {
                usage_plan_id: self.usage_plan_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUsagePlanInputOperationOutputAlias = crate::operation::DeleteUsagePlan;
#[doc(hidden)]
pub type DeleteUsagePlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUsagePlanInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUsagePlan`](crate::operation::DeleteUsagePlan)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUsagePlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUsagePlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.usage_plan_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "usage_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let usage_plan_id = aws_smithy_http::label::fmt_string(input_50, false);
            if usage_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "usage_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/usageplans/{usagePlanId}",
                usagePlanId = usage_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUsagePlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUsagePlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUsagePlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUsagePlan",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUsagePlanInput`](crate::input::DeleteUsagePlanInput)
    pub fn builder() -> crate::input::delete_usage_plan_input::Builder {
        crate::input::delete_usage_plan_input::Builder::default()
    }
}

/// See [`DeleteUsagePlanKeyInput`](crate::input::DeleteUsagePlanKeyInput)
pub mod delete_usage_plan_key_input {
    /// A builder for [`DeleteUsagePlanKeyInput`](crate::input::DeleteUsagePlanKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_plan_id: std::option::Option<std::string::String>,
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-deleted <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_plan_id = Some(input.into());
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-deleted <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_plan_id = input;
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlanKey</a> resource to be deleted.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlanKey</a> resource to be deleted.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUsagePlanKeyInput`](crate::input::DeleteUsagePlanKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUsagePlanKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUsagePlanKeyInput {
                usage_plan_id: self.usage_plan_id,
                key_id: self.key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUsagePlanKeyInputOperationOutputAlias = crate::operation::DeleteUsagePlanKey;
#[doc(hidden)]
pub type DeleteUsagePlanKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUsagePlanKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUsagePlanKey`](crate::operation::DeleteUsagePlanKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUsagePlanKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUsagePlanKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.usage_plan_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "usage_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let usage_plan_id = aws_smithy_http::label::fmt_string(input_51, false);
            if usage_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "usage_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_52 = &_input.key_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key_id",
                        details: "cannot be empty or unset",
                    })?;
            let key_id = aws_smithy_http::label::fmt_string(input_52, false);
            if key_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/usageplans/{usagePlanId}/keys/{keyId}",
                usagePlanId = usage_plan_id,
                keyId = key_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUsagePlanKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUsagePlanKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUsagePlanKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUsagePlanKey",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUsagePlanKeyInput`](crate::input::DeleteUsagePlanKeyInput)
    pub fn builder() -> crate::input::delete_usage_plan_key_input::Builder {
        crate::input::delete_usage_plan_key_input::Builder::default()
    }
}

/// See [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
pub mod delete_vpc_link_input {
    /// A builder for [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVpcLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVpcLinkInput {
                vpc_link_id: self.vpc_link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVpcLinkInputOperationOutputAlias = crate::operation::DeleteVpcLink;
#[doc(hidden)]
pub type DeleteVpcLinkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVpcLinkInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVpcLink`](crate::operation::DeleteVpcLink)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVpcLink,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVpcLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.vpc_link_id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vpc_link_id",
                        details: "cannot be empty or unset",
                    })?;
            let vpc_link_id = aws_smithy_http::label::fmt_string(input_53, false);
            if vpc_link_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vpc_link_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/vpclinks/{vpcLinkId}", vpcLinkId = vpc_link_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVpcLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVpcLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVpcLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVpcLink",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVpcLinkInput`](crate::input::DeleteVpcLinkInput)
    pub fn builder() -> crate::input::delete_vpc_link_input::Builder {
        crate::input::delete_vpc_link_input::Builder::default()
    }
}

/// See [`FlushStageAuthorizersCacheInput`](crate::input::FlushStageAuthorizersCacheInput)
pub mod flush_stage_authorizers_cache_input {
    /// A builder for [`FlushStageAuthorizersCacheInput`](crate::input::FlushStageAuthorizersCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The name of the stage to flush.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage to flush.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`FlushStageAuthorizersCacheInput`](crate::input::FlushStageAuthorizersCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::FlushStageAuthorizersCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::FlushStageAuthorizersCacheInput {
                rest_api_id: self.rest_api_id,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type FlushStageAuthorizersCacheInputOperationOutputAlias =
    crate::operation::FlushStageAuthorizersCache;
#[doc(hidden)]
pub type FlushStageAuthorizersCacheInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl FlushStageAuthorizersCacheInput {
    /// Consumes the builder and constructs an Operation<[`FlushStageAuthorizersCache`](crate::operation::FlushStageAuthorizersCache)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::FlushStageAuthorizersCache,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::FlushStageAuthorizersCacheInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.rest_api_id;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_54, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_55 = &_input.stage_name;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    })?;
            let stage_name = aws_smithy_http::label::fmt_string(input_55, false);
            if stage_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "stage_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/stages/{stageName}/cache/authorizers",
                restApiId = rest_api_id,
                stageName = stage_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::FlushStageAuthorizersCacheInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::FlushStageAuthorizersCacheInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::FlushStageAuthorizersCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "FlushStageAuthorizersCache",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`FlushStageAuthorizersCacheInput`](crate::input::FlushStageAuthorizersCacheInput)
    pub fn builder() -> crate::input::flush_stage_authorizers_cache_input::Builder {
        crate::input::flush_stage_authorizers_cache_input::Builder::default()
    }
}

/// See [`FlushStageCacheInput`](crate::input::FlushStageCacheInput)
pub mod flush_stage_cache_input {
    /// A builder for [`FlushStageCacheInput`](crate::input::FlushStageCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the stage to flush its cache.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the stage to flush its cache.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`FlushStageCacheInput`](crate::input::FlushStageCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::FlushStageCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::FlushStageCacheInput {
                rest_api_id: self.rest_api_id,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type FlushStageCacheInputOperationOutputAlias = crate::operation::FlushStageCache;
#[doc(hidden)]
pub type FlushStageCacheInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl FlushStageCacheInput {
    /// Consumes the builder and constructs an Operation<[`FlushStageCache`](crate::operation::FlushStageCache)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::FlushStageCache,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::FlushStageCacheInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_56 = &_input.rest_api_id;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_56, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_57 = &_input.stage_name;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    })?;
            let stage_name = aws_smithy_http::label::fmt_string(input_57, false);
            if stage_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "stage_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/stages/{stageName}/cache/data",
                restApiId = rest_api_id,
                stageName = stage_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::FlushStageCacheInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::FlushStageCacheInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::FlushStageCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "FlushStageCache",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`FlushStageCacheInput`](crate::input::FlushStageCacheInput)
    pub fn builder() -> crate::input::flush_stage_cache_input::Builder {
        crate::input::flush_stage_cache_input::Builder::default()
    }
}

/// See [`GenerateClientCertificateInput`](crate::input::GenerateClientCertificateInput)
pub mod generate_client_certificate_input {
    /// A builder for [`GenerateClientCertificateInput`](crate::input::GenerateClientCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The description of the <a>ClientCertificate</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the <a>ClientCertificate</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateClientCertificateInput`](crate::input::GenerateClientCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateClientCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateClientCertificateInput {
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type GenerateClientCertificateInputOperationOutputAlias =
    crate::operation::GenerateClientCertificate;
#[doc(hidden)]
pub type GenerateClientCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GenerateClientCertificateInput {
    /// Consumes the builder and constructs an Operation<[`GenerateClientCertificate`](crate::operation::GenerateClientCertificate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateClientCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GenerateClientCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/clientcertificates").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GenerateClientCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GenerateClientCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_generate_client_certificate(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateClientCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateClientCertificate",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GenerateClientCertificateInput`](crate::input::GenerateClientCertificateInput)
    pub fn builder() -> crate::input::generate_client_certificate_input::Builder {
        crate::input::generate_client_certificate_input::Builder::default()
    }
}

/// See [`GetAccountInput`](crate::input::GetAccountInput)
pub mod get_account_input {
    /// A builder for [`GetAccountInput`](crate::input::GetAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountInput`](crate::input::GetAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountInputOperationOutputAlias = crate::operation::GetAccount;
#[doc(hidden)]
pub type GetAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetAccount`](crate::operation::GetAccount)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccount",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountInput`](crate::input::GetAccountInput)
    pub fn builder() -> crate::input::get_account_input::Builder {
        crate::input::get_account_input::Builder::default()
    }
}

/// See [`GetApiKeyInput`](crate::input::GetApiKeyInput)
pub mod get_api_key_input {
    /// A builder for [`GetApiKeyInput`](crate::input::GetApiKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key: std::option::Option<std::string::String>,
        pub(crate) include_value: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource.</p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key = input;
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.</p>
        pub fn include_value(mut self, input: bool) -> Self {
            self.include_value = Some(input);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.</p>
        pub fn set_include_value(mut self, input: std::option::Option<bool>) -> Self {
            self.include_value = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiKeyInput`](crate::input::GetApiKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetApiKeyInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetApiKeyInput {
                api_key: self.api_key,
                include_value: self.include_value,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApiKeyInputOperationOutputAlias = crate::operation::GetApiKey;
#[doc(hidden)]
pub type GetApiKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetApiKeyInput {
    /// Consumes the builder and constructs an Operation<[`GetApiKey`](crate::operation::GetApiKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApiKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetApiKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_58 = &_input.api_key;
            let input_58 =
                input_58
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_key",
                        details: "cannot be empty or unset",
                    })?;
            let api_key = aws_smithy_http::label::fmt_string(input_58, false);
            if api_key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "api_key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/apikeys/{apiKey}", apiKey = api_key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetApiKeyInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_59) = &_input.include_value {
                query.push_kv(
                    "includeValue",
                    &aws_smithy_types::primitive::Encoder::from(*inner_59).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetApiKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetApiKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetApiKey::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetApiKey",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetApiKeyInput`](crate::input::GetApiKeyInput)
    pub fn builder() -> crate::input::get_api_key_input::Builder {
        crate::input::get_api_key_input::Builder::default()
    }
}

/// See [`GetApiKeysInput`](crate::input::GetApiKeysInput)
pub mod get_api_keys_input {
    /// A builder for [`GetApiKeysInput`](crate::input::GetApiKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) name_query: std::option::Option<std::string::String>,
        pub(crate) customer_id: std::option::Option<std::string::String>,
        pub(crate) include_values: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The name of queried API keys.</p>
        pub fn name_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_query = Some(input.into());
            self
        }
        /// <p>The name of queried API keys.</p>
        pub fn set_name_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_query = input;
            self
        }
        /// <p>The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.</p>
        pub fn customer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_id = Some(input.into());
            self
        }
        /// <p>The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.</p>
        pub fn set_customer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.customer_id = input;
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.</p>
        pub fn include_values(mut self, input: bool) -> Self {
            self.include_values = Some(input);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.</p>
        pub fn set_include_values(mut self, input: std::option::Option<bool>) -> Self {
            self.include_values = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiKeysInput`](crate::input::GetApiKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApiKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApiKeysInput {
                position: self.position,
                limit: self.limit,
                name_query: self.name_query,
                customer_id: self.customer_id,
                include_values: self.include_values,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApiKeysInputOperationOutputAlias = crate::operation::GetApiKeys;
#[doc(hidden)]
pub type GetApiKeysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetApiKeysInput {
    /// Consumes the builder and constructs an Operation<[`GetApiKeys`](crate::operation::GetApiKeys)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApiKeys,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetApiKeysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/apikeys").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetApiKeysInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_60) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_60));
            }
            if let Some(inner_61) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_61).encode(),
                );
            }
            if let Some(inner_62) = &_input.name_query {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_62));
            }
            if let Some(inner_63) = &_input.customer_id {
                query.push_kv("customerId", &aws_smithy_http::query::fmt_string(&inner_63));
            }
            if let Some(inner_64) = &_input.include_values {
                query.push_kv(
                    "includeValues",
                    &aws_smithy_types::primitive::Encoder::from(*inner_64).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetApiKeysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetApiKeysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApiKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApiKeys",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetApiKeysInput`](crate::input::GetApiKeysInput)
    pub fn builder() -> crate::input::get_api_keys_input::Builder {
        crate::input::get_api_keys_input::Builder::default()
    }
}

/// See [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
pub mod get_authorizer_input {
    /// A builder for [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAuthorizerInput {
                rest_api_id: self.rest_api_id,
                authorizer_id: self.authorizer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAuthorizerInputOperationOutputAlias = crate::operation::GetAuthorizer;
#[doc(hidden)]
pub type GetAuthorizerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`GetAuthorizer`](crate::operation::GetAuthorizer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAuthorizer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAuthorizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_65 = &_input.rest_api_id;
            let input_65 =
                input_65
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_65, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_66 = &_input.authorizer_id;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    })?;
            let authorizer_id = aws_smithy_http::label::fmt_string(input_66, false);
            if authorizer_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "authorizer_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/authorizers/{authorizerId}",
                restApiId = rest_api_id,
                authorizerId = authorizer_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAuthorizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAuthorizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAuthorizer",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAuthorizerInput`](crate::input::GetAuthorizerInput)
    pub fn builder() -> crate::input::get_authorizer_input::Builder {
        crate::input::get_authorizer_input::Builder::default()
    }
}

/// See [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
pub mod get_authorizers_input {
    /// A builder for [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAuthorizersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAuthorizersInput {
                rest_api_id: self.rest_api_id,
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAuthorizersInputOperationOutputAlias = crate::operation::GetAuthorizers;
#[doc(hidden)]
pub type GetAuthorizersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAuthorizersInput {
    /// Consumes the builder and constructs an Operation<[`GetAuthorizers`](crate::operation::GetAuthorizers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAuthorizers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAuthorizersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_67 = &_input.rest_api_id;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_67, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/authorizers",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetAuthorizersInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_68) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_68));
            }
            if let Some(inner_69) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_69).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAuthorizersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAuthorizersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAuthorizers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAuthorizers",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAuthorizersInput`](crate::input::GetAuthorizersInput)
    pub fn builder() -> crate::input::get_authorizers_input::Builder {
        crate::input::get_authorizers_input::Builder::default()
    }
}

/// See [`GetBasePathMappingInput`](crate::input::GetBasePathMappingInput)
pub mod get_base_path_mapping_input {
    /// A builder for [`GetBasePathMappingInput`](crate::input::GetBasePathMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) base_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to be described.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to be described.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>[Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_path = Some(input.into());
            self
        }
        /// <p>[Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.base_path = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBasePathMappingInput`](crate::input::GetBasePathMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBasePathMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBasePathMappingInput {
                domain_name: self.domain_name,
                base_path: self.base_path,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBasePathMappingInputOperationOutputAlias = crate::operation::GetBasePathMapping;
#[doc(hidden)]
pub type GetBasePathMappingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBasePathMappingInput {
    /// Consumes the builder and constructs an Operation<[`GetBasePathMapping`](crate::operation::GetBasePathMapping)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBasePathMapping,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBasePathMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_70 = &_input.domain_name;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    })?;
            let domain_name = aws_smithy_http::label::fmt_string(input_70, false);
            if domain_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "domain_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_71 = &_input.base_path;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "base_path",
                        details: "cannot be empty or unset",
                    })?;
            let base_path = aws_smithy_http::label::fmt_string(input_71, false);
            if base_path.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "base_path",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/domainnames/{domainName}/basepathmappings/{basePath}",
                domainName = domain_name,
                basePath = base_path
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBasePathMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBasePathMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBasePathMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBasePathMapping",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBasePathMappingInput`](crate::input::GetBasePathMappingInput)
    pub fn builder() -> crate::input::get_base_path_mapping_input::Builder {
        crate::input::get_base_path_mapping_input::Builder::default()
    }
}

/// See [`GetBasePathMappingsInput`](crate::input::GetBasePathMappingsInput)
pub mod get_base_path_mappings_input {
    /// A builder for [`GetBasePathMappingsInput`](crate::input::GetBasePathMappingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The domain name of a <a>BasePathMapping</a> resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>[Required] The domain name of a <a>BasePathMapping</a> resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBasePathMappingsInput`](crate::input::GetBasePathMappingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBasePathMappingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBasePathMappingsInput {
                domain_name: self.domain_name,
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBasePathMappingsInputOperationOutputAlias = crate::operation::GetBasePathMappings;
#[doc(hidden)]
pub type GetBasePathMappingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBasePathMappingsInput {
    /// Consumes the builder and constructs an Operation<[`GetBasePathMappings`](crate::operation::GetBasePathMappings)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBasePathMappings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBasePathMappingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_72 = &_input.domain_name;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    })?;
            let domain_name = aws_smithy_http::label::fmt_string(input_72, false);
            if domain_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "domain_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/domainnames/{domainName}/basepathmappings",
                domainName = domain_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetBasePathMappingsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_73) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_73));
            }
            if let Some(inner_74) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_74).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBasePathMappingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBasePathMappingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBasePathMappings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBasePathMappings",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBasePathMappingsInput`](crate::input::GetBasePathMappingsInput)
    pub fn builder() -> crate::input::get_base_path_mappings_input::Builder {
        crate::input::get_base_path_mappings_input::Builder::default()
    }
}

/// See [`GetClientCertificateInput`](crate::input::GetClientCertificateInput)
pub mod get_client_certificate_input {
    /// A builder for [`GetClientCertificateInput`](crate::input::GetClientCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be described.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be described.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetClientCertificateInput`](crate::input::GetClientCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetClientCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetClientCertificateInput {
                client_certificate_id: self.client_certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetClientCertificateInputOperationOutputAlias = crate::operation::GetClientCertificate;
#[doc(hidden)]
pub type GetClientCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetClientCertificateInput {
    /// Consumes the builder and constructs an Operation<[`GetClientCertificate`](crate::operation::GetClientCertificate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetClientCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetClientCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_75 = &_input.client_certificate_id;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "client_certificate_id",
                        details: "cannot be empty or unset",
                    })?;
            let client_certificate_id = aws_smithy_http::label::fmt_string(input_75, false);
            if client_certificate_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "client_certificate_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/clientcertificates/{clientCertificateId}",
                clientCertificateId = client_certificate_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetClientCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetClientCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetClientCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetClientCertificate",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetClientCertificateInput`](crate::input::GetClientCertificateInput)
    pub fn builder() -> crate::input::get_client_certificate_input::Builder {
        crate::input::get_client_certificate_input::Builder::default()
    }
}

/// See [`GetClientCertificatesInput`](crate::input::GetClientCertificatesInput)
pub mod get_client_certificates_input {
    /// A builder for [`GetClientCertificatesInput`](crate::input::GetClientCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetClientCertificatesInput`](crate::input::GetClientCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetClientCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetClientCertificatesInput {
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetClientCertificatesInputOperationOutputAlias = crate::operation::GetClientCertificates;
#[doc(hidden)]
pub type GetClientCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetClientCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`GetClientCertificates`](crate::operation::GetClientCertificates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetClientCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetClientCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/clientcertificates").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetClientCertificatesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_76) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_76));
            }
            if let Some(inner_77) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_77).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetClientCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetClientCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetClientCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetClientCertificates",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetClientCertificatesInput`](crate::input::GetClientCertificatesInput)
    pub fn builder() -> crate::input::get_client_certificates_input::Builder {
        crate::input::get_client_certificates_input::Builder::default()
    }
}

/// See [`GetDeploymentInput`](crate::input::GetDeploymentInput)
pub mod get_deployment_input {
    /// A builder for [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) embed: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource to get information about.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource to get information about.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Appends an item to `embed`.
        ///
        /// To override the contents of this collection use [`set_embed`](Self::set_embed).
        ///
        /// <p>A query parameter to retrieve the specified embedded resources of the returned <a>Deployment</a> resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in  <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string.  For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.</p>
        pub fn embed(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.embed.unwrap_or_default();
            v.push(input.into());
            self.embed = Some(v);
            self
        }
        /// <p>A query parameter to retrieve the specified embedded resources of the returned <a>Deployment</a> resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in  <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string.  For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.</p>
        pub fn set_embed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.embed = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentInput`](crate::input::GetDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentInput {
                rest_api_id: self.rest_api_id,
                deployment_id: self.deployment_id,
                embed: self.embed,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentInputOperationOutputAlias = crate::operation::GetDeployment;
#[doc(hidden)]
pub type GetDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`GetDeployment`](crate::operation::GetDeployment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_78 = &_input.rest_api_id;
            let input_78 =
                input_78
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_78, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_79 = &_input.deployment_id;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    })?;
            let deployment_id = aws_smithy_http::label::fmt_string(input_79, false);
            if deployment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/deployments/{deploymentId}",
                restApiId = rest_api_id,
                deploymentId = deployment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetDeploymentInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_80) = &_input.embed {
                for inner_81 in inner_80 {
                    query.push_kv("embed", &aws_smithy_http::query::fmt_string(&inner_81));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeployment",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    pub fn builder() -> crate::input::get_deployment_input::Builder {
        crate::input::get_deployment_input::Builder::default()
    }
}

/// See [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
pub mod get_deployments_input {
    /// A builder for [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentsInput {
                rest_api_id: self.rest_api_id,
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentsInputOperationOutputAlias = crate::operation::GetDeployments;
#[doc(hidden)]
pub type GetDeploymentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`GetDeployments`](crate::operation::GetDeployments)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeployments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_82 = &_input.rest_api_id;
            let input_82 =
                input_82
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_82, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/deployments",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetDeploymentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_83) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_83));
            }
            if let Some(inner_84) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_84).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeployments",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentsInput`](crate::input::GetDeploymentsInput)
    pub fn builder() -> crate::input::get_deployments_input::Builder {
        crate::input::get_deployments_input::Builder::default()
    }
}

/// See [`GetDocumentationPartInput`](crate::input::GetDocumentationPartInput)
pub mod get_documentation_part_input {
    /// A builder for [`GetDocumentationPartInput`](crate::input::GetDocumentationPartInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) documentation_part_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn documentation_part_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.documentation_part_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_documentation_part_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documentation_part_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentationPartInput`](crate::input::GetDocumentationPartInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentationPartInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentationPartInput {
                rest_api_id: self.rest_api_id,
                documentation_part_id: self.documentation_part_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentationPartInputOperationOutputAlias = crate::operation::GetDocumentationPart;
#[doc(hidden)]
pub type GetDocumentationPartInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentationPartInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentationPart`](crate::operation::GetDocumentationPart)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentationPart,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentationPartInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_85 = &_input.rest_api_id;
            let input_85 =
                input_85
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_85, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_86 = &_input.documentation_part_id;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "documentation_part_id",
                        details: "cannot be empty or unset",
                    })?;
            let documentation_part_id = aws_smithy_http::label::fmt_string(input_86, false);
            if documentation_part_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "documentation_part_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/documentation/parts/{documentationPartId}",
                restApiId = rest_api_id,
                documentationPartId = documentation_part_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentationPartInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentationPartInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentationPart::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentationPart",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentationPartInput`](crate::input::GetDocumentationPartInput)
    pub fn builder() -> crate::input::get_documentation_part_input::Builder {
        crate::input::get_documentation_part_input::Builder::default()
    }
}

/// See [`GetDocumentationPartsInput`](crate::input::GetDocumentationPartsInput)
pub mod get_documentation_parts_input {
    /// A builder for [`GetDocumentationPartsInput`](crate::input::GetDocumentationPartsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DocumentationPartType>,
        pub(crate) name_query: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) location_status: std::option::Option<crate::model::LocationStatusType>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The type of API entities of the to-be-retrieved documentation parts. </p>
        pub fn r#type(mut self, input: crate::model::DocumentationPartType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of API entities of the to-be-retrieved documentation parts. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DocumentationPartType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of API entities of the to-be-retrieved documentation parts.</p>
        pub fn name_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_query = Some(input.into());
            self
        }
        /// <p>The name of API entities of the to-be-retrieved documentation parts.</p>
        pub fn set_name_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_query = input;
            self
        }
        /// <p>The path of API entities of the to-be-retrieved documentation parts.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path of API entities of the to-be-retrieved documentation parts.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving <a>DocumentationPart</a> resources with content and <code>UNDOCUMENTED</code> for <a>DocumentationPart</a> resources without content.</p>
        pub fn location_status(mut self, input: crate::model::LocationStatusType) -> Self {
            self.location_status = Some(input);
            self
        }
        /// <p>The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving <a>DocumentationPart</a> resources with content and <code>UNDOCUMENTED</code> for <a>DocumentationPart</a> resources without content.</p>
        pub fn set_location_status(
            mut self,
            input: std::option::Option<crate::model::LocationStatusType>,
        ) -> Self {
            self.location_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentationPartsInput`](crate::input::GetDocumentationPartsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentationPartsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentationPartsInput {
                rest_api_id: self.rest_api_id,
                r#type: self.r#type,
                name_query: self.name_query,
                path: self.path,
                position: self.position,
                limit: self.limit,
                location_status: self.location_status,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentationPartsInputOperationOutputAlias = crate::operation::GetDocumentationParts;
#[doc(hidden)]
pub type GetDocumentationPartsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentationPartsInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentationParts`](crate::operation::GetDocumentationParts)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentationParts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentationPartsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_87 = &_input.rest_api_id;
            let input_87 =
                input_87
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_87, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/documentation/parts",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetDocumentationPartsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_88) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_88));
            }
            if let Some(inner_89) = &_input.name_query {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_89));
            }
            if let Some(inner_90) = &_input.path {
                query.push_kv("path", &aws_smithy_http::query::fmt_string(&inner_90));
            }
            if let Some(inner_91) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_91));
            }
            if let Some(inner_92) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_92).encode(),
                );
            }
            if let Some(inner_93) = &_input.location_status {
                query.push_kv(
                    "locationStatus",
                    &aws_smithy_http::query::fmt_string(&inner_93),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentationPartsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentationPartsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentationParts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentationParts",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentationPartsInput`](crate::input::GetDocumentationPartsInput)
    pub fn builder() -> crate::input::get_documentation_parts_input::Builder {
        crate::input::get_documentation_parts_input::Builder::default()
    }
}

/// See [`GetDocumentationVersionInput`](crate::input::GetDocumentationVersionInput)
pub mod get_documentation_version_input {
    /// A builder for [`GetDocumentationVersionInput`](crate::input::GetDocumentationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) documentation_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The version identifier of the to-be-retrieved documentation snapshot.</p>
        pub fn documentation_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.documentation_version = Some(input.into());
            self
        }
        /// <p>[Required] The version identifier of the to-be-retrieved documentation snapshot.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documentation_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentationVersionInput`](crate::input::GetDocumentationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentationVersionInput {
                rest_api_id: self.rest_api_id,
                documentation_version: self.documentation_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentationVersionInputOperationOutputAlias =
    crate::operation::GetDocumentationVersion;
#[doc(hidden)]
pub type GetDocumentationVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentationVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentationVersion`](crate::operation::GetDocumentationVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentationVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentationVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_94 = &_input.rest_api_id;
            let input_94 =
                input_94
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_94, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_95 = &_input.documentation_version;
            let input_95 =
                input_95
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "documentation_version",
                        details: "cannot be empty or unset",
                    })?;
            let documentation_version = aws_smithy_http::label::fmt_string(input_95, false);
            if documentation_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "documentation_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/documentation/versions/{documentationVersion}",
                restApiId = rest_api_id,
                documentationVersion = documentation_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentationVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentationVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentationVersion",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentationVersionInput`](crate::input::GetDocumentationVersionInput)
    pub fn builder() -> crate::input::get_documentation_version_input::Builder {
        crate::input::get_documentation_version_input::Builder::default()
    }
}

/// See [`GetDocumentationVersionsInput`](crate::input::GetDocumentationVersionsInput)
pub mod get_documentation_versions_input {
    /// A builder for [`GetDocumentationVersionsInput`](crate::input::GetDocumentationVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentationVersionsInput`](crate::input::GetDocumentationVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentationVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentationVersionsInput {
                rest_api_id: self.rest_api_id,
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentationVersionsInputOperationOutputAlias =
    crate::operation::GetDocumentationVersions;
#[doc(hidden)]
pub type GetDocumentationVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentationVersionsInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentationVersions`](crate::operation::GetDocumentationVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentationVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentationVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_96 = &_input.rest_api_id;
            let input_96 =
                input_96
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_96, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/documentation/versions",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetDocumentationVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_97) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_97));
            }
            if let Some(inner_98) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_98).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentationVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentationVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentationVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentationVersions",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentationVersionsInput`](crate::input::GetDocumentationVersionsInput)
    pub fn builder() -> crate::input::get_documentation_versions_input::Builder {
        crate::input::get_documentation_versions_input::Builder::default()
    }
}

/// See [`GetDomainNameInput`](crate::input::GetDomainNameInput)
pub mod get_domain_name_input {
    /// A builder for [`GetDomainNameInput`](crate::input::GetDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The name of the <a>DomainName</a> resource.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainNameInput`](crate::input::GetDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainNameInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainNameInputOperationOutputAlias = crate::operation::GetDomainName;
#[doc(hidden)]
pub type GetDomainNameInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainName`](crate::operation::GetDomainName)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainName,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDomainNameInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_99 = &_input.domain_name;
            let input_99 =
                input_99
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    })?;
            let domain_name = aws_smithy_http::label::fmt_string(input_99, false);
            if domain_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "domain_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/domainnames/{domainName}",
                domainName = domain_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDomainNameInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDomainNameInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainName",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDomainNameInput`](crate::input::GetDomainNameInput)
    pub fn builder() -> crate::input::get_domain_name_input::Builder {
        crate::input::get_domain_name_input::Builder::default()
    }
}

/// See [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
pub mod get_domain_names_input {
    /// A builder for [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainNamesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainNamesInput {
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainNamesInputOperationOutputAlias = crate::operation::GetDomainNames;
#[doc(hidden)]
pub type GetDomainNamesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDomainNamesInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainNames`](crate::operation::GetDomainNames)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainNames,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDomainNamesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/domainnames").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetDomainNamesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_100) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_100));
            }
            if let Some(inner_101) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_101).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDomainNamesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDomainNamesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainNames::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainNames",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDomainNamesInput`](crate::input::GetDomainNamesInput)
    pub fn builder() -> crate::input::get_domain_names_input::Builder {
        crate::input::get_domain_names_input::Builder::default()
    }
}

/// See [`GetExportInput`](crate::input::GetExportInput)
pub mod get_export_input {
    /// A builder for [`GetExportInput`](crate::input::GetExportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) export_type: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) accepts: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> that will be exported.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> that will be exported.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>[Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.</p>
        pub fn export_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_type = Some(input.into());
            self
        }
        /// <p>[Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.</p>
        pub fn set_export_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_type = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API with  x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API with  x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.</p>
        pub fn accepts(mut self, input: impl Into<std::string::String>) -> Self {
            self.accepts = Some(input.into());
            self
        }
        /// <p>The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.</p>
        pub fn set_accepts(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accepts = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExportInput`](crate::input::GetExportInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetExportInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetExportInput {
                rest_api_id: self.rest_api_id,
                stage_name: self.stage_name,
                export_type: self.export_type,
                parameters: self.parameters,
                accepts: self.accepts,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExportInputOperationOutputAlias = crate::operation::GetExport;
#[doc(hidden)]
pub type GetExportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetExportInput {
    /// Consumes the builder and constructs an Operation<[`GetExport`](crate::operation::GetExport)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetExportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_102 = &_input.rest_api_id;
            let input_102 =
                input_102
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_102, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_103 = &_input.stage_name;
            let input_103 =
                input_103
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    })?;
            let stage_name = aws_smithy_http::label::fmt_string(input_103, false);
            if stage_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "stage_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_104 = &_input.export_type;
            let input_104 =
                input_104
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "export_type",
                        details: "cannot be empty or unset",
                    })?;
            let export_type = aws_smithy_http::label::fmt_string(input_104, false);
            if export_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "export_type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/stages/{stageName}/exports/{exportType}",
                restApiId = rest_api_id,
                stageName = stage_name,
                exportType = export_type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetExportInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_105) = &_input.accepts {
                let formatted_106 = AsRef::<str>::as_ref(inner_105);
                if !formatted_106.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_106;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "accepts",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Accept", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetExportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetExportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetExport::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetExport",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetExportInput`](crate::input::GetExportInput)
    pub fn builder() -> crate::input::get_export_input::Builder {
        crate::input::get_export_input::Builder::default()
    }
}

/// See [`GetGatewayResponseInput`](crate::input::GetGatewayResponseInput)
pub mod get_gateway_response_input {
    /// A builder for [`GetGatewayResponseInput`](crate::input::GetGatewayResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) response_type: std::option::Option<crate::model::GatewayResponseType>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.response_type = Some(input);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.response_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGatewayResponseInput`](crate::input::GetGatewayResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGatewayResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGatewayResponseInput {
                rest_api_id: self.rest_api_id,
                response_type: self.response_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGatewayResponseInputOperationOutputAlias = crate::operation::GetGatewayResponse;
#[doc(hidden)]
pub type GetGatewayResponseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGatewayResponseInput {
    /// Consumes the builder and constructs an Operation<[`GetGatewayResponse`](crate::operation::GetGatewayResponse)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGatewayResponse,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGatewayResponseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_107 = &_input.rest_api_id;
            let input_107 =
                input_107
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_107, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_108 = &_input.response_type;
            let input_108 =
                input_108
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "response_type",
                        details: "cannot be empty or unset",
                    })?;
            let response_type = aws_smithy_http::label::fmt_string(input_108, false);
            if response_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "response_type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/gatewayresponses/{responseType}",
                restApiId = rest_api_id,
                responseType = response_type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGatewayResponseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGatewayResponseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGatewayResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGatewayResponse",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGatewayResponseInput`](crate::input::GetGatewayResponseInput)
    pub fn builder() -> crate::input::get_gateway_response_input::Builder {
        crate::input::get_gateway_response_input::Builder::default()
    }
}

/// See [`GetGatewayResponsesInput`](crate::input::GetGatewayResponsesInput)
pub mod get_gateway_responses_input {
    /// A builder for [`GetGatewayResponsesInput`](crate::input::GetGatewayResponsesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The <a>GatewayResponses</a> collection does not support pagination and the limit does not apply here.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The <a>GatewayResponses</a> collection does not support pagination and the limit does not apply here.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGatewayResponsesInput`](crate::input::GetGatewayResponsesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGatewayResponsesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGatewayResponsesInput {
                rest_api_id: self.rest_api_id,
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGatewayResponsesInputOperationOutputAlias = crate::operation::GetGatewayResponses;
#[doc(hidden)]
pub type GetGatewayResponsesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGatewayResponsesInput {
    /// Consumes the builder and constructs an Operation<[`GetGatewayResponses`](crate::operation::GetGatewayResponses)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGatewayResponses,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGatewayResponsesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_109 = &_input.rest_api_id;
            let input_109 =
                input_109
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_109, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/gatewayresponses",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetGatewayResponsesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_110) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_110));
            }
            if let Some(inner_111) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_111).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGatewayResponsesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGatewayResponsesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGatewayResponses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGatewayResponses",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGatewayResponsesInput`](crate::input::GetGatewayResponsesInput)
    pub fn builder() -> crate::input::get_gateway_responses_input::Builder {
        crate::input::get_gateway_responses_input::Builder::default()
    }
}

/// See [`GetIntegrationInput`](crate::input::GetIntegrationInput)
pub mod get_integration_input {
    /// A builder for [`GetIntegrationInput`](crate::input::GetIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] Specifies a get integration request's resource identifier</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration request's resource identifier</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] Specifies a get integration request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationInput`](crate::input::GetIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntegrationInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntegrationInputOperationOutputAlias = crate::operation::GetIntegration;
#[doc(hidden)]
pub type GetIntegrationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`GetIntegration`](crate::operation::GetIntegration)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntegration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIntegrationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_112 = &_input.rest_api_id;
            let input_112 =
                input_112
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_112, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_113 = &_input.resource_id;
            let input_113 =
                input_113
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_113, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_114 = &_input.http_method;
            let input_114 =
                input_114
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_114, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}/integration",
                restApiId = rest_api_id,
                resourceId = resource_id,
                httpMethod = http_method
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIntegrationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIntegrationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntegration",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIntegrationInput`](crate::input::GetIntegrationInput)
    pub fn builder() -> crate::input::get_integration_input::Builder {
        crate::input::get_integration_input::Builder::default()
    }
}

/// See [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
pub mod get_integration_response_input {
    /// A builder for [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] Specifies a get integration response request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] Specifies a get integration response request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>[Required] Specifies a get integration response request's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a get integration response request's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntegrationResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntegrationResponseInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
                status_code: self.status_code,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntegrationResponseInputOperationOutputAlias = crate::operation::GetIntegrationResponse;
#[doc(hidden)]
pub type GetIntegrationResponseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIntegrationResponseInput {
    /// Consumes the builder and constructs an Operation<[`GetIntegrationResponse`](crate::operation::GetIntegrationResponse)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntegrationResponse,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIntegrationResponseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_115 = &_input.rest_api_id;
            let input_115 =
                input_115
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_115, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_116 = &_input.resource_id;
            let input_116 =
                input_116
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_116, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_117 = &_input.http_method;
            let input_117 =
                input_117
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_117, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            let input_118 = &_input.status_code;
            let input_118 =
                input_118
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "status_code",
                        details: "cannot be empty or unset",
                    })?;
            let status_code = aws_smithy_http::label::fmt_string(input_118, false);
            if status_code.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "status_code",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}/integration/responses/{statusCode}", restApiId = rest_api_id, resourceId = resource_id, httpMethod = http_method, statusCode = status_code).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIntegrationResponseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIntegrationResponseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntegrationResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntegrationResponse",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIntegrationResponseInput`](crate::input::GetIntegrationResponseInput)
    pub fn builder() -> crate::input::get_integration_response_input::Builder {
        crate::input::get_integration_response_input::Builder::default()
    }
}

/// See [`GetMethodInput`](crate::input::GetMethodInput)
pub mod get_method_input {
    /// A builder for [`GetMethodInput`](crate::input::GetMethodInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMethodInput`](crate::input::GetMethodInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetMethodInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetMethodInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMethodInputOperationOutputAlias = crate::operation::GetMethod;
#[doc(hidden)]
pub type GetMethodInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMethodInput {
    /// Consumes the builder and constructs an Operation<[`GetMethod`](crate::operation::GetMethod)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMethod,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMethodInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_119 = &_input.rest_api_id;
            let input_119 =
                input_119
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_119, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_120 = &_input.resource_id;
            let input_120 =
                input_120
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_120, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_121 = &_input.http_method;
            let input_121 =
                input_121
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_121, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}",
                restApiId = rest_api_id,
                resourceId = resource_id,
                httpMethod = http_method
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMethodInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMethodInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetMethod::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetMethod",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMethodInput`](crate::input::GetMethodInput)
    pub fn builder() -> crate::input::get_method_input::Builder {
        crate::input::get_method_input::Builder::default()
    }
}

/// See [`GetMethodResponseInput`](crate::input::GetMethodResponseInput)
pub mod get_method_response_input {
    /// A builder for [`GetMethodResponseInput`](crate::input::GetMethodResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>[Required] The status code for the <a>MethodResponse</a> resource.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>[Required] The status code for the <a>MethodResponse</a> resource.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMethodResponseInput`](crate::input::GetMethodResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMethodResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMethodResponseInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
                status_code: self.status_code,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMethodResponseInputOperationOutputAlias = crate::operation::GetMethodResponse;
#[doc(hidden)]
pub type GetMethodResponseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMethodResponseInput {
    /// Consumes the builder and constructs an Operation<[`GetMethodResponse`](crate::operation::GetMethodResponse)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMethodResponse,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMethodResponseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_122 = &_input.rest_api_id;
            let input_122 =
                input_122
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_122, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_123 = &_input.resource_id;
            let input_123 =
                input_123
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_123, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_124 = &_input.http_method;
            let input_124 =
                input_124
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_124, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            let input_125 = &_input.status_code;
            let input_125 =
                input_125
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "status_code",
                        details: "cannot be empty or unset",
                    })?;
            let status_code = aws_smithy_http::label::fmt_string(input_125, false);
            if status_code.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "status_code",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}/responses/{statusCode}", restApiId = rest_api_id, resourceId = resource_id, httpMethod = http_method, statusCode = status_code).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMethodResponseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMethodResponseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMethodResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMethodResponse",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMethodResponseInput`](crate::input::GetMethodResponseInput)
    pub fn builder() -> crate::input::get_method_response_input::Builder {
        crate::input::get_method_response_input::Builder::default()
    }
}

/// See [`GetModelInput`](crate::input::GetModelInput)
pub mod get_model_input {
    /// A builder for [`GetModelInput`](crate::input::GetModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) model_name: std::option::Option<std::string::String>,
        pub(crate) flatten: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> exists.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> exists.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the model as an identifier.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the model as an identifier.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// <p>A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.</p>
        pub fn flatten(mut self, input: bool) -> Self {
            self.flatten = Some(input);
            self
        }
        /// <p>A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.</p>
        pub fn set_flatten(mut self, input: std::option::Option<bool>) -> Self {
            self.flatten = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelInput`](crate::input::GetModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetModelInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetModelInput {
                rest_api_id: self.rest_api_id,
                model_name: self.model_name,
                flatten: self.flatten.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetModelInputOperationOutputAlias = crate::operation::GetModel;
#[doc(hidden)]
pub type GetModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetModelInput {
    /// Consumes the builder and constructs an Operation<[`GetModel`](crate::operation::GetModel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_126 = &_input.rest_api_id;
            let input_126 =
                input_126
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_126, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_127 = &_input.model_name;
            let input_127 =
                input_127
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_name",
                        details: "cannot be empty or unset",
                    })?;
            let model_name = aws_smithy_http::label::fmt_string(input_127, false);
            if model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/models/{modelName}",
                restApiId = rest_api_id,
                modelName = model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetModelInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.flatten {
                query.push_kv(
                    "flatten",
                    &aws_smithy_types::primitive::Encoder::from(_input.flatten).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetModel::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetModel",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetModelInput`](crate::input::GetModelInput)
    pub fn builder() -> crate::input::get_model_input::Builder {
        crate::input::get_model_input::Builder::default()
    }
}

/// See [`GetModelsInput`](crate::input::GetModelsInput)
pub mod get_models_input {
    /// A builder for [`GetModelsInput`](crate::input::GetModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelsInput`](crate::input::GetModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetModelsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetModelsInput {
                rest_api_id: self.rest_api_id,
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetModelsInputOperationOutputAlias = crate::operation::GetModels;
#[doc(hidden)]
pub type GetModelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetModelsInput {
    /// Consumes the builder and constructs an Operation<[`GetModels`](crate::operation::GetModels)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetModels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetModelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_128 = &_input.rest_api_id;
            let input_128 =
                input_128
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_128, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/models",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetModelsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_129) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_129));
            }
            if let Some(inner_130) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_130).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetModelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetModelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetModels::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetModels",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetModelsInput`](crate::input::GetModelsInput)
    pub fn builder() -> crate::input::get_models_input::Builder {
        crate::input::get_models_input::Builder::default()
    }
}

/// See [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
pub mod get_model_template_input {
    /// A builder for [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the model for which to generate a template.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the model for which to generate a template.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetModelTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetModelTemplateInput {
                rest_api_id: self.rest_api_id,
                model_name: self.model_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetModelTemplateInputOperationOutputAlias = crate::operation::GetModelTemplate;
#[doc(hidden)]
pub type GetModelTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetModelTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetModelTemplate`](crate::operation::GetModelTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetModelTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetModelTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_131 = &_input.rest_api_id;
            let input_131 =
                input_131
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_131, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_132 = &_input.model_name;
            let input_132 =
                input_132
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_name",
                        details: "cannot be empty or unset",
                    })?;
            let model_name = aws_smithy_http::label::fmt_string(input_132, false);
            if model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/models/{modelName}/default_template",
                restApiId = rest_api_id,
                modelName = model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetModelTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetModelTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetModelTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetModelTemplate",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetModelTemplateInput`](crate::input::GetModelTemplateInput)
    pub fn builder() -> crate::input::get_model_template_input::Builder {
        crate::input::get_model_template_input::Builder::default()
    }
}

/// See [`GetRequestValidatorInput`](crate::input::GetRequestValidatorInput)
pub mod get_request_validator_input {
    /// A builder for [`GetRequestValidatorInput`](crate::input::GetRequestValidatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) request_validator_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier of the <a>RequestValidator</a> to be retrieved.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_validator_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>RequestValidator</a> to be retrieved.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_validator_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRequestValidatorInput`](crate::input::GetRequestValidatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRequestValidatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRequestValidatorInput {
                rest_api_id: self.rest_api_id,
                request_validator_id: self.request_validator_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRequestValidatorInputOperationOutputAlias = crate::operation::GetRequestValidator;
#[doc(hidden)]
pub type GetRequestValidatorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRequestValidatorInput {
    /// Consumes the builder and constructs an Operation<[`GetRequestValidator`](crate::operation::GetRequestValidator)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRequestValidator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRequestValidatorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_133 = &_input.rest_api_id;
            let input_133 =
                input_133
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_133, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_134 = &_input.request_validator_id;
            let input_134 =
                input_134
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "request_validator_id",
                        details: "cannot be empty or unset",
                    })?;
            let request_validator_id = aws_smithy_http::label::fmt_string(input_134, false);
            if request_validator_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "request_validator_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/requestvalidators/{requestValidatorId}",
                restApiId = rest_api_id,
                requestValidatorId = request_validator_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRequestValidatorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRequestValidatorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRequestValidator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRequestValidator",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRequestValidatorInput`](crate::input::GetRequestValidatorInput)
    pub fn builder() -> crate::input::get_request_validator_input::Builder {
        crate::input::get_request_validator_input::Builder::default()
    }
}

/// See [`GetRequestValidatorsInput`](crate::input::GetRequestValidatorsInput)
pub mod get_request_validators_input {
    /// A builder for [`GetRequestValidatorsInput`](crate::input::GetRequestValidatorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRequestValidatorsInput`](crate::input::GetRequestValidatorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRequestValidatorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRequestValidatorsInput {
                rest_api_id: self.rest_api_id,
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRequestValidatorsInputOperationOutputAlias = crate::operation::GetRequestValidators;
#[doc(hidden)]
pub type GetRequestValidatorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRequestValidatorsInput {
    /// Consumes the builder and constructs an Operation<[`GetRequestValidators`](crate::operation::GetRequestValidators)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRequestValidators,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRequestValidatorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_135 = &_input.rest_api_id;
            let input_135 =
                input_135
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_135, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/requestvalidators",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetRequestValidatorsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_136) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_136));
            }
            if let Some(inner_137) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_137).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRequestValidatorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRequestValidatorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRequestValidators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRequestValidators",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRequestValidatorsInput`](crate::input::GetRequestValidatorsInput)
    pub fn builder() -> crate::input::get_request_validators_input::Builder {
        crate::input::get_request_validators_input::Builder::default()
    }
}

/// See [`GetResourceInput`](crate::input::GetResourceInput)
pub mod get_resource_input {
    /// A builder for [`GetResourceInput`](crate::input::GetResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) embed: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier for the <a>Resource</a> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier for the <a>Resource</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `embed`.
        ///
        /// To override the contents of this collection use [`set_embed`](Self::set_embed).
        ///
        /// <p>A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a> representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.</p>
        pub fn embed(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.embed.unwrap_or_default();
            v.push(input.into());
            self.embed = Some(v);
            self
        }
        /// <p>A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a> representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.</p>
        pub fn set_embed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.embed = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceInput`](crate::input::GetResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                embed: self.embed,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceInputOperationOutputAlias = crate::operation::GetResource;
#[doc(hidden)]
pub type GetResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourceInput {
    /// Consumes the builder and constructs an Operation<[`GetResource`](crate::operation::GetResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_138 = &_input.rest_api_id;
            let input_138 =
                input_138
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_138, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_139 = &_input.resource_id;
            let input_139 =
                input_139
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_139, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{resourceId}",
                restApiId = rest_api_id,
                resourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_140) = &_input.embed {
                for inner_141 in inner_140 {
                    query.push_kv("embed", &aws_smithy_http::query::fmt_string(&inner_141));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResource",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceInput`](crate::input::GetResourceInput)
    pub fn builder() -> crate::input::get_resource_input::Builder {
        crate::input::get_resource_input::Builder::default()
    }
}

/// See [`GetResourcesInput`](crate::input::GetResourcesInput)
pub mod get_resources_input {
    /// A builder for [`GetResourcesInput`](crate::input::GetResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) embed: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Appends an item to `embed`.
        ///
        /// To override the contents of this collection use [`set_embed`](Self::set_embed).
        ///
        /// <p>A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a> resource in the response.  This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.</p>
        pub fn embed(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.embed.unwrap_or_default();
            v.push(input.into());
            self.embed = Some(v);
            self
        }
        /// <p>A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a> resource in the response.  This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.</p>
        pub fn set_embed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.embed = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcesInput`](crate::input::GetResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourcesInput {
                rest_api_id: self.rest_api_id,
                position: self.position,
                limit: self.limit,
                embed: self.embed,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourcesInputOperationOutputAlias = crate::operation::GetResources;
#[doc(hidden)]
pub type GetResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourcesInput {
    /// Consumes the builder and constructs an Operation<[`GetResources`](crate::operation::GetResources)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_142 = &_input.rest_api_id;
            let input_142 =
                input_142
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_142, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetResourcesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_143) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_143));
            }
            if let Some(inner_144) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_144).encode(),
                );
            }
            if let Some(inner_145) = &_input.embed {
                for inner_146 in inner_145 {
                    query.push_kv("embed", &aws_smithy_http::query::fmt_string(&inner_146));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResources",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourcesInput`](crate::input::GetResourcesInput)
    pub fn builder() -> crate::input::get_resources_input::Builder {
        crate::input::get_resources_input::Builder::default()
    }
}

/// See [`GetRestApiInput`](crate::input::GetRestApiInput)
pub mod get_rest_api_input {
    /// A builder for [`GetRestApiInput`](crate::input::GetRestApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRestApiInput`](crate::input::GetRestApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRestApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRestApiInput {
                rest_api_id: self.rest_api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRestApiInputOperationOutputAlias = crate::operation::GetRestApi;
#[doc(hidden)]
pub type GetRestApiInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRestApiInput {
    /// Consumes the builder and constructs an Operation<[`GetRestApi`](crate::operation::GetRestApi)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRestApi,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRestApiInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_147 = &_input.rest_api_id;
            let input_147 =
                input_147
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_147, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/restapis/{restApiId}", restApiId = rest_api_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRestApiInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRestApiInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRestApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRestApi",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRestApiInput`](crate::input::GetRestApiInput)
    pub fn builder() -> crate::input::get_rest_api_input::Builder {
        crate::input::get_rest_api_input::Builder::default()
    }
}

/// See [`GetRestApisInput`](crate::input::GetRestApisInput)
pub mod get_rest_apis_input {
    /// A builder for [`GetRestApisInput`](crate::input::GetRestApisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRestApisInput`](crate::input::GetRestApisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRestApisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRestApisInput {
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRestApisInputOperationOutputAlias = crate::operation::GetRestApis;
#[doc(hidden)]
pub type GetRestApisInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRestApisInput {
    /// Consumes the builder and constructs an Operation<[`GetRestApis`](crate::operation::GetRestApis)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRestApis,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRestApisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/restapis").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetRestApisInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_148) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_148));
            }
            if let Some(inner_149) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_149).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRestApisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRestApisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRestApis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRestApis",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRestApisInput`](crate::input::GetRestApisInput)
    pub fn builder() -> crate::input::get_rest_apis_input::Builder {
        crate::input::get_rest_apis_input::Builder::default()
    }
}

/// See [`GetSdkInput`](crate::input::GetSdkInput)
pub mod get_sdk_input {
    /// A builder for [`GetSdkInput`](crate::input::GetSdkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) sdk_type: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> that the SDK will use.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> that the SDK will use.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>[Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code>  are supported.</p>
        pub fn sdk_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.sdk_type = Some(input.into());
            self
        }
        /// <p>[Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code>  are supported.</p>
        pub fn set_sdk_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sdk_type = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>,  a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. </p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>,  a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSdkInput`](crate::input::GetSdkInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetSdkInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetSdkInput {
                rest_api_id: self.rest_api_id,
                stage_name: self.stage_name,
                sdk_type: self.sdk_type,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSdkInputOperationOutputAlias = crate::operation::GetSdk;
#[doc(hidden)]
pub type GetSdkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSdkInput {
    /// Consumes the builder and constructs an Operation<[`GetSdk`](crate::operation::GetSdk)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSdk,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSdkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_150 = &_input.rest_api_id;
            let input_150 =
                input_150
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_150, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_151 = &_input.stage_name;
            let input_151 =
                input_151
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    })?;
            let stage_name = aws_smithy_http::label::fmt_string(input_151, false);
            if stage_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "stage_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_152 = &_input.sdk_type;
            let input_152 =
                input_152
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "sdk_type",
                        details: "cannot be empty or unset",
                    })?;
            let sdk_type = aws_smithy_http::label::fmt_string(input_152, false);
            if sdk_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "sdk_type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/stages/{stageName}/sdks/{sdkType}",
                restApiId = rest_api_id,
                stageName = stage_name,
                sdkType = sdk_type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSdkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSdkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetSdk::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetSdk",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSdkInput`](crate::input::GetSdkInput)
    pub fn builder() -> crate::input::get_sdk_input::Builder {
        crate::input::get_sdk_input::Builder::default()
    }
}

/// See [`GetSdkTypeInput`](crate::input::GetSdkTypeInput)
pub mod get_sdk_type_input {
    /// A builder for [`GetSdkTypeInput`](crate::input::GetSdkTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the queried <a>SdkType</a> instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the queried <a>SdkType</a> instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSdkTypeInput`](crate::input::GetSdkTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSdkTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSdkTypeInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetSdkTypeInputOperationOutputAlias = crate::operation::GetSdkType;
#[doc(hidden)]
pub type GetSdkTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSdkTypeInput {
    /// Consumes the builder and constructs an Operation<[`GetSdkType`](crate::operation::GetSdkType)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSdkType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSdkTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_153 = &_input.id;
            let input_153 =
                input_153
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_153, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/sdktypes/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSdkTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSdkTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSdkType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSdkType",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSdkTypeInput`](crate::input::GetSdkTypeInput)
    pub fn builder() -> crate::input::get_sdk_type_input::Builder {
        crate::input::get_sdk_type_input::Builder::default()
    }
}

/// See [`GetSdkTypesInput`](crate::input::GetSdkTypesInput)
pub mod get_sdk_types_input {
    /// A builder for [`GetSdkTypesInput`](crate::input::GetSdkTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSdkTypesInput`](crate::input::GetSdkTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSdkTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSdkTypesInput {
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSdkTypesInputOperationOutputAlias = crate::operation::GetSdkTypes;
#[doc(hidden)]
pub type GetSdkTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSdkTypesInput {
    /// Consumes the builder and constructs an Operation<[`GetSdkTypes`](crate::operation::GetSdkTypes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSdkTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSdkTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/sdktypes").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetSdkTypesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_154) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_154));
            }
            if let Some(inner_155) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_155).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSdkTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSdkTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSdkTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSdkTypes",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSdkTypesInput`](crate::input::GetSdkTypesInput)
    pub fn builder() -> crate::input::get_sdk_types_input::Builder {
        crate::input::get_sdk_types_input::Builder::default()
    }
}

/// See [`GetStageInput`](crate::input::GetStageInput)
pub mod get_stage_input {
    /// A builder for [`GetStageInput`](crate::input::GetStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to get information about.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to get information about.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStageInput`](crate::input::GetStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetStageInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetStageInput {
                rest_api_id: self.rest_api_id,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStageInputOperationOutputAlias = crate::operation::GetStage;
#[doc(hidden)]
pub type GetStageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetStageInput {
    /// Consumes the builder and constructs an Operation<[`GetStage`](crate::operation::GetStage)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetStageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_156 = &_input.rest_api_id;
            let input_156 =
                input_156
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_156, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_157 = &_input.stage_name;
            let input_157 =
                input_157
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    })?;
            let stage_name = aws_smithy_http::label::fmt_string(input_157, false);
            if stage_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "stage_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/stages/{stageName}",
                restApiId = rest_api_id,
                stageName = stage_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetStageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetStageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetStage::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetStage",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetStageInput`](crate::input::GetStageInput)
    pub fn builder() -> crate::input::get_stage_input::Builder {
        crate::input::get_stage_input::Builder::default()
    }
}

/// See [`GetStagesInput`](crate::input::GetStagesInput)
pub mod get_stages_input {
    /// A builder for [`GetStagesInput`](crate::input::GetStagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The stages' deployment identifiers.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The stages' deployment identifiers.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStagesInput`](crate::input::GetStagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetStagesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetStagesInput {
                rest_api_id: self.rest_api_id,
                deployment_id: self.deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStagesInputOperationOutputAlias = crate::operation::GetStages;
#[doc(hidden)]
pub type GetStagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetStagesInput {
    /// Consumes the builder and constructs an Operation<[`GetStages`](crate::operation::GetStages)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetStagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_158 = &_input.rest_api_id;
            let input_158 =
                input_158
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_158, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/stages",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetStagesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_159) = &_input.deployment_id {
                query.push_kv(
                    "deploymentId",
                    &aws_smithy_http::query::fmt_string(&inner_159),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetStagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetStagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetStages::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetStages",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetStagesInput`](crate::input::GetStagesInput)
    pub fn builder() -> crate::input::get_stages_input::Builder {
        crate::input::get_stages_input::Builder::default()
    }
}

/// See [`GetTagsInput`](crate::input::GetTagsInput)
pub mod get_tags_input {
    /// A builder for [`GetTagsInput`](crate::input::GetTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>(Not currently supported) The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>(Not currently supported) The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>(Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>(Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTagsInput`](crate::input::GetTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTagsInput {
                resource_arn: self.resource_arn,
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTagsInputOperationOutputAlias = crate::operation::GetTags;
#[doc(hidden)]
pub type GetTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTagsInput {
    /// Consumes the builder and constructs an Operation<[`GetTags`](crate::operation::GetTags)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_160 = &_input.resource_arn;
            let input_160 =
                input_160
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_160, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetTagsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_161) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_161));
            }
            if let Some(inner_162) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_162).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetTags",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTagsInput`](crate::input::GetTagsInput)
    pub fn builder() -> crate::input::get_tags_input::Builder {
        crate::input::get_tags_input::Builder::default()
    }
}

/// See [`GetUsageInput`](crate::input::GetUsageInput)
pub mod get_usage_input {
    /// A builder for [`GetUsageInput`](crate::input::GetUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_plan_id: std::option::Option<std::string::String>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) end_date: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>[Required] The Id of the usage plan associated with the usage data.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_plan_id = Some(input.into());
            self
        }
        /// <p>[Required] The Id of the usage plan associated with the usage data.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_plan_id = input;
            self
        }
        /// <p>The Id of the API key associated with the resultant usage data.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Id of the API key associated with the resultant usage data.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>[Required] The starting date (e.g., 2016-01-01) of the usage data.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>[Required] The starting date (e.g., 2016-01-01) of the usage data.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>[Required] The ending date (e.g., 2016-12-31) of the usage data.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date = Some(input.into());
            self
        }
        /// <p>[Required] The ending date (e.g., 2016-12-31) of the usage data.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_date = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsageInput`](crate::input::GetUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetUsageInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetUsageInput {
                usage_plan_id: self.usage_plan_id,
                key_id: self.key_id,
                start_date: self.start_date,
                end_date: self.end_date,
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUsageInputOperationOutputAlias = crate::operation::GetUsage;
#[doc(hidden)]
pub type GetUsageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUsageInput {
    /// Consumes the builder and constructs an Operation<[`GetUsage`](crate::operation::GetUsage)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUsage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_163 = &_input.usage_plan_id;
            let input_163 =
                input_163
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "usage_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let usage_plan_id = aws_smithy_http::label::fmt_string(input_163, false);
            if usage_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "usage_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/usageplans/{usagePlanId}/usage",
                usagePlanId = usage_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetUsageInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_164) = &_input.key_id {
                query.push_kv("keyId", &aws_smithy_http::query::fmt_string(&inner_164));
            }
            if let Some(inner_165) = &_input.start_date {
                query.push_kv("startDate", &aws_smithy_http::query::fmt_string(&inner_165));
            }
            if let Some(inner_166) = &_input.end_date {
                query.push_kv("endDate", &aws_smithy_http::query::fmt_string(&inner_166));
            }
            if let Some(inner_167) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_167));
            }
            if let Some(inner_168) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_168).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetUsage::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetUsage",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUsageInput`](crate::input::GetUsageInput)
    pub fn builder() -> crate::input::get_usage_input::Builder {
        crate::input::get_usage_input::Builder::default()
    }
}

/// See [`GetUsagePlanInput`](crate::input::GetUsagePlanInput)
pub mod get_usage_plan_input {
    /// A builder for [`GetUsagePlanInput`](crate::input::GetUsagePlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_plan_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_plan_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_plan_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsagePlanInput`](crate::input::GetUsagePlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUsagePlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUsagePlanInput {
                usage_plan_id: self.usage_plan_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUsagePlanInputOperationOutputAlias = crate::operation::GetUsagePlan;
#[doc(hidden)]
pub type GetUsagePlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUsagePlanInput {
    /// Consumes the builder and constructs an Operation<[`GetUsagePlan`](crate::operation::GetUsagePlan)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUsagePlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUsagePlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_169 = &_input.usage_plan_id;
            let input_169 =
                input_169
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "usage_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let usage_plan_id = aws_smithy_http::label::fmt_string(input_169, false);
            if usage_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "usage_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/usageplans/{usagePlanId}",
                usagePlanId = usage_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUsagePlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUsagePlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUsagePlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUsagePlan",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUsagePlanInput`](crate::input::GetUsagePlanInput)
    pub fn builder() -> crate::input::get_usage_plan_input::Builder {
        crate::input::get_usage_plan_input::Builder::default()
    }
}

/// See [`GetUsagePlanKeyInput`](crate::input::GetUsagePlanKeyInput)
pub mod get_usage_plan_key_input {
    /// A builder for [`GetUsagePlanKeyInput`](crate::input::GetUsagePlanKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_plan_id: std::option::Option<std::string::String>,
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_plan_id = Some(input.into());
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_plan_id = input;
            self
        }
        /// <p>[Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>[Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsagePlanKeyInput`](crate::input::GetUsagePlanKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUsagePlanKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUsagePlanKeyInput {
                usage_plan_id: self.usage_plan_id,
                key_id: self.key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUsagePlanKeyInputOperationOutputAlias = crate::operation::GetUsagePlanKey;
#[doc(hidden)]
pub type GetUsagePlanKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUsagePlanKeyInput {
    /// Consumes the builder and constructs an Operation<[`GetUsagePlanKey`](crate::operation::GetUsagePlanKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUsagePlanKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUsagePlanKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_170 = &_input.usage_plan_id;
            let input_170 =
                input_170
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "usage_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let usage_plan_id = aws_smithy_http::label::fmt_string(input_170, false);
            if usage_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "usage_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_171 = &_input.key_id;
            let input_171 =
                input_171
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key_id",
                        details: "cannot be empty or unset",
                    })?;
            let key_id = aws_smithy_http::label::fmt_string(input_171, false);
            if key_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/usageplans/{usagePlanId}/keys/{keyId}",
                usagePlanId = usage_plan_id,
                keyId = key_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUsagePlanKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUsagePlanKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUsagePlanKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUsagePlanKey",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUsagePlanKeyInput`](crate::input::GetUsagePlanKeyInput)
    pub fn builder() -> crate::input::get_usage_plan_key_input::Builder {
        crate::input::get_usage_plan_key_input::Builder::default()
    }
}

/// See [`GetUsagePlanKeysInput`](crate::input::GetUsagePlanKeysInput)
pub mod get_usage_plan_keys_input {
    /// A builder for [`GetUsagePlanKeysInput`](crate::input::GetUsagePlanKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_plan_id: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) name_query: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_plan_id = Some(input.into());
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_plan_id = input;
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A query parameter specifying the name of the to-be-returned usage plan keys.</p>
        pub fn name_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_query = Some(input.into());
            self
        }
        /// <p>A query parameter specifying the name of the to-be-returned usage plan keys.</p>
        pub fn set_name_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_query = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsagePlanKeysInput`](crate::input::GetUsagePlanKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUsagePlanKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUsagePlanKeysInput {
                usage_plan_id: self.usage_plan_id,
                position: self.position,
                limit: self.limit,
                name_query: self.name_query,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUsagePlanKeysInputOperationOutputAlias = crate::operation::GetUsagePlanKeys;
#[doc(hidden)]
pub type GetUsagePlanKeysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUsagePlanKeysInput {
    /// Consumes the builder and constructs an Operation<[`GetUsagePlanKeys`](crate::operation::GetUsagePlanKeys)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUsagePlanKeys,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUsagePlanKeysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_172 = &_input.usage_plan_id;
            let input_172 =
                input_172
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "usage_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let usage_plan_id = aws_smithy_http::label::fmt_string(input_172, false);
            if usage_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "usage_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/usageplans/{usagePlanId}/keys",
                usagePlanId = usage_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetUsagePlanKeysInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_173) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_173));
            }
            if let Some(inner_174) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_174).encode(),
                );
            }
            if let Some(inner_175) = &_input.name_query {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_175));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUsagePlanKeysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUsagePlanKeysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUsagePlanKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUsagePlanKeys",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUsagePlanKeysInput`](crate::input::GetUsagePlanKeysInput)
    pub fn builder() -> crate::input::get_usage_plan_keys_input::Builder {
        crate::input::get_usage_plan_keys_input::Builder::default()
    }
}

/// See [`GetUsagePlansInput`](crate::input::GetUsagePlansInput)
pub mod get_usage_plans_input {
    /// A builder for [`GetUsagePlansInput`](crate::input::GetUsagePlansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The identifier of the API key associated with the usage plans.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The identifier of the API key associated with the usage plans.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsagePlansInput`](crate::input::GetUsagePlansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUsagePlansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUsagePlansInput {
                position: self.position,
                key_id: self.key_id,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUsagePlansInputOperationOutputAlias = crate::operation::GetUsagePlans;
#[doc(hidden)]
pub type GetUsagePlansInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUsagePlansInput {
    /// Consumes the builder and constructs an Operation<[`GetUsagePlans`](crate::operation::GetUsagePlans)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUsagePlans,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUsagePlansInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/usageplans").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetUsagePlansInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_176) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_176));
            }
            if let Some(inner_177) = &_input.key_id {
                query.push_kv("keyId", &aws_smithy_http::query::fmt_string(&inner_177));
            }
            if let Some(inner_178) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_178).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUsagePlansInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUsagePlansInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUsagePlans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUsagePlans",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUsagePlansInput`](crate::input::GetUsagePlansInput)
    pub fn builder() -> crate::input::get_usage_plans_input::Builder {
        crate::input::get_usage_plans_input::Builder::default()
    }
}

/// See [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
pub mod get_vpc_link_input {
    /// A builder for [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVpcLinkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVpcLinkInput {
                vpc_link_id: self.vpc_link_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVpcLinkInputOperationOutputAlias = crate::operation::GetVpcLink;
#[doc(hidden)]
pub type GetVpcLinkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetVpcLinkInput {
    /// Consumes the builder and constructs an Operation<[`GetVpcLink`](crate::operation::GetVpcLink)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVpcLink,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVpcLinkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_179 = &_input.vpc_link_id;
            let input_179 =
                input_179
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vpc_link_id",
                        details: "cannot be empty or unset",
                    })?;
            let vpc_link_id = aws_smithy_http::label::fmt_string(input_179, false);
            if vpc_link_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vpc_link_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/vpclinks/{vpcLinkId}", vpcLinkId = vpc_link_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVpcLinkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVpcLinkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVpcLink::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVpcLink",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVpcLinkInput`](crate::input::GetVpcLinkInput)
    pub fn builder() -> crate::input::get_vpc_link_input::Builder {
        crate::input::get_vpc_link_input::Builder::default()
    }
}

/// See [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
pub mod get_vpc_links_input {
    /// A builder for [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) position: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, input: impl Into<std::string::String>) -> Self {
            self.position = Some(input.into());
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.position = input;
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVpcLinksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVpcLinksInput {
                position: self.position,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVpcLinksInputOperationOutputAlias = crate::operation::GetVpcLinks;
#[doc(hidden)]
pub type GetVpcLinksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetVpcLinksInput {
    /// Consumes the builder and constructs an Operation<[`GetVpcLinks`](crate::operation::GetVpcLinks)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVpcLinks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVpcLinksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/vpclinks").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetVpcLinksInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_180) = &_input.position {
                query.push_kv("position", &aws_smithy_http::query::fmt_string(&inner_180));
            }
            if let Some(inner_181) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_181).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVpcLinksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVpcLinksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVpcLinks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVpcLinks",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVpcLinksInput`](crate::input::GetVpcLinksInput)
    pub fn builder() -> crate::input::get_vpc_links_input::Builder {
        crate::input::get_vpc_links_input::Builder::default()
    }
}

/// See [`ImportApiKeysInput`](crate::input::ImportApiKeysInput)
pub mod import_api_keys_input {
    /// A builder for [`ImportApiKeysInput`](crate::input::ImportApiKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) format: std::option::Option<crate::model::ApiKeysFormat>,
        pub(crate) fail_on_warnings: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format</a>.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format</a>.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// <p>A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.</p>
        pub fn format(mut self, input: crate::model::ApiKeysFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ApiKeysFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>A query parameter to indicate whether to rollback <a>ApiKey</a> importation (<code>true</code>) or not (<code>false</code>) when error is encountered.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.fail_on_warnings = Some(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback <a>ApiKey</a> importation (<code>true</code>) or not (<code>false</code>) when error is encountered.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.fail_on_warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportApiKeysInput`](crate::input::ImportApiKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportApiKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportApiKeysInput {
                body: self.body,
                format: self.format,
                fail_on_warnings: self.fail_on_warnings.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ImportApiKeysInputOperationOutputAlias = crate::operation::ImportApiKeys;
#[doc(hidden)]
pub type ImportApiKeysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportApiKeysInput {
    /// Consumes the builder and constructs an Operation<[`ImportApiKeys`](crate::operation::ImportApiKeys)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportApiKeys,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportApiKeysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/apikeys").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ImportApiKeysInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("mode", "import");
            if let Some(inner_182) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_182));
            }
            if _input.fail_on_warnings {
                query.push_kv(
                    "failonwarnings",
                    &aws_smithy_types::primitive::Encoder::from(_input.fail_on_warnings).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportApiKeysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportApiKeysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_import_api_keys_input(self.body)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportApiKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportApiKeys",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportApiKeysInput`](crate::input::ImportApiKeysInput)
    pub fn builder() -> crate::input::import_api_keys_input::Builder {
        crate::input::import_api_keys_input::Builder::default()
    }
}

/// See [`ImportDocumentationPartsInput`](crate::input::ImportDocumentationPartsInput)
pub mod import_documentation_parts_input {
    /// A builder for [`ImportDocumentationPartsInput`](crate::input::ImportDocumentationPartsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::PutMode>,
        pub(crate) fail_on_warnings: std::option::Option<bool>,
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing one. The default value is <code>MERGE</code>.</p>
        pub fn mode(mut self, input: crate::model::PutMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing one. The default value is <code>MERGE</code>.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::PutMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.fail_on_warnings = Some(input);
            self
        }
        /// <p>A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.fail_on_warnings = input;
            self
        }
        /// <p>[Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>[Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportDocumentationPartsInput`](crate::input::ImportDocumentationPartsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportDocumentationPartsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportDocumentationPartsInput {
                rest_api_id: self.rest_api_id,
                mode: self.mode,
                fail_on_warnings: self.fail_on_warnings.unwrap_or_default(),
                body: self.body,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportDocumentationPartsInputOperationOutputAlias =
    crate::operation::ImportDocumentationParts;
#[doc(hidden)]
pub type ImportDocumentationPartsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportDocumentationPartsInput {
    /// Consumes the builder and constructs an Operation<[`ImportDocumentationParts`](crate::operation::ImportDocumentationParts)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportDocumentationParts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportDocumentationPartsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_183 = &_input.rest_api_id;
            let input_183 =
                input_183
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_183, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/documentation/parts",
                restApiId = rest_api_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ImportDocumentationPartsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_184) = &_input.mode {
                query.push_kv("mode", &aws_smithy_http::query::fmt_string(&inner_184));
            }
            if _input.fail_on_warnings {
                query.push_kv(
                    "failonwarnings",
                    &aws_smithy_types::primitive::Encoder::from(_input.fail_on_warnings).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportDocumentationPartsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportDocumentationPartsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_import_documentation_parts_input(self.body)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportDocumentationParts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportDocumentationParts",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportDocumentationPartsInput`](crate::input::ImportDocumentationPartsInput)
    pub fn builder() -> crate::input::import_documentation_parts_input::Builder {
        crate::input::import_documentation_parts_input::Builder::default()
    }
}

/// See [`ImportRestApiInput`](crate::input::ImportRestApiInput)
pub mod import_rest_api_input {
    /// A builder for [`ImportRestApiInput`](crate::input::ImportRestApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fail_on_warnings: std::option::Option<bool>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>)
        /// when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.fail_on_warnings = Some(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>)
        /// when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.fail_on_warnings = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.</p>
        /// <p> To exclude <a>DocumentationParts</a> from the import, set <code>parameters</code> as <code>ignore=documentation</code>.</p>
        /// <p> To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.</p>
        /// <p> To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>.</p>
        /// <p>For example, the AWS CLI command to exclude documentation from the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code></pre>
        /// <p>The AWS CLI command to set the regional endpoint on the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code></pre>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.</p>
        /// <p> To exclude <a>DocumentationParts</a> from the import, set <code>parameters</code> as <code>ignore=documentation</code>.</p>
        /// <p> To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.</p>
        /// <p> To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>.</p>
        /// <p>For example, the AWS CLI command to exclude documentation from the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code></pre>
        /// <p>The AWS CLI command to set the regional endpoint on the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code></pre>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>[Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>[Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportRestApiInput`](crate::input::ImportRestApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportRestApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportRestApiInput {
                fail_on_warnings: self.fail_on_warnings.unwrap_or_default(),
                parameters: self.parameters,
                body: self.body,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportRestApiInputOperationOutputAlias = crate::operation::ImportRestApi;
#[doc(hidden)]
pub type ImportRestApiInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportRestApiInput {
    /// Consumes the builder and constructs an Operation<[`ImportRestApi`](crate::operation::ImportRestApi)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportRestApi,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportRestApiInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/restapis").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ImportRestApiInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("mode", "import");
            let protected_params = ["mode", "failonwarnings"];
            if let Some(inner_185) = &_input.parameters {
                for (k, v) in inner_185 {
                    if !protected_params.contains(&k.as_str()) {
                        query.push_kv(
                            &aws_smithy_http::query::fmt_string(k),
                            &aws_smithy_http::query::fmt_string(v),
                        );
                    }
                }
            }
            if _input.fail_on_warnings {
                query.push_kv(
                    "failonwarnings",
                    &aws_smithy_types::primitive::Encoder::from(_input.fail_on_warnings).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportRestApiInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportRestApiInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_import_rest_api_input(self.body)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportRestApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportRestApi",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportRestApiInput`](crate::input::ImportRestApiInput)
    pub fn builder() -> crate::input::import_rest_api_input::Builder {
        crate::input::import_rest_api_input::Builder::default()
    }
}

/// See [`PutGatewayResponseInput`](crate::input::PutGatewayResponseInput)
pub mod put_gateway_response_input {
    /// A builder for [`PutGatewayResponseInput`](crate::input::PutGatewayResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) response_type: std::option::Option<crate::model::GatewayResponseType>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn response_type(mut self, input: crate::model::GatewayResponseType) -> Self {
            self.response_type = Some(input);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.response_type = input;
            self
        }
        /// The HTTP status code of the <a>GatewayResponse</a>.
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// The HTTP status code of the <a>GatewayResponse</a>.
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p><p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p></p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p><p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p></p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p><p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p></p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p><p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p></p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// Consumes the builder and constructs a [`PutGatewayResponseInput`](crate::input::PutGatewayResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutGatewayResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutGatewayResponseInput {
                rest_api_id: self.rest_api_id,
                response_type: self.response_type,
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
            })
        }
    }
}
#[doc(hidden)]
pub type PutGatewayResponseInputOperationOutputAlias = crate::operation::PutGatewayResponse;
#[doc(hidden)]
pub type PutGatewayResponseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutGatewayResponseInput {
    /// Consumes the builder and constructs an Operation<[`PutGatewayResponse`](crate::operation::PutGatewayResponse)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutGatewayResponse,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutGatewayResponseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_186 = &_input.rest_api_id;
            let input_186 =
                input_186
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_186, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_187 = &_input.response_type;
            let input_187 =
                input_187
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "response_type",
                        details: "cannot be empty or unset",
                    })?;
            let response_type = aws_smithy_http::label::fmt_string(input_187, false);
            if response_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "response_type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/gatewayresponses/{responseType}",
                restApiId = rest_api_id,
                responseType = response_type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutGatewayResponseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutGatewayResponseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_gateway_response(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutGatewayResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutGatewayResponse",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutGatewayResponseInput`](crate::input::PutGatewayResponseInput)
    pub fn builder() -> crate::input::put_gateway_response_input::Builder {
        crate::input::put_gateway_response_input::Builder::default()
    }
}

/// See [`PutIntegrationInput`](crate::input::PutIntegrationInput)
pub mod put_integration_input {
    /// A builder for [`PutIntegrationInput`](crate::input::PutIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) integration_http_method: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) credentials: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) passthrough_behavior: std::option::Option<std::string::String>,
        pub(crate) cache_namespace: std::option::Option<std::string::String>,
        pub(crate) cache_key_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
        pub(crate) timeout_in_millis: std::option::Option<i32>,
        pub(crate) tls_config: std::option::Option<crate::model::TlsConfig>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] Specifies a put integration request's resource ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a put integration request's resource ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] Specifies a put integration request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a put integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>[Required] Specifies a put integration input's type.</p>
        pub fn r#type(mut self, input: crate::model::IntegrationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>[Required] Specifies a put integration input's type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.</p>
        pub fn integration_http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_http_method = Some(input.into());
            self
        }
        /// <p>Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.</p>
        pub fn set_integration_http_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_http_method = input;
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>Specifies whether credentials are required for a put integration.</p>
        pub fn credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials = Some(input.into());
            self
        }
        /// <p>Specifies whether credentials are required for a put integration.</p>
        pub fn set_credentials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credentials = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_templates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_templates = Some(hash_map);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_templates = input;
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values:  <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>.
        /// </p>
        /// <ul>
        /// <li><p><code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration back end without transformation.</p></li>
        /// <li><p><code>NEVER</code> rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.</p></li>
        /// <li><p><code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.</p></li>
        /// </ul>
        pub fn passthrough_behavior(mut self, input: impl Into<std::string::String>) -> Self {
            self.passthrough_behavior = Some(input.into());
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values:  <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>.
        /// </p>
        /// <ul>
        /// <li><p><code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration back end without transformation.</p></li>
        /// <li><p><code>NEVER</code> rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.</p></li>
        /// <li><p><code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.</p></li>
        /// </ul>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.passthrough_behavior = input;
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn cache_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_namespace = Some(input.into());
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn set_cache_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_namespace = input;
            self
        }
        /// Appends an item to `cache_key_parameters`.
        ///
        /// To override the contents of this collection use [`set_cache_key_parameters`](Self::set_cache_key_parameters).
        ///
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn cache_key_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_key_parameters.unwrap_or_default();
            v.push(input.into());
            self.cache_key_parameters = Some(v);
            self
        }
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn set_cache_key_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_key_parameters = input;
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn timeout_in_millis(mut self, input: i32) -> Self {
            self.timeout_in_millis = Some(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_millis = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn tls_config(mut self, input: crate::model::TlsConfig) -> Self {
            self.tls_config = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.tls_config = input;
            self
        }
        /// Consumes the builder and constructs a [`PutIntegrationInput`](crate::input::PutIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutIntegrationInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
                r#type: self.r#type,
                integration_http_method: self.integration_http_method,
                uri: self.uri,
                connection_type: self.connection_type,
                connection_id: self.connection_id,
                credentials: self.credentials,
                request_parameters: self.request_parameters,
                request_templates: self.request_templates,
                passthrough_behavior: self.passthrough_behavior,
                cache_namespace: self.cache_namespace,
                cache_key_parameters: self.cache_key_parameters,
                content_handling: self.content_handling,
                timeout_in_millis: self.timeout_in_millis,
                tls_config: self.tls_config,
            })
        }
    }
}
#[doc(hidden)]
pub type PutIntegrationInputOperationOutputAlias = crate::operation::PutIntegration;
#[doc(hidden)]
pub type PutIntegrationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`PutIntegration`](crate::operation::PutIntegration)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutIntegration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutIntegrationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_188 = &_input.rest_api_id;
            let input_188 =
                input_188
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_188, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_189 = &_input.resource_id;
            let input_189 =
                input_189
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_189, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_190 = &_input.http_method;
            let input_190 =
                input_190
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_190, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}/integration",
                restApiId = rest_api_id,
                resourceId = resource_id,
                httpMethod = http_method
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutIntegrationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutIntegrationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_integration(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutIntegration",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutIntegrationInput`](crate::input::PutIntegrationInput)
    pub fn builder() -> crate::input::put_integration_input::Builder {
        crate::input::put_integration_input::Builder::default()
    }
}

/// See [`PutIntegrationResponseInput`](crate::input::PutIntegrationResponseInput)
pub mod put_integration_response_input {
    /// A builder for [`PutIntegrationResponseInput`](crate::input::PutIntegrationResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) selection_pattern: std::option::Option<std::string::String>,
        pub(crate) response_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_templates: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) content_handling: std::option::Option<crate::model::ContentHandlingStrategy>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] Specifies a put integration response request's resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a put integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] Specifies a put integration response request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a put integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>[Required] Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>[Required] Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>Specifies the selection pattern of a put integration response.</p>
        pub fn selection_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_pattern = Some(input.into());
            self
        }
        /// <p>Specifies the selection pattern of a put integration response.</p>
        pub fn set_selection_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_pattern = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_templates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Specifies a put integration response's templates.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_templates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_templates = Some(hash_map);
            self
        }
        /// <p>Specifies a put integration response's templates.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_templates = input;
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn content_handling(mut self, input: crate::model::ContentHandlingStrategy) -> Self {
            self.content_handling = Some(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.content_handling = input;
            self
        }
        /// Consumes the builder and constructs a [`PutIntegrationResponseInput`](crate::input::PutIntegrationResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutIntegrationResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutIntegrationResponseInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
                status_code: self.status_code,
                selection_pattern: self.selection_pattern,
                response_parameters: self.response_parameters,
                response_templates: self.response_templates,
                content_handling: self.content_handling,
            })
        }
    }
}
#[doc(hidden)]
pub type PutIntegrationResponseInputOperationOutputAlias = crate::operation::PutIntegrationResponse;
#[doc(hidden)]
pub type PutIntegrationResponseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutIntegrationResponseInput {
    /// Consumes the builder and constructs an Operation<[`PutIntegrationResponse`](crate::operation::PutIntegrationResponse)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutIntegrationResponse,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutIntegrationResponseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_191 = &_input.rest_api_id;
            let input_191 =
                input_191
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_191, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_192 = &_input.resource_id;
            let input_192 =
                input_192
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_192, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_193 = &_input.http_method;
            let input_193 =
                input_193
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_193, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            let input_194 = &_input.status_code;
            let input_194 =
                input_194
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "status_code",
                        details: "cannot be empty or unset",
                    })?;
            let status_code = aws_smithy_http::label::fmt_string(input_194, false);
            if status_code.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "status_code",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}/integration/responses/{statusCode}", restApiId = rest_api_id, resourceId = resource_id, httpMethod = http_method, statusCode = status_code).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutIntegrationResponseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutIntegrationResponseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_integration_response(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutIntegrationResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutIntegrationResponse",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutIntegrationResponseInput`](crate::input::PutIntegrationResponseInput)
    pub fn builder() -> crate::input::put_integration_response_input::Builder {
        crate::input::put_integration_response_input::Builder::default()
    }
}

/// See [`PutMethodInput`](crate::input::PutMethodInput)
pub mod put_method_input {
    /// A builder for [`PutMethodInput`](crate::input::PutMethodInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) authorization_type: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) api_key_required: std::option::Option<bool>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) request_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) request_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_validator_id: std::option::Option<std::string::String>,
        pub(crate) authorization_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>[Required] The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn authorization_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_type = Some(input.into());
            self
        }
        /// <p>[Required] The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// <p>Specifies whether the method required a valid <a>ApiKey</a>.</p>
        pub fn api_key_required(mut self, input: bool) -> Self {
            self.api_key_required = Some(input);
            self
        }
        /// <p>Specifies whether the method required a valid <a>ApiKey</a>.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.api_key_required = input;
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Adds a key-value pair to `request_parameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or body-mapping templates.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.request_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or body-mapping templates.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// Adds a key-value pair to `request_models`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>Specifies the <a>Model</a> resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_models = Some(hash_map);
            self
        }
        /// <p>Specifies the <a>Model</a> resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_models = input;
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for validating the method request.</p>
        pub fn request_validator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_validator_id = Some(input.into());
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for validating the method request.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_validator_id = input;
            self
        }
        /// Appends an item to `authorization_scopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorization_scopes.unwrap_or_default();
            v.push(input.into());
            self.authorization_scopes = Some(v);
            self
        }
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorization_scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMethodInput`](crate::input::PutMethodInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutMethodInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutMethodInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
                authorization_type: self.authorization_type,
                authorizer_id: self.authorizer_id,
                api_key_required: self.api_key_required.unwrap_or_default(),
                operation_name: self.operation_name,
                request_parameters: self.request_parameters,
                request_models: self.request_models,
                request_validator_id: self.request_validator_id,
                authorization_scopes: self.authorization_scopes,
            })
        }
    }
}
#[doc(hidden)]
pub type PutMethodInputOperationOutputAlias = crate::operation::PutMethod;
#[doc(hidden)]
pub type PutMethodInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutMethodInput {
    /// Consumes the builder and constructs an Operation<[`PutMethod`](crate::operation::PutMethod)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutMethod,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutMethodInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_195 = &_input.rest_api_id;
            let input_195 =
                input_195
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_195, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_196 = &_input.resource_id;
            let input_196 =
                input_196
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_196, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_197 = &_input.http_method;
            let input_197 =
                input_197
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_197, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}",
                restApiId = rest_api_id,
                resourceId = resource_id,
                httpMethod = http_method
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutMethodInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutMethodInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_method(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutMethod::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutMethod",
                    "apigateway",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutMethodInput`](crate::input::PutMethodInput)
    pub fn builder() -> crate::input::put_method_input::Builder {
        crate::input::put_method_input::Builder::default()
    }
}

/// See [`PutMethodResponseInput`](crate::input::PutMethodResponseInput)
pub mod put_method_response_input {
    /// A builder for [`PutMethodResponseInput`](crate::input::PutMethodResponseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) response_parameters:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) response_models: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>[Required] The method response's status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>[Required] The method response's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `response_parameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.response_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_parameters = Some(hash_map);
            self
        }
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.response_parameters = input;
            self
        }
        /// Adds a key-value pair to `response_models`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Specifies the <a>Model</a> resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_models.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_models = Some(hash_map);
            self
        }
        /// <p>Specifies the <a>Model</a> resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_models = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMethodResponseInput`](crate::input::PutMethodResponseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutMethodResponseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutMethodResponseInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
                status_code: self.status_code,
                response_parameters: self.response_parameters,
                response_models: self.response_models,
            })
        }
    }
}
#[doc(hidden)]
pub type PutMethodResponseInputOperationOutputAlias = crate::operation::PutMethodResponse;
#[doc(hidden)]
pub type PutMethodResponseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutMethodResponseInput {
    /// Consumes the builder and constructs an Operation<[`PutMethodResponse`](crate::operation::PutMethodResponse)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutMethodResponse,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutMethodResponseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_198 = &_input.rest_api_id;
            let input_198 =
                input_198
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_198, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_199 = &_input.resource_id;
            let input_199 =
                input_199
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_199, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_200 = &_input.http_method;
            let input_200 =
                input_200
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_200, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            let input_201 = &_input.status_code;
            let input_201 =
                input_201
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "status_code",
                        details: "cannot be empty or unset",
                    })?;
            let status_code = aws_smithy_http::label::fmt_string(input_201, false);
            if status_code.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "status_code",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}/responses/{statusCode}", restApiId = rest_api_id, resourceId = resource_id, httpMethod = http_method, statusCode = status_code).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutMethodResponseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutMethodResponseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_method_response(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutMethodResponse::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutMethodResponse",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutMethodResponseInput`](crate::input::PutMethodResponseInput)
    pub fn builder() -> crate::input::put_method_response_input::Builder {
        crate::input::put_method_response_input::Builder::default()
    }
}

/// See [`PutRestApiInput`](crate::input::PutRestApiInput)
pub mod put_rest_api_input {
    /// A builder for [`PutRestApiInput`](crate::input::PutRestApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::PutMode>,
        pub(crate) fail_on_warnings: std::option::Option<bool>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default,
        /// the update mode is "merge".</p>
        pub fn mode(mut self, input: crate::model::PutMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default,
        /// the update mode is "merge".</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::PutMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>)
        /// when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn fail_on_warnings(mut self, input: bool) -> Self {
            self.fail_on_warnings = Some(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>)
        /// when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.fail_on_warnings = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Custom header parameters as part of the request. For example, to exclude <a>DocumentationParts</a> from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>Custom header parameters as part of the request. For example, to exclude <a>DocumentationParts</a> from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>[Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>[Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRestApiInput`](crate::input::PutRestApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRestApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRestApiInput {
                rest_api_id: self.rest_api_id,
                mode: self.mode,
                fail_on_warnings: self.fail_on_warnings.unwrap_or_default(),
                parameters: self.parameters,
                body: self.body,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRestApiInputOperationOutputAlias = crate::operation::PutRestApi;
#[doc(hidden)]
pub type PutRestApiInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRestApiInput {
    /// Consumes the builder and constructs an Operation<[`PutRestApi`](crate::operation::PutRestApi)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRestApi,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRestApiInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_202 = &_input.rest_api_id;
            let input_202 =
                input_202
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_202, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/restapis/{restApiId}", restApiId = rest_api_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::PutRestApiInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            let protected_params = ["mode", "failonwarnings"];
            if let Some(inner_203) = &_input.parameters {
                for (k, v) in inner_203 {
                    if !protected_params.contains(&k.as_str()) {
                        query.push_kv(
                            &aws_smithy_http::query::fmt_string(k),
                            &aws_smithy_http::query::fmt_string(v),
                        );
                    }
                }
            }
            if let Some(inner_204) = &_input.mode {
                query.push_kv("mode", &aws_smithy_http::query::fmt_string(&inner_204));
            }
            if _input.fail_on_warnings {
                query.push_kv(
                    "failonwarnings",
                    &aws_smithy_types::primitive::Encoder::from(_input.fail_on_warnings).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRestApiInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRestApiInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_put_rest_api_input(self.body)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRestApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRestApi",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRestApiInput`](crate::input::PutRestApiInput)
    pub fn builder() -> crate::input::put_rest_api_input::Builder {
        crate::input::put_rest_api_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>[Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>[Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_205 = &_input.resource_arn;
            let input_205 =
                input_205
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_205, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TestInvokeAuthorizerInput`](crate::input::TestInvokeAuthorizerInput)
pub mod test_invoke_authorizer_input {
    /// A builder for [`TestInvokeAuthorizerInput`](crate::input::TestInvokeAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) multi_value_headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) path_with_query_string: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) stage_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) additional_context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] Specifies a test invoke authorizer request's <a>Authorizer</a> ID.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a test invoke authorizer request's <a>Authorizer</a> ID.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// Adds a key-value pair to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>[Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.</p>
        pub fn headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.headers = Some(hash_map);
            self
        }
        /// <p>[Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.headers = input;
            self
        }
        /// Adds a key-value pair to `multi_value_headers`.
        ///
        /// To override the contents of this collection use [`set_multi_value_headers`](Self::set_multi_value_headers).
        ///
        /// <p>[Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.</p>
        pub fn multi_value_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.multi_value_headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.multi_value_headers = Some(hash_map);
            self
        }
        /// <p>[Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.</p>
        pub fn set_multi_value_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.multi_value_headers = input;
            self
        }
        /// <p>[Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn path_with_query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_with_query_string = Some(input.into());
            self
        }
        /// <p>[Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn set_path_with_query_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.path_with_query_string = input;
            self
        }
        /// <p>[Optional] The simulated request body of an incoming invocation request.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>[Optional] The simulated request body of an incoming invocation request.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// Adds a key-value pair to `stage_variables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variables = Some(hash_map);
            self
        }
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variables = input;
            self
        }
        /// Adds a key-value pair to `additional_context`.
        ///
        /// To override the contents of this collection use [`set_additional_context`](Self::set_additional_context).
        ///
        /// <p>[Optional] A key-value map of additional context variables.</p>
        pub fn additional_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.additional_context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_context = Some(hash_map);
            self
        }
        /// <p>[Optional] A key-value map of additional context variables.</p>
        pub fn set_additional_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.additional_context = input;
            self
        }
        /// Consumes the builder and constructs a [`TestInvokeAuthorizerInput`](crate::input::TestInvokeAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestInvokeAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestInvokeAuthorizerInput {
                rest_api_id: self.rest_api_id,
                authorizer_id: self.authorizer_id,
                headers: self.headers,
                multi_value_headers: self.multi_value_headers,
                path_with_query_string: self.path_with_query_string,
                body: self.body,
                stage_variables: self.stage_variables,
                additional_context: self.additional_context,
            })
        }
    }
}
#[doc(hidden)]
pub type TestInvokeAuthorizerInputOperationOutputAlias = crate::operation::TestInvokeAuthorizer;
#[doc(hidden)]
pub type TestInvokeAuthorizerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TestInvokeAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`TestInvokeAuthorizer`](crate::operation::TestInvokeAuthorizer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestInvokeAuthorizer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestInvokeAuthorizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_206 = &_input.rest_api_id;
            let input_206 =
                input_206
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_206, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_207 = &_input.authorizer_id;
            let input_207 =
                input_207
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    })?;
            let authorizer_id = aws_smithy_http::label::fmt_string(input_207, false);
            if authorizer_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "authorizer_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/authorizers/{authorizerId}",
                restApiId = rest_api_id,
                authorizerId = authorizer_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestInvokeAuthorizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestInvokeAuthorizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_test_invoke_authorizer(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestInvokeAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestInvokeAuthorizer",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestInvokeAuthorizerInput`](crate::input::TestInvokeAuthorizerInput)
    pub fn builder() -> crate::input::test_invoke_authorizer_input::Builder {
        crate::input::test_invoke_authorizer_input::Builder::default()
    }
}

/// See [`TestInvokeMethodInput`](crate::input::TestInvokeMethodInput)
pub mod test_invoke_method_input {
    /// A builder for [`TestInvokeMethodInput`](crate::input::TestInvokeMethodInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) path_with_query_string: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) multi_value_headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) stage_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] Specifies a test invoke method request's resource ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a test invoke method request's resource ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>[Required] Specifies a test invoke method request's HTTP method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>[Required] Specifies a test invoke method request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn path_with_query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_with_query_string = Some(input.into());
            self
        }
        /// <p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn set_path_with_query_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.path_with_query_string = input;
            self
        }
        /// <p>The simulated request body of an incoming invocation request.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The simulated request body of an incoming invocation request.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// Adds a key-value pair to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>A key-value map of headers to simulate an incoming invocation request.</p>
        pub fn headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.headers = Some(hash_map);
            self
        }
        /// <p>A key-value map of headers to simulate an incoming invocation request.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.headers = input;
            self
        }
        /// Adds a key-value pair to `multi_value_headers`.
        ///
        /// To override the contents of this collection use [`set_multi_value_headers`](Self::set_multi_value_headers).
        ///
        /// <p>The headers as a map from string to list of values to simulate an incoming invocation request.</p>
        pub fn multi_value_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.multi_value_headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.multi_value_headers = Some(hash_map);
            self
        }
        /// <p>The headers as a map from string to list of values to simulate an incoming invocation request.</p>
        pub fn set_multi_value_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.multi_value_headers = input;
            self
        }
        /// <p>A <a>ClientCertificate</a> identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>A <a>ClientCertificate</a> identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// Adds a key-value pair to `stage_variables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stage_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stage_variables = Some(hash_map);
            self
        }
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stage_variables = input;
            self
        }
        /// Consumes the builder and constructs a [`TestInvokeMethodInput`](crate::input::TestInvokeMethodInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestInvokeMethodInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestInvokeMethodInput {
                rest_api_id: self.rest_api_id,
                resource_id: self.resource_id,
                http_method: self.http_method,
                path_with_query_string: self.path_with_query_string,
                body: self.body,
                headers: self.headers,
                multi_value_headers: self.multi_value_headers,
                client_certificate_id: self.client_certificate_id,
                stage_variables: self.stage_variables,
            })
        }
    }
}
#[doc(hidden)]
pub type TestInvokeMethodInputOperationOutputAlias = crate::operation::TestInvokeMethod;
#[doc(hidden)]
pub type TestInvokeMethodInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TestInvokeMethodInput {
    /// Consumes the builder and constructs an Operation<[`TestInvokeMethod`](crate::operation::TestInvokeMethod)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestInvokeMethod,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestInvokeMethodInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_208 = &_input.rest_api_id;
            let input_208 =
                input_208
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_208, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_209 = &_input.resource_id;
            let input_209 =
                input_209
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_209, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_210 = &_input.http_method;
            let input_210 =
                input_210
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "http_method",
                        details: "cannot be empty or unset",
                    })?;
            let http_method = aws_smithy_http::label::fmt_string(input_210, false);
            if http_method.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "http_method",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/resources/{resourceId}/methods/{httpMethod}",
                restApiId = rest_api_id,
                resourceId = resource_id,
                httpMethod = http_method
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestInvokeMethodInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestInvokeMethodInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_test_invoke_method(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestInvokeMethod::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestInvokeMethod",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestInvokeMethodInput`](crate::input::TestInvokeMethodInput)
    pub fn builder() -> crate::input::test_invoke_method_input::Builder {
        crate::input::test_invoke_method_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>[Required] The Tag keys to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>[Required] The Tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_211 = &_input.resource_arn;
            let input_211 =
                input_211
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_211, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_212) = &_input.tag_keys {
                for inner_213 in inner_212 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_213));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAccountInput`](crate::input::UpdateAccountInput)
pub mod update_account_input {
    /// A builder for [`UpdateAccountInput`](crate::input::UpdateAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patch_operations:
            std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
    }
    impl Builder {
        /// Appends an item to `patch_operations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: impl Into<crate::model::PatchOperation>) -> Self {
            let mut v = self.patch_operations.unwrap_or_default();
            v.push(input.into());
            self.patch_operations = Some(v);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.patch_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccountInput`](crate::input::UpdateAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAccountInput {
                patch_operations: self.patch_operations,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAccountInputOperationOutputAlias = crate::operation::UpdateAccount;
#[doc(hidden)]
pub type UpdateAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAccountInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAccount`](crate::operation::UpdateAccount)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_account(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAccount",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAccountInput`](crate::input::UpdateAccountInput)
    pub fn builder() -> crate::input::update_account_input::Builder {
        crate::input::update_account_input::Builder::default()
    }
}

/// See [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
pub mod update_api_key_input {
    /// A builder for [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key: std::option::Option<std::string::String>,
        pub(crate) patch_operations:
            std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource to be updated.</p>
        pub fn api_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource to be updated.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key = input;
            self
        }
        /// Appends an item to `patch_operations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: impl Into<crate::model::PatchOperation>) -> Self {
            let mut v = self.patch_operations.unwrap_or_default();
            v.push(input.into());
            self.patch_operations = Some(v);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.patch_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApiKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApiKeyInput {
                api_key: self.api_key,
                patch_operations: self.patch_operations,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApiKeyInputOperationOutputAlias = crate::operation::UpdateApiKey;
#[doc(hidden)]
pub type UpdateApiKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateApiKeyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApiKey`](crate::operation::UpdateApiKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApiKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateApiKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_214 = &_input.api_key;
            let input_214 =
                input_214
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_key",
                        details: "cannot be empty or unset",
                    })?;
            let api_key = aws_smithy_http::label::fmt_string(input_214, false);
            if api_key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "api_key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/apikeys/{apiKey}", apiKey = api_key)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateApiKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateApiKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_api_key(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApiKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApiKey",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
    pub fn builder() -> crate::input::update_api_key_input::Builder {
        crate::input::update_api_key_input::Builder::default()
    }
}

/// See [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
pub mod update_authorizer_input {
    /// A builder for [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rest_api_id: std::option::Option<std::string::String>,
        pub(crate) authorizer_id: std::option::Option<std::string::String>,
        pub(crate) patch_operations:
            std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
    }
    impl Builder {
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rest_api_id = Some(input.into());
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rest_api_id = input;
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn authorizer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_id = input;
            self
        }
        /// Appends an item to `patch_operations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: impl Into<crate::model::PatchOperation>) -> Self {
            let mut v = self.patch_operations.unwrap_or_default();
            v.push(input.into());
            self.patch_operations = Some(v);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.patch_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAuthorizerInput {
                rest_api_id: self.rest_api_id,
                authorizer_id: self.authorizer_id,
                patch_operations: self.patch_operations,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAuthorizerInputOperationOutputAlias = crate::operation::UpdateAuthorizer;
#[doc(hidden)]
pub type UpdateAuthorizerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAuthorizer`](crate::operation::UpdateAuthorizer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAuthorizer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAuthorizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_215 = &_input.rest_api_id;
            let input_215 =
                input_215
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rest_api_id",
                        details: "cannot be empty or unset",
                    })?;
            let rest_api_id = aws_smithy_http::label::fmt_string(input_215, false);
            if rest_api_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rest_api_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_216 = &_input.authorizer_id;
            let input_216 =
                input_216
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_id",
                        details: "cannot be empty or unset",
                    })?;
            let authorizer_id = aws_smithy_http::label::fmt_string(input_216, false);
            if authorizer_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "authorizer_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restapis/{restApiId}/authorizers/{authorizerId}",
                restApiId = rest_api_id,
                authorizerId = authorizer_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAuthorizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAuthorizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_authorizer(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAuthorizer",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
    pub fn builder() -> crate::input::update_authorizer_input::Builder {
        crate::input::update_authorizer_input::Builder::default()
    }
}

/// See [`UpdateBasePathMappingInput`](crate::input::UpdateBasePathMappingInput)
pub mod update_base_path_mapping_input {
    /// A builder for [`UpdateBasePathMappingInput`](crate::input::UpdateBasePathMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) base_path: std::option::Option<std::string::String>,
        pub(crate) patch_operations:
            std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
    }
    impl Builder {
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to change.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to change.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>[Required] The base path of the <a>BasePathMapping</a> resource to change.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn base_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_path = Some(input.into());
            self
        }
        /// <p>[Required] The base path of the <a>BasePathMapping</a> resource to change.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.base_path = input;
            self
        }
        /// Appends an item to `patch_operations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: impl Into<crate::model::PatchOperation>) -> Self {
            let mut v = self.patch_operations.unwrap_or_default();
            v.push(input.into());
            self.patch_operations = Some(v);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.patch_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBasePathMappingInput`](crate::input::UpdateBasePathMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBasePathMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBasePathMappingInput {
                domain_name: self.domain_name,
                base_path: self.base_path,
                patch_operations: self.patch_operations,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBasePathMappingInputOperationOutputAlias = crate::operation::UpdateBasePathMapping;
#[doc(hidden)]
pub type UpdateBasePathMappingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateBasePathMappingInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBasePathMapping`](crate::operation::UpdateBasePathMapping)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBasePathMapping,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBasePathMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_217 = &_input.domain_name;
            let input_217 =
                input_217
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    })?;
            let domain_name = aws_smithy_http::label::fmt_string(input_217, false);
            if domain_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "domain_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_218 = &_input.base_path;
            let input_218 =
                input_218
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "base_path",
                        details: "cannot be empty or unset",
                    })?;
            let base_path = aws_smithy_http::label::fmt_string(input_218, false);
            if base_path.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "base_path",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/domainnames/{domainName}/basepathmappings/{basePath}",
                domainName = domain_name,
                basePath = base_path
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBasePathMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBasePathMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_base_path_mapping(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request
            .http_mut()
            .headers_mut()
            .insert("Accept", http::HeaderValue::from_static("application/json"));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBasePathMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBasePathMapping",
            "apigateway",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBasePathMappingInput`](crate::input::UpdateBasePathMappingInput)
    pub fn builder() -> crate::input::update_base_path_mapping_input::Builder {
        crate::input::update_base_path_mapping_input::Builder::default()
    }
}

/// See [`UpdateClientCertificateInput`](crate::input::UpdateClientCertificateInput)
pub mod update_client_certificate_input {
    /// A builder for [`UpdateClientCertificateInput`](crate::input::UpdateClientCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_certificate_id: std::option::Option<std::string::String>,
        pub(crate) patch_operations:
            std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
    }
    impl Builder {
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be updated.</p>
        pub fn client_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_certificate_id = Some(input.into());
            self
        }
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be updated.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_certificate_id = input;
            self
        }
        /// Appends an item to `patch_operations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, input: impl Into<crate::model::PatchOperation>) -> Self {
            let mut v = self.patch_operations.unwrap_or_default();
            v.push(input.into());
            self.patch_operations = Some(v);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.patch_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClientCertificateInput`](crate::input::UpdateClientCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateClientCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateClientCertificateInput {
                client_certificate_id: self.client_certificate_id,
                patch_operations: self.patch_operations,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateClientCertificateInputOperationOutputAlias =
    crate::operation::UpdateClientCertificate;
#[doc(hidden)]
pub type UpdateClientCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateClientCertificateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateClientCertificate`](crate::operation::UpdateClientCertificate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateClientCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateClientCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_219 = &_input.client_certificate_id;
            let input_219 =
                input_219
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "client_certificate_id",
                        details: "cannot be empty or unset",
                    })?;
            let client_certificate_id = aws_smithy_http::label::fmt_string(input_219, false);
            if client_certificate_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "client_certificate_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/clientcertif