// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApiKeyError {
    /// Kind of error that occurred.
    pub kind: CreateApiKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApiKeyErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApiKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApiKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApiKeyError {
    fn code(&self) -> Option<&str> {
        CreateApiKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApiKeyError {
    /// Creates a new `CreateApiKeyError`.
    pub fn new(kind: CreateApiKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApiKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApiKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApiKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApiKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateApiKeyErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateApiKeyErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateApiKeyErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateApiKeyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiKeyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateApiKeyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateApiKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApiKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::ConflictException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAuthorizerError {
    /// Kind of error that occurred.
    pub kind: CreateAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAuthorizerErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAuthorizerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAuthorizerError {
    fn code(&self) -> Option<&str> {
        CreateAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAuthorizerError {
    /// Creates a new `CreateAuthorizerError`.
    pub fn new(kind: CreateAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateAuthorizerErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateAuthorizerErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAuthorizerErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBasePathMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBasePathMappingError {
    /// Kind of error that occurred.
    pub kind: CreateBasePathMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBasePathMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBasePathMappingErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBasePathMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBasePathMappingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBasePathMappingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBasePathMappingErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBasePathMappingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBasePathMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateBasePathMappingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateBasePathMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBasePathMappingError {
    fn code(&self) -> Option<&str> {
        CreateBasePathMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBasePathMappingError {
    /// Creates a new `CreateBasePathMappingError`.
    pub fn new(kind: CreateBasePathMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBasePathMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBasePathMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBasePathMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBasePathMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateBasePathMappingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBasePathMappingErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateBasePathMappingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBasePathMappingErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateBasePathMappingErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBasePathMappingErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateBasePathMappingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBasePathMappingErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateBasePathMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBasePathMappingErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateBasePathMappingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBasePathMappingErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateBasePathMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBasePathMappingErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBasePathMappingErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBasePathMappingErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBasePathMappingErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBasePathMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateBasePathMappingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateBasePathMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDeploymentError {
    /// Kind of error that occurred.
    pub kind: CreateDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDeploymentErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested service is not available. For details see the accompanying error message. Retry after the specified time period.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDeploymentError {
    fn code(&self) -> Option<&str> {
        CreateDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDeploymentError {
    /// Creates a new `CreateDeploymentError`.
    pub fn new(kind: CreateDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDeploymentErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateDeploymentErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateDeploymentErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDocumentationPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDocumentationPartError {
    /// Kind of error that occurred.
    pub kind: CreateDocumentationPartErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDocumentationPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDocumentationPartErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDocumentationPartError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDocumentationPartErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDocumentationPartErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDocumentationPartErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDocumentationPartErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDocumentationPartErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateDocumentationPartErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateDocumentationPartErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDocumentationPartError {
    fn code(&self) -> Option<&str> {
        CreateDocumentationPartError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDocumentationPartError {
    /// Creates a new `CreateDocumentationPartError`.
    pub fn new(kind: CreateDocumentationPartErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDocumentationPartError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDocumentationPartErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDocumentationPartError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDocumentationPartErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDocumentationPartErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationPartErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationPartErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationPartErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationPartErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationPartErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationPartErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationPartErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationPartErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationPartErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationPartErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationPartErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateDocumentationPartError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDocumentationPartErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDocumentationPartErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDocumentationPartErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDocumentationPartErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDocumentationPartErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateDocumentationPartErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateDocumentationPartErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDocumentationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDocumentationVersionError {
    /// Kind of error that occurred.
    pub kind: CreateDocumentationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDocumentationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDocumentationVersionErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDocumentationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDocumentationVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDocumentationVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDocumentationVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDocumentationVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDocumentationVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateDocumentationVersionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateDocumentationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDocumentationVersionError {
    fn code(&self) -> Option<&str> {
        CreateDocumentationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDocumentationVersionError {
    /// Creates a new `CreateDocumentationVersionError`.
    pub fn new(kind: CreateDocumentationVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDocumentationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDocumentationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDocumentationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDocumentationVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDocumentationVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationVersionErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateDocumentationVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentationVersionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateDocumentationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDocumentationVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDocumentationVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDocumentationVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDocumentationVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDocumentationVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateDocumentationVersionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateDocumentationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainNameError {
    /// Kind of error that occurred.
    pub kind: CreateDomainNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainNameErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainNameErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateDomainNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainNameError {
    fn code(&self) -> Option<&str> {
        CreateDomainNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainNameError {
    /// Creates a new `CreateDomainNameError`.
    pub fn new(kind: CreateDomainNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainNameErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainNameErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainNameErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainNameErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainNameErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainNameErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateDomainNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainNameErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateDomainNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateModelError {
    /// Kind of error that occurred.
    pub kind: CreateModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateModelErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateModelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateModelError {
    fn code(&self) -> Option<&str> {
        CreateModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateModelError {
    /// Creates a new `CreateModelError`.
    pub fn new(kind: CreateModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateModelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateModelErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateModelErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateModelErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateModelErrorKind::ConflictException(_inner) => Some(_inner),
            CreateModelErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateModelErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateModelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateModelErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRequestValidator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRequestValidatorError {
    /// Kind of error that occurred.
    pub kind: CreateRequestValidatorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRequestValidator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRequestValidatorErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRequestValidatorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRequestValidatorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateRequestValidatorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRequestValidatorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRequestValidatorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRequestValidatorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateRequestValidatorErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateRequestValidatorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRequestValidatorError {
    fn code(&self) -> Option<&str> {
        CreateRequestValidatorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRequestValidatorError {
    /// Creates a new `CreateRequestValidatorError`.
    pub fn new(kind: CreateRequestValidatorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRequestValidatorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRequestValidatorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRequestValidatorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRequestValidatorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRequestValidatorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRequestValidatorErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateRequestValidatorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRequestValidatorErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateRequestValidatorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRequestValidatorErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateRequestValidatorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRequestValidatorErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateRequestValidatorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRequestValidatorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateRequestValidatorErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRequestValidatorErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateRequestValidatorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRequestValidatorErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateRequestValidatorErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRequestValidatorErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRequestValidatorErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRequestValidatorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateRequestValidatorErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateRequestValidatorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourceError {
    /// Kind of error that occurred.
    pub kind: CreateResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourceErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourceError {
    fn code(&self) -> Option<&str> {
        CreateResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourceError {
    /// Creates a new `CreateResourceError`.
    pub fn new(kind: CreateResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateResourceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRestApiError {
    /// Kind of error that occurred.
    pub kind: CreateRestApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRestApiErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRestApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRestApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateRestApiErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRestApiErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRestApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateRestApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateRestApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRestApiError {
    fn code(&self) -> Option<&str> {
        CreateRestApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRestApiError {
    /// Creates a new `CreateRestApiError`.
    pub fn new(kind: CreateRestApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRestApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRestApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRestApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRestApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRestApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateRestApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateRestApiErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateRestApiErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateRestApiErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRestApiErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateRestApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRestApiErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateRestApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateRestApiErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateRestApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRestApiErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateRestApiErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRestApiErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRestApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateRestApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateRestApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStageError {
    /// Kind of error that occurred.
    pub kind: CreateStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStageErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStageError {
    fn code(&self) -> Option<&str> {
        CreateStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStageError {
    /// Creates a new `CreateStageError`.
    pub fn new(kind: CreateStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateStageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateStageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateStageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateStageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStageErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateStageErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStageErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateStageErrorKind::ConflictException(_inner) => Some(_inner),
            CreateStageErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateStageErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateStageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateStageErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUsagePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUsagePlanError {
    /// Kind of error that occurred.
    pub kind: CreateUsagePlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUsagePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUsagePlanErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUsagePlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUsagePlanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateUsagePlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateUsagePlanErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUsagePlanErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateUsagePlanErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateUsagePlanErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateUsagePlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUsagePlanError {
    fn code(&self) -> Option<&str> {
        CreateUsagePlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUsagePlanError {
    /// Creates a new `CreateUsagePlanError`.
    pub fn new(kind: CreateUsagePlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUsagePlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUsagePlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUsagePlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUsagePlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateUsagePlanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateUsagePlanErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateUsagePlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateUsagePlanErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateUsagePlanErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsagePlanErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateUsagePlanErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateUsagePlanErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateUsagePlanErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsagePlanErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateUsagePlanErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsagePlanErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateUsagePlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUsagePlanErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateUsagePlanErrorKind::ConflictException(_inner) => Some(_inner),
            CreateUsagePlanErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUsagePlanErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateUsagePlanErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateUsagePlanErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateUsagePlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUsagePlanKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUsagePlanKeyError {
    /// Kind of error that occurred.
    pub kind: CreateUsagePlanKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUsagePlanKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUsagePlanKeyErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUsagePlanKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUsagePlanKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateUsagePlanKeyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateUsagePlanKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUsagePlanKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateUsagePlanKeyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateUsagePlanKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateUsagePlanKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUsagePlanKeyError {
    fn code(&self) -> Option<&str> {
        CreateUsagePlanKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUsagePlanKeyError {
    /// Creates a new `CreateUsagePlanKeyError`.
    pub fn new(kind: CreateUsagePlanKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUsagePlanKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUsagePlanKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUsagePlanKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUsagePlanKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateUsagePlanKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsagePlanKeyErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateUsagePlanKeyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsagePlanKeyErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateUsagePlanKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsagePlanKeyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateUsagePlanKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsagePlanKeyErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateUsagePlanKeyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsagePlanKeyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateUsagePlanKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsagePlanKeyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateUsagePlanKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUsagePlanKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateUsagePlanKeyErrorKind::ConflictException(_inner) => Some(_inner),
            CreateUsagePlanKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUsagePlanKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateUsagePlanKeyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateUsagePlanKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateUsagePlanKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVpcLinkError {
    /// Kind of error that occurred.
    pub kind: CreateVpcLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVpcLinkErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVpcLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVpcLinkErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateVpcLinkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateVpcLinkErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateVpcLinkErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateVpcLinkErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateVpcLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVpcLinkError {
    fn code(&self) -> Option<&str> {
        CreateVpcLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVpcLinkError {
    /// Creates a new `CreateVpcLinkError`.
    pub fn new(kind: CreateVpcLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVpcLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVpcLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVpcLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVpcLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateVpcLinkErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateVpcLinkErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateVpcLinkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateVpcLinkErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateVpcLinkErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcLinkErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateVpcLinkErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcLinkErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateVpcLinkErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateVpcLinkErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateVpcLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVpcLinkErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateVpcLinkErrorKind::ConflictException(_inner) => Some(_inner),
            CreateVpcLinkErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateVpcLinkErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateVpcLinkErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateVpcLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApiKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteApiKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApiKeyErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApiKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApiKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApiKeyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteApiKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApiKeyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteApiKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteApiKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApiKeyError {
    fn code(&self) -> Option<&str> {
        DeleteApiKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApiKeyError {
    /// Creates a new `DeleteApiKeyError`.
    pub fn new(kind: DeleteApiKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApiKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApiKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApiKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApiKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteApiKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiKeyErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteApiKeyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiKeyErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteApiKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiKeyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteApiKeyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiKeyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteApiKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiKeyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteApiKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApiKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApiKeyErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteApiKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApiKeyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteApiKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteApiKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAuthorizerError {
    /// Kind of error that occurred.
    pub kind: DeleteAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAuthorizerErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAuthorizerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAuthorizerError {
    fn code(&self) -> Option<&str> {
        DeleteAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAuthorizerError {
    /// Creates a new `DeleteAuthorizerError`.
    pub fn new(kind: DeleteAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAuthorizerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAuthorizerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteAuthorizerErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteAuthorizerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAuthorizerErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteAuthorizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAuthorizerErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBasePathMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBasePathMappingError {
    /// Kind of error that occurred.
    pub kind: DeleteBasePathMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBasePathMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBasePathMappingErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBasePathMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBasePathMappingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBasePathMappingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBasePathMappingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBasePathMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteBasePathMappingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteBasePathMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBasePathMappingError {
    fn code(&self) -> Option<&str> {
        DeleteBasePathMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBasePathMappingError {
    /// Creates a new `DeleteBasePathMappingError`.
    pub fn new(kind: DeleteBasePathMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBasePathMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBasePathMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBasePathMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBasePathMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteBasePathMappingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBasePathMappingErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBasePathMappingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBasePathMappingErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBasePathMappingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBasePathMappingErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBasePathMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBasePathMappingErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBasePathMappingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBasePathMappingErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteBasePathMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBasePathMappingErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBasePathMappingErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBasePathMappingErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBasePathMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteBasePathMappingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteBasePathMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClientCertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteClientCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClientCertificateErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClientCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClientCertificateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteClientCertificateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteClientCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteClientCertificateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteClientCertificateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteClientCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClientCertificateError {
    fn code(&self) -> Option<&str> {
        DeleteClientCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClientCertificateError {
    /// Creates a new `DeleteClientCertificateError`.
    pub fn new(kind: DeleteClientCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClientCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClientCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClientCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClientCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteClientCertificateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClientCertificateErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteClientCertificateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClientCertificateErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteClientCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClientCertificateErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteClientCertificateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClientCertificateErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteClientCertificateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClientCertificateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteClientCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClientCertificateErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteClientCertificateErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteClientCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteClientCertificateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteClientCertificateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteClientCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeploymentError {
    /// Kind of error that occurred.
    pub kind: DeleteDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeploymentErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDeploymentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDeploymentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteDeploymentErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeploymentError {
    fn code(&self) -> Option<&str> {
        DeleteDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeploymentError {
    /// Creates a new `DeleteDeploymentError`.
    pub fn new(kind: DeleteDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeploymentErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeploymentErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteDeploymentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeploymentErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeploymentErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteDeploymentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeploymentErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDeploymentErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeploymentErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDeploymentErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDeploymentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteDeploymentErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDocumentationPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDocumentationPartError {
    /// Kind of error that occurred.
    pub kind: DeleteDocumentationPartErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDocumentationPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDocumentationPartErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDocumentationPartError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDocumentationPartErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDocumentationPartErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDocumentationPartErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDocumentationPartErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteDocumentationPartErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteDocumentationPartErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDocumentationPartError {
    fn code(&self) -> Option<&str> {
        DeleteDocumentationPartError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDocumentationPartError {
    /// Creates a new `DeleteDocumentationPartError`.
    pub fn new(kind: DeleteDocumentationPartErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDocumentationPartError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDocumentationPartErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDocumentationPartError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDocumentationPartErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDocumentationPartErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationPartErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDocumentationPartErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationPartErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDocumentationPartErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationPartErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDocumentationPartErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationPartErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDocumentationPartErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationPartErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteDocumentationPartError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDocumentationPartErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDocumentationPartErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDocumentationPartErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDocumentationPartErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteDocumentationPartErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteDocumentationPartErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDocumentationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDocumentationVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteDocumentationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDocumentationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDocumentationVersionErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDocumentationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDocumentationVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDocumentationVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDocumentationVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDocumentationVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteDocumentationVersionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteDocumentationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDocumentationVersionError {
    fn code(&self) -> Option<&str> {
        DeleteDocumentationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDocumentationVersionError {
    /// Creates a new `DeleteDocumentationVersionError`.
    pub fn new(kind: DeleteDocumentationVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDocumentationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDocumentationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDocumentationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDocumentationVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDocumentationVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDocumentationVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDocumentationVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDocumentationVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationVersionErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDocumentationVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentationVersionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteDocumentationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDocumentationVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDocumentationVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDocumentationVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDocumentationVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteDocumentationVersionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteDocumentationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainNameError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainNameErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainNameErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDomainNameErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDomainNameErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDomainNameErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteDomainNameErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteDomainNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainNameError {
    fn code(&self) -> Option<&str> {
        DeleteDomainNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainNameError {
    /// Creates a new `DeleteDomainNameError`.
    pub fn new(kind: DeleteDomainNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDomainNameErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainNameErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDomainNameErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainNameErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteDomainNameErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainNameErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteDomainNameErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainNameErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDomainNameErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainNameErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteDomainNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainNameErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDomainNameErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDomainNameErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDomainNameErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteDomainNameErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteDomainNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGatewayResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGatewayResponseError {
    /// Kind of error that occurred.
    pub kind: DeleteGatewayResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGatewayResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGatewayResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGatewayResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGatewayResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteGatewayResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteGatewayResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteGatewayResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteGatewayResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteGatewayResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGatewayResponseError {
    fn code(&self) -> Option<&str> {
        DeleteGatewayResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGatewayResponseError {
    /// Creates a new `DeleteGatewayResponseError`.
    pub fn new(kind: DeleteGatewayResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGatewayResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGatewayResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGatewayResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGatewayResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteGatewayResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGatewayResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGatewayResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGatewayResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGatewayResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteGatewayResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGatewayResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteGatewayResponseErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteGatewayResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteGatewayResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteGatewayResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteGatewayResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIntegrationError {
    /// Kind of error that occurred.
    pub kind: DeleteIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIntegrationErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIntegrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIntegrationError {
    fn code(&self) -> Option<&str> {
        DeleteIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIntegrationError {
    /// Creates a new `DeleteIntegrationError`.
    pub fn new(kind: DeleteIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntegrationErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntegrationErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIntegrationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIntegrationResponseError {
    /// Kind of error that occurred.
    pub kind: DeleteIntegrationResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIntegrationResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIntegrationResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIntegrationResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteIntegrationResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteIntegrationResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteIntegrationResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteIntegrationResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteIntegrationResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIntegrationResponseError {
    fn code(&self) -> Option<&str> {
        DeleteIntegrationResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIntegrationResponseError {
    /// Creates a new `DeleteIntegrationResponseError`.
    pub fn new(kind: DeleteIntegrationResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIntegrationResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIntegrationResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIntegrationResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIntegrationResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteIntegrationResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteIntegrationResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIntegrationResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteIntegrationResponseErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteIntegrationResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteIntegrationResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteIntegrationResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteIntegrationResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMethodError {
    /// Kind of error that occurred.
    pub kind: DeleteMethodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMethodErrorKind {
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMethodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMethodErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteMethodErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteMethodErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteMethodErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteMethodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMethodError {
    fn code(&self) -> Option<&str> {
        DeleteMethodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMethodError {
    /// Creates a new `DeleteMethodError`.
    pub fn new(kind: DeleteMethodErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMethodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMethodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMethodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMethodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteMethodErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteMethodErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteMethodErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteMethodErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteMethodErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMethodErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteMethodErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteMethodErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteMethodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMethodErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteMethodErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteMethodErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteMethodErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteMethodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMethodResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMethodResponseError {
    /// Kind of error that occurred.
    pub kind: DeleteMethodResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMethodResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMethodResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMethodResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMethodResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteMethodResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteMethodResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteMethodResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteMethodResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteMethodResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMethodResponseError {
    fn code(&self) -> Option<&str> {
        DeleteMethodResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMethodResponseError {
    /// Creates a new `DeleteMethodResponseError`.
    pub fn new(kind: DeleteMethodResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMethodResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMethodResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMethodResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMethodResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteMethodResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMethodResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteMethodResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMethodResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteMethodResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMethodResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteMethodResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMethodResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteMethodResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMethodResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteMethodResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMethodResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteMethodResponseErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteMethodResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteMethodResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteMethodResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteMethodResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteModelError {
    /// Kind of error that occurred.
    pub kind: DeleteModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteModelErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteModelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteModelError {
    fn code(&self) -> Option<&str> {
        DeleteModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteModelError {
    /// Creates a new `DeleteModelError`.
    pub fn new(kind: DeleteModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteModelErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteModelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteModelErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteModelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteModelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteModelErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRequestValidator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRequestValidatorError {
    /// Kind of error that occurred.
    pub kind: DeleteRequestValidatorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRequestValidator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRequestValidatorErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRequestValidatorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRequestValidatorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteRequestValidatorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRequestValidatorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRequestValidatorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteRequestValidatorErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteRequestValidatorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRequestValidatorError {
    fn code(&self) -> Option<&str> {
        DeleteRequestValidatorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRequestValidatorError {
    /// Creates a new `DeleteRequestValidatorError`.
    pub fn new(kind: DeleteRequestValidatorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRequestValidatorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRequestValidatorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRequestValidatorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRequestValidatorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRequestValidatorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRequestValidatorErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRequestValidatorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRequestValidatorErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRequestValidatorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRequestValidatorErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRequestValidatorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRequestValidatorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRequestValidatorErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRequestValidatorErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteRequestValidatorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRequestValidatorErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteRequestValidatorErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRequestValidatorErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRequestValidatorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteRequestValidatorErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteRequestValidatorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourceError {
    /// Kind of error that occurred.
    pub kind: DeleteResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourceErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourceError {
    fn code(&self) -> Option<&str> {
        DeleteResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourceError {
    /// Creates a new `DeleteResourceError`.
    pub fn new(kind: DeleteResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteResourceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRestApiError {
    /// Kind of error that occurred.
    pub kind: DeleteRestApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRestApiErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRestApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRestApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteRestApiErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRestApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRestApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteRestApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteRestApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRestApiError {
    fn code(&self) -> Option<&str> {
        DeleteRestApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRestApiError {
    /// Creates a new `DeleteRestApiError`.
    pub fn new(kind: DeleteRestApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRestApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRestApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRestApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRestApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRestApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteRestApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteRestApiErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteRestApiErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteRestApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteRestApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteRestApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRestApiErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRestApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteRestApiErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteRestApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRestApiErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteRestApiErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRestApiErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRestApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteRestApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteRestApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStageError {
    /// Kind of error that occurred.
    pub kind: DeleteStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStageErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStageError {
    fn code(&self) -> Option<&str> {
        DeleteStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStageError {
    /// Creates a new `DeleteStageError`.
    pub fn new(kind: DeleteStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteStageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteStageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteStageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `DeleteStageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteStageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStageErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStageErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStageErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteStageErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteStageErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteStageErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteStageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteStageErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUsagePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUsagePlanError {
    /// Kind of error that occurred.
    pub kind: DeleteUsagePlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUsagePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUsagePlanErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUsagePlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUsagePlanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteUsagePlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteUsagePlanErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteUsagePlanErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteUsagePlanErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteUsagePlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUsagePlanError {
    fn code(&self) -> Option<&str> {
        DeleteUsagePlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUsagePlanError {
    /// Creates a new `DeleteUsagePlanError`.
    pub fn new(kind: DeleteUsagePlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUsagePlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUsagePlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUsagePlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUsagePlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteUsagePlanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteUsagePlanErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteUsagePlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteUsagePlanErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteUsagePlanErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteUsagePlanErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteUsagePlanErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsagePlanErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteUsagePlanErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsagePlanErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteUsagePlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUsagePlanErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteUsagePlanErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteUsagePlanErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteUsagePlanErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteUsagePlanErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteUsagePlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUsagePlanKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUsagePlanKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteUsagePlanKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUsagePlanKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUsagePlanKeyErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUsagePlanKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUsagePlanKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteUsagePlanKeyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteUsagePlanKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteUsagePlanKeyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteUsagePlanKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteUsagePlanKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUsagePlanKeyError {
    fn code(&self) -> Option<&str> {
        DeleteUsagePlanKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUsagePlanKeyError {
    /// Creates a new `DeleteUsagePlanKeyError`.
    pub fn new(kind: DeleteUsagePlanKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUsagePlanKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUsagePlanKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUsagePlanKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUsagePlanKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteUsagePlanKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsagePlanKeyErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteUsagePlanKeyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsagePlanKeyErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteUsagePlanKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsagePlanKeyErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteUsagePlanKeyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsagePlanKeyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteUsagePlanKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsagePlanKeyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteUsagePlanKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUsagePlanKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteUsagePlanKeyErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteUsagePlanKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteUsagePlanKeyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteUsagePlanKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteUsagePlanKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVpcLinkError {
    /// Kind of error that occurred.
    pub kind: DeleteVpcLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVpcLinkErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVpcLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVpcLinkErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVpcLinkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteVpcLinkErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVpcLinkErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteVpcLinkErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteVpcLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVpcLinkError {
    fn code(&self) -> Option<&str> {
        DeleteVpcLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVpcLinkError {
    /// Creates a new `DeleteVpcLinkError`.
    pub fn new(kind: DeleteVpcLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVpcLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVpcLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVpcLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVpcLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteVpcLinkErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteVpcLinkErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteVpcLinkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteVpcLinkErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteVpcLinkErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteVpcLinkErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteVpcLinkErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcLinkErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteVpcLinkErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteVpcLinkErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteVpcLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVpcLinkErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVpcLinkErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteVpcLinkErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVpcLinkErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteVpcLinkErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteVpcLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `FlushStageAuthorizersCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FlushStageAuthorizersCacheError {
    /// Kind of error that occurred.
    pub kind: FlushStageAuthorizersCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FlushStageAuthorizersCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FlushStageAuthorizersCacheErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FlushStageAuthorizersCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FlushStageAuthorizersCacheErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            FlushStageAuthorizersCacheErrorKind::ConflictException(_inner) => _inner.fmt(f),
            FlushStageAuthorizersCacheErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            FlushStageAuthorizersCacheErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            FlushStageAuthorizersCacheErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            FlushStageAuthorizersCacheErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            FlushStageAuthorizersCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FlushStageAuthorizersCacheError {
    fn code(&self) -> Option<&str> {
        FlushStageAuthorizersCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FlushStageAuthorizersCacheError {
    /// Creates a new `FlushStageAuthorizersCacheError`.
    pub fn new(kind: FlushStageAuthorizersCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FlushStageAuthorizersCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FlushStageAuthorizersCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FlushStageAuthorizersCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FlushStageAuthorizersCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `FlushStageAuthorizersCacheErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushStageAuthorizersCacheErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `FlushStageAuthorizersCacheErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushStageAuthorizersCacheErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `FlushStageAuthorizersCacheErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushStageAuthorizersCacheErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `FlushStageAuthorizersCacheErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushStageAuthorizersCacheErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `FlushStageAuthorizersCacheErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushStageAuthorizersCacheErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `FlushStageAuthorizersCacheErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushStageAuthorizersCacheErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for FlushStageAuthorizersCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FlushStageAuthorizersCacheErrorKind::BadRequestException(_inner) => Some(_inner),
            FlushStageAuthorizersCacheErrorKind::ConflictException(_inner) => Some(_inner),
            FlushStageAuthorizersCacheErrorKind::LimitExceededException(_inner) => Some(_inner),
            FlushStageAuthorizersCacheErrorKind::NotFoundException(_inner) => Some(_inner),
            FlushStageAuthorizersCacheErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            FlushStageAuthorizersCacheErrorKind::UnauthorizedException(_inner) => Some(_inner),
            FlushStageAuthorizersCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `FlushStageCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FlushStageCacheError {
    /// Kind of error that occurred.
    pub kind: FlushStageCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FlushStageCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FlushStageCacheErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FlushStageCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FlushStageCacheErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            FlushStageCacheErrorKind::ConflictException(_inner) => _inner.fmt(f),
            FlushStageCacheErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            FlushStageCacheErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            FlushStageCacheErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            FlushStageCacheErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            FlushStageCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FlushStageCacheError {
    fn code(&self) -> Option<&str> {
        FlushStageCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FlushStageCacheError {
    /// Creates a new `FlushStageCacheError`.
    pub fn new(kind: FlushStageCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FlushStageCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FlushStageCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FlushStageCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FlushStageCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `FlushStageCacheErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, FlushStageCacheErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `FlushStageCacheErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, FlushStageCacheErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `FlushStageCacheErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushStageCacheErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `FlushStageCacheErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, FlushStageCacheErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `FlushStageCacheErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushStageCacheErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `FlushStageCacheErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushStageCacheErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for FlushStageCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FlushStageCacheErrorKind::BadRequestException(_inner) => Some(_inner),
            FlushStageCacheErrorKind::ConflictException(_inner) => Some(_inner),
            FlushStageCacheErrorKind::LimitExceededException(_inner) => Some(_inner),
            FlushStageCacheErrorKind::NotFoundException(_inner) => Some(_inner),
            FlushStageCacheErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            FlushStageCacheErrorKind::UnauthorizedException(_inner) => Some(_inner),
            FlushStageCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateClientCertificateError {
    /// Kind of error that occurred.
    pub kind: GenerateClientCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateClientCertificateErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateClientCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateClientCertificateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GenerateClientCertificateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GenerateClientCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GenerateClientCertificateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GenerateClientCertificateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GenerateClientCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateClientCertificateError {
    fn code(&self) -> Option<&str> {
        GenerateClientCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateClientCertificateError {
    /// Creates a new `GenerateClientCertificateError`.
    pub fn new(kind: GenerateClientCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateClientCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateClientCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateClientCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateClientCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GenerateClientCertificateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateClientCertificateErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GenerateClientCertificateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateClientCertificateErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `GenerateClientCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateClientCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GenerateClientCertificateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateClientCertificateErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GenerateClientCertificateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateClientCertificateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GenerateClientCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateClientCertificateErrorKind::BadRequestException(_inner) => Some(_inner),
            GenerateClientCertificateErrorKind::ConflictException(_inner) => Some(_inner),
            GenerateClientCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            GenerateClientCertificateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GenerateClientCertificateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GenerateClientCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountError {
    /// Kind of error that occurred.
    pub kind: GetAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountError {
    fn code(&self) -> Option<&str> {
        GetAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountError {
    /// Creates a new `GetAccountError`.
    pub fn new(kind: GetAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetAccountErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetAccountErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAccountErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAccountErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAccountErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApiKeyError {
    /// Kind of error that occurred.
    pub kind: GetApiKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApiKeyErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApiKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApiKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApiKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApiKeyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApiKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetApiKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApiKeyError {
    fn code(&self) -> Option<&str> {
        GetApiKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApiKeyError {
    /// Creates a new `GetApiKeyError`.
    pub fn new(kind: GetApiKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApiKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApiKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApiKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApiKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetApiKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetApiKeyErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetApiKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetApiKeyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetApiKeyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetApiKeyErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetApiKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetApiKeyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetApiKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApiKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApiKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApiKeyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApiKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetApiKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApiKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApiKeysError {
    /// Kind of error that occurred.
    pub kind: GetApiKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApiKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApiKeysErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApiKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApiKeysErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApiKeysErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApiKeysErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApiKeysErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetApiKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApiKeysError {
    fn code(&self) -> Option<&str> {
        GetApiKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApiKeysError {
    /// Creates a new `GetApiKeysError`.
    pub fn new(kind: GetApiKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApiKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApiKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApiKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApiKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetApiKeysErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetApiKeysErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetApiKeysErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetApiKeysErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetApiKeysErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetApiKeysErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetApiKeysErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetApiKeysErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetApiKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApiKeysErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApiKeysErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApiKeysErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApiKeysErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetApiKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAuthorizerError {
    /// Kind of error that occurred.
    pub kind: GetAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAuthorizerErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAuthorizerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAuthorizerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAuthorizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAuthorizerError {
    fn code(&self) -> Option<&str> {
        GetAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAuthorizerError {
    /// Creates a new `GetAuthorizerError`.
    pub fn new(kind: GetAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAuthorizerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAuthorizerErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetAuthorizerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAuthorizerErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetAuthorizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizerErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetAuthorizerErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAuthorizerErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAuthorizerErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAuthorizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAuthorizers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAuthorizersError {
    /// Kind of error that occurred.
    pub kind: GetAuthorizersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAuthorizers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAuthorizersErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAuthorizersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAuthorizersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAuthorizersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAuthorizersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAuthorizersErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetAuthorizersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAuthorizersError {
    fn code(&self) -> Option<&str> {
        GetAuthorizersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAuthorizersError {
    /// Creates a new `GetAuthorizersError`.
    pub fn new(kind: GetAuthorizersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAuthorizersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAuthorizersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAuthorizersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAuthorizersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAuthorizersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAuthorizersErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetAuthorizersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAuthorizersErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetAuthorizersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizersErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetAuthorizersErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizersErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetAuthorizersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAuthorizersErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAuthorizersErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAuthorizersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAuthorizersErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetAuthorizersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBasePathMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBasePathMappingError {
    /// Kind of error that occurred.
    pub kind: GetBasePathMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBasePathMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBasePathMappingErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBasePathMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBasePathMappingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBasePathMappingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBasePathMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetBasePathMappingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetBasePathMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBasePathMappingError {
    fn code(&self) -> Option<&str> {
        GetBasePathMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBasePathMappingError {
    /// Creates a new `GetBasePathMappingError`.
    pub fn new(kind: GetBasePathMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBasePathMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBasePathMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBasePathMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBasePathMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetBasePathMappingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBasePathMappingErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetBasePathMappingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBasePathMappingErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetBasePathMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBasePathMappingErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetBasePathMappingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBasePathMappingErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetBasePathMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBasePathMappingErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBasePathMappingErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBasePathMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetBasePathMappingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetBasePathMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBasePathMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBasePathMappingsError {
    /// Kind of error that occurred.
    pub kind: GetBasePathMappingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBasePathMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBasePathMappingsErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBasePathMappingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBasePathMappingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBasePathMappingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBasePathMappingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetBasePathMappingsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetBasePathMappingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBasePathMappingsError {
    fn code(&self) -> Option<&str> {
        GetBasePathMappingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBasePathMappingsError {
    /// Creates a new `GetBasePathMappingsError`.
    pub fn new(kind: GetBasePathMappingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBasePathMappingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBasePathMappingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBasePathMappingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBasePathMappingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetBasePathMappingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBasePathMappingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetBasePathMappingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBasePathMappingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetBasePathMappingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBasePathMappingsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetBasePathMappingsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBasePathMappingsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetBasePathMappingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBasePathMappingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBasePathMappingsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBasePathMappingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetBasePathMappingsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetBasePathMappingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetClientCertificateError {
    /// Kind of error that occurred.
    pub kind: GetClientCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetClientCertificateErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetClientCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetClientCertificateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetClientCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetClientCertificateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetClientCertificateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetClientCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetClientCertificateError {
    fn code(&self) -> Option<&str> {
        GetClientCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetClientCertificateError {
    /// Creates a new `GetClientCertificateError`.
    pub fn new(kind: GetClientCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetClientCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetClientCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetClientCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetClientCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetClientCertificateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClientCertificateErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetClientCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClientCertificateErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetClientCertificateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClientCertificateErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetClientCertificateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClientCertificateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetClientCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetClientCertificateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetClientCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetClientCertificateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetClientCertificateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetClientCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetClientCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetClientCertificatesError {
    /// Kind of error that occurred.
    pub kind: GetClientCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetClientCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetClientCertificatesErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetClientCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetClientCertificatesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetClientCertificatesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetClientCertificatesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetClientCertificatesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetClientCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetClientCertificatesError {
    fn code(&self) -> Option<&str> {
        GetClientCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetClientCertificatesError {
    /// Creates a new `GetClientCertificatesError`.
    pub fn new(kind: GetClientCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetClientCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetClientCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetClientCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetClientCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetClientCertificatesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClientCertificatesErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetClientCertificatesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClientCertificatesErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetClientCertificatesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClientCertificatesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetClientCertificatesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClientCertificatesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetClientCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetClientCertificatesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetClientCertificatesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetClientCertificatesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetClientCertificatesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetClientCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeploymentError {
    /// Kind of error that occurred.
    pub kind: GetDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeploymentErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested service is not available. For details see the accompanying error message. Retry after the specified time period.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeploymentError {
    fn code(&self) -> Option<&str> {
        GetDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeploymentError {
    /// Creates a new `GetDeploymentError`.
    pub fn new(kind: GetDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDeploymentErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetDeploymentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetDeploymentErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDeploymentErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetDeploymentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDeploymentErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeploymentsError {
    /// Kind of error that occurred.
    pub kind: GetDeploymentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeploymentsErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested service is not available. For details see the accompanying error message. Retry after the specified time period.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeploymentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeploymentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDeploymentsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDeploymentsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetDeploymentsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDeploymentsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDeploymentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeploymentsError {
    fn code(&self) -> Option<&str> {
        GetDeploymentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeploymentsError {
    /// Creates a new `GetDeploymentsError`.
    pub fn new(kind: GetDeploymentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeploymentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeploymentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeploymentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeploymentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDeploymentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetDeploymentsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDeploymentsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetDeploymentsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetDeploymentsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetDeploymentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeploymentsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDeploymentsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDeploymentsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetDeploymentsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDeploymentsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDeploymentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDocumentationPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDocumentationPartError {
    /// Kind of error that occurred.
    pub kind: GetDocumentationPartErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDocumentationPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDocumentationPartErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDocumentationPartError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDocumentationPartErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDocumentationPartErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDocumentationPartErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDocumentationPartErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDocumentationPartErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDocumentationPartError {
    fn code(&self) -> Option<&str> {
        GetDocumentationPartError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDocumentationPartError {
    /// Creates a new `GetDocumentationPartError`.
    pub fn new(kind: GetDocumentationPartErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDocumentationPartError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDocumentationPartErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDocumentationPartError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDocumentationPartErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDocumentationPartErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationPartErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationPartErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationPartErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationPartErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationPartErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationPartErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationPartErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetDocumentationPartError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDocumentationPartErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDocumentationPartErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDocumentationPartErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDocumentationPartErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDocumentationPartErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDocumentationParts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDocumentationPartsError {
    /// Kind of error that occurred.
    pub kind: GetDocumentationPartsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDocumentationParts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDocumentationPartsErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDocumentationPartsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDocumentationPartsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDocumentationPartsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDocumentationPartsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDocumentationPartsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDocumentationPartsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDocumentationPartsError {
    fn code(&self) -> Option<&str> {
        GetDocumentationPartsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDocumentationPartsError {
    /// Creates a new `GetDocumentationPartsError`.
    pub fn new(kind: GetDocumentationPartsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDocumentationPartsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDocumentationPartsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDocumentationPartsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDocumentationPartsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDocumentationPartsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationPartsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationPartsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationPartsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationPartsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationPartsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationPartsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationPartsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetDocumentationPartsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDocumentationPartsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDocumentationPartsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDocumentationPartsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDocumentationPartsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDocumentationPartsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDocumentationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDocumentationVersionError {
    /// Kind of error that occurred.
    pub kind: GetDocumentationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDocumentationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDocumentationVersionErrorKind {
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDocumentationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDocumentationVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDocumentationVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDocumentationVersionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDocumentationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDocumentationVersionError {
    fn code(&self) -> Option<&str> {
        GetDocumentationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDocumentationVersionError {
    /// Creates a new `GetDocumentationVersionError`.
    pub fn new(kind: GetDocumentationVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDocumentationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDocumentationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDocumentationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDocumentationVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDocumentationVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationVersionErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationVersionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetDocumentationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDocumentationVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDocumentationVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDocumentationVersionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDocumentationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDocumentationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDocumentationVersionsError {
    /// Kind of error that occurred.
    pub kind: GetDocumentationVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDocumentationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDocumentationVersionsErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDocumentationVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDocumentationVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDocumentationVersionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDocumentationVersionsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDocumentationVersionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDocumentationVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDocumentationVersionsError {
    fn code(&self) -> Option<&str> {
        GetDocumentationVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDocumentationVersionsError {
    /// Creates a new `GetDocumentationVersionsError`.
    pub fn new(kind: GetDocumentationVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDocumentationVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDocumentationVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDocumentationVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDocumentationVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDocumentationVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationVersionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationVersionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationVersionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationVersionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationVersionsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetDocumentationVersionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDocumentationVersionsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetDocumentationVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDocumentationVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDocumentationVersionsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDocumentationVersionsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDocumentationVersionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDocumentationVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainNameError {
    /// Kind of error that occurred.
    pub kind: GetDomainNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainNameErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainNameErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDomainNameErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDomainNameErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDomainNameErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDomainNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainNameError {
    fn code(&self) -> Option<&str> {
        GetDomainNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainNameError {
    /// Creates a new `GetDomainNameError`.
    pub fn new(kind: GetDomainNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDomainNameErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDomainNameErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetDomainNameErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDomainNameErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDomainNameErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainNameErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetDomainNameErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetDomainNameErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetDomainNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainNameErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDomainNameErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDomainNameErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDomainNameErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDomainNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainNamesError {
    /// Kind of error that occurred.
    pub kind: GetDomainNamesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainNamesErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainNamesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainNamesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDomainNamesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDomainNamesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDomainNamesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDomainNamesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainNamesError {
    fn code(&self) -> Option<&str> {
        GetDomainNamesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainNamesError {
    /// Creates a new `GetDomainNamesError`.
    pub fn new(kind: GetDomainNamesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainNamesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainNamesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainNamesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainNamesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDomainNamesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDomainNamesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetDomainNamesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDomainNamesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDomainNamesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainNamesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetDomainNamesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainNamesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetDomainNamesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainNamesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDomainNamesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDomainNamesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDomainNamesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDomainNamesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExportError {
    /// Kind of error that occurred.
    pub kind: GetExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExportErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExportErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetExportErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetExportErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetExportErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetExportErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetExportErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExportError {
    fn code(&self) -> Option<&str> {
        GetExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExportError {
    /// Creates a new `GetExportError`.
    pub fn new(kind: GetExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetExportErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetExportErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetExportErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetExportErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetExportErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetExportErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExportErrorKind::BadRequestException(_inner) => Some(_inner),
            GetExportErrorKind::ConflictException(_inner) => Some(_inner),
            GetExportErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetExportErrorKind::NotFoundException(_inner) => Some(_inner),
            GetExportErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetExportErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGatewayResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGatewayResponseError {
    /// Kind of error that occurred.
    pub kind: GetGatewayResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGatewayResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGatewayResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGatewayResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGatewayResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetGatewayResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGatewayResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetGatewayResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetGatewayResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGatewayResponseError {
    fn code(&self) -> Option<&str> {
        GetGatewayResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGatewayResponseError {
    /// Creates a new `GetGatewayResponseError`.
    pub fn new(kind: GetGatewayResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGatewayResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGatewayResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGatewayResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGatewayResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetGatewayResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGatewayResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetGatewayResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGatewayResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetGatewayResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGatewayResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetGatewayResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGatewayResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetGatewayResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGatewayResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            GetGatewayResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGatewayResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetGatewayResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetGatewayResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGatewayResponses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGatewayResponsesError {
    /// Kind of error that occurred.
    pub kind: GetGatewayResponsesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGatewayResponses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGatewayResponsesErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGatewayResponsesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGatewayResponsesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetGatewayResponsesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGatewayResponsesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetGatewayResponsesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetGatewayResponsesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGatewayResponsesError {
    fn code(&self) -> Option<&str> {
        GetGatewayResponsesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGatewayResponsesError {
    /// Creates a new `GetGatewayResponsesError`.
    pub fn new(kind: GetGatewayResponsesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGatewayResponsesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGatewayResponsesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGatewayResponsesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGatewayResponsesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetGatewayResponsesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGatewayResponsesErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetGatewayResponsesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGatewayResponsesErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetGatewayResponsesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGatewayResponsesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetGatewayResponsesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGatewayResponsesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetGatewayResponsesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGatewayResponsesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetGatewayResponsesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGatewayResponsesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetGatewayResponsesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetGatewayResponsesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntegrationError {
    /// Kind of error that occurred.
    pub kind: GetIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntegrationErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntegrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntegrationError {
    fn code(&self) -> Option<&str> {
        GetIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntegrationError {
    /// Creates a new `GetIntegrationError`.
    pub fn new(kind: GetIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetIntegrationErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetIntegrationErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntegrationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetIntegrationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntegrationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetIntegrationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntegrationResponseError {
    /// Kind of error that occurred.
    pub kind: GetIntegrationResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntegrationResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntegrationResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntegrationResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetIntegrationResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntegrationResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetIntegrationResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetIntegrationResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntegrationResponseError {
    fn code(&self) -> Option<&str> {
        GetIntegrationResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntegrationResponseError {
    /// Creates a new `GetIntegrationResponseError`.
    pub fn new(kind: GetIntegrationResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntegrationResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntegrationResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntegrationResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntegrationResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetIntegrationResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetIntegrationResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntegrationResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            GetIntegrationResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntegrationResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetIntegrationResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetIntegrationResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMethodError {
    /// Kind of error that occurred.
    pub kind: GetMethodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMethodErrorKind {
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMethodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMethodErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetMethodErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetMethodErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetMethodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMethodError {
    fn code(&self) -> Option<&str> {
        GetMethodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMethodError {
    /// Creates a new `GetMethodError`.
    pub fn new(kind: GetMethodErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMethodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMethodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMethodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMethodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetMethodErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetMethodErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetMethodErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetMethodErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetMethodErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetMethodErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetMethodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMethodErrorKind::NotFoundException(_inner) => Some(_inner),
            GetMethodErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetMethodErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetMethodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMethodResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMethodResponseError {
    /// Kind of error that occurred.
    pub kind: GetMethodResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMethodResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMethodResponseErrorKind {
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMethodResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMethodResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetMethodResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetMethodResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetMethodResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMethodResponseError {
    fn code(&self) -> Option<&str> {
        GetMethodResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMethodResponseError {
    /// Creates a new `GetMethodResponseError`.
    pub fn new(kind: GetMethodResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMethodResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMethodResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMethodResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMethodResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetMethodResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetMethodResponseErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetMethodResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMethodResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetMethodResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMethodResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetMethodResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMethodResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            GetMethodResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetMethodResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetMethodResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetModelError {
    /// Kind of error that occurred.
    pub kind: GetModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetModelErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetModelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetModelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetModelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetModelErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetModelError {
    fn code(&self) -> Option<&str> {
        GetModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetModelError {
    /// Creates a new `GetModelError`.
    pub fn new(kind: GetModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetModelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetModelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetModelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetModelErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetModelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetModelErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetModelErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetModelErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetModelErrorKind::BadRequestException(_inner) => Some(_inner),
            GetModelErrorKind::NotFoundException(_inner) => Some(_inner),
            GetModelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetModelErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetModelsError {
    /// Kind of error that occurred.
    pub kind: GetModelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetModelsErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetModelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetModelsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetModelsError {
    fn code(&self) -> Option<&str> {
        GetModelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetModelsError {
    /// Creates a new `GetModelsError`.
    pub fn new(kind: GetModelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetModelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetModelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetModelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetModelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetModelsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetModelsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetModelsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetModelsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetModelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetModelsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetModelsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetModelsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetModelsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetModelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetModelTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetModelTemplateError {
    /// Kind of error that occurred.
    pub kind: GetModelTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetModelTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetModelTemplateErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetModelTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetModelTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetModelTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetModelTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetModelTemplateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetModelTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetModelTemplateError {
    fn code(&self) -> Option<&str> {
        GetModelTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetModelTemplateError {
    /// Creates a new `GetModelTemplateError`.
    pub fn new(kind: GetModelTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetModelTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetModelTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetModelTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetModelTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetModelTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetModelTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetModelTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetModelTemplateErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetModelTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetModelTemplateErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetModelTemplateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetModelTemplateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetModelTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetModelTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetModelTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetModelTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetModelTemplateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetModelTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRequestValidator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRequestValidatorError {
    /// Kind of error that occurred.
    pub kind: GetRequestValidatorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRequestValidator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRequestValidatorErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRequestValidatorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRequestValidatorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRequestValidatorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRequestValidatorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetRequestValidatorErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetRequestValidatorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRequestValidatorError {
    fn code(&self) -> Option<&str> {
        GetRequestValidatorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRequestValidatorError {
    /// Creates a new `GetRequestValidatorError`.
    pub fn new(kind: GetRequestValidatorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRequestValidatorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRequestValidatorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRequestValidatorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRequestValidatorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRequestValidatorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestValidatorErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetRequestValidatorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestValidatorErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetRequestValidatorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestValidatorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetRequestValidatorErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestValidatorErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetRequestValidatorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRequestValidatorErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRequestValidatorErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRequestValidatorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRequestValidatorErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetRequestValidatorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRequestValidators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRequestValidatorsError {
    /// Kind of error that occurred.
    pub kind: GetRequestValidatorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRequestValidators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRequestValidatorsErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRequestValidatorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRequestValidatorsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRequestValidatorsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRequestValidatorsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetRequestValidatorsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetRequestValidatorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRequestValidatorsError {
    fn code(&self) -> Option<&str> {
        GetRequestValidatorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRequestValidatorsError {
    /// Creates a new `GetRequestValidatorsError`.
    pub fn new(kind: GetRequestValidatorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRequestValidatorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRequestValidatorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRequestValidatorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRequestValidatorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRequestValidatorsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestValidatorsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetRequestValidatorsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestValidatorsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetRequestValidatorsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestValidatorsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetRequestValidatorsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestValidatorsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetRequestValidatorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRequestValidatorsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRequestValidatorsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRequestValidatorsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRequestValidatorsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetRequestValidatorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceError {
    /// Kind of error that occurred.
    pub kind: GetResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceErrorKind {
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceError {
    fn code(&self) -> Option<&str> {
        GetResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceError {
    /// Creates a new `GetResourceError`.
    pub fn new(kind: GetResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetResourceErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            GetResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourcesError {
    /// Kind of error that occurred.
    pub kind: GetResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourcesErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourcesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetResourcesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetResourcesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetResourcesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourcesError {
    fn code(&self) -> Option<&str> {
        GetResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourcesError {
    /// Creates a new `GetResourcesError`.
    pub fn new(kind: GetResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetResourcesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetResourcesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetResourcesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetResourcesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetResourcesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetResourcesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetResourcesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourcesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetResourcesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetResourcesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetResourcesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRestApiError {
    /// Kind of error that occurred.
    pub kind: GetRestApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRestApiErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRestApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRestApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRestApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRestApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetRestApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetRestApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRestApiError {
    fn code(&self) -> Option<&str> {
        GetRestApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRestApiError {
    /// Creates a new `GetRestApiError`.
    pub fn new(kind: GetRestApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRestApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRestApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRestApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRestApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRestApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetRestApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetRestApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRestApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetRestApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetRestApiErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetRestApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetRestApiErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetRestApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRestApiErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRestApiErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRestApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRestApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetRestApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRestApis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRestApisError {
    /// Kind of error that occurred.
    pub kind: GetRestApisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRestApis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRestApisErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRestApisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRestApisErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRestApisErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRestApisErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetRestApisErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetRestApisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRestApisError {
    fn code(&self) -> Option<&str> {
        GetRestApisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRestApisError {
    /// Creates a new `GetRestApisError`.
    pub fn new(kind: GetRestApisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRestApisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRestApisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRestApisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRestApisErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRestApisErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetRestApisErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetRestApisErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRestApisErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetRestApisErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRestApisErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetRestApisErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetRestApisErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetRestApisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRestApisErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRestApisErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRestApisErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetRestApisErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetRestApisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSdk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSdkError {
    /// Kind of error that occurred.
    pub kind: GetSdkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSdk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSdkErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSdkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSdkErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSdkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetSdkErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetSdkErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSdkErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSdkErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetSdkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSdkError {
    fn code(&self) -> Option<&str> {
        GetSdkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSdkError {
    /// Creates a new `GetSdkError`.
    pub fn new(kind: GetSdkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSdkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSdkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSdkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSdkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSdkErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSdkErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetSdkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetSdkErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetSdkErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetSdkErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetSdkErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSdkErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetSdkErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetSdkErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetSdkErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetSdkErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetSdkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSdkErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSdkErrorKind::ConflictException(_inner) => Some(_inner),
            GetSdkErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetSdkErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSdkErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSdkErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetSdkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSdkType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSdkTypeError {
    /// Kind of error that occurred.
    pub kind: GetSdkTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSdkType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSdkTypeErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSdkTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSdkTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSdkTypeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSdkTypeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSdkTypeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetSdkTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSdkTypeError {
    fn code(&self) -> Option<&str> {
        GetSdkTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSdkTypeError {
    /// Creates a new `GetSdkTypeError`.
    pub fn new(kind: GetSdkTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSdkTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSdkTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSdkTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSdkTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSdkTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSdkTypeErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetSdkTypeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSdkTypeErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetSdkTypeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetSdkTypeErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetSdkTypeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetSdkTypeErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetSdkTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSdkTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSdkTypeErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSdkTypeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSdkTypeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetSdkTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSdkTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSdkTypesError {
    /// Kind of error that occurred.
    pub kind: GetSdkTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSdkTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSdkTypesErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSdkTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSdkTypesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSdkTypesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSdkTypesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSdkTypesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetSdkTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSdkTypesError {
    fn code(&self) -> Option<&str> {
        GetSdkTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSdkTypesError {
    /// Creates a new `GetSdkTypesError`.
    pub fn new(kind: GetSdkTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSdkTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSdkTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSdkTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSdkTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSdkTypesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSdkTypesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetSdkTypesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSdkTypesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetSdkTypesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSdkTypesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetSdkTypesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetSdkTypesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetSdkTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSdkTypesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSdkTypesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSdkTypesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSdkTypesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetSdkTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStageError {
    /// Kind of error that occurred.
    pub kind: GetStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStageErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetStageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetStageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetStageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetStageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetStageErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStageError {
    fn code(&self) -> Option<&str> {
        GetStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStageError {
    /// Creates a new `GetStageError`.
    pub fn new(kind: GetStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetStageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetStageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetStageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetStageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetStageErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStageErrorKind::BadRequestException(_inner) => Some(_inner),
            GetStageErrorKind::ConflictException(_inner) => Some(_inner),
            GetStageErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetStageErrorKind::NotFoundException(_inner) => Some(_inner),
            GetStageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetStageErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStagesError {
    /// Kind of error that occurred.
    pub kind: GetStagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStagesErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStagesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetStagesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetStagesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetStagesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetStagesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetStagesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetStagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStagesError {
    fn code(&self) -> Option<&str> {
        GetStagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStagesError {
    /// Creates a new `GetStagesError`.
    pub fn new(kind: GetStagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStagesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetStagesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetStagesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetStagesErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `GetStagesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetStagesErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetStagesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetStagesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetStagesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetStagesErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetStagesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetStagesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetStagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStagesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetStagesErrorKind::ConflictException(_inner) => Some(_inner),
            GetStagesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetStagesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetStagesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetStagesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetStagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTagsError {
    /// Kind of error that occurred.
    pub kind: GetTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTagsErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTagsError {
    fn code(&self) -> Option<&str> {
        GetTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTagsError {
    /// Creates a new `GetTagsError`.
    pub fn new(kind: GetTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetTagsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetTagsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUsageError {
    /// Kind of error that occurred.
    pub kind: GetUsageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUsageErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUsageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUsageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUsageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetUsageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetUsageErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetUsageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUsageError {
    fn code(&self) -> Option<&str> {
        GetUsageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUsageError {
    /// Creates a new `GetUsageError`.
    pub fn new(kind: GetUsageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUsageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUsageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUsageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUsageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetUsageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetUsageErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetUsageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUsageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetUsageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetUsageErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetUsageErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetUsageErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetUsageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUsageErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUsageErrorKind::NotFoundException(_inner) => Some(_inner),
            GetUsageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetUsageErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetUsageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUsagePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUsagePlanError {
    /// Kind of error that occurred.
    pub kind: GetUsagePlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUsagePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUsagePlanErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUsagePlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUsagePlanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUsagePlanErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetUsagePlanErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetUsagePlanErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetUsagePlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUsagePlanError {
    fn code(&self) -> Option<&str> {
        GetUsagePlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUsagePlanError {
    /// Creates a new `GetUsagePlanError`.
    pub fn new(kind: GetUsagePlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUsagePlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUsagePlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUsagePlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUsagePlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetUsagePlanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetUsagePlanErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetUsagePlanErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUsagePlanErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetUsagePlanErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsagePlanErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetUsagePlanErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetUsagePlanErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetUsagePlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUsagePlanErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUsagePlanErrorKind::NotFoundException(_inner) => Some(_inner),
            GetUsagePlanErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetUsagePlanErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetUsagePlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUsagePlanKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUsagePlanKeyError {
    /// Kind of error that occurred.
    pub kind: GetUsagePlanKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUsagePlanKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUsagePlanKeyErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUsagePlanKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUsagePlanKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUsagePlanKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetUsagePlanKeyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetUsagePlanKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetUsagePlanKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUsagePlanKeyError {
    fn code(&self) -> Option<&str> {
        GetUsagePlanKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUsagePlanKeyError {
    /// Creates a new `GetUsagePlanKeyError`.
    pub fn new(kind: GetUsagePlanKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUsagePlanKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUsagePlanKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUsagePlanKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUsagePlanKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetUsagePlanKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetUsagePlanKeyErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetUsagePlanKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUsagePlanKeyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetUsagePlanKeyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsagePlanKeyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetUsagePlanKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsagePlanKeyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetUsagePlanKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUsagePlanKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUsagePlanKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            GetUsagePlanKeyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetUsagePlanKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetUsagePlanKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUsagePlanKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUsagePlanKeysError {
    /// Kind of error that occurred.
    pub kind: GetUsagePlanKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUsagePlanKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUsagePlanKeysErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUsagePlanKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUsagePlanKeysErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUsagePlanKeysErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetUsagePlanKeysErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetUsagePlanKeysErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetUsagePlanKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUsagePlanKeysError {
    fn code(&self) -> Option<&str> {
        GetUsagePlanKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUsagePlanKeysError {
    /// Creates a new `GetUsagePlanKeysError`.
    pub fn new(kind: GetUsagePlanKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUsagePlanKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUsagePlanKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUsagePlanKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUsagePlanKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetUsagePlanKeysErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsagePlanKeysErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetUsagePlanKeysErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUsagePlanKeysErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetUsagePlanKeysErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsagePlanKeysErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetUsagePlanKeysErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsagePlanKeysErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetUsagePlanKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUsagePlanKeysErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUsagePlanKeysErrorKind::NotFoundException(_inner) => Some(_inner),
            GetUsagePlanKeysErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetUsagePlanKeysErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetUsagePlanKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUsagePlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUsagePlansError {
    /// Kind of error that occurred.
    pub kind: GetUsagePlansErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUsagePlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUsagePlansErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUsagePlansError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUsagePlansErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUsagePlansErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetUsagePlansErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetUsagePlansErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetUsagePlansErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUsagePlansError {
    fn code(&self) -> Option<&str> {
        GetUsagePlansError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUsagePlansError {
    /// Creates a new `GetUsagePlansError`.
    pub fn new(kind: GetUsagePlansErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUsagePlansError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUsagePlansErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUsagePlansError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUsagePlansErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetUsagePlansErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetUsagePlansErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetUsagePlansErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUsagePlansErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetUsagePlansErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsagePlansErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetUsagePlansErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetUsagePlansErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetUsagePlansError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUsagePlansErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUsagePlansErrorKind::NotFoundException(_inner) => Some(_inner),
            GetUsagePlansErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetUsagePlansErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetUsagePlansErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVpcLinkError {
    /// Kind of error that occurred.
    pub kind: GetVpcLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVpcLinkErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVpcLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVpcLinkErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVpcLinkErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVpcLinkErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetVpcLinkErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetVpcLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVpcLinkError {
    fn code(&self) -> Option<&str> {
        GetVpcLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVpcLinkError {
    /// Creates a new `GetVpcLinkError`.
    pub fn new(kind: GetVpcLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVpcLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVpcLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVpcLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVpcLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetVpcLinkErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinkErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetVpcLinkErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinkErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetVpcLinkErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinkErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `GetVpcLinkErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinkErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetVpcLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVpcLinkErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVpcLinkErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVpcLinkErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetVpcLinkErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetVpcLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVpcLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVpcLinksError {
    /// Kind of error that occurred.
    pub kind: GetVpcLinksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVpcLinks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVpcLinksErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVpcLinksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVpcLinksErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVpcLinksErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVpcLinksErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetVpcLinksErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetVpcLinksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVpcLinksError {
    fn code(&self) -> Option<&str> {
        GetVpcLinksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVpcLinksError {
    /// Creates a new `GetVpcLinksError`.
    pub fn new(kind: GetVpcLinksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVpcLinksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVpcLinksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVpcLinksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVpcLinksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetVpcLinksErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinksErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetVpcLinksErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinksErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetVpcLinksErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVpcLinksErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetVpcLinksErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetVpcLinksErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetVpcLinksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVpcLinksErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVpcLinksErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVpcLinksErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetVpcLinksErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetVpcLinksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportApiKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportApiKeysError {
    /// Kind of error that occurred.
    pub kind: ImportApiKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportApiKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportApiKeysErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportApiKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportApiKeysErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ImportApiKeysErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ImportApiKeysErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ImportApiKeysErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ImportApiKeysErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ImportApiKeysErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ImportApiKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportApiKeysError {
    fn code(&self) -> Option<&str> {
        ImportApiKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportApiKeysError {
    /// Creates a new `ImportApiKeysError`.
    pub fn new(kind: ImportApiKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportApiKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportApiKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportApiKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportApiKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ImportApiKeysErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ImportApiKeysErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ImportApiKeysErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ImportApiKeysErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ImportApiKeysErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportApiKeysErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ImportApiKeysErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ImportApiKeysErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ImportApiKeysErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportApiKeysErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `ImportApiKeysErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ImportApiKeysErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ImportApiKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportApiKeysErrorKind::BadRequestException(_inner) => Some(_inner),
            ImportApiKeysErrorKind::ConflictException(_inner) => Some(_inner),
            ImportApiKeysErrorKind::LimitExceededException(_inner) => Some(_inner),
            ImportApiKeysErrorKind::NotFoundException(_inner) => Some(_inner),
            ImportApiKeysErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ImportApiKeysErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ImportApiKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportDocumentationParts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportDocumentationPartsError {
    /// Kind of error that occurred.
    pub kind: ImportDocumentationPartsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportDocumentationParts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportDocumentationPartsErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportDocumentationPartsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportDocumentationPartsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ImportDocumentationPartsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ImportDocumentationPartsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ImportDocumentationPartsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ImportDocumentationPartsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ImportDocumentationPartsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ImportDocumentationPartsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportDocumentationPartsError {
    fn code(&self) -> Option<&str> {
        ImportDocumentationPartsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportDocumentationPartsError {
    /// Creates a new `ImportDocumentationPartsError`.
    pub fn new(kind: ImportDocumentationPartsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportDocumentationPartsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportDocumentationPartsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportDocumentationPartsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportDocumentationPartsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ImportDocumentationPartsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportDocumentationPartsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ImportDocumentationPartsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportDocumentationPartsErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ImportDocumentationPartsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportDocumentationPartsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ImportDocumentationPartsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportDocumentationPartsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ImportDocumentationPartsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportDocumentationPartsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `ImportDocumentationPartsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportDocumentationPartsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ImportDocumentationPartsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportDocumentationPartsErrorKind::BadRequestException(_inner) => Some(_inner),
            ImportDocumentationPartsErrorKind::ConflictException(_inner) => Some(_inner),
            ImportDocumentationPartsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ImportDocumentationPartsErrorKind::NotFoundException(_inner) => Some(_inner),
            ImportDocumentationPartsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ImportDocumentationPartsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ImportDocumentationPartsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportRestApiError {
    /// Kind of error that occurred.
    pub kind: ImportRestApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportRestApiErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportRestApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportRestApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ImportRestApiErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ImportRestApiErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ImportRestApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ImportRestApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ImportRestApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ImportRestApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportRestApiError {
    fn code(&self) -> Option<&str> {
        ImportRestApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportRestApiError {
    /// Creates a new `ImportRestApiError`.
    pub fn new(kind: ImportRestApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportRestApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportRestApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportRestApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportRestApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ImportRestApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ImportRestApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ImportRestApiErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ImportRestApiErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ImportRestApiErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportRestApiErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ImportRestApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ImportRestApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ImportRestApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportRestApiErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `ImportRestApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ImportRestApiErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ImportRestApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportRestApiErrorKind::BadRequestException(_inner) => Some(_inner),
            ImportRestApiErrorKind::ConflictException(_inner) => Some(_inner),
            ImportRestApiErrorKind::LimitExceededException(_inner) => Some(_inner),
            ImportRestApiErrorKind::NotFoundException(_inner) => Some(_inner),
            ImportRestApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ImportRestApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ImportRestApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutGatewayResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutGatewayResponseError {
    /// Kind of error that occurred.
    pub kind: PutGatewayResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutGatewayResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutGatewayResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutGatewayResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutGatewayResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutGatewayResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutGatewayResponseErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutGatewayResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutGatewayResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutGatewayResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutGatewayResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutGatewayResponseError {
    fn code(&self) -> Option<&str> {
        PutGatewayResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutGatewayResponseError {
    /// Creates a new `PutGatewayResponseError`.
    pub fn new(kind: PutGatewayResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutGatewayResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutGatewayResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutGatewayResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutGatewayResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutGatewayResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGatewayResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutGatewayResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGatewayResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `PutGatewayResponseErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGatewayResponseErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutGatewayResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGatewayResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutGatewayResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGatewayResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `PutGatewayResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGatewayResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for PutGatewayResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutGatewayResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            PutGatewayResponseErrorKind::ConflictException(_inner) => Some(_inner),
            PutGatewayResponseErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutGatewayResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            PutGatewayResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutGatewayResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutGatewayResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutIntegrationError {
    /// Kind of error that occurred.
    pub kind: PutIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutIntegrationErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutIntegrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutIntegrationError {
    fn code(&self) -> Option<&str> {
        PutIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutIntegrationError {
    /// Creates a new `PutIntegrationError`.
    pub fn new(kind: PutIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutIntegrationErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutIntegrationErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutIntegrationErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for PutIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutIntegrationErrorKind::BadRequestException(_inner) => Some(_inner),
            PutIntegrationErrorKind::ConflictException(_inner) => Some(_inner),
            PutIntegrationErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutIntegrationErrorKind::NotFoundException(_inner) => Some(_inner),
            PutIntegrationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutIntegrationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutIntegrationResponseError {
    /// Kind of error that occurred.
    pub kind: PutIntegrationResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutIntegrationResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutIntegrationResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutIntegrationResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutIntegrationResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutIntegrationResponseErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutIntegrationResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutIntegrationResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutIntegrationResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutIntegrationResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutIntegrationResponseError {
    fn code(&self) -> Option<&str> {
        PutIntegrationResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutIntegrationResponseError {
    /// Creates a new `PutIntegrationResponseError`.
    pub fn new(kind: PutIntegrationResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutIntegrationResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutIntegrationResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutIntegrationResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutIntegrationResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutIntegrationResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationResponseErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationResponseErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for PutIntegrationResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutIntegrationResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            PutIntegrationResponseErrorKind::ConflictException(_inner) => Some(_inner),
            PutIntegrationResponseErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutIntegrationResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            PutIntegrationResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutIntegrationResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutIntegrationResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMethodError {
    /// Kind of error that occurred.
    pub kind: PutMethodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMethodErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMethodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMethodErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutMethodErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutMethodErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutMethodErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutMethodErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutMethodErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutMethodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMethodError {
    fn code(&self) -> Option<&str> {
        PutMethodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMethodError {
    /// Creates a new `PutMethodError`.
    pub fn new(kind: PutMethodErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMethodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMethodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMethodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMethodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutMethodErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutMethodErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `PutMethodErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutMethodErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutMethodErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutMethodErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `PutMethodErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutMethodErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `PutMethodErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, PutMethodErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `PutMethodErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, PutMethodErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for PutMethodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMethodErrorKind::BadRequestException(_inner) => Some(_inner),
            PutMethodErrorKind::ConflictException(_inner) => Some(_inner),
            PutMethodErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutMethodErrorKind::NotFoundException(_inner) => Some(_inner),
            PutMethodErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutMethodErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutMethodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMethodResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMethodResponseError {
    /// Kind of error that occurred.
    pub kind: PutMethodResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMethodResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMethodResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMethodResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMethodResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutMethodResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutMethodResponseErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutMethodResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutMethodResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutMethodResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutMethodResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMethodResponseError {
    fn code(&self) -> Option<&str> {
        PutMethodResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMethodResponseError {
    /// Creates a new `PutMethodResponseError`.
    pub fn new(kind: PutMethodResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMethodResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMethodResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMethodResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMethodResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutMethodResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMethodResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutMethodResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutMethodResponseErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutMethodResponseErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMethodResponseErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutMethodResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutMethodResponseErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `PutMethodResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMethodResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `PutMethodResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMethodResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for PutMethodResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMethodResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            PutMethodResponseErrorKind::ConflictException(_inner) => Some(_inner),
            PutMethodResponseErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutMethodResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            PutMethodResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutMethodResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutMethodResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRestApiError {
    /// Kind of error that occurred.
    pub kind: PutRestApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRestApiErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRestApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRestApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutRestApiErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutRestApiErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutRestApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutRestApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutRestApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutRestApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRestApiError {
    fn code(&self) -> Option<&str> {
        PutRestApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRestApiError {
    /// Creates a new `PutRestApiError`.
    pub fn new(kind: PutRestApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRestApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRestApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRestApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRestApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutRestApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutRestApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `PutRestApiErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutRestApiErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutRestApiErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutRestApiErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `PutRestApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutRestApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `PutRestApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, PutRestApiErrorKind::TooManyRequestsException(_))
    }
    /// Returns true if the error kind is `PutRestApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, PutRestApiErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for PutRestApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRestApiErrorKind::BadRequestException(_inner) => Some(_inner),
            PutRestApiErrorKind::ConflictException(_inner) => Some(_inner),
            PutRestApiErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutRestApiErrorKind::NotFoundException(_inner) => Some(_inner),
            PutRestApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutRestApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutRestApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestInvokeAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestInvokeAuthorizerError {
    /// Kind of error that occurred.
    pub kind: TestInvokeAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestInvokeAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestInvokeAuthorizerErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestInvokeAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestInvokeAuthorizerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TestInvokeAuthorizerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TestInvokeAuthorizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TestInvokeAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            TestInvokeAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestInvokeAuthorizerError {
    fn code(&self) -> Option<&str> {
        TestInvokeAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestInvokeAuthorizerError {
    /// Creates a new `TestInvokeAuthorizerError`.
    pub fn new(kind: TestInvokeAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestInvokeAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestInvokeAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestInvokeAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestInvokeAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TestInvokeAuthorizerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestInvokeAuthorizerErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `TestInvokeAuthorizerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestInvokeAuthorizerErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TestInvokeAuthorizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestInvokeAuthorizerErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `TestInvokeAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestInvokeAuthorizerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for TestInvokeAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestInvokeAuthorizerErrorKind::BadRequestException(_inner) => Some(_inner),
            TestInvokeAuthorizerErrorKind::NotFoundException(_inner) => Some(_inner),
            TestInvokeAuthorizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TestInvokeAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            TestInvokeAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestInvokeMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestInvokeMethodError {
    /// Kind of error that occurred.
    pub kind: TestInvokeMethodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestInvokeMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestInvokeMethodErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestInvokeMethodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestInvokeMethodErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TestInvokeMethodErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TestInvokeMethodErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TestInvokeMethodErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            TestInvokeMethodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestInvokeMethodError {
    fn code(&self) -> Option<&str> {
        TestInvokeMethodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestInvokeMethodError {
    /// Creates a new `TestInvokeMethodError`.
    pub fn new(kind: TestInvokeMethodErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestInvokeMethodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestInvokeMethodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestInvokeMethodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestInvokeMethodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TestInvokeMethodErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestInvokeMethodErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `TestInvokeMethodErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TestInvokeMethodErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `TestInvokeMethodErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestInvokeMethodErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `TestInvokeMethodErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestInvokeMethodErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for TestInvokeMethodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestInvokeMethodErrorKind::BadRequestException(_inner) => Some(_inner),
            TestInvokeMethodErrorKind::NotFoundException(_inner) => Some(_inner),
            TestInvokeMethodErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TestInvokeMethodErrorKind::UnauthorizedException(_inner) => Some(_inner),
            TestInvokeMethodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAccountError {
    /// Kind of error that occurred.
    pub kind: UpdateAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAccountErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateAccountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateAccountErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAccountErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateAccountErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateAccountErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAccountError {
    fn code(&self) -> Option<&str> {
        UpdateAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAccountError {
    /// Creates a new `UpdateAccountError`.
    pub fn new(kind: UpdateAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateAccountErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateAccountErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateAccountErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAccountErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateAccountErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAccountErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateAccountErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateAccountErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateAccountErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAccountErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateAccountErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateAccountErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApiKeyError {
    /// Kind of error that occurred.
    pub kind: UpdateApiKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApiKeyErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApiKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApiKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApiKeyError {
    fn code(&self) -> Option<&str> {
        UpdateApiKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApiKeyError {
    /// Creates a new `UpdateApiKeyError`.
    pub fn new(kind: UpdateApiKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApiKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApiKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApiKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApiKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiKeyErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiKeyErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiKeyErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiKeyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiKeyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiKeyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateApiKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApiKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAuthorizerError {
    /// Kind of error that occurred.
    pub kind: UpdateAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAuthorizerErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAuthorizerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAuthorizerError {
    fn code(&self) -> Option<&str> {
        UpdateAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAuthorizerError {
    /// Creates a new `UpdateAuthorizerError`.
    pub fn new(kind: UpdateAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthorizerErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateAuthorizerErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthorizerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateAuthorizerErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthorizerErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthorizerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAuthorizerErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBasePathMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBasePathMappingError {
    /// Kind of error that occurred.
    pub kind: UpdateBasePathMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBasePathMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBasePathMappingErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBasePathMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBasePathMappingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateBasePathMappingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateBasePathMappingErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateBasePathMappingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBasePathMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateBasePathMappingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateBasePathMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBasePathMappingError {
    fn code(&self) -> Option<&str> {
        UpdateBasePathMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBasePathMappingError {
    /// Creates a new `UpdateBasePathMappingError`.
    pub fn new(kind: UpdateBasePathMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBasePathMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBasePathMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBasePathMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBasePathMappingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateBasePathMappingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBasePathMappingErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateBasePathMappingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBasePathMappingErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateBasePathMappingErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBasePathMappingErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateBasePathMappingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBasePathMappingErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateBasePathMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBasePathMappingErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateBasePathMappingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBasePathMappingErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateBasePathMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBasePathMappingErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateBasePathMappingErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateBasePathMappingErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateBasePathMappingErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBasePathMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateBasePathMappingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateBasePathMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClientCertificateError {
    /// Kind of error that occurred.
    pub kind: UpdateClientCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClientCertificateErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClientCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClientCertificateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateClientCertificateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateClientCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateClientCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateClientCertificateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateClientCertificateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateClientCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClientCertificateError {
    fn code(&self) -> Option<&str> {
        UpdateClientCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClientCertificateError {
    /// Creates a new `UpdateClientCertificateError`.
    pub fn new(kind: UpdateClientCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClientCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClientCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClientCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClientCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateClientCertificateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClientCertificateErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateClientCertificateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClientCertificateErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateClientCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClientCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateClientCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClientCertificateErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateClientCertificateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClientCertificateErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateClientCertificateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClientCertificateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateClientCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClientCertificateErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateClientCertificateErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateClientCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateClientCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateClientCertificateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateClientCertificateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateClientCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeploymentError {
    /// Kind of error that occurred.
    pub kind: UpdateDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeploymentErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested service is not available. For details see the accompanying error message. Retry after the specified time period.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeploymentError {
    fn code(&self) -> Option<&str> {
        UpdateDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeploymentError {
    /// Creates a new `UpdateDeploymentError`.
    pub fn new(kind: UpdateDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDeploymentErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateDeploymentErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeploymentErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeploymentErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDocumentationPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDocumentationPartError {
    /// Kind of error that occurred.
    pub kind: UpdateDocumentationPartErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDocumentationPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDocumentationPartErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDocumentationPartError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDocumentationPartErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDocumentationPartErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDocumentationPartErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDocumentationPartErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDocumentationPartErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateDocumentationPartErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateDocumentationPartErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDocumentationPartError {
    fn code(&self) -> Option<&str> {
        UpdateDocumentationPartError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDocumentationPartError {
    /// Creates a new `UpdateDocumentationPartError`.
    pub fn new(kind: UpdateDocumentationPartErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDocumentationPartError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDocumentationPartErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDocumentationPartError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDocumentationPartErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDocumentationPartErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationPartErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationPartErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationPartErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationPartErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationPartErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationPartErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationPartErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationPartErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationPartErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationPartErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationPartErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateDocumentationPartError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDocumentationPartErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDocumentationPartErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDocumentationPartErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDocumentationPartErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDocumentationPartErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateDocumentationPartErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateDocumentationPartErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDocumentationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDocumentationVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateDocumentationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDocumentationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDocumentationVersionErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDocumentationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDocumentationVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDocumentationVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDocumentationVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDocumentationVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDocumentationVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateDocumentationVersionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateDocumentationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDocumentationVersionError {
    fn code(&self) -> Option<&str> {
        UpdateDocumentationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDocumentationVersionError {
    /// Creates a new `UpdateDocumentationVersionError`.
    pub fn new(kind: UpdateDocumentationVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDocumentationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDocumentationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDocumentationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDocumentationVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDocumentationVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationVersionErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDocumentationVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentationVersionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateDocumentationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDocumentationVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDocumentationVersionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDocumentationVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDocumentationVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDocumentationVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateDocumentationVersionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateDocumentationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainNameError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomainName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainNameErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainNameErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateDomainNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainNameError {
    fn code(&self) -> Option<&str> {
        UpdateDomainNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainNameError {
    /// Creates a new `UpdateDomainNameError`.
    pub fn new(kind: UpdateDomainNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainNameErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainNameErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainNameErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateDomainNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainNameErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateDomainNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGatewayResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGatewayResponseError {
    /// Kind of error that occurred.
    pub kind: UpdateGatewayResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGatewayResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGatewayResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGatewayResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGatewayResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateGatewayResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateGatewayResponseErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateGatewayResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGatewayResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateGatewayResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateGatewayResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGatewayResponseError {
    fn code(&self) -> Option<&str> {
        UpdateGatewayResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGatewayResponseError {
    /// Creates a new `UpdateGatewayResponseError`.
    pub fn new(kind: UpdateGatewayResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGatewayResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGatewayResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGatewayResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGatewayResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGatewayResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayResponseErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayResponseErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateGatewayResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGatewayResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateGatewayResponseErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateGatewayResponseErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateGatewayResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGatewayResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateGatewayResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateGatewayResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIntegrationError {
    /// Kind of error that occurred.
    pub kind: UpdateIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIntegrationErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIntegrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIntegrationError {
    fn code(&self) -> Option<&str> {
        UpdateIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIntegrationError {
    /// Creates a new `UpdateIntegrationError`.
    pub fn new(kind: UpdateIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateIntegrationErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateIntegrationErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIntegrationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIntegrationResponseError {
    /// Kind of error that occurred.
    pub kind: UpdateIntegrationResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIntegrationResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIntegrationResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIntegrationResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIntegrationResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateIntegrationResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIntegrationResponseError {
    fn code(&self) -> Option<&str> {
        UpdateIntegrationResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIntegrationResponseError {
    /// Creates a new `UpdateIntegrationResponseError`.
    pub fn new(kind: UpdateIntegrationResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIntegrationResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIntegrationResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIntegrationResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIntegrationResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateIntegrationResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntegrationResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateIntegrationResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIntegrationResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateIntegrationResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMethodError {
    /// Kind of error that occurred.
    pub kind: UpdateMethodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMethodErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMethodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMethodErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateMethodErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateMethodErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateMethodErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateMethodErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateMethodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMethodError {
    fn code(&self) -> Option<&str> {
        UpdateMethodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMethodError {
    /// Creates a new `UpdateMethodError`.
    pub fn new(kind: UpdateMethodErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMethodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMethodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMethodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMethodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateMethodErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateMethodErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateMethodErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateMethodErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateMethodErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateMethodErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateMethodErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMethodErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateMethodErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateMethodErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateMethodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMethodErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateMethodErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateMethodErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateMethodErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateMethodErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateMethodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMethodResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMethodResponseError {
    /// Kind of error that occurred.
    pub kind: UpdateMethodResponseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMethodResponse` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMethodResponseErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMethodResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMethodResponseErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateMethodResponseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateMethodResponseErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateMethodResponseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateMethodResponseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateMethodResponseErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateMethodResponseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMethodResponseError {
    fn code(&self) -> Option<&str> {
        UpdateMethodResponseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMethodResponseError {
    /// Creates a new `UpdateMethodResponseError`.
    pub fn new(kind: UpdateMethodResponseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMethodResponseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMethodResponseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMethodResponseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMethodResponseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateMethodResponseErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMethodResponseErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateMethodResponseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMethodResponseErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateMethodResponseErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMethodResponseErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateMethodResponseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMethodResponseErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateMethodResponseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMethodResponseErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateMethodResponseErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMethodResponseErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateMethodResponseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMethodResponseErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateMethodResponseErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateMethodResponseErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateMethodResponseErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateMethodResponseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateMethodResponseErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateMethodResponseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateModelError {
    /// Kind of error that occurred.
    pub kind: UpdateModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateModelErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateModelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateModelError {
    fn code(&self) -> Option<&str> {
        UpdateModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateModelError {
    /// Creates a new `UpdateModelError`.
    pub fn new(kind: UpdateModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateModelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateModelErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateModelErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateModelErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateModelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateModelErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRequestValidator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRequestValidatorError {
    /// Kind of error that occurred.
    pub kind: UpdateRequestValidatorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRequestValidator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRequestValidatorErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRequestValidatorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRequestValidatorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateRequestValidatorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRequestValidatorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateRequestValidatorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateRequestValidatorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateRequestValidatorErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateRequestValidatorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRequestValidatorError {
    fn code(&self) -> Option<&str> {
        UpdateRequestValidatorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRequestValidatorError {
    /// Creates a new `UpdateRequestValidatorError`.
    pub fn new(kind: UpdateRequestValidatorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRequestValidatorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRequestValidatorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRequestValidatorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRequestValidatorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateRequestValidatorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRequestValidatorErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRequestValidatorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRequestValidatorErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRequestValidatorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRequestValidatorErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRequestValidatorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRequestValidatorErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRequestValidatorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRequestValidatorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRequestValidatorErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRequestValidatorErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateRequestValidatorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRequestValidatorErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateRequestValidatorErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRequestValidatorErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateRequestValidatorErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateRequestValidatorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateRequestValidatorErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateRequestValidatorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceError {
    fn code(&self) -> Option<&str> {
        UpdateResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceError {
    /// Creates a new `UpdateResourceError`.
    pub fn new(kind: UpdateResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRestApiError {
    /// Kind of error that occurred.
    pub kind: UpdateRestApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRestApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRestApiErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRestApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRestApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateRestApiErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRestApiErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateRestApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateRestApiErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateRestApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateRestApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRestApiError {
    fn code(&self) -> Option<&str> {
        UpdateRestApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRestApiError {
    /// Creates a new `UpdateRestApiError`.
    pub fn new(kind: UpdateRestApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRestApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRestApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRestApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRestApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateRestApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateRestApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateRestApiErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateRestApiErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateRestApiErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRestApiErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRestApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateRestApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateRestApiErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRestApiErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRestApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateRestApiErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateRestApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRestApiErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateRestApiErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRestApiErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateRestApiErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateRestApiErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateRestApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateRestApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStageError {
    /// Kind of error that occurred.
    pub kind: UpdateStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStageErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStageError {
    fn code(&self) -> Option<&str> {
        UpdateStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStageError {
    /// Creates a new `UpdateStageError`.
    pub fn new(kind: UpdateStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStageErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateStageErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStageErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateStageErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateStageErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateStageErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateStageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateStageErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUsageError {
    /// Kind of error that occurred.
    pub kind: UpdateUsageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUsageErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUsageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUsageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateUsageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateUsageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateUsageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateUsageErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateUsageErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateUsageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUsageError {
    fn code(&self) -> Option<&str> {
        UpdateUsageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUsageError {
    /// Creates a new `UpdateUsageError`.
    pub fn new(kind: UpdateUsageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUsageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUsageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUsageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUsageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateUsageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateUsageErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateUsageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateUsageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateUsageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateUsageErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `UpdateUsageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateUsageErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateUsageErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUsageErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateUsageErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateUsageErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateUsageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUsageErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateUsageErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateUsageErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateUsageErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateUsageErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateUsageErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateUsageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUsagePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUsagePlanError {
    /// Kind of error that occurred.
    pub kind: UpdateUsagePlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUsagePlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUsagePlanErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUsagePlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUsagePlanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateUsagePlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateUsagePlanErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateUsagePlanErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateUsagePlanErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateUsagePlanErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateUsagePlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUsagePlanError {
    fn code(&self) -> Option<&str> {
        UpdateUsagePlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUsagePlanError {
    /// Creates a new `UpdateUsagePlanError`.
    pub fn new(kind: UpdateUsagePlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUsagePlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUsagePlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUsagePlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUsagePlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateUsagePlanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateUsagePlanErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateUsagePlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateUsagePlanErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateUsagePlanErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUsagePlanErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateUsagePlanErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateUsagePlanErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateUsagePlanErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUsagePlanErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateUsagePlanErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUsagePlanErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateUsagePlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUsagePlanErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateUsagePlanErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateUsagePlanErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateUsagePlanErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateUsagePlanErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateUsagePlanErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateUsagePlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVpcLinkError {
    /// Kind of error that occurred.
    pub kind: UpdateVpcLinkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVpcLink` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVpcLinkErrorKind {
    /// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request is denied because the caller has insufficient permissions.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVpcLinkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVpcLinkErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateVpcLinkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateVpcLinkErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateVpcLinkErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateVpcLinkErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateVpcLinkErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateVpcLinkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVpcLinkError {
    fn code(&self) -> Option<&str> {
        UpdateVpcLinkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVpcLinkError {
    /// Creates a new `UpdateVpcLinkError`.
    pub fn new(kind: UpdateVpcLinkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVpcLinkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVpcLinkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVpcLinkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVpcLinkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateVpcLinkErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateVpcLinkErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateVpcLinkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateVpcLinkErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateVpcLinkErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVpcLinkErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateVpcLinkErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateVpcLinkErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateVpcLinkErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVpcLinkErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateVpcLinkErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateVpcLinkErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateVpcLinkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVpcLinkErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateVpcLinkErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateVpcLinkErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateVpcLinkErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateVpcLinkErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateVpcLinkErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateVpcLinkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request is denied because the caller has insufficient permissions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>The request has reached its throttling limit. Retry after the specified time period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub retry_after_seconds: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                retry_after_seconds: self.retry_after_seconds,
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The requested resource is not found. Make sure that the request URI is correct.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The request exceeded the rate limit. Retry after the specified time period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub retry_after_seconds: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                retry_after_seconds: self.retry_after_seconds,
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request configuration has conflicts. For details, see the accompanying error message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>The requested service is not available. For details see the accompanying error message. Retry after the specified time period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub retry_after_seconds: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                retry_after_seconds: self.retry_after_seconds,
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}
