// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `BackplaneControlService`.
///
/// This client allows ergonomic access to a `BackplaneControlService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateApiKey` operation.
    ///
    /// See [`CreateApiKey`](crate::client::fluent_builders::CreateApiKey) for more information about the
    /// operation and its arguments.
    pub fn create_api_key(&self) -> fluent_builders::CreateApiKey<C, M, R> {
        fluent_builders::CreateApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAuthorizer` operation.
    ///
    /// See [`CreateAuthorizer`](crate::client::fluent_builders::CreateAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn create_authorizer(&self) -> fluent_builders::CreateAuthorizer<C, M, R> {
        fluent_builders::CreateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBasePathMapping` operation.
    ///
    /// See [`CreateBasePathMapping`](crate::client::fluent_builders::CreateBasePathMapping) for more information about the
    /// operation and its arguments.
    pub fn create_base_path_mapping(&self) -> fluent_builders::CreateBasePathMapping<C, M, R> {
        fluent_builders::CreateBasePathMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeployment` operation.
    ///
    /// See [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) for more information about the
    /// operation and its arguments.
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment<C, M, R> {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDocumentationPart` operation.
    ///
    /// See [`CreateDocumentationPart`](crate::client::fluent_builders::CreateDocumentationPart) for more information about the
    /// operation and its arguments.
    pub fn create_documentation_part(&self) -> fluent_builders::CreateDocumentationPart<C, M, R> {
        fluent_builders::CreateDocumentationPart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDocumentationVersion` operation.
    ///
    /// See [`CreateDocumentationVersion`](crate::client::fluent_builders::CreateDocumentationVersion) for more information about the
    /// operation and its arguments.
    pub fn create_documentation_version(
        &self,
    ) -> fluent_builders::CreateDocumentationVersion<C, M, R> {
        fluent_builders::CreateDocumentationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomainName` operation.
    ///
    /// See [`CreateDomainName`](crate::client::fluent_builders::CreateDomainName) for more information about the
    /// operation and its arguments.
    pub fn create_domain_name(&self) -> fluent_builders::CreateDomainName<C, M, R> {
        fluent_builders::CreateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModel` operation.
    ///
    /// See [`CreateModel`](crate::client::fluent_builders::CreateModel) for more information about the
    /// operation and its arguments.
    pub fn create_model(&self) -> fluent_builders::CreateModel<C, M, R> {
        fluent_builders::CreateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRequestValidator` operation.
    ///
    /// See [`CreateRequestValidator`](crate::client::fluent_builders::CreateRequestValidator) for more information about the
    /// operation and its arguments.
    pub fn create_request_validator(&self) -> fluent_builders::CreateRequestValidator<C, M, R> {
        fluent_builders::CreateRequestValidator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResource` operation.
    ///
    /// See [`CreateResource`](crate::client::fluent_builders::CreateResource) for more information about the
    /// operation and its arguments.
    pub fn create_resource(&self) -> fluent_builders::CreateResource<C, M, R> {
        fluent_builders::CreateResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRestApi` operation.
    ///
    /// See [`CreateRestApi`](crate::client::fluent_builders::CreateRestApi) for more information about the
    /// operation and its arguments.
    pub fn create_rest_api(&self) -> fluent_builders::CreateRestApi<C, M, R> {
        fluent_builders::CreateRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStage` operation.
    ///
    /// See [`CreateStage`](crate::client::fluent_builders::CreateStage) for more information about the
    /// operation and its arguments.
    pub fn create_stage(&self) -> fluent_builders::CreateStage<C, M, R> {
        fluent_builders::CreateStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUsagePlan` operation.
    ///
    /// See [`CreateUsagePlan`](crate::client::fluent_builders::CreateUsagePlan) for more information about the
    /// operation and its arguments.
    pub fn create_usage_plan(&self) -> fluent_builders::CreateUsagePlan<C, M, R> {
        fluent_builders::CreateUsagePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUsagePlanKey` operation.
    ///
    /// See [`CreateUsagePlanKey`](crate::client::fluent_builders::CreateUsagePlanKey) for more information about the
    /// operation and its arguments.
    pub fn create_usage_plan_key(&self) -> fluent_builders::CreateUsagePlanKey<C, M, R> {
        fluent_builders::CreateUsagePlanKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpcLink` operation.
    ///
    /// See [`CreateVpcLink`](crate::client::fluent_builders::CreateVpcLink) for more information about the
    /// operation and its arguments.
    pub fn create_vpc_link(&self) -> fluent_builders::CreateVpcLink<C, M, R> {
        fluent_builders::CreateVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApiKey` operation.
    ///
    /// See [`DeleteApiKey`](crate::client::fluent_builders::DeleteApiKey) for more information about the
    /// operation and its arguments.
    pub fn delete_api_key(&self) -> fluent_builders::DeleteApiKey<C, M, R> {
        fluent_builders::DeleteApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAuthorizer` operation.
    ///
    /// See [`DeleteAuthorizer`](crate::client::fluent_builders::DeleteAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn delete_authorizer(&self) -> fluent_builders::DeleteAuthorizer<C, M, R> {
        fluent_builders::DeleteAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBasePathMapping` operation.
    ///
    /// See [`DeleteBasePathMapping`](crate::client::fluent_builders::DeleteBasePathMapping) for more information about the
    /// operation and its arguments.
    pub fn delete_base_path_mapping(&self) -> fluent_builders::DeleteBasePathMapping<C, M, R> {
        fluent_builders::DeleteBasePathMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteClientCertificate` operation.
    ///
    /// See [`DeleteClientCertificate`](crate::client::fluent_builders::DeleteClientCertificate) for more information about the
    /// operation and its arguments.
    pub fn delete_client_certificate(&self) -> fluent_builders::DeleteClientCertificate<C, M, R> {
        fluent_builders::DeleteClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDeployment` operation.
    ///
    /// See [`DeleteDeployment`](crate::client::fluent_builders::DeleteDeployment) for more information about the
    /// operation and its arguments.
    pub fn delete_deployment(&self) -> fluent_builders::DeleteDeployment<C, M, R> {
        fluent_builders::DeleteDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDocumentationPart` operation.
    ///
    /// See [`DeleteDocumentationPart`](crate::client::fluent_builders::DeleteDocumentationPart) for more information about the
    /// operation and its arguments.
    pub fn delete_documentation_part(&self) -> fluent_builders::DeleteDocumentationPart<C, M, R> {
        fluent_builders::DeleteDocumentationPart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDocumentationVersion` operation.
    ///
    /// See [`DeleteDocumentationVersion`](crate::client::fluent_builders::DeleteDocumentationVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_documentation_version(
        &self,
    ) -> fluent_builders::DeleteDocumentationVersion<C, M, R> {
        fluent_builders::DeleteDocumentationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomainName` operation.
    ///
    /// See [`DeleteDomainName`](crate::client::fluent_builders::DeleteDomainName) for more information about the
    /// operation and its arguments.
    pub fn delete_domain_name(&self) -> fluent_builders::DeleteDomainName<C, M, R> {
        fluent_builders::DeleteDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGatewayResponse` operation.
    ///
    /// See [`DeleteGatewayResponse`](crate::client::fluent_builders::DeleteGatewayResponse) for more information about the
    /// operation and its arguments.
    pub fn delete_gateway_response(&self) -> fluent_builders::DeleteGatewayResponse<C, M, R> {
        fluent_builders::DeleteGatewayResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIntegration` operation.
    ///
    /// See [`DeleteIntegration`](crate::client::fluent_builders::DeleteIntegration) for more information about the
    /// operation and its arguments.
    pub fn delete_integration(&self) -> fluent_builders::DeleteIntegration<C, M, R> {
        fluent_builders::DeleteIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIntegrationResponse` operation.
    ///
    /// See [`DeleteIntegrationResponse`](crate::client::fluent_builders::DeleteIntegrationResponse) for more information about the
    /// operation and its arguments.
    pub fn delete_integration_response(
        &self,
    ) -> fluent_builders::DeleteIntegrationResponse<C, M, R> {
        fluent_builders::DeleteIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMethod` operation.
    ///
    /// See [`DeleteMethod`](crate::client::fluent_builders::DeleteMethod) for more information about the
    /// operation and its arguments.
    pub fn delete_method(&self) -> fluent_builders::DeleteMethod<C, M, R> {
        fluent_builders::DeleteMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMethodResponse` operation.
    ///
    /// See [`DeleteMethodResponse`](crate::client::fluent_builders::DeleteMethodResponse) for more information about the
    /// operation and its arguments.
    pub fn delete_method_response(&self) -> fluent_builders::DeleteMethodResponse<C, M, R> {
        fluent_builders::DeleteMethodResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModel` operation.
    ///
    /// See [`DeleteModel`](crate::client::fluent_builders::DeleteModel) for more information about the
    /// operation and its arguments.
    pub fn delete_model(&self) -> fluent_builders::DeleteModel<C, M, R> {
        fluent_builders::DeleteModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRequestValidator` operation.
    ///
    /// See [`DeleteRequestValidator`](crate::client::fluent_builders::DeleteRequestValidator) for more information about the
    /// operation and its arguments.
    pub fn delete_request_validator(&self) -> fluent_builders::DeleteRequestValidator<C, M, R> {
        fluent_builders::DeleteRequestValidator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResource` operation.
    ///
    /// See [`DeleteResource`](crate::client::fluent_builders::DeleteResource) for more information about the
    /// operation and its arguments.
    pub fn delete_resource(&self) -> fluent_builders::DeleteResource<C, M, R> {
        fluent_builders::DeleteResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRestApi` operation.
    ///
    /// See [`DeleteRestApi`](crate::client::fluent_builders::DeleteRestApi) for more information about the
    /// operation and its arguments.
    pub fn delete_rest_api(&self) -> fluent_builders::DeleteRestApi<C, M, R> {
        fluent_builders::DeleteRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStage` operation.
    ///
    /// See [`DeleteStage`](crate::client::fluent_builders::DeleteStage) for more information about the
    /// operation and its arguments.
    pub fn delete_stage(&self) -> fluent_builders::DeleteStage<C, M, R> {
        fluent_builders::DeleteStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUsagePlan` operation.
    ///
    /// See [`DeleteUsagePlan`](crate::client::fluent_builders::DeleteUsagePlan) for more information about the
    /// operation and its arguments.
    pub fn delete_usage_plan(&self) -> fluent_builders::DeleteUsagePlan<C, M, R> {
        fluent_builders::DeleteUsagePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUsagePlanKey` operation.
    ///
    /// See [`DeleteUsagePlanKey`](crate::client::fluent_builders::DeleteUsagePlanKey) for more information about the
    /// operation and its arguments.
    pub fn delete_usage_plan_key(&self) -> fluent_builders::DeleteUsagePlanKey<C, M, R> {
        fluent_builders::DeleteUsagePlanKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpcLink` operation.
    ///
    /// See [`DeleteVpcLink`](crate::client::fluent_builders::DeleteVpcLink) for more information about the
    /// operation and its arguments.
    pub fn delete_vpc_link(&self) -> fluent_builders::DeleteVpcLink<C, M, R> {
        fluent_builders::DeleteVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `FlushStageAuthorizersCache` operation.
    ///
    /// See [`FlushStageAuthorizersCache`](crate::client::fluent_builders::FlushStageAuthorizersCache) for more information about the
    /// operation and its arguments.
    pub fn flush_stage_authorizers_cache(
        &self,
    ) -> fluent_builders::FlushStageAuthorizersCache<C, M, R> {
        fluent_builders::FlushStageAuthorizersCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `FlushStageCache` operation.
    ///
    /// See [`FlushStageCache`](crate::client::fluent_builders::FlushStageCache) for more information about the
    /// operation and its arguments.
    pub fn flush_stage_cache(&self) -> fluent_builders::FlushStageCache<C, M, R> {
        fluent_builders::FlushStageCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateClientCertificate` operation.
    ///
    /// See [`GenerateClientCertificate`](crate::client::fluent_builders::GenerateClientCertificate) for more information about the
    /// operation and its arguments.
    pub fn generate_client_certificate(
        &self,
    ) -> fluent_builders::GenerateClientCertificate<C, M, R> {
        fluent_builders::GenerateClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccount` operation.
    ///
    /// See [`GetAccount`](crate::client::fluent_builders::GetAccount) for more information about the
    /// operation and its arguments.
    pub fn get_account(&self) -> fluent_builders::GetAccount<C, M, R> {
        fluent_builders::GetAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApiKey` operation.
    ///
    /// See [`GetApiKey`](crate::client::fluent_builders::GetApiKey) for more information about the
    /// operation and its arguments.
    pub fn get_api_key(&self) -> fluent_builders::GetApiKey<C, M, R> {
        fluent_builders::GetApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApiKeys` operation.
    ///
    /// See [`GetApiKeys`](crate::client::fluent_builders::GetApiKeys) for more information about the
    /// operation and its arguments.
    pub fn get_api_keys(&self) -> fluent_builders::GetApiKeys<C, M, R> {
        fluent_builders::GetApiKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAuthorizer` operation.
    ///
    /// See [`GetAuthorizer`](crate::client::fluent_builders::GetAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn get_authorizer(&self) -> fluent_builders::GetAuthorizer<C, M, R> {
        fluent_builders::GetAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAuthorizers` operation.
    ///
    /// See [`GetAuthorizers`](crate::client::fluent_builders::GetAuthorizers) for more information about the
    /// operation and its arguments.
    pub fn get_authorizers(&self) -> fluent_builders::GetAuthorizers<C, M, R> {
        fluent_builders::GetAuthorizers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBasePathMapping` operation.
    ///
    /// See [`GetBasePathMapping`](crate::client::fluent_builders::GetBasePathMapping) for more information about the
    /// operation and its arguments.
    pub fn get_base_path_mapping(&self) -> fluent_builders::GetBasePathMapping<C, M, R> {
        fluent_builders::GetBasePathMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBasePathMappings` operation.
    ///
    /// See [`GetBasePathMappings`](crate::client::fluent_builders::GetBasePathMappings) for more information about the
    /// operation and its arguments.
    pub fn get_base_path_mappings(&self) -> fluent_builders::GetBasePathMappings<C, M, R> {
        fluent_builders::GetBasePathMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetClientCertificate` operation.
    ///
    /// See [`GetClientCertificate`](crate::client::fluent_builders::GetClientCertificate) for more information about the
    /// operation and its arguments.
    pub fn get_client_certificate(&self) -> fluent_builders::GetClientCertificate<C, M, R> {
        fluent_builders::GetClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetClientCertificates` operation.
    ///
    /// See [`GetClientCertificates`](crate::client::fluent_builders::GetClientCertificates) for more information about the
    /// operation and its arguments.
    pub fn get_client_certificates(&self) -> fluent_builders::GetClientCertificates<C, M, R> {
        fluent_builders::GetClientCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeployment` operation.
    ///
    /// See [`GetDeployment`](crate::client::fluent_builders::GetDeployment) for more information about the
    /// operation and its arguments.
    pub fn get_deployment(&self) -> fluent_builders::GetDeployment<C, M, R> {
        fluent_builders::GetDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeployments` operation.
    ///
    /// See [`GetDeployments`](crate::client::fluent_builders::GetDeployments) for more information about the
    /// operation and its arguments.
    pub fn get_deployments(&self) -> fluent_builders::GetDeployments<C, M, R> {
        fluent_builders::GetDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDocumentationPart` operation.
    ///
    /// See [`GetDocumentationPart`](crate::client::fluent_builders::GetDocumentationPart) for more information about the
    /// operation and its arguments.
    pub fn get_documentation_part(&self) -> fluent_builders::GetDocumentationPart<C, M, R> {
        fluent_builders::GetDocumentationPart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDocumentationParts` operation.
    ///
    /// See [`GetDocumentationParts`](crate::client::fluent_builders::GetDocumentationParts) for more information about the
    /// operation and its arguments.
    pub fn get_documentation_parts(&self) -> fluent_builders::GetDocumentationParts<C, M, R> {
        fluent_builders::GetDocumentationParts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDocumentationVersion` operation.
    ///
    /// See [`GetDocumentationVersion`](crate::client::fluent_builders::GetDocumentationVersion) for more information about the
    /// operation and its arguments.
    pub fn get_documentation_version(&self) -> fluent_builders::GetDocumentationVersion<C, M, R> {
        fluent_builders::GetDocumentationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDocumentationVersions` operation.
    ///
    /// See [`GetDocumentationVersions`](crate::client::fluent_builders::GetDocumentationVersions) for more information about the
    /// operation and its arguments.
    pub fn get_documentation_versions(&self) -> fluent_builders::GetDocumentationVersions<C, M, R> {
        fluent_builders::GetDocumentationVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainName` operation.
    ///
    /// See [`GetDomainName`](crate::client::fluent_builders::GetDomainName) for more information about the
    /// operation and its arguments.
    pub fn get_domain_name(&self) -> fluent_builders::GetDomainName<C, M, R> {
        fluent_builders::GetDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainNames` operation.
    ///
    /// See [`GetDomainNames`](crate::client::fluent_builders::GetDomainNames) for more information about the
    /// operation and its arguments.
    pub fn get_domain_names(&self) -> fluent_builders::GetDomainNames<C, M, R> {
        fluent_builders::GetDomainNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExport` operation.
    ///
    /// See [`GetExport`](crate::client::fluent_builders::GetExport) for more information about the
    /// operation and its arguments.
    pub fn get_export(&self) -> fluent_builders::GetExport<C, M, R> {
        fluent_builders::GetExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGatewayResponse` operation.
    ///
    /// See [`GetGatewayResponse`](crate::client::fluent_builders::GetGatewayResponse) for more information about the
    /// operation and its arguments.
    pub fn get_gateway_response(&self) -> fluent_builders::GetGatewayResponse<C, M, R> {
        fluent_builders::GetGatewayResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGatewayResponses` operation.
    ///
    /// See [`GetGatewayResponses`](crate::client::fluent_builders::GetGatewayResponses) for more information about the
    /// operation and its arguments.
    pub fn get_gateway_responses(&self) -> fluent_builders::GetGatewayResponses<C, M, R> {
        fluent_builders::GetGatewayResponses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIntegration` operation.
    ///
    /// See [`GetIntegration`](crate::client::fluent_builders::GetIntegration) for more information about the
    /// operation and its arguments.
    pub fn get_integration(&self) -> fluent_builders::GetIntegration<C, M, R> {
        fluent_builders::GetIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIntegrationResponse` operation.
    ///
    /// See [`GetIntegrationResponse`](crate::client::fluent_builders::GetIntegrationResponse) for more information about the
    /// operation and its arguments.
    pub fn get_integration_response(&self) -> fluent_builders::GetIntegrationResponse<C, M, R> {
        fluent_builders::GetIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMethod` operation.
    ///
    /// See [`GetMethod`](crate::client::fluent_builders::GetMethod) for more information about the
    /// operation and its arguments.
    pub fn get_method(&self) -> fluent_builders::GetMethod<C, M, R> {
        fluent_builders::GetMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMethodResponse` operation.
    ///
    /// See [`GetMethodResponse`](crate::client::fluent_builders::GetMethodResponse) for more information about the
    /// operation and its arguments.
    pub fn get_method_response(&self) -> fluent_builders::GetMethodResponse<C, M, R> {
        fluent_builders::GetMethodResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetModel` operation.
    ///
    /// See [`GetModel`](crate::client::fluent_builders::GetModel) for more information about the
    /// operation and its arguments.
    pub fn get_model(&self) -> fluent_builders::GetModel<C, M, R> {
        fluent_builders::GetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetModels` operation.
    ///
    /// See [`GetModels`](crate::client::fluent_builders::GetModels) for more information about the
    /// operation and its arguments.
    pub fn get_models(&self) -> fluent_builders::GetModels<C, M, R> {
        fluent_builders::GetModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetModelTemplate` operation.
    ///
    /// See [`GetModelTemplate`](crate::client::fluent_builders::GetModelTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_model_template(&self) -> fluent_builders::GetModelTemplate<C, M, R> {
        fluent_builders::GetModelTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRequestValidator` operation.
    ///
    /// See [`GetRequestValidator`](crate::client::fluent_builders::GetRequestValidator) for more information about the
    /// operation and its arguments.
    pub fn get_request_validator(&self) -> fluent_builders::GetRequestValidator<C, M, R> {
        fluent_builders::GetRequestValidator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRequestValidators` operation.
    ///
    /// See [`GetRequestValidators`](crate::client::fluent_builders::GetRequestValidators) for more information about the
    /// operation and its arguments.
    pub fn get_request_validators(&self) -> fluent_builders::GetRequestValidators<C, M, R> {
        fluent_builders::GetRequestValidators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResource` operation.
    ///
    /// See [`GetResource`](crate::client::fluent_builders::GetResource) for more information about the
    /// operation and its arguments.
    pub fn get_resource(&self) -> fluent_builders::GetResource<C, M, R> {
        fluent_builders::GetResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResources` operation.
    ///
    /// See [`GetResources`](crate::client::fluent_builders::GetResources) for more information about the
    /// operation and its arguments.
    pub fn get_resources(&self) -> fluent_builders::GetResources<C, M, R> {
        fluent_builders::GetResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRestApi` operation.
    ///
    /// See [`GetRestApi`](crate::client::fluent_builders::GetRestApi) for more information about the
    /// operation and its arguments.
    pub fn get_rest_api(&self) -> fluent_builders::GetRestApi<C, M, R> {
        fluent_builders::GetRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRestApis` operation.
    ///
    /// See [`GetRestApis`](crate::client::fluent_builders::GetRestApis) for more information about the
    /// operation and its arguments.
    pub fn get_rest_apis(&self) -> fluent_builders::GetRestApis<C, M, R> {
        fluent_builders::GetRestApis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSdk` operation.
    ///
    /// See [`GetSdk`](crate::client::fluent_builders::GetSdk) for more information about the
    /// operation and its arguments.
    pub fn get_sdk(&self) -> fluent_builders::GetSdk<C, M, R> {
        fluent_builders::GetSdk::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSdkType` operation.
    ///
    /// See [`GetSdkType`](crate::client::fluent_builders::GetSdkType) for more information about the
    /// operation and its arguments.
    pub fn get_sdk_type(&self) -> fluent_builders::GetSdkType<C, M, R> {
        fluent_builders::GetSdkType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSdkTypes` operation.
    ///
    /// See [`GetSdkTypes`](crate::client::fluent_builders::GetSdkTypes) for more information about the
    /// operation and its arguments.
    pub fn get_sdk_types(&self) -> fluent_builders::GetSdkTypes<C, M, R> {
        fluent_builders::GetSdkTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStage` operation.
    ///
    /// See [`GetStage`](crate::client::fluent_builders::GetStage) for more information about the
    /// operation and its arguments.
    pub fn get_stage(&self) -> fluent_builders::GetStage<C, M, R> {
        fluent_builders::GetStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStages` operation.
    ///
    /// See [`GetStages`](crate::client::fluent_builders::GetStages) for more information about the
    /// operation and its arguments.
    pub fn get_stages(&self) -> fluent_builders::GetStages<C, M, R> {
        fluent_builders::GetStages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTags` operation.
    ///
    /// See [`GetTags`](crate::client::fluent_builders::GetTags) for more information about the
    /// operation and its arguments.
    pub fn get_tags(&self) -> fluent_builders::GetTags<C, M, R> {
        fluent_builders::GetTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUsage` operation.
    ///
    /// See [`GetUsage`](crate::client::fluent_builders::GetUsage) for more information about the
    /// operation and its arguments.
    pub fn get_usage(&self) -> fluent_builders::GetUsage<C, M, R> {
        fluent_builders::GetUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUsagePlan` operation.
    ///
    /// See [`GetUsagePlan`](crate::client::fluent_builders::GetUsagePlan) for more information about the
    /// operation and its arguments.
    pub fn get_usage_plan(&self) -> fluent_builders::GetUsagePlan<C, M, R> {
        fluent_builders::GetUsagePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUsagePlanKey` operation.
    ///
    /// See [`GetUsagePlanKey`](crate::client::fluent_builders::GetUsagePlanKey) for more information about the
    /// operation and its arguments.
    pub fn get_usage_plan_key(&self) -> fluent_builders::GetUsagePlanKey<C, M, R> {
        fluent_builders::GetUsagePlanKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUsagePlanKeys` operation.
    ///
    /// See [`GetUsagePlanKeys`](crate::client::fluent_builders::GetUsagePlanKeys) for more information about the
    /// operation and its arguments.
    pub fn get_usage_plan_keys(&self) -> fluent_builders::GetUsagePlanKeys<C, M, R> {
        fluent_builders::GetUsagePlanKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUsagePlans` operation.
    ///
    /// See [`GetUsagePlans`](crate::client::fluent_builders::GetUsagePlans) for more information about the
    /// operation and its arguments.
    pub fn get_usage_plans(&self) -> fluent_builders::GetUsagePlans<C, M, R> {
        fluent_builders::GetUsagePlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVpcLink` operation.
    ///
    /// See [`GetVpcLink`](crate::client::fluent_builders::GetVpcLink) for more information about the
    /// operation and its arguments.
    pub fn get_vpc_link(&self) -> fluent_builders::GetVpcLink<C, M, R> {
        fluent_builders::GetVpcLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVpcLinks` operation.
    ///
    /// See [`GetVpcLinks`](crate::client::fluent_builders::GetVpcLinks) for more information about the
    /// operation and its arguments.
    pub fn get_vpc_links(&self) -> fluent_builders::GetVpcLinks<C, M, R> {
        fluent_builders::GetVpcLinks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportApiKeys` operation.
    ///
    /// See [`ImportApiKeys`](crate::client::fluent_builders::ImportApiKeys) for more information about the
    /// operation and its arguments.
    pub fn import_api_keys(&self) -> fluent_builders::ImportApiKeys<C, M, R> {
        fluent_builders::ImportApiKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportDocumentationParts` operation.
    ///
    /// See [`ImportDocumentationParts`](crate::client::fluent_builders::ImportDocumentationParts) for more information about the
    /// operation and its arguments.
    pub fn import_documentation_parts(&self) -> fluent_builders::ImportDocumentationParts<C, M, R> {
        fluent_builders::ImportDocumentationParts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportRestApi` operation.
    ///
    /// See [`ImportRestApi`](crate::client::fluent_builders::ImportRestApi) for more information about the
    /// operation and its arguments.
    pub fn import_rest_api(&self) -> fluent_builders::ImportRestApi<C, M, R> {
        fluent_builders::ImportRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutGatewayResponse` operation.
    ///
    /// See [`PutGatewayResponse`](crate::client::fluent_builders::PutGatewayResponse) for more information about the
    /// operation and its arguments.
    pub fn put_gateway_response(&self) -> fluent_builders::PutGatewayResponse<C, M, R> {
        fluent_builders::PutGatewayResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutIntegration` operation.
    ///
    /// See [`PutIntegration`](crate::client::fluent_builders::PutIntegration) for more information about the
    /// operation and its arguments.
    pub fn put_integration(&self) -> fluent_builders::PutIntegration<C, M, R> {
        fluent_builders::PutIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutIntegrationResponse` operation.
    ///
    /// See [`PutIntegrationResponse`](crate::client::fluent_builders::PutIntegrationResponse) for more information about the
    /// operation and its arguments.
    pub fn put_integration_response(&self) -> fluent_builders::PutIntegrationResponse<C, M, R> {
        fluent_builders::PutIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutMethod` operation.
    ///
    /// See [`PutMethod`](crate::client::fluent_builders::PutMethod) for more information about the
    /// operation and its arguments.
    pub fn put_method(&self) -> fluent_builders::PutMethod<C, M, R> {
        fluent_builders::PutMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutMethodResponse` operation.
    ///
    /// See [`PutMethodResponse`](crate::client::fluent_builders::PutMethodResponse) for more information about the
    /// operation and its arguments.
    pub fn put_method_response(&self) -> fluent_builders::PutMethodResponse<C, M, R> {
        fluent_builders::PutMethodResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRestApi` operation.
    ///
    /// See [`PutRestApi`](crate::client::fluent_builders::PutRestApi) for more information about the
    /// operation and its arguments.
    pub fn put_rest_api(&self) -> fluent_builders::PutRestApi<C, M, R> {
        fluent_builders::PutRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestInvokeAuthorizer` operation.
    ///
    /// See [`TestInvokeAuthorizer`](crate::client::fluent_builders::TestInvokeAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn test_invoke_authorizer(&self) -> fluent_builders::TestInvokeAuthorizer<C, M, R> {
        fluent_builders::TestInvokeAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestInvokeMethod` operation.
    ///
    /// See [`TestInvokeMethod`](crate::client::fluent_builders::TestInvokeMethod) for more information about the
    /// operation and its arguments.
    pub fn test_invoke_method(&self) -> fluent_builders::TestInvokeMethod<C, M, R> {
        fluent_builders::TestInvokeMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccount` operation.
    ///
    /// See [`UpdateAccount`](crate::client::fluent_builders::UpdateAccount) for more information about the
    /// operation and its arguments.
    pub fn update_account(&self) -> fluent_builders::UpdateAccount<C, M, R> {
        fluent_builders::UpdateAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApiKey` operation.
    ///
    /// See [`UpdateApiKey`](crate::client::fluent_builders::UpdateApiKey) for more information about the
    /// operation and its arguments.
    pub fn update_api_key(&self) -> fluent_builders::UpdateApiKey<C, M, R> {
        fluent_builders::UpdateApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAuthorizer` operation.
    ///
    /// See [`UpdateAuthorizer`](crate::client::fluent_builders::UpdateAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn update_authorizer(&self) -> fluent_builders::UpdateAuthorizer<C, M, R> {
        fluent_builders::UpdateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBasePathMapping` operation.
    ///
    /// See [`UpdateBasePathMapping`](crate::client::fluent_builders::UpdateBasePathMapping) for more information about the
    /// operation and its arguments.
    pub fn update_base_path_mapping(&self) -> fluent_builders::UpdateBasePathMapping<C, M, R> {
        fluent_builders::UpdateBasePathMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateClientCertificate` operation.
    ///
    /// See [`UpdateClientCertificate`](crate::client::fluent_builders::UpdateClientCertificate) for more information about the
    /// operation and its arguments.
    pub fn update_client_certificate(&self) -> fluent_builders::UpdateClientCertificate<C, M, R> {
        fluent_builders::UpdateClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDeployment` operation.
    ///
    /// See [`UpdateDeployment`](crate::client::fluent_builders::UpdateDeployment) for more information about the
    /// operation and its arguments.
    pub fn update_deployment(&self) -> fluent_builders::UpdateDeployment<C, M, R> {
        fluent_builders::UpdateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDocumentationPart` operation.
    ///
    /// See [`UpdateDocumentationPart`](crate::client::fluent_builders::UpdateDocumentationPart) for more information about the
    /// operation and its arguments.
    pub fn update_documentation_part(&self) -> fluent_builders::UpdateDocumentationPart<C, M, R> {
        fluent_builders::UpdateDocumentationPart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDocumentationVersion` operation.
    ///
    /// See [`UpdateDocumentationVersion`](crate::client::fluent_builders::UpdateDocumentationVersion) for more information about the
    /// operation and its arguments.
    pub fn update_documentation_version(
        &self,
    ) -> fluent_builders::UpdateDocumentationVersion<C, M, R> {
        fluent_builders::UpdateDocumentationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainName` operation.
    ///
    /// See [`UpdateDomainName`](crate::client::fluent_builders::UpdateDomainName) for more information about the
    /// operation and its arguments.
    pub fn update_domain_name(&self) -> fluent_builders::UpdateDomainName<C, M, R> {
        fluent_builders::UpdateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGatewayResponse` operation.
    ///
    /// See [`UpdateGatewayResponse`](crate::client::fluent_builders::UpdateGatewayResponse) for more information about the
    /// operation and its arguments.
    pub fn update_gateway_response(&self) -> fluent_builders::UpdateGatewayResponse<C, M, R> {
        fluent_builders::UpdateGatewayResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIntegration` operation.
    ///
    /// See [`UpdateIntegration`](crate::client::fluent_builders::UpdateIntegration) for more information about the
    /// operation and its arguments.
    pub fn update_integration(&self) -> fluent_builders::UpdateIntegration<C, M, R> {
        fluent_builders::UpdateIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIntegrationResponse` operation.
    ///
    /// See [`UpdateIntegrationResponse`](crate::client::fluent_builders::UpdateIntegrationResponse) for more information about the
    /// operation and its arguments.
    pub fn update_integration_response(
        &self,
    ) -> fluent_builders::UpdateIntegrationResponse<C, M, R> {
        fluent_builders::UpdateIntegrationResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMethod` operation.
    ///
    /// See [`UpdateMethod`](crate::client::fluent_builders::UpdateMethod) for more information about the
    /// operation and its arguments.
    pub fn update_method(&self) -> fluent_builders::UpdateMethod<C, M, R> {
        fluent_builders::UpdateMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMethodResponse` operation.
    ///
    /// See [`UpdateMethodResponse`](crate::client::fluent_builders::UpdateMethodResponse) for more information about the
    /// operation and its arguments.
    pub fn update_method_response(&self) -> fluent_builders::UpdateMethodResponse<C, M, R> {
        fluent_builders::UpdateMethodResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateModel` operation.
    ///
    /// See [`UpdateModel`](crate::client::fluent_builders::UpdateModel) for more information about the
    /// operation and its arguments.
    pub fn update_model(&self) -> fluent_builders::UpdateModel<C, M, R> {
        fluent_builders::UpdateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRequestValidator` operation.
    ///
    /// See [`UpdateRequestValidator`](crate::client::fluent_builders::UpdateRequestValidator) for more information about the
    /// operation and its arguments.
    pub fn update_request_validator(&self) -> fluent_builders::UpdateRequestValidator<C, M, R> {
        fluent_builders::UpdateRequestValidator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResource` operation.
    ///
    /// See [`UpdateResource`](crate::client::fluent_builders::UpdateResource) for more information about the
    /// operation and its arguments.
    pub fn update_resource(&self) -> fluent_builders::UpdateResource<C, M, R> {
        fluent_builders::UpdateResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRestApi` operation.
    ///
    /// See [`UpdateRestApi`](crate::client::fluent_builders::UpdateRestApi) for more information about the
    /// operation and its arguments.
    pub fn update_rest_api(&self) -> fluent_builders::UpdateRestApi<C, M, R> {
        fluent_builders::UpdateRestApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStage` operation.
    ///
    /// See [`UpdateStage`](crate::client::fluent_builders::UpdateStage) for more information about the
    /// operation and its arguments.
    pub fn update_stage(&self) -> fluent_builders::UpdateStage<C, M, R> {
        fluent_builders::UpdateStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUsage` operation.
    ///
    /// See [`UpdateUsage`](crate::client::fluent_builders::UpdateUsage) for more information about the
    /// operation and its arguments.
    pub fn update_usage(&self) -> fluent_builders::UpdateUsage<C, M, R> {
        fluent_builders::UpdateUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUsagePlan` operation.
    ///
    /// See [`UpdateUsagePlan`](crate::client::fluent_builders::UpdateUsagePlan) for more information about the
    /// operation and its arguments.
    pub fn update_usage_plan(&self) -> fluent_builders::UpdateUsagePlan<C, M, R> {
        fluent_builders::UpdateUsagePlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVpcLink` operation.
    ///
    /// See [`UpdateVpcLink`](crate::client::fluent_builders::UpdateVpcLink) for more information about the
    /// operation and its arguments.
    pub fn update_vpc_link(&self) -> fluent_builders::UpdateVpcLink<C, M, R> {
        fluent_builders::UpdateVpcLink::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApiKey`.
    ///
    /// <p>Create an <a>ApiKey</a> resource. </p>
    /// <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</a></div>
    #[derive(std::fmt::Debug)]
    pub struct CreateApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_api_key_input::Builder,
    }
    impl<C, M, R> CreateApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApiKeyInputOperationOutputAlias,
                crate::output::CreateApiKeyOutput,
                crate::error::CreateApiKeyError,
                crate::input::CreateApiKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <a>ApiKey</a>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <a>ApiKey</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the <a>ApiKey</a>.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the <a>ApiKey</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies whether the <a>ApiKey</a> can be used by callers.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Specifies whether the <a>ApiKey</a> can be used by callers.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.</p>
        pub fn generate_distinct_id(mut self, inp: bool) -> Self {
            self.inner = self.inner.generate_distinct_id(inp);
            self
        }
        /// <p>Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.</p>
        pub fn set_generate_distinct_id(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_generate_distinct_id(input);
            self
        }
        /// <p>Specifies a value of the API key.</p> <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
        pub fn value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(inp);
            self
        }
        /// <p>Specifies a value of the API key.</p> <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
        /// Appends an item to `stageKeys`.
        ///
        /// To override the contents of this collection use [`set_stage_keys`](Self::set_stage_keys).
        ///
        /// <p>DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.</p>
        pub fn stage_keys(mut self, inp: impl Into<crate::model::StageKey>) -> Self {
            self.inner = self.inner.stage_keys(inp);
            self
        }
        /// <p>DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.</p>
        pub fn set_stage_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StageKey>>,
        ) -> Self {
            self.inner = self.inner.set_stage_keys(input);
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn customer_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_id(inp);
            self
        }
        /// <p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>
        pub fn set_customer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_customer_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuthorizer`.
    ///
    /// <p>Adds a new <a>Authorizer</a> resource to an existing <a>RestApi</a> resource.</p>
    /// <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</a></div>
    #[derive(std::fmt::Debug)]
    pub struct CreateAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_authorizer_input::Builder,
    }
    impl<C, M, R> CreateAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAuthorizerInputOperationOutputAlias,
                crate::output::CreateAuthorizerOutput,
                crate::error::CreateAuthorizerError,
                crate::input::CreateAuthorizerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>[Required] The name of the authorizer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>[Required] The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn r#type(mut self, inp: crate::model::AuthorizerType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>[Required] The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizerType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `providerARNs`.
        ///
        /// To override the contents of this collection use [`set_provider_ar_ns`](Self::set_provider_ar_ns).
        ///
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn provider_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_ar_ns(inp);
            self
        }
        /// <p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined.</p>
        pub fn set_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_provider_ar_ns(input);
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn auth_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_type(inp);
            self
        }
        /// <p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>
        pub fn set_auth_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_type(input);
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn authorizer_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_uri(inp);
            self
        }
        /// <p>Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form  <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_uri(input);
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn authorizer_credentials(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_credentials(inp);
            self
        }
        /// <p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>
        pub fn set_authorizer_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_credentials(input);
            self
        }
        /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
        pub fn identity_source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_source(inp);
            self
        }
        /// <p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is  <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>
        pub fn set_identity_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_source(input);
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn identity_validation_expression(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_validation_expression(inp);
            self
        }
        /// <p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_validation_expression(input);
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.authorizer_result_ttl_in_seconds(inp);
            self
        }
        /// <p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_result_ttl_in_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBasePathMapping`.
    ///
    /// <p>Creates a new <a>BasePathMapping</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBasePathMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_base_path_mapping_input::Builder,
    }
    impl<C, M, R> CreateBasePathMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBasePathMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBasePathMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBasePathMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBasePathMappingInputOperationOutputAlias,
                crate::output::CreateBasePathMappingOutput,
                crate::error::CreateBasePathMappingError,
                crate::input::CreateBasePathMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to create.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to create.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.</p>
        pub fn base_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_path(inp);
            self
        }
        /// <p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_base_path(input);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.</p>
        pub fn stage(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage(inp);
            self
        }
        /// <p>The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// <p>Creates a <a>Deployment</a> resource, which makes a specified <a>RestApi</a> callable over the internet.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl<C, M, R> CreateDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeploymentInputOperationOutputAlias,
                crate::output::CreateDeploymentOutput,
                crate::error::CreateDeploymentError,
                crate::input::CreateDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>
        pub fn stage_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_description(inp);
            self
        }
        /// <p>The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>
        pub fn set_stage_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stage_description(input);
            self
        }
        /// <p>The description for the <a>Deployment</a> resource to create.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the <a>Deployment</a> resource to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Enables a cache cluster for the <a>Stage</a> resource specified in the input.</p>
        pub fn cache_cluster_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.cache_cluster_enabled(inp);
            self
        }
        /// <p>Enables a cache cluster for the <a>Stage</a> resource specified in the input.</p>
        pub fn set_cache_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cache_cluster_enabled(input);
            self
        }
        /// <p>Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache cluster is enabled.</p>
        pub fn cache_cluster_size(mut self, inp: crate::model::CacheClusterSize) -> Self {
            self.inner = self.inner.cache_cluster_size(inp);
            self
        }
        /// <p>Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache cluster is enabled.</p>
        pub fn set_cache_cluster_size(
            mut self,
            input: std::option::Option<crate::model::CacheClusterSize>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_size(input);
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>A map that defines the stage variables for the <a>Stage</a> resource that is associated
        /// with the new deployment. Variable names can have alphanumeric and underscore characters, and the values
        /// must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.variables(k, v);
            self
        }
        /// <p>A map that defines the stage variables for the <a>Stage</a> resource that is associated
        /// with the new deployment. Variable names can have alphanumeric and underscore characters, and the values
        /// must match <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_variables(input);
            self
        }
        /// <p>The input configuration for the canary deployment when the deployment is a canary release deployment. </p>
        pub fn canary_settings(mut self, inp: crate::model::DeploymentCanarySettings) -> Self {
            self.inner = self.inner.canary_settings(inp);
            self
        }
        /// <p>The input configuration for the canary deployment when the deployment is a canary release deployment. </p>
        pub fn set_canary_settings(
            mut self,
            input: std::option::Option<crate::model::DeploymentCanarySettings>,
        ) -> Self {
            self.inner = self.inner.set_canary_settings(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn tracing_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.tracing_enabled(inp);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn set_tracing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_tracing_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDocumentationPart`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct CreateDocumentationPart<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_documentation_part_input::Builder,
    }
    impl<C, M, R> CreateDocumentationPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDocumentationPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDocumentationPartOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDocumentationPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDocumentationPartInputOperationOutputAlias,
                crate::output::CreateDocumentationPartOutput,
                crate::error::CreateDocumentationPartError,
                crate::input::CreateDocumentationPartInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The location of the targeted API entity of the to-be-created documentation part.</p>
        pub fn location(mut self, inp: crate::model::DocumentationPartLocation) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>[Required] The location of the targeted API entity of the to-be-created documentation part.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::DocumentationPartLocation>,
        ) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>[Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.</p>
        pub fn properties(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.properties(inp);
            self
        }
        /// <p>[Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.</p>
        pub fn set_properties(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDocumentationVersion`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct CreateDocumentationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_documentation_version_input::Builder,
    }
    impl<C, M, R> CreateDocumentationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDocumentationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDocumentationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDocumentationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDocumentationVersionInputOperationOutputAlias,
                crate::output::CreateDocumentationVersionOutput,
                crate::error::CreateDocumentationVersionError,
                crate::input::CreateDocumentationVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The version identifier of the new snapshot.</p>
        pub fn documentation_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(inp);
            self
        }
        /// <p>[Required] The version identifier of the new snapshot.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
        /// <p>The stage name to be associated with the new documentation snapshot.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>The stage name to be associated with the new documentation snapshot.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>A description about the new documentation snapshot.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description about the new documentation snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainName`.
    ///
    /// <p>Creates a new domain name.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_name_input::Builder,
    }
    impl<C, M, R> CreateDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainNameInputOperationOutputAlias,
                crate::output::CreateDomainNameOutput,
                crate::error::CreateDomainNameError,
                crate::input::CreateDomainNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(inp);
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
        /// <p>[Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.</p>
        pub fn certificate_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_body(inp);
            self
        }
        /// <p>[Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.</p>
        pub fn set_certificate_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_body(input);
            self
        }
        /// <p>[Deprecated] Your edge-optimized endpoint's domain name certificate's private key.</p>
        pub fn certificate_private_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_private_key(inp);
            self
        }
        /// <p>[Deprecated] Your edge-optimized endpoint's domain name certificate's private key.</p>
        pub fn set_certificate_private_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_private_key(input);
            self
        }
        /// <p>[Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.</p>
        pub fn certificate_chain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_chain(inp);
            self
        }
        /// <p>[Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_chain(input);
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn certificate_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(inp);
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by regional endpoint for this domain name.</p>
        pub fn regional_certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regional_certificate_name(inp);
            self
        }
        /// <p>The user-friendly name of the certificate that will be used by regional endpoint for this domain name.</p>
        pub fn set_regional_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regional_certificate_name(input);
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn regional_certificate_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regional_certificate_arn(inp);
            self
        }
        /// <p>The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>
        pub fn set_regional_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regional_certificate_arn(input);
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn endpoint_configuration(mut self, inp: crate::model::EndpointConfiguration) -> Self {
            self.inner = self.inner.endpoint_configuration(inp);
            self
        }
        /// <p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configuration(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn security_policy(mut self, inp: crate::model::SecurityPolicy) -> Self {
            self.inner = self.inner.security_policy(inp);
            self
        }
        /// <p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>
        pub fn set_security_policy(
            mut self,
            input: std::option::Option<crate::model::SecurityPolicy>,
        ) -> Self {
            self.inner = self.inner.set_security_policy(input);
            self
        }
        /// <p>If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.</p>
        pub fn mutual_tls_authentication(
            mut self,
            inp: crate::model::MutualTlsAuthenticationInput,
        ) -> Self {
            self.inner = self.inner.mutual_tls_authentication(inp);
            self
        }
        /// <p>If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.</p>
        pub fn set_mutual_tls_authentication(
            mut self,
            input: std::option::Option<crate::model::MutualTlsAuthenticationInput>,
        ) -> Self {
            self.inner = self.inner.set_mutual_tls_authentication(input);
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn ownership_verification_certificate_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.ownership_verification_certificate_arn(inp);
            self
        }
        /// <p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>
        pub fn set_ownership_verification_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ownership_verification_certificate_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModel`.
    ///
    /// <p>Adds a new <a>Model</a> resource to an existing <a>RestApi</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_input::Builder,
    }
    impl<C, M, R> CreateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelInputOperationOutputAlias,
                crate::output::CreateModelOutput,
                crate::error::CreateModelError,
                crate::input::CreateModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> will be created.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> will be created.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model. Must be alphanumeric.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>[Required] The name of the model. Must be alphanumeric.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the model.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model.</p>
        pub fn schema(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(inp);
            self
        }
        /// <p>The schema for the model. For <code>application/json</code> models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4</a> model.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// <p>[Required] The content-type for the model.</p>
        pub fn content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(inp);
            self
        }
        /// <p>[Required] The content-type for the model.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRequestValidator`.
    ///
    /// <p>Creates a <a>ReqeustValidator</a> of a given <a>RestApi</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRequestValidator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_request_validator_input::Builder,
    }
    impl<C, M, R> CreateRequestValidator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRequestValidator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRequestValidatorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRequestValidatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRequestValidatorInputOperationOutputAlias,
                crate::output::CreateRequestValidatorOutput,
                crate::error::CreateRequestValidatorError,
                crate::input::CreateRequestValidatorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The name of the to-be-created <a>RequestValidator</a>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the to-be-created <a>RequestValidator</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).</p>
        pub fn validate_request_body(mut self, inp: bool) -> Self {
            self.inner = self.inner.validate_request_body(inp);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).</p>
        pub fn set_validate_request_body(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_validate_request_body(input);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.</p>
        pub fn validate_request_parameters(mut self, inp: bool) -> Self {
            self.inner = self.inner.validate_request_parameters(inp);
            self
        }
        /// <p>A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.</p>
        pub fn set_validate_request_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_validate_request_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResource`.
    ///
    /// <p>Creates a <a>Resource</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_input::Builder,
    }
    impl<C, M, R> CreateResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceInputOperationOutputAlias,
                crate::output::CreateResourceOutput,
                crate::error::CreateResourceError,
                crate::input::CreateResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The parent resource's identifier.</p>
        pub fn parent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(inp);
            self
        }
        /// <p>[Required] The parent resource's identifier.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn path_part(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_part(inp);
            self
        }
        /// <p>The last path segment for this resource.</p>
        pub fn set_path_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_part(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRestApi`.
    ///
    /// <p>Creates a new <a>RestApi</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rest_api_input::Builder,
    }
    impl<C, M, R> CreateRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRestApiInputOperationOutputAlias,
                crate::output::CreateRestApiOutput,
                crate::error::CreateRestApiError,
                crate::input::CreateRestApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <a>RestApi</a>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>[Required] The name of the <a>RestApi</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the <a>RestApi</a>.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the <a>RestApi</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>A version identifier for the API.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The ID of the <a>RestApi</a> that you want to clone from.</p>
        pub fn clone_from(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.clone_from(inp);
            self
        }
        /// <p>The ID of the <a>RestApi</a> that you want to clone from.</p>
        pub fn set_clone_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_clone_from(input);
            self
        }
        /// Appends an item to `binaryMediaTypes`.
        ///
        /// To override the contents of this collection use [`set_binary_media_types`](Self::set_binary_media_types).
        ///
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn binary_media_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.binary_media_types(inp);
            self
        }
        /// <p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>
        pub fn set_binary_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_binary_media_types(input);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn minimum_compression_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.minimum_compression_size(inp);
            self
        }
        /// <p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>
        pub fn set_minimum_compression_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_minimum_compression_size(input);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn api_key_source(mut self, inp: crate::model::ApiKeySourceType) -> Self {
            self.inner = self.inner.api_key_source(inp);
            self
        }
        /// <p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul></p>
        pub fn set_api_key_source(
            mut self,
            input: std::option::Option<crate::model::ApiKeySourceType>,
        ) -> Self {
            self.inner = self.inner.set_api_key_source(input);
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn endpoint_configuration(mut self, inp: crate::model::EndpointConfiguration) -> Self {
            self.inner = self.inner.endpoint_configuration(inp);
            self
        }
        /// <p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.</p>
        pub fn set_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configuration(input);
            self
        }
        /// A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn disable_execute_api_endpoint(mut self, inp: bool) -> Self {
            self.inner = self.inner.disable_execute_api_endpoint(inp);
            self
        }
        /// <p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>
        pub fn set_disable_execute_api_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_disable_execute_api_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStage`.
    ///
    /// <p>Creates a new <a>Stage</a> resource that references a pre-existing <a>Deployment</a> for the API. </p>
    /// <!--   <p>Creates a <a>Stage</a> resource.</p>  -->
    #[derive(std::fmt::Debug)]
    pub struct CreateStage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stage_input::Builder,
    }
    impl<C, M, R> CreateStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStageInputOperationOutputAlias,
                crate::output::CreateStageOutput,
                crate::error::CreateStageError,
                crate::input::CreateStageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>[Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.</p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>The description of the <a>Stage</a> resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the <a>Stage</a> resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Whether cache clustering is enabled for the stage.</p>
        pub fn cache_cluster_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.cache_cluster_enabled(inp);
            self
        }
        /// <p>Whether cache clustering is enabled for the stage.</p>
        pub fn set_cache_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cache_cluster_enabled(input);
            self
        }
        /// <p>The stage's cache cluster size.</p>
        pub fn cache_cluster_size(mut self, inp: crate::model::CacheClusterSize) -> Self {
            self.inner = self.inner.cache_cluster_size(inp);
            self
        }
        /// <p>The stage's cache cluster size.</p>
        pub fn set_cache_cluster_size(
            mut self,
            input: std::option::Option<crate::model::CacheClusterSize>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_size(input);
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>A map that defines the stage variables for the new <a>Stage</a> resource. Variable names
        /// can have alphanumeric and underscore characters, and the values must match
        /// <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.variables(k, v);
            self
        }
        /// <p>A map that defines the stage variables for the new <a>Stage</a> resource. Variable names
        /// can have alphanumeric and underscore characters, and the values must match
        /// <code>[A-Za-z0-9-._~:/?#&=,]+</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_variables(input);
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn documentation_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(inp);
            self
        }
        /// <p>The version of the associated API documentation.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
        /// <p>The canary deployment settings of this stage.</p>
        pub fn canary_settings(mut self, inp: crate::model::CanarySettings) -> Self {
            self.inner = self.inner.canary_settings(inp);
            self
        }
        /// <p>The canary deployment settings of this stage.</p>
        pub fn set_canary_settings(
            mut self,
            input: std::option::Option<crate::model::CanarySettings>,
        ) -> Self {
            self.inner = self.inner.set_canary_settings(input);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn tracing_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.tracing_enabled(inp);
            self
        }
        /// <p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>
        pub fn set_tracing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_tracing_enabled(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUsagePlan`.
    ///
    /// <p>Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUsagePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_usage_plan_input::Builder,
    }
    impl<C, M, R> CreateUsagePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUsagePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUsagePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUsagePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUsagePlanInputOperationOutputAlias,
                crate::output::CreateUsagePlanOutput,
                crate::error::CreateUsagePlanError,
                crate::input::CreateUsagePlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the usage plan.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>[Required] The name of the usage plan.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the usage plan.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the usage plan.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `apiStages`.
        ///
        /// To override the contents of this collection use [`set_api_stages`](Self::set_api_stages).
        ///
        /// <p>The associated API stages of the usage plan.</p>
        pub fn api_stages(mut self, inp: impl Into<crate::model::ApiStage>) -> Self {
            self.inner = self.inner.api_stages(inp);
            self
        }
        /// <p>The associated API stages of the usage plan.</p>
        pub fn set_api_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApiStage>>,
        ) -> Self {
            self.inner = self.inner.set_api_stages(input);
            self
        }
        /// <p>The throttling limits of the usage plan.</p>
        pub fn throttle(mut self, inp: crate::model::ThrottleSettings) -> Self {
            self.inner = self.inner.throttle(inp);
            self
        }
        /// <p>The throttling limits of the usage plan.</p>
        pub fn set_throttle(
            mut self,
            input: std::option::Option<crate::model::ThrottleSettings>,
        ) -> Self {
            self.inner = self.inner.set_throttle(input);
            self
        }
        /// <p>The quota of the usage plan.</p>
        pub fn quota(mut self, inp: crate::model::QuotaSettings) -> Self {
            self.inner = self.inner.quota(inp);
            self
        }
        /// <p>The quota of the usage plan.</p>
        pub fn set_quota(
            mut self,
            input: std::option::Option<crate::model::QuotaSettings>,
        ) -> Self {
            self.inner = self.inner.set_quota(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUsagePlanKey`.
    ///
    /// <p>Creates a usage plan key for adding an existing API key to a usage plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUsagePlanKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_usage_plan_key_input::Builder,
    }
    impl<C, M, R> CreateUsagePlanKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUsagePlanKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUsagePlanKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUsagePlanKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUsagePlanKeyInputOperationOutputAlias,
                crate::output::CreateUsagePlanKeyOutput,
                crate::error::CreateUsagePlanKeyError,
                crate::input::CreateUsagePlanKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-created <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(inp);
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-created <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>[Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.</p>
        pub fn key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(inp);
            self
        }
        /// <p>[Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>[Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.</p>
        pub fn key_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_type(inp);
            self
        }
        /// <p>[Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.</p>
        pub fn set_key_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVpcLink`.
    ///
    /// <p>Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_vpc_link_input::Builder,
    }
    impl<C, M, R> CreateVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVpcLinkInputOperationOutputAlias,
                crate::output::CreateVpcLinkOutput,
                crate::error::CreateVpcLinkError,
                crate::input::CreateVpcLinkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name used to label and identify the VPC link.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>[Required] The name used to label and identify the VPC link.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the VPC link.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `targetArns`.
        ///
        /// To override the contents of this collection use [`set_target_arns`](Self::set_target_arns).
        ///
        /// <p>[Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn target_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arns(inp);
            self
        }
        /// <p>[Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>
        pub fn set_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_arns(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiKey`.
    ///
    /// <p>Deletes the <a>ApiKey</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_api_key_input::Builder,
    }
    impl<C, M, R> DeleteApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApiKeyInputOperationOutputAlias,
                crate::output::DeleteApiKeyOutput,
                crate::error::DeleteApiKeyError,
                crate::input::DeleteApiKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource to be deleted.</p>
        pub fn api_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_key(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource to be deleted.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuthorizer`.
    ///
    /// <p>Deletes an existing <a>Authorizer</a> resource.</p>
    /// <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</a></div>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_authorizer_input::Builder,
    }
    impl<C, M, R> DeleteAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAuthorizerInputOperationOutputAlias,
                crate::output::DeleteAuthorizerOutput,
                crate::error::DeleteAuthorizerError,
                crate::input::DeleteAuthorizerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn authorizer_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBasePathMapping`.
    ///
    /// <p>Deletes the <a>BasePathMapping</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBasePathMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_base_path_mapping_input::Builder,
    }
    impl<C, M, R> DeleteBasePathMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBasePathMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBasePathMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBasePathMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBasePathMappingInputOperationOutputAlias,
                crate::output::DeleteBasePathMappingOutput,
                crate::error::DeleteBasePathMappingError,
                crate::input::DeleteBasePathMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to delete.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>[Required] The base path name of the <a>BasePathMapping</a> resource to delete.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn base_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_path(inp);
            self
        }
        /// <p>[Required] The base path name of the <a>BasePathMapping</a> resource to delete.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_base_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClientCertificate`.
    ///
    /// <p>Deletes the <a>ClientCertificate</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_client_certificate_input::Builder,
    }
    impl<C, M, R> DeleteClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClientCertificateInputOperationOutputAlias,
                crate::output::DeleteClientCertificateOutput,
                crate::error::DeleteClientCertificateError,
                crate::input::DeleteClientCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.</p>
        pub fn client_certificate_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeployment`.
    ///
    /// <p>Deletes a <a>Deployment</a> resource. Deleting a deployment will only succeed if there are no <a>Stage</a> resources associated with it.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_deployment_input::Builder,
    }
    impl<C, M, R> DeleteDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeploymentInputOperationOutputAlias,
                crate::output::DeleteDeploymentOutput,
                crate::error::DeleteDeploymentError,
                crate::input::DeleteDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource to delete.</p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource to delete.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDocumentationPart`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct DeleteDocumentationPart<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_documentation_part_input::Builder,
    }
    impl<C, M, R> DeleteDocumentationPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDocumentationPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDocumentationPartOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDocumentationPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDocumentationPartInputOperationOutputAlias,
                crate::output::DeleteDocumentationPartOutput,
                crate::error::DeleteDocumentationPartError,
                crate::input::DeleteDocumentationPartInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the to-be-deleted documentation part.</p>
        pub fn documentation_part_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_part_id(inp);
            self
        }
        /// <p>[Required] The identifier of the to-be-deleted documentation part.</p>
        pub fn set_documentation_part_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_part_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDocumentationVersion`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct DeleteDocumentationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_documentation_version_input::Builder,
    }
    impl<C, M, R> DeleteDocumentationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDocumentationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDocumentationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDocumentationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDocumentationVersionInputOperationOutputAlias,
                crate::output::DeleteDocumentationVersionOutput,
                crate::error::DeleteDocumentationVersionError,
                crate::input::DeleteDocumentationVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The version identifier of a to-be-deleted documentation snapshot.</p>
        pub fn documentation_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(inp);
            self
        }
        /// <p>[Required] The version identifier of a to-be-deleted documentation snapshot.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainName`.
    ///
    /// <p>Deletes the <a>DomainName</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_name_input::Builder,
    }
    impl<C, M, R> DeleteDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainNameInputOperationOutputAlias,
                crate::output::DeleteDomainNameOutput,
                crate::error::DeleteDomainNameError,
                crate::input::DeleteDomainNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource to be deleted.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource to be deleted.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGatewayResponse`.
    ///
    /// <p>Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a> and resets it with the default settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGatewayResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_gateway_response_input::Builder,
    }
    impl<C, M, R> DeleteGatewayResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGatewayResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGatewayResponseInputOperationOutputAlias,
                crate::output::DeleteGatewayResponseOutput,
                crate::error::DeleteGatewayResponseError,
                crate::input::DeleteGatewayResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn response_type(mut self, inp: crate::model::GatewayResponseType) -> Self {
            self.inner = self.inner.response_type(inp);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.inner = self.inner.set_response_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegration`.
    ///
    /// <p>Represents a delete integration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_integration_input::Builder,
    }
    impl<C, M, R> DeleteIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntegrationInputOperationOutputAlias,
                crate::output::DeleteIntegrationOutput,
                crate::error::DeleteIntegrationError,
                crate::input::DeleteIntegrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a delete integration request's resource identifier.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] Specifies a delete integration request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a delete integration request's HTTP method.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies a delete integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegrationResponse`.
    ///
    /// <p>Represents a delete integration response.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_integration_response_input::Builder,
    }
    impl<C, M, R> DeleteIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntegrationResponseInputOperationOutputAlias,
                crate::output::DeleteIntegrationResponseOutput,
                crate::error::DeleteIntegrationResponseError,
                crate::input::DeleteIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a delete integration response request's resource identifier.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] Specifies a delete integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a delete integration response request's HTTP method.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies a delete integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies a delete integration response request's status code.</p>
        pub fn status_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(inp);
            self
        }
        /// <p>[Required] Specifies a delete integration response request's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMethod`.
    ///
    /// <p>Deletes an existing <a>Method</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_method_input::Builder,
    }
    impl<C, M, R> DeleteMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMethodInputOperationOutputAlias,
                crate::output::DeleteMethodOutput,
                crate::error::DeleteMethodError,
                crate::input::DeleteMethodInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMethodResponse`.
    ///
    /// <p>Deletes an existing <a>MethodResponse</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMethodResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_method_response_input::Builder,
    }
    impl<C, M, R> DeleteMethodResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMethodResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMethodResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMethodResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMethodResponseInputOperationOutputAlias,
                crate::output::DeleteMethodResponseOutput,
                crate::error::DeleteMethodResponseError,
                crate::input::DeleteMethodResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The status code identifier for the <a>MethodResponse</a> resource.</p>
        pub fn status_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(inp);
            self
        }
        /// <p>[Required] The status code identifier for the <a>MethodResponse</a> resource.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModel`.
    ///
    /// <p>Deletes a model.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_input::Builder,
    }
    impl<C, M, R> DeleteModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelInputOperationOutputAlias,
                crate::output::DeleteModelOutput,
                crate::error::DeleteModelError,
                crate::input::DeleteModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model to delete.</p>
        pub fn model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(inp);
            self
        }
        /// <p>[Required] The name of the model to delete.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRequestValidator`.
    ///
    /// <p>Deletes a <a>RequestValidator</a> of a given <a>RestApi</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRequestValidator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_request_validator_input::Builder,
    }
    impl<C, M, R> DeleteRequestValidator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRequestValidator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRequestValidatorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRequestValidatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRequestValidatorInputOperationOutputAlias,
                crate::output::DeleteRequestValidatorOutput,
                crate::error::DeleteRequestValidatorError,
                crate::input::DeleteRequestValidatorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <a>RequestValidator</a> to be deleted.</p>
        pub fn request_validator_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_validator_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>RequestValidator</a> to be deleted.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_validator_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResource`.
    ///
    /// <p>Deletes a <a>Resource</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_input::Builder,
    }
    impl<C, M, R> DeleteResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceInputOperationOutputAlias,
                crate::output::DeleteResourceOutput,
                crate::error::DeleteResourceError,
                crate::input::DeleteResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <a>Resource</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>Resource</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRestApi`.
    ///
    /// <p>Deletes the specified API.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rest_api_input::Builder,
    }
    impl<C, M, R> DeleteRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRestApiInputOperationOutputAlias,
                crate::output::DeleteRestApiOutput,
                crate::error::DeleteRestApiError,
                crate::input::DeleteRestApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStage`.
    ///
    /// <p>Deletes a <a>Stage</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stage_input::Builder,
    }
    impl<C, M, R> DeleteStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStageInputOperationOutputAlias,
                crate::output::DeleteStageOutput,
                crate::error::DeleteStageError,
                crate::input::DeleteStageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to delete.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to delete.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUsagePlan`.
    ///
    /// <p>Deletes a usage plan of a given plan Id.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUsagePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_usage_plan_input::Builder,
    }
    impl<C, M, R> DeleteUsagePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUsagePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUsagePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUsagePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUsagePlanInputOperationOutputAlias,
                crate::output::DeleteUsagePlanOutput,
                crate::error::DeleteUsagePlanError,
                crate::input::DeleteUsagePlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the to-be-deleted usage plan.</p>
        pub fn usage_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(inp);
            self
        }
        /// <p>[Required] The Id of the to-be-deleted usage plan.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUsagePlanKey`.
    ///
    /// <p>Deletes a usage plan key  and remove the underlying API key from the associated usage plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUsagePlanKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_usage_plan_key_input::Builder,
    }
    impl<C, M, R> DeleteUsagePlanKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUsagePlanKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUsagePlanKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUsagePlanKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUsagePlanKeyInputOperationOutputAlias,
                crate::output::DeleteUsagePlanKeyOutput,
                crate::error::DeleteUsagePlanKeyError,
                crate::input::DeleteUsagePlanKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-deleted <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(inp);
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-deleted <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlanKey</a> resource to be deleted.</p>
        pub fn key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(inp);
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlanKey</a> resource to be deleted.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVpcLink`.
    ///
    /// <p>Deletes an existing <a>VpcLink</a> of a specified identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_vpc_link_input::Builder,
    }
    impl<C, M, R> DeleteVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVpcLinkInputOperationOutputAlias,
                crate::output::DeleteVpcLinkOutput,
                crate::error::DeleteVpcLinkError,
                crate::input::DeleteVpcLinkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn vpc_link_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(inp);
            self
        }
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FlushStageAuthorizersCache`.
    ///
    /// <p>Flushes all authorizer cache entries on a stage.</p>
    #[derive(std::fmt::Debug)]
    pub struct FlushStageAuthorizersCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::flush_stage_authorizers_cache_input::Builder,
    }
    impl<C, M, R> FlushStageAuthorizersCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FlushStageAuthorizersCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FlushStageAuthorizersCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::FlushStageAuthorizersCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FlushStageAuthorizersCacheInputOperationOutputAlias,
                crate::output::FlushStageAuthorizersCacheOutput,
                crate::error::FlushStageAuthorizersCacheError,
                crate::input::FlushStageAuthorizersCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The name of the stage to flush.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>The name of the stage to flush.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FlushStageCache`.
    ///
    /// <p>Flushes a stage's cache.</p>
    #[derive(std::fmt::Debug)]
    pub struct FlushStageCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::flush_stage_cache_input::Builder,
    }
    impl<C, M, R> FlushStageCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FlushStageCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FlushStageCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::FlushStageCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FlushStageCacheInputOperationOutputAlias,
                crate::output::FlushStageCacheOutput,
                crate::error::FlushStageCacheError,
                crate::input::FlushStageCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the stage to flush its cache.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>[Required] The name of the stage to flush its cache.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateClientCertificate`.
    ///
    /// <p>Generates a <a>ClientCertificate</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GenerateClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_client_certificate_input::Builder,
    }
    impl<C, M, R> GenerateClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateClientCertificateInputOperationOutputAlias,
                crate::output::GenerateClientCertificateOutput,
                crate::error::GenerateClientCertificateError,
                crate::input::GenerateClientCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The description of the <a>ClientCertificate</a>.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the <a>ClientCertificate</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccount`.
    ///
    /// <p>Gets information about the current <a>Account</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_input::Builder,
    }
    impl<C, M, R> GetAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountInputOperationOutputAlias,
                crate::output::GetAccountOutput,
                crate::error::GetAccountError,
                crate::input::GetAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetApiKey`.
    ///
    /// <p>Gets information about the current <a>ApiKey</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_api_key_input::Builder,
    }
    impl<C, M, R> GetApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApiKeyInputOperationOutputAlias,
                crate::output::GetApiKeyOutput,
                crate::error::GetApiKeyError,
                crate::input::GetApiKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource.</p>
        pub fn api_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_key(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_key(input);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.</p>
        pub fn include_value(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_value(inp);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.</p>
        pub fn set_include_value(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApiKeys`.
    ///
    /// <p>Gets information about the current <a>ApiKeys</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApiKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_api_keys_input::Builder,
    }
    impl<C, M, R> GetApiKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApiKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApiKeysInputOperationOutputAlias,
                crate::output::GetApiKeysOutput,
                crate::error::GetApiKeysError,
                crate::input::GetApiKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The name of queried API keys.</p>
        pub fn name_query(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_query(inp);
            self
        }
        /// <p>The name of queried API keys.</p>
        pub fn set_name_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_query(input);
            self
        }
        /// <p>The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.</p>
        pub fn customer_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_id(inp);
            self
        }
        /// <p>The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.</p>
        pub fn set_customer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_customer_id(input);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.</p>
        pub fn include_values(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_values(inp);
            self
        }
        /// <p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.</p>
        pub fn set_include_values(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizer`.
    ///
    /// <p>Describe an existing <a>Authorizer</a> resource.</p>
    /// <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</a></div>
    #[derive(std::fmt::Debug)]
    pub struct GetAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorizer_input::Builder,
    }
    impl<C, M, R> GetAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizerInputOperationOutputAlias,
                crate::output::GetAuthorizerOutput,
                crate::error::GetAuthorizerError,
                crate::input::GetAuthorizerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn authorizer_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizers`.
    ///
    /// <p>Describe an existing <a>Authorizers</a> resource.</p>
    /// <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</a></div>
    #[derive(std::fmt::Debug)]
    pub struct GetAuthorizers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorizers_input::Builder,
    }
    impl<C, M, R> GetAuthorizers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizersInputOperationOutputAlias,
                crate::output::GetAuthorizersOutput,
                crate::error::GetAuthorizersError,
                crate::input::GetAuthorizersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBasePathMapping`.
    ///
    /// <p>Describe a <a>BasePathMapping</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBasePathMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_base_path_mapping_input::Builder,
    }
    impl<C, M, R> GetBasePathMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBasePathMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBasePathMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBasePathMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBasePathMappingInputOperationOutputAlias,
                crate::output::GetBasePathMappingOutput,
                crate::error::GetBasePathMappingError,
                crate::input::GetBasePathMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to be described.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to be described.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>[Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.</p>
        pub fn base_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_path(inp);
            self
        }
        /// <p>[Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_base_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBasePathMappings`.
    ///
    /// <p>Represents a collection of <a>BasePathMapping</a> resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBasePathMappings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_base_path_mappings_input::Builder,
    }
    impl<C, M, R> GetBasePathMappings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBasePathMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBasePathMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBasePathMappingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBasePathMappingsInputOperationOutputAlias,
                crate::output::GetBasePathMappingsOutput,
                crate::error::GetBasePathMappingsError,
                crate::input::GetBasePathMappingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The domain name of a <a>BasePathMapping</a> resource.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>[Required] The domain name of a <a>BasePathMapping</a> resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClientCertificate`.
    ///
    /// <p>Gets information about the current <a>ClientCertificate</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_client_certificate_input::Builder,
    }
    impl<C, M, R> GetClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetClientCertificateInputOperationOutputAlias,
                crate::output::GetClientCertificateOutput,
                crate::error::GetClientCertificateError,
                crate::input::GetClientCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be described.</p>
        pub fn client_certificate_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be described.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClientCertificates`.
    ///
    /// <p>Gets a collection of <a>ClientCertificate</a> resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetClientCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_client_certificates_input::Builder,
    }
    impl<C, M, R> GetClientCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetClientCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClientCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetClientCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetClientCertificatesInputOperationOutputAlias,
                crate::output::GetClientCertificatesOutput,
                crate::error::GetClientCertificatesError,
                crate::input::GetClientCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployment`.
    ///
    /// <p>Gets information about a <a>Deployment</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployment_input::Builder,
    }
    impl<C, M, R> GetDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentInputOperationOutputAlias,
                crate::output::GetDeploymentOutput,
                crate::error::GetDeploymentError,
                crate::input::GetDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource to get information about.</p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>Deployment</a> resource to get information about.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// Appends an item to `embed`.
        ///
        /// To override the contents of this collection use [`set_embed`](Self::set_embed).
        ///
        /// <p>A query parameter to retrieve the specified embedded resources of the returned <a>Deployment</a> resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in  <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string.  For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.</p>
        pub fn embed(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed(inp);
            self
        }
        /// <p>A query parameter to retrieve the specified embedded resources of the returned <a>Deployment</a> resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in  <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string.  For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.</p>
        pub fn set_embed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployments`.
    ///
    /// <p>Gets information about a <a>Deployments</a> collection.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeployments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployments_input::Builder,
    }
    impl<C, M, R> GetDeployments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentsInputOperationOutputAlias,
                crate::output::GetDeploymentsOutput,
                crate::error::GetDeploymentsError,
                crate::input::GetDeploymentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentationPart`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct GetDocumentationPart<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_documentation_part_input::Builder,
    }
    impl<C, M, R> GetDocumentationPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentationPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentationPartOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentationPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentationPartInputOperationOutputAlias,
                crate::output::GetDocumentationPartOutput,
                crate::error::GetDocumentationPartError,
                crate::input::GetDocumentationPartInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn documentation_part_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_part_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_documentation_part_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_part_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentationParts`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct GetDocumentationParts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_documentation_parts_input::Builder,
    }
    impl<C, M, R> GetDocumentationParts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentationParts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentationPartsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentationPartsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentationPartsInputOperationOutputAlias,
                crate::output::GetDocumentationPartsOutput,
                crate::error::GetDocumentationPartsError,
                crate::input::GetDocumentationPartsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The type of API entities of the to-be-retrieved documentation parts. </p>
        pub fn r#type(mut self, inp: crate::model::DocumentationPartType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of API entities of the to-be-retrieved documentation parts. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DocumentationPartType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of API entities of the to-be-retrieved documentation parts.</p>
        pub fn name_query(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_query(inp);
            self
        }
        /// <p>The name of API entities of the to-be-retrieved documentation parts.</p>
        pub fn set_name_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_query(input);
            self
        }
        /// <p>The path of API entities of the to-be-retrieved documentation parts.</p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p>The path of API entities of the to-be-retrieved documentation parts.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving <a>DocumentationPart</a> resources with content and <code>UNDOCUMENTED</code> for <a>DocumentationPart</a> resources without content.</p>
        pub fn location_status(mut self, inp: crate::model::LocationStatusType) -> Self {
            self.inner = self.inner.location_status(inp);
            self
        }
        /// <p>The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving <a>DocumentationPart</a> resources with content and <code>UNDOCUMENTED</code> for <a>DocumentationPart</a> resources without content.</p>
        pub fn set_location_status(
            mut self,
            input: std::option::Option<crate::model::LocationStatusType>,
        ) -> Self {
            self.inner = self.inner.set_location_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentationVersion`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct GetDocumentationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_documentation_version_input::Builder,
    }
    impl<C, M, R> GetDocumentationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentationVersionInputOperationOutputAlias,
                crate::output::GetDocumentationVersionOutput,
                crate::error::GetDocumentationVersionError,
                crate::input::GetDocumentationVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The version identifier of the to-be-retrieved documentation snapshot.</p>
        pub fn documentation_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(inp);
            self
        }
        /// <p>[Required] The version identifier of the to-be-retrieved documentation snapshot.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentationVersions`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct GetDocumentationVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_documentation_versions_input::Builder,
    }
    impl<C, M, R> GetDocumentationVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentationVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentationVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentationVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentationVersionsInputOperationOutputAlias,
                crate::output::GetDocumentationVersionsOutput,
                crate::error::GetDocumentationVersionsError,
                crate::input::GetDocumentationVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainName`.
    ///
    /// <p>Represents a domain name that is contained in a simpler, more intuitive URL that can be called.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_name_input::Builder,
    }
    impl<C, M, R> GetDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainNameInputOperationOutputAlias,
                crate::output::GetDomainNameOutput,
                crate::error::GetDomainNameError,
                crate::input::GetDomainNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainNames`.
    ///
    /// <p>Represents a collection of <a>DomainName</a> resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomainNames<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_names_input::Builder,
    }
    impl<C, M, R> GetDomainNames<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainNamesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainNamesInputOperationOutputAlias,
                crate::output::GetDomainNamesOutput,
                crate::error::GetDomainNamesError,
                crate::input::GetDomainNamesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExport`.
    ///
    /// <p>Exports a deployed version of a <a>RestApi</a> in a specified format.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetExport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_export_input::Builder,
    }
    impl<C, M, R> GetExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExportInputOperationOutputAlias,
                crate::output::GetExportOutput,
                crate::error::GetExportError,
                crate::input::GetExportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> that will be exported.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> that will be exported.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>[Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.</p>
        pub fn export_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_type(inp);
            self
        }
        /// <p>[Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.</p>
        pub fn set_export_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_type(input);
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API with  x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API with  x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.</p>
        pub fn accepts(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accepts(inp);
            self
        }
        /// <p>The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.</p>
        pub fn set_accepts(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_accepts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGatewayResponse`.
    ///
    /// <p>Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGatewayResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_gateway_response_input::Builder,
    }
    impl<C, M, R> GetGatewayResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGatewayResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGatewayResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGatewayResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGatewayResponseInputOperationOutputAlias,
                crate::output::GetGatewayResponseOutput,
                crate::error::GetGatewayResponseError,
                crate::input::GetGatewayResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn response_type(mut self, inp: crate::model::GatewayResponseType) -> Self {
            self.inner = self.inner.response_type(inp);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.inner = self.inner.set_response_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGatewayResponses`.
    ///
    /// <p>Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default <a>GatewayResponses</a> collection for the supported response types.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGatewayResponses<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_gateway_responses_input::Builder,
    }
    impl<C, M, R> GetGatewayResponses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGatewayResponses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGatewayResponsesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGatewayResponsesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGatewayResponsesInputOperationOutputAlias,
                crate::output::GetGatewayResponsesOutput,
                crate::error::GetGatewayResponsesError,
                crate::input::GetGatewayResponsesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The <a>GatewayResponses</a> collection does not support pagination and the limit does not apply here.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The <a>GatewayResponses</a> collection does not support pagination and the limit does not apply here.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegration`.
    ///
    /// <p>Get the integration settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_integration_input::Builder,
    }
    impl<C, M, R> GetIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntegrationInputOperationOutputAlias,
                crate::output::GetIntegrationOutput,
                crate::error::GetIntegrationError,
                crate::input::GetIntegrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a get integration request's resource identifier</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] Specifies a get integration request's resource identifier</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a get integration request's HTTP method.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies a get integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegrationResponse`.
    ///
    /// <p>Represents a get integration response.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_integration_response_input::Builder,
    }
    impl<C, M, R> GetIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntegrationResponseInputOperationOutputAlias,
                crate::output::GetIntegrationResponseOutput,
                crate::error::GetIntegrationResponseError,
                crate::input::GetIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a get integration response request's resource identifier.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] Specifies a get integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a get integration response request's HTTP method.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies a get integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies a get integration response request's status code.</p>
        pub fn status_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(inp);
            self
        }
        /// <p>[Required] Specifies a get integration response request's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMethod`.
    ///
    /// <p>Describe an existing <a>Method</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_method_input::Builder,
    }
    impl<C, M, R> GetMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMethodInputOperationOutputAlias,
                crate::output::GetMethodOutput,
                crate::error::GetMethodError,
                crate::input::GetMethodInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMethodResponse`.
    ///
    /// <p>Describes a <a>MethodResponse</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMethodResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_method_response_input::Builder,
    }
    impl<C, M, R> GetMethodResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMethodResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMethodResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMethodResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMethodResponseInputOperationOutputAlias,
                crate::output::GetMethodResponseOutput,
                crate::error::GetMethodResponseError,
                crate::input::GetMethodResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The status code for the <a>MethodResponse</a> resource.</p>
        pub fn status_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(inp);
            self
        }
        /// <p>[Required] The status code for the <a>MethodResponse</a> resource.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModel`.
    ///
    /// <p>Describes an existing model defined for a <a>RestApi</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_model_input::Builder,
    }
    impl<C, M, R> GetModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelInputOperationOutputAlias,
                crate::output::GetModelOutput,
                crate::error::GetModelError,
                crate::input::GetModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> exists.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> exists.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model as an identifier.</p>
        pub fn model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(inp);
            self
        }
        /// <p>[Required] The name of the model as an identifier.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
        /// <p>A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.</p>
        pub fn flatten(mut self, inp: bool) -> Self {
            self.inner = self.inner.flatten(inp);
            self
        }
        /// <p>A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.</p>
        pub fn set_flatten(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_flatten(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModels`.
    ///
    /// <p>Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetModels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_models_input::Builder,
    }
    impl<C, M, R> GetModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelsInputOperationOutputAlias,
                crate::output::GetModelsOutput,
                crate::error::GetModelsError,
                crate::input::GetModelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModelTemplate`.
    ///
    /// <p>Generates a sample mapping template that can be used to transform a payload into the structure of a model.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetModelTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_model_template_input::Builder,
    }
    impl<C, M, R> GetModelTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModelTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelTemplateInputOperationOutputAlias,
                crate::output::GetModelTemplateOutput,
                crate::error::GetModelTemplateError,
                crate::input::GetModelTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model for which to generate a template.</p>
        pub fn model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(inp);
            self
        }
        /// <p>[Required] The name of the model for which to generate a template.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRequestValidator`.
    ///
    /// <p>Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRequestValidator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_request_validator_input::Builder,
    }
    impl<C, M, R> GetRequestValidator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRequestValidator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRequestValidatorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRequestValidatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRequestValidatorInputOperationOutputAlias,
                crate::output::GetRequestValidatorOutput,
                crate::error::GetRequestValidatorError,
                crate::input::GetRequestValidatorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <a>RequestValidator</a> to be retrieved.</p>
        pub fn request_validator_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_validator_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>RequestValidator</a> to be retrieved.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_validator_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRequestValidators`.
    ///
    /// <p>Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRequestValidators<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_request_validators_input::Builder,
    }
    impl<C, M, R> GetRequestValidators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRequestValidators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRequestValidatorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRequestValidatorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRequestValidatorsInputOperationOutputAlias,
                crate::output::GetRequestValidatorsOutput,
                crate::error::GetRequestValidatorsError,
                crate::input::GetRequestValidatorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResource`.
    ///
    /// <p>Lists information about a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_input::Builder,
    }
    impl<C, M, R> GetResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceInputOperationOutputAlias,
                crate::output::GetResourceOutput,
                crate::error::GetResourceError,
                crate::input::GetResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier for the <a>Resource</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The identifier for the <a>Resource</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `embed`.
        ///
        /// To override the contents of this collection use [`set_embed`](Self::set_embed).
        ///
        /// <p>A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a> representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.</p>
        pub fn embed(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed(inp);
            self
        }
        /// <p>A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a> representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.</p>
        pub fn set_embed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResources`.
    ///
    /// <p>Lists information about a collection of <a>Resource</a> resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resources_input::Builder,
    }
    impl<C, M, R> GetResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcesInputOperationOutputAlias,
                crate::output::GetResourcesOutput,
                crate::error::GetResourcesError,
                crate::input::GetResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// Appends an item to `embed`.
        ///
        /// To override the contents of this collection use [`set_embed`](Self::set_embed).
        ///
        /// <p>A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a> resource in the response.  This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.</p>
        pub fn embed(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed(inp);
            self
        }
        /// <p>A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a> resource in the response.  This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.</p>
        pub fn set_embed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRestApi`.
    ///
    /// <p>Lists the <a>RestApi</a> resource in the collection.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rest_api_input::Builder,
    }
    impl<C, M, R> GetRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRestApiInputOperationOutputAlias,
                crate::output::GetRestApiOutput,
                crate::error::GetRestApiError,
                crate::input::GetRestApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRestApis`.
    ///
    /// <p>Lists the <a>RestApis</a> resources for your collection.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRestApis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rest_apis_input::Builder,
    }
    impl<C, M, R> GetRestApis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRestApis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRestApisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRestApisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRestApisInputOperationOutputAlias,
                crate::output::GetRestApisOutput,
                crate::error::GetRestApisError,
                crate::input::GetRestApisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSdk`.
    ///
    /// <p>Generates a client SDK for a <a>RestApi</a> and <a>Stage</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSdk<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sdk_input::Builder,
    }
    impl<C, M, R> GetSdk<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSdk`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSdkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSdkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSdkInputOperationOutputAlias,
                crate::output::GetSdkOutput,
                crate::error::GetSdkError,
                crate::input::GetSdkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> that the SDK will use.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> that the SDK will use.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>[Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code>  are supported.</p>
        pub fn sdk_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sdk_type(inp);
            self
        }
        /// <p>[Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code>  are supported.</p>
        pub fn set_sdk_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sdk_type(input);
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>,  a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. </p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>,  a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSdkType`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct GetSdkType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sdk_type_input::Builder,
    }
    impl<C, M, R> GetSdkType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSdkType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSdkTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSdkTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSdkTypeInputOperationOutputAlias,
                crate::output::GetSdkTypeOutput,
                crate::error::GetSdkTypeError,
                crate::input::GetSdkTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the queried <a>SdkType</a> instance.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>[Required] The identifier of the queried <a>SdkType</a> instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSdkTypes`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct GetSdkTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sdk_types_input::Builder,
    }
    impl<C, M, R> GetSdkTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSdkTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSdkTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSdkTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSdkTypesInputOperationOutputAlias,
                crate::output::GetSdkTypesOutput,
                crate::error::GetSdkTypesError,
                crate::input::GetSdkTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStage`.
    ///
    /// <p>Gets information about a <a>Stage</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stage_input::Builder,
    }
    impl<C, M, R> GetStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStageInputOperationOutputAlias,
                crate::output::GetStageOutput,
                crate::error::GetStageError,
                crate::input::GetStageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to get information about.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to get information about.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStages`.
    ///
    /// <p>Gets information about one or more <a>Stage</a> resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stages_input::Builder,
    }
    impl<C, M, R> GetStages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStagesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStagesInputOperationOutputAlias,
                crate::output::GetStagesOutput,
                crate::error::GetStagesError,
                crate::input::GetStagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The stages' deployment identifiers.</p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p>The stages' deployment identifiers.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTags`.
    ///
    /// <p>Gets the <a>Tags</a> collection for a given resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_tags_input::Builder,
    }
    impl<C, M, R> GetTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTagsInputOperationOutputAlias,
                crate::output::GetTagsOutput,
                crate::error::GetTagsError,
                crate::input::GetTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>(Not currently supported) The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>(Not currently supported) The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>(Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>(Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsage`.
    ///
    /// <p>Gets the usage data of a usage plan in a specified time interval.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_input::Builder,
    }
    impl<C, M, R> GetUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsageInputOperationOutputAlias,
                crate::output::GetUsageOutput,
                crate::error::GetUsageError,
                crate::input::GetUsageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the usage plan associated with the usage data.</p>
        pub fn usage_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(inp);
            self
        }
        /// <p>[Required] The Id of the usage plan associated with the usage data.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>The Id of the API key associated with the resultant usage data.</p>
        pub fn key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(inp);
            self
        }
        /// <p>The Id of the API key associated with the resultant usage data.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>[Required] The starting date (e.g., 2016-01-01) of the usage data.</p>
        pub fn start_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_date(inp);
            self
        }
        /// <p>[Required] The starting date (e.g., 2016-01-01) of the usage data.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>[Required] The ending date (e.g., 2016-12-31) of the usage data.</p>
        pub fn end_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.end_date(inp);
            self
        }
        /// <p>[Required] The ending date (e.g., 2016-12-31) of the usage data.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsagePlan`.
    ///
    /// <p>Gets a usage plan of a given plan identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUsagePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_plan_input::Builder,
    }
    impl<C, M, R> GetUsagePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsagePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsagePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsagePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsagePlanInputOperationOutputAlias,
                crate::output::GetUsagePlanOutput,
                crate::error::GetUsagePlanError,
                crate::input::GetUsagePlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.</p>
        pub fn usage_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsagePlanKey`.
    ///
    /// <p>Gets a usage plan key of a given key identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUsagePlanKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_plan_key_input::Builder,
    }
    impl<C, M, R> GetUsagePlanKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsagePlanKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsagePlanKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsagePlanKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsagePlanKeyInputOperationOutputAlias,
                crate::output::GetUsagePlanKeyOutput,
                crate::error::GetUsagePlanKeyError,
                crate::input::GetUsagePlanKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(inp);
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>[Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(inp);
            self
        }
        /// <p>[Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsagePlanKeys`.
    ///
    /// <p>Gets all the usage plan keys representing the API keys added to a specified usage plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUsagePlanKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_plan_keys_input::Builder,
    }
    impl<C, M, R> GetUsagePlanKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsagePlanKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsagePlanKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsagePlanKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsagePlanKeysInputOperationOutputAlias,
                crate::output::GetUsagePlanKeysOutput,
                crate::error::GetUsagePlanKeysError,
                crate::input::GetUsagePlanKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn usage_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(inp);
            self
        }
        /// <p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>A query parameter specifying the name of the to-be-returned usage plan keys.</p>
        pub fn name_query(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_query(inp);
            self
        }
        /// <p>A query parameter specifying the name of the to-be-returned usage plan keys.</p>
        pub fn set_name_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_query(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsagePlans`.
    ///
    /// <p>Gets all the usage plans of the caller's account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUsagePlans<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_plans_input::Builder,
    }
    impl<C, M, R> GetUsagePlans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsagePlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsagePlansOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsagePlansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsagePlansInputOperationOutputAlias,
                crate::output::GetUsagePlansOutput,
                crate::error::GetUsagePlansError,
                crate::input::GetUsagePlansInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The identifier of the API key associated with the usage plans.</p>
        pub fn key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(inp);
            self
        }
        /// <p>The identifier of the API key associated with the usage plans.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcLink`.
    ///
    /// <p>Gets a specified VPC link under the caller's account in a region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_vpc_link_input::Builder,
    }
    impl<C, M, R> GetVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVpcLinkInputOperationOutputAlias,
                crate::output::GetVpcLinkOutput,
                crate::error::GetVpcLinkError,
                crate::input::GetVpcLinkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn vpc_link_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(inp);
            self
        }
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVpcLinks`.
    ///
    /// <p>Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVpcLinks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_vpc_links_input::Builder,
    }
    impl<C, M, R> GetVpcLinks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVpcLinks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpcLinksOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVpcLinksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVpcLinksInputOperationOutputAlias,
                crate::output::GetVpcLinksOutput,
                crate::error::GetVpcLinksError,
                crate::input::GetVpcLinksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The current pagination position in the paged result set.</p>
        pub fn set_position(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportApiKeys`.
    ///
    /// <p>Import API keys from an external source, such as a CSV-formatted file.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportApiKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_api_keys_input::Builder,
    }
    impl<C, M, R> ImportApiKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportApiKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportApiKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportApiKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportApiKeysInputOperationOutputAlias,
                crate::output::ImportApiKeysOutput,
                crate::error::ImportApiKeysError,
                crate::input::ImportApiKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format</a>.</p>
        pub fn body(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.body(inp);
            self
        }
        /// <p>The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format</a>.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// <p>A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.</p>
        pub fn format(mut self, inp: crate::model::ApiKeysFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ApiKeysFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback <a>ApiKey</a> importation (<code>true</code>) or not (<code>false</code>) when error is encountered.</p>
        pub fn fail_on_warnings(mut self, inp: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(inp);
            self
        }
        /// <p>A query parameter to indicate whether to rollback <a>ApiKey</a> importation (<code>true</code>) or not (<code>false</code>) when error is encountered.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportDocumentationParts`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct ImportDocumentationParts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_documentation_parts_input::Builder,
    }
    impl<C, M, R> ImportDocumentationParts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportDocumentationParts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportDocumentationPartsOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportDocumentationPartsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportDocumentationPartsInputOperationOutputAlias,
                crate::output::ImportDocumentationPartsOutput,
                crate::error::ImportDocumentationPartsError,
                crate::input::ImportDocumentationPartsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing one. The default value is <code>MERGE</code>.</p>
        pub fn mode(mut self, inp: crate::model::PutMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing one. The default value is <code>MERGE</code>.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::PutMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn fail_on_warnings(mut self, inp: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(inp);
            self
        }
        /// <p>A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
        /// <p>[Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.</p>
        pub fn body(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.body(inp);
            self
        }
        /// <p>[Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportRestApi`.
    ///
    /// <p>A feature of the API Gateway control service for creating a new API from an external API definition file.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_rest_api_input::Builder,
    }
    impl<C, M, R> ImportRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportRestApiInputOperationOutputAlias,
                crate::output::ImportRestApiOutput,
                crate::error::ImportRestApiError,
                crate::input::ImportRestApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>)
        /// when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn fail_on_warnings(mut self, inp: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(inp);
            self
        }
        /// <p>A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>)
        /// when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.</p>
        /// <p> To exclude <a>DocumentationParts</a> from the import, set <code>parameters</code> as <code>ignore=documentation</code>.</p>
        /// <p> To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.</p>
        /// <p> To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>.</p>
        /// <p>For example, the AWS CLI command to exclude documentation from the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code></pre>
        /// <p>The AWS CLI command to set the regional endpoint on the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code></pre>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.</p>
        /// <p> To exclude <a>DocumentationParts</a> from the import, set <code>parameters</code> as <code>ignore=documentation</code>.</p>
        /// <p> To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.</p>
        /// <p> To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>.</p>
        /// <p>For example, the AWS CLI command to exclude documentation from the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code></pre>
        /// <p>The AWS CLI command to set the regional endpoint on the imported API is:</p>
        /// <pre><code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code></pre>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>[Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn body(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.body(inp);
            self
        }
        /// <p>[Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutGatewayResponse`.
    ///
    /// <p>Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given <a>RestApi</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutGatewayResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_gateway_response_input::Builder,
    }
    impl<C, M, R> PutGatewayResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutGatewayResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutGatewayResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::PutGatewayResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutGatewayResponseInputOperationOutputAlias,
                crate::output::PutGatewayResponseOutput,
                crate::error::PutGatewayResponseError,
                crate::input::PutGatewayResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn response_type(mut self, inp: crate::model::GatewayResponseType) -> Self {
            self.inner = self.inner.response_type(inp);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.inner = self.inner.set_response_type(input);
            self
        }
        /// The HTTP status code of the <a>GatewayResponse</a>.
        pub fn status_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(inp);
            self
        }
        /// The HTTP status code of the <a>GatewayResponse</a>.
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// Adds a key-value pair to `responseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p><p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p></p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k, v);
            self
        }
        /// <p><p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value  pairs.</p></p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `responseTemplates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p><p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p></p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_templates(k, v);
            self
        }
        /// <p><p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p></p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_templates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutIntegration`.
    ///
    /// <p>Sets up a method's integration.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_integration_input::Builder,
    }
    impl<C, M, R> PutIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutIntegrationInputOperationOutputAlias,
                crate::output::PutIntegrationOutput,
                crate::error::PutIntegrationError,
                crate::input::PutIntegrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a put integration request's resource ID.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] Specifies a put integration request's resource ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a put integration request's HTTP method.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies a put integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies a put integration input's type.</p>
        pub fn r#type(mut self, inp: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>[Required] Specifies a put integration input's type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.</p>
        pub fn integration_http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_http_method(inp);
            self
        }
        /// <p>Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.</p>
        pub fn set_integration_http_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_http_method(input);
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(inp);
            self
        }
        /// <p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p>
        /// <ul>
        /// <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p>
        /// </li>
        /// <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&{p1}={v1}&p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing  <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}</code> or  <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p>
        /// </li></ul>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn connection_type(mut self, inp: crate::model::ConnectionType) -> Self {
            self.inner = self.inner.connection_type(inp);
            self
        }
        /// <p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.inner = self.inner.set_connection_type(input);
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>Specifies whether credentials are required for a put integration.</p>
        pub fn credentials(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.credentials(inp);
            self
        }
        /// <p>Specifies whether credentials are required for a put integration.</p>
        pub fn set_credentials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_credentials(input);
            self
        }
        /// Adds a key-value pair to `requestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_parameters(k, v);
            self
        }
        /// <p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// Adds a key-value pair to `requestTemplates`.
        ///
        /// To override the contents of this collection use [`set_request_templates`](Self::set_request_templates).
        ///
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn request_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_templates(k, v);
            self
        }
        /// <p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>
        pub fn set_request_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_templates(input);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values:  <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>.
        /// </p>
        /// <ul>
        /// <li><p><code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration back end without transformation.</p></li>
        /// <li><p><code>NEVER</code> rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.</p></li>
        /// <li><p><code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.</p></li>
        /// </ul>
        pub fn passthrough_behavior(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.passthrough_behavior(inp);
            self
        }
        /// <p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values:  <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>.
        /// </p>
        /// <ul>
        /// <li><p><code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration back end without transformation.</p></li>
        /// <li><p><code>NEVER</code> rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.</p></li>
        /// <li><p><code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.</p></li>
        /// </ul>
        pub fn set_passthrough_behavior(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_passthrough_behavior(input);
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn cache_namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_namespace(inp);
            self
        }
        /// <p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>
        pub fn set_cache_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_namespace(input);
            self
        }
        /// Appends an item to `cacheKeyParameters`.
        ///
        /// To override the contents of this collection use [`set_cache_key_parameters`](Self::set_cache_key_parameters).
        ///
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn cache_key_parameters(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_key_parameters(inp);
            self
        }
        /// <p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>
        pub fn set_cache_key_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_key_parameters(input);
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn content_handling(mut self, inp: crate::model::ContentHandlingStrategy) -> Self {
            self.inner = self.inner.content_handling(inp);
            self
        }
        /// <p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling(input);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn timeout_in_millis(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout_in_millis(inp);
            self
        }
        /// <p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>
        pub fn set_timeout_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_millis(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn tls_config(mut self, inp: crate::model::TlsConfig) -> Self {
            self.inner = self.inner.tls_config(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_tls_config(
            mut self,
            input: std::option::Option<crate::model::TlsConfig>,
        ) -> Self {
            self.inner = self.inner.set_tls_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutIntegrationResponse`.
    ///
    /// <p>Represents a put integration.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_integration_response_input::Builder,
    }
    impl<C, M, R> PutIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::PutIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutIntegrationResponseInputOperationOutputAlias,
                crate::output::PutIntegrationResponseOutput,
                crate::error::PutIntegrationResponseError,
                crate::input::PutIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a put integration response request's resource identifier.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] Specifies a put integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a put integration response request's HTTP method.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies a put integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn status_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(inp);
            self
        }
        /// <p>[Required] Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// <p>Specifies the selection pattern of a put integration response.</p>
        pub fn selection_pattern(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selection_pattern(inp);
            self
        }
        /// <p>Specifies the selection pattern of a put integration response.</p>
        pub fn set_selection_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_selection_pattern(input);
            self
        }
        /// Adds a key-value pair to `responseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k, v);
            self
        }
        /// <p>A key-value map specifying response parameters that are passed to the method response from the back end.
        /// The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `responseTemplates`.
        ///
        /// To override the contents of this collection use [`set_response_templates`](Self::set_response_templates).
        ///
        /// <p>Specifies a put integration response's templates.</p>
        pub fn response_templates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_templates(k, v);
            self
        }
        /// <p>Specifies a put integration response's templates.</p>
        pub fn set_response_templates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_templates(input);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn content_handling(mut self, inp: crate::model::ContentHandlingStrategy) -> Self {
            self.inner = self.inner.content_handling(inp);
            self
        }
        /// <p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
        /// <ul>
        /// <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li>
        /// <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li>
        /// </ul>
        /// <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>
        pub fn set_content_handling(
            mut self,
            input: std::option::Option<crate::model::ContentHandlingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_content_handling(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMethod`.
    ///
    /// <p>Add a method to an existing <a>Resource</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_method_input::Builder,
    }
    impl<C, M, R> PutMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMethodInputOperationOutputAlias,
                crate::output::PutMethodOutput,
                crate::error::PutMethodError,
                crate::input::PutMethodInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies the method request's HTTP method type.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn authorization_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_type(inp);
            self
        }
        /// <p>[Required] The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn authorizer_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(inp);
            self
        }
        /// <p>Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// <p>Specifies whether the method required a valid <a>ApiKey</a>.</p>
        pub fn api_key_required(mut self, inp: bool) -> Self {
            self.inner = self.inner.api_key_required(inp);
            self
        }
        /// <p>Specifies whether the method required a valid <a>ApiKey</a>.</p>
        pub fn set_api_key_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_api_key_required(input);
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn operation_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_name(inp);
            self
        }
        /// <p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operation_name(input);
            self
        }
        /// Adds a key-value pair to `requestParameters`.
        ///
        /// To override the contents of this collection use [`set_request_parameters`](Self::set_request_parameters).
        ///
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or body-mapping templates.</p>
        pub fn request_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            self.inner = self.inner.request_parameters(k, v);
            self
        }
        /// <p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of  <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>).  The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or body-mapping templates.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.inner = self.inner.set_request_parameters(input);
            self
        }
        /// Adds a key-value pair to `requestModels`.
        ///
        /// To override the contents of this collection use [`set_request_models`](Self::set_request_models).
        ///
        /// <p>Specifies the <a>Model</a> resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>
        pub fn request_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_models(k, v);
            self
        }
        /// <p>Specifies the <a>Model</a> resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>
        pub fn set_request_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_models(input);
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for validating the method request.</p>
        pub fn request_validator_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_validator_id(inp);
            self
        }
        /// <p>The identifier of a <a>RequestValidator</a> for validating the method request.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_validator_id(input);
            self
        }
        /// Appends an item to `authorizationScopes`.
        ///
        /// To override the contents of this collection use [`set_authorization_scopes`](Self::set_authorization_scopes).
        ///
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn authorization_scopes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_scopes(inp);
            self
        }
        /// <p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>
        pub fn set_authorization_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_authorization_scopes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMethodResponse`.
    ///
    /// <p>Adds a <a>MethodResponse</a> to an existing <a>Method</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutMethodResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_method_response_input::Builder,
    }
    impl<C, M, R> PutMethodResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMethodResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMethodResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMethodResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMethodResponseInputOperationOutputAlias,
                crate::output::PutMethodResponseOutput,
                crate::error::PutMethodResponseError,
                crate::input::PutMethodResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The method response's status code.</p>
        pub fn status_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(inp);
            self
        }
        /// <p>[Required] The method response's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// Adds a key-value pair to `responseParameters`.
        ///
        /// To override the contents of this collection use [`set_response_parameters`](Self::set_response_parameters).
        ///
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn response_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            self.inner = self.inner.response_parameters(k, v);
            self
        }
        /// <p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>
        pub fn set_response_parameters(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.inner = self.inner.set_response_parameters(input);
            self
        }
        /// Adds a key-value pair to `responseModels`.
        ///
        /// To override the contents of this collection use [`set_response_models`](Self::set_response_models).
        ///
        /// <p>Specifies the <a>Model</a> resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>
        pub fn response_models(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_models(k, v);
            self
        }
        /// <p>Specifies the <a>Model</a> resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>
        pub fn set_response_models(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_response_models(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRestApi`.
    ///
    /// <p>A feature of the API Gateway control service for updating an existing API with an input of external API definitions.
    /// The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_rest_api_input::Builder,
    }
    impl<C, M, R> PutRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRestApiInputOperationOutputAlias,
                crate::output::PutRestApiOutput,
                crate::error::PutRestApiError,
                crate::input::PutRestApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default,
        /// the update mode is "merge".</p>
        pub fn mode(mut self, inp: crate::model::PutMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default,
        /// the update mode is "merge".</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::PutMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>)
        /// when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn fail_on_warnings(mut self, inp: bool) -> Self {
            self.inner = self.inner.fail_on_warnings(inp);
            self
        }
        /// <p>A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>)
        /// when a warning is encountered. The default value is <code>false</code>.</p>
        pub fn set_fail_on_warnings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fail_on_warnings(input);
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Custom header parameters as part of the request. For example, to exclude <a>DocumentationParts</a> from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>Custom header parameters as part of the request. For example, to exclude <a>DocumentationParts</a> from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>[Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn body(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.body(inp);
            self
        }
        /// <p>[Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates a tag on a given resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>[Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>[Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestInvokeAuthorizer`.
    ///
    /// <p>Simulate the execution of an <a>Authorizer</a> in your <a>RestApi</a> with headers, parameters, and an incoming request body.</p>
    /// <div class="seeAlso">
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer</a>
    /// <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer</a>
    /// </div>
    #[derive(std::fmt::Debug)]
    pub struct TestInvokeAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_invoke_authorizer_input::Builder,
    }
    impl<C, M, R> TestInvokeAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestInvokeAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestInvokeAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::TestInvokeAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestInvokeAuthorizerInputOperationOutputAlias,
                crate::output::TestInvokeAuthorizerOutput,
                crate::error::TestInvokeAuthorizerError,
                crate::input::TestInvokeAuthorizerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a test invoke authorizer request's <a>Authorizer</a> ID.</p>
        pub fn authorizer_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(inp);
            self
        }
        /// <p>[Required] Specifies a test invoke authorizer request's <a>Authorizer</a> ID.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// Adds a key-value pair to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>[Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.</p>
        pub fn headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.headers(k, v);
            self
        }
        /// <p>[Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_headers(input);
            self
        }
        /// Adds a key-value pair to `multiValueHeaders`.
        ///
        /// To override the contents of this collection use [`set_multi_value_headers`](Self::set_multi_value_headers).
        ///
        /// <p>[Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.</p>
        pub fn multi_value_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.multi_value_headers(k, v);
            self
        }
        /// <p>[Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.</p>
        pub fn set_multi_value_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_multi_value_headers(input);
            self
        }
        /// <p>[Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn path_with_query_string(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_with_query_string(inp);
            self
        }
        /// <p>[Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn set_path_with_query_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_path_with_query_string(input);
            self
        }
        /// <p>[Optional] The simulated request body of an incoming invocation request.</p>
        pub fn body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(inp);
            self
        }
        /// <p>[Optional] The simulated request body of an incoming invocation request.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// Adds a key-value pair to `stageVariables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stage_variables(k, v);
            self
        }
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stage_variables(input);
            self
        }
        /// Adds a key-value pair to `additionalContext`.
        ///
        /// To override the contents of this collection use [`set_additional_context`](Self::set_additional_context).
        ///
        /// <p>[Optional] A key-value map of additional context variables.</p>
        pub fn additional_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_context(k, v);
            self
        }
        /// <p>[Optional] A key-value map of additional context variables.</p>
        pub fn set_additional_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestInvokeMethod`.
    ///
    /// <p>Simulate the execution of a <a>Method</a> in your <a>RestApi</a> with headers, parameters, and an incoming request body.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestInvokeMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_invoke_method_input::Builder,
    }
    impl<C, M, R> TestInvokeMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestInvokeMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestInvokeMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::TestInvokeMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestInvokeMethodInputOperationOutputAlias,
                crate::output::TestInvokeMethodOutput,
                crate::error::TestInvokeMethodError,
                crate::input::TestInvokeMethodInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies a test invoke method request's resource ID.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] Specifies a test invoke method request's resource ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies a test invoke method request's HTTP method.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies a test invoke method request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn path_with_query_string(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_with_query_string(inp);
            self
        }
        /// <p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>
        pub fn set_path_with_query_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_path_with_query_string(input);
            self
        }
        /// <p>The simulated request body of an incoming invocation request.</p>
        pub fn body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(inp);
            self
        }
        /// <p>The simulated request body of an incoming invocation request.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// Adds a key-value pair to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>A key-value map of headers to simulate an incoming invocation request.</p>
        pub fn headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.headers(k, v);
            self
        }
        /// <p>A key-value map of headers to simulate an incoming invocation request.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_headers(input);
            self
        }
        /// Adds a key-value pair to `multiValueHeaders`.
        ///
        /// To override the contents of this collection use [`set_multi_value_headers`](Self::set_multi_value_headers).
        ///
        /// <p>The headers as a map from string to list of values to simulate an incoming invocation request.</p>
        pub fn multi_value_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.multi_value_headers(k, v);
            self
        }
        /// <p>The headers as a map from string to list of values to simulate an incoming invocation request.</p>
        pub fn set_multi_value_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_multi_value_headers(input);
            self
        }
        /// <p>A <a>ClientCertificate</a> identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.</p>
        pub fn client_certificate_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(inp);
            self
        }
        /// <p>A <a>ClientCertificate</a> identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
        /// Adds a key-value pair to `stageVariables`.
        ///
        /// To override the contents of this collection use [`set_stage_variables`](Self::set_stage_variables).
        ///
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>
        pub fn stage_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.stage_variables(k, v);
            self
        }
        /// <p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>
        pub fn set_stage_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_stage_variables(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from a given resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>[Required] The ARN of a resource that can be tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>[Required] The Tag keys to delete.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>[Required] The Tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccount`.
    ///
    /// <p>Changes information about the current <a>Account</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_input::Builder,
    }
    impl<C, M, R> UpdateAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountInputOperationOutputAlias,
                crate::output::UpdateAccountOutput,
                crate::error::UpdateAccountError,
                crate::input::UpdateAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiKey`.
    ///
    /// <p>Changes information about an <a>ApiKey</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_api_key_input::Builder,
    }
    impl<C, M, R> UpdateApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApiKeyInputOperationOutputAlias,
                crate::output::UpdateApiKeyOutput,
                crate::error::UpdateApiKeyError,
                crate::input::UpdateApiKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource to be updated.</p>
        pub fn api_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_key(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>ApiKey</a> resource to be updated.</p>
        pub fn set_api_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_key(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAuthorizer`.
    ///
    /// <p>Updates an existing <a>Authorizer</a> resource.</p>
    /// <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</a></div>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_authorizer_input::Builder,
    }
    impl<C, M, R> UpdateAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAuthorizerInputOperationOutputAlias,
                crate::output::UpdateAuthorizerOutput,
                crate::error::UpdateAuthorizerError,
                crate::input::UpdateAuthorizerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn authorizer_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>Authorizer</a> resource.</p>
        pub fn set_authorizer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBasePathMapping`.
    ///
    /// <p>Changes information about the <a>BasePathMapping</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBasePathMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_base_path_mapping_input::Builder,
    }
    impl<C, M, R> UpdateBasePathMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBasePathMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBasePathMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBasePathMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBasePathMappingInputOperationOutputAlias,
                crate::output::UpdateBasePathMappingOutput,
                crate::error::UpdateBasePathMappingError,
                crate::input::UpdateBasePathMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to change.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>[Required] The domain name of the <a>BasePathMapping</a> resource to change.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>[Required] The base path of the <a>BasePathMapping</a> resource to change.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn base_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_path(inp);
            self
        }
        /// <p>[Required] The base path of the <a>BasePathMapping</a> resource to change.</p>
        /// <p>To specify an empty base path, set this parameter to <code>'(none)'</code>.</p>
        pub fn set_base_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_base_path(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateClientCertificate`.
    ///
    /// <p>Changes information about an <a>ClientCertificate</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_client_certificate_input::Builder,
    }
    impl<C, M, R> UpdateClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateClientCertificateInputOperationOutputAlias,
                crate::output::UpdateClientCertificateOutput,
                crate::error::UpdateClientCertificateError,
                crate::input::UpdateClientCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be updated.</p>
        pub fn client_certificate_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_certificate_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>ClientCertificate</a> resource to be updated.</p>
        pub fn set_client_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_certificate_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeployment`.
    ///
    /// <p>Changes information about a <a>Deployment</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_deployment_input::Builder,
    }
    impl<C, M, R> UpdateDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeploymentInputOperationOutputAlias,
                crate::output::UpdateDeploymentOutput,
                crate::error::UpdateDeploymentError,
                crate::input::UpdateDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>The replacement identifier for the <a>Deployment</a> resource to change information about.</p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p>The replacement identifier for the <a>Deployment</a> resource to change information about.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDocumentationPart`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct UpdateDocumentationPart<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_documentation_part_input::Builder,
    }
    impl<C, M, R> UpdateDocumentationPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDocumentationPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDocumentationPartOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDocumentationPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDocumentationPartInputOperationOutputAlias,
                crate::output::UpdateDocumentationPartOutput,
                crate::error::UpdateDocumentationPartError,
                crate::input::UpdateDocumentationPartInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the to-be-updated documentation part.</p>
        pub fn documentation_part_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_part_id(inp);
            self
        }
        /// <p>[Required] The identifier of the to-be-updated documentation part.</p>
        pub fn set_documentation_part_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_part_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDocumentationVersion`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct UpdateDocumentationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_documentation_version_input::Builder,
    }
    impl<C, M, R> UpdateDocumentationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDocumentationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDocumentationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDocumentationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDocumentationVersionInputOperationOutputAlias,
                crate::output::UpdateDocumentationVersionOutput,
                crate::error::UpdateDocumentationVersionError,
                crate::input::UpdateDocumentationVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>..</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>..</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The version identifier of the to-be-updated documentation version.</p>
        pub fn documentation_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.documentation_version(inp);
            self
        }
        /// <p>[Required] The version identifier of the to-be-updated documentation version.</p>
        pub fn set_documentation_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_documentation_version(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainName`.
    ///
    /// <p>Changes information about the <a>DomainName</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDomainName<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_name_input::Builder,
    }
    impl<C, M, R> UpdateDomainName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainNameInputOperationOutputAlias,
                crate::output::UpdateDomainNameOutput,
                crate::error::UpdateDomainNameError,
                crate::input::UpdateDomainNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource to be changed.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>[Required] The name of the <a>DomainName</a> resource to be changed.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayResponse`.
    ///
    /// <p>Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGatewayResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gateway_response_input::Builder,
    }
    impl<C, M, R> UpdateGatewayResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGatewayResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGatewayResponseInputOperationOutputAlias,
                crate::output::UpdateGatewayResponseOutput,
                crate::error::UpdateGatewayResponseError,
                crate::input::UpdateGatewayResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn response_type(mut self, inp: crate::model::GatewayResponseType) -> Self {
            self.inner = self.inner.response_type(inp);
            self
        }
        /// <p>[Required] <p>The response type of the associated <a>GatewayResponse</a>.</p></p>
        pub fn set_response_type(
            mut self,
            input: std::option::Option<crate::model::GatewayResponseType>,
        ) -> Self {
            self.inner = self.inner.set_response_type(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntegration`.
    ///
    /// <p>Represents an update integration.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_integration_input::Builder,
    }
    impl<C, M, R> UpdateIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIntegrationInputOperationOutputAlias,
                crate::output::UpdateIntegrationOutput,
                crate::error::UpdateIntegrationError,
                crate::input::UpdateIntegrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Represents an update integration request's resource identifier.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] Represents an update integration request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Represents an update integration request's HTTP method.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Represents an update integration request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntegrationResponse`.
    ///
    /// <p>Represents an update integration response.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIntegrationResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_integration_response_input::Builder,
    }
    impl<C, M, R> UpdateIntegrationResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIntegrationResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntegrationResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntegrationResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIntegrationResponseInputOperationOutputAlias,
                crate::output::UpdateIntegrationResponseOutput,
                crate::error::UpdateIntegrationResponseError,
                crate::input::UpdateIntegrationResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] Specifies an update integration response request's resource identifier.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] Specifies an update integration response request's resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] Specifies an update integration response request's HTTP method.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] Specifies an update integration response request's HTTP method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] Specifies an update integration response request's status code.</p>
        pub fn status_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(inp);
            self
        }
        /// <p>[Required] Specifies an update integration response request's status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMethod`.
    ///
    /// <p>Updates an existing <a>Method</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_method_input::Builder,
    }
    impl<C, M, R> UpdateMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMethodInputOperationOutputAlias,
                crate::output::UpdateMethodOutput,
                crate::error::UpdateMethodError,
                crate::input::UpdateMethodInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMethodResponse`.
    ///
    /// <p>Updates an existing <a>MethodResponse</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMethodResponse<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_method_response_input::Builder,
    }
    impl<C, M, R> UpdateMethodResponse<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMethodResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMethodResponseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMethodResponseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMethodResponseInputOperationOutputAlias,
                crate::output::UpdateMethodResponseOutput,
                crate::error::UpdateMethodResponseError,
                crate::input::UpdateMethodResponseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn http_method(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.http_method(inp);
            self
        }
        /// <p>[Required] The HTTP verb of the <a>Method</a> resource.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>[Required] The status code for the <a>MethodResponse</a> resource.</p>
        pub fn status_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_code(inp);
            self
        }
        /// <p>[Required] The status code for the <a>MethodResponse</a> resource.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModel`.
    ///
    /// <p>Changes information about a model.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_model_input::Builder,
    }
    impl<C, M, R> UpdateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateModelInputOperationOutputAlias,
                crate::output::UpdateModelOutput,
                crate::error::UpdateModelError,
                crate::input::UpdateModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the model to update.</p>
        pub fn model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(inp);
            self
        }
        /// <p>[Required] The name of the model to update.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRequestValidator`.
    ///
    /// <p>Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRequestValidator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_request_validator_input::Builder,
    }
    impl<C, M, R> UpdateRequestValidator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRequestValidator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRequestValidatorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRequestValidatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRequestValidatorInputOperationOutputAlias,
                crate::output::UpdateRequestValidatorOutput,
                crate::error::UpdateRequestValidatorError,
                crate::input::UpdateRequestValidatorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of <a>RequestValidator</a> to be updated.</p>
        pub fn request_validator_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_validator_id(inp);
            self
        }
        /// <p>[Required] The identifier of <a>RequestValidator</a> to be updated.</p>
        pub fn set_request_validator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_validator_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResource`.
    ///
    /// <p>Changes information about a <a>Resource</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_input::Builder,
    }
    impl<C, M, R> UpdateResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceInputOperationOutputAlias,
                crate::output::UpdateResourceOutput,
                crate::error::UpdateResourceError,
                crate::input::UpdateResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The identifier of the <a>Resource</a> resource.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>[Required] The identifier of the <a>Resource</a> resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRestApi`.
    ///
    /// <p>Changes information about the specified API.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRestApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_rest_api_input::Builder,
    }
    impl<C, M, R> UpdateRestApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRestApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRestApiOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRestApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRestApiInputOperationOutputAlias,
                crate::output::UpdateRestApiOutput,
                crate::error::UpdateRestApiError,
                crate::input::UpdateRestApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStage`.
    ///
    /// <p>Changes information about a <a>Stage</a> resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_stage_input::Builder,
    }
    impl<C, M, R> UpdateStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStageInputOperationOutputAlias,
                crate::output::UpdateStageOutput,
                crate::error::UpdateStageError,
                crate::input::UpdateStageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn rest_api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rest_api_id(inp);
            self
        }
        /// <p>[Required] The string identifier of the associated <a>RestApi</a>.</p>
        pub fn set_rest_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rest_api_id(input);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to change information about.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>[Required] The name of the <a>Stage</a> resource to change information about.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUsage`.
    ///
    /// <p>Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_usage_input::Builder,
    }
    impl<C, M, R> UpdateUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUsageInputOperationOutputAlias,
                crate::output::UpdateUsageOutput,
                crate::error::UpdateUsageError,
                crate::input::UpdateUsageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the usage plan associated with the usage data.</p>
        pub fn usage_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(inp);
            self
        }
        /// <p>[Required] The Id of the usage plan associated with the usage data.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// <p>[Required] The identifier of the API key associated with the usage plan in which a temporary extension is granted to the remaining quota.</p>
        pub fn key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(inp);
            self
        }
        /// <p>[Required] The identifier of the API key associated with the usage plan in which a temporary extension is granted to the remaining quota.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUsagePlan`.
    ///
    /// <p>Updates a usage plan of a given plan Id.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUsagePlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_usage_plan_input::Builder,
    }
    impl<C, M, R> UpdateUsagePlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUsagePlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUsagePlanOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUsagePlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUsagePlanInputOperationOutputAlias,
                crate::output::UpdateUsagePlanOutput,
                crate::error::UpdateUsagePlanError,
                crate::input::UpdateUsagePlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The Id of the to-be-updated usage plan.</p>
        pub fn usage_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_plan_id(inp);
            self
        }
        /// <p>[Required] The Id of the to-be-updated usage plan.</p>
        pub fn set_usage_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_plan_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVpcLink`.
    ///
    /// <p>Updates an existing <a>VpcLink</a> of a specified identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVpcLink<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_vpc_link_input::Builder,
    }
    impl<C, M, R> UpdateVpcLink<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVpcLink`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVpcLinkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVpcLinkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVpcLinkInputOperationOutputAlias,
                crate::output::UpdateVpcLinkOutput,
                crate::error::UpdateVpcLinkError,
                crate::input::UpdateVpcLinkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn vpc_link_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_link_id(inp);
            self
        }
        /// <p>[Required] The identifier of the  <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_link_id(input);
            self
        }
        /// Appends an item to `patchOperations`.
        ///
        /// To override the contents of this collection use [`set_patch_operations`](Self::set_patch_operations).
        ///
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn patch_operations(mut self, inp: impl Into<crate::model::PatchOperation>) -> Self {
            self.inner = self.inner.patch_operations(inp);
            self
        }
        /// <p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>
        pub fn set_patch_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOperation>>,
        ) -> Self {
            self.inner = self.inner.set_patch_operations(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
