// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Amplify UI Builder
///
/// Client for invoking operations on AWS Amplify UI Builder. Each operation on AWS Amplify UI Builder is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_amplifyuibuilder::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_amplifyuibuilder::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_amplifyuibuilder::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateComponent`](crate::client::fluent_builders::CreateComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_app_id): <p>The unique ID of the Amplify app to associate with the component.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_environment_name): <p>The name of the backend environment that is a part of the Amplify app.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_client_token): <p>The unique client token.</p>
    ///   - [`component_to_create(CreateComponentData)`](crate::client::fluent_builders::CreateComponent::component_to_create) / [`set_component_to_create(Option<CreateComponentData>)`](crate::client::fluent_builders::CreateComponent::set_component_to_create): <p>Represents the configuration of the component to create.</p>
    /// - On success, responds with [`CreateComponentOutput`](crate::output::CreateComponentOutput) with field(s):
    ///   - [`entity(Option<Component>)`](crate::output::CreateComponentOutput::entity): <p>Describes the configuration of the new component.</p>
    /// - On failure, responds with [`SdkError<CreateComponentError>`](crate::error::CreateComponentError)
    pub fn create_component(&self) -> fluent_builders::CreateComponent {
        fluent_builders::CreateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTheme`](crate::client::fluent_builders::CreateTheme) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::CreateTheme::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::CreateTheme::set_app_id): <p>The unique ID of the Amplify app associated with the theme.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::CreateTheme::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::CreateTheme::set_environment_name): <p>The name of the backend environment that is a part of the Amplify app.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateTheme::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateTheme::set_client_token): <p>The unique client token.</p>
    ///   - [`theme_to_create(CreateThemeData)`](crate::client::fluent_builders::CreateTheme::theme_to_create) / [`set_theme_to_create(Option<CreateThemeData>)`](crate::client::fluent_builders::CreateTheme::set_theme_to_create): <p>Represents the configuration of the theme to create.</p>
    /// - On success, responds with [`CreateThemeOutput`](crate::output::CreateThemeOutput) with field(s):
    ///   - [`entity(Option<Theme>)`](crate::output::CreateThemeOutput::entity): <p>Describes the configuration of the new theme.</p>
    /// - On failure, responds with [`SdkError<CreateThemeError>`](crate::error::CreateThemeError)
    pub fn create_theme(&self) -> fluent_builders::CreateTheme {
        fluent_builders::CreateTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteComponent`](crate::client::fluent_builders::DeleteComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::DeleteComponent::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::DeleteComponent::set_app_id): <p>The unique ID of the Amplify app associated with the component to delete.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DeleteComponent::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DeleteComponent::set_environment_name): <p>The name of the backend environment that is a part of the Amplify app.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteComponent::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteComponent::set_id): <p>The unique ID of the component to delete.</p>
    /// - On success, responds with [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)

    /// - On failure, responds with [`SdkError<DeleteComponentError>`](crate::error::DeleteComponentError)
    pub fn delete_component(&self) -> fluent_builders::DeleteComponent {
        fluent_builders::DeleteComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTheme`](crate::client::fluent_builders::DeleteTheme) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTheme::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::DeleteTheme::set_app_id): <p>The unique ID of the Amplify app associated with the theme to delete.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTheme::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DeleteTheme::set_environment_name): <p>The name of the backend environment that is a part of the Amplify app.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteTheme::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteTheme::set_id): <p>The unique ID of the theme to delete.</p>
    /// - On success, responds with [`DeleteThemeOutput`](crate::output::DeleteThemeOutput)

    /// - On failure, responds with [`SdkError<DeleteThemeError>`](crate::error::DeleteThemeError)
    pub fn delete_theme(&self) -> fluent_builders::DeleteTheme {
        fluent_builders::DeleteTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExchangeCodeForToken`](crate::client::fluent_builders::ExchangeCodeForToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`provider(TokenProviders)`](crate::client::fluent_builders::ExchangeCodeForToken::provider) / [`set_provider(Option<TokenProviders>)`](crate::client::fluent_builders::ExchangeCodeForToken::set_provider): <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
    ///   - [`request(ExchangeCodeForTokenRequestBody)`](crate::client::fluent_builders::ExchangeCodeForToken::request) / [`set_request(Option<ExchangeCodeForTokenRequestBody>)`](crate::client::fluent_builders::ExchangeCodeForToken::set_request): <p>Describes the configuration of the request.</p>
    /// - On success, responds with [`ExchangeCodeForTokenOutput`](crate::output::ExchangeCodeForTokenOutput) with field(s):
    ///   - [`access_token(Option<String>)`](crate::output::ExchangeCodeForTokenOutput::access_token): <p>The access token.</p>
    ///   - [`expires_in(Option<i32>)`](crate::output::ExchangeCodeForTokenOutput::expires_in): <p>The date and time when the new access token expires.</p>
    ///   - [`refresh_token(Option<String>)`](crate::output::ExchangeCodeForTokenOutput::refresh_token): <p>The token to use to refresh a previously issued access token that might have expired.</p>
    /// - On failure, responds with [`SdkError<ExchangeCodeForTokenError>`](crate::error::ExchangeCodeForTokenError)
    pub fn exchange_code_for_token(&self) -> fluent_builders::ExchangeCodeForToken {
        fluent_builders::ExchangeCodeForToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExportComponents`](crate::client::fluent_builders::ExportComponents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ExportComponents::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ExportComponents::set_app_id): <p>The unique ID of the Amplify app to export components to.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::ExportComponents::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::ExportComponents::set_environment_name): <p>The name of the backend environment that is a part of the Amplify app.</p>
    /// - On success, responds with [`ExportComponentsOutput`](crate::output::ExportComponentsOutput) with field(s):
    ///   - [`entities(Option<Vec<Component>>)`](crate::output::ExportComponentsOutput::entities): <p>Represents the configuration of the exported components.</p>
    /// - On failure, responds with [`SdkError<ExportComponentsError>`](crate::error::ExportComponentsError)
    pub fn export_components(&self) -> fluent_builders::ExportComponents {
        fluent_builders::ExportComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExportThemes`](crate::client::fluent_builders::ExportThemes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ExportThemes::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ExportThemes::set_app_id): <p>The unique ID of the Amplify app to export the themes to.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::ExportThemes::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::ExportThemes::set_environment_name): <p>The name of the backend environment that is part of the Amplify app.</p>
    /// - On success, responds with [`ExportThemesOutput`](crate::output::ExportThemesOutput) with field(s):
    ///   - [`entities(Option<Vec<Theme>>)`](crate::output::ExportThemesOutput::entities): <p>Represents the configuration of the exported themes.</p>
    /// - On failure, responds with [`SdkError<ExportThemesError>`](crate::error::ExportThemesError)
    pub fn export_themes(&self) -> fluent_builders::ExportThemes {
        fluent_builders::ExportThemes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetComponent`](crate::client::fluent_builders::GetComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::GetComponent::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::GetComponent::set_app_id): <p>The unique ID of the Amplify app.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::GetComponent::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::GetComponent::set_environment_name): <p>The name of the backend environment that is part of the Amplify app.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetComponent::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetComponent::set_id): <p>The unique ID of the component.</p>
    /// - On success, responds with [`GetComponentOutput`](crate::output::GetComponentOutput) with field(s):
    ///   - [`component(Option<Component>)`](crate::output::GetComponentOutput::component): <p>Represents the configuration settings for the component.</p>
    /// - On failure, responds with [`SdkError<GetComponentError>`](crate::error::GetComponentError)
    pub fn get_component(&self) -> fluent_builders::GetComponent {
        fluent_builders::GetComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTheme`](crate::client::fluent_builders::GetTheme) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::GetTheme::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::GetTheme::set_app_id): <p>The unique ID of the Amplify app.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::GetTheme::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::GetTheme::set_environment_name): <p>The name of the backend environment that is part of the Amplify app.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetTheme::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetTheme::set_id): <p>The unique ID for the theme.</p>
    /// - On success, responds with [`GetThemeOutput`](crate::output::GetThemeOutput) with field(s):
    ///   - [`theme(Option<Theme>)`](crate::output::GetThemeOutput::theme): <p>Represents the configuration settings for the theme.</p>
    /// - On failure, responds with [`SdkError<GetThemeError>`](crate::error::GetThemeError)
    pub fn get_theme(&self) -> fluent_builders::GetTheme {
        fluent_builders::GetTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComponents`](crate::client::fluent_builders::ListComponents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComponents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ListComponents::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ListComponents::set_app_id): <p>The unique ID for the Amplify app.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::ListComponents::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::ListComponents::set_environment_name): <p>The name of the backend environment that is a part of the Amplify app.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComponents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComponents::set_next_token): <p>The token to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComponents::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListComponents::set_max_results): <p>The maximum number of components to retrieve.</p>
    /// - On success, responds with [`ListComponentsOutput`](crate::output::ListComponentsOutput) with field(s):
    ///   - [`entities(Option<Vec<ComponentSummary>>)`](crate::output::ListComponentsOutput::entities): <p>The list of components for the Amplify app.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListComponentsOutput::next_token): <p>The pagination token that's included if more results are available.</p>
    /// - On failure, responds with [`SdkError<ListComponentsError>`](crate::error::ListComponentsError)
    pub fn list_components(&self) -> fluent_builders::ListComponents {
        fluent_builders::ListComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThemes`](crate::client::fluent_builders::ListThemes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThemes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ListThemes::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ListThemes::set_app_id): <p>The unique ID for the Amplify app.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::ListThemes::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::ListThemes::set_environment_name): <p>The name of the backend environment that is a part of the Amplify app.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThemes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThemes::set_next_token): <p>The token to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThemes::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListThemes::set_max_results): <p>The maximum number of theme results to return in the response.</p>
    /// - On success, responds with [`ListThemesOutput`](crate::output::ListThemesOutput) with field(s):
    ///   - [`entities(Option<Vec<ThemeSummary>>)`](crate::output::ListThemesOutput::entities): <p>The list of themes for the Amplify app.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThemesOutput::next_token): <p>The pagination token that's returned if more results are available.</p>
    /// - On failure, responds with [`SdkError<ListThemesError>`](crate::error::ListThemesError)
    pub fn list_themes(&self) -> fluent_builders::ListThemes {
        fluent_builders::ListThemes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RefreshToken`](crate::client::fluent_builders::RefreshToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`provider(TokenProviders)`](crate::client::fluent_builders::RefreshToken::provider) / [`set_provider(Option<TokenProviders>)`](crate::client::fluent_builders::RefreshToken::set_provider): <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
    ///   - [`refresh_token_body(RefreshTokenRequestBody)`](crate::client::fluent_builders::RefreshToken::refresh_token_body) / [`set_refresh_token_body(Option<RefreshTokenRequestBody>)`](crate::client::fluent_builders::RefreshToken::set_refresh_token_body): <p>Information about the refresh token request.</p>
    /// - On success, responds with [`RefreshTokenOutput`](crate::output::RefreshTokenOutput) with field(s):
    ///   - [`access_token(Option<String>)`](crate::output::RefreshTokenOutput::access_token): <p>The access token.</p>
    ///   - [`expires_in(Option<i32>)`](crate::output::RefreshTokenOutput::expires_in): <p>The date and time when the new access token expires.</p>
    /// - On failure, responds with [`SdkError<RefreshTokenError>`](crate::error::RefreshTokenError)
    pub fn refresh_token(&self) -> fluent_builders::RefreshToken {
        fluent_builders::RefreshToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateComponent`](crate::client::fluent_builders::UpdateComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::UpdateComponent::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::UpdateComponent::set_app_id): <p>The unique ID for the Amplify app.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::UpdateComponent::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::UpdateComponent::set_environment_name): <p>The name of the backend environment that is part of the Amplify app.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateComponent::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateComponent::set_id): <p>The unique ID for the component.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateComponent::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateComponent::set_client_token): <p>The unique client token.</p>
    ///   - [`updated_component(UpdateComponentData)`](crate::client::fluent_builders::UpdateComponent::updated_component) / [`set_updated_component(Option<UpdateComponentData>)`](crate::client::fluent_builders::UpdateComponent::set_updated_component): <p>The configuration of the updated component.</p>
    /// - On success, responds with [`UpdateComponentOutput`](crate::output::UpdateComponentOutput) with field(s):
    ///   - [`entity(Option<Component>)`](crate::output::UpdateComponentOutput::entity): <p>Describes the configuration of the updated component.</p>
    /// - On failure, responds with [`SdkError<UpdateComponentError>`](crate::error::UpdateComponentError)
    pub fn update_component(&self) -> fluent_builders::UpdateComponent {
        fluent_builders::UpdateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTheme`](crate::client::fluent_builders::UpdateTheme) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTheme::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::UpdateTheme::set_app_id): <p>The unique ID for the Amplify app.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTheme::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::UpdateTheme::set_environment_name): <p>The name of the backend environment that is part of the Amplify app.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateTheme::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateTheme::set_id): <p>The unique ID for the theme.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateTheme::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateTheme::set_client_token): <p>The unique client token.</p>
    ///   - [`updated_theme(UpdateThemeData)`](crate::client::fluent_builders::UpdateTheme::updated_theme) / [`set_updated_theme(Option<UpdateThemeData>)`](crate::client::fluent_builders::UpdateTheme::set_updated_theme): <p>The configuration of the updated theme.</p>
    /// - On success, responds with [`UpdateThemeOutput`](crate::output::UpdateThemeOutput) with field(s):
    ///   - [`entity(Option<Theme>)`](crate::output::UpdateThemeOutput::entity): <p>Describes the configuration of the updated theme.</p>
    /// - On failure, responds with [`SdkError<UpdateThemeError>`](crate::error::UpdateThemeError)
    pub fn update_theme(&self) -> fluent_builders::UpdateTheme {
        fluent_builders::UpdateTheme::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateComponent`.
    ///
    /// <p>Creates a new component for an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_component_input::Builder,
    }
    impl CreateComponent {
        /// Creates a new `CreateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app to associate with the component.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app to associate with the component.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Represents the configuration of the component to create.</p>
        pub fn component_to_create(mut self, input: crate::model::CreateComponentData) -> Self {
            self.inner = self.inner.component_to_create(input);
            self
        }
        /// <p>Represents the configuration of the component to create.</p>
        pub fn set_component_to_create(
            mut self,
            input: std::option::Option<crate::model::CreateComponentData>,
        ) -> Self {
            self.inner = self.inner.set_component_to_create(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTheme`.
    ///
    /// <p>Creates a theme to apply to the components in an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTheme {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_theme_input::Builder,
    }
    impl CreateTheme {
        /// Creates a new `CreateTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThemeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app associated with the theme.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the theme.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Represents the configuration of the theme to create.</p>
        pub fn theme_to_create(mut self, input: crate::model::CreateThemeData) -> Self {
            self.inner = self.inner.theme_to_create(input);
            self
        }
        /// <p>Represents the configuration of the theme to create.</p>
        pub fn set_theme_to_create(
            mut self,
            input: std::option::Option<crate::model::CreateThemeData>,
        ) -> Self {
            self.inner = self.inner.set_theme_to_create(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComponent`.
    ///
    /// <p>Deletes a component from an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_component_input::Builder,
    }
    impl DeleteComponent {
        /// Creates a new `DeleteComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app associated with the component to delete.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the component to delete.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID of the component to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID of the component to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTheme`.
    ///
    /// <p>Deletes a theme from an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTheme {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_theme_input::Builder,
    }
    impl DeleteTheme {
        /// Creates a new `DeleteTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThemeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app associated with the theme to delete.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the theme to delete.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID of the theme to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID of the theme to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExchangeCodeForToken`.
    ///
    /// <p>Exchanges an access code for a token.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExchangeCodeForToken {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::exchange_code_for_token_input::Builder,
    }
    impl ExchangeCodeForToken {
        /// Creates a new `ExchangeCodeForToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExchangeCodeForTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::ExchangeCodeForTokenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn provider(mut self, input: crate::model::TokenProviders) -> Self {
            self.inner = self.inner.provider(input);
            self
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::TokenProviders>,
        ) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>Describes the configuration of the request.</p>
        pub fn request(mut self, input: crate::model::ExchangeCodeForTokenRequestBody) -> Self {
            self.inner = self.inner.request(input);
            self
        }
        /// <p>Describes the configuration of the request.</p>
        pub fn set_request(
            mut self,
            input: std::option::Option<crate::model::ExchangeCodeForTokenRequestBody>,
        ) -> Self {
            self.inner = self.inner.set_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportComponents`.
    ///
    /// <p>Exports component configurations to code that is ready to integrate into an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportComponents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::export_components_input::Builder,
    }
    impl ExportComponents {
        /// Creates a new `ExportComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportComponentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app to export components to.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app to export components to.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportThemes`.
    ///
    /// <p>Exports theme configurations to code that is ready to integrate into an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportThemes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::export_themes_input::Builder,
    }
    impl ExportThemes {
        /// Creates a new `ExportThemes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportThemesOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportThemesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app to export the themes to.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app to export the themes to.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComponent`.
    ///
    /// <p>Returns an existing component for an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_component_input::Builder,
    }
    impl GetComponent {
        /// Creates a new `GetComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTheme`.
    ///
    /// <p>Returns an existing theme for an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTheme {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_theme_input::Builder,
    }
    impl GetTheme {
        /// Creates a new `GetTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetThemeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponents`.
    ///
    /// <p>Retrieves a list of components for a specified Amplify app and backend environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComponents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_components_input::Builder,
    }
    impl ListComponents {
        /// Creates a new `ListComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComponentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComponentsPaginator {
            crate::paginator::ListComponentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of components to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of components to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThemes`.
    ///
    /// <p>Retrieves a list of themes for a specified Amplify app and backend environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThemes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_themes_input::Builder,
    }
    impl ListThemes {
        /// Creates a new `ListThemes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThemesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThemesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThemesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThemesPaginator {
            crate::paginator::ListThemesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of theme results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of theme results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RefreshToken`.
    ///
    /// <p>Refreshes a previously issued access token that might have expired.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RefreshToken {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::refresh_token_input::Builder,
    }
    impl RefreshToken {
        /// Creates a new `RefreshToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RefreshTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::RefreshTokenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn provider(mut self, input: crate::model::TokenProviders) -> Self {
            self.inner = self.inner.provider(input);
            self
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::TokenProviders>,
        ) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>Information about the refresh token request.</p>
        pub fn refresh_token_body(mut self, input: crate::model::RefreshTokenRequestBody) -> Self {
            self.inner = self.inner.refresh_token_body(input);
            self
        }
        /// <p>Information about the refresh token request.</p>
        pub fn set_refresh_token_body(
            mut self,
            input: std::option::Option<crate::model::RefreshTokenRequestBody>,
        ) -> Self {
            self.inner = self.inner.set_refresh_token_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComponent`.
    ///
    /// <p>Updates an existing component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_component_input::Builder,
    }
    impl UpdateComponent {
        /// Creates a new `UpdateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID for the component.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID for the component.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration of the updated component.</p>
        pub fn updated_component(mut self, input: crate::model::UpdateComponentData) -> Self {
            self.inner = self.inner.updated_component(input);
            self
        }
        /// <p>The configuration of the updated component.</p>
        pub fn set_updated_component(
            mut self,
            input: std::option::Option<crate::model::UpdateComponentData>,
        ) -> Self {
            self.inner = self.inner.set_updated_component(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTheme`.
    ///
    /// <p>Updates an existing theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTheme {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_theme_input::Builder,
    }
    impl UpdateTheme {
        /// Creates a new `UpdateTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThemeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration of the updated theme.</p>
        pub fn updated_theme(mut self, input: crate::model::UpdateThemeData) -> Self {
            self.inner = self.inner.updated_theme(input);
            self
        }
        /// <p>The configuration of the updated theme.</p>
        pub fn set_updated_theme(
            mut self,
            input: std::option::Option<crate::model::UpdateThemeData>,
        ) -> Self {
            self.inner = self.inner.set_updated_theme(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
