// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportThemesOutput {
    /// <p>Represents the configuration of the exported themes.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::Theme>>,
}
impl ExportThemesOutput {
    /// <p>Represents the configuration of the exported themes.</p>
    pub fn entities(&self) -> std::option::Option<&[crate::model::Theme]> {
        self.entities.as_deref()
    }
}
impl std::fmt::Debug for ExportThemesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportThemesOutput");
        formatter.field("entities", &self.entities);
        formatter.finish()
    }
}
/// See [`ExportThemesOutput`](crate::output::ExportThemesOutput)
pub mod export_themes_output {
    /// A builder for [`ExportThemesOutput`](crate::output::ExportThemesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::Theme>>,
    }
    impl Builder {
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>Represents the configuration of the exported themes.</p>
        pub fn entities(mut self, input: crate::model::Theme) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input);
            self.entities = Some(v);
            self
        }
        /// <p>Represents the configuration of the exported themes.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Theme>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportThemesOutput`](crate::output::ExportThemesOutput)
        pub fn build(self) -> crate::output::ExportThemesOutput {
            crate::output::ExportThemesOutput {
                entities: self.entities,
            }
        }
    }
}
impl ExportThemesOutput {
    /// Creates a new builder-style object to manufacture [`ExportThemesOutput`](crate::output::ExportThemesOutput)
    pub fn builder() -> crate::output::export_themes_output::Builder {
        crate::output::export_themes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThemesOutput {
    /// <p>The list of themes for the Amplify app.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::ThemeSummary>>,
    /// <p>The pagination token that's returned if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThemesOutput {
    /// <p>The list of themes for the Amplify app.</p>
    pub fn entities(&self) -> std::option::Option<&[crate::model::ThemeSummary]> {
        self.entities.as_deref()
    }
    /// <p>The pagination token that's returned if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThemesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThemesOutput");
        formatter.field("entities", &self.entities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThemesOutput`](crate::output::ListThemesOutput)
pub mod list_themes_output {
    /// A builder for [`ListThemesOutput`](crate::output::ListThemesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::ThemeSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>The list of themes for the Amplify app.</p>
        pub fn entities(mut self, input: crate::model::ThemeSummary) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input);
            self.entities = Some(v);
            self
        }
        /// <p>The list of themes for the Amplify app.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeSummary>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// <p>The pagination token that's returned if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that's returned if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThemesOutput`](crate::output::ListThemesOutput)
        pub fn build(self) -> crate::output::ListThemesOutput {
            crate::output::ListThemesOutput {
                entities: self.entities,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThemesOutput {
    /// Creates a new builder-style object to manufacture [`ListThemesOutput`](crate::output::ListThemesOutput)
    pub fn builder() -> crate::output::list_themes_output::Builder {
        crate::output::list_themes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThemeOutput {
    /// <p>Describes the configuration of the new theme.</p>
    pub entity: std::option::Option<crate::model::Theme>,
}
impl CreateThemeOutput {
    /// <p>Describes the configuration of the new theme.</p>
    pub fn entity(&self) -> std::option::Option<&crate::model::Theme> {
        self.entity.as_ref()
    }
}
impl std::fmt::Debug for CreateThemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThemeOutput");
        formatter.field("entity", &self.entity);
        formatter.finish()
    }
}
/// See [`CreateThemeOutput`](crate::output::CreateThemeOutput)
pub mod create_theme_output {
    /// A builder for [`CreateThemeOutput`](crate::output::CreateThemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity: std::option::Option<crate::model::Theme>,
    }
    impl Builder {
        /// <p>Describes the configuration of the new theme.</p>
        pub fn entity(mut self, input: crate::model::Theme) -> Self {
            self.entity = Some(input);
            self
        }
        /// <p>Describes the configuration of the new theme.</p>
        pub fn set_entity(mut self, input: std::option::Option<crate::model::Theme>) -> Self {
            self.entity = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThemeOutput`](crate::output::CreateThemeOutput)
        pub fn build(self) -> crate::output::CreateThemeOutput {
            crate::output::CreateThemeOutput {
                entity: self.entity,
            }
        }
    }
}
impl CreateThemeOutput {
    /// Creates a new builder-style object to manufacture [`CreateThemeOutput`](crate::output::CreateThemeOutput)
    pub fn builder() -> crate::output::create_theme_output::Builder {
        crate::output::create_theme_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteThemeOutput {}
impl std::fmt::Debug for DeleteThemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteThemeOutput");
        formatter.finish()
    }
}
/// See [`DeleteThemeOutput`](crate::output::DeleteThemeOutput)
pub mod delete_theme_output {
    /// A builder for [`DeleteThemeOutput`](crate::output::DeleteThemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteThemeOutput`](crate::output::DeleteThemeOutput)
        pub fn build(self) -> crate::output::DeleteThemeOutput {
            crate::output::DeleteThemeOutput {}
        }
    }
}
impl DeleteThemeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteThemeOutput`](crate::output::DeleteThemeOutput)
    pub fn builder() -> crate::output::delete_theme_output::Builder {
        crate::output::delete_theme_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThemeOutput {
    /// <p>Describes the configuration of the updated theme.</p>
    pub entity: std::option::Option<crate::model::Theme>,
}
impl UpdateThemeOutput {
    /// <p>Describes the configuration of the updated theme.</p>
    pub fn entity(&self) -> std::option::Option<&crate::model::Theme> {
        self.entity.as_ref()
    }
}
impl std::fmt::Debug for UpdateThemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThemeOutput");
        formatter.field("entity", &self.entity);
        formatter.finish()
    }
}
/// See [`UpdateThemeOutput`](crate::output::UpdateThemeOutput)
pub mod update_theme_output {
    /// A builder for [`UpdateThemeOutput`](crate::output::UpdateThemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity: std::option::Option<crate::model::Theme>,
    }
    impl Builder {
        /// <p>Describes the configuration of the updated theme.</p>
        pub fn entity(mut self, input: crate::model::Theme) -> Self {
            self.entity = Some(input);
            self
        }
        /// <p>Describes the configuration of the updated theme.</p>
        pub fn set_entity(mut self, input: std::option::Option<crate::model::Theme>) -> Self {
            self.entity = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThemeOutput`](crate::output::UpdateThemeOutput)
        pub fn build(self) -> crate::output::UpdateThemeOutput {
            crate::output::UpdateThemeOutput {
                entity: self.entity,
            }
        }
    }
}
impl UpdateThemeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateThemeOutput`](crate::output::UpdateThemeOutput)
    pub fn builder() -> crate::output::update_theme_output::Builder {
        crate::output::update_theme_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetThemeOutput {
    /// <p>Represents the configuration settings for the theme.</p>
    pub theme: std::option::Option<crate::model::Theme>,
}
impl GetThemeOutput {
    /// <p>Represents the configuration settings for the theme.</p>
    pub fn theme(&self) -> std::option::Option<&crate::model::Theme> {
        self.theme.as_ref()
    }
}
impl std::fmt::Debug for GetThemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetThemeOutput");
        formatter.field("theme", &self.theme);
        formatter.finish()
    }
}
/// See [`GetThemeOutput`](crate::output::GetThemeOutput)
pub mod get_theme_output {
    /// A builder for [`GetThemeOutput`](crate::output::GetThemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme: std::option::Option<crate::model::Theme>,
    }
    impl Builder {
        /// <p>Represents the configuration settings for the theme.</p>
        pub fn theme(mut self, input: crate::model::Theme) -> Self {
            self.theme = Some(input);
            self
        }
        /// <p>Represents the configuration settings for the theme.</p>
        pub fn set_theme(mut self, input: std::option::Option<crate::model::Theme>) -> Self {
            self.theme = input;
            self
        }
        /// Consumes the builder and constructs a [`GetThemeOutput`](crate::output::GetThemeOutput)
        pub fn build(self) -> crate::output::GetThemeOutput {
            crate::output::GetThemeOutput { theme: self.theme }
        }
    }
}
impl GetThemeOutput {
    /// Creates a new builder-style object to manufacture [`GetThemeOutput`](crate::output::GetThemeOutput)
    pub fn builder() -> crate::output::get_theme_output::Builder {
        crate::output::get_theme_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportComponentsOutput {
    /// <p>Represents the configuration of the exported components.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::Component>>,
}
impl ExportComponentsOutput {
    /// <p>Represents the configuration of the exported components.</p>
    pub fn entities(&self) -> std::option::Option<&[crate::model::Component]> {
        self.entities.as_deref()
    }
}
impl std::fmt::Debug for ExportComponentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportComponentsOutput");
        formatter.field("entities", &self.entities);
        formatter.finish()
    }
}
/// See [`ExportComponentsOutput`](crate::output::ExportComponentsOutput)
pub mod export_components_output {
    /// A builder for [`ExportComponentsOutput`](crate::output::ExportComponentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::Component>>,
    }
    impl Builder {
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>Represents the configuration of the exported components.</p>
        pub fn entities(mut self, input: crate::model::Component) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input);
            self.entities = Some(v);
            self
        }
        /// <p>Represents the configuration of the exported components.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Component>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportComponentsOutput`](crate::output::ExportComponentsOutput)
        pub fn build(self) -> crate::output::ExportComponentsOutput {
            crate::output::ExportComponentsOutput {
                entities: self.entities,
            }
        }
    }
}
impl ExportComponentsOutput {
    /// Creates a new builder-style object to manufacture [`ExportComponentsOutput`](crate::output::ExportComponentsOutput)
    pub fn builder() -> crate::output::export_components_output::Builder {
        crate::output::export_components_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentsOutput {
    /// <p>The list of components for the Amplify app.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::ComponentSummary>>,
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComponentsOutput {
    /// <p>The list of components for the Amplify app.</p>
    pub fn entities(&self) -> std::option::Option<&[crate::model::ComponentSummary]> {
        self.entities.as_deref()
    }
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComponentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentsOutput");
        formatter.field("entities", &self.entities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListComponentsOutput`](crate::output::ListComponentsOutput)
pub mod list_components_output {
    /// A builder for [`ListComponentsOutput`](crate::output::ListComponentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::ComponentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>The list of components for the Amplify app.</p>
        pub fn entities(mut self, input: crate::model::ComponentSummary) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input);
            self.entities = Some(v);
            self
        }
        /// <p>The list of components for the Amplify app.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentSummary>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentsOutput`](crate::output::ListComponentsOutput)
        pub fn build(self) -> crate::output::ListComponentsOutput {
            crate::output::ListComponentsOutput {
                entities: self.entities,
                next_token: self.next_token,
            }
        }
    }
}
impl ListComponentsOutput {
    /// Creates a new builder-style object to manufacture [`ListComponentsOutput`](crate::output::ListComponentsOutput)
    pub fn builder() -> crate::output::list_components_output::Builder {
        crate::output::list_components_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentOutput {
    /// <p>Describes the configuration of the new component.</p>
    pub entity: std::option::Option<crate::model::Component>,
}
impl CreateComponentOutput {
    /// <p>Describes the configuration of the new component.</p>
    pub fn entity(&self) -> std::option::Option<&crate::model::Component> {
        self.entity.as_ref()
    }
}
impl std::fmt::Debug for CreateComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentOutput");
        formatter.field("entity", &self.entity);
        formatter.finish()
    }
}
/// See [`CreateComponentOutput`](crate::output::CreateComponentOutput)
pub mod create_component_output {
    /// A builder for [`CreateComponentOutput`](crate::output::CreateComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity: std::option::Option<crate::model::Component>,
    }
    impl Builder {
        /// <p>Describes the configuration of the new component.</p>
        pub fn entity(mut self, input: crate::model::Component) -> Self {
            self.entity = Some(input);
            self
        }
        /// <p>Describes the configuration of the new component.</p>
        pub fn set_entity(mut self, input: std::option::Option<crate::model::Component>) -> Self {
            self.entity = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentOutput`](crate::output::CreateComponentOutput)
        pub fn build(self) -> crate::output::CreateComponentOutput {
            crate::output::CreateComponentOutput {
                entity: self.entity,
            }
        }
    }
}
impl CreateComponentOutput {
    /// Creates a new builder-style object to manufacture [`CreateComponentOutput`](crate::output::CreateComponentOutput)
    pub fn builder() -> crate::output::create_component_output::Builder {
        crate::output::create_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentOutput {}
impl std::fmt::Debug for DeleteComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentOutput");
        formatter.finish()
    }
}
/// See [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
pub mod delete_component_output {
    /// A builder for [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
        pub fn build(self) -> crate::output::DeleteComponentOutput {
            crate::output::DeleteComponentOutput {}
        }
    }
}
impl DeleteComponentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
    pub fn builder() -> crate::output::delete_component_output::Builder {
        crate::output::delete_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateComponentOutput {
    /// <p>Describes the configuration of the updated component.</p>
    pub entity: std::option::Option<crate::model::Component>,
}
impl UpdateComponentOutput {
    /// <p>Describes the configuration of the updated component.</p>
    pub fn entity(&self) -> std::option::Option<&crate::model::Component> {
        self.entity.as_ref()
    }
}
impl std::fmt::Debug for UpdateComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateComponentOutput");
        formatter.field("entity", &self.entity);
        formatter.finish()
    }
}
/// See [`UpdateComponentOutput`](crate::output::UpdateComponentOutput)
pub mod update_component_output {
    /// A builder for [`UpdateComponentOutput`](crate::output::UpdateComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity: std::option::Option<crate::model::Component>,
    }
    impl Builder {
        /// <p>Describes the configuration of the updated component.</p>
        pub fn entity(mut self, input: crate::model::Component) -> Self {
            self.entity = Some(input);
            self
        }
        /// <p>Describes the configuration of the updated component.</p>
        pub fn set_entity(mut self, input: std::option::Option<crate::model::Component>) -> Self {
            self.entity = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateComponentOutput`](crate::output::UpdateComponentOutput)
        pub fn build(self) -> crate::output::UpdateComponentOutput {
            crate::output::UpdateComponentOutput {
                entity: self.entity,
            }
        }
    }
}
impl UpdateComponentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateComponentOutput`](crate::output::UpdateComponentOutput)
    pub fn builder() -> crate::output::update_component_output::Builder {
        crate::output::update_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentOutput {
    /// <p>Represents the configuration settings for the component.</p>
    pub component: std::option::Option<crate::model::Component>,
}
impl GetComponentOutput {
    /// <p>Represents the configuration settings for the component.</p>
    pub fn component(&self) -> std::option::Option<&crate::model::Component> {
        self.component.as_ref()
    }
}
impl std::fmt::Debug for GetComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentOutput");
        formatter.field("component", &self.component);
        formatter.finish()
    }
}
/// See [`GetComponentOutput`](crate::output::GetComponentOutput)
pub mod get_component_output {
    /// A builder for [`GetComponentOutput`](crate::output::GetComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component: std::option::Option<crate::model::Component>,
    }
    impl Builder {
        /// <p>Represents the configuration settings for the component.</p>
        pub fn component(mut self, input: crate::model::Component) -> Self {
            self.component = Some(input);
            self
        }
        /// <p>Represents the configuration settings for the component.</p>
        pub fn set_component(
            mut self,
            input: std::option::Option<crate::model::Component>,
        ) -> Self {
            self.component = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentOutput`](crate::output::GetComponentOutput)
        pub fn build(self) -> crate::output::GetComponentOutput {
            crate::output::GetComponentOutput {
                component: self.component,
            }
        }
    }
}
impl GetComponentOutput {
    /// Creates a new builder-style object to manufacture [`GetComponentOutput`](crate::output::GetComponentOutput)
    pub fn builder() -> crate::output::get_component_output::Builder {
        crate::output::get_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshTokenOutput {
    /// <p>The access token.</p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p>The date and time when the new access token expires.</p>
    pub expires_in: std::option::Option<i32>,
}
impl RefreshTokenOutput {
    /// <p>The access token.</p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p>The date and time when the new access token expires.</p>
    pub fn expires_in(&self) -> std::option::Option<i32> {
        self.expires_in
    }
}
impl std::fmt::Debug for RefreshTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshTokenOutput");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("expires_in", &self.expires_in);
        formatter.finish()
    }
}
/// See [`RefreshTokenOutput`](crate::output::RefreshTokenOutput)
pub mod refresh_token_output {
    /// A builder for [`RefreshTokenOutput`](crate::output::RefreshTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) expires_in: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The date and time when the new access token expires.</p>
        pub fn expires_in(mut self, input: i32) -> Self {
            self.expires_in = Some(input);
            self
        }
        /// <p>The date and time when the new access token expires.</p>
        pub fn set_expires_in(mut self, input: std::option::Option<i32>) -> Self {
            self.expires_in = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshTokenOutput`](crate::output::RefreshTokenOutput)
        pub fn build(self) -> crate::output::RefreshTokenOutput {
            crate::output::RefreshTokenOutput {
                access_token: self.access_token,
                expires_in: self.expires_in,
            }
        }
    }
}
impl RefreshTokenOutput {
    /// Creates a new builder-style object to manufacture [`RefreshTokenOutput`](crate::output::RefreshTokenOutput)
    pub fn builder() -> crate::output::refresh_token_output::Builder {
        crate::output::refresh_token_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExchangeCodeForTokenOutput {
    /// <p>The access token.</p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p>The date and time when the new access token expires.</p>
    pub expires_in: std::option::Option<i32>,
    /// <p>The token to use to refresh a previously issued access token that might have expired.</p>
    pub refresh_token: std::option::Option<std::string::String>,
}
impl ExchangeCodeForTokenOutput {
    /// <p>The access token.</p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p>The date and time when the new access token expires.</p>
    pub fn expires_in(&self) -> std::option::Option<i32> {
        self.expires_in
    }
    /// <p>The token to use to refresh a previously issued access token that might have expired.</p>
    pub fn refresh_token(&self) -> std::option::Option<&str> {
        self.refresh_token.as_deref()
    }
}
impl std::fmt::Debug for ExchangeCodeForTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExchangeCodeForTokenOutput");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("expires_in", &self.expires_in);
        formatter.field("refresh_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ExchangeCodeForTokenOutput`](crate::output::ExchangeCodeForTokenOutput)
pub mod exchange_code_for_token_output {
    /// A builder for [`ExchangeCodeForTokenOutput`](crate::output::ExchangeCodeForTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) expires_in: std::option::Option<i32>,
        pub(crate) refresh_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The date and time when the new access token expires.</p>
        pub fn expires_in(mut self, input: i32) -> Self {
            self.expires_in = Some(input);
            self
        }
        /// <p>The date and time when the new access token expires.</p>
        pub fn set_expires_in(mut self, input: std::option::Option<i32>) -> Self {
            self.expires_in = input;
            self
        }
        /// <p>The token to use to refresh a previously issued access token that might have expired.</p>
        pub fn refresh_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_token = Some(input.into());
            self
        }
        /// <p>The token to use to refresh a previously issued access token that might have expired.</p>
        pub fn set_refresh_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ExchangeCodeForTokenOutput`](crate::output::ExchangeCodeForTokenOutput)
        pub fn build(self) -> crate::output::ExchangeCodeForTokenOutput {
            crate::output::ExchangeCodeForTokenOutput {
                access_token: self.access_token,
                expires_in: self.expires_in,
                refresh_token: self.refresh_token,
            }
        }
    }
}
impl ExchangeCodeForTokenOutput {
    /// Creates a new builder-style object to manufacture [`ExchangeCodeForTokenOutput`](crate::output::ExchangeCodeForTokenOutput)
    pub fn builder() -> crate::output::exchange_code_for_token_output::Builder {
        crate::output::exchange_code_for_token_output::Builder::default()
    }
}
