// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_component`](crate::client::Client::create_component).
///
/// See [`crate::client::fluent_builders::CreateComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateComponent {
    _private: (),
}
impl CreateComponent {
    /// Creates a new builder-style object to manufacture [`CreateComponentInput`](crate::input::CreateComponentInput)
    pub fn builder() -> crate::input::create_component_input::Builder {
        crate::input::create_component_input::Builder::default()
    }
    /// Creates a new `CreateComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateComponent {
    type Output = std::result::Result<
        crate::output::CreateComponentOutput,
        crate::error::CreateComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_component_error(response)
        } else {
            crate::operation_deser::parse_create_component_response(response)
        }
    }
}

/// Operation shape for `CreateTheme`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_theme`](crate::client::Client::create_theme).
///
/// See [`crate::client::fluent_builders::CreateTheme`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTheme {
    _private: (),
}
impl CreateTheme {
    /// Creates a new builder-style object to manufacture [`CreateThemeInput`](crate::input::CreateThemeInput)
    pub fn builder() -> crate::input::create_theme_input::Builder {
        crate::input::create_theme_input::Builder::default()
    }
    /// Creates a new `CreateTheme` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTheme {
    type Output =
        std::result::Result<crate::output::CreateThemeOutput, crate::error::CreateThemeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_theme_error(response)
        } else {
            crate::operation_deser::parse_create_theme_response(response)
        }
    }
}

/// Operation shape for `DeleteComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_component`](crate::client::Client::delete_component).
///
/// See [`crate::client::fluent_builders::DeleteComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteComponent {
    _private: (),
}
impl DeleteComponent {
    /// Creates a new builder-style object to manufacture [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    pub fn builder() -> crate::input::delete_component_input::Builder {
        crate::input::delete_component_input::Builder::default()
    }
    /// Creates a new `DeleteComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteComponent {
    type Output = std::result::Result<
        crate::output::DeleteComponentOutput,
        crate::error::DeleteComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_component_error(response)
        } else {
            crate::operation_deser::parse_delete_component_response(response)
        }
    }
}

/// Operation shape for `DeleteTheme`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_theme`](crate::client::Client::delete_theme).
///
/// See [`crate::client::fluent_builders::DeleteTheme`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTheme {
    _private: (),
}
impl DeleteTheme {
    /// Creates a new builder-style object to manufacture [`DeleteThemeInput`](crate::input::DeleteThemeInput)
    pub fn builder() -> crate::input::delete_theme_input::Builder {
        crate::input::delete_theme_input::Builder::default()
    }
    /// Creates a new `DeleteTheme` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTheme {
    type Output =
        std::result::Result<crate::output::DeleteThemeOutput, crate::error::DeleteThemeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_theme_error(response)
        } else {
            crate::operation_deser::parse_delete_theme_response(response)
        }
    }
}

/// Operation shape for `ExchangeCodeForToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`exchange_code_for_token`](crate::client::Client::exchange_code_for_token).
///
/// See [`crate::client::fluent_builders::ExchangeCodeForToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExchangeCodeForToken {
    _private: (),
}
impl ExchangeCodeForToken {
    /// Creates a new builder-style object to manufacture [`ExchangeCodeForTokenInput`](crate::input::ExchangeCodeForTokenInput)
    pub fn builder() -> crate::input::exchange_code_for_token_input::Builder {
        crate::input::exchange_code_for_token_input::Builder::default()
    }
    /// Creates a new `ExchangeCodeForToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExchangeCodeForToken {
    type Output = std::result::Result<
        crate::output::ExchangeCodeForTokenOutput,
        crate::error::ExchangeCodeForTokenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_exchange_code_for_token_error(response)
        } else {
            crate::operation_deser::parse_exchange_code_for_token_response(response)
        }
    }
}

/// Operation shape for `ExportComponents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_components`](crate::client::Client::export_components).
///
/// See [`crate::client::fluent_builders::ExportComponents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportComponents {
    _private: (),
}
impl ExportComponents {
    /// Creates a new builder-style object to manufacture [`ExportComponentsInput`](crate::input::ExportComponentsInput)
    pub fn builder() -> crate::input::export_components_input::Builder {
        crate::input::export_components_input::Builder::default()
    }
    /// Creates a new `ExportComponents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportComponents {
    type Output = std::result::Result<
        crate::output::ExportComponentsOutput,
        crate::error::ExportComponentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_components_error(response)
        } else {
            crate::operation_deser::parse_export_components_response(response)
        }
    }
}

/// Operation shape for `ExportThemes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_themes`](crate::client::Client::export_themes).
///
/// See [`crate::client::fluent_builders::ExportThemes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportThemes {
    _private: (),
}
impl ExportThemes {
    /// Creates a new builder-style object to manufacture [`ExportThemesInput`](crate::input::ExportThemesInput)
    pub fn builder() -> crate::input::export_themes_input::Builder {
        crate::input::export_themes_input::Builder::default()
    }
    /// Creates a new `ExportThemes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportThemes {
    type Output =
        std::result::Result<crate::output::ExportThemesOutput, crate::error::ExportThemesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_themes_error(response)
        } else {
            crate::operation_deser::parse_export_themes_response(response)
        }
    }
}

/// Operation shape for `GetComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_component`](crate::client::Client::get_component).
///
/// See [`crate::client::fluent_builders::GetComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComponent {
    _private: (),
}
impl GetComponent {
    /// Creates a new builder-style object to manufacture [`GetComponentInput`](crate::input::GetComponentInput)
    pub fn builder() -> crate::input::get_component_input::Builder {
        crate::input::get_component_input::Builder::default()
    }
    /// Creates a new `GetComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComponent {
    type Output =
        std::result::Result<crate::output::GetComponentOutput, crate::error::GetComponentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_component_error(response)
        } else {
            crate::operation_deser::parse_get_component_response(response)
        }
    }
}

/// Operation shape for `GetTheme`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_theme`](crate::client::Client::get_theme).
///
/// See [`crate::client::fluent_builders::GetTheme`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTheme {
    _private: (),
}
impl GetTheme {
    /// Creates a new builder-style object to manufacture [`GetThemeInput`](crate::input::GetThemeInput)
    pub fn builder() -> crate::input::get_theme_input::Builder {
        crate::input::get_theme_input::Builder::default()
    }
    /// Creates a new `GetTheme` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTheme {
    type Output = std::result::Result<crate::output::GetThemeOutput, crate::error::GetThemeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_theme_error(response)
        } else {
            crate::operation_deser::parse_get_theme_response(response)
        }
    }
}

/// Operation shape for `ListComponents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_components`](crate::client::Client::list_components).
///
/// See [`crate::client::fluent_builders::ListComponents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListComponents {
    _private: (),
}
impl ListComponents {
    /// Creates a new builder-style object to manufacture [`ListComponentsInput`](crate::input::ListComponentsInput)
    pub fn builder() -> crate::input::list_components_input::Builder {
        crate::input::list_components_input::Builder::default()
    }
    /// Creates a new `ListComponents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListComponents {
    type Output =
        std::result::Result<crate::output::ListComponentsOutput, crate::error::ListComponentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_components_error(response)
        } else {
            crate::operation_deser::parse_list_components_response(response)
        }
    }
}

/// Operation shape for `ListThemes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_themes`](crate::client::Client::list_themes).
///
/// See [`crate::client::fluent_builders::ListThemes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThemes {
    _private: (),
}
impl ListThemes {
    /// Creates a new builder-style object to manufacture [`ListThemesInput`](crate::input::ListThemesInput)
    pub fn builder() -> crate::input::list_themes_input::Builder {
        crate::input::list_themes_input::Builder::default()
    }
    /// Creates a new `ListThemes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThemes {
    type Output =
        std::result::Result<crate::output::ListThemesOutput, crate::error::ListThemesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_themes_error(response)
        } else {
            crate::operation_deser::parse_list_themes_response(response)
        }
    }
}

/// Operation shape for `RefreshToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`refresh_token`](crate::client::Client::refresh_token).
///
/// See [`crate::client::fluent_builders::RefreshToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RefreshToken {
    _private: (),
}
impl RefreshToken {
    /// Creates a new builder-style object to manufacture [`RefreshTokenInput`](crate::input::RefreshTokenInput)
    pub fn builder() -> crate::input::refresh_token_input::Builder {
        crate::input::refresh_token_input::Builder::default()
    }
    /// Creates a new `RefreshToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RefreshToken {
    type Output =
        std::result::Result<crate::output::RefreshTokenOutput, crate::error::RefreshTokenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_refresh_token_error(response)
        } else {
            crate::operation_deser::parse_refresh_token_response(response)
        }
    }
}

/// Operation shape for `UpdateComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_component`](crate::client::Client::update_component).
///
/// See [`crate::client::fluent_builders::UpdateComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateComponent {
    _private: (),
}
impl UpdateComponent {
    /// Creates a new builder-style object to manufacture [`UpdateComponentInput`](crate::input::UpdateComponentInput)
    pub fn builder() -> crate::input::update_component_input::Builder {
        crate::input::update_component_input::Builder::default()
    }
    /// Creates a new `UpdateComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateComponent {
    type Output = std::result::Result<
        crate::output::UpdateComponentOutput,
        crate::error::UpdateComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_component_error(response)
        } else {
            crate::operation_deser::parse_update_component_response(response)
        }
    }
}

/// Operation shape for `UpdateTheme`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_theme`](crate::client::Client::update_theme).
///
/// See [`crate::client::fluent_builders::UpdateTheme`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTheme {
    _private: (),
}
impl UpdateTheme {
    /// Creates a new builder-style object to manufacture [`UpdateThemeInput`](crate::input::UpdateThemeInput)
    pub fn builder() -> crate::input::update_theme_input::Builder {
        crate::input::update_theme_input::Builder::default()
    }
    /// Creates a new `UpdateTheme` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTheme {
    type Output =
        std::result::Result<crate::output::UpdateThemeOutput, crate::error::UpdateThemeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_theme_error(response)
        } else {
            crate::operation_deser::parse_update_theme_response(response)
        }
    }
}
