// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Amplify UI Builder
///
/// Client for invoking operations on AWS Amplify UI Builder. Each operation on AWS Amplify UI Builder is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_amplifyuibuilder::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_amplifyuibuilder::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_amplifyuibuilder::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateComponent` operation.
    ///
    /// See [`CreateComponent`](crate::client::fluent_builders::CreateComponent) for more information about the
    /// operation and its arguments.
    pub fn create_component(&self) -> fluent_builders::CreateComponent<C, M, R> {
        fluent_builders::CreateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTheme` operation.
    ///
    /// See [`CreateTheme`](crate::client::fluent_builders::CreateTheme) for more information about the
    /// operation and its arguments.
    pub fn create_theme(&self) -> fluent_builders::CreateTheme<C, M, R> {
        fluent_builders::CreateTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteComponent` operation.
    ///
    /// See [`DeleteComponent`](crate::client::fluent_builders::DeleteComponent) for more information about the
    /// operation and its arguments.
    pub fn delete_component(&self) -> fluent_builders::DeleteComponent<C, M, R> {
        fluent_builders::DeleteComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTheme` operation.
    ///
    /// See [`DeleteTheme`](crate::client::fluent_builders::DeleteTheme) for more information about the
    /// operation and its arguments.
    pub fn delete_theme(&self) -> fluent_builders::DeleteTheme<C, M, R> {
        fluent_builders::DeleteTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExchangeCodeForToken` operation.
    ///
    /// See [`ExchangeCodeForToken`](crate::client::fluent_builders::ExchangeCodeForToken) for more information about the
    /// operation and its arguments.
    pub fn exchange_code_for_token(&self) -> fluent_builders::ExchangeCodeForToken<C, M, R> {
        fluent_builders::ExchangeCodeForToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportComponents` operation.
    ///
    /// See [`ExportComponents`](crate::client::fluent_builders::ExportComponents) for more information about the
    /// operation and its arguments.
    pub fn export_components(&self) -> fluent_builders::ExportComponents<C, M, R> {
        fluent_builders::ExportComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportThemes` operation.
    ///
    /// See [`ExportThemes`](crate::client::fluent_builders::ExportThemes) for more information about the
    /// operation and its arguments.
    pub fn export_themes(&self) -> fluent_builders::ExportThemes<C, M, R> {
        fluent_builders::ExportThemes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetComponent` operation.
    ///
    /// See [`GetComponent`](crate::client::fluent_builders::GetComponent) for more information about the
    /// operation and its arguments.
    pub fn get_component(&self) -> fluent_builders::GetComponent<C, M, R> {
        fluent_builders::GetComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTheme` operation.
    ///
    /// See [`GetTheme`](crate::client::fluent_builders::GetTheme) for more information about the
    /// operation and its arguments.
    pub fn get_theme(&self) -> fluent_builders::GetTheme<C, M, R> {
        fluent_builders::GetTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListComponents` operation.
    ///
    /// See [`ListComponents`](crate::client::fluent_builders::ListComponents) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListComponents::into_paginator).
    pub fn list_components(&self) -> fluent_builders::ListComponents<C, M, R> {
        fluent_builders::ListComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThemes` operation.
    ///
    /// See [`ListThemes`](crate::client::fluent_builders::ListThemes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThemes::into_paginator).
    pub fn list_themes(&self) -> fluent_builders::ListThemes<C, M, R> {
        fluent_builders::ListThemes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RefreshToken` operation.
    ///
    /// See [`RefreshToken`](crate::client::fluent_builders::RefreshToken) for more information about the
    /// operation and its arguments.
    pub fn refresh_token(&self) -> fluent_builders::RefreshToken<C, M, R> {
        fluent_builders::RefreshToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateComponent` operation.
    ///
    /// See [`UpdateComponent`](crate::client::fluent_builders::UpdateComponent) for more information about the
    /// operation and its arguments.
    pub fn update_component(&self) -> fluent_builders::UpdateComponent<C, M, R> {
        fluent_builders::UpdateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTheme` operation.
    ///
    /// See [`UpdateTheme`](crate::client::fluent_builders::UpdateTheme) for more information about the
    /// operation and its arguments.
    pub fn update_theme(&self) -> fluent_builders::UpdateTheme<C, M, R> {
        fluent_builders::UpdateTheme::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateComponent`.
    ///
    /// <p>Creates a new component for an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_component_input::Builder,
    }
    impl<C, M, R> CreateComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateComponentInputOperationOutputAlias,
                crate::output::CreateComponentOutput,
                crate::error::CreateComponentError,
                crate::input::CreateComponentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app to associate with the component.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app to associate with the component.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Represents the configuration of the component to create.</p>
        pub fn component_to_create(mut self, input: crate::model::CreateComponentData) -> Self {
            self.inner = self.inner.component_to_create(input);
            self
        }
        /// <p>Represents the configuration of the component to create.</p>
        pub fn set_component_to_create(
            mut self,
            input: std::option::Option<crate::model::CreateComponentData>,
        ) -> Self {
            self.inner = self.inner.set_component_to_create(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTheme`.
    ///
    /// <p>Creates a theme to apply to the components in an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_theme_input::Builder,
    }
    impl<C, M, R> CreateTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThemeInputOperationOutputAlias,
                crate::output::CreateThemeOutput,
                crate::error::CreateThemeError,
                crate::input::CreateThemeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app associated with the theme.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the theme.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Represents the configuration of the theme to create.</p>
        pub fn theme_to_create(mut self, input: crate::model::CreateThemeData) -> Self {
            self.inner = self.inner.theme_to_create(input);
            self
        }
        /// <p>Represents the configuration of the theme to create.</p>
        pub fn set_theme_to_create(
            mut self,
            input: std::option::Option<crate::model::CreateThemeData>,
        ) -> Self {
            self.inner = self.inner.set_theme_to_create(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComponent`.
    ///
    /// <p>Deletes a component from an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_component_input::Builder,
    }
    impl<C, M, R> DeleteComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteComponentInputOperationOutputAlias,
                crate::output::DeleteComponentOutput,
                crate::error::DeleteComponentError,
                crate::input::DeleteComponentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app associated with the component to delete.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the component to delete.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID of the component to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID of the component to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTheme`.
    ///
    /// <p>Deletes a theme from an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_theme_input::Builder,
    }
    impl<C, M, R> DeleteTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThemeInputOperationOutputAlias,
                crate::output::DeleteThemeOutput,
                crate::error::DeleteThemeError,
                crate::input::DeleteThemeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app associated with the theme to delete.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the theme to delete.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID of the theme to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID of the theme to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExchangeCodeForToken`.
    ///
    /// <p>Exchanges an access code for a token.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExchangeCodeForToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::exchange_code_for_token_input::Builder,
    }
    impl<C, M, R> ExchangeCodeForToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExchangeCodeForToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExchangeCodeForTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::ExchangeCodeForTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExchangeCodeForTokenInputOperationOutputAlias,
                crate::output::ExchangeCodeForTokenOutput,
                crate::error::ExchangeCodeForTokenError,
                crate::input::ExchangeCodeForTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn provider(mut self, input: crate::model::TokenProviders) -> Self {
            self.inner = self.inner.provider(input);
            self
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::TokenProviders>,
        ) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>Describes the configuration of the request.</p>
        pub fn request(mut self, input: crate::model::ExchangeCodeForTokenRequestBody) -> Self {
            self.inner = self.inner.request(input);
            self
        }
        /// <p>Describes the configuration of the request.</p>
        pub fn set_request(
            mut self,
            input: std::option::Option<crate::model::ExchangeCodeForTokenRequestBody>,
        ) -> Self {
            self.inner = self.inner.set_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportComponents`.
    ///
    /// <p>Exports component configurations to code that is ready to integrate into an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportComponents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_components_input::Builder,
    }
    impl<C, M, R> ExportComponents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportComponentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportComponentsInputOperationOutputAlias,
                crate::output::ExportComponentsOutput,
                crate::error::ExportComponentsError,
                crate::input::ExportComponentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app to export components to.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app to export components to.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportThemes`.
    ///
    /// <p>Exports theme configurations to code that is ready to integrate into an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportThemes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_themes_input::Builder,
    }
    impl<C, M, R> ExportThemes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportThemes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportThemesOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportThemesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportThemesInputOperationOutputAlias,
                crate::output::ExportThemesOutput,
                crate::error::ExportThemesError,
                crate::input::ExportThemesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app to export the themes to.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app to export the themes to.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComponent`.
    ///
    /// <p>Returns an existing component for an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_component_input::Builder,
    }
    impl<C, M, R> GetComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComponentInputOperationOutputAlias,
                crate::output::GetComponentOutput,
                crate::error::GetComponentError,
                crate::input::GetComponentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTheme`.
    ///
    /// <p>Returns an existing theme for an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_theme_input::Builder,
    }
    impl<C, M, R> GetTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetThemeInputOperationOutputAlias,
                crate::output::GetThemeOutput,
                crate::error::GetThemeError,
                crate::input::GetThemeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponents`.
    ///
    /// <p>Retrieves a list of components for a specified Amplify app and backend environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComponents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_components_input::Builder,
    }
    impl<C, M, R> ListComponents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListComponentsInputOperationOutputAlias,
                crate::output::ListComponentsOutput,
                crate::error::ListComponentsError,
                crate::input::ListComponentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComponentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComponentsPaginator<C, M, R> {
            crate::paginator::ListComponentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of components to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of components to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThemes`.
    ///
    /// <p>Retrieves a list of themes for a specified Amplify app and backend environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThemes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_themes_input::Builder,
    }
    impl<C, M, R> ListThemes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThemes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThemesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThemesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThemesInputOperationOutputAlias,
                crate::output::ListThemesOutput,
                crate::error::ListThemesError,
                crate::input::ListThemesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThemesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThemesPaginator<C, M, R> {
            crate::paginator::ListThemesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of theme results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of theme results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RefreshToken`.
    ///
    /// <p>Refreshes a previously issued access token that might have expired.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RefreshToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::refresh_token_input::Builder,
    }
    impl<C, M, R> RefreshToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RefreshToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RefreshTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::RefreshTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RefreshTokenInputOperationOutputAlias,
                crate::output::RefreshTokenOutput,
                crate::error::RefreshTokenError,
                crate::input::RefreshTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn provider(mut self, input: crate::model::TokenProviders) -> Self {
            self.inner = self.inner.provider(input);
            self
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::TokenProviders>,
        ) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>Information about the refresh token request.</p>
        pub fn refresh_token_body(mut self, input: crate::model::RefreshTokenRequestBody) -> Self {
            self.inner = self.inner.refresh_token_body(input);
            self
        }
        /// <p>Information about the refresh token request.</p>
        pub fn set_refresh_token_body(
            mut self,
            input: std::option::Option<crate::model::RefreshTokenRequestBody>,
        ) -> Self {
            self.inner = self.inner.set_refresh_token_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComponent`.
    ///
    /// <p>Updates an existing component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_component_input::Builder,
    }
    impl<C, M, R> UpdateComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateComponentInputOperationOutputAlias,
                crate::output::UpdateComponentOutput,
                crate::error::UpdateComponentError,
                crate::input::UpdateComponentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID for the component.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID for the component.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration of the updated component.</p>
        pub fn updated_component(mut self, input: crate::model::UpdateComponentData) -> Self {
            self.inner = self.inner.updated_component(input);
            self
        }
        /// <p>The configuration of the updated component.</p>
        pub fn set_updated_component(
            mut self,
            input: std::option::Option<crate::model::UpdateComponentData>,
        ) -> Self {
            self.inner = self.inner.set_updated_component(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTheme`.
    ///
    /// <p>Updates an existing theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_theme_input::Builder,
    }
    impl<C, M, R> UpdateTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThemeInputOperationOutputAlias,
                crate::output::UpdateThemeOutput,
                crate::error::UpdateThemeError,
                crate::input::UpdateThemeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration of the updated theme.</p>
        pub fn updated_theme(mut self, input: crate::model::UpdateThemeData) -> Self {
            self.inner = self.inner.updated_theme(input);
            self
        }
        /// <p>The configuration of the updated theme.</p>
        pub fn set_updated_theme(
            mut self,
            input: std::option::Option<crate::model::UpdateThemeData>,
        ) -> Self {
            self.inner = self.inner.set_updated_theme(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
