// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A theme is a collection of style settings that apply globally to the components associated with an Amplify application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Theme {
    /// <p>The unique ID for the Amplify app associated with the theme.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The ID for the theme.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the theme.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time that the theme was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the theme was modified.</p>
    pub modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of key-value pairs that defines the properties of the theme.</p>
    pub values: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
    /// <p>Describes the properties that can be overriden to customize a theme.</p>
    pub overrides: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
    /// <p>One or more key-value pairs to use when tagging the theme.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Theme {
    /// <p>The unique ID for the Amplify app associated with the theme.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The ID for the theme.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the theme.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time that the theme was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time that the theme was modified.</p>
    pub fn modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_at.as_ref()
    }
    /// <p>A list of key-value pairs that defines the properties of the theme.</p>
    pub fn values(&self) -> std::option::Option<&[crate::model::ThemeValues]> {
        self.values.as_deref()
    }
    /// <p>Describes the properties that can be overriden to customize a theme.</p>
    pub fn overrides(&self) -> std::option::Option<&[crate::model::ThemeValues]> {
        self.overrides.as_deref()
    }
    /// <p>One or more key-value pairs to use when tagging the theme.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Theme {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Theme");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("created_at", &self.created_at);
        formatter.field("modified_at", &self.modified_at);
        formatter.field("values", &self.values);
        formatter.field("overrides", &self.overrides);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Theme`](crate::model::Theme)
pub mod theme {
    /// A builder for [`Theme`](crate::model::Theme)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) values: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        pub(crate) overrides: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique ID for the Amplify app associated with the theme.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app associated with the theme.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the theme.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time that the theme was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time that the theme was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time that the theme was modified.</p>
        pub fn modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_at = Some(input);
            self
        }
        /// <p>The time that the theme was modified.</p>
        pub fn set_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_at = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key-value pairs that defines the properties of the theme.</p>
        pub fn values(mut self, input: crate::model::ThemeValues) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input);
            self.values = Some(v);
            self
        }
        /// <p>A list of key-value pairs that defines the properties of the theme.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Appends an item to `overrides`.
        ///
        /// To override the contents of this collection use [`set_overrides`](Self::set_overrides).
        ///
        /// <p>Describes the properties that can be overriden to customize a theme.</p>
        pub fn overrides(mut self, input: crate::model::ThemeValues) -> Self {
            let mut v = self.overrides.unwrap_or_default();
            v.push(input);
            self.overrides = Some(v);
            self
        }
        /// <p>Describes the properties that can be overriden to customize a theme.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more key-value pairs to use when tagging the theme.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more key-value pairs to use when tagging the theme.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Theme`](crate::model::Theme)
        pub fn build(self) -> crate::model::Theme {
            crate::model::Theme {
                app_id: self.app_id,
                environment_name: self.environment_name,
                id: self.id,
                name: self.name,
                created_at: self.created_at,
                modified_at: self.modified_at,
                values: self.values,
                overrides: self.overrides,
                tags: self.tags,
            }
        }
    }
}
impl Theme {
    /// Creates a new builder-style object to manufacture [`Theme`](crate::model::Theme)
    pub fn builder() -> crate::model::theme::Builder {
        crate::model::theme::Builder::default()
    }
}

/// <p>A key-value pair that defines a property of a theme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThemeValues {
    /// <p>The name of the property.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the property.</p>
    pub value: std::option::Option<crate::model::ThemeValue>,
}
impl ThemeValues {
    /// <p>The name of the property.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the property.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::ThemeValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for ThemeValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThemeValues");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ThemeValues`](crate::model::ThemeValues)
pub mod theme_values {
    /// A builder for [`ThemeValues`](crate::model::ThemeValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::ThemeValue>,
    }
    impl Builder {
        /// <p>The name of the property.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the property.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the property.</p>
        pub fn value(mut self, input: crate::model::ThemeValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the property.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::ThemeValue>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ThemeValues`](crate::model::ThemeValues)
        pub fn build(self) -> crate::model::ThemeValues {
            crate::model::ThemeValues {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl ThemeValues {
    /// Creates a new builder-style object to manufacture [`ThemeValues`](crate::model::ThemeValues)
    pub fn builder() -> crate::model::theme_values::Builder {
        crate::model::theme_values::Builder::default()
    }
}

/// <p>Describes the configuration of a theme's properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThemeValue {
    /// <p>The value of a theme property.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that define the theme's properties.</p>
    pub children: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
}
impl ThemeValue {
    /// <p>The value of a theme property.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>A list of key-value pairs that define the theme's properties.</p>
    pub fn children(&self) -> std::option::Option<&[crate::model::ThemeValues]> {
        self.children.as_deref()
    }
}
impl std::fmt::Debug for ThemeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThemeValue");
        formatter.field("value", &self.value);
        formatter.field("children", &self.children);
        formatter.finish()
    }
}
/// See [`ThemeValue`](crate::model::ThemeValue)
pub mod theme_value {
    /// A builder for [`ThemeValue`](crate::model::ThemeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) children: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
    }
    impl Builder {
        /// <p>The value of a theme property.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a theme property.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Appends an item to `children`.
        ///
        /// To override the contents of this collection use [`set_children`](Self::set_children).
        ///
        /// <p>A list of key-value pairs that define the theme's properties.</p>
        pub fn children(mut self, input: crate::model::ThemeValues) -> Self {
            let mut v = self.children.unwrap_or_default();
            v.push(input);
            self.children = Some(v);
            self
        }
        /// <p>A list of key-value pairs that define the theme's properties.</p>
        pub fn set_children(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        ) -> Self {
            self.children = input;
            self
        }
        /// Consumes the builder and constructs a [`ThemeValue`](crate::model::ThemeValue)
        pub fn build(self) -> crate::model::ThemeValue {
            crate::model::ThemeValue {
                value: self.value,
                children: self.children,
            }
        }
    }
}
impl ThemeValue {
    /// Creates a new builder-style object to manufacture [`ThemeValue`](crate::model::ThemeValue)
    pub fn builder() -> crate::model::theme_value::Builder {
        crate::model::theme_value::Builder::default()
    }
}

/// <p>Describes the basic information about a theme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThemeSummary {
    /// <p>The unique ID for the app associated with the theme summary.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The ID of the theme.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the theme.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ThemeSummary {
    /// <p>The unique ID for the app associated with the theme summary.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The ID of the theme.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the theme.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ThemeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThemeSummary");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ThemeSummary`](crate::model::ThemeSummary)
pub mod theme_summary {
    /// A builder for [`ThemeSummary`](crate::model::ThemeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID for the app associated with the theme summary.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the app associated with the theme summary.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The ID of the theme.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the theme.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the theme.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ThemeSummary`](crate::model::ThemeSummary)
        pub fn build(self) -> crate::model::ThemeSummary {
            crate::model::ThemeSummary {
                app_id: self.app_id,
                environment_name: self.environment_name,
                id: self.id,
                name: self.name,
            }
        }
    }
}
impl ThemeSummary {
    /// Creates a new builder-style object to manufacture [`ThemeSummary`](crate::model::ThemeSummary)
    pub fn builder() -> crate::model::theme_summary::Builder {
        crate::model::theme_summary::Builder::default()
    }
}

/// <p>Represents all of the information that is required to create a theme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThemeData {
    /// <p>The name of the theme.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that deﬁnes the properties of the theme.</p>
    pub values: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
    /// <p>Describes the properties that can be overriden to customize an instance of the theme.</p>
    pub overrides: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
    /// <p>One or more key-value pairs to use when tagging the theme data.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateThemeData {
    /// <p>The name of the theme.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of key-value pairs that deﬁnes the properties of the theme.</p>
    pub fn values(&self) -> std::option::Option<&[crate::model::ThemeValues]> {
        self.values.as_deref()
    }
    /// <p>Describes the properties that can be overriden to customize an instance of the theme.</p>
    pub fn overrides(&self) -> std::option::Option<&[crate::model::ThemeValues]> {
        self.overrides.as_deref()
    }
    /// <p>One or more key-value pairs to use when tagging the theme data.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateThemeData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThemeData");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("overrides", &self.overrides);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateThemeData`](crate::model::CreateThemeData)
pub mod create_theme_data {
    /// A builder for [`CreateThemeData`](crate::model::CreateThemeData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        pub(crate) overrides: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the theme.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key-value pairs that deﬁnes the properties of the theme.</p>
        pub fn values(mut self, input: crate::model::ThemeValues) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input);
            self.values = Some(v);
            self
        }
        /// <p>A list of key-value pairs that deﬁnes the properties of the theme.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Appends an item to `overrides`.
        ///
        /// To override the contents of this collection use [`set_overrides`](Self::set_overrides).
        ///
        /// <p>Describes the properties that can be overriden to customize an instance of the theme.</p>
        pub fn overrides(mut self, input: crate::model::ThemeValues) -> Self {
            let mut v = self.overrides.unwrap_or_default();
            v.push(input);
            self.overrides = Some(v);
            self
        }
        /// <p>Describes the properties that can be overriden to customize an instance of the theme.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more key-value pairs to use when tagging the theme data.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more key-value pairs to use when tagging the theme data.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThemeData`](crate::model::CreateThemeData)
        pub fn build(self) -> crate::model::CreateThemeData {
            crate::model::CreateThemeData {
                name: self.name,
                values: self.values,
                overrides: self.overrides,
                tags: self.tags,
            }
        }
    }
}
impl CreateThemeData {
    /// Creates a new builder-style object to manufacture [`CreateThemeData`](crate::model::CreateThemeData)
    pub fn builder() -> crate::model::create_theme_data::Builder {
        crate::model::create_theme_data::Builder::default()
    }
}

/// <p>Saves the data binding information for a theme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThemeData {
    /// <p>The unique ID of the theme to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the theme to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that define the theme's properties.</p>
    pub values: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
    /// <p>Describes the properties that can be overriden to customize the theme.</p>
    pub overrides: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
}
impl UpdateThemeData {
    /// <p>The unique ID of the theme to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the theme to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of key-value pairs that define the theme's properties.</p>
    pub fn values(&self) -> std::option::Option<&[crate::model::ThemeValues]> {
        self.values.as_deref()
    }
    /// <p>Describes the properties that can be overriden to customize the theme.</p>
    pub fn overrides(&self) -> std::option::Option<&[crate::model::ThemeValues]> {
        self.overrides.as_deref()
    }
}
impl std::fmt::Debug for UpdateThemeData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThemeData");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("overrides", &self.overrides);
        formatter.finish()
    }
}
/// See [`UpdateThemeData`](crate::model::UpdateThemeData)
pub mod update_theme_data {
    /// A builder for [`UpdateThemeData`](crate::model::UpdateThemeData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        pub(crate) overrides: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
    }
    impl Builder {
        /// <p>The unique ID of the theme to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the theme to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the theme to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the theme to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key-value pairs that define the theme's properties.</p>
        pub fn values(mut self, input: crate::model::ThemeValues) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input);
            self.values = Some(v);
            self
        }
        /// <p>A list of key-value pairs that define the theme's properties.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Appends an item to `overrides`.
        ///
        /// To override the contents of this collection use [`set_overrides`](Self::set_overrides).
        ///
        /// <p>Describes the properties that can be overriden to customize the theme.</p>
        pub fn overrides(mut self, input: crate::model::ThemeValues) -> Self {
            let mut v = self.overrides.unwrap_or_default();
            v.push(input);
            self.overrides = Some(v);
            self
        }
        /// <p>Describes the properties that can be overriden to customize the theme.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeValues>>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThemeData`](crate::model::UpdateThemeData)
        pub fn build(self) -> crate::model::UpdateThemeData {
            crate::model::UpdateThemeData {
                id: self.id,
                name: self.name,
                values: self.values,
                overrides: self.overrides,
            }
        }
    }
}
impl UpdateThemeData {
    /// Creates a new builder-style object to manufacture [`UpdateThemeData`](crate::model::UpdateThemeData)
    pub fn builder() -> crate::model::update_theme_data::Builder {
        crate::model::update_theme_data::Builder::default()
    }
}

/// <p>Contains the configuration settings for a user interface (UI) element for an Amplify app. A component is configured as a primary, stand-alone UI element. Use <code>ComponentChild</code> to configure an instance of a <code>Component</code>. A <code>ComponentChild</code> instance inherits the configuration of the main <code>Component</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Component {
    /// <p>The unique ID of the Amplify app associated with the component.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the component in its original source system, such as Figma.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of the component.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>
    pub component_type: std::option::Option<std::string::String>,
    /// <p>Describes the component's properties. You can't specify <code>tags</code> as a valid property for <code>properties</code>.</p>
    pub properties: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    >,
    /// <p>A list of the component's <code>ComponentChild</code> instances.</p>
    pub children: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
    /// <p>A list of the component's variants. A variant is a unique style configuration of a main component.</p>
    pub variants: std::option::Option<std::vec::Vec<crate::model::ComponentVariant>>,
    /// <p>Describes the component's properties that can be overriden in a customized instance of the component. You can't specify <code>tags</code> as a valid property for <code>overrides</code>.</p>
    pub overrides: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The information to connect a component's properties to data at runtime. You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code>.</p>
    /// <p></p>
    pub binding_properties: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::ComponentBindingPropertiesValue,
        >,
    >,
    /// <p>The data binding configuration for the component's properties. Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code>.</p>
    pub collection_properties: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentDataConfiguration>,
    >,
    /// <p>The time that the component was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the component was modified.</p>
    pub modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>One or more key-value pairs to use when tagging the component.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Describes the events that can be raised on the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
    pub events: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
    >,
    /// <p>The schema version of the component when it was imported.</p>
    pub schema_version: std::option::Option<std::string::String>,
}
impl Component {
    /// <p>The unique ID of the Amplify app associated with the component.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique ID of the component in its original source system, such as Figma.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The unique ID of the component.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>
    pub fn component_type(&self) -> std::option::Option<&str> {
        self.component_type.as_deref()
    }
    /// <p>Describes the component's properties. You can't specify <code>tags</code> as a valid property for <code>properties</code>.</p>
    pub fn properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    > {
        self.properties.as_ref()
    }
    /// <p>A list of the component's <code>ComponentChild</code> instances.</p>
    pub fn children(&self) -> std::option::Option<&[crate::model::ComponentChild]> {
        self.children.as_deref()
    }
    /// <p>A list of the component's variants. A variant is a unique style configuration of a main component.</p>
    pub fn variants(&self) -> std::option::Option<&[crate::model::ComponentVariant]> {
        self.variants.as_deref()
    }
    /// <p>Describes the component's properties that can be overriden in a customized instance of the component. You can't specify <code>tags</code> as a valid property for <code>overrides</code>.</p>
    pub fn overrides(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.overrides.as_ref()
    }
    /// <p>The information to connect a component's properties to data at runtime. You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code>.</p>
    /// <p></p>
    pub fn binding_properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::ComponentBindingPropertiesValue,
        >,
    > {
        self.binding_properties.as_ref()
    }
    /// <p>The data binding configuration for the component's properties. Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code>.</p>
    pub fn collection_properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentDataConfiguration>,
    > {
        self.collection_properties.as_ref()
    }
    /// <p>The time that the component was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time that the component was modified.</p>
    pub fn modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_at.as_ref()
    }
    /// <p>One or more key-value pairs to use when tagging the component.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Describes the events that can be raised on the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
    pub fn events(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
    > {
        self.events.as_ref()
    }
    /// <p>The schema version of the component when it was imported.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
}
impl std::fmt::Debug for Component {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Component");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("source_id", &self.source_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("component_type", &self.component_type);
        formatter.field("properties", &self.properties);
        formatter.field("children", &self.children);
        formatter.field("variants", &self.variants);
        formatter.field("overrides", &self.overrides);
        formatter.field("binding_properties", &self.binding_properties);
        formatter.field("collection_properties", &self.collection_properties);
        formatter.field("created_at", &self.created_at);
        formatter.field("modified_at", &self.modified_at);
        formatter.field("tags", &self.tags);
        formatter.field("events", &self.events);
        formatter.field("schema_version", &self.schema_version);
        formatter.finish()
    }
}
/// See [`Component`](crate::model::Component)
pub mod component {
    /// A builder for [`Component`](crate::model::Component)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) component_type: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
        >,
        pub(crate) children: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
        pub(crate) variants: std::option::Option<std::vec::Vec<crate::model::ComponentVariant>>,
        pub(crate) overrides: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) binding_properties: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::ComponentBindingPropertiesValue,
            >,
        >,
        pub(crate) collection_properties: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::ComponentDataConfiguration,
            >,
        >,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) events: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
        >,
        pub(crate) schema_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app associated with the component.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the component.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique ID of the component in its original source system, such as Figma.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the component in its original source system, such as Figma.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>
        pub fn component_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type = Some(input.into());
            self
        }
        /// <p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>
        pub fn set_component_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>Describes the component's properties. You can't specify <code>tags</code> as a valid property for <code>properties</code>.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentProperty,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.properties = Some(hash_map);
            self
        }
        /// <p>Describes the component's properties. You can't specify <code>tags</code> as a valid property for <code>properties</code>.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Appends an item to `children`.
        ///
        /// To override the contents of this collection use [`set_children`](Self::set_children).
        ///
        /// <p>A list of the component's <code>ComponentChild</code> instances.</p>
        pub fn children(mut self, input: crate::model::ComponentChild) -> Self {
            let mut v = self.children.unwrap_or_default();
            v.push(input);
            self.children = Some(v);
            self
        }
        /// <p>A list of the component's <code>ComponentChild</code> instances.</p>
        pub fn set_children(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
        ) -> Self {
            self.children = input;
            self
        }
        /// Appends an item to `variants`.
        ///
        /// To override the contents of this collection use [`set_variants`](Self::set_variants).
        ///
        /// <p>A list of the component's variants. A variant is a unique style configuration of a main component.</p>
        pub fn variants(mut self, input: crate::model::ComponentVariant) -> Self {
            let mut v = self.variants.unwrap_or_default();
            v.push(input);
            self.variants = Some(v);
            self
        }
        /// <p>A list of the component's variants. A variant is a unique style configuration of a main component.</p>
        pub fn set_variants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentVariant>>,
        ) -> Self {
            self.variants = input;
            self
        }
        /// Adds a key-value pair to `overrides`.
        ///
        /// To override the contents of this collection use [`set_overrides`](Self::set_overrides).
        ///
        /// <p>Describes the component's properties that can be overriden in a customized instance of the component. You can't specify <code>tags</code> as a valid property for <code>overrides</code>.</p>
        pub fn overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut hash_map = self.overrides.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.overrides = Some(hash_map);
            self
        }
        /// <p>Describes the component's properties that can be overriden in a customized instance of the component. You can't specify <code>tags</code> as a valid property for <code>overrides</code>.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Adds a key-value pair to `binding_properties`.
        ///
        /// To override the contents of this collection use [`set_binding_properties`](Self::set_binding_properties).
        ///
        /// <p>The information to connect a component's properties to data at runtime. You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code>.</p>
        /// <p></p>
        pub fn binding_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentBindingPropertiesValue,
        ) -> Self {
            let mut hash_map = self.binding_properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.binding_properties = Some(hash_map);
            self
        }
        /// <p>The information to connect a component's properties to data at runtime. You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code>.</p>
        /// <p></p>
        pub fn set_binding_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentBindingPropertiesValue,
                >,
            >,
        ) -> Self {
            self.binding_properties = input;
            self
        }
        /// Adds a key-value pair to `collection_properties`.
        ///
        /// To override the contents of this collection use [`set_collection_properties`](Self::set_collection_properties).
        ///
        /// <p>The data binding configuration for the component's properties. Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code>.</p>
        pub fn collection_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentDataConfiguration,
        ) -> Self {
            let mut hash_map = self.collection_properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.collection_properties = Some(hash_map);
            self
        }
        /// <p>The data binding configuration for the component's properties. Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code>.</p>
        pub fn set_collection_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentDataConfiguration,
                >,
            >,
        ) -> Self {
            self.collection_properties = input;
            self
        }
        /// <p>The time that the component was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time that the component was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time that the component was modified.</p>
        pub fn modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_at = Some(input);
            self
        }
        /// <p>The time that the component was modified.</p>
        pub fn set_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more key-value pairs to use when tagging the component.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more key-value pairs to use when tagging the component.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>Describes the events that can be raised on the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
        pub fn events(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentEvent,
        ) -> Self {
            let mut hash_map = self.events.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.events = Some(hash_map);
            self
        }
        /// <p>Describes the events that can be raised on the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
            >,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>The schema version of the component when it was imported.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The schema version of the component when it was imported.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Component`](crate::model::Component)
        pub fn build(self) -> crate::model::Component {
            crate::model::Component {
                app_id: self.app_id,
                environment_name: self.environment_name,
                source_id: self.source_id,
                id: self.id,
                name: self.name,
                component_type: self.component_type,
                properties: self.properties,
                children: self.children,
                variants: self.variants,
                overrides: self.overrides,
                binding_properties: self.binding_properties,
                collection_properties: self.collection_properties,
                created_at: self.created_at,
                modified_at: self.modified_at,
                tags: self.tags,
                events: self.events,
                schema_version: self.schema_version,
            }
        }
    }
}
impl Component {
    /// Creates a new builder-style object to manufacture [`Component`](crate::model::Component)
    pub fn builder() -> crate::model::component::Builder {
        crate::model::component::Builder::default()
    }
}

/// <p>Describes the configuration of an event. You can bind an event and a corresponding action to a <code>Component</code> or a <code>ComponentChild</code>. A button click is an example of an event. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentEvent {
    /// <p>The action to perform when a specific event is raised.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>Describes information about the action.</p>
    pub parameters: std::option::Option<crate::model::ActionParameters>,
    /// <p>Binds an event to an action on a component. When you specify a <code>bindingEvent</code>, the event is called when the action is performed.</p>
    pub binding_event: std::option::Option<std::string::String>,
}
impl ComponentEvent {
    /// <p>The action to perform when a specific event is raised.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>Describes information about the action.</p>
    pub fn parameters(&self) -> std::option::Option<&crate::model::ActionParameters> {
        self.parameters.as_ref()
    }
    /// <p>Binds an event to an action on a component. When you specify a <code>bindingEvent</code>, the event is called when the action is performed.</p>
    pub fn binding_event(&self) -> std::option::Option<&str> {
        self.binding_event.as_deref()
    }
}
impl std::fmt::Debug for ComponentEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentEvent");
        formatter.field("action", &self.action);
        formatter.field("parameters", &self.parameters);
        formatter.field("binding_event", &self.binding_event);
        formatter.finish()
    }
}
/// See [`ComponentEvent`](crate::model::ComponentEvent)
pub mod component_event {
    /// A builder for [`ComponentEvent`](crate::model::ComponentEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<crate::model::ActionParameters>,
        pub(crate) binding_event: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action to perform when a specific event is raised.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The action to perform when a specific event is raised.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>Describes information about the action.</p>
        pub fn parameters(mut self, input: crate::model::ActionParameters) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>Describes information about the action.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::ActionParameters>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>Binds an event to an action on a component. When you specify a <code>bindingEvent</code>, the event is called when the action is performed.</p>
        pub fn binding_event(mut self, input: impl Into<std::string::String>) -> Self {
            self.binding_event = Some(input.into());
            self
        }
        /// <p>Binds an event to an action on a component. When you specify a <code>bindingEvent</code>, the event is called when the action is performed.</p>
        pub fn set_binding_event(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.binding_event = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentEvent`](crate::model::ComponentEvent)
        pub fn build(self) -> crate::model::ComponentEvent {
            crate::model::ComponentEvent {
                action: self.action,
                parameters: self.parameters,
                binding_event: self.binding_event,
            }
        }
    }
}
impl ComponentEvent {
    /// Creates a new builder-style object to manufacture [`ComponentEvent`](crate::model::ComponentEvent)
    pub fn builder() -> crate::model::component_event::Builder {
        crate::model::component_event::Builder::default()
    }
}

/// <p>Represents the event action configuration for an element of a <code>Component</code> or <code>ComponentChild</code>. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components. <code>ActionParameters</code> defines the action that is performed when an event occurs on the component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionParameters {
    /// <p>The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value is required for a navigation action.</p>
    pub r#type: std::option::Option<crate::model::ComponentProperty>,
    /// <p>The URL to the location to open. Specify this value for a navigation action.</p>
    pub url: std::option::Option<crate::model::ComponentProperty>,
    /// <p>The HTML anchor link to the location to open. Specify this value for a navigation action.</p>
    pub anchor: std::option::Option<crate::model::ComponentProperty>,
    /// <p>The element within the same component to modify when the action occurs.</p>
    pub target: std::option::Option<crate::model::ComponentProperty>,
    /// <p>Specifies whether the user should be signed out globally. Specify this value for an auth sign out action.</p>
    pub global: std::option::Option<crate::model::ComponentProperty>,
    /// <p>The name of the data model. Use when the action performs an operation on an Amplify DataStore model.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The unique ID of the component that the <code>ActionParameters</code> apply to.</p>
    pub id: std::option::Option<crate::model::ComponentProperty>,
    /// <p>A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model. Use when the action performs an operation on an Amplify DataStore model.</p>
    pub fields: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    >,
    /// <p>A key-value pair that specifies the state property name and its initial value.</p>
    pub state: std::option::Option<crate::model::MutationActionSetStateParameter>,
}
impl ActionParameters {
    /// <p>The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value is required for a navigation action.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ComponentProperty> {
        self.r#type.as_ref()
    }
    /// <p>The URL to the location to open. Specify this value for a navigation action.</p>
    pub fn url(&self) -> std::option::Option<&crate::model::ComponentProperty> {
        self.url.as_ref()
    }
    /// <p>The HTML anchor link to the location to open. Specify this value for a navigation action.</p>
    pub fn anchor(&self) -> std::option::Option<&crate::model::ComponentProperty> {
        self.anchor.as_ref()
    }
    /// <p>The element within the same component to modify when the action occurs.</p>
    pub fn target(&self) -> std::option::Option<&crate::model::ComponentProperty> {
        self.target.as_ref()
    }
    /// <p>Specifies whether the user should be signed out globally. Specify this value for an auth sign out action.</p>
    pub fn global(&self) -> std::option::Option<&crate::model::ComponentProperty> {
        self.global.as_ref()
    }
    /// <p>The name of the data model. Use when the action performs an operation on an Amplify DataStore model.</p>
    pub fn model(&self) -> std::option::Option<&str> {
        self.model.as_deref()
    }
    /// <p>The unique ID of the component that the <code>ActionParameters</code> apply to.</p>
    pub fn id(&self) -> std::option::Option<&crate::model::ComponentProperty> {
        self.id.as_ref()
    }
    /// <p>A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model. Use when the action performs an operation on an Amplify DataStore model.</p>
    pub fn fields(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    > {
        self.fields.as_ref()
    }
    /// <p>A key-value pair that specifies the state property name and its initial value.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::MutationActionSetStateParameter> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ActionParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionParameters");
        formatter.field("r#type", &self.r#type);
        formatter.field("url", &self.url);
        formatter.field("anchor", &self.anchor);
        formatter.field("target", &self.target);
        formatter.field("global", &self.global);
        formatter.field("model", &self.model);
        formatter.field("id", &self.id);
        formatter.field("fields", &self.fields);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`ActionParameters`](crate::model::ActionParameters)
pub mod action_parameters {
    /// A builder for [`ActionParameters`](crate::model::ActionParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ComponentProperty>,
        pub(crate) url: std::option::Option<crate::model::ComponentProperty>,
        pub(crate) anchor: std::option::Option<crate::model::ComponentProperty>,
        pub(crate) target: std::option::Option<crate::model::ComponentProperty>,
        pub(crate) global: std::option::Option<crate::model::ComponentProperty>,
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<crate::model::ComponentProperty>,
        pub(crate) fields: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
        >,
        pub(crate) state: std::option::Option<crate::model::MutationActionSetStateParameter>,
    }
    impl Builder {
        /// <p>The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value is required for a navigation action.</p>
        pub fn r#type(mut self, input: crate::model::ComponentProperty) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value is required for a navigation action.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ComponentProperty>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The URL to the location to open. Specify this value for a navigation action.</p>
        pub fn url(mut self, input: crate::model::ComponentProperty) -> Self {
            self.url = Some(input);
            self
        }
        /// <p>The URL to the location to open. Specify this value for a navigation action.</p>
        pub fn set_url(
            mut self,
            input: std::option::Option<crate::model::ComponentProperty>,
        ) -> Self {
            self.url = input;
            self
        }
        /// <p>The HTML anchor link to the location to open. Specify this value for a navigation action.</p>
        pub fn anchor(mut self, input: crate::model::ComponentProperty) -> Self {
            self.anchor = Some(input);
            self
        }
        /// <p>The HTML anchor link to the location to open. Specify this value for a navigation action.</p>
        pub fn set_anchor(
            mut self,
            input: std::option::Option<crate::model::ComponentProperty>,
        ) -> Self {
            self.anchor = input;
            self
        }
        /// <p>The element within the same component to modify when the action occurs.</p>
        pub fn target(mut self, input: crate::model::ComponentProperty) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>The element within the same component to modify when the action occurs.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::ComponentProperty>,
        ) -> Self {
            self.target = input;
            self
        }
        /// <p>Specifies whether the user should be signed out globally. Specify this value for an auth sign out action.</p>
        pub fn global(mut self, input: crate::model::ComponentProperty) -> Self {
            self.global = Some(input);
            self
        }
        /// <p>Specifies whether the user should be signed out globally. Specify this value for an auth sign out action.</p>
        pub fn set_global(
            mut self,
            input: std::option::Option<crate::model::ComponentProperty>,
        ) -> Self {
            self.global = input;
            self
        }
        /// <p>The name of the data model. Use when the action performs an operation on an Amplify DataStore model.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The name of the data model. Use when the action performs an operation on an Amplify DataStore model.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// <p>The unique ID of the component that the <code>ActionParameters</code> apply to.</p>
        pub fn id(mut self, input: crate::model::ComponentProperty) -> Self {
            self.id = Some(input);
            self
        }
        /// <p>The unique ID of the component that the <code>ActionParameters</code> apply to.</p>
        pub fn set_id(
            mut self,
            input: std::option::Option<crate::model::ComponentProperty>,
        ) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model. Use when the action performs an operation on an Amplify DataStore model.</p>
        pub fn fields(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentProperty,
        ) -> Self {
            let mut hash_map = self.fields.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.fields = Some(hash_map);
            self
        }
        /// <p>A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model. Use when the action performs an operation on an Amplify DataStore model.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
            >,
        ) -> Self {
            self.fields = input;
            self
        }
        /// <p>A key-value pair that specifies the state property name and its initial value.</p>
        pub fn state(mut self, input: crate::model::MutationActionSetStateParameter) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>A key-value pair that specifies the state property name and its initial value.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::MutationActionSetStateParameter>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionParameters`](crate::model::ActionParameters)
        pub fn build(self) -> crate::model::ActionParameters {
            crate::model::ActionParameters {
                r#type: self.r#type,
                url: self.url,
                anchor: self.anchor,
                target: self.target,
                global: self.global,
                model: self.model,
                id: self.id,
                fields: self.fields,
                state: self.state,
            }
        }
    }
}
impl ActionParameters {
    /// Creates a new builder-style object to manufacture [`ActionParameters`](crate::model::ActionParameters)
    pub fn builder() -> crate::model::action_parameters::Builder {
        crate::model::action_parameters::Builder::default()
    }
}

/// <p>Represents the state configuration when an action modifies a property of another element within the same component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MutationActionSetStateParameter {
    /// <p>The name of the component that is being modified.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The name of the component property to apply the state configuration to.</p>
    pub property: std::option::Option<std::string::String>,
    /// <p>The state configuration to assign to the property.</p>
    pub set: std::option::Option<crate::model::ComponentProperty>,
}
impl MutationActionSetStateParameter {
    /// <p>The name of the component that is being modified.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The name of the component property to apply the state configuration to.</p>
    pub fn property(&self) -> std::option::Option<&str> {
        self.property.as_deref()
    }
    /// <p>The state configuration to assign to the property.</p>
    pub fn set(&self) -> std::option::Option<&crate::model::ComponentProperty> {
        self.set.as_ref()
    }
}
impl std::fmt::Debug for MutationActionSetStateParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MutationActionSetStateParameter");
        formatter.field("component_name", &self.component_name);
        formatter.field("property", &self.property);
        formatter.field("set", &self.set);
        formatter.finish()
    }
}
/// See [`MutationActionSetStateParameter`](crate::model::MutationActionSetStateParameter)
pub mod mutation_action_set_state_parameter {
    /// A builder for [`MutationActionSetStateParameter`](crate::model::MutationActionSetStateParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) property: std::option::Option<std::string::String>,
        pub(crate) set: std::option::Option<crate::model::ComponentProperty>,
    }
    impl Builder {
        /// <p>The name of the component that is being modified.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component that is being modified.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The name of the component property to apply the state configuration to.</p>
        pub fn property(mut self, input: impl Into<std::string::String>) -> Self {
            self.property = Some(input.into());
            self
        }
        /// <p>The name of the component property to apply the state configuration to.</p>
        pub fn set_property(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property = input;
            self
        }
        /// <p>The state configuration to assign to the property.</p>
        pub fn set(mut self, input: crate::model::ComponentProperty) -> Self {
            self.set = Some(input);
            self
        }
        /// <p>The state configuration to assign to the property.</p>
        pub fn set_set(
            mut self,
            input: std::option::Option<crate::model::ComponentProperty>,
        ) -> Self {
            self.set = input;
            self
        }
        /// Consumes the builder and constructs a [`MutationActionSetStateParameter`](crate::model::MutationActionSetStateParameter)
        pub fn build(self) -> crate::model::MutationActionSetStateParameter {
            crate::model::MutationActionSetStateParameter {
                component_name: self.component_name,
                property: self.property,
                set: self.set,
            }
        }
    }
}
impl MutationActionSetStateParameter {
    /// Creates a new builder-style object to manufacture [`MutationActionSetStateParameter`](crate::model::MutationActionSetStateParameter)
    pub fn builder() -> crate::model::mutation_action_set_state_parameter::Builder {
        crate::model::mutation_action_set_state_parameter::Builder::default()
    }
}

/// <p>Describes the configuration for all of a component's properties. Use <code>ComponentProperty</code> to specify the values to render or bind by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentProperty {
    /// <p>The value to assign to the component property.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The information to bind the component property to data at runtime.</p>
    pub binding_properties: std::option::Option<crate::model::ComponentPropertyBindingProperties>,
    /// <p>The information to bind the component property to data at runtime. Use this for collection components.</p>
    pub collection_binding_properties:
        std::option::Option<crate::model::ComponentPropertyBindingProperties>,
    /// <p>The default value to assign to the component property.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The data model to use to assign a value to the component property.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The information to bind the component property to form data.</p>
    pub bindings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::FormBindingElement>,
    >,
    /// <p>An event that occurs in your app. Use this for workflow data binding.</p>
    pub event: std::option::Option<std::string::String>,
    /// <p>An authenticated user attribute to use to assign a value to the component property.</p>
    pub user_attribute: std::option::Option<std::string::String>,
    /// <p>A list of component properties to concatenate to create the value to assign to this component property.</p>
    pub concat: std::option::Option<std::vec::Vec<crate::model::ComponentProperty>>,
    /// <p>The conditional expression to use to assign a value to the component property.</p>
    pub condition: std::option::Option<crate::model::ComponentConditionProperty>,
    /// <p>Specifies whether the user configured the property in Amplify Studio after importing it.</p>
    pub configured: std::option::Option<bool>,
    /// <p>The component type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The default value assigned to the property when the component is imported into an app.</p>
    pub imported_value: std::option::Option<std::string::String>,
    /// <p>The name of the component that is affected by an event.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The name of the component's property that is affected by an event.</p>
    pub property: std::option::Option<std::string::String>,
}
impl ComponentProperty {
    /// <p>The value to assign to the component property.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The information to bind the component property to data at runtime.</p>
    pub fn binding_properties(
        &self,
    ) -> std::option::Option<&crate::model::ComponentPropertyBindingProperties> {
        self.binding_properties.as_ref()
    }
    /// <p>The information to bind the component property to data at runtime. Use this for collection components.</p>
    pub fn collection_binding_properties(
        &self,
    ) -> std::option::Option<&crate::model::ComponentPropertyBindingProperties> {
        self.collection_binding_properties.as_ref()
    }
    /// <p>The default value to assign to the component property.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>The data model to use to assign a value to the component property.</p>
    pub fn model(&self) -> std::option::Option<&str> {
        self.model.as_deref()
    }
    /// <p>The information to bind the component property to form data.</p>
    pub fn bindings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::FormBindingElement>,
    > {
        self.bindings.as_ref()
    }
    /// <p>An event that occurs in your app. Use this for workflow data binding.</p>
    pub fn event(&self) -> std::option::Option<&str> {
        self.event.as_deref()
    }
    /// <p>An authenticated user attribute to use to assign a value to the component property.</p>
    pub fn user_attribute(&self) -> std::option::Option<&str> {
        self.user_attribute.as_deref()
    }
    /// <p>A list of component properties to concatenate to create the value to assign to this component property.</p>
    pub fn concat(&self) -> std::option::Option<&[crate::model::ComponentProperty]> {
        self.concat.as_deref()
    }
    /// <p>The conditional expression to use to assign a value to the component property.</p>
    pub fn condition(&self) -> std::option::Option<&crate::model::ComponentConditionProperty> {
        self.condition.as_ref()
    }
    /// <p>Specifies whether the user configured the property in Amplify Studio after importing it.</p>
    pub fn configured(&self) -> std::option::Option<bool> {
        self.configured
    }
    /// <p>The component type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The default value assigned to the property when the component is imported into an app.</p>
    pub fn imported_value(&self) -> std::option::Option<&str> {
        self.imported_value.as_deref()
    }
    /// <p>The name of the component that is affected by an event.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The name of the component's property that is affected by an event.</p>
    pub fn property(&self) -> std::option::Option<&str> {
        self.property.as_deref()
    }
}
impl std::fmt::Debug for ComponentProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentProperty");
        formatter.field("value", &self.value);
        formatter.field("binding_properties", &self.binding_properties);
        formatter.field(
            "collection_binding_properties",
            &self.collection_binding_properties,
        );
        formatter.field("default_value", &self.default_value);
        formatter.field("model", &self.model);
        formatter.field("bindings", &self.bindings);
        formatter.field("event", &self.event);
        formatter.field("user_attribute", &self.user_attribute);
        formatter.field("concat", &self.concat);
        formatter.field("condition", &self.condition);
        formatter.field("configured", &self.configured);
        formatter.field("r#type", &self.r#type);
        formatter.field("imported_value", &self.imported_value);
        formatter.field("component_name", &self.component_name);
        formatter.field("property", &self.property);
        formatter.finish()
    }
}
/// See [`ComponentProperty`](crate::model::ComponentProperty)
pub mod component_property {
    /// A builder for [`ComponentProperty`](crate::model::ComponentProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) binding_properties:
            std::option::Option<crate::model::ComponentPropertyBindingProperties>,
        pub(crate) collection_binding_properties:
            std::option::Option<crate::model::ComponentPropertyBindingProperties>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) bindings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::FormBindingElement>,
        >,
        pub(crate) event: std::option::Option<std::string::String>,
        pub(crate) user_attribute: std::option::Option<std::string::String>,
        pub(crate) concat: std::option::Option<std::vec::Vec<crate::model::ComponentProperty>>,
        pub(crate) condition: std::option::Option<crate::model::ComponentConditionProperty>,
        pub(crate) configured: std::option::Option<bool>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) imported_value: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) property: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value to assign to the component property.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value to assign to the component property.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The information to bind the component property to data at runtime.</p>
        pub fn binding_properties(
            mut self,
            input: crate::model::ComponentPropertyBindingProperties,
        ) -> Self {
            self.binding_properties = Some(input);
            self
        }
        /// <p>The information to bind the component property to data at runtime.</p>
        pub fn set_binding_properties(
            mut self,
            input: std::option::Option<crate::model::ComponentPropertyBindingProperties>,
        ) -> Self {
            self.binding_properties = input;
            self
        }
        /// <p>The information to bind the component property to data at runtime. Use this for collection components.</p>
        pub fn collection_binding_properties(
            mut self,
            input: crate::model::ComponentPropertyBindingProperties,
        ) -> Self {
            self.collection_binding_properties = Some(input);
            self
        }
        /// <p>The information to bind the component property to data at runtime. Use this for collection components.</p>
        pub fn set_collection_binding_properties(
            mut self,
            input: std::option::Option<crate::model::ComponentPropertyBindingProperties>,
        ) -> Self {
            self.collection_binding_properties = input;
            self
        }
        /// <p>The default value to assign to the component property.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value to assign to the component property.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The data model to use to assign a value to the component property.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The data model to use to assign a value to the component property.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// Adds a key-value pair to `bindings`.
        ///
        /// To override the contents of this collection use [`set_bindings`](Self::set_bindings).
        ///
        /// <p>The information to bind the component property to form data.</p>
        pub fn bindings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::FormBindingElement,
        ) -> Self {
            let mut hash_map = self.bindings.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.bindings = Some(hash_map);
            self
        }
        /// <p>The information to bind the component property to form data.</p>
        pub fn set_bindings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FormBindingElement>,
            >,
        ) -> Self {
            self.bindings = input;
            self
        }
        /// <p>An event that occurs in your app. Use this for workflow data binding.</p>
        pub fn event(mut self, input: impl Into<std::string::String>) -> Self {
            self.event = Some(input.into());
            self
        }
        /// <p>An event that occurs in your app. Use this for workflow data binding.</p>
        pub fn set_event(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event = input;
            self
        }
        /// <p>An authenticated user attribute to use to assign a value to the component property.</p>
        pub fn user_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_attribute = Some(input.into());
            self
        }
        /// <p>An authenticated user attribute to use to assign a value to the component property.</p>
        pub fn set_user_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_attribute = input;
            self
        }
        /// Appends an item to `concat`.
        ///
        /// To override the contents of this collection use [`set_concat`](Self::set_concat).
        ///
        /// <p>A list of component properties to concatenate to create the value to assign to this component property.</p>
        pub fn concat(mut self, input: crate::model::ComponentProperty) -> Self {
            let mut v = self.concat.unwrap_or_default();
            v.push(input);
            self.concat = Some(v);
            self
        }
        /// <p>A list of component properties to concatenate to create the value to assign to this component property.</p>
        pub fn set_concat(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentProperty>>,
        ) -> Self {
            self.concat = input;
            self
        }
        /// <p>The conditional expression to use to assign a value to the component property.</p>
        pub fn condition(mut self, input: crate::model::ComponentConditionProperty) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>The conditional expression to use to assign a value to the component property.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::ComponentConditionProperty>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>Specifies whether the user configured the property in Amplify Studio after importing it.</p>
        pub fn configured(mut self, input: bool) -> Self {
            self.configured = Some(input);
            self
        }
        /// <p>Specifies whether the user configured the property in Amplify Studio after importing it.</p>
        pub fn set_configured(mut self, input: std::option::Option<bool>) -> Self {
            self.configured = input;
            self
        }
        /// <p>The component type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The component type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The default value assigned to the property when the component is imported into an app.</p>
        pub fn imported_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.imported_value = Some(input.into());
            self
        }
        /// <p>The default value assigned to the property when the component is imported into an app.</p>
        pub fn set_imported_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.imported_value = input;
            self
        }
        /// <p>The name of the component that is affected by an event.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component that is affected by an event.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The name of the component's property that is affected by an event.</p>
        pub fn property(mut self, input: impl Into<std::string::String>) -> Self {
            self.property = Some(input.into());
            self
        }
        /// <p>The name of the component's property that is affected by an event.</p>
        pub fn set_property(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentProperty`](crate::model::ComponentProperty)
        pub fn build(self) -> crate::model::ComponentProperty {
            crate::model::ComponentProperty {
                value: self.value,
                binding_properties: self.binding_properties,
                collection_binding_properties: self.collection_binding_properties,
                default_value: self.default_value,
                model: self.model,
                bindings: self.bindings,
                event: self.event,
                user_attribute: self.user_attribute,
                concat: self.concat,
                condition: self.condition,
                configured: self.configured,
                r#type: self.r#type,
                imported_value: self.imported_value,
                component_name: self.component_name,
                property: self.property,
            }
        }
    }
}
impl ComponentProperty {
    /// Creates a new builder-style object to manufacture [`ComponentProperty`](crate::model::ComponentProperty)
    pub fn builder() -> crate::model::component_property::Builder {
        crate::model::component_property::Builder::default()
    }
}

/// <p>Represents a conditional expression to set a component property. Use <code>ComponentConditionProperty</code> to set a property to different values conditionally, based on the value of another property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentConditionProperty {
    /// <p>The name of the conditional property.</p>
    pub property: std::option::Option<std::string::String>,
    /// <p>The name of a field. Specify this when the property is a data model.</p>
    pub field: std::option::Option<std::string::String>,
    /// <p>The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.</p>
    pub operator: std::option::Option<std::string::String>,
    /// <p>The value of the property to evaluate.</p>
    pub operand: std::option::Option<std::string::String>,
    /// <p>The value to assign to the property if the condition is met.</p>
    pub then: std::option::Option<std::boxed::Box<crate::model::ComponentProperty>>,
    /// <p>The value to assign to the property if the condition is not met.</p>
    pub r#else: std::option::Option<std::boxed::Box<crate::model::ComponentProperty>>,
    /// <p>The type of the property to evaluate.</p>
    pub operand_type: std::option::Option<std::string::String>,
}
impl ComponentConditionProperty {
    /// <p>The name of the conditional property.</p>
    pub fn property(&self) -> std::option::Option<&str> {
        self.property.as_deref()
    }
    /// <p>The name of a field. Specify this when the property is a data model.</p>
    pub fn field(&self) -> std::option::Option<&str> {
        self.field.as_deref()
    }
    /// <p>The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.</p>
    pub fn operator(&self) -> std::option::Option<&str> {
        self.operator.as_deref()
    }
    /// <p>The value of the property to evaluate.</p>
    pub fn operand(&self) -> std::option::Option<&str> {
        self.operand.as_deref()
    }
    /// <p>The value to assign to the property if the condition is met.</p>
    pub fn then(&self) -> std::option::Option<&crate::model::ComponentProperty> {
        self.then.as_deref()
    }
    /// <p>The value to assign to the property if the condition is not met.</p>
    pub fn r#else(&self) -> std::option::Option<&crate::model::ComponentProperty> {
        self.r#else.as_deref()
    }
    /// <p>The type of the property to evaluate.</p>
    pub fn operand_type(&self) -> std::option::Option<&str> {
        self.operand_type.as_deref()
    }
}
impl std::fmt::Debug for ComponentConditionProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentConditionProperty");
        formatter.field("property", &self.property);
        formatter.field("field", &self.field);
        formatter.field("operator", &self.operator);
        formatter.field("operand", &self.operand);
        formatter.field("then", &self.then);
        formatter.field("r#else", &self.r#else);
        formatter.field("operand_type", &self.operand_type);
        formatter.finish()
    }
}
/// See [`ComponentConditionProperty`](crate::model::ComponentConditionProperty)
pub mod component_condition_property {
    /// A builder for [`ComponentConditionProperty`](crate::model::ComponentConditionProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property: std::option::Option<std::string::String>,
        pub(crate) field: std::option::Option<std::string::String>,
        pub(crate) operator: std::option::Option<std::string::String>,
        pub(crate) operand: std::option::Option<std::string::String>,
        pub(crate) then: std::option::Option<std::boxed::Box<crate::model::ComponentProperty>>,
        pub(crate) r#else: std::option::Option<std::boxed::Box<crate::model::ComponentProperty>>,
        pub(crate) operand_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the conditional property.</p>
        pub fn property(mut self, input: impl Into<std::string::String>) -> Self {
            self.property = Some(input.into());
            self
        }
        /// <p>The name of the conditional property.</p>
        pub fn set_property(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property = input;
            self
        }
        /// <p>The name of a field. Specify this when the property is a data model.</p>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p>The name of a field. Specify this when the property is a data model.</p>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// <p>The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.</p>
        pub fn operator(mut self, input: impl Into<std::string::String>) -> Self {
            self.operator = Some(input.into());
            self
        }
        /// <p>The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.</p>
        pub fn set_operator(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operator = input;
            self
        }
        /// <p>The value of the property to evaluate.</p>
        pub fn operand(mut self, input: impl Into<std::string::String>) -> Self {
            self.operand = Some(input.into());
            self
        }
        /// <p>The value of the property to evaluate.</p>
        pub fn set_operand(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operand = input;
            self
        }
        /// <p>The value to assign to the property if the condition is met.</p>
        pub fn then(
            mut self,
            input: impl Into<std::boxed::Box<crate::model::ComponentProperty>>,
        ) -> Self {
            self.then = Some(input.into());
            self
        }
        /// <p>The value to assign to the property if the condition is met.</p>
        pub fn set_then(
            mut self,
            input: std::option::Option<std::boxed::Box<crate::model::ComponentProperty>>,
        ) -> Self {
            self.then = input;
            self
        }
        /// <p>The value to assign to the property if the condition is not met.</p>
        pub fn r#else(
            mut self,
            input: impl Into<std::boxed::Box<crate::model::ComponentProperty>>,
        ) -> Self {
            self.r#else = Some(input.into());
            self
        }
        /// <p>The value to assign to the property if the condition is not met.</p>
        pub fn set_else(
            mut self,
            input: std::option::Option<std::boxed::Box<crate::model::ComponentProperty>>,
        ) -> Self {
            self.r#else = input;
            self
        }
        /// <p>The type of the property to evaluate.</p>
        pub fn operand_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.operand_type = Some(input.into());
            self
        }
        /// <p>The type of the property to evaluate.</p>
        pub fn set_operand_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operand_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentConditionProperty`](crate::model::ComponentConditionProperty)
        pub fn build(self) -> crate::model::ComponentConditionProperty {
            crate::model::ComponentConditionProperty {
                property: self.property,
                field: self.field,
                operator: self.operator,
                operand: self.operand,
                then: self.then,
                r#else: self.r#else,
                operand_type: self.operand_type,
            }
        }
    }
}
impl ComponentConditionProperty {
    /// Creates a new builder-style object to manufacture [`ComponentConditionProperty`](crate::model::ComponentConditionProperty)
    pub fn builder() -> crate::model::component_condition_property::Builder {
        crate::model::component_condition_property::Builder::default()
    }
}

/// <p>Describes how to bind a component property to form data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FormBindingElement {
    /// <p>The name of the component to retrieve a value from.</p>
    pub element: std::option::Option<std::string::String>,
    /// <p>The property to retrieve a value from.</p>
    pub property: std::option::Option<std::string::String>,
}
impl FormBindingElement {
    /// <p>The name of the component to retrieve a value from.</p>
    pub fn element(&self) -> std::option::Option<&str> {
        self.element.as_deref()
    }
    /// <p>The property to retrieve a value from.</p>
    pub fn property(&self) -> std::option::Option<&str> {
        self.property.as_deref()
    }
}
impl std::fmt::Debug for FormBindingElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FormBindingElement");
        formatter.field("element", &self.element);
        formatter.field("property", &self.property);
        formatter.finish()
    }
}
/// See [`FormBindingElement`](crate::model::FormBindingElement)
pub mod form_binding_element {
    /// A builder for [`FormBindingElement`](crate::model::FormBindingElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) element: std::option::Option<std::string::String>,
        pub(crate) property: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the component to retrieve a value from.</p>
        pub fn element(mut self, input: impl Into<std::string::String>) -> Self {
            self.element = Some(input.into());
            self
        }
        /// <p>The name of the component to retrieve a value from.</p>
        pub fn set_element(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.element = input;
            self
        }
        /// <p>The property to retrieve a value from.</p>
        pub fn property(mut self, input: impl Into<std::string::String>) -> Self {
            self.property = Some(input.into());
            self
        }
        /// <p>The property to retrieve a value from.</p>
        pub fn set_property(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property = input;
            self
        }
        /// Consumes the builder and constructs a [`FormBindingElement`](crate::model::FormBindingElement)
        pub fn build(self) -> crate::model::FormBindingElement {
            crate::model::FormBindingElement {
                element: self.element,
                property: self.property,
            }
        }
    }
}
impl FormBindingElement {
    /// Creates a new builder-style object to manufacture [`FormBindingElement`](crate::model::FormBindingElement)
    pub fn builder() -> crate::model::form_binding_element::Builder {
        crate::model::form_binding_element::Builder::default()
    }
}

/// <p>Associates a component property to a binding property. This enables exposed properties on the top level component to propagate data to the component's property values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentPropertyBindingProperties {
    /// <p>The component property to bind to the data field.</p>
    pub property: std::option::Option<std::string::String>,
    /// <p>The data field to bind the property to.</p>
    pub field: std::option::Option<std::string::String>,
}
impl ComponentPropertyBindingProperties {
    /// <p>The component property to bind to the data field.</p>
    pub fn property(&self) -> std::option::Option<&str> {
        self.property.as_deref()
    }
    /// <p>The data field to bind the property to.</p>
    pub fn field(&self) -> std::option::Option<&str> {
        self.field.as_deref()
    }
}
impl std::fmt::Debug for ComponentPropertyBindingProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentPropertyBindingProperties");
        formatter.field("property", &self.property);
        formatter.field("field", &self.field);
        formatter.finish()
    }
}
/// See [`ComponentPropertyBindingProperties`](crate::model::ComponentPropertyBindingProperties)
pub mod component_property_binding_properties {
    /// A builder for [`ComponentPropertyBindingProperties`](crate::model::ComponentPropertyBindingProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property: std::option::Option<std::string::String>,
        pub(crate) field: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The component property to bind to the data field.</p>
        pub fn property(mut self, input: impl Into<std::string::String>) -> Self {
            self.property = Some(input.into());
            self
        }
        /// <p>The component property to bind to the data field.</p>
        pub fn set_property(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property = input;
            self
        }
        /// <p>The data field to bind the property to.</p>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p>The data field to bind the property to.</p>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentPropertyBindingProperties`](crate::model::ComponentPropertyBindingProperties)
        pub fn build(self) -> crate::model::ComponentPropertyBindingProperties {
            crate::model::ComponentPropertyBindingProperties {
                property: self.property,
                field: self.field,
            }
        }
    }
}
impl ComponentPropertyBindingProperties {
    /// Creates a new builder-style object to manufacture [`ComponentPropertyBindingProperties`](crate::model::ComponentPropertyBindingProperties)
    pub fn builder() -> crate::model::component_property_binding_properties::Builder {
        crate::model::component_property_binding_properties::Builder::default()
    }
}

/// <p>Describes the configuration for binding a component's properties to data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentDataConfiguration {
    /// <p>The name of the data model to use to bind data to a component.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>Describes how to sort the component's properties.</p>
    pub sort: std::option::Option<std::vec::Vec<crate::model::SortProperty>>,
    /// <p>Represents the conditional logic to use when binding data to a component. Use this property to retrieve only a subset of the data in a collection.</p>
    pub predicate: std::option::Option<crate::model::Predicate>,
    /// <p>A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data, rather than data retrieved from a query.</p>
    pub identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ComponentDataConfiguration {
    /// <p>The name of the data model to use to bind data to a component.</p>
    pub fn model(&self) -> std::option::Option<&str> {
        self.model.as_deref()
    }
    /// <p>Describes how to sort the component's properties.</p>
    pub fn sort(&self) -> std::option::Option<&[crate::model::SortProperty]> {
        self.sort.as_deref()
    }
    /// <p>Represents the conditional logic to use when binding data to a component. Use this property to retrieve only a subset of the data in a collection.</p>
    pub fn predicate(&self) -> std::option::Option<&crate::model::Predicate> {
        self.predicate.as_ref()
    }
    /// <p>A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data, rather than data retrieved from a query.</p>
    pub fn identifiers(&self) -> std::option::Option<&[std::string::String]> {
        self.identifiers.as_deref()
    }
}
impl std::fmt::Debug for ComponentDataConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentDataConfiguration");
        formatter.field("model", &self.model);
        formatter.field("sort", &self.sort);
        formatter.field("predicate", &self.predicate);
        formatter.field("identifiers", &self.identifiers);
        formatter.finish()
    }
}
/// See [`ComponentDataConfiguration`](crate::model::ComponentDataConfiguration)
pub mod component_data_configuration {
    /// A builder for [`ComponentDataConfiguration`](crate::model::ComponentDataConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) sort: std::option::Option<std::vec::Vec<crate::model::SortProperty>>,
        pub(crate) predicate: std::option::Option<crate::model::Predicate>,
        pub(crate) identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the data model to use to bind data to a component.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The name of the data model to use to bind data to a component.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// Appends an item to `sort`.
        ///
        /// To override the contents of this collection use [`set_sort`](Self::set_sort).
        ///
        /// <p>Describes how to sort the component's properties.</p>
        pub fn sort(mut self, input: crate::model::SortProperty) -> Self {
            let mut v = self.sort.unwrap_or_default();
            v.push(input);
            self.sort = Some(v);
            self
        }
        /// <p>Describes how to sort the component's properties.</p>
        pub fn set_sort(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortProperty>>,
        ) -> Self {
            self.sort = input;
            self
        }
        /// <p>Represents the conditional logic to use when binding data to a component. Use this property to retrieve only a subset of the data in a collection.</p>
        pub fn predicate(mut self, input: crate::model::Predicate) -> Self {
            self.predicate = Some(input);
            self
        }
        /// <p>Represents the conditional logic to use when binding data to a component. Use this property to retrieve only a subset of the data in a collection.</p>
        pub fn set_predicate(
            mut self,
            input: std::option::Option<crate::model::Predicate>,
        ) -> Self {
            self.predicate = input;
            self
        }
        /// Appends an item to `identifiers`.
        ///
        /// To override the contents of this collection use [`set_identifiers`](Self::set_identifiers).
        ///
        /// <p>A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data, rather than data retrieved from a query.</p>
        pub fn identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identifiers.unwrap_or_default();
            v.push(input.into());
            self.identifiers = Some(v);
            self
        }
        /// <p>A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data, rather than data retrieved from a query.</p>
        pub fn set_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentDataConfiguration`](crate::model::ComponentDataConfiguration)
        pub fn build(self) -> crate::model::ComponentDataConfiguration {
            crate::model::ComponentDataConfiguration {
                model: self.model,
                sort: self.sort,
                predicate: self.predicate,
                identifiers: self.identifiers,
            }
        }
    }
}
impl ComponentDataConfiguration {
    /// Creates a new builder-style object to manufacture [`ComponentDataConfiguration`](crate::model::ComponentDataConfiguration)
    pub fn builder() -> crate::model::component_data_configuration::Builder {
        crate::model::component_data_configuration::Builder::default()
    }
}

/// <p>Stores information for generating Amplify DataStore queries. Use a <code>Predicate</code> to retrieve a subset of the data in a collection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Predicate {
    /// <p>A list of predicates to combine logically.</p>
    pub or: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
    /// <p>A list of predicates to combine logically.</p>
    pub and: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
    /// <p>The field to query.</p>
    pub field: std::option::Option<std::string::String>,
    /// <p>The operator to use to perform the evaluation.</p>
    pub operator: std::option::Option<std::string::String>,
    /// <p>The value to use when performing the evaluation.</p>
    pub operand: std::option::Option<std::string::String>,
}
impl Predicate {
    /// <p>A list of predicates to combine logically.</p>
    pub fn or(&self) -> std::option::Option<&[crate::model::Predicate]> {
        self.or.as_deref()
    }
    /// <p>A list of predicates to combine logically.</p>
    pub fn and(&self) -> std::option::Option<&[crate::model::Predicate]> {
        self.and.as_deref()
    }
    /// <p>The field to query.</p>
    pub fn field(&self) -> std::option::Option<&str> {
        self.field.as_deref()
    }
    /// <p>The operator to use to perform the evaluation.</p>
    pub fn operator(&self) -> std::option::Option<&str> {
        self.operator.as_deref()
    }
    /// <p>The value to use when performing the evaluation.</p>
    pub fn operand(&self) -> std::option::Option<&str> {
        self.operand.as_deref()
    }
}
impl std::fmt::Debug for Predicate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Predicate");
        formatter.field("or", &self.or);
        formatter.field("and", &self.and);
        formatter.field("field", &self.field);
        formatter.field("operator", &self.operator);
        formatter.field("operand", &self.operand);
        formatter.finish()
    }
}
/// See [`Predicate`](crate::model::Predicate)
pub mod predicate {
    /// A builder for [`Predicate`](crate::model::Predicate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) or: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
        pub(crate) and: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
        pub(crate) field: std::option::Option<std::string::String>,
        pub(crate) operator: std::option::Option<std::string::String>,
        pub(crate) operand: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `or`.
        ///
        /// To override the contents of this collection use [`set_or`](Self::set_or).
        ///
        /// <p>A list of predicates to combine logically.</p>
        pub fn or(mut self, input: crate::model::Predicate) -> Self {
            let mut v = self.or.unwrap_or_default();
            v.push(input);
            self.or = Some(v);
            self
        }
        /// <p>A list of predicates to combine logically.</p>
        pub fn set_or(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
        ) -> Self {
            self.or = input;
            self
        }
        /// Appends an item to `and`.
        ///
        /// To override the contents of this collection use [`set_and`](Self::set_and).
        ///
        /// <p>A list of predicates to combine logically.</p>
        pub fn and(mut self, input: crate::model::Predicate) -> Self {
            let mut v = self.and.unwrap_or_default();
            v.push(input);
            self.and = Some(v);
            self
        }
        /// <p>A list of predicates to combine logically.</p>
        pub fn set_and(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
        ) -> Self {
            self.and = input;
            self
        }
        /// <p>The field to query.</p>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p>The field to query.</p>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// <p>The operator to use to perform the evaluation.</p>
        pub fn operator(mut self, input: impl Into<std::string::String>) -> Self {
            self.operator = Some(input.into());
            self
        }
        /// <p>The operator to use to perform the evaluation.</p>
        pub fn set_operator(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operator = input;
            self
        }
        /// <p>The value to use when performing the evaluation.</p>
        pub fn operand(mut self, input: impl Into<std::string::String>) -> Self {
            self.operand = Some(input.into());
            self
        }
        /// <p>The value to use when performing the evaluation.</p>
        pub fn set_operand(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operand = input;
            self
        }
        /// Consumes the builder and constructs a [`Predicate`](crate::model::Predicate)
        pub fn build(self) -> crate::model::Predicate {
            crate::model::Predicate {
                or: self.or,
                and: self.and,
                field: self.field,
                operator: self.operator,
                operand: self.operand,
            }
        }
    }
}
impl Predicate {
    /// Creates a new builder-style object to manufacture [`Predicate`](crate::model::Predicate)
    pub fn builder() -> crate::model::predicate::Builder {
        crate::model::predicate::Builder::default()
    }
}

/// <p>Describes how to sort the data that you bind to a component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SortProperty {
    /// <p>The field to perform the sort on.</p>
    pub field: std::option::Option<std::string::String>,
    /// <p>The direction of the sort, either ascending or descending.</p>
    pub direction: std::option::Option<crate::model::SortDirection>,
}
impl SortProperty {
    /// <p>The field to perform the sort on.</p>
    pub fn field(&self) -> std::option::Option<&str> {
        self.field.as_deref()
    }
    /// <p>The direction of the sort, either ascending or descending.</p>
    pub fn direction(&self) -> std::option::Option<&crate::model::SortDirection> {
        self.direction.as_ref()
    }
}
impl std::fmt::Debug for SortProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SortProperty");
        formatter.field("field", &self.field);
        formatter.field("direction", &self.direction);
        formatter.finish()
    }
}
/// See [`SortProperty`](crate::model::SortProperty)
pub mod sort_property {
    /// A builder for [`SortProperty`](crate::model::SortProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field: std::option::Option<std::string::String>,
        pub(crate) direction: std::option::Option<crate::model::SortDirection>,
    }
    impl Builder {
        /// <p>The field to perform the sort on.</p>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p>The field to perform the sort on.</p>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// <p>The direction of the sort, either ascending or descending.</p>
        pub fn direction(mut self, input: crate::model::SortDirection) -> Self {
            self.direction = Some(input);
            self
        }
        /// <p>The direction of the sort, either ascending or descending.</p>
        pub fn set_direction(
            mut self,
            input: std::option::Option<crate::model::SortDirection>,
        ) -> Self {
            self.direction = input;
            self
        }
        /// Consumes the builder and constructs a [`SortProperty`](crate::model::SortProperty)
        pub fn build(self) -> crate::model::SortProperty {
            crate::model::SortProperty {
                field: self.field,
                direction: self.direction,
            }
        }
    }
}
impl SortProperty {
    /// Creates a new builder-style object to manufacture [`SortProperty`](crate::model::SortProperty)
    pub fn builder() -> crate::model::sort_property::Builder {
        crate::model::sort_property::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct SortDirection(String);
impl SortDirection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl<T> std::convert::From<T> for SortDirection
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        SortDirection(s.as_ref().to_owned())
    }
}

/// <p>Represents the data binding configuration for a component at runtime. You can use <code>ComponentBindingPropertiesValue</code> to add exposed properties to a component to allow different values to be entered when a component is reused in different places in an app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentBindingPropertiesValue {
    /// <p>The property type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>Describes the properties to customize with data at runtime.</p>
    pub binding_properties:
        std::option::Option<crate::model::ComponentBindingPropertiesValueProperties>,
    /// <p>The default value of the property.</p>
    pub default_value: std::option::Option<std::string::String>,
}
impl ComponentBindingPropertiesValue {
    /// <p>The property type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>Describes the properties to customize with data at runtime.</p>
    pub fn binding_properties(
        &self,
    ) -> std::option::Option<&crate::model::ComponentBindingPropertiesValueProperties> {
        self.binding_properties.as_ref()
    }
    /// <p>The default value of the property.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
}
impl std::fmt::Debug for ComponentBindingPropertiesValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentBindingPropertiesValue");
        formatter.field("r#type", &self.r#type);
        formatter.field("binding_properties", &self.binding_properties);
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`ComponentBindingPropertiesValue`](crate::model::ComponentBindingPropertiesValue)
pub mod component_binding_properties_value {
    /// A builder for [`ComponentBindingPropertiesValue`](crate::model::ComponentBindingPropertiesValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) binding_properties:
            std::option::Option<crate::model::ComponentBindingPropertiesValueProperties>,
        pub(crate) default_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The property type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The property type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Describes the properties to customize with data at runtime.</p>
        pub fn binding_properties(
            mut self,
            input: crate::model::ComponentBindingPropertiesValueProperties,
        ) -> Self {
            self.binding_properties = Some(input);
            self
        }
        /// <p>Describes the properties to customize with data at runtime.</p>
        pub fn set_binding_properties(
            mut self,
            input: std::option::Option<crate::model::ComponentBindingPropertiesValueProperties>,
        ) -> Self {
            self.binding_properties = input;
            self
        }
        /// <p>The default value of the property.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value of the property.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentBindingPropertiesValue`](crate::model::ComponentBindingPropertiesValue)
        pub fn build(self) -> crate::model::ComponentBindingPropertiesValue {
            crate::model::ComponentBindingPropertiesValue {
                r#type: self.r#type,
                binding_properties: self.binding_properties,
                default_value: self.default_value,
            }
        }
    }
}
impl ComponentBindingPropertiesValue {
    /// Creates a new builder-style object to manufacture [`ComponentBindingPropertiesValue`](crate::model::ComponentBindingPropertiesValue)
    pub fn builder() -> crate::model::component_binding_properties_value::Builder {
        crate::model::component_binding_properties_value::Builder::default()
    }
}

/// <p>Represents the data binding configuration for a specific property using data stored in Amazon Web Services. For Amazon Web Services connected properties, you can bind a property to data stored in an Amazon S3 bucket, an Amplify DataStore model or an authenticated user attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentBindingPropertiesValueProperties {
    /// <p>An Amplify DataStore model.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The field to bind the data to.</p>
    pub field: std::option::Option<std::string::String>,
    /// <p>A list of predicates for binding a component's properties to data.</p>
    pub predicates: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
    /// <p>An authenticated user attribute.</p>
    pub user_attribute: std::option::Option<std::string::String>,
    /// <p>An Amazon S3 bucket.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The storage key for an Amazon S3 bucket.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The default value to assign to the property.</p>
    pub default_value: std::option::Option<std::string::String>,
}
impl ComponentBindingPropertiesValueProperties {
    /// <p>An Amplify DataStore model.</p>
    pub fn model(&self) -> std::option::Option<&str> {
        self.model.as_deref()
    }
    /// <p>The field to bind the data to.</p>
    pub fn field(&self) -> std::option::Option<&str> {
        self.field.as_deref()
    }
    /// <p>A list of predicates for binding a component's properties to data.</p>
    pub fn predicates(&self) -> std::option::Option<&[crate::model::Predicate]> {
        self.predicates.as_deref()
    }
    /// <p>An authenticated user attribute.</p>
    pub fn user_attribute(&self) -> std::option::Option<&str> {
        self.user_attribute.as_deref()
    }
    /// <p>An Amazon S3 bucket.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The storage key for an Amazon S3 bucket.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The default value to assign to the property.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
}
impl std::fmt::Debug for ComponentBindingPropertiesValueProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentBindingPropertiesValueProperties");
        formatter.field("model", &self.model);
        formatter.field("field", &self.field);
        formatter.field("predicates", &self.predicates);
        formatter.field("user_attribute", &self.user_attribute);
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`ComponentBindingPropertiesValueProperties`](crate::model::ComponentBindingPropertiesValueProperties)
pub mod component_binding_properties_value_properties {
    /// A builder for [`ComponentBindingPropertiesValueProperties`](crate::model::ComponentBindingPropertiesValueProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) field: std::option::Option<std::string::String>,
        pub(crate) predicates: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
        pub(crate) user_attribute: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amplify DataStore model.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>An Amplify DataStore model.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// <p>The field to bind the data to.</p>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p>The field to bind the data to.</p>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// Appends an item to `predicates`.
        ///
        /// To override the contents of this collection use [`set_predicates`](Self::set_predicates).
        ///
        /// <p>A list of predicates for binding a component's properties to data.</p>
        pub fn predicates(mut self, input: crate::model::Predicate) -> Self {
            let mut v = self.predicates.unwrap_or_default();
            v.push(input);
            self.predicates = Some(v);
            self
        }
        /// <p>A list of predicates for binding a component's properties to data.</p>
        pub fn set_predicates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
        ) -> Self {
            self.predicates = input;
            self
        }
        /// <p>An authenticated user attribute.</p>
        pub fn user_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_attribute = Some(input.into());
            self
        }
        /// <p>An authenticated user attribute.</p>
        pub fn set_user_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_attribute = input;
            self
        }
        /// <p>An Amazon S3 bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>An Amazon S3 bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The storage key for an Amazon S3 bucket.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The storage key for an Amazon S3 bucket.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The default value to assign to the property.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value to assign to the property.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentBindingPropertiesValueProperties`](crate::model::ComponentBindingPropertiesValueProperties)
        pub fn build(self) -> crate::model::ComponentBindingPropertiesValueProperties {
            crate::model::ComponentBindingPropertiesValueProperties {
                model: self.model,
                field: self.field,
                predicates: self.predicates,
                user_attribute: self.user_attribute,
                bucket: self.bucket,
                key: self.key,
                default_value: self.default_value,
            }
        }
    }
}
impl ComponentBindingPropertiesValueProperties {
    /// Creates a new builder-style object to manufacture [`ComponentBindingPropertiesValueProperties`](crate::model::ComponentBindingPropertiesValueProperties)
    pub fn builder() -> crate::model::component_binding_properties_value_properties::Builder {
        crate::model::component_binding_properties_value_properties::Builder::default()
    }
}

/// <p>Describes the style configuration of a unique variation of a main component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentVariant {
    /// <p>The combination of variants that comprise this variant. You can't specify <code>tags</code> as a valid property for <code>variantValues</code>.</p>
    pub variant_values:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The properties of the component variant that can be overriden when customizing an instance of the component. You can't specify <code>tags</code> as a valid property for <code>overrides</code>.</p>
    pub overrides: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
}
impl ComponentVariant {
    /// <p>The combination of variants that comprise this variant. You can't specify <code>tags</code> as a valid property for <code>variantValues</code>.</p>
    pub fn variant_values(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.variant_values.as_ref()
    }
    /// <p>The properties of the component variant that can be overriden when customizing an instance of the component. You can't specify <code>tags</code> as a valid property for <code>overrides</code>.</p>
    pub fn overrides(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.overrides.as_ref()
    }
}
impl std::fmt::Debug for ComponentVariant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentVariant");
        formatter.field("variant_values", &self.variant_values);
        formatter.field("overrides", &self.overrides);
        formatter.finish()
    }
}
/// See [`ComponentVariant`](crate::model::ComponentVariant)
pub mod component_variant {
    /// A builder for [`ComponentVariant`](crate::model::ComponentVariant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variant_values: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) overrides: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `variant_values`.
        ///
        /// To override the contents of this collection use [`set_variant_values`](Self::set_variant_values).
        ///
        /// <p>The combination of variants that comprise this variant. You can't specify <code>tags</code> as a valid property for <code>variantValues</code>.</p>
        pub fn variant_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.variant_values.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.variant_values = Some(hash_map);
            self
        }
        /// <p>The combination of variants that comprise this variant. You can't specify <code>tags</code> as a valid property for <code>variantValues</code>.</p>
        pub fn set_variant_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.variant_values = input;
            self
        }
        /// Adds a key-value pair to `overrides`.
        ///
        /// To override the contents of this collection use [`set_overrides`](Self::set_overrides).
        ///
        /// <p>The properties of the component variant that can be overriden when customizing an instance of the component. You can't specify <code>tags</code> as a valid property for <code>overrides</code>.</p>
        pub fn overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut hash_map = self.overrides.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.overrides = Some(hash_map);
            self
        }
        /// <p>The properties of the component variant that can be overriden when customizing an instance of the component. You can't specify <code>tags</code> as a valid property for <code>overrides</code>.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentVariant`](crate::model::ComponentVariant)
        pub fn build(self) -> crate::model::ComponentVariant {
            crate::model::ComponentVariant {
                variant_values: self.variant_values,
                overrides: self.overrides,
            }
        }
    }
}
impl ComponentVariant {
    /// Creates a new builder-style object to manufacture [`ComponentVariant`](crate::model::ComponentVariant)
    pub fn builder() -> crate::model::component_variant::Builder {
        crate::model::component_variant::Builder::default()
    }
}

/// <p>A nested UI configuration within a parent <code>Component</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentChild {
    /// <p>The type of the child component. </p>
    pub component_type: std::option::Option<std::string::String>,
    /// <p>The name of the child component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Describes the properties of the child component. You can't specify <code>tags</code> as a valid property for <code>properties</code>.</p>
    pub properties: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    >,
    /// <p>The list of <code>ComponentChild</code> instances for this component.</p>
    pub children: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
    /// <p>Describes the events that can be raised on the child component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
    pub events: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
    >,
    /// <p>The unique ID of the child component in its original source system, such as Figma.</p>
    pub source_id: std::option::Option<std::string::String>,
}
impl ComponentChild {
    /// <p>The type of the child component. </p>
    pub fn component_type(&self) -> std::option::Option<&str> {
        self.component_type.as_deref()
    }
    /// <p>The name of the child component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Describes the properties of the child component. You can't specify <code>tags</code> as a valid property for <code>properties</code>.</p>
    pub fn properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    > {
        self.properties.as_ref()
    }
    /// <p>The list of <code>ComponentChild</code> instances for this component.</p>
    pub fn children(&self) -> std::option::Option<&[crate::model::ComponentChild]> {
        self.children.as_deref()
    }
    /// <p>Describes the events that can be raised on the child component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
    pub fn events(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
    > {
        self.events.as_ref()
    }
    /// <p>The unique ID of the child component in its original source system, such as Figma.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
}
impl std::fmt::Debug for ComponentChild {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentChild");
        formatter.field("component_type", &self.component_type);
        formatter.field("name", &self.name);
        formatter.field("properties", &self.properties);
        formatter.field("children", &self.children);
        formatter.field("events", &self.events);
        formatter.field("source_id", &self.source_id);
        formatter.finish()
    }
}
/// See [`ComponentChild`](crate::model::ComponentChild)
pub mod component_child {
    /// A builder for [`ComponentChild`](crate::model::ComponentChild)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_type: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
        >,
        pub(crate) children: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
        pub(crate) events: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
        >,
        pub(crate) source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the child component. </p>
        pub fn component_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type = Some(input.into());
            self
        }
        /// <p>The type of the child component. </p>
        pub fn set_component_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type = input;
            self
        }
        /// <p>The name of the child component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the child component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>Describes the properties of the child component. You can't specify <code>tags</code> as a valid property for <code>properties</code>.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentProperty,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.properties = Some(hash_map);
            self
        }
        /// <p>Describes the properties of the child component. You can't specify <code>tags</code> as a valid property for <code>properties</code>.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Appends an item to `children`.
        ///
        /// To override the contents of this collection use [`set_children`](Self::set_children).
        ///
        /// <p>The list of <code>ComponentChild</code> instances for this component.</p>
        pub fn children(mut self, input: crate::model::ComponentChild) -> Self {
            let mut v = self.children.unwrap_or_default();
            v.push(input);
            self.children = Some(v);
            self
        }
        /// <p>The list of <code>ComponentChild</code> instances for this component.</p>
        pub fn set_children(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
        ) -> Self {
            self.children = input;
            self
        }
        /// Adds a key-value pair to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>Describes the events that can be raised on the child component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
        pub fn events(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentEvent,
        ) -> Self {
            let mut hash_map = self.events.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.events = Some(hash_map);
            self
        }
        /// <p>Describes the events that can be raised on the child component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
            >,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>The unique ID of the child component in its original source system, such as Figma.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the child component in its original source system, such as Figma.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentChild`](crate::model::ComponentChild)
        pub fn build(self) -> crate::model::ComponentChild {
            crate::model::ComponentChild {
                component_type: self.component_type,
                name: self.name,
                properties: self.properties,
                children: self.children,
                events: self.events,
                source_id: self.source_id,
            }
        }
    }
}
impl ComponentChild {
    /// Creates a new builder-style object to manufacture [`ComponentChild`](crate::model::ComponentChild)
    pub fn builder() -> crate::model::component_child::Builder {
        crate::model::component_child::Builder::default()
    }
}

/// <p>Contains a summary of a component. This is a read-only data type that is returned by <code>ListComponents</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentSummary {
    /// <p>The unique ID of the Amplify app associated with the component.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the component.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The component type.</p>
    pub component_type: std::option::Option<std::string::String>,
}
impl ComponentSummary {
    /// <p>The unique ID of the Amplify app associated with the component.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique ID of the component.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The component type.</p>
    pub fn component_type(&self) -> std::option::Option<&str> {
        self.component_type.as_deref()
    }
}
impl std::fmt::Debug for ComponentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentSummary");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("component_type", &self.component_type);
        formatter.finish()
    }
}
/// See [`ComponentSummary`](crate::model::ComponentSummary)
pub mod component_summary {
    /// A builder for [`ComponentSummary`](crate::model::ComponentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) component_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app associated with the component.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the component.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The component type.</p>
        pub fn component_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type = Some(input.into());
            self
        }
        /// <p>The component type.</p>
        pub fn set_component_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentSummary`](crate::model::ComponentSummary)
        pub fn build(self) -> crate::model::ComponentSummary {
            crate::model::ComponentSummary {
                app_id: self.app_id,
                environment_name: self.environment_name,
                id: self.id,
                name: self.name,
                component_type: self.component_type,
            }
        }
    }
}
impl ComponentSummary {
    /// Creates a new builder-style object to manufacture [`ComponentSummary`](crate::model::ComponentSummary)
    pub fn builder() -> crate::model::component_summary::Builder {
        crate::model::component_summary::Builder::default()
    }
}

/// <p>Represents all of the information that is required to create a component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentData {
    /// <p>The name of the component</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the component in its original source system, such as Figma.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The component type. This can be an Amplify custom UI component or another custom component.</p>
    pub component_type: std::option::Option<std::string::String>,
    /// <p>Describes the component's properties.</p>
    pub properties: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    >,
    /// <p>A list of child components that are instances of the main component.</p>
    pub children: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
    /// <p>A list of the unique variants of this component.</p>
    pub variants: std::option::Option<std::vec::Vec<crate::model::ComponentVariant>>,
    /// <p>Describes the component properties that can be overriden to customize an instance of the component.</p>
    pub overrides: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The data binding information for the component's properties.</p>
    pub binding_properties: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::ComponentBindingPropertiesValue,
        >,
    >,
    /// <p>The data binding configuration for customizing a component's properties. Use this for a collection component.</p>
    pub collection_properties: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentDataConfiguration>,
    >,
    /// <p>One or more key-value pairs to use when tagging the component data.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
    pub events: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
    >,
    /// <p>The schema version of the component when it was imported.</p>
    pub schema_version: std::option::Option<std::string::String>,
}
impl CreateComponentData {
    /// <p>The name of the component</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique ID of the component in its original source system, such as Figma.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The component type. This can be an Amplify custom UI component or another custom component.</p>
    pub fn component_type(&self) -> std::option::Option<&str> {
        self.component_type.as_deref()
    }
    /// <p>Describes the component's properties.</p>
    pub fn properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    > {
        self.properties.as_ref()
    }
    /// <p>A list of child components that are instances of the main component.</p>
    pub fn children(&self) -> std::option::Option<&[crate::model::ComponentChild]> {
        self.children.as_deref()
    }
    /// <p>A list of the unique variants of this component.</p>
    pub fn variants(&self) -> std::option::Option<&[crate::model::ComponentVariant]> {
        self.variants.as_deref()
    }
    /// <p>Describes the component properties that can be overriden to customize an instance of the component.</p>
    pub fn overrides(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.overrides.as_ref()
    }
    /// <p>The data binding information for the component's properties.</p>
    pub fn binding_properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::ComponentBindingPropertiesValue,
        >,
    > {
        self.binding_properties.as_ref()
    }
    /// <p>The data binding configuration for customizing a component's properties. Use this for a collection component.</p>
    pub fn collection_properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentDataConfiguration>,
    > {
        self.collection_properties.as_ref()
    }
    /// <p>One or more key-value pairs to use when tagging the component data.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
    pub fn events(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
    > {
        self.events.as_ref()
    }
    /// <p>The schema version of the component when it was imported.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
}
impl std::fmt::Debug for CreateComponentData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentData");
        formatter.field("name", &self.name);
        formatter.field("source_id", &self.source_id);
        formatter.field("component_type", &self.component_type);
        formatter.field("properties", &self.properties);
        formatter.field("children", &self.children);
        formatter.field("variants", &self.variants);
        formatter.field("overrides", &self.overrides);
        formatter.field("binding_properties", &self.binding_properties);
        formatter.field("collection_properties", &self.collection_properties);
        formatter.field("tags", &self.tags);
        formatter.field("events", &self.events);
        formatter.field("schema_version", &self.schema_version);
        formatter.finish()
    }
}
/// See [`CreateComponentData`](crate::model::CreateComponentData)
pub mod create_component_data {
    /// A builder for [`CreateComponentData`](crate::model::CreateComponentData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) component_type: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
        >,
        pub(crate) children: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
        pub(crate) variants: std::option::Option<std::vec::Vec<crate::model::ComponentVariant>>,
        pub(crate) overrides: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) binding_properties: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::ComponentBindingPropertiesValue,
            >,
        >,
        pub(crate) collection_properties: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::ComponentDataConfiguration,
            >,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) events: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
        >,
        pub(crate) schema_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the component</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the component</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique ID of the component in its original source system, such as Figma.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the component in its original source system, such as Figma.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The component type. This can be an Amplify custom UI component or another custom component.</p>
        pub fn component_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type = Some(input.into());
            self
        }
        /// <p>The component type. This can be an Amplify custom UI component or another custom component.</p>
        pub fn set_component_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>Describes the component's properties.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentProperty,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.properties = Some(hash_map);
            self
        }
        /// <p>Describes the component's properties.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Appends an item to `children`.
        ///
        /// To override the contents of this collection use [`set_children`](Self::set_children).
        ///
        /// <p>A list of child components that are instances of the main component.</p>
        pub fn children(mut self, input: crate::model::ComponentChild) -> Self {
            let mut v = self.children.unwrap_or_default();
            v.push(input);
            self.children = Some(v);
            self
        }
        /// <p>A list of child components that are instances of the main component.</p>
        pub fn set_children(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
        ) -> Self {
            self.children = input;
            self
        }
        /// Appends an item to `variants`.
        ///
        /// To override the contents of this collection use [`set_variants`](Self::set_variants).
        ///
        /// <p>A list of the unique variants of this component.</p>
        pub fn variants(mut self, input: crate::model::ComponentVariant) -> Self {
            let mut v = self.variants.unwrap_or_default();
            v.push(input);
            self.variants = Some(v);
            self
        }
        /// <p>A list of the unique variants of this component.</p>
        pub fn set_variants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentVariant>>,
        ) -> Self {
            self.variants = input;
            self
        }
        /// Adds a key-value pair to `overrides`.
        ///
        /// To override the contents of this collection use [`set_overrides`](Self::set_overrides).
        ///
        /// <p>Describes the component properties that can be overriden to customize an instance of the component.</p>
        pub fn overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut hash_map = self.overrides.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.overrides = Some(hash_map);
            self
        }
        /// <p>Describes the component properties that can be overriden to customize an instance of the component.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Adds a key-value pair to `binding_properties`.
        ///
        /// To override the contents of this collection use [`set_binding_properties`](Self::set_binding_properties).
        ///
        /// <p>The data binding information for the component's properties.</p>
        pub fn binding_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentBindingPropertiesValue,
        ) -> Self {
            let mut hash_map = self.binding_properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.binding_properties = Some(hash_map);
            self
        }
        /// <p>The data binding information for the component's properties.</p>
        pub fn set_binding_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentBindingPropertiesValue,
                >,
            >,
        ) -> Self {
            self.binding_properties = input;
            self
        }
        /// Adds a key-value pair to `collection_properties`.
        ///
        /// To override the contents of this collection use [`set_collection_properties`](Self::set_collection_properties).
        ///
        /// <p>The data binding configuration for customizing a component's properties. Use this for a collection component.</p>
        pub fn collection_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentDataConfiguration,
        ) -> Self {
            let mut hash_map = self.collection_properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.collection_properties = Some(hash_map);
            self
        }
        /// <p>The data binding configuration for customizing a component's properties. Use this for a collection component.</p>
        pub fn set_collection_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentDataConfiguration,
                >,
            >,
        ) -> Self {
            self.collection_properties = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more key-value pairs to use when tagging the component data.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more key-value pairs to use when tagging the component data.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
        pub fn events(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentEvent,
        ) -> Self {
            let mut hash_map = self.events.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.events = Some(hash_map);
            self
        }
        /// <p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
            >,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>The schema version of the component when it was imported.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The schema version of the component when it was imported.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentData`](crate::model::CreateComponentData)
        pub fn build(self) -> crate::model::CreateComponentData {
            crate::model::CreateComponentData {
                name: self.name,
                source_id: self.source_id,
                component_type: self.component_type,
                properties: self.properties,
                children: self.children,
                variants: self.variants,
                overrides: self.overrides,
                binding_properties: self.binding_properties,
                collection_properties: self.collection_properties,
                tags: self.tags,
                events: self.events,
                schema_version: self.schema_version,
            }
        }
    }
}
impl CreateComponentData {
    /// Creates a new builder-style object to manufacture [`CreateComponentData`](crate::model::CreateComponentData)
    pub fn builder() -> crate::model::create_component_data::Builder {
        crate::model::create_component_data::Builder::default()
    }
}

/// <p>Updates and saves all of the information about a component, based on component ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateComponentData {
    /// <p>The unique ID of the component to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the component to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the component in its original source system, such as Figma.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>
    pub component_type: std::option::Option<std::string::String>,
    /// <p>Describes the component's properties.</p>
    pub properties: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    >,
    /// <p>The components that are instances of the main component.</p>
    pub children: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
    /// <p>A list of the unique variants of the main component being updated.</p>
    pub variants: std::option::Option<std::vec::Vec<crate::model::ComponentVariant>>,
    /// <p>Describes the properties that can be overriden to customize the component.</p>
    pub overrides: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The data binding information for the component's properties.</p>
    pub binding_properties: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::ComponentBindingPropertiesValue,
        >,
    >,
    /// <p>The configuration for binding a component's properties to a data model. Use this for a collection component.</p>
    pub collection_properties: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentDataConfiguration>,
    >,
    /// <p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
    pub events: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
    >,
    /// <p>The schema version of the component when it was imported.</p>
    pub schema_version: std::option::Option<std::string::String>,
}
impl UpdateComponentData {
    /// <p>The unique ID of the component to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the component to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique ID of the component in its original source system, such as Figma.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>
    pub fn component_type(&self) -> std::option::Option<&str> {
        self.component_type.as_deref()
    }
    /// <p>Describes the component's properties.</p>
    pub fn properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
    > {
        self.properties.as_ref()
    }
    /// <p>The components that are instances of the main component.</p>
    pub fn children(&self) -> std::option::Option<&[crate::model::ComponentChild]> {
        self.children.as_deref()
    }
    /// <p>A list of the unique variants of the main component being updated.</p>
    pub fn variants(&self) -> std::option::Option<&[crate::model::ComponentVariant]> {
        self.variants.as_deref()
    }
    /// <p>Describes the properties that can be overriden to customize the component.</p>
    pub fn overrides(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.overrides.as_ref()
    }
    /// <p>The data binding information for the component's properties.</p>
    pub fn binding_properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::ComponentBindingPropertiesValue,
        >,
    > {
        self.binding_properties.as_ref()
    }
    /// <p>The configuration for binding a component's properties to a data model. Use this for a collection component.</p>
    pub fn collection_properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentDataConfiguration>,
    > {
        self.collection_properties.as_ref()
    }
    /// <p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
    pub fn events(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
    > {
        self.events.as_ref()
    }
    /// <p>The schema version of the component when it was imported.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
}
impl std::fmt::Debug for UpdateComponentData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateComponentData");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("source_id", &self.source_id);
        formatter.field("component_type", &self.component_type);
        formatter.field("properties", &self.properties);
        formatter.field("children", &self.children);
        formatter.field("variants", &self.variants);
        formatter.field("overrides", &self.overrides);
        formatter.field("binding_properties", &self.binding_properties);
        formatter.field("collection_properties", &self.collection_properties);
        formatter.field("events", &self.events);
        formatter.field("schema_version", &self.schema_version);
        formatter.finish()
    }
}
/// See [`UpdateComponentData`](crate::model::UpdateComponentData)
pub mod update_component_data {
    /// A builder for [`UpdateComponentData`](crate::model::UpdateComponentData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) component_type: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
        >,
        pub(crate) children: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
        pub(crate) variants: std::option::Option<std::vec::Vec<crate::model::ComponentVariant>>,
        pub(crate) overrides: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) binding_properties: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::ComponentBindingPropertiesValue,
            >,
        >,
        pub(crate) collection_properties: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::ComponentDataConfiguration,
            >,
        >,
        pub(crate) events: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
        >,
        pub(crate) schema_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the component to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the component to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the component to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the component to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique ID of the component in its original source system, such as Figma.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the component in its original source system, such as Figma.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>
        pub fn component_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type = Some(input.into());
            self
        }
        /// <p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>
        pub fn set_component_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>Describes the component's properties.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentProperty,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.properties = Some(hash_map);
            self
        }
        /// <p>Describes the component's properties.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentProperty>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Appends an item to `children`.
        ///
        /// To override the contents of this collection use [`set_children`](Self::set_children).
        ///
        /// <p>The components that are instances of the main component.</p>
        pub fn children(mut self, input: crate::model::ComponentChild) -> Self {
            let mut v = self.children.unwrap_or_default();
            v.push(input);
            self.children = Some(v);
            self
        }
        /// <p>The components that are instances of the main component.</p>
        pub fn set_children(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentChild>>,
        ) -> Self {
            self.children = input;
            self
        }
        /// Appends an item to `variants`.
        ///
        /// To override the contents of this collection use [`set_variants`](Self::set_variants).
        ///
        /// <p>A list of the unique variants of the main component being updated.</p>
        pub fn variants(mut self, input: crate::model::ComponentVariant) -> Self {
            let mut v = self.variants.unwrap_or_default();
            v.push(input);
            self.variants = Some(v);
            self
        }
        /// <p>A list of the unique variants of the main component being updated.</p>
        pub fn set_variants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentVariant>>,
        ) -> Self {
            self.variants = input;
            self
        }
        /// Adds a key-value pair to `overrides`.
        ///
        /// To override the contents of this collection use [`set_overrides`](Self::set_overrides).
        ///
        /// <p>Describes the properties that can be overriden to customize the component.</p>
        pub fn overrides(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut hash_map = self.overrides.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.overrides = Some(hash_map);
            self
        }
        /// <p>Describes the properties that can be overriden to customize the component.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Adds a key-value pair to `binding_properties`.
        ///
        /// To override the contents of this collection use [`set_binding_properties`](Self::set_binding_properties).
        ///
        /// <p>The data binding information for the component's properties.</p>
        pub fn binding_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentBindingPropertiesValue,
        ) -> Self {
            let mut hash_map = self.binding_properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.binding_properties = Some(hash_map);
            self
        }
        /// <p>The data binding information for the component's properties.</p>
        pub fn set_binding_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentBindingPropertiesValue,
                >,
            >,
        ) -> Self {
            self.binding_properties = input;
            self
        }
        /// Adds a key-value pair to `collection_properties`.
        ///
        /// To override the contents of this collection use [`set_collection_properties`](Self::set_collection_properties).
        ///
        /// <p>The configuration for binding a component's properties to a data model. Use this for a collection component.</p>
        pub fn collection_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentDataConfiguration,
        ) -> Self {
            let mut hash_map = self.collection_properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.collection_properties = Some(hash_map);
            self
        }
        /// <p>The configuration for binding a component's properties to a data model. Use this for a collection component.</p>
        pub fn set_collection_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentDataConfiguration,
                >,
            >,
        ) -> Self {
            self.collection_properties = input;
            self
        }
        /// Adds a key-value pair to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
        pub fn events(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentEvent,
        ) -> Self {
            let mut hash_map = self.events.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.events = Some(hash_map);
            self
        }
        /// <p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentEvent>,
            >,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>The schema version of the component when it was imported.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The schema version of the component when it was imported.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateComponentData`](crate::model::UpdateComponentData)
        pub fn build(self) -> crate::model::UpdateComponentData {
            crate::model::UpdateComponentData {
                id: self.id,
                name: self.name,
                source_id: self.source_id,
                component_type: self.component_type,
                properties: self.properties,
                children: self.children,
                variants: self.variants,
                overrides: self.overrides,
                binding_properties: self.binding_properties,
                collection_properties: self.collection_properties,
                events: self.events,
                schema_version: self.schema_version,
            }
        }
    }
}
impl UpdateComponentData {
    /// Creates a new builder-style object to manufacture [`UpdateComponentData`](crate::model::UpdateComponentData)
    pub fn builder() -> crate::model::update_component_data::Builder {
        crate::model::update_component_data::Builder::default()
    }
}

/// <p>Describes a refresh token.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshTokenRequestBody {
    /// <p>The token to use to refresh a previously issued access token that might have expired.</p>
    pub token: std::option::Option<std::string::String>,
}
impl RefreshTokenRequestBody {
    /// <p>The token to use to refresh a previously issued access token that might have expired.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
}
impl std::fmt::Debug for RefreshTokenRequestBody {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshTokenRequestBody");
        formatter.field("token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`RefreshTokenRequestBody`](crate::model::RefreshTokenRequestBody)
pub mod refresh_token_request_body {
    /// A builder for [`RefreshTokenRequestBody`](crate::model::RefreshTokenRequestBody)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to use to refresh a previously issued access token that might have expired.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The token to use to refresh a previously issued access token that might have expired.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshTokenRequestBody`](crate::model::RefreshTokenRequestBody)
        pub fn build(self) -> crate::model::RefreshTokenRequestBody {
            crate::model::RefreshTokenRequestBody { token: self.token }
        }
    }
}
impl RefreshTokenRequestBody {
    /// Creates a new builder-style object to manufacture [`RefreshTokenRequestBody`](crate::model::RefreshTokenRequestBody)
    pub fn builder() -> crate::model::refresh_token_request_body::Builder {
        crate::model::refresh_token_request_body::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TokenProviders {
    /// The figma token provider.
    Figma,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TokenProviders {
    fn from(s: &str) -> Self {
        match s {
            "figma" => TokenProviders::Figma,
            other => TokenProviders::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TokenProviders {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TokenProviders::from(s))
    }
}
impl TokenProviders {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TokenProviders::Figma => "figma",
            TokenProviders::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["figma"]
    }
}
impl AsRef<str> for TokenProviders {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the configuration of a request to exchange an access code for a token.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExchangeCodeForTokenRequestBody {
    /// <p>The access code to send in the request.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The location of the application that will receive the access code.</p>
    pub redirect_uri: std::option::Option<std::string::String>,
}
impl ExchangeCodeForTokenRequestBody {
    /// <p>The access code to send in the request.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The location of the application that will receive the access code.</p>
    pub fn redirect_uri(&self) -> std::option::Option<&str> {
        self.redirect_uri.as_deref()
    }
}
impl std::fmt::Debug for ExchangeCodeForTokenRequestBody {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExchangeCodeForTokenRequestBody");
        formatter.field("code", &"*** Sensitive Data Redacted ***");
        formatter.field("redirect_uri", &self.redirect_uri);
        formatter.finish()
    }
}
/// See [`ExchangeCodeForTokenRequestBody`](crate::model::ExchangeCodeForTokenRequestBody)
pub mod exchange_code_for_token_request_body {
    /// A builder for [`ExchangeCodeForTokenRequestBody`](crate::model::ExchangeCodeForTokenRequestBody)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) redirect_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access code to send in the request.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The access code to send in the request.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The location of the application that will receive the access code.</p>
        pub fn redirect_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.redirect_uri = Some(input.into());
            self
        }
        /// <p>The location of the application that will receive the access code.</p>
        pub fn set_redirect_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.redirect_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`ExchangeCodeForTokenRequestBody`](crate::model::ExchangeCodeForTokenRequestBody)
        pub fn build(self) -> crate::model::ExchangeCodeForTokenRequestBody {
            crate::model::ExchangeCodeForTokenRequestBody {
                code: self.code,
                redirect_uri: self.redirect_uri,
            }
        }
    }
}
impl ExchangeCodeForTokenRequestBody {
    /// Creates a new builder-style object to manufacture [`ExchangeCodeForTokenRequestBody`](crate::model::ExchangeCodeForTokenRequestBody)
    pub fn builder() -> crate::model::exchange_code_for_token_request_body::Builder {
        crate::model::exchange_code_for_token_request_body::Builder::default()
    }
}
