// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateComponentInput`](crate::input::CreateComponentInput)
pub mod create_component_input {
    /// A builder for [`CreateComponentInput`](crate::input::CreateComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) component_to_create: std::option::Option<crate::model::CreateComponentData>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app to associate with the component.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app to associate with the component.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Represents the configuration of the component to create.</p>
        pub fn component_to_create(mut self, input: crate::model::CreateComponentData) -> Self {
            self.component_to_create = Some(input);
            self
        }
        /// <p>Represents the configuration of the component to create.</p>
        pub fn set_component_to_create(
            mut self,
            input: std::option::Option<crate::model::CreateComponentData>,
        ) -> Self {
            self.component_to_create = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentInput`](crate::input::CreateComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateComponentInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                client_token: self.client_token,
                component_to_create: self.component_to_create,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateComponentInputOperationOutputAlias = crate::operation::CreateComponent;
#[doc(hidden)]
pub type CreateComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateComponentInput {
    /// Consumes the builder and constructs an Operation<[`CreateComponent`](crate::operation::CreateComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.app_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_1, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_2 = &_input.environment_name;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_2, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/components",
                    appId = app_id,
                    environmentName = environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateComponentInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_3) = &_input.client_token {
                    query.push_kv("clientToken", &aws_smithy_http::query::fmt_string(&inner_3));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_component_input(
                &self.component_to_create,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateComponent",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateComponentInput`](crate::input::CreateComponentInput)
    pub fn builder() -> crate::input::create_component_input::Builder {
        crate::input::create_component_input::Builder::default()
    }
}

/// See [`CreateThemeInput`](crate::input::CreateThemeInput)
pub mod create_theme_input {
    /// A builder for [`CreateThemeInput`](crate::input::CreateThemeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) theme_to_create: std::option::Option<crate::model::CreateThemeData>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app associated with the theme.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the theme.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Represents the configuration of the theme to create.</p>
        pub fn theme_to_create(mut self, input: crate::model::CreateThemeData) -> Self {
            self.theme_to_create = Some(input);
            self
        }
        /// <p>Represents the configuration of the theme to create.</p>
        pub fn set_theme_to_create(
            mut self,
            input: std::option::Option<crate::model::CreateThemeData>,
        ) -> Self {
            self.theme_to_create = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThemeInput`](crate::input::CreateThemeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateThemeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateThemeInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                client_token: self.client_token,
                theme_to_create: self.theme_to_create,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateThemeInputOperationOutputAlias = crate::operation::CreateTheme;
#[doc(hidden)]
pub type CreateThemeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateThemeInput {
    /// Consumes the builder and constructs an Operation<[`CreateTheme`](crate::operation::CreateTheme)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTheme,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateThemeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.app_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_4, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_5 = &_input.environment_name;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_5, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/themes",
                    appId = app_id,
                    environmentName = environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateThemeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_6) = &_input.client_token {
                    query.push_kv("clientToken", &aws_smithy_http::query::fmt_string(&inner_6));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateThemeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_theme_input(&self.theme_to_create)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTheme::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTheme",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateThemeInput`](crate::input::CreateThemeInput)
    pub fn builder() -> crate::input::create_theme_input::Builder {
        crate::input::create_theme_input::Builder::default()
    }
}

/// See [`DeleteComponentInput`](crate::input::DeleteComponentInput)
pub mod delete_component_input {
    /// A builder for [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app associated with the component to delete.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the component to delete.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique ID of the component to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the component to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteComponentInput`](crate::input::DeleteComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteComponentInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteComponentInputOperationOutputAlias = crate::operation::DeleteComponent;
#[doc(hidden)]
pub type DeleteComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteComponentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteComponent`](crate::operation::DeleteComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.app_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_7, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_8 = &_input.environment_name;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_8, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_9 = &_input.id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_9, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/components/{id}",
                    appId = app_id,
                    environmentName = environment_name,
                    id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteComponent",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    pub fn builder() -> crate::input::delete_component_input::Builder {
        crate::input::delete_component_input::Builder::default()
    }
}

/// See [`DeleteThemeInput`](crate::input::DeleteThemeInput)
pub mod delete_theme_input {
    /// A builder for [`DeleteThemeInput`](crate::input::DeleteThemeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app associated with the theme to delete.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app associated with the theme to delete.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique ID of the theme to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the theme to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThemeInput`](crate::input::DeleteThemeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteThemeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteThemeInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteThemeInputOperationOutputAlias = crate::operation::DeleteTheme;
#[doc(hidden)]
pub type DeleteThemeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteThemeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTheme`](crate::operation::DeleteTheme)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTheme,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteThemeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.app_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_10, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_11 = &_input.environment_name;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_11, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_12 = &_input.id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_12, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/themes/{id}",
                    appId = app_id,
                    environmentName = environment_name,
                    id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteThemeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTheme::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTheme",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteThemeInput`](crate::input::DeleteThemeInput)
    pub fn builder() -> crate::input::delete_theme_input::Builder {
        crate::input::delete_theme_input::Builder::default()
    }
}

/// See [`ExchangeCodeForTokenInput`](crate::input::ExchangeCodeForTokenInput)
pub mod exchange_code_for_token_input {
    /// A builder for [`ExchangeCodeForTokenInput`](crate::input::ExchangeCodeForTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider: std::option::Option<crate::model::TokenProviders>,
        pub(crate) request: std::option::Option<crate::model::ExchangeCodeForTokenRequestBody>,
    }
    impl Builder {
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn provider(mut self, input: crate::model::TokenProviders) -> Self {
            self.provider = Some(input);
            self
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::TokenProviders>,
        ) -> Self {
            self.provider = input;
            self
        }
        /// <p>Describes the configuration of the request.</p>
        pub fn request(mut self, input: crate::model::ExchangeCodeForTokenRequestBody) -> Self {
            self.request = Some(input);
            self
        }
        /// <p>Describes the configuration of the request.</p>
        pub fn set_request(
            mut self,
            input: std::option::Option<crate::model::ExchangeCodeForTokenRequestBody>,
        ) -> Self {
            self.request = input;
            self
        }
        /// Consumes the builder and constructs a [`ExchangeCodeForTokenInput`](crate::input::ExchangeCodeForTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExchangeCodeForTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExchangeCodeForTokenInput {
                provider: self.provider,
                request: self.request,
            })
        }
    }
}
#[doc(hidden)]
pub type ExchangeCodeForTokenInputOperationOutputAlias = crate::operation::ExchangeCodeForToken;
#[doc(hidden)]
pub type ExchangeCodeForTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExchangeCodeForTokenInput {
    /// Consumes the builder and constructs an Operation<[`ExchangeCodeForToken`](crate::operation::ExchangeCodeForToken)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExchangeCodeForToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExchangeCodeForTokenInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.provider;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "provider",
                        details: "cannot be empty or unset",
                    },
                )?;
                let provider = aws_smithy_http::label::fmt_string(input_13, false);
                if provider.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "provider",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tokens/{provider}", provider = provider)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExchangeCodeForTokenInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_exchange_code_for_token_input(&self.request)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExchangeCodeForToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExchangeCodeForToken",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExchangeCodeForTokenInput`](crate::input::ExchangeCodeForTokenInput)
    pub fn builder() -> crate::input::exchange_code_for_token_input::Builder {
        crate::input::exchange_code_for_token_input::Builder::default()
    }
}

/// See [`ExportComponentsInput`](crate::input::ExportComponentsInput)
pub mod export_components_input {
    /// A builder for [`ExportComponentsInput`](crate::input::ExportComponentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app to export components to.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app to export components to.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportComponentsInput`](crate::input::ExportComponentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportComponentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportComponentsInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportComponentsInputOperationOutputAlias = crate::operation::ExportComponents;
#[doc(hidden)]
pub type ExportComponentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExportComponentsInput {
    /// Consumes the builder and constructs an Operation<[`ExportComponents`](crate::operation::ExportComponents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportComponents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExportComponentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.app_id;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_14, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_15 = &_input.environment_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_15, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/export/app/{appId}/environment/{environmentName}/components",
                    appId = app_id,
                    environmentName = environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ExportComponentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_16) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_16));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExportComponentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportComponents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportComponents",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExportComponentsInput`](crate::input::ExportComponentsInput)
    pub fn builder() -> crate::input::export_components_input::Builder {
        crate::input::export_components_input::Builder::default()
    }
}

/// See [`ExportThemesInput`](crate::input::ExportThemesInput)
pub mod export_themes_input {
    /// A builder for [`ExportThemesInput`](crate::input::ExportThemesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app to export the themes to.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app to export the themes to.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportThemesInput`](crate::input::ExportThemesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportThemesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportThemesInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportThemesInputOperationOutputAlias = crate::operation::ExportThemes;
#[doc(hidden)]
pub type ExportThemesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExportThemesInput {
    /// Consumes the builder and constructs an Operation<[`ExportThemes`](crate::operation::ExportThemes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportThemes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExportThemesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.app_id;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_17, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_18 = &_input.environment_name;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_18, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/export/app/{appId}/environment/{environmentName}/themes",
                    appId = app_id,
                    environmentName = environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ExportThemesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_19) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_19));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExportThemesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportThemes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportThemes",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExportThemesInput`](crate::input::ExportThemesInput)
    pub fn builder() -> crate::input::export_themes_input::Builder {
        crate::input::export_themes_input::Builder::default()
    }
}

/// See [`GetComponentInput`](crate::input::GetComponentInput)
pub mod get_component_input {
    /// A builder for [`GetComponentInput`](crate::input::GetComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the component.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentInput`](crate::input::GetComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComponentInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetComponentInputOperationOutputAlias = crate::operation::GetComponent;
#[doc(hidden)]
pub type GetComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetComponentInput {
    /// Consumes the builder and constructs an Operation<[`GetComponent`](crate::operation::GetComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.app_id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_20, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_21 = &_input.environment_name;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_21, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_22 = &_input.id;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_22, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/components/{id}",
                    appId = app_id,
                    environmentName = environment_name,
                    id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComponent",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetComponentInput`](crate::input::GetComponentInput)
    pub fn builder() -> crate::input::get_component_input::Builder {
        crate::input::get_component_input::Builder::default()
    }
}

/// See [`GetThemeInput`](crate::input::GetThemeInput)
pub mod get_theme_input {
    /// A builder for [`GetThemeInput`](crate::input::GetThemeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetThemeInput`](crate::input::GetThemeInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetThemeInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetThemeInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetThemeInputOperationOutputAlias = crate::operation::GetTheme;
#[doc(hidden)]
pub type GetThemeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetThemeInput {
    /// Consumes the builder and constructs an Operation<[`GetTheme`](crate::operation::GetTheme)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTheme,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetThemeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.app_id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_23, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_24 = &_input.environment_name;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_24, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_25 = &_input.id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_25, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/themes/{id}",
                    appId = app_id,
                    environmentName = environment_name,
                    id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetThemeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetTheme::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetTheme",
                    "amplifyuibuilder",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetThemeInput`](crate::input::GetThemeInput)
    pub fn builder() -> crate::input::get_theme_input::Builder {
        crate::input::get_theme_input::Builder::default()
    }
}

/// See [`ListComponentsInput`](crate::input::ListComponentsInput)
pub mod list_components_input {
    /// A builder for [`ListComponentsInput`](crate::input::ListComponentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of components to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of components to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentsInput`](crate::input::ListComponentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListComponentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListComponentsInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListComponentsInputOperationOutputAlias = crate::operation::ListComponents;
#[doc(hidden)]
pub type ListComponentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListComponentsInput {
    /// Consumes the builder and constructs an Operation<[`ListComponents`](crate::operation::ListComponents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListComponents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListComponentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.app_id;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_26, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_27 = &_input.environment_name;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_27, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/components",
                    appId = app_id,
                    environmentName = environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListComponentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_28) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_28));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListComponentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListComponents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListComponents",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListComponentsInput`](crate::input::ListComponentsInput)
    pub fn builder() -> crate::input::list_components_input::Builder {
        crate::input::list_components_input::Builder::default()
    }
}

/// See [`ListThemesInput`](crate::input::ListThemesInput)
pub mod list_themes_input {
    /// A builder for [`ListThemesInput`](crate::input::ListThemesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is a part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of theme results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of theme results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThemesInput`](crate::input::ListThemesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListThemesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListThemesInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListThemesInputOperationOutputAlias = crate::operation::ListThemes;
#[doc(hidden)]
pub type ListThemesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListThemesInput {
    /// Consumes the builder and constructs an Operation<[`ListThemes`](crate::operation::ListThemes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListThemes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListThemesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.app_id;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_29, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_30 = &_input.environment_name;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_30, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/themes",
                    appId = app_id,
                    environmentName = environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListThemesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_31) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_31));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListThemesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListThemes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListThemes",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListThemesInput`](crate::input::ListThemesInput)
    pub fn builder() -> crate::input::list_themes_input::Builder {
        crate::input::list_themes_input::Builder::default()
    }
}

/// See [`RefreshTokenInput`](crate::input::RefreshTokenInput)
pub mod refresh_token_input {
    /// A builder for [`RefreshTokenInput`](crate::input::RefreshTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider: std::option::Option<crate::model::TokenProviders>,
        pub(crate) refresh_token_body: std::option::Option<crate::model::RefreshTokenRequestBody>,
    }
    impl Builder {
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn provider(mut self, input: crate::model::TokenProviders) -> Self {
            self.provider = Some(input);
            self
        }
        /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::TokenProviders>,
        ) -> Self {
            self.provider = input;
            self
        }
        /// <p>Information about the refresh token request.</p>
        pub fn refresh_token_body(mut self, input: crate::model::RefreshTokenRequestBody) -> Self {
            self.refresh_token_body = Some(input);
            self
        }
        /// <p>Information about the refresh token request.</p>
        pub fn set_refresh_token_body(
            mut self,
            input: std::option::Option<crate::model::RefreshTokenRequestBody>,
        ) -> Self {
            self.refresh_token_body = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshTokenInput`](crate::input::RefreshTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RefreshTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RefreshTokenInput {
                provider: self.provider,
                refresh_token_body: self.refresh_token_body,
            })
        }
    }
}
#[doc(hidden)]
pub type RefreshTokenInputOperationOutputAlias = crate::operation::RefreshToken;
#[doc(hidden)]
pub type RefreshTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RefreshTokenInput {
    /// Consumes the builder and constructs an Operation<[`RefreshToken`](crate::operation::RefreshToken)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RefreshToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RefreshTokenInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.provider;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "provider",
                        details: "cannot be empty or unset",
                    },
                )?;
                let provider = aws_smithy_http::label::fmt_string(input_32, false);
                if provider.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "provider",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tokens/{provider}/refresh", provider = provider)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RefreshTokenInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_refresh_token_input(&self.refresh_token_body)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RefreshToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RefreshToken",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RefreshTokenInput`](crate::input::RefreshTokenInput)
    pub fn builder() -> crate::input::refresh_token_input::Builder {
        crate::input::refresh_token_input::Builder::default()
    }
}

/// See [`UpdateComponentInput`](crate::input::UpdateComponentInput)
pub mod update_component_input {
    /// A builder for [`UpdateComponentInput`](crate::input::UpdateComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) updated_component: std::option::Option<crate::model::UpdateComponentData>,
    }
    impl Builder {
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique ID for the component.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID for the component.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The configuration of the updated component.</p>
        pub fn updated_component(mut self, input: crate::model::UpdateComponentData) -> Self {
            self.updated_component = Some(input);
            self
        }
        /// <p>The configuration of the updated component.</p>
        pub fn set_updated_component(
            mut self,
            input: std::option::Option<crate::model::UpdateComponentData>,
        ) -> Self {
            self.updated_component = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateComponentInput`](crate::input::UpdateComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateComponentInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                id: self.id,
                client_token: self.client_token,
                updated_component: self.updated_component,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateComponentInputOperationOutputAlias = crate::operation::UpdateComponent;
#[doc(hidden)]
pub type UpdateComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateComponentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateComponent`](crate::operation::UpdateComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_33 = &_input.app_id;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_33, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_34 = &_input.environment_name;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_34, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_35 = &_input.id;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_35, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/components/{id}",
                    appId = app_id,
                    environmentName = environment_name,
                    id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateComponentInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_36) = &_input.client_token {
                    query.push_kv(
                        "clientToken",
                        &aws_smithy_http::query::fmt_string(&inner_36),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_component_input(
                &self.updated_component,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateComponent",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateComponentInput`](crate::input::UpdateComponentInput)
    pub fn builder() -> crate::input::update_component_input::Builder {
        crate::input::update_component_input::Builder::default()
    }
}

/// See [`UpdateThemeInput`](crate::input::UpdateThemeInput)
pub mod update_theme_input {
    /// A builder for [`UpdateThemeInput`](crate::input::UpdateThemeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) updated_theme: std::option::Option<crate::model::UpdateThemeData>,
    }
    impl Builder {
        /// <p>The unique ID for the Amplify app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the Amplify app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment that is part of the Amplify app.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID for the theme.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The unique client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The unique client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The configuration of the updated theme.</p>
        pub fn updated_theme(mut self, input: crate::model::UpdateThemeData) -> Self {
            self.updated_theme = Some(input);
            self
        }
        /// <p>The configuration of the updated theme.</p>
        pub fn set_updated_theme(
            mut self,
            input: std::option::Option<crate::model::UpdateThemeData>,
        ) -> Self {
            self.updated_theme = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThemeInput`](crate::input::UpdateThemeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateThemeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateThemeInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                id: self.id,
                client_token: self.client_token,
                updated_theme: self.updated_theme,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateThemeInputOperationOutputAlias = crate::operation::UpdateTheme;
#[doc(hidden)]
pub type UpdateThemeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateThemeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTheme`](crate::operation::UpdateTheme)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTheme,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateThemeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_37 = &_input.app_id;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_37, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_38 = &_input.environment_name;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_38, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_39 = &_input.id;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_39, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/app/{appId}/environment/{environmentName}/themes/{id}",
                    appId = app_id,
                    environmentName = environment_name,
                    id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateThemeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_40) = &_input.client_token {
                    query.push_kv(
                        "clientToken",
                        &aws_smithy_http::query::fmt_string(&inner_40),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateThemeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_theme_input(&self.updated_theme)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTheme::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTheme",
            "amplifyuibuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateThemeInput`](crate::input::UpdateThemeInput)
    pub fn builder() -> crate::input::update_theme_input::Builder {
        crate::input::update_theme_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportThemesInput {
    /// <p>The unique ID of the Amplify app to export the themes to.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ExportThemesInput {
    /// <p>The unique ID of the Amplify app to export the themes to.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ExportThemesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportThemesInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThemesInput {
    /// <p>The unique ID for the Amplify app.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of theme results to return in the response.</p>
    pub max_results: i32,
}
impl ListThemesInput {
    /// <p>The unique ID for the Amplify app.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of theme results to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListThemesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThemesInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThemeInput {
    /// <p>The unique ID of the Amplify app associated with the theme.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique client token.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Represents the configuration of the theme to create.</p>
    pub theme_to_create: std::option::Option<crate::model::CreateThemeData>,
}
impl CreateThemeInput {
    /// <p>The unique ID of the Amplify app associated with the theme.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Represents the configuration of the theme to create.</p>
    pub fn theme_to_create(&self) -> std::option::Option<&crate::model::CreateThemeData> {
        self.theme_to_create.as_ref()
    }
}
impl std::fmt::Debug for CreateThemeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThemeInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("client_token", &self.client_token);
        formatter.field("theme_to_create", &self.theme_to_create);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteThemeInput {
    /// <p>The unique ID of the Amplify app associated with the theme to delete.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the theme to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteThemeInput {
    /// <p>The unique ID of the Amplify app associated with the theme to delete.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique ID of the theme to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteThemeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteThemeInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThemeInput {
    /// <p>The unique ID for the Amplify app.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique ID for the theme.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The unique client token.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The configuration of the updated theme.</p>
    pub updated_theme: std::option::Option<crate::model::UpdateThemeData>,
}
impl UpdateThemeInput {
    /// <p>The unique ID for the Amplify app.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique ID for the theme.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The unique client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The configuration of the updated theme.</p>
    pub fn updated_theme(&self) -> std::option::Option<&crate::model::UpdateThemeData> {
        self.updated_theme.as_ref()
    }
}
impl std::fmt::Debug for UpdateThemeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThemeInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("id", &self.id);
        formatter.field("client_token", &self.client_token);
        formatter.field("updated_theme", &self.updated_theme);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetThemeInput {
    /// <p>The unique ID of the Amplify app.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique ID for the theme.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetThemeInput {
    /// <p>The unique ID of the Amplify app.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique ID for the theme.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetThemeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetThemeInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportComponentsInput {
    /// <p>The unique ID of the Amplify app to export components to.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ExportComponentsInput {
    /// <p>The unique ID of the Amplify app to export components to.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ExportComponentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportComponentsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentsInput {
    /// <p>The unique ID for the Amplify app.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of components to retrieve.</p>
    pub max_results: i32,
}
impl ListComponentsInput {
    /// <p>The unique ID for the Amplify app.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of components to retrieve.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListComponentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentInput {
    /// <p>The unique ID of the Amplify app to associate with the component.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique client token.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Represents the configuration of the component to create.</p>
    pub component_to_create: std::option::Option<crate::model::CreateComponentData>,
}
impl CreateComponentInput {
    /// <p>The unique ID of the Amplify app to associate with the component.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Represents the configuration of the component to create.</p>
    pub fn component_to_create(&self) -> std::option::Option<&crate::model::CreateComponentData> {
        self.component_to_create.as_ref()
    }
}
impl std::fmt::Debug for CreateComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("client_token", &self.client_token);
        formatter.field("component_to_create", &self.component_to_create);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentInput {
    /// <p>The unique ID of the Amplify app associated with the component to delete.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the component to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteComponentInput {
    /// <p>The unique ID of the Amplify app associated with the component to delete.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is a part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique ID of the component to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateComponentInput {
    /// <p>The unique ID for the Amplify app.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique ID for the component.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The unique client token.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The configuration of the updated component.</p>
    pub updated_component: std::option::Option<crate::model::UpdateComponentData>,
}
impl UpdateComponentInput {
    /// <p>The unique ID for the Amplify app.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique ID for the component.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The unique client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The configuration of the updated component.</p>
    pub fn updated_component(&self) -> std::option::Option<&crate::model::UpdateComponentData> {
        self.updated_component.as_ref()
    }
}
impl std::fmt::Debug for UpdateComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateComponentInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("id", &self.id);
        formatter.field("client_token", &self.client_token);
        formatter.field("updated_component", &self.updated_component);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentInput {
    /// <p>The unique ID of the Amplify app.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the component.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetComponentInput {
    /// <p>The unique ID of the Amplify app.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment that is part of the Amplify app.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The unique ID of the component.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshTokenInput {
    /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
    pub provider: std::option::Option<crate::model::TokenProviders>,
    /// <p>Information about the refresh token request.</p>
    pub refresh_token_body: std::option::Option<crate::model::RefreshTokenRequestBody>,
}
impl RefreshTokenInput {
    /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
    pub fn provider(&self) -> std::option::Option<&crate::model::TokenProviders> {
        self.provider.as_ref()
    }
    /// <p>Information about the refresh token request.</p>
    pub fn refresh_token_body(
        &self,
    ) -> std::option::Option<&crate::model::RefreshTokenRequestBody> {
        self.refresh_token_body.as_ref()
    }
}
impl std::fmt::Debug for RefreshTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshTokenInput");
        formatter.field("provider", &self.provider);
        formatter.field("refresh_token_body", &self.refresh_token_body);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExchangeCodeForTokenInput {
    /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
    pub provider: std::option::Option<crate::model::TokenProviders>,
    /// <p>Describes the configuration of the request.</p>
    pub request: std::option::Option<crate::model::ExchangeCodeForTokenRequestBody>,
}
impl ExchangeCodeForTokenInput {
    /// <p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>
    pub fn provider(&self) -> std::option::Option<&crate::model::TokenProviders> {
        self.provider.as_ref()
    }
    /// <p>Describes the configuration of the request.</p>
    pub fn request(&self) -> std::option::Option<&crate::model::ExchangeCodeForTokenRequestBody> {
        self.request.as_ref()
    }
}
impl std::fmt::Debug for ExchangeCodeForTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExchangeCodeForTokenInput");
        formatter.field("provider", &self.provider);
        formatter.field("request", &self.request);
        formatter.finish()
    }
}
