// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CloneBackendInput`](crate::input::CloneBackendInput)
pub mod clone_backend_input {
    /// A builder for [`CloneBackendInput`](crate::input::CloneBackendInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) target_environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The name of the destination backend environment to be created.</p>
        pub fn target_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the destination backend environment to be created.</p>
        pub fn set_target_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CloneBackendInput`](crate::input::CloneBackendInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CloneBackendInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CloneBackendInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                target_environment_name: self.target_environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CloneBackendInputOperationOutputAlias = crate::operation::CloneBackend;
#[doc(hidden)]
pub type CloneBackendInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CloneBackendInput {
    /// Consumes the builder and constructs an Operation<[`CloneBackend`](crate::operation::CloneBackend)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CloneBackend,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CloneBackendInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.app_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_1, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_2 = &_input.backend_environment_name;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_2, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/environments/{BackendEnvironmentName}/clone",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CloneBackendInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_clone_backend(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CloneBackend::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CloneBackend",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CloneBackendInput`](crate::input::CloneBackendInput)
    pub fn builder() -> crate::input::clone_backend_input::Builder {
        crate::input::clone_backend_input::Builder::default()
    }
}

/// See [`CreateBackendInput`](crate::input::CreateBackendInput)
pub mod create_backend_input {
    /// A builder for [`CreateBackendInput`](crate::input::CreateBackendInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) app_name: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_config: std::option::Option<crate::model::ResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the app.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_name = Some(input.into());
            self
        }
        /// <p>The name of the app.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_name = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The resource configuration for creating backend storage.</p>
        pub fn resource_config(mut self, input: crate::model::ResourceConfig) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>The resource configuration for creating backend storage.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::ResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendInput`](crate::input::CreateBackendInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackendInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackendInput {
                app_id: self.app_id,
                app_name: self.app_name,
                backend_environment_name: self.backend_environment_name,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackendInputOperationOutputAlias = crate::operation::CreateBackend;
#[doc(hidden)]
pub type CreateBackendInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBackendInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackend`](crate::operation::CreateBackend)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackend,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBackendInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/backend").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBackendInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_backend(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackend::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackend",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBackendInput`](crate::input::CreateBackendInput)
    pub fn builder() -> crate::input::create_backend_input::Builder {
        crate::input::create_backend_input::Builder::default()
    }
}

/// See [`CreateBackendApiInput`](crate::input::CreateBackendApiInput)
pub mod create_backend_api_input {
    /// A builder for [`CreateBackendApiInput`](crate::input::CreateBackendApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The resource configuration for this request.</p>
        pub fn resource_config(mut self, input: crate::model::BackendApiResourceConfig) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>The resource configuration for this request.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::BackendApiResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendApiInput`](crate::input::CreateBackendApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackendApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackendApiInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackendApiInputOperationOutputAlias = crate::operation::CreateBackendAPI;
#[doc(hidden)]
pub type CreateBackendApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBackendApiInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackendAPI`](crate::operation::CreateBackendAPI)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackendAPI,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBackendApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.app_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_3, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/backend/{AppId}/api", AppId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBackendApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_backend_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackendAPI::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackendAPI",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBackendApiInput`](crate::input::CreateBackendApiInput)
    pub fn builder() -> crate::input::create_backend_api_input::Builder {
        crate::input::create_backend_api_input::Builder::default()
    }
}

/// See [`CreateBackendAuthInput`](crate::input::CreateBackendAuthInput)
pub mod create_backend_auth_input {
    /// A builder for [`CreateBackendAuthInput`](crate::input::CreateBackendAuthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_config:
            std::option::Option<crate::model::CreateBackendAuthResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The resource configuration for this request object.</p>
        pub fn resource_config(
            mut self,
            input: crate::model::CreateBackendAuthResourceConfig,
        ) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>The resource configuration for this request object.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::CreateBackendAuthResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendAuthInput`](crate::input::CreateBackendAuthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackendAuthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackendAuthInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackendAuthInputOperationOutputAlias = crate::operation::CreateBackendAuth;
#[doc(hidden)]
pub type CreateBackendAuthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBackendAuthInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackendAuth`](crate::operation::CreateBackendAuth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackendAuth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBackendAuthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.app_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_4, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/backend/{AppId}/auth", AppId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBackendAuthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_backend_auth(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackendAuth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackendAuth",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthInput`](crate::input::CreateBackendAuthInput)
    pub fn builder() -> crate::input::create_backend_auth_input::Builder {
        crate::input::create_backend_auth_input::Builder::default()
    }
}

/// See [`CreateBackendConfigInput`](crate::input::CreateBackendConfigInput)
pub mod create_backend_config_input {
    /// A builder for [`CreateBackendConfigInput`](crate::input::CreateBackendConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_manager_app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The app ID for the backend manager.</p>
        pub fn backend_manager_app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_manager_app_id = Some(input.into());
            self
        }
        /// <p>The app ID for the backend manager.</p>
        pub fn set_backend_manager_app_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_manager_app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendConfigInput`](crate::input::CreateBackendConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackendConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackendConfigInput {
                app_id: self.app_id,
                backend_manager_app_id: self.backend_manager_app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackendConfigInputOperationOutputAlias = crate::operation::CreateBackendConfig;
#[doc(hidden)]
pub type CreateBackendConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBackendConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackendConfig`](crate::operation::CreateBackendConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackendConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBackendConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.app_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_5, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/backend/{AppId}/config", AppId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBackendConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_backend_config(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackendConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackendConfig",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBackendConfigInput`](crate::input::CreateBackendConfigInput)
    pub fn builder() -> crate::input::create_backend_config_input::Builder {
        crate::input::create_backend_config_input::Builder::default()
    }
}

/// See [`CreateBackendStorageInput`](crate::input::CreateBackendStorageInput)
pub mod create_backend_storage_input {
    /// A builder for [`CreateBackendStorageInput`](crate::input::CreateBackendStorageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_config:
            std::option::Option<crate::model::CreateBackendStorageResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The resource configuration for creating backend storage.</p>
        pub fn resource_config(
            mut self,
            input: crate::model::CreateBackendStorageResourceConfig,
        ) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>The resource configuration for creating backend storage.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::CreateBackendStorageResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendStorageInput`](crate::input::CreateBackendStorageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackendStorageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackendStorageInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackendStorageInputOperationOutputAlias = crate::operation::CreateBackendStorage;
#[doc(hidden)]
pub type CreateBackendStorageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBackendStorageInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackendStorage`](crate::operation::CreateBackendStorage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackendStorage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBackendStorageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.app_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_6, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/backend/{AppId}/storage", AppId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBackendStorageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_backend_storage(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackendStorage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackendStorage",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBackendStorageInput`](crate::input::CreateBackendStorageInput)
    pub fn builder() -> crate::input::create_backend_storage_input::Builder {
        crate::input::create_backend_storage_input::Builder::default()
    }
}

/// See [`CreateTokenInput`](crate::input::CreateTokenInput)
pub mod create_token_input {
    /// A builder for [`CreateTokenInput`](crate::input::CreateTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTokenInput`](crate::input::CreateTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTokenInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTokenInputOperationOutputAlias = crate::operation::CreateToken;
#[doc(hidden)]
pub type CreateTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTokenInput {
    /// Consumes the builder and constructs an Operation<[`CreateToken`](crate::operation::CreateToken)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateTokenInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.app_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_7, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/backend/{AppId}/challenge", AppId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateTokenInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateToken",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateTokenInput`](crate::input::CreateTokenInput)
    pub fn builder() -> crate::input::create_token_input::Builder {
        crate::input::create_token_input::Builder::default()
    }
}

/// See [`DeleteBackendInput`](crate::input::DeleteBackendInput)
pub mod delete_backend_input {
    /// A builder for [`DeleteBackendInput`](crate::input::DeleteBackendInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackendInput`](crate::input::DeleteBackendInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackendInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackendInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackendInputOperationOutputAlias = crate::operation::DeleteBackend;
#[doc(hidden)]
pub type DeleteBackendInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBackendInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackend`](crate::operation::DeleteBackend)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackend,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBackendInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.app_id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_8, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_9 = &_input.backend_environment_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_9, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/environments/{BackendEnvironmentName}/remove",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBackendInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackend::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackend",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackendInput`](crate::input::DeleteBackendInput)
    pub fn builder() -> crate::input::delete_backend_input::Builder {
        crate::input::delete_backend_input::Builder::default()
    }
}

/// See [`DeleteBackendApiInput`](crate::input::DeleteBackendApiInput)
pub mod delete_backend_api_input {
    /// A builder for [`DeleteBackendApiInput`](crate::input::DeleteBackendApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn resource_config(mut self, input: crate::model::BackendApiResourceConfig) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::BackendApiResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackendApiInput`](crate::input::DeleteBackendApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackendApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackendApiInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackendApiInputOperationOutputAlias = crate::operation::DeleteBackendAPI;
#[doc(hidden)]
pub type DeleteBackendApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBackendApiInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackendAPI`](crate::operation::DeleteBackendAPI)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackendAPI,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBackendApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.app_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_10, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_11 = &_input.backend_environment_name;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_11, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/api/{BackendEnvironmentName}/remove",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBackendApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_backend_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackendAPI::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackendAPI",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackendApiInput`](crate::input::DeleteBackendApiInput)
    pub fn builder() -> crate::input::delete_backend_api_input::Builder {
        crate::input::delete_backend_api_input::Builder::default()
    }
}

/// See [`DeleteBackendAuthInput`](crate::input::DeleteBackendAuthInput)
pub mod delete_backend_auth_input {
    /// A builder for [`DeleteBackendAuthInput`](crate::input::DeleteBackendAuthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackendAuthInput`](crate::input::DeleteBackendAuthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackendAuthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackendAuthInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackendAuthInputOperationOutputAlias = crate::operation::DeleteBackendAuth;
#[doc(hidden)]
pub type DeleteBackendAuthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBackendAuthInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackendAuth`](crate::operation::DeleteBackendAuth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackendAuth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBackendAuthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.app_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_12, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.backend_environment_name;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_13, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/auth/{BackendEnvironmentName}/remove",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBackendAuthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_backend_auth(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackendAuth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackendAuth",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackendAuthInput`](crate::input::DeleteBackendAuthInput)
    pub fn builder() -> crate::input::delete_backend_auth_input::Builder {
        crate::input::delete_backend_auth_input::Builder::default()
    }
}

/// See [`DeleteBackendStorageInput`](crate::input::DeleteBackendStorageInput)
pub mod delete_backend_storage_input {
    /// A builder for [`DeleteBackendStorageInput`](crate::input::DeleteBackendStorageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<crate::model::ServiceName>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The name of the storage service.</p>
        pub fn service_name(mut self, input: crate::model::ServiceName) -> Self {
            self.service_name = Some(input);
            self
        }
        /// <p>The name of the storage service.</p>
        pub fn set_service_name(
            mut self,
            input: std::option::Option<crate::model::ServiceName>,
        ) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackendStorageInput`](crate::input::DeleteBackendStorageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackendStorageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackendStorageInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_name: self.resource_name,
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackendStorageInputOperationOutputAlias = crate::operation::DeleteBackendStorage;
#[doc(hidden)]
pub type DeleteBackendStorageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBackendStorageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackendStorage`](crate::operation::DeleteBackendStorage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackendStorage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBackendStorageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.app_id;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_14, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_15 = &_input.backend_environment_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_15, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/storage/{BackendEnvironmentName}/remove",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBackendStorageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_backend_storage(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackendStorage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackendStorage",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackendStorageInput`](crate::input::DeleteBackendStorageInput)
    pub fn builder() -> crate::input::delete_backend_storage_input::Builder {
        crate::input::delete_backend_storage_input::Builder::default()
    }
}

/// See [`DeleteTokenInput`](crate::input::DeleteTokenInput)
pub mod delete_token_input {
    /// A builder for [`DeleteTokenInput`](crate::input::DeleteTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTokenInput`](crate::input::DeleteTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTokenInput {
                app_id: self.app_id,
                session_id: self.session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTokenInputOperationOutputAlias = crate::operation::DeleteToken;
#[doc(hidden)]
pub type DeleteTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTokenInput {
    /// Consumes the builder and constructs an Operation<[`DeleteToken`](crate::operation::DeleteToken)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTokenInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.app_id;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_16, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_17 = &_input.session_id;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let session_id = aws_smithy_http::label::fmt_string(input_17, false);
                if session_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/challenge/{SessionId}/remove",
                    AppId = app_id,
                    SessionId = session_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTokenInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteToken",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTokenInput`](crate::input::DeleteTokenInput)
    pub fn builder() -> crate::input::delete_token_input::Builder {
        crate::input::delete_token_input::Builder::default()
    }
}

/// See [`GenerateBackendApiModelsInput`](crate::input::GenerateBackendApiModelsInput)
pub mod generate_backend_api_models_input {
    /// A builder for [`GenerateBackendApiModelsInput`](crate::input::GenerateBackendApiModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateBackendApiModelsInput`](crate::input::GenerateBackendApiModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateBackendApiModelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateBackendApiModelsInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GenerateBackendApiModelsInputOperationOutputAlias =
    crate::operation::GenerateBackendAPIModels;
#[doc(hidden)]
pub type GenerateBackendApiModelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GenerateBackendApiModelsInput {
    /// Consumes the builder and constructs an Operation<[`GenerateBackendAPIModels`](crate::operation::GenerateBackendAPIModels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateBackendAPIModels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GenerateBackendApiModelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.app_id;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_18, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_19 = &_input.backend_environment_name;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_19, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/api/{BackendEnvironmentName}/generateModels",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GenerateBackendApiModelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_generate_backend_api_models(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateBackendAPIModels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateBackendAPIModels",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GenerateBackendApiModelsInput`](crate::input::GenerateBackendApiModelsInput)
    pub fn builder() -> crate::input::generate_backend_api_models_input::Builder {
        crate::input::generate_backend_api_models_input::Builder::default()
    }
}

/// See [`GetBackendInput`](crate::input::GetBackendInput)
pub mod get_backend_input {
    /// A builder for [`GetBackendInput`](crate::input::GetBackendInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendInput`](crate::input::GetBackendInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackendInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackendInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackendInputOperationOutputAlias = crate::operation::GetBackend;
#[doc(hidden)]
pub type GetBackendInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBackendInput {
    /// Consumes the builder and constructs an Operation<[`GetBackend`](crate::operation::GetBackend)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackend,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBackendInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.app_id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_20, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/backend/{AppId}/details", AppId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBackendInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_backend(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackend::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackend",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBackendInput`](crate::input::GetBackendInput)
    pub fn builder() -> crate::input::get_backend_input::Builder {
        crate::input::get_backend_input::Builder::default()
    }
}

/// See [`GetBackendApiInput`](crate::input::GetBackendApiInput)
pub mod get_backend_api_input {
    /// A builder for [`GetBackendApiInput`](crate::input::GetBackendApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn resource_config(mut self, input: crate::model::BackendApiResourceConfig) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::BackendApiResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendApiInput`](crate::input::GetBackendApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackendApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackendApiInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackendApiInputOperationOutputAlias = crate::operation::GetBackendAPI;
#[doc(hidden)]
pub type GetBackendApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBackendApiInput {
    /// Consumes the builder and constructs an Operation<[`GetBackendAPI`](crate::operation::GetBackendAPI)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackendAPI,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBackendApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.app_id;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_21, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_22 = &_input.backend_environment_name;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_22, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/api/{BackendEnvironmentName}/details",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBackendApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_backend_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackendAPI::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackendAPI",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBackendApiInput`](crate::input::GetBackendApiInput)
    pub fn builder() -> crate::input::get_backend_api_input::Builder {
        crate::input::get_backend_api_input::Builder::default()
    }
}

/// See [`GetBackendApiModelsInput`](crate::input::GetBackendApiModelsInput)
pub mod get_backend_api_models_input {
    /// A builder for [`GetBackendApiModelsInput`](crate::input::GetBackendApiModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendApiModelsInput`](crate::input::GetBackendApiModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackendApiModelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackendApiModelsInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackendApiModelsInputOperationOutputAlias = crate::operation::GetBackendAPIModels;
#[doc(hidden)]
pub type GetBackendApiModelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBackendApiModelsInput {
    /// Consumes the builder and constructs an Operation<[`GetBackendAPIModels`](crate::operation::GetBackendAPIModels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackendAPIModels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBackendApiModelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.app_id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_23, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_24 = &_input.backend_environment_name;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_24, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/api/{BackendEnvironmentName}/getModels",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBackendApiModelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_backend_api_models(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackendAPIModels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackendAPIModels",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBackendApiModelsInput`](crate::input::GetBackendApiModelsInput)
    pub fn builder() -> crate::input::get_backend_api_models_input::Builder {
        crate::input::get_backend_api_models_input::Builder::default()
    }
}

/// See [`GetBackendAuthInput`](crate::input::GetBackendAuthInput)
pub mod get_backend_auth_input {
    /// A builder for [`GetBackendAuthInput`](crate::input::GetBackendAuthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendAuthInput`](crate::input::GetBackendAuthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackendAuthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackendAuthInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackendAuthInputOperationOutputAlias = crate::operation::GetBackendAuth;
#[doc(hidden)]
pub type GetBackendAuthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBackendAuthInput {
    /// Consumes the builder and constructs an Operation<[`GetBackendAuth`](crate::operation::GetBackendAuth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackendAuth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBackendAuthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.app_id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_25, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_26 = &_input.backend_environment_name;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_26, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/auth/{BackendEnvironmentName}/details",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBackendAuthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_backend_auth(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackendAuth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackendAuth",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBackendAuthInput`](crate::input::GetBackendAuthInput)
    pub fn builder() -> crate::input::get_backend_auth_input::Builder {
        crate::input::get_backend_auth_input::Builder::default()
    }
}

/// See [`GetBackendJobInput`](crate::input::GetBackendJobInput)
pub mod get_backend_job_input {
    /// A builder for [`GetBackendJobInput`](crate::input::GetBackendJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendJobInput`](crate::input::GetBackendJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackendJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackendJobInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackendJobInputOperationOutputAlias = crate::operation::GetBackendJob;
#[doc(hidden)]
pub type GetBackendJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBackendJobInput {
    /// Consumes the builder and constructs an Operation<[`GetBackendJob`](crate::operation::GetBackendJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackendJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBackendJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.app_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_27, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_28 = &_input.backend_environment_name;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_28, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_29 = &_input.job_id;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_29, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/job/{BackendEnvironmentName}/{JobId}",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name,
                    JobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBackendJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackendJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackendJob",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBackendJobInput`](crate::input::GetBackendJobInput)
    pub fn builder() -> crate::input::get_backend_job_input::Builder {
        crate::input::get_backend_job_input::Builder::default()
    }
}

/// See [`GetBackendStorageInput`](crate::input::GetBackendStorageInput)
pub mod get_backend_storage_input {
    /// A builder for [`GetBackendStorageInput`](crate::input::GetBackendStorageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendStorageInput`](crate::input::GetBackendStorageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackendStorageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackendStorageInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackendStorageInputOperationOutputAlias = crate::operation::GetBackendStorage;
#[doc(hidden)]
pub type GetBackendStorageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBackendStorageInput {
    /// Consumes the builder and constructs an Operation<[`GetBackendStorage`](crate::operation::GetBackendStorage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackendStorage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBackendStorageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.app_id;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_30, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_31 = &_input.backend_environment_name;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_31, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/storage/{BackendEnvironmentName}/details",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBackendStorageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_backend_storage(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackendStorage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackendStorage",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBackendStorageInput`](crate::input::GetBackendStorageInput)
    pub fn builder() -> crate::input::get_backend_storage_input::Builder {
        crate::input::get_backend_storage_input::Builder::default()
    }
}

/// See [`GetTokenInput`](crate::input::GetTokenInput)
pub mod get_token_input {
    /// A builder for [`GetTokenInput`](crate::input::GetTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTokenInput`](crate::input::GetTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTokenInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTokenInput {
                app_id: self.app_id,
                session_id: self.session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTokenInputOperationOutputAlias = crate::operation::GetToken;
#[doc(hidden)]
pub type GetTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTokenInput {
    /// Consumes the builder and constructs an Operation<[`GetToken`](crate::operation::GetToken)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetTokenInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.app_id;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_32, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_33 = &_input.session_id;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let session_id = aws_smithy_http::label::fmt_string(input_33, false);
                if session_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/challenge/{SessionId}",
                    AppId = app_id,
                    SessionId = session_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetTokenInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetToken::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetToken",
                    "amplifybackend",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetTokenInput`](crate::input::GetTokenInput)
    pub fn builder() -> crate::input::get_token_input::Builder {
        crate::input::get_token_input::Builder::default()
    }
}

/// See [`ImportBackendAuthInput`](crate::input::ImportBackendAuthInput)
pub mod import_backend_auth_input {
    /// A builder for [`ImportBackendAuthInput`](crate::input::ImportBackendAuthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) native_client_id: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) web_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The ID of the Amazon Cognito identity pool.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito identity pool.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>The ID of the Amazon Cognito native client.</p>
        pub fn native_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.native_client_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito native client.</p>
        pub fn set_native_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.native_client_id = input;
            self
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The ID of the Amazon Cognito web client.</p>
        pub fn web_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_client_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito web client.</p>
        pub fn set_web_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.web_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportBackendAuthInput`](crate::input::ImportBackendAuthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportBackendAuthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportBackendAuthInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                identity_pool_id: self.identity_pool_id,
                native_client_id: self.native_client_id,
                user_pool_id: self.user_pool_id,
                web_client_id: self.web_client_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportBackendAuthInputOperationOutputAlias = crate::operation::ImportBackendAuth;
#[doc(hidden)]
pub type ImportBackendAuthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportBackendAuthInput {
    /// Consumes the builder and constructs an Operation<[`ImportBackendAuth`](crate::operation::ImportBackendAuth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportBackendAuth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ImportBackendAuthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_34 = &_input.app_id;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_34, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_35 = &_input.backend_environment_name;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_35, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/auth/{BackendEnvironmentName}/import",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ImportBackendAuthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_import_backend_auth(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportBackendAuth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportBackendAuth",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ImportBackendAuthInput`](crate::input::ImportBackendAuthInput)
    pub fn builder() -> crate::input::import_backend_auth_input::Builder {
        crate::input::import_backend_auth_input::Builder::default()
    }
}

/// See [`ImportBackendStorageInput`](crate::input::ImportBackendStorageInput)
pub mod import_backend_storage_input {
    /// A builder for [`ImportBackendStorageInput`](crate::input::ImportBackendStorageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<crate::model::ServiceName>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The name of the storage service.</p>
        pub fn service_name(mut self, input: crate::model::ServiceName) -> Self {
            self.service_name = Some(input);
            self
        }
        /// <p>The name of the storage service.</p>
        pub fn set_service_name(
            mut self,
            input: std::option::Option<crate::model::ServiceName>,
        ) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportBackendStorageInput`](crate::input::ImportBackendStorageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportBackendStorageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportBackendStorageInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                bucket_name: self.bucket_name,
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportBackendStorageInputOperationOutputAlias = crate::operation::ImportBackendStorage;
#[doc(hidden)]
pub type ImportBackendStorageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportBackendStorageInput {
    /// Consumes the builder and constructs an Operation<[`ImportBackendStorage`](crate::operation::ImportBackendStorage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportBackendStorage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ImportBackendStorageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.app_id;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_36, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_37 = &_input.backend_environment_name;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_37, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/storage/{BackendEnvironmentName}/import",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ImportBackendStorageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_import_backend_storage(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportBackendStorage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportBackendStorage",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ImportBackendStorageInput`](crate::input::ImportBackendStorageInput)
    pub fn builder() -> crate::input::import_backend_storage_input::Builder {
        crate::input::import_backend_storage_input::Builder::default()
    }
}

/// See [`ListBackendJobsInput`](crate::input::ListBackendJobsInput)
pub mod list_backend_jobs_input {
    /// A builder for [`ListBackendJobsInput`](crate::input::ListBackendJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The maximum number of results that you want in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that you want in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified status.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified status.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackendJobsInput`](crate::input::ListBackendJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBackendJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBackendJobsInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                job_id: self.job_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                operation: self.operation,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBackendJobsInputOperationOutputAlias = crate::operation::ListBackendJobs;
#[doc(hidden)]
pub type ListBackendJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBackendJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListBackendJobs`](crate::operation::ListBackendJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBackendJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBackendJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.app_id;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_38, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_39 = &_input.backend_environment_name;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_39, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/job/{BackendEnvironmentName}",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBackendJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_backend_jobs(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBackendJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBackendJobs",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBackendJobsInput`](crate::input::ListBackendJobsInput)
    pub fn builder() -> crate::input::list_backend_jobs_input::Builder {
        crate::input::list_backend_jobs_input::Builder::default()
    }
}

/// See [`ListS3BucketsInput`](crate::input::ListS3BucketsInput)
pub mod list_s3_buckets_input {
    /// A builder for [`ListS3BucketsInput`](crate::input::ListS3BucketsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListS3BucketsInput`](crate::input::ListS3BucketsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListS3BucketsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListS3BucketsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListS3BucketsInputOperationOutputAlias = crate::operation::ListS3Buckets;
#[doc(hidden)]
pub type ListS3BucketsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListS3BucketsInput {
    /// Consumes the builder and constructs an Operation<[`ListS3Buckets`](crate::operation::ListS3Buckets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListS3Buckets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListS3BucketsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/s3Buckets").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListS3BucketsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_s3_buckets(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListS3Buckets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListS3Buckets",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListS3BucketsInput`](crate::input::ListS3BucketsInput)
    pub fn builder() -> crate::input::list_s3_buckets_input::Builder {
        crate::input::list_s3_buckets_input::Builder::default()
    }
}

/// See [`RemoveAllBackendsInput`](crate::input::RemoveAllBackendsInput)
pub mod remove_all_backends_input {
    /// A builder for [`RemoveAllBackendsInput`](crate::input::RemoveAllBackendsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) clean_amplify_app: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>Cleans up the Amplify Console app if this value is set to true.</p>
        pub fn clean_amplify_app(mut self, input: bool) -> Self {
            self.clean_amplify_app = Some(input);
            self
        }
        /// <p>Cleans up the Amplify Console app if this value is set to true.</p>
        pub fn set_clean_amplify_app(mut self, input: std::option::Option<bool>) -> Self {
            self.clean_amplify_app = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAllBackendsInput`](crate::input::RemoveAllBackendsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveAllBackendsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveAllBackendsInput {
                app_id: self.app_id,
                clean_amplify_app: self.clean_amplify_app.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveAllBackendsInputOperationOutputAlias = crate::operation::RemoveAllBackends;
#[doc(hidden)]
pub type RemoveAllBackendsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveAllBackendsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveAllBackends`](crate::operation::RemoveAllBackends)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveAllBackends,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveAllBackendsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.app_id;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_40, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/backend/{AppId}/remove", AppId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveAllBackendsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_remove_all_backends(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveAllBackends::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveAllBackends",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveAllBackendsInput`](crate::input::RemoveAllBackendsInput)
    pub fn builder() -> crate::input::remove_all_backends_input::Builder {
        crate::input::remove_all_backends_input::Builder::default()
    }
}

/// See [`RemoveBackendConfigInput`](crate::input::RemoveBackendConfigInput)
pub mod remove_backend_config_input {
    /// A builder for [`RemoveBackendConfigInput`](crate::input::RemoveBackendConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveBackendConfigInput`](crate::input::RemoveBackendConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveBackendConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveBackendConfigInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveBackendConfigInputOperationOutputAlias = crate::operation::RemoveBackendConfig;
#[doc(hidden)]
pub type RemoveBackendConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveBackendConfigInput {
    /// Consumes the builder and constructs an Operation<[`RemoveBackendConfig`](crate::operation::RemoveBackendConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveBackendConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveBackendConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_41 = &_input.app_id;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_41, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/backend/{AppId}/config/remove", AppId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveBackendConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveBackendConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveBackendConfig",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveBackendConfigInput`](crate::input::RemoveBackendConfigInput)
    pub fn builder() -> crate::input::remove_backend_config_input::Builder {
        crate::input::remove_backend_config_input::Builder::default()
    }
}

/// See [`UpdateBackendApiInput`](crate::input::UpdateBackendApiInput)
pub mod update_backend_api_input {
    /// A builder for [`UpdateBackendApiInput`](crate::input::UpdateBackendApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn resource_config(mut self, input: crate::model::BackendApiResourceConfig) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::BackendApiResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendApiInput`](crate::input::UpdateBackendApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBackendApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBackendApiInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBackendApiInputOperationOutputAlias = crate::operation::UpdateBackendAPI;
#[doc(hidden)]
pub type UpdateBackendApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBackendApiInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBackendAPI`](crate::operation::UpdateBackendAPI)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBackendAPI,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateBackendApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_42 = &_input.app_id;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_42, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_43 = &_input.backend_environment_name;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_43, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/api/{BackendEnvironmentName}",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateBackendApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_backend_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBackendAPI::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBackendAPI",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateBackendApiInput`](crate::input::UpdateBackendApiInput)
    pub fn builder() -> crate::input::update_backend_api_input::Builder {
        crate::input::update_backend_api_input::Builder::default()
    }
}

/// See [`UpdateBackendAuthInput`](crate::input::UpdateBackendAuthInput)
pub mod update_backend_auth_input {
    /// A builder for [`UpdateBackendAuthInput`](crate::input::UpdateBackendAuthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_config:
            std::option::Option<crate::model::UpdateBackendAuthResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The resource configuration for this request object.</p>
        pub fn resource_config(
            mut self,
            input: crate::model::UpdateBackendAuthResourceConfig,
        ) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>The resource configuration for this request object.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendAuthResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendAuthInput`](crate::input::UpdateBackendAuthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBackendAuthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBackendAuthInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBackendAuthInputOperationOutputAlias = crate::operation::UpdateBackendAuth;
#[doc(hidden)]
pub type UpdateBackendAuthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBackendAuthInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBackendAuth`](crate::operation::UpdateBackendAuth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBackendAuth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateBackendAuthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.app_id;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_44, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_45 = &_input.backend_environment_name;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_45, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/auth/{BackendEnvironmentName}",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateBackendAuthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_backend_auth(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBackendAuth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBackendAuth",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthInput`](crate::input::UpdateBackendAuthInput)
    pub fn builder() -> crate::input::update_backend_auth_input::Builder {
        crate::input::update_backend_auth_input::Builder::default()
    }
}

/// See [`UpdateBackendConfigInput`](crate::input::UpdateBackendConfigInput)
pub mod update_backend_config_input {
    /// A builder for [`UpdateBackendConfigInput`](crate::input::UpdateBackendConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) login_auth_config: std::option::Option<crate::model::LoginAuthConfigReqObj>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>Describes the Amazon Cognito configuration for Admin UI access.</p>
        pub fn login_auth_config(mut self, input: crate::model::LoginAuthConfigReqObj) -> Self {
            self.login_auth_config = Some(input);
            self
        }
        /// <p>Describes the Amazon Cognito configuration for Admin UI access.</p>
        pub fn set_login_auth_config(
            mut self,
            input: std::option::Option<crate::model::LoginAuthConfigReqObj>,
        ) -> Self {
            self.login_auth_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendConfigInput`](crate::input::UpdateBackendConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBackendConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBackendConfigInput {
                app_id: self.app_id,
                login_auth_config: self.login_auth_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBackendConfigInputOperationOutputAlias = crate::operation::UpdateBackendConfig;
#[doc(hidden)]
pub type UpdateBackendConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBackendConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBackendConfig`](crate::operation::UpdateBackendConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBackendConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateBackendConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.app_id;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_46, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/backend/{AppId}/config/update", AppId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateBackendConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_backend_config(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBackendConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBackendConfig",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateBackendConfigInput`](crate::input::UpdateBackendConfigInput)
    pub fn builder() -> crate::input::update_backend_config_input::Builder {
        crate::input::update_backend_config_input::Builder::default()
    }
}

/// See [`UpdateBackendJobInput`](crate::input::UpdateBackendJobInput)
pub mod update_backend_job_input {
    /// A builder for [`UpdateBackendJobInput`](crate::input::UpdateBackendJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified status.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified status.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendJobInput`](crate::input::UpdateBackendJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBackendJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBackendJobInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBackendJobInputOperationOutputAlias = crate::operation::UpdateBackendJob;
#[doc(hidden)]
pub type UpdateBackendJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBackendJobInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBackendJob`](crate::operation::UpdateBackendJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBackendJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateBackendJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_47 = &_input.app_id;
                let input_47 = input_47.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_47, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_48 = &_input.backend_environment_name;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_48, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_49 = &_input.job_id;
                let input_49 = input_49.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_49, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/job/{BackendEnvironmentName}/{JobId}",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name,
                    JobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateBackendJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_backend_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBackendJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBackendJob",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateBackendJobInput`](crate::input::UpdateBackendJobInput)
    pub fn builder() -> crate::input::update_backend_job_input::Builder {
        crate::input::update_backend_job_input::Builder::default()
    }
}

/// See [`UpdateBackendStorageInput`](crate::input::UpdateBackendStorageInput)
pub mod update_backend_storage_input {
    /// A builder for [`UpdateBackendStorageInput`](crate::input::UpdateBackendStorageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) resource_config:
            std::option::Option<crate::model::UpdateBackendStorageResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The resource configuration for updating backend storage.</p>
        pub fn resource_config(
            mut self,
            input: crate::model::UpdateBackendStorageResourceConfig,
        ) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>The resource configuration for updating backend storage.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendStorageResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendStorageInput`](crate::input::UpdateBackendStorageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBackendStorageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBackendStorageInput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBackendStorageInputOperationOutputAlias = crate::operation::UpdateBackendStorage;
#[doc(hidden)]
pub type UpdateBackendStorageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBackendStorageInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBackendStorage`](crate::operation::UpdateBackendStorage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBackendStorage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateBackendStorageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_50 = &_input.app_id;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_50, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_51 = &_input.backend_environment_name;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let backend_environment_name = aws_smithy_http::label::fmt_string(input_51, false);
                if backend_environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backend_environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/backend/{AppId}/storage/{BackendEnvironmentName}",
                    AppId = app_id,
                    BackendEnvironmentName = backend_environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateBackendStorageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_backend_storage(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBackendStorage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBackendStorage",
            "amplifybackend",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateBackendStorageInput`](crate::input::UpdateBackendStorageInput)
    pub fn builder() -> crate::input::update_backend_storage_input::Builder {
        crate::input::update_backend_storage_input::Builder::default()
    }
}

/// <p>The request body for UpdateBackendStorage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendStorageInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The resource configuration for updating backend storage.</p>
    pub resource_config: std::option::Option<crate::model::UpdateBackendStorageResourceConfig>,
    /// <p>The name of the storage resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl UpdateBackendStorageInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The resource configuration for updating backend storage.</p>
    pub fn resource_config(
        &self,
    ) -> std::option::Option<&crate::model::UpdateBackendStorageResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>The name of the storage resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateBackendStorageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendStorageInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for GetBackendJob.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendJobInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>Filters the list of response objects to include only those with the specified status.</p>
    pub status: std::option::Option<std::string::String>,
}
impl UpdateBackendJobInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The ID for the job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
    pub fn operation(&self) -> std::option::Option<&str> {
        self.operation.as_deref()
    }
    /// <p>Filters the list of response objects to include only those with the specified status.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for UpdateBackendJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendJobInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

/// <p>The request body for UpdateBackendConfig.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendConfigInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>Describes the Amazon Cognito configuration for Admin UI access.</p>
    pub login_auth_config: std::option::Option<crate::model::LoginAuthConfigReqObj>,
}
impl UpdateBackendConfigInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>Describes the Amazon Cognito configuration for Admin UI access.</p>
    pub fn login_auth_config(&self) -> std::option::Option<&crate::model::LoginAuthConfigReqObj> {
        self.login_auth_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateBackendConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendConfigInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("login_auth_config", &self.login_auth_config);
        formatter.finish()
    }
}

/// <p>The request body for UpdateBackendAuth.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendAuthInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The resource configuration for this request object.</p>
    pub resource_config: std::option::Option<crate::model::UpdateBackendAuthResourceConfig>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl UpdateBackendAuthInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The resource configuration for this request object.</p>
    pub fn resource_config(
        &self,
    ) -> std::option::Option<&crate::model::UpdateBackendAuthResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateBackendAuthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendAuthInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for UpdateBackendAPI.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendApiInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
    pub resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl UpdateBackendApiInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
    pub fn resource_config(&self) -> std::option::Option<&crate::model::BackendApiResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateBackendApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendApiInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveBackendConfigInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl RemoveBackendConfigInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveBackendConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveBackendConfigInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

/// <p>The request body for RemoveAllBackends.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAllBackendsInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>Cleans up the Amplify Console app if this value is set to true.</p>
    pub clean_amplify_app: bool,
}
impl RemoveAllBackendsInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>Cleans up the Amplify Console app if this value is set to true.</p>
    pub fn clean_amplify_app(&self) -> bool {
        self.clean_amplify_app
    }
}
impl std::fmt::Debug for RemoveAllBackendsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAllBackendsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("clean_amplify_app", &self.clean_amplify_app);
        formatter.finish()
    }
}

/// <p>The request body for S3Buckets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListS3BucketsInput {
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListS3BucketsInput {
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListS3BucketsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListS3BucketsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The request body for ListBackendJobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackendJobsInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that you want in the response.</p>
    pub max_results: i32,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>Filters the list of response objects to include only those with the specified status.</p>
    pub status: std::option::Option<std::string::String>,
}
impl ListBackendJobsInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The ID for the job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The maximum number of results that you want in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
    pub fn operation(&self) -> std::option::Option<&str> {
        self.operation.as_deref()
    }
    /// <p>Filters the list of response objects to include only those with the specified status.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for ListBackendJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackendJobsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("job_id", &self.job_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

/// <p>The request body for ImportBackendStorage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportBackendStorageInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The name of the S3 bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The name of the storage service.</p>
    pub service_name: std::option::Option<crate::model::ServiceName>,
}
impl ImportBackendStorageInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The name of the S3 bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The name of the storage service.</p>
    pub fn service_name(&self) -> std::option::Option<&crate::model::ServiceName> {
        self.service_name.as_ref()
    }
}
impl std::fmt::Debug for ImportBackendStorageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportBackendStorageInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}

/// <p>The request body for ImportBackendAuth.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportBackendAuthInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Cognito identity pool.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Cognito native client.</p>
    pub native_client_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Cognito user pool.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Cognito web client.</p>
    pub web_client_id: std::option::Option<std::string::String>,
}
impl ImportBackendAuthInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The ID of the Amazon Cognito identity pool.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>The ID of the Amazon Cognito native client.</p>
    pub fn native_client_id(&self) -> std::option::Option<&str> {
        self.native_client_id.as_deref()
    }
    /// <p>The ID of the Amazon Cognito user pool.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The ID of the Amazon Cognito web client.</p>
    pub fn web_client_id(&self) -> std::option::Option<&str> {
        self.web_client_id.as_deref()
    }
}
impl std::fmt::Debug for ImportBackendAuthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportBackendAuthInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("native_client_id", &self.native_client_id);
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("web_client_id", &self.web_client_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTokenInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The session ID.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl GetTokenInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The session ID.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
}
impl std::fmt::Debug for GetTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTokenInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}

/// <p>The request body for GetBackendStorage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendStorageInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The name of the storage resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl GetBackendStorageInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The name of the storage resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for GetBackendStorageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendStorageInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendJobInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetBackendJobInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The ID for the job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetBackendJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendJobInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

/// <p>The request body for GetBackendAuth.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendAuthInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl GetBackendAuthInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for GetBackendAuthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendAuthInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for GetBackendAPIModels.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendApiModelsInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl GetBackendApiModelsInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for GetBackendApiModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendApiModelsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for GetBackendAPI.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendApiInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
    pub resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl GetBackendApiInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
    pub fn resource_config(&self) -> std::option::Option<&crate::model::BackendApiResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for GetBackendApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendApiInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for GetBackend.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
}
impl GetBackendInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
}
impl std::fmt::Debug for GetBackendInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.finish()
    }
}

/// <p>The request body for GenerateBackendAPIModels.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateBackendApiModelsInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl GenerateBackendApiModelsInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for GenerateBackendApiModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateBackendApiModelsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTokenInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The session ID.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl DeleteTokenInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The session ID.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTokenInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}

/// <p>The request body for DeleteBackendStorage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackendStorageInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The name of the storage resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The name of the storage service.</p>
    pub service_name: std::option::Option<crate::model::ServiceName>,
}
impl DeleteBackendStorageInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The name of the storage resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The name of the storage service.</p>
    pub fn service_name(&self) -> std::option::Option<&crate::model::ServiceName> {
        self.service_name.as_ref()
    }
}
impl std::fmt::Debug for DeleteBackendStorageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackendStorageInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}

/// <p>The request body for DeleteBackendAuth.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackendAuthInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl DeleteBackendAuthInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackendAuthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackendAuthInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for DeleteBackendAPI.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackendApiInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
    pub resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl DeleteBackendApiInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
    pub fn resource_config(&self) -> std::option::Option<&crate::model::BackendApiResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackendApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackendApiInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackendInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
}
impl DeleteBackendInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackendInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackendInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTokenInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl CreateTokenInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for CreateTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTokenInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

/// <p>The request body for CreateBackendStorage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendStorageInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The resource configuration for creating backend storage.</p>
    pub resource_config: std::option::Option<crate::model::CreateBackendStorageResourceConfig>,
    /// <p>The name of the storage resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl CreateBackendStorageInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The resource configuration for creating backend storage.</p>
    pub fn resource_config(
        &self,
    ) -> std::option::Option<&crate::model::CreateBackendStorageResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>The name of the storage resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for CreateBackendStorageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendStorageInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for CreateBackendConfig.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendConfigInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The app ID for the backend manager.</p>
    pub backend_manager_app_id: std::option::Option<std::string::String>,
}
impl CreateBackendConfigInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The app ID for the backend manager.</p>
    pub fn backend_manager_app_id(&self) -> std::option::Option<&str> {
        self.backend_manager_app_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBackendConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendConfigInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_manager_app_id", &self.backend_manager_app_id);
        formatter.finish()
    }
}

/// <p>The request body for CreateBackendAuth.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendAuthInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The resource configuration for this request object.</p>
    pub resource_config: std::option::Option<crate::model::CreateBackendAuthResourceConfig>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl CreateBackendAuthInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The resource configuration for this request object.</p>
    pub fn resource_config(
        &self,
    ) -> std::option::Option<&crate::model::CreateBackendAuthResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for CreateBackendAuthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendAuthInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for CreateBackendAPI.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendApiInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The resource configuration for this request.</p>
    pub resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl CreateBackendApiInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The resource configuration for this request.</p>
    pub fn resource_config(&self) -> std::option::Option<&crate::model::BackendApiResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>The name of this resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for CreateBackendApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendApiInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for CreateBackend.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the app.</p>
    pub app_name: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The resource configuration for creating backend storage.</p>
    pub resource_config: std::option::Option<crate::model::ResourceConfig>,
    /// <p>The name of the resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl CreateBackendInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the app.</p>
    pub fn app_name(&self) -> std::option::Option<&str> {
        self.app_name.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The resource configuration for creating backend storage.</p>
    pub fn resource_config(&self) -> std::option::Option<&crate::model::ResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>The name of the resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for CreateBackendInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("app_name", &self.app_name);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The request body for CloneBackend.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloneBackendInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The name of the destination backend environment to be created.</p>
    pub target_environment_name: std::option::Option<std::string::String>,
}
impl CloneBackendInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the backend environment.</p>
    pub fn backend_environment_name(&self) -> std::option::Option<&str> {
        self.backend_environment_name.as_deref()
    }
    /// <p>The name of the destination backend environment to be created.</p>
    pub fn target_environment_name(&self) -> std::option::Option<&str> {
        self.target_environment_name.as_deref()
    }
}
impl std::fmt::Debug for CloneBackendInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloneBackendInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("target_environment_name", &self.target_environment_name);
        formatter.finish()
    }
}
