// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AmplifyBackend
///
/// Client for invoking operations on AmplifyBackend. Each operation on AmplifyBackend is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_amplifybackend::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_amplifybackend::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_amplifybackend::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CloneBackend` operation.
    ///
    /// See [`CloneBackend`](crate::client::fluent_builders::CloneBackend) for more information about the
    /// operation and its arguments.
    pub fn clone_backend(&self) -> fluent_builders::CloneBackend<C, M, R> {
        fluent_builders::CloneBackend::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBackend` operation.
    ///
    /// See [`CreateBackend`](crate::client::fluent_builders::CreateBackend) for more information about the
    /// operation and its arguments.
    pub fn create_backend(&self) -> fluent_builders::CreateBackend<C, M, R> {
        fluent_builders::CreateBackend::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBackendAPI` operation.
    ///
    /// See [`CreateBackendAPI`](crate::client::fluent_builders::CreateBackendAPI) for more information about the
    /// operation and its arguments.
    pub fn create_backend_api(&self) -> fluent_builders::CreateBackendAPI<C, M, R> {
        fluent_builders::CreateBackendAPI::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBackendAuth` operation.
    ///
    /// See [`CreateBackendAuth`](crate::client::fluent_builders::CreateBackendAuth) for more information about the
    /// operation and its arguments.
    pub fn create_backend_auth(&self) -> fluent_builders::CreateBackendAuth<C, M, R> {
        fluent_builders::CreateBackendAuth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBackendConfig` operation.
    ///
    /// See [`CreateBackendConfig`](crate::client::fluent_builders::CreateBackendConfig) for more information about the
    /// operation and its arguments.
    pub fn create_backend_config(&self) -> fluent_builders::CreateBackendConfig<C, M, R> {
        fluent_builders::CreateBackendConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBackendStorage` operation.
    ///
    /// See [`CreateBackendStorage`](crate::client::fluent_builders::CreateBackendStorage) for more information about the
    /// operation and its arguments.
    pub fn create_backend_storage(&self) -> fluent_builders::CreateBackendStorage<C, M, R> {
        fluent_builders::CreateBackendStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateToken` operation.
    ///
    /// See [`CreateToken`](crate::client::fluent_builders::CreateToken) for more information about the
    /// operation and its arguments.
    pub fn create_token(&self) -> fluent_builders::CreateToken<C, M, R> {
        fluent_builders::CreateToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackend` operation.
    ///
    /// See [`DeleteBackend`](crate::client::fluent_builders::DeleteBackend) for more information about the
    /// operation and its arguments.
    pub fn delete_backend(&self) -> fluent_builders::DeleteBackend<C, M, R> {
        fluent_builders::DeleteBackend::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackendAPI` operation.
    ///
    /// See [`DeleteBackendAPI`](crate::client::fluent_builders::DeleteBackendAPI) for more information about the
    /// operation and its arguments.
    pub fn delete_backend_api(&self) -> fluent_builders::DeleteBackendAPI<C, M, R> {
        fluent_builders::DeleteBackendAPI::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackendAuth` operation.
    ///
    /// See [`DeleteBackendAuth`](crate::client::fluent_builders::DeleteBackendAuth) for more information about the
    /// operation and its arguments.
    pub fn delete_backend_auth(&self) -> fluent_builders::DeleteBackendAuth<C, M, R> {
        fluent_builders::DeleteBackendAuth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackendStorage` operation.
    ///
    /// See [`DeleteBackendStorage`](crate::client::fluent_builders::DeleteBackendStorage) for more information about the
    /// operation and its arguments.
    pub fn delete_backend_storage(&self) -> fluent_builders::DeleteBackendStorage<C, M, R> {
        fluent_builders::DeleteBackendStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteToken` operation.
    ///
    /// See [`DeleteToken`](crate::client::fluent_builders::DeleteToken) for more information about the
    /// operation and its arguments.
    pub fn delete_token(&self) -> fluent_builders::DeleteToken<C, M, R> {
        fluent_builders::DeleteToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateBackendAPIModels` operation.
    ///
    /// See [`GenerateBackendAPIModels`](crate::client::fluent_builders::GenerateBackendAPIModels) for more information about the
    /// operation and its arguments.
    pub fn generate_backend_api_models(
        &self,
    ) -> fluent_builders::GenerateBackendAPIModels<C, M, R> {
        fluent_builders::GenerateBackendAPIModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackend` operation.
    ///
    /// See [`GetBackend`](crate::client::fluent_builders::GetBackend) for more information about the
    /// operation and its arguments.
    pub fn get_backend(&self) -> fluent_builders::GetBackend<C, M, R> {
        fluent_builders::GetBackend::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackendAPI` operation.
    ///
    /// See [`GetBackendAPI`](crate::client::fluent_builders::GetBackendAPI) for more information about the
    /// operation and its arguments.
    pub fn get_backend_api(&self) -> fluent_builders::GetBackendAPI<C, M, R> {
        fluent_builders::GetBackendAPI::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackendAPIModels` operation.
    ///
    /// See [`GetBackendAPIModels`](crate::client::fluent_builders::GetBackendAPIModels) for more information about the
    /// operation and its arguments.
    pub fn get_backend_api_models(&self) -> fluent_builders::GetBackendAPIModels<C, M, R> {
        fluent_builders::GetBackendAPIModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackendAuth` operation.
    ///
    /// See [`GetBackendAuth`](crate::client::fluent_builders::GetBackendAuth) for more information about the
    /// operation and its arguments.
    pub fn get_backend_auth(&self) -> fluent_builders::GetBackendAuth<C, M, R> {
        fluent_builders::GetBackendAuth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackendJob` operation.
    ///
    /// See [`GetBackendJob`](crate::client::fluent_builders::GetBackendJob) for more information about the
    /// operation and its arguments.
    pub fn get_backend_job(&self) -> fluent_builders::GetBackendJob<C, M, R> {
        fluent_builders::GetBackendJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackendStorage` operation.
    ///
    /// See [`GetBackendStorage`](crate::client::fluent_builders::GetBackendStorage) for more information about the
    /// operation and its arguments.
    pub fn get_backend_storage(&self) -> fluent_builders::GetBackendStorage<C, M, R> {
        fluent_builders::GetBackendStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetToken` operation.
    ///
    /// See [`GetToken`](crate::client::fluent_builders::GetToken) for more information about the
    /// operation and its arguments.
    pub fn get_token(&self) -> fluent_builders::GetToken<C, M, R> {
        fluent_builders::GetToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportBackendAuth` operation.
    ///
    /// See [`ImportBackendAuth`](crate::client::fluent_builders::ImportBackendAuth) for more information about the
    /// operation and its arguments.
    pub fn import_backend_auth(&self) -> fluent_builders::ImportBackendAuth<C, M, R> {
        fluent_builders::ImportBackendAuth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportBackendStorage` operation.
    ///
    /// See [`ImportBackendStorage`](crate::client::fluent_builders::ImportBackendStorage) for more information about the
    /// operation and its arguments.
    pub fn import_backend_storage(&self) -> fluent_builders::ImportBackendStorage<C, M, R> {
        fluent_builders::ImportBackendStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBackendJobs` operation.
    ///
    /// See [`ListBackendJobs`](crate::client::fluent_builders::ListBackendJobs) for more information about the
    /// operation and its arguments.
    pub fn list_backend_jobs(&self) -> fluent_builders::ListBackendJobs<C, M, R> {
        fluent_builders::ListBackendJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListS3Buckets` operation.
    ///
    /// See [`ListS3Buckets`](crate::client::fluent_builders::ListS3Buckets) for more information about the
    /// operation and its arguments.
    pub fn list_s3_buckets(&self) -> fluent_builders::ListS3Buckets<C, M, R> {
        fluent_builders::ListS3Buckets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveAllBackends` operation.
    ///
    /// See [`RemoveAllBackends`](crate::client::fluent_builders::RemoveAllBackends) for more information about the
    /// operation and its arguments.
    pub fn remove_all_backends(&self) -> fluent_builders::RemoveAllBackends<C, M, R> {
        fluent_builders::RemoveAllBackends::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveBackendConfig` operation.
    ///
    /// See [`RemoveBackendConfig`](crate::client::fluent_builders::RemoveBackendConfig) for more information about the
    /// operation and its arguments.
    pub fn remove_backend_config(&self) -> fluent_builders::RemoveBackendConfig<C, M, R> {
        fluent_builders::RemoveBackendConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBackendAPI` operation.
    ///
    /// See [`UpdateBackendAPI`](crate::client::fluent_builders::UpdateBackendAPI) for more information about the
    /// operation and its arguments.
    pub fn update_backend_api(&self) -> fluent_builders::UpdateBackendAPI<C, M, R> {
        fluent_builders::UpdateBackendAPI::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBackendAuth` operation.
    ///
    /// See [`UpdateBackendAuth`](crate::client::fluent_builders::UpdateBackendAuth) for more information about the
    /// operation and its arguments.
    pub fn update_backend_auth(&self) -> fluent_builders::UpdateBackendAuth<C, M, R> {
        fluent_builders::UpdateBackendAuth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBackendConfig` operation.
    ///
    /// See [`UpdateBackendConfig`](crate::client::fluent_builders::UpdateBackendConfig) for more information about the
    /// operation and its arguments.
    pub fn update_backend_config(&self) -> fluent_builders::UpdateBackendConfig<C, M, R> {
        fluent_builders::UpdateBackendConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBackendJob` operation.
    ///
    /// See [`UpdateBackendJob`](crate::client::fluent_builders::UpdateBackendJob) for more information about the
    /// operation and its arguments.
    pub fn update_backend_job(&self) -> fluent_builders::UpdateBackendJob<C, M, R> {
        fluent_builders::UpdateBackendJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBackendStorage` operation.
    ///
    /// See [`UpdateBackendStorage`](crate::client::fluent_builders::UpdateBackendStorage) for more information about the
    /// operation and its arguments.
    pub fn update_backend_storage(&self) -> fluent_builders::UpdateBackendStorage<C, M, R> {
        fluent_builders::UpdateBackendStorage::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CloneBackend`.
    ///
    /// <p>This operation clones an existing backend.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CloneBackend<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::clone_backend_input::Builder,
    }
    impl<C, M, R> CloneBackend<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CloneBackend`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CloneBackendOutput,
            aws_smithy_http::result::SdkError<crate::error::CloneBackendError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CloneBackendInputOperationOutputAlias,
                crate::output::CloneBackendOutput,
                crate::error::CloneBackendError,
                crate::input::CloneBackendInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The name of the destination backend environment to be created.</p>
        pub fn target_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_environment_name(input.into());
            self
        }
        /// <p>The name of the destination backend environment to be created.</p>
        pub fn set_target_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackend`.
    ///
    /// <p>This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBackend<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backend_input::Builder,
    }
    impl<C, M, R> CreateBackend<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackend`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackendOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackendError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackendInputOperationOutputAlias,
                crate::output::CreateBackendOutput,
                crate::error::CreateBackendError,
                crate::input::CreateBackendInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the app.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_name(input.into());
            self
        }
        /// <p>The name of the app.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_name(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The resource configuration for creating backend storage.</p>
        pub fn resource_config(mut self, input: crate::model::ResourceConfig) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>The resource configuration for creating backend storage.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::ResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>The name of the resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackendAPI`.
    ///
    /// <p>Creates a new backend API resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBackendAPI<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backend_api_input::Builder,
    }
    impl<C, M, R> CreateBackendAPI<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackendAPI`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackendApiOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackendAPIError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackendApiInputOperationOutputAlias,
                crate::output::CreateBackendApiOutput,
                crate::error::CreateBackendAPIError,
                crate::input::CreateBackendApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The resource configuration for this request.</p>
        pub fn resource_config(mut self, input: crate::model::BackendApiResourceConfig) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>The resource configuration for this request.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::BackendApiResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackendAuth`.
    ///
    /// <p>Creates a new backend authentication resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBackendAuth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backend_auth_input::Builder,
    }
    impl<C, M, R> CreateBackendAuth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackendAuth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackendAuthOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackendAuthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackendAuthInputOperationOutputAlias,
                crate::output::CreateBackendAuthOutput,
                crate::error::CreateBackendAuthError,
                crate::input::CreateBackendAuthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The resource configuration for this request object.</p>
        pub fn resource_config(
            mut self,
            input: crate::model::CreateBackendAuthResourceConfig,
        ) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>The resource configuration for this request object.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::CreateBackendAuthResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackendConfig`.
    ///
    /// <p>Creates a config object for a backend.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBackendConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backend_config_input::Builder,
    }
    impl<C, M, R> CreateBackendConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackendConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackendConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackendConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackendConfigInputOperationOutputAlias,
                crate::output::CreateBackendConfigOutput,
                crate::error::CreateBackendConfigError,
                crate::input::CreateBackendConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The app ID for the backend manager.</p>
        pub fn backend_manager_app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_manager_app_id(input.into());
            self
        }
        /// <p>The app ID for the backend manager.</p>
        pub fn set_backend_manager_app_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_manager_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackendStorage`.
    ///
    /// <p>Creates a backend storage resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBackendStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backend_storage_input::Builder,
    }
    impl<C, M, R> CreateBackendStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackendStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackendStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackendStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackendStorageInputOperationOutputAlias,
                crate::output::CreateBackendStorageOutput,
                crate::error::CreateBackendStorageError,
                crate::input::CreateBackendStorageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The resource configuration for creating backend storage.</p>
        pub fn resource_config(
            mut self,
            input: crate::model::CreateBackendStorageResourceConfig,
        ) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>The resource configuration for creating backend storage.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::CreateBackendStorageResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateToken`.
    ///
    /// <p>Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_token_input::Builder,
    }
    impl<C, M, R> CreateToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTokenInputOperationOutputAlias,
                crate::output::CreateTokenOutput,
                crate::error::CreateTokenError,
                crate::input::CreateTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackend`.
    ///
    /// <p>Removes an existing environment from your Amplify project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBackend<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backend_input::Builder,
    }
    impl<C, M, R> DeleteBackend<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackend`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackendOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackendError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackendInputOperationOutputAlias,
                crate::output::DeleteBackendOutput,
                crate::error::DeleteBackendError,
                crate::input::DeleteBackendInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackendAPI`.
    ///
    /// <p>Deletes an existing backend API resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBackendAPI<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backend_api_input::Builder,
    }
    impl<C, M, R> DeleteBackendAPI<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackendAPI`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackendApiOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackendAPIError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackendApiInputOperationOutputAlias,
                crate::output::DeleteBackendApiOutput,
                crate::error::DeleteBackendAPIError,
                crate::input::DeleteBackendApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn resource_config(mut self, input: crate::model::BackendApiResourceConfig) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::BackendApiResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackendAuth`.
    ///
    /// <p>Deletes an existing backend authentication resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBackendAuth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backend_auth_input::Builder,
    }
    impl<C, M, R> DeleteBackendAuth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackendAuth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackendAuthOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackendAuthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackendAuthInputOperationOutputAlias,
                crate::output::DeleteBackendAuthOutput,
                crate::error::DeleteBackendAuthError,
                crate::input::DeleteBackendAuthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackendStorage`.
    ///
    /// <p>Removes the specified backend storage resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBackendStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backend_storage_input::Builder,
    }
    impl<C, M, R> DeleteBackendStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackendStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackendStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackendStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackendStorageInputOperationOutputAlias,
                crate::output::DeleteBackendStorageOutput,
                crate::error::DeleteBackendStorageError,
                crate::input::DeleteBackendStorageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The name of the storage service.</p>
        pub fn service_name(mut self, input: crate::model::ServiceName) -> Self {
            self.inner = self.inner.service_name(input);
            self
        }
        /// <p>The name of the storage service.</p>
        pub fn set_service_name(
            mut self,
            input: std::option::Option<crate::model::ServiceName>,
        ) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteToken`.
    ///
    /// <p>Deletes the challenge token based on the given appId and sessionId.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_token_input::Builder,
    }
    impl<C, M, R> DeleteToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTokenInputOperationOutputAlias,
                crate::output::DeleteTokenOutput,
                crate::error::DeleteTokenError,
                crate::input::DeleteTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateBackendAPIModels`.
    ///
    /// <p>Generates a model schema for an existing backend API resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateBackendAPIModels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_backend_api_models_input::Builder,
    }
    impl<C, M, R> GenerateBackendAPIModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateBackendAPIModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateBackendApiModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateBackendAPIModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateBackendApiModelsInputOperationOutputAlias,
                crate::output::GenerateBackendApiModelsOutput,
                crate::error::GenerateBackendAPIModelsError,
                crate::input::GenerateBackendApiModelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackend`.
    ///
    /// <p>Provides project-level details for your Amplify UI project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBackend<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backend_input::Builder,
    }
    impl<C, M, R> GetBackend<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackend`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackendOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackendError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackendInputOperationOutputAlias,
                crate::output::GetBackendOutput,
                crate::error::GetBackendError,
                crate::input::GetBackendInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackendAPI`.
    ///
    /// <p>Gets the details for a backend API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBackendAPI<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backend_api_input::Builder,
    }
    impl<C, M, R> GetBackendAPI<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackendAPI`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackendApiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackendAPIError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackendApiInputOperationOutputAlias,
                crate::output::GetBackendApiOutput,
                crate::error::GetBackendAPIError,
                crate::input::GetBackendApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn resource_config(mut self, input: crate::model::BackendApiResourceConfig) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::BackendApiResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackendAPIModels`.
    ///
    /// <p>Generates a model schema for existing backend API resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBackendAPIModels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backend_api_models_input::Builder,
    }
    impl<C, M, R> GetBackendAPIModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackendAPIModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackendApiModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackendAPIModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackendApiModelsInputOperationOutputAlias,
                crate::output::GetBackendApiModelsOutput,
                crate::error::GetBackendAPIModelsError,
                crate::input::GetBackendApiModelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackendAuth`.
    ///
    /// <p>Gets a backend auth details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBackendAuth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backend_auth_input::Builder,
    }
    impl<C, M, R> GetBackendAuth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackendAuth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackendAuthOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackendAuthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackendAuthInputOperationOutputAlias,
                crate::output::GetBackendAuthOutput,
                crate::error::GetBackendAuthError,
                crate::input::GetBackendAuthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackendJob`.
    ///
    /// <p>Returns information about a specific job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBackendJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backend_job_input::Builder,
    }
    impl<C, M, R> GetBackendJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackendJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackendJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackendJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackendJobInputOperationOutputAlias,
                crate::output::GetBackendJobOutput,
                crate::error::GetBackendJobError,
                crate::input::GetBackendJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackendStorage`.
    ///
    /// <p>Gets details for a backend storage resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBackendStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backend_storage_input::Builder,
    }
    impl<C, M, R> GetBackendStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackendStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackendStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackendStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackendStorageInputOperationOutputAlias,
                crate::output::GetBackendStorageOutput,
                crate::error::GetBackendStorageError,
                crate::input::GetBackendStorageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetToken`.
    ///
    /// <p>Gets the challenge token based on the given appId and sessionId.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_token_input::Builder,
    }
    impl<C, M, R> GetToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTokenInputOperationOutputAlias,
                crate::output::GetTokenOutput,
                crate::error::GetTokenError,
                crate::input::GetTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportBackendAuth`.
    ///
    /// <p>Imports an existing backend authentication resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportBackendAuth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_backend_auth_input::Builder,
    }
    impl<C, M, R> ImportBackendAuth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportBackendAuth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportBackendAuthOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportBackendAuthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportBackendAuthInputOperationOutputAlias,
                crate::output::ImportBackendAuthOutput,
                crate::error::ImportBackendAuthError,
                crate::input::ImportBackendAuthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The ID of the Amazon Cognito identity pool.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito identity pool.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>The ID of the Amazon Cognito native client.</p>
        pub fn native_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.native_client_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito native client.</p>
        pub fn set_native_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_native_client_id(input);
            self
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The ID of the Amazon Cognito web client.</p>
        pub fn web_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_client_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito web client.</p>
        pub fn set_web_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_web_client_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportBackendStorage`.
    ///
    /// <p>Imports an existing backend storage resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportBackendStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_backend_storage_input::Builder,
    }
    impl<C, M, R> ImportBackendStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportBackendStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportBackendStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportBackendStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportBackendStorageInputOperationOutputAlias,
                crate::output::ImportBackendStorageOutput,
                crate::error::ImportBackendStorageError,
                crate::input::ImportBackendStorageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(input.into());
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>The name of the storage service.</p>
        pub fn service_name(mut self, input: crate::model::ServiceName) -> Self {
            self.inner = self.inner.service_name(input);
            self
        }
        /// <p>The name of the storage service.</p>
        pub fn set_service_name(
            mut self,
            input: std::option::Option<crate::model::ServiceName>,
        ) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackendJobs`.
    ///
    /// <p>Lists the jobs for the backend of an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBackendJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_backend_jobs_input::Builder,
    }
    impl<C, M, R> ListBackendJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBackendJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackendJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackendJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBackendJobsInputOperationOutputAlias,
                crate::output::ListBackendJobsOutput,
                crate::error::ListBackendJobsError,
                crate::input::ListBackendJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of results that you want in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation(input.into());
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation(input);
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified status.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified status.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListS3Buckets`.
    ///
    /// <p>The list of S3 buckets in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListS3Buckets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_s3_buckets_input::Builder,
    }
    impl<C, M, R> ListS3Buckets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListS3Buckets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListS3BucketsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListS3BucketsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListS3BucketsInputOperationOutputAlias,
                crate::output::ListS3BucketsOutput,
                crate::error::ListS3BucketsError,
                crate::input::ListS3BucketsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAllBackends`.
    ///
    /// <p>Removes all backend environments from your Amplify project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveAllBackends<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_all_backends_input::Builder,
    }
    impl<C, M, R> RemoveAllBackends<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveAllBackends`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAllBackendsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAllBackendsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveAllBackendsInputOperationOutputAlias,
                crate::output::RemoveAllBackendsOutput,
                crate::error::RemoveAllBackendsError,
                crate::input::RemoveAllBackendsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>Cleans up the Amplify Console app if this value is set to true.</p>
        pub fn clean_amplify_app(mut self, input: bool) -> Self {
            self.inner = self.inner.clean_amplify_app(input);
            self
        }
        /// <p>Cleans up the Amplify Console app if this value is set to true.</p>
        pub fn set_clean_amplify_app(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_clean_amplify_app(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveBackendConfig`.
    ///
    /// <p>Removes the AWS resources required to access the Amplify Admin UI.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveBackendConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_backend_config_input::Builder,
    }
    impl<C, M, R> RemoveBackendConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveBackendConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveBackendConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveBackendConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveBackendConfigInputOperationOutputAlias,
                crate::output::RemoveBackendConfigOutput,
                crate::error::RemoveBackendConfigError,
                crate::input::RemoveBackendConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBackendAPI`.
    ///
    /// <p>Updates an existing backend API resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBackendAPI<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_backend_api_input::Builder,
    }
    impl<C, M, R> UpdateBackendAPI<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBackendAPI`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBackendApiOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBackendAPIError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBackendApiInputOperationOutputAlias,
                crate::output::UpdateBackendApiOutput,
                crate::error::UpdateBackendAPIError,
                crate::input::UpdateBackendApiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn resource_config(mut self, input: crate::model::BackendApiResourceConfig) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>Defines the resource configuration for the data model in your Amplify project.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::BackendApiResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBackendAuth`.
    ///
    /// <p>Updates an existing backend authentication resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBackendAuth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_backend_auth_input::Builder,
    }
    impl<C, M, R> UpdateBackendAuth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBackendAuth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBackendAuthOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBackendAuthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBackendAuthInputOperationOutputAlias,
                crate::output::UpdateBackendAuthOutput,
                crate::error::UpdateBackendAuthError,
                crate::input::UpdateBackendAuthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The resource configuration for this request object.</p>
        pub fn resource_config(
            mut self,
            input: crate::model::UpdateBackendAuthResourceConfig,
        ) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>The resource configuration for this request object.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendAuthResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBackendConfig`.
    ///
    /// <p>Updates the AWS resources required to access the Amplify Admin UI.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBackendConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_backend_config_input::Builder,
    }
    impl<C, M, R> UpdateBackendConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBackendConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBackendConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBackendConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBackendConfigInputOperationOutputAlias,
                crate::output::UpdateBackendConfigOutput,
                crate::error::UpdateBackendConfigError,
                crate::input::UpdateBackendConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>Describes the Amazon Cognito configuration for Admin UI access.</p>
        pub fn login_auth_config(mut self, input: crate::model::LoginAuthConfigReqObj) -> Self {
            self.inner = self.inner.login_auth_config(input);
            self
        }
        /// <p>Describes the Amazon Cognito configuration for Admin UI access.</p>
        pub fn set_login_auth_config(
            mut self,
            input: std::option::Option<crate::model::LoginAuthConfigReqObj>,
        ) -> Self {
            self.inner = self.inner.set_login_auth_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBackendJob`.
    ///
    /// <p>Updates a specific job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBackendJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_backend_job_input::Builder,
    }
    impl<C, M, R> UpdateBackendJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBackendJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBackendJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBackendJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBackendJobInputOperationOutputAlias,
                crate::output::UpdateBackendJobOutput,
                crate::error::UpdateBackendJobError,
                crate::input::UpdateBackendJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation(input.into());
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified operation name.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation(input);
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified status.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>Filters the list of response objects to include only those with the specified status.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBackendStorage`.
    ///
    /// <p>Updates an existing backend storage resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBackendStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_backend_storage_input::Builder,
    }
    impl<C, M, R> UpdateBackendStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBackendStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBackendStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBackendStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBackendStorageInputOperationOutputAlias,
                crate::output::UpdateBackendStorageOutput,
                crate::error::UpdateBackendStorageError,
                crate::input::UpdateBackendStorageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_name(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_name(input);
            self
        }
        /// <p>The resource configuration for updating backend storage.</p>
        pub fn resource_config(
            mut self,
            input: crate::model::UpdateBackendStorageResourceConfig,
        ) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>The resource configuration for updating backend storage.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendStorageResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of the storage resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
