// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CloneBackend`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`clone_backend`](crate::client::Client::clone_backend).
///
/// See [`crate::client::fluent_builders::CloneBackend`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CloneBackend {
    _private: (),
}
impl CloneBackend {
    /// Creates a new builder-style object to manufacture [`CloneBackendInput`](crate::input::CloneBackendInput)
    pub fn builder() -> crate::input::clone_backend_input::Builder {
        crate::input::clone_backend_input::Builder::default()
    }
    /// Creates a new `CloneBackend` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CloneBackend {
    type Output =
        std::result::Result<crate::output::CloneBackendOutput, crate::error::CloneBackendError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_clone_backend_error(response)
        } else {
            crate::operation_deser::parse_clone_backend_response(response)
        }
    }
}

/// Operation shape for `CreateBackend`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backend`](crate::client::Client::create_backend).
///
/// See [`crate::client::fluent_builders::CreateBackend`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackend {
    _private: (),
}
impl CreateBackend {
    /// Creates a new builder-style object to manufacture [`CreateBackendInput`](crate::input::CreateBackendInput)
    pub fn builder() -> crate::input::create_backend_input::Builder {
        crate::input::create_backend_input::Builder::default()
    }
    /// Creates a new `CreateBackend` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackend {
    type Output =
        std::result::Result<crate::output::CreateBackendOutput, crate::error::CreateBackendError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backend_error(response)
        } else {
            crate::operation_deser::parse_create_backend_response(response)
        }
    }
}

/// Operation shape for `CreateBackendAPI`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backend_api`](crate::client::Client::create_backend_api).
///
/// See [`crate::client::fluent_builders::CreateBackendAPI`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackendAPI {
    _private: (),
}
impl CreateBackendAPI {
    /// Creates a new builder-style object to manufacture [`CreateBackendApiInput`](crate::input::CreateBackendApiInput)
    pub fn builder() -> crate::input::create_backend_api_input::Builder {
        crate::input::create_backend_api_input::Builder::default()
    }
    /// Creates a new `CreateBackendAPI` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackendAPI {
    type Output = std::result::Result<
        crate::output::CreateBackendApiOutput,
        crate::error::CreateBackendAPIError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backend_api_error(response)
        } else {
            crate::operation_deser::parse_create_backend_api_response(response)
        }
    }
}

/// Operation shape for `CreateBackendAuth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backend_auth`](crate::client::Client::create_backend_auth).
///
/// See [`crate::client::fluent_builders::CreateBackendAuth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackendAuth {
    _private: (),
}
impl CreateBackendAuth {
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthInput`](crate::input::CreateBackendAuthInput)
    pub fn builder() -> crate::input::create_backend_auth_input::Builder {
        crate::input::create_backend_auth_input::Builder::default()
    }
    /// Creates a new `CreateBackendAuth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackendAuth {
    type Output = std::result::Result<
        crate::output::CreateBackendAuthOutput,
        crate::error::CreateBackendAuthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backend_auth_error(response)
        } else {
            crate::operation_deser::parse_create_backend_auth_response(response)
        }
    }
}

/// Operation shape for `CreateBackendConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backend_config`](crate::client::Client::create_backend_config).
///
/// See [`crate::client::fluent_builders::CreateBackendConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackendConfig {
    _private: (),
}
impl CreateBackendConfig {
    /// Creates a new builder-style object to manufacture [`CreateBackendConfigInput`](crate::input::CreateBackendConfigInput)
    pub fn builder() -> crate::input::create_backend_config_input::Builder {
        crate::input::create_backend_config_input::Builder::default()
    }
    /// Creates a new `CreateBackendConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackendConfig {
    type Output = std::result::Result<
        crate::output::CreateBackendConfigOutput,
        crate::error::CreateBackendConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backend_config_error(response)
        } else {
            crate::operation_deser::parse_create_backend_config_response(response)
        }
    }
}

/// Operation shape for `CreateBackendStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backend_storage`](crate::client::Client::create_backend_storage).
///
/// See [`crate::client::fluent_builders::CreateBackendStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackendStorage {
    _private: (),
}
impl CreateBackendStorage {
    /// Creates a new builder-style object to manufacture [`CreateBackendStorageInput`](crate::input::CreateBackendStorageInput)
    pub fn builder() -> crate::input::create_backend_storage_input::Builder {
        crate::input::create_backend_storage_input::Builder::default()
    }
    /// Creates a new `CreateBackendStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackendStorage {
    type Output = std::result::Result<
        crate::output::CreateBackendStorageOutput,
        crate::error::CreateBackendStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backend_storage_error(response)
        } else {
            crate::operation_deser::parse_create_backend_storage_response(response)
        }
    }
}

/// Operation shape for `CreateToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_token`](crate::client::Client::create_token).
///
/// See [`crate::client::fluent_builders::CreateToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateToken {
    _private: (),
}
impl CreateToken {
    /// Creates a new builder-style object to manufacture [`CreateTokenInput`](crate::input::CreateTokenInput)
    pub fn builder() -> crate::input::create_token_input::Builder {
        crate::input::create_token_input::Builder::default()
    }
    /// Creates a new `CreateToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateToken {
    type Output =
        std::result::Result<crate::output::CreateTokenOutput, crate::error::CreateTokenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_token_error(response)
        } else {
            crate::operation_deser::parse_create_token_response(response)
        }
    }
}

/// Operation shape for `DeleteBackend`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backend`](crate::client::Client::delete_backend).
///
/// See [`crate::client::fluent_builders::DeleteBackend`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackend {
    _private: (),
}
impl DeleteBackend {
    /// Creates a new builder-style object to manufacture [`DeleteBackendInput`](crate::input::DeleteBackendInput)
    pub fn builder() -> crate::input::delete_backend_input::Builder {
        crate::input::delete_backend_input::Builder::default()
    }
    /// Creates a new `DeleteBackend` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackend {
    type Output =
        std::result::Result<crate::output::DeleteBackendOutput, crate::error::DeleteBackendError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backend_error(response)
        } else {
            crate::operation_deser::parse_delete_backend_response(response)
        }
    }
}

/// Operation shape for `DeleteBackendAPI`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backend_api`](crate::client::Client::delete_backend_api).
///
/// See [`crate::client::fluent_builders::DeleteBackendAPI`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackendAPI {
    _private: (),
}
impl DeleteBackendAPI {
    /// Creates a new builder-style object to manufacture [`DeleteBackendApiInput`](crate::input::DeleteBackendApiInput)
    pub fn builder() -> crate::input::delete_backend_api_input::Builder {
        crate::input::delete_backend_api_input::Builder::default()
    }
    /// Creates a new `DeleteBackendAPI` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackendAPI {
    type Output = std::result::Result<
        crate::output::DeleteBackendApiOutput,
        crate::error::DeleteBackendAPIError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backend_api_error(response)
        } else {
            crate::operation_deser::parse_delete_backend_api_response(response)
        }
    }
}

/// Operation shape for `DeleteBackendAuth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backend_auth`](crate::client::Client::delete_backend_auth).
///
/// See [`crate::client::fluent_builders::DeleteBackendAuth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackendAuth {
    _private: (),
}
impl DeleteBackendAuth {
    /// Creates a new builder-style object to manufacture [`DeleteBackendAuthInput`](crate::input::DeleteBackendAuthInput)
    pub fn builder() -> crate::input::delete_backend_auth_input::Builder {
        crate::input::delete_backend_auth_input::Builder::default()
    }
    /// Creates a new `DeleteBackendAuth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackendAuth {
    type Output = std::result::Result<
        crate::output::DeleteBackendAuthOutput,
        crate::error::DeleteBackendAuthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backend_auth_error(response)
        } else {
            crate::operation_deser::parse_delete_backend_auth_response(response)
        }
    }
}

/// Operation shape for `DeleteBackendStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backend_storage`](crate::client::Client::delete_backend_storage).
///
/// See [`crate::client::fluent_builders::DeleteBackendStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackendStorage {
    _private: (),
}
impl DeleteBackendStorage {
    /// Creates a new builder-style object to manufacture [`DeleteBackendStorageInput`](crate::input::DeleteBackendStorageInput)
    pub fn builder() -> crate::input::delete_backend_storage_input::Builder {
        crate::input::delete_backend_storage_input::Builder::default()
    }
    /// Creates a new `DeleteBackendStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackendStorage {
    type Output = std::result::Result<
        crate::output::DeleteBackendStorageOutput,
        crate::error::DeleteBackendStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backend_storage_error(response)
        } else {
            crate::operation_deser::parse_delete_backend_storage_response(response)
        }
    }
}

/// Operation shape for `DeleteToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_token`](crate::client::Client::delete_token).
///
/// See [`crate::client::fluent_builders::DeleteToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteToken {
    _private: (),
}
impl DeleteToken {
    /// Creates a new builder-style object to manufacture [`DeleteTokenInput`](crate::input::DeleteTokenInput)
    pub fn builder() -> crate::input::delete_token_input::Builder {
        crate::input::delete_token_input::Builder::default()
    }
    /// Creates a new `DeleteToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteToken {
    type Output =
        std::result::Result<crate::output::DeleteTokenOutput, crate::error::DeleteTokenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_token_error(response)
        } else {
            crate::operation_deser::parse_delete_token_response(response)
        }
    }
}

/// Operation shape for `GenerateBackendAPIModels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_backend_api_models`](crate::client::Client::generate_backend_api_models).
///
/// See [`crate::client::fluent_builders::GenerateBackendAPIModels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateBackendAPIModels {
    _private: (),
}
impl GenerateBackendAPIModels {
    /// Creates a new builder-style object to manufacture [`GenerateBackendApiModelsInput`](crate::input::GenerateBackendApiModelsInput)
    pub fn builder() -> crate::input::generate_backend_api_models_input::Builder {
        crate::input::generate_backend_api_models_input::Builder::default()
    }
    /// Creates a new `GenerateBackendAPIModels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateBackendAPIModels {
    type Output = std::result::Result<
        crate::output::GenerateBackendApiModelsOutput,
        crate::error::GenerateBackendAPIModelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_backend_api_models_error(response)
        } else {
            crate::operation_deser::parse_generate_backend_api_models_response(response)
        }
    }
}

/// Operation shape for `GetBackend`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backend`](crate::client::Client::get_backend).
///
/// See [`crate::client::fluent_builders::GetBackend`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackend {
    _private: (),
}
impl GetBackend {
    /// Creates a new builder-style object to manufacture [`GetBackendInput`](crate::input::GetBackendInput)
    pub fn builder() -> crate::input::get_backend_input::Builder {
        crate::input::get_backend_input::Builder::default()
    }
    /// Creates a new `GetBackend` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackend {
    type Output =
        std::result::Result<crate::output::GetBackendOutput, crate::error::GetBackendError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backend_error(response)
        } else {
            crate::operation_deser::parse_get_backend_response(response)
        }
    }
}

/// Operation shape for `GetBackendAPI`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backend_api`](crate::client::Client::get_backend_api).
///
/// See [`crate::client::fluent_builders::GetBackendAPI`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackendAPI {
    _private: (),
}
impl GetBackendAPI {
    /// Creates a new builder-style object to manufacture [`GetBackendApiInput`](crate::input::GetBackendApiInput)
    pub fn builder() -> crate::input::get_backend_api_input::Builder {
        crate::input::get_backend_api_input::Builder::default()
    }
    /// Creates a new `GetBackendAPI` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackendAPI {
    type Output =
        std::result::Result<crate::output::GetBackendApiOutput, crate::error::GetBackendAPIError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backend_api_error(response)
        } else {
            crate::operation_deser::parse_get_backend_api_response(response)
        }
    }
}

/// Operation shape for `GetBackendAPIModels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backend_api_models`](crate::client::Client::get_backend_api_models).
///
/// See [`crate::client::fluent_builders::GetBackendAPIModels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackendAPIModels {
    _private: (),
}
impl GetBackendAPIModels {
    /// Creates a new builder-style object to manufacture [`GetBackendApiModelsInput`](crate::input::GetBackendApiModelsInput)
    pub fn builder() -> crate::input::get_backend_api_models_input::Builder {
        crate::input::get_backend_api_models_input::Builder::default()
    }
    /// Creates a new `GetBackendAPIModels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackendAPIModels {
    type Output = std::result::Result<
        crate::output::GetBackendApiModelsOutput,
        crate::error::GetBackendAPIModelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backend_api_models_error(response)
        } else {
            crate::operation_deser::parse_get_backend_api_models_response(response)
        }
    }
}

/// Operation shape for `GetBackendAuth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backend_auth`](crate::client::Client::get_backend_auth).
///
/// See [`crate::client::fluent_builders::GetBackendAuth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackendAuth {
    _private: (),
}
impl GetBackendAuth {
    /// Creates a new builder-style object to manufacture [`GetBackendAuthInput`](crate::input::GetBackendAuthInput)
    pub fn builder() -> crate::input::get_backend_auth_input::Builder {
        crate::input::get_backend_auth_input::Builder::default()
    }
    /// Creates a new `GetBackendAuth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackendAuth {
    type Output =
        std::result::Result<crate::output::GetBackendAuthOutput, crate::error::GetBackendAuthError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backend_auth_error(response)
        } else {
            crate::operation_deser::parse_get_backend_auth_response(response)
        }
    }
}

/// Operation shape for `GetBackendJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backend_job`](crate::client::Client::get_backend_job).
///
/// See [`crate::client::fluent_builders::GetBackendJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackendJob {
    _private: (),
}
impl GetBackendJob {
    /// Creates a new builder-style object to manufacture [`GetBackendJobInput`](crate::input::GetBackendJobInput)
    pub fn builder() -> crate::input::get_backend_job_input::Builder {
        crate::input::get_backend_job_input::Builder::default()
    }
    /// Creates a new `GetBackendJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackendJob {
    type Output =
        std::result::Result<crate::output::GetBackendJobOutput, crate::error::GetBackendJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backend_job_error(response)
        } else {
            crate::operation_deser::parse_get_backend_job_response(response)
        }
    }
}

/// Operation shape for `GetBackendStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backend_storage`](crate::client::Client::get_backend_storage).
///
/// See [`crate::client::fluent_builders::GetBackendStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackendStorage {
    _private: (),
}
impl GetBackendStorage {
    /// Creates a new builder-style object to manufacture [`GetBackendStorageInput`](crate::input::GetBackendStorageInput)
    pub fn builder() -> crate::input::get_backend_storage_input::Builder {
        crate::input::get_backend_storage_input::Builder::default()
    }
    /// Creates a new `GetBackendStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackendStorage {
    type Output = std::result::Result<
        crate::output::GetBackendStorageOutput,
        crate::error::GetBackendStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backend_storage_error(response)
        } else {
            crate::operation_deser::parse_get_backend_storage_response(response)
        }
    }
}

/// Operation shape for `GetToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_token`](crate::client::Client::get_token).
///
/// See [`crate::client::fluent_builders::GetToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetToken {
    _private: (),
}
impl GetToken {
    /// Creates a new builder-style object to manufacture [`GetTokenInput`](crate::input::GetTokenInput)
    pub fn builder() -> crate::input::get_token_input::Builder {
        crate::input::get_token_input::Builder::default()
    }
    /// Creates a new `GetToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetToken {
    type Output = std::result::Result<crate::output::GetTokenOutput, crate::error::GetTokenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_token_error(response)
        } else {
            crate::operation_deser::parse_get_token_response(response)
        }
    }
}

/// Operation shape for `ImportBackendAuth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_backend_auth`](crate::client::Client::import_backend_auth).
///
/// See [`crate::client::fluent_builders::ImportBackendAuth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportBackendAuth {
    _private: (),
}
impl ImportBackendAuth {
    /// Creates a new builder-style object to manufacture [`ImportBackendAuthInput`](crate::input::ImportBackendAuthInput)
    pub fn builder() -> crate::input::import_backend_auth_input::Builder {
        crate::input::import_backend_auth_input::Builder::default()
    }
    /// Creates a new `ImportBackendAuth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportBackendAuth {
    type Output = std::result::Result<
        crate::output::ImportBackendAuthOutput,
        crate::error::ImportBackendAuthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_backend_auth_error(response)
        } else {
            crate::operation_deser::parse_import_backend_auth_response(response)
        }
    }
}

/// Operation shape for `ImportBackendStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_backend_storage`](crate::client::Client::import_backend_storage).
///
/// See [`crate::client::fluent_builders::ImportBackendStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportBackendStorage {
    _private: (),
}
impl ImportBackendStorage {
    /// Creates a new builder-style object to manufacture [`ImportBackendStorageInput`](crate::input::ImportBackendStorageInput)
    pub fn builder() -> crate::input::import_backend_storage_input::Builder {
        crate::input::import_backend_storage_input::Builder::default()
    }
    /// Creates a new `ImportBackendStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportBackendStorage {
    type Output = std::result::Result<
        crate::output::ImportBackendStorageOutput,
        crate::error::ImportBackendStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_backend_storage_error(response)
        } else {
            crate::operation_deser::parse_import_backend_storage_response(response)
        }
    }
}

/// Operation shape for `ListBackendJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_backend_jobs`](crate::client::Client::list_backend_jobs).
///
/// See [`crate::client::fluent_builders::ListBackendJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBackendJobs {
    _private: (),
}
impl ListBackendJobs {
    /// Creates a new builder-style object to manufacture [`ListBackendJobsInput`](crate::input::ListBackendJobsInput)
    pub fn builder() -> crate::input::list_backend_jobs_input::Builder {
        crate::input::list_backend_jobs_input::Builder::default()
    }
    /// Creates a new `ListBackendJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBackendJobs {
    type Output = std::result::Result<
        crate::output::ListBackendJobsOutput,
        crate::error::ListBackendJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_backend_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_backend_jobs_response(response)
        }
    }
}

/// Operation shape for `ListS3Buckets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_s3_buckets`](crate::client::Client::list_s3_buckets).
///
/// See [`crate::client::fluent_builders::ListS3Buckets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListS3Buckets {
    _private: (),
}
impl ListS3Buckets {
    /// Creates a new builder-style object to manufacture [`ListS3BucketsInput`](crate::input::ListS3BucketsInput)
    pub fn builder() -> crate::input::list_s3_buckets_input::Builder {
        crate::input::list_s3_buckets_input::Builder::default()
    }
    /// Creates a new `ListS3Buckets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListS3Buckets {
    type Output =
        std::result::Result<crate::output::ListS3BucketsOutput, crate::error::ListS3BucketsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_s3_buckets_error(response)
        } else {
            crate::operation_deser::parse_list_s3_buckets_response(response)
        }
    }
}

/// Operation shape for `RemoveAllBackends`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_all_backends`](crate::client::Client::remove_all_backends).
///
/// See [`crate::client::fluent_builders::RemoveAllBackends`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveAllBackends {
    _private: (),
}
impl RemoveAllBackends {
    /// Creates a new builder-style object to manufacture [`RemoveAllBackendsInput`](crate::input::RemoveAllBackendsInput)
    pub fn builder() -> crate::input::remove_all_backends_input::Builder {
        crate::input::remove_all_backends_input::Builder::default()
    }
    /// Creates a new `RemoveAllBackends` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveAllBackends {
    type Output = std::result::Result<
        crate::output::RemoveAllBackendsOutput,
        crate::error::RemoveAllBackendsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_all_backends_error(response)
        } else {
            crate::operation_deser::parse_remove_all_backends_response(response)
        }
    }
}

/// Operation shape for `RemoveBackendConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_backend_config`](crate::client::Client::remove_backend_config).
///
/// See [`crate::client::fluent_builders::RemoveBackendConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveBackendConfig {
    _private: (),
}
impl RemoveBackendConfig {
    /// Creates a new builder-style object to manufacture [`RemoveBackendConfigInput`](crate::input::RemoveBackendConfigInput)
    pub fn builder() -> crate::input::remove_backend_config_input::Builder {
        crate::input::remove_backend_config_input::Builder::default()
    }
    /// Creates a new `RemoveBackendConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveBackendConfig {
    type Output = std::result::Result<
        crate::output::RemoveBackendConfigOutput,
        crate::error::RemoveBackendConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_backend_config_error(response)
        } else {
            crate::operation_deser::parse_remove_backend_config_response(response)
        }
    }
}

/// Operation shape for `UpdateBackendAPI`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_backend_api`](crate::client::Client::update_backend_api).
///
/// See [`crate::client::fluent_builders::UpdateBackendAPI`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBackendAPI {
    _private: (),
}
impl UpdateBackendAPI {
    /// Creates a new builder-style object to manufacture [`UpdateBackendApiInput`](crate::input::UpdateBackendApiInput)
    pub fn builder() -> crate::input::update_backend_api_input::Builder {
        crate::input::update_backend_api_input::Builder::default()
    }
    /// Creates a new `UpdateBackendAPI` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBackendAPI {
    type Output = std::result::Result<
        crate::output::UpdateBackendApiOutput,
        crate::error::UpdateBackendAPIError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_backend_api_error(response)
        } else {
            crate::operation_deser::parse_update_backend_api_response(response)
        }
    }
}

/// Operation shape for `UpdateBackendAuth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_backend_auth`](crate::client::Client::update_backend_auth).
///
/// See [`crate::client::fluent_builders::UpdateBackendAuth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBackendAuth {
    _private: (),
}
impl UpdateBackendAuth {
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthInput`](crate::input::UpdateBackendAuthInput)
    pub fn builder() -> crate::input::update_backend_auth_input::Builder {
        crate::input::update_backend_auth_input::Builder::default()
    }
    /// Creates a new `UpdateBackendAuth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBackendAuth {
    type Output = std::result::Result<
        crate::output::UpdateBackendAuthOutput,
        crate::error::UpdateBackendAuthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_backend_auth_error(response)
        } else {
            crate::operation_deser::parse_update_backend_auth_response(response)
        }
    }
}

/// Operation shape for `UpdateBackendConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_backend_config`](crate::client::Client::update_backend_config).
///
/// See [`crate::client::fluent_builders::UpdateBackendConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBackendConfig {
    _private: (),
}
impl UpdateBackendConfig {
    /// Creates a new builder-style object to manufacture [`UpdateBackendConfigInput`](crate::input::UpdateBackendConfigInput)
    pub fn builder() -> crate::input::update_backend_config_input::Builder {
        crate::input::update_backend_config_input::Builder::default()
    }
    /// Creates a new `UpdateBackendConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBackendConfig {
    type Output = std::result::Result<
        crate::output::UpdateBackendConfigOutput,
        crate::error::UpdateBackendConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_backend_config_error(response)
        } else {
            crate::operation_deser::parse_update_backend_config_response(response)
        }
    }
}

/// Operation shape for `UpdateBackendJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_backend_job`](crate::client::Client::update_backend_job).
///
/// See [`crate::client::fluent_builders::UpdateBackendJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBackendJob {
    _private: (),
}
impl UpdateBackendJob {
    /// Creates a new builder-style object to manufacture [`UpdateBackendJobInput`](crate::input::UpdateBackendJobInput)
    pub fn builder() -> crate::input::update_backend_job_input::Builder {
        crate::input::update_backend_job_input::Builder::default()
    }
    /// Creates a new `UpdateBackendJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBackendJob {
    type Output = std::result::Result<
        crate::output::UpdateBackendJobOutput,
        crate::error::UpdateBackendJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_backend_job_error(response)
        } else {
            crate::operation_deser::parse_update_backend_job_response(response)
        }
    }
}

/// Operation shape for `UpdateBackendStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_backend_storage`](crate::client::Client::update_backend_storage).
///
/// See [`crate::client::fluent_builders::UpdateBackendStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBackendStorage {
    _private: (),
}
impl UpdateBackendStorage {
    /// Creates a new builder-style object to manufacture [`UpdateBackendStorageInput`](crate::input::UpdateBackendStorageInput)
    pub fn builder() -> crate::input::update_backend_storage_input::Builder {
        crate::input::update_backend_storage_input::Builder::default()
    }
    /// Creates a new `UpdateBackendStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBackendStorage {
    type Output = std::result::Result<
        crate::output::UpdateBackendStorageOutput,
        crate::error::UpdateBackendStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_backend_storage_error(response)
        } else {
            crate::operation_deser::parse_update_backend_storage_response(response)
        }
    }
}
