// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The request object for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoginAuthConfigReqObj {
    /// <p>The Amazon Cognito identity pool ID used for the Amplify Admin UI login authorization.</p>
    pub aws_cognito_identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The AWS Region for the Amplify Admin UI login.</p>
    pub aws_cognito_region: std::option::Option<std::string::String>,
    /// <p>The Amazon Cognito user pool ID used for Amplify Admin UI login authentication.</p>
    pub aws_user_pools_id: std::option::Option<std::string::String>,
    /// <p>The web client ID for the Amazon Cognito user pools.</p>
    pub aws_user_pools_web_client_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LoginAuthConfigReqObj {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoginAuthConfigReqObj");
        formatter.field(
            "aws_cognito_identity_pool_id",
            &self.aws_cognito_identity_pool_id,
        );
        formatter.field("aws_cognito_region", &self.aws_cognito_region);
        formatter.field("aws_user_pools_id", &self.aws_user_pools_id);
        formatter.field(
            "aws_user_pools_web_client_id",
            &self.aws_user_pools_web_client_id,
        );
        formatter.finish()
    }
}
/// See [`LoginAuthConfigReqObj`](crate::model::LoginAuthConfigReqObj)
pub mod login_auth_config_req_obj {
    /// A builder for [`LoginAuthConfigReqObj`](crate::model::LoginAuthConfigReqObj)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_cognito_identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) aws_cognito_region: std::option::Option<std::string::String>,
        pub(crate) aws_user_pools_id: std::option::Option<std::string::String>,
        pub(crate) aws_user_pools_web_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Cognito identity pool ID used for the Amplify Admin UI login authorization.</p>
        pub fn aws_cognito_identity_pool_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.aws_cognito_identity_pool_id = Some(input.into());
            self
        }
        /// <p>The Amazon Cognito identity pool ID used for the Amplify Admin UI login authorization.</p>
        pub fn set_aws_cognito_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_cognito_identity_pool_id = input;
            self
        }
        /// <p>The AWS Region for the Amplify Admin UI login.</p>
        pub fn aws_cognito_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_cognito_region = Some(input.into());
            self
        }
        /// <p>The AWS Region for the Amplify Admin UI login.</p>
        pub fn set_aws_cognito_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_cognito_region = input;
            self
        }
        /// <p>The Amazon Cognito user pool ID used for Amplify Admin UI login authentication.</p>
        pub fn aws_user_pools_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_user_pools_id = Some(input.into());
            self
        }
        /// <p>The Amazon Cognito user pool ID used for Amplify Admin UI login authentication.</p>
        pub fn set_aws_user_pools_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_user_pools_id = input;
            self
        }
        /// <p>The web client ID for the Amazon Cognito user pools.</p>
        pub fn aws_user_pools_web_client_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.aws_user_pools_web_client_id = Some(input.into());
            self
        }
        /// <p>The web client ID for the Amazon Cognito user pools.</p>
        pub fn set_aws_user_pools_web_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_user_pools_web_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LoginAuthConfigReqObj`](crate::model::LoginAuthConfigReqObj)
        pub fn build(self) -> crate::model::LoginAuthConfigReqObj {
            crate::model::LoginAuthConfigReqObj {
                aws_cognito_identity_pool_id: self.aws_cognito_identity_pool_id,
                aws_cognito_region: self.aws_cognito_region,
                aws_user_pools_id: self.aws_user_pools_id,
                aws_user_pools_web_client_id: self.aws_user_pools_web_client_id,
            }
        }
    }
}
impl LoginAuthConfigReqObj {
    /// Creates a new builder-style object to manufacture [`LoginAuthConfigReqObj`](crate::model::LoginAuthConfigReqObj)
    pub fn builder() -> crate::model::login_auth_config_req_obj::Builder {
        crate::model::login_auth_config_req_obj::Builder::default()
    }
}

/// <p>Defines the resource configuration when updating an authentication resource in your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendAuthResourceConfig {
    /// <p>Defines the service name to use when configuring an authentication resource in your Amplify project.</p>
    pub auth_resources: std::option::Option<crate::model::AuthResources>,
    /// <p>Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of your auth resource in the Amplify project.</p>
    pub identity_pool_configs:
        std::option::Option<crate::model::UpdateBackendAuthIdentityPoolConfig>,
    /// <p>Defines the service name to use when configuring an authentication resource in your Amplify project.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>Describes the authentication configuration for the Amazon Cognito user pool, provisioned as a part of your auth resource in the Amplify project.</p>
    pub user_pool_configs: std::option::Option<crate::model::UpdateBackendAuthUserPoolConfig>,
}
impl std::fmt::Debug for UpdateBackendAuthResourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendAuthResourceConfig");
        formatter.field("auth_resources", &self.auth_resources);
        formatter.field("identity_pool_configs", &self.identity_pool_configs);
        formatter.field("service", &self.service);
        formatter.field("user_pool_configs", &self.user_pool_configs);
        formatter.finish()
    }
}
/// See [`UpdateBackendAuthResourceConfig`](crate::model::UpdateBackendAuthResourceConfig)
pub mod update_backend_auth_resource_config {
    /// A builder for [`UpdateBackendAuthResourceConfig`](crate::model::UpdateBackendAuthResourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auth_resources: std::option::Option<crate::model::AuthResources>,
        pub(crate) identity_pool_configs:
            std::option::Option<crate::model::UpdateBackendAuthIdentityPoolConfig>,
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) user_pool_configs:
            std::option::Option<crate::model::UpdateBackendAuthUserPoolConfig>,
    }
    impl Builder {
        /// <p>Defines the service name to use when configuring an authentication resource in your Amplify project.</p>
        pub fn auth_resources(mut self, input: crate::model::AuthResources) -> Self {
            self.auth_resources = Some(input);
            self
        }
        /// <p>Defines the service name to use when configuring an authentication resource in your Amplify project.</p>
        pub fn set_auth_resources(
            mut self,
            input: std::option::Option<crate::model::AuthResources>,
        ) -> Self {
            self.auth_resources = input;
            self
        }
        /// <p>Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of your auth resource in the Amplify project.</p>
        pub fn identity_pool_configs(
            mut self,
            input: crate::model::UpdateBackendAuthIdentityPoolConfig,
        ) -> Self {
            self.identity_pool_configs = Some(input);
            self
        }
        /// <p>Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of your auth resource in the Amplify project.</p>
        pub fn set_identity_pool_configs(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendAuthIdentityPoolConfig>,
        ) -> Self {
            self.identity_pool_configs = input;
            self
        }
        /// <p>Defines the service name to use when configuring an authentication resource in your Amplify project.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>Defines the service name to use when configuring an authentication resource in your Amplify project.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>Describes the authentication configuration for the Amazon Cognito user pool, provisioned as a part of your auth resource in the Amplify project.</p>
        pub fn user_pool_configs(
            mut self,
            input: crate::model::UpdateBackendAuthUserPoolConfig,
        ) -> Self {
            self.user_pool_configs = Some(input);
            self
        }
        /// <p>Describes the authentication configuration for the Amazon Cognito user pool, provisioned as a part of your auth resource in the Amplify project.</p>
        pub fn set_user_pool_configs(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendAuthUserPoolConfig>,
        ) -> Self {
            self.user_pool_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendAuthResourceConfig`](crate::model::UpdateBackendAuthResourceConfig)
        pub fn build(self) -> crate::model::UpdateBackendAuthResourceConfig {
            crate::model::UpdateBackendAuthResourceConfig {
                auth_resources: self.auth_resources,
                identity_pool_configs: self.identity_pool_configs,
                service: self.service,
                user_pool_configs: self.user_pool_configs,
            }
        }
    }
}
impl UpdateBackendAuthResourceConfig {
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthResourceConfig`](crate::model::UpdateBackendAuthResourceConfig)
    pub fn builder() -> crate::model::update_backend_auth_resource_config::Builder {
        crate::model::update_backend_auth_resource_config::Builder::default()
    }
}

/// <p>Describes the Amazon Cognito user pool configuration for the authorization resource to be configured for your Amplify project on an update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendAuthUserPoolConfig {
    /// <p>Describes the forgot password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
    pub forgot_password: std::option::Option<crate::model::UpdateBackendAuthForgotPasswordConfig>,
    /// <p>Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured as a part of your Amplify project.</p>
    pub mfa: std::option::Option<crate::model::UpdateBackendAuthMfaConfig>,
    /// <p>Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
    pub o_auth: std::option::Option<crate::model::UpdateBackendAuthOAuthConfig>,
    /// <p>Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
    pub password_policy: std::option::Option<crate::model::UpdateBackendAuthPasswordPolicyConfig>,
}
impl std::fmt::Debug for UpdateBackendAuthUserPoolConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendAuthUserPoolConfig");
        formatter.field("forgot_password", &self.forgot_password);
        formatter.field("mfa", &self.mfa);
        formatter.field("o_auth", &self.o_auth);
        formatter.field("password_policy", &self.password_policy);
        formatter.finish()
    }
}
/// See [`UpdateBackendAuthUserPoolConfig`](crate::model::UpdateBackendAuthUserPoolConfig)
pub mod update_backend_auth_user_pool_config {
    /// A builder for [`UpdateBackendAuthUserPoolConfig`](crate::model::UpdateBackendAuthUserPoolConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forgot_password:
            std::option::Option<crate::model::UpdateBackendAuthForgotPasswordConfig>,
        pub(crate) mfa: std::option::Option<crate::model::UpdateBackendAuthMfaConfig>,
        pub(crate) o_auth: std::option::Option<crate::model::UpdateBackendAuthOAuthConfig>,
        pub(crate) password_policy:
            std::option::Option<crate::model::UpdateBackendAuthPasswordPolicyConfig>,
    }
    impl Builder {
        /// <p>Describes the forgot password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn forgot_password(
            mut self,
            input: crate::model::UpdateBackendAuthForgotPasswordConfig,
        ) -> Self {
            self.forgot_password = Some(input);
            self
        }
        /// <p>Describes the forgot password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn set_forgot_password(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendAuthForgotPasswordConfig>,
        ) -> Self {
            self.forgot_password = input;
            self
        }
        /// <p>Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured as a part of your Amplify project.</p>
        pub fn mfa(mut self, input: crate::model::UpdateBackendAuthMfaConfig) -> Self {
            self.mfa = Some(input);
            self
        }
        /// <p>Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured as a part of your Amplify project.</p>
        pub fn set_mfa(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendAuthMfaConfig>,
        ) -> Self {
            self.mfa = input;
            self
        }
        /// <p>Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn o_auth(mut self, input: crate::model::UpdateBackendAuthOAuthConfig) -> Self {
            self.o_auth = Some(input);
            self
        }
        /// <p>Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn set_o_auth(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendAuthOAuthConfig>,
        ) -> Self {
            self.o_auth = input;
            self
        }
        /// <p>Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn password_policy(
            mut self,
            input: crate::model::UpdateBackendAuthPasswordPolicyConfig,
        ) -> Self {
            self.password_policy = Some(input);
            self
        }
        /// <p>Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn set_password_policy(
            mut self,
            input: std::option::Option<crate::model::UpdateBackendAuthPasswordPolicyConfig>,
        ) -> Self {
            self.password_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendAuthUserPoolConfig`](crate::model::UpdateBackendAuthUserPoolConfig)
        pub fn build(self) -> crate::model::UpdateBackendAuthUserPoolConfig {
            crate::model::UpdateBackendAuthUserPoolConfig {
                forgot_password: self.forgot_password,
                mfa: self.mfa,
                o_auth: self.o_auth,
                password_policy: self.password_policy,
            }
        }
    }
}
impl UpdateBackendAuthUserPoolConfig {
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthUserPoolConfig`](crate::model::UpdateBackendAuthUserPoolConfig)
    pub fn builder() -> crate::model::update_backend_auth_user_pool_config::Builder {
        crate::model::update_backend_auth_user_pool_config::Builder::default()
    }
}

/// <p>Describes the password policy for your Amazon Cognito user pool configured as a part of your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendAuthPasswordPolicyConfig {
    /// <p>Describes additional constraints on password requirements to sign in to the auth resource, configured as a part of your Amplify project.</p>
    pub additional_constraints:
        std::option::Option<std::vec::Vec<crate::model::AdditionalConstraintsElement>>,
    /// <p>Describes the minimum length of the password required to sign in to the auth resource, configured as a part of your Amplify project.</p>
    pub minimum_length: f64,
}
impl std::fmt::Debug for UpdateBackendAuthPasswordPolicyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendAuthPasswordPolicyConfig");
        formatter.field("additional_constraints", &self.additional_constraints);
        formatter.field("minimum_length", &self.minimum_length);
        formatter.finish()
    }
}
/// See [`UpdateBackendAuthPasswordPolicyConfig`](crate::model::UpdateBackendAuthPasswordPolicyConfig)
pub mod update_backend_auth_password_policy_config {
    /// A builder for [`UpdateBackendAuthPasswordPolicyConfig`](crate::model::UpdateBackendAuthPasswordPolicyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) additional_constraints:
            std::option::Option<std::vec::Vec<crate::model::AdditionalConstraintsElement>>,
        pub(crate) minimum_length: std::option::Option<f64>,
    }
    impl Builder {
        /// Appends an item to `additional_constraints`.
        ///
        /// To override the contents of this collection use [`set_additional_constraints`](Self::set_additional_constraints).
        ///
        /// <p>Describes additional constraints on password requirements to sign in to the auth resource, configured as a part of your Amplify project.</p>
        pub fn additional_constraints(
            mut self,
            input: impl Into<crate::model::AdditionalConstraintsElement>,
        ) -> Self {
            let mut v = self.additional_constraints.unwrap_or_default();
            v.push(input.into());
            self.additional_constraints = Some(v);
            self
        }
        /// <p>Describes additional constraints on password requirements to sign in to the auth resource, configured as a part of your Amplify project.</p>
        pub fn set_additional_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdditionalConstraintsElement>>,
        ) -> Self {
            self.additional_constraints = input;
            self
        }
        /// <p>Describes the minimum length of the password required to sign in to the auth resource, configured as a part of your Amplify project.</p>
        pub fn minimum_length(mut self, input: f64) -> Self {
            self.minimum_length = Some(input);
            self
        }
        /// <p>Describes the minimum length of the password required to sign in to the auth resource, configured as a part of your Amplify project.</p>
        pub fn set_minimum_length(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum_length = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendAuthPasswordPolicyConfig`](crate::model::UpdateBackendAuthPasswordPolicyConfig)
        pub fn build(self) -> crate::model::UpdateBackendAuthPasswordPolicyConfig {
            crate::model::UpdateBackendAuthPasswordPolicyConfig {
                additional_constraints: self.additional_constraints,
                minimum_length: self.minimum_length.unwrap_or_default(),
            }
        }
    }
}
impl UpdateBackendAuthPasswordPolicyConfig {
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthPasswordPolicyConfig`](crate::model::UpdateBackendAuthPasswordPolicyConfig)
    pub fn builder() -> crate::model::update_backend_auth_password_policy_config::Builder {
        crate::model::update_backend_auth_password_policy_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdditionalConstraintsElement {
    #[allow(missing_docs)] // documentation missing in model
    RequireDigit,
    #[allow(missing_docs)] // documentation missing in model
    RequireLowercase,
    #[allow(missing_docs)] // documentation missing in model
    RequireSymbol,
    #[allow(missing_docs)] // documentation missing in model
    RequireUppercase,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdditionalConstraintsElement {
    fn from(s: &str) -> Self {
        match s {
            "REQUIRE_DIGIT" => AdditionalConstraintsElement::RequireDigit,
            "REQUIRE_LOWERCASE" => AdditionalConstraintsElement::RequireLowercase,
            "REQUIRE_SYMBOL" => AdditionalConstraintsElement::RequireSymbol,
            "REQUIRE_UPPERCASE" => AdditionalConstraintsElement::RequireUppercase,
            other => AdditionalConstraintsElement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdditionalConstraintsElement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdditionalConstraintsElement::from(s))
    }
}
impl AdditionalConstraintsElement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdditionalConstraintsElement::RequireDigit => "REQUIRE_DIGIT",
            AdditionalConstraintsElement::RequireLowercase => "REQUIRE_LOWERCASE",
            AdditionalConstraintsElement::RequireSymbol => "REQUIRE_SYMBOL",
            AdditionalConstraintsElement::RequireUppercase => "REQUIRE_UPPERCASE",
            AdditionalConstraintsElement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "REQUIRE_DIGIT",
            "REQUIRE_LOWERCASE",
            "REQUIRE_SYMBOL",
            "REQUIRE_UPPERCASE",
        ]
    }
}
impl AsRef<str> for AdditionalConstraintsElement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The OAuth configurations for authenticating users into your Amplify app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendAuthOAuthConfig {
    /// <p>The Amazon Cognito domain prefix used to create a hosted UI for authentication.</p>
    pub domain_prefix: std::option::Option<std::string::String>,
    /// <p>The OAuth grant type to allow app users to authenticate from your Amplify app.</p>
    pub o_auth_grant_type: std::option::Option<crate::model::OAuthGrantType>,
    /// <p>The list of OAuth-related flows that can allow users to authenticate from your Amplify app.</p>
    pub o_auth_scopes: std::option::Option<std::vec::Vec<crate::model::OAuthScopesElement>>,
    /// <p>Redirect URLs that OAuth uses when a user signs in to an Amplify app.</p>
    pub redirect_sign_in_ur_is: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Redirect URLs that OAuth uses when a user signs out of an Amplify app.</p>
    pub redirect_sign_out_ur_is: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Describes third-party social federation configurations for allowing your users to sign in with OAuth.</p>
    pub social_provider_settings: std::option::Option<crate::model::SocialProviderSettings>,
}
impl std::fmt::Debug for UpdateBackendAuthOAuthConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendAuthOAuthConfig");
        formatter.field("domain_prefix", &self.domain_prefix);
        formatter.field("o_auth_grant_type", &self.o_auth_grant_type);
        formatter.field("o_auth_scopes", &self.o_auth_scopes);
        formatter.field("redirect_sign_in_ur_is", &self.redirect_sign_in_ur_is);
        formatter.field("redirect_sign_out_ur_is", &self.redirect_sign_out_ur_is);
        formatter.field("social_provider_settings", &self.social_provider_settings);
        formatter.finish()
    }
}
/// See [`UpdateBackendAuthOAuthConfig`](crate::model::UpdateBackendAuthOAuthConfig)
pub mod update_backend_auth_o_auth_config {
    /// A builder for [`UpdateBackendAuthOAuthConfig`](crate::model::UpdateBackendAuthOAuthConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_prefix: std::option::Option<std::string::String>,
        pub(crate) o_auth_grant_type: std::option::Option<crate::model::OAuthGrantType>,
        pub(crate) o_auth_scopes:
            std::option::Option<std::vec::Vec<crate::model::OAuthScopesElement>>,
        pub(crate) redirect_sign_in_ur_is: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) redirect_sign_out_ur_is: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) social_provider_settings:
            std::option::Option<crate::model::SocialProviderSettings>,
    }
    impl Builder {
        /// <p>The Amazon Cognito domain prefix used to create a hosted UI for authentication.</p>
        pub fn domain_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon Cognito domain prefix used to create a hosted UI for authentication.</p>
        pub fn set_domain_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_prefix = input;
            self
        }
        /// <p>The OAuth grant type to allow app users to authenticate from your Amplify app.</p>
        pub fn o_auth_grant_type(mut self, input: crate::model::OAuthGrantType) -> Self {
            self.o_auth_grant_type = Some(input);
            self
        }
        /// <p>The OAuth grant type to allow app users to authenticate from your Amplify app.</p>
        pub fn set_o_auth_grant_type(
            mut self,
            input: std::option::Option<crate::model::OAuthGrantType>,
        ) -> Self {
            self.o_auth_grant_type = input;
            self
        }
        /// Appends an item to `o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_o_auth_scopes`](Self::set_o_auth_scopes).
        ///
        /// <p>The list of OAuth-related flows that can allow users to authenticate from your Amplify app.</p>
        pub fn o_auth_scopes(mut self, input: impl Into<crate::model::OAuthScopesElement>) -> Self {
            let mut v = self.o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.o_auth_scopes = Some(v);
            self
        }
        /// <p>The list of OAuth-related flows that can allow users to authenticate from your Amplify app.</p>
        pub fn set_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OAuthScopesElement>>,
        ) -> Self {
            self.o_auth_scopes = input;
            self
        }
        /// Appends an item to `redirect_sign_in_ur_is`.
        ///
        /// To override the contents of this collection use [`set_redirect_sign_in_ur_is`](Self::set_redirect_sign_in_ur_is).
        ///
        /// <p>Redirect URLs that OAuth uses when a user signs in to an Amplify app.</p>
        pub fn redirect_sign_in_ur_is(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.redirect_sign_in_ur_is.unwrap_or_default();
            v.push(input.into());
            self.redirect_sign_in_ur_is = Some(v);
            self
        }
        /// <p>Redirect URLs that OAuth uses when a user signs in to an Amplify app.</p>
        pub fn set_redirect_sign_in_ur_is(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.redirect_sign_in_ur_is = input;
            self
        }
        /// Appends an item to `redirect_sign_out_ur_is`.
        ///
        /// To override the contents of this collection use [`set_redirect_sign_out_ur_is`](Self::set_redirect_sign_out_ur_is).
        ///
        /// <p>Redirect URLs that OAuth uses when a user signs out of an Amplify app.</p>
        pub fn redirect_sign_out_ur_is(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.redirect_sign_out_ur_is.unwrap_or_default();
            v.push(input.into());
            self.redirect_sign_out_ur_is = Some(v);
            self
        }
        /// <p>Redirect URLs that OAuth uses when a user signs out of an Amplify app.</p>
        pub fn set_redirect_sign_out_ur_is(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.redirect_sign_out_ur_is = input;
            self
        }
        /// <p>Describes third-party social federation configurations for allowing your users to sign in with OAuth.</p>
        pub fn social_provider_settings(
            mut self,
            input: crate::model::SocialProviderSettings,
        ) -> Self {
            self.social_provider_settings = Some(input);
            self
        }
        /// <p>Describes third-party social federation configurations for allowing your users to sign in with OAuth.</p>
        pub fn set_social_provider_settings(
            mut self,
            input: std::option::Option<crate::model::SocialProviderSettings>,
        ) -> Self {
            self.social_provider_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendAuthOAuthConfig`](crate::model::UpdateBackendAuthOAuthConfig)
        pub fn build(self) -> crate::model::UpdateBackendAuthOAuthConfig {
            crate::model::UpdateBackendAuthOAuthConfig {
                domain_prefix: self.domain_prefix,
                o_auth_grant_type: self.o_auth_grant_type,
                o_auth_scopes: self.o_auth_scopes,
                redirect_sign_in_ur_is: self.redirect_sign_in_ur_is,
                redirect_sign_out_ur_is: self.redirect_sign_out_ur_is,
                social_provider_settings: self.social_provider_settings,
            }
        }
    }
}
impl UpdateBackendAuthOAuthConfig {
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthOAuthConfig`](crate::model::UpdateBackendAuthOAuthConfig)
    pub fn builder() -> crate::model::update_backend_auth_o_auth_config::Builder {
        crate::model::update_backend_auth_o_auth_config::Builder::default()
    }
}

/// <p>The settings for using the social identity providers for access to your Amplify app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SocialProviderSettings {
    /// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
    pub facebook: std::option::Option<crate::model::BackendAuthSocialProviderConfig>,
    /// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
    pub google: std::option::Option<crate::model::BackendAuthSocialProviderConfig>,
    /// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
    pub login_with_amazon: std::option::Option<crate::model::BackendAuthSocialProviderConfig>,
    /// <p>Describes Apple social federation configurations for allowing your app users to sign in using OAuth.</p>
    pub sign_in_with_apple: std::option::Option<crate::model::BackendAuthAppleProviderConfig>,
}
impl std::fmt::Debug for SocialProviderSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SocialProviderSettings");
        formatter.field("facebook", &self.facebook);
        formatter.field("google", &self.google);
        formatter.field("login_with_amazon", &self.login_with_amazon);
        formatter.field("sign_in_with_apple", &self.sign_in_with_apple);
        formatter.finish()
    }
}
/// See [`SocialProviderSettings`](crate::model::SocialProviderSettings)
pub mod social_provider_settings {
    /// A builder for [`SocialProviderSettings`](crate::model::SocialProviderSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) facebook: std::option::Option<crate::model::BackendAuthSocialProviderConfig>,
        pub(crate) google: std::option::Option<crate::model::BackendAuthSocialProviderConfig>,
        pub(crate) login_with_amazon:
            std::option::Option<crate::model::BackendAuthSocialProviderConfig>,
        pub(crate) sign_in_with_apple:
            std::option::Option<crate::model::BackendAuthAppleProviderConfig>,
    }
    impl Builder {
        /// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
        pub fn facebook(mut self, input: crate::model::BackendAuthSocialProviderConfig) -> Self {
            self.facebook = Some(input);
            self
        }
        /// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
        pub fn set_facebook(
            mut self,
            input: std::option::Option<crate::model::BackendAuthSocialProviderConfig>,
        ) -> Self {
            self.facebook = input;
            self
        }
        /// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
        pub fn google(mut self, input: crate::model::BackendAuthSocialProviderConfig) -> Self {
            self.google = Some(input);
            self
        }
        /// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
        pub fn set_google(
            mut self,
            input: std::option::Option<crate::model::BackendAuthSocialProviderConfig>,
        ) -> Self {
            self.google = input;
            self
        }
        /// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
        pub fn login_with_amazon(
            mut self,
            input: crate::model::BackendAuthSocialProviderConfig,
        ) -> Self {
            self.login_with_amazon = Some(input);
            self
        }
        /// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
        pub fn set_login_with_amazon(
            mut self,
            input: std::option::Option<crate::model::BackendAuthSocialProviderConfig>,
        ) -> Self {
            self.login_with_amazon = input;
            self
        }
        /// <p>Describes Apple social federation configurations for allowing your app users to sign in using OAuth.</p>
        pub fn sign_in_with_apple(
            mut self,
            input: crate::model::BackendAuthAppleProviderConfig,
        ) -> Self {
            self.sign_in_with_apple = Some(input);
            self
        }
        /// <p>Describes Apple social federation configurations for allowing your app users to sign in using OAuth.</p>
        pub fn set_sign_in_with_apple(
            mut self,
            input: std::option::Option<crate::model::BackendAuthAppleProviderConfig>,
        ) -> Self {
            self.sign_in_with_apple = input;
            self
        }
        /// Consumes the builder and constructs a [`SocialProviderSettings`](crate::model::SocialProviderSettings)
        pub fn build(self) -> crate::model::SocialProviderSettings {
            crate::model::SocialProviderSettings {
                facebook: self.facebook,
                google: self.google,
                login_with_amazon: self.login_with_amazon,
                sign_in_with_apple: self.sign_in_with_apple,
            }
        }
    }
}
impl SocialProviderSettings {
    /// Creates a new builder-style object to manufacture [`SocialProviderSettings`](crate::model::SocialProviderSettings)
    pub fn builder() -> crate::model::social_provider_settings::Builder {
        crate::model::social_provider_settings::Builder::default()
    }
}

/// <p>Describes Apple social federation configurations for allowing your app users to sign in using OAuth.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendAuthAppleProviderConfig {
    /// <p>Describes the client_id (also called Services ID) that comes from Apple.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>Describes the key_id that comes from Apple.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>Describes the private_key that comes from Apple.</p>
    pub private_key: std::option::Option<std::string::String>,
    /// <p>Describes the team_id that comes from Apple.</p>
    pub team_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackendAuthAppleProviderConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendAuthAppleProviderConfig");
        formatter.field("client_id", &self.client_id);
        formatter.field("key_id", &self.key_id);
        formatter.field("private_key", &self.private_key);
        formatter.field("team_id", &self.team_id);
        formatter.finish()
    }
}
/// See [`BackendAuthAppleProviderConfig`](crate::model::BackendAuthAppleProviderConfig)
pub mod backend_auth_apple_provider_config {
    /// A builder for [`BackendAuthAppleProviderConfig`](crate::model::BackendAuthAppleProviderConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) private_key: std::option::Option<std::string::String>,
        pub(crate) team_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes the client_id (also called Services ID) that comes from Apple.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>Describes the client_id (also called Services ID) that comes from Apple.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>Describes the key_id that comes from Apple.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>Describes the key_id that comes from Apple.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>Describes the private_key that comes from Apple.</p>
        pub fn private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_key = Some(input.into());
            self
        }
        /// <p>Describes the private_key that comes from Apple.</p>
        pub fn set_private_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_key = input;
            self
        }
        /// <p>Describes the team_id that comes from Apple.</p>
        pub fn team_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.team_id = Some(input.into());
            self
        }
        /// <p>Describes the team_id that comes from Apple.</p>
        pub fn set_team_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.team_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendAuthAppleProviderConfig`](crate::model::BackendAuthAppleProviderConfig)
        pub fn build(self) -> crate::model::BackendAuthAppleProviderConfig {
            crate::model::BackendAuthAppleProviderConfig {
                client_id: self.client_id,
                key_id: self.key_id,
                private_key: self.private_key,
                team_id: self.team_id,
            }
        }
    }
}
impl BackendAuthAppleProviderConfig {
    /// Creates a new builder-style object to manufacture [`BackendAuthAppleProviderConfig`](crate::model::BackendAuthAppleProviderConfig)
    pub fn builder() -> crate::model::backend_auth_apple_provider_config::Builder {
        crate::model::backend_auth_apple_provider_config::Builder::default()
    }
}

/// <p>Describes third-party social federation configurations for allowing your app users to sign in using OAuth.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendAuthSocialProviderConfig {
    /// <p>Describes the client_id, which can be obtained from the third-party social federation provider.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>Describes the client_secret, which can be obtained from third-party social federation providers.</p>
    pub client_secret: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackendAuthSocialProviderConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendAuthSocialProviderConfig");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &self.client_secret);
        formatter.finish()
    }
}
/// See [`BackendAuthSocialProviderConfig`](crate::model::BackendAuthSocialProviderConfig)
pub mod backend_auth_social_provider_config {
    /// A builder for [`BackendAuthSocialProviderConfig`](crate::model::BackendAuthSocialProviderConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes the client_id, which can be obtained from the third-party social federation provider.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>Describes the client_id, which can be obtained from the third-party social federation provider.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>Describes the client_secret, which can be obtained from third-party social federation providers.</p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p>Describes the client_secret, which can be obtained from third-party social federation providers.</p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendAuthSocialProviderConfig`](crate::model::BackendAuthSocialProviderConfig)
        pub fn build(self) -> crate::model::BackendAuthSocialProviderConfig {
            crate::model::BackendAuthSocialProviderConfig {
                client_id: self.client_id,
                client_secret: self.client_secret,
            }
        }
    }
}
impl BackendAuthSocialProviderConfig {
    /// Creates a new builder-style object to manufacture [`BackendAuthSocialProviderConfig`](crate::model::BackendAuthSocialProviderConfig)
    pub fn builder() -> crate::model::backend_auth_social_provider_config::Builder {
        crate::model::backend_auth_social_provider_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OAuthScopesElement {
    #[allow(missing_docs)] // documentation missing in model
    AwsCognitoSigninUserAdmin,
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Openid,
    #[allow(missing_docs)] // documentation missing in model
    Phone,
    #[allow(missing_docs)] // documentation missing in model
    Profile,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OAuthScopesElement {
    fn from(s: &str) -> Self {
        match s {
            "AWS_COGNITO_SIGNIN_USER_ADMIN" => OAuthScopesElement::AwsCognitoSigninUserAdmin,
            "EMAIL" => OAuthScopesElement::Email,
            "OPENID" => OAuthScopesElement::Openid,
            "PHONE" => OAuthScopesElement::Phone,
            "PROFILE" => OAuthScopesElement::Profile,
            other => OAuthScopesElement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OAuthScopesElement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OAuthScopesElement::from(s))
    }
}
impl OAuthScopesElement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OAuthScopesElement::AwsCognitoSigninUserAdmin => "AWS_COGNITO_SIGNIN_USER_ADMIN",
            OAuthScopesElement::Email => "EMAIL",
            OAuthScopesElement::Openid => "OPENID",
            OAuthScopesElement::Phone => "PHONE",
            OAuthScopesElement::Profile => "PROFILE",
            OAuthScopesElement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS_COGNITO_SIGNIN_USER_ADMIN",
            "EMAIL",
            "OPENID",
            "PHONE",
            "PROFILE",
        ]
    }
}
impl AsRef<str> for OAuthScopesElement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OAuthGrantType {
    #[allow(missing_docs)] // documentation missing in model
    Code,
    #[allow(missing_docs)] // documentation missing in model
    Implicit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OAuthGrantType {
    fn from(s: &str) -> Self {
        match s {
            "CODE" => OAuthGrantType::Code,
            "IMPLICIT" => OAuthGrantType::Implicit,
            other => OAuthGrantType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OAuthGrantType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OAuthGrantType::from(s))
    }
}
impl OAuthGrantType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OAuthGrantType::Code => "CODE",
            OAuthGrantType::Implicit => "IMPLICIT",
            OAuthGrantType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CODE", "IMPLICIT"]
    }
}
impl AsRef<str> for OAuthGrantType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Updates the multi-factor authentication (MFA) configuration for the backend of your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendAuthMfaConfig {
    /// <p>The MFA mode for the backend of your Amplify project.</p>
    pub mfa_mode: std::option::Option<crate::model::MfaMode>,
    /// <p>The settings of your MFA configuration for the backend of your Amplify project.</p>
    pub settings: std::option::Option<crate::model::Settings>,
}
impl std::fmt::Debug for UpdateBackendAuthMfaConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendAuthMfaConfig");
        formatter.field("mfa_mode", &self.mfa_mode);
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}
/// See [`UpdateBackendAuthMfaConfig`](crate::model::UpdateBackendAuthMfaConfig)
pub mod update_backend_auth_mfa_config {
    /// A builder for [`UpdateBackendAuthMfaConfig`](crate::model::UpdateBackendAuthMfaConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mfa_mode: std::option::Option<crate::model::MfaMode>,
        pub(crate) settings: std::option::Option<crate::model::Settings>,
    }
    impl Builder {
        /// <p>The MFA mode for the backend of your Amplify project.</p>
        pub fn mfa_mode(mut self, input: crate::model::MfaMode) -> Self {
            self.mfa_mode = Some(input);
            self
        }
        /// <p>The MFA mode for the backend of your Amplify project.</p>
        pub fn set_mfa_mode(mut self, input: std::option::Option<crate::model::MfaMode>) -> Self {
            self.mfa_mode = input;
            self
        }
        /// <p>The settings of your MFA configuration for the backend of your Amplify project.</p>
        pub fn settings(mut self, input: crate::model::Settings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p>The settings of your MFA configuration for the backend of your Amplify project.</p>
        pub fn set_settings(mut self, input: std::option::Option<crate::model::Settings>) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendAuthMfaConfig`](crate::model::UpdateBackendAuthMfaConfig)
        pub fn build(self) -> crate::model::UpdateBackendAuthMfaConfig {
            crate::model::UpdateBackendAuthMfaConfig {
                mfa_mode: self.mfa_mode,
                settings: self.settings,
            }
        }
    }
}
impl UpdateBackendAuthMfaConfig {
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthMfaConfig`](crate::model::UpdateBackendAuthMfaConfig)
    pub fn builder() -> crate::model::update_backend_auth_mfa_config::Builder {
        crate::model::update_backend_auth_mfa_config::Builder::default()
    }
}

/// <p>The settings of your MFA configuration for the backend of your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Settings {
    /// <p>The supported MFA types.</p>
    pub mfa_types: std::option::Option<std::vec::Vec<crate::model::MfaTypesElement>>,
    /// <p>The body of the SMS message.</p>
    pub sms_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Settings");
        formatter.field("mfa_types", &self.mfa_types);
        formatter.field("sms_message", &self.sms_message);
        formatter.finish()
    }
}
/// See [`Settings`](crate::model::Settings)
pub mod settings {
    /// A builder for [`Settings`](crate::model::Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mfa_types: std::option::Option<std::vec::Vec<crate::model::MfaTypesElement>>,
        pub(crate) sms_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `mfa_types`.
        ///
        /// To override the contents of this collection use [`set_mfa_types`](Self::set_mfa_types).
        ///
        /// <p>The supported MFA types.</p>
        pub fn mfa_types(mut self, input: impl Into<crate::model::MfaTypesElement>) -> Self {
            let mut v = self.mfa_types.unwrap_or_default();
            v.push(input.into());
            self.mfa_types = Some(v);
            self
        }
        /// <p>The supported MFA types.</p>
        pub fn set_mfa_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MfaTypesElement>>,
        ) -> Self {
            self.mfa_types = input;
            self
        }
        /// <p>The body of the SMS message.</p>
        pub fn sms_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_message = Some(input.into());
            self
        }
        /// <p>The body of the SMS message.</p>
        pub fn set_sms_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sms_message = input;
            self
        }
        /// Consumes the builder and constructs a [`Settings`](crate::model::Settings)
        pub fn build(self) -> crate::model::Settings {
            crate::model::Settings {
                mfa_types: self.mfa_types,
                sms_message: self.sms_message,
            }
        }
    }
}
impl Settings {
    /// Creates a new builder-style object to manufacture [`Settings`](crate::model::Settings)
    pub fn builder() -> crate::model::settings::Builder {
        crate::model::settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MfaTypesElement {
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    #[allow(missing_docs)] // documentation missing in model
    Totp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MfaTypesElement {
    fn from(s: &str) -> Self {
        match s {
            "SMS" => MfaTypesElement::Sms,
            "TOTP" => MfaTypesElement::Totp,
            other => MfaTypesElement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MfaTypesElement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MfaTypesElement::from(s))
    }
}
impl MfaTypesElement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MfaTypesElement::Sms => "SMS",
            MfaTypesElement::Totp => "TOTP",
            MfaTypesElement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SMS", "TOTP"]
    }
}
impl AsRef<str> for MfaTypesElement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MfaMode {
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    On,
    #[allow(missing_docs)] // documentation missing in model
    Optional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MfaMode {
    fn from(s: &str) -> Self {
        match s {
            "OFF" => MfaMode::Off,
            "ON" => MfaMode::On,
            "OPTIONAL" => MfaMode::Optional,
            other => MfaMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MfaMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MfaMode::from(s))
    }
}
impl MfaMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MfaMode::Off => "OFF",
            MfaMode::On => "ON",
            MfaMode::Optional => "OPTIONAL",
            MfaMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OFF", "ON", "OPTIONAL"]
    }
}
impl AsRef<str> for MfaMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the forgot password policy for authenticating into the Amplify app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendAuthForgotPasswordConfig {
    /// <p>Describes which mode to use (either SMS or email) to deliver messages to app users that want to recover their password.</p>
    pub delivery_method: std::option::Option<crate::model::DeliveryMethod>,
    /// <p>The configuration for the email sent when an app user forgets their password.</p>
    pub email_settings: std::option::Option<crate::model::EmailSettings>,
    /// <p>The configuration for the SMS message sent when an Amplify app user forgets their password.</p>
    pub sms_settings: std::option::Option<crate::model::SmsSettings>,
}
impl std::fmt::Debug for UpdateBackendAuthForgotPasswordConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendAuthForgotPasswordConfig");
        formatter.field("delivery_method", &self.delivery_method);
        formatter.field("email_settings", &self.email_settings);
        formatter.field("sms_settings", &self.sms_settings);
        formatter.finish()
    }
}
/// See [`UpdateBackendAuthForgotPasswordConfig`](crate::model::UpdateBackendAuthForgotPasswordConfig)
pub mod update_backend_auth_forgot_password_config {
    /// A builder for [`UpdateBackendAuthForgotPasswordConfig`](crate::model::UpdateBackendAuthForgotPasswordConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_method: std::option::Option<crate::model::DeliveryMethod>,
        pub(crate) email_settings: std::option::Option<crate::model::EmailSettings>,
        pub(crate) sms_settings: std::option::Option<crate::model::SmsSettings>,
    }
    impl Builder {
        /// <p>Describes which mode to use (either SMS or email) to deliver messages to app users that want to recover their password.</p>
        pub fn delivery_method(mut self, input: crate::model::DeliveryMethod) -> Self {
            self.delivery_method = Some(input);
            self
        }
        /// <p>Describes which mode to use (either SMS or email) to deliver messages to app users that want to recover their password.</p>
        pub fn set_delivery_method(
            mut self,
            input: std::option::Option<crate::model::DeliveryMethod>,
        ) -> Self {
            self.delivery_method = input;
            self
        }
        /// <p>The configuration for the email sent when an app user forgets their password.</p>
        pub fn email_settings(mut self, input: crate::model::EmailSettings) -> Self {
            self.email_settings = Some(input);
            self
        }
        /// <p>The configuration for the email sent when an app user forgets their password.</p>
        pub fn set_email_settings(
            mut self,
            input: std::option::Option<crate::model::EmailSettings>,
        ) -> Self {
            self.email_settings = input;
            self
        }
        /// <p>The configuration for the SMS message sent when an Amplify app user forgets their password.</p>
        pub fn sms_settings(mut self, input: crate::model::SmsSettings) -> Self {
            self.sms_settings = Some(input);
            self
        }
        /// <p>The configuration for the SMS message sent when an Amplify app user forgets their password.</p>
        pub fn set_sms_settings(
            mut self,
            input: std::option::Option<crate::model::SmsSettings>,
        ) -> Self {
            self.sms_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendAuthForgotPasswordConfig`](crate::model::UpdateBackendAuthForgotPasswordConfig)
        pub fn build(self) -> crate::model::UpdateBackendAuthForgotPasswordConfig {
            crate::model::UpdateBackendAuthForgotPasswordConfig {
                delivery_method: self.delivery_method,
                email_settings: self.email_settings,
                sms_settings: self.sms_settings,
            }
        }
    }
}
impl UpdateBackendAuthForgotPasswordConfig {
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthForgotPasswordConfig`](crate::model::UpdateBackendAuthForgotPasswordConfig)
    pub fn builder() -> crate::model::update_backend_auth_forgot_password_config::Builder {
        crate::model::update_backend_auth_forgot_password_config::Builder::default()
    }
}

/// <p>SMS settings for authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsSettings {
    /// <p>The body of the SMS message.</p>
    pub sms_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SmsSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsSettings");
        formatter.field("sms_message", &self.sms_message);
        formatter.finish()
    }
}
/// See [`SmsSettings`](crate::model::SmsSettings)
pub mod sms_settings {
    /// A builder for [`SmsSettings`](crate::model::SmsSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sms_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The body of the SMS message.</p>
        pub fn sms_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_message = Some(input.into());
            self
        }
        /// <p>The body of the SMS message.</p>
        pub fn set_sms_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sms_message = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsSettings`](crate::model::SmsSettings)
        pub fn build(self) -> crate::model::SmsSettings {
            crate::model::SmsSettings {
                sms_message: self.sms_message,
            }
        }
    }
}
impl SmsSettings {
    /// Creates a new builder-style object to manufacture [`SmsSettings`](crate::model::SmsSettings)
    pub fn builder() -> crate::model::sms_settings::Builder {
        crate::model::sms_settings::Builder::default()
    }
}

/// <p>The configuration for the email sent when an app user forgets their password.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailSettings {
    /// <p>The body of the email.</p>
    pub email_message: std::option::Option<std::string::String>,
    /// <p>The subject of the email.</p>
    pub email_subject: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EmailSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailSettings");
        formatter.field("email_message", &self.email_message);
        formatter.field("email_subject", &self.email_subject);
        formatter.finish()
    }
}
/// See [`EmailSettings`](crate::model::EmailSettings)
pub mod email_settings {
    /// A builder for [`EmailSettings`](crate::model::EmailSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_message: std::option::Option<std::string::String>,
        pub(crate) email_subject: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The body of the email.</p>
        pub fn email_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_message = Some(input.into());
            self
        }
        /// <p>The body of the email.</p>
        pub fn set_email_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_message = input;
            self
        }
        /// <p>The subject of the email.</p>
        pub fn email_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_subject = Some(input.into());
            self
        }
        /// <p>The subject of the email.</p>
        pub fn set_email_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_subject = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailSettings`](crate::model::EmailSettings)
        pub fn build(self) -> crate::model::EmailSettings {
            crate::model::EmailSettings {
                email_message: self.email_message,
                email_subject: self.email_subject,
            }
        }
    }
}
impl EmailSettings {
    /// Creates a new builder-style object to manufacture [`EmailSettings`](crate::model::EmailSettings)
    pub fn builder() -> crate::model::email_settings::Builder {
        crate::model::email_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeliveryMethod {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeliveryMethod {
    fn from(s: &str) -> Self {
        match s {
            "EMAIL" => DeliveryMethod::Email,
            "SMS" => DeliveryMethod::Sms,
            other => DeliveryMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeliveryMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeliveryMethod::from(s))
    }
}
impl DeliveryMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeliveryMethod::Email => "EMAIL",
            DeliveryMethod::Sms => "SMS",
            DeliveryMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMAIL", "SMS"]
    }
}
impl AsRef<str> for DeliveryMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Service {
    #[allow(missing_docs)] // documentation missing in model
    Cognito,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Service {
    fn from(s: &str) -> Self {
        match s {
            "COGNITO" => Service::Cognito,
            other => Service::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Service {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Service::from(s))
    }
}
impl Service {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Service::Cognito => "COGNITO",
            Service::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COGNITO"]
    }
}
impl AsRef<str> for Service {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of your auth resource in the Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendAuthIdentityPoolConfig {
    /// <p>A boolean value that can be set to allow or disallow guest-level authorization into your Amplify app.</p>
    pub unauthenticated_login: bool,
}
impl std::fmt::Debug for UpdateBackendAuthIdentityPoolConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendAuthIdentityPoolConfig");
        formatter.field("unauthenticated_login", &self.unauthenticated_login);
        formatter.finish()
    }
}
/// See [`UpdateBackendAuthIdentityPoolConfig`](crate::model::UpdateBackendAuthIdentityPoolConfig)
pub mod update_backend_auth_identity_pool_config {
    /// A builder for [`UpdateBackendAuthIdentityPoolConfig`](crate::model::UpdateBackendAuthIdentityPoolConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unauthenticated_login: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A boolean value that can be set to allow or disallow guest-level authorization into your Amplify app.</p>
        pub fn unauthenticated_login(mut self, input: bool) -> Self {
            self.unauthenticated_login = Some(input);
            self
        }
        /// <p>A boolean value that can be set to allow or disallow guest-level authorization into your Amplify app.</p>
        pub fn set_unauthenticated_login(mut self, input: std::option::Option<bool>) -> Self {
            self.unauthenticated_login = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendAuthIdentityPoolConfig`](crate::model::UpdateBackendAuthIdentityPoolConfig)
        pub fn build(self) -> crate::model::UpdateBackendAuthIdentityPoolConfig {
            crate::model::UpdateBackendAuthIdentityPoolConfig {
                unauthenticated_login: self.unauthenticated_login.unwrap_or_default(),
            }
        }
    }
}
impl UpdateBackendAuthIdentityPoolConfig {
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthIdentityPoolConfig`](crate::model::UpdateBackendAuthIdentityPoolConfig)
    pub fn builder() -> crate::model::update_backend_auth_identity_pool_config::Builder {
        crate::model::update_backend_auth_identity_pool_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthResources {
    #[allow(missing_docs)] // documentation missing in model
    IdentityPoolAndUserPool,
    #[allow(missing_docs)] // documentation missing in model
    UserPoolOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthResources {
    fn from(s: &str) -> Self {
        match s {
            "IDENTITY_POOL_AND_USER_POOL" => AuthResources::IdentityPoolAndUserPool,
            "USER_POOL_ONLY" => AuthResources::UserPoolOnly,
            other => AuthResources::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthResources {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthResources::from(s))
    }
}
impl AuthResources {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthResources::IdentityPoolAndUserPool => "IDENTITY_POOL_AND_USER_POOL",
            AuthResources::UserPoolOnly => "USER_POOL_ONLY",
            AuthResources::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IDENTITY_POOL_AND_USER_POOL", "USER_POOL_ONLY"]
    }
}
impl AsRef<str> for AuthResources {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The resource config for the data model, configured as a part of the Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendApiResourceConfig {
    /// <p>Additional authentication methods used to interact with your data models.</p>
    pub additional_auth_types: std::option::Option<std::vec::Vec<crate::model::BackendApiAuthType>>,
    /// <p>The API name used to interact with the data model, configured as a part of your Amplify project.</p>
    pub api_name: std::option::Option<std::string::String>,
    /// <p>The conflict resolution strategy for your data stored in the data models.</p>
    pub conflict_resolution: std::option::Option<crate::model::BackendApiConflictResolution>,
    /// <p>The default authentication type for interacting with the configured data models in your Amplify project.</p>
    pub default_auth_type: std::option::Option<crate::model::BackendApiAuthType>,
    /// <p>The service used to provision and interact with the data model.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The definition of the data model in the annotated transform of the GraphQL schema.</p>
    pub transform_schema: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackendApiResourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendApiResourceConfig");
        formatter.field("additional_auth_types", &self.additional_auth_types);
        formatter.field("api_name", &self.api_name);
        formatter.field("conflict_resolution", &self.conflict_resolution);
        formatter.field("default_auth_type", &self.default_auth_type);
        formatter.field("service", &self.service);
        formatter.field("transform_schema", &self.transform_schema);
        formatter.finish()
    }
}
/// See [`BackendApiResourceConfig`](crate::model::BackendApiResourceConfig)
pub mod backend_api_resource_config {
    /// A builder for [`BackendApiResourceConfig`](crate::model::BackendApiResourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) additional_auth_types:
            std::option::Option<std::vec::Vec<crate::model::BackendApiAuthType>>,
        pub(crate) api_name: std::option::Option<std::string::String>,
        pub(crate) conflict_resolution:
            std::option::Option<crate::model::BackendApiConflictResolution>,
        pub(crate) default_auth_type: std::option::Option<crate::model::BackendApiAuthType>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) transform_schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `additional_auth_types`.
        ///
        /// To override the contents of this collection use [`set_additional_auth_types`](Self::set_additional_auth_types).
        ///
        /// <p>Additional authentication methods used to interact with your data models.</p>
        pub fn additional_auth_types(
            mut self,
            input: impl Into<crate::model::BackendApiAuthType>,
        ) -> Self {
            let mut v = self.additional_auth_types.unwrap_or_default();
            v.push(input.into());
            self.additional_auth_types = Some(v);
            self
        }
        /// <p>Additional authentication methods used to interact with your data models.</p>
        pub fn set_additional_auth_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackendApiAuthType>>,
        ) -> Self {
            self.additional_auth_types = input;
            self
        }
        /// <p>The API name used to interact with the data model, configured as a part of your Amplify project.</p>
        pub fn api_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_name = Some(input.into());
            self
        }
        /// <p>The API name used to interact with the data model, configured as a part of your Amplify project.</p>
        pub fn set_api_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_name = input;
            self
        }
        /// <p>The conflict resolution strategy for your data stored in the data models.</p>
        pub fn conflict_resolution(
            mut self,
            input: crate::model::BackendApiConflictResolution,
        ) -> Self {
            self.conflict_resolution = Some(input);
            self
        }
        /// <p>The conflict resolution strategy for your data stored in the data models.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::BackendApiConflictResolution>,
        ) -> Self {
            self.conflict_resolution = input;
            self
        }
        /// <p>The default authentication type for interacting with the configured data models in your Amplify project.</p>
        pub fn default_auth_type(mut self, input: crate::model::BackendApiAuthType) -> Self {
            self.default_auth_type = Some(input);
            self
        }
        /// <p>The default authentication type for interacting with the configured data models in your Amplify project.</p>
        pub fn set_default_auth_type(
            mut self,
            input: std::option::Option<crate::model::BackendApiAuthType>,
        ) -> Self {
            self.default_auth_type = input;
            self
        }
        /// <p>The service used to provision and interact with the data model.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The service used to provision and interact with the data model.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The definition of the data model in the annotated transform of the GraphQL schema.</p>
        pub fn transform_schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_schema = Some(input.into());
            self
        }
        /// <p>The definition of the data model in the annotated transform of the GraphQL schema.</p>
        pub fn set_transform_schema(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transform_schema = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendApiResourceConfig`](crate::model::BackendApiResourceConfig)
        pub fn build(self) -> crate::model::BackendApiResourceConfig {
            crate::model::BackendApiResourceConfig {
                additional_auth_types: self.additional_auth_types,
                api_name: self.api_name,
                conflict_resolution: self.conflict_resolution,
                default_auth_type: self.default_auth_type,
                service: self.service,
                transform_schema: self.transform_schema,
            }
        }
    }
}
impl BackendApiResourceConfig {
    /// Creates a new builder-style object to manufacture [`BackendApiResourceConfig`](crate::model::BackendApiResourceConfig)
    pub fn builder() -> crate::model::backend_api_resource_config::Builder {
        crate::model::backend_api_resource_config::Builder::default()
    }
}

/// <p>Describes the auth types for your configured data models.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendApiAuthType {
    /// <p>Describes the authentication mode.</p>
    pub mode: std::option::Option<crate::model::Mode>,
    /// <p>Describes settings for the authentication mode.</p>
    pub settings: std::option::Option<crate::model::BackendApiAppSyncAuthSettings>,
}
impl std::fmt::Debug for BackendApiAuthType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendApiAuthType");
        formatter.field("mode", &self.mode);
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}
/// See [`BackendApiAuthType`](crate::model::BackendApiAuthType)
pub mod backend_api_auth_type {
    /// A builder for [`BackendApiAuthType`](crate::model::BackendApiAuthType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<crate::model::Mode>,
        pub(crate) settings: std::option::Option<crate::model::BackendApiAppSyncAuthSettings>,
    }
    impl Builder {
        /// <p>Describes the authentication mode.</p>
        pub fn mode(mut self, input: crate::model::Mode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Describes the authentication mode.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::Mode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>Describes settings for the authentication mode.</p>
        pub fn settings(mut self, input: crate::model::BackendApiAppSyncAuthSettings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p>Describes settings for the authentication mode.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::BackendApiAppSyncAuthSettings>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendApiAuthType`](crate::model::BackendApiAuthType)
        pub fn build(self) -> crate::model::BackendApiAuthType {
            crate::model::BackendApiAuthType {
                mode: self.mode,
                settings: self.settings,
            }
        }
    }
}
impl BackendApiAuthType {
    /// Creates a new builder-style object to manufacture [`BackendApiAuthType`](crate::model::BackendApiAuthType)
    pub fn builder() -> crate::model::backend_api_auth_type::Builder {
        crate::model::backend_api_auth_type::Builder::default()
    }
}

/// <p>The authentication settings for accessing provisioned data models in your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendApiAppSyncAuthSettings {
    /// <p>The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication setting to access your data models.</p>
    pub cognito_user_pool_id: std::option::Option<std::string::String>,
    /// <p>The API key description for API_KEY, if it was used as an authentication mechanism to access your data models.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The API key expiration time for API_KEY, if it was used as an authentication mechanism to access your data models.</p>
    pub expiration_time: f64,
    /// <p>The expiry time for the OpenID authentication mechanism.</p>
    pub open_id_auth_ttl: std::option::Option<std::string::String>,
    /// <p>The clientID for openID, if openID was used as an authentication setting to access your data models.</p>
    pub open_id_client_id: std::option::Option<std::string::String>,
    /// <p>The expiry time for the OpenID authentication mechanism.</p>
    pub open_id_iat_ttl: std::option::Option<std::string::String>,
    /// <p>The openID issuer URL, if openID was used as an authentication setting to access your data models.</p>
    pub open_id_issue_url: std::option::Option<std::string::String>,
    /// <p>The OpenID provider name, if OpenID was used as an authentication mechanism to access your data models.</p>
    pub open_id_provider_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackendApiAppSyncAuthSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendApiAppSyncAuthSettings");
        formatter.field("cognito_user_pool_id", &self.cognito_user_pool_id);
        formatter.field("description", &self.description);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.field("open_id_auth_ttl", &self.open_id_auth_ttl);
        formatter.field("open_id_client_id", &self.open_id_client_id);
        formatter.field("open_id_iat_ttl", &self.open_id_iat_ttl);
        formatter.field("open_id_issue_url", &self.open_id_issue_url);
        formatter.field("open_id_provider_name", &self.open_id_provider_name);
        formatter.finish()
    }
}
/// See [`BackendApiAppSyncAuthSettings`](crate::model::BackendApiAppSyncAuthSettings)
pub mod backend_api_app_sync_auth_settings {
    /// A builder for [`BackendApiAppSyncAuthSettings`](crate::model::BackendApiAppSyncAuthSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cognito_user_pool_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) expiration_time: std::option::Option<f64>,
        pub(crate) open_id_auth_ttl: std::option::Option<std::string::String>,
        pub(crate) open_id_client_id: std::option::Option<std::string::String>,
        pub(crate) open_id_iat_ttl: std::option::Option<std::string::String>,
        pub(crate) open_id_issue_url: std::option::Option<std::string::String>,
        pub(crate) open_id_provider_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication setting to access your data models.</p>
        pub fn cognito_user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cognito_user_pool_id = Some(input.into());
            self
        }
        /// <p>The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication setting to access your data models.</p>
        pub fn set_cognito_user_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cognito_user_pool_id = input;
            self
        }
        /// <p>The API key description for API_KEY, if it was used as an authentication mechanism to access your data models.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The API key description for API_KEY, if it was used as an authentication mechanism to access your data models.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The API key expiration time for API_KEY, if it was used as an authentication mechanism to access your data models.</p>
        pub fn expiration_time(mut self, input: f64) -> Self {
            self.expiration_time = Some(input);
            self
        }
        /// <p>The API key expiration time for API_KEY, if it was used as an authentication mechanism to access your data models.</p>
        pub fn set_expiration_time(mut self, input: std::option::Option<f64>) -> Self {
            self.expiration_time = input;
            self
        }
        /// <p>The expiry time for the OpenID authentication mechanism.</p>
        pub fn open_id_auth_ttl(mut self, input: impl Into<std::string::String>) -> Self {
            self.open_id_auth_ttl = Some(input.into());
            self
        }
        /// <p>The expiry time for the OpenID authentication mechanism.</p>
        pub fn set_open_id_auth_ttl(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_auth_ttl = input;
            self
        }
        /// <p>The clientID for openID, if openID was used as an authentication setting to access your data models.</p>
        pub fn open_id_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.open_id_client_id = Some(input.into());
            self
        }
        /// <p>The clientID for openID, if openID was used as an authentication setting to access your data models.</p>
        pub fn set_open_id_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_client_id = input;
            self
        }
        /// <p>The expiry time for the OpenID authentication mechanism.</p>
        pub fn open_id_iat_ttl(mut self, input: impl Into<std::string::String>) -> Self {
            self.open_id_iat_ttl = Some(input.into());
            self
        }
        /// <p>The expiry time for the OpenID authentication mechanism.</p>
        pub fn set_open_id_iat_ttl(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_iat_ttl = input;
            self
        }
        /// <p>The openID issuer URL, if openID was used as an authentication setting to access your data models.</p>
        pub fn open_id_issue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.open_id_issue_url = Some(input.into());
            self
        }
        /// <p>The openID issuer URL, if openID was used as an authentication setting to access your data models.</p>
        pub fn set_open_id_issue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_issue_url = input;
            self
        }
        /// <p>The OpenID provider name, if OpenID was used as an authentication mechanism to access your data models.</p>
        pub fn open_id_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.open_id_provider_name = Some(input.into());
            self
        }
        /// <p>The OpenID provider name, if OpenID was used as an authentication mechanism to access your data models.</p>
        pub fn set_open_id_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_provider_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendApiAppSyncAuthSettings`](crate::model::BackendApiAppSyncAuthSettings)
        pub fn build(self) -> crate::model::BackendApiAppSyncAuthSettings {
            crate::model::BackendApiAppSyncAuthSettings {
                cognito_user_pool_id: self.cognito_user_pool_id,
                description: self.description,
                expiration_time: self.expiration_time.unwrap_or_default(),
                open_id_auth_ttl: self.open_id_auth_ttl,
                open_id_client_id: self.open_id_client_id,
                open_id_iat_ttl: self.open_id_iat_ttl,
                open_id_issue_url: self.open_id_issue_url,
                open_id_provider_name: self.open_id_provider_name,
            }
        }
    }
}
impl BackendApiAppSyncAuthSettings {
    /// Creates a new builder-style object to manufacture [`BackendApiAppSyncAuthSettings`](crate::model::BackendApiAppSyncAuthSettings)
    pub fn builder() -> crate::model::backend_api_app_sync_auth_settings::Builder {
        crate::model::backend_api_app_sync_auth_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mode {
    #[allow(missing_docs)] // documentation missing in model
    AmazonCognitoUserPools,
    #[allow(missing_docs)] // documentation missing in model
    ApiKey,
    #[allow(missing_docs)] // documentation missing in model
    AwsIam,
    #[allow(missing_docs)] // documentation missing in model
    OpenidConnect,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mode {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_COGNITO_USER_POOLS" => Mode::AmazonCognitoUserPools,
            "API_KEY" => Mode::ApiKey,
            "AWS_IAM" => Mode::AwsIam,
            "OPENID_CONNECT" => Mode::OpenidConnect,
            other => Mode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mode::from(s))
    }
}
impl Mode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mode::AmazonCognitoUserPools => "AMAZON_COGNITO_USER_POOLS",
            Mode::ApiKey => "API_KEY",
            Mode::AwsIam => "AWS_IAM",
            Mode::OpenidConnect => "OPENID_CONNECT",
            Mode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMAZON_COGNITO_USER_POOLS",
            "API_KEY",
            "AWS_IAM",
            "OPENID_CONNECT",
        ]
    }
}
impl AsRef<str> for Mode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the conflict resolution configuration for your data model configured in your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendApiConflictResolution {
    /// <p>The strategy for conflict resolution.</p>
    pub resolution_strategy: std::option::Option<crate::model::ResolutionStrategy>,
}
impl std::fmt::Debug for BackendApiConflictResolution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendApiConflictResolution");
        formatter.field("resolution_strategy", &self.resolution_strategy);
        formatter.finish()
    }
}
/// See [`BackendApiConflictResolution`](crate::model::BackendApiConflictResolution)
pub mod backend_api_conflict_resolution {
    /// A builder for [`BackendApiConflictResolution`](crate::model::BackendApiConflictResolution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolution_strategy: std::option::Option<crate::model::ResolutionStrategy>,
    }
    impl Builder {
        /// <p>The strategy for conflict resolution.</p>
        pub fn resolution_strategy(mut self, input: crate::model::ResolutionStrategy) -> Self {
            self.resolution_strategy = Some(input);
            self
        }
        /// <p>The strategy for conflict resolution.</p>
        pub fn set_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ResolutionStrategy>,
        ) -> Self {
            self.resolution_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendApiConflictResolution`](crate::model::BackendApiConflictResolution)
        pub fn build(self) -> crate::model::BackendApiConflictResolution {
            crate::model::BackendApiConflictResolution {
                resolution_strategy: self.resolution_strategy,
            }
        }
    }
}
impl BackendApiConflictResolution {
    /// Creates a new builder-style object to manufacture [`BackendApiConflictResolution`](crate::model::BackendApiConflictResolution)
    pub fn builder() -> crate::model::backend_api_conflict_resolution::Builder {
        crate::model::backend_api_conflict_resolution::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolutionStrategy {
    #[allow(missing_docs)] // documentation missing in model
    Automerge,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    OptimisticConcurrency,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolutionStrategy {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMERGE" => ResolutionStrategy::Automerge,
            "LAMBDA" => ResolutionStrategy::Lambda,
            "NONE" => ResolutionStrategy::None,
            "OPTIMISTIC_CONCURRENCY" => ResolutionStrategy::OptimisticConcurrency,
            other => ResolutionStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolutionStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolutionStrategy::from(s))
    }
}
impl ResolutionStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolutionStrategy::Automerge => "AUTOMERGE",
            ResolutionStrategy::Lambda => "LAMBDA",
            ResolutionStrategy::None => "NONE",
            ResolutionStrategy::OptimisticConcurrency => "OPTIMISTIC_CONCURRENCY",
            ResolutionStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMERGE", "LAMBDA", "NONE", "OPTIMISTIC_CONCURRENCY"]
    }
}
impl AsRef<str> for ResolutionStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The response object for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendJobRespObj {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The time when the job was created.</p>
    pub create_time: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time when the job was last updated.</p>
    pub update_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackendJobRespObj {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendJobRespObj");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("create_time", &self.create_time);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`BackendJobRespObj`](crate::model::BackendJobRespObj)
pub mod backend_job_resp_obj {
    /// A builder for [`BackendJobRespObj`](crate::model::BackendJobRespObj)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) update_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The time when the job was created.</p>
        pub fn create_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.create_time = Some(input.into());
            self
        }
        /// <p>The time when the job was created.</p>
        pub fn set_create_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time when the job was last updated.</p>
        pub fn update_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_time = Some(input.into());
            self
        }
        /// <p>The time when the job was last updated.</p>
        pub fn set_update_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendJobRespObj`](crate::model::BackendJobRespObj)
        pub fn build(self) -> crate::model::BackendJobRespObj {
            crate::model::BackendJobRespObj {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                create_time: self.create_time,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
                update_time: self.update_time,
            }
        }
    }
}
impl BackendJobRespObj {
    /// Creates a new builder-style object to manufacture [`BackendJobRespObj`](crate::model::BackendJobRespObj)
    pub fn builder() -> crate::model::backend_job_resp_obj::Builder {
        crate::model::backend_job_resp_obj::Builder::default()
    }
}

/// <p>Defines the resource configuration when creating an auth resource in your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendAuthResourceConfig {
    /// <p>Defines whether you want to configure only authentication or both authentication and authorization settings.</p>
    pub auth_resources: std::option::Option<crate::model::AuthResources>,
    /// <p>Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of your auth resource in the Amplify project.</p>
    pub identity_pool_configs:
        std::option::Option<crate::model::CreateBackendAuthIdentityPoolConfig>,
    /// <p>Defines the service name to use when configuring an authentication resource in your Amplify project.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>Describes authentication configuration for the Amazon Cognito user pool, provisioned as a part of your auth resource in the Amplify project.</p>
    pub user_pool_configs: std::option::Option<crate::model::CreateBackendAuthUserPoolConfig>,
}
impl std::fmt::Debug for CreateBackendAuthResourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendAuthResourceConfig");
        formatter.field("auth_resources", &self.auth_resources);
        formatter.field("identity_pool_configs", &self.identity_pool_configs);
        formatter.field("service", &self.service);
        formatter.field("user_pool_configs", &self.user_pool_configs);
        formatter.finish()
    }
}
/// See [`CreateBackendAuthResourceConfig`](crate::model::CreateBackendAuthResourceConfig)
pub mod create_backend_auth_resource_config {
    /// A builder for [`CreateBackendAuthResourceConfig`](crate::model::CreateBackendAuthResourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auth_resources: std::option::Option<crate::model::AuthResources>,
        pub(crate) identity_pool_configs:
            std::option::Option<crate::model::CreateBackendAuthIdentityPoolConfig>,
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) user_pool_configs:
            std::option::Option<crate::model::CreateBackendAuthUserPoolConfig>,
    }
    impl Builder {
        /// <p>Defines whether you want to configure only authentication or both authentication and authorization settings.</p>
        pub fn auth_resources(mut self, input: crate::model::AuthResources) -> Self {
            self.auth_resources = Some(input);
            self
        }
        /// <p>Defines whether you want to configure only authentication or both authentication and authorization settings.</p>
        pub fn set_auth_resources(
            mut self,
            input: std::option::Option<crate::model::AuthResources>,
        ) -> Self {
            self.auth_resources = input;
            self
        }
        /// <p>Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of your auth resource in the Amplify project.</p>
        pub fn identity_pool_configs(
            mut self,
            input: crate::model::CreateBackendAuthIdentityPoolConfig,
        ) -> Self {
            self.identity_pool_configs = Some(input);
            self
        }
        /// <p>Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of your auth resource in the Amplify project.</p>
        pub fn set_identity_pool_configs(
            mut self,
            input: std::option::Option<crate::model::CreateBackendAuthIdentityPoolConfig>,
        ) -> Self {
            self.identity_pool_configs = input;
            self
        }
        /// <p>Defines the service name to use when configuring an authentication resource in your Amplify project.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>Defines the service name to use when configuring an authentication resource in your Amplify project.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>Describes authentication configuration for the Amazon Cognito user pool, provisioned as a part of your auth resource in the Amplify project.</p>
        pub fn user_pool_configs(
            mut self,
            input: crate::model::CreateBackendAuthUserPoolConfig,
        ) -> Self {
            self.user_pool_configs = Some(input);
            self
        }
        /// <p>Describes authentication configuration for the Amazon Cognito user pool, provisioned as a part of your auth resource in the Amplify project.</p>
        pub fn set_user_pool_configs(
            mut self,
            input: std::option::Option<crate::model::CreateBackendAuthUserPoolConfig>,
        ) -> Self {
            self.user_pool_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendAuthResourceConfig`](crate::model::CreateBackendAuthResourceConfig)
        pub fn build(self) -> crate::model::CreateBackendAuthResourceConfig {
            crate::model::CreateBackendAuthResourceConfig {
                auth_resources: self.auth_resources,
                identity_pool_configs: self.identity_pool_configs,
                service: self.service,
                user_pool_configs: self.user_pool_configs,
            }
        }
    }
}
impl CreateBackendAuthResourceConfig {
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthResourceConfig`](crate::model::CreateBackendAuthResourceConfig)
    pub fn builder() -> crate::model::create_backend_auth_resource_config::Builder {
        crate::model::create_backend_auth_resource_config::Builder::default()
    }
}

/// <p>Describes the Amazon Cognito user pool configuration for the auth resource to be configured for your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendAuthUserPoolConfig {
    /// <p>Describes the forgotten password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
    pub forgot_password: std::option::Option<crate::model::CreateBackendAuthForgotPasswordConfig>,
    /// <p>Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured as a part of your Amplify project.</p>
    pub mfa: std::option::Option<crate::model::CreateBackendAuthMfaConfig>,
    /// <p>Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
    pub o_auth: std::option::Option<crate::model::CreateBackendAuthOAuthConfig>,
    /// <p>Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
    pub password_policy: std::option::Option<crate::model::CreateBackendAuthPasswordPolicyConfig>,
    /// <p>The required attributes to sign up new users in the user pool.</p>
    pub required_sign_up_attributes:
        std::option::Option<std::vec::Vec<crate::model::RequiredSignUpAttributesElement>>,
    /// <p>Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user pool, configured as a part of your Amplify project.</p>
    pub sign_in_method: std::option::Option<crate::model::SignInMethod>,
    /// <p>The Amazon Cognito user pool name.</p>
    pub user_pool_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateBackendAuthUserPoolConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendAuthUserPoolConfig");
        formatter.field("forgot_password", &self.forgot_password);
        formatter.field("mfa", &self.mfa);
        formatter.field("o_auth", &self.o_auth);
        formatter.field("password_policy", &self.password_policy);
        formatter.field(
            "required_sign_up_attributes",
            &self.required_sign_up_attributes,
        );
        formatter.field("sign_in_method", &self.sign_in_method);
        formatter.field("user_pool_name", &self.user_pool_name);
        formatter.finish()
    }
}
/// See [`CreateBackendAuthUserPoolConfig`](crate::model::CreateBackendAuthUserPoolConfig)
pub mod create_backend_auth_user_pool_config {
    /// A builder for [`CreateBackendAuthUserPoolConfig`](crate::model::CreateBackendAuthUserPoolConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forgot_password:
            std::option::Option<crate::model::CreateBackendAuthForgotPasswordConfig>,
        pub(crate) mfa: std::option::Option<crate::model::CreateBackendAuthMfaConfig>,
        pub(crate) o_auth: std::option::Option<crate::model::CreateBackendAuthOAuthConfig>,
        pub(crate) password_policy:
            std::option::Option<crate::model::CreateBackendAuthPasswordPolicyConfig>,
        pub(crate) required_sign_up_attributes:
            std::option::Option<std::vec::Vec<crate::model::RequiredSignUpAttributesElement>>,
        pub(crate) sign_in_method: std::option::Option<crate::model::SignInMethod>,
        pub(crate) user_pool_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes the forgotten password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn forgot_password(
            mut self,
            input: crate::model::CreateBackendAuthForgotPasswordConfig,
        ) -> Self {
            self.forgot_password = Some(input);
            self
        }
        /// <p>Describes the forgotten password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn set_forgot_password(
            mut self,
            input: std::option::Option<crate::model::CreateBackendAuthForgotPasswordConfig>,
        ) -> Self {
            self.forgot_password = input;
            self
        }
        /// <p>Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured as a part of your Amplify project.</p>
        pub fn mfa(mut self, input: crate::model::CreateBackendAuthMfaConfig) -> Self {
            self.mfa = Some(input);
            self
        }
        /// <p>Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured as a part of your Amplify project.</p>
        pub fn set_mfa(
            mut self,
            input: std::option::Option<crate::model::CreateBackendAuthMfaConfig>,
        ) -> Self {
            self.mfa = input;
            self
        }
        /// <p>Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn o_auth(mut self, input: crate::model::CreateBackendAuthOAuthConfig) -> Self {
            self.o_auth = Some(input);
            self
        }
        /// <p>Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn set_o_auth(
            mut self,
            input: std::option::Option<crate::model::CreateBackendAuthOAuthConfig>,
        ) -> Self {
            self.o_auth = input;
            self
        }
        /// <p>Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn password_policy(
            mut self,
            input: crate::model::CreateBackendAuthPasswordPolicyConfig,
        ) -> Self {
            self.password_policy = Some(input);
            self
        }
        /// <p>Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn set_password_policy(
            mut self,
            input: std::option::Option<crate::model::CreateBackendAuthPasswordPolicyConfig>,
        ) -> Self {
            self.password_policy = input;
            self
        }
        /// Appends an item to `required_sign_up_attributes`.
        ///
        /// To override the contents of this collection use [`set_required_sign_up_attributes`](Self::set_required_sign_up_attributes).
        ///
        /// <p>The required attributes to sign up new users in the user pool.</p>
        pub fn required_sign_up_attributes(
            mut self,
            input: impl Into<crate::model::RequiredSignUpAttributesElement>,
        ) -> Self {
            let mut v = self.required_sign_up_attributes.unwrap_or_default();
            v.push(input.into());
            self.required_sign_up_attributes = Some(v);
            self
        }
        /// <p>The required attributes to sign up new users in the user pool.</p>
        pub fn set_required_sign_up_attributes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RequiredSignUpAttributesElement>,
            >,
        ) -> Self {
            self.required_sign_up_attributes = input;
            self
        }
        /// <p>Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn sign_in_method(mut self, input: crate::model::SignInMethod) -> Self {
            self.sign_in_method = Some(input);
            self
        }
        /// <p>Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user pool, configured as a part of your Amplify project.</p>
        pub fn set_sign_in_method(
            mut self,
            input: std::option::Option<crate::model::SignInMethod>,
        ) -> Self {
            self.sign_in_method = input;
            self
        }
        /// <p>The Amazon Cognito user pool name.</p>
        pub fn user_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_name = Some(input.into());
            self
        }
        /// <p>The Amazon Cognito user pool name.</p>
        pub fn set_user_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_pool_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendAuthUserPoolConfig`](crate::model::CreateBackendAuthUserPoolConfig)
        pub fn build(self) -> crate::model::CreateBackendAuthUserPoolConfig {
            crate::model::CreateBackendAuthUserPoolConfig {
                forgot_password: self.forgot_password,
                mfa: self.mfa,
                o_auth: self.o_auth,
                password_policy: self.password_policy,
                required_sign_up_attributes: self.required_sign_up_attributes,
                sign_in_method: self.sign_in_method,
                user_pool_name: self.user_pool_name,
            }
        }
    }
}
impl CreateBackendAuthUserPoolConfig {
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthUserPoolConfig`](crate::model::CreateBackendAuthUserPoolConfig)
    pub fn builder() -> crate::model::create_backend_auth_user_pool_config::Builder {
        crate::model::create_backend_auth_user_pool_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SignInMethod {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    EmailAndPhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    Username,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SignInMethod {
    fn from(s: &str) -> Self {
        match s {
            "EMAIL" => SignInMethod::Email,
            "EMAIL_AND_PHONE_NUMBER" => SignInMethod::EmailAndPhoneNumber,
            "PHONE_NUMBER" => SignInMethod::PhoneNumber,
            "USERNAME" => SignInMethod::Username,
            other => SignInMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SignInMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SignInMethod::from(s))
    }
}
impl SignInMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SignInMethod::Email => "EMAIL",
            SignInMethod::EmailAndPhoneNumber => "EMAIL_AND_PHONE_NUMBER",
            SignInMethod::PhoneNumber => "PHONE_NUMBER",
            SignInMethod::Username => "USERNAME",
            SignInMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EMAIL",
            "EMAIL_AND_PHONE_NUMBER",
            "PHONE_NUMBER",
            "USERNAME",
        ]
    }
}
impl AsRef<str> for SignInMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequiredSignUpAttributesElement {
    #[allow(missing_docs)] // documentation missing in model
    Address,
    #[allow(missing_docs)] // documentation missing in model
    Birthdate,
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    FamilyName,
    #[allow(missing_docs)] // documentation missing in model
    Gender,
    #[allow(missing_docs)] // documentation missing in model
    GivenName,
    #[allow(missing_docs)] // documentation missing in model
    Locale,
    #[allow(missing_docs)] // documentation missing in model
    MiddleName,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Nickname,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    Picture,
    #[allow(missing_docs)] // documentation missing in model
    PreferredUsername,
    #[allow(missing_docs)] // documentation missing in model
    Profile,
    #[allow(missing_docs)] // documentation missing in model
    UpdatedAt,
    #[allow(missing_docs)] // documentation missing in model
    Website,
    #[allow(missing_docs)] // documentation missing in model
    ZoneInfo,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequiredSignUpAttributesElement {
    fn from(s: &str) -> Self {
        match s {
            "ADDRESS" => RequiredSignUpAttributesElement::Address,
            "BIRTHDATE" => RequiredSignUpAttributesElement::Birthdate,
            "EMAIL" => RequiredSignUpAttributesElement::Email,
            "FAMILY_NAME" => RequiredSignUpAttributesElement::FamilyName,
            "GENDER" => RequiredSignUpAttributesElement::Gender,
            "GIVEN_NAME" => RequiredSignUpAttributesElement::GivenName,
            "LOCALE" => RequiredSignUpAttributesElement::Locale,
            "MIDDLE_NAME" => RequiredSignUpAttributesElement::MiddleName,
            "NAME" => RequiredSignUpAttributesElement::Name,
            "NICKNAME" => RequiredSignUpAttributesElement::Nickname,
            "PHONE_NUMBER" => RequiredSignUpAttributesElement::PhoneNumber,
            "PICTURE" => RequiredSignUpAttributesElement::Picture,
            "PREFERRED_USERNAME" => RequiredSignUpAttributesElement::PreferredUsername,
            "PROFILE" => RequiredSignUpAttributesElement::Profile,
            "UPDATED_AT" => RequiredSignUpAttributesElement::UpdatedAt,
            "WEBSITE" => RequiredSignUpAttributesElement::Website,
            "ZONE_INFO" => RequiredSignUpAttributesElement::ZoneInfo,
            other => RequiredSignUpAttributesElement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequiredSignUpAttributesElement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequiredSignUpAttributesElement::from(s))
    }
}
impl RequiredSignUpAttributesElement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequiredSignUpAttributesElement::Address => "ADDRESS",
            RequiredSignUpAttributesElement::Birthdate => "BIRTHDATE",
            RequiredSignUpAttributesElement::Email => "EMAIL",
            RequiredSignUpAttributesElement::FamilyName => "FAMILY_NAME",
            RequiredSignUpAttributesElement::Gender => "GENDER",
            RequiredSignUpAttributesElement::GivenName => "GIVEN_NAME",
            RequiredSignUpAttributesElement::Locale => "LOCALE",
            RequiredSignUpAttributesElement::MiddleName => "MIDDLE_NAME",
            RequiredSignUpAttributesElement::Name => "NAME",
            RequiredSignUpAttributesElement::Nickname => "NICKNAME",
            RequiredSignUpAttributesElement::PhoneNumber => "PHONE_NUMBER",
            RequiredSignUpAttributesElement::Picture => "PICTURE",
            RequiredSignUpAttributesElement::PreferredUsername => "PREFERRED_USERNAME",
            RequiredSignUpAttributesElement::Profile => "PROFILE",
            RequiredSignUpAttributesElement::UpdatedAt => "UPDATED_AT",
            RequiredSignUpAttributesElement::Website => "WEBSITE",
            RequiredSignUpAttributesElement::ZoneInfo => "ZONE_INFO",
            RequiredSignUpAttributesElement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDRESS",
            "BIRTHDATE",
            "EMAIL",
            "FAMILY_NAME",
            "GENDER",
            "GIVEN_NAME",
            "LOCALE",
            "MIDDLE_NAME",
            "NAME",
            "NICKNAME",
            "PHONE_NUMBER",
            "PICTURE",
            "PREFERRED_USERNAME",
            "PROFILE",
            "UPDATED_AT",
            "WEBSITE",
            "ZONE_INFO",
        ]
    }
}
impl AsRef<str> for RequiredSignUpAttributesElement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The password policy configuration for the backend to your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendAuthPasswordPolicyConfig {
    /// <p>Additional constraints for the password used to access the backend of your Amplify project.</p>
    pub additional_constraints:
        std::option::Option<std::vec::Vec<crate::model::AdditionalConstraintsElement>>,
    /// <p>The minimum length of the password used to access the backend of your Amplify project.</p>
    pub minimum_length: f64,
}
impl std::fmt::Debug for CreateBackendAuthPasswordPolicyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendAuthPasswordPolicyConfig");
        formatter.field("additional_constraints", &self.additional_constraints);
        formatter.field("minimum_length", &self.minimum_length);
        formatter.finish()
    }
}
/// See [`CreateBackendAuthPasswordPolicyConfig`](crate::model::CreateBackendAuthPasswordPolicyConfig)
pub mod create_backend_auth_password_policy_config {
    /// A builder for [`CreateBackendAuthPasswordPolicyConfig`](crate::model::CreateBackendAuthPasswordPolicyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) additional_constraints:
            std::option::Option<std::vec::Vec<crate::model::AdditionalConstraintsElement>>,
        pub(crate) minimum_length: std::option::Option<f64>,
    }
    impl Builder {
        /// Appends an item to `additional_constraints`.
        ///
        /// To override the contents of this collection use [`set_additional_constraints`](Self::set_additional_constraints).
        ///
        /// <p>Additional constraints for the password used to access the backend of your Amplify project.</p>
        pub fn additional_constraints(
            mut self,
            input: impl Into<crate::model::AdditionalConstraintsElement>,
        ) -> Self {
            let mut v = self.additional_constraints.unwrap_or_default();
            v.push(input.into());
            self.additional_constraints = Some(v);
            self
        }
        /// <p>Additional constraints for the password used to access the backend of your Amplify project.</p>
        pub fn set_additional_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdditionalConstraintsElement>>,
        ) -> Self {
            self.additional_constraints = input;
            self
        }
        /// <p>The minimum length of the password used to access the backend of your Amplify project.</p>
        pub fn minimum_length(mut self, input: f64) -> Self {
            self.minimum_length = Some(input);
            self
        }
        /// <p>The minimum length of the password used to access the backend of your Amplify project.</p>
        pub fn set_minimum_length(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum_length = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendAuthPasswordPolicyConfig`](crate::model::CreateBackendAuthPasswordPolicyConfig)
        pub fn build(self) -> crate::model::CreateBackendAuthPasswordPolicyConfig {
            crate::model::CreateBackendAuthPasswordPolicyConfig {
                additional_constraints: self.additional_constraints,
                minimum_length: self.minimum_length.unwrap_or_default(),
            }
        }
    }
}
impl CreateBackendAuthPasswordPolicyConfig {
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthPasswordPolicyConfig`](crate::model::CreateBackendAuthPasswordPolicyConfig)
    pub fn builder() -> crate::model::create_backend_auth_password_policy_config::Builder {
        crate::model::create_backend_auth_password_policy_config::Builder::default()
    }
}

/// <p>Creates the OAuth configuration for your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendAuthOAuthConfig {
    /// <p>The domain prefix for your Amplify app.</p>
    pub domain_prefix: std::option::Option<std::string::String>,
    /// <p>The OAuth grant type that you use to allow app users to authenticate from your Amplify app.</p>
    pub o_auth_grant_type: std::option::Option<crate::model::OAuthGrantType>,
    /// <p>List of OAuth-related flows used to allow your app users to authenticate from your Amplify app.</p>
    pub o_auth_scopes: std::option::Option<std::vec::Vec<crate::model::OAuthScopesElement>>,
    /// <p>The redirected URI for signing in to your Amplify app.</p>
    pub redirect_sign_in_ur_is: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Redirect URLs that OAuth uses when a user signs out of an Amplify app.</p>
    pub redirect_sign_out_ur_is: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The settings for using social providers to access your Amplify app.</p>
    pub social_provider_settings: std::option::Option<crate::model::SocialProviderSettings>,
}
impl std::fmt::Debug for CreateBackendAuthOAuthConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendAuthOAuthConfig");
        formatter.field("domain_prefix", &self.domain_prefix);
        formatter.field("o_auth_grant_type", &self.o_auth_grant_type);
        formatter.field("o_auth_scopes", &self.o_auth_scopes);
        formatter.field("redirect_sign_in_ur_is", &self.redirect_sign_in_ur_is);
        formatter.field("redirect_sign_out_ur_is", &self.redirect_sign_out_ur_is);
        formatter.field("social_provider_settings", &self.social_provider_settings);
        formatter.finish()
    }
}
/// See [`CreateBackendAuthOAuthConfig`](crate::model::CreateBackendAuthOAuthConfig)
pub mod create_backend_auth_o_auth_config {
    /// A builder for [`CreateBackendAuthOAuthConfig`](crate::model::CreateBackendAuthOAuthConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_prefix: std::option::Option<std::string::String>,
        pub(crate) o_auth_grant_type: std::option::Option<crate::model::OAuthGrantType>,
        pub(crate) o_auth_scopes:
            std::option::Option<std::vec::Vec<crate::model::OAuthScopesElement>>,
        pub(crate) redirect_sign_in_ur_is: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) redirect_sign_out_ur_is: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) social_provider_settings:
            std::option::Option<crate::model::SocialProviderSettings>,
    }
    impl Builder {
        /// <p>The domain prefix for your Amplify app.</p>
        pub fn domain_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_prefix = Some(input.into());
            self
        }
        /// <p>The domain prefix for your Amplify app.</p>
        pub fn set_domain_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_prefix = input;
            self
        }
        /// <p>The OAuth grant type that you use to allow app users to authenticate from your Amplify app.</p>
        pub fn o_auth_grant_type(mut self, input: crate::model::OAuthGrantType) -> Self {
            self.o_auth_grant_type = Some(input);
            self
        }
        /// <p>The OAuth grant type that you use to allow app users to authenticate from your Amplify app.</p>
        pub fn set_o_auth_grant_type(
            mut self,
            input: std::option::Option<crate::model::OAuthGrantType>,
        ) -> Self {
            self.o_auth_grant_type = input;
            self
        }
        /// Appends an item to `o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_o_auth_scopes`](Self::set_o_auth_scopes).
        ///
        /// <p>List of OAuth-related flows used to allow your app users to authenticate from your Amplify app.</p>
        pub fn o_auth_scopes(mut self, input: impl Into<crate::model::OAuthScopesElement>) -> Self {
            let mut v = self.o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.o_auth_scopes = Some(v);
            self
        }
        /// <p>List of OAuth-related flows used to allow your app users to authenticate from your Amplify app.</p>
        pub fn set_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OAuthScopesElement>>,
        ) -> Self {
            self.o_auth_scopes = input;
            self
        }
        /// Appends an item to `redirect_sign_in_ur_is`.
        ///
        /// To override the contents of this collection use [`set_redirect_sign_in_ur_is`](Self::set_redirect_sign_in_ur_is).
        ///
        /// <p>The redirected URI for signing in to your Amplify app.</p>
        pub fn redirect_sign_in_ur_is(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.redirect_sign_in_ur_is.unwrap_or_default();
            v.push(input.into());
            self.redirect_sign_in_ur_is = Some(v);
            self
        }
        /// <p>The redirected URI for signing in to your Amplify app.</p>
        pub fn set_redirect_sign_in_ur_is(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.redirect_sign_in_ur_is = input;
            self
        }
        /// Appends an item to `redirect_sign_out_ur_is`.
        ///
        /// To override the contents of this collection use [`set_redirect_sign_out_ur_is`](Self::set_redirect_sign_out_ur_is).
        ///
        /// <p>Redirect URLs that OAuth uses when a user signs out of an Amplify app.</p>
        pub fn redirect_sign_out_ur_is(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.redirect_sign_out_ur_is.unwrap_or_default();
            v.push(input.into());
            self.redirect_sign_out_ur_is = Some(v);
            self
        }
        /// <p>Redirect URLs that OAuth uses when a user signs out of an Amplify app.</p>
        pub fn set_redirect_sign_out_ur_is(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.redirect_sign_out_ur_is = input;
            self
        }
        /// <p>The settings for using social providers to access your Amplify app.</p>
        pub fn social_provider_settings(
            mut self,
            input: crate::model::SocialProviderSettings,
        ) -> Self {
            self.social_provider_settings = Some(input);
            self
        }
        /// <p>The settings for using social providers to access your Amplify app.</p>
        pub fn set_social_provider_settings(
            mut self,
            input: std::option::Option<crate::model::SocialProviderSettings>,
        ) -> Self {
            self.social_provider_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendAuthOAuthConfig`](crate::model::CreateBackendAuthOAuthConfig)
        pub fn build(self) -> crate::model::CreateBackendAuthOAuthConfig {
            crate::model::CreateBackendAuthOAuthConfig {
                domain_prefix: self.domain_prefix,
                o_auth_grant_type: self.o_auth_grant_type,
                o_auth_scopes: self.o_auth_scopes,
                redirect_sign_in_ur_is: self.redirect_sign_in_ur_is,
                redirect_sign_out_ur_is: self.redirect_sign_out_ur_is,
                social_provider_settings: self.social_provider_settings,
            }
        }
    }
}
impl CreateBackendAuthOAuthConfig {
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthOAuthConfig`](crate::model::CreateBackendAuthOAuthConfig)
    pub fn builder() -> crate::model::create_backend_auth_o_auth_config::Builder {
        crate::model::create_backend_auth_o_auth_config::Builder::default()
    }
}

/// <p>Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured as a part of your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendAuthMfaConfig {
    /// <p>Describes whether MFA should be [ON, OFF, or OPTIONAL] for authentication in your Amplify project.</p>
    pub mfa_mode: std::option::Option<crate::model::MfaMode>,
    /// <p>Describes the configuration settings and methods for your Amplify app users to use MFA.</p>
    pub settings: std::option::Option<crate::model::Settings>,
}
impl std::fmt::Debug for CreateBackendAuthMfaConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendAuthMfaConfig");
        formatter.field("mfa_mode", &self.mfa_mode);
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}
/// See [`CreateBackendAuthMfaConfig`](crate::model::CreateBackendAuthMfaConfig)
pub mod create_backend_auth_mfa_config {
    /// A builder for [`CreateBackendAuthMfaConfig`](crate::model::CreateBackendAuthMfaConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mfa_mode: std::option::Option<crate::model::MfaMode>,
        pub(crate) settings: std::option::Option<crate::model::Settings>,
    }
    impl Builder {
        /// <p>Describes whether MFA should be [ON, OFF, or OPTIONAL] for authentication in your Amplify project.</p>
        pub fn mfa_mode(mut self, input: crate::model::MfaMode) -> Self {
            self.mfa_mode = Some(input);
            self
        }
        /// <p>Describes whether MFA should be [ON, OFF, or OPTIONAL] for authentication in your Amplify project.</p>
        pub fn set_mfa_mode(mut self, input: std::option::Option<crate::model::MfaMode>) -> Self {
            self.mfa_mode = input;
            self
        }
        /// <p>Describes the configuration settings and methods for your Amplify app users to use MFA.</p>
        pub fn settings(mut self, input: crate::model::Settings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p>Describes the configuration settings and methods for your Amplify app users to use MFA.</p>
        pub fn set_settings(mut self, input: std::option::Option<crate::model::Settings>) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendAuthMfaConfig`](crate::model::CreateBackendAuthMfaConfig)
        pub fn build(self) -> crate::model::CreateBackendAuthMfaConfig {
            crate::model::CreateBackendAuthMfaConfig {
                mfa_mode: self.mfa_mode,
                settings: self.settings,
            }
        }
    }
}
impl CreateBackendAuthMfaConfig {
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthMfaConfig`](crate::model::CreateBackendAuthMfaConfig)
    pub fn builder() -> crate::model::create_backend_auth_mfa_config::Builder {
        crate::model::create_backend_auth_mfa_config::Builder::default()
    }
}

/// <p>Describes the forgot password policy for authenticating into the Amplify app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendAuthForgotPasswordConfig {
    /// <p>Describes which mode to use (either SMS or email) to deliver messages to app users who want to recover their password.</p>
    pub delivery_method: std::option::Option<crate::model::DeliveryMethod>,
    /// <p>The configuration for the email sent when an app user forgets their password.</p>
    pub email_settings: std::option::Option<crate::model::EmailSettings>,
    /// <p>The configuration for the SMS message sent when an app user forgets their password.</p>
    pub sms_settings: std::option::Option<crate::model::SmsSettings>,
}
impl std::fmt::Debug for CreateBackendAuthForgotPasswordConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendAuthForgotPasswordConfig");
        formatter.field("delivery_method", &self.delivery_method);
        formatter.field("email_settings", &self.email_settings);
        formatter.field("sms_settings", &self.sms_settings);
        formatter.finish()
    }
}
/// See [`CreateBackendAuthForgotPasswordConfig`](crate::model::CreateBackendAuthForgotPasswordConfig)
pub mod create_backend_auth_forgot_password_config {
    /// A builder for [`CreateBackendAuthForgotPasswordConfig`](crate::model::CreateBackendAuthForgotPasswordConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_method: std::option::Option<crate::model::DeliveryMethod>,
        pub(crate) email_settings: std::option::Option<crate::model::EmailSettings>,
        pub(crate) sms_settings: std::option::Option<crate::model::SmsSettings>,
    }
    impl Builder {
        /// <p>Describes which mode to use (either SMS or email) to deliver messages to app users who want to recover their password.</p>
        pub fn delivery_method(mut self, input: crate::model::DeliveryMethod) -> Self {
            self.delivery_method = Some(input);
            self
        }
        /// <p>Describes which mode to use (either SMS or email) to deliver messages to app users who want to recover their password.</p>
        pub fn set_delivery_method(
            mut self,
            input: std::option::Option<crate::model::DeliveryMethod>,
        ) -> Self {
            self.delivery_method = input;
            self
        }
        /// <p>The configuration for the email sent when an app user forgets their password.</p>
        pub fn email_settings(mut self, input: crate::model::EmailSettings) -> Self {
            self.email_settings = Some(input);
            self
        }
        /// <p>The configuration for the email sent when an app user forgets their password.</p>
        pub fn set_email_settings(
            mut self,
            input: std::option::Option<crate::model::EmailSettings>,
        ) -> Self {
            self.email_settings = input;
            self
        }
        /// <p>The configuration for the SMS message sent when an app user forgets their password.</p>
        pub fn sms_settings(mut self, input: crate::model::SmsSettings) -> Self {
            self.sms_settings = Some(input);
            self
        }
        /// <p>The configuration for the SMS message sent when an app user forgets their password.</p>
        pub fn set_sms_settings(
            mut self,
            input: std::option::Option<crate::model::SmsSettings>,
        ) -> Self {
            self.sms_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendAuthForgotPasswordConfig`](crate::model::CreateBackendAuthForgotPasswordConfig)
        pub fn build(self) -> crate::model::CreateBackendAuthForgotPasswordConfig {
            crate::model::CreateBackendAuthForgotPasswordConfig {
                delivery_method: self.delivery_method,
                email_settings: self.email_settings,
                sms_settings: self.sms_settings,
            }
        }
    }
}
impl CreateBackendAuthForgotPasswordConfig {
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthForgotPasswordConfig`](crate::model::CreateBackendAuthForgotPasswordConfig)
    pub fn builder() -> crate::model::create_backend_auth_forgot_password_config::Builder {
        crate::model::create_backend_auth_forgot_password_config::Builder::default()
    }
}

/// <p>Describes authorization configurations for the auth resources, configured as a part of your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendAuthIdentityPoolConfig {
    /// <p>Name of the Amazon Cognito identity pool used for authorization.</p>
    pub identity_pool_name: std::option::Option<std::string::String>,
    /// <p>Set to true or false based on whether you want to enable guest authorization to your Amplify app.</p>
    pub unauthenticated_login: bool,
}
impl std::fmt::Debug for CreateBackendAuthIdentityPoolConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendAuthIdentityPoolConfig");
        formatter.field("identity_pool_name", &self.identity_pool_name);
        formatter.field("unauthenticated_login", &self.unauthenticated_login);
        formatter.finish()
    }
}
/// See [`CreateBackendAuthIdentityPoolConfig`](crate::model::CreateBackendAuthIdentityPoolConfig)
pub mod create_backend_auth_identity_pool_config {
    /// A builder for [`CreateBackendAuthIdentityPoolConfig`](crate::model::CreateBackendAuthIdentityPoolConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_name: std::option::Option<std::string::String>,
        pub(crate) unauthenticated_login: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Name of the Amazon Cognito identity pool used for authorization.</p>
        pub fn identity_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_name = Some(input.into());
            self
        }
        /// <p>Name of the Amazon Cognito identity pool used for authorization.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_name = input;
            self
        }
        /// <p>Set to true or false based on whether you want to enable guest authorization to your Amplify app.</p>
        pub fn unauthenticated_login(mut self, input: bool) -> Self {
            self.unauthenticated_login = Some(input);
            self
        }
        /// <p>Set to true or false based on whether you want to enable guest authorization to your Amplify app.</p>
        pub fn set_unauthenticated_login(mut self, input: std::option::Option<bool>) -> Self {
            self.unauthenticated_login = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendAuthIdentityPoolConfig`](crate::model::CreateBackendAuthIdentityPoolConfig)
        pub fn build(self) -> crate::model::CreateBackendAuthIdentityPoolConfig {
            crate::model::CreateBackendAuthIdentityPoolConfig {
                identity_pool_name: self.identity_pool_name,
                unauthenticated_login: self.unauthenticated_login.unwrap_or_default(),
            }
        }
    }
}
impl CreateBackendAuthIdentityPoolConfig {
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthIdentityPoolConfig`](crate::model::CreateBackendAuthIdentityPoolConfig)
    pub fn builder() -> crate::model::create_backend_auth_identity_pool_config::Builder {
        crate::model::create_backend_auth_identity_pool_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Latest,
    #[allow(missing_docs)] // documentation missing in model
    Stale,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "LATEST" => Status::Latest,
            "STALE" => Status::Stale,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Latest => "LATEST",
            Status::Stale => "STALE",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LATEST", "STALE"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the resource configuration for the data model in your Amplify project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceConfig {}
impl std::fmt::Debug for ResourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceConfig");
        formatter.finish()
    }
}
/// See [`ResourceConfig`](crate::model::ResourceConfig)
pub mod resource_config {
    /// A builder for [`ResourceConfig`](crate::model::ResourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ResourceConfig`](crate::model::ResourceConfig)
        pub fn build(self) -> crate::model::ResourceConfig {
            crate::model::ResourceConfig {}
        }
    }
}
impl ResourceConfig {
    /// Creates a new builder-style object to manufacture [`ResourceConfig`](crate::model::ResourceConfig)
    pub fn builder() -> crate::model::resource_config::Builder {
        crate::model::resource_config::Builder::default()
    }
}
