// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CloneBackend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CloneBackendError {
    /// Kind of error that occurred.
    pub kind: CloneBackendErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CloneBackend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CloneBackendErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CloneBackendError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CloneBackendErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CloneBackendErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CloneBackendErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CloneBackendErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CloneBackendErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CloneBackendError {
    fn code(&self) -> Option<&str> {
        CloneBackendError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CloneBackendError {
    /// Creates a new `CloneBackendError`.
    pub fn new(kind: CloneBackendErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CloneBackendError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CloneBackendErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CloneBackendError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CloneBackendErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CloneBackendErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CloneBackendErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CloneBackendErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloneBackendErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CloneBackendErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CloneBackendErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CloneBackendErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloneBackendErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CloneBackendError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CloneBackendErrorKind::BadRequestException(_inner) => Some(_inner),
            CloneBackendErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CloneBackendErrorKind::NotFoundException(_inner) => Some(_inner),
            CloneBackendErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CloneBackendErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackendError {
    /// Kind of error that occurred.
    pub kind: CreateBackendErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackendErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackendError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackendErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBackendErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateBackendErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBackendErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateBackendErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackendError {
    fn code(&self) -> Option<&str> {
        CreateBackendError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackendError {
    /// Creates a new `CreateBackendError`.
    pub fn new(kind: CreateBackendErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackendError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackendErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackendError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackendErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackendErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateBackendErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateBackendErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateBackendErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateBackendErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateBackendError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackendErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBackendErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateBackendErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBackendErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateBackendErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackendAPI` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackendAPIError {
    /// Kind of error that occurred.
    pub kind: CreateBackendAPIErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackendAPI` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackendAPIErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackendAPIError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackendAPIErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBackendAPIErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateBackendAPIErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBackendAPIErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateBackendAPIErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackendAPIError {
    fn code(&self) -> Option<&str> {
        CreateBackendAPIError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackendAPIError {
    /// Creates a new `CreateBackendAPIError`.
    pub fn new(kind: CreateBackendAPIErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackendAPIError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackendAPIErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackendAPIError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackendAPIErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackendAPIErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendAPIErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendAPIErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendAPIErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendAPIErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateBackendAPIErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateBackendAPIErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendAPIErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateBackendAPIError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackendAPIErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBackendAPIErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateBackendAPIErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBackendAPIErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateBackendAPIErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackendAuthError {
    /// Kind of error that occurred.
    pub kind: CreateBackendAuthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackendAuthErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackendAuthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackendAuthErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBackendAuthErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateBackendAuthErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBackendAuthErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateBackendAuthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackendAuthError {
    fn code(&self) -> Option<&str> {
        CreateBackendAuthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackendAuthError {
    /// Creates a new `CreateBackendAuthError`.
    pub fn new(kind: CreateBackendAuthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackendAuthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackendAuthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackendAuthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackendAuthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackendAuthErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendAuthErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendAuthErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendAuthErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendAuthErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateBackendAuthErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateBackendAuthErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendAuthErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateBackendAuthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackendAuthErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBackendAuthErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateBackendAuthErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBackendAuthErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateBackendAuthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackendConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackendConfigError {
    /// Kind of error that occurred.
    pub kind: CreateBackendConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackendConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackendConfigErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackendConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackendConfigErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBackendConfigErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateBackendConfigErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBackendConfigErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateBackendConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackendConfigError {
    fn code(&self) -> Option<&str> {
        CreateBackendConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackendConfigError {
    /// Creates a new `CreateBackendConfigError`.
    pub fn new(kind: CreateBackendConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackendConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackendConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackendConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackendConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackendConfigErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendConfigErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendConfigErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendConfigErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendConfigErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendConfigErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateBackendConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackendConfigErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBackendConfigErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateBackendConfigErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBackendConfigErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateBackendConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTokenError {
    /// Kind of error that occurred.
    pub kind: CreateTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTokenErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTokenErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTokenError {
    fn code(&self) -> Option<&str> {
        CreateTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTokenError {
    /// Creates a new `CreateTokenError`.
    pub fn new(kind: CreateTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTokenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTokenErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTokenErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateTokenErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateTokenErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateTokenErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackendError {
    /// Kind of error that occurred.
    pub kind: DeleteBackendErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackendErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackendError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackendErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBackendErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteBackendErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBackendErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteBackendErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackendError {
    fn code(&self) -> Option<&str> {
        DeleteBackendError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackendError {
    /// Creates a new `DeleteBackendError`.
    pub fn new(kind: DeleteBackendErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackendError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackendErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackendError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackendErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackendErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteBackendErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteBackendErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackendErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBackendErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteBackendErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteBackendError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackendErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBackendErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteBackendErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBackendErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteBackendErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackendAPI` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackendAPIError {
    /// Kind of error that occurred.
    pub kind: DeleteBackendAPIErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackendAPI` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackendAPIErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackendAPIError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackendAPIErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBackendAPIErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteBackendAPIErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBackendAPIErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteBackendAPIErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackendAPIError {
    fn code(&self) -> Option<&str> {
        DeleteBackendAPIError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackendAPIError {
    /// Creates a new `DeleteBackendAPIError`.
    pub fn new(kind: DeleteBackendAPIErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackendAPIError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackendAPIErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackendAPIError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackendAPIErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackendAPIErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendAPIErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackendAPIErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendAPIErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackendAPIErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBackendAPIErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteBackendAPIErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendAPIErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteBackendAPIError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackendAPIErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBackendAPIErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteBackendAPIErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBackendAPIErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteBackendAPIErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackendAuthError {
    /// Kind of error that occurred.
    pub kind: DeleteBackendAuthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackendAuthErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackendAuthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackendAuthErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBackendAuthErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteBackendAuthErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBackendAuthErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteBackendAuthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackendAuthError {
    fn code(&self) -> Option<&str> {
        DeleteBackendAuthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackendAuthError {
    /// Creates a new `DeleteBackendAuthError`.
    pub fn new(kind: DeleteBackendAuthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackendAuthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackendAuthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackendAuthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackendAuthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackendAuthErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendAuthErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackendAuthErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendAuthErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackendAuthErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBackendAuthErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteBackendAuthErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendAuthErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteBackendAuthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackendAuthErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBackendAuthErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteBackendAuthErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBackendAuthErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteBackendAuthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTokenError {
    /// Kind of error that occurred.
    pub kind: DeleteTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTokenErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTokenErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTokenError {
    fn code(&self) -> Option<&str> {
        DeleteTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTokenError {
    /// Creates a new `DeleteTokenError`.
    pub fn new(kind: DeleteTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTokenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteTokenErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, DeleteTokenErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteTokenErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTokenErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTokenErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteTokenErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteTokenErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteTokenErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateBackendAPIModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateBackendAPIModelsError {
    /// Kind of error that occurred.
    pub kind: GenerateBackendAPIModelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateBackendAPIModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateBackendAPIModelsErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateBackendAPIModelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateBackendAPIModelsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GenerateBackendAPIModelsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            GenerateBackendAPIModelsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GenerateBackendAPIModelsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GenerateBackendAPIModelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateBackendAPIModelsError {
    fn code(&self) -> Option<&str> {
        GenerateBackendAPIModelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateBackendAPIModelsError {
    /// Creates a new `GenerateBackendAPIModelsError`.
    pub fn new(kind: GenerateBackendAPIModelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateBackendAPIModelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateBackendAPIModelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateBackendAPIModelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateBackendAPIModelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateBackendAPIModelsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateBackendAPIModelsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateBackendAPIModelsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateBackendAPIModelsErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateBackendAPIModelsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateBackendAPIModelsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateBackendAPIModelsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateBackendAPIModelsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GenerateBackendAPIModelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateBackendAPIModelsErrorKind::BadRequestException(_inner) => Some(_inner),
            GenerateBackendAPIModelsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            GenerateBackendAPIModelsErrorKind::NotFoundException(_inner) => Some(_inner),
            GenerateBackendAPIModelsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GenerateBackendAPIModelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackendError {
    /// Kind of error that occurred.
    pub kind: GetBackendErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackendErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackendError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackendErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBackendErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            GetBackendErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBackendErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetBackendErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackendError {
    fn code(&self) -> Option<&str> {
        GetBackendError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackendError {
    /// Creates a new `GetBackendError`.
    pub fn new(kind: GetBackendErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackendError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackendErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackendError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackendErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackendErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBackendErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBackendErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetBackendErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `GetBackendErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBackendErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBackendErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetBackendErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetBackendError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackendErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBackendErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            GetBackendErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBackendErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetBackendErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackendAPI` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackendAPIError {
    /// Kind of error that occurred.
    pub kind: GetBackendAPIErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackendAPI` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackendAPIErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackendAPIError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackendAPIErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBackendAPIErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            GetBackendAPIErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBackendAPIErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetBackendAPIErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackendAPIError {
    fn code(&self) -> Option<&str> {
        GetBackendAPIError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackendAPIError {
    /// Creates a new `GetBackendAPIError`.
    pub fn new(kind: GetBackendAPIErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackendAPIError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackendAPIErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackendAPIError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackendAPIErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackendAPIErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBackendAPIErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBackendAPIErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendAPIErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackendAPIErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBackendAPIErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBackendAPIErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendAPIErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetBackendAPIError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackendAPIErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBackendAPIErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            GetBackendAPIErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBackendAPIErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetBackendAPIErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackendAPIModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackendAPIModelsError {
    /// Kind of error that occurred.
    pub kind: GetBackendAPIModelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackendAPIModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackendAPIModelsErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackendAPIModelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackendAPIModelsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBackendAPIModelsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            GetBackendAPIModelsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBackendAPIModelsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetBackendAPIModelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackendAPIModelsError {
    fn code(&self) -> Option<&str> {
        GetBackendAPIModelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackendAPIModelsError {
    /// Creates a new `GetBackendAPIModelsError`.
    pub fn new(kind: GetBackendAPIModelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackendAPIModelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackendAPIModelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackendAPIModelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackendAPIModelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackendAPIModelsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendAPIModelsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackendAPIModelsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendAPIModelsErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackendAPIModelsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendAPIModelsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackendAPIModelsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendAPIModelsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetBackendAPIModelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackendAPIModelsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBackendAPIModelsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            GetBackendAPIModelsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBackendAPIModelsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetBackendAPIModelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackendAuthError {
    /// Kind of error that occurred.
    pub kind: GetBackendAuthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackendAuthErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackendAuthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackendAuthErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBackendAuthErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            GetBackendAuthErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBackendAuthErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetBackendAuthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackendAuthError {
    fn code(&self) -> Option<&str> {
        GetBackendAuthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackendAuthError {
    /// Creates a new `GetBackendAuthError`.
    pub fn new(kind: GetBackendAuthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackendAuthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackendAuthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackendAuthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackendAuthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackendAuthErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBackendAuthErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBackendAuthErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendAuthErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackendAuthErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBackendAuthErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBackendAuthErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendAuthErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetBackendAuthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackendAuthErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBackendAuthErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            GetBackendAuthErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBackendAuthErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetBackendAuthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackendJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackendJobError {
    /// Kind of error that occurred.
    pub kind: GetBackendJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackendJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackendJobErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackendJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackendJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBackendJobErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            GetBackendJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBackendJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetBackendJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackendJobError {
    fn code(&self) -> Option<&str> {
        GetBackendJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackendJobError {
    /// Creates a new `GetBackendJobError`.
    pub fn new(kind: GetBackendJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackendJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackendJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackendJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackendJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackendJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBackendJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBackendJobErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendJobErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackendJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBackendJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBackendJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetBackendJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackendJobErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBackendJobErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            GetBackendJobErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBackendJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetBackendJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTokenError {
    /// Kind of error that occurred.
    pub kind: GetTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTokenErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTokenErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetTokenErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            GetTokenErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetTokenErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTokenError {
    fn code(&self) -> Option<&str> {
        GetTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTokenError {
    /// Creates a new `GetTokenError`.
    pub fn new(kind: GetTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTokenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTokenErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetTokenErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetTokenErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetTokenErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `GetTokenErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTokenErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetTokenErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetTokenErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTokenErrorKind::BadRequestException(_inner) => Some(_inner),
            GetTokenErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            GetTokenErrorKind::NotFoundException(_inner) => Some(_inner),
            GetTokenErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportBackendAuthError {
    /// Kind of error that occurred.
    pub kind: ImportBackendAuthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportBackendAuthErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportBackendAuthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportBackendAuthErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ImportBackendAuthErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ImportBackendAuthErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ImportBackendAuthErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ImportBackendAuthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportBackendAuthError {
    fn code(&self) -> Option<&str> {
        ImportBackendAuthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportBackendAuthError {
    /// Creates a new `ImportBackendAuthError`.
    pub fn new(kind: ImportBackendAuthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportBackendAuthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportBackendAuthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportBackendAuthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportBackendAuthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportBackendAuthErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportBackendAuthErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportBackendAuthErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportBackendAuthErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportBackendAuthErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ImportBackendAuthErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ImportBackendAuthErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportBackendAuthErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ImportBackendAuthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportBackendAuthErrorKind::BadRequestException(_inner) => Some(_inner),
            ImportBackendAuthErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ImportBackendAuthErrorKind::NotFoundException(_inner) => Some(_inner),
            ImportBackendAuthErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ImportBackendAuthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBackendJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBackendJobsError {
    /// Kind of error that occurred.
    pub kind: ListBackendJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBackendJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBackendJobsErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBackendJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBackendJobsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListBackendJobsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListBackendJobsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListBackendJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListBackendJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBackendJobsError {
    fn code(&self) -> Option<&str> {
        ListBackendJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBackendJobsError {
    /// Creates a new `ListBackendJobsError`.
    pub fn new(kind: ListBackendJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBackendJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBackendJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBackendJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBackendJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBackendJobsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListBackendJobsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListBackendJobsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackendJobsErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackendJobsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListBackendJobsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListBackendJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackendJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListBackendJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBackendJobsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListBackendJobsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListBackendJobsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListBackendJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListBackendJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveAllBackends` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveAllBackendsError {
    /// Kind of error that occurred.
    pub kind: RemoveAllBackendsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveAllBackends` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveAllBackendsErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveAllBackendsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveAllBackendsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RemoveAllBackendsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            RemoveAllBackendsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RemoveAllBackendsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RemoveAllBackendsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveAllBackendsError {
    fn code(&self) -> Option<&str> {
        RemoveAllBackendsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveAllBackendsError {
    /// Creates a new `RemoveAllBackendsError`.
    pub fn new(kind: RemoveAllBackendsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveAllBackendsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveAllBackendsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveAllBackendsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveAllBackendsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveAllBackendsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAllBackendsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAllBackendsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAllBackendsErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAllBackendsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RemoveAllBackendsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `RemoveAllBackendsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAllBackendsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemoveAllBackendsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveAllBackendsErrorKind::BadRequestException(_inner) => Some(_inner),
            RemoveAllBackendsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            RemoveAllBackendsErrorKind::NotFoundException(_inner) => Some(_inner),
            RemoveAllBackendsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RemoveAllBackendsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveBackendConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveBackendConfigError {
    /// Kind of error that occurred.
    pub kind: RemoveBackendConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveBackendConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveBackendConfigErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveBackendConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveBackendConfigErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RemoveBackendConfigErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            RemoveBackendConfigErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RemoveBackendConfigErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RemoveBackendConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveBackendConfigError {
    fn code(&self) -> Option<&str> {
        RemoveBackendConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveBackendConfigError {
    /// Creates a new `RemoveBackendConfigError`.
    pub fn new(kind: RemoveBackendConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveBackendConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveBackendConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveBackendConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveBackendConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveBackendConfigErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveBackendConfigErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveBackendConfigErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveBackendConfigErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveBackendConfigErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveBackendConfigErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveBackendConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveBackendConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemoveBackendConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveBackendConfigErrorKind::BadRequestException(_inner) => Some(_inner),
            RemoveBackendConfigErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            RemoveBackendConfigErrorKind::NotFoundException(_inner) => Some(_inner),
            RemoveBackendConfigErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RemoveBackendConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBackendAPI` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBackendAPIError {
    /// Kind of error that occurred.
    pub kind: UpdateBackendAPIErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBackendAPI` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBackendAPIErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBackendAPIError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBackendAPIErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateBackendAPIErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateBackendAPIErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBackendAPIErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateBackendAPIErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBackendAPIError {
    fn code(&self) -> Option<&str> {
        UpdateBackendAPIError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBackendAPIError {
    /// Creates a new `UpdateBackendAPIError`.
    pub fn new(kind: UpdateBackendAPIErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBackendAPIError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBackendAPIErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBackendAPIError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBackendAPIErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBackendAPIErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendAPIErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackendAPIErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendAPIErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackendAPIErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateBackendAPIErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateBackendAPIErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendAPIErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateBackendAPIError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBackendAPIErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateBackendAPIErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateBackendAPIErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBackendAPIErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateBackendAPIErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBackendAuthError {
    /// Kind of error that occurred.
    pub kind: UpdateBackendAuthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBackendAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBackendAuthErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBackendAuthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBackendAuthErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateBackendAuthErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateBackendAuthErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBackendAuthErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateBackendAuthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBackendAuthError {
    fn code(&self) -> Option<&str> {
        UpdateBackendAuthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBackendAuthError {
    /// Creates a new `UpdateBackendAuthError`.
    pub fn new(kind: UpdateBackendAuthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBackendAuthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBackendAuthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBackendAuthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBackendAuthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBackendAuthErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendAuthErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackendAuthErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendAuthErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackendAuthErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateBackendAuthErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateBackendAuthErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendAuthErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateBackendAuthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBackendAuthErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateBackendAuthErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateBackendAuthErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBackendAuthErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateBackendAuthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBackendConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBackendConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateBackendConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBackendConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBackendConfigErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBackendConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBackendConfigErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateBackendConfigErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateBackendConfigErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBackendConfigErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateBackendConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBackendConfigError {
    fn code(&self) -> Option<&str> {
        UpdateBackendConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBackendConfigError {
    /// Creates a new `UpdateBackendConfigError`.
    pub fn new(kind: UpdateBackendConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBackendConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBackendConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBackendConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBackendConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBackendConfigErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendConfigErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackendConfigErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendConfigErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackendConfigErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendConfigErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackendConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateBackendConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBackendConfigErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateBackendConfigErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateBackendConfigErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBackendConfigErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateBackendConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBackendJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBackendJobError {
    /// Kind of error that occurred.
    pub kind: UpdateBackendJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBackendJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBackendJobErrorKind {
    /// <p>An error returned if a request is not formed properly.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An error returned if there's a temporary issue with the service.</p>
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// <p>An error returned when a specific resource type is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBackendJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBackendJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateBackendJobErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateBackendJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBackendJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateBackendJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBackendJobError {
    fn code(&self) -> Option<&str> {
        UpdateBackendJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBackendJobError {
    /// Creates a new `UpdateBackendJobError`.
    pub fn new(kind: UpdateBackendJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBackendJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBackendJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBackendJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBackendJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBackendJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendJobErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackendJobErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendJobErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackendJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateBackendJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateBackendJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackendJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateBackendJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBackendJobErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateBackendJobErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateBackendJobErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBackendJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateBackendJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An error that is returned when a limit of a specific type has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// <p>The type of limit that was exceeded.</p>
    pub limit_type: std::option::Option<std::string::String>,
    /// <p>An error message to inform that the request has failed.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("limit_type", &self.limit_type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit_type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of limit that was exceeded.</p>
        pub fn limit_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit_type = Some(input.into());
            self
        }
        /// <p>The type of limit that was exceeded.</p>
        pub fn set_limit_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit_type = input;
            self
        }
        /// <p>An error message to inform that the request has failed.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An error message to inform that the request has failed.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                limit_type: self.limit_type,
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>An error returned when a specific resource type is not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>An error message to inform that the request has failed.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of resource that is not found.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An error message to inform that the request has failed.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An error message to inform that the request has failed.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of resource that is not found.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource that is not found.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
                resource_type: self.resource_type,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>An error returned if there's a temporary issue with the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayTimeoutException {
    /// <p>An error message to inform that the request failed.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GatewayTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayTimeoutException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GatewayTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GatewayTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GatewayTimeoutException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for GatewayTimeoutException {}
/// See [`GatewayTimeoutException`](crate::error::GatewayTimeoutException)
pub mod gateway_timeout_exception {
    /// A builder for [`GatewayTimeoutException`](crate::error::GatewayTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An error message to inform that the request failed.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An error message to inform that the request failed.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayTimeoutException`](crate::error::GatewayTimeoutException)
        pub fn build(self) -> crate::error::GatewayTimeoutException {
            crate::error::GatewayTimeoutException {
                message: self.message,
            }
        }
    }
}
impl GatewayTimeoutException {
    /// Creates a new builder-style object to manufacture [`GatewayTimeoutException`](crate::error::GatewayTimeoutException)
    pub fn builder() -> crate::error::gateway_timeout_exception::Builder {
        crate::error::gateway_timeout_exception::Builder::default()
    }
}

/// <p>An error returned if a request is not formed properly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// <p>An error message to inform that the request failed.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An error message to inform that the request failed.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An error message to inform that the request failed.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}
