// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendJobOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The time when the job was created.</p>
    pub create_time: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time when the job was last updated.</p>
    pub update_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateBackendJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendJobOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("create_time", &self.create_time);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`UpdateBackendJobOutput`](crate::output::UpdateBackendJobOutput)
pub mod update_backend_job_output {
    /// A builder for [`UpdateBackendJobOutput`](crate::output::UpdateBackendJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) update_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The time when the job was created.</p>
        pub fn create_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.create_time = Some(input.into());
            self
        }
        /// <p>The time when the job was created.</p>
        pub fn set_create_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time when the job was last updated.</p>
        pub fn update_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_time = Some(input.into());
            self
        }
        /// <p>The time when the job was last updated.</p>
        pub fn set_update_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendJobOutput`](crate::output::UpdateBackendJobOutput)
        pub fn build(self) -> crate::output::UpdateBackendJobOutput {
            crate::output::UpdateBackendJobOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                create_time: self.create_time,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
                update_time: self.update_time,
            }
        }
    }
}
impl UpdateBackendJobOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBackendJobOutput`](crate::output::UpdateBackendJobOutput)
    pub fn builder() -> crate::output::update_backend_job_output::Builder {
        crate::output::update_backend_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendConfigOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The app ID for the backend manager.</p>
    pub backend_manager_app_id: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>Describes the Amazon Cognito configurations for the Admin UI auth resource to log in with.</p>
    pub login_auth_config: std::option::Option<crate::model::LoginAuthConfigReqObj>,
}
impl std::fmt::Debug for UpdateBackendConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendConfigOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_manager_app_id", &self.backend_manager_app_id);
        formatter.field("error", &self.error);
        formatter.field("login_auth_config", &self.login_auth_config);
        formatter.finish()
    }
}
/// See [`UpdateBackendConfigOutput`](crate::output::UpdateBackendConfigOutput)
pub mod update_backend_config_output {
    /// A builder for [`UpdateBackendConfigOutput`](crate::output::UpdateBackendConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_manager_app_id: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) login_auth_config: std::option::Option<crate::model::LoginAuthConfigReqObj>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The app ID for the backend manager.</p>
        pub fn backend_manager_app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_manager_app_id = Some(input.into());
            self
        }
        /// <p>The app ID for the backend manager.</p>
        pub fn set_backend_manager_app_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_manager_app_id = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>Describes the Amazon Cognito configurations for the Admin UI auth resource to log in with.</p>
        pub fn login_auth_config(mut self, input: crate::model::LoginAuthConfigReqObj) -> Self {
            self.login_auth_config = Some(input);
            self
        }
        /// <p>Describes the Amazon Cognito configurations for the Admin UI auth resource to log in with.</p>
        pub fn set_login_auth_config(
            mut self,
            input: std::option::Option<crate::model::LoginAuthConfigReqObj>,
        ) -> Self {
            self.login_auth_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendConfigOutput`](crate::output::UpdateBackendConfigOutput)
        pub fn build(self) -> crate::output::UpdateBackendConfigOutput {
            crate::output::UpdateBackendConfigOutput {
                app_id: self.app_id,
                backend_manager_app_id: self.backend_manager_app_id,
                error: self.error,
                login_auth_config: self.login_auth_config,
            }
        }
    }
}
impl UpdateBackendConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBackendConfigOutput`](crate::output::UpdateBackendConfigOutput)
    pub fn builder() -> crate::output::update_backend_config_output::Builder {
        crate::output::update_backend_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendAuthOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateBackendAuthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendAuthOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateBackendAuthOutput`](crate::output::UpdateBackendAuthOutput)
pub mod update_backend_auth_output {
    /// A builder for [`UpdateBackendAuthOutput`](crate::output::UpdateBackendAuthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendAuthOutput`](crate::output::UpdateBackendAuthOutput)
        pub fn build(self) -> crate::output::UpdateBackendAuthOutput {
            crate::output::UpdateBackendAuthOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl UpdateBackendAuthOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBackendAuthOutput`](crate::output::UpdateBackendAuthOutput)
    pub fn builder() -> crate::output::update_backend_auth_output::Builder {
        crate::output::update_backend_auth_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackendApiOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateBackendApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackendApiOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateBackendApiOutput`](crate::output::UpdateBackendApiOutput)
pub mod update_backend_api_output {
    /// A builder for [`UpdateBackendApiOutput`](crate::output::UpdateBackendApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackendApiOutput`](crate::output::UpdateBackendApiOutput)
        pub fn build(self) -> crate::output::UpdateBackendApiOutput {
            crate::output::UpdateBackendApiOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl UpdateBackendApiOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBackendApiOutput`](crate::output::UpdateBackendApiOutput)
    pub fn builder() -> crate::output::update_backend_api_output::Builder {
        crate::output::update_backend_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveBackendConfigOutput {
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveBackendConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveBackendConfigOutput");
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`RemoveBackendConfigOutput`](crate::output::RemoveBackendConfigOutput)
pub mod remove_backend_config_output {
    /// A builder for [`RemoveBackendConfigOutput`](crate::output::RemoveBackendConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveBackendConfigOutput`](crate::output::RemoveBackendConfigOutput)
        pub fn build(self) -> crate::output::RemoveBackendConfigOutput {
            crate::output::RemoveBackendConfigOutput { error: self.error }
        }
    }
}
impl RemoveBackendConfigOutput {
    /// Creates a new builder-style object to manufacture [`RemoveBackendConfigOutput`](crate::output::RemoveBackendConfigOutput)
    pub fn builder() -> crate::output::remove_backend_config_output::Builder {
        crate::output::remove_backend_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAllBackendsOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveAllBackendsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAllBackendsOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RemoveAllBackendsOutput`](crate::output::RemoveAllBackendsOutput)
pub mod remove_all_backends_output {
    /// A builder for [`RemoveAllBackendsOutput`](crate::output::RemoveAllBackendsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAllBackendsOutput`](crate::output::RemoveAllBackendsOutput)
        pub fn build(self) -> crate::output::RemoveAllBackendsOutput {
            crate::output::RemoveAllBackendsOutput {
                app_id: self.app_id,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl RemoveAllBackendsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveAllBackendsOutput`](crate::output::RemoveAllBackendsOutput)
    pub fn builder() -> crate::output::remove_all_backends_output::Builder {
        crate::output::remove_all_backends_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackendJobsOutput {
    /// <p>An array of jobs and their properties.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::BackendJobRespObj>>,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListBackendJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackendJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBackendJobsOutput`](crate::output::ListBackendJobsOutput)
pub mod list_backend_jobs_output {
    /// A builder for [`ListBackendJobsOutput`](crate::output::ListBackendJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::BackendJobRespObj>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>An array of jobs and their properties.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::BackendJobRespObj>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>An array of jobs and their properties.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackendJobRespObj>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackendJobsOutput`](crate::output::ListBackendJobsOutput)
        pub fn build(self) -> crate::output::ListBackendJobsOutput {
            crate::output::ListBackendJobsOutput {
                jobs: self.jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBackendJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListBackendJobsOutput`](crate::output::ListBackendJobsOutput)
    pub fn builder() -> crate::output::list_backend_jobs_output::Builder {
        crate::output::list_backend_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportBackendAuthOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImportBackendAuthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportBackendAuthOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ImportBackendAuthOutput`](crate::output::ImportBackendAuthOutput)
pub mod import_backend_auth_output {
    /// A builder for [`ImportBackendAuthOutput`](crate::output::ImportBackendAuthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportBackendAuthOutput`](crate::output::ImportBackendAuthOutput)
        pub fn build(self) -> crate::output::ImportBackendAuthOutput {
            crate::output::ImportBackendAuthOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl ImportBackendAuthOutput {
    /// Creates a new builder-style object to manufacture [`ImportBackendAuthOutput`](crate::output::ImportBackendAuthOutput)
    pub fn builder() -> crate::output::import_backend_auth_output::Builder {
        crate::output::import_backend_auth_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTokenOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The one-time challenge code for authenticating into the Amplify Admin UI.</p>
    pub challenge_code: std::option::Option<std::string::String>,
    /// <p>A unique ID provided when creating a new challenge token.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The expiry time for the one-time generated token code.</p>
    pub ttl: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTokenOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("challenge_code", &self.challenge_code);
        formatter.field("session_id", &self.session_id);
        formatter.field("ttl", &self.ttl);
        formatter.finish()
    }
}
/// See [`GetTokenOutput`](crate::output::GetTokenOutput)
pub mod get_token_output {
    /// A builder for [`GetTokenOutput`](crate::output::GetTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) challenge_code: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The one-time challenge code for authenticating into the Amplify Admin UI.</p>
        pub fn challenge_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.challenge_code = Some(input.into());
            self
        }
        /// <p>The one-time challenge code for authenticating into the Amplify Admin UI.</p>
        pub fn set_challenge_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.challenge_code = input;
            self
        }
        /// <p>A unique ID provided when creating a new challenge token.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>A unique ID provided when creating a new challenge token.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The expiry time for the one-time generated token code.</p>
        pub fn ttl(mut self, input: impl Into<std::string::String>) -> Self {
            self.ttl = Some(input.into());
            self
        }
        /// <p>The expiry time for the one-time generated token code.</p>
        pub fn set_ttl(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTokenOutput`](crate::output::GetTokenOutput)
        pub fn build(self) -> crate::output::GetTokenOutput {
            crate::output::GetTokenOutput {
                app_id: self.app_id,
                challenge_code: self.challenge_code,
                session_id: self.session_id,
                ttl: self.ttl,
            }
        }
    }
}
impl GetTokenOutput {
    /// Creates a new builder-style object to manufacture [`GetTokenOutput`](crate::output::GetTokenOutput)
    pub fn builder() -> crate::output::get_token_output::Builder {
        crate::output::get_token_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendJobOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The time when the job was created.</p>
    pub create_time: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time when the job was last updated.</p>
    pub update_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetBackendJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendJobOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("create_time", &self.create_time);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`GetBackendJobOutput`](crate::output::GetBackendJobOutput)
pub mod get_backend_job_output {
    /// A builder for [`GetBackendJobOutput`](crate::output::GetBackendJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) update_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The time when the job was created.</p>
        pub fn create_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.create_time = Some(input.into());
            self
        }
        /// <p>The time when the job was created.</p>
        pub fn set_create_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time when the job was last updated.</p>
        pub fn update_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_time = Some(input.into());
            self
        }
        /// <p>The time when the job was last updated.</p>
        pub fn set_update_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendJobOutput`](crate::output::GetBackendJobOutput)
        pub fn build(self) -> crate::output::GetBackendJobOutput {
            crate::output::GetBackendJobOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                create_time: self.create_time,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
                update_time: self.update_time,
            }
        }
    }
}
impl GetBackendJobOutput {
    /// Creates a new builder-style object to manufacture [`GetBackendJobOutput`](crate::output::GetBackendJobOutput)
    pub fn builder() -> crate::output::get_backend_job_output::Builder {
        crate::output::get_backend_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendAuthOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The resource configuration for authorization requests to the backend of your Amplify project.</p>
    pub resource_config: std::option::Option<crate::model::CreateBackendAuthResourceConfig>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetBackendAuthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendAuthOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
/// See [`GetBackendAuthOutput`](crate::output::GetBackendAuthOutput)
pub mod get_backend_auth_output {
    /// A builder for [`GetBackendAuthOutput`](crate::output::GetBackendAuthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) resource_config:
            std::option::Option<crate::model::CreateBackendAuthResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The resource configuration for authorization requests to the backend of your Amplify project.</p>
        pub fn resource_config(
            mut self,
            input: crate::model::CreateBackendAuthResourceConfig,
        ) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>The resource configuration for authorization requests to the backend of your Amplify project.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::CreateBackendAuthResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendAuthOutput`](crate::output::GetBackendAuthOutput)
        pub fn build(self) -> crate::output::GetBackendAuthOutput {
            crate::output::GetBackendAuthOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            }
        }
    }
}
impl GetBackendAuthOutput {
    /// Creates a new builder-style object to manufacture [`GetBackendAuthOutput`](crate::output::GetBackendAuthOutput)
    pub fn builder() -> crate::output::get_backend_auth_output::Builder {
        crate::output::get_backend_auth_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendApiModelsOutput {
    /// <p>Stringified JSON of the datastore model.</p>
    pub models: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for GetBackendApiModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendApiModelsOutput");
        formatter.field("models", &self.models);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetBackendApiModelsOutput`](crate::output::GetBackendApiModelsOutput)
pub mod get_backend_api_models_output {
    /// A builder for [`GetBackendApiModelsOutput`](crate::output::GetBackendApiModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) models: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>Stringified JSON of the datastore model.</p>
        pub fn models(mut self, input: impl Into<std::string::String>) -> Self {
            self.models = Some(input.into());
            self
        }
        /// <p>Stringified JSON of the datastore model.</p>
        pub fn set_models(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.models = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendApiModelsOutput`](crate::output::GetBackendApiModelsOutput)
        pub fn build(self) -> crate::output::GetBackendApiModelsOutput {
            crate::output::GetBackendApiModelsOutput {
                models: self.models,
                status: self.status,
            }
        }
    }
}
impl GetBackendApiModelsOutput {
    /// Creates a new builder-style object to manufacture [`GetBackendApiModelsOutput`](crate::output::GetBackendApiModelsOutput)
    pub fn builder() -> crate::output::get_backend_api_models_output::Builder {
        crate::output::get_backend_api_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendApiOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The resource configuration for this response object.</p>
    pub resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
    /// <p>The name of this resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetBackendApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendApiOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
/// See [`GetBackendApiOutput`](crate::output::GetBackendApiOutput)
pub mod get_backend_api_output {
    /// A builder for [`GetBackendApiOutput`](crate::output::GetBackendApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) resource_config: std::option::Option<crate::model::BackendApiResourceConfig>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The resource configuration for this response object.</p>
        pub fn resource_config(mut self, input: crate::model::BackendApiResourceConfig) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>The resource configuration for this response object.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::BackendApiResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>The name of this resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of this resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendApiOutput`](crate::output::GetBackendApiOutput)
        pub fn build(self) -> crate::output::GetBackendApiOutput {
            crate::output::GetBackendApiOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                resource_config: self.resource_config,
                resource_name: self.resource_name,
            }
        }
    }
}
impl GetBackendApiOutput {
    /// Creates a new builder-style object to manufacture [`GetBackendApiOutput`](crate::output::GetBackendApiOutput)
    pub fn builder() -> crate::output::get_backend_api_output::Builder {
        crate::output::get_backend_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendOutput {
    /// <p>A stringified version of the cli.json file for your Amplify project.</p>
    pub amplify_feature_flags: std::option::Option<std::string::String>,
    /// <p>A stringified version of the current configs for your Amplify project.</p>
    pub amplify_meta_config: std::option::Option<std::string::String>,
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the app.</p>
    pub app_name: std::option::Option<std::string::String>,
    /// <p>A list of backend environments in an array.</p>
    pub backend_environment_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request failed, this is the returned error.</p>
    pub error: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetBackendOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendOutput");
        formatter.field("amplify_feature_flags", &self.amplify_feature_flags);
        formatter.field("amplify_meta_config", &self.amplify_meta_config);
        formatter.field("app_id", &self.app_id);
        formatter.field("app_name", &self.app_name);
        formatter.field("backend_environment_list", &self.backend_environment_list);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`GetBackendOutput`](crate::output::GetBackendOutput)
pub mod get_backend_output {
    /// A builder for [`GetBackendOutput`](crate::output::GetBackendOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amplify_feature_flags: std::option::Option<std::string::String>,
        pub(crate) amplify_meta_config: std::option::Option<std::string::String>,
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) app_name: std::option::Option<std::string::String>,
        pub(crate) backend_environment_list:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A stringified version of the cli.json file for your Amplify project.</p>
        pub fn amplify_feature_flags(mut self, input: impl Into<std::string::String>) -> Self {
            self.amplify_feature_flags = Some(input.into());
            self
        }
        /// <p>A stringified version of the cli.json file for your Amplify project.</p>
        pub fn set_amplify_feature_flags(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amplify_feature_flags = input;
            self
        }
        /// <p>A stringified version of the current configs for your Amplify project.</p>
        pub fn amplify_meta_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.amplify_meta_config = Some(input.into());
            self
        }
        /// <p>A stringified version of the current configs for your Amplify project.</p>
        pub fn set_amplify_meta_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amplify_meta_config = input;
            self
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the app.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_name = Some(input.into());
            self
        }
        /// <p>The name of the app.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_name = input;
            self
        }
        /// Appends an item to `backend_environment_list`.
        ///
        /// To override the contents of this collection use [`set_backend_environment_list`](Self::set_backend_environment_list).
        ///
        /// <p>A list of backend environments in an array.</p>
        pub fn backend_environment_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.backend_environment_list.unwrap_or_default();
            v.push(input.into());
            self.backend_environment_list = Some(v);
            self
        }
        /// <p>A list of backend environments in an array.</p>
        pub fn set_backend_environment_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.backend_environment_list = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request failed, this is the returned error.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request failed, this is the returned error.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendOutput`](crate::output::GetBackendOutput)
        pub fn build(self) -> crate::output::GetBackendOutput {
            crate::output::GetBackendOutput {
                amplify_feature_flags: self.amplify_feature_flags,
                amplify_meta_config: self.amplify_meta_config,
                app_id: self.app_id,
                app_name: self.app_name,
                backend_environment_list: self.backend_environment_list,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
            }
        }
    }
}
impl GetBackendOutput {
    /// Creates a new builder-style object to manufacture [`GetBackendOutput`](crate::output::GetBackendOutput)
    pub fn builder() -> crate::output::get_backend_output::Builder {
        crate::output::get_backend_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateBackendApiModelsOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GenerateBackendApiModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateBackendApiModelsOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GenerateBackendApiModelsOutput`](crate::output::GenerateBackendApiModelsOutput)
pub mod generate_backend_api_models_output {
    /// A builder for [`GenerateBackendApiModelsOutput`](crate::output::GenerateBackendApiModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateBackendApiModelsOutput`](crate::output::GenerateBackendApiModelsOutput)
        pub fn build(self) -> crate::output::GenerateBackendApiModelsOutput {
            crate::output::GenerateBackendApiModelsOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl GenerateBackendApiModelsOutput {
    /// Creates a new builder-style object to manufacture [`GenerateBackendApiModelsOutput`](crate::output::GenerateBackendApiModelsOutput)
    pub fn builder() -> crate::output::generate_backend_api_models_output::Builder {
        crate::output::generate_backend_api_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTokenOutput {
    /// <p>Indicates whether the request succeeded or failed.</p>
    pub is_success: bool,
}
impl std::fmt::Debug for DeleteTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTokenOutput");
        formatter.field("is_success", &self.is_success);
        formatter.finish()
    }
}
/// See [`DeleteTokenOutput`](crate::output::DeleteTokenOutput)
pub mod delete_token_output {
    /// A builder for [`DeleteTokenOutput`](crate::output::DeleteTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_success: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether the request succeeded or failed.</p>
        pub fn is_success(mut self, input: bool) -> Self {
            self.is_success = Some(input);
            self
        }
        /// <p>Indicates whether the request succeeded or failed.</p>
        pub fn set_is_success(mut self, input: std::option::Option<bool>) -> Self {
            self.is_success = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTokenOutput`](crate::output::DeleteTokenOutput)
        pub fn build(self) -> crate::output::DeleteTokenOutput {
            crate::output::DeleteTokenOutput {
                is_success: self.is_success.unwrap_or_default(),
            }
        }
    }
}
impl DeleteTokenOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTokenOutput`](crate::output::DeleteTokenOutput)
    pub fn builder() -> crate::output::delete_token_output::Builder {
        crate::output::delete_token_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackendAuthOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBackendAuthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackendAuthOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteBackendAuthOutput`](crate::output::DeleteBackendAuthOutput)
pub mod delete_backend_auth_output {
    /// A builder for [`DeleteBackendAuthOutput`](crate::output::DeleteBackendAuthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackendAuthOutput`](crate::output::DeleteBackendAuthOutput)
        pub fn build(self) -> crate::output::DeleteBackendAuthOutput {
            crate::output::DeleteBackendAuthOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl DeleteBackendAuthOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackendAuthOutput`](crate::output::DeleteBackendAuthOutput)
    pub fn builder() -> crate::output::delete_backend_auth_output::Builder {
        crate::output::delete_backend_auth_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackendApiOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBackendApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackendApiOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteBackendApiOutput`](crate::output::DeleteBackendApiOutput)
pub mod delete_backend_api_output {
    /// A builder for [`DeleteBackendApiOutput`](crate::output::DeleteBackendApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackendApiOutput`](crate::output::DeleteBackendApiOutput)
        pub fn build(self) -> crate::output::DeleteBackendApiOutput {
            crate::output::DeleteBackendApiOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl DeleteBackendApiOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackendApiOutput`](crate::output::DeleteBackendApiOutput)
    pub fn builder() -> crate::output::delete_backend_api_output::Builder {
        crate::output::delete_backend_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackendOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBackendOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackendOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteBackendOutput`](crate::output::DeleteBackendOutput)
pub mod delete_backend_output {
    /// A builder for [`DeleteBackendOutput`](crate::output::DeleteBackendOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackendOutput`](crate::output::DeleteBackendOutput)
        pub fn build(self) -> crate::output::DeleteBackendOutput {
            crate::output::DeleteBackendOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl DeleteBackendOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackendOutput`](crate::output::DeleteBackendOutput)
    pub fn builder() -> crate::output::delete_backend_output::Builder {
        crate::output::delete_backend_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTokenOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>One-time challenge code for authenticating into the Amplify Admin UI.</p>
    pub challenge_code: std::option::Option<std::string::String>,
    /// <p>A unique ID provided when creating a new challenge token.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The expiry time for the one-time generated token code.</p>
    pub ttl: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTokenOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("challenge_code", &self.challenge_code);
        formatter.field("session_id", &self.session_id);
        formatter.field("ttl", &self.ttl);
        formatter.finish()
    }
}
/// See [`CreateTokenOutput`](crate::output::CreateTokenOutput)
pub mod create_token_output {
    /// A builder for [`CreateTokenOutput`](crate::output::CreateTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) challenge_code: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>One-time challenge code for authenticating into the Amplify Admin UI.</p>
        pub fn challenge_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.challenge_code = Some(input.into());
            self
        }
        /// <p>One-time challenge code for authenticating into the Amplify Admin UI.</p>
        pub fn set_challenge_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.challenge_code = input;
            self
        }
        /// <p>A unique ID provided when creating a new challenge token.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>A unique ID provided when creating a new challenge token.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The expiry time for the one-time generated token code.</p>
        pub fn ttl(mut self, input: impl Into<std::string::String>) -> Self {
            self.ttl = Some(input.into());
            self
        }
        /// <p>The expiry time for the one-time generated token code.</p>
        pub fn set_ttl(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTokenOutput`](crate::output::CreateTokenOutput)
        pub fn build(self) -> crate::output::CreateTokenOutput {
            crate::output::CreateTokenOutput {
                app_id: self.app_id,
                challenge_code: self.challenge_code,
                session_id: self.session_id,
                ttl: self.ttl,
            }
        }
    }
}
impl CreateTokenOutput {
    /// Creates a new builder-style object to manufacture [`CreateTokenOutput`](crate::output::CreateTokenOutput)
    pub fn builder() -> crate::output::create_token_output::Builder {
        crate::output::create_token_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendConfigOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateBackendConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendConfigOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("job_id", &self.job_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateBackendConfigOutput`](crate::output::CreateBackendConfigOutput)
pub mod create_backend_config_output {
    /// A builder for [`CreateBackendConfigOutput`](crate::output::CreateBackendConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendConfigOutput`](crate::output::CreateBackendConfigOutput)
        pub fn build(self) -> crate::output::CreateBackendConfigOutput {
            crate::output::CreateBackendConfigOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                job_id: self.job_id,
                status: self.status,
            }
        }
    }
}
impl CreateBackendConfigOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackendConfigOutput`](crate::output::CreateBackendConfigOutput)
    pub fn builder() -> crate::output::create_backend_config_output::Builder {
        crate::output::create_backend_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendAuthOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateBackendAuthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendAuthOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateBackendAuthOutput`](crate::output::CreateBackendAuthOutput)
pub mod create_backend_auth_output {
    /// A builder for [`CreateBackendAuthOutput`](crate::output::CreateBackendAuthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendAuthOutput`](crate::output::CreateBackendAuthOutput)
        pub fn build(self) -> crate::output::CreateBackendAuthOutput {
            crate::output::CreateBackendAuthOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl CreateBackendAuthOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackendAuthOutput`](crate::output::CreateBackendAuthOutput)
    pub fn builder() -> crate::output::create_backend_auth_output::Builder {
        crate::output::create_backend_auth_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendApiOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateBackendApiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendApiOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateBackendApiOutput`](crate::output::CreateBackendApiOutput)
pub mod create_backend_api_output {
    /// A builder for [`CreateBackendApiOutput`](crate::output::CreateBackendApiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendApiOutput`](crate::output::CreateBackendApiOutput)
        pub fn build(self) -> crate::output::CreateBackendApiOutput {
            crate::output::CreateBackendApiOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl CreateBackendApiOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackendApiOutput`](crate::output::CreateBackendApiOutput)
    pub fn builder() -> crate::output::create_backend_api_output::Builder {
        crate::output::create_backend_api_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateBackendOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateBackendOutput`](crate::output::CreateBackendOutput)
pub mod create_backend_output {
    /// A builder for [`CreateBackendOutput`](crate::output::CreateBackendOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendOutput`](crate::output::CreateBackendOutput)
        pub fn build(self) -> crate::output::CreateBackendOutput {
            crate::output::CreateBackendOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl CreateBackendOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackendOutput`](crate::output::CreateBackendOutput)
    pub fn builder() -> crate::output::create_backend_output::Builder {
        crate::output::create_backend_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloneBackendOutput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the backend environment.</p>
    pub backend_environment_name: std::option::Option<std::string::String>,
    /// <p>If the request fails, this error is returned.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The current status of the request.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloneBackendOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloneBackendOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("backend_environment_name", &self.backend_environment_name);
        formatter.field("error", &self.error);
        formatter.field("job_id", &self.job_id);
        formatter.field("operation", &self.operation);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CloneBackendOutput`](crate::output::CloneBackendOutput)
pub mod clone_backend_output {
    /// A builder for [`CloneBackendOutput`](crate::output::CloneBackendOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) backend_environment_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn backend_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the backend environment.</p>
        pub fn set_backend_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_name = input;
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>If the request fails, this error is returned.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of the operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CloneBackendOutput`](crate::output::CloneBackendOutput)
        pub fn build(self) -> crate::output::CloneBackendOutput {
            crate::output::CloneBackendOutput {
                app_id: self.app_id,
                backend_environment_name: self.backend_environment_name,
                error: self.error,
                job_id: self.job_id,
                operation: self.operation,
                status: self.status,
            }
        }
    }
}
impl CloneBackendOutput {
    /// Creates a new builder-style object to manufacture [`CloneBackendOutput`](crate::output::CloneBackendOutput)
    pub fn builder() -> crate::output::clone_backend_output::Builder {
        crate::output::clone_backend_output::Builder::default()
    }
}
