// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateAppInput`](crate::input::CreateAppInput)
pub mod create_app_input {
    /// A builder for [`CreateAppInput`](crate::input::CreateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) iam_service_role_arn: std::option::Option<std::string::String>,
        pub(crate) oauth_token: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) enable_branch_auto_build: std::option::Option<bool>,
        pub(crate) enable_branch_auto_deletion: std::option::Option<bool>,
        pub(crate) enable_basic_auth: std::option::Option<bool>,
        pub(crate) basic_auth_credentials: std::option::Option<std::string::String>,
        pub(crate) custom_rules: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) build_spec: std::option::Option<std::string::String>,
        pub(crate) custom_headers: std::option::Option<std::string::String>,
        pub(crate) enable_auto_branch_creation: std::option::Option<bool>,
        pub(crate) auto_branch_creation_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_branch_creation_config:
            std::option::Option<crate::model::AutoBranchCreationConfig>,
    }
    impl Builder {
        /// <p> The name for an Amplify app. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name for an Amplify app. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The repository for an Amplify app. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p> The repository for an Amplify app. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p> The platform or framework for an Amplify app. </p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p> The platform or framework for an Amplify app. </p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn iam_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_service_role_arn = Some(input.into());
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn set_iam_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_service_role_arn = input;
            self
        }
        /// <p> The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. </p>
        pub fn oauth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.oauth_token = Some(input.into());
            self
        }
        /// <p> The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. </p>
        pub fn set_oauth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.oauth_token = input;
            self
        }
        /// <p> The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored. </p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p> The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables map for an Amplify app. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p> The environment variables map for an Amplify app. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p> Enables the auto building of branches for an Amplify app. </p>
        pub fn enable_branch_auto_build(mut self, input: bool) -> Self {
            self.enable_branch_auto_build = Some(input);
            self
        }
        /// <p> Enables the auto building of branches for an Amplify app. </p>
        pub fn set_enable_branch_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_branch_auto_build = input;
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
        pub fn enable_branch_auto_deletion(mut self, input: bool) -> Self {
            self.enable_branch_auto_deletion = Some(input);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
        pub fn set_enable_branch_auto_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_branch_auto_deletion = input;
            self
        }
        /// <p> Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.enable_basic_auth = Some(input);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_basic_auth = input;
            self
        }
        /// <p> The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.basic_auth_credentials = Some(input.into());
            self
        }
        /// <p> The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.basic_auth_credentials = input;
            self
        }
        /// Appends an item to `custom_rules`.
        ///
        /// To override the contents of this collection use [`set_custom_rules`](Self::set_custom_rules).
        ///
        /// <p> The custom rewrite and redirect rules for an Amplify app. </p>
        pub fn custom_rules(mut self, input: crate::model::CustomRule) -> Self {
            let mut v = self.custom_rules.unwrap_or_default();
            v.push(input);
            self.custom_rules = Some(v);
            self
        }
        /// <p> The custom rewrite and redirect rules for an Amplify app. </p>
        pub fn set_custom_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        ) -> Self {
            self.custom_rules = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tag for an Amplify app. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tag for an Amplify app. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_spec = Some(input.into());
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_spec = input;
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn custom_headers(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_headers = Some(input.into());
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn set_custom_headers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_headers = input;
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn enable_auto_branch_creation(mut self, input: bool) -> Self {
            self.enable_auto_branch_creation = Some(input);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn set_enable_auto_branch_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_branch_creation = input;
            self
        }
        /// Appends an item to `auto_branch_creation_patterns`.
        ///
        /// To override the contents of this collection use [`set_auto_branch_creation_patterns`](Self::set_auto_branch_creation_patterns).
        ///
        /// <p> The automated branch creation glob patterns for an Amplify app. </p>
        pub fn auto_branch_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.auto_branch_creation_patterns.unwrap_or_default();
            v.push(input.into());
            self.auto_branch_creation_patterns = Some(v);
            self
        }
        /// <p> The automated branch creation glob patterns for an Amplify app. </p>
        pub fn set_auto_branch_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_branch_creation_patterns = input;
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn auto_branch_creation_config(
            mut self,
            input: crate::model::AutoBranchCreationConfig,
        ) -> Self {
            self.auto_branch_creation_config = Some(input);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn set_auto_branch_creation_config(
            mut self,
            input: std::option::Option<crate::model::AutoBranchCreationConfig>,
        ) -> Self {
            self.auto_branch_creation_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInput`](crate::input::CreateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateAppInput {
                name: self.name,
                description: self.description,
                repository: self.repository,
                platform: self.platform,
                iam_service_role_arn: self.iam_service_role_arn,
                oauth_token: self.oauth_token,
                access_token: self.access_token,
                environment_variables: self.environment_variables,
                enable_branch_auto_build: self.enable_branch_auto_build,
                enable_branch_auto_deletion: self.enable_branch_auto_deletion,
                enable_basic_auth: self.enable_basic_auth,
                basic_auth_credentials: self.basic_auth_credentials,
                custom_rules: self.custom_rules,
                tags: self.tags,
                build_spec: self.build_spec,
                custom_headers: self.custom_headers,
                enable_auto_branch_creation: self.enable_auto_branch_creation,
                auto_branch_creation_patterns: self.auto_branch_creation_patterns,
                auto_branch_creation_config: self.auto_branch_creation_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppInputOperationOutputAlias = crate::operation::CreateApp;
#[doc(hidden)]
pub type CreateAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAppInput {
    /// Consumes the builder and constructs an Operation<[`CreateApp`](crate::operation::CreateApp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAppInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/apps").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAppInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_app(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateApp",
                    "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
}

/// See [`CreateBackendEnvironmentInput`](crate::input::CreateBackendEnvironmentInput)
pub mod create_backend_environment_input {
    /// A builder for [`CreateBackendEnvironmentInput`](crate::input::CreateBackendEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) deployment_artifacts: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p> The AWS CloudFormation stack name of a backend environment. </p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p> The AWS CloudFormation stack name of a backend environment. </p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p> The name of deployment artifacts. </p>
        pub fn deployment_artifacts(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_artifacts = Some(input.into());
            self
        }
        /// <p> The name of deployment artifacts. </p>
        pub fn set_deployment_artifacts(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_artifacts = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendEnvironmentInput`](crate::input::CreateBackendEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackendEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackendEnvironmentInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                stack_name: self.stack_name,
                deployment_artifacts: self.deployment_artifacts,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackendEnvironmentInputOperationOutputAlias =
    crate::operation::CreateBackendEnvironment;
#[doc(hidden)]
pub type CreateBackendEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBackendEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackendEnvironment`](crate::operation::CreateBackendEnvironment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackendEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBackendEnvironmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.app_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_1, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}/backendenvironments", appId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBackendEnvironmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_backend_environment(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackendEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackendEnvironment",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBackendEnvironmentInput`](crate::input::CreateBackendEnvironmentInput)
    pub fn builder() -> crate::input::create_backend_environment_input::Builder {
        crate::input::create_backend_environment_input::Builder::default()
    }
}

/// See [`CreateBranchInput`](crate::input::CreateBranchInput)
pub mod create_branch_input {
    /// A builder for [`CreateBranchInput`](crate::input::CreateBranchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<crate::model::Stage>,
        pub(crate) framework: std::option::Option<std::string::String>,
        pub(crate) enable_notification: std::option::Option<bool>,
        pub(crate) enable_auto_build: std::option::Option<bool>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) basic_auth_credentials: std::option::Option<std::string::String>,
        pub(crate) enable_basic_auth: std::option::Option<bool>,
        pub(crate) enable_performance_mode: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) build_spec: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) enable_pull_request_preview: std::option::Option<bool>,
        pub(crate) pull_request_environment_name: std::option::Option<std::string::String>,
        pub(crate) backend_environment_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The description for the branch. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for the branch. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn stage(mut self, input: crate::model::Stage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::Stage>) -> Self {
            self.stage = input;
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn framework(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework = Some(input.into());
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn set_framework(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework = input;
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn enable_notification(mut self, input: bool) -> Self {
            self.enable_notification = Some(input);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn set_enable_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_notification = input;
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn enable_auto_build(mut self, input: bool) -> Self {
            self.enable_auto_build = Some(input);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn set_enable_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_build = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for the branch. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p> The environment variables for the branch. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.basic_auth_credentials = Some(input.into());
            self
        }
        /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.basic_auth_credentials = input;
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.enable_basic_auth = Some(input);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_basic_auth = input;
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn enable_performance_mode(mut self, input: bool) -> Self {
            self.enable_performance_mode = Some(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn set_enable_performance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_performance_mode = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tag for the branch. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tag for the branch. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_spec = Some(input.into());
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_spec = input;
            self
        }
        /// <p> The content Time To Live (TTL) for the website in seconds. </p>
        pub fn ttl(mut self, input: impl Into<std::string::String>) -> Self {
            self.ttl = Some(input.into());
            self
        }
        /// <p> The content Time To Live (TTL) for the website in seconds. </p>
        pub fn set_ttl(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ttl = input;
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn enable_pull_request_preview(mut self, input: bool) -> Self {
            self.enable_pull_request_preview = Some(input);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn set_enable_pull_request_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_pull_request_preview = input;
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn pull_request_environment_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.pull_request_environment_name = Some(input.into());
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn set_pull_request_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_environment_name = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
        pub fn backend_environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
        pub fn set_backend_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBranchInput`](crate::input::CreateBranchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBranchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBranchInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                description: self.description,
                stage: self.stage,
                framework: self.framework,
                enable_notification: self.enable_notification,
                enable_auto_build: self.enable_auto_build,
                environment_variables: self.environment_variables,
                basic_auth_credentials: self.basic_auth_credentials,
                enable_basic_auth: self.enable_basic_auth,
                enable_performance_mode: self.enable_performance_mode,
                tags: self.tags,
                build_spec: self.build_spec,
                ttl: self.ttl,
                display_name: self.display_name,
                enable_pull_request_preview: self.enable_pull_request_preview,
                pull_request_environment_name: self.pull_request_environment_name,
                backend_environment_arn: self.backend_environment_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBranchInputOperationOutputAlias = crate::operation::CreateBranch;
#[doc(hidden)]
pub type CreateBranchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBranchInput {
    /// Consumes the builder and constructs an Operation<[`CreateBranch`](crate::operation::CreateBranch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBranch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBranchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.app_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_2, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}/branches", appId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBranchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_branch(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBranch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBranch",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBranchInput`](crate::input::CreateBranchInput)
    pub fn builder() -> crate::input::create_branch_input::Builder {
        crate::input::create_branch_input::Builder::default()
    }
}

/// See [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
pub mod create_deployment_input {
    /// A builder for [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) file_map: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Adds a key-value pair to `file_map`.
        ///
        /// To override the contents of this collection use [`set_file_map`](Self::set_file_map).
        ///
        /// <p> An optional file map that contains the file name as the key and the file content md5 hash as the value. If this argument is provided, the service will generate a unique upload URL per file. Otherwise, the service will only generate a single upload URL for the zipped files. </p>
        pub fn file_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.file_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.file_map = Some(hash_map);
            self
        }
        /// <p> An optional file map that contains the file name as the key and the file content md5 hash as the value. If this argument is provided, the service will generate a unique upload URL per file. Otherwise, the service will only generate a single upload URL for the zipped files. </p>
        pub fn set_file_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.file_map = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                file_map: self.file_map,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentInputOperationOutputAlias = crate::operation::CreateDeployment;
#[doc(hidden)]
pub type CreateDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeployment`](crate::operation::CreateDeployment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDeploymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.app_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_3, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_4 = &_input.branch_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_4, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}/deployments",
                    appId = app_id,
                    branchName = branch_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDeploymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_deployment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeployment",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
}

/// See [`CreateDomainAssociationInput`](crate::input::CreateDomainAssociationInput)
pub mod create_domain_association_input {
    /// A builder for [`CreateDomainAssociationInput`](crate::input::CreateDomainAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) enable_auto_sub_domain: std::option::Option<bool>,
        pub(crate) sub_domain_settings:
            std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
        pub(crate) auto_sub_domain_creation_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_sub_domain_iam_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The domain name for the domain association. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> The domain name for the domain association. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn enable_auto_sub_domain(mut self, input: bool) -> Self {
            self.enable_auto_sub_domain = Some(input);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn set_enable_auto_sub_domain(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_sub_domain = input;
            self
        }
        /// Appends an item to `sub_domain_settings`.
        ///
        /// To override the contents of this collection use [`set_sub_domain_settings`](Self::set_sub_domain_settings).
        ///
        /// <p> The setting for the subdomain. </p>
        pub fn sub_domain_settings(mut self, input: crate::model::SubDomainSetting) -> Self {
            let mut v = self.sub_domain_settings.unwrap_or_default();
            v.push(input);
            self.sub_domain_settings = Some(v);
            self
        }
        /// <p> The setting for the subdomain. </p>
        pub fn set_sub_domain_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
        ) -> Self {
            self.sub_domain_settings = input;
            self
        }
        /// Appends an item to `auto_sub_domain_creation_patterns`.
        ///
        /// To override the contents of this collection use [`set_auto_sub_domain_creation_patterns`](Self::set_auto_sub_domain_creation_patterns).
        ///
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn auto_sub_domain_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.auto_sub_domain_creation_patterns.unwrap_or_default();
            v.push(input.into());
            self.auto_sub_domain_creation_patterns = Some(v);
            self
        }
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn set_auto_sub_domain_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_sub_domain_creation_patterns = input;
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn auto_sub_domain_iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_sub_domain_iam_role = Some(input.into());
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn set_auto_sub_domain_iam_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_sub_domain_iam_role = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainAssociationInput`](crate::input::CreateDomainAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainAssociationInput {
                app_id: self.app_id,
                domain_name: self.domain_name,
                enable_auto_sub_domain: self.enable_auto_sub_domain,
                sub_domain_settings: self.sub_domain_settings,
                auto_sub_domain_creation_patterns: self.auto_sub_domain_creation_patterns,
                auto_sub_domain_iam_role: self.auto_sub_domain_iam_role,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainAssociationInputOperationOutputAlias =
    crate::operation::CreateDomainAssociation;
#[doc(hidden)]
pub type CreateDomainAssociationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDomainAssociationInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomainAssociation`](crate::operation::CreateDomainAssociation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomainAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDomainAssociationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.app_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_5, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}/domains", appId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDomainAssociationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_domain_association(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomainAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomainAssociation",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainAssociationInput`](crate::input::CreateDomainAssociationInput)
    pub fn builder() -> crate::input::create_domain_association_input::Builder {
        crate::input::create_domain_association_input::Builder::default()
    }
}

/// See [`CreateWebhookInput`](crate::input::CreateWebhookInput)
pub mod create_webhook_input {
    /// A builder for [`CreateWebhookInput`](crate::input::CreateWebhookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWebhookInput`](crate::input::CreateWebhookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWebhookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWebhookInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWebhookInputOperationOutputAlias = crate::operation::CreateWebhook;
#[doc(hidden)]
pub type CreateWebhookInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateWebhookInput {
    /// Consumes the builder and constructs an Operation<[`CreateWebhook`](crate::operation::CreateWebhook)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWebhook,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateWebhookInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.app_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_6, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}/webhooks", appId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateWebhookInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_webhook(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWebhook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWebhook",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateWebhookInput`](crate::input::CreateWebhookInput)
    pub fn builder() -> crate::input::create_webhook_input::Builder {
        crate::input::create_webhook_input::Builder::default()
    }
}

/// See [`DeleteAppInput`](crate::input::DeleteAppInput)
pub mod delete_app_input {
    /// A builder for [`DeleteAppInput`](crate::input::DeleteAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInput`](crate::input::DeleteAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteAppInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInputOperationOutputAlias = crate::operation::DeleteApp;
#[doc(hidden)]
pub type DeleteAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApp`](crate::operation::DeleteApp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAppInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.app_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_7, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}", appId = app_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAppInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteApp",
                    "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
}

/// See [`DeleteBackendEnvironmentInput`](crate::input::DeleteBackendEnvironmentInput)
pub mod delete_backend_environment_input {
    /// A builder for [`DeleteBackendEnvironmentInput`](crate::input::DeleteBackendEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID of an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID of an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name of a backend environment of an Amplify app. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p> The name of a backend environment of an Amplify app. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackendEnvironmentInput`](crate::input::DeleteBackendEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackendEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackendEnvironmentInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackendEnvironmentInputOperationOutputAlias =
    crate::operation::DeleteBackendEnvironment;
#[doc(hidden)]
pub type DeleteBackendEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBackendEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackendEnvironment`](crate::operation::DeleteBackendEnvironment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackendEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBackendEnvironmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.app_id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_8, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_9 = &_input.environment_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_9, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/backendenvironments/{environmentName}",
                    appId = app_id,
                    environmentName = environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBackendEnvironmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackendEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackendEnvironment",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackendEnvironmentInput`](crate::input::DeleteBackendEnvironmentInput)
    pub fn builder() -> crate::input::delete_backend_environment_input::Builder {
        crate::input::delete_backend_environment_input::Builder::default()
    }
}

/// See [`DeleteBranchInput`](crate::input::DeleteBranchInput)
pub mod delete_branch_input {
    /// A builder for [`DeleteBranchInput`](crate::input::DeleteBranchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBranchInput`](crate::input::DeleteBranchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBranchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBranchInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBranchInputOperationOutputAlias = crate::operation::DeleteBranch;
#[doc(hidden)]
pub type DeleteBranchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBranchInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBranch`](crate::operation::DeleteBranch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBranch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBranchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.app_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_10, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_11 = &_input.branch_name;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_11, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}",
                    appId = app_id,
                    branchName = branch_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBranchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBranch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBranch",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBranchInput`](crate::input::DeleteBranchInput)
    pub fn builder() -> crate::input::delete_branch_input::Builder {
        crate::input::delete_branch_input::Builder::default()
    }
}

/// See [`DeleteDomainAssociationInput`](crate::input::DeleteDomainAssociationInput)
pub mod delete_domain_association_input {
    /// A builder for [`DeleteDomainAssociationInput`](crate::input::DeleteDomainAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique id for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainAssociationInput`](crate::input::DeleteDomainAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainAssociationInput {
                app_id: self.app_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainAssociationInputOperationOutputAlias =
    crate::operation::DeleteDomainAssociation;
#[doc(hidden)]
pub type DeleteDomainAssociationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDomainAssociationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomainAssociation`](crate::operation::DeleteDomainAssociation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomainAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDomainAssociationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.app_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_12, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.domain_name;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_13, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/domains/{domainName}",
                    appId = app_id,
                    domainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDomainAssociationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomainAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomainAssociation",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainAssociationInput`](crate::input::DeleteDomainAssociationInput)
    pub fn builder() -> crate::input::delete_domain_association_input::Builder {
        crate::input::delete_domain_association_input::Builder::default()
    }
}

/// See [`DeleteJobInput`](crate::input::DeleteJobInput)
pub mod delete_job_input {
    /// A builder for [`DeleteJobInput`](crate::input::DeleteJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobInput`](crate::input::DeleteJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteJobInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteJobInputOperationOutputAlias = crate::operation::DeleteJob;
#[doc(hidden)]
pub type DeleteJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteJobInput {
    /// Consumes the builder and constructs an Operation<[`DeleteJob`](crate::operation::DeleteJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.app_id;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_14, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_15 = &_input.branch_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_15, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_16 = &_input.job_id;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_16, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}/jobs/{jobId}",
                    appId = app_id,
                    branchName = branch_name,
                    jobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteJob",
                    "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteJobInput`](crate::input::DeleteJobInput)
    pub fn builder() -> crate::input::delete_job_input::Builder {
        crate::input::delete_job_input::Builder::default()
    }
}

/// See [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
pub mod delete_webhook_input {
    /// A builder for [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for a webhook. </p>
        pub fn webhook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.webhook_id = Some(input.into());
            self
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.webhook_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWebhookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWebhookInput {
                webhook_id: self.webhook_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWebhookInputOperationOutputAlias = crate::operation::DeleteWebhook;
#[doc(hidden)]
pub type DeleteWebhookInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteWebhookInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWebhook`](crate::operation::DeleteWebhook)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWebhook,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteWebhookInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.webhook_id;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "webhook_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let webhook_id = aws_smithy_http::label::fmt_string(input_17, false);
                if webhook_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "webhook_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/webhooks/{webhookId}", webhookId = webhook_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteWebhookInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWebhook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWebhook",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
    pub fn builder() -> crate::input::delete_webhook_input::Builder {
        crate::input::delete_webhook_input::Builder::default()
    }
}

/// See [`GenerateAccessLogsInput`](crate::input::GenerateAccessLogsInput)
pub mod generate_access_logs_input {
    /// A builder for [`GenerateAccessLogsInput`](crate::input::GenerateAccessLogsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The time at which the logs should start. The time range specified is inclusive of the start time. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> The time at which the logs should start. The time range specified is inclusive of the start time. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The time at which the logs should end. The time range specified is inclusive of the end time. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> The time at which the logs should end. The time range specified is inclusive of the end time. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateAccessLogsInput`](crate::input::GenerateAccessLogsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateAccessLogsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateAccessLogsInput {
                start_time: self.start_time,
                end_time: self.end_time,
                domain_name: self.domain_name,
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GenerateAccessLogsInputOperationOutputAlias = crate::operation::GenerateAccessLogs;
#[doc(hidden)]
pub type GenerateAccessLogsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GenerateAccessLogsInput {
    /// Consumes the builder and constructs an Operation<[`GenerateAccessLogs`](crate::operation::GenerateAccessLogs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateAccessLogs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GenerateAccessLogsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.app_id;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_18, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}/accesslogs", appId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GenerateAccessLogsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_generate_access_logs(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateAccessLogs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateAccessLogs",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GenerateAccessLogsInput`](crate::input::GenerateAccessLogsInput)
    pub fn builder() -> crate::input::generate_access_logs_input::Builder {
        crate::input::generate_access_logs_input::Builder::default()
    }
}

/// See [`GetAppInput`](crate::input::GetAppInput)
pub mod get_app_input {
    /// A builder for [`GetAppInput`](crate::input::GetAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppInput`](crate::input::GetAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetAppInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppInputOperationOutputAlias = crate::operation::GetApp;
#[doc(hidden)]
pub type GetAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAppInput {
    /// Consumes the builder and constructs an Operation<[`GetApp`](crate::operation::GetApp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAppInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.app_id;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_19, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}", appId = app_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAppInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetApp", "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAppInput`](crate::input::GetAppInput)
    pub fn builder() -> crate::input::get_app_input::Builder {
        crate::input::get_app_input::Builder::default()
    }
}

/// See [`GetArtifactUrlInput`](crate::input::GetArtifactUrlInput)
pub mod get_artifact_url_input {
    /// A builder for [`GetArtifactUrlInput`](crate::input::GetArtifactUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an artifact. </p>
        pub fn artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an artifact. </p>
        pub fn set_artifact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.artifact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetArtifactUrlInput`](crate::input::GetArtifactUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetArtifactUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetArtifactUrlInput {
                artifact_id: self.artifact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetArtifactUrlInputOperationOutputAlias = crate::operation::GetArtifactUrl;
#[doc(hidden)]
pub type GetArtifactUrlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetArtifactUrlInput {
    /// Consumes the builder and constructs an Operation<[`GetArtifactUrl`](crate::operation::GetArtifactUrl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetArtifactUrl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetArtifactUrlInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.artifact_id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "artifact_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let artifact_id = aws_smithy_http::label::fmt_string(input_20, false);
                if artifact_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "artifact_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/artifacts/{artifactId}", artifactId = artifact_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetArtifactUrlInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetArtifactUrl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetArtifactUrl",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetArtifactUrlInput`](crate::input::GetArtifactUrlInput)
    pub fn builder() -> crate::input::get_artifact_url_input::Builder {
        crate::input::get_artifact_url_input::Builder::default()
    }
}

/// See [`GetBackendEnvironmentInput`](crate::input::GetBackendEnvironmentInput)
pub mod get_backend_environment_input {
    /// A builder for [`GetBackendEnvironmentInput`](crate::input::GetBackendEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique id for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendEnvironmentInput`](crate::input::GetBackendEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackendEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackendEnvironmentInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackendEnvironmentInputOperationOutputAlias = crate::operation::GetBackendEnvironment;
#[doc(hidden)]
pub type GetBackendEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBackendEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`GetBackendEnvironment`](crate::operation::GetBackendEnvironment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackendEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBackendEnvironmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.app_id;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_21, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_22 = &_input.environment_name;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let environment_name = aws_smithy_http::label::fmt_string(input_22, false);
                if environment_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/backendenvironments/{environmentName}",
                    appId = app_id,
                    environmentName = environment_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBackendEnvironmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackendEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackendEnvironment",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBackendEnvironmentInput`](crate::input::GetBackendEnvironmentInput)
    pub fn builder() -> crate::input::get_backend_environment_input::Builder {
        crate::input::get_backend_environment_input::Builder::default()
    }
}

/// See [`GetBranchInput`](crate::input::GetBranchInput)
pub mod get_branch_input {
    /// A builder for [`GetBranchInput`](crate::input::GetBranchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBranchInput`](crate::input::GetBranchInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetBranchInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetBranchInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBranchInputOperationOutputAlias = crate::operation::GetBranch;
#[doc(hidden)]
pub type GetBranchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBranchInput {
    /// Consumes the builder and constructs an Operation<[`GetBranch`](crate::operation::GetBranch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBranch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBranchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.app_id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_23, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_24 = &_input.branch_name;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_24, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}",
                    appId = app_id,
                    branchName = branch_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBranchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetBranch::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetBranch",
                    "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBranchInput`](crate::input::GetBranchInput)
    pub fn builder() -> crate::input::get_branch_input::Builder {
        crate::input::get_branch_input::Builder::default()
    }
}

/// See [`GetDomainAssociationInput`](crate::input::GetDomainAssociationInput)
pub mod get_domain_association_input {
    /// A builder for [`GetDomainAssociationInput`](crate::input::GetDomainAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique id for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainAssociationInput`](crate::input::GetDomainAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainAssociationInput {
                app_id: self.app_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainAssociationInputOperationOutputAlias = crate::operation::GetDomainAssociation;
#[doc(hidden)]
pub type GetDomainAssociationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainAssociationInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainAssociation`](crate::operation::GetDomainAssociation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDomainAssociationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.app_id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_25, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_26 = &_input.domain_name;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_26, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/domains/{domainName}",
                    appId = app_id,
                    domainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDomainAssociationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainAssociation",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDomainAssociationInput`](crate::input::GetDomainAssociationInput)
    pub fn builder() -> crate::input::get_domain_association_input::Builder {
        crate::input::get_domain_association_input::Builder::default()
    }
}

/// See [`GetJobInput`](crate::input::GetJobInput)
pub mod get_job_input {
    /// A builder for [`GetJobInput`](crate::input::GetJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobInput`](crate::input::GetJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetJobInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJobInputOperationOutputAlias = crate::operation::GetJob;
#[doc(hidden)]
pub type GetJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJobInput {
    /// Consumes the builder and constructs an Operation<[`GetJob`](crate::operation::GetJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.app_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_27, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_28 = &_input.branch_name;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_28, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_29 = &_input.job_id;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_29, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}/jobs/{jobId}",
                    appId = app_id,
                    branchName = branch_name,
                    jobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetJob", "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetJobInput`](crate::input::GetJobInput)
    pub fn builder() -> crate::input::get_job_input::Builder {
        crate::input::get_job_input::Builder::default()
    }
}

/// See [`GetWebhookInput`](crate::input::GetWebhookInput)
pub mod get_webhook_input {
    /// A builder for [`GetWebhookInput`](crate::input::GetWebhookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for a webhook. </p>
        pub fn webhook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.webhook_id = Some(input.into());
            self
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.webhook_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWebhookInput`](crate::input::GetWebhookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWebhookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWebhookInput {
                webhook_id: self.webhook_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWebhookInputOperationOutputAlias = crate::operation::GetWebhook;
#[doc(hidden)]
pub type GetWebhookInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWebhookInput {
    /// Consumes the builder and constructs an Operation<[`GetWebhook`](crate::operation::GetWebhook)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWebhook,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetWebhookInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.webhook_id;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "webhook_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let webhook_id = aws_smithy_http::label::fmt_string(input_30, false);
                if webhook_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "webhook_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/webhooks/{webhookId}", webhookId = webhook_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetWebhookInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWebhook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWebhook",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetWebhookInput`](crate::input::GetWebhookInput)
    pub fn builder() -> crate::input::get_webhook_input::Builder {
        crate::input::get_webhook_input::Builder::default()
    }
}

/// See [`ListAppsInput`](crate::input::ListAppsInput)
pub mod list_apps_input {
    /// A builder for [`ListAppsInput`](crate::input::ListAppsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppsInput`](crate::input::ListAppsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListAppsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListAppsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppsInputOperationOutputAlias = crate::operation::ListApps;
#[doc(hidden)]
pub type ListAppsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAppsInput {
    /// Consumes the builder and constructs an Operation<[`ListApps`](crate::operation::ListApps)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApps,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAppsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/apps").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListAppsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_31) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_31));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAppsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListApps::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListApps", "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAppsInput`](crate::input::ListAppsInput)
    pub fn builder() -> crate::input::list_apps_input::Builder {
        crate::input::list_apps_input::Builder::default()
    }
}

/// See [`ListArtifactsInput`](crate::input::ListArtifactsInput)
pub mod list_artifacts_input {
    /// A builder for [`ListArtifactsInput`](crate::input::ListArtifactsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name of a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name of a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The unique ID for a job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The unique ID for a job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p> A pagination token. Set to null to start listing artifacts from start. If a non-null pagination token is returned in a result, pass its value in here to list more artifacts. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing artifacts from start. If a non-null pagination token is returned in a result, pass its value in here to list more artifacts. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListArtifactsInput`](crate::input::ListArtifactsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListArtifactsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListArtifactsInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                job_id: self.job_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListArtifactsInputOperationOutputAlias = crate::operation::ListArtifacts;
#[doc(hidden)]
pub type ListArtifactsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListArtifactsInput {
    /// Consumes the builder and constructs an Operation<[`ListArtifacts`](crate::operation::ListArtifacts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListArtifacts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListArtifactsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.app_id;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_32, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_33 = &_input.branch_name;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_33, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_34 = &_input.job_id;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_34, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}/jobs/{jobId}/artifacts",
                    appId = app_id,
                    branchName = branch_name,
                    jobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListArtifactsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_35) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_35));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListArtifactsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListArtifacts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListArtifacts",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListArtifactsInput`](crate::input::ListArtifactsInput)
    pub fn builder() -> crate::input::list_artifacts_input::Builder {
        crate::input::list_artifacts_input::Builder::default()
    }
}

/// See [`ListBackendEnvironmentsInput`](crate::input::ListBackendEnvironmentsInput)
pub mod list_backend_environments_input {
    /// A builder for [`ListBackendEnvironmentsInput`](crate::input::ListBackendEnvironmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name of the backend environment </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p> The name of the backend environment </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p> A pagination token. Set to null to start listing backend environments from the start. If a non-null pagination token is returned in a result, pass its value in here to list more backend environments. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing backend environments from the start. If a non-null pagination token is returned in a result, pass its value in here to list more backend environments. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackendEnvironmentsInput`](crate::input::ListBackendEnvironmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBackendEnvironmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBackendEnvironmentsInput {
                app_id: self.app_id,
                environment_name: self.environment_name,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListBackendEnvironmentsInputOperationOutputAlias =
    crate::operation::ListBackendEnvironments;
#[doc(hidden)]
pub type ListBackendEnvironmentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBackendEnvironmentsInput {
    /// Consumes the builder and constructs an Operation<[`ListBackendEnvironments`](crate::operation::ListBackendEnvironments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBackendEnvironments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBackendEnvironmentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.app_id;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_36, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}/backendenvironments", appId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListBackendEnvironmentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_37) = &_input.environment_name {
                    query.push_kv(
                        "environmentName",
                        &aws_smithy_http::query::fmt_string(&inner_37),
                    );
                }
                if let Some(inner_38) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_38));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBackendEnvironmentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBackendEnvironments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBackendEnvironments",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBackendEnvironmentsInput`](crate::input::ListBackendEnvironmentsInput)
    pub fn builder() -> crate::input::list_backend_environments_input::Builder {
        crate::input::list_backend_environments_input::Builder::default()
    }
}

/// See [`ListBranchesInput`](crate::input::ListBranchesInput)
pub mod list_branches_input {
    /// A builder for [`ListBranchesInput`](crate::input::ListBranchesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> A pagination token. Set to null to start listing branches from the start. If a non-null pagination token is returned in a result, pass its value in here to list more branches. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing branches from the start. If a non-null pagination token is returned in a result, pass its value in here to list more branches. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBranchesInput`](crate::input::ListBranchesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBranchesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBranchesInput {
                app_id: self.app_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListBranchesInputOperationOutputAlias = crate::operation::ListBranches;
#[doc(hidden)]
pub type ListBranchesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBranchesInput {
    /// Consumes the builder and constructs an Operation<[`ListBranches`](crate::operation::ListBranches)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBranches,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBranchesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.app_id;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_39, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}/branches", appId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListBranchesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_40) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_40));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBranchesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBranches::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBranches",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBranchesInput`](crate::input::ListBranchesInput)
    pub fn builder() -> crate::input::list_branches_input::Builder {
        crate::input::list_branches_input::Builder::default()
    }
}

/// See [`ListDomainAssociationsInput`](crate::input::ListDomainAssociationsInput)
pub mod list_domain_associations_input {
    /// A builder for [`ListDomainAssociationsInput`](crate::input::ListDomainAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> A pagination token. Set to null to start listing apps from the start. If non-null, a pagination token is returned in a result. Pass its value in here to list more projects. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing apps from the start. If non-null, a pagination token is returned in a result. Pass its value in here to list more projects. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainAssociationsInput`](crate::input::ListDomainAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainAssociationsInput {
                app_id: self.app_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainAssociationsInputOperationOutputAlias = crate::operation::ListDomainAssociations;
#[doc(hidden)]
pub type ListDomainAssociationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDomainAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListDomainAssociations`](crate::operation::ListDomainAssociations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomainAssociations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDomainAssociationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_41 = &_input.app_id;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_41, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}/domains", appId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDomainAssociationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_42) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_42));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDomainAssociationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomainAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomainAssociations",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDomainAssociationsInput`](crate::input::ListDomainAssociationsInput)
    pub fn builder() -> crate::input::list_domain_associations_input::Builder {
        crate::input::list_domain_associations_input::Builder::default()
    }
}

/// See [`ListJobsInput`](crate::input::ListJobsInput)
pub mod list_jobs_input {
    /// A builder for [`ListJobsInput`](crate::input::ListJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for a branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for a branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> A pagination token. Set to null to start listing steps from the start. If a non-null pagination token is returned in a result, pass its value in here to list more steps. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing steps from the start. If a non-null pagination token is returned in a result, pass its value in here to list more steps. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsInput`](crate::input::ListJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListJobsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListJobsInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListJobsInputOperationOutputAlias = crate::operation::ListJobs;
#[doc(hidden)]
pub type ListJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListJobs`](crate::operation::ListJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_43 = &_input.app_id;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_43, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_44 = &_input.branch_name;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_44, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}/jobs",
                    appId = app_id,
                    branchName = branch_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListJobsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_45) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_45));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListJobs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListJobs", "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) to use to list tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) to use to list tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.resource_arn;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_46, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListWebhooksInput`](crate::input::ListWebhooksInput)
pub mod list_webhooks_input {
    /// A builder for [`ListWebhooksInput`](crate::input::ListWebhooksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> A pagination token. Set to null to start listing webhooks from the start. If non-null,the pagination token is returned in a result. Pass its value in here to list more webhooks. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing webhooks from the start. If non-null,the pagination token is returned in a result. Pass its value in here to list more webhooks. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWebhooksInput`](crate::input::ListWebhooksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWebhooksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWebhooksInput {
                app_id: self.app_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListWebhooksInputOperationOutputAlias = crate::operation::ListWebhooks;
#[doc(hidden)]
pub type ListWebhooksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListWebhooksInput {
    /// Consumes the builder and constructs an Operation<[`ListWebhooks`](crate::operation::ListWebhooks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWebhooks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListWebhooksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_47 = &_input.app_id;
                let input_47 = input_47.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_47, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}/webhooks", appId = app_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListWebhooksInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_48) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_48));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListWebhooksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWebhooks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWebhooks",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListWebhooksInput`](crate::input::ListWebhooksInput)
    pub fn builder() -> crate::input::list_webhooks_input::Builder {
        crate::input::list_webhooks_input::Builder::default()
    }
}

/// See [`StartDeploymentInput`](crate::input::StartDeploymentInput)
pub mod start_deployment_input {
    /// A builder for [`StartDeploymentInput`](crate::input::StartDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) source_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The job ID for this deployment, generated by the create deployment request. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The job ID for this deployment, generated by the create deployment request. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p> The source URL for this deployment, used when calling start deployment without create deployment. The source URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file. </p>
        pub fn source_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_url = Some(input.into());
            self
        }
        /// <p> The source URL for this deployment, used when calling start deployment without create deployment. The source URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file. </p>
        pub fn set_source_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_url = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDeploymentInput`](crate::input::StartDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDeploymentInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                job_id: self.job_id,
                source_url: self.source_url,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDeploymentInputOperationOutputAlias = crate::operation::StartDeployment;
#[doc(hidden)]
pub type StartDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`StartDeployment`](crate::operation::StartDeployment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartDeploymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_49 = &_input.app_id;
                let input_49 = input_49.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_49, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_50 = &_input.branch_name;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_50, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}/deployments/start",
                    appId = app_id,
                    branchName = branch_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartDeploymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_deployment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDeployment",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartDeploymentInput`](crate::input::StartDeploymentInput)
    pub fn builder() -> crate::input::start_deployment_input::Builder {
        crate::input::start_deployment_input::Builder::default()
    }
}

/// See [`StartJobInput`](crate::input::StartJobInput)
pub mod start_job_input {
    /// A builder for [`StartJobInput`](crate::input::StartJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
        pub(crate) job_reason: std::option::Option<std::string::String>,
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) commit_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The unique ID for an existing job. This is required if the value of <code>jobType</code> is <code>RETRY</code>. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an existing job. This is required if the value of <code>jobType</code> is <code>RETRY</code>. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p> Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the <code>jobId</code> is also required. </p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p> Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the <code>jobId</code> is also required. </p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// <p> A descriptive reason for starting this job. </p>
        pub fn job_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_reason = Some(input.into());
            self
        }
        /// <p> A descriptive reason for starting this job. </p>
        pub fn set_job_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_reason = input;
            self
        }
        /// <p> The commit ID from a third-party repository provider for the job. </p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p> The commit ID from a third-party repository provider for the job. </p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p> The commit message from a third-party repository provider for the job. </p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p> The commit message from a third-party repository provider for the job. </p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p> The commit date and time for the job. </p>
        pub fn commit_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.commit_time = Some(input);
            self
        }
        /// <p> The commit date and time for the job. </p>
        pub fn set_commit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.commit_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StartJobInput`](crate::input::StartJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StartJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StartJobInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                job_id: self.job_id,
                job_type: self.job_type,
                job_reason: self.job_reason,
                commit_id: self.commit_id,
                commit_message: self.commit_message,
                commit_time: self.commit_time,
            })
        }
    }
}
#[doc(hidden)]
pub type StartJobInputOperationOutputAlias = crate::operation::StartJob;
#[doc(hidden)]
pub type StartJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartJobInput {
    /// Consumes the builder and constructs an Operation<[`StartJob`](crate::operation::StartJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_51 = &_input.app_id;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_51, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_52 = &_input.branch_name;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_52, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}/jobs",
                    appId = app_id,
                    branchName = branch_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StartJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StartJob", "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartJobInput`](crate::input::StartJobInput)
    pub fn builder() -> crate::input::start_job_input::Builder {
        crate::input::start_job_input::Builder::default()
    }
}

/// See [`StopJobInput`](crate::input::StopJobInput)
pub mod stop_job_input {
    /// A builder for [`StopJobInput`](crate::input::StopJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The unique id for the job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The unique id for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopJobInput`](crate::input::StopJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StopJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StopJobInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopJobInputOperationOutputAlias = crate::operation::StopJob;
#[doc(hidden)]
pub type StopJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopJobInput {
    /// Consumes the builder and constructs an Operation<[`StopJob`](crate::operation::StopJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_53 = &_input.app_id;
                let input_53 = input_53.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_53, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_54 = &_input.branch_name;
                let input_54 = input_54.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_54, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_55 = &_input.job_id;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_55, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}/jobs/{jobId}/stop",
                    appId = app_id,
                    branchName = branch_name,
                    jobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StopJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StopJob", "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopJobInput`](crate::input::StopJobInput)
    pub fn builder() -> crate::input::stop_job_input::Builder {
        crate::input::stop_job_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) to use to tag a resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) to use to tag a resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to tag the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags used to tag the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_56 = &_input.resource_arn;
                let input_56 = input_56.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_56, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) to use to untag a resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) to use to untag a resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The tag keys to use to untag a resource. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p> The tag keys to use to untag a resource. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_57 = &_input.resource_arn;
                let input_57 = input_57.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_57, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_58) = &_input.tag_keys {
                    for inner_59 in inner_58 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_59));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAppInput`](crate::input::UpdateAppInput)
pub mod update_app_input {
    /// A builder for [`UpdateAppInput`](crate::input::UpdateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) iam_service_role_arn: std::option::Option<std::string::String>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) enable_branch_auto_build: std::option::Option<bool>,
        pub(crate) enable_branch_auto_deletion: std::option::Option<bool>,
        pub(crate) enable_basic_auth: std::option::Option<bool>,
        pub(crate) basic_auth_credentials: std::option::Option<std::string::String>,
        pub(crate) custom_rules: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        pub(crate) build_spec: std::option::Option<std::string::String>,
        pub(crate) custom_headers: std::option::Option<std::string::String>,
        pub(crate) enable_auto_branch_creation: std::option::Option<bool>,
        pub(crate) auto_branch_creation_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_branch_creation_config:
            std::option::Option<crate::model::AutoBranchCreationConfig>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) oauth_token: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for an Amplify app. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name for an Amplify app. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The platform for an Amplify app. </p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p> The platform for an Amplify app. </p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn iam_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_service_role_arn = Some(input.into());
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn set_iam_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_service_role_arn = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for an Amplify app. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p> The environment variables for an Amplify app. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p> Enables branch auto-building for an Amplify app. </p>
        pub fn enable_branch_auto_build(mut self, input: bool) -> Self {
            self.enable_branch_auto_build = Some(input);
            self
        }
        /// <p> Enables branch auto-building for an Amplify app. </p>
        pub fn set_enable_branch_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_branch_auto_build = input;
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
        pub fn enable_branch_auto_deletion(mut self, input: bool) -> Self {
            self.enable_branch_auto_deletion = Some(input);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
        pub fn set_enable_branch_auto_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_branch_auto_deletion = input;
            self
        }
        /// <p> Enables basic authorization for an Amplify app. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.enable_basic_auth = Some(input);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_basic_auth = input;
            self
        }
        /// <p> The basic authorization credentials for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.basic_auth_credentials = Some(input.into());
            self
        }
        /// <p> The basic authorization credentials for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.basic_auth_credentials = input;
            self
        }
        /// Appends an item to `custom_rules`.
        ///
        /// To override the contents of this collection use [`set_custom_rules`](Self::set_custom_rules).
        ///
        /// <p> The custom redirect and rewrite rules for an Amplify app. </p>
        pub fn custom_rules(mut self, input: crate::model::CustomRule) -> Self {
            let mut v = self.custom_rules.unwrap_or_default();
            v.push(input);
            self.custom_rules = Some(v);
            self
        }
        /// <p> The custom redirect and rewrite rules for an Amplify app. </p>
        pub fn set_custom_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        ) -> Self {
            self.custom_rules = input;
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_spec = Some(input.into());
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_spec = input;
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn custom_headers(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_headers = Some(input.into());
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn set_custom_headers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_headers = input;
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn enable_auto_branch_creation(mut self, input: bool) -> Self {
            self.enable_auto_branch_creation = Some(input);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn set_enable_auto_branch_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_branch_creation = input;
            self
        }
        /// Appends an item to `auto_branch_creation_patterns`.
        ///
        /// To override the contents of this collection use [`set_auto_branch_creation_patterns`](Self::set_auto_branch_creation_patterns).
        ///
        /// <p> Describes the automated branch creation glob patterns for an Amplify app. </p>
        pub fn auto_branch_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.auto_branch_creation_patterns.unwrap_or_default();
            v.push(input.into());
            self.auto_branch_creation_patterns = Some(v);
            self
        }
        /// <p> Describes the automated branch creation glob patterns for an Amplify app. </p>
        pub fn set_auto_branch_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_branch_creation_patterns = input;
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn auto_branch_creation_config(
            mut self,
            input: crate::model::AutoBranchCreationConfig,
        ) -> Self {
            self.auto_branch_creation_config = Some(input);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn set_auto_branch_creation_config(
            mut self,
            input: std::option::Option<crate::model::AutoBranchCreationConfig>,
        ) -> Self {
            self.auto_branch_creation_config = input;
            self
        }
        /// <p> The name of the repository for an Amplify app </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p> The name of the repository for an Amplify app </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p> The OAuth token for a third-party source control system for an Amplify app. The token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. </p>
        pub fn oauth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.oauth_token = Some(input.into());
            self
        }
        /// <p> The OAuth token for a third-party source control system for an Amplify app. The token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. </p>
        pub fn set_oauth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.oauth_token = input;
            self
        }
        /// <p> The personal access token for a third-party source control system for an Amplify app. The token is used to create webhook and a read-only deploy key. The token is not stored. </p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p> The personal access token for a third-party source control system for an Amplify app. The token is used to create webhook and a read-only deploy key. The token is not stored. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppInput`](crate::input::UpdateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateAppInput {
                app_id: self.app_id,
                name: self.name,
                description: self.description,
                platform: self.platform,
                iam_service_role_arn: self.iam_service_role_arn,
                environment_variables: self.environment_variables,
                enable_branch_auto_build: self.enable_branch_auto_build,
                enable_branch_auto_deletion: self.enable_branch_auto_deletion,
                enable_basic_auth: self.enable_basic_auth,
                basic_auth_credentials: self.basic_auth_credentials,
                custom_rules: self.custom_rules,
                build_spec: self.build_spec,
                custom_headers: self.custom_headers,
                enable_auto_branch_creation: self.enable_auto_branch_creation,
                auto_branch_creation_patterns: self.auto_branch_creation_patterns,
                auto_branch_creation_config: self.auto_branch_creation_config,
                repository: self.repository,
                oauth_token: self.oauth_token,
                access_token: self.access_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAppInputOperationOutputAlias = crate::operation::UpdateApp;
#[doc(hidden)]
pub type UpdateAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAppInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApp`](crate::operation::UpdateApp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateAppInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_60 = &_input.app_id;
                let input_60 = input_60.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_60, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/apps/{appId}", appId = app_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateAppInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_app(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateApp",
                    "amplify",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateAppInput`](crate::input::UpdateAppInput)
    pub fn builder() -> crate::input::update_app_input::Builder {
        crate::input::update_app_input::Builder::default()
    }
}

/// See [`UpdateBranchInput`](crate::input::UpdateBranchInput)
pub mod update_branch_input {
    /// A builder for [`UpdateBranchInput`](crate::input::UpdateBranchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) framework: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<crate::model::Stage>,
        pub(crate) enable_notification: std::option::Option<bool>,
        pub(crate) enable_auto_build: std::option::Option<bool>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) basic_auth_credentials: std::option::Option<std::string::String>,
        pub(crate) enable_basic_auth: std::option::Option<bool>,
        pub(crate) enable_performance_mode: std::option::Option<bool>,
        pub(crate) build_spec: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) enable_pull_request_preview: std::option::Option<bool>,
        pub(crate) pull_request_environment_name: std::option::Option<std::string::String>,
        pub(crate) backend_environment_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The description for the branch. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for the branch. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn framework(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework = Some(input.into());
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn set_framework(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework = input;
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn stage(mut self, input: crate::model::Stage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::Stage>) -> Self {
            self.stage = input;
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn enable_notification(mut self, input: bool) -> Self {
            self.enable_notification = Some(input);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn set_enable_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_notification = input;
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn enable_auto_build(mut self, input: bool) -> Self {
            self.enable_auto_build = Some(input);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn set_enable_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_build = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for the branch. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p> The environment variables for the branch. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.basic_auth_credentials = Some(input.into());
            self
        }
        /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.basic_auth_credentials = input;
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.enable_basic_auth = Some(input);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_basic_auth = input;
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn enable_performance_mode(mut self, input: bool) -> Self {
            self.enable_performance_mode = Some(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn set_enable_performance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_performance_mode = input;
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_spec = Some(input.into());
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_spec = input;
            self
        }
        /// <p> The content Time to Live (TTL) for the website in seconds. </p>
        pub fn ttl(mut self, input: impl Into<std::string::String>) -> Self {
            self.ttl = Some(input.into());
            self
        }
        /// <p> The content Time to Live (TTL) for the website in seconds. </p>
        pub fn set_ttl(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ttl = input;
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn enable_pull_request_preview(mut self, input: bool) -> Self {
            self.enable_pull_request_preview = Some(input);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn set_enable_pull_request_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_pull_request_preview = input;
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn pull_request_environment_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.pull_request_environment_name = Some(input.into());
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn set_pull_request_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_environment_name = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
        pub fn backend_environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
        pub fn set_backend_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBranchInput`](crate::input::UpdateBranchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBranchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBranchInput {
                app_id: self.app_id,
                branch_name: self.branch_name,
                description: self.description,
                framework: self.framework,
                stage: self.stage,
                enable_notification: self.enable_notification,
                enable_auto_build: self.enable_auto_build,
                environment_variables: self.environment_variables,
                basic_auth_credentials: self.basic_auth_credentials,
                enable_basic_auth: self.enable_basic_auth,
                enable_performance_mode: self.enable_performance_mode,
                build_spec: self.build_spec,
                ttl: self.ttl,
                display_name: self.display_name,
                enable_pull_request_preview: self.enable_pull_request_preview,
                pull_request_environment_name: self.pull_request_environment_name,
                backend_environment_arn: self.backend_environment_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBranchInputOperationOutputAlias = crate::operation::UpdateBranch;
#[doc(hidden)]
pub type UpdateBranchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBranchInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBranch`](crate::operation::UpdateBranch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBranch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateBranchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_61 = &_input.app_id;
                let input_61 = input_61.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_61, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_62 = &_input.branch_name;
                let input_62 = input_62.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let branch_name = aws_smithy_http::label::fmt_string(input_62, false);
                if branch_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "branch_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/branches/{branchName}",
                    appId = app_id,
                    branchName = branch_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateBranchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_branch(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBranch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBranch",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateBranchInput`](crate::input::UpdateBranchInput)
    pub fn builder() -> crate::input::update_branch_input::Builder {
        crate::input::update_branch_input::Builder::default()
    }
}

/// See [`UpdateDomainAssociationInput`](crate::input::UpdateDomainAssociationInput)
pub mod update_domain_association_input {
    /// A builder for [`UpdateDomainAssociationInput`](crate::input::UpdateDomainAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) enable_auto_sub_domain: std::option::Option<bool>,
        pub(crate) sub_domain_settings:
            std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
        pub(crate) auto_sub_domain_creation_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_sub_domain_iam_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn enable_auto_sub_domain(mut self, input: bool) -> Self {
            self.enable_auto_sub_domain = Some(input);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn set_enable_auto_sub_domain(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_sub_domain = input;
            self
        }
        /// Appends an item to `sub_domain_settings`.
        ///
        /// To override the contents of this collection use [`set_sub_domain_settings`](Self::set_sub_domain_settings).
        ///
        /// <p> Describes the settings for the subdomain. </p>
        pub fn sub_domain_settings(mut self, input: crate::model::SubDomainSetting) -> Self {
            let mut v = self.sub_domain_settings.unwrap_or_default();
            v.push(input);
            self.sub_domain_settings = Some(v);
            self
        }
        /// <p> Describes the settings for the subdomain. </p>
        pub fn set_sub_domain_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
        ) -> Self {
            self.sub_domain_settings = input;
            self
        }
        /// Appends an item to `auto_sub_domain_creation_patterns`.
        ///
        /// To override the contents of this collection use [`set_auto_sub_domain_creation_patterns`](Self::set_auto_sub_domain_creation_patterns).
        ///
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn auto_sub_domain_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.auto_sub_domain_creation_patterns.unwrap_or_default();
            v.push(input.into());
            self.auto_sub_domain_creation_patterns = Some(v);
            self
        }
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn set_auto_sub_domain_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_sub_domain_creation_patterns = input;
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn auto_sub_domain_iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_sub_domain_iam_role = Some(input.into());
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn set_auto_sub_domain_iam_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_sub_domain_iam_role = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainAssociationInput`](crate::input::UpdateDomainAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDomainAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDomainAssociationInput {
                app_id: self.app_id,
                domain_name: self.domain_name,
                enable_auto_sub_domain: self.enable_auto_sub_domain,
                sub_domain_settings: self.sub_domain_settings,
                auto_sub_domain_creation_patterns: self.auto_sub_domain_creation_patterns,
                auto_sub_domain_iam_role: self.auto_sub_domain_iam_role,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDomainAssociationInputOperationOutputAlias =
    crate::operation::UpdateDomainAssociation;
#[doc(hidden)]
pub type UpdateDomainAssociationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDomainAssociationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDomainAssociation`](crate::operation::UpdateDomainAssociation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDomainAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDomainAssociationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_63 = &_input.app_id;
                let input_63 = input_63.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let app_id = aws_smithy_http::label::fmt_string(input_63, false);
                if app_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_64 = &_input.domain_name;
                let input_64 = input_64.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_64, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/apps/{appId}/domains/{domainName}",
                    appId = app_id,
                    domainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDomainAssociationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_domain_association(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDomainAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDomainAssociation",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDomainAssociationInput`](crate::input::UpdateDomainAssociationInput)
    pub fn builder() -> crate::input::update_domain_association_input::Builder {
        crate::input::update_domain_association_input::Builder::default()
    }
}

/// See [`UpdateWebhookInput`](crate::input::UpdateWebhookInput)
pub mod update_webhook_input {
    /// A builder for [`UpdateWebhookInput`](crate::input::UpdateWebhookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for a webhook. </p>
        pub fn webhook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.webhook_id = Some(input.into());
            self
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.webhook_id = input;
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWebhookInput`](crate::input::UpdateWebhookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWebhookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWebhookInput {
                webhook_id: self.webhook_id,
                branch_name: self.branch_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWebhookInputOperationOutputAlias = crate::operation::UpdateWebhook;
#[doc(hidden)]
pub type UpdateWebhookInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateWebhookInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWebhook`](crate::operation::UpdateWebhook)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWebhook,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateWebhookInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_65 = &_input.webhook_id;
                let input_65 = input_65.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "webhook_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let webhook_id = aws_smithy_http::label::fmt_string(input_65, false);
                if webhook_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "webhook_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/webhooks/{webhookId}", webhookId = webhook_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateWebhookInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_webhook(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWebhook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWebhook",
            "amplify",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateWebhookInput`](crate::input::UpdateWebhookInput)
    pub fn builder() -> crate::input::update_webhook_input::Builder {
        crate::input::update_webhook_input::Builder::default()
    }
}

/// <p> The request structure for the update webhook request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWebhookInput {
    /// <p> The unique ID for a webhook. </p>
    pub webhook_id: std::option::Option<std::string::String>,
    /// <p> The name for a branch that is part of an Amplify app. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The description for a webhook. </p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateWebhookInput {
    /// <p> The unique ID for a webhook. </p>
    pub fn webhook_id(&self) -> std::option::Option<&str> {
        self.webhook_id.as_deref()
    }
    /// <p> The name for a branch that is part of an Amplify app. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The description for a webhook. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateWebhookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWebhookInput");
        formatter.field("webhook_id", &self.webhook_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

/// <p> The request structure for the update domain association request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainAssociationInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name of the domain. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> Enables the automated creation of subdomains for branches. </p>
    pub enable_auto_sub_domain: std::option::Option<bool>,
    /// <p> Describes the settings for the subdomain. </p>
    pub sub_domain_settings: std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
    /// <p> Sets the branch patterns for automatic subdomain creation. </p>
    pub auto_sub_domain_creation_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
    pub auto_sub_domain_iam_role: std::option::Option<std::string::String>,
}
impl UpdateDomainAssociationInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name of the domain. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> Enables the automated creation of subdomains for branches. </p>
    pub fn enable_auto_sub_domain(&self) -> std::option::Option<bool> {
        self.enable_auto_sub_domain
    }
    /// <p> Describes the settings for the subdomain. </p>
    pub fn sub_domain_settings(&self) -> std::option::Option<&[crate::model::SubDomainSetting]> {
        self.sub_domain_settings.as_deref()
    }
    /// <p> Sets the branch patterns for automatic subdomain creation. </p>
    pub fn auto_sub_domain_creation_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_sub_domain_creation_patterns.as_deref()
    }
    /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
    pub fn auto_sub_domain_iam_role(&self) -> std::option::Option<&str> {
        self.auto_sub_domain_iam_role.as_deref()
    }
}
impl std::fmt::Debug for UpdateDomainAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainAssociationInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("enable_auto_sub_domain", &self.enable_auto_sub_domain);
        formatter.field("sub_domain_settings", &self.sub_domain_settings);
        formatter.field(
            "auto_sub_domain_creation_patterns",
            &self.auto_sub_domain_creation_patterns,
        );
        formatter.field("auto_sub_domain_iam_role", &self.auto_sub_domain_iam_role);
        formatter.finish()
    }
}

/// <p> The request structure for the update branch request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBranchInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the branch. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The description for the branch. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The framework for the branch. </p>
    pub framework: std::option::Option<std::string::String>,
    /// <p> Describes the current stage for the branch. </p>
    pub stage: std::option::Option<crate::model::Stage>,
    /// <p> Enables notifications for the branch. </p>
    pub enable_notification: std::option::Option<bool>,
    /// <p> Enables auto building for the branch. </p>
    pub enable_auto_build: std::option::Option<bool>,
    /// <p> The environment variables for the branch. </p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    pub basic_auth_credentials: std::option::Option<std::string::String>,
    /// <p> Enables basic authorization for the branch. </p>
    pub enable_basic_auth: std::option::Option<bool>,
    /// <p>Enables performance mode for the branch.</p>
    /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    pub enable_performance_mode: std::option::Option<bool>,
    /// <p> The build specification (build spec) for the branch. </p>
    pub build_spec: std::option::Option<std::string::String>,
    /// <p> The content Time to Live (TTL) for the website in seconds. </p>
    pub ttl: std::option::Option<std::string::String>,
    /// <p> The display name for a branch. This is used as the default domain prefix. </p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p> Enables pull request previews for this branch. </p>
    pub enable_pull_request_preview: std::option::Option<bool>,
    /// <p> The Amplify environment name for the pull request. </p>
    pub pull_request_environment_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
    pub backend_environment_arn: std::option::Option<std::string::String>,
}
impl UpdateBranchInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the branch. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The description for the branch. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The framework for the branch. </p>
    pub fn framework(&self) -> std::option::Option<&str> {
        self.framework.as_deref()
    }
    /// <p> Describes the current stage for the branch. </p>
    pub fn stage(&self) -> std::option::Option<&crate::model::Stage> {
        self.stage.as_ref()
    }
    /// <p> Enables notifications for the branch. </p>
    pub fn enable_notification(&self) -> std::option::Option<bool> {
        self.enable_notification
    }
    /// <p> Enables auto building for the branch. </p>
    pub fn enable_auto_build(&self) -> std::option::Option<bool> {
        self.enable_auto_build
    }
    /// <p> The environment variables for the branch. </p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
    /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    pub fn basic_auth_credentials(&self) -> std::option::Option<&str> {
        self.basic_auth_credentials.as_deref()
    }
    /// <p> Enables basic authorization for the branch. </p>
    pub fn enable_basic_auth(&self) -> std::option::Option<bool> {
        self.enable_basic_auth
    }
    /// <p>Enables performance mode for the branch.</p>
    /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    pub fn enable_performance_mode(&self) -> std::option::Option<bool> {
        self.enable_performance_mode
    }
    /// <p> The build specification (build spec) for the branch. </p>
    pub fn build_spec(&self) -> std::option::Option<&str> {
        self.build_spec.as_deref()
    }
    /// <p> The content Time to Live (TTL) for the website in seconds. </p>
    pub fn ttl(&self) -> std::option::Option<&str> {
        self.ttl.as_deref()
    }
    /// <p> The display name for a branch. This is used as the default domain prefix. </p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p> Enables pull request previews for this branch. </p>
    pub fn enable_pull_request_preview(&self) -> std::option::Option<bool> {
        self.enable_pull_request_preview
    }
    /// <p> The Amplify environment name for the pull request. </p>
    pub fn pull_request_environment_name(&self) -> std::option::Option<&str> {
        self.pull_request_environment_name.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
    pub fn backend_environment_arn(&self) -> std::option::Option<&str> {
        self.backend_environment_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateBranchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBranchInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("description", &self.description);
        formatter.field("framework", &self.framework);
        formatter.field("stage", &self.stage);
        formatter.field("enable_notification", &self.enable_notification);
        formatter.field("enable_auto_build", &self.enable_auto_build);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("basic_auth_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("enable_basic_auth", &self.enable_basic_auth);
        formatter.field("enable_performance_mode", &self.enable_performance_mode);
        formatter.field("build_spec", &self.build_spec);
        formatter.field("ttl", &self.ttl);
        formatter.field("display_name", &self.display_name);
        formatter.field(
            "enable_pull_request_preview",
            &self.enable_pull_request_preview,
        );
        formatter.field(
            "pull_request_environment_name",
            &self.pull_request_environment_name,
        );
        formatter.field("backend_environment_arn", &self.backend_environment_arn);
        formatter.finish()
    }
}

/// <p> The request structure for the update app request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for an Amplify app. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description for an Amplify app. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The platform for an Amplify app. </p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
    pub iam_service_role_arn: std::option::Option<std::string::String>,
    /// <p> The environment variables for an Amplify app. </p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> Enables branch auto-building for an Amplify app. </p>
    pub enable_branch_auto_build: std::option::Option<bool>,
    /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
    pub enable_branch_auto_deletion: std::option::Option<bool>,
    /// <p> Enables basic authorization for an Amplify app. </p>
    pub enable_basic_auth: std::option::Option<bool>,
    /// <p> The basic authorization credentials for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    pub basic_auth_credentials: std::option::Option<std::string::String>,
    /// <p> The custom redirect and rewrite rules for an Amplify app. </p>
    pub custom_rules: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
    /// <p> The build specification (build spec) for an Amplify app. </p>
    pub build_spec: std::option::Option<std::string::String>,
    /// <p>The custom HTTP headers for an Amplify app.</p>
    pub custom_headers: std::option::Option<std::string::String>,
    /// <p> Enables automated branch creation for an Amplify app. </p>
    pub enable_auto_branch_creation: std::option::Option<bool>,
    /// <p> Describes the automated branch creation glob patterns for an Amplify app. </p>
    pub auto_branch_creation_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The automated branch creation configuration for an Amplify app. </p>
    pub auto_branch_creation_config: std::option::Option<crate::model::AutoBranchCreationConfig>,
    /// <p> The name of the repository for an Amplify app </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p> The OAuth token for a third-party source control system for an Amplify app. The token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. </p>
    pub oauth_token: std::option::Option<std::string::String>,
    /// <p> The personal access token for a third-party source control system for an Amplify app. The token is used to create webhook and a read-only deploy key. The token is not stored. </p>
    pub access_token: std::option::Option<std::string::String>,
}
impl UpdateAppInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for an Amplify app. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The description for an Amplify app. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The platform for an Amplify app. </p>
    pub fn platform(&self) -> std::option::Option<&crate::model::Platform> {
        self.platform.as_ref()
    }
    /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
    pub fn iam_service_role_arn(&self) -> std::option::Option<&str> {
        self.iam_service_role_arn.as_deref()
    }
    /// <p> The environment variables for an Amplify app. </p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
    /// <p> Enables branch auto-building for an Amplify app. </p>
    pub fn enable_branch_auto_build(&self) -> std::option::Option<bool> {
        self.enable_branch_auto_build
    }
    /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
    pub fn enable_branch_auto_deletion(&self) -> std::option::Option<bool> {
        self.enable_branch_auto_deletion
    }
    /// <p> Enables basic authorization for an Amplify app. </p>
    pub fn enable_basic_auth(&self) -> std::option::Option<bool> {
        self.enable_basic_auth
    }
    /// <p> The basic authorization credentials for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    pub fn basic_auth_credentials(&self) -> std::option::Option<&str> {
        self.basic_auth_credentials.as_deref()
    }
    /// <p> The custom redirect and rewrite rules for an Amplify app. </p>
    pub fn custom_rules(&self) -> std::option::Option<&[crate::model::CustomRule]> {
        self.custom_rules.as_deref()
    }
    /// <p> The build specification (build spec) for an Amplify app. </p>
    pub fn build_spec(&self) -> std::option::Option<&str> {
        self.build_spec.as_deref()
    }
    /// <p>The custom HTTP headers for an Amplify app.</p>
    pub fn custom_headers(&self) -> std::option::Option<&str> {
        self.custom_headers.as_deref()
    }
    /// <p> Enables automated branch creation for an Amplify app. </p>
    pub fn enable_auto_branch_creation(&self) -> std::option::Option<bool> {
        self.enable_auto_branch_creation
    }
    /// <p> Describes the automated branch creation glob patterns for an Amplify app. </p>
    pub fn auto_branch_creation_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_branch_creation_patterns.as_deref()
    }
    /// <p> The automated branch creation configuration for an Amplify app. </p>
    pub fn auto_branch_creation_config(
        &self,
    ) -> std::option::Option<&crate::model::AutoBranchCreationConfig> {
        self.auto_branch_creation_config.as_ref()
    }
    /// <p> The name of the repository for an Amplify app </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p> The OAuth token for a third-party source control system for an Amplify app. The token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. </p>
    pub fn oauth_token(&self) -> std::option::Option<&str> {
        self.oauth_token.as_deref()
    }
    /// <p> The personal access token for a third-party source control system for an Amplify app. The token is used to create webhook and a read-only deploy key. The token is not stored. </p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("platform", &self.platform);
        formatter.field("iam_service_role_arn", &self.iam_service_role_arn);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("enable_branch_auto_build", &self.enable_branch_auto_build);
        formatter.field(
            "enable_branch_auto_deletion",
            &self.enable_branch_auto_deletion,
        );
        formatter.field("enable_basic_auth", &self.enable_basic_auth);
        formatter.field("basic_auth_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("custom_rules", &self.custom_rules);
        formatter.field("build_spec", &self.build_spec);
        formatter.field("custom_headers", &self.custom_headers);
        formatter.field(
            "enable_auto_branch_creation",
            &self.enable_auto_branch_creation,
        );
        formatter.field(
            "auto_branch_creation_patterns",
            &self.auto_branch_creation_patterns,
        );
        formatter.field(
            "auto_branch_creation_config",
            &self.auto_branch_creation_config,
        );
        formatter.field("repository", &self.repository);
        formatter.field("oauth_token", &"*** Sensitive Data Redacted ***");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

/// <p> The request structure for the untag resource request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) to use to untag a resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The tag keys to use to untag a resource. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) to use to untag a resource. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> The tag keys to use to untag a resource. </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p> The request structure to tag a resource with a tag key and value. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) to use to tag a resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The tags used to tag the resource. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) to use to tag a resource. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> The tags used to tag the resource. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p> The request structure for the stop job request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopJobInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the branch, for the job. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The unique id for the job. </p>
    pub job_id: std::option::Option<std::string::String>,
}
impl StopJobInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the branch, for the job. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The unique id for the job. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for StopJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopJobInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

/// <p> The request structure for the start job request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartJobInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The branch name for the job. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The unique ID for an existing job. This is required if the value of <code>jobType</code> is <code>RETRY</code>. </p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p> Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the <code>jobId</code> is also required. </p>
    pub job_type: std::option::Option<crate::model::JobType>,
    /// <p> A descriptive reason for starting this job. </p>
    pub job_reason: std::option::Option<std::string::String>,
    /// <p> The commit ID from a third-party repository provider for the job. </p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p> The commit message from a third-party repository provider for the job. </p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p> The commit date and time for the job. </p>
    pub commit_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl StartJobInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The branch name for the job. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The unique ID for an existing job. This is required if the value of <code>jobType</code> is <code>RETRY</code>. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p> Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the <code>jobId</code> is also required. </p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
    /// <p> A descriptive reason for starting this job. </p>
    pub fn job_reason(&self) -> std::option::Option<&str> {
        self.job_reason.as_deref()
    }
    /// <p> The commit ID from a third-party repository provider for the job. </p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p> The commit message from a third-party repository provider for the job. </p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p> The commit date and time for the job. </p>
    pub fn commit_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.commit_time.as_ref()
    }
}
impl std::fmt::Debug for StartJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartJobInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("job_id", &self.job_id);
        formatter.field("job_type", &self.job_type);
        formatter.field("job_reason", &self.job_reason);
        formatter.field("commit_id", &self.commit_id);
        formatter.field("commit_message", &self.commit_message);
        formatter.field("commit_time", &self.commit_time);
        formatter.finish()
    }
}

/// <p> The request structure for the start a deployment request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDeploymentInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the branch, for the job. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The job ID for this deployment, generated by the create deployment request. </p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p> The source URL for this deployment, used when calling start deployment without create deployment. The source URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file. </p>
    pub source_url: std::option::Option<std::string::String>,
}
impl StartDeploymentInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the branch, for the job. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The job ID for this deployment, generated by the create deployment request. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p> The source URL for this deployment, used when calling start deployment without create deployment. The source URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file. </p>
    pub fn source_url(&self) -> std::option::Option<&str> {
        self.source_url.as_deref()
    }
}
impl std::fmt::Debug for StartDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDeploymentInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("job_id", &self.job_id);
        formatter.field("source_url", &self.source_url);
        formatter.finish()
    }
}

/// <p> The request structure for the list webhooks request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWebhooksInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> A pagination token. Set to null to start listing webhooks from the start. If non-null,the pagination token is returned in a result. Pass its value in here to list more webhooks. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to list in a single response. </p>
    pub max_results: i32,
}
impl ListWebhooksInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> A pagination token. Set to null to start listing webhooks from the start. If non-null,the pagination token is returned in a result. Pass its value in here to list more webhooks. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of records to list in a single response. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListWebhooksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWebhooksInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p> The request structure to use to list tags for a resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p> The Amazon Resource Name (ARN) to use to list tags. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p> The Amazon Resource Name (ARN) to use to list tags. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

/// <p> The request structure for the list jobs request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for a branch. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> A pagination token. Set to null to start listing steps from the start. If a non-null pagination token is returned in a result, pass its value in here to list more steps. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to list in a single response. </p>
    pub max_results: i32,
}
impl ListJobsInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for a branch. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> A pagination token. Set to null to start listing steps from the start. If a non-null pagination token is returned in a result, pass its value in here to list more steps. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of records to list in a single response. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p> The request structure for the list domain associations request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainAssociationsInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> A pagination token. Set to null to start listing apps from the start. If non-null, a pagination token is returned in a result. Pass its value in here to list more projects. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to list in a single response. </p>
    pub max_results: i32,
}
impl ListDomainAssociationsInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> A pagination token. Set to null to start listing apps from the start. If non-null, a pagination token is returned in a result. Pass its value in here to list more projects. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of records to list in a single response. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListDomainAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainAssociationsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p> The request structure for the list branches request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBranchesInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> A pagination token. Set to null to start listing branches from the start. If a non-null pagination token is returned in a result, pass its value in here to list more branches. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to list in a single response. </p>
    pub max_results: i32,
}
impl ListBranchesInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> A pagination token. Set to null to start listing branches from the start. If a non-null pagination token is returned in a result, pass its value in here to list more branches. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of records to list in a single response. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListBranchesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBranchesInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p> The request structure for the list backend environments request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackendEnvironmentsInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name of the backend environment </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p> A pagination token. Set to null to start listing backend environments from the start. If a non-null pagination token is returned in a result, pass its value in here to list more backend environments. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to list in a single response. </p>
    pub max_results: i32,
}
impl ListBackendEnvironmentsInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name of the backend environment </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p> A pagination token. Set to null to start listing backend environments from the start. If a non-null pagination token is returned in a result, pass its value in here to list more backend environments. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of records to list in a single response. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListBackendEnvironmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackendEnvironmentsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p> Describes the request structure for the list artifacts request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListArtifactsInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name of a branch that is part of an Amplify app. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The unique ID for a job. </p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p> A pagination token. Set to null to start listing artifacts from start. If a non-null pagination token is returned in a result, pass its value in here to list more artifacts. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to list in a single response. </p>
    pub max_results: i32,
}
impl ListArtifactsInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name of a branch that is part of an Amplify app. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The unique ID for a job. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p> A pagination token. Set to null to start listing artifacts from start. If a non-null pagination token is returned in a result, pass its value in here to list more artifacts. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of records to list in a single response. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListArtifactsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListArtifactsInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("job_id", &self.job_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p> The request structure for the list apps request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppsInput {
    /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to list in a single response. </p>
    pub max_results: i32,
}
impl ListAppsInput {
    /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of records to list in a single response. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListAppsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p> The request structure for the get webhook request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWebhookInput {
    /// <p> The unique ID for a webhook. </p>
    pub webhook_id: std::option::Option<std::string::String>,
}
impl GetWebhookInput {
    /// <p> The unique ID for a webhook. </p>
    pub fn webhook_id(&self) -> std::option::Option<&str> {
        self.webhook_id.as_deref()
    }
}
impl std::fmt::Debug for GetWebhookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWebhookInput");
        formatter.field("webhook_id", &self.webhook_id);
        formatter.finish()
    }
}

/// <p> The request structure for the get job request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The branch name for the job. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The unique ID for the job. </p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetJobInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The branch name for the job. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The unique ID for the job. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

/// <p> The request structure for the get domain association request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainAssociationInput {
    /// <p> The unique id for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name of the domain. </p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetDomainAssociationInput {
    /// <p> The unique id for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name of the domain. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetDomainAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainAssociationInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> The request structure for the get branch request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBranchInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the branch. </p>
    pub branch_name: std::option::Option<std::string::String>,
}
impl GetBranchInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the branch. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
}
impl std::fmt::Debug for GetBranchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBranchInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.finish()
    }
}

/// <p> The request structure for the get backend environment request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendEnvironmentInput {
    /// <p> The unique id for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the backend environment. </p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl GetBackendEnvironmentInput {
    /// <p> The unique id for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the backend environment. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
}
impl std::fmt::Debug for GetBackendEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendEnvironmentInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}

/// <p> Returns the request structure for the get artifact request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetArtifactUrlInput {
    /// <p> The unique ID for an artifact. </p>
    pub artifact_id: std::option::Option<std::string::String>,
}
impl GetArtifactUrlInput {
    /// <p> The unique ID for an artifact. </p>
    pub fn artifact_id(&self) -> std::option::Option<&str> {
        self.artifact_id.as_deref()
    }
}
impl std::fmt::Debug for GetArtifactUrlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetArtifactUrlInput");
        formatter.field("artifact_id", &self.artifact_id);
        formatter.finish()
    }
}

/// <p> The request structure for the get app request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
}
impl GetAppInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for GetAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

/// <p> The request structure for the generate access logs request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateAccessLogsInput {
    /// <p> The time at which the logs should start. The time range specified is inclusive of the start time. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The time at which the logs should end. The time range specified is inclusive of the end time. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The name of the domain. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
}
impl GenerateAccessLogsInput {
    /// <p> The time at which the logs should start. The time range specified is inclusive of the start time. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p> The time at which the logs should end. The time range specified is inclusive of the end time. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p> The name of the domain. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for GenerateAccessLogsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateAccessLogsInput");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

/// <p> The request structure for the delete webhook request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWebhookInput {
    /// <p> The unique ID for a webhook. </p>
    pub webhook_id: std::option::Option<std::string::String>,
}
impl DeleteWebhookInput {
    /// <p> The unique ID for a webhook. </p>
    pub fn webhook_id(&self) -> std::option::Option<&str> {
        self.webhook_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWebhookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWebhookInput");
        formatter.field("webhook_id", &self.webhook_id);
        formatter.finish()
    }
}

/// <p> The request structure for the delete job request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the branch, for the job. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The unique ID for the job. </p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DeleteJobInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the branch, for the job. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The unique ID for the job. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

/// <p> The request structure for the delete domain association request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainAssociationInput {
    /// <p> The unique id for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name of the domain. </p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteDomainAssociationInput {
    /// <p> The unique id for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name of the domain. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDomainAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainAssociationInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> The request structure for the delete branch request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBranchInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the branch. </p>
    pub branch_name: std::option::Option<std::string::String>,
}
impl DeleteBranchInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the branch. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBranchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBranchInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.finish()
    }
}

/// <p> The request structure for the delete backend environment request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackendEnvironmentInput {
    /// <p> The unique ID of an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name of a backend environment of an Amplify app. </p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl DeleteBackendEnvironmentInput {
    /// <p> The unique ID of an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name of a backend environment of an Amplify app. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackendEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackendEnvironmentInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}

/// <p> Describes the request structure for the delete app request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
}
impl DeleteAppInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

/// <p> The request structure for the create webhook request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWebhookInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for a branch that is part of an Amplify app. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The description for a webhook. </p>
    pub description: std::option::Option<std::string::String>,
}
impl CreateWebhookInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for a branch that is part of an Amplify app. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The description for a webhook. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for CreateWebhookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWebhookInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

/// <p> The request structure for the create domain association request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainAssociationInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The domain name for the domain association. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> Enables the automated creation of subdomains for branches. </p>
    pub enable_auto_sub_domain: std::option::Option<bool>,
    /// <p> The setting for the subdomain. </p>
    pub sub_domain_settings: std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
    /// <p> Sets the branch patterns for automatic subdomain creation. </p>
    pub auto_sub_domain_creation_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
    pub auto_sub_domain_iam_role: std::option::Option<std::string::String>,
}
impl CreateDomainAssociationInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The domain name for the domain association. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> Enables the automated creation of subdomains for branches. </p>
    pub fn enable_auto_sub_domain(&self) -> std::option::Option<bool> {
        self.enable_auto_sub_domain
    }
    /// <p> The setting for the subdomain. </p>
    pub fn sub_domain_settings(&self) -> std::option::Option<&[crate::model::SubDomainSetting]> {
        self.sub_domain_settings.as_deref()
    }
    /// <p> Sets the branch patterns for automatic subdomain creation. </p>
    pub fn auto_sub_domain_creation_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_sub_domain_creation_patterns.as_deref()
    }
    /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
    pub fn auto_sub_domain_iam_role(&self) -> std::option::Option<&str> {
        self.auto_sub_domain_iam_role.as_deref()
    }
}
impl std::fmt::Debug for CreateDomainAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainAssociationInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("enable_auto_sub_domain", &self.enable_auto_sub_domain);
        formatter.field("sub_domain_settings", &self.sub_domain_settings);
        formatter.field(
            "auto_sub_domain_creation_patterns",
            &self.auto_sub_domain_creation_patterns,
        );
        formatter.field("auto_sub_domain_iam_role", &self.auto_sub_domain_iam_role);
        formatter.finish()
    }
}

/// <p> The request structure for the create a new deployment request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the branch, for the job. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> An optional file map that contains the file name as the key and the file content md5 hash as the value. If this argument is provided, the service will generate a unique upload URL per file. Otherwise, the service will only generate a single upload URL for the zipped files. </p>
    pub file_map:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDeploymentInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the branch, for the job. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> An optional file map that contains the file name as the key and the file content md5 hash as the value. If this argument is provided, the service will generate a unique upload URL per file. Otherwise, the service will only generate a single upload URL for the zipped files. </p>
    pub fn file_map(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.file_map.as_ref()
    }
}
impl std::fmt::Debug for CreateDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("file_map", &self.file_map);
        formatter.finish()
    }
}

/// <p> The request structure for the create branch request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBranchInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the branch. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The description for the branch. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> Describes the current stage for the branch. </p>
    pub stage: std::option::Option<crate::model::Stage>,
    /// <p> The framework for the branch. </p>
    pub framework: std::option::Option<std::string::String>,
    /// <p> Enables notifications for the branch. </p>
    pub enable_notification: std::option::Option<bool>,
    /// <p> Enables auto building for the branch. </p>
    pub enable_auto_build: std::option::Option<bool>,
    /// <p> The environment variables for the branch. </p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    pub basic_auth_credentials: std::option::Option<std::string::String>,
    /// <p> Enables basic authorization for the branch. </p>
    pub enable_basic_auth: std::option::Option<bool>,
    /// <p>Enables performance mode for the branch.</p>
    /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    pub enable_performance_mode: std::option::Option<bool>,
    /// <p> The tag for the branch. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The build specification (build spec) for the branch. </p>
    pub build_spec: std::option::Option<std::string::String>,
    /// <p> The content Time To Live (TTL) for the website in seconds. </p>
    pub ttl: std::option::Option<std::string::String>,
    /// <p> The display name for a branch. This is used as the default domain prefix. </p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p> Enables pull request previews for this branch. </p>
    pub enable_pull_request_preview: std::option::Option<bool>,
    /// <p> The Amplify environment name for the pull request. </p>
    pub pull_request_environment_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
    pub backend_environment_arn: std::option::Option<std::string::String>,
}
impl CreateBranchInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the branch. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The description for the branch. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> Describes the current stage for the branch. </p>
    pub fn stage(&self) -> std::option::Option<&crate::model::Stage> {
        self.stage.as_ref()
    }
    /// <p> The framework for the branch. </p>
    pub fn framework(&self) -> std::option::Option<&str> {
        self.framework.as_deref()
    }
    /// <p> Enables notifications for the branch. </p>
    pub fn enable_notification(&self) -> std::option::Option<bool> {
        self.enable_notification
    }
    /// <p> Enables auto building for the branch. </p>
    pub fn enable_auto_build(&self) -> std::option::Option<bool> {
        self.enable_auto_build
    }
    /// <p> The environment variables for the branch. </p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
    /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    pub fn basic_auth_credentials(&self) -> std::option::Option<&str> {
        self.basic_auth_credentials.as_deref()
    }
    /// <p> Enables basic authorization for the branch. </p>
    pub fn enable_basic_auth(&self) -> std::option::Option<bool> {
        self.enable_basic_auth
    }
    /// <p>Enables performance mode for the branch.</p>
    /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    pub fn enable_performance_mode(&self) -> std::option::Option<bool> {
        self.enable_performance_mode
    }
    /// <p> The tag for the branch. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> The build specification (build spec) for the branch. </p>
    pub fn build_spec(&self) -> std::option::Option<&str> {
        self.build_spec.as_deref()
    }
    /// <p> The content Time To Live (TTL) for the website in seconds. </p>
    pub fn ttl(&self) -> std::option::Option<&str> {
        self.ttl.as_deref()
    }
    /// <p> The display name for a branch. This is used as the default domain prefix. </p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p> Enables pull request previews for this branch. </p>
    pub fn enable_pull_request_preview(&self) -> std::option::Option<bool> {
        self.enable_pull_request_preview
    }
    /// <p> The Amplify environment name for the pull request. </p>
    pub fn pull_request_environment_name(&self) -> std::option::Option<&str> {
        self.pull_request_environment_name.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
    pub fn backend_environment_arn(&self) -> std::option::Option<&str> {
        self.backend_environment_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateBranchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBranchInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("description", &self.description);
        formatter.field("stage", &self.stage);
        formatter.field("framework", &self.framework);
        formatter.field("enable_notification", &self.enable_notification);
        formatter.field("enable_auto_build", &self.enable_auto_build);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("basic_auth_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("enable_basic_auth", &self.enable_basic_auth);
        formatter.field("enable_performance_mode", &self.enable_performance_mode);
        formatter.field("tags", &self.tags);
        formatter.field("build_spec", &self.build_spec);
        formatter.field("ttl", &self.ttl);
        formatter.field("display_name", &self.display_name);
        formatter.field(
            "enable_pull_request_preview",
            &self.enable_pull_request_preview,
        );
        formatter.field(
            "pull_request_environment_name",
            &self.pull_request_environment_name,
        );
        formatter.field("backend_environment_arn", &self.backend_environment_arn);
        formatter.finish()
    }
}

/// <p> The request structure for the backend environment create request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendEnvironmentInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The name for the backend environment. </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p> The AWS CloudFormation stack name of a backend environment. </p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p> The name of deployment artifacts. </p>
    pub deployment_artifacts: std::option::Option<std::string::String>,
}
impl CreateBackendEnvironmentInput {
    /// <p> The unique ID for an Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The name for the backend environment. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p> The AWS CloudFormation stack name of a backend environment. </p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p> The name of deployment artifacts. </p>
    pub fn deployment_artifacts(&self) -> std::option::Option<&str> {
        self.deployment_artifacts.as_deref()
    }
}
impl std::fmt::Debug for CreateBackendEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendEnvironmentInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("deployment_artifacts", &self.deployment_artifacts);
        formatter.finish()
    }
}

/// <p> The request structure used to create apps in Amplify. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppInput {
    /// <p> The name for an Amplify app. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description for an Amplify app. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The repository for an Amplify app. </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p> The platform or framework for an Amplify app. </p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
    pub iam_service_role_arn: std::option::Option<std::string::String>,
    /// <p> The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. </p>
    pub oauth_token: std::option::Option<std::string::String>,
    /// <p> The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored. </p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p> The environment variables map for an Amplify app. </p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> Enables the auto building of branches for an Amplify app. </p>
    pub enable_branch_auto_build: std::option::Option<bool>,
    /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
    pub enable_branch_auto_deletion: std::option::Option<bool>,
    /// <p> Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app. </p>
    pub enable_basic_auth: std::option::Option<bool>,
    /// <p> The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    pub basic_auth_credentials: std::option::Option<std::string::String>,
    /// <p> The custom rewrite and redirect rules for an Amplify app. </p>
    pub custom_rules: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
    /// <p> The tag for an Amplify app. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The build specification (build spec) for an Amplify app. </p>
    pub build_spec: std::option::Option<std::string::String>,
    /// <p>The custom HTTP headers for an Amplify app.</p>
    pub custom_headers: std::option::Option<std::string::String>,
    /// <p> Enables automated branch creation for an Amplify app. </p>
    pub enable_auto_branch_creation: std::option::Option<bool>,
    /// <p> The automated branch creation glob patterns for an Amplify app. </p>
    pub auto_branch_creation_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The automated branch creation configuration for an Amplify app. </p>
    pub auto_branch_creation_config: std::option::Option<crate::model::AutoBranchCreationConfig>,
}
impl CreateAppInput {
    /// <p> The name for an Amplify app. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The description for an Amplify app. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The repository for an Amplify app. </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p> The platform or framework for an Amplify app. </p>
    pub fn platform(&self) -> std::option::Option<&crate::model::Platform> {
        self.platform.as_ref()
    }
    /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
    pub fn iam_service_role_arn(&self) -> std::option::Option<&str> {
        self.iam_service_role_arn.as_deref()
    }
    /// <p> The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. </p>
    pub fn oauth_token(&self) -> std::option::Option<&str> {
        self.oauth_token.as_deref()
    }
    /// <p> The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored. </p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p> The environment variables map for an Amplify app. </p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
    /// <p> Enables the auto building of branches for an Amplify app. </p>
    pub fn enable_branch_auto_build(&self) -> std::option::Option<bool> {
        self.enable_branch_auto_build
    }
    /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
    pub fn enable_branch_auto_deletion(&self) -> std::option::Option<bool> {
        self.enable_branch_auto_deletion
    }
    /// <p> Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app. </p>
    pub fn enable_basic_auth(&self) -> std::option::Option<bool> {
        self.enable_basic_auth
    }
    /// <p> The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    pub fn basic_auth_credentials(&self) -> std::option::Option<&str> {
        self.basic_auth_credentials.as_deref()
    }
    /// <p> The custom rewrite and redirect rules for an Amplify app. </p>
    pub fn custom_rules(&self) -> std::option::Option<&[crate::model::CustomRule]> {
        self.custom_rules.as_deref()
    }
    /// <p> The tag for an Amplify app. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> The build specification (build spec) for an Amplify app. </p>
    pub fn build_spec(&self) -> std::option::Option<&str> {
        self.build_spec.as_deref()
    }
    /// <p>The custom HTTP headers for an Amplify app.</p>
    pub fn custom_headers(&self) -> std::option::Option<&str> {
        self.custom_headers.as_deref()
    }
    /// <p> Enables automated branch creation for an Amplify app. </p>
    pub fn enable_auto_branch_creation(&self) -> std::option::Option<bool> {
        self.enable_auto_branch_creation
    }
    /// <p> The automated branch creation glob patterns for an Amplify app. </p>
    pub fn auto_branch_creation_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_branch_creation_patterns.as_deref()
    }
    /// <p> The automated branch creation configuration for an Amplify app. </p>
    pub fn auto_branch_creation_config(
        &self,
    ) -> std::option::Option<&crate::model::AutoBranchCreationConfig> {
        self.auto_branch_creation_config.as_ref()
    }
}
impl std::fmt::Debug for CreateAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("repository", &self.repository);
        formatter.field("platform", &self.platform);
        formatter.field("iam_service_role_arn", &self.iam_service_role_arn);
        formatter.field("oauth_token", &"*** Sensitive Data Redacted ***");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("enable_branch_auto_build", &self.enable_branch_auto_build);
        formatter.field(
            "enable_branch_auto_deletion",
            &self.enable_branch_auto_deletion,
        );
        formatter.field("enable_basic_auth", &self.enable_basic_auth);
        formatter.field("basic_auth_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("custom_rules", &self.custom_rules);
        formatter.field("tags", &self.tags);
        formatter.field("build_spec", &self.build_spec);
        formatter.field("custom_headers", &self.custom_headers);
        formatter.field(
            "enable_auto_branch_creation",
            &self.enable_auto_branch_creation,
        );
        formatter.field(
            "auto_branch_creation_patterns",
            &self.auto_branch_creation_patterns,
        );
        formatter.field(
            "auto_branch_creation_config",
            &self.auto_branch_creation_config,
        );
        formatter.finish()
    }
}
