// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app`](crate::client::Client::create_app).
///
/// See [`crate::client::fluent_builders::CreateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApp {
    _private: (),
}
impl CreateApp {
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
    /// Creates a new `CreateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApp {
    type Output = std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_app_error(response)
        } else {
            crate::operation_deser::parse_create_app_response(response)
        }
    }
}

/// Operation shape for `CreateBackendEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backend_environment`](crate::client::Client::create_backend_environment).
///
/// See [`crate::client::fluent_builders::CreateBackendEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackendEnvironment {
    _private: (),
}
impl CreateBackendEnvironment {
    /// Creates a new builder-style object to manufacture [`CreateBackendEnvironmentInput`](crate::input::CreateBackendEnvironmentInput)
    pub fn builder() -> crate::input::create_backend_environment_input::Builder {
        crate::input::create_backend_environment_input::Builder::default()
    }
    /// Creates a new `CreateBackendEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackendEnvironment {
    type Output = std::result::Result<
        crate::output::CreateBackendEnvironmentOutput,
        crate::error::CreateBackendEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backend_environment_error(response)
        } else {
            crate::operation_deser::parse_create_backend_environment_response(response)
        }
    }
}

/// Operation shape for `CreateBranch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_branch`](crate::client::Client::create_branch).
///
/// See [`crate::client::fluent_builders::CreateBranch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBranch {
    _private: (),
}
impl CreateBranch {
    /// Creates a new builder-style object to manufacture [`CreateBranchInput`](crate::input::CreateBranchInput)
    pub fn builder() -> crate::input::create_branch_input::Builder {
        crate::input::create_branch_input::Builder::default()
    }
    /// Creates a new `CreateBranch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBranch {
    type Output =
        std::result::Result<crate::output::CreateBranchOutput, crate::error::CreateBranchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_branch_error(response)
        } else {
            crate::operation_deser::parse_create_branch_response(response)
        }
    }
}

/// Operation shape for `CreateDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_deployment`](crate::client::Client::create_deployment).
///
/// See [`crate::client::fluent_builders::CreateDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeployment {
    _private: (),
}
impl CreateDeployment {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
    /// Creates a new `CreateDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeployment {
    type Output = std::result::Result<
        crate::output::CreateDeploymentOutput,
        crate::error::CreateDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_deployment_error(response)
        } else {
            crate::operation_deser::parse_create_deployment_response(response)
        }
    }
}

/// Operation shape for `CreateDomainAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain_association`](crate::client::Client::create_domain_association).
///
/// See [`crate::client::fluent_builders::CreateDomainAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomainAssociation {
    _private: (),
}
impl CreateDomainAssociation {
    /// Creates a new builder-style object to manufacture [`CreateDomainAssociationInput`](crate::input::CreateDomainAssociationInput)
    pub fn builder() -> crate::input::create_domain_association_input::Builder {
        crate::input::create_domain_association_input::Builder::default()
    }
    /// Creates a new `CreateDomainAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomainAssociation {
    type Output = std::result::Result<
        crate::output::CreateDomainAssociationOutput,
        crate::error::CreateDomainAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_domain_association_error(response)
        } else {
            crate::operation_deser::parse_create_domain_association_response(response)
        }
    }
}

/// Operation shape for `CreateWebhook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_webhook`](crate::client::Client::create_webhook).
///
/// See [`crate::client::fluent_builders::CreateWebhook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWebhook {
    _private: (),
}
impl CreateWebhook {
    /// Creates a new builder-style object to manufacture [`CreateWebhookInput`](crate::input::CreateWebhookInput)
    pub fn builder() -> crate::input::create_webhook_input::Builder {
        crate::input::create_webhook_input::Builder::default()
    }
    /// Creates a new `CreateWebhook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWebhook {
    type Output =
        std::result::Result<crate::output::CreateWebhookOutput, crate::error::CreateWebhookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_webhook_error(response)
        } else {
            crate::operation_deser::parse_create_webhook_response(response)
        }
    }
}

/// Operation shape for `DeleteApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app`](crate::client::Client::delete_app).
///
/// See [`crate::client::fluent_builders::DeleteApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApp {
    _private: (),
}
impl DeleteApp {
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
    /// Creates a new `DeleteApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApp {
    type Output = std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_error(response)
        } else {
            crate::operation_deser::parse_delete_app_response(response)
        }
    }
}

/// Operation shape for `DeleteBackendEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backend_environment`](crate::client::Client::delete_backend_environment).
///
/// See [`crate::client::fluent_builders::DeleteBackendEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackendEnvironment {
    _private: (),
}
impl DeleteBackendEnvironment {
    /// Creates a new builder-style object to manufacture [`DeleteBackendEnvironmentInput`](crate::input::DeleteBackendEnvironmentInput)
    pub fn builder() -> crate::input::delete_backend_environment_input::Builder {
        crate::input::delete_backend_environment_input::Builder::default()
    }
    /// Creates a new `DeleteBackendEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackendEnvironment {
    type Output = std::result::Result<
        crate::output::DeleteBackendEnvironmentOutput,
        crate::error::DeleteBackendEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backend_environment_error(response)
        } else {
            crate::operation_deser::parse_delete_backend_environment_response(response)
        }
    }
}

/// Operation shape for `DeleteBranch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_branch`](crate::client::Client::delete_branch).
///
/// See [`crate::client::fluent_builders::DeleteBranch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBranch {
    _private: (),
}
impl DeleteBranch {
    /// Creates a new builder-style object to manufacture [`DeleteBranchInput`](crate::input::DeleteBranchInput)
    pub fn builder() -> crate::input::delete_branch_input::Builder {
        crate::input::delete_branch_input::Builder::default()
    }
    /// Creates a new `DeleteBranch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBranch {
    type Output =
        std::result::Result<crate::output::DeleteBranchOutput, crate::error::DeleteBranchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_branch_error(response)
        } else {
            crate::operation_deser::parse_delete_branch_response(response)
        }
    }
}

/// Operation shape for `DeleteDomainAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain_association`](crate::client::Client::delete_domain_association).
///
/// See [`crate::client::fluent_builders::DeleteDomainAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomainAssociation {
    _private: (),
}
impl DeleteDomainAssociation {
    /// Creates a new builder-style object to manufacture [`DeleteDomainAssociationInput`](crate::input::DeleteDomainAssociationInput)
    pub fn builder() -> crate::input::delete_domain_association_input::Builder {
        crate::input::delete_domain_association_input::Builder::default()
    }
    /// Creates a new `DeleteDomainAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomainAssociation {
    type Output = std::result::Result<
        crate::output::DeleteDomainAssociationOutput,
        crate::error::DeleteDomainAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_domain_association_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_association_response(response)
        }
    }
}

/// Operation shape for `DeleteJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_job`](crate::client::Client::delete_job).
///
/// See [`crate::client::fluent_builders::DeleteJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJob {
    _private: (),
}
impl DeleteJob {
    /// Creates a new builder-style object to manufacture [`DeleteJobInput`](crate::input::DeleteJobInput)
    pub fn builder() -> crate::input::delete_job_input::Builder {
        crate::input::delete_job_input::Builder::default()
    }
    /// Creates a new `DeleteJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJob {
    type Output = std::result::Result<crate::output::DeleteJobOutput, crate::error::DeleteJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_job_error(response)
        } else {
            crate::operation_deser::parse_delete_job_response(response)
        }
    }
}

/// Operation shape for `DeleteWebhook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_webhook`](crate::client::Client::delete_webhook).
///
/// See [`crate::client::fluent_builders::DeleteWebhook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWebhook {
    _private: (),
}
impl DeleteWebhook {
    /// Creates a new builder-style object to manufacture [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
    pub fn builder() -> crate::input::delete_webhook_input::Builder {
        crate::input::delete_webhook_input::Builder::default()
    }
    /// Creates a new `DeleteWebhook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWebhook {
    type Output =
        std::result::Result<crate::output::DeleteWebhookOutput, crate::error::DeleteWebhookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_webhook_error(response)
        } else {
            crate::operation_deser::parse_delete_webhook_response(response)
        }
    }
}

/// Operation shape for `GenerateAccessLogs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_access_logs`](crate::client::Client::generate_access_logs).
///
/// See [`crate::client::fluent_builders::GenerateAccessLogs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateAccessLogs {
    _private: (),
}
impl GenerateAccessLogs {
    /// Creates a new builder-style object to manufacture [`GenerateAccessLogsInput`](crate::input::GenerateAccessLogsInput)
    pub fn builder() -> crate::input::generate_access_logs_input::Builder {
        crate::input::generate_access_logs_input::Builder::default()
    }
    /// Creates a new `GenerateAccessLogs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateAccessLogs {
    type Output = std::result::Result<
        crate::output::GenerateAccessLogsOutput,
        crate::error::GenerateAccessLogsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_access_logs_error(response)
        } else {
            crate::operation_deser::parse_generate_access_logs_response(response)
        }
    }
}

/// Operation shape for `GetApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_app`](crate::client::Client::get_app).
///
/// See [`crate::client::fluent_builders::GetApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApp {
    _private: (),
}
impl GetApp {
    /// Creates a new builder-style object to manufacture [`GetAppInput`](crate::input::GetAppInput)
    pub fn builder() -> crate::input::get_app_input::Builder {
        crate::input::get_app_input::Builder::default()
    }
    /// Creates a new `GetApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApp {
    type Output = std::result::Result<crate::output::GetAppOutput, crate::error::GetAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_app_error(response)
        } else {
            crate::operation_deser::parse_get_app_response(response)
        }
    }
}

/// Operation shape for `GetArtifactUrl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_artifact_url`](crate::client::Client::get_artifact_url).
///
/// See [`crate::client::fluent_builders::GetArtifactUrl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetArtifactUrl {
    _private: (),
}
impl GetArtifactUrl {
    /// Creates a new builder-style object to manufacture [`GetArtifactUrlInput`](crate::input::GetArtifactUrlInput)
    pub fn builder() -> crate::input::get_artifact_url_input::Builder {
        crate::input::get_artifact_url_input::Builder::default()
    }
    /// Creates a new `GetArtifactUrl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetArtifactUrl {
    type Output =
        std::result::Result<crate::output::GetArtifactUrlOutput, crate::error::GetArtifactUrlError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_artifact_url_error(response)
        } else {
            crate::operation_deser::parse_get_artifact_url_response(response)
        }
    }
}

/// Operation shape for `GetBackendEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backend_environment`](crate::client::Client::get_backend_environment).
///
/// See [`crate::client::fluent_builders::GetBackendEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackendEnvironment {
    _private: (),
}
impl GetBackendEnvironment {
    /// Creates a new builder-style object to manufacture [`GetBackendEnvironmentInput`](crate::input::GetBackendEnvironmentInput)
    pub fn builder() -> crate::input::get_backend_environment_input::Builder {
        crate::input::get_backend_environment_input::Builder::default()
    }
    /// Creates a new `GetBackendEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackendEnvironment {
    type Output = std::result::Result<
        crate::output::GetBackendEnvironmentOutput,
        crate::error::GetBackendEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backend_environment_error(response)
        } else {
            crate::operation_deser::parse_get_backend_environment_response(response)
        }
    }
}

/// Operation shape for `GetBranch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_branch`](crate::client::Client::get_branch).
///
/// See [`crate::client::fluent_builders::GetBranch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBranch {
    _private: (),
}
impl GetBranch {
    /// Creates a new builder-style object to manufacture [`GetBranchInput`](crate::input::GetBranchInput)
    pub fn builder() -> crate::input::get_branch_input::Builder {
        crate::input::get_branch_input::Builder::default()
    }
    /// Creates a new `GetBranch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBranch {
    type Output = std::result::Result<crate::output::GetBranchOutput, crate::error::GetBranchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_branch_error(response)
        } else {
            crate::operation_deser::parse_get_branch_response(response)
        }
    }
}

/// Operation shape for `GetDomainAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain_association`](crate::client::Client::get_domain_association).
///
/// See [`crate::client::fluent_builders::GetDomainAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomainAssociation {
    _private: (),
}
impl GetDomainAssociation {
    /// Creates a new builder-style object to manufacture [`GetDomainAssociationInput`](crate::input::GetDomainAssociationInput)
    pub fn builder() -> crate::input::get_domain_association_input::Builder {
        crate::input::get_domain_association_input::Builder::default()
    }
    /// Creates a new `GetDomainAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomainAssociation {
    type Output = std::result::Result<
        crate::output::GetDomainAssociationOutput,
        crate::error::GetDomainAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_association_error(response)
        } else {
            crate::operation_deser::parse_get_domain_association_response(response)
        }
    }
}

/// Operation shape for `GetJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job`](crate::client::Client::get_job).
///
/// See [`crate::client::fluent_builders::GetJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJob {
    _private: (),
}
impl GetJob {
    /// Creates a new builder-style object to manufacture [`GetJobInput`](crate::input::GetJobInput)
    pub fn builder() -> crate::input::get_job_input::Builder {
        crate::input::get_job_input::Builder::default()
    }
    /// Creates a new `GetJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJob {
    type Output = std::result::Result<crate::output::GetJobOutput, crate::error::GetJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_error(response)
        } else {
            crate::operation_deser::parse_get_job_response(response)
        }
    }
}

/// Operation shape for `GetWebhook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_webhook`](crate::client::Client::get_webhook).
///
/// See [`crate::client::fluent_builders::GetWebhook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWebhook {
    _private: (),
}
impl GetWebhook {
    /// Creates a new builder-style object to manufacture [`GetWebhookInput`](crate::input::GetWebhookInput)
    pub fn builder() -> crate::input::get_webhook_input::Builder {
        crate::input::get_webhook_input::Builder::default()
    }
    /// Creates a new `GetWebhook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWebhook {
    type Output =
        std::result::Result<crate::output::GetWebhookOutput, crate::error::GetWebhookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_webhook_error(response)
        } else {
            crate::operation_deser::parse_get_webhook_response(response)
        }
    }
}

/// Operation shape for `ListApps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_apps`](crate::client::Client::list_apps).
///
/// See [`crate::client::fluent_builders::ListApps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApps {
    _private: (),
}
impl ListApps {
    /// Creates a new builder-style object to manufacture [`ListAppsInput`](crate::input::ListAppsInput)
    pub fn builder() -> crate::input::list_apps_input::Builder {
        crate::input::list_apps_input::Builder::default()
    }
    /// Creates a new `ListApps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApps {
    type Output = std::result::Result<crate::output::ListAppsOutput, crate::error::ListAppsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_apps_error(response)
        } else {
            crate::operation_deser::parse_list_apps_response(response)
        }
    }
}

/// Operation shape for `ListArtifacts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_artifacts`](crate::client::Client::list_artifacts).
///
/// See [`crate::client::fluent_builders::ListArtifacts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListArtifacts {
    _private: (),
}
impl ListArtifacts {
    /// Creates a new builder-style object to manufacture [`ListArtifactsInput`](crate::input::ListArtifactsInput)
    pub fn builder() -> crate::input::list_artifacts_input::Builder {
        crate::input::list_artifacts_input::Builder::default()
    }
    /// Creates a new `ListArtifacts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListArtifacts {
    type Output =
        std::result::Result<crate::output::ListArtifactsOutput, crate::error::ListArtifactsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_artifacts_error(response)
        } else {
            crate::operation_deser::parse_list_artifacts_response(response)
        }
    }
}

/// Operation shape for `ListBackendEnvironments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_backend_environments`](crate::client::Client::list_backend_environments).
///
/// See [`crate::client::fluent_builders::ListBackendEnvironments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBackendEnvironments {
    _private: (),
}
impl ListBackendEnvironments {
    /// Creates a new builder-style object to manufacture [`ListBackendEnvironmentsInput`](crate::input::ListBackendEnvironmentsInput)
    pub fn builder() -> crate::input::list_backend_environments_input::Builder {
        crate::input::list_backend_environments_input::Builder::default()
    }
    /// Creates a new `ListBackendEnvironments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBackendEnvironments {
    type Output = std::result::Result<
        crate::output::ListBackendEnvironmentsOutput,
        crate::error::ListBackendEnvironmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_backend_environments_error(response)
        } else {
            crate::operation_deser::parse_list_backend_environments_response(response)
        }
    }
}

/// Operation shape for `ListBranches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_branches`](crate::client::Client::list_branches).
///
/// See [`crate::client::fluent_builders::ListBranches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBranches {
    _private: (),
}
impl ListBranches {
    /// Creates a new builder-style object to manufacture [`ListBranchesInput`](crate::input::ListBranchesInput)
    pub fn builder() -> crate::input::list_branches_input::Builder {
        crate::input::list_branches_input::Builder::default()
    }
    /// Creates a new `ListBranches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBranches {
    type Output =
        std::result::Result<crate::output::ListBranchesOutput, crate::error::ListBranchesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_branches_error(response)
        } else {
            crate::operation_deser::parse_list_branches_response(response)
        }
    }
}

/// Operation shape for `ListDomainAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domain_associations`](crate::client::Client::list_domain_associations).
///
/// See [`crate::client::fluent_builders::ListDomainAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomainAssociations {
    _private: (),
}
impl ListDomainAssociations {
    /// Creates a new builder-style object to manufacture [`ListDomainAssociationsInput`](crate::input::ListDomainAssociationsInput)
    pub fn builder() -> crate::input::list_domain_associations_input::Builder {
        crate::input::list_domain_associations_input::Builder::default()
    }
    /// Creates a new `ListDomainAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomainAssociations {
    type Output = std::result::Result<
        crate::output::ListDomainAssociationsOutput,
        crate::error::ListDomainAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domain_associations_error(response)
        } else {
            crate::operation_deser::parse_list_domain_associations_response(response)
        }
    }
}

/// Operation shape for `ListJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs`](crate::client::Client::list_jobs).
///
/// See [`crate::client::fluent_builders::ListJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobs {
    _private: (),
}
impl ListJobs {
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
    /// Creates a new `ListJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobs {
    type Output = std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWebhooks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_webhooks`](crate::client::Client::list_webhooks).
///
/// See [`crate::client::fluent_builders::ListWebhooks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWebhooks {
    _private: (),
}
impl ListWebhooks {
    /// Creates a new builder-style object to manufacture [`ListWebhooksInput`](crate::input::ListWebhooksInput)
    pub fn builder() -> crate::input::list_webhooks_input::Builder {
        crate::input::list_webhooks_input::Builder::default()
    }
    /// Creates a new `ListWebhooks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWebhooks {
    type Output =
        std::result::Result<crate::output::ListWebhooksOutput, crate::error::ListWebhooksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_webhooks_error(response)
        } else {
            crate::operation_deser::parse_list_webhooks_response(response)
        }
    }
}

/// Operation shape for `StartDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_deployment`](crate::client::Client::start_deployment).
///
/// See [`crate::client::fluent_builders::StartDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDeployment {
    _private: (),
}
impl StartDeployment {
    /// Creates a new builder-style object to manufacture [`StartDeploymentInput`](crate::input::StartDeploymentInput)
    pub fn builder() -> crate::input::start_deployment_input::Builder {
        crate::input::start_deployment_input::Builder::default()
    }
    /// Creates a new `StartDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDeployment {
    type Output = std::result::Result<
        crate::output::StartDeploymentOutput,
        crate::error::StartDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_deployment_error(response)
        } else {
            crate::operation_deser::parse_start_deployment_response(response)
        }
    }
}

/// Operation shape for `StartJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_job`](crate::client::Client::start_job).
///
/// See [`crate::client::fluent_builders::StartJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartJob {
    _private: (),
}
impl StartJob {
    /// Creates a new builder-style object to manufacture [`StartJobInput`](crate::input::StartJobInput)
    pub fn builder() -> crate::input::start_job_input::Builder {
        crate::input::start_job_input::Builder::default()
    }
    /// Creates a new `StartJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartJob {
    type Output = std::result::Result<crate::output::StartJobOutput, crate::error::StartJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_job_error(response)
        } else {
            crate::operation_deser::parse_start_job_response(response)
        }
    }
}

/// Operation shape for `StopJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_job`](crate::client::Client::stop_job).
///
/// See [`crate::client::fluent_builders::StopJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopJob {
    _private: (),
}
impl StopJob {
    /// Creates a new builder-style object to manufacture [`StopJobInput`](crate::input::StopJobInput)
    pub fn builder() -> crate::input::stop_job_input::Builder {
        crate::input::stop_job_input::Builder::default()
    }
    /// Creates a new `StopJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopJob {
    type Output = std::result::Result<crate::output::StopJobOutput, crate::error::StopJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_job_error(response)
        } else {
            crate::operation_deser::parse_stop_job_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_app`](crate::client::Client::update_app).
///
/// See [`crate::client::fluent_builders::UpdateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApp {
    _private: (),
}
impl UpdateApp {
    /// Creates a new builder-style object to manufacture [`UpdateAppInput`](crate::input::UpdateAppInput)
    pub fn builder() -> crate::input::update_app_input::Builder {
        crate::input::update_app_input::Builder::default()
    }
    /// Creates a new `UpdateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApp {
    type Output = std::result::Result<crate::output::UpdateAppOutput, crate::error::UpdateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_app_error(response)
        } else {
            crate::operation_deser::parse_update_app_response(response)
        }
    }
}

/// Operation shape for `UpdateBranch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_branch`](crate::client::Client::update_branch).
///
/// See [`crate::client::fluent_builders::UpdateBranch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBranch {
    _private: (),
}
impl UpdateBranch {
    /// Creates a new builder-style object to manufacture [`UpdateBranchInput`](crate::input::UpdateBranchInput)
    pub fn builder() -> crate::input::update_branch_input::Builder {
        crate::input::update_branch_input::Builder::default()
    }
    /// Creates a new `UpdateBranch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBranch {
    type Output =
        std::result::Result<crate::output::UpdateBranchOutput, crate::error::UpdateBranchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_branch_error(response)
        } else {
            crate::operation_deser::parse_update_branch_response(response)
        }
    }
}

/// Operation shape for `UpdateDomainAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_domain_association`](crate::client::Client::update_domain_association).
///
/// See [`crate::client::fluent_builders::UpdateDomainAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDomainAssociation {
    _private: (),
}
impl UpdateDomainAssociation {
    /// Creates a new builder-style object to manufacture [`UpdateDomainAssociationInput`](crate::input::UpdateDomainAssociationInput)
    pub fn builder() -> crate::input::update_domain_association_input::Builder {
        crate::input::update_domain_association_input::Builder::default()
    }
    /// Creates a new `UpdateDomainAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDomainAssociation {
    type Output = std::result::Result<
        crate::output::UpdateDomainAssociationOutput,
        crate::error::UpdateDomainAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_domain_association_error(response)
        } else {
            crate::operation_deser::parse_update_domain_association_response(response)
        }
    }
}

/// Operation shape for `UpdateWebhook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_webhook`](crate::client::Client::update_webhook).
///
/// See [`crate::client::fluent_builders::UpdateWebhook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWebhook {
    _private: (),
}
impl UpdateWebhook {
    /// Creates a new builder-style object to manufacture [`UpdateWebhookInput`](crate::input::UpdateWebhookInput)
    pub fn builder() -> crate::input::update_webhook_input::Builder {
        crate::input::update_webhook_input::Builder::default()
    }
    /// Creates a new `UpdateWebhook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWebhook {
    type Output =
        std::result::Result<crate::output::UpdateWebhookOutput, crate::error::UpdateWebhookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_webhook_error(response)
        } else {
            crate::operation_deser::parse_update_webhook_response(response)
        }
    }
}
