// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Amplify
///
/// Client for invoking operations on AWS Amplify. Each operation on AWS Amplify is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_amplify::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_amplify::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_amplify::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateApp` operation.
    ///
    /// See [`CreateApp`](crate::client::fluent_builders::CreateApp) for more information about the
    /// operation and its arguments.
    pub fn create_app(&self) -> fluent_builders::CreateApp<C, M, R> {
        fluent_builders::CreateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBackendEnvironment` operation.
    ///
    /// See [`CreateBackendEnvironment`](crate::client::fluent_builders::CreateBackendEnvironment) for more information about the
    /// operation and its arguments.
    pub fn create_backend_environment(&self) -> fluent_builders::CreateBackendEnvironment<C, M, R> {
        fluent_builders::CreateBackendEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBranch` operation.
    ///
    /// See [`CreateBranch`](crate::client::fluent_builders::CreateBranch) for more information about the
    /// operation and its arguments.
    pub fn create_branch(&self) -> fluent_builders::CreateBranch<C, M, R> {
        fluent_builders::CreateBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeployment` operation.
    ///
    /// See [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) for more information about the
    /// operation and its arguments.
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment<C, M, R> {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomainAssociation` operation.
    ///
    /// See [`CreateDomainAssociation`](crate::client::fluent_builders::CreateDomainAssociation) for more information about the
    /// operation and its arguments.
    pub fn create_domain_association(&self) -> fluent_builders::CreateDomainAssociation<C, M, R> {
        fluent_builders::CreateDomainAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWebhook` operation.
    ///
    /// See [`CreateWebhook`](crate::client::fluent_builders::CreateWebhook) for more information about the
    /// operation and its arguments.
    pub fn create_webhook(&self) -> fluent_builders::CreateWebhook<C, M, R> {
        fluent_builders::CreateWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApp` operation.
    ///
    /// See [`DeleteApp`](crate::client::fluent_builders::DeleteApp) for more information about the
    /// operation and its arguments.
    pub fn delete_app(&self) -> fluent_builders::DeleteApp<C, M, R> {
        fluent_builders::DeleteApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackendEnvironment` operation.
    ///
    /// See [`DeleteBackendEnvironment`](crate::client::fluent_builders::DeleteBackendEnvironment) for more information about the
    /// operation and its arguments.
    pub fn delete_backend_environment(&self) -> fluent_builders::DeleteBackendEnvironment<C, M, R> {
        fluent_builders::DeleteBackendEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBranch` operation.
    ///
    /// See [`DeleteBranch`](crate::client::fluent_builders::DeleteBranch) for more information about the
    /// operation and its arguments.
    pub fn delete_branch(&self) -> fluent_builders::DeleteBranch<C, M, R> {
        fluent_builders::DeleteBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomainAssociation` operation.
    ///
    /// See [`DeleteDomainAssociation`](crate::client::fluent_builders::DeleteDomainAssociation) for more information about the
    /// operation and its arguments.
    pub fn delete_domain_association(&self) -> fluent_builders::DeleteDomainAssociation<C, M, R> {
        fluent_builders::DeleteDomainAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJob` operation.
    ///
    /// See [`DeleteJob`](crate::client::fluent_builders::DeleteJob) for more information about the
    /// operation and its arguments.
    pub fn delete_job(&self) -> fluent_builders::DeleteJob<C, M, R> {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWebhook` operation.
    ///
    /// See [`DeleteWebhook`](crate::client::fluent_builders::DeleteWebhook) for more information about the
    /// operation and its arguments.
    pub fn delete_webhook(&self) -> fluent_builders::DeleteWebhook<C, M, R> {
        fluent_builders::DeleteWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateAccessLogs` operation.
    ///
    /// See [`GenerateAccessLogs`](crate::client::fluent_builders::GenerateAccessLogs) for more information about the
    /// operation and its arguments.
    pub fn generate_access_logs(&self) -> fluent_builders::GenerateAccessLogs<C, M, R> {
        fluent_builders::GenerateAccessLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApp` operation.
    ///
    /// See [`GetApp`](crate::client::fluent_builders::GetApp) for more information about the
    /// operation and its arguments.
    pub fn get_app(&self) -> fluent_builders::GetApp<C, M, R> {
        fluent_builders::GetApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetArtifactUrl` operation.
    ///
    /// See [`GetArtifactUrl`](crate::client::fluent_builders::GetArtifactUrl) for more information about the
    /// operation and its arguments.
    pub fn get_artifact_url(&self) -> fluent_builders::GetArtifactUrl<C, M, R> {
        fluent_builders::GetArtifactUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackendEnvironment` operation.
    ///
    /// See [`GetBackendEnvironment`](crate::client::fluent_builders::GetBackendEnvironment) for more information about the
    /// operation and its arguments.
    pub fn get_backend_environment(&self) -> fluent_builders::GetBackendEnvironment<C, M, R> {
        fluent_builders::GetBackendEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBranch` operation.
    ///
    /// See [`GetBranch`](crate::client::fluent_builders::GetBranch) for more information about the
    /// operation and its arguments.
    pub fn get_branch(&self) -> fluent_builders::GetBranch<C, M, R> {
        fluent_builders::GetBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainAssociation` operation.
    ///
    /// See [`GetDomainAssociation`](crate::client::fluent_builders::GetDomainAssociation) for more information about the
    /// operation and its arguments.
    pub fn get_domain_association(&self) -> fluent_builders::GetDomainAssociation<C, M, R> {
        fluent_builders::GetDomainAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJob` operation.
    ///
    /// See [`GetJob`](crate::client::fluent_builders::GetJob) for more information about the
    /// operation and its arguments.
    pub fn get_job(&self) -> fluent_builders::GetJob<C, M, R> {
        fluent_builders::GetJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWebhook` operation.
    ///
    /// See [`GetWebhook`](crate::client::fluent_builders::GetWebhook) for more information about the
    /// operation and its arguments.
    pub fn get_webhook(&self) -> fluent_builders::GetWebhook<C, M, R> {
        fluent_builders::GetWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApps` operation.
    ///
    /// See [`ListApps`](crate::client::fluent_builders::ListApps) for more information about the
    /// operation and its arguments.
    pub fn list_apps(&self) -> fluent_builders::ListApps<C, M, R> {
        fluent_builders::ListApps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListArtifacts` operation.
    ///
    /// See [`ListArtifacts`](crate::client::fluent_builders::ListArtifacts) for more information about the
    /// operation and its arguments.
    pub fn list_artifacts(&self) -> fluent_builders::ListArtifacts<C, M, R> {
        fluent_builders::ListArtifacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBackendEnvironments` operation.
    ///
    /// See [`ListBackendEnvironments`](crate::client::fluent_builders::ListBackendEnvironments) for more information about the
    /// operation and its arguments.
    pub fn list_backend_environments(&self) -> fluent_builders::ListBackendEnvironments<C, M, R> {
        fluent_builders::ListBackendEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBranches` operation.
    ///
    /// See [`ListBranches`](crate::client::fluent_builders::ListBranches) for more information about the
    /// operation and its arguments.
    pub fn list_branches(&self) -> fluent_builders::ListBranches<C, M, R> {
        fluent_builders::ListBranches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomainAssociations` operation.
    ///
    /// See [`ListDomainAssociations`](crate::client::fluent_builders::ListDomainAssociations) for more information about the
    /// operation and its arguments.
    pub fn list_domain_associations(&self) -> fluent_builders::ListDomainAssociations<C, M, R> {
        fluent_builders::ListDomainAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobs` operation.
    ///
    /// See [`ListJobs`](crate::client::fluent_builders::ListJobs) for more information about the
    /// operation and its arguments.
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWebhooks` operation.
    ///
    /// See [`ListWebhooks`](crate::client::fluent_builders::ListWebhooks) for more information about the
    /// operation and its arguments.
    pub fn list_webhooks(&self) -> fluent_builders::ListWebhooks<C, M, R> {
        fluent_builders::ListWebhooks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDeployment` operation.
    ///
    /// See [`StartDeployment`](crate::client::fluent_builders::StartDeployment) for more information about the
    /// operation and its arguments.
    pub fn start_deployment(&self) -> fluent_builders::StartDeployment<C, M, R> {
        fluent_builders::StartDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartJob` operation.
    ///
    /// See [`StartJob`](crate::client::fluent_builders::StartJob) for more information about the
    /// operation and its arguments.
    pub fn start_job(&self) -> fluent_builders::StartJob<C, M, R> {
        fluent_builders::StartJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopJob` operation.
    ///
    /// See [`StopJob`](crate::client::fluent_builders::StopJob) for more information about the
    /// operation and its arguments.
    pub fn stop_job(&self) -> fluent_builders::StopJob<C, M, R> {
        fluent_builders::StopJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApp` operation.
    ///
    /// See [`UpdateApp`](crate::client::fluent_builders::UpdateApp) for more information about the
    /// operation and its arguments.
    pub fn update_app(&self) -> fluent_builders::UpdateApp<C, M, R> {
        fluent_builders::UpdateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBranch` operation.
    ///
    /// See [`UpdateBranch`](crate::client::fluent_builders::UpdateBranch) for more information about the
    /// operation and its arguments.
    pub fn update_branch(&self) -> fluent_builders::UpdateBranch<C, M, R> {
        fluent_builders::UpdateBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainAssociation` operation.
    ///
    /// See [`UpdateDomainAssociation`](crate::client::fluent_builders::UpdateDomainAssociation) for more information about the
    /// operation and its arguments.
    pub fn update_domain_association(&self) -> fluent_builders::UpdateDomainAssociation<C, M, R> {
        fluent_builders::UpdateDomainAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWebhook` operation.
    ///
    /// See [`UpdateWebhook`](crate::client::fluent_builders::UpdateWebhook) for more information about the
    /// operation and its arguments.
    pub fn update_webhook(&self) -> fluent_builders::UpdateWebhook<C, M, R> {
        fluent_builders::UpdateWebhook::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApp`.
    ///
    /// <p> Creates a new Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_input::Builder,
    }
    impl<C, M, R> CreateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInputOperationOutputAlias,
                crate::output::CreateAppOutput,
                crate::error::CreateAppError,
                crate::input::CreateAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name for an Amplify app. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p> The name for an Amplify app. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The repository for an Amplify app. </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p> The repository for an Amplify app. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The platform or framework for an Amplify app. </p>
        pub fn platform(mut self, inp: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(inp);
            self
        }
        /// <p> The platform or framework for an Amplify app. </p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn iam_service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_service_role_arn(inp);
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn set_iam_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iam_service_role_arn(input);
            self
        }
        /// <p> The OAuth token for a third-party source control system for an Amplify app. The OAuth
        /// token is used to create a webhook and a read-only deploy key. The OAuth token is not
        /// stored. </p>
        pub fn oauth_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.oauth_token(inp);
            self
        }
        /// <p> The OAuth token for a third-party source control system for an Amplify app. The OAuth
        /// token is used to create a webhook and a read-only deploy key. The OAuth token is not
        /// stored. </p>
        pub fn set_oauth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_oauth_token(input);
            self
        }
        /// <p> The personal access token for a third-party source control system for an Amplify app.
        /// The personal access token is used to create a webhook and a read-only deploy key. The
        /// token is not stored. </p>
        pub fn access_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(inp);
            self
        }
        /// <p> The personal access token for a third-party source control system for an Amplify app.
        /// The personal access token is used to create a webhook and a read-only deploy key. The
        /// token is not stored. </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// Adds a key-value pair to `environmentVariables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables map for an Amplify app. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_variables(k, v);
            self
        }
        /// <p> The environment variables map for an Amplify app. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment_variables(input);
            self
        }
        /// <p> Enables the auto building of branches for an Amplify app. </p>
        pub fn enable_branch_auto_build(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_branch_auto_build(inp);
            self
        }
        /// <p> Enables the auto building of branches for an Amplify app. </p>
        pub fn set_enable_branch_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_branch_auto_build(input);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch
        /// from your Git repository. </p>
        pub fn enable_branch_auto_deletion(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_branch_auto_deletion(inp);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch
        /// from your Git repository. </p>
        pub fn set_enable_branch_auto_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_branch_auto_deletion(input);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. This will apply to all branches that
        /// are part of this app. </p>
        pub fn enable_basic_auth(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_basic_auth(inp);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. This will apply to all branches that
        /// are part of this app. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_basic_auth(input);
            self
        }
        /// <p> The credentials for basic authorization for an Amplify app. </p>
        pub fn basic_auth_credentials(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basic_auth_credentials(inp);
            self
        }
        /// <p> The credentials for basic authorization for an Amplify app. </p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_basic_auth_credentials(input);
            self
        }
        /// Appends an item to `customRules`.
        ///
        /// To override the contents of this collection use [`set_custom_rules`](Self::set_custom_rules).
        ///
        /// <p> The custom rewrite and redirect rules for an Amplify app. </p>
        pub fn custom_rules(mut self, inp: impl Into<crate::model::CustomRule>) -> Self {
            self.inner = self.inner.custom_rules(inp);
            self
        }
        /// <p> The custom rewrite and redirect rules for an Amplify app. </p>
        pub fn set_custom_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        ) -> Self {
            self.inner = self.inner.set_custom_rules(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tag for an Amplify app. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p> The tag for an Amplify app. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn build_spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.build_spec(inp);
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_build_spec(input);
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn custom_headers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_headers(inp);
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn set_custom_headers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_headers(input);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn enable_auto_branch_creation(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_auto_branch_creation(inp);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn set_enable_auto_branch_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_branch_creation(input);
            self
        }
        /// Appends an item to `autoBranchCreationPatterns`.
        ///
        /// To override the contents of this collection use [`set_auto_branch_creation_patterns`](Self::set_auto_branch_creation_patterns).
        ///
        /// <p> The automated branch creation glob patterns for an Amplify app. </p>
        pub fn auto_branch_creation_patterns(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_branch_creation_patterns(inp);
            self
        }
        /// <p> The automated branch creation glob patterns for an Amplify app. </p>
        pub fn set_auto_branch_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_branch_creation_patterns(input);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn auto_branch_creation_config(
            mut self,
            inp: crate::model::AutoBranchCreationConfig,
        ) -> Self {
            self.inner = self.inner.auto_branch_creation_config(inp);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn set_auto_branch_creation_config(
            mut self,
            input: std::option::Option<crate::model::AutoBranchCreationConfig>,
        ) -> Self {
            self.inner = self.inner.set_auto_branch_creation_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackendEnvironment`.
    ///
    /// <p> Creates a new backend environment for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBackendEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backend_environment_input::Builder,
    }
    impl<C, M, R> CreateBackendEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackendEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackendEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackendEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackendEnvironmentInputOperationOutputAlias,
                crate::output::CreateBackendEnvironmentOutput,
                crate::error::CreateBackendEnvironmentError,
                crate::input::CreateBackendEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p> The AWS CloudFormation stack name of a backend environment. </p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p> The AWS CloudFormation stack name of a backend environment. </p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p> The name of deployment artifacts. </p>
        pub fn deployment_artifacts(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_artifacts(inp);
            self
        }
        /// <p> The name of deployment artifacts. </p>
        pub fn set_deployment_artifacts(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_artifacts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBranch`.
    ///
    /// <p> Creates a new branch for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBranch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_branch_input::Builder,
    }
    impl<C, M, R> CreateBranch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBranchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBranchInputOperationOutputAlias,
                crate::output::CreateBranchOutput,
                crate::error::CreateBranchError,
                crate::input::CreateBranchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The description for the branch. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> The description for the branch. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn stage(mut self, inp: crate::model::Stage) -> Self {
            self.inner = self.inner.stage(inp);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::Stage>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn framework(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework(inp);
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn set_framework(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework(input);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn enable_notification(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_notification(inp);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn set_enable_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_notification(input);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn enable_auto_build(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_auto_build(inp);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn set_enable_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_build(input);
            self
        }
        /// Adds a key-value pair to `environmentVariables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for the branch. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_variables(k, v);
            self
        }
        /// <p> The environment variables for the branch. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment_variables(input);
            self
        }
        /// <p> The basic authorization credentials for the branch. </p>
        pub fn basic_auth_credentials(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basic_auth_credentials(inp);
            self
        }
        /// <p> The basic authorization credentials for the branch. </p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_basic_auth_credentials(input);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn enable_basic_auth(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_basic_auth(inp);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_basic_auth(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn enable_performance_mode(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_performance_mode(inp);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn set_enable_performance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_mode(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tag for the branch. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p> The tag for the branch. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn build_spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.build_spec(inp);
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_build_spec(input);
            self
        }
        /// <p> The content Time To Live (TTL) for the website in seconds. </p>
        pub fn ttl(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ttl(inp);
            self
        }
        /// <p> The content Time To Live (TTL) for the website in seconds. </p>
        pub fn set_ttl(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn enable_pull_request_preview(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_pull_request_preview(inp);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn set_enable_pull_request_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_pull_request_preview(input);
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn pull_request_environment_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.pull_request_environment_name(inp);
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn set_pull_request_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_environment_name(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn backend_environment_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn set_backend_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// <p> Creates a deployment for a manually deployed Amplify app. Manually deployed apps are
    /// not connected to a repository. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl<C, M, R> CreateDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeploymentInputOperationOutputAlias,
                crate::output::CreateDeploymentOutput,
                crate::error::CreateDeploymentError,
                crate::input::CreateDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// Adds a key-value pair to `fileMap`.
        ///
        /// To override the contents of this collection use [`set_file_map`](Self::set_file_map).
        ///
        /// <p> An optional file map that contains the file name as the key and the file content md5
        /// hash as the value. If this argument is provided, the service will generate a unique
        /// upload URL per file. Otherwise, the service will only generate a single upload URL for
        /// the zipped files. </p>
        pub fn file_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.file_map(k, v);
            self
        }
        /// <p> An optional file map that contains the file name as the key and the file content md5
        /// hash as the value. If this argument is provided, the service will generate a unique
        /// upload URL per file. Otherwise, the service will only generate a single upload URL for
        /// the zipped files. </p>
        pub fn set_file_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_file_map(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainAssociation`.
    ///
    /// <p> Creates a new domain association for an Amplify app. This action associates a custom
    /// domain with the Amplify app </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDomainAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_association_input::Builder,
    }
    impl<C, M, R> CreateDomainAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomainAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainAssociationInputOperationOutputAlias,
                crate::output::CreateDomainAssociationOutput,
                crate::error::CreateDomainAssociationError,
                crate::input::CreateDomainAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The domain name for the domain association. </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p> The domain name for the domain association. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn enable_auto_sub_domain(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_auto_sub_domain(inp);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn set_enable_auto_sub_domain(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_sub_domain(input);
            self
        }
        /// Appends an item to `subDomainSettings`.
        ///
        /// To override the contents of this collection use [`set_sub_domain_settings`](Self::set_sub_domain_settings).
        ///
        /// <p> The setting for the subdomain. </p>
        pub fn sub_domain_settings(
            mut self,
            inp: impl Into<crate::model::SubDomainSetting>,
        ) -> Self {
            self.inner = self.inner.sub_domain_settings(inp);
            self
        }
        /// <p> The setting for the subdomain. </p>
        pub fn set_sub_domain_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
        ) -> Self {
            self.inner = self.inner.set_sub_domain_settings(input);
            self
        }
        /// Appends an item to `autoSubDomainCreationPatterns`.
        ///
        /// To override the contents of this collection use [`set_auto_sub_domain_creation_patterns`](Self::set_auto_sub_domain_creation_patterns).
        ///
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn auto_sub_domain_creation_patterns(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_sub_domain_creation_patterns(inp);
            self
        }
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn set_auto_sub_domain_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_sub_domain_creation_patterns(input);
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon
        /// Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn auto_sub_domain_iam_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_sub_domain_iam_role(inp);
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon
        /// Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn set_auto_sub_domain_iam_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_sub_domain_iam_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebhook`.
    ///
    /// <p> Creates a new webhook on an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWebhook<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_webhook_input::Builder,
    }
    impl<C, M, R> CreateWebhook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebhookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWebhookInputOperationOutputAlias,
                crate::output::CreateWebhookOutput,
                crate::error::CreateWebhookError,
                crate::input::CreateWebhookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApp`.
    ///
    /// <p> Deletes an existing Amplify app specified by an app ID. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_input::Builder,
    }
    impl<C, M, R> DeleteApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInputOperationOutputAlias,
                crate::output::DeleteAppOutput,
                crate::error::DeleteAppError,
                crate::input::DeleteAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackendEnvironment`.
    ///
    /// <p> Deletes a backend environment for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBackendEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backend_environment_input::Builder,
    }
    impl<C, M, R> DeleteBackendEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackendEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackendEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackendEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackendEnvironmentInputOperationOutputAlias,
                crate::output::DeleteBackendEnvironmentOutput,
                crate::error::DeleteBackendEnvironmentError,
                crate::input::DeleteBackendEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID of an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of a backend environment of an Amplify app. </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p> The name of a backend environment of an Amplify app. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBranch`.
    ///
    /// <p> Deletes a branch for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBranch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_branch_input::Builder,
    }
    impl<C, M, R> DeleteBranch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBranchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBranchInputOperationOutputAlias,
                crate::output::DeleteBranchOutput,
                crate::error::DeleteBranchError,
                crate::input::DeleteBranchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainAssociation`.
    ///
    /// <p> Deletes a domain association for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDomainAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_association_input::Builder,
    }
    impl<C, M, R> DeleteDomainAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomainAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainAssociationInputOperationOutputAlias,
                crate::output::DeleteDomainAssociationOutput,
                crate::error::DeleteDomainAssociationError,
                crate::input::DeleteDomainAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p> Deletes a job for a branch of an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl<C, M, R> DeleteJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobInputOperationOutputAlias,
                crate::output::DeleteJobOutput,
                crate::error::DeleteJobError,
                crate::input::DeleteJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWebhook`.
    ///
    /// <p> Deletes a webhook. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWebhook<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_webhook_input::Builder,
    }
    impl<C, M, R> DeleteWebhook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWebhookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWebhookInputOperationOutputAlias,
                crate::output::DeleteWebhookOutput,
                crate::error::DeleteWebhookError,
                crate::input::DeleteWebhookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn webhook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.webhook_id(inp);
            self
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_webhook_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateAccessLogs`.
    ///
    /// <p> Returns the website access logs for a specific time range using a presigned URL.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GenerateAccessLogs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_access_logs_input::Builder,
    }
    impl<C, M, R> GenerateAccessLogs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateAccessLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateAccessLogsOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateAccessLogsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateAccessLogsInputOperationOutputAlias,
                crate::output::GenerateAccessLogsOutput,
                crate::error::GenerateAccessLogsError,
                crate::input::GenerateAccessLogsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The time at which the logs should start. The time range specified is inclusive of the
        /// start time. </p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p> The time at which the logs should start. The time range specified is inclusive of the
        /// start time. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The time at which the logs should end. The time range specified is inclusive of the
        /// end time. </p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p> The time at which the logs should end. The time range specified is inclusive of the
        /// end time. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApp`.
    ///
    /// <p> Returns an existing Amplify app by appID. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_input::Builder,
    }
    impl<C, M, R> GetApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppInputOperationOutputAlias,
                crate::output::GetAppOutput,
                crate::error::GetAppError,
                crate::input::GetAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetArtifactUrl`.
    ///
    /// <p> Returns the artifact info that corresponds to an artifact id. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetArtifactUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_artifact_url_input::Builder,
    }
    impl<C, M, R> GetArtifactUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetArtifactUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetArtifactUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetArtifactUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetArtifactUrlInputOperationOutputAlias,
                crate::output::GetArtifactUrlOutput,
                crate::error::GetArtifactUrlError,
                crate::input::GetArtifactUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an artifact. </p>
        pub fn artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_id(inp);
            self
        }
        /// <p> The unique ID for an artifact. </p>
        pub fn set_artifact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_artifact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackendEnvironment`.
    ///
    /// <p> Returns a backend environment for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetBackendEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backend_environment_input::Builder,
    }
    impl<C, M, R> GetBackendEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackendEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackendEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackendEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackendEnvironmentInputOperationOutputAlias,
                crate::output::GetBackendEnvironmentOutput,
                crate::error::GetBackendEnvironmentError,
                crate::input::GetBackendEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBranch`.
    ///
    /// <p> Returns a branch for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetBranch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_branch_input::Builder,
    }
    impl<C, M, R> GetBranch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBranchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBranchInputOperationOutputAlias,
                crate::output::GetBranchOutput,
                crate::error::GetBranchError,
                crate::input::GetBranchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainAssociation`.
    ///
    /// <p> Returns the domain information for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomainAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_association_input::Builder,
    }
    impl<C, M, R> GetDomainAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainAssociationInputOperationOutputAlias,
                crate::output::GetDomainAssociationOutput,
                crate::error::GetDomainAssociationError,
                crate::input::GetDomainAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJob`.
    ///
    /// <p> Returns a job for a branch of an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_input::Builder,
    }
    impl<C, M, R> GetJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobInputOperationOutputAlias,
                crate::output::GetJobOutput,
                crate::error::GetJobError,
                crate::input::GetJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWebhook`.
    ///
    /// <p> Returns the webhook information that corresponds to a specified webhook ID. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetWebhook<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_webhook_input::Builder,
    }
    impl<C, M, R> GetWebhook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWebhookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWebhookInputOperationOutputAlias,
                crate::output::GetWebhookOutput,
                crate::error::GetWebhookError,
                crate::input::GetWebhookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn webhook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.webhook_id(inp);
            self
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_webhook_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApps`.
    ///
    /// <p> Returns a list of the existing Amplify apps. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListApps<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_apps_input::Builder,
    }
    impl<C, M, R> ListApps<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppsInputOperationOutputAlias,
                crate::output::ListAppsOutput,
                crate::error::ListAppsError,
                crate::input::ListAppsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass
        /// its value in another request to retrieve more entries. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass
        /// its value in another request to retrieve more entries. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListArtifacts`.
    ///
    /// <p> Returns a list of artifacts for a specified app, branch, and job. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListArtifacts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_artifacts_input::Builder,
    }
    impl<C, M, R> ListArtifacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListArtifacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListArtifactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListArtifactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListArtifactsInputOperationOutputAlias,
                crate::output::ListArtifactsOutput,
                crate::error::ListArtifactsError,
                crate::input::ListArtifactsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name of a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique ID for a job. </p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p> The unique ID for a job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing artifacts from start. If a non-null
        /// pagination token is returned in a result, pass its value in here to list more artifacts.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A pagination token. Set to null to start listing artifacts from start. If a non-null
        /// pagination token is returned in a result, pass its value in here to list more artifacts.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackendEnvironments`.
    ///
    /// <p> Lists the backend environments for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListBackendEnvironments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_backend_environments_input::Builder,
    }
    impl<C, M, R> ListBackendEnvironments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBackendEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackendEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackendEnvironmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBackendEnvironmentsInputOperationOutputAlias,
                crate::output::ListBackendEnvironmentsOutput,
                crate::error::ListBackendEnvironmentsError,
                crate::input::ListBackendEnvironmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of the backend environment </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p> The name of the backend environment </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing backend environments from the start.
        /// If a non-null pagination token is returned in a result, pass its value in here to list
        /// more backend environments. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A pagination token. Set to null to start listing backend environments from the start.
        /// If a non-null pagination token is returned in a result, pass its value in here to list
        /// more backend environments. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBranches`.
    ///
    /// <p> Lists the branches of an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListBranches<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_branches_input::Builder,
    }
    impl<C, M, R> ListBranches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBranches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBranchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBranchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBranchesInputOperationOutputAlias,
                crate::output::ListBranchesOutput,
                crate::error::ListBranchesError,
                crate::input::ListBranchesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing branches from the start. If a
        /// non-null pagination token is returned in a result, pass its value in here to list more
        /// branches. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A pagination token. Set to null to start listing branches from the start. If a
        /// non-null pagination token is returned in a result, pass its value in here to list more
        /// branches. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainAssociations`.
    ///
    /// <p> Returns the domain associations for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListDomainAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domain_associations_input::Builder,
    }
    impl<C, M, R> ListDomainAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomainAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainAssociationsInputOperationOutputAlias,
                crate::output::ListDomainAssociationsOutput,
                crate::error::ListDomainAssociationsError,
                crate::input::ListDomainAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing apps from the start. If non-null, a
        /// pagination token is returned in a result. Pass its value in here to list more projects.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A pagination token. Set to null to start listing apps from the start. If non-null, a
        /// pagination token is returned in a result. Pass its value in here to list more projects.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p> Lists the jobs for a branch of an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl<C, M, R> ListJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobsInputOperationOutputAlias,
                crate::output::ListJobsOutput,
                crate::error::ListJobsError,
                crate::input::ListJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for a branch. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for a branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing steps from the start. If a non-null
        /// pagination token is returned in a result, pass its value in here to list more steps.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A pagination token. Set to null to start listing steps from the start. If a non-null
        /// pagination token is returned in a result, pass its value in here to list more steps.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns a list of tags for a specified Amazon Resource Name (ARN). </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) to use to list tags. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) to use to list tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebhooks`.
    ///
    /// <p> Returns a list of webhooks for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListWebhooks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_webhooks_input::Builder,
    }
    impl<C, M, R> ListWebhooks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWebhooks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebhooksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebhooksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWebhooksInputOperationOutputAlias,
                crate::output::ListWebhooksOutput,
                crate::error::ListWebhooksError,
                crate::input::ListWebhooksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing webhooks from the start. If
        /// non-null,the pagination token is returned in a result. Pass its value in here to list
        /// more webhooks. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A pagination token. Set to null to start listing webhooks from the start. If
        /// non-null,the pagination token is returned in a result. Pass its value in here to list
        /// more webhooks. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDeployment`.
    ///
    /// <p> Starts a deployment for a manually deployed app. Manually deployed apps are not
    /// connected to a repository. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_deployment_input::Builder,
    }
    impl<C, M, R> StartDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDeploymentInputOperationOutputAlias,
                crate::output::StartDeploymentOutput,
                crate::error::StartDeploymentError,
                crate::input::StartDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The job ID for this deployment, generated by the create deployment request. </p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p> The job ID for this deployment, generated by the create deployment request. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p> The source URL for this deployment, used when calling start deployment without create
        /// deployment. The source URL can be any HTTP GET URL that is publicly accessible and
        /// downloads a single .zip file. </p>
        pub fn source_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_url(inp);
            self
        }
        /// <p> The source URL for this deployment, used when calling start deployment without create
        /// deployment. The source URL can be any HTTP GET URL that is publicly accessible and
        /// downloads a single .zip file. </p>
        pub fn set_source_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartJob`.
    ///
    /// <p> Starts a new job for a branch of an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_job_input::Builder,
    }
    impl<C, M, R> StartJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartJobInputOperationOutputAlias,
                crate::output::StartJobOutput,
                crate::error::StartJobError,
                crate::input::StartJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique ID for an existing job. This is required if the value of
        /// <code>jobType</code> is <code>RETRY</code>. </p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p> The unique ID for an existing job. This is required if the value of
        /// <code>jobType</code> is <code>RETRY</code>. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p> Describes the type for the job. The job type <code>RELEASE</code> starts a new job
        /// with the latest change from the specified branch. This value is available only for apps
        /// that are connected to a repository. The job type <code>RETRY</code> retries an existing
        /// job. If the job type value is <code>RETRY</code>, the <code>jobId</code> is also
        /// required. </p>
        pub fn job_type(mut self, inp: crate::model::JobType) -> Self {
            self.inner = self.inner.job_type(inp);
            self
        }
        /// <p> Describes the type for the job. The job type <code>RELEASE</code> starts a new job
        /// with the latest change from the specified branch. This value is available only for apps
        /// that are connected to a repository. The job type <code>RETRY</code> retries an existing
        /// job. If the job type value is <code>RETRY</code>, the <code>jobId</code> is also
        /// required. </p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.inner = self.inner.set_job_type(input);
            self
        }
        /// <p> A descriptive reason for starting this job. </p>
        pub fn job_reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_reason(inp);
            self
        }
        /// <p> A descriptive reason for starting this job. </p>
        pub fn set_job_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_reason(input);
            self
        }
        /// <p> The commit ID from a third-party repository provider for the job. </p>
        pub fn commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_id(inp);
            self
        }
        /// <p> The commit ID from a third-party repository provider for the job. </p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_commit_id(input);
            self
        }
        /// <p> The commit message from a third-party repository provider for the job. </p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p> The commit message from a third-party repository provider for the job. </p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p> The commit date and time for the job. </p>
        pub fn commit_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.commit_time(inp);
            self
        }
        /// <p> The commit date and time for the job. </p>
        pub fn set_commit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_commit_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopJob`.
    ///
    /// <p> Stops a job that is in progress for a branch of an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct StopJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_job_input::Builder,
    }
    impl<C, M, R> StopJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopJobInputOperationOutputAlias,
                crate::output::StopJobOutput,
                crate::error::StopJobError,
                crate::input::StopJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique id for the job. </p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p> The unique id for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Tags the resource with a tag key and value. </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) to use to tag a resource. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) to use to tag a resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to tag the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p> The tags used to tag the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Untags a resource with a specified Amazon Resource Name (ARN). </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) to use to untag a resource. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) to use to untag a resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The tag keys to use to untag a resource. </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p> The tag keys to use to untag a resource. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApp`.
    ///
    /// <p> Updates an existing Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_app_input::Builder,
    }
    impl<C, M, R> UpdateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAppInputOperationOutputAlias,
                crate::output::UpdateAppOutput,
                crate::error::UpdateAppError,
                crate::input::UpdateAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for an Amplify app. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p> The name for an Amplify app. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The platform for an Amplify app. </p>
        pub fn platform(mut self, inp: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(inp);
            self
        }
        /// <p> The platform for an Amplify app. </p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn iam_service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_service_role_arn(inp);
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn set_iam_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iam_service_role_arn(input);
            self
        }
        /// Adds a key-value pair to `environmentVariables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for an Amplify app. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_variables(k, v);
            self
        }
        /// <p> The environment variables for an Amplify app. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment_variables(input);
            self
        }
        /// <p> Enables branch auto-building for an Amplify app. </p>
        pub fn enable_branch_auto_build(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_branch_auto_build(inp);
            self
        }
        /// <p> Enables branch auto-building for an Amplify app. </p>
        pub fn set_enable_branch_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_branch_auto_build(input);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch
        /// from your Git repository. </p>
        pub fn enable_branch_auto_deletion(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_branch_auto_deletion(inp);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch
        /// from your Git repository. </p>
        pub fn set_enable_branch_auto_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_branch_auto_deletion(input);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. </p>
        pub fn enable_basic_auth(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_basic_auth(inp);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_basic_auth(input);
            self
        }
        /// <p> The basic authorization credentials for an Amplify app. </p>
        pub fn basic_auth_credentials(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basic_auth_credentials(inp);
            self
        }
        /// <p> The basic authorization credentials for an Amplify app. </p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_basic_auth_credentials(input);
            self
        }
        /// Appends an item to `customRules`.
        ///
        /// To override the contents of this collection use [`set_custom_rules`](Self::set_custom_rules).
        ///
        /// <p> The custom redirect and rewrite rules for an Amplify app. </p>
        pub fn custom_rules(mut self, inp: impl Into<crate::model::CustomRule>) -> Self {
            self.inner = self.inner.custom_rules(inp);
            self
        }
        /// <p> The custom redirect and rewrite rules for an Amplify app. </p>
        pub fn set_custom_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        ) -> Self {
            self.inner = self.inner.set_custom_rules(input);
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn build_spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.build_spec(inp);
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_build_spec(input);
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn custom_headers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_headers(inp);
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn set_custom_headers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_headers(input);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn enable_auto_branch_creation(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_auto_branch_creation(inp);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn set_enable_auto_branch_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_branch_creation(input);
            self
        }
        /// Appends an item to `autoBranchCreationPatterns`.
        ///
        /// To override the contents of this collection use [`set_auto_branch_creation_patterns`](Self::set_auto_branch_creation_patterns).
        ///
        /// <p> Describes the automated branch creation glob patterns for an Amplify app. </p>
        pub fn auto_branch_creation_patterns(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_branch_creation_patterns(inp);
            self
        }
        /// <p> Describes the automated branch creation glob patterns for an Amplify app. </p>
        pub fn set_auto_branch_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_branch_creation_patterns(input);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn auto_branch_creation_config(
            mut self,
            inp: crate::model::AutoBranchCreationConfig,
        ) -> Self {
            self.inner = self.inner.auto_branch_creation_config(inp);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn set_auto_branch_creation_config(
            mut self,
            input: std::option::Option<crate::model::AutoBranchCreationConfig>,
        ) -> Self {
            self.inner = self.inner.set_auto_branch_creation_config(input);
            self
        }
        /// <p> The name of the repository for an Amplify app </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p> The name of the repository for an Amplify app </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The OAuth token for a third-party source control system for an Amplify app. The token
        /// is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        /// </p>
        pub fn oauth_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.oauth_token(inp);
            self
        }
        /// <p> The OAuth token for a third-party source control system for an Amplify app. The token
        /// is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        /// </p>
        pub fn set_oauth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_oauth_token(input);
            self
        }
        /// <p> The personal access token for a third-party source control system for an Amplify app.
        /// The token is used to create webhook and a read-only deploy key. The token is not stored.
        /// </p>
        pub fn access_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(inp);
            self
        }
        /// <p> The personal access token for a third-party source control system for an Amplify app.
        /// The token is used to create webhook and a read-only deploy key. The token is not stored.
        /// </p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBranch`.
    ///
    /// <p> Updates a branch for an Amplify app. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBranch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_branch_input::Builder,
    }
    impl<C, M, R> UpdateBranch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBranchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBranchInputOperationOutputAlias,
                crate::output::UpdateBranchOutput,
                crate::error::UpdateBranchError,
                crate::input::UpdateBranchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The description for the branch. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> The description for the branch. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn framework(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework(inp);
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn set_framework(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework(input);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn stage(mut self, inp: crate::model::Stage) -> Self {
            self.inner = self.inner.stage(inp);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::Stage>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn enable_notification(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_notification(inp);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn set_enable_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_notification(input);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn enable_auto_build(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_auto_build(inp);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn set_enable_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_build(input);
            self
        }
        /// Adds a key-value pair to `environmentVariables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for the branch. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_variables(k, v);
            self
        }
        /// <p> The environment variables for the branch. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment_variables(input);
            self
        }
        /// <p> The basic authorization credentials for the branch. </p>
        pub fn basic_auth_credentials(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basic_auth_credentials(inp);
            self
        }
        /// <p> The basic authorization credentials for the branch. </p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_basic_auth_credentials(input);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn enable_basic_auth(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_basic_auth(inp);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_basic_auth(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn enable_performance_mode(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_performance_mode(inp);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn set_enable_performance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_mode(input);
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn build_spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.build_spec(inp);
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_build_spec(input);
            self
        }
        /// <p> The content Time to Live (TTL) for the website in seconds. </p>
        pub fn ttl(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ttl(inp);
            self
        }
        /// <p> The content Time to Live (TTL) for the website in seconds. </p>
        pub fn set_ttl(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn enable_pull_request_preview(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_pull_request_preview(inp);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn set_enable_pull_request_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_pull_request_preview(input);
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn pull_request_environment_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.pull_request_environment_name(inp);
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn set_pull_request_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_environment_name(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn backend_environment_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn set_backend_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainAssociation`.
    ///
    /// <p> Creates a new domain association for an Amplify app.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDomainAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_association_input::Builder,
    }
    impl<C, M, R> UpdateDomainAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainAssociationInputOperationOutputAlias,
                crate::output::UpdateDomainAssociationOutput,
                crate::error::UpdateDomainAssociationError,
                crate::input::UpdateDomainAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn enable_auto_sub_domain(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_auto_sub_domain(inp);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn set_enable_auto_sub_domain(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_sub_domain(input);
            self
        }
        /// Appends an item to `subDomainSettings`.
        ///
        /// To override the contents of this collection use [`set_sub_domain_settings`](Self::set_sub_domain_settings).
        ///
        /// <p> Describes the settings for the subdomain. </p>
        pub fn sub_domain_settings(
            mut self,
            inp: impl Into<crate::model::SubDomainSetting>,
        ) -> Self {
            self.inner = self.inner.sub_domain_settings(inp);
            self
        }
        /// <p> Describes the settings for the subdomain. </p>
        pub fn set_sub_domain_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
        ) -> Self {
            self.inner = self.inner.set_sub_domain_settings(input);
            self
        }
        /// Appends an item to `autoSubDomainCreationPatterns`.
        ///
        /// To override the contents of this collection use [`set_auto_sub_domain_creation_patterns`](Self::set_auto_sub_domain_creation_patterns).
        ///
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn auto_sub_domain_creation_patterns(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_sub_domain_creation_patterns(inp);
            self
        }
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn set_auto_sub_domain_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_sub_domain_creation_patterns(input);
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon
        /// Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn auto_sub_domain_iam_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_sub_domain_iam_role(inp);
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon
        /// Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn set_auto_sub_domain_iam_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_sub_domain_iam_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWebhook`.
    ///
    /// <p> Updates a webhook. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateWebhook<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_webhook_input::Builder,
    }
    impl<C, M, R> UpdateWebhook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWebhookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWebhookInputOperationOutputAlias,
                crate::output::UpdateWebhookOutput,
                crate::error::UpdateWebhookError,
                crate::input::UpdateWebhookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn webhook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.webhook_id(inp);
            self
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_webhook_id(input);
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
