// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Amplify
///
/// Client for invoking operations on AWS Amplify. Each operation on AWS Amplify is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_amplify::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_amplify::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_amplify::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateApp`](crate::client::fluent_builders::CreateApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApp::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApp::set_name): <p> The name for an Amplify app. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApp::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApp::set_description): <p> The description for an Amplify app. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::CreateApp::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::CreateApp::set_repository): <p> The repository for an Amplify app. </p>
    ///   - [`platform(Platform)`](crate::client::fluent_builders::CreateApp::platform) / [`set_platform(Option<Platform>)`](crate::client::fluent_builders::CreateApp::set_platform): <p> The platform or framework for an Amplify app. </p>
    ///   - [`iam_service_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateApp::iam_service_role_arn) / [`set_iam_service_role_arn(Option<String>)`](crate::client::fluent_builders::CreateApp::set_iam_service_role_arn): <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
    ///   - [`oauth_token(impl Into<String>)`](crate::client::fluent_builders::CreateApp::oauth_token) / [`set_oauth_token(Option<String>)`](crate::client::fluent_builders::CreateApp::set_oauth_token): <p>The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.</p>  <p>Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use <code>accessToken</code>.</p>  <p>You must specify either <code>oauthToken</code> or <code>accessToken</code> when you create a new app.</p>  <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::CreateApp::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::CreateApp::set_access_token): <p>The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.</p>  <p>Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use <code>oauthToken</code>.</p>  <p>You must specify either <code>accessToken</code> or <code>oauthToken</code> when you create a new app.</p>  <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
    ///   - [`environment_variables(HashMap<String, String>)`](crate::client::fluent_builders::CreateApp::environment_variables) / [`set_environment_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateApp::set_environment_variables): <p> The environment variables map for an Amplify app. </p>
    ///   - [`enable_branch_auto_build(bool)`](crate::client::fluent_builders::CreateApp::enable_branch_auto_build) / [`set_enable_branch_auto_build(Option<bool>)`](crate::client::fluent_builders::CreateApp::set_enable_branch_auto_build): <p> Enables the auto building of branches for an Amplify app. </p>
    ///   - [`enable_branch_auto_deletion(bool)`](crate::client::fluent_builders::CreateApp::enable_branch_auto_deletion) / [`set_enable_branch_auto_deletion(Option<bool>)`](crate::client::fluent_builders::CreateApp::set_enable_branch_auto_deletion): <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
    ///   - [`enable_basic_auth(bool)`](crate::client::fluent_builders::CreateApp::enable_basic_auth) / [`set_enable_basic_auth(Option<bool>)`](crate::client::fluent_builders::CreateApp::set_enable_basic_auth): <p> Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app. </p>
    ///   - [`basic_auth_credentials(impl Into<String>)`](crate::client::fluent_builders::CreateApp::basic_auth_credentials) / [`set_basic_auth_credentials(Option<String>)`](crate::client::fluent_builders::CreateApp::set_basic_auth_credentials): <p> The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    ///   - [`custom_rules(Vec<CustomRule>)`](crate::client::fluent_builders::CreateApp::custom_rules) / [`set_custom_rules(Option<Vec<CustomRule>>)`](crate::client::fluent_builders::CreateApp::set_custom_rules): <p> The custom rewrite and redirect rules for an Amplify app. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateApp::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateApp::set_tags): <p> The tag for an Amplify app. </p>
    ///   - [`build_spec(impl Into<String>)`](crate::client::fluent_builders::CreateApp::build_spec) / [`set_build_spec(Option<String>)`](crate::client::fluent_builders::CreateApp::set_build_spec): <p> The build specification (build spec) for an Amplify app. </p>
    ///   - [`custom_headers(impl Into<String>)`](crate::client::fluent_builders::CreateApp::custom_headers) / [`set_custom_headers(Option<String>)`](crate::client::fluent_builders::CreateApp::set_custom_headers): <p>The custom HTTP headers for an Amplify app.</p>
    ///   - [`enable_auto_branch_creation(bool)`](crate::client::fluent_builders::CreateApp::enable_auto_branch_creation) / [`set_enable_auto_branch_creation(Option<bool>)`](crate::client::fluent_builders::CreateApp::set_enable_auto_branch_creation): <p> Enables automated branch creation for an Amplify app. </p>
    ///   - [`auto_branch_creation_patterns(Vec<String>)`](crate::client::fluent_builders::CreateApp::auto_branch_creation_patterns) / [`set_auto_branch_creation_patterns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateApp::set_auto_branch_creation_patterns): <p> The automated branch creation glob patterns for an Amplify app. </p>
    ///   - [`auto_branch_creation_config(AutoBranchCreationConfig)`](crate::client::fluent_builders::CreateApp::auto_branch_creation_config) / [`set_auto_branch_creation_config(Option<AutoBranchCreationConfig>)`](crate::client::fluent_builders::CreateApp::set_auto_branch_creation_config): <p> The automated branch creation configuration for an Amplify app. </p>
    /// - On success, responds with [`CreateAppOutput`](crate::output::CreateAppOutput) with field(s):
    ///   - [`app(Option<App>)`](crate::output::CreateAppOutput::app): <p> Represents the different branches of a repository for building, deploying, and hosting an Amplify app. </p>
    /// - On failure, responds with [`SdkError<CreateAppError>`](crate::error::CreateAppError)
    pub fn create_app(&self) -> fluent_builders::CreateApp {
        fluent_builders::CreateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBackendEnvironment`](crate::client::fluent_builders::CreateBackendEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::CreateBackendEnvironment::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::CreateBackendEnvironment::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::CreateBackendEnvironment::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::CreateBackendEnvironment::set_environment_name): <p> The name for the backend environment. </p>
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::CreateBackendEnvironment::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::CreateBackendEnvironment::set_stack_name): <p> The AWS CloudFormation stack name of a backend environment. </p>
    ///   - [`deployment_artifacts(impl Into<String>)`](crate::client::fluent_builders::CreateBackendEnvironment::deployment_artifacts) / [`set_deployment_artifacts(Option<String>)`](crate::client::fluent_builders::CreateBackendEnvironment::set_deployment_artifacts): <p> The name of deployment artifacts. </p>
    /// - On success, responds with [`CreateBackendEnvironmentOutput`](crate::output::CreateBackendEnvironmentOutput) with field(s):
    ///   - [`backend_environment(Option<BackendEnvironment>)`](crate::output::CreateBackendEnvironmentOutput::backend_environment): <p> Describes the backend environment for an Amplify app. </p>
    /// - On failure, responds with [`SdkError<CreateBackendEnvironmentError>`](crate::error::CreateBackendEnvironmentError)
    pub fn create_backend_environment(&self) -> fluent_builders::CreateBackendEnvironment {
        fluent_builders::CreateBackendEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBranch`](crate::client::fluent_builders::CreateBranch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_branch_name): <p> The name for the branch. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_description): <p> The description for the branch. </p>
    ///   - [`stage(Stage)`](crate::client::fluent_builders::CreateBranch::stage) / [`set_stage(Option<Stage>)`](crate::client::fluent_builders::CreateBranch::set_stage): <p> Describes the current stage for the branch. </p>
    ///   - [`framework(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::framework) / [`set_framework(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_framework): <p> The framework for the branch. </p>
    ///   - [`enable_notification(bool)`](crate::client::fluent_builders::CreateBranch::enable_notification) / [`set_enable_notification(Option<bool>)`](crate::client::fluent_builders::CreateBranch::set_enable_notification): <p> Enables notifications for the branch. </p>
    ///   - [`enable_auto_build(bool)`](crate::client::fluent_builders::CreateBranch::enable_auto_build) / [`set_enable_auto_build(Option<bool>)`](crate::client::fluent_builders::CreateBranch::set_enable_auto_build): <p> Enables auto building for the branch. </p>
    ///   - [`environment_variables(HashMap<String, String>)`](crate::client::fluent_builders::CreateBranch::environment_variables) / [`set_environment_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateBranch::set_environment_variables): <p> The environment variables for the branch. </p>
    ///   - [`basic_auth_credentials(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::basic_auth_credentials) / [`set_basic_auth_credentials(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_basic_auth_credentials): <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    ///   - [`enable_basic_auth(bool)`](crate::client::fluent_builders::CreateBranch::enable_basic_auth) / [`set_enable_basic_auth(Option<bool>)`](crate::client::fluent_builders::CreateBranch::set_enable_basic_auth): <p> Enables basic authorization for the branch. </p>
    ///   - [`enable_performance_mode(bool)`](crate::client::fluent_builders::CreateBranch::enable_performance_mode) / [`set_enable_performance_mode(Option<bool>)`](crate::client::fluent_builders::CreateBranch::set_enable_performance_mode): <p>Enables performance mode for the branch.</p>  <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateBranch::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateBranch::set_tags): <p> The tag for the branch. </p>
    ///   - [`build_spec(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::build_spec) / [`set_build_spec(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_build_spec): <p> The build specification (build spec) for the branch. </p>
    ///   - [`ttl(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::ttl) / [`set_ttl(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_ttl): <p> The content Time To Live (TTL) for the website in seconds. </p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_display_name): <p> The display name for a branch. This is used as the default domain prefix. </p>
    ///   - [`enable_pull_request_preview(bool)`](crate::client::fluent_builders::CreateBranch::enable_pull_request_preview) / [`set_enable_pull_request_preview(Option<bool>)`](crate::client::fluent_builders::CreateBranch::set_enable_pull_request_preview): <p> Enables pull request previews for this branch. </p>
    ///   - [`pull_request_environment_name(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::pull_request_environment_name) / [`set_pull_request_environment_name(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_pull_request_environment_name): <p> The Amplify environment name for the pull request. </p>
    ///   - [`backend_environment_arn(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::backend_environment_arn) / [`set_backend_environment_arn(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_backend_environment_arn): <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
    /// - On success, responds with [`CreateBranchOutput`](crate::output::CreateBranchOutput) with field(s):
    ///   - [`branch(Option<Branch>)`](crate::output::CreateBranchOutput::branch): <p> Describes the branch for an Amplify app, which maps to a third-party repository branch. </p>
    /// - On failure, responds with [`SdkError<CreateBranchError>`](crate::error::CreateBranchError)
    pub fn create_branch(&self) -> fluent_builders::CreateBranch {
        fluent_builders::CreateBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_branch_name): <p> The name for the branch, for the job. </p>
    ///   - [`file_map(HashMap<String, String>)`](crate::client::fluent_builders::CreateDeployment::file_map) / [`set_file_map(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDeployment::set_file_map): <p> An optional file map that contains the file name as the key and the file content md5 hash as the value. If this argument is provided, the service will generate a unique upload URL per file. Otherwise, the service will only generate a single upload URL for the zipped files. </p>
    /// - On success, responds with [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::CreateDeploymentOutput::job_id): <p> The job ID for this deployment. will supply to start deployment api. </p>
    ///   - [`file_upload_urls(Option<HashMap<String, String>>)`](crate::output::CreateDeploymentOutput::file_upload_urls): <p> When the <code>fileMap</code> argument is provided in the request, <code>fileUploadUrls</code> will contain a map of file names to upload URLs. </p>
    ///   - [`zip_upload_url(Option<String>)`](crate::output::CreateDeploymentOutput::zip_upload_url): <p> When the <code>fileMap</code> argument is not provided in the request, this <code>zipUploadUrl</code> is returned. </p>
    /// - On failure, responds with [`SdkError<CreateDeploymentError>`](crate::error::CreateDeploymentError)
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDomainAssociation`](crate::client::fluent_builders::CreateDomainAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::CreateDomainAssociation::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::CreateDomainAssociation::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomainAssociation::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateDomainAssociation::set_domain_name): <p> The domain name for the domain association. </p>
    ///   - [`enable_auto_sub_domain(bool)`](crate::client::fluent_builders::CreateDomainAssociation::enable_auto_sub_domain) / [`set_enable_auto_sub_domain(Option<bool>)`](crate::client::fluent_builders::CreateDomainAssociation::set_enable_auto_sub_domain): <p> Enables the automated creation of subdomains for branches. </p>
    ///   - [`sub_domain_settings(Vec<SubDomainSetting>)`](crate::client::fluent_builders::CreateDomainAssociation::sub_domain_settings) / [`set_sub_domain_settings(Option<Vec<SubDomainSetting>>)`](crate::client::fluent_builders::CreateDomainAssociation::set_sub_domain_settings): <p> The setting for the subdomain. </p>
    ///   - [`auto_sub_domain_creation_patterns(Vec<String>)`](crate::client::fluent_builders::CreateDomainAssociation::auto_sub_domain_creation_patterns) / [`set_auto_sub_domain_creation_patterns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDomainAssociation::set_auto_sub_domain_creation_patterns): <p> Sets the branch patterns for automatic subdomain creation. </p>
    ///   - [`auto_sub_domain_iam_role(impl Into<String>)`](crate::client::fluent_builders::CreateDomainAssociation::auto_sub_domain_iam_role) / [`set_auto_sub_domain_iam_role(Option<String>)`](crate::client::fluent_builders::CreateDomainAssociation::set_auto_sub_domain_iam_role): <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
    /// - On success, responds with [`CreateDomainAssociationOutput`](crate::output::CreateDomainAssociationOutput) with field(s):
    ///   - [`domain_association(Option<DomainAssociation>)`](crate::output::CreateDomainAssociationOutput::domain_association): <p> Describes the structure of a domain association, which associates a custom domain with an Amplify app. </p>
    /// - On failure, responds with [`SdkError<CreateDomainAssociationError>`](crate::error::CreateDomainAssociationError)
    pub fn create_domain_association(&self) -> fluent_builders::CreateDomainAssociation {
        fluent_builders::CreateDomainAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWebhook`](crate::client::fluent_builders::CreateWebhook) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::CreateWebhook::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::CreateWebhook::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::CreateWebhook::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::CreateWebhook::set_branch_name): <p> The name for a branch that is part of an Amplify app. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateWebhook::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateWebhook::set_description): <p> The description for a webhook. </p>
    /// - On success, responds with [`CreateWebhookOutput`](crate::output::CreateWebhookOutput) with field(s):
    ///   - [`webhook(Option<Webhook>)`](crate::output::CreateWebhookOutput::webhook): <p> Describes a webhook that connects repository events to an Amplify app. </p>
    /// - On failure, responds with [`SdkError<CreateWebhookError>`](crate::error::CreateWebhookError)
    pub fn create_webhook(&self) -> fluent_builders::CreateWebhook {
        fluent_builders::CreateWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApp`](crate::client::fluent_builders::DeleteApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApp::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::DeleteApp::set_app_id): <p> The unique ID for an Amplify app. </p>
    /// - On success, responds with [`DeleteAppOutput`](crate::output::DeleteAppOutput) with field(s):
    ///   - [`app(Option<App>)`](crate::output::DeleteAppOutput::app): <p> Represents the different branches of a repository for building, deploying, and hosting an Amplify app. </p>
    /// - On failure, responds with [`SdkError<DeleteAppError>`](crate::error::DeleteAppError)
    pub fn delete_app(&self) -> fluent_builders::DeleteApp {
        fluent_builders::DeleteApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBackendEnvironment`](crate::client::fluent_builders::DeleteBackendEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBackendEnvironment::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::DeleteBackendEnvironment::set_app_id): <p> The unique ID of an Amplify app. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBackendEnvironment::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DeleteBackendEnvironment::set_environment_name): <p> The name of a backend environment of an Amplify app. </p>
    /// - On success, responds with [`DeleteBackendEnvironmentOutput`](crate::output::DeleteBackendEnvironmentOutput) with field(s):
    ///   - [`backend_environment(Option<BackendEnvironment>)`](crate::output::DeleteBackendEnvironmentOutput::backend_environment): <p> Describes the backend environment for an Amplify app. </p>
    /// - On failure, responds with [`SdkError<DeleteBackendEnvironmentError>`](crate::error::DeleteBackendEnvironmentError)
    pub fn delete_backend_environment(&self) -> fluent_builders::DeleteBackendEnvironment {
        fluent_builders::DeleteBackendEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBranch`](crate::client::fluent_builders::DeleteBranch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBranch::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::DeleteBranch::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBranch::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::DeleteBranch::set_branch_name): <p> The name for the branch. </p>
    /// - On success, responds with [`DeleteBranchOutput`](crate::output::DeleteBranchOutput) with field(s):
    ///   - [`branch(Option<Branch>)`](crate::output::DeleteBranchOutput::branch): <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
    /// - On failure, responds with [`SdkError<DeleteBranchError>`](crate::error::DeleteBranchError)
    pub fn delete_branch(&self) -> fluent_builders::DeleteBranch {
        fluent_builders::DeleteBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomainAssociation`](crate::client::fluent_builders::DeleteDomainAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDomainAssociation::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::DeleteDomainAssociation::set_app_id): <p> The unique id for an Amplify app. </p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDomainAssociation::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteDomainAssociation::set_domain_name): <p> The name of the domain. </p>
    /// - On success, responds with [`DeleteDomainAssociationOutput`](crate::output::DeleteDomainAssociationOutput) with field(s):
    ///   - [`domain_association(Option<DomainAssociation>)`](crate::output::DeleteDomainAssociationOutput::domain_association): <p> Describes a domain association that associates a custom domain with an Amplify app. </p>
    /// - On failure, responds with [`SdkError<DeleteDomainAssociationError>`](crate::error::DeleteDomainAssociationError)
    pub fn delete_domain_association(&self) -> fluent_builders::DeleteDomainAssociation {
        fluent_builders::DeleteDomainAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteJob`](crate::client::fluent_builders::DeleteJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJob::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::DeleteJob::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::DeleteJob::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::DeleteJob::set_branch_name): <p> The name for the branch, for the job. </p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DeleteJob::set_job_id): <p> The unique ID for the job. </p>
    /// - On success, responds with [`DeleteJobOutput`](crate::output::DeleteJobOutput) with field(s):
    ///   - [`job_summary(Option<JobSummary>)`](crate::output::DeleteJobOutput::job_summary): <p> Describes the summary for an execution job for an Amplify app. </p>
    /// - On failure, responds with [`SdkError<DeleteJobError>`](crate::error::DeleteJobError)
    pub fn delete_job(&self) -> fluent_builders::DeleteJob {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWebhook`](crate::client::fluent_builders::DeleteWebhook) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`webhook_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWebhook::webhook_id) / [`set_webhook_id(Option<String>)`](crate::client::fluent_builders::DeleteWebhook::set_webhook_id): <p> The unique ID for a webhook. </p>
    /// - On success, responds with [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput) with field(s):
    ///   - [`webhook(Option<Webhook>)`](crate::output::DeleteWebhookOutput::webhook): <p> Describes a webhook that connects repository events to an Amplify app. </p>
    /// - On failure, responds with [`SdkError<DeleteWebhookError>`](crate::error::DeleteWebhookError)
    pub fn delete_webhook(&self) -> fluent_builders::DeleteWebhook {
        fluent_builders::DeleteWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateAccessLogs`](crate::client::fluent_builders::GenerateAccessLogs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GenerateAccessLogs::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GenerateAccessLogs::set_start_time): <p> The time at which the logs should start. The time range specified is inclusive of the start time. </p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GenerateAccessLogs::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GenerateAccessLogs::set_end_time): <p> The time at which the logs should end. The time range specified is inclusive of the end time. </p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GenerateAccessLogs::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GenerateAccessLogs::set_domain_name): <p> The name of the domain. </p>
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::GenerateAccessLogs::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::GenerateAccessLogs::set_app_id): <p> The unique ID for an Amplify app. </p>
    /// - On success, responds with [`GenerateAccessLogsOutput`](crate::output::GenerateAccessLogsOutput) with field(s):
    ///   - [`log_url(Option<String>)`](crate::output::GenerateAccessLogsOutput::log_url): <p> The pre-signed URL for the requested access logs. </p>
    /// - On failure, responds with [`SdkError<GenerateAccessLogsError>`](crate::error::GenerateAccessLogsError)
    pub fn generate_access_logs(&self) -> fluent_builders::GenerateAccessLogs {
        fluent_builders::GenerateAccessLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApp`](crate::client::fluent_builders::GetApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::GetApp::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::GetApp::set_app_id): <p> The unique ID for an Amplify app. </p>
    /// - On success, responds with [`GetAppOutput`](crate::output::GetAppOutput) with field(s):
    ///   - [`app(Option<App>)`](crate::output::GetAppOutput::app): <p> Represents the different branches of a repository for building, deploying, and hosting an Amplify app. </p>
    /// - On failure, responds with [`SdkError<GetAppError>`](crate::error::GetAppError)
    pub fn get_app(&self) -> fluent_builders::GetApp {
        fluent_builders::GetApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetArtifactUrl`](crate::client::fluent_builders::GetArtifactUrl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`artifact_id(impl Into<String>)`](crate::client::fluent_builders::GetArtifactUrl::artifact_id) / [`set_artifact_id(Option<String>)`](crate::client::fluent_builders::GetArtifactUrl::set_artifact_id): <p> The unique ID for an artifact. </p>
    /// - On success, responds with [`GetArtifactUrlOutput`](crate::output::GetArtifactUrlOutput) with field(s):
    ///   - [`artifact_id(Option<String>)`](crate::output::GetArtifactUrlOutput::artifact_id): <p> The unique ID for an artifact. </p>
    ///   - [`artifact_url(Option<String>)`](crate::output::GetArtifactUrlOutput::artifact_url): <p> The presigned URL for the artifact. </p>
    /// - On failure, responds with [`SdkError<GetArtifactUrlError>`](crate::error::GetArtifactUrlError)
    pub fn get_artifact_url(&self) -> fluent_builders::GetArtifactUrl {
        fluent_builders::GetArtifactUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBackendEnvironment`](crate::client::fluent_builders::GetBackendEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::GetBackendEnvironment::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::GetBackendEnvironment::set_app_id): <p> The unique id for an Amplify app. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::GetBackendEnvironment::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::GetBackendEnvironment::set_environment_name): <p> The name for the backend environment. </p>
    /// - On success, responds with [`GetBackendEnvironmentOutput`](crate::output::GetBackendEnvironmentOutput) with field(s):
    ///   - [`backend_environment(Option<BackendEnvironment>)`](crate::output::GetBackendEnvironmentOutput::backend_environment): <p> Describes the backend environment for an Amplify app. </p>
    /// - On failure, responds with [`SdkError<GetBackendEnvironmentError>`](crate::error::GetBackendEnvironmentError)
    pub fn get_backend_environment(&self) -> fluent_builders::GetBackendEnvironment {
        fluent_builders::GetBackendEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBranch`](crate::client::fluent_builders::GetBranch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::GetBranch::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::GetBranch::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::GetBranch::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::GetBranch::set_branch_name): <p> The name for the branch. </p>
    /// - On success, responds with [`GetBranchOutput`](crate::output::GetBranchOutput) with field(s):
    ///   - [`branch(Option<Branch>)`](crate::output::GetBranchOutput::branch): <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
    /// - On failure, responds with [`SdkError<GetBranchError>`](crate::error::GetBranchError)
    pub fn get_branch(&self) -> fluent_builders::GetBranch {
        fluent_builders::GetBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainAssociation`](crate::client::fluent_builders::GetDomainAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::GetDomainAssociation::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::GetDomainAssociation::set_app_id): <p> The unique id for an Amplify app. </p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetDomainAssociation::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetDomainAssociation::set_domain_name): <p> The name of the domain. </p>
    /// - On success, responds with [`GetDomainAssociationOutput`](crate::output::GetDomainAssociationOutput) with field(s):
    ///   - [`domain_association(Option<DomainAssociation>)`](crate::output::GetDomainAssociationOutput::domain_association): <p> Describes the structure of a domain association, which associates a custom domain with an Amplify app. </p>
    /// - On failure, responds with [`SdkError<GetDomainAssociationError>`](crate::error::GetDomainAssociationError)
    pub fn get_domain_association(&self) -> fluent_builders::GetDomainAssociation {
        fluent_builders::GetDomainAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJob`](crate::client::fluent_builders::GetJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::GetJob::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::GetJob::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::GetJob::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::GetJob::set_branch_name): <p> The branch name for the job. </p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetJob::set_job_id): <p> The unique ID for the job. </p>
    /// - On success, responds with [`GetJobOutput`](crate::output::GetJobOutput) with field(s):
    ///   - [`job(Option<Job>)`](crate::output::GetJobOutput::job): <p> Describes an execution job for an Amplify app. </p>
    /// - On failure, responds with [`SdkError<GetJobError>`](crate::error::GetJobError)
    pub fn get_job(&self) -> fluent_builders::GetJob {
        fluent_builders::GetJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWebhook`](crate::client::fluent_builders::GetWebhook) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`webhook_id(impl Into<String>)`](crate::client::fluent_builders::GetWebhook::webhook_id) / [`set_webhook_id(Option<String>)`](crate::client::fluent_builders::GetWebhook::set_webhook_id): <p> The unique ID for a webhook. </p>
    /// - On success, responds with [`GetWebhookOutput`](crate::output::GetWebhookOutput) with field(s):
    ///   - [`webhook(Option<Webhook>)`](crate::output::GetWebhookOutput::webhook): <p> Describes the structure of a webhook. </p>
    /// - On failure, responds with [`SdkError<GetWebhookError>`](crate::error::GetWebhookError)
    pub fn get_webhook(&self) -> fluent_builders::GetWebhook {
        fluent_builders::GetWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApps`](crate::client::fluent_builders::ListApps) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApps::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApps::set_next_token): <p> A pagination token. If non-null, the pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApps::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListApps::set_max_results): <p> The maximum number of records to list in a single response. </p>
    /// - On success, responds with [`ListAppsOutput`](crate::output::ListAppsOutput) with field(s):
    ///   - [`apps(Option<Vec<App>>)`](crate::output::ListAppsOutput::apps): <p> A list of Amplify apps. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppsOutput::next_token): <p> A pagination token. Set to null to start listing apps from start. If non-null, the pagination token is returned in a result. Pass its value in here to list more projects. </p>
    /// - On failure, responds with [`SdkError<ListAppsError>`](crate::error::ListAppsError)
    pub fn list_apps(&self) -> fluent_builders::ListApps {
        fluent_builders::ListApps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListArtifacts`](crate::client::fluent_builders::ListArtifacts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ListArtifacts::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ListArtifacts::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::ListArtifacts::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::ListArtifacts::set_branch_name): <p> The name of a branch that is part of an Amplify app. </p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::ListArtifacts::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::ListArtifacts::set_job_id): <p> The unique ID for a job. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListArtifacts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListArtifacts::set_next_token): <p> A pagination token. Set to null to start listing artifacts from start. If a non-null pagination token is returned in a result, pass its value in here to list more artifacts. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListArtifacts::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListArtifacts::set_max_results): <p> The maximum number of records to list in a single response. </p>
    /// - On success, responds with [`ListArtifactsOutput`](crate::output::ListArtifactsOutput) with field(s):
    ///   - [`artifacts(Option<Vec<Artifact>>)`](crate::output::ListArtifactsOutput::artifacts): <p> A list of artifacts. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListArtifactsOutput::next_token): <p> A pagination token. If a non-null pagination token is returned in a result, pass its value in another request to retrieve more entries. </p>
    /// - On failure, responds with [`SdkError<ListArtifactsError>`](crate::error::ListArtifactsError)
    pub fn list_artifacts(&self) -> fluent_builders::ListArtifacts {
        fluent_builders::ListArtifacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBackendEnvironments`](crate::client::fluent_builders::ListBackendEnvironments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ListBackendEnvironments::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ListBackendEnvironments::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::ListBackendEnvironments::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::ListBackendEnvironments::set_environment_name): <p> The name of the backend environment </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBackendEnvironments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBackendEnvironments::set_next_token): <p> A pagination token. Set to null to start listing backend environments from the start. If a non-null pagination token is returned in a result, pass its value in here to list more backend environments. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBackendEnvironments::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListBackendEnvironments::set_max_results): <p> The maximum number of records to list in a single response. </p>
    /// - On success, responds with [`ListBackendEnvironmentsOutput`](crate::output::ListBackendEnvironmentsOutput) with field(s):
    ///   - [`backend_environments(Option<Vec<BackendEnvironment>>)`](crate::output::ListBackendEnvironmentsOutput::backend_environments): <p> The list of backend environments for an Amplify app. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBackendEnvironmentsOutput::next_token): <p> A pagination token. If a non-null pagination token is returned in a result, pass its value in another request to retrieve more entries. </p>
    /// - On failure, responds with [`SdkError<ListBackendEnvironmentsError>`](crate::error::ListBackendEnvironmentsError)
    pub fn list_backend_environments(&self) -> fluent_builders::ListBackendEnvironments {
        fluent_builders::ListBackendEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBranches`](crate::client::fluent_builders::ListBranches) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ListBranches::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ListBranches::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBranches::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBranches::set_next_token): <p> A pagination token. Set to null to start listing branches from the start. If a non-null pagination token is returned in a result, pass its value in here to list more branches. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBranches::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListBranches::set_max_results): <p> The maximum number of records to list in a single response. </p>
    /// - On success, responds with [`ListBranchesOutput`](crate::output::ListBranchesOutput) with field(s):
    ///   - [`branches(Option<Vec<Branch>>)`](crate::output::ListBranchesOutput::branches): <p> A list of branches for an Amplify app. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBranchesOutput::next_token): <p> A pagination token. If a non-null pagination token is returned in a result, pass its value in another request to retrieve more entries. </p>
    /// - On failure, responds with [`SdkError<ListBranchesError>`](crate::error::ListBranchesError)
    pub fn list_branches(&self) -> fluent_builders::ListBranches {
        fluent_builders::ListBranches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomainAssociations`](crate::client::fluent_builders::ListDomainAssociations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ListDomainAssociations::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ListDomainAssociations::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomainAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomainAssociations::set_next_token): <p> A pagination token. Set to null to start listing apps from the start. If non-null, a pagination token is returned in a result. Pass its value in here to list more projects. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDomainAssociations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDomainAssociations::set_max_results): <p> The maximum number of records to list in a single response. </p>
    /// - On success, responds with [`ListDomainAssociationsOutput`](crate::output::ListDomainAssociationsOutput) with field(s):
    ///   - [`domain_associations(Option<Vec<DomainAssociation>>)`](crate::output::ListDomainAssociationsOutput::domain_associations): <p> A list of domain associations. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainAssociationsOutput::next_token): <p> A pagination token. If non-null, a pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
    /// - On failure, responds with [`SdkError<ListDomainAssociationsError>`](crate::error::ListDomainAssociationsError)
    pub fn list_domain_associations(&self) -> fluent_builders::ListDomainAssociations {
        fluent_builders::ListDomainAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobs`](crate::client::fluent_builders::ListJobs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ListJobs::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ListJobs::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::ListJobs::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::ListJobs::set_branch_name): <p> The name for a branch. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobs::set_next_token): <p> A pagination token. Set to null to start listing steps from the start. If a non-null pagination token is returned in a result, pass its value in here to list more steps. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobs::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListJobs::set_max_results): <p> The maximum number of records to list in a single response. </p>
    /// - On success, responds with [`ListJobsOutput`](crate::output::ListJobsOutput) with field(s):
    ///   - [`job_summaries(Option<Vec<JobSummary>>)`](crate::output::ListJobsOutput::job_summaries): <p> The result structure for the list job result request. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobsOutput::next_token): <p> A pagination token. If non-null the pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
    /// - On failure, responds with [`SdkError<ListJobsError>`](crate::error::ListJobsError)
    pub fn list_jobs(&self) -> fluent_builders::ListJobs {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p> The Amazon Resource Name (ARN) to use to list tags. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p> A list of tags for the specified The Amazon Resource Name (ARN). </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWebhooks`](crate::client::fluent_builders::ListWebhooks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::ListWebhooks::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::ListWebhooks::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWebhooks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWebhooks::set_next_token): <p> A pagination token. Set to null to start listing webhooks from the start. If non-null,the pagination token is returned in a result. Pass its value in here to list more webhooks. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWebhooks::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListWebhooks::set_max_results): <p> The maximum number of records to list in a single response. </p>
    /// - On success, responds with [`ListWebhooksOutput`](crate::output::ListWebhooksOutput) with field(s):
    ///   - [`webhooks(Option<Vec<Webhook>>)`](crate::output::ListWebhooksOutput::webhooks): <p> A list of webhooks. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListWebhooksOutput::next_token): <p> A pagination token. If non-null, the pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
    /// - On failure, responds with [`SdkError<ListWebhooksError>`](crate::error::ListWebhooksError)
    pub fn list_webhooks(&self) -> fluent_builders::ListWebhooks {
        fluent_builders::ListWebhooks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDeployment`](crate::client::fluent_builders::StartDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_branch_name): <p> The name for the branch, for the job. </p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_job_id): <p> The job ID for this deployment, generated by the create deployment request. </p>
    ///   - [`source_url(impl Into<String>)`](crate::client::fluent_builders::StartDeployment::source_url) / [`set_source_url(Option<String>)`](crate::client::fluent_builders::StartDeployment::set_source_url): <p> The source URL for this deployment, used when calling start deployment without create deployment. The source URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file. </p>
    /// - On success, responds with [`StartDeploymentOutput`](crate::output::StartDeploymentOutput) with field(s):
    ///   - [`job_summary(Option<JobSummary>)`](crate::output::StartDeploymentOutput::job_summary): <p> The summary for the job. </p>
    /// - On failure, responds with [`SdkError<StartDeploymentError>`](crate::error::StartDeploymentError)
    pub fn start_deployment(&self) -> fluent_builders::StartDeployment {
        fluent_builders::StartDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartJob`](crate::client::fluent_builders::StartJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::StartJob::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::StartJob::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::StartJob::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::StartJob::set_branch_name): <p> The branch name for the job. </p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StartJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StartJob::set_job_id): <p> The unique ID for an existing job. This is required if the value of <code>jobType</code> is <code>RETRY</code>. </p>
    ///   - [`job_type(JobType)`](crate::client::fluent_builders::StartJob::job_type) / [`set_job_type(Option<JobType>)`](crate::client::fluent_builders::StartJob::set_job_type): <p> Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the <code>jobId</code> is also required. </p>
    ///   - [`job_reason(impl Into<String>)`](crate::client::fluent_builders::StartJob::job_reason) / [`set_job_reason(Option<String>)`](crate::client::fluent_builders::StartJob::set_job_reason): <p> A descriptive reason for starting this job. </p>
    ///   - [`commit_id(impl Into<String>)`](crate::client::fluent_builders::StartJob::commit_id) / [`set_commit_id(Option<String>)`](crate::client::fluent_builders::StartJob::set_commit_id): <p> The commit ID from a third-party repository provider for the job. </p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::StartJob::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::StartJob::set_commit_message): <p> The commit message from a third-party repository provider for the job. </p>
    ///   - [`commit_time(DateTime)`](crate::client::fluent_builders::StartJob::commit_time) / [`set_commit_time(Option<DateTime>)`](crate::client::fluent_builders::StartJob::set_commit_time): <p> The commit date and time for the job. </p>
    /// - On success, responds with [`StartJobOutput`](crate::output::StartJobOutput) with field(s):
    ///   - [`job_summary(Option<JobSummary>)`](crate::output::StartJobOutput::job_summary): <p> The summary for the job. </p>
    /// - On failure, responds with [`SdkError<StartJobError>`](crate::error::StartJobError)
    pub fn start_job(&self) -> fluent_builders::StartJob {
        fluent_builders::StartJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopJob`](crate::client::fluent_builders::StopJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::StopJob::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::StopJob::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::StopJob::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::StopJob::set_branch_name): <p> The name for the branch, for the job. </p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StopJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StopJob::set_job_id): <p> The unique id for the job. </p>
    /// - On success, responds with [`StopJobOutput`](crate::output::StopJobOutput) with field(s):
    ///   - [`job_summary(Option<JobSummary>)`](crate::output::StopJobOutput::job_summary): <p> The summary for the job. </p>
    /// - On failure, responds with [`SdkError<StopJobError>`](crate::error::StopJobError)
    pub fn stop_job(&self) -> fluent_builders::StopJob {
        fluent_builders::StopJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) to use to tag a resource. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p> The tags used to tag the resource. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) to use to untag a resource. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p> The tag keys to use to untag a resource. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApp`](crate::client::fluent_builders::UpdateApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_name): <p> The name for an Amplify app. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_description): <p> The description for an Amplify app. </p>
    ///   - [`platform(Platform)`](crate::client::fluent_builders::UpdateApp::platform) / [`set_platform(Option<Platform>)`](crate::client::fluent_builders::UpdateApp::set_platform): <p> The platform for an Amplify app. </p>
    ///   - [`iam_service_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::iam_service_role_arn) / [`set_iam_service_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_iam_service_role_arn): <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
    ///   - [`environment_variables(HashMap<String, String>)`](crate::client::fluent_builders::UpdateApp::environment_variables) / [`set_environment_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateApp::set_environment_variables): <p> The environment variables for an Amplify app. </p>
    ///   - [`enable_branch_auto_build(bool)`](crate::client::fluent_builders::UpdateApp::enable_branch_auto_build) / [`set_enable_branch_auto_build(Option<bool>)`](crate::client::fluent_builders::UpdateApp::set_enable_branch_auto_build): <p> Enables branch auto-building for an Amplify app. </p>
    ///   - [`enable_branch_auto_deletion(bool)`](crate::client::fluent_builders::UpdateApp::enable_branch_auto_deletion) / [`set_enable_branch_auto_deletion(Option<bool>)`](crate::client::fluent_builders::UpdateApp::set_enable_branch_auto_deletion): <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
    ///   - [`enable_basic_auth(bool)`](crate::client::fluent_builders::UpdateApp::enable_basic_auth) / [`set_enable_basic_auth(Option<bool>)`](crate::client::fluent_builders::UpdateApp::set_enable_basic_auth): <p> Enables basic authorization for an Amplify app. </p>
    ///   - [`basic_auth_credentials(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::basic_auth_credentials) / [`set_basic_auth_credentials(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_basic_auth_credentials): <p> The basic authorization credentials for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    ///   - [`custom_rules(Vec<CustomRule>)`](crate::client::fluent_builders::UpdateApp::custom_rules) / [`set_custom_rules(Option<Vec<CustomRule>>)`](crate::client::fluent_builders::UpdateApp::set_custom_rules): <p> The custom redirect and rewrite rules for an Amplify app. </p>
    ///   - [`build_spec(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::build_spec) / [`set_build_spec(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_build_spec): <p> The build specification (build spec) for an Amplify app. </p>
    ///   - [`custom_headers(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::custom_headers) / [`set_custom_headers(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_custom_headers): <p>The custom HTTP headers for an Amplify app.</p>
    ///   - [`enable_auto_branch_creation(bool)`](crate::client::fluent_builders::UpdateApp::enable_auto_branch_creation) / [`set_enable_auto_branch_creation(Option<bool>)`](crate::client::fluent_builders::UpdateApp::set_enable_auto_branch_creation): <p> Enables automated branch creation for an Amplify app. </p>
    ///   - [`auto_branch_creation_patterns(Vec<String>)`](crate::client::fluent_builders::UpdateApp::auto_branch_creation_patterns) / [`set_auto_branch_creation_patterns(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateApp::set_auto_branch_creation_patterns): <p> Describes the automated branch creation glob patterns for an Amplify app. </p>
    ///   - [`auto_branch_creation_config(AutoBranchCreationConfig)`](crate::client::fluent_builders::UpdateApp::auto_branch_creation_config) / [`set_auto_branch_creation_config(Option<AutoBranchCreationConfig>)`](crate::client::fluent_builders::UpdateApp::set_auto_branch_creation_config): <p> The automated branch creation configuration for an Amplify app. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_repository): <p> The name of the repository for an Amplify app </p>
    ///   - [`oauth_token(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::oauth_token) / [`set_oauth_token(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_oauth_token): <p>The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.</p>  <p>Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit.</p>  <p>To authorize access to GitHub as your repository provider, use <code>accessToken</code>.</p>  <p>You must specify either <code>oauthToken</code> or <code>accessToken</code> when you update an app.</p>  <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_access_token): <p>The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.</p>  <p>Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use <code>oauthToken</code>.</p>  <p>You must specify either <code>accessToken</code> or <code>oauthToken</code> when you update an app.</p>  <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
    /// - On success, responds with [`UpdateAppOutput`](crate::output::UpdateAppOutput) with field(s):
    ///   - [`app(Option<App>)`](crate::output::UpdateAppOutput::app): <p> Represents the updated Amplify app. </p>
    /// - On failure, responds with [`SdkError<UpdateAppError>`](crate::error::UpdateAppError)
    pub fn update_app(&self) -> fluent_builders::UpdateApp {
        fluent_builders::UpdateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBranch`](crate::client::fluent_builders::UpdateBranch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_branch_name): <p> The name for the branch. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_description): <p> The description for the branch. </p>
    ///   - [`framework(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::framework) / [`set_framework(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_framework): <p> The framework for the branch. </p>
    ///   - [`stage(Stage)`](crate::client::fluent_builders::UpdateBranch::stage) / [`set_stage(Option<Stage>)`](crate::client::fluent_builders::UpdateBranch::set_stage): <p> Describes the current stage for the branch. </p>
    ///   - [`enable_notification(bool)`](crate::client::fluent_builders::UpdateBranch::enable_notification) / [`set_enable_notification(Option<bool>)`](crate::client::fluent_builders::UpdateBranch::set_enable_notification): <p> Enables notifications for the branch. </p>
    ///   - [`enable_auto_build(bool)`](crate::client::fluent_builders::UpdateBranch::enable_auto_build) / [`set_enable_auto_build(Option<bool>)`](crate::client::fluent_builders::UpdateBranch::set_enable_auto_build): <p> Enables auto building for the branch. </p>
    ///   - [`environment_variables(HashMap<String, String>)`](crate::client::fluent_builders::UpdateBranch::environment_variables) / [`set_environment_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateBranch::set_environment_variables): <p> The environment variables for the branch. </p>
    ///   - [`basic_auth_credentials(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::basic_auth_credentials) / [`set_basic_auth_credentials(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_basic_auth_credentials): <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
    ///   - [`enable_basic_auth(bool)`](crate::client::fluent_builders::UpdateBranch::enable_basic_auth) / [`set_enable_basic_auth(Option<bool>)`](crate::client::fluent_builders::UpdateBranch::set_enable_basic_auth): <p> Enables basic authorization for the branch. </p>
    ///   - [`enable_performance_mode(bool)`](crate::client::fluent_builders::UpdateBranch::enable_performance_mode) / [`set_enable_performance_mode(Option<bool>)`](crate::client::fluent_builders::UpdateBranch::set_enable_performance_mode): <p>Enables performance mode for the branch.</p>  <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    ///   - [`build_spec(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::build_spec) / [`set_build_spec(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_build_spec): <p> The build specification (build spec) for the branch. </p>
    ///   - [`ttl(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::ttl) / [`set_ttl(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_ttl): <p> The content Time to Live (TTL) for the website in seconds. </p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_display_name): <p> The display name for a branch. This is used as the default domain prefix. </p>
    ///   - [`enable_pull_request_preview(bool)`](crate::client::fluent_builders::UpdateBranch::enable_pull_request_preview) / [`set_enable_pull_request_preview(Option<bool>)`](crate::client::fluent_builders::UpdateBranch::set_enable_pull_request_preview): <p> Enables pull request previews for this branch. </p>
    ///   - [`pull_request_environment_name(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::pull_request_environment_name) / [`set_pull_request_environment_name(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_pull_request_environment_name): <p> The Amplify environment name for the pull request. </p>
    ///   - [`backend_environment_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateBranch::backend_environment_arn) / [`set_backend_environment_arn(Option<String>)`](crate::client::fluent_builders::UpdateBranch::set_backend_environment_arn): <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
    /// - On success, responds with [`UpdateBranchOutput`](crate::output::UpdateBranchOutput) with field(s):
    ///   - [`branch(Option<Branch>)`](crate::output::UpdateBranchOutput::branch): <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
    /// - On failure, responds with [`SdkError<UpdateBranchError>`](crate::error::UpdateBranchError)
    pub fn update_branch(&self) -> fluent_builders::UpdateBranch {
        fluent_builders::UpdateBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainAssociation`](crate::client::fluent_builders::UpdateDomainAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainAssociation::app_id) / [`set_app_id(Option<String>)`](crate::client::fluent_builders::UpdateDomainAssociation::set_app_id): <p> The unique ID for an Amplify app. </p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainAssociation::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainAssociation::set_domain_name): <p> The name of the domain. </p>
    ///   - [`enable_auto_sub_domain(bool)`](crate::client::fluent_builders::UpdateDomainAssociation::enable_auto_sub_domain) / [`set_enable_auto_sub_domain(Option<bool>)`](crate::client::fluent_builders::UpdateDomainAssociation::set_enable_auto_sub_domain): <p> Enables the automated creation of subdomains for branches. </p>
    ///   - [`sub_domain_settings(Vec<SubDomainSetting>)`](crate::client::fluent_builders::UpdateDomainAssociation::sub_domain_settings) / [`set_sub_domain_settings(Option<Vec<SubDomainSetting>>)`](crate::client::fluent_builders::UpdateDomainAssociation::set_sub_domain_settings): <p> Describes the settings for the subdomain. </p>
    ///   - [`auto_sub_domain_creation_patterns(Vec<String>)`](crate::client::fluent_builders::UpdateDomainAssociation::auto_sub_domain_creation_patterns) / [`set_auto_sub_domain_creation_patterns(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateDomainAssociation::set_auto_sub_domain_creation_patterns): <p> Sets the branch patterns for automatic subdomain creation. </p>
    ///   - [`auto_sub_domain_iam_role(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainAssociation::auto_sub_domain_iam_role) / [`set_auto_sub_domain_iam_role(Option<String>)`](crate::client::fluent_builders::UpdateDomainAssociation::set_auto_sub_domain_iam_role): <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
    /// - On success, responds with [`UpdateDomainAssociationOutput`](crate::output::UpdateDomainAssociationOutput) with field(s):
    ///   - [`domain_association(Option<DomainAssociation>)`](crate::output::UpdateDomainAssociationOutput::domain_association): <p> Describes a domain association, which associates a custom domain with an Amplify app. </p>
    /// - On failure, responds with [`SdkError<UpdateDomainAssociationError>`](crate::error::UpdateDomainAssociationError)
    pub fn update_domain_association(&self) -> fluent_builders::UpdateDomainAssociation {
        fluent_builders::UpdateDomainAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWebhook`](crate::client::fluent_builders::UpdateWebhook) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`webhook_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWebhook::webhook_id) / [`set_webhook_id(Option<String>)`](crate::client::fluent_builders::UpdateWebhook::set_webhook_id): <p> The unique ID for a webhook. </p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::UpdateWebhook::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::UpdateWebhook::set_branch_name): <p> The name for a branch that is part of an Amplify app. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateWebhook::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateWebhook::set_description): <p> The description for a webhook. </p>
    /// - On success, responds with [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput) with field(s):
    ///   - [`webhook(Option<Webhook>)`](crate::output::UpdateWebhookOutput::webhook): <p> Describes a webhook that connects repository events to an Amplify app. </p>
    /// - On failure, responds with [`SdkError<UpdateWebhookError>`](crate::error::UpdateWebhookError)
    pub fn update_webhook(&self) -> fluent_builders::UpdateWebhook {
        fluent_builders::UpdateWebhook::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApp`.
    ///
    /// <p> Creates a new Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_app_input::Builder,
    }
    impl CreateApp {
        /// Creates a new `CreateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name for an Amplify app. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name for an Amplify app. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The repository for an Amplify app. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The repository for an Amplify app. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The platform or framework for an Amplify app. </p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p> The platform or framework for an Amplify app. </p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn iam_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_service_role_arn(input.into());
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn set_iam_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iam_service_role_arn(input);
            self
        }
        /// <p>The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.</p>
        /// <p>Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use <code>accessToken</code>.</p>
        /// <p>You must specify either <code>oauthToken</code> or <code>accessToken</code> when you create a new app.</p>
        /// <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
        pub fn oauth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.oauth_token(input.into());
            self
        }
        /// <p>The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.</p>
        /// <p>Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use <code>accessToken</code>.</p>
        /// <p>You must specify either <code>oauthToken</code> or <code>accessToken</code> when you create a new app.</p>
        /// <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
        pub fn set_oauth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_oauth_token(input);
            self
        }
        /// <p>The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.</p>
        /// <p>Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use <code>oauthToken</code>.</p>
        /// <p>You must specify either <code>accessToken</code> or <code>oauthToken</code> when you create a new app.</p>
        /// <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.</p>
        /// <p>Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use <code>oauthToken</code>.</p>
        /// <p>You must specify either <code>accessToken</code> or <code>oauthToken</code> when you create a new app.</p>
        /// <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// Adds a key-value pair to `environmentVariables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables map for an Amplify app. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_variables(k.into(), v.into());
            self
        }
        /// <p> The environment variables map for an Amplify app. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment_variables(input);
            self
        }
        /// <p> Enables the auto building of branches for an Amplify app. </p>
        pub fn enable_branch_auto_build(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_branch_auto_build(input);
            self
        }
        /// <p> Enables the auto building of branches for an Amplify app. </p>
        pub fn set_enable_branch_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_branch_auto_build(input);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
        pub fn enable_branch_auto_deletion(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_branch_auto_deletion(input);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
        pub fn set_enable_branch_auto_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_branch_auto_deletion(input);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_basic_auth(input);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_basic_auth(input);
            self
        }
        /// <p> The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basic_auth_credentials(input.into());
            self
        }
        /// <p> The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_basic_auth_credentials(input);
            self
        }
        /// Appends an item to `customRules`.
        ///
        /// To override the contents of this collection use [`set_custom_rules`](Self::set_custom_rules).
        ///
        /// <p> The custom rewrite and redirect rules for an Amplify app. </p>
        pub fn custom_rules(mut self, input: crate::model::CustomRule) -> Self {
            self.inner = self.inner.custom_rules(input);
            self
        }
        /// <p> The custom rewrite and redirect rules for an Amplify app. </p>
        pub fn set_custom_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        ) -> Self {
            self.inner = self.inner.set_custom_rules(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tag for an Amplify app. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tag for an Amplify app. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.build_spec(input.into());
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_build_spec(input);
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn custom_headers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_headers(input.into());
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn set_custom_headers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_headers(input);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn enable_auto_branch_creation(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_auto_branch_creation(input);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn set_enable_auto_branch_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_branch_creation(input);
            self
        }
        /// Appends an item to `autoBranchCreationPatterns`.
        ///
        /// To override the contents of this collection use [`set_auto_branch_creation_patterns`](Self::set_auto_branch_creation_patterns).
        ///
        /// <p> The automated branch creation glob patterns for an Amplify app. </p>
        pub fn auto_branch_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_branch_creation_patterns(input.into());
            self
        }
        /// <p> The automated branch creation glob patterns for an Amplify app. </p>
        pub fn set_auto_branch_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_branch_creation_patterns(input);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn auto_branch_creation_config(
            mut self,
            input: crate::model::AutoBranchCreationConfig,
        ) -> Self {
            self.inner = self.inner.auto_branch_creation_config(input);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn set_auto_branch_creation_config(
            mut self,
            input: std::option::Option<crate::model::AutoBranchCreationConfig>,
        ) -> Self {
            self.inner = self.inner.set_auto_branch_creation_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackendEnvironment`.
    ///
    /// <p> Creates a new backend environment for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBackendEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_backend_environment_input::Builder,
    }
    impl CreateBackendEnvironment {
        /// Creates a new `CreateBackendEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackendEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackendEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p> The AWS CloudFormation stack name of a backend environment. </p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p> The AWS CloudFormation stack name of a backend environment. </p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p> The name of deployment artifacts. </p>
        pub fn deployment_artifacts(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_artifacts(input.into());
            self
        }
        /// <p> The name of deployment artifacts. </p>
        pub fn set_deployment_artifacts(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_artifacts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBranch`.
    ///
    /// <p> Creates a new branch for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBranch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_branch_input::Builder,
    }
    impl CreateBranch {
        /// Creates a new `CreateBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBranchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The description for the branch. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description for the branch. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn stage(mut self, input: crate::model::Stage) -> Self {
            self.inner = self.inner.stage(input);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::Stage>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn framework(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework(input.into());
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn set_framework(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework(input);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn enable_notification(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_notification(input);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn set_enable_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_notification(input);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn enable_auto_build(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_auto_build(input);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn set_enable_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_build(input);
            self
        }
        /// Adds a key-value pair to `environmentVariables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for the branch. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_variables(k.into(), v.into());
            self
        }
        /// <p> The environment variables for the branch. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment_variables(input);
            self
        }
        /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basic_auth_credentials(input.into());
            self
        }
        /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_basic_auth_credentials(input);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_basic_auth(input);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_basic_auth(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn enable_performance_mode(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_performance_mode(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn set_enable_performance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_mode(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tag for the branch. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tag for the branch. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.build_spec(input.into());
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_build_spec(input);
            self
        }
        /// <p> The content Time To Live (TTL) for the website in seconds. </p>
        pub fn ttl(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ttl(input.into());
            self
        }
        /// <p> The content Time To Live (TTL) for the website in seconds. </p>
        pub fn set_ttl(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn enable_pull_request_preview(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_pull_request_preview(input);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn set_enable_pull_request_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_pull_request_preview(input);
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn pull_request_environment_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.pull_request_environment_name(input.into());
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn set_pull_request_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_environment_name(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
        pub fn backend_environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
        pub fn set_backend_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// <p> Creates a deployment for a manually deployed Amplify app. Manually deployed apps are not connected to a repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl CreateDeployment {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// Adds a key-value pair to `fileMap`.
        ///
        /// To override the contents of this collection use [`set_file_map`](Self::set_file_map).
        ///
        /// <p> An optional file map that contains the file name as the key and the file content md5 hash as the value. If this argument is provided, the service will generate a unique upload URL per file. Otherwise, the service will only generate a single upload URL for the zipped files. </p>
        pub fn file_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.file_map(k.into(), v.into());
            self
        }
        /// <p> An optional file map that contains the file name as the key and the file content md5 hash as the value. If this argument is provided, the service will generate a unique upload URL per file. Otherwise, the service will only generate a single upload URL for the zipped files. </p>
        pub fn set_file_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_file_map(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainAssociation`.
    ///
    /// <p> Creates a new domain association for an Amplify app. This action associates a custom domain with the Amplify app </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomainAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_domain_association_input::Builder,
    }
    impl CreateDomainAssociation {
        /// Creates a new `CreateDomainAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The domain name for the domain association. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p> The domain name for the domain association. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn enable_auto_sub_domain(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_auto_sub_domain(input);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn set_enable_auto_sub_domain(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_sub_domain(input);
            self
        }
        /// Appends an item to `subDomainSettings`.
        ///
        /// To override the contents of this collection use [`set_sub_domain_settings`](Self::set_sub_domain_settings).
        ///
        /// <p> The setting for the subdomain. </p>
        pub fn sub_domain_settings(mut self, input: crate::model::SubDomainSetting) -> Self {
            self.inner = self.inner.sub_domain_settings(input);
            self
        }
        /// <p> The setting for the subdomain. </p>
        pub fn set_sub_domain_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
        ) -> Self {
            self.inner = self.inner.set_sub_domain_settings(input);
            self
        }
        /// Appends an item to `autoSubDomainCreationPatterns`.
        ///
        /// To override the contents of this collection use [`set_auto_sub_domain_creation_patterns`](Self::set_auto_sub_domain_creation_patterns).
        ///
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn auto_sub_domain_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_sub_domain_creation_patterns(input.into());
            self
        }
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn set_auto_sub_domain_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_sub_domain_creation_patterns(input);
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn auto_sub_domain_iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_sub_domain_iam_role(input.into());
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn set_auto_sub_domain_iam_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_sub_domain_iam_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebhook`.
    ///
    /// <p> Creates a new webhook on an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWebhook {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_webhook_input::Builder,
    }
    impl CreateWebhook {
        /// Creates a new `CreateWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebhookError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApp`.
    ///
    /// <p> Deletes an existing Amplify app specified by an app ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_app_input::Builder,
    }
    impl DeleteApp {
        /// Creates a new `DeleteApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackendEnvironment`.
    ///
    /// <p> Deletes a backend environment for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBackendEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_backend_environment_input::Builder,
    }
    impl DeleteBackendEnvironment {
        /// Creates a new `DeleteBackendEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackendEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackendEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID of an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of a backend environment of an Amplify app. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p> The name of a backend environment of an Amplify app. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBranch`.
    ///
    /// <p> Deletes a branch for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBranch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_branch_input::Builder,
    }
    impl DeleteBranch {
        /// Creates a new `DeleteBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBranchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainAssociation`.
    ///
    /// <p> Deletes a domain association for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomainAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_domain_association_input::Builder,
    }
    impl DeleteDomainAssociation {
        /// Creates a new `DeleteDomainAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p> Deletes a job for a branch of an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl DeleteJob {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWebhook`.
    ///
    /// <p> Deletes a webhook. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWebhook {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_webhook_input::Builder,
    }
    impl DeleteWebhook {
        /// Creates a new `DeleteWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWebhookError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn webhook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.webhook_id(input.into());
            self
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_webhook_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateAccessLogs`.
    ///
    /// <p> Returns the website access logs for a specific time range using a presigned URL. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateAccessLogs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::generate_access_logs_input::Builder,
    }
    impl GenerateAccessLogs {
        /// Creates a new `GenerateAccessLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateAccessLogsOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateAccessLogsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The time at which the logs should start. The time range specified is inclusive of the start time. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p> The time at which the logs should start. The time range specified is inclusive of the start time. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The time at which the logs should end. The time range specified is inclusive of the end time. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p> The time at which the logs should end. The time range specified is inclusive of the end time. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApp`.
    ///
    /// <p> Returns an existing Amplify app by appID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_app_input::Builder,
    }
    impl GetApp {
        /// Creates a new `GetApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetArtifactUrl`.
    ///
    /// <p> Returns the artifact info that corresponds to an artifact id. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetArtifactUrl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_artifact_url_input::Builder,
    }
    impl GetArtifactUrl {
        /// Creates a new `GetArtifactUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetArtifactUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetArtifactUrlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an artifact. </p>
        pub fn artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_id(input.into());
            self
        }
        /// <p> The unique ID for an artifact. </p>
        pub fn set_artifact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_artifact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackendEnvironment`.
    ///
    /// <p> Returns a backend environment for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBackendEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_backend_environment_input::Builder,
    }
    impl GetBackendEnvironment {
        /// Creates a new `GetBackendEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackendEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackendEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p> The name for the backend environment. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBranch`.
    ///
    /// <p> Returns a branch for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBranch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_branch_input::Builder,
    }
    impl GetBranch {
        /// Creates a new `GetBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBranchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainAssociation`.
    ///
    /// <p> Returns the domain information for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_association_input::Builder,
    }
    impl GetDomainAssociation {
        /// Creates a new `GetDomainAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique id for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJob`.
    ///
    /// <p> Returns a job for a branch of an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_job_input::Builder,
    }
    impl GetJob {
        /// Creates a new `GetJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWebhook`.
    ///
    /// <p> Returns the webhook information that corresponds to a specified webhook ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWebhook {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_webhook_input::Builder,
    }
    impl GetWebhook {
        /// Creates a new `GetWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWebhookError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn webhook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.webhook_id(input.into());
            self
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_webhook_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApps`.
    ///
    /// <p> Returns a list of the existing Amplify apps. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApps {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_apps_input::Builder,
    }
    impl ListApps {
        /// Creates a new `ListApps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass its value in another request to retrieve more entries. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListArtifacts`.
    ///
    /// <p> Returns a list of artifacts for a specified app, branch, and job. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListArtifacts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_artifacts_input::Builder,
    }
    impl ListArtifacts {
        /// Creates a new `ListArtifacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListArtifactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListArtifactsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name of a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique ID for a job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p> The unique ID for a job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing artifacts from start. If a non-null pagination token is returned in a result, pass its value in here to list more artifacts. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing artifacts from start. If a non-null pagination token is returned in a result, pass its value in here to list more artifacts. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackendEnvironments`.
    ///
    /// <p> Lists the backend environments for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBackendEnvironments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_backend_environments_input::Builder,
    }
    impl ListBackendEnvironments {
        /// Creates a new `ListBackendEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackendEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackendEnvironmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of the backend environment </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p> The name of the backend environment </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing backend environments from the start. If a non-null pagination token is returned in a result, pass its value in here to list more backend environments. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing backend environments from the start. If a non-null pagination token is returned in a result, pass its value in here to list more backend environments. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBranches`.
    ///
    /// <p> Lists the branches of an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBranches {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_branches_input::Builder,
    }
    impl ListBranches {
        /// Creates a new `ListBranches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBranchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBranchesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing branches from the start. If a non-null pagination token is returned in a result, pass its value in here to list more branches. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing branches from the start. If a non-null pagination token is returned in a result, pass its value in here to list more branches. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainAssociations`.
    ///
    /// <p> Returns the domain associations for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domain_associations_input::Builder,
    }
    impl ListDomainAssociations {
        /// Creates a new `ListDomainAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing apps from the start. If non-null, a pagination token is returned in a result. Pass its value in here to list more projects. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing apps from the start. If non-null, a pagination token is returned in a result. Pass its value in here to list more projects. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p> Lists the jobs for a branch of an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl ListJobs {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for a branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for a branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing steps from the start. If a non-null pagination token is returned in a result, pass its value in here to list more steps. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing steps from the start. If a non-null pagination token is returned in a result, pass its value in here to list more steps. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns a list of tags for a specified Amazon Resource Name (ARN). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) to use to list tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) to use to list tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebhooks`.
    ///
    /// <p> Returns a list of webhooks for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWebhooks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_webhooks_input::Builder,
    }
    impl ListWebhooks {
        /// Creates a new `ListWebhooks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebhooksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebhooksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> A pagination token. Set to null to start listing webhooks from the start. If non-null,the pagination token is returned in a result. Pass its value in here to list more webhooks. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing webhooks from the start. If non-null,the pagination token is returned in a result. Pass its value in here to list more webhooks. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of records to list in a single response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDeployment`.
    ///
    /// <p> Starts a deployment for a manually deployed app. Manually deployed apps are not connected to a repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_deployment_input::Builder,
    }
    impl StartDeployment {
        /// Creates a new `StartDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The job ID for this deployment, generated by the create deployment request. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p> The job ID for this deployment, generated by the create deployment request. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p> The source URL for this deployment, used when calling start deployment without create deployment. The source URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file. </p>
        pub fn source_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_url(input.into());
            self
        }
        /// <p> The source URL for this deployment, used when calling start deployment without create deployment. The source URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file. </p>
        pub fn set_source_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartJob`.
    ///
    /// <p> Starts a new job for a branch of an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_job_input::Builder,
    }
    impl StartJob {
        /// Creates a new `StartJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The branch name for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique ID for an existing job. This is required if the value of <code>jobType</code> is <code>RETRY</code>. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p> The unique ID for an existing job. This is required if the value of <code>jobType</code> is <code>RETRY</code>. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p> Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the <code>jobId</code> is also required. </p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.inner = self.inner.job_type(input);
            self
        }
        /// <p> Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the <code>jobId</code> is also required. </p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.inner = self.inner.set_job_type(input);
            self
        }
        /// <p> A descriptive reason for starting this job. </p>
        pub fn job_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_reason(input.into());
            self
        }
        /// <p> A descriptive reason for starting this job. </p>
        pub fn set_job_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_reason(input);
            self
        }
        /// <p> The commit ID from a third-party repository provider for the job. </p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_id(input.into());
            self
        }
        /// <p> The commit ID from a third-party repository provider for the job. </p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_commit_id(input);
            self
        }
        /// <p> The commit message from a third-party repository provider for the job. </p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p> The commit message from a third-party repository provider for the job. </p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p> The commit date and time for the job. </p>
        pub fn commit_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.commit_time(input);
            self
        }
        /// <p> The commit date and time for the job. </p>
        pub fn set_commit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_commit_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopJob`.
    ///
    /// <p> Stops a job that is in progress for a branch of an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_job_input::Builder,
    }
    impl StopJob {
        /// Creates a new `StopJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for the branch, for the job. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The unique id for the job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p> The unique id for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Tags the resource with a tag key and value. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) to use to tag a resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) to use to tag a resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags used to tag the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags used to tag the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Untags a resource with a specified Amazon Resource Name (ARN). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) to use to untag a resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) to use to untag a resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The tag keys to use to untag a resource. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p> The tag keys to use to untag a resource. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApp`.
    ///
    /// <p> Updates an existing Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_app_input::Builder,
    }
    impl UpdateApp {
        /// Creates a new `UpdateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for an Amplify app. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name for an Amplify app. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description for an Amplify app. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The platform for an Amplify app. </p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p> The platform for an Amplify app. </p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn iam_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_service_role_arn(input.into());
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for an Amplify app. </p>
        pub fn set_iam_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iam_service_role_arn(input);
            self
        }
        /// Adds a key-value pair to `environmentVariables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for an Amplify app. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_variables(k.into(), v.into());
            self
        }
        /// <p> The environment variables for an Amplify app. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment_variables(input);
            self
        }
        /// <p> Enables branch auto-building for an Amplify app. </p>
        pub fn enable_branch_auto_build(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_branch_auto_build(input);
            self
        }
        /// <p> Enables branch auto-building for an Amplify app. </p>
        pub fn set_enable_branch_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_branch_auto_build(input);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
        pub fn enable_branch_auto_deletion(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_branch_auto_deletion(input);
            self
        }
        /// <p> Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. </p>
        pub fn set_enable_branch_auto_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_branch_auto_deletion(input);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_basic_auth(input);
            self
        }
        /// <p> Enables basic authorization for an Amplify app. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_basic_auth(input);
            self
        }
        /// <p> The basic authorization credentials for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basic_auth_credentials(input.into());
            self
        }
        /// <p> The basic authorization credentials for an Amplify app. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_basic_auth_credentials(input);
            self
        }
        /// Appends an item to `customRules`.
        ///
        /// To override the contents of this collection use [`set_custom_rules`](Self::set_custom_rules).
        ///
        /// <p> The custom redirect and rewrite rules for an Amplify app. </p>
        pub fn custom_rules(mut self, input: crate::model::CustomRule) -> Self {
            self.inner = self.inner.custom_rules(input);
            self
        }
        /// <p> The custom redirect and rewrite rules for an Amplify app. </p>
        pub fn set_custom_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        ) -> Self {
            self.inner = self.inner.set_custom_rules(input);
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.build_spec(input.into());
            self
        }
        /// <p> The build specification (build spec) for an Amplify app. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_build_spec(input);
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn custom_headers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_headers(input.into());
            self
        }
        /// <p>The custom HTTP headers for an Amplify app.</p>
        pub fn set_custom_headers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_headers(input);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn enable_auto_branch_creation(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_auto_branch_creation(input);
            self
        }
        /// <p> Enables automated branch creation for an Amplify app. </p>
        pub fn set_enable_auto_branch_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_branch_creation(input);
            self
        }
        /// Appends an item to `autoBranchCreationPatterns`.
        ///
        /// To override the contents of this collection use [`set_auto_branch_creation_patterns`](Self::set_auto_branch_creation_patterns).
        ///
        /// <p> Describes the automated branch creation glob patterns for an Amplify app. </p>
        pub fn auto_branch_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_branch_creation_patterns(input.into());
            self
        }
        /// <p> Describes the automated branch creation glob patterns for an Amplify app. </p>
        pub fn set_auto_branch_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_branch_creation_patterns(input);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn auto_branch_creation_config(
            mut self,
            input: crate::model::AutoBranchCreationConfig,
        ) -> Self {
            self.inner = self.inner.auto_branch_creation_config(input);
            self
        }
        /// <p> The automated branch creation configuration for an Amplify app. </p>
        pub fn set_auto_branch_creation_config(
            mut self,
            input: std::option::Option<crate::model::AutoBranchCreationConfig>,
        ) -> Self {
            self.inner = self.inner.set_auto_branch_creation_config(input);
            self
        }
        /// <p> The name of the repository for an Amplify app </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository for an Amplify app </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.</p>
        /// <p>Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit.</p>
        /// <p>To authorize access to GitHub as your repository provider, use <code>accessToken</code>.</p>
        /// <p>You must specify either <code>oauthToken</code> or <code>accessToken</code> when you update an app.</p>
        /// <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
        pub fn oauth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.oauth_token(input.into());
            self
        }
        /// <p>The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.</p>
        /// <p>Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit.</p>
        /// <p>To authorize access to GitHub as your repository provider, use <code>accessToken</code>.</p>
        /// <p>You must specify either <code>oauthToken</code> or <code>accessToken</code> when you update an app.</p>
        /// <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
        pub fn set_oauth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_oauth_token(input);
            self
        }
        /// <p>The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.</p>
        /// <p>Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use <code>oauthToken</code>.</p>
        /// <p>You must specify either <code>accessToken</code> or <code>oauthToken</code> when you update an app.</p>
        /// <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.</p>
        /// <p>Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use <code>oauthToken</code>.</p>
        /// <p>You must specify either <code>accessToken</code> or <code>oauthToken</code> when you update an app.</p>
        /// <p>Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBranch`.
    ///
    /// <p> Updates a branch for an Amplify app. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBranch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_branch_input::Builder,
    }
    impl UpdateBranch {
        /// Creates a new `UpdateBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBranchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name for the branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for the branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The description for the branch. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description for the branch. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn framework(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework(input.into());
            self
        }
        /// <p> The framework for the branch. </p>
        pub fn set_framework(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework(input);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn stage(mut self, input: crate::model::Stage) -> Self {
            self.inner = self.inner.stage(input);
            self
        }
        /// <p> Describes the current stage for the branch. </p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::Stage>) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn enable_notification(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_notification(input);
            self
        }
        /// <p> Enables notifications for the branch. </p>
        pub fn set_enable_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_notification(input);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn enable_auto_build(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_auto_build(input);
            self
        }
        /// <p> Enables auto building for the branch. </p>
        pub fn set_enable_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_build(input);
            self
        }
        /// Adds a key-value pair to `environmentVariables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for the branch. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_variables(k.into(), v.into());
            self
        }
        /// <p> The environment variables for the branch. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment_variables(input);
            self
        }
        /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.basic_auth_credentials(input.into());
            self
        }
        /// <p> The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format <code>user:password</code>.</p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_basic_auth_credentials(input);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_basic_auth(input);
            self
        }
        /// <p> Enables basic authorization for the branch. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_basic_auth(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn enable_performance_mode(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_performance_mode(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn set_enable_performance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_mode(input);
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.build_spec(input.into());
            self
        }
        /// <p> The build specification (build spec) for the branch. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_build_spec(input);
            self
        }
        /// <p> The content Time to Live (TTL) for the website in seconds. </p>
        pub fn ttl(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ttl(input.into());
            self
        }
        /// <p> The content Time to Live (TTL) for the website in seconds. </p>
        pub fn set_ttl(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p> The display name for a branch. This is used as the default domain prefix. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn enable_pull_request_preview(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_pull_request_preview(input);
            self
        }
        /// <p> Enables pull request previews for this branch. </p>
        pub fn set_enable_pull_request_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_pull_request_preview(input);
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn pull_request_environment_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.pull_request_environment_name(input.into());
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn set_pull_request_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_environment_name(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
        pub fn backend_environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backend_environment_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
        pub fn set_backend_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backend_environment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainAssociation`.
    ///
    /// <p> Creates a new domain association for an Amplify app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_domain_association_input::Builder,
    }
    impl UpdateDomainAssociation {
        /// Creates a new `UpdateDomainAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(input.into());
            self
        }
        /// <p> The unique ID for an Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn enable_auto_sub_domain(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_auto_sub_domain(input);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn set_enable_auto_sub_domain(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_auto_sub_domain(input);
            self
        }
        /// Appends an item to `subDomainSettings`.
        ///
        /// To override the contents of this collection use [`set_sub_domain_settings`](Self::set_sub_domain_settings).
        ///
        /// <p> Describes the settings for the subdomain. </p>
        pub fn sub_domain_settings(mut self, input: crate::model::SubDomainSetting) -> Self {
            self.inner = self.inner.sub_domain_settings(input);
            self
        }
        /// <p> Describes the settings for the subdomain. </p>
        pub fn set_sub_domain_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubDomainSetting>>,
        ) -> Self {
            self.inner = self.inner.set_sub_domain_settings(input);
            self
        }
        /// Appends an item to `autoSubDomainCreationPatterns`.
        ///
        /// To override the contents of this collection use [`set_auto_sub_domain_creation_patterns`](Self::set_auto_sub_domain_creation_patterns).
        ///
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn auto_sub_domain_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_sub_domain_creation_patterns(input.into());
            self
        }
        /// <p> Sets the branch patterns for automatic subdomain creation. </p>
        pub fn set_auto_sub_domain_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_sub_domain_creation_patterns(input);
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn auto_sub_domain_iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_sub_domain_iam_role(input.into());
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn set_auto_sub_domain_iam_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_sub_domain_iam_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWebhook`.
    ///
    /// <p> Updates a webhook. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWebhook {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_webhook_input::Builder,
    }
    impl UpdateWebhook {
        /// Creates a new `UpdateWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWebhookError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn webhook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.webhook_id(input.into());
            self
        }
        /// <p> The unique ID for a webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_webhook_id(input);
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
