// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p> The result structure for the update webhook request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWebhookOutput {
    /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
    pub webhook: std::option::Option<crate::model::Webhook>,
}
impl UpdateWebhookOutput {
    /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
    pub fn webhook(&self) -> std::option::Option<&crate::model::Webhook> {
        self.webhook.as_ref()
    }
}
impl std::fmt::Debug for UpdateWebhookOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWebhookOutput");
        formatter.field("webhook", &self.webhook);
        formatter.finish()
    }
}
/// See [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput)
pub mod update_webhook_output {
    /// A builder for [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook: std::option::Option<crate::model::Webhook>,
    }
    impl Builder {
        /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
        pub fn webhook(mut self, input: crate::model::Webhook) -> Self {
            self.webhook = Some(input);
            self
        }
        /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
        pub fn set_webhook(mut self, input: std::option::Option<crate::model::Webhook>) -> Self {
            self.webhook = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput)
        pub fn build(self) -> crate::output::UpdateWebhookOutput {
            crate::output::UpdateWebhookOutput {
                webhook: self.webhook,
            }
        }
    }
}
impl UpdateWebhookOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput)
    pub fn builder() -> crate::output::update_webhook_output::Builder {
        crate::output::update_webhook_output::Builder::default()
    }
}

/// <p> The result structure for the update domain association request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainAssociationOutput {
    /// <p> Describes a domain association, which associates a custom domain with an Amplify app.
    /// </p>
    pub domain_association: std::option::Option<crate::model::DomainAssociation>,
}
impl UpdateDomainAssociationOutput {
    /// <p> Describes a domain association, which associates a custom domain with an Amplify app.
    /// </p>
    pub fn domain_association(&self) -> std::option::Option<&crate::model::DomainAssociation> {
        self.domain_association.as_ref()
    }
}
impl std::fmt::Debug for UpdateDomainAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainAssociationOutput");
        formatter.field("domain_association", &self.domain_association);
        formatter.finish()
    }
}
/// See [`UpdateDomainAssociationOutput`](crate::output::UpdateDomainAssociationOutput)
pub mod update_domain_association_output {
    /// A builder for [`UpdateDomainAssociationOutput`](crate::output::UpdateDomainAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_association: std::option::Option<crate::model::DomainAssociation>,
    }
    impl Builder {
        /// <p> Describes a domain association, which associates a custom domain with an Amplify app.
        /// </p>
        pub fn domain_association(mut self, input: crate::model::DomainAssociation) -> Self {
            self.domain_association = Some(input);
            self
        }
        /// <p> Describes a domain association, which associates a custom domain with an Amplify app.
        /// </p>
        pub fn set_domain_association(
            mut self,
            input: std::option::Option<crate::model::DomainAssociation>,
        ) -> Self {
            self.domain_association = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainAssociationOutput`](crate::output::UpdateDomainAssociationOutput)
        pub fn build(self) -> crate::output::UpdateDomainAssociationOutput {
            crate::output::UpdateDomainAssociationOutput {
                domain_association: self.domain_association,
            }
        }
    }
}
impl UpdateDomainAssociationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainAssociationOutput`](crate::output::UpdateDomainAssociationOutput)
    pub fn builder() -> crate::output::update_domain_association_output::Builder {
        crate::output::update_domain_association_output::Builder::default()
    }
}

/// <p> The result structure for the update branch request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBranchOutput {
    /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
    pub branch: std::option::Option<crate::model::Branch>,
}
impl UpdateBranchOutput {
    /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
    pub fn branch(&self) -> std::option::Option<&crate::model::Branch> {
        self.branch.as_ref()
    }
}
impl std::fmt::Debug for UpdateBranchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBranchOutput");
        formatter.field("branch", &self.branch);
        formatter.finish()
    }
}
/// See [`UpdateBranchOutput`](crate::output::UpdateBranchOutput)
pub mod update_branch_output {
    /// A builder for [`UpdateBranchOutput`](crate::output::UpdateBranchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branch: std::option::Option<crate::model::Branch>,
    }
    impl Builder {
        /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
        pub fn branch(mut self, input: crate::model::Branch) -> Self {
            self.branch = Some(input);
            self
        }
        /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
        pub fn set_branch(mut self, input: std::option::Option<crate::model::Branch>) -> Self {
            self.branch = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBranchOutput`](crate::output::UpdateBranchOutput)
        pub fn build(self) -> crate::output::UpdateBranchOutput {
            crate::output::UpdateBranchOutput {
                branch: self.branch,
            }
        }
    }
}
impl UpdateBranchOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBranchOutput`](crate::output::UpdateBranchOutput)
    pub fn builder() -> crate::output::update_branch_output::Builder {
        crate::output::update_branch_output::Builder::default()
    }
}

/// <p> The result structure for an Amplify app update request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppOutput {
    /// <p> Represents the updated Amplify app. </p>
    pub app: std::option::Option<crate::model::App>,
}
impl UpdateAppOutput {
    /// <p> Represents the updated Amplify app. </p>
    pub fn app(&self) -> std::option::Option<&crate::model::App> {
        self.app.as_ref()
    }
}
impl std::fmt::Debug for UpdateAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppOutput");
        formatter.field("app", &self.app);
        formatter.finish()
    }
}
/// See [`UpdateAppOutput`](crate::output::UpdateAppOutput)
pub mod update_app_output {
    /// A builder for [`UpdateAppOutput`](crate::output::UpdateAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app: std::option::Option<crate::model::App>,
    }
    impl Builder {
        /// <p> Represents the updated Amplify app. </p>
        pub fn app(mut self, input: crate::model::App) -> Self {
            self.app = Some(input);
            self
        }
        /// <p> Represents the updated Amplify app. </p>
        pub fn set_app(mut self, input: std::option::Option<crate::model::App>) -> Self {
            self.app = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppOutput`](crate::output::UpdateAppOutput)
        pub fn build(self) -> crate::output::UpdateAppOutput {
            crate::output::UpdateAppOutput { app: self.app }
        }
    }
}
impl UpdateAppOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAppOutput`](crate::output::UpdateAppOutput)
    pub fn builder() -> crate::output::update_app_output::Builder {
        crate::output::update_app_output::Builder::default()
    }
}

/// <p> The response for the untag resource request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

/// <p> The response for the tag resource request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p> The result structure for the stop job request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopJobOutput {
    /// <p> The summary for the job. </p>
    pub job_summary: std::option::Option<crate::model::JobSummary>,
}
impl StopJobOutput {
    /// <p> The summary for the job. </p>
    pub fn job_summary(&self) -> std::option::Option<&crate::model::JobSummary> {
        self.job_summary.as_ref()
    }
}
impl std::fmt::Debug for StopJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopJobOutput");
        formatter.field("job_summary", &self.job_summary);
        formatter.finish()
    }
}
/// See [`StopJobOutput`](crate::output::StopJobOutput)
pub mod stop_job_output {
    /// A builder for [`StopJobOutput`](crate::output::StopJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_summary: std::option::Option<crate::model::JobSummary>,
    }
    impl Builder {
        /// <p> The summary for the job. </p>
        pub fn job_summary(mut self, input: crate::model::JobSummary) -> Self {
            self.job_summary = Some(input);
            self
        }
        /// <p> The summary for the job. </p>
        pub fn set_job_summary(
            mut self,
            input: std::option::Option<crate::model::JobSummary>,
        ) -> Self {
            self.job_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`StopJobOutput`](crate::output::StopJobOutput)
        pub fn build(self) -> crate::output::StopJobOutput {
            crate::output::StopJobOutput {
                job_summary: self.job_summary,
            }
        }
    }
}
impl StopJobOutput {
    /// Creates a new builder-style object to manufacture [`StopJobOutput`](crate::output::StopJobOutput)
    pub fn builder() -> crate::output::stop_job_output::Builder {
        crate::output::stop_job_output::Builder::default()
    }
}

/// <p> The result structure for the run job request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartJobOutput {
    /// <p> The summary for the job. </p>
    pub job_summary: std::option::Option<crate::model::JobSummary>,
}
impl StartJobOutput {
    /// <p> The summary for the job. </p>
    pub fn job_summary(&self) -> std::option::Option<&crate::model::JobSummary> {
        self.job_summary.as_ref()
    }
}
impl std::fmt::Debug for StartJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartJobOutput");
        formatter.field("job_summary", &self.job_summary);
        formatter.finish()
    }
}
/// See [`StartJobOutput`](crate::output::StartJobOutput)
pub mod start_job_output {
    /// A builder for [`StartJobOutput`](crate::output::StartJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_summary: std::option::Option<crate::model::JobSummary>,
    }
    impl Builder {
        /// <p> The summary for the job. </p>
        pub fn job_summary(mut self, input: crate::model::JobSummary) -> Self {
            self.job_summary = Some(input);
            self
        }
        /// <p> The summary for the job. </p>
        pub fn set_job_summary(
            mut self,
            input: std::option::Option<crate::model::JobSummary>,
        ) -> Self {
            self.job_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`StartJobOutput`](crate::output::StartJobOutput)
        pub fn build(self) -> crate::output::StartJobOutput {
            crate::output::StartJobOutput {
                job_summary: self.job_summary,
            }
        }
    }
}
impl StartJobOutput {
    /// Creates a new builder-style object to manufacture [`StartJobOutput`](crate::output::StartJobOutput)
    pub fn builder() -> crate::output::start_job_output::Builder {
        crate::output::start_job_output::Builder::default()
    }
}

/// <p> The result structure for the start a deployment request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDeploymentOutput {
    /// <p> The summary for the job. </p>
    pub job_summary: std::option::Option<crate::model::JobSummary>,
}
impl StartDeploymentOutput {
    /// <p> The summary for the job. </p>
    pub fn job_summary(&self) -> std::option::Option<&crate::model::JobSummary> {
        self.job_summary.as_ref()
    }
}
impl std::fmt::Debug for StartDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDeploymentOutput");
        formatter.field("job_summary", &self.job_summary);
        formatter.finish()
    }
}
/// See [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
pub mod start_deployment_output {
    /// A builder for [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_summary: std::option::Option<crate::model::JobSummary>,
    }
    impl Builder {
        /// <p> The summary for the job. </p>
        pub fn job_summary(mut self, input: crate::model::JobSummary) -> Self {
            self.job_summary = Some(input);
            self
        }
        /// <p> The summary for the job. </p>
        pub fn set_job_summary(
            mut self,
            input: std::option::Option<crate::model::JobSummary>,
        ) -> Self {
            self.job_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
        pub fn build(self) -> crate::output::StartDeploymentOutput {
            crate::output::StartDeploymentOutput {
                job_summary: self.job_summary,
            }
        }
    }
}
impl StartDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
    pub fn builder() -> crate::output::start_deployment_output::Builder {
        crate::output::start_deployment_output::Builder::default()
    }
}

/// <p> The result structure for the list webhooks request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWebhooksOutput {
    /// <p> A list of webhooks. </p>
    pub webhooks: std::option::Option<std::vec::Vec<crate::model::Webhook>>,
    /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass
    /// its value in another request to retrieve more entries. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWebhooksOutput {
    /// <p> A list of webhooks. </p>
    pub fn webhooks(&self) -> std::option::Option<&[crate::model::Webhook]> {
        self.webhooks.as_deref()
    }
    /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass
    /// its value in another request to retrieve more entries. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWebhooksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWebhooksOutput");
        formatter.field("webhooks", &self.webhooks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWebhooksOutput`](crate::output::ListWebhooksOutput)
pub mod list_webhooks_output {
    /// A builder for [`ListWebhooksOutput`](crate::output::ListWebhooksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhooks: std::option::Option<std::vec::Vec<crate::model::Webhook>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `webhooks`.
        ///
        /// To override the contents of this collection use [`set_webhooks`](Self::set_webhooks).
        ///
        /// <p> A list of webhooks. </p>
        pub fn webhooks(mut self, input: impl Into<crate::model::Webhook>) -> Self {
            let mut v = self.webhooks.unwrap_or_default();
            v.push(input.into());
            self.webhooks = Some(v);
            self
        }
        /// <p> A list of webhooks. </p>
        pub fn set_webhooks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Webhook>>,
        ) -> Self {
            self.webhooks = input;
            self
        }
        /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass
        /// its value in another request to retrieve more entries. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. If non-null, the pagination token is returned in a result. Pass
        /// its value in another request to retrieve more entries. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWebhooksOutput`](crate::output::ListWebhooksOutput)
        pub fn build(self) -> crate::output::ListWebhooksOutput {
            crate::output::ListWebhooksOutput {
                webhooks: self.webhooks,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWebhooksOutput {
    /// Creates a new builder-style object to manufacture [`ListWebhooksOutput`](crate::output::ListWebhooksOutput)
    pub fn builder() -> crate::output::list_webhooks_output::Builder {
        crate::output::list_webhooks_output::Builder::default()
    }
}

/// <p> The response for the list tags for resource request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p> A list of tags for the specified The Amazon Resource Name (ARN). </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p> A list of tags for the specified The Amazon Resource Name (ARN). </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A list of tags for the specified The Amazon Resource Name (ARN). </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> A list of tags for the specified The Amazon Resource Name (ARN). </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p> The maximum number of records to list in a single response. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsOutput {
    /// <p> The result structure for the list job result request. </p>
    pub job_summaries: std::option::Option<std::vec::Vec<crate::model::JobSummary>>,
    /// <p> A pagination token. If non-null the pagination token is returned in a result. Pass
    /// its value in another request to retrieve more entries. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobsOutput {
    /// <p> The result structure for the list job result request. </p>
    pub fn job_summaries(&self) -> std::option::Option<&[crate::model::JobSummary]> {
        self.job_summaries.as_deref()
    }
    /// <p> A pagination token. If non-null the pagination token is returned in a result. Pass
    /// its value in another request to retrieve more entries. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsOutput");
        formatter.field("job_summaries", &self.job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobsOutput`](crate::output::ListJobsOutput)
pub mod list_jobs_output {
    /// A builder for [`ListJobsOutput`](crate::output::ListJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_summaries: std::option::Option<std::vec::Vec<crate::model::JobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_summaries`.
        ///
        /// To override the contents of this collection use [`set_job_summaries`](Self::set_job_summaries).
        ///
        /// <p> The result structure for the list job result request. </p>
        pub fn job_summaries(mut self, input: impl Into<crate::model::JobSummary>) -> Self {
            let mut v = self.job_summaries.unwrap_or_default();
            v.push(input.into());
            self.job_summaries = Some(v);
            self
        }
        /// <p> The result structure for the list job result request. </p>
        pub fn set_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobSummary>>,
        ) -> Self {
            self.job_summaries = input;
            self
        }
        /// <p> A pagination token. If non-null the pagination token is returned in a result. Pass
        /// its value in another request to retrieve more entries. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. If non-null the pagination token is returned in a result. Pass
        /// its value in another request to retrieve more entries. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsOutput`](crate::output::ListJobsOutput)
        pub fn build(self) -> crate::output::ListJobsOutput {
            crate::output::ListJobsOutput {
                job_summaries: self.job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsOutput`](crate::output::ListJobsOutput)
    pub fn builder() -> crate::output::list_jobs_output::Builder {
        crate::output::list_jobs_output::Builder::default()
    }
}

/// <p> The result structure for the list domain association request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainAssociationsOutput {
    /// <p> A list of domain associations. </p>
    pub domain_associations: std::option::Option<std::vec::Vec<crate::model::DomainAssociation>>,
    /// <p> A pagination token. If non-null, a pagination token is returned in a result. Pass its
    /// value in another request to retrieve more entries. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDomainAssociationsOutput {
    /// <p> A list of domain associations. </p>
    pub fn domain_associations(&self) -> std::option::Option<&[crate::model::DomainAssociation]> {
        self.domain_associations.as_deref()
    }
    /// <p> A pagination token. If non-null, a pagination token is returned in a result. Pass its
    /// value in another request to retrieve more entries. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDomainAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainAssociationsOutput");
        formatter.field("domain_associations", &self.domain_associations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDomainAssociationsOutput`](crate::output::ListDomainAssociationsOutput)
pub mod list_domain_associations_output {
    /// A builder for [`ListDomainAssociationsOutput`](crate::output::ListDomainAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_associations:
            std::option::Option<std::vec::Vec<crate::model::DomainAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domain_associations`.
        ///
        /// To override the contents of this collection use [`set_domain_associations`](Self::set_domain_associations).
        ///
        /// <p> A list of domain associations. </p>
        pub fn domain_associations(
            mut self,
            input: impl Into<crate::model::DomainAssociation>,
        ) -> Self {
            let mut v = self.domain_associations.unwrap_or_default();
            v.push(input.into());
            self.domain_associations = Some(v);
            self
        }
        /// <p> A list of domain associations. </p>
        pub fn set_domain_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainAssociation>>,
        ) -> Self {
            self.domain_associations = input;
            self
        }
        /// <p> A pagination token. If non-null, a pagination token is returned in a result. Pass its
        /// value in another request to retrieve more entries. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. If non-null, a pagination token is returned in a result. Pass its
        /// value in another request to retrieve more entries. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainAssociationsOutput`](crate::output::ListDomainAssociationsOutput)
        pub fn build(self) -> crate::output::ListDomainAssociationsOutput {
            crate::output::ListDomainAssociationsOutput {
                domain_associations: self.domain_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDomainAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainAssociationsOutput`](crate::output::ListDomainAssociationsOutput)
    pub fn builder() -> crate::output::list_domain_associations_output::Builder {
        crate::output::list_domain_associations_output::Builder::default()
    }
}

/// <p> The result structure for the list branches request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBranchesOutput {
    /// <p> A list of branches for an Amplify app. </p>
    pub branches: std::option::Option<std::vec::Vec<crate::model::Branch>>,
    /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
    /// value in another request to retrieve more entries. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBranchesOutput {
    /// <p> A list of branches for an Amplify app. </p>
    pub fn branches(&self) -> std::option::Option<&[crate::model::Branch]> {
        self.branches.as_deref()
    }
    /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
    /// value in another request to retrieve more entries. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBranchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBranchesOutput");
        formatter.field("branches", &self.branches);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBranchesOutput`](crate::output::ListBranchesOutput)
pub mod list_branches_output {
    /// A builder for [`ListBranchesOutput`](crate::output::ListBranchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branches: std::option::Option<std::vec::Vec<crate::model::Branch>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `branches`.
        ///
        /// To override the contents of this collection use [`set_branches`](Self::set_branches).
        ///
        /// <p> A list of branches for an Amplify app. </p>
        pub fn branches(mut self, input: impl Into<crate::model::Branch>) -> Self {
            let mut v = self.branches.unwrap_or_default();
            v.push(input.into());
            self.branches = Some(v);
            self
        }
        /// <p> A list of branches for an Amplify app. </p>
        pub fn set_branches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Branch>>,
        ) -> Self {
            self.branches = input;
            self
        }
        /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
        /// value in another request to retrieve more entries. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
        /// value in another request to retrieve more entries. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBranchesOutput`](crate::output::ListBranchesOutput)
        pub fn build(self) -> crate::output::ListBranchesOutput {
            crate::output::ListBranchesOutput {
                branches: self.branches,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBranchesOutput {
    /// Creates a new builder-style object to manufacture [`ListBranchesOutput`](crate::output::ListBranchesOutput)
    pub fn builder() -> crate::output::list_branches_output::Builder {
        crate::output::list_branches_output::Builder::default()
    }
}

/// <p> The result structure for the list backend environments result. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackendEnvironmentsOutput {
    /// <p> The list of backend environments for an Amplify app. </p>
    pub backend_environments: std::option::Option<std::vec::Vec<crate::model::BackendEnvironment>>,
    /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
    /// value in another request to retrieve more entries. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBackendEnvironmentsOutput {
    /// <p> The list of backend environments for an Amplify app. </p>
    pub fn backend_environments(&self) -> std::option::Option<&[crate::model::BackendEnvironment]> {
        self.backend_environments.as_deref()
    }
    /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
    /// value in another request to retrieve more entries. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBackendEnvironmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackendEnvironmentsOutput");
        formatter.field("backend_environments", &self.backend_environments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBackendEnvironmentsOutput`](crate::output::ListBackendEnvironmentsOutput)
pub mod list_backend_environments_output {
    /// A builder for [`ListBackendEnvironmentsOutput`](crate::output::ListBackendEnvironmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backend_environments:
            std::option::Option<std::vec::Vec<crate::model::BackendEnvironment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `backend_environments`.
        ///
        /// To override the contents of this collection use [`set_backend_environments`](Self::set_backend_environments).
        ///
        /// <p> The list of backend environments for an Amplify app. </p>
        pub fn backend_environments(
            mut self,
            input: impl Into<crate::model::BackendEnvironment>,
        ) -> Self {
            let mut v = self.backend_environments.unwrap_or_default();
            v.push(input.into());
            self.backend_environments = Some(v);
            self
        }
        /// <p> The list of backend environments for an Amplify app. </p>
        pub fn set_backend_environments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackendEnvironment>>,
        ) -> Self {
            self.backend_environments = input;
            self
        }
        /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
        /// value in another request to retrieve more entries. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
        /// value in another request to retrieve more entries. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackendEnvironmentsOutput`](crate::output::ListBackendEnvironmentsOutput)
        pub fn build(self) -> crate::output::ListBackendEnvironmentsOutput {
            crate::output::ListBackendEnvironmentsOutput {
                backend_environments: self.backend_environments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBackendEnvironmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListBackendEnvironmentsOutput`](crate::output::ListBackendEnvironmentsOutput)
    pub fn builder() -> crate::output::list_backend_environments_output::Builder {
        crate::output::list_backend_environments_output::Builder::default()
    }
}

/// <p> The result structure for the list artifacts request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListArtifactsOutput {
    /// <p> A list of artifacts. </p>
    pub artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
    /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
    /// value in another request to retrieve more entries. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListArtifactsOutput {
    /// <p> A list of artifacts. </p>
    pub fn artifacts(&self) -> std::option::Option<&[crate::model::Artifact]> {
        self.artifacts.as_deref()
    }
    /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
    /// value in another request to retrieve more entries. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListArtifactsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListArtifactsOutput");
        formatter.field("artifacts", &self.artifacts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
pub mod list_artifacts_output {
    /// A builder for [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `artifacts`.
        ///
        /// To override the contents of this collection use [`set_artifacts`](Self::set_artifacts).
        ///
        /// <p> A list of artifacts. </p>
        pub fn artifacts(mut self, input: impl Into<crate::model::Artifact>) -> Self {
            let mut v = self.artifacts.unwrap_or_default();
            v.push(input.into());
            self.artifacts = Some(v);
            self
        }
        /// <p> A list of artifacts. </p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        ) -> Self {
            self.artifacts = input;
            self
        }
        /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
        /// value in another request to retrieve more entries. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. If a non-null pagination token is returned in a result, pass its
        /// value in another request to retrieve more entries. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
        pub fn build(self) -> crate::output::ListArtifactsOutput {
            crate::output::ListArtifactsOutput {
                artifacts: self.artifacts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListArtifactsOutput {
    /// Creates a new builder-style object to manufacture [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
    pub fn builder() -> crate::output::list_artifacts_output::Builder {
        crate::output::list_artifacts_output::Builder::default()
    }
}

/// <p> The result structure for an Amplify app list request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppsOutput {
    /// <p> A list of Amplify apps. </p>
    pub apps: std::option::Option<std::vec::Vec<crate::model::App>>,
    /// <p> A pagination token. Set to null to start listing apps from start. If non-null, the
    /// pagination token is returned in a result. Pass its value in here to list more projects.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppsOutput {
    /// <p> A list of Amplify apps. </p>
    pub fn apps(&self) -> std::option::Option<&[crate::model::App]> {
        self.apps.as_deref()
    }
    /// <p> A pagination token. Set to null to start listing apps from start. If non-null, the
    /// pagination token is returned in a result. Pass its value in here to list more projects.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppsOutput");
        formatter.field("apps", &self.apps);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppsOutput`](crate::output::ListAppsOutput)
pub mod list_apps_output {
    /// A builder for [`ListAppsOutput`](crate::output::ListAppsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apps: std::option::Option<std::vec::Vec<crate::model::App>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `apps`.
        ///
        /// To override the contents of this collection use [`set_apps`](Self::set_apps).
        ///
        /// <p> A list of Amplify apps. </p>
        pub fn apps(mut self, input: impl Into<crate::model::App>) -> Self {
            let mut v = self.apps.unwrap_or_default();
            v.push(input.into());
            self.apps = Some(v);
            self
        }
        /// <p> A list of Amplify apps. </p>
        pub fn set_apps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::App>>,
        ) -> Self {
            self.apps = input;
            self
        }
        /// <p> A pagination token. Set to null to start listing apps from start. If non-null, the
        /// pagination token is returned in a result. Pass its value in here to list more projects.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token. Set to null to start listing apps from start. If non-null, the
        /// pagination token is returned in a result. Pass its value in here to list more projects.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppsOutput`](crate::output::ListAppsOutput)
        pub fn build(self) -> crate::output::ListAppsOutput {
            crate::output::ListAppsOutput {
                apps: self.apps,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppsOutput`](crate::output::ListAppsOutput)
    pub fn builder() -> crate::output::list_apps_output::Builder {
        crate::output::list_apps_output::Builder::default()
    }
}

/// <p> The result structure for the get webhook request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWebhookOutput {
    /// <p> Describes the structure of a webhook. </p>
    pub webhook: std::option::Option<crate::model::Webhook>,
}
impl GetWebhookOutput {
    /// <p> Describes the structure of a webhook. </p>
    pub fn webhook(&self) -> std::option::Option<&crate::model::Webhook> {
        self.webhook.as_ref()
    }
}
impl std::fmt::Debug for GetWebhookOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWebhookOutput");
        formatter.field("webhook", &self.webhook);
        formatter.finish()
    }
}
/// See [`GetWebhookOutput`](crate::output::GetWebhookOutput)
pub mod get_webhook_output {
    /// A builder for [`GetWebhookOutput`](crate::output::GetWebhookOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook: std::option::Option<crate::model::Webhook>,
    }
    impl Builder {
        /// <p> Describes the structure of a webhook. </p>
        pub fn webhook(mut self, input: crate::model::Webhook) -> Self {
            self.webhook = Some(input);
            self
        }
        /// <p> Describes the structure of a webhook. </p>
        pub fn set_webhook(mut self, input: std::option::Option<crate::model::Webhook>) -> Self {
            self.webhook = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWebhookOutput`](crate::output::GetWebhookOutput)
        pub fn build(self) -> crate::output::GetWebhookOutput {
            crate::output::GetWebhookOutput {
                webhook: self.webhook,
            }
        }
    }
}
impl GetWebhookOutput {
    /// Creates a new builder-style object to manufacture [`GetWebhookOutput`](crate::output::GetWebhookOutput)
    pub fn builder() -> crate::output::get_webhook_output::Builder {
        crate::output::get_webhook_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobOutput {
    /// <p> Describes an execution job for an Amplify app. </p>
    pub job: std::option::Option<crate::model::Job>,
}
impl GetJobOutput {
    /// <p> Describes an execution job for an Amplify app. </p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for GetJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`GetJobOutput`](crate::output::GetJobOutput)
pub mod get_job_output {
    /// A builder for [`GetJobOutput`](crate::output::GetJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p> Describes an execution job for an Amplify app. </p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p> Describes an execution job for an Amplify app. </p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobOutput`](crate::output::GetJobOutput)
        pub fn build(self) -> crate::output::GetJobOutput {
            crate::output::GetJobOutput { job: self.job }
        }
    }
}
impl GetJobOutput {
    /// Creates a new builder-style object to manufacture [`GetJobOutput`](crate::output::GetJobOutput)
    pub fn builder() -> crate::output::get_job_output::Builder {
        crate::output::get_job_output::Builder::default()
    }
}

/// <p> The result structure for the get domain association request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainAssociationOutput {
    /// <p> Describes the structure of a domain association, which associates a custom domain
    /// with an Amplify app. </p>
    pub domain_association: std::option::Option<crate::model::DomainAssociation>,
}
impl GetDomainAssociationOutput {
    /// <p> Describes the structure of a domain association, which associates a custom domain
    /// with an Amplify app. </p>
    pub fn domain_association(&self) -> std::option::Option<&crate::model::DomainAssociation> {
        self.domain_association.as_ref()
    }
}
impl std::fmt::Debug for GetDomainAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainAssociationOutput");
        formatter.field("domain_association", &self.domain_association);
        formatter.finish()
    }
}
/// See [`GetDomainAssociationOutput`](crate::output::GetDomainAssociationOutput)
pub mod get_domain_association_output {
    /// A builder for [`GetDomainAssociationOutput`](crate::output::GetDomainAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_association: std::option::Option<crate::model::DomainAssociation>,
    }
    impl Builder {
        /// <p> Describes the structure of a domain association, which associates a custom domain
        /// with an Amplify app. </p>
        pub fn domain_association(mut self, input: crate::model::DomainAssociation) -> Self {
            self.domain_association = Some(input);
            self
        }
        /// <p> Describes the structure of a domain association, which associates a custom domain
        /// with an Amplify app. </p>
        pub fn set_domain_association(
            mut self,
            input: std::option::Option<crate::model::DomainAssociation>,
        ) -> Self {
            self.domain_association = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainAssociationOutput`](crate::output::GetDomainAssociationOutput)
        pub fn build(self) -> crate::output::GetDomainAssociationOutput {
            crate::output::GetDomainAssociationOutput {
                domain_association: self.domain_association,
            }
        }
    }
}
impl GetDomainAssociationOutput {
    /// Creates a new builder-style object to manufacture [`GetDomainAssociationOutput`](crate::output::GetDomainAssociationOutput)
    pub fn builder() -> crate::output::get_domain_association_output::Builder {
        crate::output::get_domain_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBranchOutput {
    /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
    pub branch: std::option::Option<crate::model::Branch>,
}
impl GetBranchOutput {
    /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
    pub fn branch(&self) -> std::option::Option<&crate::model::Branch> {
        self.branch.as_ref()
    }
}
impl std::fmt::Debug for GetBranchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBranchOutput");
        formatter.field("branch", &self.branch);
        formatter.finish()
    }
}
/// See [`GetBranchOutput`](crate::output::GetBranchOutput)
pub mod get_branch_output {
    /// A builder for [`GetBranchOutput`](crate::output::GetBranchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branch: std::option::Option<crate::model::Branch>,
    }
    impl Builder {
        /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
        pub fn branch(mut self, input: crate::model::Branch) -> Self {
            self.branch = Some(input);
            self
        }
        /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
        pub fn set_branch(mut self, input: std::option::Option<crate::model::Branch>) -> Self {
            self.branch = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBranchOutput`](crate::output::GetBranchOutput)
        pub fn build(self) -> crate::output::GetBranchOutput {
            crate::output::GetBranchOutput {
                branch: self.branch,
            }
        }
    }
}
impl GetBranchOutput {
    /// Creates a new builder-style object to manufacture [`GetBranchOutput`](crate::output::GetBranchOutput)
    pub fn builder() -> crate::output::get_branch_output::Builder {
        crate::output::get_branch_output::Builder::default()
    }
}

/// <p> The result structure for the get backend environment result. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackendEnvironmentOutput {
    /// <p> Describes the backend environment for an Amplify app. </p>
    pub backend_environment: std::option::Option<crate::model::BackendEnvironment>,
}
impl GetBackendEnvironmentOutput {
    /// <p> Describes the backend environment for an Amplify app. </p>
    pub fn backend_environment(&self) -> std::option::Option<&crate::model::BackendEnvironment> {
        self.backend_environment.as_ref()
    }
}
impl std::fmt::Debug for GetBackendEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackendEnvironmentOutput");
        formatter.field("backend_environment", &self.backend_environment);
        formatter.finish()
    }
}
/// See [`GetBackendEnvironmentOutput`](crate::output::GetBackendEnvironmentOutput)
pub mod get_backend_environment_output {
    /// A builder for [`GetBackendEnvironmentOutput`](crate::output::GetBackendEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backend_environment: std::option::Option<crate::model::BackendEnvironment>,
    }
    impl Builder {
        /// <p> Describes the backend environment for an Amplify app. </p>
        pub fn backend_environment(mut self, input: crate::model::BackendEnvironment) -> Self {
            self.backend_environment = Some(input);
            self
        }
        /// <p> Describes the backend environment for an Amplify app. </p>
        pub fn set_backend_environment(
            mut self,
            input: std::option::Option<crate::model::BackendEnvironment>,
        ) -> Self {
            self.backend_environment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackendEnvironmentOutput`](crate::output::GetBackendEnvironmentOutput)
        pub fn build(self) -> crate::output::GetBackendEnvironmentOutput {
            crate::output::GetBackendEnvironmentOutput {
                backend_environment: self.backend_environment,
            }
        }
    }
}
impl GetBackendEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`GetBackendEnvironmentOutput`](crate::output::GetBackendEnvironmentOutput)
    pub fn builder() -> crate::output::get_backend_environment_output::Builder {
        crate::output::get_backend_environment_output::Builder::default()
    }
}

/// <p> Returns the result structure for the get artifact request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetArtifactUrlOutput {
    /// <p> The unique ID for an artifact. </p>
    pub artifact_id: std::option::Option<std::string::String>,
    /// <p> The presigned URL for the artifact. </p>
    pub artifact_url: std::option::Option<std::string::String>,
}
impl GetArtifactUrlOutput {
    /// <p> The unique ID for an artifact. </p>
    pub fn artifact_id(&self) -> std::option::Option<&str> {
        self.artifact_id.as_deref()
    }
    /// <p> The presigned URL for the artifact. </p>
    pub fn artifact_url(&self) -> std::option::Option<&str> {
        self.artifact_url.as_deref()
    }
}
impl std::fmt::Debug for GetArtifactUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetArtifactUrlOutput");
        formatter.field("artifact_id", &self.artifact_id);
        formatter.field("artifact_url", &self.artifact_url);
        formatter.finish()
    }
}
/// See [`GetArtifactUrlOutput`](crate::output::GetArtifactUrlOutput)
pub mod get_artifact_url_output {
    /// A builder for [`GetArtifactUrlOutput`](crate::output::GetArtifactUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifact_id: std::option::Option<std::string::String>,
        pub(crate) artifact_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID for an artifact. </p>
        pub fn artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_id = Some(input.into());
            self
        }
        /// <p> The unique ID for an artifact. </p>
        pub fn set_artifact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.artifact_id = input;
            self
        }
        /// <p> The presigned URL for the artifact. </p>
        pub fn artifact_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_url = Some(input.into());
            self
        }
        /// <p> The presigned URL for the artifact. </p>
        pub fn set_artifact_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.artifact_url = input;
            self
        }
        /// Consumes the builder and constructs a [`GetArtifactUrlOutput`](crate::output::GetArtifactUrlOutput)
        pub fn build(self) -> crate::output::GetArtifactUrlOutput {
            crate::output::GetArtifactUrlOutput {
                artifact_id: self.artifact_id,
                artifact_url: self.artifact_url,
            }
        }
    }
}
impl GetArtifactUrlOutput {
    /// Creates a new builder-style object to manufacture [`GetArtifactUrlOutput`](crate::output::GetArtifactUrlOutput)
    pub fn builder() -> crate::output::get_artifact_url_output::Builder {
        crate::output::get_artifact_url_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppOutput {
    /// <p> Represents the different branches of a repository for building, deploying, and
    /// hosting an Amplify app. </p>
    pub app: std::option::Option<crate::model::App>,
}
impl GetAppOutput {
    /// <p> Represents the different branches of a repository for building, deploying, and
    /// hosting an Amplify app. </p>
    pub fn app(&self) -> std::option::Option<&crate::model::App> {
        self.app.as_ref()
    }
}
impl std::fmt::Debug for GetAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppOutput");
        formatter.field("app", &self.app);
        formatter.finish()
    }
}
/// See [`GetAppOutput`](crate::output::GetAppOutput)
pub mod get_app_output {
    /// A builder for [`GetAppOutput`](crate::output::GetAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app: std::option::Option<crate::model::App>,
    }
    impl Builder {
        /// <p> Represents the different branches of a repository for building, deploying, and
        /// hosting an Amplify app. </p>
        pub fn app(mut self, input: crate::model::App) -> Self {
            self.app = Some(input);
            self
        }
        /// <p> Represents the different branches of a repository for building, deploying, and
        /// hosting an Amplify app. </p>
        pub fn set_app(mut self, input: std::option::Option<crate::model::App>) -> Self {
            self.app = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppOutput`](crate::output::GetAppOutput)
        pub fn build(self) -> crate::output::GetAppOutput {
            crate::output::GetAppOutput { app: self.app }
        }
    }
}
impl GetAppOutput {
    /// Creates a new builder-style object to manufacture [`GetAppOutput`](crate::output::GetAppOutput)
    pub fn builder() -> crate::output::get_app_output::Builder {
        crate::output::get_app_output::Builder::default()
    }
}

/// <p> The result structure for the generate access logs request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateAccessLogsOutput {
    /// <p> The pre-signed URL for the requested access logs. </p>
    pub log_url: std::option::Option<std::string::String>,
}
impl GenerateAccessLogsOutput {
    /// <p> The pre-signed URL for the requested access logs. </p>
    pub fn log_url(&self) -> std::option::Option<&str> {
        self.log_url.as_deref()
    }
}
impl std::fmt::Debug for GenerateAccessLogsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateAccessLogsOutput");
        formatter.field("log_url", &self.log_url);
        formatter.finish()
    }
}
/// See [`GenerateAccessLogsOutput`](crate::output::GenerateAccessLogsOutput)
pub mod generate_access_logs_output {
    /// A builder for [`GenerateAccessLogsOutput`](crate::output::GenerateAccessLogsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The pre-signed URL for the requested access logs. </p>
        pub fn log_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_url = Some(input.into());
            self
        }
        /// <p> The pre-signed URL for the requested access logs. </p>
        pub fn set_log_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_url = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateAccessLogsOutput`](crate::output::GenerateAccessLogsOutput)
        pub fn build(self) -> crate::output::GenerateAccessLogsOutput {
            crate::output::GenerateAccessLogsOutput {
                log_url: self.log_url,
            }
        }
    }
}
impl GenerateAccessLogsOutput {
    /// Creates a new builder-style object to manufacture [`GenerateAccessLogsOutput`](crate::output::GenerateAccessLogsOutput)
    pub fn builder() -> crate::output::generate_access_logs_output::Builder {
        crate::output::generate_access_logs_output::Builder::default()
    }
}

/// <p> The result structure for the delete webhook request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWebhookOutput {
    /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
    pub webhook: std::option::Option<crate::model::Webhook>,
}
impl DeleteWebhookOutput {
    /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
    pub fn webhook(&self) -> std::option::Option<&crate::model::Webhook> {
        self.webhook.as_ref()
    }
}
impl std::fmt::Debug for DeleteWebhookOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWebhookOutput");
        formatter.field("webhook", &self.webhook);
        formatter.finish()
    }
}
/// See [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
pub mod delete_webhook_output {
    /// A builder for [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook: std::option::Option<crate::model::Webhook>,
    }
    impl Builder {
        /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
        pub fn webhook(mut self, input: crate::model::Webhook) -> Self {
            self.webhook = Some(input);
            self
        }
        /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
        pub fn set_webhook(mut self, input: std::option::Option<crate::model::Webhook>) -> Self {
            self.webhook = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
        pub fn build(self) -> crate::output::DeleteWebhookOutput {
            crate::output::DeleteWebhookOutput {
                webhook: self.webhook,
            }
        }
    }
}
impl DeleteWebhookOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
    pub fn builder() -> crate::output::delete_webhook_output::Builder {
        crate::output::delete_webhook_output::Builder::default()
    }
}

/// <p> The result structure for the delete job request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobOutput {
    /// <p> Describes the summary for an execution job for an Amplify app. </p>
    pub job_summary: std::option::Option<crate::model::JobSummary>,
}
impl DeleteJobOutput {
    /// <p> Describes the summary for an execution job for an Amplify app. </p>
    pub fn job_summary(&self) -> std::option::Option<&crate::model::JobSummary> {
        self.job_summary.as_ref()
    }
}
impl std::fmt::Debug for DeleteJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobOutput");
        formatter.field("job_summary", &self.job_summary);
        formatter.finish()
    }
}
/// See [`DeleteJobOutput`](crate::output::DeleteJobOutput)
pub mod delete_job_output {
    /// A builder for [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_summary: std::option::Option<crate::model::JobSummary>,
    }
    impl Builder {
        /// <p> Describes the summary for an execution job for an Amplify app. </p>
        pub fn job_summary(mut self, input: crate::model::JobSummary) -> Self {
            self.job_summary = Some(input);
            self
        }
        /// <p> Describes the summary for an execution job for an Amplify app. </p>
        pub fn set_job_summary(
            mut self,
            input: std::option::Option<crate::model::JobSummary>,
        ) -> Self {
            self.job_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobOutput`](crate::output::DeleteJobOutput)
        pub fn build(self) -> crate::output::DeleteJobOutput {
            crate::output::DeleteJobOutput {
                job_summary: self.job_summary,
            }
        }
    }
}
impl DeleteJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    pub fn builder() -> crate::output::delete_job_output::Builder {
        crate::output::delete_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainAssociationOutput {
    /// <p> Describes a domain association that associates a custom domain with an Amplify app.
    /// </p>
    pub domain_association: std::option::Option<crate::model::DomainAssociation>,
}
impl DeleteDomainAssociationOutput {
    /// <p> Describes a domain association that associates a custom domain with an Amplify app.
    /// </p>
    pub fn domain_association(&self) -> std::option::Option<&crate::model::DomainAssociation> {
        self.domain_association.as_ref()
    }
}
impl std::fmt::Debug for DeleteDomainAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainAssociationOutput");
        formatter.field("domain_association", &self.domain_association);
        formatter.finish()
    }
}
/// See [`DeleteDomainAssociationOutput`](crate::output::DeleteDomainAssociationOutput)
pub mod delete_domain_association_output {
    /// A builder for [`DeleteDomainAssociationOutput`](crate::output::DeleteDomainAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_association: std::option::Option<crate::model::DomainAssociation>,
    }
    impl Builder {
        /// <p> Describes a domain association that associates a custom domain with an Amplify app.
        /// </p>
        pub fn domain_association(mut self, input: crate::model::DomainAssociation) -> Self {
            self.domain_association = Some(input);
            self
        }
        /// <p> Describes a domain association that associates a custom domain with an Amplify app.
        /// </p>
        pub fn set_domain_association(
            mut self,
            input: std::option::Option<crate::model::DomainAssociation>,
        ) -> Self {
            self.domain_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainAssociationOutput`](crate::output::DeleteDomainAssociationOutput)
        pub fn build(self) -> crate::output::DeleteDomainAssociationOutput {
            crate::output::DeleteDomainAssociationOutput {
                domain_association: self.domain_association,
            }
        }
    }
}
impl DeleteDomainAssociationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDomainAssociationOutput`](crate::output::DeleteDomainAssociationOutput)
    pub fn builder() -> crate::output::delete_domain_association_output::Builder {
        crate::output::delete_domain_association_output::Builder::default()
    }
}

/// <p> The result structure for the delete branch request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBranchOutput {
    /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
    pub branch: std::option::Option<crate::model::Branch>,
}
impl DeleteBranchOutput {
    /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
    pub fn branch(&self) -> std::option::Option<&crate::model::Branch> {
        self.branch.as_ref()
    }
}
impl std::fmt::Debug for DeleteBranchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBranchOutput");
        formatter.field("branch", &self.branch);
        formatter.finish()
    }
}
/// See [`DeleteBranchOutput`](crate::output::DeleteBranchOutput)
pub mod delete_branch_output {
    /// A builder for [`DeleteBranchOutput`](crate::output::DeleteBranchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branch: std::option::Option<crate::model::Branch>,
    }
    impl Builder {
        /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
        pub fn branch(mut self, input: crate::model::Branch) -> Self {
            self.branch = Some(input);
            self
        }
        /// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
        pub fn set_branch(mut self, input: std::option::Option<crate::model::Branch>) -> Self {
            self.branch = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBranchOutput`](crate::output::DeleteBranchOutput)
        pub fn build(self) -> crate::output::DeleteBranchOutput {
            crate::output::DeleteBranchOutput {
                branch: self.branch,
            }
        }
    }
}
impl DeleteBranchOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBranchOutput`](crate::output::DeleteBranchOutput)
    pub fn builder() -> crate::output::delete_branch_output::Builder {
        crate::output::delete_branch_output::Builder::default()
    }
}

/// <p> The result structure of the delete backend environment result. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackendEnvironmentOutput {
    /// <p> Describes the backend environment for an Amplify app. </p>
    pub backend_environment: std::option::Option<crate::model::BackendEnvironment>,
}
impl DeleteBackendEnvironmentOutput {
    /// <p> Describes the backend environment for an Amplify app. </p>
    pub fn backend_environment(&self) -> std::option::Option<&crate::model::BackendEnvironment> {
        self.backend_environment.as_ref()
    }
}
impl std::fmt::Debug for DeleteBackendEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackendEnvironmentOutput");
        formatter.field("backend_environment", &self.backend_environment);
        formatter.finish()
    }
}
/// See [`DeleteBackendEnvironmentOutput`](crate::output::DeleteBackendEnvironmentOutput)
pub mod delete_backend_environment_output {
    /// A builder for [`DeleteBackendEnvironmentOutput`](crate::output::DeleteBackendEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backend_environment: std::option::Option<crate::model::BackendEnvironment>,
    }
    impl Builder {
        /// <p> Describes the backend environment for an Amplify app. </p>
        pub fn backend_environment(mut self, input: crate::model::BackendEnvironment) -> Self {
            self.backend_environment = Some(input);
            self
        }
        /// <p> Describes the backend environment for an Amplify app. </p>
        pub fn set_backend_environment(
            mut self,
            input: std::option::Option<crate::model::BackendEnvironment>,
        ) -> Self {
            self.backend_environment = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackendEnvironmentOutput`](crate::output::DeleteBackendEnvironmentOutput)
        pub fn build(self) -> crate::output::DeleteBackendEnvironmentOutput {
            crate::output::DeleteBackendEnvironmentOutput {
                backend_environment: self.backend_environment,
            }
        }
    }
}
impl DeleteBackendEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackendEnvironmentOutput`](crate::output::DeleteBackendEnvironmentOutput)
    pub fn builder() -> crate::output::delete_backend_environment_output::Builder {
        crate::output::delete_backend_environment_output::Builder::default()
    }
}

/// <p> The result structure for the delete app request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppOutput {
    /// <p> Represents the different branches of a repository for building, deploying, and
    /// hosting an Amplify app. </p>
    pub app: std::option::Option<crate::model::App>,
}
impl DeleteAppOutput {
    /// <p> Represents the different branches of a repository for building, deploying, and
    /// hosting an Amplify app. </p>
    pub fn app(&self) -> std::option::Option<&crate::model::App> {
        self.app.as_ref()
    }
}
impl std::fmt::Debug for DeleteAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppOutput");
        formatter.field("app", &self.app);
        formatter.finish()
    }
}
/// See [`DeleteAppOutput`](crate::output::DeleteAppOutput)
pub mod delete_app_output {
    /// A builder for [`DeleteAppOutput`](crate::output::DeleteAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app: std::option::Option<crate::model::App>,
    }
    impl Builder {
        /// <p> Represents the different branches of a repository for building, deploying, and
        /// hosting an Amplify app. </p>
        pub fn app(mut self, input: crate::model::App) -> Self {
            self.app = Some(input);
            self
        }
        /// <p> Represents the different branches of a repository for building, deploying, and
        /// hosting an Amplify app. </p>
        pub fn set_app(mut self, input: std::option::Option<crate::model::App>) -> Self {
            self.app = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppOutput`](crate::output::DeleteAppOutput)
        pub fn build(self) -> crate::output::DeleteAppOutput {
            crate::output::DeleteAppOutput { app: self.app }
        }
    }
}
impl DeleteAppOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppOutput`](crate::output::DeleteAppOutput)
    pub fn builder() -> crate::output::delete_app_output::Builder {
        crate::output::delete_app_output::Builder::default()
    }
}

/// <p> The result structure for the create webhook request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWebhookOutput {
    /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
    pub webhook: std::option::Option<crate::model::Webhook>,
}
impl CreateWebhookOutput {
    /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
    pub fn webhook(&self) -> std::option::Option<&crate::model::Webhook> {
        self.webhook.as_ref()
    }
}
impl std::fmt::Debug for CreateWebhookOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWebhookOutput");
        formatter.field("webhook", &self.webhook);
        formatter.finish()
    }
}
/// See [`CreateWebhookOutput`](crate::output::CreateWebhookOutput)
pub mod create_webhook_output {
    /// A builder for [`CreateWebhookOutput`](crate::output::CreateWebhookOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook: std::option::Option<crate::model::Webhook>,
    }
    impl Builder {
        /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
        pub fn webhook(mut self, input: crate::model::Webhook) -> Self {
            self.webhook = Some(input);
            self
        }
        /// <p> Describes a webhook that connects repository events to an Amplify app. </p>
        pub fn set_webhook(mut self, input: std::option::Option<crate::model::Webhook>) -> Self {
            self.webhook = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWebhookOutput`](crate::output::CreateWebhookOutput)
        pub fn build(self) -> crate::output::CreateWebhookOutput {
            crate::output::CreateWebhookOutput {
                webhook: self.webhook,
            }
        }
    }
}
impl CreateWebhookOutput {
    /// Creates a new builder-style object to manufacture [`CreateWebhookOutput`](crate::output::CreateWebhookOutput)
    pub fn builder() -> crate::output::create_webhook_output::Builder {
        crate::output::create_webhook_output::Builder::default()
    }
}

/// <p> The result structure for the create domain association request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainAssociationOutput {
    /// <p> Describes the structure of a domain association, which associates a custom domain
    /// with an Amplify app. </p>
    pub domain_association: std::option::Option<crate::model::DomainAssociation>,
}
impl CreateDomainAssociationOutput {
    /// <p> Describes the structure of a domain association, which associates a custom domain
    /// with an Amplify app. </p>
    pub fn domain_association(&self) -> std::option::Option<&crate::model::DomainAssociation> {
        self.domain_association.as_ref()
    }
}
impl std::fmt::Debug for CreateDomainAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainAssociationOutput");
        formatter.field("domain_association", &self.domain_association);
        formatter.finish()
    }
}
/// See [`CreateDomainAssociationOutput`](crate::output::CreateDomainAssociationOutput)
pub mod create_domain_association_output {
    /// A builder for [`CreateDomainAssociationOutput`](crate::output::CreateDomainAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_association: std::option::Option<crate::model::DomainAssociation>,
    }
    impl Builder {
        /// <p> Describes the structure of a domain association, which associates a custom domain
        /// with an Amplify app. </p>
        pub fn domain_association(mut self, input: crate::model::DomainAssociation) -> Self {
            self.domain_association = Some(input);
            self
        }
        /// <p> Describes the structure of a domain association, which associates a custom domain
        /// with an Amplify app. </p>
        pub fn set_domain_association(
            mut self,
            input: std::option::Option<crate::model::DomainAssociation>,
        ) -> Self {
            self.domain_association = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainAssociationOutput`](crate::output::CreateDomainAssociationOutput)
        pub fn build(self) -> crate::output::CreateDomainAssociationOutput {
            crate::output::CreateDomainAssociationOutput {
                domain_association: self.domain_association,
            }
        }
    }
}
impl CreateDomainAssociationOutput {
    /// Creates a new builder-style object to manufacture [`CreateDomainAssociationOutput`](crate::output::CreateDomainAssociationOutput)
    pub fn builder() -> crate::output::create_domain_association_output::Builder {
        crate::output::create_domain_association_output::Builder::default()
    }
}

/// <p> The result structure for the create a new deployment request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentOutput {
    /// <p> The job ID for this deployment. will supply to start deployment api. </p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p> When the <code>fileMap</code> argument is provided in the request,
    /// <code>fileUploadUrls</code> will contain a map of file names to upload URLs. </p>
    pub file_upload_urls:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> When the <code>fileMap</code> argument is not provided in the request, this
    /// <code>zipUploadUrl</code> is returned. </p>
    pub zip_upload_url: std::option::Option<std::string::String>,
}
impl CreateDeploymentOutput {
    /// <p> The job ID for this deployment. will supply to start deployment api. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p> When the <code>fileMap</code> argument is provided in the request,
    /// <code>fileUploadUrls</code> will contain a map of file names to upload URLs. </p>
    pub fn file_upload_urls(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.file_upload_urls.as_ref()
    }
    /// <p> When the <code>fileMap</code> argument is not provided in the request, this
    /// <code>zipUploadUrl</code> is returned. </p>
    pub fn zip_upload_url(&self) -> std::option::Option<&str> {
        self.zip_upload_url.as_deref()
    }
}
impl std::fmt::Debug for CreateDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("file_upload_urls", &self.file_upload_urls);
        formatter.field("zip_upload_url", &self.zip_upload_url);
        formatter.finish()
    }
}
/// See [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
pub mod create_deployment_output {
    /// A builder for [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) file_upload_urls: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) zip_upload_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The job ID for this deployment. will supply to start deployment api. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The job ID for this deployment. will supply to start deployment api. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Adds a key-value pair to `file_upload_urls`.
        ///
        /// To override the contents of this collection use [`set_file_upload_urls`](Self::set_file_upload_urls).
        ///
        /// <p> When the <code>fileMap</code> argument is provided in the request,
        /// <code>fileUploadUrls</code> will contain a map of file names to upload URLs. </p>
        pub fn file_upload_urls(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.file_upload_urls.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.file_upload_urls = Some(hash_map);
            self
        }
        /// <p> When the <code>fileMap</code> argument is provided in the request,
        /// <code>fileUploadUrls</code> will contain a map of file names to upload URLs. </p>
        pub fn set_file_upload_urls(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.file_upload_urls = input;
            self
        }
        /// <p> When the <code>fileMap</code> argument is not provided in the request, this
        /// <code>zipUploadUrl</code> is returned. </p>
        pub fn zip_upload_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.zip_upload_url = Some(input.into());
            self
        }
        /// <p> When the <code>fileMap</code> argument is not provided in the request, this
        /// <code>zipUploadUrl</code> is returned. </p>
        pub fn set_zip_upload_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.zip_upload_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
        pub fn build(self) -> crate::output::CreateDeploymentOutput {
            crate::output::CreateDeploymentOutput {
                job_id: self.job_id,
                file_upload_urls: self.file_upload_urls,
                zip_upload_url: self.zip_upload_url,
            }
        }
    }
}
impl CreateDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
    pub fn builder() -> crate::output::create_deployment_output::Builder {
        crate::output::create_deployment_output::Builder::default()
    }
}

/// <p> The result structure for create branch request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBranchOutput {
    /// <p> Describes the branch for an Amplify app, which maps to a third-party repository
    /// branch. </p>
    pub branch: std::option::Option<crate::model::Branch>,
}
impl CreateBranchOutput {
    /// <p> Describes the branch for an Amplify app, which maps to a third-party repository
    /// branch. </p>
    pub fn branch(&self) -> std::option::Option<&crate::model::Branch> {
        self.branch.as_ref()
    }
}
impl std::fmt::Debug for CreateBranchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBranchOutput");
        formatter.field("branch", &self.branch);
        formatter.finish()
    }
}
/// See [`CreateBranchOutput`](crate::output::CreateBranchOutput)
pub mod create_branch_output {
    /// A builder for [`CreateBranchOutput`](crate::output::CreateBranchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branch: std::option::Option<crate::model::Branch>,
    }
    impl Builder {
        /// <p> Describes the branch for an Amplify app, which maps to a third-party repository
        /// branch. </p>
        pub fn branch(mut self, input: crate::model::Branch) -> Self {
            self.branch = Some(input);
            self
        }
        /// <p> Describes the branch for an Amplify app, which maps to a third-party repository
        /// branch. </p>
        pub fn set_branch(mut self, input: std::option::Option<crate::model::Branch>) -> Self {
            self.branch = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBranchOutput`](crate::output::CreateBranchOutput)
        pub fn build(self) -> crate::output::CreateBranchOutput {
            crate::output::CreateBranchOutput {
                branch: self.branch,
            }
        }
    }
}
impl CreateBranchOutput {
    /// Creates a new builder-style object to manufacture [`CreateBranchOutput`](crate::output::CreateBranchOutput)
    pub fn builder() -> crate::output::create_branch_output::Builder {
        crate::output::create_branch_output::Builder::default()
    }
}

/// <p> The result structure for the create backend environment request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackendEnvironmentOutput {
    /// <p> Describes the backend environment for an Amplify app. </p>
    pub backend_environment: std::option::Option<crate::model::BackendEnvironment>,
}
impl CreateBackendEnvironmentOutput {
    /// <p> Describes the backend environment for an Amplify app. </p>
    pub fn backend_environment(&self) -> std::option::Option<&crate::model::BackendEnvironment> {
        self.backend_environment.as_ref()
    }
}
impl std::fmt::Debug for CreateBackendEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackendEnvironmentOutput");
        formatter.field("backend_environment", &self.backend_environment);
        formatter.finish()
    }
}
/// See [`CreateBackendEnvironmentOutput`](crate::output::CreateBackendEnvironmentOutput)
pub mod create_backend_environment_output {
    /// A builder for [`CreateBackendEnvironmentOutput`](crate::output::CreateBackendEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backend_environment: std::option::Option<crate::model::BackendEnvironment>,
    }
    impl Builder {
        /// <p> Describes the backend environment for an Amplify app. </p>
        pub fn backend_environment(mut self, input: crate::model::BackendEnvironment) -> Self {
            self.backend_environment = Some(input);
            self
        }
        /// <p> Describes the backend environment for an Amplify app. </p>
        pub fn set_backend_environment(
            mut self,
            input: std::option::Option<crate::model::BackendEnvironment>,
        ) -> Self {
            self.backend_environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackendEnvironmentOutput`](crate::output::CreateBackendEnvironmentOutput)
        pub fn build(self) -> crate::output::CreateBackendEnvironmentOutput {
            crate::output::CreateBackendEnvironmentOutput {
                backend_environment: self.backend_environment,
            }
        }
    }
}
impl CreateBackendEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackendEnvironmentOutput`](crate::output::CreateBackendEnvironmentOutput)
    pub fn builder() -> crate::output::create_backend_environment_output::Builder {
        crate::output::create_backend_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppOutput {
    /// <p> Represents the different branches of a repository for building, deploying, and
    /// hosting an Amplify app. </p>
    pub app: std::option::Option<crate::model::App>,
}
impl CreateAppOutput {
    /// <p> Represents the different branches of a repository for building, deploying, and
    /// hosting an Amplify app. </p>
    pub fn app(&self) -> std::option::Option<&crate::model::App> {
        self.app.as_ref()
    }
}
impl std::fmt::Debug for CreateAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppOutput");
        formatter.field("app", &self.app);
        formatter.finish()
    }
}
/// See [`CreateAppOutput`](crate::output::CreateAppOutput)
pub mod create_app_output {
    /// A builder for [`CreateAppOutput`](crate::output::CreateAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app: std::option::Option<crate::model::App>,
    }
    impl Builder {
        /// <p> Represents the different branches of a repository for building, deploying, and
        /// hosting an Amplify app. </p>
        pub fn app(mut self, input: crate::model::App) -> Self {
            self.app = Some(input);
            self
        }
        /// <p> Represents the different branches of a repository for building, deploying, and
        /// hosting an Amplify app. </p>
        pub fn set_app(mut self, input: std::option::Option<crate::model::App>) -> Self {
            self.app = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppOutput`](crate::output::CreateAppOutput)
        pub fn build(self) -> crate::output::CreateAppOutput {
            crate::output::CreateAppOutput { app: self.app }
        }
    }
}
impl CreateAppOutput {
    /// Creates a new builder-style object to manufacture [`CreateAppOutput`](crate::output::CreateAppOutput)
    pub fn builder() -> crate::output::create_app_output::Builder {
        crate::output::create_app_output::Builder::default()
    }
}
