// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p> Describes a webhook that connects repository events to an Amplify app. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Webhook {
    /// <p> The Amazon Resource Name (ARN) for the webhook. </p>
    pub webhook_arn: std::option::Option<std::string::String>,
    /// <p> The ID of the webhook. </p>
    pub webhook_id: std::option::Option<std::string::String>,
    /// <p> The URL of the webhook. </p>
    pub webhook_url: std::option::Option<std::string::String>,
    /// <p> The name for a branch that is part of an Amplify app. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The description for a webhook. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The create date and time for a webhook. </p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Updates the date and time for a webhook. </p>
    pub update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Webhook {
    /// <p> The Amazon Resource Name (ARN) for the webhook. </p>
    pub fn webhook_arn(&self) -> std::option::Option<&str> {
        self.webhook_arn.as_deref()
    }
    /// <p> The ID of the webhook. </p>
    pub fn webhook_id(&self) -> std::option::Option<&str> {
        self.webhook_id.as_deref()
    }
    /// <p> The URL of the webhook. </p>
    pub fn webhook_url(&self) -> std::option::Option<&str> {
        self.webhook_url.as_deref()
    }
    /// <p> The name for a branch that is part of an Amplify app. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The description for a webhook. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The create date and time for a webhook. </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_time.as_ref()
    }
    /// <p> Updates the date and time for a webhook. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for Webhook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Webhook");
        formatter.field("webhook_arn", &self.webhook_arn);
        formatter.field("webhook_id", &self.webhook_id);
        formatter.field("webhook_url", &self.webhook_url);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("description", &self.description);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`Webhook`](crate::model::Webhook)
pub mod webhook {
    /// A builder for [`Webhook`](crate::model::Webhook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook_arn: std::option::Option<std::string::String>,
        pub(crate) webhook_id: std::option::Option<std::string::String>,
        pub(crate) webhook_url: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) for the webhook. </p>
        pub fn webhook_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.webhook_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the webhook. </p>
        pub fn set_webhook_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.webhook_arn = input;
            self
        }
        /// <p> The ID of the webhook. </p>
        pub fn webhook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.webhook_id = Some(input.into());
            self
        }
        /// <p> The ID of the webhook. </p>
        pub fn set_webhook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.webhook_id = input;
            self
        }
        /// <p> The URL of the webhook. </p>
        pub fn webhook_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.webhook_url = Some(input.into());
            self
        }
        /// <p> The URL of the webhook. </p>
        pub fn set_webhook_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.webhook_url = input;
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for a branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for a webhook. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The create date and time for a webhook. </p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p> The create date and time for a webhook. </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p> Updates the date and time for a webhook. </p>
        pub fn update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p> Updates the date and time for a webhook. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Webhook`](crate::model::Webhook)
        pub fn build(self) -> crate::model::Webhook {
            crate::model::Webhook {
                webhook_arn: self.webhook_arn,
                webhook_id: self.webhook_id,
                webhook_url: self.webhook_url,
                branch_name: self.branch_name,
                description: self.description,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl Webhook {
    /// Creates a new builder-style object to manufacture [`Webhook`](crate::model::Webhook)
    pub fn builder() -> crate::model::webhook::Builder {
        crate::model::webhook::Builder::default()
    }
}

/// <p> Describes a domain association that associates a custom domain with an Amplify app.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainAssociation {
    /// <p> The Amazon Resource Name (ARN) for the domain association. </p>
    pub domain_association_arn: std::option::Option<std::string::String>,
    /// <p> The name of the domain. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> Enables the automated creation of subdomains for branches. </p>
    pub enable_auto_sub_domain: std::option::Option<bool>,
    /// <p> Sets branch patterns for automatic subdomain creation. </p>
    pub auto_sub_domain_creation_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon
    /// Resource Name (ARN) for automatically creating subdomains. </p>
    pub auto_sub_domain_iam_role: std::option::Option<std::string::String>,
    /// <p> The current status of the domain association. </p>
    pub domain_status: std::option::Option<crate::model::DomainStatus>,
    /// <p> The reason for the current status of the domain association. </p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p> The DNS record for certificate verification. </p>
    pub certificate_verification_dns_record: std::option::Option<std::string::String>,
    /// <p> The subdomains for the domain association. </p>
    pub sub_domains: std::option::Option<std::vec::Vec<crate::model::SubDomain>>,
}
impl DomainAssociation {
    /// <p> The Amazon Resource Name (ARN) for the domain association. </p>
    pub fn domain_association_arn(&self) -> std::option::Option<&str> {
        self.domain_association_arn.as_deref()
    }
    /// <p> The name of the domain. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> Enables the automated creation of subdomains for branches. </p>
    pub fn enable_auto_sub_domain(&self) -> std::option::Option<bool> {
        self.enable_auto_sub_domain
    }
    /// <p> Sets branch patterns for automatic subdomain creation. </p>
    pub fn auto_sub_domain_creation_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_sub_domain_creation_patterns.as_deref()
    }
    /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon
    /// Resource Name (ARN) for automatically creating subdomains. </p>
    pub fn auto_sub_domain_iam_role(&self) -> std::option::Option<&str> {
        self.auto_sub_domain_iam_role.as_deref()
    }
    /// <p> The current status of the domain association. </p>
    pub fn domain_status(&self) -> std::option::Option<&crate::model::DomainStatus> {
        self.domain_status.as_ref()
    }
    /// <p> The reason for the current status of the domain association. </p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p> The DNS record for certificate verification. </p>
    pub fn certificate_verification_dns_record(&self) -> std::option::Option<&str> {
        self.certificate_verification_dns_record.as_deref()
    }
    /// <p> The subdomains for the domain association. </p>
    pub fn sub_domains(&self) -> std::option::Option<&[crate::model::SubDomain]> {
        self.sub_domains.as_deref()
    }
}
impl std::fmt::Debug for DomainAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainAssociation");
        formatter.field("domain_association_arn", &self.domain_association_arn);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("enable_auto_sub_domain", &self.enable_auto_sub_domain);
        formatter.field(
            "auto_sub_domain_creation_patterns",
            &self.auto_sub_domain_creation_patterns,
        );
        formatter.field("auto_sub_domain_iam_role", &self.auto_sub_domain_iam_role);
        formatter.field("domain_status", &self.domain_status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field(
            "certificate_verification_dns_record",
            &self.certificate_verification_dns_record,
        );
        formatter.field("sub_domains", &self.sub_domains);
        formatter.finish()
    }
}
/// See [`DomainAssociation`](crate::model::DomainAssociation)
pub mod domain_association {
    /// A builder for [`DomainAssociation`](crate::model::DomainAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_association_arn: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) enable_auto_sub_domain: std::option::Option<bool>,
        pub(crate) auto_sub_domain_creation_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_sub_domain_iam_role: std::option::Option<std::string::String>,
        pub(crate) domain_status: std::option::Option<crate::model::DomainStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) certificate_verification_dns_record: std::option::Option<std::string::String>,
        pub(crate) sub_domains: std::option::Option<std::vec::Vec<crate::model::SubDomain>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) for the domain association. </p>
        pub fn domain_association_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_association_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the domain association. </p>
        pub fn set_domain_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_association_arn = input;
            self
        }
        /// <p> The name of the domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> The name of the domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn enable_auto_sub_domain(mut self, input: bool) -> Self {
            self.enable_auto_sub_domain = Some(input);
            self
        }
        /// <p> Enables the automated creation of subdomains for branches. </p>
        pub fn set_enable_auto_sub_domain(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_sub_domain = input;
            self
        }
        /// Appends an item to `auto_sub_domain_creation_patterns`.
        ///
        /// To override the contents of this collection use [`set_auto_sub_domain_creation_patterns`](Self::set_auto_sub_domain_creation_patterns).
        ///
        /// <p> Sets branch patterns for automatic subdomain creation. </p>
        pub fn auto_sub_domain_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.auto_sub_domain_creation_patterns.unwrap_or_default();
            v.push(input.into());
            self.auto_sub_domain_creation_patterns = Some(v);
            self
        }
        /// <p> Sets branch patterns for automatic subdomain creation. </p>
        pub fn set_auto_sub_domain_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_sub_domain_creation_patterns = input;
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon
        /// Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn auto_sub_domain_iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_sub_domain_iam_role = Some(input.into());
            self
        }
        /// <p> The required AWS Identity and Access Management (IAM) service role for the Amazon
        /// Resource Name (ARN) for automatically creating subdomains. </p>
        pub fn set_auto_sub_domain_iam_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_sub_domain_iam_role = input;
            self
        }
        /// <p> The current status of the domain association. </p>
        pub fn domain_status(mut self, input: crate::model::DomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p> The current status of the domain association. </p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// <p> The reason for the current status of the domain association. </p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p> The reason for the current status of the domain association. </p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p> The DNS record for certificate verification. </p>
        pub fn certificate_verification_dns_record(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.certificate_verification_dns_record = Some(input.into());
            self
        }
        /// <p> The DNS record for certificate verification. </p>
        pub fn set_certificate_verification_dns_record(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_verification_dns_record = input;
            self
        }
        /// Appends an item to `sub_domains`.
        ///
        /// To override the contents of this collection use [`set_sub_domains`](Self::set_sub_domains).
        ///
        /// <p> The subdomains for the domain association. </p>
        pub fn sub_domains(mut self, input: impl Into<crate::model::SubDomain>) -> Self {
            let mut v = self.sub_domains.unwrap_or_default();
            v.push(input.into());
            self.sub_domains = Some(v);
            self
        }
        /// <p> The subdomains for the domain association. </p>
        pub fn set_sub_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubDomain>>,
        ) -> Self {
            self.sub_domains = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainAssociation`](crate::model::DomainAssociation)
        pub fn build(self) -> crate::model::DomainAssociation {
            crate::model::DomainAssociation {
                domain_association_arn: self.domain_association_arn,
                domain_name: self.domain_name,
                enable_auto_sub_domain: self.enable_auto_sub_domain,
                auto_sub_domain_creation_patterns: self.auto_sub_domain_creation_patterns,
                auto_sub_domain_iam_role: self.auto_sub_domain_iam_role,
                domain_status: self.domain_status,
                status_reason: self.status_reason,
                certificate_verification_dns_record: self.certificate_verification_dns_record,
                sub_domains: self.sub_domains,
            }
        }
    }
}
impl DomainAssociation {
    /// Creates a new builder-style object to manufacture [`DomainAssociation`](crate::model::DomainAssociation)
    pub fn builder() -> crate::model::domain_association::Builder {
        crate::model::domain_association::Builder::default()
    }
}

/// <p> The subdomain for the domain association. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubDomain {
    /// <p> Describes the settings for the subdomain. </p>
    pub sub_domain_setting: std::option::Option<crate::model::SubDomainSetting>,
    /// <p> The verified status of the subdomain </p>
    pub verified: std::option::Option<bool>,
    /// <p> The DNS record for the subdomain. </p>
    pub dns_record: std::option::Option<std::string::String>,
}
impl SubDomain {
    /// <p> Describes the settings for the subdomain. </p>
    pub fn sub_domain_setting(&self) -> std::option::Option<&crate::model::SubDomainSetting> {
        self.sub_domain_setting.as_ref()
    }
    /// <p> The verified status of the subdomain </p>
    pub fn verified(&self) -> std::option::Option<bool> {
        self.verified
    }
    /// <p> The DNS record for the subdomain. </p>
    pub fn dns_record(&self) -> std::option::Option<&str> {
        self.dns_record.as_deref()
    }
}
impl std::fmt::Debug for SubDomain {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubDomain");
        formatter.field("sub_domain_setting", &self.sub_domain_setting);
        formatter.field("verified", &self.verified);
        formatter.field("dns_record", &self.dns_record);
        formatter.finish()
    }
}
/// See [`SubDomain`](crate::model::SubDomain)
pub mod sub_domain {
    /// A builder for [`SubDomain`](crate::model::SubDomain)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sub_domain_setting: std::option::Option<crate::model::SubDomainSetting>,
        pub(crate) verified: std::option::Option<bool>,
        pub(crate) dns_record: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Describes the settings for the subdomain. </p>
        pub fn sub_domain_setting(mut self, input: crate::model::SubDomainSetting) -> Self {
            self.sub_domain_setting = Some(input);
            self
        }
        /// <p> Describes the settings for the subdomain. </p>
        pub fn set_sub_domain_setting(
            mut self,
            input: std::option::Option<crate::model::SubDomainSetting>,
        ) -> Self {
            self.sub_domain_setting = input;
            self
        }
        /// <p> The verified status of the subdomain </p>
        pub fn verified(mut self, input: bool) -> Self {
            self.verified = Some(input);
            self
        }
        /// <p> The verified status of the subdomain </p>
        pub fn set_verified(mut self, input: std::option::Option<bool>) -> Self {
            self.verified = input;
            self
        }
        /// <p> The DNS record for the subdomain. </p>
        pub fn dns_record(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_record = Some(input.into());
            self
        }
        /// <p> The DNS record for the subdomain. </p>
        pub fn set_dns_record(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_record = input;
            self
        }
        /// Consumes the builder and constructs a [`SubDomain`](crate::model::SubDomain)
        pub fn build(self) -> crate::model::SubDomain {
            crate::model::SubDomain {
                sub_domain_setting: self.sub_domain_setting,
                verified: self.verified,
                dns_record: self.dns_record,
            }
        }
    }
}
impl SubDomain {
    /// Creates a new builder-style object to manufacture [`SubDomain`](crate::model::SubDomain)
    pub fn builder() -> crate::model::sub_domain::Builder {
        crate::model::sub_domain::Builder::default()
    }
}

/// <p> Describes the settings for the subdomain. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubDomainSetting {
    /// <p> The prefix setting for the subdomain. </p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p> The branch name setting for the subdomain. </p>
    pub branch_name: std::option::Option<std::string::String>,
}
impl SubDomainSetting {
    /// <p> The prefix setting for the subdomain. </p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p> The branch name setting for the subdomain. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
}
impl std::fmt::Debug for SubDomainSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubDomainSetting");
        formatter.field("prefix", &self.prefix);
        formatter.field("branch_name", &self.branch_name);
        formatter.finish()
    }
}
/// See [`SubDomainSetting`](crate::model::SubDomainSetting)
pub mod sub_domain_setting {
    /// A builder for [`SubDomainSetting`](crate::model::SubDomainSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The prefix setting for the subdomain. </p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p> The prefix setting for the subdomain. </p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p> The branch name setting for the subdomain. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The branch name setting for the subdomain. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SubDomainSetting`](crate::model::SubDomainSetting)
        pub fn build(self) -> crate::model::SubDomainSetting {
            crate::model::SubDomainSetting {
                prefix: self.prefix,
                branch_name: self.branch_name,
            }
        }
    }
}
impl SubDomainSetting {
    /// Creates a new builder-style object to manufacture [`SubDomainSetting`](crate::model::SubDomainSetting)
    pub fn builder() -> crate::model::sub_domain_setting::Builder {
        crate::model::sub_domain_setting::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    PendingDeployment,
    #[allow(missing_docs)] // documentation missing in model
    PendingVerification,
    #[allow(missing_docs)] // documentation missing in model
    RequestingCertificate,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DomainStatus::Available,
            "CREATING" => DomainStatus::Creating,
            "FAILED" => DomainStatus::Failed,
            "IN_PROGRESS" => DomainStatus::InProgress,
            "PENDING_DEPLOYMENT" => DomainStatus::PendingDeployment,
            "PENDING_VERIFICATION" => DomainStatus::PendingVerification,
            "REQUESTING_CERTIFICATE" => DomainStatus::RequestingCertificate,
            "UPDATING" => DomainStatus::Updating,
            other => DomainStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainStatus::from(s))
    }
}
impl DomainStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainStatus::Available => "AVAILABLE",
            DomainStatus::Creating => "CREATING",
            DomainStatus::Failed => "FAILED",
            DomainStatus::InProgress => "IN_PROGRESS",
            DomainStatus::PendingDeployment => "PENDING_DEPLOYMENT",
            DomainStatus::PendingVerification => "PENDING_VERIFICATION",
            DomainStatus::RequestingCertificate => "REQUESTING_CERTIFICATE",
            DomainStatus::Updating => "UPDATING",
            DomainStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATING",
            "FAILED",
            "IN_PROGRESS",
            "PENDING_DEPLOYMENT",
            "PENDING_VERIFICATION",
            "REQUESTING_CERTIFICATE",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for DomainStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The branch for an Amplify app, which maps to a third-party repository branch. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Branch {
    /// <p> The Amazon Resource Name (ARN) for a branch that is part of an Amplify app. </p>
    pub branch_arn: std::option::Option<std::string::String>,
    /// <p> The name for the branch that is part of an Amplify app. </p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p> The description for the branch that is part of an Amplify app. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The tag for the branch of an Amplify app. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The current stage for the branch that is part of an Amplify app. </p>
    pub stage: std::option::Option<crate::model::Stage>,
    /// <p> The display name for the branch. This is used as the default domain prefix. </p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p> Enables notifications for a branch that is part of an Amplify app. </p>
    pub enable_notification: std::option::Option<bool>,
    /// <p> The creation date and time for a branch that is part of an Amplify app. </p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The last updated date and time for a branch that is part of an Amplify app. </p>
    pub update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The environment variables specific to a branch of an Amplify app. </p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> Enables auto-building on push for a branch of an Amplify app. </p>
    pub enable_auto_build: std::option::Option<bool>,
    /// <p> The custom domains for a branch of an Amplify app. </p>
    pub custom_domains: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The framework for a branch of an Amplify app. </p>
    pub framework: std::option::Option<std::string::String>,
    /// <p> The ID of the active job for a branch of an Amplify app. </p>
    pub active_job_id: std::option::Option<std::string::String>,
    /// <p> The total number of jobs that are part of an Amplify app. </p>
    pub total_number_of_jobs: std::option::Option<std::string::String>,
    /// <p> Enables basic authorization for a branch of an Amplify app. </p>
    pub enable_basic_auth: std::option::Option<bool>,
    /// <p>Enables performance mode for the branch.</p>
    /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    pub enable_performance_mode: std::option::Option<bool>,
    /// <p> The thumbnail URL for the branch of an Amplify app. </p>
    pub thumbnail_url: std::option::Option<std::string::String>,
    /// <p> The basic authorization credentials for a branch of an Amplify app. </p>
    pub basic_auth_credentials: std::option::Option<std::string::String>,
    /// <p> The build specification (build spec) content for the branch of an Amplify app.
    /// </p>
    pub build_spec: std::option::Option<std::string::String>,
    /// <p> The content Time to Live (TTL) for the website in seconds. </p>
    pub ttl: std::option::Option<std::string::String>,
    /// <p> A list of custom resources that are linked to this branch. </p>
    pub associated_resources: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> Enables pull request previews for the branch. </p>
    pub enable_pull_request_preview: std::option::Option<bool>,
    /// <p> The Amplify environment name for the pull request. </p>
    pub pull_request_environment_name: std::option::Option<std::string::String>,
    /// <p> The destination branch if the branch is a pull request branch. </p>
    pub destination_branch: std::option::Option<std::string::String>,
    /// <p> The source branch if the branch is a pull request branch. </p>
    pub source_branch: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
    /// app. </p>
    pub backend_environment_arn: std::option::Option<std::string::String>,
}
impl Branch {
    /// <p> The Amazon Resource Name (ARN) for a branch that is part of an Amplify app. </p>
    pub fn branch_arn(&self) -> std::option::Option<&str> {
        self.branch_arn.as_deref()
    }
    /// <p> The name for the branch that is part of an Amplify app. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p> The description for the branch that is part of an Amplify app. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The tag for the branch of an Amplify app. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> The current stage for the branch that is part of an Amplify app. </p>
    pub fn stage(&self) -> std::option::Option<&crate::model::Stage> {
        self.stage.as_ref()
    }
    /// <p> The display name for the branch. This is used as the default domain prefix. </p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p> Enables notifications for a branch that is part of an Amplify app. </p>
    pub fn enable_notification(&self) -> std::option::Option<bool> {
        self.enable_notification
    }
    /// <p> The creation date and time for a branch that is part of an Amplify app. </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_time.as_ref()
    }
    /// <p> The last updated date and time for a branch that is part of an Amplify app. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.update_time.as_ref()
    }
    /// <p> The environment variables specific to a branch of an Amplify app. </p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
    /// <p> Enables auto-building on push for a branch of an Amplify app. </p>
    pub fn enable_auto_build(&self) -> std::option::Option<bool> {
        self.enable_auto_build
    }
    /// <p> The custom domains for a branch of an Amplify app. </p>
    pub fn custom_domains(&self) -> std::option::Option<&[std::string::String]> {
        self.custom_domains.as_deref()
    }
    /// <p> The framework for a branch of an Amplify app. </p>
    pub fn framework(&self) -> std::option::Option<&str> {
        self.framework.as_deref()
    }
    /// <p> The ID of the active job for a branch of an Amplify app. </p>
    pub fn active_job_id(&self) -> std::option::Option<&str> {
        self.active_job_id.as_deref()
    }
    /// <p> The total number of jobs that are part of an Amplify app. </p>
    pub fn total_number_of_jobs(&self) -> std::option::Option<&str> {
        self.total_number_of_jobs.as_deref()
    }
    /// <p> Enables basic authorization for a branch of an Amplify app. </p>
    pub fn enable_basic_auth(&self) -> std::option::Option<bool> {
        self.enable_basic_auth
    }
    /// <p>Enables performance mode for the branch.</p>
    /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    pub fn enable_performance_mode(&self) -> std::option::Option<bool> {
        self.enable_performance_mode
    }
    /// <p> The thumbnail URL for the branch of an Amplify app. </p>
    pub fn thumbnail_url(&self) -> std::option::Option<&str> {
        self.thumbnail_url.as_deref()
    }
    /// <p> The basic authorization credentials for a branch of an Amplify app. </p>
    pub fn basic_auth_credentials(&self) -> std::option::Option<&str> {
        self.basic_auth_credentials.as_deref()
    }
    /// <p> The build specification (build spec) content for the branch of an Amplify app.
    /// </p>
    pub fn build_spec(&self) -> std::option::Option<&str> {
        self.build_spec.as_deref()
    }
    /// <p> The content Time to Live (TTL) for the website in seconds. </p>
    pub fn ttl(&self) -> std::option::Option<&str> {
        self.ttl.as_deref()
    }
    /// <p> A list of custom resources that are linked to this branch. </p>
    pub fn associated_resources(&self) -> std::option::Option<&[std::string::String]> {
        self.associated_resources.as_deref()
    }
    /// <p> Enables pull request previews for the branch. </p>
    pub fn enable_pull_request_preview(&self) -> std::option::Option<bool> {
        self.enable_pull_request_preview
    }
    /// <p> The Amplify environment name for the pull request. </p>
    pub fn pull_request_environment_name(&self) -> std::option::Option<&str> {
        self.pull_request_environment_name.as_deref()
    }
    /// <p> The destination branch if the branch is a pull request branch. </p>
    pub fn destination_branch(&self) -> std::option::Option<&str> {
        self.destination_branch.as_deref()
    }
    /// <p> The source branch if the branch is a pull request branch. </p>
    pub fn source_branch(&self) -> std::option::Option<&str> {
        self.source_branch.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
    /// app. </p>
    pub fn backend_environment_arn(&self) -> std::option::Option<&str> {
        self.backend_environment_arn.as_deref()
    }
}
impl std::fmt::Debug for Branch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Branch");
        formatter.field("branch_arn", &self.branch_arn);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field("stage", &self.stage);
        formatter.field("display_name", &self.display_name);
        formatter.field("enable_notification", &self.enable_notification);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("enable_auto_build", &self.enable_auto_build);
        formatter.field("custom_domains", &self.custom_domains);
        formatter.field("framework", &self.framework);
        formatter.field("active_job_id", &self.active_job_id);
        formatter.field("total_number_of_jobs", &self.total_number_of_jobs);
        formatter.field("enable_basic_auth", &self.enable_basic_auth);
        formatter.field("enable_performance_mode", &self.enable_performance_mode);
        formatter.field("thumbnail_url", &self.thumbnail_url);
        formatter.field("basic_auth_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("build_spec", &self.build_spec);
        formatter.field("ttl", &self.ttl);
        formatter.field("associated_resources", &self.associated_resources);
        formatter.field(
            "enable_pull_request_preview",
            &self.enable_pull_request_preview,
        );
        formatter.field(
            "pull_request_environment_name",
            &self.pull_request_environment_name,
        );
        formatter.field("destination_branch", &self.destination_branch);
        formatter.field("source_branch", &self.source_branch);
        formatter.field("backend_environment_arn", &self.backend_environment_arn);
        formatter.finish()
    }
}
/// See [`Branch`](crate::model::Branch)
pub mod branch {
    /// A builder for [`Branch`](crate::model::Branch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branch_arn: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) stage: std::option::Option<crate::model::Stage>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) enable_notification: std::option::Option<bool>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) enable_auto_build: std::option::Option<bool>,
        pub(crate) custom_domains: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) framework: std::option::Option<std::string::String>,
        pub(crate) active_job_id: std::option::Option<std::string::String>,
        pub(crate) total_number_of_jobs: std::option::Option<std::string::String>,
        pub(crate) enable_basic_auth: std::option::Option<bool>,
        pub(crate) enable_performance_mode: std::option::Option<bool>,
        pub(crate) thumbnail_url: std::option::Option<std::string::String>,
        pub(crate) basic_auth_credentials: std::option::Option<std::string::String>,
        pub(crate) build_spec: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<std::string::String>,
        pub(crate) associated_resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enable_pull_request_preview: std::option::Option<bool>,
        pub(crate) pull_request_environment_name: std::option::Option<std::string::String>,
        pub(crate) destination_branch: std::option::Option<std::string::String>,
        pub(crate) source_branch: std::option::Option<std::string::String>,
        pub(crate) backend_environment_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) for a branch that is part of an Amplify app. </p>
        pub fn branch_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a branch that is part of an Amplify app. </p>
        pub fn set_branch_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_arn = input;
            self
        }
        /// <p> The name for the branch that is part of an Amplify app. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The name for the branch that is part of an Amplify app. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p> The description for the branch that is part of an Amplify app. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for the branch that is part of an Amplify app. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tag for the branch of an Amplify app. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tag for the branch of an Amplify app. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The current stage for the branch that is part of an Amplify app. </p>
        pub fn stage(mut self, input: crate::model::Stage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p> The current stage for the branch that is part of an Amplify app. </p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::Stage>) -> Self {
            self.stage = input;
            self
        }
        /// <p> The display name for the branch. This is used as the default domain prefix. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p> The display name for the branch. This is used as the default domain prefix. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p> Enables notifications for a branch that is part of an Amplify app. </p>
        pub fn enable_notification(mut self, input: bool) -> Self {
            self.enable_notification = Some(input);
            self
        }
        /// <p> Enables notifications for a branch that is part of an Amplify app. </p>
        pub fn set_enable_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_notification = input;
            self
        }
        /// <p> The creation date and time for a branch that is part of an Amplify app. </p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p> The creation date and time for a branch that is part of an Amplify app. </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p> The last updated date and time for a branch that is part of an Amplify app. </p>
        pub fn update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p> The last updated date and time for a branch that is part of an Amplify app. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables specific to a branch of an Amplify app. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p> The environment variables specific to a branch of an Amplify app. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p> Enables auto-building on push for a branch of an Amplify app. </p>
        pub fn enable_auto_build(mut self, input: bool) -> Self {
            self.enable_auto_build = Some(input);
            self
        }
        /// <p> Enables auto-building on push for a branch of an Amplify app. </p>
        pub fn set_enable_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_build = input;
            self
        }
        /// Appends an item to `custom_domains`.
        ///
        /// To override the contents of this collection use [`set_custom_domains`](Self::set_custom_domains).
        ///
        /// <p> The custom domains for a branch of an Amplify app. </p>
        pub fn custom_domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.custom_domains.unwrap_or_default();
            v.push(input.into());
            self.custom_domains = Some(v);
            self
        }
        /// <p> The custom domains for a branch of an Amplify app. </p>
        pub fn set_custom_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.custom_domains = input;
            self
        }
        /// <p> The framework for a branch of an Amplify app. </p>
        pub fn framework(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework = Some(input.into());
            self
        }
        /// <p> The framework for a branch of an Amplify app. </p>
        pub fn set_framework(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework = input;
            self
        }
        /// <p> The ID of the active job for a branch of an Amplify app. </p>
        pub fn active_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_job_id = Some(input.into());
            self
        }
        /// <p> The ID of the active job for a branch of an Amplify app. </p>
        pub fn set_active_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_job_id = input;
            self
        }
        /// <p> The total number of jobs that are part of an Amplify app. </p>
        pub fn total_number_of_jobs(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_number_of_jobs = Some(input.into());
            self
        }
        /// <p> The total number of jobs that are part of an Amplify app. </p>
        pub fn set_total_number_of_jobs(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_number_of_jobs = input;
            self
        }
        /// <p> Enables basic authorization for a branch of an Amplify app. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.enable_basic_auth = Some(input);
            self
        }
        /// <p> Enables basic authorization for a branch of an Amplify app. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_basic_auth = input;
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn enable_performance_mode(mut self, input: bool) -> Self {
            self.enable_performance_mode = Some(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn set_enable_performance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_performance_mode = input;
            self
        }
        /// <p> The thumbnail URL for the branch of an Amplify app. </p>
        pub fn thumbnail_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.thumbnail_url = Some(input.into());
            self
        }
        /// <p> The thumbnail URL for the branch of an Amplify app. </p>
        pub fn set_thumbnail_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thumbnail_url = input;
            self
        }
        /// <p> The basic authorization credentials for a branch of an Amplify app. </p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.basic_auth_credentials = Some(input.into());
            self
        }
        /// <p> The basic authorization credentials for a branch of an Amplify app. </p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.basic_auth_credentials = input;
            self
        }
        /// <p> The build specification (build spec) content for the branch of an Amplify app.
        /// </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_spec = Some(input.into());
            self
        }
        /// <p> The build specification (build spec) content for the branch of an Amplify app.
        /// </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_spec = input;
            self
        }
        /// <p> The content Time to Live (TTL) for the website in seconds. </p>
        pub fn ttl(mut self, input: impl Into<std::string::String>) -> Self {
            self.ttl = Some(input.into());
            self
        }
        /// <p> The content Time to Live (TTL) for the website in seconds. </p>
        pub fn set_ttl(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ttl = input;
            self
        }
        /// Appends an item to `associated_resources`.
        ///
        /// To override the contents of this collection use [`set_associated_resources`](Self::set_associated_resources).
        ///
        /// <p> A list of custom resources that are linked to this branch. </p>
        pub fn associated_resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.associated_resources.unwrap_or_default();
            v.push(input.into());
            self.associated_resources = Some(v);
            self
        }
        /// <p> A list of custom resources that are linked to this branch. </p>
        pub fn set_associated_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.associated_resources = input;
            self
        }
        /// <p> Enables pull request previews for the branch. </p>
        pub fn enable_pull_request_preview(mut self, input: bool) -> Self {
            self.enable_pull_request_preview = Some(input);
            self
        }
        /// <p> Enables pull request previews for the branch. </p>
        pub fn set_enable_pull_request_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_pull_request_preview = input;
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn pull_request_environment_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.pull_request_environment_name = Some(input.into());
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn set_pull_request_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_environment_name = input;
            self
        }
        /// <p> The destination branch if the branch is a pull request branch. </p>
        pub fn destination_branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_branch = Some(input.into());
            self
        }
        /// <p> The destination branch if the branch is a pull request branch. </p>
        pub fn set_destination_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_branch = input;
            self
        }
        /// <p> The source branch if the branch is a pull request branch. </p>
        pub fn source_branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_branch = Some(input.into());
            self
        }
        /// <p> The source branch if the branch is a pull request branch. </p>
        pub fn set_source_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_branch = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn backend_environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn set_backend_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Branch`](crate::model::Branch)
        pub fn build(self) -> crate::model::Branch {
            crate::model::Branch {
                branch_arn: self.branch_arn,
                branch_name: self.branch_name,
                description: self.description,
                tags: self.tags,
                stage: self.stage,
                display_name: self.display_name,
                enable_notification: self.enable_notification,
                create_time: self.create_time,
                update_time: self.update_time,
                environment_variables: self.environment_variables,
                enable_auto_build: self.enable_auto_build,
                custom_domains: self.custom_domains,
                framework: self.framework,
                active_job_id: self.active_job_id,
                total_number_of_jobs: self.total_number_of_jobs,
                enable_basic_auth: self.enable_basic_auth,
                enable_performance_mode: self.enable_performance_mode,
                thumbnail_url: self.thumbnail_url,
                basic_auth_credentials: self.basic_auth_credentials,
                build_spec: self.build_spec,
                ttl: self.ttl,
                associated_resources: self.associated_resources,
                enable_pull_request_preview: self.enable_pull_request_preview,
                pull_request_environment_name: self.pull_request_environment_name,
                destination_branch: self.destination_branch,
                source_branch: self.source_branch,
                backend_environment_arn: self.backend_environment_arn,
            }
        }
    }
}
impl Branch {
    /// Creates a new builder-style object to manufacture [`Branch`](crate::model::Branch)
    pub fn builder() -> crate::model::branch::Builder {
        crate::model::branch::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Stage {
    #[allow(missing_docs)] // documentation missing in model
    Beta,
    #[allow(missing_docs)] // documentation missing in model
    Development,
    #[allow(missing_docs)] // documentation missing in model
    Experimental,
    #[allow(missing_docs)] // documentation missing in model
    Production,
    #[allow(missing_docs)] // documentation missing in model
    PullRequest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Stage {
    fn from(s: &str) -> Self {
        match s {
            "BETA" => Stage::Beta,
            "DEVELOPMENT" => Stage::Development,
            "EXPERIMENTAL" => Stage::Experimental,
            "PRODUCTION" => Stage::Production,
            "PULL_REQUEST" => Stage::PullRequest,
            other => Stage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Stage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Stage::from(s))
    }
}
impl Stage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Stage::Beta => "BETA",
            Stage::Development => "DEVELOPMENT",
            Stage::Experimental => "EXPERIMENTAL",
            Stage::Production => "PRODUCTION",
            Stage::PullRequest => "PULL_REQUEST",
            Stage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BETA",
            "DEVELOPMENT",
            "EXPERIMENTAL",
            "PRODUCTION",
            "PULL_REQUEST",
        ]
    }
}
impl AsRef<str> for Stage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Represents the different branches of a repository for building, deploying, and
/// hosting an Amplify app. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct App {
    /// <p> The unique ID of the Amplify app. </p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the Amplify app. </p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p> The name for the Amplify app. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The tag for the Amplify app. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The description for the Amplify app. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The repository for the Amplify app. </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p> The platform for the Amplify app. </p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p> Creates a date and time for the Amplify app. </p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Updates the date and time for the Amplify app. </p>
    pub update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The AWS Identity and Access Management (IAM) service role for the Amazon Resource
    /// Name (ARN) of the Amplify app. </p>
    pub iam_service_role_arn: std::option::Option<std::string::String>,
    /// <p> The environment variables for the Amplify app. </p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The default domain for the Amplify app. </p>
    pub default_domain: std::option::Option<std::string::String>,
    /// <p> Enables the auto-building of branches for the Amplify app. </p>
    pub enable_branch_auto_build: std::option::Option<bool>,
    /// <p> Automatically disconnect a branch in the Amplify Console when you delete a branch
    /// from your Git repository. </p>
    pub enable_branch_auto_deletion: std::option::Option<bool>,
    /// <p> Enables basic authorization for the Amplify app's branches. </p>
    pub enable_basic_auth: std::option::Option<bool>,
    /// <p> The basic authorization credentials for branches for the Amplify app. </p>
    pub basic_auth_credentials: std::option::Option<std::string::String>,
    /// <p> Describes the custom redirect and rewrite rules for the Amplify app. </p>
    pub custom_rules: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
    /// <p> Describes the information about a production branch of the Amplify app. </p>
    pub production_branch: std::option::Option<crate::model::ProductionBranch>,
    /// <p> Describes the content of the build specification (build spec) for the Amplify app.
    /// </p>
    pub build_spec: std::option::Option<std::string::String>,
    /// <p>Describes the custom HTTP headers for the Amplify app.</p>
    pub custom_headers: std::option::Option<std::string::String>,
    /// <p> Enables automated branch creation for the Amplify app. </p>
    pub enable_auto_branch_creation: std::option::Option<bool>,
    /// <p> Describes the automated branch creation glob patterns for the Amplify app. </p>
    pub auto_branch_creation_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> Describes the automated branch creation configuration for the Amplify app. </p>
    pub auto_branch_creation_config: std::option::Option<crate::model::AutoBranchCreationConfig>,
}
impl App {
    /// <p> The unique ID of the Amplify app. </p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the Amplify app. </p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p> The name for the Amplify app. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The tag for the Amplify app. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> The description for the Amplify app. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The repository for the Amplify app. </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p> The platform for the Amplify app. </p>
    pub fn platform(&self) -> std::option::Option<&crate::model::Platform> {
        self.platform.as_ref()
    }
    /// <p> Creates a date and time for the Amplify app. </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_time.as_ref()
    }
    /// <p> Updates the date and time for the Amplify app. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.update_time.as_ref()
    }
    /// <p> The AWS Identity and Access Management (IAM) service role for the Amazon Resource
    /// Name (ARN) of the Amplify app. </p>
    pub fn iam_service_role_arn(&self) -> std::option::Option<&str> {
        self.iam_service_role_arn.as_deref()
    }
    /// <p> The environment variables for the Amplify app. </p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
    /// <p> The default domain for the Amplify app. </p>
    pub fn default_domain(&self) -> std::option::Option<&str> {
        self.default_domain.as_deref()
    }
    /// <p> Enables the auto-building of branches for the Amplify app. </p>
    pub fn enable_branch_auto_build(&self) -> std::option::Option<bool> {
        self.enable_branch_auto_build
    }
    /// <p> Automatically disconnect a branch in the Amplify Console when you delete a branch
    /// from your Git repository. </p>
    pub fn enable_branch_auto_deletion(&self) -> std::option::Option<bool> {
        self.enable_branch_auto_deletion
    }
    /// <p> Enables basic authorization for the Amplify app's branches. </p>
    pub fn enable_basic_auth(&self) -> std::option::Option<bool> {
        self.enable_basic_auth
    }
    /// <p> The basic authorization credentials for branches for the Amplify app. </p>
    pub fn basic_auth_credentials(&self) -> std::option::Option<&str> {
        self.basic_auth_credentials.as_deref()
    }
    /// <p> Describes the custom redirect and rewrite rules for the Amplify app. </p>
    pub fn custom_rules(&self) -> std::option::Option<&[crate::model::CustomRule]> {
        self.custom_rules.as_deref()
    }
    /// <p> Describes the information about a production branch of the Amplify app. </p>
    pub fn production_branch(&self) -> std::option::Option<&crate::model::ProductionBranch> {
        self.production_branch.as_ref()
    }
    /// <p> Describes the content of the build specification (build spec) for the Amplify app.
    /// </p>
    pub fn build_spec(&self) -> std::option::Option<&str> {
        self.build_spec.as_deref()
    }
    /// <p>Describes the custom HTTP headers for the Amplify app.</p>
    pub fn custom_headers(&self) -> std::option::Option<&str> {
        self.custom_headers.as_deref()
    }
    /// <p> Enables automated branch creation for the Amplify app. </p>
    pub fn enable_auto_branch_creation(&self) -> std::option::Option<bool> {
        self.enable_auto_branch_creation
    }
    /// <p> Describes the automated branch creation glob patterns for the Amplify app. </p>
    pub fn auto_branch_creation_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_branch_creation_patterns.as_deref()
    }
    /// <p> Describes the automated branch creation configuration for the Amplify app. </p>
    pub fn auto_branch_creation_config(
        &self,
    ) -> std::option::Option<&crate::model::AutoBranchCreationConfig> {
        self.auto_branch_creation_config.as_ref()
    }
}
impl std::fmt::Debug for App {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("App");
        formatter.field("app_id", &self.app_id);
        formatter.field("app_arn", &self.app_arn);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.field("description", &self.description);
        formatter.field("repository", &self.repository);
        formatter.field("platform", &self.platform);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.field("iam_service_role_arn", &self.iam_service_role_arn);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("default_domain", &self.default_domain);
        formatter.field("enable_branch_auto_build", &self.enable_branch_auto_build);
        formatter.field(
            "enable_branch_auto_deletion",
            &self.enable_branch_auto_deletion,
        );
        formatter.field("enable_basic_auth", &self.enable_basic_auth);
        formatter.field("basic_auth_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("custom_rules", &self.custom_rules);
        formatter.field("production_branch", &self.production_branch);
        formatter.field("build_spec", &self.build_spec);
        formatter.field("custom_headers", &self.custom_headers);
        formatter.field(
            "enable_auto_branch_creation",
            &self.enable_auto_branch_creation,
        );
        formatter.field(
            "auto_branch_creation_patterns",
            &self.auto_branch_creation_patterns,
        );
        formatter.field(
            "auto_branch_creation_config",
            &self.auto_branch_creation_config,
        );
        formatter.finish()
    }
}
/// See [`App`](crate::model::App)
pub mod app {
    /// A builder for [`App`](crate::model::App)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) iam_service_role_arn: std::option::Option<std::string::String>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) default_domain: std::option::Option<std::string::String>,
        pub(crate) enable_branch_auto_build: std::option::Option<bool>,
        pub(crate) enable_branch_auto_deletion: std::option::Option<bool>,
        pub(crate) enable_basic_auth: std::option::Option<bool>,
        pub(crate) basic_auth_credentials: std::option::Option<std::string::String>,
        pub(crate) custom_rules: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        pub(crate) production_branch: std::option::Option<crate::model::ProductionBranch>,
        pub(crate) build_spec: std::option::Option<std::string::String>,
        pub(crate) custom_headers: std::option::Option<std::string::String>,
        pub(crate) enable_auto_branch_creation: std::option::Option<bool>,
        pub(crate) auto_branch_creation_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_branch_creation_config:
            std::option::Option<crate::model::AutoBranchCreationConfig>,
    }
    impl Builder {
        /// <p> The unique ID of the Amplify app. </p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p> The unique ID of the Amplify app. </p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amplify app. </p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amplify app. </p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p> The name for the Amplify app. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name for the Amplify app. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tag for the Amplify app. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tag for the Amplify app. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The description for the Amplify app. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for the Amplify app. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The repository for the Amplify app. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p> The repository for the Amplify app. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p> The platform for the Amplify app. </p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p> The platform for the Amplify app. </p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p> Creates a date and time for the Amplify app. </p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p> Creates a date and time for the Amplify app. </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p> Updates the date and time for the Amplify app. </p>
        pub fn update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p> Updates the date and time for the Amplify app. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for the Amazon Resource
        /// Name (ARN) of the Amplify app. </p>
        pub fn iam_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_service_role_arn = Some(input.into());
            self
        }
        /// <p> The AWS Identity and Access Management (IAM) service role for the Amazon Resource
        /// Name (ARN) of the Amplify app. </p>
        pub fn set_iam_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_service_role_arn = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for the Amplify app. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p> The environment variables for the Amplify app. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p> The default domain for the Amplify app. </p>
        pub fn default_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_domain = Some(input.into());
            self
        }
        /// <p> The default domain for the Amplify app. </p>
        pub fn set_default_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_domain = input;
            self
        }
        /// <p> Enables the auto-building of branches for the Amplify app. </p>
        pub fn enable_branch_auto_build(mut self, input: bool) -> Self {
            self.enable_branch_auto_build = Some(input);
            self
        }
        /// <p> Enables the auto-building of branches for the Amplify app. </p>
        pub fn set_enable_branch_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_branch_auto_build = input;
            self
        }
        /// <p> Automatically disconnect a branch in the Amplify Console when you delete a branch
        /// from your Git repository. </p>
        pub fn enable_branch_auto_deletion(mut self, input: bool) -> Self {
            self.enable_branch_auto_deletion = Some(input);
            self
        }
        /// <p> Automatically disconnect a branch in the Amplify Console when you delete a branch
        /// from your Git repository. </p>
        pub fn set_enable_branch_auto_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_branch_auto_deletion = input;
            self
        }
        /// <p> Enables basic authorization for the Amplify app's branches. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.enable_basic_auth = Some(input);
            self
        }
        /// <p> Enables basic authorization for the Amplify app's branches. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_basic_auth = input;
            self
        }
        /// <p> The basic authorization credentials for branches for the Amplify app. </p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.basic_auth_credentials = Some(input.into());
            self
        }
        /// <p> The basic authorization credentials for branches for the Amplify app. </p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.basic_auth_credentials = input;
            self
        }
        /// Appends an item to `custom_rules`.
        ///
        /// To override the contents of this collection use [`set_custom_rules`](Self::set_custom_rules).
        ///
        /// <p> Describes the custom redirect and rewrite rules for the Amplify app. </p>
        pub fn custom_rules(mut self, input: impl Into<crate::model::CustomRule>) -> Self {
            let mut v = self.custom_rules.unwrap_or_default();
            v.push(input.into());
            self.custom_rules = Some(v);
            self
        }
        /// <p> Describes the custom redirect and rewrite rules for the Amplify app. </p>
        pub fn set_custom_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomRule>>,
        ) -> Self {
            self.custom_rules = input;
            self
        }
        /// <p> Describes the information about a production branch of the Amplify app. </p>
        pub fn production_branch(mut self, input: crate::model::ProductionBranch) -> Self {
            self.production_branch = Some(input);
            self
        }
        /// <p> Describes the information about a production branch of the Amplify app. </p>
        pub fn set_production_branch(
            mut self,
            input: std::option::Option<crate::model::ProductionBranch>,
        ) -> Self {
            self.production_branch = input;
            self
        }
        /// <p> Describes the content of the build specification (build spec) for the Amplify app.
        /// </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_spec = Some(input.into());
            self
        }
        /// <p> Describes the content of the build specification (build spec) for the Amplify app.
        /// </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_spec = input;
            self
        }
        /// <p>Describes the custom HTTP headers for the Amplify app.</p>
        pub fn custom_headers(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_headers = Some(input.into());
            self
        }
        /// <p>Describes the custom HTTP headers for the Amplify app.</p>
        pub fn set_custom_headers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_headers = input;
            self
        }
        /// <p> Enables automated branch creation for the Amplify app. </p>
        pub fn enable_auto_branch_creation(mut self, input: bool) -> Self {
            self.enable_auto_branch_creation = Some(input);
            self
        }
        /// <p> Enables automated branch creation for the Amplify app. </p>
        pub fn set_enable_auto_branch_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_branch_creation = input;
            self
        }
        /// Appends an item to `auto_branch_creation_patterns`.
        ///
        /// To override the contents of this collection use [`set_auto_branch_creation_patterns`](Self::set_auto_branch_creation_patterns).
        ///
        /// <p> Describes the automated branch creation glob patterns for the Amplify app. </p>
        pub fn auto_branch_creation_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.auto_branch_creation_patterns.unwrap_or_default();
            v.push(input.into());
            self.auto_branch_creation_patterns = Some(v);
            self
        }
        /// <p> Describes the automated branch creation glob patterns for the Amplify app. </p>
        pub fn set_auto_branch_creation_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_branch_creation_patterns = input;
            self
        }
        /// <p> Describes the automated branch creation configuration for the Amplify app. </p>
        pub fn auto_branch_creation_config(
            mut self,
            input: crate::model::AutoBranchCreationConfig,
        ) -> Self {
            self.auto_branch_creation_config = Some(input);
            self
        }
        /// <p> Describes the automated branch creation configuration for the Amplify app. </p>
        pub fn set_auto_branch_creation_config(
            mut self,
            input: std::option::Option<crate::model::AutoBranchCreationConfig>,
        ) -> Self {
            self.auto_branch_creation_config = input;
            self
        }
        /// Consumes the builder and constructs a [`App`](crate::model::App)
        pub fn build(self) -> crate::model::App {
            crate::model::App {
                app_id: self.app_id,
                app_arn: self.app_arn,
                name: self.name,
                tags: self.tags,
                description: self.description,
                repository: self.repository,
                platform: self.platform,
                create_time: self.create_time,
                update_time: self.update_time,
                iam_service_role_arn: self.iam_service_role_arn,
                environment_variables: self.environment_variables,
                default_domain: self.default_domain,
                enable_branch_auto_build: self.enable_branch_auto_build,
                enable_branch_auto_deletion: self.enable_branch_auto_deletion,
                enable_basic_auth: self.enable_basic_auth,
                basic_auth_credentials: self.basic_auth_credentials,
                custom_rules: self.custom_rules,
                production_branch: self.production_branch,
                build_spec: self.build_spec,
                custom_headers: self.custom_headers,
                enable_auto_branch_creation: self.enable_auto_branch_creation,
                auto_branch_creation_patterns: self.auto_branch_creation_patterns,
                auto_branch_creation_config: self.auto_branch_creation_config,
            }
        }
    }
}
impl App {
    /// Creates a new builder-style object to manufacture [`App`](crate::model::App)
    pub fn builder() -> crate::model::app::Builder {
        crate::model::app::Builder::default()
    }
}

/// <p> Describes the automated branch creation configuration. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoBranchCreationConfig {
    /// <p> Describes the current stage for the autocreated branch. </p>
    pub stage: std::option::Option<crate::model::Stage>,
    /// <p> The framework for the autocreated branch. </p>
    pub framework: std::option::Option<std::string::String>,
    /// <p> Enables auto building for the autocreated branch. </p>
    pub enable_auto_build: std::option::Option<bool>,
    /// <p> The environment variables for the autocreated branch. </p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The basic authorization credentials for the autocreated branch. </p>
    pub basic_auth_credentials: std::option::Option<std::string::String>,
    /// <p> Enables basic authorization for the autocreated branch. </p>
    pub enable_basic_auth: std::option::Option<bool>,
    /// <p>Enables performance mode for the branch.</p>
    /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    pub enable_performance_mode: std::option::Option<bool>,
    /// <p> The build specification (build spec) for the autocreated branch. </p>
    pub build_spec: std::option::Option<std::string::String>,
    /// <p> Enables pull request previews for the autocreated branch. </p>
    pub enable_pull_request_preview: std::option::Option<bool>,
    /// <p> The Amplify environment name for the pull request. </p>
    pub pull_request_environment_name: std::option::Option<std::string::String>,
}
impl AutoBranchCreationConfig {
    /// <p> Describes the current stage for the autocreated branch. </p>
    pub fn stage(&self) -> std::option::Option<&crate::model::Stage> {
        self.stage.as_ref()
    }
    /// <p> The framework for the autocreated branch. </p>
    pub fn framework(&self) -> std::option::Option<&str> {
        self.framework.as_deref()
    }
    /// <p> Enables auto building for the autocreated branch. </p>
    pub fn enable_auto_build(&self) -> std::option::Option<bool> {
        self.enable_auto_build
    }
    /// <p> The environment variables for the autocreated branch. </p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
    /// <p> The basic authorization credentials for the autocreated branch. </p>
    pub fn basic_auth_credentials(&self) -> std::option::Option<&str> {
        self.basic_auth_credentials.as_deref()
    }
    /// <p> Enables basic authorization for the autocreated branch. </p>
    pub fn enable_basic_auth(&self) -> std::option::Option<bool> {
        self.enable_basic_auth
    }
    /// <p>Enables performance mode for the branch.</p>
    /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
    pub fn enable_performance_mode(&self) -> std::option::Option<bool> {
        self.enable_performance_mode
    }
    /// <p> The build specification (build spec) for the autocreated branch. </p>
    pub fn build_spec(&self) -> std::option::Option<&str> {
        self.build_spec.as_deref()
    }
    /// <p> Enables pull request previews for the autocreated branch. </p>
    pub fn enable_pull_request_preview(&self) -> std::option::Option<bool> {
        self.enable_pull_request_preview
    }
    /// <p> The Amplify environment name for the pull request. </p>
    pub fn pull_request_environment_name(&self) -> std::option::Option<&str> {
        self.pull_request_environment_name.as_deref()
    }
}
impl std::fmt::Debug for AutoBranchCreationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoBranchCreationConfig");
        formatter.field("stage", &self.stage);
        formatter.field("framework", &self.framework);
        formatter.field("enable_auto_build", &self.enable_auto_build);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("basic_auth_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("enable_basic_auth", &self.enable_basic_auth);
        formatter.field("enable_performance_mode", &self.enable_performance_mode);
        formatter.field("build_spec", &self.build_spec);
        formatter.field(
            "enable_pull_request_preview",
            &self.enable_pull_request_preview,
        );
        formatter.field(
            "pull_request_environment_name",
            &self.pull_request_environment_name,
        );
        formatter.finish()
    }
}
/// See [`AutoBranchCreationConfig`](crate::model::AutoBranchCreationConfig)
pub mod auto_branch_creation_config {
    /// A builder for [`AutoBranchCreationConfig`](crate::model::AutoBranchCreationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stage: std::option::Option<crate::model::Stage>,
        pub(crate) framework: std::option::Option<std::string::String>,
        pub(crate) enable_auto_build: std::option::Option<bool>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) basic_auth_credentials: std::option::Option<std::string::String>,
        pub(crate) enable_basic_auth: std::option::Option<bool>,
        pub(crate) enable_performance_mode: std::option::Option<bool>,
        pub(crate) build_spec: std::option::Option<std::string::String>,
        pub(crate) enable_pull_request_preview: std::option::Option<bool>,
        pub(crate) pull_request_environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Describes the current stage for the autocreated branch. </p>
        pub fn stage(mut self, input: crate::model::Stage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p> Describes the current stage for the autocreated branch. </p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::Stage>) -> Self {
            self.stage = input;
            self
        }
        /// <p> The framework for the autocreated branch. </p>
        pub fn framework(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework = Some(input.into());
            self
        }
        /// <p> The framework for the autocreated branch. </p>
        pub fn set_framework(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework = input;
            self
        }
        /// <p> Enables auto building for the autocreated branch. </p>
        pub fn enable_auto_build(mut self, input: bool) -> Self {
            self.enable_auto_build = Some(input);
            self
        }
        /// <p> Enables auto building for the autocreated branch. </p>
        pub fn set_enable_auto_build(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_build = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p> The environment variables for the autocreated branch. </p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p> The environment variables for the autocreated branch. </p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p> The basic authorization credentials for the autocreated branch. </p>
        pub fn basic_auth_credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.basic_auth_credentials = Some(input.into());
            self
        }
        /// <p> The basic authorization credentials for the autocreated branch. </p>
        pub fn set_basic_auth_credentials(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.basic_auth_credentials = input;
            self
        }
        /// <p> Enables basic authorization for the autocreated branch. </p>
        pub fn enable_basic_auth(mut self, input: bool) -> Self {
            self.enable_basic_auth = Some(input);
            self
        }
        /// <p> Enables basic authorization for the autocreated branch. </p>
        pub fn set_enable_basic_auth(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_basic_auth = input;
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn enable_performance_mode(mut self, input: bool) -> Self {
            self.enable_performance_mode = Some(input);
            self
        }
        /// <p>Enables performance mode for the branch.</p>
        /// <p>Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. </p>
        pub fn set_enable_performance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_performance_mode = input;
            self
        }
        /// <p> The build specification (build spec) for the autocreated branch. </p>
        pub fn build_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_spec = Some(input.into());
            self
        }
        /// <p> The build specification (build spec) for the autocreated branch. </p>
        pub fn set_build_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_spec = input;
            self
        }
        /// <p> Enables pull request previews for the autocreated branch. </p>
        pub fn enable_pull_request_preview(mut self, input: bool) -> Self {
            self.enable_pull_request_preview = Some(input);
            self
        }
        /// <p> Enables pull request previews for the autocreated branch. </p>
        pub fn set_enable_pull_request_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_pull_request_preview = input;
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn pull_request_environment_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.pull_request_environment_name = Some(input.into());
            self
        }
        /// <p> The Amplify environment name for the pull request. </p>
        pub fn set_pull_request_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoBranchCreationConfig`](crate::model::AutoBranchCreationConfig)
        pub fn build(self) -> crate::model::AutoBranchCreationConfig {
            crate::model::AutoBranchCreationConfig {
                stage: self.stage,
                framework: self.framework,
                enable_auto_build: self.enable_auto_build,
                environment_variables: self.environment_variables,
                basic_auth_credentials: self.basic_auth_credentials,
                enable_basic_auth: self.enable_basic_auth,
                enable_performance_mode: self.enable_performance_mode,
                build_spec: self.build_spec,
                enable_pull_request_preview: self.enable_pull_request_preview,
                pull_request_environment_name: self.pull_request_environment_name,
            }
        }
    }
}
impl AutoBranchCreationConfig {
    /// Creates a new builder-style object to manufacture [`AutoBranchCreationConfig`](crate::model::AutoBranchCreationConfig)
    pub fn builder() -> crate::model::auto_branch_creation_config::Builder {
        crate::model::auto_branch_creation_config::Builder::default()
    }
}

/// <p> Describes the information about a production branch for an Amplify app. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductionBranch {
    /// <p> The last deploy time of the production branch. </p>
    pub last_deploy_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The status of the production branch. </p>
    pub status: std::option::Option<std::string::String>,
    /// <p> The thumbnail URL for the production branch. </p>
    pub thumbnail_url: std::option::Option<std::string::String>,
    /// <p> The branch name for the production branch. </p>
    pub branch_name: std::option::Option<std::string::String>,
}
impl ProductionBranch {
    /// <p> The last deploy time of the production branch. </p>
    pub fn last_deploy_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_deploy_time.as_ref()
    }
    /// <p> The status of the production branch. </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p> The thumbnail URL for the production branch. </p>
    pub fn thumbnail_url(&self) -> std::option::Option<&str> {
        self.thumbnail_url.as_deref()
    }
    /// <p> The branch name for the production branch. </p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
}
impl std::fmt::Debug for ProductionBranch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductionBranch");
        formatter.field("last_deploy_time", &self.last_deploy_time);
        formatter.field("status", &self.status);
        formatter.field("thumbnail_url", &self.thumbnail_url);
        formatter.field("branch_name", &self.branch_name);
        formatter.finish()
    }
}
/// See [`ProductionBranch`](crate::model::ProductionBranch)
pub mod production_branch {
    /// A builder for [`ProductionBranch`](crate::model::ProductionBranch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_deploy_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) thumbnail_url: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The last deploy time of the production branch. </p>
        pub fn last_deploy_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_deploy_time = Some(input);
            self
        }
        /// <p> The last deploy time of the production branch. </p>
        pub fn set_last_deploy_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_deploy_time = input;
            self
        }
        /// <p> The status of the production branch. </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p> The status of the production branch. </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p> The thumbnail URL for the production branch. </p>
        pub fn thumbnail_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.thumbnail_url = Some(input.into());
            self
        }
        /// <p> The thumbnail URL for the production branch. </p>
        pub fn set_thumbnail_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thumbnail_url = input;
            self
        }
        /// <p> The branch name for the production branch. </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p> The branch name for the production branch. </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductionBranch`](crate::model::ProductionBranch)
        pub fn build(self) -> crate::model::ProductionBranch {
            crate::model::ProductionBranch {
                last_deploy_time: self.last_deploy_time,
                status: self.status,
                thumbnail_url: self.thumbnail_url,
                branch_name: self.branch_name,
            }
        }
    }
}
impl ProductionBranch {
    /// Creates a new builder-style object to manufacture [`ProductionBranch`](crate::model::ProductionBranch)
    pub fn builder() -> crate::model::production_branch::Builder {
        crate::model::production_branch::Builder::default()
    }
}

/// <p> Describes a custom rewrite or redirect rule. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomRule {
    /// <p> The source pattern for a URL rewrite or redirect rule. </p>
    pub source: std::option::Option<std::string::String>,
    /// <p> The target pattern for a URL rewrite or redirect rule. </p>
    pub target: std::option::Option<std::string::String>,
    /// <p> The status code for a URL rewrite or redirect rule. </p>
    ///
    /// <dl>
    /// <dt>200</dt>
    /// <dd>
    /// <p>Represents a 200 rewrite rule.</p>
    /// </dd>
    /// <dt>301</dt>
    /// <dd>
    /// <p>Represents a 301 (moved pemanently) redirect rule. This and all future requests should be directed to the target URL. </p>
    /// </dd>
    /// <dt>302</dt>
    /// <dd>
    /// <p>Represents a 302 temporary redirect rule.</p>
    /// </dd>
    /// <dt>404</dt>
    /// <dd>
    /// <p>Represents a 404 redirect rule.</p>
    /// </dd>
    /// <dt>404-200</dt>
    /// <dd>
    /// <p>Represents a 404 rewrite rule.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<std::string::String>,
    /// <p> The condition for a URL rewrite or redirect rule, such as a country code. </p>
    pub condition: std::option::Option<std::string::String>,
}
impl CustomRule {
    /// <p> The source pattern for a URL rewrite or redirect rule. </p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p> The target pattern for a URL rewrite or redirect rule. </p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
    /// <p> The status code for a URL rewrite or redirect rule. </p>
    ///
    /// <dl>
    /// <dt>200</dt>
    /// <dd>
    /// <p>Represents a 200 rewrite rule.</p>
    /// </dd>
    /// <dt>301</dt>
    /// <dd>
    /// <p>Represents a 301 (moved pemanently) redirect rule. This and all future requests should be directed to the target URL. </p>
    /// </dd>
    /// <dt>302</dt>
    /// <dd>
    /// <p>Represents a 302 temporary redirect rule.</p>
    /// </dd>
    /// <dt>404</dt>
    /// <dd>
    /// <p>Represents a 404 redirect rule.</p>
    /// </dd>
    /// <dt>404-200</dt>
    /// <dd>
    /// <p>Represents a 404 rewrite rule.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p> The condition for a URL rewrite or redirect rule, such as a country code. </p>
    pub fn condition(&self) -> std::option::Option<&str> {
        self.condition.as_deref()
    }
}
impl std::fmt::Debug for CustomRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomRule");
        formatter.field("source", &self.source);
        formatter.field("target", &self.target);
        formatter.field("status", &self.status);
        formatter.field("condition", &self.condition);
        formatter.finish()
    }
}
/// See [`CustomRule`](crate::model::CustomRule)
pub mod custom_rule {
    /// A builder for [`CustomRule`](crate::model::CustomRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) condition: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The source pattern for a URL rewrite or redirect rule. </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p> The source pattern for a URL rewrite or redirect rule. </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p> The target pattern for a URL rewrite or redirect rule. </p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p> The target pattern for a URL rewrite or redirect rule. </p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p> The status code for a URL rewrite or redirect rule. </p>
        ///
        /// <dl>
        /// <dt>200</dt>
        /// <dd>
        /// <p>Represents a 200 rewrite rule.</p>
        /// </dd>
        /// <dt>301</dt>
        /// <dd>
        /// <p>Represents a 301 (moved pemanently) redirect rule. This and all future requests should be directed to the target URL. </p>
        /// </dd>
        /// <dt>302</dt>
        /// <dd>
        /// <p>Represents a 302 temporary redirect rule.</p>
        /// </dd>
        /// <dt>404</dt>
        /// <dd>
        /// <p>Represents a 404 redirect rule.</p>
        /// </dd>
        /// <dt>404-200</dt>
        /// <dd>
        /// <p>Represents a 404 rewrite rule.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p> The status code for a URL rewrite or redirect rule. </p>
        ///
        /// <dl>
        /// <dt>200</dt>
        /// <dd>
        /// <p>Represents a 200 rewrite rule.</p>
        /// </dd>
        /// <dt>301</dt>
        /// <dd>
        /// <p>Represents a 301 (moved pemanently) redirect rule. This and all future requests should be directed to the target URL. </p>
        /// </dd>
        /// <dt>302</dt>
        /// <dd>
        /// <p>Represents a 302 temporary redirect rule.</p>
        /// </dd>
        /// <dt>404</dt>
        /// <dd>
        /// <p>Represents a 404 redirect rule.</p>
        /// </dd>
        /// <dt>404-200</dt>
        /// <dd>
        /// <p>Represents a 404 rewrite rule.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p> The condition for a URL rewrite or redirect rule, such as a country code. </p>
        pub fn condition(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition = Some(input.into());
            self
        }
        /// <p> The condition for a URL rewrite or redirect rule, such as a country code. </p>
        pub fn set_condition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.condition = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomRule`](crate::model::CustomRule)
        pub fn build(self) -> crate::model::CustomRule {
            crate::model::CustomRule {
                source: self.source,
                target: self.target,
                status: self.status,
                condition: self.condition,
            }
        }
    }
}
impl CustomRule {
    /// Creates a new builder-style object to manufacture [`CustomRule`](crate::model::CustomRule)
    pub fn builder() -> crate::model::custom_rule::Builder {
        crate::model::custom_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Platform {
    #[allow(missing_docs)] // documentation missing in model
    Web,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Platform {
    fn from(s: &str) -> Self {
        match s {
            "WEB" => Platform::Web,
            other => Platform::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Platform {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Platform::from(s))
    }
}
impl Platform {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Platform::Web => "WEB",
            Platform::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["WEB"]
    }
}
impl AsRef<str> for Platform {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Describes the summary for an execution job for an Amplify app. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobSummary {
    /// <p> The Amazon Resource Name (ARN) for the job. </p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p> The unique ID for the job. </p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p> The commit ID from a third-party repository provider for the job. </p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p> The commit message from a third-party repository provider for the job. </p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p> The commit date and time for the job. </p>
    pub commit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The start date and time for the job. </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The current status for the job. </p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p> The end date and time for the job. </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The type for the job. If the value is <code>RELEASE</code>, the job was manually
    /// released from its source by using the <code>StartJob</code> API. If the value is
    /// <code>RETRY</code>, the job was manually retried using the <code>StartJob</code>
    /// API. If the value is <code>WEB_HOOK</code>, the job was automatically triggered by
    /// webhooks. </p>
    pub job_type: std::option::Option<crate::model::JobType>,
}
impl JobSummary {
    /// <p> The Amazon Resource Name (ARN) for the job. </p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p> The unique ID for the job. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p> The commit ID from a third-party repository provider for the job. </p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p> The commit message from a third-party repository provider for the job. </p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p> The commit date and time for the job. </p>
    pub fn commit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.commit_time.as_ref()
    }
    /// <p> The start date and time for the job. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p> The current status for the job. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
    /// <p> The end date and time for the job. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p> The type for the job. If the value is <code>RELEASE</code>, the job was manually
    /// released from its source by using the <code>StartJob</code> API. If the value is
    /// <code>RETRY</code>, the job was manually retried using the <code>StartJob</code>
    /// API. If the value is <code>WEB_HOOK</code>, the job was automatically triggered by
    /// webhooks. </p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
}
impl std::fmt::Debug for JobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobSummary");
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_id", &self.job_id);
        formatter.field("commit_id", &self.commit_id);
        formatter.field("commit_message", &self.commit_message);
        formatter.field("commit_time", &self.commit_time);
        formatter.field("start_time", &self.start_time);
        formatter.field("status", &self.status);
        formatter.field("end_time", &self.end_time);
        formatter.field("job_type", &self.job_type);
        formatter.finish()
    }
}
/// See [`JobSummary`](crate::model::JobSummary)
pub mod job_summary {
    /// A builder for [`JobSummary`](crate::model::JobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) commit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) for the job. </p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the job. </p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The unique ID for the job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p> The commit ID from a third-party repository provider for the job. </p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p> The commit ID from a third-party repository provider for the job. </p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p> The commit message from a third-party repository provider for the job. </p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p> The commit message from a third-party repository provider for the job. </p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p> The commit date and time for the job. </p>
        pub fn commit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.commit_time = Some(input);
            self
        }
        /// <p> The commit date and time for the job. </p>
        pub fn set_commit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.commit_time = input;
            self
        }
        /// <p> The start date and time for the job. </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> The start date and time for the job. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The current status for the job. </p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The current status for the job. </p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p> The end date and time for the job. </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> The end date and time for the job. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p> The type for the job. If the value is <code>RELEASE</code>, the job was manually
        /// released from its source by using the <code>StartJob</code> API. If the value is
        /// <code>RETRY</code>, the job was manually retried using the <code>StartJob</code>
        /// API. If the value is <code>WEB_HOOK</code>, the job was automatically triggered by
        /// webhooks. </p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p> The type for the job. If the value is <code>RELEASE</code>, the job was manually
        /// released from its source by using the <code>StartJob</code> API. If the value is
        /// <code>RETRY</code>, the job was manually retried using the <code>StartJob</code>
        /// API. If the value is <code>WEB_HOOK</code>, the job was automatically triggered by
        /// webhooks. </p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// Consumes the builder and constructs a [`JobSummary`](crate::model::JobSummary)
        pub fn build(self) -> crate::model::JobSummary {
            crate::model::JobSummary {
                job_arn: self.job_arn,
                job_id: self.job_id,
                commit_id: self.commit_id,
                commit_message: self.commit_message,
                commit_time: self.commit_time,
                start_time: self.start_time,
                status: self.status,
                end_time: self.end_time,
                job_type: self.job_type,
            }
        }
    }
}
impl JobSummary {
    /// Creates a new builder-style object to manufacture [`JobSummary`](crate::model::JobSummary)
    pub fn builder() -> crate::model::job_summary::Builder {
        crate::model::job_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobType {
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    #[allow(missing_docs)] // documentation missing in model
    Release,
    #[allow(missing_docs)] // documentation missing in model
    Retry,
    #[allow(missing_docs)] // documentation missing in model
    WebHook,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobType {
    fn from(s: &str) -> Self {
        match s {
            "MANUAL" => JobType::Manual,
            "RELEASE" => JobType::Release,
            "RETRY" => JobType::Retry,
            "WEB_HOOK" => JobType::WebHook,
            other => JobType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobType::from(s))
    }
}
impl JobType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobType::Manual => "MANUAL",
            JobType::Release => "RELEASE",
            JobType::Retry => "RETRY",
            JobType::WebHook => "WEB_HOOK",
            JobType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MANUAL", "RELEASE", "RETRY", "WEB_HOOK"]
    }
}
impl AsRef<str> for JobType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Provisioning,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => JobStatus::Cancelled,
            "CANCELLING" => JobStatus::Cancelling,
            "FAILED" => JobStatus::Failed,
            "PENDING" => JobStatus::Pending,
            "PROVISIONING" => JobStatus::Provisioning,
            "RUNNING" => JobStatus::Running,
            "SUCCEED" => JobStatus::Succeed,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Cancelled => "CANCELLED",
            JobStatus::Cancelling => "CANCELLING",
            JobStatus::Failed => "FAILED",
            JobStatus::Pending => "PENDING",
            JobStatus::Provisioning => "PROVISIONING",
            JobStatus::Running => "RUNNING",
            JobStatus::Succeed => "SUCCEED",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "CANCELLING",
            "FAILED",
            "PENDING",
            "PROVISIONING",
            "RUNNING",
            "SUCCEED",
        ]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Describes the backend environment for an Amplify app. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendEnvironment {
    /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
    /// app. </p>
    pub backend_environment_arn: std::option::Option<std::string::String>,
    /// <p> The name for a backend environment that is part of an Amplify app. </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p> The AWS CloudFormation stack name of a backend environment. </p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p> The name of deployment artifacts. </p>
    pub deployment_artifacts: std::option::Option<std::string::String>,
    /// <p> The creation date and time for a backend environment that is part of an Amplify app.
    /// </p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The last updated date and time for a backend environment that is part of an Amplify
    /// app. </p>
    pub update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl BackendEnvironment {
    /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
    /// app. </p>
    pub fn backend_environment_arn(&self) -> std::option::Option<&str> {
        self.backend_environment_arn.as_deref()
    }
    /// <p> The name for a backend environment that is part of an Amplify app. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p> The AWS CloudFormation stack name of a backend environment. </p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p> The name of deployment artifacts. </p>
    pub fn deployment_artifacts(&self) -> std::option::Option<&str> {
        self.deployment_artifacts.as_deref()
    }
    /// <p> The creation date and time for a backend environment that is part of an Amplify app.
    /// </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_time.as_ref()
    }
    /// <p> The last updated date and time for a backend environment that is part of an Amplify
    /// app. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for BackendEnvironment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendEnvironment");
        formatter.field("backend_environment_arn", &self.backend_environment_arn);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("deployment_artifacts", &self.deployment_artifacts);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`BackendEnvironment`](crate::model::BackendEnvironment)
pub mod backend_environment {
    /// A builder for [`BackendEnvironment`](crate::model::BackendEnvironment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backend_environment_arn: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) deployment_artifacts: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn backend_environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backend_environment_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn set_backend_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backend_environment_arn = input;
            self
        }
        /// <p> The name for a backend environment that is part of an Amplify app. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p> The name for a backend environment that is part of an Amplify app. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p> The AWS CloudFormation stack name of a backend environment. </p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p> The AWS CloudFormation stack name of a backend environment. </p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p> The name of deployment artifacts. </p>
        pub fn deployment_artifacts(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_artifacts = Some(input.into());
            self
        }
        /// <p> The name of deployment artifacts. </p>
        pub fn set_deployment_artifacts(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_artifacts = input;
            self
        }
        /// <p> The creation date and time for a backend environment that is part of an Amplify app.
        /// </p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p> The creation date and time for a backend environment that is part of an Amplify app.
        /// </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p> The last updated date and time for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p> The last updated date and time for a backend environment that is part of an Amplify
        /// app. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendEnvironment`](crate::model::BackendEnvironment)
        pub fn build(self) -> crate::model::BackendEnvironment {
            crate::model::BackendEnvironment {
                backend_environment_arn: self.backend_environment_arn,
                environment_name: self.environment_name,
                stack_name: self.stack_name,
                deployment_artifacts: self.deployment_artifacts,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl BackendEnvironment {
    /// Creates a new builder-style object to manufacture [`BackendEnvironment`](crate::model::BackendEnvironment)
    pub fn builder() -> crate::model::backend_environment::Builder {
        crate::model::backend_environment::Builder::default()
    }
}

/// <p> Describes an artifact. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Artifact {
    /// <p> The file name for the artifact. </p>
    pub artifact_file_name: std::option::Option<std::string::String>,
    /// <p> The unique ID for the artifact. </p>
    pub artifact_id: std::option::Option<std::string::String>,
}
impl Artifact {
    /// <p> The file name for the artifact. </p>
    pub fn artifact_file_name(&self) -> std::option::Option<&str> {
        self.artifact_file_name.as_deref()
    }
    /// <p> The unique ID for the artifact. </p>
    pub fn artifact_id(&self) -> std::option::Option<&str> {
        self.artifact_id.as_deref()
    }
}
impl std::fmt::Debug for Artifact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Artifact");
        formatter.field("artifact_file_name", &self.artifact_file_name);
        formatter.field("artifact_id", &self.artifact_id);
        formatter.finish()
    }
}
/// See [`Artifact`](crate::model::Artifact)
pub mod artifact {
    /// A builder for [`Artifact`](crate::model::Artifact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifact_file_name: std::option::Option<std::string::String>,
        pub(crate) artifact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The file name for the artifact. </p>
        pub fn artifact_file_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_file_name = Some(input.into());
            self
        }
        /// <p> The file name for the artifact. </p>
        pub fn set_artifact_file_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_file_name = input;
            self
        }
        /// <p> The unique ID for the artifact. </p>
        pub fn artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_id = Some(input.into());
            self
        }
        /// <p> The unique ID for the artifact. </p>
        pub fn set_artifact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.artifact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Artifact`](crate::model::Artifact)
        pub fn build(self) -> crate::model::Artifact {
            crate::model::Artifact {
                artifact_file_name: self.artifact_file_name,
                artifact_id: self.artifact_id,
            }
        }
    }
}
impl Artifact {
    /// Creates a new builder-style object to manufacture [`Artifact`](crate::model::Artifact)
    pub fn builder() -> crate::model::artifact::Builder {
        crate::model::artifact::Builder::default()
    }
}

/// <p> Describes an execution job for an Amplify app. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Job {
    /// <p> Describes the summary for an execution job for an Amplify app. </p>
    pub summary: std::option::Option<crate::model::JobSummary>,
    /// <p> The execution steps for an execution job, for an Amplify app. </p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::Step>>,
}
impl Job {
    /// <p> Describes the summary for an execution job for an Amplify app. </p>
    pub fn summary(&self) -> std::option::Option<&crate::model::JobSummary> {
        self.summary.as_ref()
    }
    /// <p> The execution steps for an execution job, for an Amplify app. </p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::Step]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for Job {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Job");
        formatter.field("summary", &self.summary);
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}
/// See [`Job`](crate::model::Job)
pub mod job {
    /// A builder for [`Job`](crate::model::Job)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::JobSummary>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::Step>>,
    }
    impl Builder {
        /// <p> Describes the summary for an execution job for an Amplify app. </p>
        pub fn summary(mut self, input: crate::model::JobSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p> Describes the summary for an execution job for an Amplify app. </p>
        pub fn set_summary(mut self, input: std::option::Option<crate::model::JobSummary>) -> Self {
            self.summary = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p> The execution steps for an execution job, for an Amplify app. </p>
        pub fn steps(mut self, input: impl Into<crate::model::Step>) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input.into());
            self.steps = Some(v);
            self
        }
        /// <p> The execution steps for an execution job, for an Amplify app. </p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Step>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`Job`](crate::model::Job)
        pub fn build(self) -> crate::model::Job {
            crate::model::Job {
                summary: self.summary,
                steps: self.steps,
            }
        }
    }
}
impl Job {
    /// Creates a new builder-style object to manufacture [`Job`](crate::model::Job)
    pub fn builder() -> crate::model::job::Builder {
        crate::model::job::Builder::default()
    }
}

/// <p> Describes an execution step, for an execution job, for an Amplify app. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Step {
    /// <p> The name of the execution step. </p>
    pub step_name: std::option::Option<std::string::String>,
    /// <p> The start date and time of the execution step. </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The status of the execution step. </p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p> The end date and time of the execution step. </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The URL to the logs for the execution step. </p>
    pub log_url: std::option::Option<std::string::String>,
    /// <p> The URL to the artifact for the execution step. </p>
    pub artifacts_url: std::option::Option<std::string::String>,
    /// <p> The URL to the test artifact for the execution step. </p>
    pub test_artifacts_url: std::option::Option<std::string::String>,
    /// <p> The URL to the test configuration for the execution step. </p>
    pub test_config_url: std::option::Option<std::string::String>,
    /// <p> The list of screenshot URLs for the execution step, if relevant. </p>
    pub screenshots:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The reason for the current step status. </p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p> The context for the current step. Includes a build image if the step is build.
    /// </p>
    pub context: std::option::Option<std::string::String>,
}
impl Step {
    /// <p> The name of the execution step. </p>
    pub fn step_name(&self) -> std::option::Option<&str> {
        self.step_name.as_deref()
    }
    /// <p> The start date and time of the execution step. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p> The status of the execution step. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
    /// <p> The end date and time of the execution step. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p> The URL to the logs for the execution step. </p>
    pub fn log_url(&self) -> std::option::Option<&str> {
        self.log_url.as_deref()
    }
    /// <p> The URL to the artifact for the execution step. </p>
    pub fn artifacts_url(&self) -> std::option::Option<&str> {
        self.artifacts_url.as_deref()
    }
    /// <p> The URL to the test artifact for the execution step. </p>
    pub fn test_artifacts_url(&self) -> std::option::Option<&str> {
        self.test_artifacts_url.as_deref()
    }
    /// <p> The URL to the test configuration for the execution step. </p>
    pub fn test_config_url(&self) -> std::option::Option<&str> {
        self.test_config_url.as_deref()
    }
    /// <p> The list of screenshot URLs for the execution step, if relevant. </p>
    pub fn screenshots(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.screenshots.as_ref()
    }
    /// <p> The reason for the current step status. </p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p> The context for the current step. Includes a build image if the step is build.
    /// </p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for Step {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Step");
        formatter.field("step_name", &self.step_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("status", &self.status);
        formatter.field("end_time", &self.end_time);
        formatter.field("log_url", &self.log_url);
        formatter.field("artifacts_url", &self.artifacts_url);
        formatter.field("test_artifacts_url", &self.test_artifacts_url);
        formatter.field("test_config_url", &self.test_config_url);
        formatter.field("screenshots", &self.screenshots);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
/// See [`Step`](crate::model::Step)
pub mod step {
    /// A builder for [`Step`](crate::model::Step)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) step_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) log_url: std::option::Option<std::string::String>,
        pub(crate) artifacts_url: std::option::Option<std::string::String>,
        pub(crate) test_artifacts_url: std::option::Option<std::string::String>,
        pub(crate) test_config_url: std::option::Option<std::string::String>,
        pub(crate) screenshots: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the execution step. </p>
        pub fn step_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.step_name = Some(input.into());
            self
        }
        /// <p> The name of the execution step. </p>
        pub fn set_step_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.step_name = input;
            self
        }
        /// <p> The start date and time of the execution step. </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> The start date and time of the execution step. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The status of the execution step. </p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the execution step. </p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p> The end date and time of the execution step. </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> The end date and time of the execution step. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p> The URL to the logs for the execution step. </p>
        pub fn log_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_url = Some(input.into());
            self
        }
        /// <p> The URL to the logs for the execution step. </p>
        pub fn set_log_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_url = input;
            self
        }
        /// <p> The URL to the artifact for the execution step. </p>
        pub fn artifacts_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifacts_url = Some(input.into());
            self
        }
        /// <p> The URL to the artifact for the execution step. </p>
        pub fn set_artifacts_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifacts_url = input;
            self
        }
        /// <p> The URL to the test artifact for the execution step. </p>
        pub fn test_artifacts_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_artifacts_url = Some(input.into());
            self
        }
        /// <p> The URL to the test artifact for the execution step. </p>
        pub fn set_test_artifacts_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_artifacts_url = input;
            self
        }
        /// <p> The URL to the test configuration for the execution step. </p>
        pub fn test_config_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_config_url = Some(input.into());
            self
        }
        /// <p> The URL to the test configuration for the execution step. </p>
        pub fn set_test_config_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_config_url = input;
            self
        }
        /// Adds a key-value pair to `screenshots`.
        ///
        /// To override the contents of this collection use [`set_screenshots`](Self::set_screenshots).
        ///
        /// <p> The list of screenshot URLs for the execution step, if relevant. </p>
        pub fn screenshots(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.screenshots.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.screenshots = Some(hash_map);
            self
        }
        /// <p> The list of screenshot URLs for the execution step, if relevant. </p>
        pub fn set_screenshots(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.screenshots = input;
            self
        }
        /// <p> The reason for the current step status. </p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p> The reason for the current step status. </p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p> The context for the current step. Includes a build image if the step is build.
        /// </p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p> The context for the current step. Includes a build image if the step is build.
        /// </p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`Step`](crate::model::Step)
        pub fn build(self) -> crate::model::Step {
            crate::model::Step {
                step_name: self.step_name,
                start_time: self.start_time,
                status: self.status,
                end_time: self.end_time,
                log_url: self.log_url,
                artifacts_url: self.artifacts_url,
                test_artifacts_url: self.test_artifacts_url,
                test_config_url: self.test_config_url,
                screenshots: self.screenshots,
                status_reason: self.status_reason,
                context: self.context,
            }
        }
    }
}
impl Step {
    /// Creates a new builder-style object to manufacture [`Step`](crate::model::Step)
    pub fn builder() -> crate::model::step::Builder {
        crate::model::step::Builder::default()
    }
}
