// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAppError {
    /// Kind of error that occurred.
    pub kind: CreateAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAppErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAppErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::DependentServiceFailureException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAppError {
    fn code(&self) -> Option<&str> {
        CreateAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAppError {
    /// Creates a new `CreateAppError`.
    pub fn new(kind: CreateAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateAppErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAppErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAppErrorKind::DependentServiceFailureException(_inner) => Some(_inner),
            CreateAppErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateAppErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAppErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackendEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackendEnvironmentError {
    /// Kind of error that occurred.
    pub kind: CreateBackendEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackendEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackendEnvironmentErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackendEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackendEnvironmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBackendEnvironmentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateBackendEnvironmentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBackendEnvironmentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBackendEnvironmentErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateBackendEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackendEnvironmentError {
    fn code(&self) -> Option<&str> {
        CreateBackendEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackendEnvironmentError {
    /// Creates a new `CreateBackendEnvironmentError`.
    pub fn new(kind: CreateBackendEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackendEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackendEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackendEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackendEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackendEnvironmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendEnvironmentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendEnvironmentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendEnvironmentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendEnvironmentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendEnvironmentErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendEnvironmentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendEnvironmentErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackendEnvironmentErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackendEnvironmentErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateBackendEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackendEnvironmentErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBackendEnvironmentErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateBackendEnvironmentErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBackendEnvironmentErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBackendEnvironmentErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateBackendEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBranchError {
    /// Kind of error that occurred.
    pub kind: CreateBranchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBranchErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBranchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBranchErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::DependentServiceFailureException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBranchError {
    fn code(&self) -> Option<&str> {
        CreateBranchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBranchError {
    /// Creates a new `CreateBranchError`.
    pub fn new(kind: CreateBranchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBranchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBranchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBranchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBranchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateBranchErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateBranchErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateBranchErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateBranchErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateBranchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBranchErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBranchErrorKind::DependentServiceFailureException(_inner) => Some(_inner),
            CreateBranchErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateBranchErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBranchErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBranchErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateBranchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDeploymentError {
    /// Kind of error that occurred.
    pub kind: CreateDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDeploymentErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDeploymentError {
    fn code(&self) -> Option<&str> {
        CreateDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDeploymentError {
    /// Creates a new `CreateDeploymentError`.
    pub fn new(kind: CreateDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomainAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainAssociationError {
    /// Kind of error that occurred.
    pub kind: CreateDomainAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomainAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainAssociationErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainAssociationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDomainAssociationErrorKind::DependentServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            CreateDomainAssociationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDomainAssociationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDomainAssociationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDomainAssociationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateDomainAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainAssociationError {
    fn code(&self) -> Option<&str> {
        CreateDomainAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainAssociationError {
    /// Creates a new `CreateDomainAssociationError`.
    pub fn new(kind: CreateDomainAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDomainAssociationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainAssociationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainAssociationErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainAssociationErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainAssociationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainAssociationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainAssociationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainAssociationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainAssociationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainAssociationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainAssociationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainAssociationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateDomainAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainAssociationErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDomainAssociationErrorKind::DependentServiceFailureException(_inner) => {
                Some(_inner)
            }
            CreateDomainAssociationErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDomainAssociationErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDomainAssociationErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDomainAssociationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateDomainAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWebhookError {
    /// Kind of error that occurred.
    pub kind: CreateWebhookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWebhookErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWebhookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWebhookErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::DependentServiceFailureException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWebhookError {
    fn code(&self) -> Option<&str> {
        CreateWebhookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWebhookError {
    /// Creates a new `CreateWebhookError`.
    pub fn new(kind: CreateWebhookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWebhookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWebhookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWebhookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWebhookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateWebhookErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebhookErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebhookErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebhookErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateWebhookErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateWebhookErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateWebhookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWebhookErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateWebhookErrorKind::DependentServiceFailureException(_inner) => Some(_inner),
            CreateWebhookErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateWebhookErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateWebhookErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateWebhookErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateWebhookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppError {
    /// Kind of error that occurred.
    pub kind: DeleteAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::DependentServiceFailureException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppError {
    fn code(&self) -> Option<&str> {
        DeleteAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppError {
    /// Creates a new `DeleteAppError`.
    pub fn new(kind: DeleteAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteAppErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteAppErrorKind::DependentServiceFailureException(_inner) => Some(_inner),
            DeleteAppErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteAppErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAppErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackendEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackendEnvironmentError {
    /// Kind of error that occurred.
    pub kind: DeleteBackendEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackendEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackendEnvironmentErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackendEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackendEnvironmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBackendEnvironmentErrorKind::DependentServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackendEnvironmentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteBackendEnvironmentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBackendEnvironmentErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteBackendEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackendEnvironmentError {
    fn code(&self) -> Option<&str> {
        DeleteBackendEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackendEnvironmentError {
    /// Creates a new `DeleteBackendEnvironmentError`.
    pub fn new(kind: DeleteBackendEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackendEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackendEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackendEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackendEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackendEnvironmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendEnvironmentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackendEnvironmentErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendEnvironmentErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackendEnvironmentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendEnvironmentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackendEnvironmentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendEnvironmentErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackendEnvironmentErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackendEnvironmentErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteBackendEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackendEnvironmentErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBackendEnvironmentErrorKind::DependentServiceFailureException(_inner) => {
                Some(_inner)
            }
            DeleteBackendEnvironmentErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteBackendEnvironmentErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBackendEnvironmentErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteBackendEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBranchError {
    /// Kind of error that occurred.
    pub kind: DeleteBranchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBranchErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBranchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBranchErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::DependentServiceFailureException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBranchError {
    fn code(&self) -> Option<&str> {
        DeleteBranchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBranchError {
    /// Creates a new `DeleteBranchError`.
    pub fn new(kind: DeleteBranchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBranchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBranchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBranchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBranchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteBranchErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBranchErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteBranchErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteBranchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBranchErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBranchErrorKind::DependentServiceFailureException(_inner) => Some(_inner),
            DeleteBranchErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteBranchErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBranchErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteBranchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomainAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainAssociationError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomainAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainAssociationErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainAssociationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDomainAssociationErrorKind::DependentServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDomainAssociationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDomainAssociationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDomainAssociationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteDomainAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainAssociationError {
    fn code(&self) -> Option<&str> {
        DeleteDomainAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainAssociationError {
    /// Creates a new `DeleteDomainAssociationError`.
    pub fn new(kind: DeleteDomainAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDomainAssociationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainAssociationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainAssociationErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainAssociationErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainAssociationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainAssociationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainAssociationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainAssociationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainAssociationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainAssociationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteDomainAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainAssociationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDomainAssociationErrorKind::DependentServiceFailureException(_inner) => {
                Some(_inner)
            }
            DeleteDomainAssociationErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDomainAssociationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDomainAssociationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteDomainAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJobError {
    /// Kind of error that occurred.
    pub kind: DeleteJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJobErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJobError {
    fn code(&self) -> Option<&str> {
        DeleteJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJobError {
    /// Creates a new `DeleteJobError`.
    pub fn new(kind: DeleteJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJobErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteJobErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteJobErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteJobErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWebhookError {
    /// Kind of error that occurred.
    pub kind: DeleteWebhookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWebhookErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWebhookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWebhookErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWebhookError {
    fn code(&self) -> Option<&str> {
        DeleteWebhookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWebhookError {
    /// Creates a new `DeleteWebhookError`.
    pub fn new(kind: DeleteWebhookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWebhookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWebhookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWebhookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWebhookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteWebhookErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebhookErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebhookErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteWebhookErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteWebhookErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteWebhookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWebhookErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateAccessLogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateAccessLogsError {
    /// Kind of error that occurred.
    pub kind: GenerateAccessLogsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateAccessLogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateAccessLogsErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateAccessLogsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateAccessLogsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GenerateAccessLogsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GenerateAccessLogsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GenerateAccessLogsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GenerateAccessLogsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateAccessLogsError {
    fn code(&self) -> Option<&str> {
        GenerateAccessLogsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateAccessLogsError {
    /// Creates a new `GenerateAccessLogsError`.
    pub fn new(kind: GenerateAccessLogsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateAccessLogsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateAccessLogsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateAccessLogsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateAccessLogsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateAccessLogsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateAccessLogsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateAccessLogsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateAccessLogsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateAccessLogsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateAccessLogsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateAccessLogsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateAccessLogsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GenerateAccessLogsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateAccessLogsErrorKind::BadRequestException(_inner) => Some(_inner),
            GenerateAccessLogsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GenerateAccessLogsErrorKind::NotFoundException(_inner) => Some(_inner),
            GenerateAccessLogsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GenerateAccessLogsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppError {
    /// Kind of error that occurred.
    pub kind: GetAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAppErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetAppErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAppErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppError {
    fn code(&self) -> Option<&str> {
        GetAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppError {
    /// Creates a new `GetAppError`.
    pub fn new(kind: GetAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAppErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAppErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetAppErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAppErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetArtifactUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetArtifactUrlError {
    /// Kind of error that occurred.
    pub kind: GetArtifactUrlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetArtifactUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetArtifactUrlErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetArtifactUrlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetArtifactUrlErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetArtifactUrlErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetArtifactUrlErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetArtifactUrlErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetArtifactUrlErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetArtifactUrlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetArtifactUrlError {
    fn code(&self) -> Option<&str> {
        GetArtifactUrlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetArtifactUrlError {
    /// Creates a new `GetArtifactUrlError`.
    pub fn new(kind: GetArtifactUrlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetArtifactUrlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetArtifactUrlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetArtifactUrlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetArtifactUrlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetArtifactUrlErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetArtifactUrlErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetArtifactUrlErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetArtifactUrlErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetArtifactUrlErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetArtifactUrlErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetArtifactUrlErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetArtifactUrlErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetArtifactUrlErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetArtifactUrlErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetArtifactUrlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetArtifactUrlErrorKind::BadRequestException(_inner) => Some(_inner),
            GetArtifactUrlErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetArtifactUrlErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetArtifactUrlErrorKind::NotFoundException(_inner) => Some(_inner),
            GetArtifactUrlErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetArtifactUrlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackendEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackendEnvironmentError {
    /// Kind of error that occurred.
    pub kind: GetBackendEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackendEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackendEnvironmentErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackendEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackendEnvironmentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBackendEnvironmentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBackendEnvironmentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBackendEnvironmentErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetBackendEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackendEnvironmentError {
    fn code(&self) -> Option<&str> {
        GetBackendEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackendEnvironmentError {
    /// Creates a new `GetBackendEnvironmentError`.
    pub fn new(kind: GetBackendEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackendEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackendEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackendEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackendEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackendEnvironmentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendEnvironmentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackendEnvironmentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendEnvironmentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackendEnvironmentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendEnvironmentErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackendEnvironmentErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackendEnvironmentErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetBackendEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackendEnvironmentErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBackendEnvironmentErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBackendEnvironmentErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBackendEnvironmentErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetBackendEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBranchError {
    /// Kind of error that occurred.
    pub kind: GetBranchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBranchErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBranchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBranchErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBranchError {
    fn code(&self) -> Option<&str> {
        GetBranchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBranchError {
    /// Creates a new `GetBranchError`.
    pub fn new(kind: GetBranchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBranchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBranchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBranchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBranchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBranchErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetBranchErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBranchErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetBranchErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetBranchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBranchErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBranchErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBranchErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBranchErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetBranchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainAssociationError {
    /// Kind of error that occurred.
    pub kind: GetDomainAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainAssociationErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainAssociationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDomainAssociationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetDomainAssociationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDomainAssociationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDomainAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainAssociationError {
    fn code(&self) -> Option<&str> {
        GetDomainAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainAssociationError {
    /// Creates a new `GetDomainAssociationError`.
    pub fn new(kind: GetDomainAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDomainAssociationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainAssociationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainAssociationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainAssociationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainAssociationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainAssociationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainAssociationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainAssociationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetDomainAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainAssociationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDomainAssociationErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetDomainAssociationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDomainAssociationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDomainAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobError {
    /// Kind of error that occurred.
    pub kind: GetJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetJobErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetJobErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobError {
    fn code(&self) -> Option<&str> {
        GetJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobError {
    /// Creates a new `GetJobError`.
    pub fn new(kind: GetJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobErrorKind::BadRequestException(_inner) => Some(_inner),
            GetJobErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetJobErrorKind::NotFoundException(_inner) => Some(_inner),
            GetJobErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWebhookError {
    /// Kind of error that occurred.
    pub kind: GetWebhookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWebhookErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWebhookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWebhookErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetWebhookErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetWebhookErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetWebhookErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetWebhookErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetWebhookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWebhookError {
    fn code(&self) -> Option<&str> {
        GetWebhookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWebhookError {
    /// Creates a new `GetWebhookError`.
    pub fn new(kind: GetWebhookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWebhookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWebhookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWebhookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWebhookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWebhookErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetWebhookErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetWebhookErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetWebhookErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetWebhookErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetWebhookErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetWebhookErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetWebhookErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetWebhookErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetWebhookErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetWebhookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWebhookErrorKind::BadRequestException(_inner) => Some(_inner),
            GetWebhookErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetWebhookErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetWebhookErrorKind::NotFoundException(_inner) => Some(_inner),
            GetWebhookErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetWebhookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAppsError {
    /// Kind of error that occurred.
    pub kind: ListAppsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAppsErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAppsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAppsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListAppsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAppsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListAppsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAppsError {
    fn code(&self) -> Option<&str> {
        ListAppsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAppsError {
    /// Creates a new `ListAppsError`.
    pub fn new(kind: ListAppsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAppsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAppsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAppsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAppsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAppsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListAppsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListAppsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, ListAppsErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `ListAppsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListAppsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListAppsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAppsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListAppsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAppsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListAppsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListArtifactsError {
    /// Kind of error that occurred.
    pub kind: ListArtifactsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListArtifactsErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListArtifactsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListArtifactsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListArtifactsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListArtifactsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListArtifactsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListArtifactsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListArtifactsError {
    fn code(&self) -> Option<&str> {
        ListArtifactsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListArtifactsError {
    /// Creates a new `ListArtifactsError`.
    pub fn new(kind: ListArtifactsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListArtifactsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListArtifactsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListArtifactsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListArtifactsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListArtifactsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListArtifactsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListArtifactsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListArtifactsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListArtifactsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListArtifactsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListArtifactsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListArtifactsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListArtifactsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListArtifactsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListArtifactsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListArtifactsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListArtifactsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListArtifactsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBackendEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBackendEnvironmentsError {
    /// Kind of error that occurred.
    pub kind: ListBackendEnvironmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBackendEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBackendEnvironmentsErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBackendEnvironmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBackendEnvironmentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListBackendEnvironmentsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListBackendEnvironmentsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListBackendEnvironmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBackendEnvironmentsError {
    fn code(&self) -> Option<&str> {
        ListBackendEnvironmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBackendEnvironmentsError {
    /// Creates a new `ListBackendEnvironmentsError`.
    pub fn new(kind: ListBackendEnvironmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBackendEnvironmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBackendEnvironmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBackendEnvironmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBackendEnvironmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBackendEnvironmentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackendEnvironmentsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackendEnvironmentsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackendEnvironmentsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackendEnvironmentsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackendEnvironmentsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListBackendEnvironmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBackendEnvironmentsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListBackendEnvironmentsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListBackendEnvironmentsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListBackendEnvironmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBranches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBranchesError {
    /// Kind of error that occurred.
    pub kind: ListBranchesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBranches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBranchesErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBranchesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBranchesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBranchesError {
    fn code(&self) -> Option<&str> {
        ListBranchesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBranchesError {
    /// Creates a new `ListBranchesError`.
    pub fn new(kind: ListBranchesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBranchesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBranchesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBranchesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBranchesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListBranchesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListBranchesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListBranchesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBranchesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListBranchesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListBranchesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListBranchesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomainAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainAssociationsError {
    /// Kind of error that occurred.
    pub kind: ListDomainAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomainAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainAssociationsErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainAssociationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListDomainAssociationsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDomainAssociationsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListDomainAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainAssociationsError {
    fn code(&self) -> Option<&str> {
        ListDomainAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainAssociationsError {
    /// Creates a new `ListDomainAssociationsError`.
    pub fn new(kind: ListDomainAssociationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainAssociationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainAssociationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainAssociationsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainAssociationsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainAssociationsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainAssociationsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListDomainAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainAssociationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDomainAssociationsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDomainAssociationsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListDomainAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsError {
    /// Kind of error that occurred.
    pub kind: ListJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsError {
    fn code(&self) -> Option<&str> {
        ListJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsError {
    /// Creates a new `ListJobsError`.
    pub fn new(kind: ListJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListJobsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListJobsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListJobsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An operation failed due to a non-existent resource. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWebhooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWebhooksError {
    /// Kind of error that occurred.
    pub kind: ListWebhooksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWebhooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWebhooksErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWebhooksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWebhooksErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListWebhooksErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListWebhooksErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListWebhooksErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListWebhooksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWebhooksError {
    fn code(&self) -> Option<&str> {
        ListWebhooksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWebhooksError {
    /// Creates a new `ListWebhooksError`.
    pub fn new(kind: ListWebhooksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWebhooksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWebhooksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWebhooksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWebhooksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWebhooksErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListWebhooksErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListWebhooksErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebhooksErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebhooksErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListWebhooksErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `ListWebhooksErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListWebhooksErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListWebhooksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWebhooksErrorKind::BadRequestException(_inner) => Some(_inner),
            ListWebhooksErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListWebhooksErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListWebhooksErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListWebhooksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDeploymentError {
    /// Kind of error that occurred.
    pub kind: StartDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDeploymentErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDeploymentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDeploymentError {
    fn code(&self) -> Option<&str> {
        StartDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDeploymentError {
    /// Creates a new `StartDeploymentError`.
    pub fn new(kind: StartDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDeploymentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StartDeploymentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StartDeploymentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeploymentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDeploymentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeploymentErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartDeploymentErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartDeploymentErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeploymentErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for StartDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDeploymentErrorKind::BadRequestException(_inner) => Some(_inner),
            StartDeploymentErrorKind::InternalFailureException(_inner) => Some(_inner),
            StartDeploymentErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            StartDeploymentErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StartDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartJobError {
    /// Kind of error that occurred.
    pub kind: StartJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartJobErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartJobErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            StartJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartJobErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StartJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartJobError {
    fn code(&self) -> Option<&str> {
        StartJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartJobError {
    /// Creates a new `StartJobError`.
    pub fn new(kind: StartJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for StartJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartJobErrorKind::BadRequestException(_inner) => Some(_inner),
            StartJobErrorKind::InternalFailureException(_inner) => Some(_inner),
            StartJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartJobErrorKind::NotFoundException(_inner) => Some(_inner),
            StartJobErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StartJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopJobError {
    /// Kind of error that occurred.
    pub kind: StopJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopJobErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> A resource could not be created because service quotas were exceeded. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StopJobErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            StopJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StopJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopJobErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StopJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopJobError {
    fn code(&self) -> Option<&str> {
        StopJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopJobError {
    /// Creates a new `StopJobError`.
    pub fn new(kind: StopJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StopJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StopJobErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, StopJobErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `StopJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StopJobErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `StopJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopJobErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, StopJobErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for StopJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopJobErrorKind::BadRequestException(_inner) => Some(_inner),
            StopJobErrorKind::InternalFailureException(_inner) => Some(_inner),
            StopJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            StopJobErrorKind::NotFoundException(_inner) => Some(_inner),
            StopJobErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StopJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An operation failed due to a non-existent resource. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An operation failed due to a non-existent resource. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAppError {
    /// Kind of error that occurred.
    pub kind: UpdateAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAppErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAppErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateAppErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateAppErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateAppErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAppError {
    fn code(&self) -> Option<&str> {
        UpdateAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAppError {
    /// Creates a new `UpdateAppError`.
    pub fn new(kind: UpdateAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAppErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateAppErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateAppErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, UpdateAppErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `UpdateAppErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateAppErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateAppErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateAppErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAppErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateAppErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateAppErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateAppErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBranchError {
    /// Kind of error that occurred.
    pub kind: UpdateBranchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBranchErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBranchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBranchErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateBranchErrorKind::DependentServiceFailureException(_inner) => _inner.fmt(f),
            UpdateBranchErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateBranchErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBranchErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateBranchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBranchError {
    fn code(&self) -> Option<&str> {
        UpdateBranchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBranchError {
    /// Creates a new `UpdateBranchError`.
    pub fn new(kind: UpdateBranchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBranchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBranchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBranchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBranchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBranchErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateBranchErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateBranchErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBranchErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBranchErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBranchErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBranchErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateBranchErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateBranchErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateBranchErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateBranchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBranchErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateBranchErrorKind::DependentServiceFailureException(_inner) => Some(_inner),
            UpdateBranchErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateBranchErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBranchErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateBranchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomainAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainAssociationError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomainAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainAssociationErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainAssociationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDomainAssociationErrorKind::DependentServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDomainAssociationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDomainAssociationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDomainAssociationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateDomainAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainAssociationError {
    fn code(&self) -> Option<&str> {
        UpdateDomainAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainAssociationError {
    /// Creates a new `UpdateDomainAssociationError`.
    pub fn new(kind: UpdateDomainAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDomainAssociationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainAssociationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainAssociationErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainAssociationErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainAssociationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainAssociationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainAssociationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainAssociationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainAssociationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainAssociationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateDomainAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainAssociationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDomainAssociationErrorKind::DependentServiceFailureException(_inner) => {
                Some(_inner)
            }
            UpdateDomainAssociationErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDomainAssociationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDomainAssociationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateDomainAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWebhookError {
    /// Kind of error that occurred.
    pub kind: UpdateWebhookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWebhookErrorKind {
    /// <p> A request contains unexpected data. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> An operation failed because a dependent service threw an exception. </p>
    DependentServiceFailureException(crate::error::DependentServiceFailureException),
    /// <p> The service failed to perform an operation due to an internal issue. </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p> An entity was not found during an operation. </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> An operation failed due to a lack of access. </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWebhookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWebhookErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateWebhookErrorKind::DependentServiceFailureException(_inner) => _inner.fmt(f),
            UpdateWebhookErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateWebhookErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateWebhookErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateWebhookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWebhookError {
    fn code(&self) -> Option<&str> {
        UpdateWebhookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWebhookError {
    /// Creates a new `UpdateWebhookError`.
    pub fn new(kind: UpdateWebhookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWebhookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWebhookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWebhookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWebhookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWebhookErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateWebhookErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateWebhookErrorKind::DependentServiceFailureException`.
    pub fn is_dependent_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebhookErrorKind::DependentServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebhookErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebhookErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebhookErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateWebhookErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateWebhookErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateWebhookErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateWebhookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWebhookErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateWebhookErrorKind::DependentServiceFailureException(_inner) => Some(_inner),
            UpdateWebhookErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateWebhookErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateWebhookErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateWebhookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p> An operation failed due to a lack of access. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p> An entity was not found during an operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p> The service failed to perform an operation due to an internal issue. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

/// <p> An operation failed because a dependent service threw an exception. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependentServiceFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DependentServiceFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependentServiceFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DependentServiceFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependentServiceFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependentServiceFailureException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependentServiceFailureException {}
/// See [`DependentServiceFailureException`](crate::error::DependentServiceFailureException)
pub mod dependent_service_failure_exception {
    /// A builder for [`DependentServiceFailureException`](crate::error::DependentServiceFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DependentServiceFailureException`](crate::error::DependentServiceFailureException)
        pub fn build(self) -> crate::error::DependentServiceFailureException {
            crate::error::DependentServiceFailureException {
                message: self.message,
            }
        }
    }
}
impl DependentServiceFailureException {
    /// Creates a new builder-style object to manufacture [`DependentServiceFailureException`](crate::error::DependentServiceFailureException)
    pub fn builder() -> crate::error::dependent_service_failure_exception::Builder {
        crate::error::dependent_service_failure_exception::Builder::default()
    }
}

/// <p> A request contains unexpected data. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p> An operation failed due to a non-existent resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p> A resource could not be created because service quotas were exceeded. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}
