// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Prometheus Service
///
/// Client for invoking operations on Amazon Prometheus Service. Each operation on Amazon Prometheus Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_amp::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_amp::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_amp::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateAlertManagerDefinition`](crate::client::fluent_builders::CreateAlertManagerDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::CreateAlertManagerDefinition::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::CreateAlertManagerDefinition::set_workspace_id): The ID of the workspace in which to create the alert manager definition.
    ///   - [`data(Blob)`](crate::client::fluent_builders::CreateAlertManagerDefinition::data) / [`set_data(Option<Blob>)`](crate::client::fluent_builders::CreateAlertManagerDefinition::set_data): The alert manager definition data.
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAlertManagerDefinition::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAlertManagerDefinition::set_client_token): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
    /// - On success, responds with [`CreateAlertManagerDefinitionOutput`](crate::output::CreateAlertManagerDefinitionOutput) with field(s):
    ///   - [`status(Option<AlertManagerDefinitionStatus>)`](crate::output::CreateAlertManagerDefinitionOutput::status): The status of alert manager definition.
    /// - On failure, responds with [`SdkError<CreateAlertManagerDefinitionError>`](crate::error::CreateAlertManagerDefinitionError)
    pub fn create_alert_manager_definition(
        &self,
    ) -> fluent_builders::CreateAlertManagerDefinition<C, M, R> {
        fluent_builders::CreateAlertManagerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRuleGroupsNamespace`](crate::client::fluent_builders::CreateRuleGroupsNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::set_workspace_id): The ID of the workspace in which to create the rule group namespace.
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::set_name): The rule groups namespace name.
    ///   - [`data(Blob)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::data) / [`set_data(Option<Blob>)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::set_data): The namespace data that define the rule groups.
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::set_client_token): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRuleGroupsNamespace::set_tags): Optional, user-provided tags for this rule groups namespace.
    /// - On success, responds with [`CreateRuleGroupsNamespaceOutput`](crate::output::CreateRuleGroupsNamespaceOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateRuleGroupsNamespaceOutput::name): The rule groups namespace name.
    ///   - [`arn(Option<String>)`](crate::output::CreateRuleGroupsNamespaceOutput::arn): The Amazon Resource Name (ARN) of this rule groups namespace.
    ///   - [`status(Option<RuleGroupsNamespaceStatus>)`](crate::output::CreateRuleGroupsNamespaceOutput::status): The status of rule groups namespace.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateRuleGroupsNamespaceOutput::tags): The tags of this rule groups namespace.
    /// - On failure, responds with [`SdkError<CreateRuleGroupsNamespaceError>`](crate::error::CreateRuleGroupsNamespaceError)
    pub fn create_rule_groups_namespace(
        &self,
    ) -> fluent_builders::CreateRuleGroupsNamespace<C, M, R> {
        fluent_builders::CreateRuleGroupsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWorkspace`](crate::client::fluent_builders::CreateWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_alias): An optional user-assigned alias for this workspace. This alias is for user reference and does not need to be unique.
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_client_token): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateWorkspace::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateWorkspace::set_tags): Optional, user-provided tags for this workspace.
    /// - On success, responds with [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput) with field(s):
    ///   - [`workspace_id(Option<String>)`](crate::output::CreateWorkspaceOutput::workspace_id): The generated ID of the workspace that was just created.
    ///   - [`arn(Option<String>)`](crate::output::CreateWorkspaceOutput::arn): The ARN of the workspace that was just created.
    ///   - [`status(Option<WorkspaceStatus>)`](crate::output::CreateWorkspaceOutput::status): The status of the workspace that was just created (usually CREATING).
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateWorkspaceOutput::tags): The tags of this workspace.
    /// - On failure, responds with [`SdkError<CreateWorkspaceError>`](crate::error::CreateWorkspaceError)
    pub fn create_workspace(&self) -> fluent_builders::CreateWorkspace<C, M, R> {
        fluent_builders::CreateWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAlertManagerDefinition`](crate::client::fluent_builders::DeleteAlertManagerDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAlertManagerDefinition::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DeleteAlertManagerDefinition::set_workspace_id): The ID of the workspace in which to delete the alert manager definition.
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteAlertManagerDefinition::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteAlertManagerDefinition::set_client_token): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
    /// - On success, responds with [`DeleteAlertManagerDefinitionOutput`](crate::output::DeleteAlertManagerDefinitionOutput)

    /// - On failure, responds with [`SdkError<DeleteAlertManagerDefinitionError>`](crate::error::DeleteAlertManagerDefinitionError)
    pub fn delete_alert_manager_definition(
        &self,
    ) -> fluent_builders::DeleteAlertManagerDefinition<C, M, R> {
        fluent_builders::DeleteAlertManagerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRuleGroupsNamespace`](crate::client::fluent_builders::DeleteRuleGroupsNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroupsNamespace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroupsNamespace::set_workspace_id): The ID of the workspace to delete rule group definition.
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroupsNamespace::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroupsNamespace::set_name): The rule groups namespace name.
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroupsNamespace::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroupsNamespace::set_client_token): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
    /// - On success, responds with [`DeleteRuleGroupsNamespaceOutput`](crate::output::DeleteRuleGroupsNamespaceOutput)

    /// - On failure, responds with [`SdkError<DeleteRuleGroupsNamespaceError>`](crate::error::DeleteRuleGroupsNamespaceError)
    pub fn delete_rule_groups_namespace(
        &self,
    ) -> fluent_builders::DeleteRuleGroupsNamespace<C, M, R> {
        fluent_builders::DeleteRuleGroupsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkspace`](crate::client::fluent_builders::DeleteWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkspace::set_workspace_id): The ID of the workspace to delete.
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkspace::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteWorkspace::set_client_token): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
    /// - On success, responds with [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)

    /// - On failure, responds with [`SdkError<DeleteWorkspaceError>`](crate::error::DeleteWorkspaceError)
    pub fn delete_workspace(&self) -> fluent_builders::DeleteWorkspace<C, M, R> {
        fluent_builders::DeleteWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAlertManagerDefinition`](crate::client::fluent_builders::DescribeAlertManagerDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAlertManagerDefinition::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DescribeAlertManagerDefinition::set_workspace_id): The ID of the workspace to describe.
    /// - On success, responds with [`DescribeAlertManagerDefinitionOutput`](crate::output::DescribeAlertManagerDefinitionOutput) with field(s):
    ///   - [`alert_manager_definition(Option<AlertManagerDefinitionDescription>)`](crate::output::DescribeAlertManagerDefinitionOutput::alert_manager_definition): The properties of the selected workspace's alert manager definition.
    /// - On failure, responds with [`SdkError<DescribeAlertManagerDefinitionError>`](crate::error::DescribeAlertManagerDefinitionError)
    pub fn describe_alert_manager_definition(
        &self,
    ) -> fluent_builders::DescribeAlertManagerDefinition<C, M, R> {
        fluent_builders::DescribeAlertManagerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRuleGroupsNamespace`](crate::client::fluent_builders::DescribeRuleGroupsNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DescribeRuleGroupsNamespace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DescribeRuleGroupsNamespace::set_workspace_id): The ID of the workspace to describe.
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeRuleGroupsNamespace::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeRuleGroupsNamespace::set_name): The rule groups namespace.
    /// - On success, responds with [`DescribeRuleGroupsNamespaceOutput`](crate::output::DescribeRuleGroupsNamespaceOutput) with field(s):
    ///   - [`rule_groups_namespace(Option<RuleGroupsNamespaceDescription>)`](crate::output::DescribeRuleGroupsNamespaceOutput::rule_groups_namespace): The selected rule groups namespace.
    /// - On failure, responds with [`SdkError<DescribeRuleGroupsNamespaceError>`](crate::error::DescribeRuleGroupsNamespaceError)
    pub fn describe_rule_groups_namespace(
        &self,
    ) -> fluent_builders::DescribeRuleGroupsNamespace<C, M, R> {
        fluent_builders::DescribeRuleGroupsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspace`](crate::client::fluent_builders::DescribeWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DescribeWorkspace::set_workspace_id): The ID of the workspace to describe.
    /// - On success, responds with [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput) with field(s):
    ///   - [`workspace(Option<WorkspaceDescription>)`](crate::output::DescribeWorkspaceOutput::workspace): The properties of the selected workspace.
    /// - On failure, responds with [`SdkError<DescribeWorkspaceError>`](crate::error::DescribeWorkspaceError)
    pub fn describe_workspace(&self) -> fluent_builders::DescribeWorkspace<C, M, R> {
        fluent_builders::DescribeWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRuleGroupsNamespaces`](crate::client::fluent_builders::ListRuleGroupsNamespaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRuleGroupsNamespaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::ListRuleGroupsNamespaces::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::ListRuleGroupsNamespaces::set_workspace_id): The ID of the workspace.
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListRuleGroupsNamespaces::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListRuleGroupsNamespaces::set_name): Optional filter for rule groups namespace name. Only the rule groups namespace that begin with this value will be returned.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRuleGroupsNamespaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRuleGroupsNamespaces::set_next_token): Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListRuleGroupsNamespaces request.
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRuleGroupsNamespaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRuleGroupsNamespaces::set_max_results): Maximum results to return in response (default=100, maximum=1000).
    /// - On success, responds with [`ListRuleGroupsNamespacesOutput`](crate::output::ListRuleGroupsNamespacesOutput) with field(s):
    ///   - [`rule_groups_namespaces(Option<Vec<RuleGroupsNamespaceSummary>>)`](crate::output::ListRuleGroupsNamespacesOutput::rule_groups_namespaces): The list of the selected rule groups namespaces.
    ///   - [`next_token(Option<String>)`](crate::output::ListRuleGroupsNamespacesOutput::next_token): Pagination token to use when requesting the next page in this list.
    /// - On failure, responds with [`SdkError<ListRuleGroupsNamespacesError>`](crate::error::ListRuleGroupsNamespacesError)
    pub fn list_rule_groups_namespaces(
        &self,
    ) -> fluent_builders::ListRuleGroupsNamespaces<C, M, R> {
        fluent_builders::ListRuleGroupsNamespaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): The ARN of the resource.
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): The list of tags assigned to the resource.
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkspaces`](crate::client::fluent_builders::ListWorkspaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWorkspaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkspaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWorkspaces::set_next_token): Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListWorkspaces request.
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::ListWorkspaces::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::ListWorkspaces::set_alias): Optional filter for workspace alias. Only the workspaces with aliases that begin with this value will be returned.
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWorkspaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListWorkspaces::set_max_results): Maximum results to return in response (default=100, maximum=1000).
    /// - On success, responds with [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput) with field(s):
    ///   - [`workspaces(Option<Vec<WorkspaceSummary>>)`](crate::output::ListWorkspacesOutput::workspaces): The list of existing workspaces, including those undergoing creation or deletion.
    ///   - [`next_token(Option<String>)`](crate::output::ListWorkspacesOutput::next_token): Pagination token to use when requesting the next page in this list.
    /// - On failure, responds with [`SdkError<ListWorkspacesError>`](crate::error::ListWorkspacesError)
    pub fn list_workspaces(&self) -> fluent_builders::ListWorkspaces<C, M, R> {
        fluent_builders::ListWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAlertManagerDefinition`](crate::client::fluent_builders::PutAlertManagerDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::PutAlertManagerDefinition::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::PutAlertManagerDefinition::set_workspace_id): The ID of the workspace in which to update the alert manager definition.
    ///   - [`data(Blob)`](crate::client::fluent_builders::PutAlertManagerDefinition::data) / [`set_data(Option<Blob>)`](crate::client::fluent_builders::PutAlertManagerDefinition::set_data): The alert manager definition data.
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::PutAlertManagerDefinition::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::PutAlertManagerDefinition::set_client_token): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
    /// - On success, responds with [`PutAlertManagerDefinitionOutput`](crate::output::PutAlertManagerDefinitionOutput) with field(s):
    ///   - [`status(Option<AlertManagerDefinitionStatus>)`](crate::output::PutAlertManagerDefinitionOutput::status): The status of alert manager definition.
    /// - On failure, responds with [`SdkError<PutAlertManagerDefinitionError>`](crate::error::PutAlertManagerDefinitionError)
    pub fn put_alert_manager_definition(
        &self,
    ) -> fluent_builders::PutAlertManagerDefinition<C, M, R> {
        fluent_builders::PutAlertManagerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRuleGroupsNamespace`](crate::client::fluent_builders::PutRuleGroupsNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::PutRuleGroupsNamespace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::PutRuleGroupsNamespace::set_workspace_id): The ID of the workspace in which to update the rule group namespace.
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutRuleGroupsNamespace::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutRuleGroupsNamespace::set_name): The rule groups namespace name.
    ///   - [`data(Blob)`](crate::client::fluent_builders::PutRuleGroupsNamespace::data) / [`set_data(Option<Blob>)`](crate::client::fluent_builders::PutRuleGroupsNamespace::set_data): The namespace data that define the rule groups.
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::PutRuleGroupsNamespace::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::PutRuleGroupsNamespace::set_client_token): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
    /// - On success, responds with [`PutRuleGroupsNamespaceOutput`](crate::output::PutRuleGroupsNamespaceOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::PutRuleGroupsNamespaceOutput::name): The rule groups namespace name.
    ///   - [`arn(Option<String>)`](crate::output::PutRuleGroupsNamespaceOutput::arn): The Amazon Resource Name (ARN) of this rule groups namespace.
    ///   - [`status(Option<RuleGroupsNamespaceStatus>)`](crate::output::PutRuleGroupsNamespaceOutput::status): The status of rule groups namespace.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::PutRuleGroupsNamespaceOutput::tags): The tags of this rule groups namespace.
    /// - On failure, responds with [`SdkError<PutRuleGroupsNamespaceError>`](crate::error::PutRuleGroupsNamespaceError)
    pub fn put_rule_groups_namespace(&self) -> fluent_builders::PutRuleGroupsNamespace<C, M, R> {
        fluent_builders::PutRuleGroupsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): The ARN of the resource.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): The list of tags assigned to the resource.
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): The ARN of the resource.
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): One or more tag keys
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWorkspaceAlias`](crate::client::fluent_builders::UpdateWorkspaceAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspaceAlias::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkspaceAlias::set_workspace_id): The ID of the workspace being updated.
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspaceAlias::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::UpdateWorkspaceAlias::set_alias): The new alias of the workspace.
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspaceAlias::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateWorkspaceAlias::set_client_token): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
    /// - On success, responds with [`UpdateWorkspaceAliasOutput`](crate::output::UpdateWorkspaceAliasOutput)

    /// - On failure, responds with [`SdkError<UpdateWorkspaceAliasError>`](crate::error::UpdateWorkspaceAliasError)
    pub fn update_workspace_alias(&self) -> fluent_builders::UpdateWorkspaceAlias<C, M, R> {
        fluent_builders::UpdateWorkspaceAlias::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAlertManagerDefinition`.
    ///
    /// Create an alert manager definition.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAlertManagerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_alert_manager_definition_input::Builder,
    }
    impl<C, M, R> CreateAlertManagerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAlertManagerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAlertManagerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAlertManagerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAlertManagerDefinitionInputOperationOutputAlias,
                crate::output::CreateAlertManagerDefinitionOutput,
                crate::error::CreateAlertManagerDefinitionError,
                crate::input::CreateAlertManagerDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to create the alert manager definition.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace in which to create the alert manager definition.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The alert manager definition data.
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.data(input);
            self
        }
        /// The alert manager definition data.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleGroupsNamespace`.
    ///
    /// Create a rule group namespace.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRuleGroupsNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rule_groups_namespace_input::Builder,
    }
    impl<C, M, R> CreateRuleGroupsNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRuleGroupsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleGroupsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleGroupsNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRuleGroupsNamespaceInputOperationOutputAlias,
                crate::output::CreateRuleGroupsNamespaceOutput,
                crate::error::CreateRuleGroupsNamespaceError,
                crate::input::CreateRuleGroupsNamespaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to create the rule group namespace.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace in which to create the rule group namespace.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The rule groups namespace name.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// The namespace data that define the rule groups.
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.data(input);
            self
        }
        /// The namespace data that define the rule groups.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Optional, user-provided tags for this rule groups namespace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// Optional, user-provided tags for this rule groups namespace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkspace`.
    ///
    /// Creates a new AMP workspace.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workspace_input::Builder,
    }
    impl<C, M, R> CreateWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkspaceInputOperationOutputAlias,
                crate::output::CreateWorkspaceOutput,
                crate::error::CreateWorkspaceError,
                crate::input::CreateWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// An optional user-assigned alias for this workspace. This alias is for user reference and does not need to be unique.
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// An optional user-assigned alias for this workspace. This alias is for user reference and does not need to be unique.
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Optional, user-provided tags for this workspace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// Optional, user-provided tags for this workspace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlertManagerDefinition`.
    ///
    /// Deletes an alert manager definition.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAlertManagerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_alert_manager_definition_input::Builder,
    }
    impl<C, M, R> DeleteAlertManagerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAlertManagerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAlertManagerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAlertManagerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAlertManagerDefinitionInputOperationOutputAlias,
                crate::output::DeleteAlertManagerDefinitionOutput,
                crate::error::DeleteAlertManagerDefinitionError,
                crate::input::DeleteAlertManagerDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to delete the alert manager definition.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace in which to delete the alert manager definition.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleGroupsNamespace`.
    ///
    /// Delete a rule groups namespace.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRuleGroupsNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rule_groups_namespace_input::Builder,
    }
    impl<C, M, R> DeleteRuleGroupsNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRuleGroupsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleGroupsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleGroupsNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRuleGroupsNamespaceInputOperationOutputAlias,
                crate::output::DeleteRuleGroupsNamespaceOutput,
                crate::error::DeleteRuleGroupsNamespaceError,
                crate::input::DeleteRuleGroupsNamespaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to delete rule group definition.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace to delete rule group definition.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The rule groups namespace name.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkspace`.
    ///
    /// Deletes an AMP workspace.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workspace_input::Builder,
    }
    impl<C, M, R> DeleteWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkspaceInputOperationOutputAlias,
                crate::output::DeleteWorkspaceOutput,
                crate::error::DeleteWorkspaceError,
                crate::input::DeleteWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to delete.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace to delete.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAlertManagerDefinition`.
    ///
    /// Describes an alert manager definition.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAlertManagerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_alert_manager_definition_input::Builder,
    }
    impl<C, M, R> DescribeAlertManagerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAlertManagerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAlertManagerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAlertManagerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAlertManagerDefinitionInputOperationOutputAlias,
                crate::output::DescribeAlertManagerDefinitionOutput,
                crate::error::DescribeAlertManagerDefinitionError,
                crate::input::DescribeAlertManagerDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to describe.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace to describe.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRuleGroupsNamespace`.
    ///
    /// Describe a rule groups namespace.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRuleGroupsNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_rule_groups_namespace_input::Builder,
    }
    impl<C, M, R> DescribeRuleGroupsNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRuleGroupsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRuleGroupsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRuleGroupsNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRuleGroupsNamespaceInputOperationOutputAlias,
                crate::output::DescribeRuleGroupsNamespaceOutput,
                crate::error::DescribeRuleGroupsNamespaceError,
                crate::input::DescribeRuleGroupsNamespaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to describe.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace to describe.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The rule groups namespace.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// The rule groups namespace.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspace`.
    ///
    /// Describes an existing AMP workspace.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workspace_input::Builder,
    }
    impl<C, M, R> DescribeWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkspaceInputOperationOutputAlias,
                crate::output::DescribeWorkspaceOutput,
                crate::error::DescribeWorkspaceError,
                crate::input::DescribeWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to describe.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace to describe.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleGroupsNamespaces`.
    ///
    /// Lists rule groups namespaces.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRuleGroupsNamespaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rule_groups_namespaces_input::Builder,
    }
    impl<C, M, R> ListRuleGroupsNamespaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRuleGroupsNamespaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleGroupsNamespacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleGroupsNamespacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRuleGroupsNamespacesInputOperationOutputAlias,
                crate::output::ListRuleGroupsNamespacesOutput,
                crate::error::ListRuleGroupsNamespacesError,
                crate::input::ListRuleGroupsNamespacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRuleGroupsNamespacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRuleGroupsNamespacesPaginator<C, M, R> {
            crate::paginator::ListRuleGroupsNamespacesPaginator::new(self.handle, self.inner)
        }
        /// The ID of the workspace.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Optional filter for rule groups namespace name. Only the rule groups namespace that begin with this value will be returned.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// Optional filter for rule groups namespace name. Only the rule groups namespace that begin with this value will be returned.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListRuleGroupsNamespaces request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListRuleGroupsNamespaces request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Maximum results to return in response (default=100, maximum=1000).
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Maximum results to return in response (default=100, maximum=1000).
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// Lists the tags you have assigned to the resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The ARN of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkspaces`.
    ///
    /// Lists all AMP workspaces, including workspaces being created or deleted.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workspaces_input::Builder,
    }
    impl<C, M, R> ListWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkspacesInputOperationOutputAlias,
                crate::output::ListWorkspacesOutput,
                crate::error::ListWorkspacesError,
                crate::input::ListWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkspacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkspacesPaginator<C, M, R> {
            crate::paginator::ListWorkspacesPaginator::new(self.handle, self.inner)
        }
        /// Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListWorkspaces request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListWorkspaces request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Optional filter for workspace alias. Only the workspaces with aliases that begin with this value will be returned.
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// Optional filter for workspace alias. Only the workspaces with aliases that begin with this value will be returned.
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// Maximum results to return in response (default=100, maximum=1000).
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Maximum results to return in response (default=100, maximum=1000).
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAlertManagerDefinition`.
    ///
    /// Update an alert manager definition.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAlertManagerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_alert_manager_definition_input::Builder,
    }
    impl<C, M, R> PutAlertManagerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAlertManagerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAlertManagerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAlertManagerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAlertManagerDefinitionInputOperationOutputAlias,
                crate::output::PutAlertManagerDefinitionOutput,
                crate::error::PutAlertManagerDefinitionError,
                crate::input::PutAlertManagerDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to update the alert manager definition.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace in which to update the alert manager definition.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The alert manager definition data.
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.data(input);
            self
        }
        /// The alert manager definition data.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRuleGroupsNamespace`.
    ///
    /// Update a rule groups namespace.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRuleGroupsNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_rule_groups_namespace_input::Builder,
    }
    impl<C, M, R> PutRuleGroupsNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRuleGroupsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRuleGroupsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRuleGroupsNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRuleGroupsNamespaceInputOperationOutputAlias,
                crate::output::PutRuleGroupsNamespaceOutput,
                crate::error::PutRuleGroupsNamespaceError,
                crate::input::PutRuleGroupsNamespaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to update the rule group namespace.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace in which to update the rule group namespace.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The rule groups namespace name.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// The namespace data that define the rule groups.
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.data(input);
            self
        }
        /// The namespace data that define the rule groups.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// Creates tags for the specified resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The ARN of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The list of tags assigned to the resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// The list of tags assigned to the resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// Deletes tags from the specified resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The ARN of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// One or more tag keys
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// One or more tag keys
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspaceAlias`.
    ///
    /// Updates an AMP workspace alias.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkspaceAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workspace_alias_input::Builder,
    }
    impl<C, M, R> UpdateWorkspaceAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkspaceAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkspaceAliasInputOperationOutputAlias,
                crate::output::UpdateWorkspaceAliasOutput,
                crate::error::UpdateWorkspaceAliasError,
                crate::input::UpdateWorkspaceAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace being updated.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// The ID of the workspace being updated.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The new alias of the workspace.
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// The new alias of the workspace.
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
