// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Prometheus Service
///
/// Client for invoking operations on Amazon Prometheus Service. Each operation on Amazon Prometheus Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_amp::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_amp::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_amp::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateAlertManagerDefinition` operation.
    ///
    /// See [`CreateAlertManagerDefinition`](crate::client::fluent_builders::CreateAlertManagerDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_alert_manager_definition(
        &self,
    ) -> fluent_builders::CreateAlertManagerDefinition<C, M, R> {
        fluent_builders::CreateAlertManagerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRuleGroupsNamespace` operation.
    ///
    /// See [`CreateRuleGroupsNamespace`](crate::client::fluent_builders::CreateRuleGroupsNamespace) for more information about the
    /// operation and its arguments.
    pub fn create_rule_groups_namespace(
        &self,
    ) -> fluent_builders::CreateRuleGroupsNamespace<C, M, R> {
        fluent_builders::CreateRuleGroupsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkspace` operation.
    ///
    /// See [`CreateWorkspace`](crate::client::fluent_builders::CreateWorkspace) for more information about the
    /// operation and its arguments.
    pub fn create_workspace(&self) -> fluent_builders::CreateWorkspace<C, M, R> {
        fluent_builders::CreateWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAlertManagerDefinition` operation.
    ///
    /// See [`DeleteAlertManagerDefinition`](crate::client::fluent_builders::DeleteAlertManagerDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_alert_manager_definition(
        &self,
    ) -> fluent_builders::DeleteAlertManagerDefinition<C, M, R> {
        fluent_builders::DeleteAlertManagerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRuleGroupsNamespace` operation.
    ///
    /// See [`DeleteRuleGroupsNamespace`](crate::client::fluent_builders::DeleteRuleGroupsNamespace) for more information about the
    /// operation and its arguments.
    pub fn delete_rule_groups_namespace(
        &self,
    ) -> fluent_builders::DeleteRuleGroupsNamespace<C, M, R> {
        fluent_builders::DeleteRuleGroupsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkspace` operation.
    ///
    /// See [`DeleteWorkspace`](crate::client::fluent_builders::DeleteWorkspace) for more information about the
    /// operation and its arguments.
    pub fn delete_workspace(&self) -> fluent_builders::DeleteWorkspace<C, M, R> {
        fluent_builders::DeleteWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAlertManagerDefinition` operation.
    ///
    /// See [`DescribeAlertManagerDefinition`](crate::client::fluent_builders::DescribeAlertManagerDefinition) for more information about the
    /// operation and its arguments.
    pub fn describe_alert_manager_definition(
        &self,
    ) -> fluent_builders::DescribeAlertManagerDefinition<C, M, R> {
        fluent_builders::DescribeAlertManagerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRuleGroupsNamespace` operation.
    ///
    /// See [`DescribeRuleGroupsNamespace`](crate::client::fluent_builders::DescribeRuleGroupsNamespace) for more information about the
    /// operation and its arguments.
    pub fn describe_rule_groups_namespace(
        &self,
    ) -> fluent_builders::DescribeRuleGroupsNamespace<C, M, R> {
        fluent_builders::DescribeRuleGroupsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkspace` operation.
    ///
    /// See [`DescribeWorkspace`](crate::client::fluent_builders::DescribeWorkspace) for more information about the
    /// operation and its arguments.
    pub fn describe_workspace(&self) -> fluent_builders::DescribeWorkspace<C, M, R> {
        fluent_builders::DescribeWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRuleGroupsNamespaces` operation.
    ///
    /// See [`ListRuleGroupsNamespaces`](crate::client::fluent_builders::ListRuleGroupsNamespaces) for more information about the
    /// operation and its arguments.
    pub fn list_rule_groups_namespaces(
        &self,
    ) -> fluent_builders::ListRuleGroupsNamespaces<C, M, R> {
        fluent_builders::ListRuleGroupsNamespaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkspaces` operation.
    ///
    /// See [`ListWorkspaces`](crate::client::fluent_builders::ListWorkspaces) for more information about the
    /// operation and its arguments.
    pub fn list_workspaces(&self) -> fluent_builders::ListWorkspaces<C, M, R> {
        fluent_builders::ListWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAlertManagerDefinition` operation.
    ///
    /// See [`PutAlertManagerDefinition`](crate::client::fluent_builders::PutAlertManagerDefinition) for more information about the
    /// operation and its arguments.
    pub fn put_alert_manager_definition(
        &self,
    ) -> fluent_builders::PutAlertManagerDefinition<C, M, R> {
        fluent_builders::PutAlertManagerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRuleGroupsNamespace` operation.
    ///
    /// See [`PutRuleGroupsNamespace`](crate::client::fluent_builders::PutRuleGroupsNamespace) for more information about the
    /// operation and its arguments.
    pub fn put_rule_groups_namespace(&self) -> fluent_builders::PutRuleGroupsNamespace<C, M, R> {
        fluent_builders::PutRuleGroupsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkspaceAlias` operation.
    ///
    /// See [`UpdateWorkspaceAlias`](crate::client::fluent_builders::UpdateWorkspaceAlias) for more information about the
    /// operation and its arguments.
    pub fn update_workspace_alias(&self) -> fluent_builders::UpdateWorkspaceAlias<C, M, R> {
        fluent_builders::UpdateWorkspaceAlias::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAlertManagerDefinition`.
    ///
    /// Create an alert manager definition.
    #[derive(std::fmt::Debug)]
    pub struct CreateAlertManagerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_alert_manager_definition_input::Builder,
    }
    impl<C, M, R> CreateAlertManagerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAlertManagerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAlertManagerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAlertManagerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAlertManagerDefinitionInputOperationOutputAlias,
                crate::output::CreateAlertManagerDefinitionOutput,
                crate::error::CreateAlertManagerDefinitionError,
                crate::input::CreateAlertManagerDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to create the alert manager definition.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace in which to create the alert manager definition.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The alert manager definition data.
        pub fn data(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.data(inp);
            self
        }
        /// The alert manager definition data.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleGroupsNamespace`.
    ///
    /// Create a rule group namespace.
    #[derive(std::fmt::Debug)]
    pub struct CreateRuleGroupsNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rule_groups_namespace_input::Builder,
    }
    impl<C, M, R> CreateRuleGroupsNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRuleGroupsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleGroupsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleGroupsNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRuleGroupsNamespaceInputOperationOutputAlias,
                crate::output::CreateRuleGroupsNamespaceOutput,
                crate::error::CreateRuleGroupsNamespaceError,
                crate::input::CreateRuleGroupsNamespaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to create the rule group namespace.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace in which to create the rule group namespace.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The rule groups namespace name.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// The namespace data that define the rule groups.
        pub fn data(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.data(inp);
            self
        }
        /// The namespace data that define the rule groups.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Optional, user-provided tags for this rule groups namespace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Optional, user-provided tags for this rule groups namespace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkspace`.
    ///
    /// Creates a new AMP workspace.
    #[derive(std::fmt::Debug)]
    pub struct CreateWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workspace_input::Builder,
    }
    impl<C, M, R> CreateWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkspaceInputOperationOutputAlias,
                crate::output::CreateWorkspaceOutput,
                crate::error::CreateWorkspaceError,
                crate::input::CreateWorkspaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// An optional user-assigned alias for this workspace. This alias is for user reference and does not need to be unique.
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// An optional user-assigned alias for this workspace. This alias is for user reference and does not need to be unique.
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Optional, user-provided tags for this workspace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Optional, user-provided tags for this workspace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlertManagerDefinition`.
    ///
    /// Deletes an alert manager definition.
    #[derive(std::fmt::Debug)]
    pub struct DeleteAlertManagerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_alert_manager_definition_input::Builder,
    }
    impl<C, M, R> DeleteAlertManagerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAlertManagerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAlertManagerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAlertManagerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAlertManagerDefinitionInputOperationOutputAlias,
                crate::output::DeleteAlertManagerDefinitionOutput,
                crate::error::DeleteAlertManagerDefinitionError,
                crate::input::DeleteAlertManagerDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to delete the alert manager definition.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace in which to delete the alert manager definition.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleGroupsNamespace`.
    ///
    /// Delete a rule groups namespace.
    #[derive(std::fmt::Debug)]
    pub struct DeleteRuleGroupsNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rule_groups_namespace_input::Builder,
    }
    impl<C, M, R> DeleteRuleGroupsNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRuleGroupsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleGroupsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleGroupsNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRuleGroupsNamespaceInputOperationOutputAlias,
                crate::output::DeleteRuleGroupsNamespaceOutput,
                crate::error::DeleteRuleGroupsNamespaceError,
                crate::input::DeleteRuleGroupsNamespaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to delete rule group definition.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace to delete rule group definition.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The rule groups namespace name.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkspace`.
    ///
    /// Deletes an AMP workspace.
    #[derive(std::fmt::Debug)]
    pub struct DeleteWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workspace_input::Builder,
    }
    impl<C, M, R> DeleteWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkspaceInputOperationOutputAlias,
                crate::output::DeleteWorkspaceOutput,
                crate::error::DeleteWorkspaceError,
                crate::input::DeleteWorkspaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to delete.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace to delete.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAlertManagerDefinition`.
    ///
    /// Describes an alert manager definition.
    #[derive(std::fmt::Debug)]
    pub struct DescribeAlertManagerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_alert_manager_definition_input::Builder,
    }
    impl<C, M, R> DescribeAlertManagerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAlertManagerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAlertManagerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAlertManagerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAlertManagerDefinitionInputOperationOutputAlias,
                crate::output::DescribeAlertManagerDefinitionOutput,
                crate::error::DescribeAlertManagerDefinitionError,
                crate::input::DescribeAlertManagerDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to describe.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace to describe.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRuleGroupsNamespace`.
    ///
    /// Describe a rule groups namespace.
    #[derive(std::fmt::Debug)]
    pub struct DescribeRuleGroupsNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_rule_groups_namespace_input::Builder,
    }
    impl<C, M, R> DescribeRuleGroupsNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRuleGroupsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRuleGroupsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRuleGroupsNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRuleGroupsNamespaceInputOperationOutputAlias,
                crate::output::DescribeRuleGroupsNamespaceOutput,
                crate::error::DescribeRuleGroupsNamespaceError,
                crate::input::DescribeRuleGroupsNamespaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to describe.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace to describe.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The rule groups namespace.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The rule groups namespace.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspace`.
    ///
    /// Describes an existing AMP workspace.
    #[derive(std::fmt::Debug)]
    pub struct DescribeWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workspace_input::Builder,
    }
    impl<C, M, R> DescribeWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkspaceInputOperationOutputAlias,
                crate::output::DescribeWorkspaceOutput,
                crate::error::DescribeWorkspaceError,
                crate::input::DescribeWorkspaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace to describe.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace to describe.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleGroupsNamespaces`.
    ///
    /// Lists rule groups namespaces.
    #[derive(std::fmt::Debug)]
    pub struct ListRuleGroupsNamespaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rule_groups_namespaces_input::Builder,
    }
    impl<C, M, R> ListRuleGroupsNamespaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRuleGroupsNamespaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleGroupsNamespacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleGroupsNamespacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRuleGroupsNamespacesInputOperationOutputAlias,
                crate::output::ListRuleGroupsNamespacesOutput,
                crate::error::ListRuleGroupsNamespacesError,
                crate::input::ListRuleGroupsNamespacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Optional filter for rule groups namespace name. Only the rule groups namespace that begin with this value will be returned.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// Optional filter for rule groups namespace name. Only the rule groups namespace that begin with this value will be returned.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListRuleGroupsNamespaces request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListRuleGroupsNamespaces request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Maximum results to return in response (default=100, maximum=1000).
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Maximum results to return in response (default=100, maximum=1000).
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// Lists the tags you have assigned to the resource.
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the resource.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The ARN of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkspaces`.
    ///
    /// Lists all AMP workspaces, including workspaces being created or deleted.
    #[derive(std::fmt::Debug)]
    pub struct ListWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workspaces_input::Builder,
    }
    impl<C, M, R> ListWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkspacesInputOperationOutputAlias,
                crate::output::ListWorkspacesOutput,
                crate::error::ListWorkspacesError,
                crate::input::ListWorkspacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListWorkspaces request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListWorkspaces request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Optional filter for workspace alias. Only the workspaces with aliases that begin with this value will be returned.
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// Optional filter for workspace alias. Only the workspaces with aliases that begin with this value will be returned.
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// Maximum results to return in response (default=100, maximum=1000).
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Maximum results to return in response (default=100, maximum=1000).
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAlertManagerDefinition`.
    ///
    /// Update an alert manager definition.
    #[derive(std::fmt::Debug)]
    pub struct PutAlertManagerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_alert_manager_definition_input::Builder,
    }
    impl<C, M, R> PutAlertManagerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAlertManagerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAlertManagerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAlertManagerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAlertManagerDefinitionInputOperationOutputAlias,
                crate::output::PutAlertManagerDefinitionOutput,
                crate::error::PutAlertManagerDefinitionError,
                crate::input::PutAlertManagerDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to update the alert manager definition.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace in which to update the alert manager definition.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The alert manager definition data.
        pub fn data(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.data(inp);
            self
        }
        /// The alert manager definition data.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRuleGroupsNamespace`.
    ///
    /// Update a rule groups namespace.
    #[derive(std::fmt::Debug)]
    pub struct PutRuleGroupsNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_rule_groups_namespace_input::Builder,
    }
    impl<C, M, R> PutRuleGroupsNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRuleGroupsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRuleGroupsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRuleGroupsNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRuleGroupsNamespaceInputOperationOutputAlias,
                crate::output::PutRuleGroupsNamespaceOutput,
                crate::error::PutRuleGroupsNamespaceError,
                crate::input::PutRuleGroupsNamespaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace in which to update the rule group namespace.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace in which to update the rule group namespace.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The rule groups namespace name.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// The namespace data that define the rule groups.
        pub fn data(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.data(inp);
            self
        }
        /// The namespace data that define the rule groups.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// Creates tags for the specified resource.
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the resource.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The ARN of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The list of tags assigned to the resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// The list of tags assigned to the resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// Deletes tags from the specified resource.
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the resource.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The ARN of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// One or more tag keys
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// One or more tag keys
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspaceAlias`.
    ///
    /// Updates an AMP workspace alias.
    #[derive(std::fmt::Debug)]
    pub struct UpdateWorkspaceAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workspace_alias_input::Builder,
    }
    impl<C, M, R> UpdateWorkspaceAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkspaceAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkspaceAliasInputOperationOutputAlias,
                crate::output::UpdateWorkspaceAliasOutput,
                crate::error::UpdateWorkspaceAliasError,
                crate::input::UpdateWorkspaceAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the workspace being updated.
        pub fn workspace_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(inp);
            self
        }
        /// The ID of the workspace being updated.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// The new alias of the workspace.
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// The new alias of the workspace.
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
