// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Represents the output of a ListWorkspaces operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkspacesOutput {
    /// The list of existing workspaces, including those undergoing creation or deletion.
    pub workspaces: std::option::Option<std::vec::Vec<crate::model::WorkspaceSummary>>,
    /// Pagination token to use when requesting the next page in this list.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkspacesOutput {
    /// The list of existing workspaces, including those undergoing creation or deletion.
    pub fn workspaces(&self) -> std::option::Option<&[crate::model::WorkspaceSummary]> {
        self.workspaces.as_deref()
    }
    /// Pagination token to use when requesting the next page in this list.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkspacesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkspacesOutput");
        formatter.field("workspaces", &self.workspaces);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
pub mod list_workspaces_output {
    /// A builder for [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspaces: std::option::Option<std::vec::Vec<crate::model::WorkspaceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `workspaces`.
        ///
        /// To override the contents of this collection use [`set_workspaces`](Self::set_workspaces).
        ///
        /// The list of existing workspaces, including those undergoing creation or deletion.
        pub fn workspaces(mut self, input: impl Into<crate::model::WorkspaceSummary>) -> Self {
            let mut v = self.workspaces.unwrap_or_default();
            v.push(input.into());
            self.workspaces = Some(v);
            self
        }
        /// The list of existing workspaces, including those undergoing creation or deletion.
        pub fn set_workspaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkspaceSummary>>,
        ) -> Self {
            self.workspaces = input;
            self
        }
        /// Pagination token to use when requesting the next page in this list.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Pagination token to use when requesting the next page in this list.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
        pub fn build(self) -> crate::output::ListWorkspacesOutput {
            crate::output::ListWorkspacesOutput {
                workspaces: self.workspaces,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorkspacesOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
    pub fn builder() -> crate::output::list_workspaces_output::Builder {
        crate::output::list_workspaces_output::Builder::default()
    }
}

/// Represents the output of a CreateWorkspace operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkspaceOutput {
    /// The generated ID of the workspace that was just created.
    pub workspace_id: std::option::Option<std::string::String>,
    /// The ARN of the workspace that was just created.
    pub arn: std::option::Option<std::string::String>,
    /// The status of the workspace that was just created (usually CREATING).
    pub status: std::option::Option<crate::model::WorkspaceStatus>,
    /// The tags of this workspace.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateWorkspaceOutput {
    /// The generated ID of the workspace that was just created.
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// The ARN of the workspace that was just created.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The status of the workspace that was just created (usually CREATING).
    pub fn status(&self) -> std::option::Option<&crate::model::WorkspaceStatus> {
        self.status.as_ref()
    }
    /// The tags of this workspace.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkspaceOutput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
pub mod create_workspace_output {
    /// A builder for [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::WorkspaceStatus>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The generated ID of the workspace that was just created.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// The generated ID of the workspace that was just created.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// The ARN of the workspace that was just created.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the workspace that was just created.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The status of the workspace that was just created (usually CREATING).
        pub fn status(mut self, input: crate::model::WorkspaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of the workspace that was just created (usually CREATING).
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorkspaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags of this workspace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// The tags of this workspace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
        pub fn build(self) -> crate::output::CreateWorkspaceOutput {
            crate::output::CreateWorkspaceOutput {
                workspace_id: self.workspace_id,
                arn: self.arn,
                status: self.status,
                tags: self.tags,
            }
        }
    }
}
impl CreateWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
    pub fn builder() -> crate::output::create_workspace_output::Builder {
        crate::output::create_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkspaceOutput {}
impl std::fmt::Debug for DeleteWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkspaceOutput");
        formatter.finish()
    }
}
/// See [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
pub mod delete_workspace_output {
    /// A builder for [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
        pub fn build(self) -> crate::output::DeleteWorkspaceOutput {
            crate::output::DeleteWorkspaceOutput {}
        }
    }
}
impl DeleteWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
    pub fn builder() -> crate::output::delete_workspace_output::Builder {
        crate::output::delete_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkspaceAliasOutput {}
impl std::fmt::Debug for UpdateWorkspaceAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkspaceAliasOutput");
        formatter.finish()
    }
}
/// See [`UpdateWorkspaceAliasOutput`](crate::output::UpdateWorkspaceAliasOutput)
pub mod update_workspace_alias_output {
    /// A builder for [`UpdateWorkspaceAliasOutput`](crate::output::UpdateWorkspaceAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateWorkspaceAliasOutput`](crate::output::UpdateWorkspaceAliasOutput)
        pub fn build(self) -> crate::output::UpdateWorkspaceAliasOutput {
            crate::output::UpdateWorkspaceAliasOutput {}
        }
    }
}
impl UpdateWorkspaceAliasOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceAliasOutput`](crate::output::UpdateWorkspaceAliasOutput)
    pub fn builder() -> crate::output::update_workspace_alias_output::Builder {
        crate::output::update_workspace_alias_output::Builder::default()
    }
}

/// Represents the output of a DescribeWorkspace operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceOutput {
    /// The properties of the selected workspace.
    pub workspace: std::option::Option<crate::model::WorkspaceDescription>,
}
impl DescribeWorkspaceOutput {
    /// The properties of the selected workspace.
    pub fn workspace(&self) -> std::option::Option<&crate::model::WorkspaceDescription> {
        self.workspace.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceOutput");
        formatter.field("workspace", &self.workspace);
        formatter.finish()
    }
}
/// See [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput)
pub mod describe_workspace_output {
    /// A builder for [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace: std::option::Option<crate::model::WorkspaceDescription>,
    }
    impl Builder {
        /// The properties of the selected workspace.
        pub fn workspace(mut self, input: crate::model::WorkspaceDescription) -> Self {
            self.workspace = Some(input);
            self
        }
        /// The properties of the selected workspace.
        pub fn set_workspace(
            mut self,
            input: std::option::Option<crate::model::WorkspaceDescription>,
        ) -> Self {
            self.workspace = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput)
        pub fn build(self) -> crate::output::DescribeWorkspaceOutput {
            crate::output::DescribeWorkspaceOutput {
                workspace: self.workspace,
            }
        }
    }
}
impl DescribeWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput)
    pub fn builder() -> crate::output::describe_workspace_output::Builder {
        crate::output::describe_workspace_output::Builder::default()
    }
}

/// Represents the output of a ListRuleGroupsNamespaces operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRuleGroupsNamespacesOutput {
    /// The list of the selected rule groups namespaces.
    pub rule_groups_namespaces:
        std::option::Option<std::vec::Vec<crate::model::RuleGroupsNamespaceSummary>>,
    /// Pagination token to use when requesting the next page in this list.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRuleGroupsNamespacesOutput {
    /// The list of the selected rule groups namespaces.
    pub fn rule_groups_namespaces(
        &self,
    ) -> std::option::Option<&[crate::model::RuleGroupsNamespaceSummary]> {
        self.rule_groups_namespaces.as_deref()
    }
    /// Pagination token to use when requesting the next page in this list.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRuleGroupsNamespacesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRuleGroupsNamespacesOutput");
        formatter.field("rule_groups_namespaces", &self.rule_groups_namespaces);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRuleGroupsNamespacesOutput`](crate::output::ListRuleGroupsNamespacesOutput)
pub mod list_rule_groups_namespaces_output {
    /// A builder for [`ListRuleGroupsNamespacesOutput`](crate::output::ListRuleGroupsNamespacesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_groups_namespaces:
            std::option::Option<std::vec::Vec<crate::model::RuleGroupsNamespaceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rule_groups_namespaces`.
        ///
        /// To override the contents of this collection use [`set_rule_groups_namespaces`](Self::set_rule_groups_namespaces).
        ///
        /// The list of the selected rule groups namespaces.
        pub fn rule_groups_namespaces(
            mut self,
            input: impl Into<crate::model::RuleGroupsNamespaceSummary>,
        ) -> Self {
            let mut v = self.rule_groups_namespaces.unwrap_or_default();
            v.push(input.into());
            self.rule_groups_namespaces = Some(v);
            self
        }
        /// The list of the selected rule groups namespaces.
        pub fn set_rule_groups_namespaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleGroupsNamespaceSummary>>,
        ) -> Self {
            self.rule_groups_namespaces = input;
            self
        }
        /// Pagination token to use when requesting the next page in this list.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Pagination token to use when requesting the next page in this list.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRuleGroupsNamespacesOutput`](crate::output::ListRuleGroupsNamespacesOutput)
        pub fn build(self) -> crate::output::ListRuleGroupsNamespacesOutput {
            crate::output::ListRuleGroupsNamespacesOutput {
                rule_groups_namespaces: self.rule_groups_namespaces,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRuleGroupsNamespacesOutput {
    /// Creates a new builder-style object to manufacture [`ListRuleGroupsNamespacesOutput`](crate::output::ListRuleGroupsNamespacesOutput)
    pub fn builder() -> crate::output::list_rule_groups_namespaces_output::Builder {
        crate::output::list_rule_groups_namespaces_output::Builder::default()
    }
}

/// Represents the output of a CreateRuleGroupsNamespace operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRuleGroupsNamespaceOutput {
    /// The rule groups namespace name.
    pub name: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) of this rule groups namespace.
    pub arn: std::option::Option<std::string::String>,
    /// The status of rule groups namespace.
    pub status: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
    /// The tags of this rule groups namespace.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRuleGroupsNamespaceOutput {
    /// The rule groups namespace name.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The Amazon Resource Name (ARN) of this rule groups namespace.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The status of rule groups namespace.
    pub fn status(&self) -> std::option::Option<&crate::model::RuleGroupsNamespaceStatus> {
        self.status.as_ref()
    }
    /// The tags of this rule groups namespace.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRuleGroupsNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRuleGroupsNamespaceOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateRuleGroupsNamespaceOutput`](crate::output::CreateRuleGroupsNamespaceOutput)
pub mod create_rule_groups_namespace_output {
    /// A builder for [`CreateRuleGroupsNamespaceOutput`](crate::output::CreateRuleGroupsNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The rule groups namespace name.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The Amazon Resource Name (ARN) of this rule groups namespace.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of this rule groups namespace.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The status of rule groups namespace.
        pub fn status(mut self, input: crate::model::RuleGroupsNamespaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of rule groups namespace.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags of this rule groups namespace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// The tags of this rule groups namespace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRuleGroupsNamespaceOutput`](crate::output::CreateRuleGroupsNamespaceOutput)
        pub fn build(self) -> crate::output::CreateRuleGroupsNamespaceOutput {
            crate::output::CreateRuleGroupsNamespaceOutput {
                name: self.name,
                arn: self.arn,
                status: self.status,
                tags: self.tags,
            }
        }
    }
}
impl CreateRuleGroupsNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`CreateRuleGroupsNamespaceOutput`](crate::output::CreateRuleGroupsNamespaceOutput)
    pub fn builder() -> crate::output::create_rule_groups_namespace_output::Builder {
        crate::output::create_rule_groups_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleGroupsNamespaceOutput {}
impl std::fmt::Debug for DeleteRuleGroupsNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleGroupsNamespaceOutput");
        formatter.finish()
    }
}
/// See [`DeleteRuleGroupsNamespaceOutput`](crate::output::DeleteRuleGroupsNamespaceOutput)
pub mod delete_rule_groups_namespace_output {
    /// A builder for [`DeleteRuleGroupsNamespaceOutput`](crate::output::DeleteRuleGroupsNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRuleGroupsNamespaceOutput`](crate::output::DeleteRuleGroupsNamespaceOutput)
        pub fn build(self) -> crate::output::DeleteRuleGroupsNamespaceOutput {
            crate::output::DeleteRuleGroupsNamespaceOutput {}
        }
    }
}
impl DeleteRuleGroupsNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRuleGroupsNamespaceOutput`](crate::output::DeleteRuleGroupsNamespaceOutput)
    pub fn builder() -> crate::output::delete_rule_groups_namespace_output::Builder {
        crate::output::delete_rule_groups_namespace_output::Builder::default()
    }
}

/// Represents the output of a PutRuleGroupsNamespace operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRuleGroupsNamespaceOutput {
    /// The rule groups namespace name.
    pub name: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) of this rule groups namespace.
    pub arn: std::option::Option<std::string::String>,
    /// The status of rule groups namespace.
    pub status: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
    /// The tags of this rule groups namespace.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PutRuleGroupsNamespaceOutput {
    /// The rule groups namespace name.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The Amazon Resource Name (ARN) of this rule groups namespace.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The status of rule groups namespace.
    pub fn status(&self) -> std::option::Option<&crate::model::RuleGroupsNamespaceStatus> {
        self.status.as_ref()
    }
    /// The tags of this rule groups namespace.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for PutRuleGroupsNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRuleGroupsNamespaceOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PutRuleGroupsNamespaceOutput`](crate::output::PutRuleGroupsNamespaceOutput)
pub mod put_rule_groups_namespace_output {
    /// A builder for [`PutRuleGroupsNamespaceOutput`](crate::output::PutRuleGroupsNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The rule groups namespace name.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The Amazon Resource Name (ARN) of this rule groups namespace.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of this rule groups namespace.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The status of rule groups namespace.
        pub fn status(mut self, input: crate::model::RuleGroupsNamespaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of rule groups namespace.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags of this rule groups namespace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// The tags of this rule groups namespace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRuleGroupsNamespaceOutput`](crate::output::PutRuleGroupsNamespaceOutput)
        pub fn build(self) -> crate::output::PutRuleGroupsNamespaceOutput {
            crate::output::PutRuleGroupsNamespaceOutput {
                name: self.name,
                arn: self.arn,
                status: self.status,
                tags: self.tags,
            }
        }
    }
}
impl PutRuleGroupsNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`PutRuleGroupsNamespaceOutput`](crate::output::PutRuleGroupsNamespaceOutput)
    pub fn builder() -> crate::output::put_rule_groups_namespace_output::Builder {
        crate::output::put_rule_groups_namespace_output::Builder::default()
    }
}

/// Represents the output of a DescribeRuleGroupsNamespace operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRuleGroupsNamespaceOutput {
    /// The selected rule groups namespace.
    pub rule_groups_namespace: std::option::Option<crate::model::RuleGroupsNamespaceDescription>,
}
impl DescribeRuleGroupsNamespaceOutput {
    /// The selected rule groups namespace.
    pub fn rule_groups_namespace(
        &self,
    ) -> std::option::Option<&crate::model::RuleGroupsNamespaceDescription> {
        self.rule_groups_namespace.as_ref()
    }
}
impl std::fmt::Debug for DescribeRuleGroupsNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRuleGroupsNamespaceOutput");
        formatter.field("rule_groups_namespace", &self.rule_groups_namespace);
        formatter.finish()
    }
}
/// See [`DescribeRuleGroupsNamespaceOutput`](crate::output::DescribeRuleGroupsNamespaceOutput)
pub mod describe_rule_groups_namespace_output {
    /// A builder for [`DescribeRuleGroupsNamespaceOutput`](crate::output::DescribeRuleGroupsNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_groups_namespace:
            std::option::Option<crate::model::RuleGroupsNamespaceDescription>,
    }
    impl Builder {
        /// The selected rule groups namespace.
        pub fn rule_groups_namespace(
            mut self,
            input: crate::model::RuleGroupsNamespaceDescription,
        ) -> Self {
            self.rule_groups_namespace = Some(input);
            self
        }
        /// The selected rule groups namespace.
        pub fn set_rule_groups_namespace(
            mut self,
            input: std::option::Option<crate::model::RuleGroupsNamespaceDescription>,
        ) -> Self {
            self.rule_groups_namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRuleGroupsNamespaceOutput`](crate::output::DescribeRuleGroupsNamespaceOutput)
        pub fn build(self) -> crate::output::DescribeRuleGroupsNamespaceOutput {
            crate::output::DescribeRuleGroupsNamespaceOutput {
                rule_groups_namespace: self.rule_groups_namespace,
            }
        }
    }
}
impl DescribeRuleGroupsNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRuleGroupsNamespaceOutput`](crate::output::DescribeRuleGroupsNamespaceOutput)
    pub fn builder() -> crate::output::describe_rule_groups_namespace_output::Builder {
        crate::output::describe_rule_groups_namespace_output::Builder::default()
    }
}

/// Represents the output of a CreateAlertManagerDefinition operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAlertManagerDefinitionOutput {
    /// The status of alert manager definition.
    pub status: std::option::Option<crate::model::AlertManagerDefinitionStatus>,
}
impl CreateAlertManagerDefinitionOutput {
    /// The status of alert manager definition.
    pub fn status(&self) -> std::option::Option<&crate::model::AlertManagerDefinitionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CreateAlertManagerDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAlertManagerDefinitionOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateAlertManagerDefinitionOutput`](crate::output::CreateAlertManagerDefinitionOutput)
pub mod create_alert_manager_definition_output {
    /// A builder for [`CreateAlertManagerDefinitionOutput`](crate::output::CreateAlertManagerDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AlertManagerDefinitionStatus>,
    }
    impl Builder {
        /// The status of alert manager definition.
        pub fn status(mut self, input: crate::model::AlertManagerDefinitionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of alert manager definition.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AlertManagerDefinitionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAlertManagerDefinitionOutput`](crate::output::CreateAlertManagerDefinitionOutput)
        pub fn build(self) -> crate::output::CreateAlertManagerDefinitionOutput {
            crate::output::CreateAlertManagerDefinitionOutput {
                status: self.status,
            }
        }
    }
}
impl CreateAlertManagerDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`CreateAlertManagerDefinitionOutput`](crate::output::CreateAlertManagerDefinitionOutput)
    pub fn builder() -> crate::output::create_alert_manager_definition_output::Builder {
        crate::output::create_alert_manager_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAlertManagerDefinitionOutput {}
impl std::fmt::Debug for DeleteAlertManagerDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAlertManagerDefinitionOutput");
        formatter.finish()
    }
}
/// See [`DeleteAlertManagerDefinitionOutput`](crate::output::DeleteAlertManagerDefinitionOutput)
pub mod delete_alert_manager_definition_output {
    /// A builder for [`DeleteAlertManagerDefinitionOutput`](crate::output::DeleteAlertManagerDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAlertManagerDefinitionOutput`](crate::output::DeleteAlertManagerDefinitionOutput)
        pub fn build(self) -> crate::output::DeleteAlertManagerDefinitionOutput {
            crate::output::DeleteAlertManagerDefinitionOutput {}
        }
    }
}
impl DeleteAlertManagerDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAlertManagerDefinitionOutput`](crate::output::DeleteAlertManagerDefinitionOutput)
    pub fn builder() -> crate::output::delete_alert_manager_definition_output::Builder {
        crate::output::delete_alert_manager_definition_output::Builder::default()
    }
}

/// Represents the output of a PutAlertManagerDefinition operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAlertManagerDefinitionOutput {
    /// The status of alert manager definition.
    pub status: std::option::Option<crate::model::AlertManagerDefinitionStatus>,
}
impl PutAlertManagerDefinitionOutput {
    /// The status of alert manager definition.
    pub fn status(&self) -> std::option::Option<&crate::model::AlertManagerDefinitionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for PutAlertManagerDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAlertManagerDefinitionOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`PutAlertManagerDefinitionOutput`](crate::output::PutAlertManagerDefinitionOutput)
pub mod put_alert_manager_definition_output {
    /// A builder for [`PutAlertManagerDefinitionOutput`](crate::output::PutAlertManagerDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AlertManagerDefinitionStatus>,
    }
    impl Builder {
        /// The status of alert manager definition.
        pub fn status(mut self, input: crate::model::AlertManagerDefinitionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of alert manager definition.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AlertManagerDefinitionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAlertManagerDefinitionOutput`](crate::output::PutAlertManagerDefinitionOutput)
        pub fn build(self) -> crate::output::PutAlertManagerDefinitionOutput {
            crate::output::PutAlertManagerDefinitionOutput {
                status: self.status,
            }
        }
    }
}
impl PutAlertManagerDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`PutAlertManagerDefinitionOutput`](crate::output::PutAlertManagerDefinitionOutput)
    pub fn builder() -> crate::output::put_alert_manager_definition_output::Builder {
        crate::output::put_alert_manager_definition_output::Builder::default()
    }
}

/// Represents the output of a DescribeAlertManagerDefinition operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAlertManagerDefinitionOutput {
    /// The properties of the selected workspace's alert manager definition.
    pub alert_manager_definition:
        std::option::Option<crate::model::AlertManagerDefinitionDescription>,
}
impl DescribeAlertManagerDefinitionOutput {
    /// The properties of the selected workspace's alert manager definition.
    pub fn alert_manager_definition(
        &self,
    ) -> std::option::Option<&crate::model::AlertManagerDefinitionDescription> {
        self.alert_manager_definition.as_ref()
    }
}
impl std::fmt::Debug for DescribeAlertManagerDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAlertManagerDefinitionOutput");
        formatter.field("alert_manager_definition", &self.alert_manager_definition);
        formatter.finish()
    }
}
/// See [`DescribeAlertManagerDefinitionOutput`](crate::output::DescribeAlertManagerDefinitionOutput)
pub mod describe_alert_manager_definition_output {
    /// A builder for [`DescribeAlertManagerDefinitionOutput`](crate::output::DescribeAlertManagerDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alert_manager_definition:
            std::option::Option<crate::model::AlertManagerDefinitionDescription>,
    }
    impl Builder {
        /// The properties of the selected workspace's alert manager definition.
        pub fn alert_manager_definition(
            mut self,
            input: crate::model::AlertManagerDefinitionDescription,
        ) -> Self {
            self.alert_manager_definition = Some(input);
            self
        }
        /// The properties of the selected workspace's alert manager definition.
        pub fn set_alert_manager_definition(
            mut self,
            input: std::option::Option<crate::model::AlertManagerDefinitionDescription>,
        ) -> Self {
            self.alert_manager_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAlertManagerDefinitionOutput`](crate::output::DescribeAlertManagerDefinitionOutput)
        pub fn build(self) -> crate::output::DescribeAlertManagerDefinitionOutput {
            crate::output::DescribeAlertManagerDefinitionOutput {
                alert_manager_definition: self.alert_manager_definition,
            }
        }
    }
}
impl DescribeAlertManagerDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAlertManagerDefinitionOutput`](crate::output::DescribeAlertManagerDefinitionOutput)
    pub fn builder() -> crate::output::describe_alert_manager_definition_output::Builder {
        crate::output::describe_alert_manager_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// The list of tags assigned to the resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// The list of tags assigned to the resource.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The list of tags assigned to the resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// The list of tags assigned to the resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}
