// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Stores information about a field passed inside a request that resulted in an exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// The field name.
    pub name: std::option::Option<std::string::String>,
    /// Message describing why the field failed validation.
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// The field name.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Message describing why the field failed validation.
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The field name.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The field name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Message describing why the field failed validation.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Message describing why the field failed validation.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

/// Possible reasons a request failed validation.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "FIELD_VALIDATION_FAILED",
            "OTHER",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Represents a summary of the properties of a workspace.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceSummary {
    /// Unique string identifying this workspace.
    pub workspace_id: std::option::Option<std::string::String>,
    /// Alias of this workspace.
    pub alias: std::option::Option<std::string::String>,
    /// The AmazonResourceName of this workspace.
    pub arn: std::option::Option<std::string::String>,
    /// The status of this workspace.
    pub status: std::option::Option<crate::model::WorkspaceStatus>,
    /// The time when the workspace was created.
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// The tags of this workspace.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl WorkspaceSummary {
    /// Unique string identifying this workspace.
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// Alias of this workspace.
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// The AmazonResourceName of this workspace.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The status of this workspace.
    pub fn status(&self) -> std::option::Option<&crate::model::WorkspaceStatus> {
        self.status.as_ref()
    }
    /// The time when the workspace was created.
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// The tags of this workspace.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceSummary");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("alias", &self.alias);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`WorkspaceSummary`](crate::model::WorkspaceSummary)
pub mod workspace_summary {
    /// A builder for [`WorkspaceSummary`](crate::model::WorkspaceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::WorkspaceStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Unique string identifying this workspace.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// Unique string identifying this workspace.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Alias of this workspace.
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// Alias of this workspace.
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// The AmazonResourceName of this workspace.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The AmazonResourceName of this workspace.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The status of this workspace.
        pub fn status(mut self, input: crate::model::WorkspaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of this workspace.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorkspaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// The time when the workspace was created.
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// The time when the workspace was created.
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags of this workspace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// The tags of this workspace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceSummary`](crate::model::WorkspaceSummary)
        pub fn build(self) -> crate::model::WorkspaceSummary {
            crate::model::WorkspaceSummary {
                workspace_id: self.workspace_id,
                alias: self.alias,
                arn: self.arn,
                status: self.status,
                created_at: self.created_at,
                tags: self.tags,
            }
        }
    }
}
impl WorkspaceSummary {
    /// Creates a new builder-style object to manufacture [`WorkspaceSummary`](crate::model::WorkspaceSummary)
    pub fn builder() -> crate::model::workspace_summary::Builder {
        crate::model::workspace_summary::Builder::default()
    }
}

/// Represents the status of a workspace.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceStatus {
    /// Status code of this workspace.
    pub status_code: std::option::Option<crate::model::WorkspaceStatusCode>,
}
impl WorkspaceStatus {
    /// Status code of this workspace.
    pub fn status_code(&self) -> std::option::Option<&crate::model::WorkspaceStatusCode> {
        self.status_code.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceStatus");
        formatter.field("status_code", &self.status_code);
        formatter.finish()
    }
}
/// See [`WorkspaceStatus`](crate::model::WorkspaceStatus)
pub mod workspace_status {
    /// A builder for [`WorkspaceStatus`](crate::model::WorkspaceStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<crate::model::WorkspaceStatusCode>,
    }
    impl Builder {
        /// Status code of this workspace.
        pub fn status_code(mut self, input: crate::model::WorkspaceStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// Status code of this workspace.
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::WorkspaceStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceStatus`](crate::model::WorkspaceStatus)
        pub fn build(self) -> crate::model::WorkspaceStatus {
            crate::model::WorkspaceStatus {
                status_code: self.status_code,
            }
        }
    }
}
impl WorkspaceStatus {
    /// Creates a new builder-style object to manufacture [`WorkspaceStatus`](crate::model::WorkspaceStatus)
    pub fn builder() -> crate::model::workspace_status::Builder {
        crate::model::workspace_status::Builder::default()
    }
}

/// State of a workspace.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkspaceStatusCode {
    /// Workspace has been created and is usable.
    Active,
    /// Workspace is being created. Deletion is disallowed until status is ACTIVE.
    Creating,
    /// Workspace creation failed. Refer to WorkspaceStatus.failureReason for more details.
    CreationFailed,
    /// Workspace is being deleted. Deletions are allowed only when status is ACTIVE.
    Deleting,
    /// Workspace is being updated. Updates are allowed only when status is ACTIVE.
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkspaceStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => WorkspaceStatusCode::Active,
            "CREATING" => WorkspaceStatusCode::Creating,
            "CREATION_FAILED" => WorkspaceStatusCode::CreationFailed,
            "DELETING" => WorkspaceStatusCode::Deleting,
            "UPDATING" => WorkspaceStatusCode::Updating,
            other => WorkspaceStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkspaceStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkspaceStatusCode::from(s))
    }
}
impl WorkspaceStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkspaceStatusCode::Active => "ACTIVE",
            WorkspaceStatusCode::Creating => "CREATING",
            WorkspaceStatusCode::CreationFailed => "CREATION_FAILED",
            WorkspaceStatusCode::Deleting => "DELETING",
            WorkspaceStatusCode::Updating => "UPDATING",
            WorkspaceStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "CREATION_FAILED",
            "DELETING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for WorkspaceStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Represents the properties of a workspace.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceDescription {
    /// Unique string identifying this workspace.
    pub workspace_id: std::option::Option<std::string::String>,
    /// Alias of this workspace.
    pub alias: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) of this workspace.
    pub arn: std::option::Option<std::string::String>,
    /// The status of this workspace.
    pub status: std::option::Option<crate::model::WorkspaceStatus>,
    /// Prometheus endpoint URI.
    pub prometheus_endpoint: std::option::Option<std::string::String>,
    /// The time when the workspace was created.
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// The tags of this workspace.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl WorkspaceDescription {
    /// Unique string identifying this workspace.
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// Alias of this workspace.
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// The Amazon Resource Name (ARN) of this workspace.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The status of this workspace.
    pub fn status(&self) -> std::option::Option<&crate::model::WorkspaceStatus> {
        self.status.as_ref()
    }
    /// Prometheus endpoint URI.
    pub fn prometheus_endpoint(&self) -> std::option::Option<&str> {
        self.prometheus_endpoint.as_deref()
    }
    /// The time when the workspace was created.
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// The tags of this workspace.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceDescription");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("alias", &self.alias);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("prometheus_endpoint", &self.prometheus_endpoint);
        formatter.field("created_at", &self.created_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`WorkspaceDescription`](crate::model::WorkspaceDescription)
pub mod workspace_description {
    /// A builder for [`WorkspaceDescription`](crate::model::WorkspaceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::WorkspaceStatus>,
        pub(crate) prometheus_endpoint: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Unique string identifying this workspace.
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// Unique string identifying this workspace.
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Alias of this workspace.
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// Alias of this workspace.
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// The Amazon Resource Name (ARN) of this workspace.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of this workspace.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The status of this workspace.
        pub fn status(mut self, input: crate::model::WorkspaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of this workspace.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorkspaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Prometheus endpoint URI.
        pub fn prometheus_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.prometheus_endpoint = Some(input.into());
            self
        }
        /// Prometheus endpoint URI.
        pub fn set_prometheus_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prometheus_endpoint = input;
            self
        }
        /// The time when the workspace was created.
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// The time when the workspace was created.
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags of this workspace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// The tags of this workspace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceDescription`](crate::model::WorkspaceDescription)
        pub fn build(self) -> crate::model::WorkspaceDescription {
            crate::model::WorkspaceDescription {
                workspace_id: self.workspace_id,
                alias: self.alias,
                arn: self.arn,
                status: self.status,
                prometheus_endpoint: self.prometheus_endpoint,
                created_at: self.created_at,
                tags: self.tags,
            }
        }
    }
}
impl WorkspaceDescription {
    /// Creates a new builder-style object to manufacture [`WorkspaceDescription`](crate::model::WorkspaceDescription)
    pub fn builder() -> crate::model::workspace_description::Builder {
        crate::model::workspace_description::Builder::default()
    }
}

/// Represents a summary of the rule groups namespace.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleGroupsNamespaceSummary {
    /// The Amazon Resource Name (ARN) of this rule groups namespace.
    pub arn: std::option::Option<std::string::String>,
    /// The rule groups namespace name.
    pub name: std::option::Option<std::string::String>,
    /// The status of rule groups namespace.
    pub status: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
    /// The time when the rule groups namespace was created.
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// The time when the rule groups namespace was modified.
    pub modified_at: std::option::Option<aws_smithy_types::Instant>,
    /// The tags of this rule groups namespace.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl RuleGroupsNamespaceSummary {
    /// The Amazon Resource Name (ARN) of this rule groups namespace.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The rule groups namespace name.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The status of rule groups namespace.
    pub fn status(&self) -> std::option::Option<&crate::model::RuleGroupsNamespaceStatus> {
        self.status.as_ref()
    }
    /// The time when the rule groups namespace was created.
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// The time when the rule groups namespace was modified.
    pub fn modified_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.modified_at.as_ref()
    }
    /// The tags of this rule groups namespace.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for RuleGroupsNamespaceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleGroupsNamespaceSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("modified_at", &self.modified_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`RuleGroupsNamespaceSummary`](crate::model::RuleGroupsNamespaceSummary)
pub mod rule_groups_namespace_summary {
    /// A builder for [`RuleGroupsNamespaceSummary`](crate::model::RuleGroupsNamespaceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) modified_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of this rule groups namespace.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of this rule groups namespace.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The rule groups namespace name.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The status of rule groups namespace.
        pub fn status(mut self, input: crate::model::RuleGroupsNamespaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of rule groups namespace.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// The time when the rule groups namespace was created.
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// The time when the rule groups namespace was created.
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// The time when the rule groups namespace was modified.
        pub fn modified_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.modified_at = Some(input);
            self
        }
        /// The time when the rule groups namespace was modified.
        pub fn set_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.modified_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags of this rule groups namespace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// The tags of this rule groups namespace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleGroupsNamespaceSummary`](crate::model::RuleGroupsNamespaceSummary)
        pub fn build(self) -> crate::model::RuleGroupsNamespaceSummary {
            crate::model::RuleGroupsNamespaceSummary {
                arn: self.arn,
                name: self.name,
                status: self.status,
                created_at: self.created_at,
                modified_at: self.modified_at,
                tags: self.tags,
            }
        }
    }
}
impl RuleGroupsNamespaceSummary {
    /// Creates a new builder-style object to manufacture [`RuleGroupsNamespaceSummary`](crate::model::RuleGroupsNamespaceSummary)
    pub fn builder() -> crate::model::rule_groups_namespace_summary::Builder {
        crate::model::rule_groups_namespace_summary::Builder::default()
    }
}

/// Represents the status of a namespace.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleGroupsNamespaceStatus {
    /// Status code of this namespace.
    pub status_code: std::option::Option<crate::model::RuleGroupsNamespaceStatusCode>,
    /// The reason for failure if any.
    pub status_reason: std::option::Option<std::string::String>,
}
impl RuleGroupsNamespaceStatus {
    /// Status code of this namespace.
    pub fn status_code(&self) -> std::option::Option<&crate::model::RuleGroupsNamespaceStatusCode> {
        self.status_code.as_ref()
    }
    /// The reason for failure if any.
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
}
impl std::fmt::Debug for RuleGroupsNamespaceStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleGroupsNamespaceStatus");
        formatter.field("status_code", &self.status_code);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`RuleGroupsNamespaceStatus`](crate::model::RuleGroupsNamespaceStatus)
pub mod rule_groups_namespace_status {
    /// A builder for [`RuleGroupsNamespaceStatus`](crate::model::RuleGroupsNamespaceStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<crate::model::RuleGroupsNamespaceStatusCode>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Status code of this namespace.
        pub fn status_code(mut self, input: crate::model::RuleGroupsNamespaceStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// Status code of this namespace.
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::RuleGroupsNamespaceStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// The reason for failure if any.
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// The reason for failure if any.
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleGroupsNamespaceStatus`](crate::model::RuleGroupsNamespaceStatus)
        pub fn build(self) -> crate::model::RuleGroupsNamespaceStatus {
            crate::model::RuleGroupsNamespaceStatus {
                status_code: self.status_code,
                status_reason: self.status_reason,
            }
        }
    }
}
impl RuleGroupsNamespaceStatus {
    /// Creates a new builder-style object to manufacture [`RuleGroupsNamespaceStatus`](crate::model::RuleGroupsNamespaceStatus)
    pub fn builder() -> crate::model::rule_groups_namespace_status::Builder {
        crate::model::rule_groups_namespace_status::Builder::default()
    }
}

/// State of a namespace.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RuleGroupsNamespaceStatusCode {
    /// Namespace has been created/updated. Update/Deletion is disallowed until namespace is ACTIVE and workspace status is ACTIVE.
    Active,
    /// Namespace is being created. Update/Deletion is disallowed until namespace is ACTIVE and workspace status is ACTIVE.
    Creating,
    /// Namespace creation failed.
    CreationFailed,
    /// Namespace is being deleting. Update/Deletion is disallowed until namespace is ACTIVE and workspace status is ACTIVE.
    Deleting,
    /// Namespace update failed.
    UpdateFailed,
    /// Namespace is being updated. Update/Deletion is disallowed until namespace is ACTIVE and workspace status is ACTIVE.
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RuleGroupsNamespaceStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RuleGroupsNamespaceStatusCode::Active,
            "CREATING" => RuleGroupsNamespaceStatusCode::Creating,
            "CREATION_FAILED" => RuleGroupsNamespaceStatusCode::CreationFailed,
            "DELETING" => RuleGroupsNamespaceStatusCode::Deleting,
            "UPDATE_FAILED" => RuleGroupsNamespaceStatusCode::UpdateFailed,
            "UPDATING" => RuleGroupsNamespaceStatusCode::Updating,
            other => RuleGroupsNamespaceStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RuleGroupsNamespaceStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RuleGroupsNamespaceStatusCode::from(s))
    }
}
impl RuleGroupsNamespaceStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RuleGroupsNamespaceStatusCode::Active => "ACTIVE",
            RuleGroupsNamespaceStatusCode::Creating => "CREATING",
            RuleGroupsNamespaceStatusCode::CreationFailed => "CREATION_FAILED",
            RuleGroupsNamespaceStatusCode::Deleting => "DELETING",
            RuleGroupsNamespaceStatusCode::UpdateFailed => "UPDATE_FAILED",
            RuleGroupsNamespaceStatusCode::Updating => "UPDATING",
            RuleGroupsNamespaceStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "CREATION_FAILED",
            "DELETING",
            "UPDATE_FAILED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for RuleGroupsNamespaceStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Represents a description of the rule groups namespace.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleGroupsNamespaceDescription {
    /// The Amazon Resource Name (ARN) of this rule groups namespace.
    pub arn: std::option::Option<std::string::String>,
    /// The rule groups namespace name.
    pub name: std::option::Option<std::string::String>,
    /// The status of rule groups namespace.
    pub status: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
    /// The rule groups namespace data.
    pub data: std::option::Option<aws_smithy_types::Blob>,
    /// The time when the rule groups namespace was created.
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// The time when the rule groups namespace was modified.
    pub modified_at: std::option::Option<aws_smithy_types::Instant>,
    /// The tags of this rule groups namespace.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl RuleGroupsNamespaceDescription {
    /// The Amazon Resource Name (ARN) of this rule groups namespace.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The rule groups namespace name.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The status of rule groups namespace.
    pub fn status(&self) -> std::option::Option<&crate::model::RuleGroupsNamespaceStatus> {
        self.status.as_ref()
    }
    /// The rule groups namespace data.
    pub fn data(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.data.as_ref()
    }
    /// The time when the rule groups namespace was created.
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// The time when the rule groups namespace was modified.
    pub fn modified_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.modified_at.as_ref()
    }
    /// The tags of this rule groups namespace.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for RuleGroupsNamespaceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleGroupsNamespaceDescription");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("data", &self.data);
        formatter.field("created_at", &self.created_at);
        formatter.field("modified_at", &self.modified_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`RuleGroupsNamespaceDescription`](crate::model::RuleGroupsNamespaceDescription)
pub mod rule_groups_namespace_description {
    /// A builder for [`RuleGroupsNamespaceDescription`](crate::model::RuleGroupsNamespaceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
        pub(crate) data: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) modified_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of this rule groups namespace.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of this rule groups namespace.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The rule groups namespace name.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The rule groups namespace name.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The status of rule groups namespace.
        pub fn status(mut self, input: crate::model::RuleGroupsNamespaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of rule groups namespace.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RuleGroupsNamespaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// The rule groups namespace data.
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.data = Some(input);
            self
        }
        /// The rule groups namespace data.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.data = input;
            self
        }
        /// The time when the rule groups namespace was created.
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// The time when the rule groups namespace was created.
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// The time when the rule groups namespace was modified.
        pub fn modified_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.modified_at = Some(input);
            self
        }
        /// The time when the rule groups namespace was modified.
        pub fn set_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.modified_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags of this rule groups namespace.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// The tags of this rule groups namespace.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleGroupsNamespaceDescription`](crate::model::RuleGroupsNamespaceDescription)
        pub fn build(self) -> crate::model::RuleGroupsNamespaceDescription {
            crate::model::RuleGroupsNamespaceDescription {
                arn: self.arn,
                name: self.name,
                status: self.status,
                data: self.data,
                created_at: self.created_at,
                modified_at: self.modified_at,
                tags: self.tags,
            }
        }
    }
}
impl RuleGroupsNamespaceDescription {
    /// Creates a new builder-style object to manufacture [`RuleGroupsNamespaceDescription`](crate::model::RuleGroupsNamespaceDescription)
    pub fn builder() -> crate::model::rule_groups_namespace_description::Builder {
        crate::model::rule_groups_namespace_description::Builder::default()
    }
}

/// Represents the status of a definition.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlertManagerDefinitionStatus {
    /// Status code of this definition.
    pub status_code: std::option::Option<crate::model::AlertManagerDefinitionStatusCode>,
    /// The reason for failure if any.
    pub status_reason: std::option::Option<std::string::String>,
}
impl AlertManagerDefinitionStatus {
    /// Status code of this definition.
    pub fn status_code(
        &self,
    ) -> std::option::Option<&crate::model::AlertManagerDefinitionStatusCode> {
        self.status_code.as_ref()
    }
    /// The reason for failure if any.
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
}
impl std::fmt::Debug for AlertManagerDefinitionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlertManagerDefinitionStatus");
        formatter.field("status_code", &self.status_code);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`AlertManagerDefinitionStatus`](crate::model::AlertManagerDefinitionStatus)
pub mod alert_manager_definition_status {
    /// A builder for [`AlertManagerDefinitionStatus`](crate::model::AlertManagerDefinitionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<crate::model::AlertManagerDefinitionStatusCode>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Status code of this definition.
        pub fn status_code(
            mut self,
            input: crate::model::AlertManagerDefinitionStatusCode,
        ) -> Self {
            self.status_code = Some(input);
            self
        }
        /// Status code of this definition.
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::AlertManagerDefinitionStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// The reason for failure if any.
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// The reason for failure if any.
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AlertManagerDefinitionStatus`](crate::model::AlertManagerDefinitionStatus)
        pub fn build(self) -> crate::model::AlertManagerDefinitionStatus {
            crate::model::AlertManagerDefinitionStatus {
                status_code: self.status_code,
                status_reason: self.status_reason,
            }
        }
    }
}
impl AlertManagerDefinitionStatus {
    /// Creates a new builder-style object to manufacture [`AlertManagerDefinitionStatus`](crate::model::AlertManagerDefinitionStatus)
    pub fn builder() -> crate::model::alert_manager_definition_status::Builder {
        crate::model::alert_manager_definition_status::Builder::default()
    }
}

/// State of an alert manager definition.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlertManagerDefinitionStatusCode {
    /// Definition has been created/updated. Update/Deletion is disallowed until definition is ACTIVE and workspace status is ACTIVE.
    Active,
    /// Definition is being created. Update/Deletion is disallowed until definition is ACTIVE and workspace status is ACTIVE.
    Creating,
    /// Definition creation failed.
    CreationFailed,
    /// Definition is being deleting. Update/Deletion is disallowed until definition is ACTIVE and workspace status is ACTIVE.
    Deleting,
    /// Definition update failed.
    UpdateFailed,
    /// Definition is being updated. Update/Deletion is disallowed until definition is ACTIVE and workspace status is ACTIVE.
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlertManagerDefinitionStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AlertManagerDefinitionStatusCode::Active,
            "CREATING" => AlertManagerDefinitionStatusCode::Creating,
            "CREATION_FAILED" => AlertManagerDefinitionStatusCode::CreationFailed,
            "DELETING" => AlertManagerDefinitionStatusCode::Deleting,
            "UPDATE_FAILED" => AlertManagerDefinitionStatusCode::UpdateFailed,
            "UPDATING" => AlertManagerDefinitionStatusCode::Updating,
            other => AlertManagerDefinitionStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlertManagerDefinitionStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlertManagerDefinitionStatusCode::from(s))
    }
}
impl AlertManagerDefinitionStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlertManagerDefinitionStatusCode::Active => "ACTIVE",
            AlertManagerDefinitionStatusCode::Creating => "CREATING",
            AlertManagerDefinitionStatusCode::CreationFailed => "CREATION_FAILED",
            AlertManagerDefinitionStatusCode::Deleting => "DELETING",
            AlertManagerDefinitionStatusCode::UpdateFailed => "UPDATE_FAILED",
            AlertManagerDefinitionStatusCode::Updating => "UPDATING",
            AlertManagerDefinitionStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "CREATION_FAILED",
            "DELETING",
            "UPDATE_FAILED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for AlertManagerDefinitionStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Represents the properties of an alert manager definition.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlertManagerDefinitionDescription {
    /// The status of alert manager definition.
    pub status: std::option::Option<crate::model::AlertManagerDefinitionStatus>,
    /// The alert manager definition.
    pub data: std::option::Option<aws_smithy_types::Blob>,
    /// The time when the alert manager definition was created.
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// The time when the alert manager definition was modified.
    pub modified_at: std::option::Option<aws_smithy_types::Instant>,
}
impl AlertManagerDefinitionDescription {
    /// The status of alert manager definition.
    pub fn status(&self) -> std::option::Option<&crate::model::AlertManagerDefinitionStatus> {
        self.status.as_ref()
    }
    /// The alert manager definition.
    pub fn data(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.data.as_ref()
    }
    /// The time when the alert manager definition was created.
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// The time when the alert manager definition was modified.
    pub fn modified_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.modified_at.as_ref()
    }
}
impl std::fmt::Debug for AlertManagerDefinitionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlertManagerDefinitionDescription");
        formatter.field("status", &self.status);
        formatter.field("data", &self.data);
        formatter.field("created_at", &self.created_at);
        formatter.field("modified_at", &self.modified_at);
        formatter.finish()
    }
}
/// See [`AlertManagerDefinitionDescription`](crate::model::AlertManagerDefinitionDescription)
pub mod alert_manager_definition_description {
    /// A builder for [`AlertManagerDefinitionDescription`](crate::model::AlertManagerDefinitionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AlertManagerDefinitionStatus>,
        pub(crate) data: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) modified_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// The status of alert manager definition.
        pub fn status(mut self, input: crate::model::AlertManagerDefinitionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of alert manager definition.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AlertManagerDefinitionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// The alert manager definition.
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.data = Some(input);
            self
        }
        /// The alert manager definition.
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.data = input;
            self
        }
        /// The time when the alert manager definition was created.
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// The time when the alert manager definition was created.
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// The time when the alert manager definition was modified.
        pub fn modified_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.modified_at = Some(input);
            self
        }
        /// The time when the alert manager definition was modified.
        pub fn set_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.modified_at = input;
            self
        }
        /// Consumes the builder and constructs a [`AlertManagerDefinitionDescription`](crate::model::AlertManagerDefinitionDescription)
        pub fn build(self) -> crate::model::AlertManagerDefinitionDescription {
            crate::model::AlertManagerDefinitionDescription {
                status: self.status,
                data: self.data,
                created_at: self.created_at,
                modified_at: self.modified_at,
            }
        }
    }
}
impl AlertManagerDefinitionDescription {
    /// Creates a new builder-style object to manufacture [`AlertManagerDefinitionDescription`](crate::model::AlertManagerDefinitionDescription)
    pub fn builder() -> crate::model::alert_manager_definition_description::Builder {
        crate::model::alert_manager_definition_description::Builder::default()
    }
}
