// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateAlertManagerDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAlertManagerDefinitionError {
    /// Kind of error that occurred.
    pub kind: CreateAlertManagerDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAlertManagerDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAlertManagerDefinitionErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request would cause a service quota to be exceeded.
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAlertManagerDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAlertManagerDefinitionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAlertManagerDefinitionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAlertManagerDefinitionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateAlertManagerDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateAlertManagerDefinitionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateAlertManagerDefinitionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAlertManagerDefinitionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateAlertManagerDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAlertManagerDefinitionError {
    fn code(&self) -> Option<&str> {
        CreateAlertManagerDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateAlertManagerDefinitionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateAlertManagerDefinitionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateAlertManagerDefinitionError {
    /// Creates a new `CreateAlertManagerDefinitionError`.
    pub fn new(kind: CreateAlertManagerDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAlertManagerDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAlertManagerDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAlertManagerDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAlertManagerDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAlertManagerDefinitionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertManagerDefinitionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAlertManagerDefinitionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertManagerDefinitionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAlertManagerDefinitionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertManagerDefinitionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAlertManagerDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertManagerDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAlertManagerDefinitionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertManagerDefinitionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAlertManagerDefinitionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertManagerDefinitionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAlertManagerDefinitionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertManagerDefinitionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateAlertManagerDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAlertManagerDefinitionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAlertManagerDefinitionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAlertManagerDefinitionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateAlertManagerDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateAlertManagerDefinitionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateAlertManagerDefinitionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAlertManagerDefinitionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateAlertManagerDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRuleGroupsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRuleGroupsNamespaceError {
    /// Kind of error that occurred.
    pub kind: CreateRuleGroupsNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRuleGroupsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRuleGroupsNamespaceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request would cause a service quota to be exceeded.
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRuleGroupsNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRuleGroupsNamespaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRuleGroupsNamespaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRuleGroupsNamespaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateRuleGroupsNamespaceErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateRuleGroupsNamespaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRuleGroupsNamespaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateRuleGroupsNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRuleGroupsNamespaceError {
    fn code(&self) -> Option<&str> {
        CreateRuleGroupsNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateRuleGroupsNamespaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateRuleGroupsNamespaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateRuleGroupsNamespaceError {
    /// Creates a new `CreateRuleGroupsNamespaceError`.
    pub fn new(kind: CreateRuleGroupsNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRuleGroupsNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRuleGroupsNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRuleGroupsNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRuleGroupsNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRuleGroupsNamespaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupsNamespaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupsNamespaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupsNamespaceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupsNamespaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupsNamespaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupsNamespaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupsNamespaceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupsNamespaceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupsNamespaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupsNamespaceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupsNamespaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupsNamespaceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateRuleGroupsNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRuleGroupsNamespaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRuleGroupsNamespaceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRuleGroupsNamespaceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateRuleGroupsNamespaceErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateRuleGroupsNamespaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRuleGroupsNamespaceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateRuleGroupsNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkspaceError {
    /// Kind of error that occurred.
    pub kind: CreateWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkspaceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request would cause a service quota to be exceeded.
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkspaceError {
    fn code(&self) -> Option<&str> {
        CreateWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateWorkspaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateWorkspaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateWorkspaceError {
    /// Creates a new `CreateWorkspaceError`.
    pub fn new(kind: CreateWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkspaceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkspaceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkspaceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAlertManagerDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAlertManagerDefinitionError {
    /// Kind of error that occurred.
    pub kind: DeleteAlertManagerDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAlertManagerDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAlertManagerDefinitionErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAlertManagerDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAlertManagerDefinitionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAlertManagerDefinitionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteAlertManagerDefinitionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteAlertManagerDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAlertManagerDefinitionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAlertManagerDefinitionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAlertManagerDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAlertManagerDefinitionError {
    fn code(&self) -> Option<&str> {
        DeleteAlertManagerDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteAlertManagerDefinitionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteAlertManagerDefinitionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteAlertManagerDefinitionError {
    /// Creates a new `DeleteAlertManagerDefinitionError`.
    pub fn new(kind: DeleteAlertManagerDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAlertManagerDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAlertManagerDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAlertManagerDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAlertManagerDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAlertManagerDefinitionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlertManagerDefinitionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAlertManagerDefinitionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlertManagerDefinitionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAlertManagerDefinitionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlertManagerDefinitionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAlertManagerDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlertManagerDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAlertManagerDefinitionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlertManagerDefinitionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAlertManagerDefinitionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlertManagerDefinitionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteAlertManagerDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAlertManagerDefinitionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAlertManagerDefinitionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteAlertManagerDefinitionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteAlertManagerDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteAlertManagerDefinitionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAlertManagerDefinitionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAlertManagerDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRuleGroupsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRuleGroupsNamespaceError {
    /// Kind of error that occurred.
    pub kind: DeleteRuleGroupsNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRuleGroupsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRuleGroupsNamespaceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRuleGroupsNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRuleGroupsNamespaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRuleGroupsNamespaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRuleGroupsNamespaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRuleGroupsNamespaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRuleGroupsNamespaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRuleGroupsNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRuleGroupsNamespaceError {
    fn code(&self) -> Option<&str> {
        DeleteRuleGroupsNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteRuleGroupsNamespaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteRuleGroupsNamespaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteRuleGroupsNamespaceError {
    /// Creates a new `DeleteRuleGroupsNamespaceError`.
    pub fn new(kind: DeleteRuleGroupsNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRuleGroupsNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRuleGroupsNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRuleGroupsNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRuleGroupsNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupsNamespaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupsNamespaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupsNamespaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupsNamespaceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupsNamespaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupsNamespaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupsNamespaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupsNamespaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupsNamespaceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupsNamespaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupsNamespaceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteRuleGroupsNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRuleGroupsNamespaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRuleGroupsNamespaceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRuleGroupsNamespaceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRuleGroupsNamespaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRuleGroupsNamespaceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRuleGroupsNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkspaceError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkspaceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkspaceError {
    fn code(&self) -> Option<&str> {
        DeleteWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteWorkspaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteWorkspaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteWorkspaceError {
    /// Creates a new `DeleteWorkspaceError`.
    pub fn new(kind: DeleteWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkspaceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkspaceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkspaceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAlertManagerDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAlertManagerDefinitionError {
    /// Kind of error that occurred.
    pub kind: DescribeAlertManagerDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAlertManagerDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAlertManagerDefinitionErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAlertManagerDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAlertManagerDefinitionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAlertManagerDefinitionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAlertManagerDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAlertManagerDefinitionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAlertManagerDefinitionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeAlertManagerDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAlertManagerDefinitionError {
    fn code(&self) -> Option<&str> {
        DescribeAlertManagerDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeAlertManagerDefinitionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeAlertManagerDefinitionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeAlertManagerDefinitionError {
    /// Creates a new `DescribeAlertManagerDefinitionError`.
    pub fn new(
        kind: DescribeAlertManagerDefinitionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAlertManagerDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAlertManagerDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAlertManagerDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAlertManagerDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAlertManagerDefinitionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlertManagerDefinitionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlertManagerDefinitionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlertManagerDefinitionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlertManagerDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlertManagerDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlertManagerDefinitionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlertManagerDefinitionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlertManagerDefinitionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlertManagerDefinitionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAlertManagerDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAlertManagerDefinitionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAlertManagerDefinitionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeAlertManagerDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeAlertManagerDefinitionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAlertManagerDefinitionErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeAlertManagerDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRuleGroupsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRuleGroupsNamespaceError {
    /// Kind of error that occurred.
    pub kind: DescribeRuleGroupsNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRuleGroupsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRuleGroupsNamespaceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRuleGroupsNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRuleGroupsNamespaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeRuleGroupsNamespaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeRuleGroupsNamespaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeRuleGroupsNamespaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeRuleGroupsNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRuleGroupsNamespaceError {
    fn code(&self) -> Option<&str> {
        DescribeRuleGroupsNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeRuleGroupsNamespaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeRuleGroupsNamespaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeRuleGroupsNamespaceError {
    /// Creates a new `DescribeRuleGroupsNamespaceError`.
    pub fn new(kind: DescribeRuleGroupsNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRuleGroupsNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRuleGroupsNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRuleGroupsNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRuleGroupsNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRuleGroupsNamespaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleGroupsNamespaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRuleGroupsNamespaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleGroupsNamespaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRuleGroupsNamespaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRuleGroupsNamespaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleGroupsNamespaceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRuleGroupsNamespaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleGroupsNamespaceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeRuleGroupsNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRuleGroupsNamespaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeRuleGroupsNamespaceErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRuleGroupsNamespaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeRuleGroupsNamespaceErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeRuleGroupsNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspaceError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspaceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspaceError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeWorkspaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeWorkspaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeWorkspaceError {
    /// Creates a new `DescribeWorkspaceError`.
    pub fn new(kind: DescribeWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRuleGroupsNamespaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRuleGroupsNamespacesError {
    /// Kind of error that occurred.
    pub kind: ListRuleGroupsNamespacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRuleGroupsNamespaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRuleGroupsNamespacesErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRuleGroupsNamespacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRuleGroupsNamespacesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRuleGroupsNamespacesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRuleGroupsNamespacesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRuleGroupsNamespacesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRuleGroupsNamespacesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRuleGroupsNamespacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRuleGroupsNamespacesError {
    fn code(&self) -> Option<&str> {
        ListRuleGroupsNamespacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListRuleGroupsNamespacesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListRuleGroupsNamespacesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListRuleGroupsNamespacesError {
    /// Creates a new `ListRuleGroupsNamespacesError`.
    pub fn new(kind: ListRuleGroupsNamespacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRuleGroupsNamespacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRuleGroupsNamespacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRuleGroupsNamespacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRuleGroupsNamespacesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRuleGroupsNamespacesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsNamespacesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRuleGroupsNamespacesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsNamespacesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRuleGroupsNamespacesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsNamespacesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRuleGroupsNamespacesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsNamespacesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRuleGroupsNamespacesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsNamespacesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRuleGroupsNamespacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRuleGroupsNamespacesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRuleGroupsNamespacesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRuleGroupsNamespacesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRuleGroupsNamespacesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRuleGroupsNamespacesErrorKind::ValidationException(_inner) => Some(_inner),
            ListRuleGroupsNamespacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListTagsForResourceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkspacesError {
    /// Kind of error that occurred.
    pub kind: ListWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkspacesErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkspacesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkspacesError {
    fn code(&self) -> Option<&str> {
        ListWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListWorkspacesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListWorkspacesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListWorkspacesError {
    /// Creates a new `ListWorkspacesError`.
    pub fn new(kind: ListWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkspacesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkspacesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListWorkspacesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListWorkspacesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkspacesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::ValidationException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAlertManagerDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAlertManagerDefinitionError {
    /// Kind of error that occurred.
    pub kind: PutAlertManagerDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAlertManagerDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAlertManagerDefinitionErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request would cause a service quota to be exceeded.
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAlertManagerDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAlertManagerDefinitionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutAlertManagerDefinitionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutAlertManagerDefinitionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutAlertManagerDefinitionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutAlertManagerDefinitionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutAlertManagerDefinitionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutAlertManagerDefinitionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutAlertManagerDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAlertManagerDefinitionError {
    fn code(&self) -> Option<&str> {
        PutAlertManagerDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            PutAlertManagerDefinitionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            PutAlertManagerDefinitionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl PutAlertManagerDefinitionError {
    /// Creates a new `PutAlertManagerDefinitionError`.
    pub fn new(kind: PutAlertManagerDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAlertManagerDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAlertManagerDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAlertManagerDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAlertManagerDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAlertManagerDefinitionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAlertManagerDefinitionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAlertManagerDefinitionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAlertManagerDefinitionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAlertManagerDefinitionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAlertManagerDefinitionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAlertManagerDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAlertManagerDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAlertManagerDefinitionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAlertManagerDefinitionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAlertManagerDefinitionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAlertManagerDefinitionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAlertManagerDefinitionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAlertManagerDefinitionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutAlertManagerDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAlertManagerDefinitionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutAlertManagerDefinitionErrorKind::ConflictException(_inner) => Some(_inner),
            PutAlertManagerDefinitionErrorKind::InternalServerException(_inner) => Some(_inner),
            PutAlertManagerDefinitionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutAlertManagerDefinitionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            PutAlertManagerDefinitionErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutAlertManagerDefinitionErrorKind::ValidationException(_inner) => Some(_inner),
            PutAlertManagerDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRuleGroupsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRuleGroupsNamespaceError {
    /// Kind of error that occurred.
    pub kind: PutRuleGroupsNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRuleGroupsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRuleGroupsNamespaceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request would cause a service quota to be exceeded.
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRuleGroupsNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRuleGroupsNamespaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutRuleGroupsNamespaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutRuleGroupsNamespaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutRuleGroupsNamespaceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            PutRuleGroupsNamespaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutRuleGroupsNamespaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutRuleGroupsNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRuleGroupsNamespaceError {
    fn code(&self) -> Option<&str> {
        PutRuleGroupsNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            PutRuleGroupsNamespaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            PutRuleGroupsNamespaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl PutRuleGroupsNamespaceError {
    /// Creates a new `PutRuleGroupsNamespaceError`.
    pub fn new(kind: PutRuleGroupsNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRuleGroupsNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRuleGroupsNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRuleGroupsNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRuleGroupsNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRuleGroupsNamespaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRuleGroupsNamespaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRuleGroupsNamespaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRuleGroupsNamespaceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRuleGroupsNamespaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRuleGroupsNamespaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRuleGroupsNamespaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRuleGroupsNamespaceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRuleGroupsNamespaceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRuleGroupsNamespaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRuleGroupsNamespaceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRuleGroupsNamespaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRuleGroupsNamespaceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutRuleGroupsNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRuleGroupsNamespaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutRuleGroupsNamespaceErrorKind::ConflictException(_inner) => Some(_inner),
            PutRuleGroupsNamespaceErrorKind::InternalServerException(_inner) => Some(_inner),
            PutRuleGroupsNamespaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutRuleGroupsNamespaceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            PutRuleGroupsNamespaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutRuleGroupsNamespaceErrorKind::ValidationException(_inner) => Some(_inner),
            PutRuleGroupsNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            TagResourceErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UntagResourceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkspaceAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkspaceAliasError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkspaceAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkspaceAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkspaceAliasErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// Unexpected error during processing of request.
    InternalServerException(crate::error::InternalServerException),
    /// Request references a resource which does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request would cause a service quota to be exceeded.
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkspaceAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkspaceAliasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAliasErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAliasErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAliasErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkspaceAliasError {
    fn code(&self) -> Option<&str> {
        UpdateWorkspaceAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateWorkspaceAliasErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateWorkspaceAliasErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateWorkspaceAliasError {
    /// Creates a new `UpdateWorkspaceAliasError`.
    pub fn new(kind: UpdateWorkspaceAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkspaceAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkspaceAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkspaceAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkspaceAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAliasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAliasErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAliasErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAliasErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAliasErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAliasErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAliasErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAliasErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAliasErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateWorkspaceAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkspaceAliasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWorkspaceAliasErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateWorkspaceAliasErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateWorkspaceAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateWorkspaceAliasErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateWorkspaceAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateWorkspaceAliasErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateWorkspaceAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// The input fails to satisfy the constraints specified by an AWS service.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// Description of the error.
    pub message: std::option::Option<std::string::String>,
    /// Reason the request failed validation.
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// The field that caused the error, if applicable. If more than one field caused the error, pick one and elaborate in the message.
    pub field_list: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// Reason the request failed validation.
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// The field that caused the error, if applicable. If more than one field caused the error, pick one and elaborate in the message.
    pub fn field_list(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.field_list.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("field_list", &self.field_list);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) field_list:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        /// Description of the error.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Description of the error.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Reason the request failed validation.
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// Reason the request failed validation.
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `field_list`.
        ///
        /// To override the contents of this collection use [`set_field_list`](Self::set_field_list).
        ///
        /// The field that caused the error, if applicable. If more than one field caused the error, pick one and elaborate in the message.
        pub fn field_list(
            mut self,
            input: impl Into<crate::model::ValidationExceptionField>,
        ) -> Self {
            let mut v = self.field_list.unwrap_or_default();
            v.push(input.into());
            self.field_list = Some(v);
            self
        }
        /// The field that caused the error, if applicable. If more than one field caused the error, pick one and elaborate in the message.
        pub fn set_field_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.field_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                field_list: self.field_list,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// Request was denied due to request throttling.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// Description of the error.
    pub message: std::option::Option<std::string::String>,
    /// Service Quotas requirement to identify originating service.
    pub service_code: std::option::Option<std::string::String>,
    /// Service Quotas requirement to identify originating quota.
    pub quota_code: std::option::Option<std::string::String>,
    /// Advice to clients on when the call can be safely retried.
    pub retry_after_seconds: std::option::Option<i32>,
}
impl ThrottlingException {
    /// Service Quotas requirement to identify originating service.
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// Service Quotas requirement to identify originating quota.
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// Advice to clients on when the call can be safely retried.
    pub fn retry_after_seconds(&self) -> std::option::Option<i32> {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ClientError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// Description of the error.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Description of the error.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Service Quotas requirement to identify originating service.
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// Service Quotas requirement to identify originating service.
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Service Quotas requirement to identify originating quota.
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// Service Quotas requirement to identify originating quota.
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Advice to clients on when the call can be safely retried.
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// Advice to clients on when the call can be safely retried.
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                service_code: self.service_code,
                quota_code: self.quota_code,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// Unexpected error during processing of request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    /// Description of the error.
    pub message: std::option::Option<std::string::String>,
    /// Advice to clients on when the call can be safely retried.
    pub retry_after_seconds: std::option::Option<i32>,
}
impl InternalServerException {
    /// Advice to clients on when the call can be safely retried.
    pub fn retry_after_seconds(&self) -> std::option::Option<i32> {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ServerError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// Description of the error.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Description of the error.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Advice to clients on when the call can be safely retried.
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// Advice to clients on when the call can be safely retried.
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// User does not have sufficient access to perform this action.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// Description of the error.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Description of the error.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Description of the error.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// Request would cause a service quota to be exceeded.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    /// Description of the error.
    pub message: std::option::Option<std::string::String>,
    /// Identifier of the resource affected.
    pub resource_id: std::option::Option<std::string::String>,
    /// Type of the resource affected.
    pub resource_type: std::option::Option<std::string::String>,
    /// Service Quotas requirement to identify originating service.
    pub service_code: std::option::Option<std::string::String>,
    /// Service Quotas requirement to identify originating quota.
    pub quota_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// Identifier of the resource affected.
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// Type of the resource affected.
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// Service Quotas requirement to identify originating service.
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// Service Quotas requirement to identify originating quota.
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Description of the error.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Description of the error.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Identifier of the resource affected.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// Identifier of the resource affected.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Type of the resource affected.
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Type of the resource affected.
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Service Quotas requirement to identify originating service.
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// Service Quotas requirement to identify originating service.
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Service Quotas requirement to identify originating quota.
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// Service Quotas requirement to identify originating quota.
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                service_code: self.service_code,
                quota_code: self.quota_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// Updating or deleting a resource can cause an inconsistent state.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// Description of the error.
    pub message: std::option::Option<std::string::String>,
    /// Identifier of the resource affected.
    pub resource_id: std::option::Option<std::string::String>,
    /// Type of the resource affected.
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// Identifier of the resource affected.
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// Type of the resource affected.
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Description of the error.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Description of the error.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Identifier of the resource affected.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// Identifier of the resource affected.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Type of the resource affected.
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Type of the resource affected.
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// Request references a resource which does not exist.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// Description of the error.
    pub message: std::option::Option<std::string::String>,
    /// Identifier of the resource affected.
    pub resource_id: std::option::Option<std::string::String>,
    /// Type of the resource affected.
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// Identifier of the resource affected.
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// Type of the resource affected.
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Description of the error.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Description of the error.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Identifier of the resource affected.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// Identifier of the resource affected.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Type of the resource affected.
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Type of the resource affected.
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}
