// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_approve_skill_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ApproveSkillOutput, crate::error::ApproveSkillError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ApproveSkillError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ApproveSkillError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::ApproveSkillError {
            meta: generic,
            kind: crate::error::ApproveSkillErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ApproveSkillError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::ApproveSkillError {
            meta: generic,
            kind: crate::error::ApproveSkillErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ApproveSkillError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ApproveSkillError {
            meta: generic,
            kind: crate::error::ApproveSkillErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ApproveSkillError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ApproveSkillError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_approve_skill_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ApproveSkillOutput, crate::error::ApproveSkillError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::approve_skill_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_contact_with_address_book_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateContactWithAddressBookOutput,
    crate::error::AssociateContactWithAddressBookError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateContactWithAddressBookError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateContactWithAddressBookError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::AssociateContactWithAddressBookError {
            meta: generic,
            kind: crate::error::AssociateContactWithAddressBookErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateContactWithAddressBookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateContactWithAddressBookError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_contact_with_address_book_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateContactWithAddressBookOutput,
    crate::error::AssociateContactWithAddressBookError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::associate_contact_with_address_book_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_device_with_network_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateDeviceWithNetworkProfileOutput,
    crate::error::AssociateDeviceWithNetworkProfileError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateDeviceWithNetworkProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateDeviceWithNetworkProfileError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::AssociateDeviceWithNetworkProfileError { meta: generic, kind: crate::error::AssociateDeviceWithNetworkProfileErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateDeviceWithNetworkProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DeviceNotRegisteredException" => crate::error::AssociateDeviceWithNetworkProfileError { meta: generic, kind: crate::error::AssociateDeviceWithNetworkProfileErrorKind::DeviceNotRegisteredException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::device_not_registered_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_device_not_registered_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateDeviceWithNetworkProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::AssociateDeviceWithNetworkProfileError { meta: generic, kind: crate::error::AssociateDeviceWithNetworkProfileErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateDeviceWithNetworkProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AssociateDeviceWithNetworkProfileError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_device_with_network_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateDeviceWithNetworkProfileOutput,
    crate::error::AssociateDeviceWithNetworkProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::associate_device_with_network_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_device_with_room_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateDeviceWithRoomOutput,
    crate::error::AssociateDeviceWithRoomError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateDeviceWithRoomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateDeviceWithRoomError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::AssociateDeviceWithRoomError {
            meta: generic,
            kind: crate::error::AssociateDeviceWithRoomErrorKind::ConcurrentModificationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::concurrent_modification_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateDeviceWithRoomError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "DeviceNotRegisteredException" => crate::error::AssociateDeviceWithRoomError {
            meta: generic,
            kind: crate::error::AssociateDeviceWithRoomErrorKind::DeviceNotRegisteredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::device_not_registered_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_device_not_registered_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateDeviceWithRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AssociateDeviceWithRoomError {
            meta: generic,
            kind: crate::error::AssociateDeviceWithRoomErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateDeviceWithRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateDeviceWithRoomError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_device_with_room_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateDeviceWithRoomOutput,
    crate::error::AssociateDeviceWithRoomError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_device_with_room_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_skill_group_with_room_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateSkillGroupWithRoomOutput,
    crate::error::AssociateSkillGroupWithRoomError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateSkillGroupWithRoomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateSkillGroupWithRoomError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::AssociateSkillGroupWithRoomError {
            meta: generic,
            kind:
                crate::error::AssociateSkillGroupWithRoomErrorKind::ConcurrentModificationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::concurrent_modification_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSkillGroupWithRoomError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::AssociateSkillGroupWithRoomError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_skill_group_with_room_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateSkillGroupWithRoomOutput,
    crate::error::AssociateSkillGroupWithRoomError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_skill_group_with_room_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_skill_with_skill_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateSkillWithSkillGroupOutput,
    crate::error::AssociateSkillWithSkillGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateSkillWithSkillGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateSkillWithSkillGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::AssociateSkillWithSkillGroupError {
            meta: generic,
            kind:
                crate::error::AssociateSkillWithSkillGroupErrorKind::ConcurrentModificationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::concurrent_modification_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSkillWithSkillGroupError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NotFoundException" => crate::error::AssociateSkillWithSkillGroupError {
            meta: generic,
            kind: crate::error::AssociateSkillWithSkillGroupErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSkillWithSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SkillNotLinkedException" => crate::error::AssociateSkillWithSkillGroupError {
            meta: generic,
            kind: crate::error::AssociateSkillWithSkillGroupErrorKind::SkillNotLinkedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::skill_not_linked_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_skill_not_linked_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSkillWithSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateSkillWithSkillGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_skill_with_skill_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateSkillWithSkillGroupOutput,
    crate::error::AssociateSkillWithSkillGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_skill_with_skill_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_skill_with_users_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateSkillWithUsersOutput,
    crate::error::AssociateSkillWithUsersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateSkillWithUsersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateSkillWithUsersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::AssociateSkillWithUsersError {
            meta: generic,
            kind: crate::error::AssociateSkillWithUsersErrorKind::ConcurrentModificationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::concurrent_modification_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSkillWithUsersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotFoundException" => crate::error::AssociateSkillWithUsersError {
            meta: generic,
            kind: crate::error::AssociateSkillWithUsersErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSkillWithUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateSkillWithUsersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_skill_with_users_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateSkillWithUsersOutput,
    crate::error::AssociateSkillWithUsersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_skill_with_users_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_address_book_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAddressBookOutput, crate::error::CreateAddressBookError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAddressBookError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAddressBookError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateAddressBookError {
            meta: generic,
            kind: crate::error::CreateAddressBookErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAddressBookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateAddressBookError {
            meta: generic,
            kind: crate::error::CreateAddressBookErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAddressBookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAddressBookError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_address_book_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAddressBookOutput, crate::error::CreateAddressBookError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_address_book_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_address_book(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAddressBookError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_business_report_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBusinessReportScheduleOutput,
    crate::error::CreateBusinessReportScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBusinessReportScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateBusinessReportScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateBusinessReportScheduleError {
            meta: generic,
            kind: crate::error::CreateBusinessReportScheduleErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBusinessReportScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBusinessReportScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_business_report_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBusinessReportScheduleOutput,
    crate::error::CreateBusinessReportScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_business_report_schedule_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_business_report_schedule(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateBusinessReportScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_conference_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConferenceProviderOutput,
    crate::error::CreateConferenceProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateConferenceProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateConferenceProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateConferenceProviderError {
            meta: generic,
            kind: crate::error::CreateConferenceProviderErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConferenceProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateConferenceProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_conference_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConferenceProviderOutput,
    crate::error::CreateConferenceProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_conference_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_conference_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateConferenceProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_contact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateContactOutput, crate::error::CreateContactError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateContactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateContactError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateContactError {
            meta: generic,
            kind: crate::error::CreateContactErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateContactError {
            meta: generic,
            kind: crate::error::CreateContactErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateContactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_contact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateContactOutput, crate::error::CreateContactError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_contact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_contact(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateContactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_gateway_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateGatewayGroupOutput,
    crate::error::CreateGatewayGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateGatewayGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateGatewayGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateGatewayGroupError {
            meta: generic,
            kind: crate::error::CreateGatewayGroupErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGatewayGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateGatewayGroupError {
            meta: generic,
            kind: crate::error::CreateGatewayGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGatewayGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateGatewayGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_gateway_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateGatewayGroupOutput,
    crate::error::CreateGatewayGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_gateway_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_gateway_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateGatewayGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_network_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNetworkProfileOutput,
    crate::error::CreateNetworkProfileError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateNetworkProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateNetworkProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateNetworkProfileError {
            meta: generic,
            kind: crate::error::CreateNetworkProfileErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::CreateNetworkProfileError {
            meta: generic,
            kind: crate::error::CreateNetworkProfileErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCertificateAuthorityException" => crate::error::CreateNetworkProfileError {
            meta: generic,
            kind: crate::error::CreateNetworkProfileErrorKind::InvalidCertificateAuthorityException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_certificate_authority_exception::Builder::default(
                            );
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_certificate_authority_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidServiceLinkedRoleStateException" => crate::error::CreateNetworkProfileError {
            meta: generic,
            kind:
                crate::error::CreateNetworkProfileErrorKind::InvalidServiceLinkedRoleStateException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_service_linked_role_state_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_service_linked_role_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkProfileError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "LimitExceededException" => crate::error::CreateNetworkProfileError {
            meta: generic,
            kind: crate::error::CreateNetworkProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateNetworkProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_network_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNetworkProfileOutput,
    crate::error::CreateNetworkProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_network_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_network_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateNetworkProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateProfileOutput, crate::error::CreateProfileError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateProfileError {
            meta: generic,
            kind: crate::error::CreateProfileErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::CreateProfileError {
            meta: generic,
            kind: crate::error::CreateProfileErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateProfileError {
            meta: generic,
            kind: crate::error::CreateProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateProfileOutput, crate::error::CreateProfileError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_room_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRoomOutput, crate::error::CreateRoomError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRoomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRoomError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateRoomError {
            meta: generic,
            kind: crate::error::CreateRoomErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateRoomError {
            meta: generic,
            kind: crate::error::CreateRoomErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRoomError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_room_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRoomOutput, crate::error::CreateRoomError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_room_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_room(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRoomError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_skill_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSkillGroupOutput, crate::error::CreateSkillGroupError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSkillGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateSkillGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateSkillGroupError {
            meta: generic,
            kind: crate::error::CreateSkillGroupErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::CreateSkillGroupError {
            meta: generic,
            kind: crate::error::CreateSkillGroupErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateSkillGroupError {
            meta: generic,
            kind: crate::error::CreateSkillGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSkillGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_skill_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSkillGroupOutput, crate::error::CreateSkillGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_skill_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_skill_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSkillGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_address_book_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAddressBookOutput, crate::error::DeleteAddressBookError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAddressBookError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAddressBookError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteAddressBookError {
            meta: generic,
            kind: crate::error::DeleteAddressBookErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAddressBookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteAddressBookError {
            meta: generic,
            kind: crate::error::DeleteAddressBookErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAddressBookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAddressBookError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_address_book_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAddressBookOutput, crate::error::DeleteAddressBookError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_address_book_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_business_report_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBusinessReportScheduleOutput,
    crate::error::DeleteBusinessReportScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBusinessReportScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteBusinessReportScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteBusinessReportScheduleError {
            meta: generic,
            kind:
                crate::error::DeleteBusinessReportScheduleErrorKind::ConcurrentModificationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::concurrent_modification_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBusinessReportScheduleError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NotFoundException" => crate::error::DeleteBusinessReportScheduleError {
            meta: generic,
            kind: crate::error::DeleteBusinessReportScheduleErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBusinessReportScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBusinessReportScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_business_report_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBusinessReportScheduleOutput,
    crate::error::DeleteBusinessReportScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_business_report_schedule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_conference_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConferenceProviderOutput,
    crate::error::DeleteConferenceProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteConferenceProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteConferenceProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::DeleteConferenceProviderError {
            meta: generic,
            kind: crate::error::DeleteConferenceProviderErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConferenceProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteConferenceProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_conference_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConferenceProviderOutput,
    crate::error::DeleteConferenceProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_conference_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_contact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteContactOutput, crate::error::DeleteContactError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteContactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteContactError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteContactError {
            meta: generic,
            kind: crate::error::DeleteContactErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteContactError {
            meta: generic,
            kind: crate::error::DeleteContactErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteContactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_contact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteContactOutput, crate::error::DeleteContactError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_contact_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDeviceOutput, crate::error::DeleteDeviceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteDeviceError {
            meta: generic,
            kind: crate::error::DeleteDeviceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCertificateAuthorityException" => crate::error::DeleteDeviceError {
            meta: generic,
            kind: crate::error::DeleteDeviceErrorKind::InvalidCertificateAuthorityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_certificate_authority_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_certificate_authority_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteDeviceError {
            meta: generic,
            kind: crate::error::DeleteDeviceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDeviceOutput, crate::error::DeleteDeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_device_usage_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDeviceUsageDataOutput,
    crate::error::DeleteDeviceUsageDataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDeviceUsageDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDeviceUsageDataError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DeviceNotRegisteredException" => crate::error::DeleteDeviceUsageDataError {
            meta: generic,
            kind: crate::error::DeleteDeviceUsageDataErrorKind::DeviceNotRegisteredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::device_not_registered_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_device_not_registered_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDeviceUsageDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::DeleteDeviceUsageDataError {
            meta: generic,
            kind: crate::error::DeleteDeviceUsageDataErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDeviceUsageDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteDeviceUsageDataError {
            meta: generic,
            kind: crate::error::DeleteDeviceUsageDataErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDeviceUsageDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDeviceUsageDataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_device_usage_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDeviceUsageDataOutput,
    crate::error::DeleteDeviceUsageDataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_device_usage_data_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_gateway_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteGatewayGroupOutput,
    crate::error::DeleteGatewayGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteGatewayGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteGatewayGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceAssociatedException" => crate::error::DeleteGatewayGroupError {
            meta: generic,
            kind: crate::error::DeleteGatewayGroupErrorKind::ResourceAssociatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_associated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_associated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGatewayGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteGatewayGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_gateway_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteGatewayGroupOutput,
    crate::error::DeleteGatewayGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_gateway_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_network_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNetworkProfileOutput,
    crate::error::DeleteNetworkProfileError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteNetworkProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteNetworkProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteNetworkProfileError {
            meta: generic,
            kind: crate::error::DeleteNetworkProfileErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteNetworkProfileError {
            meta: generic,
            kind: crate::error::DeleteNetworkProfileErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::DeleteNetworkProfileError {
            meta: generic,
            kind: crate::error::DeleteNetworkProfileErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteNetworkProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_network_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNetworkProfileOutput,
    crate::error::DeleteNetworkProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_network_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteProfileOutput, crate::error::DeleteProfileError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteProfileError {
            meta: generic,
            kind: crate::error::DeleteProfileErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteProfileError {
            meta: generic,
            kind: crate::error::DeleteProfileErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteProfileOutput, crate::error::DeleteProfileError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_room_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRoomOutput, crate::error::DeleteRoomError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRoomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRoomError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteRoomError {
            meta: generic,
            kind: crate::error::DeleteRoomErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteRoomError {
            meta: generic,
            kind: crate::error::DeleteRoomErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRoomError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_room_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRoomOutput, crate::error::DeleteRoomError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_room_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_room_skill_parameter_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRoomSkillParameterOutput,
    crate::error::DeleteRoomSkillParameterError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRoomSkillParameterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteRoomSkillParameterError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteRoomSkillParameterError {
            meta: generic,
            kind: crate::error::DeleteRoomSkillParameterErrorKind::ConcurrentModificationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::concurrent_modification_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRoomSkillParameterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteRoomSkillParameterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_room_skill_parameter_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRoomSkillParameterOutput,
    crate::error::DeleteRoomSkillParameterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_room_skill_parameter_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_skill_authorization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSkillAuthorizationOutput,
    crate::error::DeleteSkillAuthorizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSkillAuthorizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteSkillAuthorizationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteSkillAuthorizationError {
            meta: generic,
            kind: crate::error::DeleteSkillAuthorizationErrorKind::ConcurrentModificationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::concurrent_modification_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSkillAuthorizationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotFoundException" => crate::error::DeleteSkillAuthorizationError {
            meta: generic,
            kind: crate::error::DeleteSkillAuthorizationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSkillAuthorizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSkillAuthorizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_skill_authorization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSkillAuthorizationOutput,
    crate::error::DeleteSkillAuthorizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_skill_authorization_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_skill_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSkillGroupOutput, crate::error::DeleteSkillGroupError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSkillGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSkillGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteSkillGroupError {
            meta: generic,
            kind: crate::error::DeleteSkillGroupErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteSkillGroupError {
            meta: generic,
            kind: crate::error::DeleteSkillGroupErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSkillGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_skill_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSkillGroupOutput, crate::error::DeleteSkillGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_skill_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_contact_from_address_book_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateContactFromAddressBookOutput,
    crate::error::DisassociateContactFromAddressBookError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateContactFromAddressBookError::unhandled)?;
    Err(crate::error::DisassociateContactFromAddressBookError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_contact_from_address_book_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateContactFromAddressBookOutput,
    crate::error::DisassociateContactFromAddressBookError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_contact_from_address_book_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_device_from_room_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateDeviceFromRoomOutput,
    crate::error::DisassociateDeviceFromRoomError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateDeviceFromRoomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateDeviceFromRoomError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DisassociateDeviceFromRoomError {
            meta: generic,
            kind:
                crate::error::DisassociateDeviceFromRoomErrorKind::ConcurrentModificationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::concurrent_modification_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateDeviceFromRoomError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "DeviceNotRegisteredException" => crate::error::DisassociateDeviceFromRoomError {
            meta: generic,
            kind: crate::error::DisassociateDeviceFromRoomErrorKind::DeviceNotRegisteredException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::device_not_registered_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_device_not_registered_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateDeviceFromRoomError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DisassociateDeviceFromRoomError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_device_from_room_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateDeviceFromRoomOutput,
    crate::error::DisassociateDeviceFromRoomError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_device_from_room_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_skill_from_skill_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateSkillFromSkillGroupOutput,
    crate::error::DisassociateSkillFromSkillGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateSkillFromSkillGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisassociateSkillFromSkillGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DisassociateSkillFromSkillGroupError { meta: generic, kind: crate::error::DisassociateSkillFromSkillGroupErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateSkillFromSkillGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::DisassociateSkillFromSkillGroupError { meta: generic, kind: crate::error::DisassociateSkillFromSkillGroupErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateSkillFromSkillGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DisassociateSkillFromSkillGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_skill_from_skill_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateSkillFromSkillGroupOutput,
    crate::error::DisassociateSkillFromSkillGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_skill_from_skill_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_skill_from_users_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateSkillFromUsersOutput,
    crate::error::DisassociateSkillFromUsersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateSkillFromUsersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateSkillFromUsersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DisassociateSkillFromUsersError {
            meta: generic,
            kind:
                crate::error::DisassociateSkillFromUsersErrorKind::ConcurrentModificationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::concurrent_modification_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateSkillFromUsersError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NotFoundException" => crate::error::DisassociateSkillFromUsersError {
            meta: generic,
            kind: crate::error::DisassociateSkillFromUsersErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateSkillFromUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateSkillFromUsersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_skill_from_users_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateSkillFromUsersOutput,
    crate::error::DisassociateSkillFromUsersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_skill_from_users_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_skill_group_from_room_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateSkillGroupFromRoomOutput,
    crate::error::DisassociateSkillGroupFromRoomError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateSkillGroupFromRoomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisassociateSkillGroupFromRoomError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DisassociateSkillGroupFromRoomError { meta: generic, kind: crate::error::DisassociateSkillGroupFromRoomErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateSkillGroupFromRoomError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DisassociateSkillGroupFromRoomError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_skill_group_from_room_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateSkillGroupFromRoomOutput,
    crate::error::DisassociateSkillGroupFromRoomError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_skill_group_from_room_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_forget_smart_home_appliances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ForgetSmartHomeAppliancesOutput,
    crate::error::ForgetSmartHomeAppliancesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ForgetSmartHomeAppliancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ForgetSmartHomeAppliancesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::ForgetSmartHomeAppliancesError {
            meta: generic,
            kind: crate::error::ForgetSmartHomeAppliancesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetSmartHomeAppliancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ForgetSmartHomeAppliancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_forget_smart_home_appliances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ForgetSmartHomeAppliancesOutput,
    crate::error::ForgetSmartHomeAppliancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::forget_smart_home_appliances_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_address_book_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAddressBookOutput, crate::error::GetAddressBookError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAddressBookError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAddressBookError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetAddressBookError {
            meta: generic,
            kind: crate::error::GetAddressBookErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAddressBookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAddressBookError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_address_book_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAddressBookOutput, crate::error::GetAddressBookError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_address_book_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_address_book(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAddressBookError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_conference_preference_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetConferencePreferenceOutput,
    crate::error::GetConferencePreferenceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetConferencePreferenceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetConferencePreferenceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetConferencePreferenceError {
            meta: generic,
            kind: crate::error::GetConferencePreferenceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetConferencePreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetConferencePreferenceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_conference_preference_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetConferencePreferenceOutput,
    crate::error::GetConferencePreferenceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_conference_preference_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_conference_preference(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetConferencePreferenceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_conference_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetConferenceProviderOutput,
    crate::error::GetConferenceProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetConferenceProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetConferenceProviderError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetConferenceProviderError {
            meta: generic,
            kind: crate::error::GetConferenceProviderErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetConferenceProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetConferenceProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_conference_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetConferenceProviderOutput,
    crate::error::GetConferenceProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_conference_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_conference_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetConferenceProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_contact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetContactOutput, crate::error::GetContactError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetContactError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetContactError {
            meta: generic,
            kind: crate::error::GetContactErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_contact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetContactOutput, crate::error::GetContactError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_contact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_contact(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetContactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDeviceOutput, crate::error::GetDeviceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetDeviceError {
            meta: generic,
            kind: crate::error::GetDeviceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDeviceOutput, crate::error::GetDeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_device_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_device(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDeviceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_gateway_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGatewayOutput, crate::error::GetGatewayError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetGatewayError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetGatewayError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetGatewayError {
            meta: generic,
            kind: crate::error::GetGatewayErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetGatewayError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_gateway_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGatewayOutput, crate::error::GetGatewayError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_gateway_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_gateway(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetGatewayError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_gateway_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGatewayGroupOutput, crate::error::GetGatewayGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetGatewayGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetGatewayGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetGatewayGroupError {
            meta: generic,
            kind: crate::error::GetGatewayGroupErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGatewayGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetGatewayGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_gateway_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGatewayGroupOutput, crate::error::GetGatewayGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_gateway_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_gateway_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetGatewayGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_invitation_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInvitationConfigurationOutput,
    crate::error::GetInvitationConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInvitationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetInvitationConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetInvitationConfigurationError {
            meta: generic,
            kind: crate::error::GetInvitationConfigurationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInvitationConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInvitationConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_invitation_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInvitationConfigurationOutput,
    crate::error::GetInvitationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_invitation_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_invitation_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInvitationConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_network_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetNetworkProfileOutput, crate::error::GetNetworkProfileError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetNetworkProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetNetworkProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidSecretsManagerResourceException" => crate::error::GetNetworkProfileError {
            meta: generic,
            kind: crate::error::GetNetworkProfileErrorKind::InvalidSecretsManagerResourceException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_secrets_manager_resource_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_secrets_manager_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetNetworkProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotFoundException" => crate::error::GetNetworkProfileError {
            meta: generic,
            kind: crate::error::GetNetworkProfileErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetNetworkProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_network_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetNetworkProfileOutput, crate::error::GetNetworkProfileError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_network_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_network_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetNetworkProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetProfileOutput, crate::error::GetProfileError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetProfileError {
            meta: generic,
            kind: crate::error::GetProfileErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetProfileOutput, crate::error::GetProfileError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_room_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRoomOutput, crate::error::GetRoomError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRoomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRoomError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetRoomError {
            meta: generic,
            kind: crate::error::GetRoomErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRoomError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_room_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRoomOutput, crate::error::GetRoomError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_room_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_room(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRoomError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_room_skill_parameter_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRoomSkillParameterOutput,
    crate::error::GetRoomSkillParameterError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRoomSkillParameterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRoomSkillParameterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetRoomSkillParameterError {
            meta: generic,
            kind: crate::error::GetRoomSkillParameterErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRoomSkillParameterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRoomSkillParameterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_room_skill_parameter_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRoomSkillParameterOutput,
    crate::error::GetRoomSkillParameterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_room_skill_parameter_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_room_skill_parameter(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRoomSkillParameterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_skill_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSkillGroupOutput, crate::error::GetSkillGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSkillGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSkillGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::GetSkillGroupError {
            meta: generic,
            kind: crate::error::GetSkillGroupErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSkillGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_skill_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSkillGroupOutput, crate::error::GetSkillGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_skill_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_skill_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSkillGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_business_report_schedules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBusinessReportSchedulesOutput,
    crate::error::ListBusinessReportSchedulesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBusinessReportSchedulesError::unhandled)?;
    Err(crate::error::ListBusinessReportSchedulesError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_business_report_schedules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBusinessReportSchedulesOutput,
    crate::error::ListBusinessReportSchedulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_business_report_schedules_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_business_report_schedules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListBusinessReportSchedulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_conference_providers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConferenceProvidersOutput,
    crate::error::ListConferenceProvidersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListConferenceProvidersError::unhandled)?;
    Err(crate::error::ListConferenceProvidersError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_conference_providers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConferenceProvidersOutput,
    crate::error::ListConferenceProvidersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_conference_providers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_conference_providers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListConferenceProvidersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_device_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDeviceEventsOutput, crate::error::ListDeviceEventsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDeviceEventsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDeviceEventsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::ListDeviceEventsError {
            meta: generic,
            kind: crate::error::ListDeviceEventsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDeviceEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListDeviceEventsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_device_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDeviceEventsOutput, crate::error::ListDeviceEventsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_device_events_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_device_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDeviceEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_gateway_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGatewayGroupsOutput, crate::error::ListGatewayGroupsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGatewayGroupsError::unhandled)?;
    Err(crate::error::ListGatewayGroupsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_gateway_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGatewayGroupsOutput, crate::error::ListGatewayGroupsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_gateway_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_gateway_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGatewayGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_gateways_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGatewaysOutput, crate::error::ListGatewaysError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGatewaysError::unhandled)?;
    Err(crate::error::ListGatewaysError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_gateways_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGatewaysOutput, crate::error::ListGatewaysError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_gateways_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_gateways(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGatewaysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_skills_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSkillsOutput, crate::error::ListSkillsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSkillsError::unhandled)?;
    Err(crate::error::ListSkillsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_skills_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSkillsOutput, crate::error::ListSkillsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_skills_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_skills(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSkillsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_skills_store_categories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSkillsStoreCategoriesOutput,
    crate::error::ListSkillsStoreCategoriesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSkillsStoreCategoriesError::unhandled)?;
    Err(crate::error::ListSkillsStoreCategoriesError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_skills_store_categories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSkillsStoreCategoriesOutput,
    crate::error::ListSkillsStoreCategoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_skills_store_categories_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_skills_store_categories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSkillsStoreCategoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_skills_store_skills_by_category_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSkillsStoreSkillsByCategoryOutput,
    crate::error::ListSkillsStoreSkillsByCategoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSkillsStoreSkillsByCategoryError::unhandled)?;
    Err(crate::error::ListSkillsStoreSkillsByCategoryError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_skills_store_skills_by_category_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSkillsStoreSkillsByCategoryOutput,
    crate::error::ListSkillsStoreSkillsByCategoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_skills_store_skills_by_category_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_skills_store_skills_by_category(response.body().as_ref(), output).map_err(crate::error::ListSkillsStoreSkillsByCategoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_smart_home_appliances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSmartHomeAppliancesOutput,
    crate::error::ListSmartHomeAppliancesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSmartHomeAppliancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListSmartHomeAppliancesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::ListSmartHomeAppliancesError {
            meta: generic,
            kind: crate::error::ListSmartHomeAppliancesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSmartHomeAppliancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSmartHomeAppliancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_smart_home_appliances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSmartHomeAppliancesOutput,
    crate::error::ListSmartHomeAppliancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_smart_home_appliances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_smart_home_appliances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSmartHomeAppliancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_conference_preference_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutConferencePreferenceOutput,
    crate::error::PutConferencePreferenceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutConferencePreferenceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutConferencePreferenceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::PutConferencePreferenceError {
            meta: generic,
            kind: crate::error::PutConferencePreferenceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutConferencePreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutConferencePreferenceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_conference_preference_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutConferencePreferenceOutput,
    crate::error::PutConferencePreferenceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_conference_preference_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_invitation_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutInvitationConfigurationOutput,
    crate::error::PutInvitationConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutInvitationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutInvitationConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::PutInvitationConfigurationError {
            meta: generic,
            kind:
                crate::error::PutInvitationConfigurationErrorKind::ConcurrentModificationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::concurrent_modification_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInvitationConfigurationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NotFoundException" => crate::error::PutInvitationConfigurationError {
            meta: generic,
            kind: crate::error::PutInvitationConfigurationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInvitationConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutInvitationConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_invitation_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutInvitationConfigurationOutput,
    crate::error::PutInvitationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_invitation_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_room_skill_parameter_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutRoomSkillParameterOutput,
    crate::error::PutRoomSkillParameterError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutRoomSkillParameterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutRoomSkillParameterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::PutRoomSkillParameterError {
            meta: generic,
            kind: crate::error::PutRoomSkillParameterErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutRoomSkillParameterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutRoomSkillParameterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_room_skill_parameter_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutRoomSkillParameterOutput,
    crate::error::PutRoomSkillParameterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_room_skill_parameter_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_skill_authorization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutSkillAuthorizationOutput,
    crate::error::PutSkillAuthorizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutSkillAuthorizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutSkillAuthorizationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::PutSkillAuthorizationError {
            meta: generic,
            kind: crate::error::PutSkillAuthorizationErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSkillAuthorizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedException" => crate::error::PutSkillAuthorizationError {
            meta: generic,
            kind: crate::error::PutSkillAuthorizationErrorKind::UnauthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSkillAuthorizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutSkillAuthorizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_skill_authorization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutSkillAuthorizationOutput,
    crate::error::PutSkillAuthorizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_skill_authorization_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_avs_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterAvsDeviceOutput, crate::error::RegisterAVSDeviceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterAVSDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterAVSDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::RegisterAVSDeviceError {
            meta: generic,
            kind: crate::error::RegisterAVSDeviceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterAVSDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDeviceException" => crate::error::RegisterAVSDeviceError {
            meta: generic,
            kind: crate::error::RegisterAVSDeviceErrorKind::InvalidDeviceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_device_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_device_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterAVSDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::RegisterAVSDeviceError {
            meta: generic,
            kind: crate::error::RegisterAVSDeviceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterAVSDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::RegisterAVSDeviceError {
            meta: generic,
            kind: crate::error::RegisterAVSDeviceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterAVSDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterAVSDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_avs_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterAvsDeviceOutput, crate::error::RegisterAVSDeviceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_avs_device_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_register_avs_device(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterAVSDeviceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_skill_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RejectSkillOutput, crate::error::RejectSkillError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RejectSkillError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RejectSkillError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::RejectSkillError {
            meta: generic,
            kind: crate::error::RejectSkillErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectSkillError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::RejectSkillError {
            meta: generic,
            kind: crate::error::RejectSkillErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectSkillError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RejectSkillError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_skill_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RejectSkillOutput, crate::error::RejectSkillError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reject_skill_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resolve_room_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResolveRoomOutput, crate::error::ResolveRoomError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResolveRoomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResolveRoomError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::ResolveRoomError {
            meta: generic,
            kind: crate::error::ResolveRoomErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResolveRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResolveRoomError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resolve_room_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResolveRoomOutput, crate::error::ResolveRoomError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::resolve_room_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_resolve_room(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ResolveRoomError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_invitation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RevokeInvitationOutput, crate::error::RevokeInvitationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RevokeInvitationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RevokeInvitationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::RevokeInvitationError {
            meta: generic,
            kind: crate::error::RevokeInvitationErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeInvitationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::RevokeInvitationError {
            meta: generic,
            kind: crate::error::RevokeInvitationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeInvitationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RevokeInvitationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_invitation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RevokeInvitationOutput, crate::error::RevokeInvitationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::revoke_invitation_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_address_books_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SearchAddressBooksOutput,
    crate::error::SearchAddressBooksError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchAddressBooksError::unhandled)?;
    Err(crate::error::SearchAddressBooksError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_address_books_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SearchAddressBooksOutput,
    crate::error::SearchAddressBooksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_address_books_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_address_books(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchAddressBooksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_contacts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchContactsOutput, crate::error::SearchContactsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchContactsError::unhandled)?;
    Err(crate::error::SearchContactsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_contacts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchContactsOutput, crate::error::SearchContactsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_contacts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_contacts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchContactsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchDevicesOutput, crate::error::SearchDevicesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchDevicesError::unhandled)?;
    Err(crate::error::SearchDevicesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchDevicesOutput, crate::error::SearchDevicesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_devices_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_devices(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchDevicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_network_profiles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SearchNetworkProfilesOutput,
    crate::error::SearchNetworkProfilesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchNetworkProfilesError::unhandled)?;
    Err(crate::error::SearchNetworkProfilesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_network_profiles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SearchNetworkProfilesOutput,
    crate::error::SearchNetworkProfilesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_network_profiles_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_network_profiles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchNetworkProfilesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_profiles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchProfilesOutput, crate::error::SearchProfilesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchProfilesError::unhandled)?;
    Err(crate::error::SearchProfilesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_profiles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchProfilesOutput, crate::error::SearchProfilesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_profiles_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_profiles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchProfilesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_rooms_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchRoomsOutput, crate::error::SearchRoomsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchRoomsError::unhandled)?;
    Err(crate::error::SearchRoomsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_rooms_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchRoomsOutput, crate::error::SearchRoomsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_rooms_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_rooms(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchRoomsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_skill_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchSkillGroupsOutput, crate::error::SearchSkillGroupsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchSkillGroupsError::unhandled)?;
    Err(crate::error::SearchSkillGroupsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_skill_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchSkillGroupsOutput, crate::error::SearchSkillGroupsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_skill_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_skill_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchSkillGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_users_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchUsersOutput, crate::error::SearchUsersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchUsersError::unhandled)?;
    Err(crate::error::SearchUsersError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_users_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchUsersOutput, crate::error::SearchUsersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_users_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_users(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchUsersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_announcement_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendAnnouncementOutput, crate::error::SendAnnouncementError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendAnnouncementError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendAnnouncementError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::SendAnnouncementError {
            meta: generic,
            kind: crate::error::SendAnnouncementErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendAnnouncementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::SendAnnouncementError {
            meta: generic,
            kind: crate::error::SendAnnouncementErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendAnnouncementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendAnnouncementError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_announcement_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendAnnouncementOutput, crate::error::SendAnnouncementError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_announcement_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_send_announcement(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendAnnouncementError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_invitation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendInvitationOutput, crate::error::SendInvitationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendInvitationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendInvitationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::SendInvitationError {
            meta: generic,
            kind: crate::error::SendInvitationErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendInvitationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserStatusException" => crate::error::SendInvitationError {
            meta: generic,
            kind: crate::error::SendInvitationErrorKind::InvalidUserStatusException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_user_status_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_user_status_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendInvitationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::SendInvitationError {
            meta: generic,
            kind: crate::error::SendInvitationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendInvitationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendInvitationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_invitation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendInvitationOutput, crate::error::SendInvitationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_invitation_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_device_sync_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartDeviceSyncOutput, crate::error::StartDeviceSyncError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartDeviceSyncError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartDeviceSyncError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DeviceNotRegisteredException" => crate::error::StartDeviceSyncError {
            meta: generic,
            kind: crate::error::StartDeviceSyncErrorKind::DeviceNotRegisteredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::device_not_registered_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_device_not_registered_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDeviceSyncError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartDeviceSyncError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_device_sync_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartDeviceSyncOutput, crate::error::StartDeviceSyncError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_device_sync_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_smart_home_appliance_discovery_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSmartHomeApplianceDiscoveryOutput,
    crate::error::StartSmartHomeApplianceDiscoveryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartSmartHomeApplianceDiscoveryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartSmartHomeApplianceDiscoveryError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::StartSmartHomeApplianceDiscoveryError {
            meta: generic,
            kind: crate::error::StartSmartHomeApplianceDiscoveryErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSmartHomeApplianceDiscoveryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartSmartHomeApplianceDiscoveryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_smart_home_appliance_discovery_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSmartHomeApplianceDiscoveryOutput,
    crate::error::StartSmartHomeApplianceDiscoveryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::start_smart_home_appliance_discovery_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_address_book_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAddressBookOutput, crate::error::UpdateAddressBookError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAddressBookError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAddressBookError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateAddressBookError {
            meta: generic,
            kind: crate::error::UpdateAddressBookErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAddressBookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NameInUseException" => crate::error::UpdateAddressBookError {
            meta: generic,
            kind: crate::error::UpdateAddressBookErrorKind::NameInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAddressBookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateAddressBookError {
            meta: generic,
            kind: crate::error::UpdateAddressBookErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAddressBookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAddressBookError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_address_book_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAddressBookOutput, crate::error::UpdateAddressBookError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_address_book_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_business_report_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBusinessReportScheduleOutput,
    crate::error::UpdateBusinessReportScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateBusinessReportScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateBusinessReportScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateBusinessReportScheduleError {
            meta: generic,
            kind:
                crate::error::UpdateBusinessReportScheduleErrorKind::ConcurrentModificationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::concurrent_modification_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBusinessReportScheduleError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NotFoundException" => crate::error::UpdateBusinessReportScheduleError {
            meta: generic,
            kind: crate::error::UpdateBusinessReportScheduleErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBusinessReportScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateBusinessReportScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_business_report_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBusinessReportScheduleOutput,
    crate::error::UpdateBusinessReportScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_business_report_schedule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_conference_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConferenceProviderOutput,
    crate::error::UpdateConferenceProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateConferenceProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateConferenceProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFoundException" => crate::error::UpdateConferenceProviderError {
            meta: generic,
            kind: crate::error::UpdateConferenceProviderErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConferenceProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateConferenceProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_conference_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConferenceProviderOutput,
    crate::error::UpdateConferenceProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_conference_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_contact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateContactOutput, crate::error::UpdateContactError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateContactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateContactError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateContactError {
            meta: generic,
            kind: crate::error::UpdateContactErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateContactError {
            meta: generic,
            kind: crate::error::UpdateContactErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateContactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_contact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateContactOutput, crate::error::UpdateContactError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_contact_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDeviceOutput, crate::error::UpdateDeviceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateDeviceError {
            meta: generic,
            kind: crate::error::UpdateDeviceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DeviceNotRegisteredException" => crate::error::UpdateDeviceError {
            meta: generic,
            kind: crate::error::UpdateDeviceErrorKind::DeviceNotRegisteredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::device_not_registered_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_device_not_registered_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateDeviceError {
            meta: generic,
            kind: crate::error::UpdateDeviceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDeviceOutput, crate::error::UpdateDeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_gateway_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGatewayOutput, crate::error::UpdateGatewayError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateGatewayError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateGatewayError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NameInUseException" => crate::error::UpdateGatewayError {
            meta: generic,
            kind: crate::error::UpdateGatewayErrorKind::NameInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateGatewayError {
            meta: generic,
            kind: crate::error::UpdateGatewayErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGatewayError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateGatewayError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_gateway_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGatewayOutput, crate::error::UpdateGatewayError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_gateway_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_gateway_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateGatewayGroupOutput,
    crate::error::UpdateGatewayGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateGatewayGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateGatewayGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NameInUseException" => crate::error::UpdateGatewayGroupError {
            meta: generic,
            kind: crate::error::UpdateGatewayGroupErrorKind::NameInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGatewayGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateGatewayGroupError {
            meta: generic,
            kind: crate::error::UpdateGatewayGroupErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGatewayGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateGatewayGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_gateway_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateGatewayGroupOutput,
    crate::error::UpdateGatewayGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_gateway_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_network_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNetworkProfileOutput,
    crate::error::UpdateNetworkProfileError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateNetworkProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateNetworkProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateNetworkProfileError {
            meta: generic,
            kind: crate::error::UpdateNetworkProfileErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCertificateAuthorityException" => crate::error::UpdateNetworkProfileError {
            meta: generic,
            kind: crate::error::UpdateNetworkProfileErrorKind::InvalidCertificateAuthorityException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_certificate_authority_exception::Builder::default(
                            );
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_certificate_authority_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidSecretsManagerResourceException" => crate::error::UpdateNetworkProfileError {
            meta: generic,
            kind:
                crate::error::UpdateNetworkProfileErrorKind::InvalidSecretsManagerResourceException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_secrets_manager_resource_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_secrets_manager_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkProfileError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NameInUseException" => crate::error::UpdateNetworkProfileError {
            meta: generic,
            kind: crate::error::UpdateNetworkProfileErrorKind::NameInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateNetworkProfileError {
            meta: generic,
            kind: crate::error::UpdateNetworkProfileErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateNetworkProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_network_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNetworkProfileOutput,
    crate::error::UpdateNetworkProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_network_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateProfileOutput, crate::error::UpdateProfileError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateProfileError {
            meta: generic,
            kind: crate::error::UpdateProfileErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NameInUseException" => crate::error::UpdateProfileError {
            meta: generic,
            kind: crate::error::UpdateProfileErrorKind::NameInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateProfileError {
            meta: generic,
            kind: crate::error::UpdateProfileErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateProfileOutput, crate::error::UpdateProfileError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_room_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRoomOutput, crate::error::UpdateRoomError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRoomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRoomError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NameInUseException" => crate::error::UpdateRoomError {
            meta: generic,
            kind: crate::error::UpdateRoomErrorKind::NameInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateRoomError {
            meta: generic,
            kind: crate::error::UpdateRoomErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRoomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRoomError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_room_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRoomOutput, crate::error::UpdateRoomError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_room_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_skill_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateSkillGroupOutput, crate::error::UpdateSkillGroupError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSkillGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateSkillGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateSkillGroupError {
            meta: generic,
            kind: crate::error::UpdateSkillGroupErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NameInUseException" => crate::error::UpdateSkillGroupError {
            meta: generic,
            kind: crate::error::UpdateSkillGroupErrorKind::NameInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateSkillGroupError {
            meta: generic,
            kind: crate::error::UpdateSkillGroupErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSkillGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSkillGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_skill_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateSkillGroupOutput, crate::error::UpdateSkillGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_skill_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}
