// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `ApproveSkill`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`approve_skill`](crate::client::Client::approve_skill).
///
/// See [`crate::client::fluent_builders::ApproveSkill`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApproveSkill {
    _private: (),
}
impl ApproveSkill {
    /// Creates a new builder-style object to manufacture [`ApproveSkillInput`](crate::input::ApproveSkillInput)
    pub fn builder() -> crate::input::approve_skill_input::Builder {
        crate::input::approve_skill_input::Builder::default()
    }
    /// Creates a new `ApproveSkill` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ApproveSkill {
    type Output =
        std::result::Result<crate::output::ApproveSkillOutput, crate::error::ApproveSkillError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_approve_skill_error(response)
        } else {
            crate::operation_deser::parse_approve_skill_response(response)
        }
    }
}

/// Operation shape for `AssociateContactWithAddressBook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_contact_with_address_book`](crate::client::Client::associate_contact_with_address_book).
///
/// See [`crate::client::fluent_builders::AssociateContactWithAddressBook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateContactWithAddressBook {
    _private: (),
}
impl AssociateContactWithAddressBook {
    /// Creates a new builder-style object to manufacture [`AssociateContactWithAddressBookInput`](crate::input::AssociateContactWithAddressBookInput)
    pub fn builder() -> crate::input::associate_contact_with_address_book_input::Builder {
        crate::input::associate_contact_with_address_book_input::Builder::default()
    }
    /// Creates a new `AssociateContactWithAddressBook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateContactWithAddressBook {
    type Output = std::result::Result<
        crate::output::AssociateContactWithAddressBookOutput,
        crate::error::AssociateContactWithAddressBookError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_contact_with_address_book_error(response)
        } else {
            crate::operation_deser::parse_associate_contact_with_address_book_response(response)
        }
    }
}

/// Operation shape for `AssociateDeviceWithNetworkProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_device_with_network_profile`](crate::client::Client::associate_device_with_network_profile).
///
/// See [`crate::client::fluent_builders::AssociateDeviceWithNetworkProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateDeviceWithNetworkProfile {
    _private: (),
}
impl AssociateDeviceWithNetworkProfile {
    /// Creates a new builder-style object to manufacture [`AssociateDeviceWithNetworkProfileInput`](crate::input::AssociateDeviceWithNetworkProfileInput)
    pub fn builder() -> crate::input::associate_device_with_network_profile_input::Builder {
        crate::input::associate_device_with_network_profile_input::Builder::default()
    }
    /// Creates a new `AssociateDeviceWithNetworkProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateDeviceWithNetworkProfile {
    type Output = std::result::Result<
        crate::output::AssociateDeviceWithNetworkProfileOutput,
        crate::error::AssociateDeviceWithNetworkProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_device_with_network_profile_error(response)
        } else {
            crate::operation_deser::parse_associate_device_with_network_profile_response(response)
        }
    }
}

/// Operation shape for `AssociateDeviceWithRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_device_with_room`](crate::client::Client::associate_device_with_room).
///
/// See [`crate::client::fluent_builders::AssociateDeviceWithRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateDeviceWithRoom {
    _private: (),
}
impl AssociateDeviceWithRoom {
    /// Creates a new builder-style object to manufacture [`AssociateDeviceWithRoomInput`](crate::input::AssociateDeviceWithRoomInput)
    pub fn builder() -> crate::input::associate_device_with_room_input::Builder {
        crate::input::associate_device_with_room_input::Builder::default()
    }
    /// Creates a new `AssociateDeviceWithRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateDeviceWithRoom {
    type Output = std::result::Result<
        crate::output::AssociateDeviceWithRoomOutput,
        crate::error::AssociateDeviceWithRoomError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_device_with_room_error(response)
        } else {
            crate::operation_deser::parse_associate_device_with_room_response(response)
        }
    }
}

/// Operation shape for `AssociateSkillGroupWithRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_skill_group_with_room`](crate::client::Client::associate_skill_group_with_room).
///
/// See [`crate::client::fluent_builders::AssociateSkillGroupWithRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateSkillGroupWithRoom {
    _private: (),
}
impl AssociateSkillGroupWithRoom {
    /// Creates a new builder-style object to manufacture [`AssociateSkillGroupWithRoomInput`](crate::input::AssociateSkillGroupWithRoomInput)
    pub fn builder() -> crate::input::associate_skill_group_with_room_input::Builder {
        crate::input::associate_skill_group_with_room_input::Builder::default()
    }
    /// Creates a new `AssociateSkillGroupWithRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateSkillGroupWithRoom {
    type Output = std::result::Result<
        crate::output::AssociateSkillGroupWithRoomOutput,
        crate::error::AssociateSkillGroupWithRoomError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_skill_group_with_room_error(response)
        } else {
            crate::operation_deser::parse_associate_skill_group_with_room_response(response)
        }
    }
}

/// Operation shape for `AssociateSkillWithSkillGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_skill_with_skill_group`](crate::client::Client::associate_skill_with_skill_group).
///
/// See [`crate::client::fluent_builders::AssociateSkillWithSkillGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateSkillWithSkillGroup {
    _private: (),
}
impl AssociateSkillWithSkillGroup {
    /// Creates a new builder-style object to manufacture [`AssociateSkillWithSkillGroupInput`](crate::input::AssociateSkillWithSkillGroupInput)
    pub fn builder() -> crate::input::associate_skill_with_skill_group_input::Builder {
        crate::input::associate_skill_with_skill_group_input::Builder::default()
    }
    /// Creates a new `AssociateSkillWithSkillGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateSkillWithSkillGroup {
    type Output = std::result::Result<
        crate::output::AssociateSkillWithSkillGroupOutput,
        crate::error::AssociateSkillWithSkillGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_skill_with_skill_group_error(response)
        } else {
            crate::operation_deser::parse_associate_skill_with_skill_group_response(response)
        }
    }
}

/// Operation shape for `AssociateSkillWithUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_skill_with_users`](crate::client::Client::associate_skill_with_users).
///
/// See [`crate::client::fluent_builders::AssociateSkillWithUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateSkillWithUsers {
    _private: (),
}
impl AssociateSkillWithUsers {
    /// Creates a new builder-style object to manufacture [`AssociateSkillWithUsersInput`](crate::input::AssociateSkillWithUsersInput)
    pub fn builder() -> crate::input::associate_skill_with_users_input::Builder {
        crate::input::associate_skill_with_users_input::Builder::default()
    }
    /// Creates a new `AssociateSkillWithUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateSkillWithUsers {
    type Output = std::result::Result<
        crate::output::AssociateSkillWithUsersOutput,
        crate::error::AssociateSkillWithUsersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_skill_with_users_error(response)
        } else {
            crate::operation_deser::parse_associate_skill_with_users_response(response)
        }
    }
}

/// Operation shape for `CreateAddressBook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_address_book`](crate::client::Client::create_address_book).
///
/// See [`crate::client::fluent_builders::CreateAddressBook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAddressBook {
    _private: (),
}
impl CreateAddressBook {
    /// Creates a new builder-style object to manufacture [`CreateAddressBookInput`](crate::input::CreateAddressBookInput)
    pub fn builder() -> crate::input::create_address_book_input::Builder {
        crate::input::create_address_book_input::Builder::default()
    }
    /// Creates a new `CreateAddressBook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAddressBook {
    type Output = std::result::Result<
        crate::output::CreateAddressBookOutput,
        crate::error::CreateAddressBookError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_address_book_error(response)
        } else {
            crate::operation_deser::parse_create_address_book_response(response)
        }
    }
}

/// Operation shape for `CreateBusinessReportSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_business_report_schedule`](crate::client::Client::create_business_report_schedule).
///
/// See [`crate::client::fluent_builders::CreateBusinessReportSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBusinessReportSchedule {
    _private: (),
}
impl CreateBusinessReportSchedule {
    /// Creates a new builder-style object to manufacture [`CreateBusinessReportScheduleInput`](crate::input::CreateBusinessReportScheduleInput)
    pub fn builder() -> crate::input::create_business_report_schedule_input::Builder {
        crate::input::create_business_report_schedule_input::Builder::default()
    }
    /// Creates a new `CreateBusinessReportSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBusinessReportSchedule {
    type Output = std::result::Result<
        crate::output::CreateBusinessReportScheduleOutput,
        crate::error::CreateBusinessReportScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_business_report_schedule_error(response)
        } else {
            crate::operation_deser::parse_create_business_report_schedule_response(response)
        }
    }
}

/// Operation shape for `CreateConferenceProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_conference_provider`](crate::client::Client::create_conference_provider).
///
/// See [`crate::client::fluent_builders::CreateConferenceProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConferenceProvider {
    _private: (),
}
impl CreateConferenceProvider {
    /// Creates a new builder-style object to manufacture [`CreateConferenceProviderInput`](crate::input::CreateConferenceProviderInput)
    pub fn builder() -> crate::input::create_conference_provider_input::Builder {
        crate::input::create_conference_provider_input::Builder::default()
    }
    /// Creates a new `CreateConferenceProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConferenceProvider {
    type Output = std::result::Result<
        crate::output::CreateConferenceProviderOutput,
        crate::error::CreateConferenceProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_conference_provider_error(response)
        } else {
            crate::operation_deser::parse_create_conference_provider_response(response)
        }
    }
}

/// Operation shape for `CreateContact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_contact`](crate::client::Client::create_contact).
///
/// See [`crate::client::fluent_builders::CreateContact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateContact {
    _private: (),
}
impl CreateContact {
    /// Creates a new builder-style object to manufacture [`CreateContactInput`](crate::input::CreateContactInput)
    pub fn builder() -> crate::input::create_contact_input::Builder {
        crate::input::create_contact_input::Builder::default()
    }
    /// Creates a new `CreateContact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateContact {
    type Output =
        std::result::Result<crate::output::CreateContactOutput, crate::error::CreateContactError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_contact_error(response)
        } else {
            crate::operation_deser::parse_create_contact_response(response)
        }
    }
}

/// Operation shape for `CreateGatewayGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_gateway_group`](crate::client::Client::create_gateway_group).
///
/// See [`crate::client::fluent_builders::CreateGatewayGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGatewayGroup {
    _private: (),
}
impl CreateGatewayGroup {
    /// Creates a new builder-style object to manufacture [`CreateGatewayGroupInput`](crate::input::CreateGatewayGroupInput)
    pub fn builder() -> crate::input::create_gateway_group_input::Builder {
        crate::input::create_gateway_group_input::Builder::default()
    }
    /// Creates a new `CreateGatewayGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGatewayGroup {
    type Output = std::result::Result<
        crate::output::CreateGatewayGroupOutput,
        crate::error::CreateGatewayGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_gateway_group_error(response)
        } else {
            crate::operation_deser::parse_create_gateway_group_response(response)
        }
    }
}

/// Operation shape for `CreateNetworkProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network_profile`](crate::client::Client::create_network_profile).
///
/// See [`crate::client::fluent_builders::CreateNetworkProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetworkProfile {
    _private: (),
}
impl CreateNetworkProfile {
    /// Creates a new builder-style object to manufacture [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
    pub fn builder() -> crate::input::create_network_profile_input::Builder {
        crate::input::create_network_profile_input::Builder::default()
    }
    /// Creates a new `CreateNetworkProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetworkProfile {
    type Output = std::result::Result<
        crate::output::CreateNetworkProfileOutput,
        crate::error::CreateNetworkProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_profile_error(response)
        } else {
            crate::operation_deser::parse_create_network_profile_response(response)
        }
    }
}

/// Operation shape for `CreateProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_profile`](crate::client::Client::create_profile).
///
/// See [`crate::client::fluent_builders::CreateProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProfile {
    _private: (),
}
impl CreateProfile {
    /// Creates a new builder-style object to manufacture [`CreateProfileInput`](crate::input::CreateProfileInput)
    pub fn builder() -> crate::input::create_profile_input::Builder {
        crate::input::create_profile_input::Builder::default()
    }
    /// Creates a new `CreateProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProfile {
    type Output =
        std::result::Result<crate::output::CreateProfileOutput, crate::error::CreateProfileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_profile_error(response)
        } else {
            crate::operation_deser::parse_create_profile_response(response)
        }
    }
}

/// Operation shape for `CreateRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_room`](crate::client::Client::create_room).
///
/// See [`crate::client::fluent_builders::CreateRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRoom {
    _private: (),
}
impl CreateRoom {
    /// Creates a new builder-style object to manufacture [`CreateRoomInput`](crate::input::CreateRoomInput)
    pub fn builder() -> crate::input::create_room_input::Builder {
        crate::input::create_room_input::Builder::default()
    }
    /// Creates a new `CreateRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRoom {
    type Output =
        std::result::Result<crate::output::CreateRoomOutput, crate::error::CreateRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_room_error(response)
        } else {
            crate::operation_deser::parse_create_room_response(response)
        }
    }
}

/// Operation shape for `CreateSkillGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_skill_group`](crate::client::Client::create_skill_group).
///
/// See [`crate::client::fluent_builders::CreateSkillGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSkillGroup {
    _private: (),
}
impl CreateSkillGroup {
    /// Creates a new builder-style object to manufacture [`CreateSkillGroupInput`](crate::input::CreateSkillGroupInput)
    pub fn builder() -> crate::input::create_skill_group_input::Builder {
        crate::input::create_skill_group_input::Builder::default()
    }
    /// Creates a new `CreateSkillGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSkillGroup {
    type Output = std::result::Result<
        crate::output::CreateSkillGroupOutput,
        crate::error::CreateSkillGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_skill_group_error(response)
        } else {
            crate::operation_deser::parse_create_skill_group_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `DeleteAddressBook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_address_book`](crate::client::Client::delete_address_book).
///
/// See [`crate::client::fluent_builders::DeleteAddressBook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAddressBook {
    _private: (),
}
impl DeleteAddressBook {
    /// Creates a new builder-style object to manufacture [`DeleteAddressBookInput`](crate::input::DeleteAddressBookInput)
    pub fn builder() -> crate::input::delete_address_book_input::Builder {
        crate::input::delete_address_book_input::Builder::default()
    }
    /// Creates a new `DeleteAddressBook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAddressBook {
    type Output = std::result::Result<
        crate::output::DeleteAddressBookOutput,
        crate::error::DeleteAddressBookError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_address_book_error(response)
        } else {
            crate::operation_deser::parse_delete_address_book_response(response)
        }
    }
}

/// Operation shape for `DeleteBusinessReportSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_business_report_schedule`](crate::client::Client::delete_business_report_schedule).
///
/// See [`crate::client::fluent_builders::DeleteBusinessReportSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBusinessReportSchedule {
    _private: (),
}
impl DeleteBusinessReportSchedule {
    /// Creates a new builder-style object to manufacture [`DeleteBusinessReportScheduleInput`](crate::input::DeleteBusinessReportScheduleInput)
    pub fn builder() -> crate::input::delete_business_report_schedule_input::Builder {
        crate::input::delete_business_report_schedule_input::Builder::default()
    }
    /// Creates a new `DeleteBusinessReportSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBusinessReportSchedule {
    type Output = std::result::Result<
        crate::output::DeleteBusinessReportScheduleOutput,
        crate::error::DeleteBusinessReportScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_business_report_schedule_error(response)
        } else {
            crate::operation_deser::parse_delete_business_report_schedule_response(response)
        }
    }
}

/// Operation shape for `DeleteConferenceProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_conference_provider`](crate::client::Client::delete_conference_provider).
///
/// See [`crate::client::fluent_builders::DeleteConferenceProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConferenceProvider {
    _private: (),
}
impl DeleteConferenceProvider {
    /// Creates a new builder-style object to manufacture [`DeleteConferenceProviderInput`](crate::input::DeleteConferenceProviderInput)
    pub fn builder() -> crate::input::delete_conference_provider_input::Builder {
        crate::input::delete_conference_provider_input::Builder::default()
    }
    /// Creates a new `DeleteConferenceProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConferenceProvider {
    type Output = std::result::Result<
        crate::output::DeleteConferenceProviderOutput,
        crate::error::DeleteConferenceProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_conference_provider_error(response)
        } else {
            crate::operation_deser::parse_delete_conference_provider_response(response)
        }
    }
}

/// Operation shape for `DeleteContact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_contact`](crate::client::Client::delete_contact).
///
/// See [`crate::client::fluent_builders::DeleteContact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteContact {
    _private: (),
}
impl DeleteContact {
    /// Creates a new builder-style object to manufacture [`DeleteContactInput`](crate::input::DeleteContactInput)
    pub fn builder() -> crate::input::delete_contact_input::Builder {
        crate::input::delete_contact_input::Builder::default()
    }
    /// Creates a new `DeleteContact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteContact {
    type Output =
        std::result::Result<crate::output::DeleteContactOutput, crate::error::DeleteContactError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_contact_error(response)
        } else {
            crate::operation_deser::parse_delete_contact_response(response)
        }
    }
}

/// Operation shape for `DeleteDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_device`](crate::client::Client::delete_device).
///
/// See [`crate::client::fluent_builders::DeleteDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDevice {
    _private: (),
}
impl DeleteDevice {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    pub fn builder() -> crate::input::delete_device_input::Builder {
        crate::input::delete_device_input::Builder::default()
    }
    /// Creates a new `DeleteDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDevice {
    type Output =
        std::result::Result<crate::output::DeleteDeviceOutput, crate::error::DeleteDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_device_error(response)
        } else {
            crate::operation_deser::parse_delete_device_response(response)
        }
    }
}

/// Operation shape for `DeleteDeviceUsageData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_device_usage_data`](crate::client::Client::delete_device_usage_data).
///
/// See [`crate::client::fluent_builders::DeleteDeviceUsageData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDeviceUsageData {
    _private: (),
}
impl DeleteDeviceUsageData {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceUsageDataInput`](crate::input::DeleteDeviceUsageDataInput)
    pub fn builder() -> crate::input::delete_device_usage_data_input::Builder {
        crate::input::delete_device_usage_data_input::Builder::default()
    }
    /// Creates a new `DeleteDeviceUsageData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDeviceUsageData {
    type Output = std::result::Result<
        crate::output::DeleteDeviceUsageDataOutput,
        crate::error::DeleteDeviceUsageDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_device_usage_data_error(response)
        } else {
            crate::operation_deser::parse_delete_device_usage_data_response(response)
        }
    }
}

/// Operation shape for `DeleteGatewayGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_gateway_group`](crate::client::Client::delete_gateway_group).
///
/// See [`crate::client::fluent_builders::DeleteGatewayGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGatewayGroup {
    _private: (),
}
impl DeleteGatewayGroup {
    /// Creates a new builder-style object to manufacture [`DeleteGatewayGroupInput`](crate::input::DeleteGatewayGroupInput)
    pub fn builder() -> crate::input::delete_gateway_group_input::Builder {
        crate::input::delete_gateway_group_input::Builder::default()
    }
    /// Creates a new `DeleteGatewayGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGatewayGroup {
    type Output = std::result::Result<
        crate::output::DeleteGatewayGroupOutput,
        crate::error::DeleteGatewayGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_gateway_group_error(response)
        } else {
            crate::operation_deser::parse_delete_gateway_group_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_profile`](crate::client::Client::delete_network_profile).
///
/// See [`crate::client::fluent_builders::DeleteNetworkProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkProfile {
    _private: (),
}
impl DeleteNetworkProfile {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
    pub fn builder() -> crate::input::delete_network_profile_input::Builder {
        crate::input::delete_network_profile_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkProfile {
    type Output = std::result::Result<
        crate::output::DeleteNetworkProfileOutput,
        crate::error::DeleteNetworkProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_network_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_profile`](crate::client::Client::delete_profile).
///
/// See [`crate::client::fluent_builders::DeleteProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProfile {
    _private: (),
}
impl DeleteProfile {
    /// Creates a new builder-style object to manufacture [`DeleteProfileInput`](crate::input::DeleteProfileInput)
    pub fn builder() -> crate::input::delete_profile_input::Builder {
        crate::input::delete_profile_input::Builder::default()
    }
    /// Creates a new `DeleteProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProfile {
    type Output =
        std::result::Result<crate::output::DeleteProfileOutput, crate::error::DeleteProfileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_room`](crate::client::Client::delete_room).
///
/// See [`crate::client::fluent_builders::DeleteRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRoom {
    _private: (),
}
impl DeleteRoom {
    /// Creates a new builder-style object to manufacture [`DeleteRoomInput`](crate::input::DeleteRoomInput)
    pub fn builder() -> crate::input::delete_room_input::Builder {
        crate::input::delete_room_input::Builder::default()
    }
    /// Creates a new `DeleteRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRoom {
    type Output =
        std::result::Result<crate::output::DeleteRoomOutput, crate::error::DeleteRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_room_error(response)
        } else {
            crate::operation_deser::parse_delete_room_response(response)
        }
    }
}

/// Operation shape for `DeleteRoomSkillParameter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_room_skill_parameter`](crate::client::Client::delete_room_skill_parameter).
///
/// See [`crate::client::fluent_builders::DeleteRoomSkillParameter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRoomSkillParameter {
    _private: (),
}
impl DeleteRoomSkillParameter {
    /// Creates a new builder-style object to manufacture [`DeleteRoomSkillParameterInput`](crate::input::DeleteRoomSkillParameterInput)
    pub fn builder() -> crate::input::delete_room_skill_parameter_input::Builder {
        crate::input::delete_room_skill_parameter_input::Builder::default()
    }
    /// Creates a new `DeleteRoomSkillParameter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRoomSkillParameter {
    type Output = std::result::Result<
        crate::output::DeleteRoomSkillParameterOutput,
        crate::error::DeleteRoomSkillParameterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_room_skill_parameter_error(response)
        } else {
            crate::operation_deser::parse_delete_room_skill_parameter_response(response)
        }
    }
}

/// Operation shape for `DeleteSkillAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_skill_authorization`](crate::client::Client::delete_skill_authorization).
///
/// See [`crate::client::fluent_builders::DeleteSkillAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSkillAuthorization {
    _private: (),
}
impl DeleteSkillAuthorization {
    /// Creates a new builder-style object to manufacture [`DeleteSkillAuthorizationInput`](crate::input::DeleteSkillAuthorizationInput)
    pub fn builder() -> crate::input::delete_skill_authorization_input::Builder {
        crate::input::delete_skill_authorization_input::Builder::default()
    }
    /// Creates a new `DeleteSkillAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSkillAuthorization {
    type Output = std::result::Result<
        crate::output::DeleteSkillAuthorizationOutput,
        crate::error::DeleteSkillAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_skill_authorization_error(response)
        } else {
            crate::operation_deser::parse_delete_skill_authorization_response(response)
        }
    }
}

/// Operation shape for `DeleteSkillGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_skill_group`](crate::client::Client::delete_skill_group).
///
/// See [`crate::client::fluent_builders::DeleteSkillGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSkillGroup {
    _private: (),
}
impl DeleteSkillGroup {
    /// Creates a new builder-style object to manufacture [`DeleteSkillGroupInput`](crate::input::DeleteSkillGroupInput)
    pub fn builder() -> crate::input::delete_skill_group_input::Builder {
        crate::input::delete_skill_group_input::Builder::default()
    }
    /// Creates a new `DeleteSkillGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSkillGroup {
    type Output = std::result::Result<
        crate::output::DeleteSkillGroupOutput,
        crate::error::DeleteSkillGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_skill_group_error(response)
        } else {
            crate::operation_deser::parse_delete_skill_group_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DisassociateContactFromAddressBook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_contact_from_address_book`](crate::client::Client::disassociate_contact_from_address_book).
///
/// See [`crate::client::fluent_builders::DisassociateContactFromAddressBook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateContactFromAddressBook {
    _private: (),
}
impl DisassociateContactFromAddressBook {
    /// Creates a new builder-style object to manufacture [`DisassociateContactFromAddressBookInput`](crate::input::DisassociateContactFromAddressBookInput)
    pub fn builder() -> crate::input::disassociate_contact_from_address_book_input::Builder {
        crate::input::disassociate_contact_from_address_book_input::Builder::default()
    }
    /// Creates a new `DisassociateContactFromAddressBook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateContactFromAddressBook {
    type Output = std::result::Result<
        crate::output::DisassociateContactFromAddressBookOutput,
        crate::error::DisassociateContactFromAddressBookError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_contact_from_address_book_error(response)
        } else {
            crate::operation_deser::parse_disassociate_contact_from_address_book_response(response)
        }
    }
}

/// Operation shape for `DisassociateDeviceFromRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_device_from_room`](crate::client::Client::disassociate_device_from_room).
///
/// See [`crate::client::fluent_builders::DisassociateDeviceFromRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateDeviceFromRoom {
    _private: (),
}
impl DisassociateDeviceFromRoom {
    /// Creates a new builder-style object to manufacture [`DisassociateDeviceFromRoomInput`](crate::input::DisassociateDeviceFromRoomInput)
    pub fn builder() -> crate::input::disassociate_device_from_room_input::Builder {
        crate::input::disassociate_device_from_room_input::Builder::default()
    }
    /// Creates a new `DisassociateDeviceFromRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateDeviceFromRoom {
    type Output = std::result::Result<
        crate::output::DisassociateDeviceFromRoomOutput,
        crate::error::DisassociateDeviceFromRoomError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_device_from_room_error(response)
        } else {
            crate::operation_deser::parse_disassociate_device_from_room_response(response)
        }
    }
}

/// Operation shape for `DisassociateSkillFromSkillGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_skill_from_skill_group`](crate::client::Client::disassociate_skill_from_skill_group).
///
/// See [`crate::client::fluent_builders::DisassociateSkillFromSkillGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateSkillFromSkillGroup {
    _private: (),
}
impl DisassociateSkillFromSkillGroup {
    /// Creates a new builder-style object to manufacture [`DisassociateSkillFromSkillGroupInput`](crate::input::DisassociateSkillFromSkillGroupInput)
    pub fn builder() -> crate::input::disassociate_skill_from_skill_group_input::Builder {
        crate::input::disassociate_skill_from_skill_group_input::Builder::default()
    }
    /// Creates a new `DisassociateSkillFromSkillGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateSkillFromSkillGroup {
    type Output = std::result::Result<
        crate::output::DisassociateSkillFromSkillGroupOutput,
        crate::error::DisassociateSkillFromSkillGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_skill_from_skill_group_error(response)
        } else {
            crate::operation_deser::parse_disassociate_skill_from_skill_group_response(response)
        }
    }
}

/// Operation shape for `DisassociateSkillFromUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_skill_from_users`](crate::client::Client::disassociate_skill_from_users).
///
/// See [`crate::client::fluent_builders::DisassociateSkillFromUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateSkillFromUsers {
    _private: (),
}
impl DisassociateSkillFromUsers {
    /// Creates a new builder-style object to manufacture [`DisassociateSkillFromUsersInput`](crate::input::DisassociateSkillFromUsersInput)
    pub fn builder() -> crate::input::disassociate_skill_from_users_input::Builder {
        crate::input::disassociate_skill_from_users_input::Builder::default()
    }
    /// Creates a new `DisassociateSkillFromUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateSkillFromUsers {
    type Output = std::result::Result<
        crate::output::DisassociateSkillFromUsersOutput,
        crate::error::DisassociateSkillFromUsersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_skill_from_users_error(response)
        } else {
            crate::operation_deser::parse_disassociate_skill_from_users_response(response)
        }
    }
}

/// Operation shape for `DisassociateSkillGroupFromRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_skill_group_from_room`](crate::client::Client::disassociate_skill_group_from_room).
///
/// See [`crate::client::fluent_builders::DisassociateSkillGroupFromRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateSkillGroupFromRoom {
    _private: (),
}
impl DisassociateSkillGroupFromRoom {
    /// Creates a new builder-style object to manufacture [`DisassociateSkillGroupFromRoomInput`](crate::input::DisassociateSkillGroupFromRoomInput)
    pub fn builder() -> crate::input::disassociate_skill_group_from_room_input::Builder {
        crate::input::disassociate_skill_group_from_room_input::Builder::default()
    }
    /// Creates a new `DisassociateSkillGroupFromRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateSkillGroupFromRoom {
    type Output = std::result::Result<
        crate::output::DisassociateSkillGroupFromRoomOutput,
        crate::error::DisassociateSkillGroupFromRoomError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_skill_group_from_room_error(response)
        } else {
            crate::operation_deser::parse_disassociate_skill_group_from_room_response(response)
        }
    }
}

/// Operation shape for `ForgetSmartHomeAppliances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`forget_smart_home_appliances`](crate::client::Client::forget_smart_home_appliances).
///
/// See [`crate::client::fluent_builders::ForgetSmartHomeAppliances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ForgetSmartHomeAppliances {
    _private: (),
}
impl ForgetSmartHomeAppliances {
    /// Creates a new builder-style object to manufacture [`ForgetSmartHomeAppliancesInput`](crate::input::ForgetSmartHomeAppliancesInput)
    pub fn builder() -> crate::input::forget_smart_home_appliances_input::Builder {
        crate::input::forget_smart_home_appliances_input::Builder::default()
    }
    /// Creates a new `ForgetSmartHomeAppliances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ForgetSmartHomeAppliances {
    type Output = std::result::Result<
        crate::output::ForgetSmartHomeAppliancesOutput,
        crate::error::ForgetSmartHomeAppliancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_forget_smart_home_appliances_error(response)
        } else {
            crate::operation_deser::parse_forget_smart_home_appliances_response(response)
        }
    }
}

/// Operation shape for `GetAddressBook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_address_book`](crate::client::Client::get_address_book).
///
/// See [`crate::client::fluent_builders::GetAddressBook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAddressBook {
    _private: (),
}
impl GetAddressBook {
    /// Creates a new builder-style object to manufacture [`GetAddressBookInput`](crate::input::GetAddressBookInput)
    pub fn builder() -> crate::input::get_address_book_input::Builder {
        crate::input::get_address_book_input::Builder::default()
    }
    /// Creates a new `GetAddressBook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAddressBook {
    type Output =
        std::result::Result<crate::output::GetAddressBookOutput, crate::error::GetAddressBookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_address_book_error(response)
        } else {
            crate::operation_deser::parse_get_address_book_response(response)
        }
    }
}

/// Operation shape for `GetConferencePreference`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_conference_preference`](crate::client::Client::get_conference_preference).
///
/// See [`crate::client::fluent_builders::GetConferencePreference`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConferencePreference {
    _private: (),
}
impl GetConferencePreference {
    /// Creates a new builder-style object to manufacture [`GetConferencePreferenceInput`](crate::input::GetConferencePreferenceInput)
    pub fn builder() -> crate::input::get_conference_preference_input::Builder {
        crate::input::get_conference_preference_input::Builder::default()
    }
    /// Creates a new `GetConferencePreference` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConferencePreference {
    type Output = std::result::Result<
        crate::output::GetConferencePreferenceOutput,
        crate::error::GetConferencePreferenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_conference_preference_error(response)
        } else {
            crate::operation_deser::parse_get_conference_preference_response(response)
        }
    }
}

/// Operation shape for `GetConferenceProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_conference_provider`](crate::client::Client::get_conference_provider).
///
/// See [`crate::client::fluent_builders::GetConferenceProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConferenceProvider {
    _private: (),
}
impl GetConferenceProvider {
    /// Creates a new builder-style object to manufacture [`GetConferenceProviderInput`](crate::input::GetConferenceProviderInput)
    pub fn builder() -> crate::input::get_conference_provider_input::Builder {
        crate::input::get_conference_provider_input::Builder::default()
    }
    /// Creates a new `GetConferenceProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConferenceProvider {
    type Output = std::result::Result<
        crate::output::GetConferenceProviderOutput,
        crate::error::GetConferenceProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_conference_provider_error(response)
        } else {
            crate::operation_deser::parse_get_conference_provider_response(response)
        }
    }
}

/// Operation shape for `GetContact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_contact`](crate::client::Client::get_contact).
///
/// See [`crate::client::fluent_builders::GetContact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContact {
    _private: (),
}
impl GetContact {
    /// Creates a new builder-style object to manufacture [`GetContactInput`](crate::input::GetContactInput)
    pub fn builder() -> crate::input::get_contact_input::Builder {
        crate::input::get_contact_input::Builder::default()
    }
    /// Creates a new `GetContact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContact {
    type Output =
        std::result::Result<crate::output::GetContactOutput, crate::error::GetContactError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_contact_error(response)
        } else {
            crate::operation_deser::parse_get_contact_response(response)
        }
    }
}

/// Operation shape for `GetDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device`](crate::client::Client::get_device).
///
/// See [`crate::client::fluent_builders::GetDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevice {
    _private: (),
}
impl GetDevice {
    /// Creates a new builder-style object to manufacture [`GetDeviceInput`](crate::input::GetDeviceInput)
    pub fn builder() -> crate::input::get_device_input::Builder {
        crate::input::get_device_input::Builder::default()
    }
    /// Creates a new `GetDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevice {
    type Output = std::result::Result<crate::output::GetDeviceOutput, crate::error::GetDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_error(response)
        } else {
            crate::operation_deser::parse_get_device_response(response)
        }
    }
}

/// Operation shape for `GetGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_gateway`](crate::client::Client::get_gateway).
///
/// See [`crate::client::fluent_builders::GetGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGateway {
    _private: (),
}
impl GetGateway {
    /// Creates a new builder-style object to manufacture [`GetGatewayInput`](crate::input::GetGatewayInput)
    pub fn builder() -> crate::input::get_gateway_input::Builder {
        crate::input::get_gateway_input::Builder::default()
    }
    /// Creates a new `GetGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGateway {
    type Output =
        std::result::Result<crate::output::GetGatewayOutput, crate::error::GetGatewayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_gateway_error(response)
        } else {
            crate::operation_deser::parse_get_gateway_response(response)
        }
    }
}

/// Operation shape for `GetGatewayGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_gateway_group`](crate::client::Client::get_gateway_group).
///
/// See [`crate::client::fluent_builders::GetGatewayGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGatewayGroup {
    _private: (),
}
impl GetGatewayGroup {
    /// Creates a new builder-style object to manufacture [`GetGatewayGroupInput`](crate::input::GetGatewayGroupInput)
    pub fn builder() -> crate::input::get_gateway_group_input::Builder {
        crate::input::get_gateway_group_input::Builder::default()
    }
    /// Creates a new `GetGatewayGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGatewayGroup {
    type Output = std::result::Result<
        crate::output::GetGatewayGroupOutput,
        crate::error::GetGatewayGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_gateway_group_error(response)
        } else {
            crate::operation_deser::parse_get_gateway_group_response(response)
        }
    }
}

/// Operation shape for `GetInvitationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_invitation_configuration`](crate::client::Client::get_invitation_configuration).
///
/// See [`crate::client::fluent_builders::GetInvitationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInvitationConfiguration {
    _private: (),
}
impl GetInvitationConfiguration {
    /// Creates a new builder-style object to manufacture [`GetInvitationConfigurationInput`](crate::input::GetInvitationConfigurationInput)
    pub fn builder() -> crate::input::get_invitation_configuration_input::Builder {
        crate::input::get_invitation_configuration_input::Builder::default()
    }
    /// Creates a new `GetInvitationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInvitationConfiguration {
    type Output = std::result::Result<
        crate::output::GetInvitationConfigurationOutput,
        crate::error::GetInvitationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_invitation_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_invitation_configuration_response(response)
        }
    }
}

/// Operation shape for `GetNetworkProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_profile`](crate::client::Client::get_network_profile).
///
/// See [`crate::client::fluent_builders::GetNetworkProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkProfile {
    _private: (),
}
impl GetNetworkProfile {
    /// Creates a new builder-style object to manufacture [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
    pub fn builder() -> crate::input::get_network_profile_input::Builder {
        crate::input::get_network_profile_input::Builder::default()
    }
    /// Creates a new `GetNetworkProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkProfile {
    type Output = std::result::Result<
        crate::output::GetNetworkProfileOutput,
        crate::error::GetNetworkProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_profile_error(response)
        } else {
            crate::operation_deser::parse_get_network_profile_response(response)
        }
    }
}

/// Operation shape for `GetProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_profile`](crate::client::Client::get_profile).
///
/// See [`crate::client::fluent_builders::GetProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProfile {
    _private: (),
}
impl GetProfile {
    /// Creates a new builder-style object to manufacture [`GetProfileInput`](crate::input::GetProfileInput)
    pub fn builder() -> crate::input::get_profile_input::Builder {
        crate::input::get_profile_input::Builder::default()
    }
    /// Creates a new `GetProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProfile {
    type Output =
        std::result::Result<crate::output::GetProfileOutput, crate::error::GetProfileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_profile_error(response)
        } else {
            crate::operation_deser::parse_get_profile_response(response)
        }
    }
}

/// Operation shape for `GetRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_room`](crate::client::Client::get_room).
///
/// See [`crate::client::fluent_builders::GetRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRoom {
    _private: (),
}
impl GetRoom {
    /// Creates a new builder-style object to manufacture [`GetRoomInput`](crate::input::GetRoomInput)
    pub fn builder() -> crate::input::get_room_input::Builder {
        crate::input::get_room_input::Builder::default()
    }
    /// Creates a new `GetRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRoom {
    type Output = std::result::Result<crate::output::GetRoomOutput, crate::error::GetRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_room_error(response)
        } else {
            crate::operation_deser::parse_get_room_response(response)
        }
    }
}

/// Operation shape for `GetRoomSkillParameter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_room_skill_parameter`](crate::client::Client::get_room_skill_parameter).
///
/// See [`crate::client::fluent_builders::GetRoomSkillParameter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRoomSkillParameter {
    _private: (),
}
impl GetRoomSkillParameter {
    /// Creates a new builder-style object to manufacture [`GetRoomSkillParameterInput`](crate::input::GetRoomSkillParameterInput)
    pub fn builder() -> crate::input::get_room_skill_parameter_input::Builder {
        crate::input::get_room_skill_parameter_input::Builder::default()
    }
    /// Creates a new `GetRoomSkillParameter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRoomSkillParameter {
    type Output = std::result::Result<
        crate::output::GetRoomSkillParameterOutput,
        crate::error::GetRoomSkillParameterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_room_skill_parameter_error(response)
        } else {
            crate::operation_deser::parse_get_room_skill_parameter_response(response)
        }
    }
}

/// Operation shape for `GetSkillGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_skill_group`](crate::client::Client::get_skill_group).
///
/// See [`crate::client::fluent_builders::GetSkillGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSkillGroup {
    _private: (),
}
impl GetSkillGroup {
    /// Creates a new builder-style object to manufacture [`GetSkillGroupInput`](crate::input::GetSkillGroupInput)
    pub fn builder() -> crate::input::get_skill_group_input::Builder {
        crate::input::get_skill_group_input::Builder::default()
    }
    /// Creates a new `GetSkillGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSkillGroup {
    type Output =
        std::result::Result<crate::output::GetSkillGroupOutput, crate::error::GetSkillGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_skill_group_error(response)
        } else {
            crate::operation_deser::parse_get_skill_group_response(response)
        }
    }
}

/// Operation shape for `ListBusinessReportSchedules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_business_report_schedules`](crate::client::Client::list_business_report_schedules).
///
/// See [`crate::client::fluent_builders::ListBusinessReportSchedules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBusinessReportSchedules {
    _private: (),
}
impl ListBusinessReportSchedules {
    /// Creates a new builder-style object to manufacture [`ListBusinessReportSchedulesInput`](crate::input::ListBusinessReportSchedulesInput)
    pub fn builder() -> crate::input::list_business_report_schedules_input::Builder {
        crate::input::list_business_report_schedules_input::Builder::default()
    }
    /// Creates a new `ListBusinessReportSchedules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBusinessReportSchedules {
    type Output = std::result::Result<
        crate::output::ListBusinessReportSchedulesOutput,
        crate::error::ListBusinessReportSchedulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_business_report_schedules_error(response)
        } else {
            crate::operation_deser::parse_list_business_report_schedules_response(response)
        }
    }
}

/// Operation shape for `ListConferenceProviders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_conference_providers`](crate::client::Client::list_conference_providers).
///
/// See [`crate::client::fluent_builders::ListConferenceProviders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConferenceProviders {
    _private: (),
}
impl ListConferenceProviders {
    /// Creates a new builder-style object to manufacture [`ListConferenceProvidersInput`](crate::input::ListConferenceProvidersInput)
    pub fn builder() -> crate::input::list_conference_providers_input::Builder {
        crate::input::list_conference_providers_input::Builder::default()
    }
    /// Creates a new `ListConferenceProviders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConferenceProviders {
    type Output = std::result::Result<
        crate::output::ListConferenceProvidersOutput,
        crate::error::ListConferenceProvidersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_conference_providers_error(response)
        } else {
            crate::operation_deser::parse_list_conference_providers_response(response)
        }
    }
}

/// Operation shape for `ListDeviceEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_events`](crate::client::Client::list_device_events).
///
/// See [`crate::client::fluent_builders::ListDeviceEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeviceEvents {
    _private: (),
}
impl ListDeviceEvents {
    /// Creates a new builder-style object to manufacture [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
    pub fn builder() -> crate::input::list_device_events_input::Builder {
        crate::input::list_device_events_input::Builder::default()
    }
    /// Creates a new `ListDeviceEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeviceEvents {
    type Output = std::result::Result<
        crate::output::ListDeviceEventsOutput,
        crate::error::ListDeviceEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_events_error(response)
        } else {
            crate::operation_deser::parse_list_device_events_response(response)
        }
    }
}

/// Operation shape for `ListGatewayGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_gateway_groups`](crate::client::Client::list_gateway_groups).
///
/// See [`crate::client::fluent_builders::ListGatewayGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGatewayGroups {
    _private: (),
}
impl ListGatewayGroups {
    /// Creates a new builder-style object to manufacture [`ListGatewayGroupsInput`](crate::input::ListGatewayGroupsInput)
    pub fn builder() -> crate::input::list_gateway_groups_input::Builder {
        crate::input::list_gateway_groups_input::Builder::default()
    }
    /// Creates a new `ListGatewayGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGatewayGroups {
    type Output = std::result::Result<
        crate::output::ListGatewayGroupsOutput,
        crate::error::ListGatewayGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_gateway_groups_error(response)
        } else {
            crate::operation_deser::parse_list_gateway_groups_response(response)
        }
    }
}

/// Operation shape for `ListGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_gateways`](crate::client::Client::list_gateways).
///
/// See [`crate::client::fluent_builders::ListGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGateways {
    _private: (),
}
impl ListGateways {
    /// Creates a new builder-style object to manufacture [`ListGatewaysInput`](crate::input::ListGatewaysInput)
    pub fn builder() -> crate::input::list_gateways_input::Builder {
        crate::input::list_gateways_input::Builder::default()
    }
    /// Creates a new `ListGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGateways {
    type Output =
        std::result::Result<crate::output::ListGatewaysOutput, crate::error::ListGatewaysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_gateways_error(response)
        } else {
            crate::operation_deser::parse_list_gateways_response(response)
        }
    }
}

/// Operation shape for `ListSkills`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_skills`](crate::client::Client::list_skills).
///
/// See [`crate::client::fluent_builders::ListSkills`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSkills {
    _private: (),
}
impl ListSkills {
    /// Creates a new builder-style object to manufacture [`ListSkillsInput`](crate::input::ListSkillsInput)
    pub fn builder() -> crate::input::list_skills_input::Builder {
        crate::input::list_skills_input::Builder::default()
    }
    /// Creates a new `ListSkills` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSkills {
    type Output =
        std::result::Result<crate::output::ListSkillsOutput, crate::error::ListSkillsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_skills_error(response)
        } else {
            crate::operation_deser::parse_list_skills_response(response)
        }
    }
}

/// Operation shape for `ListSkillsStoreCategories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_skills_store_categories`](crate::client::Client::list_skills_store_categories).
///
/// See [`crate::client::fluent_builders::ListSkillsStoreCategories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSkillsStoreCategories {
    _private: (),
}
impl ListSkillsStoreCategories {
    /// Creates a new builder-style object to manufacture [`ListSkillsStoreCategoriesInput`](crate::input::ListSkillsStoreCategoriesInput)
    pub fn builder() -> crate::input::list_skills_store_categories_input::Builder {
        crate::input::list_skills_store_categories_input::Builder::default()
    }
    /// Creates a new `ListSkillsStoreCategories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSkillsStoreCategories {
    type Output = std::result::Result<
        crate::output::ListSkillsStoreCategoriesOutput,
        crate::error::ListSkillsStoreCategoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_skills_store_categories_error(response)
        } else {
            crate::operation_deser::parse_list_skills_store_categories_response(response)
        }
    }
}

/// Operation shape for `ListSkillsStoreSkillsByCategory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_skills_store_skills_by_category`](crate::client::Client::list_skills_store_skills_by_category).
///
/// See [`crate::client::fluent_builders::ListSkillsStoreSkillsByCategory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSkillsStoreSkillsByCategory {
    _private: (),
}
impl ListSkillsStoreSkillsByCategory {
    /// Creates a new builder-style object to manufacture [`ListSkillsStoreSkillsByCategoryInput`](crate::input::ListSkillsStoreSkillsByCategoryInput)
    pub fn builder() -> crate::input::list_skills_store_skills_by_category_input::Builder {
        crate::input::list_skills_store_skills_by_category_input::Builder::default()
    }
    /// Creates a new `ListSkillsStoreSkillsByCategory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSkillsStoreSkillsByCategory {
    type Output = std::result::Result<
        crate::output::ListSkillsStoreSkillsByCategoryOutput,
        crate::error::ListSkillsStoreSkillsByCategoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_skills_store_skills_by_category_error(response)
        } else {
            crate::operation_deser::parse_list_skills_store_skills_by_category_response(response)
        }
    }
}

/// Operation shape for `ListSmartHomeAppliances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_smart_home_appliances`](crate::client::Client::list_smart_home_appliances).
///
/// See [`crate::client::fluent_builders::ListSmartHomeAppliances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSmartHomeAppliances {
    _private: (),
}
impl ListSmartHomeAppliances {
    /// Creates a new builder-style object to manufacture [`ListSmartHomeAppliancesInput`](crate::input::ListSmartHomeAppliancesInput)
    pub fn builder() -> crate::input::list_smart_home_appliances_input::Builder {
        crate::input::list_smart_home_appliances_input::Builder::default()
    }
    /// Creates a new `ListSmartHomeAppliances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSmartHomeAppliances {
    type Output = std::result::Result<
        crate::output::ListSmartHomeAppliancesOutput,
        crate::error::ListSmartHomeAppliancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_smart_home_appliances_error(response)
        } else {
            crate::operation_deser::parse_list_smart_home_appliances_response(response)
        }
    }
}

/// Operation shape for `ListTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags`](crate::client::Client::list_tags).
///
/// See [`crate::client::fluent_builders::ListTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTags {
    _private: (),
}
impl ListTags {
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
    /// Creates a new `ListTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTags {
    type Output = std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_error(response)
        } else {
            crate::operation_deser::parse_list_tags_response(response)
        }
    }
}

/// Operation shape for `PutConferencePreference`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_conference_preference`](crate::client::Client::put_conference_preference).
///
/// See [`crate::client::fluent_builders::PutConferencePreference`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConferencePreference {
    _private: (),
}
impl PutConferencePreference {
    /// Creates a new builder-style object to manufacture [`PutConferencePreferenceInput`](crate::input::PutConferencePreferenceInput)
    pub fn builder() -> crate::input::put_conference_preference_input::Builder {
        crate::input::put_conference_preference_input::Builder::default()
    }
    /// Creates a new `PutConferencePreference` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConferencePreference {
    type Output = std::result::Result<
        crate::output::PutConferencePreferenceOutput,
        crate::error::PutConferencePreferenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_conference_preference_error(response)
        } else {
            crate::operation_deser::parse_put_conference_preference_response(response)
        }
    }
}

/// Operation shape for `PutInvitationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_invitation_configuration`](crate::client::Client::put_invitation_configuration).
///
/// See [`crate::client::fluent_builders::PutInvitationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutInvitationConfiguration {
    _private: (),
}
impl PutInvitationConfiguration {
    /// Creates a new builder-style object to manufacture [`PutInvitationConfigurationInput`](crate::input::PutInvitationConfigurationInput)
    pub fn builder() -> crate::input::put_invitation_configuration_input::Builder {
        crate::input::put_invitation_configuration_input::Builder::default()
    }
    /// Creates a new `PutInvitationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutInvitationConfiguration {
    type Output = std::result::Result<
        crate::output::PutInvitationConfigurationOutput,
        crate::error::PutInvitationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_invitation_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_invitation_configuration_response(response)
        }
    }
}

/// Operation shape for `PutRoomSkillParameter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_room_skill_parameter`](crate::client::Client::put_room_skill_parameter).
///
/// See [`crate::client::fluent_builders::PutRoomSkillParameter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRoomSkillParameter {
    _private: (),
}
impl PutRoomSkillParameter {
    /// Creates a new builder-style object to manufacture [`PutRoomSkillParameterInput`](crate::input::PutRoomSkillParameterInput)
    pub fn builder() -> crate::input::put_room_skill_parameter_input::Builder {
        crate::input::put_room_skill_parameter_input::Builder::default()
    }
    /// Creates a new `PutRoomSkillParameter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRoomSkillParameter {
    type Output = std::result::Result<
        crate::output::PutRoomSkillParameterOutput,
        crate::error::PutRoomSkillParameterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_room_skill_parameter_error(response)
        } else {
            crate::operation_deser::parse_put_room_skill_parameter_response(response)
        }
    }
}

/// Operation shape for `PutSkillAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_skill_authorization`](crate::client::Client::put_skill_authorization).
///
/// See [`crate::client::fluent_builders::PutSkillAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutSkillAuthorization {
    _private: (),
}
impl PutSkillAuthorization {
    /// Creates a new builder-style object to manufacture [`PutSkillAuthorizationInput`](crate::input::PutSkillAuthorizationInput)
    pub fn builder() -> crate::input::put_skill_authorization_input::Builder {
        crate::input::put_skill_authorization_input::Builder::default()
    }
    /// Creates a new `PutSkillAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutSkillAuthorization {
    type Output = std::result::Result<
        crate::output::PutSkillAuthorizationOutput,
        crate::error::PutSkillAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_skill_authorization_error(response)
        } else {
            crate::operation_deser::parse_put_skill_authorization_response(response)
        }
    }
}

/// Operation shape for `RegisterAVSDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_avs_device`](crate::client::Client::register_avs_device).
///
/// See [`crate::client::fluent_builders::RegisterAVSDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterAVSDevice {
    _private: (),
}
impl RegisterAVSDevice {
    /// Creates a new builder-style object to manufacture [`RegisterAvsDeviceInput`](crate::input::RegisterAvsDeviceInput)
    pub fn builder() -> crate::input::register_avs_device_input::Builder {
        crate::input::register_avs_device_input::Builder::default()
    }
    /// Creates a new `RegisterAVSDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterAVSDevice {
    type Output = std::result::Result<
        crate::output::RegisterAvsDeviceOutput,
        crate::error::RegisterAVSDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_avs_device_error(response)
        } else {
            crate::operation_deser::parse_register_avs_device_response(response)
        }
    }
}

/// Operation shape for `RejectSkill`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_skill`](crate::client::Client::reject_skill).
///
/// See [`crate::client::fluent_builders::RejectSkill`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectSkill {
    _private: (),
}
impl RejectSkill {
    /// Creates a new builder-style object to manufacture [`RejectSkillInput`](crate::input::RejectSkillInput)
    pub fn builder() -> crate::input::reject_skill_input::Builder {
        crate::input::reject_skill_input::Builder::default()
    }
    /// Creates a new `RejectSkill` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectSkill {
    type Output =
        std::result::Result<crate::output::RejectSkillOutput, crate::error::RejectSkillError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_skill_error(response)
        } else {
            crate::operation_deser::parse_reject_skill_response(response)
        }
    }
}

/// Operation shape for `ResolveRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resolve_room`](crate::client::Client::resolve_room).
///
/// See [`crate::client::fluent_builders::ResolveRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResolveRoom {
    _private: (),
}
impl ResolveRoom {
    /// Creates a new builder-style object to manufacture [`ResolveRoomInput`](crate::input::ResolveRoomInput)
    pub fn builder() -> crate::input::resolve_room_input::Builder {
        crate::input::resolve_room_input::Builder::default()
    }
    /// Creates a new `ResolveRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResolveRoom {
    type Output =
        std::result::Result<crate::output::ResolveRoomOutput, crate::error::ResolveRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resolve_room_error(response)
        } else {
            crate::operation_deser::parse_resolve_room_response(response)
        }
    }
}

/// Operation shape for `RevokeInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_invitation`](crate::client::Client::revoke_invitation).
///
/// See [`crate::client::fluent_builders::RevokeInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeInvitation {
    _private: (),
}
impl RevokeInvitation {
    /// Creates a new builder-style object to manufacture [`RevokeInvitationInput`](crate::input::RevokeInvitationInput)
    pub fn builder() -> crate::input::revoke_invitation_input::Builder {
        crate::input::revoke_invitation_input::Builder::default()
    }
    /// Creates a new `RevokeInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeInvitation {
    type Output = std::result::Result<
        crate::output::RevokeInvitationOutput,
        crate::error::RevokeInvitationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_invitation_error(response)
        } else {
            crate::operation_deser::parse_revoke_invitation_response(response)
        }
    }
}

/// Operation shape for `SearchAddressBooks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_address_books`](crate::client::Client::search_address_books).
///
/// See [`crate::client::fluent_builders::SearchAddressBooks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchAddressBooks {
    _private: (),
}
impl SearchAddressBooks {
    /// Creates a new builder-style object to manufacture [`SearchAddressBooksInput`](crate::input::SearchAddressBooksInput)
    pub fn builder() -> crate::input::search_address_books_input::Builder {
        crate::input::search_address_books_input::Builder::default()
    }
    /// Creates a new `SearchAddressBooks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchAddressBooks {
    type Output = std::result::Result<
        crate::output::SearchAddressBooksOutput,
        crate::error::SearchAddressBooksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_address_books_error(response)
        } else {
            crate::operation_deser::parse_search_address_books_response(response)
        }
    }
}

/// Operation shape for `SearchContacts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_contacts`](crate::client::Client::search_contacts).
///
/// See [`crate::client::fluent_builders::SearchContacts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchContacts {
    _private: (),
}
impl SearchContacts {
    /// Creates a new builder-style object to manufacture [`SearchContactsInput`](crate::input::SearchContactsInput)
    pub fn builder() -> crate::input::search_contacts_input::Builder {
        crate::input::search_contacts_input::Builder::default()
    }
    /// Creates a new `SearchContacts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchContacts {
    type Output =
        std::result::Result<crate::output::SearchContactsOutput, crate::error::SearchContactsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_contacts_error(response)
        } else {
            crate::operation_deser::parse_search_contacts_response(response)
        }
    }
}

/// Operation shape for `SearchDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_devices`](crate::client::Client::search_devices).
///
/// See [`crate::client::fluent_builders::SearchDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchDevices {
    _private: (),
}
impl SearchDevices {
    /// Creates a new builder-style object to manufacture [`SearchDevicesInput`](crate::input::SearchDevicesInput)
    pub fn builder() -> crate::input::search_devices_input::Builder {
        crate::input::search_devices_input::Builder::default()
    }
    /// Creates a new `SearchDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchDevices {
    type Output =
        std::result::Result<crate::output::SearchDevicesOutput, crate::error::SearchDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_devices_error(response)
        } else {
            crate::operation_deser::parse_search_devices_response(response)
        }
    }
}

/// Operation shape for `SearchNetworkProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_network_profiles`](crate::client::Client::search_network_profiles).
///
/// See [`crate::client::fluent_builders::SearchNetworkProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchNetworkProfiles {
    _private: (),
}
impl SearchNetworkProfiles {
    /// Creates a new builder-style object to manufacture [`SearchNetworkProfilesInput`](crate::input::SearchNetworkProfilesInput)
    pub fn builder() -> crate::input::search_network_profiles_input::Builder {
        crate::input::search_network_profiles_input::Builder::default()
    }
    /// Creates a new `SearchNetworkProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchNetworkProfiles {
    type Output = std::result::Result<
        crate::output::SearchNetworkProfilesOutput,
        crate::error::SearchNetworkProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_network_profiles_error(response)
        } else {
            crate::operation_deser::parse_search_network_profiles_response(response)
        }
    }
}

/// Operation shape for `SearchProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_profiles`](crate::client::Client::search_profiles).
///
/// See [`crate::client::fluent_builders::SearchProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchProfiles {
    _private: (),
}
impl SearchProfiles {
    /// Creates a new builder-style object to manufacture [`SearchProfilesInput`](crate::input::SearchProfilesInput)
    pub fn builder() -> crate::input::search_profiles_input::Builder {
        crate::input::search_profiles_input::Builder::default()
    }
    /// Creates a new `SearchProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchProfiles {
    type Output =
        std::result::Result<crate::output::SearchProfilesOutput, crate::error::SearchProfilesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_profiles_error(response)
        } else {
            crate::operation_deser::parse_search_profiles_response(response)
        }
    }
}

/// Operation shape for `SearchRooms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_rooms`](crate::client::Client::search_rooms).
///
/// See [`crate::client::fluent_builders::SearchRooms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchRooms {
    _private: (),
}
impl SearchRooms {
    /// Creates a new builder-style object to manufacture [`SearchRoomsInput`](crate::input::SearchRoomsInput)
    pub fn builder() -> crate::input::search_rooms_input::Builder {
        crate::input::search_rooms_input::Builder::default()
    }
    /// Creates a new `SearchRooms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchRooms {
    type Output =
        std::result::Result<crate::output::SearchRoomsOutput, crate::error::SearchRoomsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_rooms_error(response)
        } else {
            crate::operation_deser::parse_search_rooms_response(response)
        }
    }
}

/// Operation shape for `SearchSkillGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_skill_groups`](crate::client::Client::search_skill_groups).
///
/// See [`crate::client::fluent_builders::SearchSkillGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchSkillGroups {
    _private: (),
}
impl SearchSkillGroups {
    /// Creates a new builder-style object to manufacture [`SearchSkillGroupsInput`](crate::input::SearchSkillGroupsInput)
    pub fn builder() -> crate::input::search_skill_groups_input::Builder {
        crate::input::search_skill_groups_input::Builder::default()
    }
    /// Creates a new `SearchSkillGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchSkillGroups {
    type Output = std::result::Result<
        crate::output::SearchSkillGroupsOutput,
        crate::error::SearchSkillGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_skill_groups_error(response)
        } else {
            crate::operation_deser::parse_search_skill_groups_response(response)
        }
    }
}

/// Operation shape for `SearchUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_users`](crate::client::Client::search_users).
///
/// See [`crate::client::fluent_builders::SearchUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchUsers {
    _private: (),
}
impl SearchUsers {
    /// Creates a new builder-style object to manufacture [`SearchUsersInput`](crate::input::SearchUsersInput)
    pub fn builder() -> crate::input::search_users_input::Builder {
        crate::input::search_users_input::Builder::default()
    }
    /// Creates a new `SearchUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchUsers {
    type Output =
        std::result::Result<crate::output::SearchUsersOutput, crate::error::SearchUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_users_error(response)
        } else {
            crate::operation_deser::parse_search_users_response(response)
        }
    }
}

/// Operation shape for `SendAnnouncement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_announcement`](crate::client::Client::send_announcement).
///
/// See [`crate::client::fluent_builders::SendAnnouncement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendAnnouncement {
    _private: (),
}
impl SendAnnouncement {
    /// Creates a new builder-style object to manufacture [`SendAnnouncementInput`](crate::input::SendAnnouncementInput)
    pub fn builder() -> crate::input::send_announcement_input::Builder {
        crate::input::send_announcement_input::Builder::default()
    }
    /// Creates a new `SendAnnouncement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendAnnouncement {
    type Output = std::result::Result<
        crate::output::SendAnnouncementOutput,
        crate::error::SendAnnouncementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_announcement_error(response)
        } else {
            crate::operation_deser::parse_send_announcement_response(response)
        }
    }
}

/// Operation shape for `SendInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_invitation`](crate::client::Client::send_invitation).
///
/// See [`crate::client::fluent_builders::SendInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendInvitation {
    _private: (),
}
impl SendInvitation {
    /// Creates a new builder-style object to manufacture [`SendInvitationInput`](crate::input::SendInvitationInput)
    pub fn builder() -> crate::input::send_invitation_input::Builder {
        crate::input::send_invitation_input::Builder::default()
    }
    /// Creates a new `SendInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendInvitation {
    type Output =
        std::result::Result<crate::output::SendInvitationOutput, crate::error::SendInvitationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_invitation_error(response)
        } else {
            crate::operation_deser::parse_send_invitation_response(response)
        }
    }
}

/// Operation shape for `StartDeviceSync`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_device_sync`](crate::client::Client::start_device_sync).
///
/// See [`crate::client::fluent_builders::StartDeviceSync`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDeviceSync {
    _private: (),
}
impl StartDeviceSync {
    /// Creates a new builder-style object to manufacture [`StartDeviceSyncInput`](crate::input::StartDeviceSyncInput)
    pub fn builder() -> crate::input::start_device_sync_input::Builder {
        crate::input::start_device_sync_input::Builder::default()
    }
    /// Creates a new `StartDeviceSync` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDeviceSync {
    type Output = std::result::Result<
        crate::output::StartDeviceSyncOutput,
        crate::error::StartDeviceSyncError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_device_sync_error(response)
        } else {
            crate::operation_deser::parse_start_device_sync_response(response)
        }
    }
}

/// Operation shape for `StartSmartHomeApplianceDiscovery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_smart_home_appliance_discovery`](crate::client::Client::start_smart_home_appliance_discovery).
///
/// See [`crate::client::fluent_builders::StartSmartHomeApplianceDiscovery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSmartHomeApplianceDiscovery {
    _private: (),
}
impl StartSmartHomeApplianceDiscovery {
    /// Creates a new builder-style object to manufacture [`StartSmartHomeApplianceDiscoveryInput`](crate::input::StartSmartHomeApplianceDiscoveryInput)
    pub fn builder() -> crate::input::start_smart_home_appliance_discovery_input::Builder {
        crate::input::start_smart_home_appliance_discovery_input::Builder::default()
    }
    /// Creates a new `StartSmartHomeApplianceDiscovery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSmartHomeApplianceDiscovery {
    type Output = std::result::Result<
        crate::output::StartSmartHomeApplianceDiscoveryOutput,
        crate::error::StartSmartHomeApplianceDiscoveryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_smart_home_appliance_discovery_error(response)
        } else {
            crate::operation_deser::parse_start_smart_home_appliance_discovery_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAddressBook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_address_book`](crate::client::Client::update_address_book).
///
/// See [`crate::client::fluent_builders::UpdateAddressBook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAddressBook {
    _private: (),
}
impl UpdateAddressBook {
    /// Creates a new builder-style object to manufacture [`UpdateAddressBookInput`](crate::input::UpdateAddressBookInput)
    pub fn builder() -> crate::input::update_address_book_input::Builder {
        crate::input::update_address_book_input::Builder::default()
    }
    /// Creates a new `UpdateAddressBook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAddressBook {
    type Output = std::result::Result<
        crate::output::UpdateAddressBookOutput,
        crate::error::UpdateAddressBookError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_address_book_error(response)
        } else {
            crate::operation_deser::parse_update_address_book_response(response)
        }
    }
}

/// Operation shape for `UpdateBusinessReportSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_business_report_schedule`](crate::client::Client::update_business_report_schedule).
///
/// See [`crate::client::fluent_builders::UpdateBusinessReportSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBusinessReportSchedule {
    _private: (),
}
impl UpdateBusinessReportSchedule {
    /// Creates a new builder-style object to manufacture [`UpdateBusinessReportScheduleInput`](crate::input::UpdateBusinessReportScheduleInput)
    pub fn builder() -> crate::input::update_business_report_schedule_input::Builder {
        crate::input::update_business_report_schedule_input::Builder::default()
    }
    /// Creates a new `UpdateBusinessReportSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBusinessReportSchedule {
    type Output = std::result::Result<
        crate::output::UpdateBusinessReportScheduleOutput,
        crate::error::UpdateBusinessReportScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_business_report_schedule_error(response)
        } else {
            crate::operation_deser::parse_update_business_report_schedule_response(response)
        }
    }
}

/// Operation shape for `UpdateConferenceProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_conference_provider`](crate::client::Client::update_conference_provider).
///
/// See [`crate::client::fluent_builders::UpdateConferenceProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConferenceProvider {
    _private: (),
}
impl UpdateConferenceProvider {
    /// Creates a new builder-style object to manufacture [`UpdateConferenceProviderInput`](crate::input::UpdateConferenceProviderInput)
    pub fn builder() -> crate::input::update_conference_provider_input::Builder {
        crate::input::update_conference_provider_input::Builder::default()
    }
    /// Creates a new `UpdateConferenceProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConferenceProvider {
    type Output = std::result::Result<
        crate::output::UpdateConferenceProviderOutput,
        crate::error::UpdateConferenceProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_conference_provider_error(response)
        } else {
            crate::operation_deser::parse_update_conference_provider_response(response)
        }
    }
}

/// Operation shape for `UpdateContact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_contact`](crate::client::Client::update_contact).
///
/// See [`crate::client::fluent_builders::UpdateContact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContact {
    _private: (),
}
impl UpdateContact {
    /// Creates a new builder-style object to manufacture [`UpdateContactInput`](crate::input::UpdateContactInput)
    pub fn builder() -> crate::input::update_contact_input::Builder {
        crate::input::update_contact_input::Builder::default()
    }
    /// Creates a new `UpdateContact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContact {
    type Output =
        std::result::Result<crate::output::UpdateContactOutput, crate::error::UpdateContactError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_contact_error(response)
        } else {
            crate::operation_deser::parse_update_contact_response(response)
        }
    }
}

/// Operation shape for `UpdateDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device`](crate::client::Client::update_device).
///
/// See [`crate::client::fluent_builders::UpdateDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDevice {
    _private: (),
}
impl UpdateDevice {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
    pub fn builder() -> crate::input::update_device_input::Builder {
        crate::input::update_device_input::Builder::default()
    }
    /// Creates a new `UpdateDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDevice {
    type Output =
        std::result::Result<crate::output::UpdateDeviceOutput, crate::error::UpdateDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_error(response)
        } else {
            crate::operation_deser::parse_update_device_response(response)
        }
    }
}

/// Operation shape for `UpdateGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_gateway`](crate::client::Client::update_gateway).
///
/// See [`crate::client::fluent_builders::UpdateGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGateway {
    _private: (),
}
impl UpdateGateway {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
    pub fn builder() -> crate::input::update_gateway_input::Builder {
        crate::input::update_gateway_input::Builder::default()
    }
    /// Creates a new `UpdateGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGateway {
    type Output =
        std::result::Result<crate::output::UpdateGatewayOutput, crate::error::UpdateGatewayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_gateway_error(response)
        } else {
            crate::operation_deser::parse_update_gateway_response(response)
        }
    }
}

/// Operation shape for `UpdateGatewayGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_gateway_group`](crate::client::Client::update_gateway_group).
///
/// See [`crate::client::fluent_builders::UpdateGatewayGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGatewayGroup {
    _private: (),
}
impl UpdateGatewayGroup {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayGroupInput`](crate::input::UpdateGatewayGroupInput)
    pub fn builder() -> crate::input::update_gateway_group_input::Builder {
        crate::input::update_gateway_group_input::Builder::default()
    }
    /// Creates a new `UpdateGatewayGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGatewayGroup {
    type Output = std::result::Result<
        crate::output::UpdateGatewayGroupOutput,
        crate::error::UpdateGatewayGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_gateway_group_error(response)
        } else {
            crate::operation_deser::parse_update_gateway_group_response(response)
        }
    }
}

/// Operation shape for `UpdateNetworkProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_network_profile`](crate::client::Client::update_network_profile).
///
/// See [`crate::client::fluent_builders::UpdateNetworkProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNetworkProfile {
    _private: (),
}
impl UpdateNetworkProfile {
    /// Creates a new builder-style object to manufacture [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
    pub fn builder() -> crate::input::update_network_profile_input::Builder {
        crate::input::update_network_profile_input::Builder::default()
    }
    /// Creates a new `UpdateNetworkProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNetworkProfile {
    type Output = std::result::Result<
        crate::output::UpdateNetworkProfileOutput,
        crate::error::UpdateNetworkProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_network_profile_error(response)
        } else {
            crate::operation_deser::parse_update_network_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_profile`](crate::client::Client::update_profile).
///
/// See [`crate::client::fluent_builders::UpdateProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProfile {
    _private: (),
}
impl UpdateProfile {
    /// Creates a new builder-style object to manufacture [`UpdateProfileInput`](crate::input::UpdateProfileInput)
    pub fn builder() -> crate::input::update_profile_input::Builder {
        crate::input::update_profile_input::Builder::default()
    }
    /// Creates a new `UpdateProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProfile {
    type Output =
        std::result::Result<crate::output::UpdateProfileOutput, crate::error::UpdateProfileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_profile_error(response)
        } else {
            crate::operation_deser::parse_update_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_room`](crate::client::Client::update_room).
///
/// See [`crate::client::fluent_builders::UpdateRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoom {
    _private: (),
}
impl UpdateRoom {
    /// Creates a new builder-style object to manufacture [`UpdateRoomInput`](crate::input::UpdateRoomInput)
    pub fn builder() -> crate::input::update_room_input::Builder {
        crate::input::update_room_input::Builder::default()
    }
    /// Creates a new `UpdateRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoom {
    type Output =
        std::result::Result<crate::output::UpdateRoomOutput, crate::error::UpdateRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_room_error(response)
        } else {
            crate::operation_deser::parse_update_room_response(response)
        }
    }
}

/// Operation shape for `UpdateSkillGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_skill_group`](crate::client::Client::update_skill_group).
///
/// See [`crate::client::fluent_builders::UpdateSkillGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSkillGroup {
    _private: (),
}
impl UpdateSkillGroup {
    /// Creates a new builder-style object to manufacture [`UpdateSkillGroupInput`](crate::input::UpdateSkillGroupInput)
    pub fn builder() -> crate::input::update_skill_group_input::Builder {
        crate::input::update_skill_group_input::Builder::default()
    }
    /// Creates a new `UpdateSkillGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSkillGroup {
    type Output = std::result::Result<
        crate::output::UpdateSkillGroupOutput,
        crate::error::UpdateSkillGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_skill_group_error(response)
        } else {
            crate::operation_deser::parse_update_skill_group_response(response)
        }
    }
}
