// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Updates meeting room settings of a room profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMeetingRoomConfiguration {
    /// <p>Whether room utilization metrics are enabled or not.</p>
    pub room_utilization_metrics_enabled: std::option::Option<bool>,
    /// <p>Settings for the end of meeting reminder feature that are applied to a room profile. The
    /// end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>
    pub end_of_meeting_reminder: std::option::Option<crate::model::UpdateEndOfMeetingReminder>,
    /// <p>Settings to automatically book an available room available for a configured duration
    /// when joining a meeting with Alexa.</p>
    pub instant_booking: std::option::Option<crate::model::UpdateInstantBooking>,
    /// <p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.” </p>
    pub require_check_in: std::option::Option<crate::model::UpdateRequireCheckIn>,
}
impl std::fmt::Debug for UpdateMeetingRoomConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMeetingRoomConfiguration");
        formatter.field(
            "room_utilization_metrics_enabled",
            &self.room_utilization_metrics_enabled,
        );
        formatter.field("end_of_meeting_reminder", &self.end_of_meeting_reminder);
        formatter.field("instant_booking", &self.instant_booking);
        formatter.field("require_check_in", &self.require_check_in);
        formatter.finish()
    }
}
/// See [`UpdateMeetingRoomConfiguration`](crate::model::UpdateMeetingRoomConfiguration)
pub mod update_meeting_room_configuration {
    /// A builder for [`UpdateMeetingRoomConfiguration`](crate::model::UpdateMeetingRoomConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_utilization_metrics_enabled: std::option::Option<bool>,
        pub(crate) end_of_meeting_reminder:
            std::option::Option<crate::model::UpdateEndOfMeetingReminder>,
        pub(crate) instant_booking: std::option::Option<crate::model::UpdateInstantBooking>,
        pub(crate) require_check_in: std::option::Option<crate::model::UpdateRequireCheckIn>,
    }
    impl Builder {
        /// <p>Whether room utilization metrics are enabled or not.</p>
        pub fn room_utilization_metrics_enabled(mut self, input: bool) -> Self {
            self.room_utilization_metrics_enabled = Some(input);
            self
        }
        /// <p>Whether room utilization metrics are enabled or not.</p>
        pub fn set_room_utilization_metrics_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.room_utilization_metrics_enabled = input;
            self
        }
        /// <p>Settings for the end of meeting reminder feature that are applied to a room profile. The
        /// end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>
        pub fn end_of_meeting_reminder(
            mut self,
            input: crate::model::UpdateEndOfMeetingReminder,
        ) -> Self {
            self.end_of_meeting_reminder = Some(input);
            self
        }
        /// <p>Settings for the end of meeting reminder feature that are applied to a room profile. The
        /// end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>
        pub fn set_end_of_meeting_reminder(
            mut self,
            input: std::option::Option<crate::model::UpdateEndOfMeetingReminder>,
        ) -> Self {
            self.end_of_meeting_reminder = input;
            self
        }
        /// <p>Settings to automatically book an available room available for a configured duration
        /// when joining a meeting with Alexa.</p>
        pub fn instant_booking(mut self, input: crate::model::UpdateInstantBooking) -> Self {
            self.instant_booking = Some(input);
            self
        }
        /// <p>Settings to automatically book an available room available for a configured duration
        /// when joining a meeting with Alexa.</p>
        pub fn set_instant_booking(
            mut self,
            input: std::option::Option<crate::model::UpdateInstantBooking>,
        ) -> Self {
            self.instant_booking = input;
            self
        }
        /// <p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.” </p>
        pub fn require_check_in(mut self, input: crate::model::UpdateRequireCheckIn) -> Self {
            self.require_check_in = Some(input);
            self
        }
        /// <p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.” </p>
        pub fn set_require_check_in(
            mut self,
            input: std::option::Option<crate::model::UpdateRequireCheckIn>,
        ) -> Self {
            self.require_check_in = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMeetingRoomConfiguration`](crate::model::UpdateMeetingRoomConfiguration)
        pub fn build(self) -> crate::model::UpdateMeetingRoomConfiguration {
            crate::model::UpdateMeetingRoomConfiguration {
                room_utilization_metrics_enabled: self.room_utilization_metrics_enabled,
                end_of_meeting_reminder: self.end_of_meeting_reminder,
                instant_booking: self.instant_booking,
                require_check_in: self.require_check_in,
            }
        }
    }
}
impl UpdateMeetingRoomConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateMeetingRoomConfiguration`](crate::model::UpdateMeetingRoomConfiguration)
    pub fn builder() -> crate::model::update_meeting_room_configuration::Builder {
        crate::model::update_meeting_room_configuration::Builder::default()
    }
}

/// <p>Updates settings for the require check in feature that are applied to a room profile. Require check in allows a meeting room’s Alexa or AVS device to prompt the user to check in; otherwise, the room will be released. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRequireCheckIn {
    /// <p>Duration between 5 and 20 minutes to determine when to release the room if it's not checked into. </p>
    pub release_after_minutes: std::option::Option<i32>,
    /// <p>Whether require check in is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for UpdateRequireCheckIn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRequireCheckIn");
        formatter.field("release_after_minutes", &self.release_after_minutes);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`UpdateRequireCheckIn`](crate::model::UpdateRequireCheckIn)
pub mod update_require_check_in {
    /// A builder for [`UpdateRequireCheckIn`](crate::model::UpdateRequireCheckIn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) release_after_minutes: std::option::Option<i32>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Duration between 5 and 20 minutes to determine when to release the room if it's not checked into. </p>
        pub fn release_after_minutes(mut self, input: i32) -> Self {
            self.release_after_minutes = Some(input);
            self
        }
        /// <p>Duration between 5 and 20 minutes to determine when to release the room if it's not checked into. </p>
        pub fn set_release_after_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.release_after_minutes = input;
            self
        }
        /// <p>Whether require check in is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether require check in is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRequireCheckIn`](crate::model::UpdateRequireCheckIn)
        pub fn build(self) -> crate::model::UpdateRequireCheckIn {
            crate::model::UpdateRequireCheckIn {
                release_after_minutes: self.release_after_minutes,
                enabled: self.enabled,
            }
        }
    }
}
impl UpdateRequireCheckIn {
    /// Creates a new builder-style object to manufacture [`UpdateRequireCheckIn`](crate::model::UpdateRequireCheckIn)
    pub fn builder() -> crate::model::update_require_check_in::Builder {
        crate::model::update_require_check_in::Builder::default()
    }
}

/// <p>Updates settings for the instant booking feature that are applied to a room profile. If
/// instant booking is enabled, Alexa automatically reserves a room if it is free when a user
/// joins a meeting with Alexa.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInstantBooking {
    /// <p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book
    /// an available room when a meeting is started with Alexa.</p>
    pub duration_in_minutes: std::option::Option<i32>,
    /// <p>Whether instant booking is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for UpdateInstantBooking {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInstantBooking");
        formatter.field("duration_in_minutes", &self.duration_in_minutes);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`UpdateInstantBooking`](crate::model::UpdateInstantBooking)
pub mod update_instant_booking {
    /// A builder for [`UpdateInstantBooking`](crate::model::UpdateInstantBooking)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_minutes: std::option::Option<i32>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book
        /// an available room when a meeting is started with Alexa.</p>
        pub fn duration_in_minutes(mut self, input: i32) -> Self {
            self.duration_in_minutes = Some(input);
            self
        }
        /// <p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book
        /// an available room when a meeting is started with Alexa.</p>
        pub fn set_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_minutes = input;
            self
        }
        /// <p>Whether instant booking is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether instant booking is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInstantBooking`](crate::model::UpdateInstantBooking)
        pub fn build(self) -> crate::model::UpdateInstantBooking {
            crate::model::UpdateInstantBooking {
                duration_in_minutes: self.duration_in_minutes,
                enabled: self.enabled,
            }
        }
    }
}
impl UpdateInstantBooking {
    /// Creates a new builder-style object to manufacture [`UpdateInstantBooking`](crate::model::UpdateInstantBooking)
    pub fn builder() -> crate::model::update_instant_booking::Builder {
        crate::model::update_instant_booking::Builder::default()
    }
}

/// <p>Settings for the end of meeting reminder feature that are applied to a room profile. The
/// end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEndOfMeetingReminder {
    /// <p>Updates settings for the end of meeting reminder feature that are applied to a room
    /// profile. The end of meeting reminder enables Alexa to remind users when a meeting is
    /// ending. </p>
    pub reminder_at_minutes: std::option::Option<std::vec::Vec<i32>>,
    /// <p>The type of sound that users hear during the end of meeting reminder. </p>
    pub reminder_type: std::option::Option<crate::model::EndOfMeetingReminderType>,
    /// <p>Whether an end of meeting reminder is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for UpdateEndOfMeetingReminder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEndOfMeetingReminder");
        formatter.field("reminder_at_minutes", &self.reminder_at_minutes);
        formatter.field("reminder_type", &self.reminder_type);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`UpdateEndOfMeetingReminder`](crate::model::UpdateEndOfMeetingReminder)
pub mod update_end_of_meeting_reminder {
    /// A builder for [`UpdateEndOfMeetingReminder`](crate::model::UpdateEndOfMeetingReminder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reminder_at_minutes: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) reminder_type: std::option::Option<crate::model::EndOfMeetingReminderType>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `reminder_at_minutes`.
        ///
        /// To override the contents of this collection use [`set_reminder_at_minutes`](Self::set_reminder_at_minutes).
        ///
        /// <p>Updates settings for the end of meeting reminder feature that are applied to a room
        /// profile. The end of meeting reminder enables Alexa to remind users when a meeting is
        /// ending. </p>
        pub fn reminder_at_minutes(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.reminder_at_minutes.unwrap_or_default();
            v.push(input.into());
            self.reminder_at_minutes = Some(v);
            self
        }
        /// <p>Updates settings for the end of meeting reminder feature that are applied to a room
        /// profile. The end of meeting reminder enables Alexa to remind users when a meeting is
        /// ending. </p>
        pub fn set_reminder_at_minutes(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.reminder_at_minutes = input;
            self
        }
        /// <p>The type of sound that users hear during the end of meeting reminder. </p>
        pub fn reminder_type(mut self, input: crate::model::EndOfMeetingReminderType) -> Self {
            self.reminder_type = Some(input);
            self
        }
        /// <p>The type of sound that users hear during the end of meeting reminder. </p>
        pub fn set_reminder_type(
            mut self,
            input: std::option::Option<crate::model::EndOfMeetingReminderType>,
        ) -> Self {
            self.reminder_type = input;
            self
        }
        /// <p>Whether an end of meeting reminder is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether an end of meeting reminder is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEndOfMeetingReminder`](crate::model::UpdateEndOfMeetingReminder)
        pub fn build(self) -> crate::model::UpdateEndOfMeetingReminder {
            crate::model::UpdateEndOfMeetingReminder {
                reminder_at_minutes: self.reminder_at_minutes,
                reminder_type: self.reminder_type,
                enabled: self.enabled,
            }
        }
    }
}
impl UpdateEndOfMeetingReminder {
    /// Creates a new builder-style object to manufacture [`UpdateEndOfMeetingReminder`](crate::model::UpdateEndOfMeetingReminder)
    pub fn builder() -> crate::model::update_end_of_meeting_reminder::Builder {
        crate::model::update_end_of_meeting_reminder::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndOfMeetingReminderType {
    #[allow(missing_docs)] // documentation missing in model
    AnnouncementTimeCheck,
    #[allow(missing_docs)] // documentation missing in model
    AnnouncementVariableTimeLeft,
    #[allow(missing_docs)] // documentation missing in model
    Chime,
    #[allow(missing_docs)] // documentation missing in model
    Knock,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndOfMeetingReminderType {
    fn from(s: &str) -> Self {
        match s {
            "ANNOUNCEMENT_TIME_CHECK" => EndOfMeetingReminderType::AnnouncementTimeCheck,
            "ANNOUNCEMENT_VARIABLE_TIME_LEFT" => {
                EndOfMeetingReminderType::AnnouncementVariableTimeLeft
            }
            "CHIME" => EndOfMeetingReminderType::Chime,
            "KNOCK" => EndOfMeetingReminderType::Knock,
            other => EndOfMeetingReminderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndOfMeetingReminderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndOfMeetingReminderType::from(s))
    }
}
impl EndOfMeetingReminderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndOfMeetingReminderType::AnnouncementTimeCheck => "ANNOUNCEMENT_TIME_CHECK",
            EndOfMeetingReminderType::AnnouncementVariableTimeLeft => {
                "ANNOUNCEMENT_VARIABLE_TIME_LEFT"
            }
            EndOfMeetingReminderType::Chime => "CHIME",
            EndOfMeetingReminderType::Knock => "KNOCK",
            EndOfMeetingReminderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANNOUNCEMENT_TIME_CHECK",
            "ANNOUNCEMENT_VARIABLE_TIME_LEFT",
            "CHIME",
            "KNOCK",
        ]
    }
}
impl AsRef<str> for EndOfMeetingReminderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WakeWord {
    #[allow(missing_docs)] // documentation missing in model
    Alexa,
    #[allow(missing_docs)] // documentation missing in model
    Amazon,
    #[allow(missing_docs)] // documentation missing in model
    Computer,
    #[allow(missing_docs)] // documentation missing in model
    Echo,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WakeWord {
    fn from(s: &str) -> Self {
        match s {
            "ALEXA" => WakeWord::Alexa,
            "AMAZON" => WakeWord::Amazon,
            "COMPUTER" => WakeWord::Computer,
            "ECHO" => WakeWord::Echo,
            other => WakeWord::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WakeWord {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WakeWord::from(s))
    }
}
impl WakeWord {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WakeWord::Alexa => "ALEXA",
            WakeWord::Amazon => "AMAZON",
            WakeWord::Computer => "COMPUTER",
            WakeWord::Echo => "ECHO",
            WakeWord::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALEXA", "AMAZON", "COMPUTER", "ECHO"]
    }
}
impl AsRef<str> for WakeWord {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TemperatureUnit {
    #[allow(missing_docs)] // documentation missing in model
    Celsius,
    #[allow(missing_docs)] // documentation missing in model
    Fahrenheit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TemperatureUnit {
    fn from(s: &str) -> Self {
        match s {
            "CELSIUS" => TemperatureUnit::Celsius,
            "FAHRENHEIT" => TemperatureUnit::Fahrenheit,
            other => TemperatureUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TemperatureUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TemperatureUnit::from(s))
    }
}
impl TemperatureUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TemperatureUnit::Celsius => "CELSIUS",
            TemperatureUnit::Fahrenheit => "FAHRENHEIT",
            TemperatureUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CELSIUS", "FAHRENHEIT"]
    }
}
impl AsRef<str> for TemperatureUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DistanceUnit {
    #[allow(missing_docs)] // documentation missing in model
    Imperial,
    #[allow(missing_docs)] // documentation missing in model
    Metric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DistanceUnit {
    fn from(s: &str) -> Self {
        match s {
            "IMPERIAL" => DistanceUnit::Imperial,
            "METRIC" => DistanceUnit::Metric,
            other => DistanceUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DistanceUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DistanceUnit::from(s))
    }
}
impl DistanceUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DistanceUnit::Imperial => "IMPERIAL",
            DistanceUnit::Metric => "METRIC",
            DistanceUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IMPERIAL", "METRIC"]
    }
}
impl AsRef<str> for DistanceUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The SIP address for the contact containing the URI and SIP address type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SipAddress {
    /// <p>The URI for the SIP address.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The type of the SIP address.</p>
    pub r#type: std::option::Option<crate::model::SipType>,
}
impl std::fmt::Debug for SipAddress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SipAddress");
        formatter.field("uri", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`SipAddress`](crate::model::SipAddress)
pub mod sip_address {
    /// A builder for [`SipAddress`](crate::model::SipAddress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::SipType>,
    }
    impl Builder {
        /// <p>The URI for the SIP address.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The URI for the SIP address.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The type of the SIP address.</p>
        pub fn r#type(mut self, input: crate::model::SipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the SIP address.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::SipType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`SipAddress`](crate::model::SipAddress)
        pub fn build(self) -> crate::model::SipAddress {
            crate::model::SipAddress {
                uri: self.uri,
                r#type: self.r#type,
            }
        }
    }
}
impl SipAddress {
    /// Creates a new builder-style object to manufacture [`SipAddress`](crate::model::SipAddress)
    pub fn builder() -> crate::model::sip_address::Builder {
        crate::model::sip_address::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SipType {
    #[allow(missing_docs)] // documentation missing in model
    Work,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SipType {
    fn from(s: &str) -> Self {
        match s {
            "WORK" => SipType::Work,
            other => SipType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SipType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SipType::from(s))
    }
}
impl SipType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SipType::Work => "WORK",
            SipType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["WORK"]
    }
}
impl AsRef<str> for SipType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The phone number for the contact containing the raw number and phone number type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumber {
    /// <p>The raw value of the phone number.</p>
    pub number: std::option::Option<std::string::String>,
    /// <p>The type of the phone number.</p>
    pub r#type: std::option::Option<crate::model::PhoneNumberType>,
}
impl std::fmt::Debug for PhoneNumber {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumber");
        formatter.field("number", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`PhoneNumber`](crate::model::PhoneNumber)
pub mod phone_number {
    /// A builder for [`PhoneNumber`](crate::model::PhoneNumber)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PhoneNumberType>,
    }
    impl Builder {
        /// <p>The raw value of the phone number.</p>
        pub fn number(mut self, input: impl Into<std::string::String>) -> Self {
            self.number = Some(input.into());
            self
        }
        /// <p>The raw value of the phone number.</p>
        pub fn set_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.number = input;
            self
        }
        /// <p>The type of the phone number.</p>
        pub fn r#type(mut self, input: crate::model::PhoneNumberType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the phone number.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumber`](crate::model::PhoneNumber)
        pub fn build(self) -> crate::model::PhoneNumber {
            crate::model::PhoneNumber {
                number: self.number,
                r#type: self.r#type,
            }
        }
    }
}
impl PhoneNumber {
    /// Creates a new builder-style object to manufacture [`PhoneNumber`](crate::model::PhoneNumber)
    pub fn builder() -> crate::model::phone_number::Builder {
        crate::model::phone_number::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneNumberType {
    #[allow(missing_docs)] // documentation missing in model
    Home,
    #[allow(missing_docs)] // documentation missing in model
    Mobile,
    #[allow(missing_docs)] // documentation missing in model
    Work,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneNumberType {
    fn from(s: &str) -> Self {
        match s {
            "HOME" => PhoneNumberType::Home,
            "MOBILE" => PhoneNumberType::Mobile,
            "WORK" => PhoneNumberType::Work,
            other => PhoneNumberType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneNumberType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneNumberType::from(s))
    }
}
impl PhoneNumberType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneNumberType::Home => "HOME",
            PhoneNumberType::Mobile => "MOBILE",
            PhoneNumberType::Work => "WORK",
            PhoneNumberType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HOME", "MOBILE", "WORK"]
    }
}
impl AsRef<str> for PhoneNumberType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The values that indicate whether a pin is always required (YES), never required (NO),
/// or OPTIONAL.</p>
/// <ul>
/// <li>
/// <p>If YES, Alexa will always ask for a meeting pin.</p>
/// </li>
/// <li>
/// <p>If NO, Alexa will never ask for a meeting pin.</p>
/// </li>
/// <li>
/// <p>If OPTIONAL, Alexa will ask if you have a meeting pin and if the customer responds
/// with yes, it will ask for the meeting pin.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeetingSetting {
    /// <p>The values that indicate whether the pin is always required.</p>
    pub require_pin: std::option::Option<crate::model::RequirePin>,
}
impl std::fmt::Debug for MeetingSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeetingSetting");
        formatter.field("require_pin", &self.require_pin);
        formatter.finish()
    }
}
/// See [`MeetingSetting`](crate::model::MeetingSetting)
pub mod meeting_setting {
    /// A builder for [`MeetingSetting`](crate::model::MeetingSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) require_pin: std::option::Option<crate::model::RequirePin>,
    }
    impl Builder {
        /// <p>The values that indicate whether the pin is always required.</p>
        pub fn require_pin(mut self, input: crate::model::RequirePin) -> Self {
            self.require_pin = Some(input);
            self
        }
        /// <p>The values that indicate whether the pin is always required.</p>
        pub fn set_require_pin(
            mut self,
            input: std::option::Option<crate::model::RequirePin>,
        ) -> Self {
            self.require_pin = input;
            self
        }
        /// Consumes the builder and constructs a [`MeetingSetting`](crate::model::MeetingSetting)
        pub fn build(self) -> crate::model::MeetingSetting {
            crate::model::MeetingSetting {
                require_pin: self.require_pin,
            }
        }
    }
}
impl MeetingSetting {
    /// Creates a new builder-style object to manufacture [`MeetingSetting`](crate::model::MeetingSetting)
    pub fn builder() -> crate::model::meeting_setting::Builder {
        crate::model::meeting_setting::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequirePin {
    #[allow(missing_docs)] // documentation missing in model
    No,
    #[allow(missing_docs)] // documentation missing in model
    Optional,
    #[allow(missing_docs)] // documentation missing in model
    Yes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequirePin {
    fn from(s: &str) -> Self {
        match s {
            "NO" => RequirePin::No,
            "OPTIONAL" => RequirePin::Optional,
            "YES" => RequirePin::Yes,
            other => RequirePin::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequirePin {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequirePin::from(s))
    }
}
impl RequirePin {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequirePin::No => "NO",
            RequirePin::Optional => "OPTIONAL",
            RequirePin::Yes => "YES",
            RequirePin::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO", "OPTIONAL", "YES"]
    }
}
impl AsRef<str> for RequirePin {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The information for public switched telephone network (PSTN) conferencing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PstnDialIn {
    /// <p>The zip code.</p>
    pub country_code: std::option::Option<std::string::String>,
    /// <p>The phone number to call to join the conference.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.</p>
    pub one_click_id_delay: std::option::Option<std::string::String>,
    /// <p>The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.</p>
    pub one_click_pin_delay: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PstnDialIn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PstnDialIn");
        formatter.field("country_code", &self.country_code);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("one_click_id_delay", &self.one_click_id_delay);
        formatter.field("one_click_pin_delay", &self.one_click_pin_delay);
        formatter.finish()
    }
}
/// See [`PstnDialIn`](crate::model::PstnDialIn)
pub mod pstn_dial_in {
    /// A builder for [`PstnDialIn`](crate::model::PstnDialIn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) country_code: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) one_click_id_delay: std::option::Option<std::string::String>,
        pub(crate) one_click_pin_delay: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The zip code.</p>
        pub fn country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.country_code = Some(input.into());
            self
        }
        /// <p>The zip code.</p>
        pub fn set_country_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country_code = input;
            self
        }
        /// <p>The phone number to call to join the conference.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number to call to join the conference.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.</p>
        pub fn one_click_id_delay(mut self, input: impl Into<std::string::String>) -> Self {
            self.one_click_id_delay = Some(input.into());
            self
        }
        /// <p>The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.</p>
        pub fn set_one_click_id_delay(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.one_click_id_delay = input;
            self
        }
        /// <p>The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.</p>
        pub fn one_click_pin_delay(mut self, input: impl Into<std::string::String>) -> Self {
            self.one_click_pin_delay = Some(input.into());
            self
        }
        /// <p>The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.</p>
        pub fn set_one_click_pin_delay(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.one_click_pin_delay = input;
            self
        }
        /// Consumes the builder and constructs a [`PstnDialIn`](crate::model::PstnDialIn)
        pub fn build(self) -> crate::model::PstnDialIn {
            crate::model::PstnDialIn {
                country_code: self.country_code,
                phone_number: self.phone_number,
                one_click_id_delay: self.one_click_id_delay,
                one_click_pin_delay: self.one_click_pin_delay,
            }
        }
    }
}
impl PstnDialIn {
    /// Creates a new builder-style object to manufacture [`PstnDialIn`](crate::model::PstnDialIn)
    pub fn builder() -> crate::model::pstn_dial_in::Builder {
        crate::model::pstn_dial_in::Builder::default()
    }
}

/// <p>The IP endpoint and protocol for calling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpDialIn {
    /// <p>The IP address.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The protocol, including SIP, SIPS, and H323.</p>
    pub comms_protocol: std::option::Option<crate::model::CommsProtocol>,
}
impl std::fmt::Debug for IpDialIn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpDialIn");
        formatter.field("endpoint", &self.endpoint);
        formatter.field("comms_protocol", &self.comms_protocol);
        formatter.finish()
    }
}
/// See [`IpDialIn`](crate::model::IpDialIn)
pub mod ip_dial_in {
    /// A builder for [`IpDialIn`](crate::model::IpDialIn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) comms_protocol: std::option::Option<crate::model::CommsProtocol>,
    }
    impl Builder {
        /// <p>The IP address.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The IP address.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The protocol, including SIP, SIPS, and H323.</p>
        pub fn comms_protocol(mut self, input: crate::model::CommsProtocol) -> Self {
            self.comms_protocol = Some(input);
            self
        }
        /// <p>The protocol, including SIP, SIPS, and H323.</p>
        pub fn set_comms_protocol(
            mut self,
            input: std::option::Option<crate::model::CommsProtocol>,
        ) -> Self {
            self.comms_protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`IpDialIn`](crate::model::IpDialIn)
        pub fn build(self) -> crate::model::IpDialIn {
            crate::model::IpDialIn {
                endpoint: self.endpoint,
                comms_protocol: self.comms_protocol,
            }
        }
    }
}
impl IpDialIn {
    /// Creates a new builder-style object to manufacture [`IpDialIn`](crate::model::IpDialIn)
    pub fn builder() -> crate::model::ip_dial_in::Builder {
        crate::model::ip_dial_in::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CommsProtocol {
    #[allow(missing_docs)] // documentation missing in model
    H323,
    #[allow(missing_docs)] // documentation missing in model
    Sip,
    #[allow(missing_docs)] // documentation missing in model
    Sips,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CommsProtocol {
    fn from(s: &str) -> Self {
        match s {
            "H323" => CommsProtocol::H323,
            "SIP" => CommsProtocol::Sip,
            "SIPS" => CommsProtocol::Sips,
            other => CommsProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CommsProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CommsProtocol::from(s))
    }
}
impl CommsProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CommsProtocol::H323 => "H323",
            CommsProtocol::Sip => "SIP",
            CommsProtocol::Sips => "SIPS",
            CommsProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["H323", "SIP", "SIPS"]
    }
}
impl AsRef<str> for CommsProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConferenceProviderType {
    #[allow(missing_docs)] // documentation missing in model
    Bluejeans,
    #[allow(missing_docs)] // documentation missing in model
    Chime,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Fuze,
    #[allow(missing_docs)] // documentation missing in model
    GoogleHangouts,
    #[allow(missing_docs)] // documentation missing in model
    Polycom,
    #[allow(missing_docs)] // documentation missing in model
    Ringcentral,
    #[allow(missing_docs)] // documentation missing in model
    SkypeForBusiness,
    #[allow(missing_docs)] // documentation missing in model
    Webex,
    #[allow(missing_docs)] // documentation missing in model
    Zoom,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConferenceProviderType {
    fn from(s: &str) -> Self {
        match s {
            "BLUEJEANS" => ConferenceProviderType::Bluejeans,
            "CHIME" => ConferenceProviderType::Chime,
            "CUSTOM" => ConferenceProviderType::Custom,
            "FUZE" => ConferenceProviderType::Fuze,
            "GOOGLE_HANGOUTS" => ConferenceProviderType::GoogleHangouts,
            "POLYCOM" => ConferenceProviderType::Polycom,
            "RINGCENTRAL" => ConferenceProviderType::Ringcentral,
            "SKYPE_FOR_BUSINESS" => ConferenceProviderType::SkypeForBusiness,
            "WEBEX" => ConferenceProviderType::Webex,
            "ZOOM" => ConferenceProviderType::Zoom,
            other => ConferenceProviderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConferenceProviderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConferenceProviderType::from(s))
    }
}
impl ConferenceProviderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConferenceProviderType::Bluejeans => "BLUEJEANS",
            ConferenceProviderType::Chime => "CHIME",
            ConferenceProviderType::Custom => "CUSTOM",
            ConferenceProviderType::Fuze => "FUZE",
            ConferenceProviderType::GoogleHangouts => "GOOGLE_HANGOUTS",
            ConferenceProviderType::Polycom => "POLYCOM",
            ConferenceProviderType::Ringcentral => "RINGCENTRAL",
            ConferenceProviderType::SkypeForBusiness => "SKYPE_FOR_BUSINESS",
            ConferenceProviderType::Webex => "WEBEX",
            ConferenceProviderType::Zoom => "ZOOM",
            ConferenceProviderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BLUEJEANS",
            "CHIME",
            "CUSTOM",
            "FUZE",
            "GOOGLE_HANGOUTS",
            "POLYCOM",
            "RINGCENTRAL",
            "SKYPE_FOR_BUSINESS",
            "WEBEX",
            "ZOOM",
        ]
    }
}
impl AsRef<str> for ConferenceProviderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The recurrence of the reports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BusinessReportRecurrence {
    /// <p>The start date.</p>
    pub start_date: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BusinessReportRecurrence {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BusinessReportRecurrence");
        formatter.field("start_date", &self.start_date);
        formatter.finish()
    }
}
/// See [`BusinessReportRecurrence`](crate::model::BusinessReportRecurrence)
pub mod business_report_recurrence {
    /// A builder for [`BusinessReportRecurrence`](crate::model::BusinessReportRecurrence)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_date: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start date.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The start date.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// Consumes the builder and constructs a [`BusinessReportRecurrence`](crate::model::BusinessReportRecurrence)
        pub fn build(self) -> crate::model::BusinessReportRecurrence {
            crate::model::BusinessReportRecurrence {
                start_date: self.start_date,
            }
        }
    }
}
impl BusinessReportRecurrence {
    /// Creates a new builder-style object to manufacture [`BusinessReportRecurrence`](crate::model::BusinessReportRecurrence)
    pub fn builder() -> crate::model::business_report_recurrence::Builder {
        crate::model::business_report_recurrence::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BusinessReportFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    CsvZip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BusinessReportFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => BusinessReportFormat::Csv,
            "CSV_ZIP" => BusinessReportFormat::CsvZip,
            other => BusinessReportFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BusinessReportFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BusinessReportFormat::from(s))
    }
}
impl BusinessReportFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BusinessReportFormat::Csv => "CSV",
            BusinessReportFormat::CsvZip => "CSV_ZIP",
            BusinessReportFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "CSV_ZIP"]
    }
}
impl AsRef<str> for BusinessReportFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A key-value pair that can be associated with a resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of a tag. Tag keys are case-sensitive. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of a tag. Tag values are case sensitive and can be null.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of a tag. Tag keys are case-sensitive. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of a tag. Tag keys are case-sensitive. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of a tag. Tag values are case sensitive and can be null.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a tag. Tag values are case sensitive and can be null.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Feature {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Bluetooth,
    #[allow(missing_docs)] // documentation missing in model
    Lists,
    #[allow(missing_docs)] // documentation missing in model
    NetworkProfile,
    #[allow(missing_docs)] // documentation missing in model
    Notifications,
    #[allow(missing_docs)] // documentation missing in model
    Settings,
    #[allow(missing_docs)] // documentation missing in model
    Skills,
    #[allow(missing_docs)] // documentation missing in model
    Volume,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Feature {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => Feature::All,
            "BLUETOOTH" => Feature::Bluetooth,
            "LISTS" => Feature::Lists,
            "NETWORK_PROFILE" => Feature::NetworkProfile,
            "NOTIFICATIONS" => Feature::Notifications,
            "SETTINGS" => Feature::Settings,
            "SKILLS" => Feature::Skills,
            "VOLUME" => Feature::Volume,
            other => Feature::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Feature {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Feature::from(s))
    }
}
impl Feature {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Feature::All => "ALL",
            Feature::Bluetooth => "BLUETOOTH",
            Feature::Lists => "LISTS",
            Feature::NetworkProfile => "NETWORK_PROFILE",
            Feature::Notifications => "NOTIFICATIONS",
            Feature::Settings => "SETTINGS",
            Feature::Skills => "SKILLS",
            Feature::Volume => "VOLUME",
            Feature::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL",
            "BLUETOOTH",
            "LISTS",
            "NETWORK_PROFILE",
            "NOTIFICATIONS",
            "SETTINGS",
            "SKILLS",
            "VOLUME",
        ]
    }
}
impl AsRef<str> for Feature {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The content definition. This can contain only one text, SSML, or audio list
/// object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Content {
    /// <p>The list of text messages.</p>
    pub text_list: std::option::Option<std::vec::Vec<crate::model::Text>>,
    /// <p>The list of SSML messages.</p>
    pub ssml_list: std::option::Option<std::vec::Vec<crate::model::Ssml>>,
    /// <p>The list of audio messages.</p>
    pub audio_list: std::option::Option<std::vec::Vec<crate::model::Audio>>,
}
impl std::fmt::Debug for Content {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Content");
        formatter.field("text_list", &self.text_list);
        formatter.field("ssml_list", &self.ssml_list);
        formatter.field("audio_list", &self.audio_list);
        formatter.finish()
    }
}
/// See [`Content`](crate::model::Content)
pub mod content {
    /// A builder for [`Content`](crate::model::Content)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_list: std::option::Option<std::vec::Vec<crate::model::Text>>,
        pub(crate) ssml_list: std::option::Option<std::vec::Vec<crate::model::Ssml>>,
        pub(crate) audio_list: std::option::Option<std::vec::Vec<crate::model::Audio>>,
    }
    impl Builder {
        /// Appends an item to `text_list`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>The list of text messages.</p>
        pub fn text_list(mut self, input: impl Into<crate::model::Text>) -> Self {
            let mut v = self.text_list.unwrap_or_default();
            v.push(input.into());
            self.text_list = Some(v);
            self
        }
        /// <p>The list of text messages.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Text>>,
        ) -> Self {
            self.text_list = input;
            self
        }
        /// Appends an item to `ssml_list`.
        ///
        /// To override the contents of this collection use [`set_ssml_list`](Self::set_ssml_list).
        ///
        /// <p>The list of SSML messages.</p>
        pub fn ssml_list(mut self, input: impl Into<crate::model::Ssml>) -> Self {
            let mut v = self.ssml_list.unwrap_or_default();
            v.push(input.into());
            self.ssml_list = Some(v);
            self
        }
        /// <p>The list of SSML messages.</p>
        pub fn set_ssml_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ssml>>,
        ) -> Self {
            self.ssml_list = input;
            self
        }
        /// Appends an item to `audio_list`.
        ///
        /// To override the contents of this collection use [`set_audio_list`](Self::set_audio_list).
        ///
        /// <p>The list of audio messages.</p>
        pub fn audio_list(mut self, input: impl Into<crate::model::Audio>) -> Self {
            let mut v = self.audio_list.unwrap_or_default();
            v.push(input.into());
            self.audio_list = Some(v);
            self
        }
        /// <p>The list of audio messages.</p>
        pub fn set_audio_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Audio>>,
        ) -> Self {
            self.audio_list = input;
            self
        }
        /// Consumes the builder and constructs a [`Content`](crate::model::Content)
        pub fn build(self) -> crate::model::Content {
            crate::model::Content {
                text_list: self.text_list,
                ssml_list: self.ssml_list,
                audio_list: self.audio_list,
            }
        }
    }
}
impl Content {
    /// Creates a new builder-style object to manufacture [`Content`](crate::model::Content)
    pub fn builder() -> crate::model::content::Builder {
        crate::model::content::Builder::default()
    }
}

/// <p>The audio message. There is a 1 MB limit on the audio file input and the only supported
/// format is MP3. To convert your MP3 audio files to an Alexa-friendly,  </p>
/// <p>required codec version (MPEG version 2) and bit rate (48 kbps), you might use converter
/// software. One option for this is a command-line tool, FFmpeg. For more information, see
/// <a href="https://www.ffmpeg.org/">FFmpeg</a>. The following command converts the
/// provided <input-file> to an MP3 file that is played in the announcement:</p>
/// <p>
/// <code>ffmpeg -i <input-file> -ac 2 -codec:a libmp3lame -b:a 48k -ar 16000
/// <output-file.mp3></code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Audio {
    /// <p>The locale of the audio message. Currently, en-US is supported.</p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>The location of the audio file. Currently, S3 URLs are supported. Only S3 locations
    /// comprised of safe characters are valid. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters">Safe Characters</a>.</p>
    pub location: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Audio {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Audio");
        formatter.field("locale", &self.locale);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`Audio`](crate::model::Audio)
pub mod audio {
    /// A builder for [`Audio`](crate::model::Audio)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The locale of the audio message. Currently, en-US is supported.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale of the audio message. Currently, en-US is supported.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The location of the audio file. Currently, S3 URLs are supported. Only S3 locations
        /// comprised of safe characters are valid. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters">Safe Characters</a>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the audio file. Currently, S3 URLs are supported. Only S3 locations
        /// comprised of safe characters are valid. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters">Safe Characters</a>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`Audio`](crate::model::Audio)
        pub fn build(self) -> crate::model::Audio {
            crate::model::Audio {
                locale: self.locale,
                location: self.location,
            }
        }
    }
}
impl Audio {
    /// Creates a new builder-style object to manufacture [`Audio`](crate::model::Audio)
    pub fn builder() -> crate::model::audio::Builder {
        crate::model::audio::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Locale {
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Locale {
    fn from(s: &str) -> Self {
        match s {
            "en-US" => Locale::EnUs,
            other => Locale::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Locale {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Locale::from(s))
    }
}
impl Locale {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Locale::EnUs => "en-US",
            Locale::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["en-US"]
    }
}
impl AsRef<str> for Locale {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The SSML message. For more information, see <a href="https://developer.amazon.com/docs/custom-skills/speech-synthesis-markup-language-ssml-reference.html">SSML Reference</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ssml {
    /// <p>The locale of the SSML message. Currently, en-US is supported.</p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>The value of the SSML message in the correct SSML format. The audio tag is not supported.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Ssml {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ssml");
        formatter.field("locale", &self.locale);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Ssml`](crate::model::Ssml)
pub mod ssml {
    /// A builder for [`Ssml`](crate::model::Ssml)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The locale of the SSML message. Currently, en-US is supported.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale of the SSML message. Currently, en-US is supported.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The value of the SSML message in the correct SSML format. The audio tag is not supported.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the SSML message in the correct SSML format. The audio tag is not supported.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Ssml`](crate::model::Ssml)
        pub fn build(self) -> crate::model::Ssml {
            crate::model::Ssml {
                locale: self.locale,
                value: self.value,
            }
        }
    }
}
impl Ssml {
    /// Creates a new builder-style object to manufacture [`Ssml`](crate::model::Ssml)
    pub fn builder() -> crate::model::ssml::Builder {
        crate::model::ssml::Builder::default()
    }
}

/// <p>The text message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Text {
    /// <p>The locale of the text message. Currently, en-US is supported.</p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>The value of the text message.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Text {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Text");
        formatter.field("locale", &self.locale);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Text`](crate::model::Text)
pub mod text {
    /// A builder for [`Text`](crate::model::Text)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The locale of the text message. Currently, en-US is supported.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale of the text message. Currently, en-US is supported.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The value of the text message.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the text message.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Text`](crate::model::Text)
        pub fn build(self) -> crate::model::Text {
            crate::model::Text {
                locale: self.locale,
                value: self.value,
            }
        }
    }
}
impl Text {
    /// Creates a new builder-style object to manufacture [`Text`](crate::model::Text)
    pub fn builder() -> crate::model::text::Builder {
        crate::model::text::Builder::default()
    }
}

/// <p>A filter name and value pair that is used to return a more specific list of results.
/// Filters can be used to match a set of resources by various criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The key of a filter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The values of a filter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The key of a filter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of a filter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of a filter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of a filter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Information related to a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserData {
    /// <p>The ARN of a user.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The first name of a user.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name of a user.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The email of a user.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The enrollment status of a user.</p>
    pub enrollment_status: std::option::Option<crate::model::EnrollmentStatus>,
    /// <p>The enrollment ARN of a user.</p>
    pub enrollment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserData");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("first_name", &self.first_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("email", &self.email);
        formatter.field("enrollment_status", &self.enrollment_status);
        formatter.field("enrollment_id", &self.enrollment_id);
        formatter.finish()
    }
}
/// See [`UserData`](crate::model::UserData)
pub mod user_data {
    /// A builder for [`UserData`](crate::model::UserData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) enrollment_status: std::option::Option<crate::model::EnrollmentStatus>,
        pub(crate) enrollment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a user.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a user.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The first name of a user.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name of a user.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name of a user.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name of a user.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The email of a user.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email of a user.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The enrollment status of a user.</p>
        pub fn enrollment_status(mut self, input: crate::model::EnrollmentStatus) -> Self {
            self.enrollment_status = Some(input);
            self
        }
        /// <p>The enrollment status of a user.</p>
        pub fn set_enrollment_status(
            mut self,
            input: std::option::Option<crate::model::EnrollmentStatus>,
        ) -> Self {
            self.enrollment_status = input;
            self
        }
        /// <p>The enrollment ARN of a user.</p>
        pub fn enrollment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.enrollment_id = Some(input.into());
            self
        }
        /// <p>The enrollment ARN of a user.</p>
        pub fn set_enrollment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.enrollment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserData`](crate::model::UserData)
        pub fn build(self) -> crate::model::UserData {
            crate::model::UserData {
                user_arn: self.user_arn,
                first_name: self.first_name,
                last_name: self.last_name,
                email: self.email,
                enrollment_status: self.enrollment_status,
                enrollment_id: self.enrollment_id,
            }
        }
    }
}
impl UserData {
    /// Creates a new builder-style object to manufacture [`UserData`](crate::model::UserData)
    pub fn builder() -> crate::model::user_data::Builder {
        crate::model::user_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnrollmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deregistering,
    #[allow(missing_docs)] // documentation missing in model
    Disassociating,
    #[allow(missing_docs)] // documentation missing in model
    Initialized,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Registered,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnrollmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "DEREGISTERING" => EnrollmentStatus::Deregistering,
            "DISASSOCIATING" => EnrollmentStatus::Disassociating,
            "INITIALIZED" => EnrollmentStatus::Initialized,
            "PENDING" => EnrollmentStatus::Pending,
            "REGISTERED" => EnrollmentStatus::Registered,
            other => EnrollmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnrollmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnrollmentStatus::from(s))
    }
}
impl EnrollmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnrollmentStatus::Deregistering => "DEREGISTERING",
            EnrollmentStatus::Disassociating => "DISASSOCIATING",
            EnrollmentStatus::Initialized => "INITIALIZED",
            EnrollmentStatus::Pending => "PENDING",
            EnrollmentStatus::Registered => "REGISTERED",
            EnrollmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEREGISTERING",
            "DISASSOCIATING",
            "INITIALIZED",
            "PENDING",
            "REGISTERED",
        ]
    }
}
impl AsRef<str> for EnrollmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing a sort criteria. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Sort {
    /// <p>The sort key of a sort object.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The sort value of a sort object.</p>
    pub value: std::option::Option<crate::model::SortValue>,
}
impl std::fmt::Debug for Sort {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Sort");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Sort`](crate::model::Sort)
pub mod sort {
    /// A builder for [`Sort`](crate::model::Sort)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::SortValue>,
    }
    impl Builder {
        /// <p>The sort key of a sort object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The sort key of a sort object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The sort value of a sort object.</p>
        pub fn value(mut self, input: crate::model::SortValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The sort value of a sort object.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::SortValue>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Sort`](crate::model::Sort)
        pub fn build(self) -> crate::model::Sort {
            crate::model::Sort {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Sort {
    /// Creates a new builder-style object to manufacture [`Sort`](crate::model::Sort)
    pub fn builder() -> crate::model::sort::Builder {
        crate::model::sort::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortValue {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortValue {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => SortValue::Asc,
            "DESC" => SortValue::Desc,
            other => SortValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortValue::from(s))
    }
}
impl SortValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortValue::Asc => "ASC",
            SortValue::Desc => "DESC",
            SortValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for SortValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The attributes of a skill group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SkillGroupData {
    /// <p>The skill group ARN of a skill group.</p>
    pub skill_group_arn: std::option::Option<std::string::String>,
    /// <p>The skill group name of a skill group.</p>
    pub skill_group_name: std::option::Option<std::string::String>,
    /// <p>The description of a skill group.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SkillGroupData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SkillGroupData");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.field("skill_group_name", &self.skill_group_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`SkillGroupData`](crate::model::SkillGroupData)
pub mod skill_group_data {
    /// A builder for [`SkillGroupData`](crate::model::SkillGroupData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
        pub(crate) skill_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The skill group ARN of a skill group.</p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The skill group ARN of a skill group.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// <p>The skill group name of a skill group.</p>
        pub fn skill_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_name = Some(input.into());
            self
        }
        /// <p>The skill group name of a skill group.</p>
        pub fn set_skill_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_name = input;
            self
        }
        /// <p>The description of a skill group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a skill group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`SkillGroupData`](crate::model::SkillGroupData)
        pub fn build(self) -> crate::model::SkillGroupData {
            crate::model::SkillGroupData {
                skill_group_arn: self.skill_group_arn,
                skill_group_name: self.skill_group_name,
                description: self.description,
            }
        }
    }
}
impl SkillGroupData {
    /// Creates a new builder-style object to manufacture [`SkillGroupData`](crate::model::SkillGroupData)
    pub fn builder() -> crate::model::skill_group_data::Builder {
        crate::model::skill_group_data::Builder::default()
    }
}

/// <p>The data of a room.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoomData {
    /// <p>The ARN of a room.</p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The name of a room.</p>
    pub room_name: std::option::Option<std::string::String>,
    /// <p>The description of a room.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The provider calendar ARN of a room.</p>
    pub provider_calendar_id: std::option::Option<std::string::String>,
    /// <p>The profile ARN of a room.</p>
    pub profile_arn: std::option::Option<std::string::String>,
    /// <p>The profile name of a room.</p>
    pub profile_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RoomData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoomData");
        formatter.field("room_arn", &self.room_arn);
        formatter.field("room_name", &self.room_name);
        formatter.field("description", &self.description);
        formatter.field("provider_calendar_id", &self.provider_calendar_id);
        formatter.field("profile_arn", &self.profile_arn);
        formatter.field("profile_name", &self.profile_name);
        formatter.finish()
    }
}
/// See [`RoomData`](crate::model::RoomData)
pub mod room_data {
    /// A builder for [`RoomData`](crate::model::RoomData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) room_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) provider_calendar_id: std::option::Option<std::string::String>,
        pub(crate) profile_arn: std::option::Option<std::string::String>,
        pub(crate) profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a room.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a room.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The name of a room.</p>
        pub fn room_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_name = Some(input.into());
            self
        }
        /// <p>The name of a room.</p>
        pub fn set_room_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_name = input;
            self
        }
        /// <p>The description of a room.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a room.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The provider calendar ARN of a room.</p>
        pub fn provider_calendar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_calendar_id = Some(input.into());
            self
        }
        /// <p>The provider calendar ARN of a room.</p>
        pub fn set_provider_calendar_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_calendar_id = input;
            self
        }
        /// <p>The profile ARN of a room.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The profile ARN of a room.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// <p>The profile name of a room.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The profile name of a room.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RoomData`](crate::model::RoomData)
        pub fn build(self) -> crate::model::RoomData {
            crate::model::RoomData {
                room_arn: self.room_arn,
                room_name: self.room_name,
                description: self.description,
                provider_calendar_id: self.provider_calendar_id,
                profile_arn: self.profile_arn,
                profile_name: self.profile_name,
            }
        }
    }
}
impl RoomData {
    /// Creates a new builder-style object to manufacture [`RoomData`](crate::model::RoomData)
    pub fn builder() -> crate::model::room_data::Builder {
        crate::model::room_data::Builder::default()
    }
}

/// <p>The data of a room profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProfileData {
    /// <p>The ARN of a room profile.</p>
    pub profile_arn: std::option::Option<std::string::String>,
    /// <p>The name of a room profile.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>Retrieves if the profile data is default or not.</p>
    pub is_default: std::option::Option<bool>,
    /// <p>The address of a room profile.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The time zone of a room profile.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>The distance unit of a room profile.</p>
    pub distance_unit: std::option::Option<crate::model::DistanceUnit>,
    /// <p>The temperature unit of a room profile.</p>
    pub temperature_unit: std::option::Option<crate::model::TemperatureUnit>,
    /// <p>The wake word of a room profile.</p>
    pub wake_word: std::option::Option<crate::model::WakeWord>,
    /// <p>The locale of a room profile. (This is currently available only to a limited preview
    /// audience.)</p>
    pub locale: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProfileData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProfileData");
        formatter.field("profile_arn", &self.profile_arn);
        formatter.field("profile_name", &self.profile_name);
        formatter.field("is_default", &self.is_default);
        formatter.field("address", &self.address);
        formatter.field("timezone", &self.timezone);
        formatter.field("distance_unit", &self.distance_unit);
        formatter.field("temperature_unit", &self.temperature_unit);
        formatter.field("wake_word", &self.wake_word);
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}
/// See [`ProfileData`](crate::model::ProfileData)
pub mod profile_data {
    /// A builder for [`ProfileData`](crate::model::ProfileData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_arn: std::option::Option<std::string::String>,
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) is_default: std::option::Option<bool>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) distance_unit: std::option::Option<crate::model::DistanceUnit>,
        pub(crate) temperature_unit: std::option::Option<crate::model::TemperatureUnit>,
        pub(crate) wake_word: std::option::Option<crate::model::WakeWord>,
        pub(crate) locale: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a room profile.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a room profile.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// <p>The name of a room profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of a room profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>Retrieves if the profile data is default or not.</p>
        pub fn is_default(mut self, input: bool) -> Self {
            self.is_default = Some(input);
            self
        }
        /// <p>Retrieves if the profile data is default or not.</p>
        pub fn set_is_default(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default = input;
            self
        }
        /// <p>The address of a room profile.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The address of a room profile.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The time zone of a room profile.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone of a room profile.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>The distance unit of a room profile.</p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.distance_unit = Some(input);
            self
        }
        /// <p>The distance unit of a room profile.</p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.distance_unit = input;
            self
        }
        /// <p>The temperature unit of a room profile.</p>
        pub fn temperature_unit(mut self, input: crate::model::TemperatureUnit) -> Self {
            self.temperature_unit = Some(input);
            self
        }
        /// <p>The temperature unit of a room profile.</p>
        pub fn set_temperature_unit(
            mut self,
            input: std::option::Option<crate::model::TemperatureUnit>,
        ) -> Self {
            self.temperature_unit = input;
            self
        }
        /// <p>The wake word of a room profile.</p>
        pub fn wake_word(mut self, input: crate::model::WakeWord) -> Self {
            self.wake_word = Some(input);
            self
        }
        /// <p>The wake word of a room profile.</p>
        pub fn set_wake_word(mut self, input: std::option::Option<crate::model::WakeWord>) -> Self {
            self.wake_word = input;
            self
        }
        /// <p>The locale of a room profile. (This is currently available only to a limited preview
        /// audience.)</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale of a room profile. (This is currently available only to a limited preview
        /// audience.)</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`ProfileData`](crate::model::ProfileData)
        pub fn build(self) -> crate::model::ProfileData {
            crate::model::ProfileData {
                profile_arn: self.profile_arn,
                profile_name: self.profile_name,
                is_default: self.is_default,
                address: self.address,
                timezone: self.timezone,
                distance_unit: self.distance_unit,
                temperature_unit: self.temperature_unit,
                wake_word: self.wake_word,
                locale: self.locale,
            }
        }
    }
}
impl ProfileData {
    /// Creates a new builder-style object to manufacture [`ProfileData`](crate::model::ProfileData)
    pub fn builder() -> crate::model::profile_data::Builder {
        crate::model::profile_data::Builder::default()
    }
}

/// <p>The data associated with a network profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkProfileData {
    /// <p>The ARN of the network profile associated with a device.</p>
    pub network_profile_arn: std::option::Option<std::string::String>,
    /// <p>The name of the network profile associated with a device.</p>
    pub network_profile_name: std::option::Option<std::string::String>,
    /// <p>Detailed information about a device's network profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The SSID of the Wi-Fi network.</p>
    pub ssid: std::option::Option<std::string::String>,
    /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
    /// WEP, or OPEN.</p>
    pub security_type: std::option::Option<crate::model::NetworkSecurityType>,
    /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
    /// supported.</p>
    pub eap_method: std::option::Option<crate::model::NetworkEapMethod>,
    /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
    /// (ACM). This is used to issue certificates to the devices.</p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NetworkProfileData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkProfileData");
        formatter.field("network_profile_arn", &self.network_profile_arn);
        formatter.field("network_profile_name", &self.network_profile_name);
        formatter.field("description", &self.description);
        formatter.field("ssid", &self.ssid);
        formatter.field("security_type", &self.security_type);
        formatter.field("eap_method", &self.eap_method);
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.finish()
    }
}
/// See [`NetworkProfileData`](crate::model::NetworkProfileData)
pub mod network_profile_data {
    /// A builder for [`NetworkProfileData`](crate::model::NetworkProfileData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile_arn: std::option::Option<std::string::String>,
        pub(crate) network_profile_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ssid: std::option::Option<std::string::String>,
        pub(crate) security_type: std::option::Option<crate::model::NetworkSecurityType>,
        pub(crate) eap_method: std::option::Option<crate::model::NetworkEapMethod>,
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_arn = input;
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn network_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn set_network_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_name = input;
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The SSID of the Wi-Fi network.</p>
        pub fn ssid(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssid = Some(input.into());
            self
        }
        /// <p>The SSID of the Wi-Fi network.</p>
        pub fn set_ssid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssid = input;
            self
        }
        /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
        /// WEP, or OPEN.</p>
        pub fn security_type(mut self, input: crate::model::NetworkSecurityType) -> Self {
            self.security_type = Some(input);
            self
        }
        /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
        /// WEP, or OPEN.</p>
        pub fn set_security_type(
            mut self,
            input: std::option::Option<crate::model::NetworkSecurityType>,
        ) -> Self {
            self.security_type = input;
            self
        }
        /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
        /// supported.</p>
        pub fn eap_method(mut self, input: crate::model::NetworkEapMethod) -> Self {
            self.eap_method = Some(input);
            self
        }
        /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
        /// supported.</p>
        pub fn set_eap_method(
            mut self,
            input: std::option::Option<crate::model::NetworkEapMethod>,
        ) -> Self {
            self.eap_method = input;
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices.</p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices.</p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkProfileData`](crate::model::NetworkProfileData)
        pub fn build(self) -> crate::model::NetworkProfileData {
            crate::model::NetworkProfileData {
                network_profile_arn: self.network_profile_arn,
                network_profile_name: self.network_profile_name,
                description: self.description,
                ssid: self.ssid,
                security_type: self.security_type,
                eap_method: self.eap_method,
                certificate_authority_arn: self.certificate_authority_arn,
            }
        }
    }
}
impl NetworkProfileData {
    /// Creates a new builder-style object to manufacture [`NetworkProfileData`](crate::model::NetworkProfileData)
    pub fn builder() -> crate::model::network_profile_data::Builder {
        crate::model::network_profile_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkEapMethod {
    #[allow(missing_docs)] // documentation missing in model
    EapTls,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkEapMethod {
    fn from(s: &str) -> Self {
        match s {
            "EAP_TLS" => NetworkEapMethod::EapTls,
            other => NetworkEapMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkEapMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkEapMethod::from(s))
    }
}
impl NetworkEapMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkEapMethod::EapTls => "EAP_TLS",
            NetworkEapMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EAP_TLS"]
    }
}
impl AsRef<str> for NetworkEapMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkSecurityType {
    #[allow(missing_docs)] // documentation missing in model
    Open,
    #[allow(missing_docs)] // documentation missing in model
    Wep,
    #[allow(missing_docs)] // documentation missing in model
    Wpa2Enterprise,
    #[allow(missing_docs)] // documentation missing in model
    Wpa2Psk,
    #[allow(missing_docs)] // documentation missing in model
    WpaPsk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkSecurityType {
    fn from(s: &str) -> Self {
        match s {
            "OPEN" => NetworkSecurityType::Open,
            "WEP" => NetworkSecurityType::Wep,
            "WPA2_ENTERPRISE" => NetworkSecurityType::Wpa2Enterprise,
            "WPA2_PSK" => NetworkSecurityType::Wpa2Psk,
            "WPA_PSK" => NetworkSecurityType::WpaPsk,
            other => NetworkSecurityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkSecurityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkSecurityType::from(s))
    }
}
impl NetworkSecurityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkSecurityType::Open => "OPEN",
            NetworkSecurityType::Wep => "WEP",
            NetworkSecurityType::Wpa2Enterprise => "WPA2_ENTERPRISE",
            NetworkSecurityType::Wpa2Psk => "WPA2_PSK",
            NetworkSecurityType::WpaPsk => "WPA_PSK",
            NetworkSecurityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPEN", "WEP", "WPA2_ENTERPRISE", "WPA2_PSK", "WPA_PSK"]
    }
}
impl AsRef<str> for NetworkSecurityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Device attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceData {
    /// <p>The ARN of a device.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The serial number of a device.</p>
    pub device_serial_number: std::option::Option<std::string::String>,
    /// <p>The type of a device.</p>
    pub device_type: std::option::Option<std::string::String>,
    /// <p>The name of a device.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The software version of a device.</p>
    pub software_version: std::option::Option<std::string::String>,
    /// <p>The MAC address of a device.</p>
    pub mac_address: std::option::Option<std::string::String>,
    /// <p>The status of a device.</p>
    pub device_status: std::option::Option<crate::model::DeviceStatus>,
    /// <p>The ARN of the network profile associated with a device.</p>
    pub network_profile_arn: std::option::Option<std::string::String>,
    /// <p>The name of the network profile associated with a device.</p>
    pub network_profile_name: std::option::Option<std::string::String>,
    /// <p>The room ARN associated with a device.</p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The name of the room associated with a device.</p>
    pub room_name: std::option::Option<std::string::String>,
    /// <p>Detailed information about a device's status.</p>
    pub device_status_info: std::option::Option<crate::model::DeviceStatusInfo>,
    /// <p>The time (in epoch) when the device data was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DeviceData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceData");
        formatter.field("device_arn", &self.device_arn);
        formatter.field("device_serial_number", &self.device_serial_number);
        formatter.field("device_type", &self.device_type);
        formatter.field("device_name", &self.device_name);
        formatter.field("software_version", &self.software_version);
        formatter.field("mac_address", &self.mac_address);
        formatter.field("device_status", &self.device_status);
        formatter.field("network_profile_arn", &self.network_profile_arn);
        formatter.field("network_profile_name", &self.network_profile_name);
        formatter.field("room_arn", &self.room_arn);
        formatter.field("room_name", &self.room_name);
        formatter.field("device_status_info", &self.device_status_info);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`DeviceData`](crate::model::DeviceData)
pub mod device_data {
    /// A builder for [`DeviceData`](crate::model::DeviceData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) device_serial_number: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<std::string::String>,
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) software_version: std::option::Option<std::string::String>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) device_status: std::option::Option<crate::model::DeviceStatus>,
        pub(crate) network_profile_arn: std::option::Option<std::string::String>,
        pub(crate) network_profile_name: std::option::Option<std::string::String>,
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) room_name: std::option::Option<std::string::String>,
        pub(crate) device_status_info: std::option::Option<crate::model::DeviceStatusInfo>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of a device.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The serial number of a device.</p>
        pub fn device_serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_serial_number = Some(input.into());
            self
        }
        /// <p>The serial number of a device.</p>
        pub fn set_device_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_serial_number = input;
            self
        }
        /// <p>The type of a device.</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>The type of a device.</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// <p>The name of a device.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of a device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The software version of a device.</p>
        pub fn software_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.software_version = Some(input.into());
            self
        }
        /// <p>The software version of a device.</p>
        pub fn set_software_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.software_version = input;
            self
        }
        /// <p>The MAC address of a device.</p>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>The MAC address of a device.</p>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// <p>The status of a device.</p>
        pub fn device_status(mut self, input: crate::model::DeviceStatus) -> Self {
            self.device_status = Some(input);
            self
        }
        /// <p>The status of a device.</p>
        pub fn set_device_status(
            mut self,
            input: std::option::Option<crate::model::DeviceStatus>,
        ) -> Self {
            self.device_status = input;
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_arn = input;
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn network_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn set_network_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_name = input;
            self
        }
        /// <p>The room ARN associated with a device.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The room ARN associated with a device.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The name of the room associated with a device.</p>
        pub fn room_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_name = Some(input.into());
            self
        }
        /// <p>The name of the room associated with a device.</p>
        pub fn set_room_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_name = input;
            self
        }
        /// <p>Detailed information about a device's status.</p>
        pub fn device_status_info(mut self, input: crate::model::DeviceStatusInfo) -> Self {
            self.device_status_info = Some(input);
            self
        }
        /// <p>Detailed information about a device's status.</p>
        pub fn set_device_status_info(
            mut self,
            input: std::option::Option<crate::model::DeviceStatusInfo>,
        ) -> Self {
            self.device_status_info = input;
            self
        }
        /// <p>The time (in epoch) when the device data was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time (in epoch) when the device data was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceData`](crate::model::DeviceData)
        pub fn build(self) -> crate::model::DeviceData {
            crate::model::DeviceData {
                device_arn: self.device_arn,
                device_serial_number: self.device_serial_number,
                device_type: self.device_type,
                device_name: self.device_name,
                software_version: self.software_version,
                mac_address: self.mac_address,
                device_status: self.device_status,
                network_profile_arn: self.network_profile_arn,
                network_profile_name: self.network_profile_name,
                room_arn: self.room_arn,
                room_name: self.room_name,
                device_status_info: self.device_status_info,
                created_time: self.created_time,
            }
        }
    }
}
impl DeviceData {
    /// Creates a new builder-style object to manufacture [`DeviceData`](crate::model::DeviceData)
    pub fn builder() -> crate::model::device_data::Builder {
        crate::model::device_data::Builder::default()
    }
}

/// <p>Detailed information about a device's status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceStatusInfo {
    /// <p>One or more device status detail descriptions.</p>
    pub device_status_details: std::option::Option<std::vec::Vec<crate::model::DeviceStatusDetail>>,
    /// <p>The latest available information about the connection status of a device. </p>
    pub connection_status: std::option::Option<crate::model::ConnectionStatus>,
    /// <p>The time (in epoch) when the device connection status changed.</p>
    pub connection_status_updated_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DeviceStatusInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceStatusInfo");
        formatter.field("device_status_details", &self.device_status_details);
        formatter.field("connection_status", &self.connection_status);
        formatter.field(
            "connection_status_updated_time",
            &self.connection_status_updated_time,
        );
        formatter.finish()
    }
}
/// See [`DeviceStatusInfo`](crate::model::DeviceStatusInfo)
pub mod device_status_info {
    /// A builder for [`DeviceStatusInfo`](crate::model::DeviceStatusInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_status_details:
            std::option::Option<std::vec::Vec<crate::model::DeviceStatusDetail>>,
        pub(crate) connection_status: std::option::Option<crate::model::ConnectionStatus>,
        pub(crate) connection_status_updated_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// Appends an item to `device_status_details`.
        ///
        /// To override the contents of this collection use [`set_device_status_details`](Self::set_device_status_details).
        ///
        /// <p>One or more device status detail descriptions.</p>
        pub fn device_status_details(
            mut self,
            input: impl Into<crate::model::DeviceStatusDetail>,
        ) -> Self {
            let mut v = self.device_status_details.unwrap_or_default();
            v.push(input.into());
            self.device_status_details = Some(v);
            self
        }
        /// <p>One or more device status detail descriptions.</p>
        pub fn set_device_status_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceStatusDetail>>,
        ) -> Self {
            self.device_status_details = input;
            self
        }
        /// <p>The latest available information about the connection status of a device. </p>
        pub fn connection_status(mut self, input: crate::model::ConnectionStatus) -> Self {
            self.connection_status = Some(input);
            self
        }
        /// <p>The latest available information about the connection status of a device. </p>
        pub fn set_connection_status(
            mut self,
            input: std::option::Option<crate::model::ConnectionStatus>,
        ) -> Self {
            self.connection_status = input;
            self
        }
        /// <p>The time (in epoch) when the device connection status changed.</p>
        pub fn connection_status_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.connection_status_updated_time = Some(input);
            self
        }
        /// <p>The time (in epoch) when the device connection status changed.</p>
        pub fn set_connection_status_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.connection_status_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceStatusInfo`](crate::model::DeviceStatusInfo)
        pub fn build(self) -> crate::model::DeviceStatusInfo {
            crate::model::DeviceStatusInfo {
                device_status_details: self.device_status_details,
                connection_status: self.connection_status,
                connection_status_updated_time: self.connection_status_updated_time,
            }
        }
    }
}
impl DeviceStatusInfo {
    /// Creates a new builder-style object to manufacture [`DeviceStatusInfo`](crate::model::DeviceStatusInfo)
    pub fn builder() -> crate::model::device_status_info::Builder {
        crate::model::device_status_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Offline,
    #[allow(missing_docs)] // documentation missing in model
    Online,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "OFFLINE" => ConnectionStatus::Offline,
            "ONLINE" => ConnectionStatus::Online,
            other => ConnectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionStatus::from(s))
    }
}
impl ConnectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionStatus::Offline => "OFFLINE",
            ConnectionStatus::Online => "ONLINE",
            ConnectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OFFLINE", "ONLINE"]
    }
}
impl AsRef<str> for ConnectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of a device’s status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceStatusDetail {
    /// <p>The list of available features on the device.</p>
    pub feature: std::option::Option<crate::model::Feature>,
    /// <p>The device status detail code.</p>
    pub code: std::option::Option<crate::model::DeviceStatusDetailCode>,
}
impl std::fmt::Debug for DeviceStatusDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceStatusDetail");
        formatter.field("feature", &self.feature);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
/// See [`DeviceStatusDetail`](crate::model::DeviceStatusDetail)
pub mod device_status_detail {
    /// A builder for [`DeviceStatusDetail`](crate::model::DeviceStatusDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature: std::option::Option<crate::model::Feature>,
        pub(crate) code: std::option::Option<crate::model::DeviceStatusDetailCode>,
    }
    impl Builder {
        /// <p>The list of available features on the device.</p>
        pub fn feature(mut self, input: crate::model::Feature) -> Self {
            self.feature = Some(input);
            self
        }
        /// <p>The list of available features on the device.</p>
        pub fn set_feature(mut self, input: std::option::Option<crate::model::Feature>) -> Self {
            self.feature = input;
            self
        }
        /// <p>The device status detail code.</p>
        pub fn code(mut self, input: crate::model::DeviceStatusDetailCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The device status detail code.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::DeviceStatusDetailCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceStatusDetail`](crate::model::DeviceStatusDetail)
        pub fn build(self) -> crate::model::DeviceStatusDetail {
            crate::model::DeviceStatusDetail {
                feature: self.feature,
                code: self.code,
            }
        }
    }
}
impl DeviceStatusDetail {
    /// Creates a new builder-style object to manufacture [`DeviceStatusDetail`](crate::model::DeviceStatusDetail)
    pub fn builder() -> crate::model::device_status_detail::Builder {
        crate::model::device_status_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceStatusDetailCode {
    #[allow(missing_docs)] // documentation missing in model
    AssociationRejection,
    #[allow(missing_docs)] // documentation missing in model
    AuthenticationFailure,
    #[allow(missing_docs)] // documentation missing in model
    CertificateAuthorityAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    CertificateIssuingLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    CredentialsAccessFailure,
    #[allow(missing_docs)] // documentation missing in model
    DeviceSoftwareUpdateNeeded,
    #[allow(missing_docs)] // documentation missing in model
    DeviceWasOffline,
    #[allow(missing_docs)] // documentation missing in model
    DhcpFailure,
    #[allow(missing_docs)] // documentation missing in model
    DnsFailure,
    #[allow(missing_docs)] // documentation missing in model
    InternetUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    InvalidCertificateAuthority,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPasswordState,
    #[allow(missing_docs)] // documentation missing in model
    NetworkProfileNotFound,
    #[allow(missing_docs)] // documentation missing in model
    PasswordManagerAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    PasswordNotFound,
    #[allow(missing_docs)] // documentation missing in model
    TlsVersionMismatch,
    #[allow(missing_docs)] // documentation missing in model
    UnknownFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceStatusDetailCode {
    fn from(s: &str) -> Self {
        match s {
            "ASSOCIATION_REJECTION" => DeviceStatusDetailCode::AssociationRejection,
            "AUTHENTICATION_FAILURE" => DeviceStatusDetailCode::AuthenticationFailure,
            "CERTIFICATE_AUTHORITY_ACCESS_DENIED" => {
                DeviceStatusDetailCode::CertificateAuthorityAccessDenied
            }
            "CERTIFICATE_ISSUING_LIMIT_EXCEEDED" => {
                DeviceStatusDetailCode::CertificateIssuingLimitExceeded
            }
            "CREDENTIALS_ACCESS_FAILURE" => DeviceStatusDetailCode::CredentialsAccessFailure,
            "DEVICE_SOFTWARE_UPDATE_NEEDED" => DeviceStatusDetailCode::DeviceSoftwareUpdateNeeded,
            "DEVICE_WAS_OFFLINE" => DeviceStatusDetailCode::DeviceWasOffline,
            "DHCP_FAILURE" => DeviceStatusDetailCode::DhcpFailure,
            "DNS_FAILURE" => DeviceStatusDetailCode::DnsFailure,
            "INTERNET_UNAVAILABLE" => DeviceStatusDetailCode::InternetUnavailable,
            "INVALID_CERTIFICATE_AUTHORITY" => DeviceStatusDetailCode::InvalidCertificateAuthority,
            "INVALID_PASSWORD_STATE" => DeviceStatusDetailCode::InvalidPasswordState,
            "NETWORK_PROFILE_NOT_FOUND" => DeviceStatusDetailCode::NetworkProfileNotFound,
            "PASSWORD_MANAGER_ACCESS_DENIED" => DeviceStatusDetailCode::PasswordManagerAccessDenied,
            "PASSWORD_NOT_FOUND" => DeviceStatusDetailCode::PasswordNotFound,
            "TLS_VERSION_MISMATCH" => DeviceStatusDetailCode::TlsVersionMismatch,
            "UNKNOWN_FAILURE" => DeviceStatusDetailCode::UnknownFailure,
            other => DeviceStatusDetailCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceStatusDetailCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceStatusDetailCode::from(s))
    }
}
impl DeviceStatusDetailCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceStatusDetailCode::AssociationRejection => "ASSOCIATION_REJECTION",
            DeviceStatusDetailCode::AuthenticationFailure => "AUTHENTICATION_FAILURE",
            DeviceStatusDetailCode::CertificateAuthorityAccessDenied => {
                "CERTIFICATE_AUTHORITY_ACCESS_DENIED"
            }
            DeviceStatusDetailCode::CertificateIssuingLimitExceeded => {
                "CERTIFICATE_ISSUING_LIMIT_EXCEEDED"
            }
            DeviceStatusDetailCode::CredentialsAccessFailure => "CREDENTIALS_ACCESS_FAILURE",
            DeviceStatusDetailCode::DeviceSoftwareUpdateNeeded => "DEVICE_SOFTWARE_UPDATE_NEEDED",
            DeviceStatusDetailCode::DeviceWasOffline => "DEVICE_WAS_OFFLINE",
            DeviceStatusDetailCode::DhcpFailure => "DHCP_FAILURE",
            DeviceStatusDetailCode::DnsFailure => "DNS_FAILURE",
            DeviceStatusDetailCode::InternetUnavailable => "INTERNET_UNAVAILABLE",
            DeviceStatusDetailCode::InvalidCertificateAuthority => "INVALID_CERTIFICATE_AUTHORITY",
            DeviceStatusDetailCode::InvalidPasswordState => "INVALID_PASSWORD_STATE",
            DeviceStatusDetailCode::NetworkProfileNotFound => "NETWORK_PROFILE_NOT_FOUND",
            DeviceStatusDetailCode::PasswordManagerAccessDenied => "PASSWORD_MANAGER_ACCESS_DENIED",
            DeviceStatusDetailCode::PasswordNotFound => "PASSWORD_NOT_FOUND",
            DeviceStatusDetailCode::TlsVersionMismatch => "TLS_VERSION_MISMATCH",
            DeviceStatusDetailCode::UnknownFailure => "UNKNOWN_FAILURE",
            DeviceStatusDetailCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSOCIATION_REJECTION",
            "AUTHENTICATION_FAILURE",
            "CERTIFICATE_AUTHORITY_ACCESS_DENIED",
            "CERTIFICATE_ISSUING_LIMIT_EXCEEDED",
            "CREDENTIALS_ACCESS_FAILURE",
            "DEVICE_SOFTWARE_UPDATE_NEEDED",
            "DEVICE_WAS_OFFLINE",
            "DHCP_FAILURE",
            "DNS_FAILURE",
            "INTERNET_UNAVAILABLE",
            "INVALID_CERTIFICATE_AUTHORITY",
            "INVALID_PASSWORD_STATE",
            "NETWORK_PROFILE_NOT_FOUND",
            "PASSWORD_MANAGER_ACCESS_DENIED",
            "PASSWORD_NOT_FOUND",
            "TLS_VERSION_MISMATCH",
            "UNKNOWN_FAILURE",
        ]
    }
}
impl AsRef<str> for DeviceStatusDetailCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deregistered,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    WasOffline,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceStatus {
    fn from(s: &str) -> Self {
        match s {
            "DEREGISTERED" => DeviceStatus::Deregistered,
            "FAILED" => DeviceStatus::Failed,
            "PENDING" => DeviceStatus::Pending,
            "READY" => DeviceStatus::Ready,
            "WAS_OFFLINE" => DeviceStatus::WasOffline,
            other => DeviceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceStatus::from(s))
    }
}
impl DeviceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceStatus::Deregistered => "DEREGISTERED",
            DeviceStatus::Failed => "FAILED",
            DeviceStatus::Pending => "PENDING",
            DeviceStatus::Ready => "READY",
            DeviceStatus::WasOffline => "WAS_OFFLINE",
            DeviceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEREGISTERED", "FAILED", "PENDING", "READY", "WAS_OFFLINE"]
    }
}
impl AsRef<str> for DeviceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information related to a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactData {
    /// <p>The ARN of the contact.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The name of the contact to display on the console.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The first name of the contact, used to call the contact on the device.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name of the contact, used to call the contact on the device.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The phone number of the contact. The phone number type defaults to WORK. You can
    /// specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you
    /// specify the phone number type and multiple numbers.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The list of phone numbers for the contact.</p>
    pub phone_numbers: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
    /// <p>The list of SIP addresses for the contact.</p>
    pub sip_addresses: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
}
impl std::fmt::Debug for ContactData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactData");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("first_name", &self.first_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("phone_numbers", &self.phone_numbers);
        formatter.field("sip_addresses", &self.sip_addresses);
        formatter.finish()
    }
}
/// See [`ContactData`](crate::model::ContactData)
pub mod contact_data {
    /// A builder for [`ContactData`](crate::model::ContactData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) phone_numbers: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        pub(crate) sip_addresses: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
    }
    impl Builder {
        /// <p>The ARN of the contact.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The name of the contact to display on the console.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the contact to display on the console.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The first name of the contact, used to call the contact on the device.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name of the contact, used to call the contact on the device.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name of the contact, used to call the contact on the device.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name of the contact, used to call the contact on the device.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The phone number of the contact. The phone number type defaults to WORK. You can
        /// specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you
        /// specify the phone number type and multiple numbers.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number of the contact. The phone number type defaults to WORK. You can
        /// specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you
        /// specify the phone number type and multiple numbers.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// Appends an item to `phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_phone_numbers`](Self::set_phone_numbers).
        ///
        /// <p>The list of phone numbers for the contact.</p>
        pub fn phone_numbers(mut self, input: impl Into<crate::model::PhoneNumber>) -> Self {
            let mut v = self.phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.phone_numbers = Some(v);
            self
        }
        /// <p>The list of phone numbers for the contact.</p>
        pub fn set_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        ) -> Self {
            self.phone_numbers = input;
            self
        }
        /// Appends an item to `sip_addresses`.
        ///
        /// To override the contents of this collection use [`set_sip_addresses`](Self::set_sip_addresses).
        ///
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn sip_addresses(mut self, input: impl Into<crate::model::SipAddress>) -> Self {
            let mut v = self.sip_addresses.unwrap_or_default();
            v.push(input.into());
            self.sip_addresses = Some(v);
            self
        }
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn set_sip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
        ) -> Self {
            self.sip_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactData`](crate::model::ContactData)
        pub fn build(self) -> crate::model::ContactData {
            crate::model::ContactData {
                contact_arn: self.contact_arn,
                display_name: self.display_name,
                first_name: self.first_name,
                last_name: self.last_name,
                phone_number: self.phone_number,
                phone_numbers: self.phone_numbers,
                sip_addresses: self.sip_addresses,
            }
        }
    }
}
impl ContactData {
    /// Creates a new builder-style object to manufacture [`ContactData`](crate::model::ContactData)
    pub fn builder() -> crate::model::contact_data::Builder {
        crate::model::contact_data::Builder::default()
    }
}

/// <p>Information related to an address book.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddressBookData {
    /// <p>The ARN of the address book.</p>
    pub address_book_arn: std::option::Option<std::string::String>,
    /// <p>The name of the address book.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the address book.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AddressBookData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddressBookData");
        formatter.field("address_book_arn", &self.address_book_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`AddressBookData`](crate::model::AddressBookData)
pub mod address_book_data {
    /// A builder for [`AddressBookData`](crate::model::AddressBookData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address_book_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the address book.</p>
        pub fn address_book_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_book_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the address book.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_book_arn = input;
            self
        }
        /// <p>The name of the address book.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the address book.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the address book.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the address book.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`AddressBookData`](crate::model::AddressBookData)
        pub fn build(self) -> crate::model::AddressBookData {
            crate::model::AddressBookData {
                address_book_arn: self.address_book_arn,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl AddressBookData {
    /// Creates a new builder-style object to manufacture [`AddressBookData`](crate::model::AddressBookData)
    pub fn builder() -> crate::model::address_book_data::Builder {
        crate::model::address_book_data::Builder::default()
    }
}

/// <p>A skill parameter associated with a room.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoomSkillParameter {
    /// <p>The parameter key of a room skill parameter. ParameterKey is an enumerated type that
    /// only takes “DEFAULT” or “SCOPE” as valid values.</p>
    pub parameter_key: std::option::Option<std::string::String>,
    /// <p>The parameter value of a room skill parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RoomSkillParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoomSkillParameter");
        formatter.field("parameter_key", &self.parameter_key);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.finish()
    }
}
/// See [`RoomSkillParameter`](crate::model::RoomSkillParameter)
pub mod room_skill_parameter {
    /// A builder for [`RoomSkillParameter`](crate::model::RoomSkillParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_key: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The parameter key of a room skill parameter. ParameterKey is an enumerated type that
        /// only takes “DEFAULT” or “SCOPE” as valid values.</p>
        pub fn parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_key = Some(input.into());
            self
        }
        /// <p>The parameter key of a room skill parameter. ParameterKey is an enumerated type that
        /// only takes “DEFAULT” or “SCOPE” as valid values.</p>
        pub fn set_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_key = input;
            self
        }
        /// <p>The parameter value of a room skill parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The parameter value of a room skill parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// Consumes the builder and constructs a [`RoomSkillParameter`](crate::model::RoomSkillParameter)
        pub fn build(self) -> crate::model::RoomSkillParameter {
            crate::model::RoomSkillParameter {
                parameter_key: self.parameter_key,
                parameter_value: self.parameter_value,
            }
        }
    }
}
impl RoomSkillParameter {
    /// Creates a new builder-style object to manufacture [`RoomSkillParameter`](crate::model::RoomSkillParameter)
    pub fn builder() -> crate::model::room_skill_parameter::Builder {
        crate::model::room_skill_parameter::Builder::default()
    }
}

/// <p>The default conference provider that is used if no other scheduled meetings are
/// detected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConferencePreference {
    /// <p>The ARN of the default conference provider.</p>
    pub default_conference_provider_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConferencePreference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConferencePreference");
        formatter.field(
            "default_conference_provider_arn",
            &self.default_conference_provider_arn,
        );
        formatter.finish()
    }
}
/// See [`ConferencePreference`](crate::model::ConferencePreference)
pub mod conference_preference {
    /// A builder for [`ConferencePreference`](crate::model::ConferencePreference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_conference_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the default conference provider.</p>
        pub fn default_conference_provider_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_conference_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the default conference provider.</p>
        pub fn set_default_conference_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_conference_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ConferencePreference`](crate::model::ConferencePreference)
        pub fn build(self) -> crate::model::ConferencePreference {
            crate::model::ConferencePreference {
                default_conference_provider_arn: self.default_conference_provider_arn,
            }
        }
    }
}
impl ConferencePreference {
    /// Creates a new builder-style object to manufacture [`ConferencePreference`](crate::model::ConferencePreference)
    pub fn builder() -> crate::model::conference_preference::Builder {
        crate::model::conference_preference::Builder::default()
    }
}

/// <p>A smart home appliance that can connect to a central system. Any domestic device can be
/// a smart appliance. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmartHomeAppliance {
    /// <p>The friendly name of the smart home appliance.</p>
    pub friendly_name: std::option::Option<std::string::String>,
    /// <p>The description of the smart home appliance.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the manufacturer of the smart home appliance.</p>
    pub manufacturer_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SmartHomeAppliance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmartHomeAppliance");
        formatter.field("friendly_name", &self.friendly_name);
        formatter.field("description", &self.description);
        formatter.field("manufacturer_name", &self.manufacturer_name);
        formatter.finish()
    }
}
/// See [`SmartHomeAppliance`](crate::model::SmartHomeAppliance)
pub mod smart_home_appliance {
    /// A builder for [`SmartHomeAppliance`](crate::model::SmartHomeAppliance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) friendly_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) manufacturer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The friendly name of the smart home appliance.</p>
        pub fn friendly_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.friendly_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the smart home appliance.</p>
        pub fn set_friendly_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.friendly_name = input;
            self
        }
        /// <p>The description of the smart home appliance.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the smart home appliance.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the manufacturer of the smart home appliance.</p>
        pub fn manufacturer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manufacturer_name = Some(input.into());
            self
        }
        /// <p>The name of the manufacturer of the smart home appliance.</p>
        pub fn set_manufacturer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manufacturer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SmartHomeAppliance`](crate::model::SmartHomeAppliance)
        pub fn build(self) -> crate::model::SmartHomeAppliance {
            crate::model::SmartHomeAppliance {
                friendly_name: self.friendly_name,
                description: self.description,
                manufacturer_name: self.manufacturer_name,
            }
        }
    }
}
impl SmartHomeAppliance {
    /// Creates a new builder-style object to manufacture [`SmartHomeAppliance`](crate::model::SmartHomeAppliance)
    pub fn builder() -> crate::model::smart_home_appliance::Builder {
        crate::model::smart_home_appliance::Builder::default()
    }
}

/// <p>The detailed information about an Alexa skill.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SkillsStoreSkill {
    /// <p>The ARN of the skill.</p>
    pub skill_id: std::option::Option<std::string::String>,
    /// <p>The name of the skill.</p>
    pub skill_name: std::option::Option<std::string::String>,
    /// <p>Short description about the skill.</p>
    pub short_description: std::option::Option<std::string::String>,
    /// <p>The URL where the skill icon resides.</p>
    pub icon_url: std::option::Option<std::string::String>,
    /// <p>Sample utterances that interact with the skill.</p>
    pub sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about the skill.</p>
    pub skill_details: std::option::Option<crate::model::SkillDetails>,
    /// <p>Linking support for a skill.</p>
    pub supports_linking: bool,
}
impl std::fmt::Debug for SkillsStoreSkill {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SkillsStoreSkill");
        formatter.field("skill_id", &self.skill_id);
        formatter.field("skill_name", &self.skill_name);
        formatter.field("short_description", &self.short_description);
        formatter.field("icon_url", &self.icon_url);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("skill_details", &self.skill_details);
        formatter.field("supports_linking", &self.supports_linking);
        formatter.finish()
    }
}
/// See [`SkillsStoreSkill`](crate::model::SkillsStoreSkill)
pub mod skills_store_skill {
    /// A builder for [`SkillsStoreSkill`](crate::model::SkillsStoreSkill)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_id: std::option::Option<std::string::String>,
        pub(crate) skill_name: std::option::Option<std::string::String>,
        pub(crate) short_description: std::option::Option<std::string::String>,
        pub(crate) icon_url: std::option::Option<std::string::String>,
        pub(crate) sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) skill_details: std::option::Option<crate::model::SkillDetails>,
        pub(crate) supports_linking: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the skill.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The ARN of the skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// <p>The name of the skill.</p>
        pub fn skill_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_name = Some(input.into());
            self
        }
        /// <p>The name of the skill.</p>
        pub fn set_skill_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_name = input;
            self
        }
        /// <p>Short description about the skill.</p>
        pub fn short_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_description = Some(input.into());
            self
        }
        /// <p>Short description about the skill.</p>
        pub fn set_short_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.short_description = input;
            self
        }
        /// <p>The URL where the skill icon resides.</p>
        pub fn icon_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.icon_url = Some(input.into());
            self
        }
        /// <p>The URL where the skill icon resides.</p>
        pub fn set_icon_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.icon_url = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>Sample utterances that interact with the skill.</p>
        pub fn sample_utterances(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input.into());
            self.sample_utterances = Some(v);
            self
        }
        /// <p>Sample utterances that interact with the skill.</p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>Information about the skill.</p>
        pub fn skill_details(mut self, input: crate::model::SkillDetails) -> Self {
            self.skill_details = Some(input);
            self
        }
        /// <p>Information about the skill.</p>
        pub fn set_skill_details(
            mut self,
            input: std::option::Option<crate::model::SkillDetails>,
        ) -> Self {
            self.skill_details = input;
            self
        }
        /// <p>Linking support for a skill.</p>
        pub fn supports_linking(mut self, input: bool) -> Self {
            self.supports_linking = Some(input);
            self
        }
        /// <p>Linking support for a skill.</p>
        pub fn set_supports_linking(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_linking = input;
            self
        }
        /// Consumes the builder and constructs a [`SkillsStoreSkill`](crate::model::SkillsStoreSkill)
        pub fn build(self) -> crate::model::SkillsStoreSkill {
            crate::model::SkillsStoreSkill {
                skill_id: self.skill_id,
                skill_name: self.skill_name,
                short_description: self.short_description,
                icon_url: self.icon_url,
                sample_utterances: self.sample_utterances,
                skill_details: self.skill_details,
                supports_linking: self.supports_linking.unwrap_or_default(),
            }
        }
    }
}
impl SkillsStoreSkill {
    /// Creates a new builder-style object to manufacture [`SkillsStoreSkill`](crate::model::SkillsStoreSkill)
    pub fn builder() -> crate::model::skills_store_skill::Builder {
        crate::model::skills_store_skill::Builder::default()
    }
}

/// <p>Granular information about the skill.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SkillDetails {
    /// <p>The description of the product.</p>
    pub product_description: std::option::Option<std::string::String>,
    /// <p>The phrase used to trigger the skill.</p>
    pub invocation_phrase: std::option::Option<std::string::String>,
    /// <p>The date when the skill was released.</p>
    pub release_date: std::option::Option<std::string::String>,
    /// <p>The URL of the end user license agreement.</p>
    pub end_user_license_agreement: std::option::Option<std::string::String>,
    /// <p>The generic keywords associated with the skill that can be used to find a
    /// skill.</p>
    pub generic_keywords: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The details about what the skill supports organized as bullet points.</p>
    pub bullet_points: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The updates added in bullet points.</p>
    pub new_in_this_version_bullet_points: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The types of skills.</p>
    pub skill_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// <i>This member has been deprecated.</i>
    /// </p>
    /// <p>The list of reviews for the skill, including Key and Value pair.</p>
    pub reviews:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The details about the developer that published the skill.</p>
    pub developer_info: std::option::Option<crate::model::DeveloperInfo>,
}
impl std::fmt::Debug for SkillDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SkillDetails");
        formatter.field("product_description", &self.product_description);
        formatter.field("invocation_phrase", &self.invocation_phrase);
        formatter.field("release_date", &self.release_date);
        formatter.field(
            "end_user_license_agreement",
            &self.end_user_license_agreement,
        );
        formatter.field("generic_keywords", &self.generic_keywords);
        formatter.field("bullet_points", &self.bullet_points);
        formatter.field(
            "new_in_this_version_bullet_points",
            &self.new_in_this_version_bullet_points,
        );
        formatter.field("skill_types", &self.skill_types);
        formatter.field("reviews", &self.reviews);
        formatter.field("developer_info", &self.developer_info);
        formatter.finish()
    }
}
/// See [`SkillDetails`](crate::model::SkillDetails)
pub mod skill_details {
    /// A builder for [`SkillDetails`](crate::model::SkillDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_description: std::option::Option<std::string::String>,
        pub(crate) invocation_phrase: std::option::Option<std::string::String>,
        pub(crate) release_date: std::option::Option<std::string::String>,
        pub(crate) end_user_license_agreement: std::option::Option<std::string::String>,
        pub(crate) generic_keywords: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) bullet_points: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) new_in_this_version_bullet_points:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) skill_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) reviews: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) developer_info: std::option::Option<crate::model::DeveloperInfo>,
    }
    impl Builder {
        /// <p>The description of the product.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_description = Some(input.into());
            self
        }
        /// <p>The description of the product.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_description = input;
            self
        }
        /// <p>The phrase used to trigger the skill.</p>
        pub fn invocation_phrase(mut self, input: impl Into<std::string::String>) -> Self {
            self.invocation_phrase = Some(input.into());
            self
        }
        /// <p>The phrase used to trigger the skill.</p>
        pub fn set_invocation_phrase(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invocation_phrase = input;
            self
        }
        /// <p>The date when the skill was released.</p>
        pub fn release_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.release_date = Some(input.into());
            self
        }
        /// <p>The date when the skill was released.</p>
        pub fn set_release_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.release_date = input;
            self
        }
        /// <p>The URL of the end user license agreement.</p>
        pub fn end_user_license_agreement(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_user_license_agreement = Some(input.into());
            self
        }
        /// <p>The URL of the end user license agreement.</p>
        pub fn set_end_user_license_agreement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.end_user_license_agreement = input;
            self
        }
        /// Appends an item to `generic_keywords`.
        ///
        /// To override the contents of this collection use [`set_generic_keywords`](Self::set_generic_keywords).
        ///
        /// <p>The generic keywords associated with the skill that can be used to find a
        /// skill.</p>
        pub fn generic_keywords(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.generic_keywords.unwrap_or_default();
            v.push(input.into());
            self.generic_keywords = Some(v);
            self
        }
        /// <p>The generic keywords associated with the skill that can be used to find a
        /// skill.</p>
        pub fn set_generic_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.generic_keywords = input;
            self
        }
        /// Appends an item to `bullet_points`.
        ///
        /// To override the contents of this collection use [`set_bullet_points`](Self::set_bullet_points).
        ///
        /// <p>The details about what the skill supports organized as bullet points.</p>
        pub fn bullet_points(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bullet_points.unwrap_or_default();
            v.push(input.into());
            self.bullet_points = Some(v);
            self
        }
        /// <p>The details about what the skill supports organized as bullet points.</p>
        pub fn set_bullet_points(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bullet_points = input;
            self
        }
        /// Appends an item to `new_in_this_version_bullet_points`.
        ///
        /// To override the contents of this collection use [`set_new_in_this_version_bullet_points`](Self::set_new_in_this_version_bullet_points).
        ///
        /// <p>The updates added in bullet points.</p>
        pub fn new_in_this_version_bullet_points(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.new_in_this_version_bullet_points.unwrap_or_default();
            v.push(input.into());
            self.new_in_this_version_bullet_points = Some(v);
            self
        }
        /// <p>The updates added in bullet points.</p>
        pub fn set_new_in_this_version_bullet_points(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.new_in_this_version_bullet_points = input;
            self
        }
        /// Appends an item to `skill_types`.
        ///
        /// To override the contents of this collection use [`set_skill_types`](Self::set_skill_types).
        ///
        /// <p>The types of skills.</p>
        pub fn skill_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.skill_types.unwrap_or_default();
            v.push(input.into());
            self.skill_types = Some(v);
            self
        }
        /// <p>The types of skills.</p>
        pub fn set_skill_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.skill_types = input;
            self
        }
        /// Adds a key-value pair to `reviews`.
        ///
        /// To override the contents of this collection use [`set_reviews`](Self::set_reviews).
        ///
        /// <p>
        /// <i>This member has been deprecated.</i>
        /// </p>
        /// <p>The list of reviews for the skill, including Key and Value pair.</p>
        pub fn reviews(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.reviews.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.reviews = Some(hash_map);
            self
        }
        /// <p>
        /// <i>This member has been deprecated.</i>
        /// </p>
        /// <p>The list of reviews for the skill, including Key and Value pair.</p>
        pub fn set_reviews(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.reviews = input;
            self
        }
        /// <p>The details about the developer that published the skill.</p>
        pub fn developer_info(mut self, input: crate::model::DeveloperInfo) -> Self {
            self.developer_info = Some(input);
            self
        }
        /// <p>The details about the developer that published the skill.</p>
        pub fn set_developer_info(
            mut self,
            input: std::option::Option<crate::model::DeveloperInfo>,
        ) -> Self {
            self.developer_info = input;
            self
        }
        /// Consumes the builder and constructs a [`SkillDetails`](crate::model::SkillDetails)
        pub fn build(self) -> crate::model::SkillDetails {
            crate::model::SkillDetails {
                product_description: self.product_description,
                invocation_phrase: self.invocation_phrase,
                release_date: self.release_date,
                end_user_license_agreement: self.end_user_license_agreement,
                generic_keywords: self.generic_keywords,
                bullet_points: self.bullet_points,
                new_in_this_version_bullet_points: self.new_in_this_version_bullet_points,
                skill_types: self.skill_types,
                reviews: self.reviews,
                developer_info: self.developer_info,
            }
        }
    }
}
impl SkillDetails {
    /// Creates a new builder-style object to manufacture [`SkillDetails`](crate::model::SkillDetails)
    pub fn builder() -> crate::model::skill_details::Builder {
        crate::model::skill_details::Builder::default()
    }
}

/// <p>The details about the developer that published the skill.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeveloperInfo {
    /// <p>The name of the developer.</p>
    pub developer_name: std::option::Option<std::string::String>,
    /// <p>The URL of the privacy policy.</p>
    pub privacy_policy: std::option::Option<std::string::String>,
    /// <p>The email of the developer.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The website of the developer.</p>
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeveloperInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeveloperInfo");
        formatter.field("developer_name", &self.developer_name);
        formatter.field("privacy_policy", &self.privacy_policy);
        formatter.field("email", &self.email);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`DeveloperInfo`](crate::model::DeveloperInfo)
pub mod developer_info {
    /// A builder for [`DeveloperInfo`](crate::model::DeveloperInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) developer_name: std::option::Option<std::string::String>,
        pub(crate) privacy_policy: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the developer.</p>
        pub fn developer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_name = Some(input.into());
            self
        }
        /// <p>The name of the developer.</p>
        pub fn set_developer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_name = input;
            self
        }
        /// <p>The URL of the privacy policy.</p>
        pub fn privacy_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.privacy_policy = Some(input.into());
            self
        }
        /// <p>The URL of the privacy policy.</p>
        pub fn set_privacy_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.privacy_policy = input;
            self
        }
        /// <p>The email of the developer.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email of the developer.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The website of the developer.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The website of the developer.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`DeveloperInfo`](crate::model::DeveloperInfo)
        pub fn build(self) -> crate::model::DeveloperInfo {
            crate::model::DeveloperInfo {
                developer_name: self.developer_name,
                privacy_policy: self.privacy_policy,
                email: self.email,
                url: self.url,
            }
        }
    }
}
impl DeveloperInfo {
    /// Creates a new builder-style object to manufacture [`DeveloperInfo`](crate::model::DeveloperInfo)
    pub fn builder() -> crate::model::developer_info::Builder {
        crate::model::developer_info::Builder::default()
    }
}

/// <p>The skill store category that is shown. Alexa skills are assigned a specific skill
/// category during creation, such as News, Social, and Sports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Category {
    /// <p>The ID of the skill store category.</p>
    pub category_id: std::option::Option<i64>,
    /// <p>The name of the skill store category.</p>
    pub category_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Category {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Category");
        formatter.field("category_id", &self.category_id);
        formatter.field("category_name", &self.category_name);
        formatter.finish()
    }
}
/// See [`Category`](crate::model::Category)
pub mod category {
    /// A builder for [`Category`](crate::model::Category)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category_id: std::option::Option<i64>,
        pub(crate) category_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the skill store category.</p>
        pub fn category_id(mut self, input: i64) -> Self {
            self.category_id = Some(input);
            self
        }
        /// <p>The ID of the skill store category.</p>
        pub fn set_category_id(mut self, input: std::option::Option<i64>) -> Self {
            self.category_id = input;
            self
        }
        /// <p>The name of the skill store category.</p>
        pub fn category_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.category_name = Some(input.into());
            self
        }
        /// <p>The name of the skill store category.</p>
        pub fn set_category_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.category_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Category`](crate::model::Category)
        pub fn build(self) -> crate::model::Category {
            crate::model::Category {
                category_id: self.category_id,
                category_name: self.category_name,
            }
        }
    }
}
impl Category {
    /// Creates a new builder-style object to manufacture [`Category`](crate::model::Category)
    pub fn builder() -> crate::model::category::Builder {
        crate::model::category::Builder::default()
    }
}

/// <p>The summary of skills.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SkillSummary {
    /// <p>The ARN of the skill summary.</p>
    pub skill_id: std::option::Option<std::string::String>,
    /// <p>The name of the skill.</p>
    pub skill_name: std::option::Option<std::string::String>,
    /// <p>Linking support for a skill.</p>
    pub supports_linking: bool,
    /// <p>Whether the skill is enabled under the user's account, or if it requires linking to be
    /// used.</p>
    pub enablement_type: std::option::Option<crate::model::EnablementType>,
    /// <p>Whether the skill is publicly available or is a private skill.</p>
    pub skill_type: std::option::Option<crate::model::SkillType>,
}
impl std::fmt::Debug for SkillSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SkillSummary");
        formatter.field("skill_id", &self.skill_id);
        formatter.field("skill_name", &self.skill_name);
        formatter.field("supports_linking", &self.supports_linking);
        formatter.field("enablement_type", &self.enablement_type);
        formatter.field("skill_type", &self.skill_type);
        formatter.finish()
    }
}
/// See [`SkillSummary`](crate::model::SkillSummary)
pub mod skill_summary {
    /// A builder for [`SkillSummary`](crate::model::SkillSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_id: std::option::Option<std::string::String>,
        pub(crate) skill_name: std::option::Option<std::string::String>,
        pub(crate) supports_linking: std::option::Option<bool>,
        pub(crate) enablement_type: std::option::Option<crate::model::EnablementType>,
        pub(crate) skill_type: std::option::Option<crate::model::SkillType>,
    }
    impl Builder {
        /// <p>The ARN of the skill summary.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The ARN of the skill summary.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// <p>The name of the skill.</p>
        pub fn skill_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_name = Some(input.into());
            self
        }
        /// <p>The name of the skill.</p>
        pub fn set_skill_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_name = input;
            self
        }
        /// <p>Linking support for a skill.</p>
        pub fn supports_linking(mut self, input: bool) -> Self {
            self.supports_linking = Some(input);
            self
        }
        /// <p>Linking support for a skill.</p>
        pub fn set_supports_linking(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_linking = input;
            self
        }
        /// <p>Whether the skill is enabled under the user's account, or if it requires linking to be
        /// used.</p>
        pub fn enablement_type(mut self, input: crate::model::EnablementType) -> Self {
            self.enablement_type = Some(input);
            self
        }
        /// <p>Whether the skill is enabled under the user's account, or if it requires linking to be
        /// used.</p>
        pub fn set_enablement_type(
            mut self,
            input: std::option::Option<crate::model::EnablementType>,
        ) -> Self {
            self.enablement_type = input;
            self
        }
        /// <p>Whether the skill is publicly available or is a private skill.</p>
        pub fn skill_type(mut self, input: crate::model::SkillType) -> Self {
            self.skill_type = Some(input);
            self
        }
        /// <p>Whether the skill is publicly available or is a private skill.</p>
        pub fn set_skill_type(
            mut self,
            input: std::option::Option<crate::model::SkillType>,
        ) -> Self {
            self.skill_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SkillSummary`](crate::model::SkillSummary)
        pub fn build(self) -> crate::model::SkillSummary {
            crate::model::SkillSummary {
                skill_id: self.skill_id,
                skill_name: self.skill_name,
                supports_linking: self.supports_linking.unwrap_or_default(),
                enablement_type: self.enablement_type,
                skill_type: self.skill_type,
            }
        }
    }
}
impl SkillSummary {
    /// Creates a new builder-style object to manufacture [`SkillSummary`](crate::model::SkillSummary)
    pub fn builder() -> crate::model::skill_summary::Builder {
        crate::model::skill_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SkillType {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SkillType {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE" => SkillType::Private,
            "PUBLIC" => SkillType::Public,
            other => SkillType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SkillType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SkillType::from(s))
    }
}
impl SkillType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SkillType::Private => "PRIVATE",
            SkillType::Public => "PUBLIC",
            SkillType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE", "PUBLIC"]
    }
}
impl AsRef<str> for SkillType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnablementType {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnablementType {
    fn from(s: &str) -> Self {
        match s {
            "ENABLED" => EnablementType::Enabled,
            "PENDING" => EnablementType::Pending,
            other => EnablementType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnablementType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnablementType::from(s))
    }
}
impl EnablementType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnablementType::Enabled => "ENABLED",
            EnablementType::Pending => "PENDING",
            EnablementType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENABLED", "PENDING"]
    }
}
impl AsRef<str> for EnablementType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SkillTypeFilter {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SkillTypeFilter {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => SkillTypeFilter::All,
            "PRIVATE" => SkillTypeFilter::Private,
            "PUBLIC" => SkillTypeFilter::Public,
            other => SkillTypeFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SkillTypeFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SkillTypeFilter::from(s))
    }
}
impl SkillTypeFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SkillTypeFilter::All => "ALL",
            SkillTypeFilter::Private => "PRIVATE",
            SkillTypeFilter::Public => "PUBLIC",
            SkillTypeFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "PRIVATE", "PUBLIC"]
    }
}
impl AsRef<str> for SkillTypeFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnablementTypeFilter {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnablementTypeFilter {
    fn from(s: &str) -> Self {
        match s {
            "ENABLED" => EnablementTypeFilter::Enabled,
            "PENDING" => EnablementTypeFilter::Pending,
            other => EnablementTypeFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnablementTypeFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnablementTypeFilter::from(s))
    }
}
impl EnablementTypeFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnablementTypeFilter::Enabled => "ENABLED",
            EnablementTypeFilter::Pending => "PENDING",
            EnablementTypeFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENABLED", "PENDING"]
    }
}
impl AsRef<str> for EnablementTypeFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The summary of a gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewaySummary {
    /// <p>The ARN of the gateway.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the gateway.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the gateway.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the gateway group that the gateway is associated to.</p>
    pub gateway_group_arn: std::option::Option<std::string::String>,
    /// <p>The software version of the gateway. The gateway automatically updates its software
    /// version during normal operation.</p>
    pub software_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GatewaySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewaySummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("gateway_group_arn", &self.gateway_group_arn);
        formatter.field("software_version", &self.software_version);
        formatter.finish()
    }
}
/// See [`GatewaySummary`](crate::model::GatewaySummary)
pub mod gateway_summary {
    /// A builder for [`GatewaySummary`](crate::model::GatewaySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) gateway_group_arn: std::option::Option<std::string::String>,
        pub(crate) software_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the gateway.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the gateway.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the gateway.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the gateway.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the gateway.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the gateway group that the gateway is associated to.</p>
        pub fn gateway_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway group that the gateway is associated to.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_group_arn = input;
            self
        }
        /// <p>The software version of the gateway. The gateway automatically updates its software
        /// version during normal operation.</p>
        pub fn software_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.software_version = Some(input.into());
            self
        }
        /// <p>The software version of the gateway. The gateway automatically updates its software
        /// version during normal operation.</p>
        pub fn set_software_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.software_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewaySummary`](crate::model::GatewaySummary)
        pub fn build(self) -> crate::model::GatewaySummary {
            crate::model::GatewaySummary {
                arn: self.arn,
                name: self.name,
                description: self.description,
                gateway_group_arn: self.gateway_group_arn,
                software_version: self.software_version,
            }
        }
    }
}
impl GatewaySummary {
    /// Creates a new builder-style object to manufacture [`GatewaySummary`](crate::model::GatewaySummary)
    pub fn builder() -> crate::model::gateway_summary::Builder {
        crate::model::gateway_summary::Builder::default()
    }
}

/// <p>The summary of a gateway group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayGroupSummary {
    /// <p>The ARN of the gateway group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the gateway group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the gateway group.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GatewayGroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayGroupSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`GatewayGroupSummary`](crate::model::GatewayGroupSummary)
pub mod gateway_group_summary {
    /// A builder for [`GatewayGroupSummary`](crate::model::GatewayGroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the gateway group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the gateway group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the gateway group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the gateway group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the gateway group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayGroupSummary`](crate::model::GatewayGroupSummary)
        pub fn build(self) -> crate::model::GatewayGroupSummary {
            crate::model::GatewayGroupSummary {
                arn: self.arn,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl GatewayGroupSummary {
    /// Creates a new builder-style object to manufacture [`GatewayGroupSummary`](crate::model::GatewayGroupSummary)
    pub fn builder() -> crate::model::gateway_group_summary::Builder {
        crate::model::gateway_group_summary::Builder::default()
    }
}

/// <p>The list of device events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceEvent {
    /// <p>The type of device event.</p>
    pub r#type: std::option::Option<crate::model::DeviceEventType>,
    /// <p>The value of the event.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The time (in epoch) when the event occurred. </p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DeviceEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceEvent");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.field("timestamp", &self.timestamp);
        formatter.finish()
    }
}
/// See [`DeviceEvent`](crate::model::DeviceEvent)
pub mod device_event {
    /// A builder for [`DeviceEvent`](crate::model::DeviceEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DeviceEventType>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The type of device event.</p>
        pub fn r#type(mut self, input: crate::model::DeviceEventType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of device event.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DeviceEventType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value of the event.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the event.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The time (in epoch) when the event occurred. </p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time (in epoch) when the event occurred. </p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceEvent`](crate::model::DeviceEvent)
        pub fn build(self) -> crate::model::DeviceEvent {
            crate::model::DeviceEvent {
                r#type: self.r#type,
                value: self.value,
                timestamp: self.timestamp,
            }
        }
    }
}
impl DeviceEvent {
    /// Creates a new builder-style object to manufacture [`DeviceEvent`](crate::model::DeviceEvent)
    pub fn builder() -> crate::model::device_event::Builder {
        crate::model::device_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceEventType {
    #[allow(missing_docs)] // documentation missing in model
    ConnectionStatus,
    #[allow(missing_docs)] // documentation missing in model
    DeviceStatus,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceEventType {
    fn from(s: &str) -> Self {
        match s {
            "CONNECTION_STATUS" => DeviceEventType::ConnectionStatus,
            "DEVICE_STATUS" => DeviceEventType::DeviceStatus,
            other => DeviceEventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceEventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceEventType::from(s))
    }
}
impl DeviceEventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceEventType::ConnectionStatus => "CONNECTION_STATUS",
            DeviceEventType::DeviceStatus => "DEVICE_STATUS",
            DeviceEventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECTION_STATUS", "DEVICE_STATUS"]
    }
}
impl AsRef<str> for DeviceEventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An entity that provides a conferencing solution. Alexa for Business acts as the voice interface and mediator that connects users to their preferred conference provider. Examples of conference providers include Amazon Chime, Zoom, Cisco, and Polycom. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConferenceProvider {
    /// <p>The ARN of the newly created conference provider.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the conference provider.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of conference providers.</p>
    pub r#type: std::option::Option<crate::model::ConferenceProviderType>,
    /// <p>The IP endpoint and protocol for calling.</p>
    pub ip_dial_in: std::option::Option<crate::model::IpDialIn>,
    /// <p>The information for PSTN conferencing.</p>
    pub pstn_dial_in: std::option::Option<crate::model::PstnDialIn>,
    /// <p>The meeting settings for the conference provider.</p>
    pub meeting_setting: std::option::Option<crate::model::MeetingSetting>,
}
impl std::fmt::Debug for ConferenceProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConferenceProvider");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("ip_dial_in", &self.ip_dial_in);
        formatter.field("pstn_dial_in", &self.pstn_dial_in);
        formatter.field("meeting_setting", &self.meeting_setting);
        formatter.finish()
    }
}
/// See [`ConferenceProvider`](crate::model::ConferenceProvider)
pub mod conference_provider {
    /// A builder for [`ConferenceProvider`](crate::model::ConferenceProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ConferenceProviderType>,
        pub(crate) ip_dial_in: std::option::Option<crate::model::IpDialIn>,
        pub(crate) pstn_dial_in: std::option::Option<crate::model::PstnDialIn>,
        pub(crate) meeting_setting: std::option::Option<crate::model::MeetingSetting>,
    }
    impl Builder {
        /// <p>The ARN of the newly created conference provider.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the newly created conference provider.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the conference provider.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the conference provider.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of conference providers.</p>
        pub fn r#type(mut self, input: crate::model::ConferenceProviderType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of conference providers.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ConferenceProviderType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn ip_dial_in(mut self, input: crate::model::IpDialIn) -> Self {
            self.ip_dial_in = Some(input);
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn set_ip_dial_in(
            mut self,
            input: std::option::Option<crate::model::IpDialIn>,
        ) -> Self {
            self.ip_dial_in = input;
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn pstn_dial_in(mut self, input: crate::model::PstnDialIn) -> Self {
            self.pstn_dial_in = Some(input);
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn set_pstn_dial_in(
            mut self,
            input: std::option::Option<crate::model::PstnDialIn>,
        ) -> Self {
            self.pstn_dial_in = input;
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn meeting_setting(mut self, input: crate::model::MeetingSetting) -> Self {
            self.meeting_setting = Some(input);
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn set_meeting_setting(
            mut self,
            input: std::option::Option<crate::model::MeetingSetting>,
        ) -> Self {
            self.meeting_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`ConferenceProvider`](crate::model::ConferenceProvider)
        pub fn build(self) -> crate::model::ConferenceProvider {
            crate::model::ConferenceProvider {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                ip_dial_in: self.ip_dial_in,
                pstn_dial_in: self.pstn_dial_in,
                meeting_setting: self.meeting_setting,
            }
        }
    }
}
impl ConferenceProvider {
    /// Creates a new builder-style object to manufacture [`ConferenceProvider`](crate::model::ConferenceProvider)
    pub fn builder() -> crate::model::conference_provider::Builder {
        crate::model::conference_provider::Builder::default()
    }
}

/// <p>The schedule of the usage report.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BusinessReportSchedule {
    /// <p>The ARN of the business report schedule.</p>
    pub schedule_arn: std::option::Option<std::string::String>,
    /// <p>The name identifier of the schedule.</p>
    pub schedule_name: std::option::Option<std::string::String>,
    /// <p>The S3 bucket name of the output reports.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The S3 key where the report is delivered.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The format of the generated report (individual CSV files or zipped files of
    /// individual files).</p>
    pub format: std::option::Option<crate::model::BusinessReportFormat>,
    /// <p>The content range of the reports.</p>
    pub content_range: std::option::Option<crate::model::BusinessReportContentRange>,
    /// <p>The recurrence of the reports.</p>
    pub recurrence: std::option::Option<crate::model::BusinessReportRecurrence>,
    /// <p>The details of the last business report delivery for a specified time
    /// interval.</p>
    pub last_business_report: std::option::Option<crate::model::BusinessReport>,
}
impl std::fmt::Debug for BusinessReportSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BusinessReportSchedule");
        formatter.field("schedule_arn", &self.schedule_arn);
        formatter.field("schedule_name", &self.schedule_name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("format", &self.format);
        formatter.field("content_range", &self.content_range);
        formatter.field("recurrence", &self.recurrence);
        formatter.field("last_business_report", &self.last_business_report);
        formatter.finish()
    }
}
/// See [`BusinessReportSchedule`](crate::model::BusinessReportSchedule)
pub mod business_report_schedule {
    /// A builder for [`BusinessReportSchedule`](crate::model::BusinessReportSchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_arn: std::option::Option<std::string::String>,
        pub(crate) schedule_name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::BusinessReportFormat>,
        pub(crate) content_range: std::option::Option<crate::model::BusinessReportContentRange>,
        pub(crate) recurrence: std::option::Option<crate::model::BusinessReportRecurrence>,
        pub(crate) last_business_report: std::option::Option<crate::model::BusinessReport>,
    }
    impl Builder {
        /// <p>The ARN of the business report schedule.</p>
        pub fn schedule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the business report schedule.</p>
        pub fn set_schedule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule_arn = input;
            self
        }
        /// <p>The name identifier of the schedule.</p>
        pub fn schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_name = Some(input.into());
            self
        }
        /// <p>The name identifier of the schedule.</p>
        pub fn set_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_name = input;
            self
        }
        /// <p>The S3 bucket name of the output reports.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The S3 bucket name of the output reports.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn format(mut self, input: crate::model::BusinessReportFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::BusinessReportFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The content range of the reports.</p>
        pub fn content_range(mut self, input: crate::model::BusinessReportContentRange) -> Self {
            self.content_range = Some(input);
            self
        }
        /// <p>The content range of the reports.</p>
        pub fn set_content_range(
            mut self,
            input: std::option::Option<crate::model::BusinessReportContentRange>,
        ) -> Self {
            self.content_range = input;
            self
        }
        /// <p>The recurrence of the reports.</p>
        pub fn recurrence(mut self, input: crate::model::BusinessReportRecurrence) -> Self {
            self.recurrence = Some(input);
            self
        }
        /// <p>The recurrence of the reports.</p>
        pub fn set_recurrence(
            mut self,
            input: std::option::Option<crate::model::BusinessReportRecurrence>,
        ) -> Self {
            self.recurrence = input;
            self
        }
        /// <p>The details of the last business report delivery for a specified time
        /// interval.</p>
        pub fn last_business_report(mut self, input: crate::model::BusinessReport) -> Self {
            self.last_business_report = Some(input);
            self
        }
        /// <p>The details of the last business report delivery for a specified time
        /// interval.</p>
        pub fn set_last_business_report(
            mut self,
            input: std::option::Option<crate::model::BusinessReport>,
        ) -> Self {
            self.last_business_report = input;
            self
        }
        /// Consumes the builder and constructs a [`BusinessReportSchedule`](crate::model::BusinessReportSchedule)
        pub fn build(self) -> crate::model::BusinessReportSchedule {
            crate::model::BusinessReportSchedule {
                schedule_arn: self.schedule_arn,
                schedule_name: self.schedule_name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                format: self.format,
                content_range: self.content_range,
                recurrence: self.recurrence,
                last_business_report: self.last_business_report,
            }
        }
    }
}
impl BusinessReportSchedule {
    /// Creates a new builder-style object to manufacture [`BusinessReportSchedule`](crate::model::BusinessReportSchedule)
    pub fn builder() -> crate::model::business_report_schedule::Builder {
        crate::model::business_report_schedule::Builder::default()
    }
}

/// <p>Usage report with specified parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BusinessReport {
    /// <p>The status of the report generation execution (RUNNING, SUCCEEDED, or
    /// FAILED).</p>
    pub status: std::option::Option<crate::model::BusinessReportStatus>,
    /// <p>The failure code.</p>
    pub failure_code: std::option::Option<crate::model::BusinessReportFailureCode>,
    /// <p>The S3 location of the output reports.</p>
    pub s3_location: std::option::Option<crate::model::BusinessReportS3Location>,
    /// <p>The time of report delivery.</p>
    pub delivery_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The download link where a user can download the report.</p>
    pub download_url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BusinessReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BusinessReport");
        formatter.field("status", &self.status);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("s3_location", &self.s3_location);
        formatter.field("delivery_time", &self.delivery_time);
        formatter.field("download_url", &self.download_url);
        formatter.finish()
    }
}
/// See [`BusinessReport`](crate::model::BusinessReport)
pub mod business_report {
    /// A builder for [`BusinessReport`](crate::model::BusinessReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::BusinessReportStatus>,
        pub(crate) failure_code: std::option::Option<crate::model::BusinessReportFailureCode>,
        pub(crate) s3_location: std::option::Option<crate::model::BusinessReportS3Location>,
        pub(crate) delivery_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) download_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the report generation execution (RUNNING, SUCCEEDED, or
        /// FAILED).</p>
        pub fn status(mut self, input: crate::model::BusinessReportStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the report generation execution (RUNNING, SUCCEEDED, or
        /// FAILED).</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BusinessReportStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The failure code.</p>
        pub fn failure_code(mut self, input: crate::model::BusinessReportFailureCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::BusinessReportFailureCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The S3 location of the output reports.</p>
        pub fn s3_location(mut self, input: crate::model::BusinessReportS3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>The S3 location of the output reports.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::BusinessReportS3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// <p>The time of report delivery.</p>
        pub fn delivery_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.delivery_time = Some(input);
            self
        }
        /// <p>The time of report delivery.</p>
        pub fn set_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.delivery_time = input;
            self
        }
        /// <p>The download link where a user can download the report.</p>
        pub fn download_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.download_url = Some(input.into());
            self
        }
        /// <p>The download link where a user can download the report.</p>
        pub fn set_download_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.download_url = input;
            self
        }
        /// Consumes the builder and constructs a [`BusinessReport`](crate::model::BusinessReport)
        pub fn build(self) -> crate::model::BusinessReport {
            crate::model::BusinessReport {
                status: self.status,
                failure_code: self.failure_code,
                s3_location: self.s3_location,
                delivery_time: self.delivery_time,
                download_url: self.download_url,
            }
        }
    }
}
impl BusinessReport {
    /// Creates a new builder-style object to manufacture [`BusinessReport`](crate::model::BusinessReport)
    pub fn builder() -> crate::model::business_report::Builder {
        crate::model::business_report::Builder::default()
    }
}

/// <p>The S3 location of the output reports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BusinessReportS3Location {
    /// <p>The path of the business report.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The S3 bucket name of the output reports.</p>
    pub bucket_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BusinessReportS3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BusinessReportS3Location");
        formatter.field("path", &self.path);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.finish()
    }
}
/// See [`BusinessReportS3Location`](crate::model::BusinessReportS3Location)
pub mod business_report_s3_location {
    /// A builder for [`BusinessReportS3Location`](crate::model::BusinessReportS3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path of the business report.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path of the business report.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The S3 bucket name of the output reports.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The S3 bucket name of the output reports.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BusinessReportS3Location`](crate::model::BusinessReportS3Location)
        pub fn build(self) -> crate::model::BusinessReportS3Location {
            crate::model::BusinessReportS3Location {
                path: self.path,
                bucket_name: self.bucket_name,
            }
        }
    }
}
impl BusinessReportS3Location {
    /// Creates a new builder-style object to manufacture [`BusinessReportS3Location`](crate::model::BusinessReportS3Location)
    pub fn builder() -> crate::model::business_report_s3_location::Builder {
        crate::model::business_report_s3_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BusinessReportFailureCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    NoSuchBucket,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BusinessReportFailureCode {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => BusinessReportFailureCode::AccessDenied,
            "INTERNAL_FAILURE" => BusinessReportFailureCode::InternalFailure,
            "NO_SUCH_BUCKET" => BusinessReportFailureCode::NoSuchBucket,
            other => BusinessReportFailureCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BusinessReportFailureCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BusinessReportFailureCode::from(s))
    }
}
impl BusinessReportFailureCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BusinessReportFailureCode::AccessDenied => "ACCESS_DENIED",
            BusinessReportFailureCode::InternalFailure => "INTERNAL_FAILURE",
            BusinessReportFailureCode::NoSuchBucket => "NO_SUCH_BUCKET",
            BusinessReportFailureCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCESS_DENIED", "INTERNAL_FAILURE", "NO_SUCH_BUCKET"]
    }
}
impl AsRef<str> for BusinessReportFailureCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BusinessReportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BusinessReportStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => BusinessReportStatus::Failed,
            "RUNNING" => BusinessReportStatus::Running,
            "SUCCEEDED" => BusinessReportStatus::Succeeded,
            other => BusinessReportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BusinessReportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BusinessReportStatus::from(s))
    }
}
impl BusinessReportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BusinessReportStatus::Failed => "FAILED",
            BusinessReportStatus::Running => "RUNNING",
            BusinessReportStatus::Succeeded => "SUCCEEDED",
            BusinessReportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "RUNNING", "SUCCEEDED"]
    }
}
impl AsRef<str> for BusinessReportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The content range of the report.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BusinessReportContentRange {
    /// <p>The interval of the content range.</p>
    pub interval: std::option::Option<crate::model::BusinessReportInterval>,
}
impl std::fmt::Debug for BusinessReportContentRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BusinessReportContentRange");
        formatter.field("interval", &self.interval);
        formatter.finish()
    }
}
/// See [`BusinessReportContentRange`](crate::model::BusinessReportContentRange)
pub mod business_report_content_range {
    /// A builder for [`BusinessReportContentRange`](crate::model::BusinessReportContentRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interval: std::option::Option<crate::model::BusinessReportInterval>,
    }
    impl Builder {
        /// <p>The interval of the content range.</p>
        pub fn interval(mut self, input: crate::model::BusinessReportInterval) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The interval of the content range.</p>
        pub fn set_interval(
            mut self,
            input: std::option::Option<crate::model::BusinessReportInterval>,
        ) -> Self {
            self.interval = input;
            self
        }
        /// Consumes the builder and constructs a [`BusinessReportContentRange`](crate::model::BusinessReportContentRange)
        pub fn build(self) -> crate::model::BusinessReportContentRange {
            crate::model::BusinessReportContentRange {
                interval: self.interval,
            }
        }
    }
}
impl BusinessReportContentRange {
    /// Creates a new builder-style object to manufacture [`BusinessReportContentRange`](crate::model::BusinessReportContentRange)
    pub fn builder() -> crate::model::business_report_content_range::Builder {
        crate::model::business_report_content_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BusinessReportInterval {
    #[allow(missing_docs)] // documentation missing in model
    OneDay,
    #[allow(missing_docs)] // documentation missing in model
    OneWeek,
    #[allow(missing_docs)] // documentation missing in model
    ThirtyDays,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BusinessReportInterval {
    fn from(s: &str) -> Self {
        match s {
            "ONE_DAY" => BusinessReportInterval::OneDay,
            "ONE_WEEK" => BusinessReportInterval::OneWeek,
            "THIRTY_DAYS" => BusinessReportInterval::ThirtyDays,
            other => BusinessReportInterval::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BusinessReportInterval {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BusinessReportInterval::from(s))
    }
}
impl BusinessReportInterval {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BusinessReportInterval::OneDay => "ONE_DAY",
            BusinessReportInterval::OneWeek => "ONE_WEEK",
            BusinessReportInterval::ThirtyDays => "THIRTY_DAYS",
            BusinessReportInterval::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ONE_DAY", "ONE_WEEK", "THIRTY_DAYS"]
    }
}
impl AsRef<str> for BusinessReportInterval {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A skill group with attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SkillGroup {
    /// <p>The ARN of a skill group.</p>
    pub skill_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of a skill group.</p>
    pub skill_group_name: std::option::Option<std::string::String>,
    /// <p>The description of a skill group.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SkillGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SkillGroup");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.field("skill_group_name", &self.skill_group_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`SkillGroup`](crate::model::SkillGroup)
pub mod skill_group {
    /// A builder for [`SkillGroup`](crate::model::SkillGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
        pub(crate) skill_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a skill group.</p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a skill group.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// <p>The name of a skill group.</p>
        pub fn skill_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_name = Some(input.into());
            self
        }
        /// <p>The name of a skill group.</p>
        pub fn set_skill_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_name = input;
            self
        }
        /// <p>The description of a skill group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a skill group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`SkillGroup`](crate::model::SkillGroup)
        pub fn build(self) -> crate::model::SkillGroup {
            crate::model::SkillGroup {
                skill_group_arn: self.skill_group_arn,
                skill_group_name: self.skill_group_name,
                description: self.description,
            }
        }
    }
}
impl SkillGroup {
    /// Creates a new builder-style object to manufacture [`SkillGroup`](crate::model::SkillGroup)
    pub fn builder() -> crate::model::skill_group::Builder {
        crate::model::skill_group::Builder::default()
    }
}

/// <p>A room with attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Room {
    /// <p>The ARN of a room.</p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The name of a room.</p>
    pub room_name: std::option::Option<std::string::String>,
    /// <p>The description of a room.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The provider calendar ARN of a room.</p>
    pub provider_calendar_id: std::option::Option<std::string::String>,
    /// <p>The profile ARN of a room.</p>
    pub profile_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Room {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Room");
        formatter.field("room_arn", &self.room_arn);
        formatter.field("room_name", &self.room_name);
        formatter.field("description", &self.description);
        formatter.field("provider_calendar_id", &self.provider_calendar_id);
        formatter.field("profile_arn", &self.profile_arn);
        formatter.finish()
    }
}
/// See [`Room`](crate::model::Room)
pub mod room {
    /// A builder for [`Room`](crate::model::Room)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) room_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) provider_calendar_id: std::option::Option<std::string::String>,
        pub(crate) profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a room.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a room.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The name of a room.</p>
        pub fn room_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_name = Some(input.into());
            self
        }
        /// <p>The name of a room.</p>
        pub fn set_room_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_name = input;
            self
        }
        /// <p>The description of a room.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a room.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The provider calendar ARN of a room.</p>
        pub fn provider_calendar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_calendar_id = Some(input.into());
            self
        }
        /// <p>The provider calendar ARN of a room.</p>
        pub fn set_provider_calendar_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_calendar_id = input;
            self
        }
        /// <p>The profile ARN of a room.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The profile ARN of a room.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Room`](crate::model::Room)
        pub fn build(self) -> crate::model::Room {
            crate::model::Room {
                room_arn: self.room_arn,
                room_name: self.room_name,
                description: self.description,
                provider_calendar_id: self.provider_calendar_id,
                profile_arn: self.profile_arn,
            }
        }
    }
}
impl Room {
    /// Creates a new builder-style object to manufacture [`Room`](crate::model::Room)
    pub fn builder() -> crate::model::room::Builder {
        crate::model::room::Builder::default()
    }
}

/// <p>A room profile with attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Profile {
    /// <p>The ARN of a room profile.</p>
    pub profile_arn: std::option::Option<std::string::String>,
    /// <p>The name of a room profile.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>Retrieves if the profile is default or not.</p>
    pub is_default: std::option::Option<bool>,
    /// <p>The address of a room profile.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The time zone of a room profile.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>The distance unit of a room profile.</p>
    pub distance_unit: std::option::Option<crate::model::DistanceUnit>,
    /// <p>The temperature unit of a room profile.</p>
    pub temperature_unit: std::option::Option<crate::model::TemperatureUnit>,
    /// <p>The wake word of a room profile.</p>
    pub wake_word: std::option::Option<crate::model::WakeWord>,
    /// <p>The locale of a room profile. (This is currently available only to a limited preview
    /// audience.)</p>
    pub locale: std::option::Option<std::string::String>,
    /// <p>The setup mode of a room profile.</p>
    pub setup_mode_disabled: std::option::Option<bool>,
    /// <p>The max volume limit of a room profile.</p>
    pub max_volume_limit: std::option::Option<i32>,
    /// <p>The PSTN setting of a room profile.</p>
    pub pstn_enabled: std::option::Option<bool>,
    /// <p>Whether data retention of the profile is enabled.</p>
    pub data_retention_opt_in: std::option::Option<bool>,
    /// <p>The ARN of the address book.</p>
    pub address_book_arn: std::option::Option<std::string::String>,
    /// <p>Meeting room settings of a room profile.</p>
    pub meeting_room_configuration: std::option::Option<crate::model::MeetingRoomConfiguration>,
}
impl std::fmt::Debug for Profile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Profile");
        formatter.field("profile_arn", &self.profile_arn);
        formatter.field("profile_name", &self.profile_name);
        formatter.field("is_default", &self.is_default);
        formatter.field("address", &self.address);
        formatter.field("timezone", &self.timezone);
        formatter.field("distance_unit", &self.distance_unit);
        formatter.field("temperature_unit", &self.temperature_unit);
        formatter.field("wake_word", &self.wake_word);
        formatter.field("locale", &self.locale);
        formatter.field("setup_mode_disabled", &self.setup_mode_disabled);
        formatter.field("max_volume_limit", &self.max_volume_limit);
        formatter.field("pstn_enabled", &self.pstn_enabled);
        formatter.field("data_retention_opt_in", &self.data_retention_opt_in);
        formatter.field("address_book_arn", &self.address_book_arn);
        formatter.field(
            "meeting_room_configuration",
            &self.meeting_room_configuration,
        );
        formatter.finish()
    }
}
/// See [`Profile`](crate::model::Profile)
pub mod profile {
    /// A builder for [`Profile`](crate::model::Profile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_arn: std::option::Option<std::string::String>,
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) is_default: std::option::Option<bool>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) distance_unit: std::option::Option<crate::model::DistanceUnit>,
        pub(crate) temperature_unit: std::option::Option<crate::model::TemperatureUnit>,
        pub(crate) wake_word: std::option::Option<crate::model::WakeWord>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) setup_mode_disabled: std::option::Option<bool>,
        pub(crate) max_volume_limit: std::option::Option<i32>,
        pub(crate) pstn_enabled: std::option::Option<bool>,
        pub(crate) data_retention_opt_in: std::option::Option<bool>,
        pub(crate) address_book_arn: std::option::Option<std::string::String>,
        pub(crate) meeting_room_configuration:
            std::option::Option<crate::model::MeetingRoomConfiguration>,
    }
    impl Builder {
        /// <p>The ARN of a room profile.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a room profile.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// <p>The name of a room profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of a room profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>Retrieves if the profile is default or not.</p>
        pub fn is_default(mut self, input: bool) -> Self {
            self.is_default = Some(input);
            self
        }
        /// <p>Retrieves if the profile is default or not.</p>
        pub fn set_is_default(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default = input;
            self
        }
        /// <p>The address of a room profile.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The address of a room profile.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The time zone of a room profile.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone of a room profile.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>The distance unit of a room profile.</p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.distance_unit = Some(input);
            self
        }
        /// <p>The distance unit of a room profile.</p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.distance_unit = input;
            self
        }
        /// <p>The temperature unit of a room profile.</p>
        pub fn temperature_unit(mut self, input: crate::model::TemperatureUnit) -> Self {
            self.temperature_unit = Some(input);
            self
        }
        /// <p>The temperature unit of a room profile.</p>
        pub fn set_temperature_unit(
            mut self,
            input: std::option::Option<crate::model::TemperatureUnit>,
        ) -> Self {
            self.temperature_unit = input;
            self
        }
        /// <p>The wake word of a room profile.</p>
        pub fn wake_word(mut self, input: crate::model::WakeWord) -> Self {
            self.wake_word = Some(input);
            self
        }
        /// <p>The wake word of a room profile.</p>
        pub fn set_wake_word(mut self, input: std::option::Option<crate::model::WakeWord>) -> Self {
            self.wake_word = input;
            self
        }
        /// <p>The locale of a room profile. (This is currently available only to a limited preview
        /// audience.)</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale of a room profile. (This is currently available only to a limited preview
        /// audience.)</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The setup mode of a room profile.</p>
        pub fn setup_mode_disabled(mut self, input: bool) -> Self {
            self.setup_mode_disabled = Some(input);
            self
        }
        /// <p>The setup mode of a room profile.</p>
        pub fn set_setup_mode_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.setup_mode_disabled = input;
            self
        }
        /// <p>The max volume limit of a room profile.</p>
        pub fn max_volume_limit(mut self, input: i32) -> Self {
            self.max_volume_limit = Some(input);
            self
        }
        /// <p>The max volume limit of a room profile.</p>
        pub fn set_max_volume_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.max_volume_limit = input;
            self
        }
        /// <p>The PSTN setting of a room profile.</p>
        pub fn pstn_enabled(mut self, input: bool) -> Self {
            self.pstn_enabled = Some(input);
            self
        }
        /// <p>The PSTN setting of a room profile.</p>
        pub fn set_pstn_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.pstn_enabled = input;
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn data_retention_opt_in(mut self, input: bool) -> Self {
            self.data_retention_opt_in = Some(input);
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn set_data_retention_opt_in(mut self, input: std::option::Option<bool>) -> Self {
            self.data_retention_opt_in = input;
            self
        }
        /// <p>The ARN of the address book.</p>
        pub fn address_book_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_book_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the address book.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_book_arn = input;
            self
        }
        /// <p>Meeting room settings of a room profile.</p>
        pub fn meeting_room_configuration(
            mut self,
            input: crate::model::MeetingRoomConfiguration,
        ) -> Self {
            self.meeting_room_configuration = Some(input);
            self
        }
        /// <p>Meeting room settings of a room profile.</p>
        pub fn set_meeting_room_configuration(
            mut self,
            input: std::option::Option<crate::model::MeetingRoomConfiguration>,
        ) -> Self {
            self.meeting_room_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Profile`](crate::model::Profile)
        pub fn build(self) -> crate::model::Profile {
            crate::model::Profile {
                profile_arn: self.profile_arn,
                profile_name: self.profile_name,
                is_default: self.is_default,
                address: self.address,
                timezone: self.timezone,
                distance_unit: self.distance_unit,
                temperature_unit: self.temperature_unit,
                wake_word: self.wake_word,
                locale: self.locale,
                setup_mode_disabled: self.setup_mode_disabled,
                max_volume_limit: self.max_volume_limit,
                pstn_enabled: self.pstn_enabled,
                data_retention_opt_in: self.data_retention_opt_in,
                address_book_arn: self.address_book_arn,
                meeting_room_configuration: self.meeting_room_configuration,
            }
        }
    }
}
impl Profile {
    /// Creates a new builder-style object to manufacture [`Profile`](crate::model::Profile)
    pub fn builder() -> crate::model::profile::Builder {
        crate::model::profile::Builder::default()
    }
}

/// <p>Meeting room settings of a room profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeetingRoomConfiguration {
    /// <p>Whether room utilization metrics are enabled or not.</p>
    pub room_utilization_metrics_enabled: std::option::Option<bool>,
    /// <p>Settings for the end of meeting reminder feature that are applied to a room profile. The
    /// end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>
    pub end_of_meeting_reminder: std::option::Option<crate::model::EndOfMeetingReminder>,
    /// <p>Settings to automatically book the room if available for a configured duration when
    /// joining a meeting with Alexa. </p>
    pub instant_booking: std::option::Option<crate::model::InstantBooking>,
    /// <p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room
    /// reservation if it's not checked into. This makes the room available for others. Users can
    /// check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check
    /// in.” </p>
    pub require_check_in: std::option::Option<crate::model::RequireCheckIn>,
}
impl std::fmt::Debug for MeetingRoomConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeetingRoomConfiguration");
        formatter.field(
            "room_utilization_metrics_enabled",
            &self.room_utilization_metrics_enabled,
        );
        formatter.field("end_of_meeting_reminder", &self.end_of_meeting_reminder);
        formatter.field("instant_booking", &self.instant_booking);
        formatter.field("require_check_in", &self.require_check_in);
        formatter.finish()
    }
}
/// See [`MeetingRoomConfiguration`](crate::model::MeetingRoomConfiguration)
pub mod meeting_room_configuration {
    /// A builder for [`MeetingRoomConfiguration`](crate::model::MeetingRoomConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_utilization_metrics_enabled: std::option::Option<bool>,
        pub(crate) end_of_meeting_reminder: std::option::Option<crate::model::EndOfMeetingReminder>,
        pub(crate) instant_booking: std::option::Option<crate::model::InstantBooking>,
        pub(crate) require_check_in: std::option::Option<crate::model::RequireCheckIn>,
    }
    impl Builder {
        /// <p>Whether room utilization metrics are enabled or not.</p>
        pub fn room_utilization_metrics_enabled(mut self, input: bool) -> Self {
            self.room_utilization_metrics_enabled = Some(input);
            self
        }
        /// <p>Whether room utilization metrics are enabled or not.</p>
        pub fn set_room_utilization_metrics_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.room_utilization_metrics_enabled = input;
            self
        }
        /// <p>Settings for the end of meeting reminder feature that are applied to a room profile. The
        /// end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>
        pub fn end_of_meeting_reminder(
            mut self,
            input: crate::model::EndOfMeetingReminder,
        ) -> Self {
            self.end_of_meeting_reminder = Some(input);
            self
        }
        /// <p>Settings for the end of meeting reminder feature that are applied to a room profile. The
        /// end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>
        pub fn set_end_of_meeting_reminder(
            mut self,
            input: std::option::Option<crate::model::EndOfMeetingReminder>,
        ) -> Self {
            self.end_of_meeting_reminder = input;
            self
        }
        /// <p>Settings to automatically book the room if available for a configured duration when
        /// joining a meeting with Alexa. </p>
        pub fn instant_booking(mut self, input: crate::model::InstantBooking) -> Self {
            self.instant_booking = Some(input);
            self
        }
        /// <p>Settings to automatically book the room if available for a configured duration when
        /// joining a meeting with Alexa. </p>
        pub fn set_instant_booking(
            mut self,
            input: std::option::Option<crate::model::InstantBooking>,
        ) -> Self {
            self.instant_booking = input;
            self
        }
        /// <p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room
        /// reservation if it's not checked into. This makes the room available for others. Users can
        /// check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check
        /// in.” </p>
        pub fn require_check_in(mut self, input: crate::model::RequireCheckIn) -> Self {
            self.require_check_in = Some(input);
            self
        }
        /// <p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room
        /// reservation if it's not checked into. This makes the room available for others. Users can
        /// check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check
        /// in.” </p>
        pub fn set_require_check_in(
            mut self,
            input: std::option::Option<crate::model::RequireCheckIn>,
        ) -> Self {
            self.require_check_in = input;
            self
        }
        /// Consumes the builder and constructs a [`MeetingRoomConfiguration`](crate::model::MeetingRoomConfiguration)
        pub fn build(self) -> crate::model::MeetingRoomConfiguration {
            crate::model::MeetingRoomConfiguration {
                room_utilization_metrics_enabled: self.room_utilization_metrics_enabled,
                end_of_meeting_reminder: self.end_of_meeting_reminder,
                instant_booking: self.instant_booking,
                require_check_in: self.require_check_in,
            }
        }
    }
}
impl MeetingRoomConfiguration {
    /// Creates a new builder-style object to manufacture [`MeetingRoomConfiguration`](crate::model::MeetingRoomConfiguration)
    pub fn builder() -> crate::model::meeting_room_configuration::Builder {
        crate::model::meeting_room_configuration::Builder::default()
    }
}

/// <p>Settings for the require check in feature that are applied to a room profile. Require check in allows a meeting room’s Alexa or AVS device to prompt the user to check in; otherwise, the room will be released. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequireCheckIn {
    /// <p>Duration between 5 and 20 minutes to determine when to release the room if it's not checked into. </p>
    pub release_after_minutes: std::option::Option<i32>,
    /// <p>Whether require check in is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for RequireCheckIn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequireCheckIn");
        formatter.field("release_after_minutes", &self.release_after_minutes);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`RequireCheckIn`](crate::model::RequireCheckIn)
pub mod require_check_in {
    /// A builder for [`RequireCheckIn`](crate::model::RequireCheckIn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) release_after_minutes: std::option::Option<i32>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Duration between 5 and 20 minutes to determine when to release the room if it's not checked into. </p>
        pub fn release_after_minutes(mut self, input: i32) -> Self {
            self.release_after_minutes = Some(input);
            self
        }
        /// <p>Duration between 5 and 20 minutes to determine when to release the room if it's not checked into. </p>
        pub fn set_release_after_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.release_after_minutes = input;
            self
        }
        /// <p>Whether require check in is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether require check in is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`RequireCheckIn`](crate::model::RequireCheckIn)
        pub fn build(self) -> crate::model::RequireCheckIn {
            crate::model::RequireCheckIn {
                release_after_minutes: self.release_after_minutes,
                enabled: self.enabled,
            }
        }
    }
}
impl RequireCheckIn {
    /// Creates a new builder-style object to manufacture [`RequireCheckIn`](crate::model::RequireCheckIn)
    pub fn builder() -> crate::model::require_check_in::Builder {
        crate::model::require_check_in::Builder::default()
    }
}

/// <p>Settings for the instant booking feature that are applied to a room profile. When users
/// start their meeting with Alexa, Alexa  automatically books the room for the configured
/// duration if the room is available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstantBooking {
    /// <p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book
    /// an available room when a meeting is started with Alexa. </p>
    pub duration_in_minutes: std::option::Option<i32>,
    /// <p>Whether instant booking is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for InstantBooking {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstantBooking");
        formatter.field("duration_in_minutes", &self.duration_in_minutes);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`InstantBooking`](crate::model::InstantBooking)
pub mod instant_booking {
    /// A builder for [`InstantBooking`](crate::model::InstantBooking)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_minutes: std::option::Option<i32>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book
        /// an available room when a meeting is started with Alexa. </p>
        pub fn duration_in_minutes(mut self, input: i32) -> Self {
            self.duration_in_minutes = Some(input);
            self
        }
        /// <p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book
        /// an available room when a meeting is started with Alexa. </p>
        pub fn set_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_minutes = input;
            self
        }
        /// <p>Whether instant booking is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether instant booking is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`InstantBooking`](crate::model::InstantBooking)
        pub fn build(self) -> crate::model::InstantBooking {
            crate::model::InstantBooking {
                duration_in_minutes: self.duration_in_minutes,
                enabled: self.enabled,
            }
        }
    }
}
impl InstantBooking {
    /// Creates a new builder-style object to manufacture [`InstantBooking`](crate::model::InstantBooking)
    pub fn builder() -> crate::model::instant_booking::Builder {
        crate::model::instant_booking::Builder::default()
    }
}

/// <p>Settings for the end of meeting reminder feature that are applied to a room profile. The
/// end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndOfMeetingReminder {
    /// <p>A range of 3 to 15 minutes that determines when the reminder begins.</p>
    pub reminder_at_minutes: std::option::Option<std::vec::Vec<i32>>,
    /// <p>The type of sound that users hear during the end of meeting reminder. </p>
    pub reminder_type: std::option::Option<crate::model::EndOfMeetingReminderType>,
    /// <p>Whether an end of meeting reminder is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for EndOfMeetingReminder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndOfMeetingReminder");
        formatter.field("reminder_at_minutes", &self.reminder_at_minutes);
        formatter.field("reminder_type", &self.reminder_type);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`EndOfMeetingReminder`](crate::model::EndOfMeetingReminder)
pub mod end_of_meeting_reminder {
    /// A builder for [`EndOfMeetingReminder`](crate::model::EndOfMeetingReminder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reminder_at_minutes: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) reminder_type: std::option::Option<crate::model::EndOfMeetingReminderType>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `reminder_at_minutes`.
        ///
        /// To override the contents of this collection use [`set_reminder_at_minutes`](Self::set_reminder_at_minutes).
        ///
        /// <p>A range of 3 to 15 minutes that determines when the reminder begins.</p>
        pub fn reminder_at_minutes(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.reminder_at_minutes.unwrap_or_default();
            v.push(input.into());
            self.reminder_at_minutes = Some(v);
            self
        }
        /// <p>A range of 3 to 15 minutes that determines when the reminder begins.</p>
        pub fn set_reminder_at_minutes(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.reminder_at_minutes = input;
            self
        }
        /// <p>The type of sound that users hear during the end of meeting reminder. </p>
        pub fn reminder_type(mut self, input: crate::model::EndOfMeetingReminderType) -> Self {
            self.reminder_type = Some(input);
            self
        }
        /// <p>The type of sound that users hear during the end of meeting reminder. </p>
        pub fn set_reminder_type(
            mut self,
            input: std::option::Option<crate::model::EndOfMeetingReminderType>,
        ) -> Self {
            self.reminder_type = input;
            self
        }
        /// <p>Whether an end of meeting reminder is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether an end of meeting reminder is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`EndOfMeetingReminder`](crate::model::EndOfMeetingReminder)
        pub fn build(self) -> crate::model::EndOfMeetingReminder {
            crate::model::EndOfMeetingReminder {
                reminder_at_minutes: self.reminder_at_minutes,
                reminder_type: self.reminder_type,
                enabled: self.enabled,
            }
        }
    }
}
impl EndOfMeetingReminder {
    /// Creates a new builder-style object to manufacture [`EndOfMeetingReminder`](crate::model::EndOfMeetingReminder)
    pub fn builder() -> crate::model::end_of_meeting_reminder::Builder {
        crate::model::end_of_meeting_reminder::Builder::default()
    }
}

/// <p>The network profile associated with a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkProfile {
    /// <p>The ARN of the network profile associated with a device.</p>
    pub network_profile_arn: std::option::Option<std::string::String>,
    /// <p>The name of the network profile associated with a device.</p>
    pub network_profile_name: std::option::Option<std::string::String>,
    /// <p>Detailed information about a device's network profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The SSID of the Wi-Fi network.</p>
    pub ssid: std::option::Option<std::string::String>,
    /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
    /// WEP, or OPEN.</p>
    pub security_type: std::option::Option<crate::model::NetworkSecurityType>,
    /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
    /// supported. </p>
    pub eap_method: std::option::Option<crate::model::NetworkEapMethod>,
    /// <p>The current password of the Wi-Fi network.</p>
    pub current_password: std::option::Option<std::string::String>,
    /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
    /// transmitted to the device and is used when the password of the network changes to
    /// NextPassword. </p>
    pub next_password: std::option::Option<std::string::String>,
    /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
    /// (ACM). This is used to issue certificates to the devices. </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The root certificates of your authentication server, which is installed on your devices
    /// and used to trust your authentication server during EAP negotiation.</p>
    pub trust_anchors: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for NetworkProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkProfile");
        formatter.field("network_profile_arn", &self.network_profile_arn);
        formatter.field("network_profile_name", &self.network_profile_name);
        formatter.field("description", &self.description);
        formatter.field("ssid", &self.ssid);
        formatter.field("security_type", &self.security_type);
        formatter.field("eap_method", &self.eap_method);
        formatter.field("current_password", &"*** Sensitive Data Redacted ***");
        formatter.field("next_password", &"*** Sensitive Data Redacted ***");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("trust_anchors", &self.trust_anchors);
        formatter.finish()
    }
}
/// See [`NetworkProfile`](crate::model::NetworkProfile)
pub mod network_profile {
    /// A builder for [`NetworkProfile`](crate::model::NetworkProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile_arn: std::option::Option<std::string::String>,
        pub(crate) network_profile_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ssid: std::option::Option<std::string::String>,
        pub(crate) security_type: std::option::Option<crate::model::NetworkSecurityType>,
        pub(crate) eap_method: std::option::Option<crate::model::NetworkEapMethod>,
        pub(crate) current_password: std::option::Option<std::string::String>,
        pub(crate) next_password: std::option::Option<std::string::String>,
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) trust_anchors: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_arn = input;
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn network_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn set_network_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_name = input;
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The SSID of the Wi-Fi network.</p>
        pub fn ssid(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssid = Some(input.into());
            self
        }
        /// <p>The SSID of the Wi-Fi network.</p>
        pub fn set_ssid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssid = input;
            self
        }
        /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
        /// WEP, or OPEN.</p>
        pub fn security_type(mut self, input: crate::model::NetworkSecurityType) -> Self {
            self.security_type = Some(input);
            self
        }
        /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
        /// WEP, or OPEN.</p>
        pub fn set_security_type(
            mut self,
            input: std::option::Option<crate::model::NetworkSecurityType>,
        ) -> Self {
            self.security_type = input;
            self
        }
        /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
        /// supported. </p>
        pub fn eap_method(mut self, input: crate::model::NetworkEapMethod) -> Self {
            self.eap_method = Some(input);
            self
        }
        /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
        /// supported. </p>
        pub fn set_eap_method(
            mut self,
            input: std::option::Option<crate::model::NetworkEapMethod>,
        ) -> Self {
            self.eap_method = input;
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn current_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_password = Some(input.into());
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn set_current_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_password = input;
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn next_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_password = Some(input.into());
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn set_next_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_password = input;
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Appends an item to `trust_anchors`.
        ///
        /// To override the contents of this collection use [`set_trust_anchors`](Self::set_trust_anchors).
        ///
        /// <p>The root certificates of your authentication server, which is installed on your devices
        /// and used to trust your authentication server during EAP negotiation.</p>
        pub fn trust_anchors(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trust_anchors.unwrap_or_default();
            v.push(input.into());
            self.trust_anchors = Some(v);
            self
        }
        /// <p>The root certificates of your authentication server, which is installed on your devices
        /// and used to trust your authentication server during EAP negotiation.</p>
        pub fn set_trust_anchors(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trust_anchors = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkProfile`](crate::model::NetworkProfile)
        pub fn build(self) -> crate::model::NetworkProfile {
            crate::model::NetworkProfile {
                network_profile_arn: self.network_profile_arn,
                network_profile_name: self.network_profile_name,
                description: self.description,
                ssid: self.ssid,
                security_type: self.security_type,
                eap_method: self.eap_method,
                current_password: self.current_password,
                next_password: self.next_password,
                certificate_authority_arn: self.certificate_authority_arn,
                trust_anchors: self.trust_anchors,
            }
        }
    }
}
impl NetworkProfile {
    /// Creates a new builder-style object to manufacture [`NetworkProfile`](crate::model::NetworkProfile)
    pub fn builder() -> crate::model::network_profile::Builder {
        crate::model::network_profile::Builder::default()
    }
}

/// <p>The details of the gateway group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayGroup {
    /// <p>The ARN of the gateway group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the gateway group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the gateway group.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GatewayGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayGroup");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`GatewayGroup`](crate::model::GatewayGroup)
pub mod gateway_group {
    /// A builder for [`GatewayGroup`](crate::model::GatewayGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the gateway group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the gateway group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the gateway group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the gateway group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the gateway group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayGroup`](crate::model::GatewayGroup)
        pub fn build(self) -> crate::model::GatewayGroup {
            crate::model::GatewayGroup {
                arn: self.arn,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl GatewayGroup {
    /// Creates a new builder-style object to manufacture [`GatewayGroup`](crate::model::GatewayGroup)
    pub fn builder() -> crate::model::gateway_group::Builder {
        crate::model::gateway_group::Builder::default()
    }
}

/// <p>The details of the gateway. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Gateway {
    /// <p>The ARN of the gateway.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the gateway.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the gateway.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the gateway group that the gateway is associated to.</p>
    pub gateway_group_arn: std::option::Option<std::string::String>,
    /// <p>The software version of the gateway. The gateway automatically updates its software
    /// version during normal operation.</p>
    pub software_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Gateway {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Gateway");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("gateway_group_arn", &self.gateway_group_arn);
        formatter.field("software_version", &self.software_version);
        formatter.finish()
    }
}
/// See [`Gateway`](crate::model::Gateway)
pub mod gateway {
    /// A builder for [`Gateway`](crate::model::Gateway)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) gateway_group_arn: std::option::Option<std::string::String>,
        pub(crate) software_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the gateway.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the gateway.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the gateway.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the gateway.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the gateway.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the gateway group that the gateway is associated to.</p>
        pub fn gateway_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway group that the gateway is associated to.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_group_arn = input;
            self
        }
        /// <p>The software version of the gateway. The gateway automatically updates its software
        /// version during normal operation.</p>
        pub fn software_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.software_version = Some(input.into());
            self
        }
        /// <p>The software version of the gateway. The gateway automatically updates its software
        /// version during normal operation.</p>
        pub fn set_software_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.software_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Gateway`](crate::model::Gateway)
        pub fn build(self) -> crate::model::Gateway {
            crate::model::Gateway {
                arn: self.arn,
                name: self.name,
                description: self.description,
                gateway_group_arn: self.gateway_group_arn,
                software_version: self.software_version,
            }
        }
    }
}
impl Gateway {
    /// Creates a new builder-style object to manufacture [`Gateway`](crate::model::Gateway)
    pub fn builder() -> crate::model::gateway::Builder {
        crate::model::gateway::Builder::default()
    }
}

/// <p>A device with attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Device {
    /// <p>The ARN of a device.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The serial number of a device.</p>
    pub device_serial_number: std::option::Option<std::string::String>,
    /// <p>The type of a device.</p>
    pub device_type: std::option::Option<std::string::String>,
    /// <p>The name of a device.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The software version of a device.</p>
    pub software_version: std::option::Option<std::string::String>,
    /// <p>The MAC address of a device.</p>
    pub mac_address: std::option::Option<std::string::String>,
    /// <p>The room ARN of a device.</p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The status of a device. If the status is not READY, check the DeviceStatusInfo value
    /// for details.</p>
    pub device_status: std::option::Option<crate::model::DeviceStatus>,
    /// <p>Detailed information about a device's status.</p>
    pub device_status_info: std::option::Option<crate::model::DeviceStatusInfo>,
    /// <p>Detailed information about a device's network profile.</p>
    pub network_profile_info: std::option::Option<crate::model::DeviceNetworkProfileInfo>,
}
impl std::fmt::Debug for Device {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Device");
        formatter.field("device_arn", &self.device_arn);
        formatter.field("device_serial_number", &self.device_serial_number);
        formatter.field("device_type", &self.device_type);
        formatter.field("device_name", &self.device_name);
        formatter.field("software_version", &self.software_version);
        formatter.field("mac_address", &self.mac_address);
        formatter.field("room_arn", &self.room_arn);
        formatter.field("device_status", &self.device_status);
        formatter.field("device_status_info", &self.device_status_info);
        formatter.field("network_profile_info", &self.network_profile_info);
        formatter.finish()
    }
}
/// See [`Device`](crate::model::Device)
pub mod device {
    /// A builder for [`Device`](crate::model::Device)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) device_serial_number: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<std::string::String>,
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) software_version: std::option::Option<std::string::String>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) device_status: std::option::Option<crate::model::DeviceStatus>,
        pub(crate) device_status_info: std::option::Option<crate::model::DeviceStatusInfo>,
        pub(crate) network_profile_info:
            std::option::Option<crate::model::DeviceNetworkProfileInfo>,
    }
    impl Builder {
        /// <p>The ARN of a device.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The serial number of a device.</p>
        pub fn device_serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_serial_number = Some(input.into());
            self
        }
        /// <p>The serial number of a device.</p>
        pub fn set_device_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_serial_number = input;
            self
        }
        /// <p>The type of a device.</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>The type of a device.</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// <p>The name of a device.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of a device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The software version of a device.</p>
        pub fn software_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.software_version = Some(input.into());
            self
        }
        /// <p>The software version of a device.</p>
        pub fn set_software_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.software_version = input;
            self
        }
        /// <p>The MAC address of a device.</p>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>The MAC address of a device.</p>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// <p>The room ARN of a device.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The room ARN of a device.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The status of a device. If the status is not READY, check the DeviceStatusInfo value
        /// for details.</p>
        pub fn device_status(mut self, input: crate::model::DeviceStatus) -> Self {
            self.device_status = Some(input);
            self
        }
        /// <p>The status of a device. If the status is not READY, check the DeviceStatusInfo value
        /// for details.</p>
        pub fn set_device_status(
            mut self,
            input: std::option::Option<crate::model::DeviceStatus>,
        ) -> Self {
            self.device_status = input;
            self
        }
        /// <p>Detailed information about a device's status.</p>
        pub fn device_status_info(mut self, input: crate::model::DeviceStatusInfo) -> Self {
            self.device_status_info = Some(input);
            self
        }
        /// <p>Detailed information about a device's status.</p>
        pub fn set_device_status_info(
            mut self,
            input: std::option::Option<crate::model::DeviceStatusInfo>,
        ) -> Self {
            self.device_status_info = input;
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn network_profile_info(
            mut self,
            input: crate::model::DeviceNetworkProfileInfo,
        ) -> Self {
            self.network_profile_info = Some(input);
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn set_network_profile_info(
            mut self,
            input: std::option::Option<crate::model::DeviceNetworkProfileInfo>,
        ) -> Self {
            self.network_profile_info = input;
            self
        }
        /// Consumes the builder and constructs a [`Device`](crate::model::Device)
        pub fn build(self) -> crate::model::Device {
            crate::model::Device {
                device_arn: self.device_arn,
                device_serial_number: self.device_serial_number,
                device_type: self.device_type,
                device_name: self.device_name,
                software_version: self.software_version,
                mac_address: self.mac_address,
                room_arn: self.room_arn,
                device_status: self.device_status,
                device_status_info: self.device_status_info,
                network_profile_info: self.network_profile_info,
            }
        }
    }
}
impl Device {
    /// Creates a new builder-style object to manufacture [`Device`](crate::model::Device)
    pub fn builder() -> crate::model::device::Builder {
        crate::model::device::Builder::default()
    }
}

/// <p>Detailed information about a device's network profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceNetworkProfileInfo {
    /// <p>The ARN of the network profile associated with a device.</p>
    pub network_profile_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the certificate associated with a device.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The time (in epoch) when the certificate expires.</p>
    pub certificate_expiration_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DeviceNetworkProfileInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceNetworkProfileInfo");
        formatter.field("network_profile_arn", &self.network_profile_arn);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field(
            "certificate_expiration_time",
            &self.certificate_expiration_time,
        );
        formatter.finish()
    }
}
/// See [`DeviceNetworkProfileInfo`](crate::model::DeviceNetworkProfileInfo)
pub mod device_network_profile_info {
    /// A builder for [`DeviceNetworkProfileInfo`](crate::model::DeviceNetworkProfileInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_expiration_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_arn = input;
            self
        }
        /// <p>The ARN of the certificate associated with a device.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the certificate associated with a device.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The time (in epoch) when the certificate expires.</p>
        pub fn certificate_expiration_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.certificate_expiration_time = Some(input);
            self
        }
        /// <p>The time (in epoch) when the certificate expires.</p>
        pub fn set_certificate_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.certificate_expiration_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceNetworkProfileInfo`](crate::model::DeviceNetworkProfileInfo)
        pub fn build(self) -> crate::model::DeviceNetworkProfileInfo {
            crate::model::DeviceNetworkProfileInfo {
                network_profile_arn: self.network_profile_arn,
                certificate_arn: self.certificate_arn,
                certificate_expiration_time: self.certificate_expiration_time,
            }
        }
    }
}
impl DeviceNetworkProfileInfo {
    /// Creates a new builder-style object to manufacture [`DeviceNetworkProfileInfo`](crate::model::DeviceNetworkProfileInfo)
    pub fn builder() -> crate::model::device_network_profile_info::Builder {
        crate::model::device_network_profile_info::Builder::default()
    }
}

/// <p>A contact with attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Contact {
    /// <p>The ARN of the contact.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The name of the contact to display on the console.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The first name of the contact, used to call the contact on the device.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name of the contact, used to call the contact on the device.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The phone number of the contact. The phone number type defaults to WORK. You can
    /// either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which
    /// lets you specify the phone number type and multiple numbers.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The list of phone numbers for the contact.</p>
    pub phone_numbers: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
    /// <p>The list of SIP addresses for the contact.</p>
    pub sip_addresses: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
}
impl std::fmt::Debug for Contact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Contact");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("first_name", &self.first_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("phone_numbers", &self.phone_numbers);
        formatter.field("sip_addresses", &self.sip_addresses);
        formatter.finish()
    }
}
/// See [`Contact`](crate::model::Contact)
pub mod contact {
    /// A builder for [`Contact`](crate::model::Contact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) phone_numbers: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        pub(crate) sip_addresses: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
    }
    impl Builder {
        /// <p>The ARN of the contact.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The name of the contact to display on the console.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the contact to display on the console.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The first name of the contact, used to call the contact on the device.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name of the contact, used to call the contact on the device.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name of the contact, used to call the contact on the device.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name of the contact, used to call the contact on the device.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The phone number of the contact. The phone number type defaults to WORK. You can
        /// either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which
        /// lets you specify the phone number type and multiple numbers.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number of the contact. The phone number type defaults to WORK. You can
        /// either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which
        /// lets you specify the phone number type and multiple numbers.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// Appends an item to `phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_phone_numbers`](Self::set_phone_numbers).
        ///
        /// <p>The list of phone numbers for the contact.</p>
        pub fn phone_numbers(mut self, input: impl Into<crate::model::PhoneNumber>) -> Self {
            let mut v = self.phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.phone_numbers = Some(v);
            self
        }
        /// <p>The list of phone numbers for the contact.</p>
        pub fn set_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        ) -> Self {
            self.phone_numbers = input;
            self
        }
        /// Appends an item to `sip_addresses`.
        ///
        /// To override the contents of this collection use [`set_sip_addresses`](Self::set_sip_addresses).
        ///
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn sip_addresses(mut self, input: impl Into<crate::model::SipAddress>) -> Self {
            let mut v = self.sip_addresses.unwrap_or_default();
            v.push(input.into());
            self.sip_addresses = Some(v);
            self
        }
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn set_sip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
        ) -> Self {
            self.sip_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`Contact`](crate::model::Contact)
        pub fn build(self) -> crate::model::Contact {
            crate::model::Contact {
                contact_arn: self.contact_arn,
                display_name: self.display_name,
                first_name: self.first_name,
                last_name: self.last_name,
                phone_number: self.phone_number,
                phone_numbers: self.phone_numbers,
                sip_addresses: self.sip_addresses,
            }
        }
    }
}
impl Contact {
    /// Creates a new builder-style object to manufacture [`Contact`](crate::model::Contact)
    pub fn builder() -> crate::model::contact::Builder {
        crate::model::contact::Builder::default()
    }
}

/// <p>An address book with attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddressBook {
    /// <p>The ARN of the address book.</p>
    pub address_book_arn: std::option::Option<std::string::String>,
    /// <p>The name of the address book.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the address book.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AddressBook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddressBook");
        formatter.field("address_book_arn", &self.address_book_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`AddressBook`](crate::model::AddressBook)
pub mod address_book {
    /// A builder for [`AddressBook`](crate::model::AddressBook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address_book_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the address book.</p>
        pub fn address_book_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_book_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the address book.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_book_arn = input;
            self
        }
        /// <p>The name of the address book.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the address book.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the address book.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the address book.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`AddressBook`](crate::model::AddressBook)
        pub fn build(self) -> crate::model::AddressBook {
            crate::model::AddressBook {
                address_book_arn: self.address_book_arn,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl AddressBook {
    /// Creates a new builder-style object to manufacture [`AddressBook`](crate::model::AddressBook)
    pub fn builder() -> crate::model::address_book::Builder {
        crate::model::address_book::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceUsageType {
    #[allow(missing_docs)] // documentation missing in model
    Voice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceUsageType {
    fn from(s: &str) -> Self {
        match s {
            "VOICE" => DeviceUsageType::Voice,
            other => DeviceUsageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceUsageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceUsageType::from(s))
    }
}
impl DeviceUsageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceUsageType::Voice => "VOICE",
            DeviceUsageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["VOICE"]
    }
}
impl AsRef<str> for DeviceUsageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Creates meeting room settings of a room profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMeetingRoomConfiguration {
    /// <p>Whether room utilization metrics are enabled or not.</p>
    pub room_utilization_metrics_enabled: std::option::Option<bool>,
    /// <p>Creates settings for the end of meeting reminder feature that are applied to a room
    /// profile. The end of meeting reminder enables Alexa to remind users when a meeting is
    /// ending.</p>
    pub end_of_meeting_reminder: std::option::Option<crate::model::CreateEndOfMeetingReminder>,
    /// <p>Settings to automatically book a room for a configured duration if it's free when joining a meeting with Alexa.</p>
    pub instant_booking: std::option::Option<crate::model::CreateInstantBooking>,
    /// <p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.”</p>
    pub require_check_in: std::option::Option<crate::model::CreateRequireCheckIn>,
}
impl std::fmt::Debug for CreateMeetingRoomConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMeetingRoomConfiguration");
        formatter.field(
            "room_utilization_metrics_enabled",
            &self.room_utilization_metrics_enabled,
        );
        formatter.field("end_of_meeting_reminder", &self.end_of_meeting_reminder);
        formatter.field("instant_booking", &self.instant_booking);
        formatter.field("require_check_in", &self.require_check_in);
        formatter.finish()
    }
}
/// See [`CreateMeetingRoomConfiguration`](crate::model::CreateMeetingRoomConfiguration)
pub mod create_meeting_room_configuration {
    /// A builder for [`CreateMeetingRoomConfiguration`](crate::model::CreateMeetingRoomConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_utilization_metrics_enabled: std::option::Option<bool>,
        pub(crate) end_of_meeting_reminder:
            std::option::Option<crate::model::CreateEndOfMeetingReminder>,
        pub(crate) instant_booking: std::option::Option<crate::model::CreateInstantBooking>,
        pub(crate) require_check_in: std::option::Option<crate::model::CreateRequireCheckIn>,
    }
    impl Builder {
        /// <p>Whether room utilization metrics are enabled or not.</p>
        pub fn room_utilization_metrics_enabled(mut self, input: bool) -> Self {
            self.room_utilization_metrics_enabled = Some(input);
            self
        }
        /// <p>Whether room utilization metrics are enabled or not.</p>
        pub fn set_room_utilization_metrics_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.room_utilization_metrics_enabled = input;
            self
        }
        /// <p>Creates settings for the end of meeting reminder feature that are applied to a room
        /// profile. The end of meeting reminder enables Alexa to remind users when a meeting is
        /// ending.</p>
        pub fn end_of_meeting_reminder(
            mut self,
            input: crate::model::CreateEndOfMeetingReminder,
        ) -> Self {
            self.end_of_meeting_reminder = Some(input);
            self
        }
        /// <p>Creates settings for the end of meeting reminder feature that are applied to a room
        /// profile. The end of meeting reminder enables Alexa to remind users when a meeting is
        /// ending.</p>
        pub fn set_end_of_meeting_reminder(
            mut self,
            input: std::option::Option<crate::model::CreateEndOfMeetingReminder>,
        ) -> Self {
            self.end_of_meeting_reminder = input;
            self
        }
        /// <p>Settings to automatically book a room for a configured duration if it's free when joining a meeting with Alexa.</p>
        pub fn instant_booking(mut self, input: crate::model::CreateInstantBooking) -> Self {
            self.instant_booking = Some(input);
            self
        }
        /// <p>Settings to automatically book a room for a configured duration if it's free when joining a meeting with Alexa.</p>
        pub fn set_instant_booking(
            mut self,
            input: std::option::Option<crate::model::CreateInstantBooking>,
        ) -> Self {
            self.instant_booking = input;
            self
        }
        /// <p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.”</p>
        pub fn require_check_in(mut self, input: crate::model::CreateRequireCheckIn) -> Self {
            self.require_check_in = Some(input);
            self
        }
        /// <p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.”</p>
        pub fn set_require_check_in(
            mut self,
            input: std::option::Option<crate::model::CreateRequireCheckIn>,
        ) -> Self {
            self.require_check_in = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMeetingRoomConfiguration`](crate::model::CreateMeetingRoomConfiguration)
        pub fn build(self) -> crate::model::CreateMeetingRoomConfiguration {
            crate::model::CreateMeetingRoomConfiguration {
                room_utilization_metrics_enabled: self.room_utilization_metrics_enabled,
                end_of_meeting_reminder: self.end_of_meeting_reminder,
                instant_booking: self.instant_booking,
                require_check_in: self.require_check_in,
            }
        }
    }
}
impl CreateMeetingRoomConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateMeetingRoomConfiguration`](crate::model::CreateMeetingRoomConfiguration)
    pub fn builder() -> crate::model::create_meeting_room_configuration::Builder {
        crate::model::create_meeting_room_configuration::Builder::default()
    }
}

/// <p>Creates settings for the require check in feature that are applied to a room profile. Require check in allows a meeting room’s Alexa or AVS device to prompt the user to check in; otherwise, the room will be released.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRequireCheckIn {
    /// <p>Duration between 5 and 20 minutes to determine when to release the room if it's not checked into.</p>
    pub release_after_minutes: std::option::Option<i32>,
    /// <p>Whether require check in is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for CreateRequireCheckIn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRequireCheckIn");
        formatter.field("release_after_minutes", &self.release_after_minutes);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`CreateRequireCheckIn`](crate::model::CreateRequireCheckIn)
pub mod create_require_check_in {
    /// A builder for [`CreateRequireCheckIn`](crate::model::CreateRequireCheckIn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) release_after_minutes: std::option::Option<i32>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Duration between 5 and 20 minutes to determine when to release the room if it's not checked into.</p>
        pub fn release_after_minutes(mut self, input: i32) -> Self {
            self.release_after_minutes = Some(input);
            self
        }
        /// <p>Duration between 5 and 20 minutes to determine when to release the room if it's not checked into.</p>
        pub fn set_release_after_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.release_after_minutes = input;
            self
        }
        /// <p>Whether require check in is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether require check in is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRequireCheckIn`](crate::model::CreateRequireCheckIn)
        pub fn build(self) -> crate::model::CreateRequireCheckIn {
            crate::model::CreateRequireCheckIn {
                release_after_minutes: self.release_after_minutes,
                enabled: self.enabled,
            }
        }
    }
}
impl CreateRequireCheckIn {
    /// Creates a new builder-style object to manufacture [`CreateRequireCheckIn`](crate::model::CreateRequireCheckIn)
    pub fn builder() -> crate::model::create_require_check_in::Builder {
        crate::model::create_require_check_in::Builder::default()
    }
}

/// <p>Creates settings for the instant booking feature that are applied to a room profile.
/// When users start their meeting with Alexa, Alexa automatically books the room for the
/// configured duration if the room is available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInstantBooking {
    /// <p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book
    /// an available room when a meeting is started with Alexa.</p>
    pub duration_in_minutes: std::option::Option<i32>,
    /// <p>Whether instant booking is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for CreateInstantBooking {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInstantBooking");
        formatter.field("duration_in_minutes", &self.duration_in_minutes);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`CreateInstantBooking`](crate::model::CreateInstantBooking)
pub mod create_instant_booking {
    /// A builder for [`CreateInstantBooking`](crate::model::CreateInstantBooking)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_minutes: std::option::Option<i32>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book
        /// an available room when a meeting is started with Alexa.</p>
        pub fn duration_in_minutes(mut self, input: i32) -> Self {
            self.duration_in_minutes = Some(input);
            self
        }
        /// <p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book
        /// an available room when a meeting is started with Alexa.</p>
        pub fn set_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_minutes = input;
            self
        }
        /// <p>Whether instant booking is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether instant booking is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstantBooking`](crate::model::CreateInstantBooking)
        pub fn build(self) -> crate::model::CreateInstantBooking {
            crate::model::CreateInstantBooking {
                duration_in_minutes: self.duration_in_minutes,
                enabled: self.enabled,
            }
        }
    }
}
impl CreateInstantBooking {
    /// Creates a new builder-style object to manufacture [`CreateInstantBooking`](crate::model::CreateInstantBooking)
    pub fn builder() -> crate::model::create_instant_booking::Builder {
        crate::model::create_instant_booking::Builder::default()
    }
}

/// <p>Creates settings for the end of meeting reminder feature that are applied to a room
/// profile. The end of meeting reminder enables Alexa to remind users when a meeting is
/// ending.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEndOfMeetingReminder {
    /// <p> A range of 3 to 15 minutes that determines when the reminder begins.</p>
    pub reminder_at_minutes: std::option::Option<std::vec::Vec<i32>>,
    /// <p>The type of sound that users hear during the end of meeting reminder. </p>
    pub reminder_type: std::option::Option<crate::model::EndOfMeetingReminderType>,
    /// <p>Whether an end of meeting reminder is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for CreateEndOfMeetingReminder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEndOfMeetingReminder");
        formatter.field("reminder_at_minutes", &self.reminder_at_minutes);
        formatter.field("reminder_type", &self.reminder_type);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`CreateEndOfMeetingReminder`](crate::model::CreateEndOfMeetingReminder)
pub mod create_end_of_meeting_reminder {
    /// A builder for [`CreateEndOfMeetingReminder`](crate::model::CreateEndOfMeetingReminder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reminder_at_minutes: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) reminder_type: std::option::Option<crate::model::EndOfMeetingReminderType>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `reminder_at_minutes`.
        ///
        /// To override the contents of this collection use [`set_reminder_at_minutes`](Self::set_reminder_at_minutes).
        ///
        /// <p> A range of 3 to 15 minutes that determines when the reminder begins.</p>
        pub fn reminder_at_minutes(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.reminder_at_minutes.unwrap_or_default();
            v.push(input.into());
            self.reminder_at_minutes = Some(v);
            self
        }
        /// <p> A range of 3 to 15 minutes that determines when the reminder begins.</p>
        pub fn set_reminder_at_minutes(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.reminder_at_minutes = input;
            self
        }
        /// <p>The type of sound that users hear during the end of meeting reminder. </p>
        pub fn reminder_type(mut self, input: crate::model::EndOfMeetingReminderType) -> Self {
            self.reminder_type = Some(input);
            self
        }
        /// <p>The type of sound that users hear during the end of meeting reminder. </p>
        pub fn set_reminder_type(
            mut self,
            input: std::option::Option<crate::model::EndOfMeetingReminderType>,
        ) -> Self {
            self.reminder_type = input;
            self
        }
        /// <p>Whether an end of meeting reminder is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether an end of meeting reminder is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEndOfMeetingReminder`](crate::model::CreateEndOfMeetingReminder)
        pub fn build(self) -> crate::model::CreateEndOfMeetingReminder {
            crate::model::CreateEndOfMeetingReminder {
                reminder_at_minutes: self.reminder_at_minutes,
                reminder_type: self.reminder_type,
                enabled: self.enabled,
            }
        }
    }
}
impl CreateEndOfMeetingReminder {
    /// Creates a new builder-style object to manufacture [`CreateEndOfMeetingReminder`](crate::model::CreateEndOfMeetingReminder)
    pub fn builder() -> crate::model::create_end_of_meeting_reminder::Builder {
        crate::model::create_end_of_meeting_reminder::Builder::default()
    }
}
