// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`ApproveSkillInput`](crate::input::ApproveSkillInput)
pub mod approve_skill_input {
    /// A builder for [`ApproveSkillInput`](crate::input::ApproveSkillInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the skill.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ApproveSkillInput`](crate::input::ApproveSkillInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApproveSkillInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApproveSkillInput {
                skill_id: self.skill_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ApproveSkillInputOperationOutputAlias = crate::operation::ApproveSkill;
#[doc(hidden)]
pub type ApproveSkillInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ApproveSkillInput {
    /// Consumes the builder and constructs an Operation<[`ApproveSkill`](crate::operation::ApproveSkill)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApproveSkill,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ApproveSkillInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ApproveSkillInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ApproveSkillInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ApproveSkill",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_approve_skill(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApproveSkill::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApproveSkill",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ApproveSkillInput`](crate::input::ApproveSkillInput)
    pub fn builder() -> crate::input::approve_skill_input::Builder {
        crate::input::approve_skill_input::Builder::default()
    }
}

/// See [`AssociateContactWithAddressBookInput`](crate::input::AssociateContactWithAddressBookInput)
pub mod associate_contact_with_address_book_input {
    /// A builder for [`AssociateContactWithAddressBookInput`](crate::input::AssociateContactWithAddressBookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) address_book_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the contact to associate with an address book.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact to associate with an address book.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The ARN of the address book with which to associate the contact.</p>
        pub fn address_book_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_book_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the address book with which to associate the contact.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_book_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateContactWithAddressBookInput`](crate::input::AssociateContactWithAddressBookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateContactWithAddressBookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateContactWithAddressBookInput {
                contact_arn: self.contact_arn,
                address_book_arn: self.address_book_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateContactWithAddressBookInputOperationOutputAlias =
    crate::operation::AssociateContactWithAddressBook;
#[doc(hidden)]
pub type AssociateContactWithAddressBookInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateContactWithAddressBookInput {
    /// Consumes the builder and constructs an Operation<[`AssociateContactWithAddressBook`](crate::operation::AssociateContactWithAddressBook)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateContactWithAddressBook,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateContactWithAddressBookInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateContactWithAddressBookInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateContactWithAddressBookInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.AssociateContactWithAddressBook",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_contact_with_address_book(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateContactWithAddressBook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateContactWithAddressBook",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateContactWithAddressBookInput`](crate::input::AssociateContactWithAddressBookInput)
    pub fn builder() -> crate::input::associate_contact_with_address_book_input::Builder {
        crate::input::associate_contact_with_address_book_input::Builder::default()
    }
}

/// See [`AssociateDeviceWithNetworkProfileInput`](crate::input::AssociateDeviceWithNetworkProfileInput)
pub mod associate_device_with_network_profile_input {
    /// A builder for [`AssociateDeviceWithNetworkProfileInput`](crate::input::AssociateDeviceWithNetworkProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) network_profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device ARN.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The device ARN.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The ARN of the network profile to associate with a device.</p>
        pub fn network_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile to associate with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateDeviceWithNetworkProfileInput`](crate::input::AssociateDeviceWithNetworkProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateDeviceWithNetworkProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateDeviceWithNetworkProfileInput {
                device_arn: self.device_arn,
                network_profile_arn: self.network_profile_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateDeviceWithNetworkProfileInputOperationOutputAlias =
    crate::operation::AssociateDeviceWithNetworkProfile;
#[doc(hidden)]
pub type AssociateDeviceWithNetworkProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateDeviceWithNetworkProfileInput {
    /// Consumes the builder and constructs an Operation<[`AssociateDeviceWithNetworkProfile`](crate::operation::AssociateDeviceWithNetworkProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateDeviceWithNetworkProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateDeviceWithNetworkProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateDeviceWithNetworkProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateDeviceWithNetworkProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.AssociateDeviceWithNetworkProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_device_with_network_profile(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateDeviceWithNetworkProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateDeviceWithNetworkProfile",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateDeviceWithNetworkProfileInput`](crate::input::AssociateDeviceWithNetworkProfileInput)
    pub fn builder() -> crate::input::associate_device_with_network_profile_input::Builder {
        crate::input::associate_device_with_network_profile_input::Builder::default()
    }
}

/// See [`AssociateDeviceWithRoomInput`](crate::input::AssociateDeviceWithRoomInput)
pub mod associate_device_with_room_input {
    /// A builder for [`AssociateDeviceWithRoomInput`](crate::input::AssociateDeviceWithRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the device to associate to a room. Required.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device to associate to a room. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The ARN of the room with which to associate the device. Required.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room with which to associate the device. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateDeviceWithRoomInput`](crate::input::AssociateDeviceWithRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateDeviceWithRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateDeviceWithRoomInput {
                device_arn: self.device_arn,
                room_arn: self.room_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateDeviceWithRoomInputOperationOutputAlias =
    crate::operation::AssociateDeviceWithRoom;
#[doc(hidden)]
pub type AssociateDeviceWithRoomInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateDeviceWithRoomInput {
    /// Consumes the builder and constructs an Operation<[`AssociateDeviceWithRoom`](crate::operation::AssociateDeviceWithRoom)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateDeviceWithRoom,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateDeviceWithRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateDeviceWithRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateDeviceWithRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.AssociateDeviceWithRoom",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_device_with_room(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateDeviceWithRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateDeviceWithRoom",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateDeviceWithRoomInput`](crate::input::AssociateDeviceWithRoomInput)
    pub fn builder() -> crate::input::associate_device_with_room_input::Builder {
        crate::input::associate_device_with_room_input::Builder::default()
    }
}

/// See [`AssociateSkillGroupWithRoomInput`](crate::input::AssociateSkillGroupWithRoomInput)
pub mod associate_skill_group_with_room_input {
    /// A builder for [`AssociateSkillGroupWithRoomInput`](crate::input::AssociateSkillGroupWithRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
        pub(crate) room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the skill group to associate with a room. Required.</p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the skill group to associate with a room. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// <p>The ARN of the room with which to associate the skill group. Required.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room with which to associate the skill group. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateSkillGroupWithRoomInput`](crate::input::AssociateSkillGroupWithRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateSkillGroupWithRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateSkillGroupWithRoomInput {
                skill_group_arn: self.skill_group_arn,
                room_arn: self.room_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateSkillGroupWithRoomInputOperationOutputAlias =
    crate::operation::AssociateSkillGroupWithRoom;
#[doc(hidden)]
pub type AssociateSkillGroupWithRoomInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateSkillGroupWithRoomInput {
    /// Consumes the builder and constructs an Operation<[`AssociateSkillGroupWithRoom`](crate::operation::AssociateSkillGroupWithRoom)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateSkillGroupWithRoom,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateSkillGroupWithRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateSkillGroupWithRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateSkillGroupWithRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.AssociateSkillGroupWithRoom",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_skill_group_with_room(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateSkillGroupWithRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateSkillGroupWithRoom",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateSkillGroupWithRoomInput`](crate::input::AssociateSkillGroupWithRoomInput)
    pub fn builder() -> crate::input::associate_skill_group_with_room_input::Builder {
        crate::input::associate_skill_group_with_room_input::Builder::default()
    }
}

/// See [`AssociateSkillWithSkillGroupInput`](crate::input::AssociateSkillWithSkillGroupInput)
pub mod associate_skill_with_skill_group_input {
    /// A builder for [`AssociateSkillWithSkillGroupInput`](crate::input::AssociateSkillWithSkillGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
        pub(crate) skill_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the skill group to associate the skill to. Required.</p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the skill group to associate the skill to. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateSkillWithSkillGroupInput`](crate::input::AssociateSkillWithSkillGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateSkillWithSkillGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateSkillWithSkillGroupInput {
                skill_group_arn: self.skill_group_arn,
                skill_id: self.skill_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateSkillWithSkillGroupInputOperationOutputAlias =
    crate::operation::AssociateSkillWithSkillGroup;
#[doc(hidden)]
pub type AssociateSkillWithSkillGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateSkillWithSkillGroupInput {
    /// Consumes the builder and constructs an Operation<[`AssociateSkillWithSkillGroup`](crate::operation::AssociateSkillWithSkillGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateSkillWithSkillGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateSkillWithSkillGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateSkillWithSkillGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateSkillWithSkillGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.AssociateSkillWithSkillGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_skill_with_skill_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateSkillWithSkillGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateSkillWithSkillGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateSkillWithSkillGroupInput`](crate::input::AssociateSkillWithSkillGroupInput)
    pub fn builder() -> crate::input::associate_skill_with_skill_group_input::Builder {
        crate::input::associate_skill_with_skill_group_input::Builder::default()
    }
}

/// See [`AssociateSkillWithUsersInput`](crate::input::AssociateSkillWithUsersInput)
pub mod associate_skill_with_users_input {
    /// A builder for [`AssociateSkillWithUsersInput`](crate::input::AssociateSkillWithUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The private skill ID you want to make available to enrolled users.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The private skill ID you want to make available to enrolled users.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateSkillWithUsersInput`](crate::input::AssociateSkillWithUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateSkillWithUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateSkillWithUsersInput {
                skill_id: self.skill_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateSkillWithUsersInputOperationOutputAlias =
    crate::operation::AssociateSkillWithUsers;
#[doc(hidden)]
pub type AssociateSkillWithUsersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateSkillWithUsersInput {
    /// Consumes the builder and constructs an Operation<[`AssociateSkillWithUsers`](crate::operation::AssociateSkillWithUsers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateSkillWithUsers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateSkillWithUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateSkillWithUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateSkillWithUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.AssociateSkillWithUsers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_skill_with_users(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateSkillWithUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateSkillWithUsers",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateSkillWithUsersInput`](crate::input::AssociateSkillWithUsersInput)
    pub fn builder() -> crate::input::associate_skill_with_users_input::Builder {
        crate::input::associate_skill_with_users_input::Builder::default()
    }
}

/// See [`CreateAddressBookInput`](crate::input::CreateAddressBookInput)
pub mod create_address_book_input {
    /// A builder for [`CreateAddressBookInput`](crate::input::CreateAddressBookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the address book.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the address book.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the address book.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the address book.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures
        /// idempotency.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures
        /// idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAddressBookInput`](crate::input::CreateAddressBookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAddressBookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAddressBookInput {
                name: self.name,
                description: self.description,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAddressBookInputOperationOutputAlias = crate::operation::CreateAddressBook;
#[doc(hidden)]
pub type CreateAddressBookInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAddressBookInput {
    /// Consumes the builder and constructs an Operation<[`CreateAddressBook`](crate::operation::CreateAddressBook)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAddressBook,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAddressBookInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAddressBookInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAddressBookInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateAddressBook",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_address_book(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAddressBook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAddressBook",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAddressBookInput`](crate::input::CreateAddressBookInput)
    pub fn builder() -> crate::input::create_address_book_input::Builder {
        crate::input::create_address_book_input::Builder::default()
    }
}

/// See [`CreateBusinessReportScheduleInput`](crate::input::CreateBusinessReportScheduleInput)
pub mod create_business_report_schedule_input {
    /// A builder for [`CreateBusinessReportScheduleInput`](crate::input::CreateBusinessReportScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::BusinessReportFormat>,
        pub(crate) content_range: std::option::Option<crate::model::BusinessReportContentRange>,
        pub(crate) recurrence: std::option::Option<crate::model::BusinessReportRecurrence>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name identifier of the schedule.</p>
        pub fn schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_name = Some(input.into());
            self
        }
        /// <p>The name identifier of the schedule.</p>
        pub fn set_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_name = input;
            self
        }
        /// <p>The S3 bucket name of the output reports. If this isn't specified, the report can be
        /// retrieved from a download link by calling ListBusinessReportSchedule. </p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The S3 bucket name of the output reports. If this isn't specified, the report can be
        /// retrieved from a download link by calling ListBusinessReportSchedule. </p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn format(mut self, input: crate::model::BusinessReportFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::BusinessReportFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The content range of the reports.</p>
        pub fn content_range(mut self, input: crate::model::BusinessReportContentRange) -> Self {
            self.content_range = Some(input);
            self
        }
        /// <p>The content range of the reports.</p>
        pub fn set_content_range(
            mut self,
            input: std::option::Option<crate::model::BusinessReportContentRange>,
        ) -> Self {
            self.content_range = input;
            self
        }
        /// <p>The recurrence of the reports. If this isn't specified, the report will only be
        /// delivered one time when the API is called. </p>
        pub fn recurrence(mut self, input: crate::model::BusinessReportRecurrence) -> Self {
            self.recurrence = Some(input);
            self
        }
        /// <p>The recurrence of the reports. If this isn't specified, the report will only be
        /// delivered one time when the API is called. </p>
        pub fn set_recurrence(
            mut self,
            input: std::option::Option<crate::model::BusinessReportRecurrence>,
        ) -> Self {
            self.recurrence = input;
            self
        }
        /// <p>The client request token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The client request token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the business report schedule.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the business report schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBusinessReportScheduleInput`](crate::input::CreateBusinessReportScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBusinessReportScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBusinessReportScheduleInput {
                schedule_name: self.schedule_name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                format: self.format,
                content_range: self.content_range,
                recurrence: self.recurrence,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBusinessReportScheduleInputOperationOutputAlias =
    crate::operation::CreateBusinessReportSchedule;
#[doc(hidden)]
pub type CreateBusinessReportScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBusinessReportScheduleInput {
    /// Consumes the builder and constructs an Operation<[`CreateBusinessReportSchedule`](crate::operation::CreateBusinessReportSchedule)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBusinessReportSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBusinessReportScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBusinessReportScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBusinessReportScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateBusinessReportSchedule",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_business_report_schedule(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBusinessReportSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBusinessReportSchedule",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBusinessReportScheduleInput`](crate::input::CreateBusinessReportScheduleInput)
    pub fn builder() -> crate::input::create_business_report_schedule_input::Builder {
        crate::input::create_business_report_schedule_input::Builder::default()
    }
}

/// See [`CreateConferenceProviderInput`](crate::input::CreateConferenceProviderInput)
pub mod create_conference_provider_input {
    /// A builder for [`CreateConferenceProviderInput`](crate::input::CreateConferenceProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conference_provider_name: std::option::Option<std::string::String>,
        pub(crate) conference_provider_type:
            std::option::Option<crate::model::ConferenceProviderType>,
        pub(crate) ip_dial_in: std::option::Option<crate::model::IpDialIn>,
        pub(crate) pstn_dial_in: std::option::Option<crate::model::PstnDialIn>,
        pub(crate) meeting_setting: std::option::Option<crate::model::MeetingSetting>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the conference provider.</p>
        pub fn conference_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conference_provider_name = Some(input.into());
            self
        }
        /// <p>The name of the conference provider.</p>
        pub fn set_conference_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conference_provider_name = input;
            self
        }
        /// <p>Represents a type within a list of predefined types.</p>
        pub fn conference_provider_type(
            mut self,
            input: crate::model::ConferenceProviderType,
        ) -> Self {
            self.conference_provider_type = Some(input);
            self
        }
        /// <p>Represents a type within a list of predefined types.</p>
        pub fn set_conference_provider_type(
            mut self,
            input: std::option::Option<crate::model::ConferenceProviderType>,
        ) -> Self {
            self.conference_provider_type = input;
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn ip_dial_in(mut self, input: crate::model::IpDialIn) -> Self {
            self.ip_dial_in = Some(input);
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn set_ip_dial_in(
            mut self,
            input: std::option::Option<crate::model::IpDialIn>,
        ) -> Self {
            self.ip_dial_in = input;
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn pstn_dial_in(mut self, input: crate::model::PstnDialIn) -> Self {
            self.pstn_dial_in = Some(input);
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn set_pstn_dial_in(
            mut self,
            input: std::option::Option<crate::model::PstnDialIn>,
        ) -> Self {
            self.pstn_dial_in = input;
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn meeting_setting(mut self, input: crate::model::MeetingSetting) -> Self {
            self.meeting_setting = Some(input);
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn set_meeting_setting(
            mut self,
            input: std::option::Option<crate::model::MeetingSetting>,
        ) -> Self {
            self.meeting_setting = input;
            self
        }
        /// <p>The request token of the client.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The request token of the client.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConferenceProviderInput`](crate::input::CreateConferenceProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConferenceProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConferenceProviderInput {
                conference_provider_name: self.conference_provider_name,
                conference_provider_type: self.conference_provider_type,
                ip_dial_in: self.ip_dial_in,
                pstn_dial_in: self.pstn_dial_in,
                meeting_setting: self.meeting_setting,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConferenceProviderInputOperationOutputAlias =
    crate::operation::CreateConferenceProvider;
#[doc(hidden)]
pub type CreateConferenceProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConferenceProviderInput {
    /// Consumes the builder and constructs an Operation<[`CreateConferenceProvider`](crate::operation::CreateConferenceProvider)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConferenceProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConferenceProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConferenceProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConferenceProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateConferenceProvider",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_conference_provider(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConferenceProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConferenceProvider",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConferenceProviderInput`](crate::input::CreateConferenceProviderInput)
    pub fn builder() -> crate::input::create_conference_provider_input::Builder {
        crate::input::create_conference_provider_input::Builder::default()
    }
}

/// See [`CreateContactInput`](crate::input::CreateContactInput)
pub mod create_contact_input {
    /// A builder for [`CreateContactInput`](crate::input::CreateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) phone_numbers: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        pub(crate) sip_addresses: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the contact to display on the console.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the contact to display on the console.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The first name of the contact that is used to call the contact on the
        /// device.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name of the contact that is used to call the contact on the
        /// device.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name of the contact that is used to call the contact on the
        /// device.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name of the contact that is used to call the contact on the
        /// device.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The phone number of the contact in E.164 format. The phone number type defaults to
        /// WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
        /// which lets you specify the phone number type and multiple numbers.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number of the contact in E.164 format. The phone number type defaults to
        /// WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
        /// which lets you specify the phone number type and multiple numbers.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// Appends an item to `phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_phone_numbers`](Self::set_phone_numbers).
        ///
        /// <p>The list of phone numbers for the contact.</p>
        pub fn phone_numbers(mut self, input: impl Into<crate::model::PhoneNumber>) -> Self {
            let mut v = self.phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.phone_numbers = Some(v);
            self
        }
        /// <p>The list of phone numbers for the contact.</p>
        pub fn set_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        ) -> Self {
            self.phone_numbers = input;
            self
        }
        /// Appends an item to `sip_addresses`.
        ///
        /// To override the contents of this collection use [`set_sip_addresses`](Self::set_sip_addresses).
        ///
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn sip_addresses(mut self, input: impl Into<crate::model::SipAddress>) -> Self {
            let mut v = self.sip_addresses.unwrap_or_default();
            v.push(input.into());
            self.sip_addresses = Some(v);
            self
        }
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn set_sip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
        ) -> Self {
            self.sip_addresses = input;
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures
        /// idempotency.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures
        /// idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactInput`](crate::input::CreateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContactInput {
                display_name: self.display_name,
                first_name: self.first_name,
                last_name: self.last_name,
                phone_number: self.phone_number,
                phone_numbers: self.phone_numbers,
                sip_addresses: self.sip_addresses,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContactInputOperationOutputAlias = crate::operation::CreateContact;
#[doc(hidden)]
pub type CreateContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateContactInput {
    /// Consumes the builder and constructs an Operation<[`CreateContact`](crate::operation::CreateContact)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateContact",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_contact(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContact",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateContactInput`](crate::input::CreateContactInput)
    pub fn builder() -> crate::input::create_contact_input::Builder {
        crate::input::create_contact_input::Builder::default()
    }
}

/// See [`CreateGatewayGroupInput`](crate::input::CreateGatewayGroupInput)
pub mod create_gateway_group_input {
    /// A builder for [`CreateGatewayGroupInput`](crate::input::CreateGatewayGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the gateway group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the gateway group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the gateway group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the gateway group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGatewayGroupInput`](crate::input::CreateGatewayGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGatewayGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGatewayGroupInput {
                name: self.name,
                description: self.description,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGatewayGroupInputOperationOutputAlias = crate::operation::CreateGatewayGroup;
#[doc(hidden)]
pub type CreateGatewayGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGatewayGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGatewayGroup`](crate::operation::CreateGatewayGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGatewayGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGatewayGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGatewayGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGatewayGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateGatewayGroup",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_gateway_group(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGatewayGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGatewayGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGatewayGroupInput`](crate::input::CreateGatewayGroupInput)
    pub fn builder() -> crate::input::create_gateway_group_input::Builder {
        crate::input::create_gateway_group_input::Builder::default()
    }
}

/// See [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
pub mod create_network_profile_input {
    /// A builder for [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ssid: std::option::Option<std::string::String>,
        pub(crate) security_type: std::option::Option<crate::model::NetworkSecurityType>,
        pub(crate) eap_method: std::option::Option<crate::model::NetworkEapMethod>,
        pub(crate) current_password: std::option::Option<std::string::String>,
        pub(crate) next_password: std::option::Option<std::string::String>,
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) trust_anchors: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the network profile associated with a device.</p>
        pub fn network_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn set_network_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_name = input;
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The SSID of the Wi-Fi network.</p>
        pub fn ssid(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssid = Some(input.into());
            self
        }
        /// <p>The SSID of the Wi-Fi network.</p>
        pub fn set_ssid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssid = input;
            self
        }
        /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
        /// WEP, or OPEN.</p>
        pub fn security_type(mut self, input: crate::model::NetworkSecurityType) -> Self {
            self.security_type = Some(input);
            self
        }
        /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
        /// WEP, or OPEN.</p>
        pub fn set_security_type(
            mut self,
            input: std::option::Option<crate::model::NetworkSecurityType>,
        ) -> Self {
            self.security_type = input;
            self
        }
        /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
        /// supported.</p>
        pub fn eap_method(mut self, input: crate::model::NetworkEapMethod) -> Self {
            self.eap_method = Some(input);
            self
        }
        /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
        /// supported.</p>
        pub fn set_eap_method(
            mut self,
            input: std::option::Option<crate::model::NetworkEapMethod>,
        ) -> Self {
            self.eap_method = input;
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn current_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_password = Some(input.into());
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn set_current_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_password = input;
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn next_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_password = Some(input.into());
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn set_next_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_password = input;
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Appends an item to `trust_anchors`.
        ///
        /// To override the contents of this collection use [`set_trust_anchors`](Self::set_trust_anchors).
        ///
        /// <p>The root certificates of your authentication server that is installed on your devices
        /// and used to trust your authentication server during EAP negotiation. </p>
        pub fn trust_anchors(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trust_anchors.unwrap_or_default();
            v.push(input.into());
            self.trust_anchors = Some(v);
            self
        }
        /// <p>The root certificates of your authentication server that is installed on your devices
        /// and used to trust your authentication server during EAP negotiation. </p>
        pub fn set_trust_anchors(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trust_anchors = input;
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkProfileInput {
                network_profile_name: self.network_profile_name,
                description: self.description,
                ssid: self.ssid,
                security_type: self.security_type,
                eap_method: self.eap_method,
                current_password: self.current_password,
                next_password: self.next_password,
                certificate_authority_arn: self.certificate_authority_arn,
                trust_anchors: self.trust_anchors,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkProfileInputOperationOutputAlias = crate::operation::CreateNetworkProfile;
#[doc(hidden)]
pub type CreateNetworkProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateNetworkProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetworkProfile`](crate::operation::CreateNetworkProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetworkProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNetworkProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNetworkProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNetworkProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateNetworkProfile",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_network_profile(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetworkProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetworkProfile",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
    pub fn builder() -> crate::input::create_network_profile_input::Builder {
        crate::input::create_network_profile_input::Builder::default()
    }
}

/// See [`CreateProfileInput`](crate::input::CreateProfileInput)
pub mod create_profile_input {
    /// A builder for [`CreateProfileInput`](crate::input::CreateProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) distance_unit: std::option::Option<crate::model::DistanceUnit>,
        pub(crate) temperature_unit: std::option::Option<crate::model::TemperatureUnit>,
        pub(crate) wake_word: std::option::Option<crate::model::WakeWord>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) setup_mode_disabled: std::option::Option<bool>,
        pub(crate) max_volume_limit: std::option::Option<i32>,
        pub(crate) pstn_enabled: std::option::Option<bool>,
        pub(crate) data_retention_opt_in: std::option::Option<bool>,
        pub(crate) meeting_room_configuration:
            std::option::Option<crate::model::CreateMeetingRoomConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of a room profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of a room profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The time zone used by a room profile.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone used by a room profile.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>The valid address for the room.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The valid address for the room.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The distance unit to be used by devices in the profile.</p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.distance_unit = Some(input);
            self
        }
        /// <p>The distance unit to be used by devices in the profile.</p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.distance_unit = input;
            self
        }
        /// <p>The temperature unit to be used by devices in the profile.</p>
        pub fn temperature_unit(mut self, input: crate::model::TemperatureUnit) -> Self {
            self.temperature_unit = Some(input);
            self
        }
        /// <p>The temperature unit to be used by devices in the profile.</p>
        pub fn set_temperature_unit(
            mut self,
            input: std::option::Option<crate::model::TemperatureUnit>,
        ) -> Self {
            self.temperature_unit = input;
            self
        }
        /// <p>A wake word for Alexa, Echo, Amazon, or a computer.</p>
        pub fn wake_word(mut self, input: crate::model::WakeWord) -> Self {
            self.wake_word = Some(input);
            self
        }
        /// <p>A wake word for Alexa, Echo, Amazon, or a computer.</p>
        pub fn set_wake_word(mut self, input: std::option::Option<crate::model::WakeWord>) -> Self {
            self.wake_word = input;
            self
        }
        /// <p>The locale of the room profile. (This is currently only available to a limited preview audience.)</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale of the room profile. (This is currently only available to a limited preview audience.)</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The user-specified token that is used during the creation of a profile.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The user-specified token that is used during the creation of a profile.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Whether room profile setup is enabled.</p>
        pub fn setup_mode_disabled(mut self, input: bool) -> Self {
            self.setup_mode_disabled = Some(input);
            self
        }
        /// <p>Whether room profile setup is enabled.</p>
        pub fn set_setup_mode_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.setup_mode_disabled = input;
            self
        }
        /// <p>The maximum volume limit for a room profile.</p>
        pub fn max_volume_limit(mut self, input: i32) -> Self {
            self.max_volume_limit = Some(input);
            self
        }
        /// <p>The maximum volume limit for a room profile.</p>
        pub fn set_max_volume_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.max_volume_limit = input;
            self
        }
        /// <p>Whether PSTN calling is enabled.</p>
        pub fn pstn_enabled(mut self, input: bool) -> Self {
            self.pstn_enabled = Some(input);
            self
        }
        /// <p>Whether PSTN calling is enabled.</p>
        pub fn set_pstn_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.pstn_enabled = input;
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn data_retention_opt_in(mut self, input: bool) -> Self {
            self.data_retention_opt_in = Some(input);
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn set_data_retention_opt_in(mut self, input: std::option::Option<bool>) -> Self {
            self.data_retention_opt_in = input;
            self
        }
        /// <p>The meeting room settings of a room profile.</p>
        pub fn meeting_room_configuration(
            mut self,
            input: crate::model::CreateMeetingRoomConfiguration,
        ) -> Self {
            self.meeting_room_configuration = Some(input);
            self
        }
        /// <p>The meeting room settings of a room profile.</p>
        pub fn set_meeting_room_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateMeetingRoomConfiguration>,
        ) -> Self {
            self.meeting_room_configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the profile.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProfileInput`](crate::input::CreateProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProfileInput {
                profile_name: self.profile_name,
                timezone: self.timezone,
                address: self.address,
                distance_unit: self.distance_unit,
                temperature_unit: self.temperature_unit,
                wake_word: self.wake_word,
                locale: self.locale,
                client_request_token: self.client_request_token,
                setup_mode_disabled: self.setup_mode_disabled,
                max_volume_limit: self.max_volume_limit,
                pstn_enabled: self.pstn_enabled,
                data_retention_opt_in: self.data_retention_opt_in,
                meeting_room_configuration: self.meeting_room_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProfileInputOperationOutputAlias = crate::operation::CreateProfile;
#[doc(hidden)]
pub type CreateProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateProfile`](crate::operation::CreateProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateProfile",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_profile(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProfile",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProfileInput`](crate::input::CreateProfileInput)
    pub fn builder() -> crate::input::create_profile_input::Builder {
        crate::input::create_profile_input::Builder::default()
    }
}

/// See [`CreateRoomInput`](crate::input::CreateRoomInput)
pub mod create_room_input {
    /// A builder for [`CreateRoomInput`](crate::input::CreateRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) profile_arn: std::option::Option<std::string::String>,
        pub(crate) provider_calendar_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the room.</p>
        pub fn room_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_name = Some(input.into());
            self
        }
        /// <p>The name for the room.</p>
        pub fn set_room_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_name = input;
            self
        }
        /// <p>The description for the room.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the room.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The profile ARN for the room. This is required.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The profile ARN for the room. This is required.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// <p>The calendar ARN for the room.</p>
        pub fn provider_calendar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_calendar_id = Some(input.into());
            self
        }
        /// <p>The calendar ARN for the room.</p>
        pub fn set_provider_calendar_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_calendar_id = input;
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the room.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the room.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoomInput`](crate::input::CreateRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRoomInput {
                room_name: self.room_name,
                description: self.description,
                profile_arn: self.profile_arn,
                provider_calendar_id: self.provider_calendar_id,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRoomInputOperationOutputAlias = crate::operation::CreateRoom;
#[doc(hidden)]
pub type CreateRoomInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRoomInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoom`](crate::operation::CreateRoom)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoom,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateRoom",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_room(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoom",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRoomInput`](crate::input::CreateRoomInput)
    pub fn builder() -> crate::input::create_room_input::Builder {
        crate::input::create_room_input::Builder::default()
    }
}

/// See [`CreateSkillGroupInput`](crate::input::CreateSkillGroupInput)
pub mod create_skill_group_input {
    /// A builder for [`CreateSkillGroupInput`](crate::input::CreateSkillGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the skill group.</p>
        pub fn skill_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_name = Some(input.into());
            self
        }
        /// <p>The name for the skill group.</p>
        pub fn set_skill_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_name = input;
            self
        }
        /// <p>The description for the skill group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the skill group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the skill group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the skill group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSkillGroupInput`](crate::input::CreateSkillGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSkillGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSkillGroupInput {
                skill_group_name: self.skill_group_name,
                description: self.description,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSkillGroupInputOperationOutputAlias = crate::operation::CreateSkillGroup;
#[doc(hidden)]
pub type CreateSkillGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSkillGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateSkillGroup`](crate::operation::CreateSkillGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSkillGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSkillGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSkillGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSkillGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateSkillGroup",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_skill_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSkillGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSkillGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSkillGroupInput`](crate::input::CreateSkillGroupInput)
    pub fn builder() -> crate::input::create_skill_group_input::Builder {
        crate::input::create_skill_group_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN for the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ARN for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The first name for the user.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name for the user.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name for the user.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name for the user.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The email address for the user.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address for the user.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the user.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the user.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                user_id: self.user_id,
                first_name: self.first_name,
                last_name: self.last_name,
                email: self.email,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.CreateUser",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`DeleteAddressBookInput`](crate::input::DeleteAddressBookInput)
pub mod delete_address_book_input {
    /// A builder for [`DeleteAddressBookInput`](crate::input::DeleteAddressBookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address_book_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the address book to delete.</p>
        pub fn address_book_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_book_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the address book to delete.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_book_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAddressBookInput`](crate::input::DeleteAddressBookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAddressBookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAddressBookInput {
                address_book_arn: self.address_book_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAddressBookInputOperationOutputAlias = crate::operation::DeleteAddressBook;
#[doc(hidden)]
pub type DeleteAddressBookInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAddressBookInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAddressBook`](crate::operation::DeleteAddressBook)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAddressBook,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAddressBookInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAddressBookInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAddressBookInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteAddressBook",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_address_book(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAddressBook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAddressBook",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAddressBookInput`](crate::input::DeleteAddressBookInput)
    pub fn builder() -> crate::input::delete_address_book_input::Builder {
        crate::input::delete_address_book_input::Builder::default()
    }
}

/// See [`DeleteBusinessReportScheduleInput`](crate::input::DeleteBusinessReportScheduleInput)
pub mod delete_business_report_schedule_input {
    /// A builder for [`DeleteBusinessReportScheduleInput`](crate::input::DeleteBusinessReportScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the business report schedule.</p>
        pub fn schedule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the business report schedule.</p>
        pub fn set_schedule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBusinessReportScheduleInput`](crate::input::DeleteBusinessReportScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBusinessReportScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBusinessReportScheduleInput {
                schedule_arn: self.schedule_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBusinessReportScheduleInputOperationOutputAlias =
    crate::operation::DeleteBusinessReportSchedule;
#[doc(hidden)]
pub type DeleteBusinessReportScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBusinessReportScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBusinessReportSchedule`](crate::operation::DeleteBusinessReportSchedule)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBusinessReportSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBusinessReportScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBusinessReportScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBusinessReportScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteBusinessReportSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_business_report_schedule(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBusinessReportSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBusinessReportSchedule",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBusinessReportScheduleInput`](crate::input::DeleteBusinessReportScheduleInput)
    pub fn builder() -> crate::input::delete_business_report_schedule_input::Builder {
        crate::input::delete_business_report_schedule_input::Builder::default()
    }
}

/// See [`DeleteConferenceProviderInput`](crate::input::DeleteConferenceProviderInput)
pub mod delete_conference_provider_input {
    /// A builder for [`DeleteConferenceProviderInput`](crate::input::DeleteConferenceProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conference_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the conference provider.</p>
        pub fn conference_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.conference_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the conference provider.</p>
        pub fn set_conference_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conference_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConferenceProviderInput`](crate::input::DeleteConferenceProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConferenceProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConferenceProviderInput {
                conference_provider_arn: self.conference_provider_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConferenceProviderInputOperationOutputAlias =
    crate::operation::DeleteConferenceProvider;
#[doc(hidden)]
pub type DeleteConferenceProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConferenceProviderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConferenceProvider`](crate::operation::DeleteConferenceProvider)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConferenceProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConferenceProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConferenceProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConferenceProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteConferenceProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_conference_provider(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConferenceProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConferenceProvider",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConferenceProviderInput`](crate::input::DeleteConferenceProviderInput)
    pub fn builder() -> crate::input::delete_conference_provider_input::Builder {
        crate::input::delete_conference_provider_input::Builder::default()
    }
}

/// See [`DeleteContactInput`](crate::input::DeleteContactInput)
pub mod delete_contact_input {
    /// A builder for [`DeleteContactInput`](crate::input::DeleteContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the contact to delete.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact to delete.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContactInput`](crate::input::DeleteContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContactInput {
                contact_arn: self.contact_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContactInputOperationOutputAlias = crate::operation::DeleteContact;
#[doc(hidden)]
pub type DeleteContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteContactInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContact`](crate::operation::DeleteContact)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteContact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_contact(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContact",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteContactInput`](crate::input::DeleteContactInput)
    pub fn builder() -> crate::input::delete_contact_input::Builder {
        crate::input::delete_contact_input::Builder::default()
    }
}

/// See [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
pub mod delete_device_input {
    /// A builder for [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the device for which to request details.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device for which to request details.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeviceInput {
                device_arn: self.device_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeviceInputOperationOutputAlias = crate::operation::DeleteDevice;
#[doc(hidden)]
pub type DeleteDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDevice`](crate::operation::DeleteDevice)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_device(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDevice",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    pub fn builder() -> crate::input::delete_device_input::Builder {
        crate::input::delete_device_input::Builder::default()
    }
}

/// See [`DeleteDeviceUsageDataInput`](crate::input::DeleteDeviceUsageDataInput)
pub mod delete_device_usage_data_input {
    /// A builder for [`DeleteDeviceUsageDataInput`](crate::input::DeleteDeviceUsageDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) device_usage_type: std::option::Option<crate::model::DeviceUsageType>,
    }
    impl Builder {
        /// <p>The ARN of the device.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The type of usage data to delete.</p>
        pub fn device_usage_type(mut self, input: crate::model::DeviceUsageType) -> Self {
            self.device_usage_type = Some(input);
            self
        }
        /// <p>The type of usage data to delete.</p>
        pub fn set_device_usage_type(
            mut self,
            input: std::option::Option<crate::model::DeviceUsageType>,
        ) -> Self {
            self.device_usage_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceUsageDataInput`](crate::input::DeleteDeviceUsageDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeviceUsageDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeviceUsageDataInput {
                device_arn: self.device_arn,
                device_usage_type: self.device_usage_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeviceUsageDataInputOperationOutputAlias = crate::operation::DeleteDeviceUsageData;
#[doc(hidden)]
pub type DeleteDeviceUsageDataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDeviceUsageDataInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeviceUsageData`](crate::operation::DeleteDeviceUsageData)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeviceUsageData,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeviceUsageDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeviceUsageDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeviceUsageDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteDeviceUsageData",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_device_usage_data(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeviceUsageData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeviceUsageData",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeviceUsageDataInput`](crate::input::DeleteDeviceUsageDataInput)
    pub fn builder() -> crate::input::delete_device_usage_data_input::Builder {
        crate::input::delete_device_usage_data_input::Builder::default()
    }
}

/// See [`DeleteGatewayGroupInput`](crate::input::DeleteGatewayGroupInput)
pub mod delete_gateway_group_input {
    /// A builder for [`DeleteGatewayGroupInput`](crate::input::DeleteGatewayGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the gateway group to delete.</p>
        pub fn gateway_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway group to delete.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGatewayGroupInput`](crate::input::DeleteGatewayGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGatewayGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGatewayGroupInput {
                gateway_group_arn: self.gateway_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGatewayGroupInputOperationOutputAlias = crate::operation::DeleteGatewayGroup;
#[doc(hidden)]
pub type DeleteGatewayGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGatewayGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGatewayGroup`](crate::operation::DeleteGatewayGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGatewayGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGatewayGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGatewayGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGatewayGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteGatewayGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_gateway_group(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGatewayGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGatewayGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGatewayGroupInput`](crate::input::DeleteGatewayGroupInput)
    pub fn builder() -> crate::input::delete_gateway_group_input::Builder {
        crate::input::delete_gateway_group_input::Builder::default()
    }
}

/// See [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
pub mod delete_network_profile_input {
    /// A builder for [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNetworkProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNetworkProfileInput {
                network_profile_arn: self.network_profile_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNetworkProfileInputOperationOutputAlias = crate::operation::DeleteNetworkProfile;
#[doc(hidden)]
pub type DeleteNetworkProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteNetworkProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNetworkProfile`](crate::operation::DeleteNetworkProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNetworkProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNetworkProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNetworkProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNetworkProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteNetworkProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_network_profile(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNetworkProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNetworkProfile",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
    pub fn builder() -> crate::input::delete_network_profile_input::Builder {
        crate::input::delete_network_profile_input::Builder::default()
    }
}

/// See [`DeleteProfileInput`](crate::input::DeleteProfileInput)
pub mod delete_profile_input {
    /// A builder for [`DeleteProfileInput`](crate::input::DeleteProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the room profile to delete. Required.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room profile to delete. Required.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfileInput`](crate::input::DeleteProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProfileInput {
                profile_arn: self.profile_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProfileInputOperationOutputAlias = crate::operation::DeleteProfile;
#[doc(hidden)]
pub type DeleteProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProfile`](crate::operation::DeleteProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_profile(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProfile",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProfileInput`](crate::input::DeleteProfileInput)
    pub fn builder() -> crate::input::delete_profile_input::Builder {
        crate::input::delete_profile_input::Builder::default()
    }
}

/// See [`DeleteRoomInput`](crate::input::DeleteRoomInput)
pub mod delete_room_input {
    /// A builder for [`DeleteRoomInput`](crate::input::DeleteRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the room to delete. Required.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room to delete. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRoomInput`](crate::input::DeleteRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRoomInput {
                room_arn: self.room_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRoomInputOperationOutputAlias = crate::operation::DeleteRoom;
#[doc(hidden)]
pub type DeleteRoomInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRoomInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoom`](crate::operation::DeleteRoom)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoom,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteRoom",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_room(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoom",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRoomInput`](crate::input::DeleteRoomInput)
    pub fn builder() -> crate::input::delete_room_input::Builder {
        crate::input::delete_room_input::Builder::default()
    }
}

/// See [`DeleteRoomSkillParameterInput`](crate::input::DeleteRoomSkillParameterInput)
pub mod delete_room_skill_parameter_input {
    /// A builder for [`DeleteRoomSkillParameterInput`](crate::input::DeleteRoomSkillParameterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) skill_id: std::option::Option<std::string::String>,
        pub(crate) parameter_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the room from which to remove the room skill parameter details.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room from which to remove the room skill parameter details.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The ID of the skill from which to remove the room skill parameter details.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The ID of the skill from which to remove the room skill parameter details.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// <p>The room skill parameter key for which to remove details.</p>
        pub fn parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_key = Some(input.into());
            self
        }
        /// <p>The room skill parameter key for which to remove details.</p>
        pub fn set_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_key = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRoomSkillParameterInput`](crate::input::DeleteRoomSkillParameterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRoomSkillParameterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRoomSkillParameterInput {
                room_arn: self.room_arn,
                skill_id: self.skill_id,
                parameter_key: self.parameter_key,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRoomSkillParameterInputOperationOutputAlias =
    crate::operation::DeleteRoomSkillParameter;
#[doc(hidden)]
pub type DeleteRoomSkillParameterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRoomSkillParameterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoomSkillParameter`](crate::operation::DeleteRoomSkillParameter)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoomSkillParameter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRoomSkillParameterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRoomSkillParameterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRoomSkillParameterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteRoomSkillParameter",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_room_skill_parameter(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoomSkillParameter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoomSkillParameter",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRoomSkillParameterInput`](crate::input::DeleteRoomSkillParameterInput)
    pub fn builder() -> crate::input::delete_room_skill_parameter_input::Builder {
        crate::input::delete_room_skill_parameter_input::Builder::default()
    }
}

/// See [`DeleteSkillAuthorizationInput`](crate::input::DeleteSkillAuthorizationInput)
pub mod delete_skill_authorization_input {
    /// A builder for [`DeleteSkillAuthorizationInput`](crate::input::DeleteSkillAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_id: std::option::Option<std::string::String>,
        pub(crate) room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a skill.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// <p>The room that the skill is authorized for.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The room that the skill is authorized for.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSkillAuthorizationInput`](crate::input::DeleteSkillAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSkillAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSkillAuthorizationInput {
                skill_id: self.skill_id,
                room_arn: self.room_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSkillAuthorizationInputOperationOutputAlias =
    crate::operation::DeleteSkillAuthorization;
#[doc(hidden)]
pub type DeleteSkillAuthorizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSkillAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSkillAuthorization`](crate::operation::DeleteSkillAuthorization)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSkillAuthorization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSkillAuthorizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSkillAuthorizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSkillAuthorizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteSkillAuthorization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_skill_authorization(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSkillAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSkillAuthorization",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSkillAuthorizationInput`](crate::input::DeleteSkillAuthorizationInput)
    pub fn builder() -> crate::input::delete_skill_authorization_input::Builder {
        crate::input::delete_skill_authorization_input::Builder::default()
    }
}

/// See [`DeleteSkillGroupInput`](crate::input::DeleteSkillGroupInput)
pub mod delete_skill_group_input {
    /// A builder for [`DeleteSkillGroupInput`](crate::input::DeleteSkillGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the skill group to delete. Required.</p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the skill group to delete. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSkillGroupInput`](crate::input::DeleteSkillGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSkillGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSkillGroupInput {
                skill_group_arn: self.skill_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSkillGroupInputOperationOutputAlias = crate::operation::DeleteSkillGroup;
#[doc(hidden)]
pub type DeleteSkillGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSkillGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSkillGroup`](crate::operation::DeleteSkillGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSkillGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSkillGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSkillGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSkillGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteSkillGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_skill_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSkillGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSkillGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSkillGroupInput`](crate::input::DeleteSkillGroupInput)
    pub fn builder() -> crate::input::delete_skill_group_input::Builder {
        crate::input::delete_skill_group_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) enrollment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the user to delete in the organization. Required.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user to delete in the organization. Required.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The ARN of the user's enrollment in the organization. Required.</p>
        pub fn enrollment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.enrollment_id = Some(input.into());
            self
        }
        /// <p>The ARN of the user's enrollment in the organization. Required.</p>
        pub fn set_enrollment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.enrollment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                user_arn: self.user_arn,
                enrollment_id: self.enrollment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DeleteUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DisassociateContactFromAddressBookInput`](crate::input::DisassociateContactFromAddressBookInput)
pub mod disassociate_contact_from_address_book_input {
    /// A builder for [`DisassociateContactFromAddressBookInput`](crate::input::DisassociateContactFromAddressBookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) address_book_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the contact to disassociate from an address book.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact to disassociate from an address book.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The ARN of the address from which to disassociate the contact.</p>
        pub fn address_book_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_book_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the address from which to disassociate the contact.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_book_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateContactFromAddressBookInput`](crate::input::DisassociateContactFromAddressBookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateContactFromAddressBookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateContactFromAddressBookInput {
                contact_arn: self.contact_arn,
                address_book_arn: self.address_book_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateContactFromAddressBookInputOperationOutputAlias =
    crate::operation::DisassociateContactFromAddressBook;
#[doc(hidden)]
pub type DisassociateContactFromAddressBookInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateContactFromAddressBookInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateContactFromAddressBook`](crate::operation::DisassociateContactFromAddressBook)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateContactFromAddressBook,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateContactFromAddressBookInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateContactFromAddressBookInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateContactFromAddressBookInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DisassociateContactFromAddressBook",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_contact_from_address_book(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateContactFromAddressBook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateContactFromAddressBook",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateContactFromAddressBookInput`](crate::input::DisassociateContactFromAddressBookInput)
    pub fn builder() -> crate::input::disassociate_contact_from_address_book_input::Builder {
        crate::input::disassociate_contact_from_address_book_input::Builder::default()
    }
}

/// See [`DisassociateDeviceFromRoomInput`](crate::input::DisassociateDeviceFromRoomInput)
pub mod disassociate_device_from_room_input {
    /// A builder for [`DisassociateDeviceFromRoomInput`](crate::input::DisassociateDeviceFromRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the device to disassociate from a room. Required.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device to disassociate from a room. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateDeviceFromRoomInput`](crate::input::DisassociateDeviceFromRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateDeviceFromRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateDeviceFromRoomInput {
                device_arn: self.device_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateDeviceFromRoomInputOperationOutputAlias =
    crate::operation::DisassociateDeviceFromRoom;
#[doc(hidden)]
pub type DisassociateDeviceFromRoomInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateDeviceFromRoomInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateDeviceFromRoom`](crate::operation::DisassociateDeviceFromRoom)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateDeviceFromRoom,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateDeviceFromRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateDeviceFromRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateDeviceFromRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DisassociateDeviceFromRoom",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_device_from_room(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateDeviceFromRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateDeviceFromRoom",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateDeviceFromRoomInput`](crate::input::DisassociateDeviceFromRoomInput)
    pub fn builder() -> crate::input::disassociate_device_from_room_input::Builder {
        crate::input::disassociate_device_from_room_input::Builder::default()
    }
}

/// See [`DisassociateSkillFromSkillGroupInput`](crate::input::DisassociateSkillFromSkillGroupInput)
pub mod disassociate_skill_from_skill_group_input {
    /// A builder for [`DisassociateSkillFromSkillGroupInput`](crate::input::DisassociateSkillFromSkillGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
        pub(crate) skill_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a skill. Required.</p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of a skill. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// <p>The ARN of a skill group to associate to a skill.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The ARN of a skill group to associate to a skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateSkillFromSkillGroupInput`](crate::input::DisassociateSkillFromSkillGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateSkillFromSkillGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateSkillFromSkillGroupInput {
                skill_group_arn: self.skill_group_arn,
                skill_id: self.skill_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateSkillFromSkillGroupInputOperationOutputAlias =
    crate::operation::DisassociateSkillFromSkillGroup;
#[doc(hidden)]
pub type DisassociateSkillFromSkillGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateSkillFromSkillGroupInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateSkillFromSkillGroup`](crate::operation::DisassociateSkillFromSkillGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateSkillFromSkillGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateSkillFromSkillGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateSkillFromSkillGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateSkillFromSkillGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DisassociateSkillFromSkillGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_skill_from_skill_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateSkillFromSkillGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateSkillFromSkillGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateSkillFromSkillGroupInput`](crate::input::DisassociateSkillFromSkillGroupInput)
    pub fn builder() -> crate::input::disassociate_skill_from_skill_group_input::Builder {
        crate::input::disassociate_skill_from_skill_group_input::Builder::default()
    }
}

/// See [`DisassociateSkillFromUsersInput`](crate::input::DisassociateSkillFromUsersInput)
pub mod disassociate_skill_from_users_input {
    /// A builder for [`DisassociateSkillFromUsersInput`](crate::input::DisassociateSkillFromUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The private skill ID you want to make unavailable for enrolled users.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p> The private skill ID you want to make unavailable for enrolled users.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateSkillFromUsersInput`](crate::input::DisassociateSkillFromUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateSkillFromUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateSkillFromUsersInput {
                skill_id: self.skill_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateSkillFromUsersInputOperationOutputAlias =
    crate::operation::DisassociateSkillFromUsers;
#[doc(hidden)]
pub type DisassociateSkillFromUsersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateSkillFromUsersInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateSkillFromUsers`](crate::operation::DisassociateSkillFromUsers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateSkillFromUsers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateSkillFromUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateSkillFromUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateSkillFromUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DisassociateSkillFromUsers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_skill_from_users(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateSkillFromUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateSkillFromUsers",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateSkillFromUsersInput`](crate::input::DisassociateSkillFromUsersInput)
    pub fn builder() -> crate::input::disassociate_skill_from_users_input::Builder {
        crate::input::disassociate_skill_from_users_input::Builder::default()
    }
}

/// See [`DisassociateSkillGroupFromRoomInput`](crate::input::DisassociateSkillGroupFromRoomInput)
pub mod disassociate_skill_group_from_room_input {
    /// A builder for [`DisassociateSkillGroupFromRoomInput`](crate::input::DisassociateSkillGroupFromRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
        pub(crate) room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the skill group to disassociate from a room. Required.</p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the skill group to disassociate from a room. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// <p>The ARN of the room from which the skill group is to be disassociated.
        /// Required.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room from which the skill group is to be disassociated.
        /// Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateSkillGroupFromRoomInput`](crate::input::DisassociateSkillGroupFromRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateSkillGroupFromRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateSkillGroupFromRoomInput {
                skill_group_arn: self.skill_group_arn,
                room_arn: self.room_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateSkillGroupFromRoomInputOperationOutputAlias =
    crate::operation::DisassociateSkillGroupFromRoom;
#[doc(hidden)]
pub type DisassociateSkillGroupFromRoomInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateSkillGroupFromRoomInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateSkillGroupFromRoom`](crate::operation::DisassociateSkillGroupFromRoom)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateSkillGroupFromRoom,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateSkillGroupFromRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateSkillGroupFromRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateSkillGroupFromRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.DisassociateSkillGroupFromRoom",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_skill_group_from_room(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateSkillGroupFromRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateSkillGroupFromRoom",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateSkillGroupFromRoomInput`](crate::input::DisassociateSkillGroupFromRoomInput)
    pub fn builder() -> crate::input::disassociate_skill_group_from_room_input::Builder {
        crate::input::disassociate_skill_group_from_room_input::Builder::default()
    }
}

/// See [`ForgetSmartHomeAppliancesInput`](crate::input::ForgetSmartHomeAppliancesInput)
pub mod forget_smart_home_appliances_input {
    /// A builder for [`ForgetSmartHomeAppliancesInput`](crate::input::ForgetSmartHomeAppliancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The room that the appliances are associated with.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The room that the appliances are associated with.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ForgetSmartHomeAppliancesInput`](crate::input::ForgetSmartHomeAppliancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ForgetSmartHomeAppliancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ForgetSmartHomeAppliancesInput {
                room_arn: self.room_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ForgetSmartHomeAppliancesInputOperationOutputAlias =
    crate::operation::ForgetSmartHomeAppliances;
#[doc(hidden)]
pub type ForgetSmartHomeAppliancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ForgetSmartHomeAppliancesInput {
    /// Consumes the builder and constructs an Operation<[`ForgetSmartHomeAppliances`](crate::operation::ForgetSmartHomeAppliances)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ForgetSmartHomeAppliances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ForgetSmartHomeAppliancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ForgetSmartHomeAppliancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ForgetSmartHomeAppliancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ForgetSmartHomeAppliances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_forget_smart_home_appliances(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ForgetSmartHomeAppliances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ForgetSmartHomeAppliances",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ForgetSmartHomeAppliancesInput`](crate::input::ForgetSmartHomeAppliancesInput)
    pub fn builder() -> crate::input::forget_smart_home_appliances_input::Builder {
        crate::input::forget_smart_home_appliances_input::Builder::default()
    }
}

/// See [`GetAddressBookInput`](crate::input::GetAddressBookInput)
pub mod get_address_book_input {
    /// A builder for [`GetAddressBookInput`](crate::input::GetAddressBookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address_book_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the address book for which to request details.</p>
        pub fn address_book_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_book_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the address book for which to request details.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_book_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAddressBookInput`](crate::input::GetAddressBookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAddressBookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAddressBookInput {
                address_book_arn: self.address_book_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAddressBookInputOperationOutputAlias = crate::operation::GetAddressBook;
#[doc(hidden)]
pub type GetAddressBookInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAddressBookInput {
    /// Consumes the builder and constructs an Operation<[`GetAddressBook`](crate::operation::GetAddressBook)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAddressBook,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAddressBookInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAddressBookInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAddressBookInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetAddressBook",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_address_book(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAddressBook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAddressBook",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAddressBookInput`](crate::input::GetAddressBookInput)
    pub fn builder() -> crate::input::get_address_book_input::Builder {
        crate::input::get_address_book_input::Builder::default()
    }
}

/// See [`GetConferencePreferenceInput`](crate::input::GetConferencePreferenceInput)
pub mod get_conference_preference_input {
    /// A builder for [`GetConferencePreferenceInput`](crate::input::GetConferencePreferenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetConferencePreferenceInput`](crate::input::GetConferencePreferenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConferencePreferenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConferencePreferenceInput {})
        }
    }
}
#[doc(hidden)]
pub type GetConferencePreferenceInputOperationOutputAlias =
    crate::operation::GetConferencePreference;
#[doc(hidden)]
pub type GetConferencePreferenceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetConferencePreferenceInput {
    /// Consumes the builder and constructs an Operation<[`GetConferencePreference`](crate::operation::GetConferencePreference)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConferencePreference,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConferencePreferenceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConferencePreferenceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConferencePreferenceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetConferencePreference",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_conference_preference(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConferencePreference::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConferencePreference",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConferencePreferenceInput`](crate::input::GetConferencePreferenceInput)
    pub fn builder() -> crate::input::get_conference_preference_input::Builder {
        crate::input::get_conference_preference_input::Builder::default()
    }
}

/// See [`GetConferenceProviderInput`](crate::input::GetConferenceProviderInput)
pub mod get_conference_provider_input {
    /// A builder for [`GetConferenceProviderInput`](crate::input::GetConferenceProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conference_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the newly created conference provider.</p>
        pub fn conference_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.conference_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the newly created conference provider.</p>
        pub fn set_conference_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conference_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConferenceProviderInput`](crate::input::GetConferenceProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConferenceProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConferenceProviderInput {
                conference_provider_arn: self.conference_provider_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConferenceProviderInputOperationOutputAlias = crate::operation::GetConferenceProvider;
#[doc(hidden)]
pub type GetConferenceProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetConferenceProviderInput {
    /// Consumes the builder and constructs an Operation<[`GetConferenceProvider`](crate::operation::GetConferenceProvider)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConferenceProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConferenceProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConferenceProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConferenceProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetConferenceProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_conference_provider(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConferenceProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConferenceProvider",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConferenceProviderInput`](crate::input::GetConferenceProviderInput)
    pub fn builder() -> crate::input::get_conference_provider_input::Builder {
        crate::input::get_conference_provider_input::Builder::default()
    }
}

/// See [`GetContactInput`](crate::input::GetContactInput)
pub mod get_contact_input {
    /// A builder for [`GetContactInput`](crate::input::GetContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the contact for which to request details.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact for which to request details.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactInput`](crate::input::GetContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContactInput {
                contact_arn: self.contact_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContactInputOperationOutputAlias = crate::operation::GetContact;
#[doc(hidden)]
pub type GetContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetContactInput {
    /// Consumes the builder and constructs an Operation<[`GetContact`](crate::operation::GetContact)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetContact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_contact(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContact",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContactInput`](crate::input::GetContactInput)
    pub fn builder() -> crate::input::get_contact_input::Builder {
        crate::input::get_contact_input::Builder::default()
    }
}

/// See [`GetDeviceInput`](crate::input::GetDeviceInput)
pub mod get_device_input {
    /// A builder for [`GetDeviceInput`](crate::input::GetDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the device for which to request details. Required.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device for which to request details. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceInput`](crate::input::GetDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetDeviceInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetDeviceInput {
                device_arn: self.device_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeviceInputOperationOutputAlias = crate::operation::GetDevice;
#[doc(hidden)]
pub type GetDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDeviceInput {
    /// Consumes the builder and constructs an Operation<[`GetDevice`](crate::operation::GetDevice)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_device(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetDevice::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetDevice",
                    "alexaforbusiness",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeviceInput`](crate::input::GetDeviceInput)
    pub fn builder() -> crate::input::get_device_input::Builder {
        crate::input::get_device_input::Builder::default()
    }
}

/// See [`GetGatewayInput`](crate::input::GetGatewayInput)
pub mod get_gateway_input {
    /// A builder for [`GetGatewayInput`](crate::input::GetGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the gateway to get.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway to get.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGatewayInput`](crate::input::GetGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGatewayInput {
                gateway_arn: self.gateway_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGatewayInputOperationOutputAlias = crate::operation::GetGateway;
#[doc(hidden)]
pub type GetGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGatewayInput {
    /// Consumes the builder and constructs an Operation<[`GetGateway`](crate::operation::GetGateway)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetGateway",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_gateway(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGateway",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGatewayInput`](crate::input::GetGatewayInput)
    pub fn builder() -> crate::input::get_gateway_input::Builder {
        crate::input::get_gateway_input::Builder::default()
    }
}

/// See [`GetGatewayGroupInput`](crate::input::GetGatewayGroupInput)
pub mod get_gateway_group_input {
    /// A builder for [`GetGatewayGroupInput`](crate::input::GetGatewayGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the gateway group to get.</p>
        pub fn gateway_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway group to get.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGatewayGroupInput`](crate::input::GetGatewayGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGatewayGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGatewayGroupInput {
                gateway_group_arn: self.gateway_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGatewayGroupInputOperationOutputAlias = crate::operation::GetGatewayGroup;
#[doc(hidden)]
pub type GetGatewayGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGatewayGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetGatewayGroup`](crate::operation::GetGatewayGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGatewayGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGatewayGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGatewayGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGatewayGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetGatewayGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_gateway_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGatewayGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGatewayGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGatewayGroupInput`](crate::input::GetGatewayGroupInput)
    pub fn builder() -> crate::input::get_gateway_group_input::Builder {
        crate::input::get_gateway_group_input::Builder::default()
    }
}

/// See [`GetInvitationConfigurationInput`](crate::input::GetInvitationConfigurationInput)
pub mod get_invitation_configuration_input {
    /// A builder for [`GetInvitationConfigurationInput`](crate::input::GetInvitationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetInvitationConfigurationInput`](crate::input::GetInvitationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInvitationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInvitationConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type GetInvitationConfigurationInputOperationOutputAlias =
    crate::operation::GetInvitationConfiguration;
#[doc(hidden)]
pub type GetInvitationConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInvitationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetInvitationConfiguration`](crate::operation::GetInvitationConfiguration)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInvitationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInvitationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInvitationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInvitationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetInvitationConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_invitation_configuration(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInvitationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInvitationConfiguration",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInvitationConfigurationInput`](crate::input::GetInvitationConfigurationInput)
    pub fn builder() -> crate::input::get_invitation_configuration_input::Builder {
        crate::input::get_invitation_configuration_input::Builder::default()
    }
}

/// See [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
pub mod get_network_profile_input {
    /// A builder for [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetNetworkProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetNetworkProfileInput {
                network_profile_arn: self.network_profile_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetNetworkProfileInputOperationOutputAlias = crate::operation::GetNetworkProfile;
#[doc(hidden)]
pub type GetNetworkProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetNetworkProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetNetworkProfile`](crate::operation::GetNetworkProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetNetworkProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetNetworkProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetNetworkProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetNetworkProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetNetworkProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_network_profile(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetNetworkProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetNetworkProfile",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
    pub fn builder() -> crate::input::get_network_profile_input::Builder {
        crate::input::get_network_profile_input::Builder::default()
    }
}

/// See [`GetProfileInput`](crate::input::GetProfileInput)
pub mod get_profile_input {
    /// A builder for [`GetProfileInput`](crate::input::GetProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the room profile for which to request details. Required.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room profile for which to request details. Required.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProfileInput`](crate::input::GetProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProfileInput {
                profile_arn: self.profile_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProfileInputOperationOutputAlias = crate::operation::GetProfile;
#[doc(hidden)]
pub type GetProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetProfile`](crate::operation::GetProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_profile(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProfile",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetProfileInput`](crate::input::GetProfileInput)
    pub fn builder() -> crate::input::get_profile_input::Builder {
        crate::input::get_profile_input::Builder::default()
    }
}

/// See [`GetRoomInput`](crate::input::GetRoomInput)
pub mod get_room_input {
    /// A builder for [`GetRoomInput`](crate::input::GetRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the room for which to request details. Required.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room for which to request details. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRoomInput`](crate::input::GetRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetRoomInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetRoomInput {
                room_arn: self.room_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRoomInputOperationOutputAlias = crate::operation::GetRoom;
#[doc(hidden)]
pub type GetRoomInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRoomInput {
    /// Consumes the builder and constructs an Operation<[`GetRoom`](crate::operation::GetRoom)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRoom,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetRoom",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_room(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetRoom::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetRoom",
                    "alexaforbusiness",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRoomInput`](crate::input::GetRoomInput)
    pub fn builder() -> crate::input::get_room_input::Builder {
        crate::input::get_room_input::Builder::default()
    }
}

/// See [`GetRoomSkillParameterInput`](crate::input::GetRoomSkillParameterInput)
pub mod get_room_skill_parameter_input {
    /// A builder for [`GetRoomSkillParameterInput`](crate::input::GetRoomSkillParameterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) skill_id: std::option::Option<std::string::String>,
        pub(crate) parameter_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the room from which to get the room skill parameter details. </p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room from which to get the room skill parameter details. </p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The ARN of the skill from which to get the room skill parameter details.
        /// Required.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The ARN of the skill from which to get the room skill parameter details.
        /// Required.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// <p>The room skill parameter key for which to get details. Required.</p>
        pub fn parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_key = Some(input.into());
            self
        }
        /// <p>The room skill parameter key for which to get details. Required.</p>
        pub fn set_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_key = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRoomSkillParameterInput`](crate::input::GetRoomSkillParameterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRoomSkillParameterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRoomSkillParameterInput {
                room_arn: self.room_arn,
                skill_id: self.skill_id,
                parameter_key: self.parameter_key,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRoomSkillParameterInputOperationOutputAlias = crate::operation::GetRoomSkillParameter;
#[doc(hidden)]
pub type GetRoomSkillParameterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRoomSkillParameterInput {
    /// Consumes the builder and constructs an Operation<[`GetRoomSkillParameter`](crate::operation::GetRoomSkillParameter)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRoomSkillParameter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRoomSkillParameterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRoomSkillParameterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRoomSkillParameterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetRoomSkillParameter",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_room_skill_parameter(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRoomSkillParameter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRoomSkillParameter",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRoomSkillParameterInput`](crate::input::GetRoomSkillParameterInput)
    pub fn builder() -> crate::input::get_room_skill_parameter_input::Builder {
        crate::input::get_room_skill_parameter_input::Builder::default()
    }
}

/// See [`GetSkillGroupInput`](crate::input::GetSkillGroupInput)
pub mod get_skill_group_input {
    /// A builder for [`GetSkillGroupInput`](crate::input::GetSkillGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the skill group for which to get details. Required.</p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the skill group for which to get details. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSkillGroupInput`](crate::input::GetSkillGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSkillGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSkillGroupInput {
                skill_group_arn: self.skill_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSkillGroupInputOperationOutputAlias = crate::operation::GetSkillGroup;
#[doc(hidden)]
pub type GetSkillGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSkillGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetSkillGroup`](crate::operation::GetSkillGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSkillGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSkillGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSkillGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSkillGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.GetSkillGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_skill_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSkillGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSkillGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSkillGroupInput`](crate::input::GetSkillGroupInput)
    pub fn builder() -> crate::input::get_skill_group_input::Builder {
        crate::input::get_skill_group_input::Builder::default()
    }
}

/// See [`ListBusinessReportSchedulesInput`](crate::input::ListBusinessReportSchedulesInput)
pub mod list_business_report_schedules_input {
    /// A builder for [`ListBusinessReportSchedulesInput`](crate::input::ListBusinessReportSchedulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token used to list the remaining schedules from the previous API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to list the remaining schedules from the previous API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of schedules listed in the call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of schedules listed in the call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBusinessReportSchedulesInput`](crate::input::ListBusinessReportSchedulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBusinessReportSchedulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBusinessReportSchedulesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBusinessReportSchedulesInputOperationOutputAlias =
    crate::operation::ListBusinessReportSchedules;
#[doc(hidden)]
pub type ListBusinessReportSchedulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBusinessReportSchedulesInput {
    /// Consumes the builder and constructs an Operation<[`ListBusinessReportSchedules`](crate::operation::ListBusinessReportSchedules)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBusinessReportSchedules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBusinessReportSchedulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBusinessReportSchedulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBusinessReportSchedulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListBusinessReportSchedules",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_business_report_schedules(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBusinessReportSchedules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBusinessReportSchedules",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBusinessReportSchedulesInput`](crate::input::ListBusinessReportSchedulesInput)
    pub fn builder() -> crate::input::list_business_report_schedules_input::Builder {
        crate::input::list_business_report_schedules_input::Builder::default()
    }
}

/// See [`ListConferenceProvidersInput`](crate::input::ListConferenceProvidersInput)
pub mod list_conference_providers_input {
    /// A builder for [`ListConferenceProvidersInput`](crate::input::ListConferenceProvidersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The tokens used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of conference providers to be returned, per paginated
        /// calls.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of conference providers to be returned, per paginated
        /// calls.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConferenceProvidersInput`](crate::input::ListConferenceProvidersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConferenceProvidersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConferenceProvidersInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConferenceProvidersInputOperationOutputAlias =
    crate::operation::ListConferenceProviders;
#[doc(hidden)]
pub type ListConferenceProvidersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListConferenceProvidersInput {
    /// Consumes the builder and constructs an Operation<[`ListConferenceProviders`](crate::operation::ListConferenceProviders)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConferenceProviders,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConferenceProvidersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConferenceProvidersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConferenceProvidersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListConferenceProviders",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_conference_providers(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConferenceProviders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConferenceProviders",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConferenceProvidersInput`](crate::input::ListConferenceProvidersInput)
    pub fn builder() -> crate::input::list_conference_providers_input::Builder {
        crate::input::list_conference_providers_input::Builder::default()
    }
}

/// See [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
pub mod list_device_events_input {
    /// A builder for [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) event_type: std::option::Option<crate::model::DeviceEventType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of a device.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The event type to filter device events. If EventType isn't specified, this returns a
        /// list of all device events in reverse chronological order. If EventType is specified, this
        /// returns a list of device events for that EventType in reverse chronological order.
        /// </p>
        pub fn event_type(mut self, input: crate::model::DeviceEventType) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>The event type to filter device events. If EventType isn't specified, this returns a
        /// list of all device events in reverse chronological order. If EventType is specified, this
        /// returns a list of device events for that EventType in reverse chronological order.
        /// </p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::DeviceEventType>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults. When the end of results
        /// is reached, the response has a value of null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults. When the end of results
        /// is reached, the response has a value of null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. The default value is 50. If
        /// more results exist than the specified MaxResults value, a token is included in the response
        /// so that the remaining results can be retrieved. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. The default value is 50. If
        /// more results exist than the specified MaxResults value, a token is included in the response
        /// so that the remaining results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeviceEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeviceEventsInput {
                device_arn: self.device_arn,
                event_type: self.event_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeviceEventsInputOperationOutputAlias = crate::operation::ListDeviceEvents;
#[doc(hidden)]
pub type ListDeviceEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDeviceEventsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeviceEvents`](crate::operation::ListDeviceEvents)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeviceEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeviceEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeviceEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeviceEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListDeviceEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_device_events(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeviceEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeviceEvents",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
    pub fn builder() -> crate::input::list_device_events_input::Builder {
        crate::input::list_device_events_input::Builder::default()
    }
}

/// See [`ListGatewayGroupsInput`](crate::input::ListGatewayGroupsInput)
pub mod list_gateway_groups_input {
    /// A builder for [`ListGatewayGroupsInput`](crate::input::ListGatewayGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token used to paginate though multiple pages of gateway group summaries.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to paginate though multiple pages of gateway group summaries.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of gateway group summaries to return. The default is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of gateway group summaries to return. The default is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGatewayGroupsInput`](crate::input::ListGatewayGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGatewayGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGatewayGroupsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGatewayGroupsInputOperationOutputAlias = crate::operation::ListGatewayGroups;
#[doc(hidden)]
pub type ListGatewayGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGatewayGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListGatewayGroups`](crate::operation::ListGatewayGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGatewayGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGatewayGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGatewayGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGatewayGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListGatewayGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_gateway_groups(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGatewayGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGatewayGroups",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGatewayGroupsInput`](crate::input::ListGatewayGroupsInput)
    pub fn builder() -> crate::input::list_gateway_groups_input::Builder {
        crate::input::list_gateway_groups_input::Builder::default()
    }
}

/// See [`ListGatewaysInput`](crate::input::ListGatewaysInput)
pub mod list_gateways_input {
    /// A builder for [`ListGatewaysInput`](crate::input::ListGatewaysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_group_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The gateway group ARN for which to list gateways.</p>
        pub fn gateway_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_group_arn = Some(input.into());
            self
        }
        /// <p>The gateway group ARN for which to list gateways.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_group_arn = input;
            self
        }
        /// <p>The token used to paginate though multiple pages of gateway summaries.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to paginate though multiple pages of gateway summaries.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of gateway summaries to return. The default is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of gateway summaries to return. The default is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGatewaysInput`](crate::input::ListGatewaysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGatewaysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGatewaysInput {
                gateway_group_arn: self.gateway_group_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGatewaysInputOperationOutputAlias = crate::operation::ListGateways;
#[doc(hidden)]
pub type ListGatewaysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGatewaysInput {
    /// Consumes the builder and constructs an Operation<[`ListGateways`](crate::operation::ListGateways)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGateways,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGatewaysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGatewaysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGatewaysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListGateways",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_gateways(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGateways::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGateways",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGatewaysInput`](crate::input::ListGatewaysInput)
    pub fn builder() -> crate::input::list_gateways_input::Builder {
        crate::input::list_gateways_input::Builder::default()
    }
}

/// See [`ListSkillsInput`](crate::input::ListSkillsInput)
pub mod list_skills_input {
    /// A builder for [`ListSkillsInput`](crate::input::ListSkillsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
        pub(crate) enablement_type: std::option::Option<crate::model::EnablementTypeFilter>,
        pub(crate) skill_type: std::option::Option<crate::model::SkillTypeFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the skill group for which to list enabled skills.</p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the skill group for which to list enabled skills.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// <p>Whether the skill is enabled under the user's account.</p>
        pub fn enablement_type(mut self, input: crate::model::EnablementTypeFilter) -> Self {
            self.enablement_type = Some(input);
            self
        }
        /// <p>Whether the skill is enabled under the user's account.</p>
        pub fn set_enablement_type(
            mut self,
            input: std::option::Option<crate::model::EnablementTypeFilter>,
        ) -> Self {
            self.enablement_type = input;
            self
        }
        /// <p>Whether the skill is publicly available or is a private skill.</p>
        pub fn skill_type(mut self, input: crate::model::SkillTypeFilter) -> Self {
            self.skill_type = Some(input);
            self
        }
        /// <p>Whether the skill is publicly available or is a private skill.</p>
        pub fn set_skill_type(
            mut self,
            input: std::option::Option<crate::model::SkillTypeFilter>,
        ) -> Self {
            self.skill_type = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSkillsInput`](crate::input::ListSkillsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSkillsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSkillsInput {
                skill_group_arn: self.skill_group_arn,
                enablement_type: self.enablement_type,
                skill_type: self.skill_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSkillsInputOperationOutputAlias = crate::operation::ListSkills;
#[doc(hidden)]
pub type ListSkillsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSkillsInput {
    /// Consumes the builder and constructs an Operation<[`ListSkills`](crate::operation::ListSkills)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSkills,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSkillsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSkillsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSkillsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListSkills",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_skills(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSkills::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSkills",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSkillsInput`](crate::input::ListSkillsInput)
    pub fn builder() -> crate::input::list_skills_input::Builder {
        crate::input::list_skills_input::Builder::default()
    }
}

/// See [`ListSkillsStoreCategoriesInput`](crate::input::ListSkillsStoreCategoriesInput)
pub mod list_skills_store_categories_input {
    /// A builder for [`ListSkillsStoreCategoriesInput`](crate::input::ListSkillsStoreCategoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The tokens used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of categories returned, per paginated calls.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of categories returned, per paginated calls.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSkillsStoreCategoriesInput`](crate::input::ListSkillsStoreCategoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSkillsStoreCategoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSkillsStoreCategoriesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSkillsStoreCategoriesInputOperationOutputAlias =
    crate::operation::ListSkillsStoreCategories;
#[doc(hidden)]
pub type ListSkillsStoreCategoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSkillsStoreCategoriesInput {
    /// Consumes the builder and constructs an Operation<[`ListSkillsStoreCategories`](crate::operation::ListSkillsStoreCategories)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSkillsStoreCategories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSkillsStoreCategoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSkillsStoreCategoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSkillsStoreCategoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListSkillsStoreCategories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_skills_store_categories(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSkillsStoreCategories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSkillsStoreCategories",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSkillsStoreCategoriesInput`](crate::input::ListSkillsStoreCategoriesInput)
    pub fn builder() -> crate::input::list_skills_store_categories_input::Builder {
        crate::input::list_skills_store_categories_input::Builder::default()
    }
}

/// See [`ListSkillsStoreSkillsByCategoryInput`](crate::input::ListSkillsStoreSkillsByCategoryInput)
pub mod list_skills_store_skills_by_category_input {
    /// A builder for [`ListSkillsStoreSkillsByCategoryInput`](crate::input::ListSkillsStoreSkillsByCategoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category_id: std::option::Option<i64>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The category ID for which the skills are being retrieved from the skill
        /// store.</p>
        pub fn category_id(mut self, input: i64) -> Self {
            self.category_id = Some(input);
            self
        }
        /// <p>The category ID for which the skills are being retrieved from the skill
        /// store.</p>
        pub fn set_category_id(mut self, input: std::option::Option<i64>) -> Self {
            self.category_id = input;
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of skills returned per paginated calls.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of skills returned per paginated calls.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSkillsStoreSkillsByCategoryInput`](crate::input::ListSkillsStoreSkillsByCategoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSkillsStoreSkillsByCategoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSkillsStoreSkillsByCategoryInput {
                category_id: self.category_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSkillsStoreSkillsByCategoryInputOperationOutputAlias =
    crate::operation::ListSkillsStoreSkillsByCategory;
#[doc(hidden)]
pub type ListSkillsStoreSkillsByCategoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSkillsStoreSkillsByCategoryInput {
    /// Consumes the builder and constructs an Operation<[`ListSkillsStoreSkillsByCategory`](crate::operation::ListSkillsStoreSkillsByCategory)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSkillsStoreSkillsByCategory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSkillsStoreSkillsByCategoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSkillsStoreSkillsByCategoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSkillsStoreSkillsByCategoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListSkillsStoreSkillsByCategory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_skills_store_skills_by_category(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSkillsStoreSkillsByCategory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSkillsStoreSkillsByCategory",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSkillsStoreSkillsByCategoryInput`](crate::input::ListSkillsStoreSkillsByCategoryInput)
    pub fn builder() -> crate::input::list_skills_store_skills_by_category_input::Builder {
        crate::input::list_skills_store_skills_by_category_input::Builder::default()
    }
}

/// See [`ListSmartHomeAppliancesInput`](crate::input::ListSmartHomeAppliancesInput)
pub mod list_smart_home_appliances_input {
    /// A builder for [`ListSmartHomeAppliancesInput`](crate::input::ListSmartHomeAppliancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The room that the appliances are associated with.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The room that the appliances are associated with.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The maximum number of appliances to be returned, per paginated calls.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of appliances to be returned, per paginated calls.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSmartHomeAppliancesInput`](crate::input::ListSmartHomeAppliancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSmartHomeAppliancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSmartHomeAppliancesInput {
                room_arn: self.room_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSmartHomeAppliancesInputOperationOutputAlias =
    crate::operation::ListSmartHomeAppliances;
#[doc(hidden)]
pub type ListSmartHomeAppliancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSmartHomeAppliancesInput {
    /// Consumes the builder and constructs an Operation<[`ListSmartHomeAppliances`](crate::operation::ListSmartHomeAppliances)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSmartHomeAppliances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSmartHomeAppliancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSmartHomeAppliancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSmartHomeAppliancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListSmartHomeAppliances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_smart_home_appliances(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSmartHomeAppliances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSmartHomeAppliances",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSmartHomeAppliancesInput`](crate::input::ListSmartHomeAppliancesInput)
    pub fn builder() -> crate::input::list_smart_home_appliances_input::Builder {
        crate::input::list_smart_home_appliances_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the specified resource for which to list tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the specified resource for which to list tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                arn: self.arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ListTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_tags(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags",
                    "alexaforbusiness",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`PutConferencePreferenceInput`](crate::input::PutConferencePreferenceInput)
pub mod put_conference_preference_input {
    /// A builder for [`PutConferencePreferenceInput`](crate::input::PutConferencePreferenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conference_preference: std::option::Option<crate::model::ConferencePreference>,
    }
    impl Builder {
        /// <p>The conference preference of a specific conference provider.</p>
        pub fn conference_preference(mut self, input: crate::model::ConferencePreference) -> Self {
            self.conference_preference = Some(input);
            self
        }
        /// <p>The conference preference of a specific conference provider.</p>
        pub fn set_conference_preference(
            mut self,
            input: std::option::Option<crate::model::ConferencePreference>,
        ) -> Self {
            self.conference_preference = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConferencePreferenceInput`](crate::input::PutConferencePreferenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConferencePreferenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConferencePreferenceInput {
                conference_preference: self.conference_preference,
            })
        }
    }
}
#[doc(hidden)]
pub type PutConferencePreferenceInputOperationOutputAlias =
    crate::operation::PutConferencePreference;
#[doc(hidden)]
pub type PutConferencePreferenceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutConferencePreferenceInput {
    /// Consumes the builder and constructs an Operation<[`PutConferencePreference`](crate::operation::PutConferencePreference)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConferencePreference,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutConferencePreferenceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutConferencePreferenceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutConferencePreferenceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.PutConferencePreference",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_conference_preference(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConferencePreference::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConferencePreference",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutConferencePreferenceInput`](crate::input::PutConferencePreferenceInput)
    pub fn builder() -> crate::input::put_conference_preference_input::Builder {
        crate::input::put_conference_preference_input::Builder::default()
    }
}

/// See [`PutInvitationConfigurationInput`](crate::input::PutInvitationConfigurationInput)
pub mod put_invitation_configuration_input {
    /// A builder for [`PutInvitationConfigurationInput`](crate::input::PutInvitationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_name: std::option::Option<std::string::String>,
        pub(crate) contact_email: std::option::Option<std::string::String>,
        pub(crate) private_skill_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the organization sending the enrollment invite to a user.</p>
        pub fn organization_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_name = Some(input.into());
            self
        }
        /// <p>The name of the organization sending the enrollment invite to a user.</p>
        pub fn set_organization_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_name = input;
            self
        }
        /// <p>The email ID of the organization or individual contact that the enrolled user can use.
        /// </p>
        pub fn contact_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_email = Some(input.into());
            self
        }
        /// <p>The email ID of the organization or individual contact that the enrolled user can use.
        /// </p>
        pub fn set_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_email = input;
            self
        }
        /// Appends an item to `private_skill_ids`.
        ///
        /// To override the contents of this collection use [`set_private_skill_ids`](Self::set_private_skill_ids).
        ///
        /// <p>The list of private skill IDs that you want to recommend to the user to enable in the
        /// invitation.</p>
        pub fn private_skill_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.private_skill_ids.unwrap_or_default();
            v.push(input.into());
            self.private_skill_ids = Some(v);
            self
        }
        /// <p>The list of private skill IDs that you want to recommend to the user to enable in the
        /// invitation.</p>
        pub fn set_private_skill_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.private_skill_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`PutInvitationConfigurationInput`](crate::input::PutInvitationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutInvitationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutInvitationConfigurationInput {
                organization_name: self.organization_name,
                contact_email: self.contact_email,
                private_skill_ids: self.private_skill_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type PutInvitationConfigurationInputOperationOutputAlias =
    crate::operation::PutInvitationConfiguration;
#[doc(hidden)]
pub type PutInvitationConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutInvitationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutInvitationConfiguration`](crate::operation::PutInvitationConfiguration)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutInvitationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutInvitationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutInvitationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutInvitationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.PutInvitationConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_invitation_configuration(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutInvitationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutInvitationConfiguration",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutInvitationConfigurationInput`](crate::input::PutInvitationConfigurationInput)
    pub fn builder() -> crate::input::put_invitation_configuration_input::Builder {
        crate::input::put_invitation_configuration_input::Builder::default()
    }
}

/// See [`PutRoomSkillParameterInput`](crate::input::PutRoomSkillParameterInput)
pub mod put_room_skill_parameter_input {
    /// A builder for [`PutRoomSkillParameterInput`](crate::input::PutRoomSkillParameterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) skill_id: std::option::Option<std::string::String>,
        pub(crate) room_skill_parameter: std::option::Option<crate::model::RoomSkillParameter>,
    }
    impl Builder {
        /// <p>The ARN of the room associated with the room skill parameter. Required.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room associated with the room skill parameter. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The ARN of the skill associated with the room skill parameter. Required.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The ARN of the skill associated with the room skill parameter. Required.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// <p>The updated room skill parameter. Required.</p>
        pub fn room_skill_parameter(mut self, input: crate::model::RoomSkillParameter) -> Self {
            self.room_skill_parameter = Some(input);
            self
        }
        /// <p>The updated room skill parameter. Required.</p>
        pub fn set_room_skill_parameter(
            mut self,
            input: std::option::Option<crate::model::RoomSkillParameter>,
        ) -> Self {
            self.room_skill_parameter = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRoomSkillParameterInput`](crate::input::PutRoomSkillParameterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRoomSkillParameterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRoomSkillParameterInput {
                room_arn: self.room_arn,
                skill_id: self.skill_id,
                room_skill_parameter: self.room_skill_parameter,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRoomSkillParameterInputOperationOutputAlias = crate::operation::PutRoomSkillParameter;
#[doc(hidden)]
pub type PutRoomSkillParameterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRoomSkillParameterInput {
    /// Consumes the builder and constructs an Operation<[`PutRoomSkillParameter`](crate::operation::PutRoomSkillParameter)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRoomSkillParameter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRoomSkillParameterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRoomSkillParameterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRoomSkillParameterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.PutRoomSkillParameter",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_room_skill_parameter(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRoomSkillParameter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRoomSkillParameter",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRoomSkillParameterInput`](crate::input::PutRoomSkillParameterInput)
    pub fn builder() -> crate::input::put_room_skill_parameter_input::Builder {
        crate::input::put_room_skill_parameter_input::Builder::default()
    }
}

/// See [`PutSkillAuthorizationInput`](crate::input::PutSkillAuthorizationInput)
pub mod put_skill_authorization_input {
    /// A builder for [`PutSkillAuthorizationInput`](crate::input::PutSkillAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization_result: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) skill_id: std::option::Option<std::string::String>,
        pub(crate) room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `authorization_result`.
        ///
        /// To override the contents of this collection use [`set_authorization_result`](Self::set_authorization_result).
        ///
        /// <p>The authorization result specific to OAUTH code grant output. "Code” must be
        /// populated in the AuthorizationResult map to establish the authorization.</p>
        pub fn authorization_result(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.authorization_result.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.authorization_result = Some(hash_map);
            self
        }
        /// <p>The authorization result specific to OAUTH code grant output. "Code” must be
        /// populated in the AuthorizationResult map to establish the authorization.</p>
        pub fn set_authorization_result(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.authorization_result = input;
            self
        }
        /// <p>The unique identifier of a skill.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// <p>The room that the skill is authorized for.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The room that the skill is authorized for.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSkillAuthorizationInput`](crate::input::PutSkillAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutSkillAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutSkillAuthorizationInput {
                authorization_result: self.authorization_result,
                skill_id: self.skill_id,
                room_arn: self.room_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type PutSkillAuthorizationInputOperationOutputAlias = crate::operation::PutSkillAuthorization;
#[doc(hidden)]
pub type PutSkillAuthorizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutSkillAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`PutSkillAuthorization`](crate::operation::PutSkillAuthorization)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutSkillAuthorization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutSkillAuthorizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutSkillAuthorizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutSkillAuthorizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.PutSkillAuthorization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_skill_authorization(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutSkillAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutSkillAuthorization",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutSkillAuthorizationInput`](crate::input::PutSkillAuthorizationInput)
    pub fn builder() -> crate::input::put_skill_authorization_input::Builder {
        crate::input::put_skill_authorization_input::Builder::default()
    }
}

/// See [`RegisterAvsDeviceInput`](crate::input::RegisterAvsDeviceInput)
pub mod register_avs_device_input {
    /// A builder for [`RegisterAvsDeviceInput`](crate::input::RegisterAvsDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) user_code: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) device_serial_number: std::option::Option<std::string::String>,
        pub(crate) amazon_id: std::option::Option<std::string::String>,
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The client ID of the OEM used for code-based linking authorization on an AVS
        /// device.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID of the OEM used for code-based linking authorization on an AVS
        /// device.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The code that is obtained after your AVS device has made a POST request to LWA as a
        /// part of the Device Authorization Request component of the OAuth code-based linking
        /// specification.</p>
        pub fn user_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_code = Some(input.into());
            self
        }
        /// <p>The code that is obtained after your AVS device has made a POST request to LWA as a
        /// part of the Device Authorization Request component of the OAuth code-based linking
        /// specification.</p>
        pub fn set_user_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_code = input;
            self
        }
        /// <p>The product ID used to identify your AVS device during authorization.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product ID used to identify your AVS device during authorization.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The key generated by the OEM that uniquely identifies a specified instance of your
        /// AVS device.</p>
        pub fn device_serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_serial_number = Some(input.into());
            self
        }
        /// <p>The key generated by the OEM that uniquely identifies a specified instance of your
        /// AVS device.</p>
        pub fn set_device_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_serial_number = input;
            self
        }
        /// <p>The device type ID for your AVS device generated by Amazon when the OEM creates a new
        /// product on Amazon's Developer Console.</p>
        pub fn amazon_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_id = Some(input.into());
            self
        }
        /// <p>The device type ID for your AVS device generated by Amazon when the OEM creates a new
        /// product on Amazon's Developer Console.</p>
        pub fn set_amazon_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.amazon_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the room with which to associate your AVS device.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the room with which to associate your AVS device.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterAvsDeviceInput`](crate::input::RegisterAvsDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterAvsDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterAvsDeviceInput {
                client_id: self.client_id,
                user_code: self.user_code,
                product_id: self.product_id,
                device_serial_number: self.device_serial_number,
                amazon_id: self.amazon_id,
                room_arn: self.room_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterAvsDeviceInputOperationOutputAlias = crate::operation::RegisterAVSDevice;
#[doc(hidden)]
pub type RegisterAvsDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterAvsDeviceInput {
    /// Consumes the builder and constructs an Operation<[`RegisterAVSDevice`](crate::operation::RegisterAVSDevice)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterAVSDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterAvsDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterAvsDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterAvsDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.RegisterAVSDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_avs_device(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterAVSDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterAVSDevice",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterAvsDeviceInput`](crate::input::RegisterAvsDeviceInput)
    pub fn builder() -> crate::input::register_avs_device_input::Builder {
        crate::input::register_avs_device_input::Builder::default()
    }
}

/// See [`RejectSkillInput`](crate::input::RejectSkillInput)
pub mod reject_skill_input {
    /// A builder for [`RejectSkillInput`](crate::input::RejectSkillInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the skill.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectSkillInput`](crate::input::RejectSkillInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectSkillInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectSkillInput {
                skill_id: self.skill_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectSkillInputOperationOutputAlias = crate::operation::RejectSkill;
#[doc(hidden)]
pub type RejectSkillInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RejectSkillInput {
    /// Consumes the builder and constructs an Operation<[`RejectSkill`](crate::operation::RejectSkill)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectSkill,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RejectSkillInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RejectSkillInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RejectSkillInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.RejectSkill",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_reject_skill(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectSkill::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectSkill",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RejectSkillInput`](crate::input::RejectSkillInput)
    pub fn builder() -> crate::input::reject_skill_input::Builder {
        crate::input::reject_skill_input::Builder::default()
    }
}

/// See [`ResolveRoomInput`](crate::input::ResolveRoomInput)
pub mod resolve_room_input {
    /// A builder for [`ResolveRoomInput`](crate::input::ResolveRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) skill_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the user. Required.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ARN of the user. Required.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The ARN of the skill that was requested. Required.</p>
        pub fn skill_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_id = Some(input.into());
            self
        }
        /// <p>The ARN of the skill that was requested. Required.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.skill_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveRoomInput`](crate::input::ResolveRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResolveRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResolveRoomInput {
                user_id: self.user_id,
                skill_id: self.skill_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ResolveRoomInputOperationOutputAlias = crate::operation::ResolveRoom;
#[doc(hidden)]
pub type ResolveRoomInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResolveRoomInput {
    /// Consumes the builder and constructs an Operation<[`ResolveRoom`](crate::operation::ResolveRoom)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResolveRoom,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResolveRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResolveRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResolveRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.ResolveRoom",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_resolve_room(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResolveRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResolveRoom",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResolveRoomInput`](crate::input::ResolveRoomInput)
    pub fn builder() -> crate::input::resolve_room_input::Builder {
        crate::input::resolve_room_input::Builder::default()
    }
}

/// See [`RevokeInvitationInput`](crate::input::RevokeInvitationInput)
pub mod revoke_invitation_input {
    /// A builder for [`RevokeInvitationInput`](crate::input::RevokeInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) enrollment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the user for whom to revoke an enrollment invitation. Required.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user for whom to revoke an enrollment invitation. Required.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The ARN of the enrollment invitation to revoke. Required.</p>
        pub fn enrollment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.enrollment_id = Some(input.into());
            self
        }
        /// <p>The ARN of the enrollment invitation to revoke. Required.</p>
        pub fn set_enrollment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.enrollment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeInvitationInput`](crate::input::RevokeInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RevokeInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RevokeInvitationInput {
                user_arn: self.user_arn,
                enrollment_id: self.enrollment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RevokeInvitationInputOperationOutputAlias = crate::operation::RevokeInvitation;
#[doc(hidden)]
pub type RevokeInvitationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RevokeInvitationInput {
    /// Consumes the builder and constructs an Operation<[`RevokeInvitation`](crate::operation::RevokeInvitation)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RevokeInvitation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RevokeInvitationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RevokeInvitationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RevokeInvitationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.RevokeInvitation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_revoke_invitation(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RevokeInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RevokeInvitation",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RevokeInvitationInput`](crate::input::RevokeInvitationInput)
    pub fn builder() -> crate::input::revoke_invitation_input::Builder {
        crate::input::revoke_invitation_input::Builder::default()
    }
}

/// See [`SearchAddressBooksInput`](crate::input::SearchAddressBooksInput)
pub mod search_address_books_input {
    /// A builder for [`SearchAddressBooksInput`](crate::input::SearchAddressBooksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of address books. The supported filter key
        /// is AddressBookName.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to list a specified set of address books. The supported filter key
        /// is AddressBookName.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `sort_criteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of address books. The supported
        /// sort key is AddressBookName.</p>
        pub fn sort_criteria(mut self, input: impl Into<crate::model::Sort>) -> Self {
            let mut v = self.sort_criteria.unwrap_or_default();
            v.push(input.into());
            self.sort_criteria = Some(v);
            self
        }
        /// <p>The sort order to use in listing the specified set of address books. The supported
        /// sort key is AddressBookName.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchAddressBooksInput`](crate::input::SearchAddressBooksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchAddressBooksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchAddressBooksInput {
                filters: self.filters,
                sort_criteria: self.sort_criteria,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchAddressBooksInputOperationOutputAlias = crate::operation::SearchAddressBooks;
#[doc(hidden)]
pub type SearchAddressBooksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchAddressBooksInput {
    /// Consumes the builder and constructs an Operation<[`SearchAddressBooks`](crate::operation::SearchAddressBooks)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchAddressBooks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchAddressBooksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchAddressBooksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchAddressBooksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SearchAddressBooks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_address_books(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchAddressBooks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchAddressBooks",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchAddressBooksInput`](crate::input::SearchAddressBooksInput)
    pub fn builder() -> crate::input::search_address_books_input::Builder {
        crate::input::search_address_books_input::Builder::default()
    }
}

/// See [`SearchContactsInput`](crate::input::SearchContactsInput)
pub mod search_contacts_input {
    /// A builder for [`SearchContactsInput`](crate::input::SearchContactsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of address books. The supported filter
        /// keys are DisplayName, FirstName, LastName, and AddressBookArns.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to list a specified set of address books. The supported filter
        /// keys are DisplayName, FirstName, LastName, and AddressBookArns.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `sort_criteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of contacts. The supported sort
        /// keys are DisplayName, FirstName, and LastName.</p>
        pub fn sort_criteria(mut self, input: impl Into<crate::model::Sort>) -> Self {
            let mut v = self.sort_criteria.unwrap_or_default();
            v.push(input.into());
            self.sort_criteria = Some(v);
            self
        }
        /// <p>The sort order to use in listing the specified set of contacts. The supported sort
        /// keys are DisplayName, FirstName, and LastName.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchContactsInput`](crate::input::SearchContactsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchContactsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchContactsInput {
                filters: self.filters,
                sort_criteria: self.sort_criteria,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchContactsInputOperationOutputAlias = crate::operation::SearchContacts;
#[doc(hidden)]
pub type SearchContactsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchContactsInput {
    /// Consumes the builder and constructs an Operation<[`SearchContacts`](crate::operation::SearchContacts)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchContacts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchContactsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchContactsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchContactsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SearchContacts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_search_contacts(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchContacts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchContacts",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchContactsInput`](crate::input::SearchContactsInput)
    pub fn builder() -> crate::input::search_contacts_input::Builder {
        crate::input::search_contacts_input::Builder::default()
    }
}

/// See [`SearchDevicesInput`](crate::input::SearchDevicesInput)
pub mod search_devices_input {
    /// A builder for [`SearchDevicesInput`](crate::input::SearchDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
    }
    impl Builder {
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of devices. Supported filter keys are
        /// DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType, DeviceSerialNumber,
        /// UnassociatedOnly, ConnectionStatus (ONLINE and OFFLINE), NetworkProfileName,
        /// NetworkProfileArn, Feature, and FailureCode.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to list a specified set of devices. Supported filter keys are
        /// DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType, DeviceSerialNumber,
        /// UnassociatedOnly, ConnectionStatus (ONLINE and OFFLINE), NetworkProfileName,
        /// NetworkProfileArn, Feature, and FailureCode.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `sort_criteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of devices. Supported sort keys
        /// are DeviceName, DeviceStatus, RoomName, DeviceType, DeviceSerialNumber, ConnectionStatus,
        /// NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.</p>
        pub fn sort_criteria(mut self, input: impl Into<crate::model::Sort>) -> Self {
            let mut v = self.sort_criteria.unwrap_or_default();
            v.push(input.into());
            self.sort_criteria = Some(v);
            self
        }
        /// <p>The sort order to use in listing the specified set of devices. Supported sort keys
        /// are DeviceName, DeviceStatus, RoomName, DeviceType, DeviceSerialNumber, ConnectionStatus,
        /// NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchDevicesInput`](crate::input::SearchDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchDevicesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchDevicesInputOperationOutputAlias = crate::operation::SearchDevices;
#[doc(hidden)]
pub type SearchDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchDevicesInput {
    /// Consumes the builder and constructs an Operation<[`SearchDevices`](crate::operation::SearchDevices)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchDevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SearchDevices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_search_devices(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchDevices",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchDevicesInput`](crate::input::SearchDevicesInput)
    pub fn builder() -> crate::input::search_devices_input::Builder {
        crate::input::search_devices_input::Builder::default()
    }
}

/// See [`SearchNetworkProfilesInput`](crate::input::SearchNetworkProfilesInput)
pub mod search_network_profiles_input {
    /// A builder for [`SearchNetworkProfilesInput`](crate::input::SearchNetworkProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
    }
    impl Builder {
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by MaxResults. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by MaxResults. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the
        /// specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the
        /// specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of network profiles. Valid filters are
        /// NetworkProfileName, Ssid, and SecurityType.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to list a specified set of network profiles. Valid filters are
        /// NetworkProfileName, Ssid, and SecurityType.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `sort_criteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use to list the specified set of network profiles. Valid sort criteria
        /// includes NetworkProfileName, Ssid, and SecurityType.</p>
        pub fn sort_criteria(mut self, input: impl Into<crate::model::Sort>) -> Self {
            let mut v = self.sort_criteria.unwrap_or_default();
            v.push(input.into());
            self.sort_criteria = Some(v);
            self
        }
        /// <p>The sort order to use to list the specified set of network profiles. Valid sort criteria
        /// includes NetworkProfileName, Ssid, and SecurityType.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchNetworkProfilesInput`](crate::input::SearchNetworkProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchNetworkProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchNetworkProfilesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchNetworkProfilesInputOperationOutputAlias = crate::operation::SearchNetworkProfiles;
#[doc(hidden)]
pub type SearchNetworkProfilesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchNetworkProfilesInput {
    /// Consumes the builder and constructs an Operation<[`SearchNetworkProfiles`](crate::operation::SearchNetworkProfiles)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchNetworkProfiles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchNetworkProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchNetworkProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchNetworkProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SearchNetworkProfiles",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_network_profiles(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchNetworkProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchNetworkProfiles",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchNetworkProfilesInput`](crate::input::SearchNetworkProfilesInput)
    pub fn builder() -> crate::input::search_network_profiles_input::Builder {
        crate::input::search_network_profiles_input::Builder::default()
    }
}

/// See [`SearchProfilesInput`](crate::input::SearchProfilesInput)
pub mod search_profiles_input {
    /// A builder for [`SearchProfilesInput`](crate::input::SearchProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
    }
    impl Builder {
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of room profiles. Supported filter keys
        /// are ProfileName and Address. Required. </p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to list a specified set of room profiles. Supported filter keys
        /// are ProfileName and Address. Required. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `sort_criteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of room profiles. Supported sort
        /// keys are ProfileName and Address.</p>
        pub fn sort_criteria(mut self, input: impl Into<crate::model::Sort>) -> Self {
            let mut v = self.sort_criteria.unwrap_or_default();
            v.push(input.into());
            self.sort_criteria = Some(v);
            self
        }
        /// <p>The sort order to use in listing the specified set of room profiles. Supported sort
        /// keys are ProfileName and Address.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchProfilesInput`](crate::input::SearchProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchProfilesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchProfilesInputOperationOutputAlias = crate::operation::SearchProfiles;
#[doc(hidden)]
pub type SearchProfilesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchProfilesInput {
    /// Consumes the builder and constructs an Operation<[`SearchProfiles`](crate::operation::SearchProfiles)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchProfiles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SearchProfiles",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_search_profiles(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchProfiles",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchProfilesInput`](crate::input::SearchProfilesInput)
    pub fn builder() -> crate::input::search_profiles_input::Builder {
        crate::input::search_profiles_input::Builder::default()
    }
}

/// See [`SearchRoomsInput`](crate::input::SearchRoomsInput)
pub mod search_rooms_input {
    /// A builder for [`SearchRoomsInput`](crate::input::SearchRoomsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
    }
    impl Builder {
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of rooms. The supported filter keys are
        /// RoomName and ProfileName.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to list a specified set of rooms. The supported filter keys are
        /// RoomName and ProfileName.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `sort_criteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of rooms. The supported sort keys
        /// are RoomName and ProfileName.</p>
        pub fn sort_criteria(mut self, input: impl Into<crate::model::Sort>) -> Self {
            let mut v = self.sort_criteria.unwrap_or_default();
            v.push(input.into());
            self.sort_criteria = Some(v);
            self
        }
        /// <p>The sort order to use in listing the specified set of rooms. The supported sort keys
        /// are RoomName and ProfileName.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchRoomsInput`](crate::input::SearchRoomsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchRoomsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchRoomsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchRoomsInputOperationOutputAlias = crate::operation::SearchRooms;
#[doc(hidden)]
pub type SearchRoomsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchRoomsInput {
    /// Consumes the builder and constructs an Operation<[`SearchRooms`](crate::operation::SearchRooms)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchRooms,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchRoomsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchRoomsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchRoomsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SearchRooms",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_search_rooms(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchRooms::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchRooms",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchRoomsInput`](crate::input::SearchRoomsInput)
    pub fn builder() -> crate::input::search_rooms_input::Builder {
        crate::input::search_rooms_input::Builder::default()
    }
}

/// See [`SearchSkillGroupsInput`](crate::input::SearchSkillGroupsInput)
pub mod search_skill_groups_input {
    /// A builder for [`SearchSkillGroupsInput`](crate::input::SearchSkillGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
    }
    impl Builder {
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.
        /// Required.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.
        /// Required.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of skill groups. The supported filter key
        /// is SkillGroupName. </p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to list a specified set of skill groups. The supported filter key
        /// is SkillGroupName. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `sort_criteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of skill groups. The supported
        /// sort key is SkillGroupName. </p>
        pub fn sort_criteria(mut self, input: impl Into<crate::model::Sort>) -> Self {
            let mut v = self.sort_criteria.unwrap_or_default();
            v.push(input.into());
            self.sort_criteria = Some(v);
            self
        }
        /// <p>The sort order to use in listing the specified set of skill groups. The supported
        /// sort key is SkillGroupName. </p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchSkillGroupsInput`](crate::input::SearchSkillGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchSkillGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchSkillGroupsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchSkillGroupsInputOperationOutputAlias = crate::operation::SearchSkillGroups;
#[doc(hidden)]
pub type SearchSkillGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchSkillGroupsInput {
    /// Consumes the builder and constructs an Operation<[`SearchSkillGroups`](crate::operation::SearchSkillGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchSkillGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchSkillGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchSkillGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchSkillGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SearchSkillGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_skill_groups(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchSkillGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchSkillGroups",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchSkillGroupsInput`](crate::input::SearchSkillGroupsInput)
    pub fn builder() -> crate::input::search_skill_groups_input::Builder {
        crate::input::search_skill_groups_input::Builder::default()
    }
}

/// See [`SearchUsersInput`](crate::input::SearchUsersInput)
pub mod search_users_input {
    /// A builder for [`SearchUsersInput`](crate::input::SearchUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
    }
    impl Builder {
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.
        /// Required.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.
        /// Required.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. Required.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. Required.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use for listing a specific set of users. Required. Supported filter
        /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use for listing a specific set of users. Required. Supported filter
        /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `sort_criteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the filtered set of users. Required. Supported sort
        /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
        pub fn sort_criteria(mut self, input: impl Into<crate::model::Sort>) -> Self {
            let mut v = self.sort_criteria.unwrap_or_default();
            v.push(input.into());
            self.sort_criteria = Some(v);
            self
        }
        /// <p>The sort order to use in listing the filtered set of users. Required. Supported sort
        /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchUsersInput`](crate::input::SearchUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchUsersInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchUsersInputOperationOutputAlias = crate::operation::SearchUsers;
#[doc(hidden)]
pub type SearchUsersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchUsersInput {
    /// Consumes the builder and constructs an Operation<[`SearchUsers`](crate::operation::SearchUsers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchUsers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SearchUsers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_search_users(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchUsers",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchUsersInput`](crate::input::SearchUsersInput)
    pub fn builder() -> crate::input::search_users_input::Builder {
        crate::input::search_users_input::Builder::default()
    }
}

/// See [`SendAnnouncementInput`](crate::input::SendAnnouncementInput)
pub mod send_announcement_input {
    /// A builder for [`SendAnnouncementInput`](crate::input::SendAnnouncementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) content: std::option::Option<crate::model::Content>,
        pub(crate) time_to_live_in_seconds: std::option::Option<i32>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `room_filters`.
        ///
        /// To override the contents of this collection use [`set_room_filters`](Self::set_room_filters).
        ///
        /// <p>The filters to use to send an announcement to a specified list of rooms. The supported filter keys are RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.</p>
        pub fn room_filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.room_filters.unwrap_or_default();
            v.push(input.into());
            self.room_filters = Some(v);
            self
        }
        /// <p>The filters to use to send an announcement to a specified list of rooms. The supported filter keys are RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.</p>
        pub fn set_room_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.room_filters = input;
            self
        }
        /// <p>The announcement content. This can contain only one of the three possible announcement types (text, SSML or audio).</p>
        pub fn content(mut self, input: crate::model::Content) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The announcement content. This can contain only one of the three possible announcement types (text, SSML or audio).</p>
        pub fn set_content(mut self, input: std::option::Option<crate::model::Content>) -> Self {
            self.content = input;
            self
        }
        /// <p>The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the
        /// announcement is not delivered.</p>
        pub fn time_to_live_in_seconds(mut self, input: i32) -> Self {
            self.time_to_live_in_seconds = Some(input);
            self
        }
        /// <p>The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the
        /// announcement is not delivered.</p>
        pub fn set_time_to_live_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.time_to_live_in_seconds = input;
            self
        }
        /// <p>The unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SendAnnouncementInput`](crate::input::SendAnnouncementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendAnnouncementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendAnnouncementInput {
                room_filters: self.room_filters,
                content: self.content,
                time_to_live_in_seconds: self.time_to_live_in_seconds,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SendAnnouncementInputOperationOutputAlias = crate::operation::SendAnnouncement;
#[doc(hidden)]
pub type SendAnnouncementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendAnnouncementInput {
    /// Consumes the builder and constructs an Operation<[`SendAnnouncement`](crate::operation::SendAnnouncement)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendAnnouncement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendAnnouncementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendAnnouncementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendAnnouncementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SendAnnouncement",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_announcement(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendAnnouncement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendAnnouncement",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendAnnouncementInput`](crate::input::SendAnnouncementInput)
    pub fn builder() -> crate::input::send_announcement_input::Builder {
        crate::input::send_announcement_input::Builder::default()
    }
}

/// See [`SendInvitationInput`](crate::input::SendInvitationInput)
pub mod send_invitation_input {
    /// A builder for [`SendInvitationInput`](crate::input::SendInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the user to whom to send an invitation. Required.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user to whom to send an invitation. Required.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SendInvitationInput`](crate::input::SendInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendInvitationInput {
                user_arn: self.user_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type SendInvitationInputOperationOutputAlias = crate::operation::SendInvitation;
#[doc(hidden)]
pub type SendInvitationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendInvitationInput {
    /// Consumes the builder and constructs an Operation<[`SendInvitation`](crate::operation::SendInvitation)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendInvitation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendInvitationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendInvitationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendInvitationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.SendInvitation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_send_invitation(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendInvitation",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendInvitationInput`](crate::input::SendInvitationInput)
    pub fn builder() -> crate::input::send_invitation_input::Builder {
        crate::input::send_invitation_input::Builder::default()
    }
}

/// See [`StartDeviceSyncInput`](crate::input::StartDeviceSyncInput)
pub mod start_device_sync_input {
    /// A builder for [`StartDeviceSyncInput`](crate::input::StartDeviceSyncInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) features: std::option::Option<std::vec::Vec<crate::model::Feature>>,
    }
    impl Builder {
        /// <p>The ARN of the room with which the device to sync is associated. Required.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room with which the device to sync is associated. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The ARN of the device to sync. Required.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device to sync. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// Appends an item to `features`.
        ///
        /// To override the contents of this collection use [`set_features`](Self::set_features).
        ///
        /// <p>Request structure to start the device sync. Required.</p>
        pub fn features(mut self, input: impl Into<crate::model::Feature>) -> Self {
            let mut v = self.features.unwrap_or_default();
            v.push(input.into());
            self.features = Some(v);
            self
        }
        /// <p>Request structure to start the device sync. Required.</p>
        pub fn set_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Feature>>,
        ) -> Self {
            self.features = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDeviceSyncInput`](crate::input::StartDeviceSyncInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDeviceSyncInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDeviceSyncInput {
                room_arn: self.room_arn,
                device_arn: self.device_arn,
                features: self.features,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDeviceSyncInputOperationOutputAlias = crate::operation::StartDeviceSync;
#[doc(hidden)]
pub type StartDeviceSyncInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartDeviceSyncInput {
    /// Consumes the builder and constructs an Operation<[`StartDeviceSync`](crate::operation::StartDeviceSync)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDeviceSync,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDeviceSyncInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDeviceSyncInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDeviceSyncInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.StartDeviceSync",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_device_sync(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDeviceSync::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDeviceSync",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDeviceSyncInput`](crate::input::StartDeviceSyncInput)
    pub fn builder() -> crate::input::start_device_sync_input::Builder {
        crate::input::start_device_sync_input::Builder::default()
    }
}

/// See [`StartSmartHomeApplianceDiscoveryInput`](crate::input::StartSmartHomeApplianceDiscoveryInput)
pub mod start_smart_home_appliance_discovery_input {
    /// A builder for [`StartSmartHomeApplianceDiscoveryInput`](crate::input::StartSmartHomeApplianceDiscoveryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The room where smart home appliance discovery was initiated.</p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The room where smart home appliance discovery was initiated.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSmartHomeApplianceDiscoveryInput`](crate::input::StartSmartHomeApplianceDiscoveryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSmartHomeApplianceDiscoveryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSmartHomeApplianceDiscoveryInput {
                room_arn: self.room_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSmartHomeApplianceDiscoveryInputOperationOutputAlias =
    crate::operation::StartSmartHomeApplianceDiscovery;
#[doc(hidden)]
pub type StartSmartHomeApplianceDiscoveryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartSmartHomeApplianceDiscoveryInput {
    /// Consumes the builder and constructs an Operation<[`StartSmartHomeApplianceDiscovery`](crate::operation::StartSmartHomeApplianceDiscovery)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSmartHomeApplianceDiscovery,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartSmartHomeApplianceDiscoveryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartSmartHomeApplianceDiscoveryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartSmartHomeApplianceDiscoveryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.StartSmartHomeApplianceDiscovery",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_smart_home_appliance_discovery(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSmartHomeApplianceDiscovery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSmartHomeApplianceDiscovery",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartSmartHomeApplianceDiscoveryInput`](crate::input::StartSmartHomeApplianceDiscoveryInput)
    pub fn builder() -> crate::input::start_smart_home_appliance_discovery_input::Builder {
        crate::input::start_smart_home_appliance_discovery_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the resource to which to add metadata tags. Required. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to which to add metadata tags. Required. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags. Required.
        /// </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags. Required.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                arn: self.arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource from which to remove metadata tags. Required. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource from which to remove metadata tags. Required. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags to be removed from the specified resource. Do not provide system tags.
        /// Required. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tags to be removed from the specified resource. Do not provide system tags.
        /// Required. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                arn: self.arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAddressBookInput`](crate::input::UpdateAddressBookInput)
pub mod update_address_book_input {
    /// A builder for [`UpdateAddressBookInput`](crate::input::UpdateAddressBookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address_book_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the room to update.</p>
        pub fn address_book_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_book_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room to update.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_book_arn = input;
            self
        }
        /// <p>The updated name of the room.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated name of the room.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated description of the room.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the room.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAddressBookInput`](crate::input::UpdateAddressBookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAddressBookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAddressBookInput {
                address_book_arn: self.address_book_arn,
                name: self.name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAddressBookInputOperationOutputAlias = crate::operation::UpdateAddressBook;
#[doc(hidden)]
pub type UpdateAddressBookInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAddressBookInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAddressBook`](crate::operation::UpdateAddressBook)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAddressBook,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAddressBookInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAddressBookInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAddressBookInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateAddressBook",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_address_book(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAddressBook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAddressBook",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAddressBookInput`](crate::input::UpdateAddressBookInput)
    pub fn builder() -> crate::input::update_address_book_input::Builder {
        crate::input::update_address_book_input::Builder::default()
    }
}

/// See [`UpdateBusinessReportScheduleInput`](crate::input::UpdateBusinessReportScheduleInput)
pub mod update_business_report_schedule_input {
    /// A builder for [`UpdateBusinessReportScheduleInput`](crate::input::UpdateBusinessReportScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_arn: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::BusinessReportFormat>,
        pub(crate) schedule_name: std::option::Option<std::string::String>,
        pub(crate) recurrence: std::option::Option<crate::model::BusinessReportRecurrence>,
    }
    impl Builder {
        /// <p>The ARN of the business report schedule.</p>
        pub fn schedule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the business report schedule.</p>
        pub fn set_schedule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule_arn = input;
            self
        }
        /// <p>The S3 location of the output reports.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The S3 location of the output reports.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn format(mut self, input: crate::model::BusinessReportFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::BusinessReportFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The name identifier of the schedule.</p>
        pub fn schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_name = Some(input.into());
            self
        }
        /// <p>The name identifier of the schedule.</p>
        pub fn set_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_name = input;
            self
        }
        /// <p>The recurrence of the reports.</p>
        pub fn recurrence(mut self, input: crate::model::BusinessReportRecurrence) -> Self {
            self.recurrence = Some(input);
            self
        }
        /// <p>The recurrence of the reports.</p>
        pub fn set_recurrence(
            mut self,
            input: std::option::Option<crate::model::BusinessReportRecurrence>,
        ) -> Self {
            self.recurrence = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBusinessReportScheduleInput`](crate::input::UpdateBusinessReportScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBusinessReportScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBusinessReportScheduleInput {
                schedule_arn: self.schedule_arn,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                format: self.format,
                schedule_name: self.schedule_name,
                recurrence: self.recurrence,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBusinessReportScheduleInputOperationOutputAlias =
    crate::operation::UpdateBusinessReportSchedule;
#[doc(hidden)]
pub type UpdateBusinessReportScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateBusinessReportScheduleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBusinessReportSchedule`](crate::operation::UpdateBusinessReportSchedule)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBusinessReportSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBusinessReportScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBusinessReportScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBusinessReportScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateBusinessReportSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_business_report_schedule(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBusinessReportSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBusinessReportSchedule",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBusinessReportScheduleInput`](crate::input::UpdateBusinessReportScheduleInput)
    pub fn builder() -> crate::input::update_business_report_schedule_input::Builder {
        crate::input::update_business_report_schedule_input::Builder::default()
    }
}

/// See [`UpdateConferenceProviderInput`](crate::input::UpdateConferenceProviderInput)
pub mod update_conference_provider_input {
    /// A builder for [`UpdateConferenceProviderInput`](crate::input::UpdateConferenceProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conference_provider_arn: std::option::Option<std::string::String>,
        pub(crate) conference_provider_type:
            std::option::Option<crate::model::ConferenceProviderType>,
        pub(crate) ip_dial_in: std::option::Option<crate::model::IpDialIn>,
        pub(crate) pstn_dial_in: std::option::Option<crate::model::PstnDialIn>,
        pub(crate) meeting_setting: std::option::Option<crate::model::MeetingSetting>,
    }
    impl Builder {
        /// <p>The ARN of the conference provider.</p>
        pub fn conference_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.conference_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the conference provider.</p>
        pub fn set_conference_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conference_provider_arn = input;
            self
        }
        /// <p>The type of the conference provider.</p>
        pub fn conference_provider_type(
            mut self,
            input: crate::model::ConferenceProviderType,
        ) -> Self {
            self.conference_provider_type = Some(input);
            self
        }
        /// <p>The type of the conference provider.</p>
        pub fn set_conference_provider_type(
            mut self,
            input: std::option::Option<crate::model::ConferenceProviderType>,
        ) -> Self {
            self.conference_provider_type = input;
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn ip_dial_in(mut self, input: crate::model::IpDialIn) -> Self {
            self.ip_dial_in = Some(input);
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn set_ip_dial_in(
            mut self,
            input: std::option::Option<crate::model::IpDialIn>,
        ) -> Self {
            self.ip_dial_in = input;
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn pstn_dial_in(mut self, input: crate::model::PstnDialIn) -> Self {
            self.pstn_dial_in = Some(input);
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn set_pstn_dial_in(
            mut self,
            input: std::option::Option<crate::model::PstnDialIn>,
        ) -> Self {
            self.pstn_dial_in = input;
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn meeting_setting(mut self, input: crate::model::MeetingSetting) -> Self {
            self.meeting_setting = Some(input);
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn set_meeting_setting(
            mut self,
            input: std::option::Option<crate::model::MeetingSetting>,
        ) -> Self {
            self.meeting_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConferenceProviderInput`](crate::input::UpdateConferenceProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConferenceProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConferenceProviderInput {
                conference_provider_arn: self.conference_provider_arn,
                conference_provider_type: self.conference_provider_type,
                ip_dial_in: self.ip_dial_in,
                pstn_dial_in: self.pstn_dial_in,
                meeting_setting: self.meeting_setting,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConferenceProviderInputOperationOutputAlias =
    crate::operation::UpdateConferenceProvider;
#[doc(hidden)]
pub type UpdateConferenceProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConferenceProviderInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConferenceProvider`](crate::operation::UpdateConferenceProvider)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConferenceProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConferenceProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConferenceProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConferenceProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateConferenceProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_conference_provider(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConferenceProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConferenceProvider",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConferenceProviderInput`](crate::input::UpdateConferenceProviderInput)
    pub fn builder() -> crate::input::update_conference_provider_input::Builder {
        crate::input::update_conference_provider_input::Builder::default()
    }
}

/// See [`UpdateContactInput`](crate::input::UpdateContactInput)
pub mod update_contact_input {
    /// A builder for [`UpdateContactInput`](crate::input::UpdateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) phone_numbers: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        pub(crate) sip_addresses: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
    }
    impl Builder {
        /// <p>The ARN of the contact to update.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact to update.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The updated display name of the contact.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The updated display name of the contact.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The updated first name of the contact.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The updated first name of the contact.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The updated last name of the contact.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The updated last name of the contact.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The updated phone number of the contact. The phone number type defaults to WORK. You
        /// can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
        /// which lets you specify the phone number type and multiple numbers.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The updated phone number of the contact. The phone number type defaults to WORK. You
        /// can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
        /// which lets you specify the phone number type and multiple numbers.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// Appends an item to `phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_phone_numbers`](Self::set_phone_numbers).
        ///
        /// <p>The list of phone numbers for the contact.</p>
        pub fn phone_numbers(mut self, input: impl Into<crate::model::PhoneNumber>) -> Self {
            let mut v = self.phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.phone_numbers = Some(v);
            self
        }
        /// <p>The list of phone numbers for the contact.</p>
        pub fn set_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        ) -> Self {
            self.phone_numbers = input;
            self
        }
        /// Appends an item to `sip_addresses`.
        ///
        /// To override the contents of this collection use [`set_sip_addresses`](Self::set_sip_addresses).
        ///
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn sip_addresses(mut self, input: impl Into<crate::model::SipAddress>) -> Self {
            let mut v = self.sip_addresses.unwrap_or_default();
            v.push(input.into());
            self.sip_addresses = Some(v);
            self
        }
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn set_sip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
        ) -> Self {
            self.sip_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContactInput`](crate::input::UpdateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContactInput {
                contact_arn: self.contact_arn,
                display_name: self.display_name,
                first_name: self.first_name,
                last_name: self.last_name,
                phone_number: self.phone_number,
                phone_numbers: self.phone_numbers,
                sip_addresses: self.sip_addresses,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContactInputOperationOutputAlias = crate::operation::UpdateContact;
#[doc(hidden)]
pub type UpdateContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateContactInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContact`](crate::operation::UpdateContact)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateContact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_contact(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContact",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateContactInput`](crate::input::UpdateContactInput)
    pub fn builder() -> crate::input::update_contact_input::Builder {
        crate::input::update_contact_input::Builder::default()
    }
}

/// See [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
pub mod update_device_input {
    /// A builder for [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) device_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the device to update. Required.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device to update. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The updated device name. Required.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The updated device name. Required.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeviceInput {
                device_arn: self.device_arn,
                device_name: self.device_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeviceInputOperationOutputAlias = crate::operation::UpdateDevice;
#[doc(hidden)]
pub type UpdateDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDeviceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDevice`](crate::operation::UpdateDevice)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_device(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDevice",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeviceInput`](crate::input::UpdateDeviceInput)
    pub fn builder() -> crate::input::update_device_input::Builder {
        crate::input::update_device_input::Builder::default()
    }
}

/// See [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
pub mod update_gateway_input {
    /// A builder for [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) software_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the gateway to update.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway to update.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The updated name of the gateway.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated name of the gateway.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated description of the gateway.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the gateway.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated software version of the gateway. The gateway automatically updates its
        /// software version during normal operation.</p>
        pub fn software_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.software_version = Some(input.into());
            self
        }
        /// <p>The updated software version of the gateway. The gateway automatically updates its
        /// software version during normal operation.</p>
        pub fn set_software_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.software_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGatewayInput {
                gateway_arn: self.gateway_arn,
                name: self.name,
                description: self.description,
                software_version: self.software_version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGatewayInputOperationOutputAlias = crate::operation::UpdateGateway;
#[doc(hidden)]
pub type UpdateGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGatewayInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGateway`](crate::operation::UpdateGateway)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateGateway",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_gateway(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGateway",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
    pub fn builder() -> crate::input::update_gateway_input::Builder {
        crate::input::update_gateway_input::Builder::default()
    }
}

/// See [`UpdateGatewayGroupInput`](crate::input::UpdateGatewayGroupInput)
pub mod update_gateway_group_input {
    /// A builder for [`UpdateGatewayGroupInput`](crate::input::UpdateGatewayGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_group_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the gateway group to update.</p>
        pub fn gateway_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the gateway group to update.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_group_arn = input;
            self
        }
        /// <p>The updated name of the gateway group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated name of the gateway group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated description of the gateway group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the gateway group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayGroupInput`](crate::input::UpdateGatewayGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGatewayGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGatewayGroupInput {
                gateway_group_arn: self.gateway_group_arn,
                name: self.name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGatewayGroupInputOperationOutputAlias = crate::operation::UpdateGatewayGroup;
#[doc(hidden)]
pub type UpdateGatewayGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGatewayGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGatewayGroup`](crate::operation::UpdateGatewayGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGatewayGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGatewayGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGatewayGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGatewayGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateGatewayGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_gateway_group(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGatewayGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGatewayGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGatewayGroupInput`](crate::input::UpdateGatewayGroupInput)
    pub fn builder() -> crate::input::update_gateway_group_input::Builder {
        crate::input::update_gateway_group_input::Builder::default()
    }
}

/// See [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
pub mod update_network_profile_input {
    /// A builder for [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile_arn: std::option::Option<std::string::String>,
        pub(crate) network_profile_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) current_password: std::option::Option<std::string::String>,
        pub(crate) next_password: std::option::Option<std::string::String>,
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) trust_anchors: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_arn = input;
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn network_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn set_network_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_name = input;
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn current_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_password = Some(input.into());
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn set_current_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_password = input;
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn next_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_password = Some(input.into());
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn set_next_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_password = input;
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Appends an item to `trust_anchors`.
        ///
        /// To override the contents of this collection use [`set_trust_anchors`](Self::set_trust_anchors).
        ///
        /// <p>The root certificate(s) of your authentication server that will be installed on your
        /// devices and used to trust your authentication server during EAP negotiation. </p>
        pub fn trust_anchors(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trust_anchors.unwrap_or_default();
            v.push(input.into());
            self.trust_anchors = Some(v);
            self
        }
        /// <p>The root certificate(s) of your authentication server that will be installed on your
        /// devices and used to trust your authentication server during EAP negotiation. </p>
        pub fn set_trust_anchors(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trust_anchors = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNetworkProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNetworkProfileInput {
                network_profile_arn: self.network_profile_arn,
                network_profile_name: self.network_profile_name,
                description: self.description,
                current_password: self.current_password,
                next_password: self.next_password,
                certificate_authority_arn: self.certificate_authority_arn,
                trust_anchors: self.trust_anchors,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNetworkProfileInputOperationOutputAlias = crate::operation::UpdateNetworkProfile;
#[doc(hidden)]
pub type UpdateNetworkProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateNetworkProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNetworkProfile`](crate::operation::UpdateNetworkProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNetworkProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateNetworkProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateNetworkProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateNetworkProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateNetworkProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_network_profile(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNetworkProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNetworkProfile",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
    pub fn builder() -> crate::input::update_network_profile_input::Builder {
        crate::input::update_network_profile_input::Builder::default()
    }
}

/// See [`UpdateProfileInput`](crate::input::UpdateProfileInput)
pub mod update_profile_input {
    /// A builder for [`UpdateProfileInput`](crate::input::UpdateProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_arn: std::option::Option<std::string::String>,
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) is_default: std::option::Option<bool>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) distance_unit: std::option::Option<crate::model::DistanceUnit>,
        pub(crate) temperature_unit: std::option::Option<crate::model::TemperatureUnit>,
        pub(crate) wake_word: std::option::Option<crate::model::WakeWord>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) setup_mode_disabled: std::option::Option<bool>,
        pub(crate) max_volume_limit: std::option::Option<i32>,
        pub(crate) pstn_enabled: std::option::Option<bool>,
        pub(crate) data_retention_opt_in: std::option::Option<bool>,
        pub(crate) meeting_room_configuration:
            std::option::Option<crate::model::UpdateMeetingRoomConfiguration>,
    }
    impl Builder {
        /// <p>The ARN of the room profile to update. Required.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room profile to update. Required.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// <p>The updated name for the room profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The updated name for the room profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>Sets the profile as default if selected. If this is missing, no update is done to the
        /// default status.</p>
        pub fn is_default(mut self, input: bool) -> Self {
            self.is_default = Some(input);
            self
        }
        /// <p>Sets the profile as default if selected. If this is missing, no update is done to the
        /// default status.</p>
        pub fn set_is_default(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default = input;
            self
        }
        /// <p>The updated timezone for the room profile.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The updated timezone for the room profile.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>The updated address for the room profile.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The updated address for the room profile.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The updated distance unit for the room profile.</p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.distance_unit = Some(input);
            self
        }
        /// <p>The updated distance unit for the room profile.</p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.distance_unit = input;
            self
        }
        /// <p>The updated temperature unit for the room profile.</p>
        pub fn temperature_unit(mut self, input: crate::model::TemperatureUnit) -> Self {
            self.temperature_unit = Some(input);
            self
        }
        /// <p>The updated temperature unit for the room profile.</p>
        pub fn set_temperature_unit(
            mut self,
            input: std::option::Option<crate::model::TemperatureUnit>,
        ) -> Self {
            self.temperature_unit = input;
            self
        }
        /// <p>The updated wake word for the room profile.</p>
        pub fn wake_word(mut self, input: crate::model::WakeWord) -> Self {
            self.wake_word = Some(input);
            self
        }
        /// <p>The updated wake word for the room profile.</p>
        pub fn set_wake_word(mut self, input: std::option::Option<crate::model::WakeWord>) -> Self {
            self.wake_word = input;
            self
        }
        /// <p>The updated locale for the room profile. (This is currently only available to a limited preview audience.)</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The updated locale for the room profile. (This is currently only available to a limited preview audience.)</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>Whether the setup mode of the profile is enabled.</p>
        pub fn setup_mode_disabled(mut self, input: bool) -> Self {
            self.setup_mode_disabled = Some(input);
            self
        }
        /// <p>Whether the setup mode of the profile is enabled.</p>
        pub fn set_setup_mode_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.setup_mode_disabled = input;
            self
        }
        /// <p>The updated maximum volume limit for the room profile.</p>
        pub fn max_volume_limit(mut self, input: i32) -> Self {
            self.max_volume_limit = Some(input);
            self
        }
        /// <p>The updated maximum volume limit for the room profile.</p>
        pub fn set_max_volume_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.max_volume_limit = input;
            self
        }
        /// <p>Whether the PSTN setting of the room profile is enabled.</p>
        pub fn pstn_enabled(mut self, input: bool) -> Self {
            self.pstn_enabled = Some(input);
            self
        }
        /// <p>Whether the PSTN setting of the room profile is enabled.</p>
        pub fn set_pstn_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.pstn_enabled = input;
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn data_retention_opt_in(mut self, input: bool) -> Self {
            self.data_retention_opt_in = Some(input);
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn set_data_retention_opt_in(mut self, input: std::option::Option<bool>) -> Self {
            self.data_retention_opt_in = input;
            self
        }
        /// <p>The updated meeting room settings of a room profile.</p>
        pub fn meeting_room_configuration(
            mut self,
            input: crate::model::UpdateMeetingRoomConfiguration,
        ) -> Self {
            self.meeting_room_configuration = Some(input);
            self
        }
        /// <p>The updated meeting room settings of a room profile.</p>
        pub fn set_meeting_room_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateMeetingRoomConfiguration>,
        ) -> Self {
            self.meeting_room_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProfileInput`](crate::input::UpdateProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProfileInput {
                profile_arn: self.profile_arn,
                profile_name: self.profile_name,
                is_default: self.is_default,
                timezone: self.timezone,
                address: self.address,
                distance_unit: self.distance_unit,
                temperature_unit: self.temperature_unit,
                wake_word: self.wake_word,
                locale: self.locale,
                setup_mode_disabled: self.setup_mode_disabled,
                max_volume_limit: self.max_volume_limit,
                pstn_enabled: self.pstn_enabled,
                data_retention_opt_in: self.data_retention_opt_in,
                meeting_room_configuration: self.meeting_room_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProfileInputOperationOutputAlias = crate::operation::UpdateProfile;
#[doc(hidden)]
pub type UpdateProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProfile`](crate::operation::UpdateProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_profile(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProfile",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProfileInput`](crate::input::UpdateProfileInput)
    pub fn builder() -> crate::input::update_profile_input::Builder {
        crate::input::update_profile_input::Builder::default()
    }
}

/// See [`UpdateRoomInput`](crate::input::UpdateRoomInput)
pub mod update_room_input {
    /// A builder for [`UpdateRoomInput`](crate::input::UpdateRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_arn: std::option::Option<std::string::String>,
        pub(crate) room_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) provider_calendar_id: std::option::Option<std::string::String>,
        pub(crate) profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the room to update. </p>
        pub fn room_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room to update. </p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_arn = input;
            self
        }
        /// <p>The updated name for the room.</p>
        pub fn room_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_name = Some(input.into());
            self
        }
        /// <p>The updated name for the room.</p>
        pub fn set_room_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_name = input;
            self
        }
        /// <p>The updated description for the room.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description for the room.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated provider calendar ARN for the room.</p>
        pub fn provider_calendar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_calendar_id = Some(input.into());
            self
        }
        /// <p>The updated provider calendar ARN for the room.</p>
        pub fn set_provider_calendar_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_calendar_id = input;
            self
        }
        /// <p>The updated profile ARN for the room.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The updated profile ARN for the room.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRoomInput`](crate::input::UpdateRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRoomInput {
                room_arn: self.room_arn,
                room_name: self.room_name,
                description: self.description,
                provider_calendar_id: self.provider_calendar_id,
                profile_arn: self.profile_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRoomInputOperationOutputAlias = crate::operation::UpdateRoom;
#[doc(hidden)]
pub type UpdateRoomInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRoomInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRoom`](crate::operation::UpdateRoom)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRoom,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRoomInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRoomInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRoomInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateRoom",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_room(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRoom",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRoomInput`](crate::input::UpdateRoomInput)
    pub fn builder() -> crate::input::update_room_input::Builder {
        crate::input::update_room_input::Builder::default()
    }
}

/// See [`UpdateSkillGroupInput`](crate::input::UpdateSkillGroupInput)
pub mod update_skill_group_input {
    /// A builder for [`UpdateSkillGroupInput`](crate::input::UpdateSkillGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skill_group_arn: std::option::Option<std::string::String>,
        pub(crate) skill_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the skill group to update. </p>
        pub fn skill_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the skill group to update. </p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_arn = input;
            self
        }
        /// <p>The updated name for the skill group.</p>
        pub fn skill_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.skill_group_name = Some(input.into());
            self
        }
        /// <p>The updated name for the skill group.</p>
        pub fn set_skill_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.skill_group_name = input;
            self
        }
        /// <p>The updated description for the skill group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description for the skill group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSkillGroupInput`](crate::input::UpdateSkillGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSkillGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSkillGroupInput {
                skill_group_arn: self.skill_group_arn,
                skill_group_name: self.skill_group_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSkillGroupInputOperationOutputAlias = crate::operation::UpdateSkillGroup;
#[doc(hidden)]
pub type UpdateSkillGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSkillGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSkillGroup`](crate::operation::UpdateSkillGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSkillGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSkillGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSkillGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSkillGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AlexaForBusiness.UpdateSkillGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_skill_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSkillGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSkillGroup",
            "alexaforbusiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSkillGroupInput`](crate::input::UpdateSkillGroupInput)
    pub fn builder() -> crate::input::update_skill_group_input::Builder {
        crate::input::update_skill_group_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSkillGroupInput {
    /// <p>The ARN of the skill group to update. </p>
    pub skill_group_arn: std::option::Option<std::string::String>,
    /// <p>The updated name for the skill group.</p>
    pub skill_group_name: std::option::Option<std::string::String>,
    /// <p>The updated description for the skill group.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateSkillGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSkillGroupInput");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.field("skill_group_name", &self.skill_group_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRoomInput {
    /// <p>The ARN of the room to update. </p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The updated name for the room.</p>
    pub room_name: std::option::Option<std::string::String>,
    /// <p>The updated description for the room.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated provider calendar ARN for the room.</p>
    pub provider_calendar_id: std::option::Option<std::string::String>,
    /// <p>The updated profile ARN for the room.</p>
    pub profile_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRoomInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.field("room_name", &self.room_name);
        formatter.field("description", &self.description);
        formatter.field("provider_calendar_id", &self.provider_calendar_id);
        formatter.field("profile_arn", &self.profile_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProfileInput {
    /// <p>The ARN of the room profile to update. Required.</p>
    pub profile_arn: std::option::Option<std::string::String>,
    /// <p>The updated name for the room profile.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>Sets the profile as default if selected. If this is missing, no update is done to the
    /// default status.</p>
    pub is_default: std::option::Option<bool>,
    /// <p>The updated timezone for the room profile.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>The updated address for the room profile.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The updated distance unit for the room profile.</p>
    pub distance_unit: std::option::Option<crate::model::DistanceUnit>,
    /// <p>The updated temperature unit for the room profile.</p>
    pub temperature_unit: std::option::Option<crate::model::TemperatureUnit>,
    /// <p>The updated wake word for the room profile.</p>
    pub wake_word: std::option::Option<crate::model::WakeWord>,
    /// <p>The updated locale for the room profile. (This is currently only available to a limited preview audience.)</p>
    pub locale: std::option::Option<std::string::String>,
    /// <p>Whether the setup mode of the profile is enabled.</p>
    pub setup_mode_disabled: std::option::Option<bool>,
    /// <p>The updated maximum volume limit for the room profile.</p>
    pub max_volume_limit: std::option::Option<i32>,
    /// <p>Whether the PSTN setting of the room profile is enabled.</p>
    pub pstn_enabled: std::option::Option<bool>,
    /// <p>Whether data retention of the profile is enabled.</p>
    pub data_retention_opt_in: std::option::Option<bool>,
    /// <p>The updated meeting room settings of a room profile.</p>
    pub meeting_room_configuration:
        std::option::Option<crate::model::UpdateMeetingRoomConfiguration>,
}
impl std::fmt::Debug for UpdateProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProfileInput");
        formatter.field("profile_arn", &self.profile_arn);
        formatter.field("profile_name", &self.profile_name);
        formatter.field("is_default", &self.is_default);
        formatter.field("timezone", &self.timezone);
        formatter.field("address", &self.address);
        formatter.field("distance_unit", &self.distance_unit);
        formatter.field("temperature_unit", &self.temperature_unit);
        formatter.field("wake_word", &self.wake_word);
        formatter.field("locale", &self.locale);
        formatter.field("setup_mode_disabled", &self.setup_mode_disabled);
        formatter.field("max_volume_limit", &self.max_volume_limit);
        formatter.field("pstn_enabled", &self.pstn_enabled);
        formatter.field("data_retention_opt_in", &self.data_retention_opt_in);
        formatter.field(
            "meeting_room_configuration",
            &self.meeting_room_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNetworkProfileInput {
    /// <p>The ARN of the network profile associated with a device.</p>
    pub network_profile_arn: std::option::Option<std::string::String>,
    /// <p>The name of the network profile associated with a device.</p>
    pub network_profile_name: std::option::Option<std::string::String>,
    /// <p>Detailed information about a device's network profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current password of the Wi-Fi network.</p>
    pub current_password: std::option::Option<std::string::String>,
    /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
    /// transmitted to the device and is used when the password of the network changes to
    /// NextPassword. </p>
    pub next_password: std::option::Option<std::string::String>,
    /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
    /// (ACM). This is used to issue certificates to the devices. </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The root certificate(s) of your authentication server that will be installed on your
    /// devices and used to trust your authentication server during EAP negotiation. </p>
    pub trust_anchors: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UpdateNetworkProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNetworkProfileInput");
        formatter.field("network_profile_arn", &self.network_profile_arn);
        formatter.field("network_profile_name", &self.network_profile_name);
        formatter.field("description", &self.description);
        formatter.field("current_password", &"*** Sensitive Data Redacted ***");
        formatter.field("next_password", &"*** Sensitive Data Redacted ***");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("trust_anchors", &self.trust_anchors);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayGroupInput {
    /// <p>The ARN of the gateway group to update.</p>
    pub gateway_group_arn: std::option::Option<std::string::String>,
    /// <p>The updated name of the gateway group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated description of the gateway group.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateGatewayGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayGroupInput");
        formatter.field("gateway_group_arn", &self.gateway_group_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayInput {
    /// <p>The ARN of the gateway to update.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The updated name of the gateway.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated description of the gateway.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated software version of the gateway. The gateway automatically updates its
    /// software version during normal operation.</p>
    pub software_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("software_version", &self.software_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceInput {
    /// <p>The ARN of the device to update. Required.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The updated device name. Required.</p>
    pub device_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceInput");
        formatter.field("device_arn", &self.device_arn);
        formatter.field("device_name", &self.device_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContactInput {
    /// <p>The ARN of the contact to update.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The updated display name of the contact.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The updated first name of the contact.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The updated last name of the contact.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The updated phone number of the contact. The phone number type defaults to WORK. You
    /// can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
    /// which lets you specify the phone number type and multiple numbers.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The list of phone numbers for the contact.</p>
    pub phone_numbers: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
    /// <p>The list of SIP addresses for the contact.</p>
    pub sip_addresses: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
}
impl std::fmt::Debug for UpdateContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContactInput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("first_name", &self.first_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("phone_numbers", &self.phone_numbers);
        formatter.field("sip_addresses", &self.sip_addresses);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConferenceProviderInput {
    /// <p>The ARN of the conference provider.</p>
    pub conference_provider_arn: std::option::Option<std::string::String>,
    /// <p>The type of the conference provider.</p>
    pub conference_provider_type: std::option::Option<crate::model::ConferenceProviderType>,
    /// <p>The IP endpoint and protocol for calling.</p>
    pub ip_dial_in: std::option::Option<crate::model::IpDialIn>,
    /// <p>The information for PSTN conferencing.</p>
    pub pstn_dial_in: std::option::Option<crate::model::PstnDialIn>,
    /// <p>The meeting settings for the conference provider.</p>
    pub meeting_setting: std::option::Option<crate::model::MeetingSetting>,
}
impl std::fmt::Debug for UpdateConferenceProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConferenceProviderInput");
        formatter.field("conference_provider_arn", &self.conference_provider_arn);
        formatter.field("conference_provider_type", &self.conference_provider_type);
        formatter.field("ip_dial_in", &self.ip_dial_in);
        formatter.field("pstn_dial_in", &self.pstn_dial_in);
        formatter.field("meeting_setting", &self.meeting_setting);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBusinessReportScheduleInput {
    /// <p>The ARN of the business report schedule.</p>
    pub schedule_arn: std::option::Option<std::string::String>,
    /// <p>The S3 location of the output reports.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The S3 key where the report is delivered.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The format of the generated report (individual CSV files or zipped files of
    /// individual files).</p>
    pub format: std::option::Option<crate::model::BusinessReportFormat>,
    /// <p>The name identifier of the schedule.</p>
    pub schedule_name: std::option::Option<std::string::String>,
    /// <p>The recurrence of the reports.</p>
    pub recurrence: std::option::Option<crate::model::BusinessReportRecurrence>,
}
impl std::fmt::Debug for UpdateBusinessReportScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBusinessReportScheduleInput");
        formatter.field("schedule_arn", &self.schedule_arn);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("format", &self.format);
        formatter.field("schedule_name", &self.schedule_name);
        formatter.field("recurrence", &self.recurrence);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAddressBookInput {
    /// <p>The ARN of the room to update.</p>
    pub address_book_arn: std::option::Option<std::string::String>,
    /// <p>The updated name of the room.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated description of the room.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateAddressBookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAddressBookInput");
        formatter.field("address_book_arn", &self.address_book_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource from which to remove metadata tags. Required. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The tags to be removed from the specified resource. Do not provide system tags.
    /// Required. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("arn", &self.arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource to which to add metadata tags. Required. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The tags to be added to the specified resource. Do not provide system tags. Required.
    /// </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSmartHomeApplianceDiscoveryInput {
    /// <p>The room where smart home appliance discovery was initiated.</p>
    pub room_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartSmartHomeApplianceDiscoveryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSmartHomeApplianceDiscoveryInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDeviceSyncInput {
    /// <p>The ARN of the room with which the device to sync is associated. Required.</p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the device to sync. Required.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>Request structure to start the device sync. Required.</p>
    pub features: std::option::Option<std::vec::Vec<crate::model::Feature>>,
}
impl std::fmt::Debug for StartDeviceSyncInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDeviceSyncInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.field("device_arn", &self.device_arn);
        formatter.field("features", &self.features);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendInvitationInput {
    /// <p>The ARN of the user to whom to send an invitation. Required.</p>
    pub user_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SendInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendInvitationInput");
        formatter.field("user_arn", &self.user_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendAnnouncementInput {
    /// <p>The filters to use to send an announcement to a specified list of rooms. The supported filter keys are RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.</p>
    pub room_filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The announcement content. This can contain only one of the three possible announcement types (text, SSML or audio).</p>
    pub content: std::option::Option<crate::model::Content>,
    /// <p>The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the
    /// announcement is not delivered.</p>
    pub time_to_live_in_seconds: std::option::Option<i32>,
    /// <p>The unique, user-specified identifier for the request that ensures idempotency.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SendAnnouncementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendAnnouncementInput");
        formatter.field("room_filters", &self.room_filters);
        formatter.field("content", &self.content);
        formatter.field("time_to_live_in_seconds", &self.time_to_live_in_seconds);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchUsersInput {
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by <code>MaxResults</code>.
    /// Required.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than
    /// the specified <code>MaxResults</code> value, a token is included in the response so that
    /// the remaining results can be retrieved. Required.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The filters to use for listing a specific set of users. Required. Supported filter
    /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The sort order to use in listing the filtered set of users. Required. Supported sort
    /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
    pub sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
}
impl std::fmt::Debug for SearchUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchUsersInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchSkillGroupsInput {
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by <code>MaxResults</code>.
    /// Required.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than
    /// the specified <code>MaxResults</code> value, a token is included in the response so that
    /// the remaining results can be retrieved. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The filters to use to list a specified set of skill groups. The supported filter key
    /// is SkillGroupName. </p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The sort order to use in listing the specified set of skill groups. The supported
    /// sort key is SkillGroupName. </p>
    pub sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
}
impl std::fmt::Debug for SearchSkillGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchSkillGroupsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchRoomsInput {
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than
    /// the specified <code>MaxResults</code> value, a token is included in the response so that
    /// the remaining results can be retrieved. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The filters to use to list a specified set of rooms. The supported filter keys are
    /// RoomName and ProfileName.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The sort order to use in listing the specified set of rooms. The supported sort keys
    /// are RoomName and ProfileName.</p>
    pub sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
}
impl std::fmt::Debug for SearchRoomsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchRoomsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchProfilesInput {
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than
    /// the specified <code>MaxResults</code> value, a token is included in the response so that
    /// the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The filters to use to list a specified set of room profiles. Supported filter keys
    /// are ProfileName and Address. Required. </p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The sort order to use in listing the specified set of room profiles. Supported sort
    /// keys are ProfileName and Address.</p>
    pub sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
}
impl std::fmt::Debug for SearchProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchProfilesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchNetworkProfilesInput {
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by MaxResults. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the
    /// specified MaxResults value, a token is included in the response so that the remaining
    /// results can be retrieved. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The filters to use to list a specified set of network profiles. Valid filters are
    /// NetworkProfileName, Ssid, and SecurityType.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The sort order to use to list the specified set of network profiles. Valid sort criteria
    /// includes NetworkProfileName, Ssid, and SecurityType.</p>
    pub sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
}
impl std::fmt::Debug for SearchNetworkProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchNetworkProfilesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchDevicesInput {
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than
    /// the specified <code>MaxResults</code> value, a token is included in the response so that
    /// the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The filters to use to list a specified set of devices. Supported filter keys are
    /// DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType, DeviceSerialNumber,
    /// UnassociatedOnly, ConnectionStatus (ONLINE and OFFLINE), NetworkProfileName,
    /// NetworkProfileArn, Feature, and FailureCode.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The sort order to use in listing the specified set of devices. Supported sort keys
    /// are DeviceName, DeviceStatus, RoomName, DeviceType, DeviceSerialNumber, ConnectionStatus,
    /// NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.</p>
    pub sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
}
impl std::fmt::Debug for SearchDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchDevicesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchContactsInput {
    /// <p>The filters to use to list a specified set of address books. The supported filter
    /// keys are DisplayName, FirstName, LastName, and AddressBookArns.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The sort order to use in listing the specified set of contacts. The supported sort
    /// keys are DisplayName, FirstName, and LastName.</p>
    pub sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response only includes
    /// results beyond the token, up to the value specified by MaxResults.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than
    /// the specified MaxResults value, a token is included in the response so that the remaining
    /// results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for SearchContactsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchContactsInput");
        formatter.field("filters", &self.filters);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchAddressBooksInput {
    /// <p>The filters to use to list a specified set of address books. The supported filter key
    /// is AddressBookName.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The sort order to use in listing the specified set of address books. The supported
    /// sort key is AddressBookName.</p>
    pub sort_criteria: std::option::Option<std::vec::Vec<crate::model::Sort>>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response only includes
    /// results beyond the token, up to the value specified by MaxResults.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than
    /// the specified MaxResults value, a token is included in the response so that the remaining
    /// results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for SearchAddressBooksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchAddressBooksInput");
        formatter.field("filters", &self.filters);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeInvitationInput {
    /// <p>The ARN of the user for whom to revoke an enrollment invitation. Required.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the enrollment invitation to revoke. Required.</p>
    pub enrollment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RevokeInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeInvitationInput");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("enrollment_id", &self.enrollment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolveRoomInput {
    /// <p>The ARN of the user. Required.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the skill that was requested. Required.</p>
    pub skill_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResolveRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolveRoomInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("skill_id", &self.skill_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectSkillInput {
    /// <p>The unique identifier of the skill.</p>
    pub skill_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RejectSkillInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectSkillInput");
        formatter.field("skill_id", &self.skill_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterAvsDeviceInput {
    /// <p>The client ID of the OEM used for code-based linking authorization on an AVS
    /// device.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The code that is obtained after your AVS device has made a POST request to LWA as a
    /// part of the Device Authorization Request component of the OAuth code-based linking
    /// specification.</p>
    pub user_code: std::option::Option<std::string::String>,
    /// <p>The product ID used to identify your AVS device during authorization.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The key generated by the OEM that uniquely identifies a specified instance of your
    /// AVS device.</p>
    pub device_serial_number: std::option::Option<std::string::String>,
    /// <p>The device type ID for your AVS device generated by Amazon when the OEM creates a new
    /// product on Amazon's Developer Console.</p>
    pub amazon_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the room with which to associate your AVS device.</p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for RegisterAvsDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterAvsDeviceInput");
        formatter.field("client_id", &self.client_id);
        formatter.field("user_code", &self.user_code);
        formatter.field("product_id", &self.product_id);
        formatter.field("device_serial_number", &self.device_serial_number);
        formatter.field("amazon_id", &self.amazon_id);
        formatter.field("room_arn", &self.room_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSkillAuthorizationInput {
    /// <p>The authorization result specific to OAUTH code grant output. "Code” must be
    /// populated in the AuthorizationResult map to establish the authorization.</p>
    pub authorization_result:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The unique identifier of a skill.</p>
    pub skill_id: std::option::Option<std::string::String>,
    /// <p>The room that the skill is authorized for.</p>
    pub room_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutSkillAuthorizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSkillAuthorizationInput");
        formatter.field("authorization_result", &"*** Sensitive Data Redacted ***");
        formatter.field("skill_id", &self.skill_id);
        formatter.field("room_arn", &self.room_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRoomSkillParameterInput {
    /// <p>The ARN of the room associated with the room skill parameter. Required.</p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the skill associated with the room skill parameter. Required.</p>
    pub skill_id: std::option::Option<std::string::String>,
    /// <p>The updated room skill parameter. Required.</p>
    pub room_skill_parameter: std::option::Option<crate::model::RoomSkillParameter>,
}
impl std::fmt::Debug for PutRoomSkillParameterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRoomSkillParameterInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.field("skill_id", &self.skill_id);
        formatter.field("room_skill_parameter", &self.room_skill_parameter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutInvitationConfigurationInput {
    /// <p>The name of the organization sending the enrollment invite to a user.</p>
    pub organization_name: std::option::Option<std::string::String>,
    /// <p>The email ID of the organization or individual contact that the enrolled user can use.
    /// </p>
    pub contact_email: std::option::Option<std::string::String>,
    /// <p>The list of private skill IDs that you want to recommend to the user to enable in the
    /// invitation.</p>
    pub private_skill_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PutInvitationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutInvitationConfigurationInput");
        formatter.field("organization_name", &self.organization_name);
        formatter.field("contact_email", &self.contact_email);
        formatter.field("private_skill_ids", &self.private_skill_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConferencePreferenceInput {
    /// <p>The conference preference of a specific conference provider.</p>
    pub conference_preference: std::option::Option<crate::model::ConferencePreference>,
}
impl std::fmt::Debug for PutConferencePreferenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConferencePreferenceInput");
        formatter.field("conference_preference", &self.conference_preference);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>The ARN of the specified resource for which to list tags.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by <code>MaxResults</code>. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than
    /// the specified <code>MaxResults</code> value, a token is included in the response so that
    /// the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSmartHomeAppliancesInput {
    /// <p>The room that the appliances are associated with.</p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of appliances to be returned, per paginated calls.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The tokens used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSmartHomeAppliancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSmartHomeAppliancesInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSkillsStoreSkillsByCategoryInput {
    /// <p>The category ID for which the skills are being retrieved from the skill
    /// store.</p>
    pub category_id: std::option::Option<i64>,
    /// <p>The tokens used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of skills returned per paginated calls.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListSkillsStoreSkillsByCategoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSkillsStoreSkillsByCategoryInput");
        formatter.field("category_id", &self.category_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSkillsStoreCategoriesInput {
    /// <p>The tokens used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of categories returned, per paginated calls.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListSkillsStoreCategoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSkillsStoreCategoriesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSkillsInput {
    /// <p>The ARN of the skill group for which to list enabled skills.</p>
    pub skill_group_arn: std::option::Option<std::string::String>,
    /// <p>Whether the skill is enabled under the user's account.</p>
    pub enablement_type: std::option::Option<crate::model::EnablementTypeFilter>,
    /// <p>Whether the skill is publicly available or is a private skill.</p>
    pub skill_type: std::option::Option<crate::model::SkillTypeFilter>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than
    /// the specified <code>MaxResults</code> value, a token is included in the response so that
    /// the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListSkillsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSkillsInput");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.field("enablement_type", &self.enablement_type);
        formatter.field("skill_type", &self.skill_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGatewaysInput {
    /// <p>The gateway group ARN for which to list gateways.</p>
    pub gateway_group_arn: std::option::Option<std::string::String>,
    /// <p>The token used to paginate though multiple pages of gateway summaries.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of gateway summaries to return. The default is 50.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListGatewaysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGatewaysInput");
        formatter.field("gateway_group_arn", &self.gateway_group_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGatewayGroupsInput {
    /// <p>The token used to paginate though multiple pages of gateway group summaries.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of gateway group summaries to return. The default is 50.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListGatewayGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGatewayGroupsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeviceEventsInput {
    /// <p>The ARN of a device.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The event type to filter device events. If EventType isn't specified, this returns a
    /// list of all device events in reverse chronological order. If EventType is specified, this
    /// returns a list of device events for that EventType in reverse chronological order.
    /// </p>
    pub event_type: std::option::Option<crate::model::DeviceEventType>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response only includes
    /// results beyond the token, up to the value specified by MaxResults. When the end of results
    /// is reached, the response has a value of null.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. The default value is 50. If
    /// more results exist than the specified MaxResults value, a token is included in the response
    /// so that the remaining results can be retrieved. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListDeviceEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeviceEventsInput");
        formatter.field("device_arn", &self.device_arn);
        formatter.field("event_type", &self.event_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConferenceProvidersInput {
    /// <p>The tokens used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of conference providers to be returned, per paginated
    /// calls.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListConferenceProvidersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConferenceProvidersInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBusinessReportSchedulesInput {
    /// <p>The token used to list the remaining schedules from the previous API call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of schedules listed in the call.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListBusinessReportSchedulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBusinessReportSchedulesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSkillGroupInput {
    /// <p>The ARN of the skill group for which to get details. Required.</p>
    pub skill_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSkillGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSkillGroupInput");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRoomSkillParameterInput {
    /// <p>The ARN of the room from which to get the room skill parameter details. </p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the skill from which to get the room skill parameter details.
    /// Required.</p>
    pub skill_id: std::option::Option<std::string::String>,
    /// <p>The room skill parameter key for which to get details. Required.</p>
    pub parameter_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetRoomSkillParameterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRoomSkillParameterInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.field("skill_id", &self.skill_id);
        formatter.field("parameter_key", &self.parameter_key);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRoomInput {
    /// <p>The ARN of the room for which to request details. Required.</p>
    pub room_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRoomInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProfileInput {
    /// <p>The ARN of the room profile for which to request details. Required.</p>
    pub profile_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProfileInput");
        formatter.field("profile_arn", &self.profile_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkProfileInput {
    /// <p>The ARN of the network profile associated with a device.</p>
    pub network_profile_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetNetworkProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkProfileInput");
        formatter.field("network_profile_arn", &self.network_profile_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInvitationConfigurationInput {}
impl std::fmt::Debug for GetInvitationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInvitationConfigurationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGatewayGroupInput {
    /// <p>The ARN of the gateway group to get.</p>
    pub gateway_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGatewayGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGatewayGroupInput");
        formatter.field("gateway_group_arn", &self.gateway_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGatewayInput {
    /// <p>The ARN of the gateway to get.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGatewayInput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceInput {
    /// <p>The ARN of the device for which to request details. Required.</p>
    pub device_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceInput");
        formatter.field("device_arn", &self.device_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactInput {
    /// <p>The ARN of the contact for which to request details.</p>
    pub contact_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactInput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConferenceProviderInput {
    /// <p>The ARN of the newly created conference provider.</p>
    pub conference_provider_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetConferenceProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConferenceProviderInput");
        formatter.field("conference_provider_arn", &self.conference_provider_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConferencePreferenceInput {}
impl std::fmt::Debug for GetConferencePreferenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConferencePreferenceInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAddressBookInput {
    /// <p>The ARN of the address book for which to request details.</p>
    pub address_book_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetAddressBookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAddressBookInput");
        formatter.field("address_book_arn", &self.address_book_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForgetSmartHomeAppliancesInput {
    /// <p>The room that the appliances are associated with.</p>
    pub room_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForgetSmartHomeAppliancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForgetSmartHomeAppliancesInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateSkillGroupFromRoomInput {
    /// <p>The ARN of the skill group to disassociate from a room. Required.</p>
    pub skill_group_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the room from which the skill group is to be disassociated.
    /// Required.</p>
    pub room_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateSkillGroupFromRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateSkillGroupFromRoomInput");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.field("room_arn", &self.room_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateSkillFromUsersInput {
    /// <p> The private skill ID you want to make unavailable for enrolled users.</p>
    pub skill_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateSkillFromUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateSkillFromUsersInput");
        formatter.field("skill_id", &self.skill_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateSkillFromSkillGroupInput {
    /// <p>The unique identifier of a skill. Required.</p>
    pub skill_group_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of a skill group to associate to a skill.</p>
    pub skill_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateSkillFromSkillGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateSkillFromSkillGroupInput");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.field("skill_id", &self.skill_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateDeviceFromRoomInput {
    /// <p>The ARN of the device to disassociate from a room. Required.</p>
    pub device_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateDeviceFromRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateDeviceFromRoomInput");
        formatter.field("device_arn", &self.device_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateContactFromAddressBookInput {
    /// <p>The ARN of the contact to disassociate from an address book.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the address from which to disassociate the contact.</p>
    pub address_book_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateContactFromAddressBookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateContactFromAddressBookInput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("address_book_arn", &self.address_book_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserInput {
    /// <p>The ARN of the user to delete in the organization. Required.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the user's enrollment in the organization. Required.</p>
    pub enrollment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserInput");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("enrollment_id", &self.enrollment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSkillGroupInput {
    /// <p>The ARN of the skill group to delete. Required.</p>
    pub skill_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSkillGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSkillGroupInput");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSkillAuthorizationInput {
    /// <p>The unique identifier of a skill.</p>
    pub skill_id: std::option::Option<std::string::String>,
    /// <p>The room that the skill is authorized for.</p>
    pub room_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSkillAuthorizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSkillAuthorizationInput");
        formatter.field("skill_id", &self.skill_id);
        formatter.field("room_arn", &self.room_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRoomSkillParameterInput {
    /// <p>The ARN of the room from which to remove the room skill parameter details.</p>
    pub room_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the skill from which to remove the room skill parameter details.</p>
    pub skill_id: std::option::Option<std::string::String>,
    /// <p>The room skill parameter key for which to remove details.</p>
    pub parameter_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteRoomSkillParameterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRoomSkillParameterInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.field("skill_id", &self.skill_id);
        formatter.field("parameter_key", &self.parameter_key);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRoomInput {
    /// <p>The ARN of the room to delete. Required.</p>
    pub room_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRoomInput");
        formatter.field("room_arn", &self.room_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfileInput {
    /// <p>The ARN of the room profile to delete. Required.</p>
    pub profile_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfileInput");
        formatter.field("profile_arn", &self.profile_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNetworkProfileInput {
    /// <p>The ARN of the network profile associated with a device.</p>
    pub network_profile_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteNetworkProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNetworkProfileInput");
        formatter.field("network_profile_arn", &self.network_profile_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGatewayGroupInput {
    /// <p>The ARN of the gateway group to delete.</p>
    pub gateway_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteGatewayGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGatewayGroupInput");
        formatter.field("gateway_group_arn", &self.gateway_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeviceUsageDataInput {
    /// <p>The ARN of the device.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The type of usage data to delete.</p>
    pub device_usage_type: std::option::Option<crate::model::DeviceUsageType>,
}
impl std::fmt::Debug for DeleteDeviceUsageDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeviceUsageDataInput");
        formatter.field("device_arn", &self.device_arn);
        formatter.field("device_usage_type", &self.device_usage_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeviceInput {
    /// <p>The ARN of the device for which to request details.</p>
    pub device_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeviceInput");
        formatter.field("device_arn", &self.device_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContactInput {
    /// <p>The ARN of the contact to delete.</p>
    pub contact_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContactInput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConferenceProviderInput {
    /// <p>The ARN of the conference provider.</p>
    pub conference_provider_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteConferenceProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConferenceProviderInput");
        formatter.field("conference_provider_arn", &self.conference_provider_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBusinessReportScheduleInput {
    /// <p>The ARN of the business report schedule.</p>
    pub schedule_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBusinessReportScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBusinessReportScheduleInput");
        formatter.field("schedule_arn", &self.schedule_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAddressBookInput {
    /// <p>The ARN of the address book to delete.</p>
    pub address_book_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteAddressBookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAddressBookInput");
        formatter.field("address_book_arn", &self.address_book_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The ARN for the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The first name for the user.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name for the user.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The email address for the user.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>A unique, user-specified identifier for this request that ensures idempotency.
    /// </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags for the user.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("first_name", &self.first_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("email", &self.email);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSkillGroupInput {
    /// <p>The name for the skill group.</p>
    pub skill_group_name: std::option::Option<std::string::String>,
    /// <p>The description for the skill group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A unique, user-specified identifier for this request that ensures idempotency.
    /// </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags for the skill group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateSkillGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSkillGroupInput");
        formatter.field("skill_group_name", &self.skill_group_name);
        formatter.field("description", &self.description);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRoomInput {
    /// <p>The name for the room.</p>
    pub room_name: std::option::Option<std::string::String>,
    /// <p>The description for the room.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The profile ARN for the room. This is required.</p>
    pub profile_arn: std::option::Option<std::string::String>,
    /// <p>The calendar ARN for the room.</p>
    pub provider_calendar_id: std::option::Option<std::string::String>,
    /// <p>A unique, user-specified identifier for this request that ensures idempotency.
    /// </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags for the room.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRoomInput");
        formatter.field("room_name", &self.room_name);
        formatter.field("description", &self.description);
        formatter.field("profile_arn", &self.profile_arn);
        formatter.field("provider_calendar_id", &self.provider_calendar_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProfileInput {
    /// <p>The name of a room profile.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The time zone used by a room profile.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>The valid address for the room.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The distance unit to be used by devices in the profile.</p>
    pub distance_unit: std::option::Option<crate::model::DistanceUnit>,
    /// <p>The temperature unit to be used by devices in the profile.</p>
    pub temperature_unit: std::option::Option<crate::model::TemperatureUnit>,
    /// <p>A wake word for Alexa, Echo, Amazon, or a computer.</p>
    pub wake_word: std::option::Option<crate::model::WakeWord>,
    /// <p>The locale of the room profile. (This is currently only available to a limited preview audience.)</p>
    pub locale: std::option::Option<std::string::String>,
    /// <p>The user-specified token that is used during the creation of a profile.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Whether room profile setup is enabled.</p>
    pub setup_mode_disabled: std::option::Option<bool>,
    /// <p>The maximum volume limit for a room profile.</p>
    pub max_volume_limit: std::option::Option<i32>,
    /// <p>Whether PSTN calling is enabled.</p>
    pub pstn_enabled: std::option::Option<bool>,
    /// <p>Whether data retention of the profile is enabled.</p>
    pub data_retention_opt_in: std::option::Option<bool>,
    /// <p>The meeting room settings of a room profile.</p>
    pub meeting_room_configuration:
        std::option::Option<crate::model::CreateMeetingRoomConfiguration>,
    /// <p>The tags for the profile.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProfileInput");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("timezone", &self.timezone);
        formatter.field("address", &self.address);
        formatter.field("distance_unit", &self.distance_unit);
        formatter.field("temperature_unit", &self.temperature_unit);
        formatter.field("wake_word", &self.wake_word);
        formatter.field("locale", &self.locale);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("setup_mode_disabled", &self.setup_mode_disabled);
        formatter.field("max_volume_limit", &self.max_volume_limit);
        formatter.field("pstn_enabled", &self.pstn_enabled);
        formatter.field("data_retention_opt_in", &self.data_retention_opt_in);
        formatter.field(
            "meeting_room_configuration",
            &self.meeting_room_configuration,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNetworkProfileInput {
    /// <p>The name of the network profile associated with a device.</p>
    pub network_profile_name: std::option::Option<std::string::String>,
    /// <p>Detailed information about a device's network profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The SSID of the Wi-Fi network.</p>
    pub ssid: std::option::Option<std::string::String>,
    /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
    /// WEP, or OPEN.</p>
    pub security_type: std::option::Option<crate::model::NetworkSecurityType>,
    /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
    /// supported.</p>
    pub eap_method: std::option::Option<crate::model::NetworkEapMethod>,
    /// <p>The current password of the Wi-Fi network.</p>
    pub current_password: std::option::Option<std::string::String>,
    /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
    /// transmitted to the device and is used when the password of the network changes to
    /// NextPassword. </p>
    pub next_password: std::option::Option<std::string::String>,
    /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
    /// (ACM). This is used to issue certificates to the devices. </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The root certificates of your authentication server that is installed on your devices
    /// and used to trust your authentication server during EAP negotiation. </p>
    pub trust_anchors: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique, user-specified identifier for the request that ensures idempotency.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags to be added to the specified resource. Do not provide system tags. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateNetworkProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNetworkProfileInput");
        formatter.field("network_profile_name", &self.network_profile_name);
        formatter.field("description", &self.description);
        formatter.field("ssid", &self.ssid);
        formatter.field("security_type", &self.security_type);
        formatter.field("eap_method", &self.eap_method);
        formatter.field("current_password", &"*** Sensitive Data Redacted ***");
        formatter.field("next_password", &"*** Sensitive Data Redacted ***");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("trust_anchors", &self.trust_anchors);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGatewayGroupInput {
    /// <p>The name of the gateway group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the gateway group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A unique, user-specified identifier for the request that ensures idempotency.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateGatewayGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGatewayGroupInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContactInput {
    /// <p>The name of the contact to display on the console.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The first name of the contact that is used to call the contact on the
    /// device.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name of the contact that is used to call the contact on the
    /// device.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The phone number of the contact in E.164 format. The phone number type defaults to
    /// WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
    /// which lets you specify the phone number type and multiple numbers.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The list of phone numbers for the contact.</p>
    pub phone_numbers: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
    /// <p>The list of SIP addresses for the contact.</p>
    pub sip_addresses: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
    /// <p>A unique, user-specified identifier for this request that ensures
    /// idempotency.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContactInput");
        formatter.field("display_name", &self.display_name);
        formatter.field("first_name", &self.first_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("phone_numbers", &self.phone_numbers);
        formatter.field("sip_addresses", &self.sip_addresses);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConferenceProviderInput {
    /// <p>The name of the conference provider.</p>
    pub conference_provider_name: std::option::Option<std::string::String>,
    /// <p>Represents a type within a list of predefined types.</p>
    pub conference_provider_type: std::option::Option<crate::model::ConferenceProviderType>,
    /// <p>The IP endpoint and protocol for calling.</p>
    pub ip_dial_in: std::option::Option<crate::model::IpDialIn>,
    /// <p>The information for PSTN conferencing.</p>
    pub pstn_dial_in: std::option::Option<crate::model::PstnDialIn>,
    /// <p>The meeting settings for the conference provider.</p>
    pub meeting_setting: std::option::Option<crate::model::MeetingSetting>,
    /// <p>The request token of the client.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateConferenceProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConferenceProviderInput");
        formatter.field("conference_provider_name", &self.conference_provider_name);
        formatter.field("conference_provider_type", &self.conference_provider_type);
        formatter.field("ip_dial_in", &self.ip_dial_in);
        formatter.field("pstn_dial_in", &self.pstn_dial_in);
        formatter.field("meeting_setting", &self.meeting_setting);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBusinessReportScheduleInput {
    /// <p>The name identifier of the schedule.</p>
    pub schedule_name: std::option::Option<std::string::String>,
    /// <p>The S3 bucket name of the output reports. If this isn't specified, the report can be
    /// retrieved from a download link by calling ListBusinessReportSchedule. </p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The S3 key where the report is delivered.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The format of the generated report (individual CSV files or zipped files of
    /// individual files).</p>
    pub format: std::option::Option<crate::model::BusinessReportFormat>,
    /// <p>The content range of the reports.</p>
    pub content_range: std::option::Option<crate::model::BusinessReportContentRange>,
    /// <p>The recurrence of the reports. If this isn't specified, the report will only be
    /// delivered one time when the API is called. </p>
    pub recurrence: std::option::Option<crate::model::BusinessReportRecurrence>,
    /// <p>The client request token.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags for the business report schedule.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateBusinessReportScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBusinessReportScheduleInput");
        formatter.field("schedule_name", &self.schedule_name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("format", &self.format);
        formatter.field("content_range", &self.content_range);
        formatter.field("recurrence", &self.recurrence);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAddressBookInput {
    /// <p>The name of the address book.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the address book.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A unique, user-specified identifier for the request that ensures
    /// idempotency.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateAddressBookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAddressBookInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateSkillWithUsersInput {
    /// <p>The private skill ID you want to make available to enrolled users.</p>
    pub skill_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateSkillWithUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateSkillWithUsersInput");
        formatter.field("skill_id", &self.skill_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateSkillWithSkillGroupInput {
    /// <p>The ARN of the skill group to associate the skill to. Required.</p>
    pub skill_group_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the skill.</p>
    pub skill_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateSkillWithSkillGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateSkillWithSkillGroupInput");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.field("skill_id", &self.skill_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateSkillGroupWithRoomInput {
    /// <p>The ARN of the skill group to associate with a room. Required.</p>
    pub skill_group_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the room with which to associate the skill group. Required.</p>
    pub room_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateSkillGroupWithRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateSkillGroupWithRoomInput");
        formatter.field("skill_group_arn", &self.skill_group_arn);
        formatter.field("room_arn", &self.room_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateDeviceWithRoomInput {
    /// <p>The ARN of the device to associate to a room. Required.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the room with which to associate the device. Required.</p>
    pub room_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateDeviceWithRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateDeviceWithRoomInput");
        formatter.field("device_arn", &self.device_arn);
        formatter.field("room_arn", &self.room_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateDeviceWithNetworkProfileInput {
    /// <p>The device ARN.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the network profile to associate with a device.</p>
    pub network_profile_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateDeviceWithNetworkProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateDeviceWithNetworkProfileInput");
        formatter.field("device_arn", &self.device_arn);
        formatter.field("network_profile_arn", &self.network_profile_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateContactWithAddressBookInput {
    /// <p>The ARN of the contact to associate with an address book.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the address book with which to associate the contact.</p>
    pub address_book_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateContactWithAddressBookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateContactWithAddressBookInput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("address_book_arn", &self.address_book_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApproveSkillInput {
    /// <p>The unique identifier of the skill.</p>
    pub skill_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ApproveSkillInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApproveSkillInput");
        formatter.field("skill_id", &self.skill_id);
        formatter.finish()
    }
}
